/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * A data connection to allow DLP to profile data in locations that require
 * additional configuration.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.Connection}
 */
public final class Connection extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.Connection)
    ConnectionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Connection.newBuilder() to construct.
  private Connection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Connection() {
    name_ = "";
    state_ = 0;
    errors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Connection();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_Connection_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_Connection_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.Connection.class,
            com.google.privacy.dlp.v2.Connection.Builder.class);
  }

  private int propertiesCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object properties_;

  public enum PropertiesCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CLOUD_SQL(4),
    PROPERTIES_NOT_SET(0);
    private final int value;

    private PropertiesCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PropertiesCase valueOf(int value) {
      return forNumber(value);
    }

    public static PropertiesCase forNumber(int value) {
      switch (value) {
        case 4:
          return CLOUD_SQL;
        case 0:
          return PROPERTIES_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PropertiesCase getPropertiesCase() {
    return PropertiesCase.forNumber(propertiesCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the connection:
   * `projects/{project}/locations/{location}/connections/{name}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the connection:
   * `projects/{project}/locations/{location}/connections/{name}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The connection's state in its lifecycle.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.ConnectionState state = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Required. The connection's state in its lifecycle.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.ConnectionState state = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ConnectionState getState() {
    com.google.privacy.dlp.v2.ConnectionState result =
        com.google.privacy.dlp.v2.ConnectionState.forNumber(state_);
    return result == null ? com.google.privacy.dlp.v2.ConnectionState.UNRECOGNIZED : result;
  }

  public static final int ERRORS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.Error> errors_;
  /**
   *
   *
   * <pre>
   * Output only. Set if status == ERROR, to provide additional details. Will
   * store the last 10 errors sorted with the most recent first.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.Error> getErrorsList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Set if status == ERROR, to provide additional details. Will
   * store the last 10 errors sorted with the most recent first.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.ErrorOrBuilder>
      getErrorsOrBuilderList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Set if status == ERROR, to provide additional details. Will
   * store the last 10 errors sorted with the most recent first.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getErrorsCount() {
    return errors_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Set if status == ERROR, to provide additional details. Will
   * store the last 10 errors sorted with the most recent first.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Error getErrors(int index) {
    return errors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Set if status == ERROR, to provide additional details. Will
   * store the last 10 errors sorted with the most recent first.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ErrorOrBuilder getErrorsOrBuilder(int index) {
    return errors_.get(index);
  }

  public static final int CLOUD_SQL_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Connect to a Cloud SQL instance.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudSqlProperties cloud_sql = 4;</code>
   *
   * @return Whether the cloudSql field is set.
   */
  @java.lang.Override
  public boolean hasCloudSql() {
    return propertiesCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Connect to a Cloud SQL instance.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudSqlProperties cloud_sql = 4;</code>
   *
   * @return The cloudSql.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudSqlProperties getCloudSql() {
    if (propertiesCase_ == 4) {
      return (com.google.privacy.dlp.v2.CloudSqlProperties) properties_;
    }
    return com.google.privacy.dlp.v2.CloudSqlProperties.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Connect to a Cloud SQL instance.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudSqlProperties cloud_sql = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudSqlPropertiesOrBuilder getCloudSqlOrBuilder() {
    if (propertiesCase_ == 4) {
      return (com.google.privacy.dlp.v2.CloudSqlProperties) properties_;
    }
    return com.google.privacy.dlp.v2.CloudSqlProperties.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (state_
        != com.google.privacy.dlp.v2.ConnectionState.CONNECTION_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, state_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      output.writeMessage(3, errors_.get(i));
    }
    if (propertiesCase_ == 4) {
      output.writeMessage(4, (com.google.privacy.dlp.v2.CloudSqlProperties) properties_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (state_
        != com.google.privacy.dlp.v2.ConnectionState.CONNECTION_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, errors_.get(i));
    }
    if (propertiesCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.privacy.dlp.v2.CloudSqlProperties) properties_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.Connection)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.Connection other = (com.google.privacy.dlp.v2.Connection) obj;

    if (!getName().equals(other.getName())) return false;
    if (state_ != other.state_) return false;
    if (!getErrorsList().equals(other.getErrorsList())) return false;
    if (!getPropertiesCase().equals(other.getPropertiesCase())) return false;
    switch (propertiesCase_) {
      case 4:
        if (!getCloudSql().equals(other.getCloudSql())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (getErrorsCount() > 0) {
      hash = (37 * hash) + ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorsList().hashCode();
    }
    switch (propertiesCase_) {
      case 4:
        hash = (37 * hash) + CLOUD_SQL_FIELD_NUMBER;
        hash = (53 * hash) + getCloudSql().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.Connection parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Connection parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Connection parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Connection parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Connection parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Connection parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Connection parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Connection parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Connection parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Connection parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Connection parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Connection parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.Connection prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A data connection to allow DLP to profile data in locations that require
   * additional configuration.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.Connection}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.Connection)
      com.google.privacy.dlp.v2.ConnectionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Connection_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Connection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.Connection.class,
              com.google.privacy.dlp.v2.Connection.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.Connection.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      state_ = 0;
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
      } else {
        errors_ = null;
        errorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (cloudSqlBuilder_ != null) {
        cloudSqlBuilder_.clear();
      }
      propertiesCase_ = 0;
      properties_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Connection_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Connection getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.Connection.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Connection build() {
      com.google.privacy.dlp.v2.Connection result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Connection buildPartial() {
      com.google.privacy.dlp.v2.Connection result = new com.google.privacy.dlp.v2.Connection(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.privacy.dlp.v2.Connection result) {
      if (errorsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          errors_ = java.util.Collections.unmodifiableList(errors_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.errors_ = errors_;
      } else {
        result.errors_ = errorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.privacy.dlp.v2.Connection result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.state_ = state_;
      }
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.Connection result) {
      result.propertiesCase_ = propertiesCase_;
      result.properties_ = this.properties_;
      if (propertiesCase_ == 4 && cloudSqlBuilder_ != null) {
        result.properties_ = cloudSqlBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.Connection) {
        return mergeFrom((com.google.privacy.dlp.v2.Connection) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.Connection other) {
      if (other == com.google.privacy.dlp.v2.Connection.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (errorsBuilder_ == null) {
        if (!other.errors_.isEmpty()) {
          if (errors_.isEmpty()) {
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureErrorsIsMutable();
            errors_.addAll(other.errors_);
          }
          onChanged();
        }
      } else {
        if (!other.errors_.isEmpty()) {
          if (errorsBuilder_.isEmpty()) {
            errorsBuilder_.dispose();
            errorsBuilder_ = null;
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000004);
            errorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorsFieldBuilder()
                    : null;
          } else {
            errorsBuilder_.addAllMessages(other.errors_);
          }
        }
      }
      switch (other.getPropertiesCase()) {
        case CLOUD_SQL:
          {
            mergeCloudSql(other.getCloudSql());
            break;
          }
        case PROPERTIES_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.privacy.dlp.v2.Error m =
                    input.readMessage(com.google.privacy.dlp.v2.Error.parser(), extensionRegistry);
                if (errorsBuilder_ == null) {
                  ensureErrorsIsMutable();
                  errors_.add(m);
                } else {
                  errorsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCloudSqlFieldBuilder().getBuilder(), extensionRegistry);
                propertiesCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int propertiesCase_ = 0;
    private java.lang.Object properties_;

    public PropertiesCase getPropertiesCase() {
      return PropertiesCase.forNumber(propertiesCase_);
    }

    public Builder clearProperties() {
      propertiesCase_ = 0;
      properties_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the connection:
     * `projects/{project}/locations/{location}/connections/{name}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the connection:
     * `projects/{project}/locations/{location}/connections/{name}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the connection:
     * `projects/{project}/locations/{location}/connections/{name}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the connection:
     * `projects/{project}/locations/{location}/connections/{name}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the connection:
     * `projects/{project}/locations/{location}/connections/{name}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The connection's state in its lifecycle.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.ConnectionState state = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Required. The connection's state in its lifecycle.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.ConnectionState state = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The connection's state in its lifecycle.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.ConnectionState state = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ConnectionState getState() {
      com.google.privacy.dlp.v2.ConnectionState result =
          com.google.privacy.dlp.v2.ConnectionState.forNumber(state_);
      return result == null ? com.google.privacy.dlp.v2.ConnectionState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The connection's state in its lifecycle.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.ConnectionState state = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.privacy.dlp.v2.ConnectionState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The connection's state in its lifecycle.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.ConnectionState state = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.privacy.dlp.v2.Error> errors_ =
        java.util.Collections.emptyList();

    private void ensureErrorsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        errors_ = new java.util.ArrayList<com.google.privacy.dlp.v2.Error>(errors_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.Error,
            com.google.privacy.dlp.v2.Error.Builder,
            com.google.privacy.dlp.v2.ErrorOrBuilder>
        errorsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.privacy.dlp.v2.Error> getErrorsList() {
      if (errorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errors_);
      } else {
        return errorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getErrorsCount() {
      if (errorsBuilder_ == null) {
        return errors_.size();
      } else {
        return errorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.privacy.dlp.v2.Error getErrors(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setErrors(int index, com.google.privacy.dlp.v2.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.set(index, value);
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setErrors(int index, com.google.privacy.dlp.v2.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(com.google.privacy.dlp.v2.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(int index, com.google.privacy.dlp.v2.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(index, value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(com.google.privacy.dlp.v2.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(int index, com.google.privacy.dlp.v2.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllErrors(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.Error> values) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errors_);
        onChanged();
      } else {
        errorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearErrors() {
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        errorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeErrors(int index) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.remove(index);
        onChanged();
      } else {
        errorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.privacy.dlp.v2.Error.Builder getErrorsBuilder(int index) {
      return getErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.privacy.dlp.v2.ErrorOrBuilder getErrorsOrBuilder(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.ErrorOrBuilder>
        getErrorsOrBuilderList() {
      if (errorsBuilder_ != null) {
        return errorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.privacy.dlp.v2.Error.Builder addErrorsBuilder() {
      return getErrorsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.privacy.dlp.v2.Error.Builder addErrorsBuilder(int index) {
      return getErrorsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Set if status == ERROR, to provide additional details. Will
     * store the last 10 errors sorted with the most recent first.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.privacy.dlp.v2.Error.Builder> getErrorsBuilderList() {
      return getErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.Error,
            com.google.privacy.dlp.v2.Error.Builder,
            com.google.privacy.dlp.v2.ErrorOrBuilder>
        getErrorsFieldBuilder() {
      if (errorsBuilder_ == null) {
        errorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.Error,
                com.google.privacy.dlp.v2.Error.Builder,
                com.google.privacy.dlp.v2.ErrorOrBuilder>(
                errors_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        errors_ = null;
      }
      return errorsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CloudSqlProperties,
            com.google.privacy.dlp.v2.CloudSqlProperties.Builder,
            com.google.privacy.dlp.v2.CloudSqlPropertiesOrBuilder>
        cloudSqlBuilder_;
    /**
     *
     *
     * <pre>
     * Connect to a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlProperties cloud_sql = 4;</code>
     *
     * @return Whether the cloudSql field is set.
     */
    @java.lang.Override
    public boolean hasCloudSql() {
      return propertiesCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Connect to a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlProperties cloud_sql = 4;</code>
     *
     * @return The cloudSql.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudSqlProperties getCloudSql() {
      if (cloudSqlBuilder_ == null) {
        if (propertiesCase_ == 4) {
          return (com.google.privacy.dlp.v2.CloudSqlProperties) properties_;
        }
        return com.google.privacy.dlp.v2.CloudSqlProperties.getDefaultInstance();
      } else {
        if (propertiesCase_ == 4) {
          return cloudSqlBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.CloudSqlProperties.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Connect to a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlProperties cloud_sql = 4;</code>
     */
    public Builder setCloudSql(com.google.privacy.dlp.v2.CloudSqlProperties value) {
      if (cloudSqlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        properties_ = value;
        onChanged();
      } else {
        cloudSqlBuilder_.setMessage(value);
      }
      propertiesCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Connect to a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlProperties cloud_sql = 4;</code>
     */
    public Builder setCloudSql(
        com.google.privacy.dlp.v2.CloudSqlProperties.Builder builderForValue) {
      if (cloudSqlBuilder_ == null) {
        properties_ = builderForValue.build();
        onChanged();
      } else {
        cloudSqlBuilder_.setMessage(builderForValue.build());
      }
      propertiesCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Connect to a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlProperties cloud_sql = 4;</code>
     */
    public Builder mergeCloudSql(com.google.privacy.dlp.v2.CloudSqlProperties value) {
      if (cloudSqlBuilder_ == null) {
        if (propertiesCase_ == 4
            && properties_ != com.google.privacy.dlp.v2.CloudSqlProperties.getDefaultInstance()) {
          properties_ =
              com.google.privacy.dlp.v2.CloudSqlProperties.newBuilder(
                      (com.google.privacy.dlp.v2.CloudSqlProperties) properties_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          properties_ = value;
        }
        onChanged();
      } else {
        if (propertiesCase_ == 4) {
          cloudSqlBuilder_.mergeFrom(value);
        } else {
          cloudSqlBuilder_.setMessage(value);
        }
      }
      propertiesCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Connect to a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlProperties cloud_sql = 4;</code>
     */
    public Builder clearCloudSql() {
      if (cloudSqlBuilder_ == null) {
        if (propertiesCase_ == 4) {
          propertiesCase_ = 0;
          properties_ = null;
          onChanged();
        }
      } else {
        if (propertiesCase_ == 4) {
          propertiesCase_ = 0;
          properties_ = null;
        }
        cloudSqlBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Connect to a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlProperties cloud_sql = 4;</code>
     */
    public com.google.privacy.dlp.v2.CloudSqlProperties.Builder getCloudSqlBuilder() {
      return getCloudSqlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Connect to a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlProperties cloud_sql = 4;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudSqlPropertiesOrBuilder getCloudSqlOrBuilder() {
      if ((propertiesCase_ == 4) && (cloudSqlBuilder_ != null)) {
        return cloudSqlBuilder_.getMessageOrBuilder();
      } else {
        if (propertiesCase_ == 4) {
          return (com.google.privacy.dlp.v2.CloudSqlProperties) properties_;
        }
        return com.google.privacy.dlp.v2.CloudSqlProperties.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Connect to a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlProperties cloud_sql = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CloudSqlProperties,
            com.google.privacy.dlp.v2.CloudSqlProperties.Builder,
            com.google.privacy.dlp.v2.CloudSqlPropertiesOrBuilder>
        getCloudSqlFieldBuilder() {
      if (cloudSqlBuilder_ == null) {
        if (!(propertiesCase_ == 4)) {
          properties_ = com.google.privacy.dlp.v2.CloudSqlProperties.getDefaultInstance();
        }
        cloudSqlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CloudSqlProperties,
                com.google.privacy.dlp.v2.CloudSqlProperties.Builder,
                com.google.privacy.dlp.v2.CloudSqlPropertiesOrBuilder>(
                (com.google.privacy.dlp.v2.CloudSqlProperties) properties_,
                getParentForChildren(),
                isClean());
        properties_ = null;
      }
      propertiesCase_ = 4;
      onChanged();
      return cloudSqlBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.Connection)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.Connection)
  private static final com.google.privacy.dlp.v2.Connection DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.Connection();
  }

  public static com.google.privacy.dlp.v2.Connection getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Connection> PARSER =
      new com.google.protobuf.AbstractParser<Connection>() {
        @java.lang.Override
        public Connection parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Connection> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Connection> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.Connection getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
