/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Represents a container that may contain DLP findings.
 * Examples of a container include a file, table, or database record.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.Container}
 */
public final class Container extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.Container)
    ContainerOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Container.newBuilder() to construct.
  private Container(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Container() {
    type_ = "";
    projectId_ = "";
    fullPath_ = "";
    rootPath_ = "";
    relativePath_ = "";
    version_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Container();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_Container_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_Container_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.Container.class,
            com.google.privacy.dlp.v2.Container.Builder.class);
  }

  private int bitField0_;
  public static final int TYPE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * Container type, for example BigQuery or Cloud Storage.
   * </pre>
   *
   * <code>string type = 1;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Container type, for example BigQuery or Cloud Storage.
   * </pre>
   *
   * <code>string type = 1;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Project where the finding was found.
   * Can be different from the project that owns the finding.
   * </pre>
   *
   * <code>string project_id = 2;</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Project where the finding was found.
   * Can be different from the project that owns the finding.
   * </pre>
   *
   * <code>string project_id = 2;</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FULL_PATH_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fullPath_ = "";
  /**
   *
   *
   * <pre>
   * A string representation of the full container name.
   * Examples:
   * - BigQuery: 'Project:DataSetId.TableId'
   * - Cloud Storage: 'gs://Bucket/folders/filename.txt'
   * </pre>
   *
   * <code>string full_path = 3;</code>
   *
   * @return The fullPath.
   */
  @java.lang.Override
  public java.lang.String getFullPath() {
    java.lang.Object ref = fullPath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fullPath_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A string representation of the full container name.
   * Examples:
   * - BigQuery: 'Project:DataSetId.TableId'
   * - Cloud Storage: 'gs://Bucket/folders/filename.txt'
   * </pre>
   *
   * <code>string full_path = 3;</code>
   *
   * @return The bytes for fullPath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFullPathBytes() {
    java.lang.Object ref = fullPath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fullPath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROOT_PATH_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rootPath_ = "";
  /**
   *
   *
   * <pre>
   * The root of the container.
   * Examples:
   *
   * - For BigQuery table `project_id:dataset_id.table_id`, the root is
   *  `dataset_id`
   * - For Cloud Storage file `gs://bucket/folder/filename.txt`, the root
   *  is `gs://bucket`
   * </pre>
   *
   * <code>string root_path = 4;</code>
   *
   * @return The rootPath.
   */
  @java.lang.Override
  public java.lang.String getRootPath() {
    java.lang.Object ref = rootPath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rootPath_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The root of the container.
   * Examples:
   *
   * - For BigQuery table `project_id:dataset_id.table_id`, the root is
   *  `dataset_id`
   * - For Cloud Storage file `gs://bucket/folder/filename.txt`, the root
   *  is `gs://bucket`
   * </pre>
   *
   * <code>string root_path = 4;</code>
   *
   * @return The bytes for rootPath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRootPathBytes() {
    java.lang.Object ref = rootPath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rootPath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RELATIVE_PATH_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object relativePath_ = "";
  /**
   *
   *
   * <pre>
   * The rest of the path after the root.
   * Examples:
   *
   * - For BigQuery table `project_id:dataset_id.table_id`, the relative path is
   *  `table_id`
   * - For Cloud Storage file `gs://bucket/folder/filename.txt`, the relative
   *  path is `folder/filename.txt`
   * </pre>
   *
   * <code>string relative_path = 5;</code>
   *
   * @return The relativePath.
   */
  @java.lang.Override
  public java.lang.String getRelativePath() {
    java.lang.Object ref = relativePath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      relativePath_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The rest of the path after the root.
   * Examples:
   *
   * - For BigQuery table `project_id:dataset_id.table_id`, the relative path is
   *  `table_id`
   * - For Cloud Storage file `gs://bucket/folder/filename.txt`, the relative
   *  path is `folder/filename.txt`
   * </pre>
   *
   * <code>string relative_path = 5;</code>
   *
   * @return The bytes for relativePath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRelativePathBytes() {
    java.lang.Object ref = relativePath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      relativePath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Findings container modification timestamp, if applicable. For Cloud
   * Storage, this field contains the last file modification timestamp. For a
   * BigQuery table, this field contains the last_modified_time property. For
   * Datastore, this field isn't populated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Findings container modification timestamp, if applicable. For Cloud
   * Storage, this field contains the last file modification timestamp. For a
   * BigQuery table, this field contains the last_modified_time property. For
   * Datastore, this field isn't populated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Findings container modification timestamp, if applicable. For Cloud
   * Storage, this field contains the last file modification timestamp. For a
   * BigQuery table, this field contains the last_modified_time property. For
   * Datastore, this field isn't populated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int VERSION_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object version_ = "";
  /**
   *
   *
   * <pre>
   * Findings container version, if available
   * ("generation" for Cloud Storage).
   * </pre>
   *
   * <code>string version = 7;</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Findings container version, if available
   * ("generation" for Cloud Storage).
   * </pre>
   *
   * <code>string version = 7;</code>
   *
   * @return The bytes for version.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullPath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, fullPath_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rootPath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, rootPath_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(relativePath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, relativePath_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, version_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullPath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, fullPath_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rootPath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, rootPath_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(relativePath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, relativePath_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, version_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.Container)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.Container other = (com.google.privacy.dlp.v2.Container) obj;

    if (!getType().equals(other.getType())) return false;
    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getFullPath().equals(other.getFullPath())) return false;
    if (!getRootPath().equals(other.getRootPath())) return false;
    if (!getRelativePath().equals(other.getRelativePath())) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getVersion().equals(other.getVersion())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + FULL_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getFullPath().hashCode();
    hash = (37 * hash) + ROOT_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getRootPath().hashCode();
    hash = (37 * hash) + RELATIVE_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getRelativePath().hashCode();
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.Container parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Container parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Container parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Container parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Container parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Container parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Container parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Container parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Container parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Container parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Container parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Container parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.Container prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a container that may contain DLP findings.
   * Examples of a container include a file, table, or database record.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.Container}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.Container)
      com.google.privacy.dlp.v2.ContainerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Container_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Container_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.Container.class,
              com.google.privacy.dlp.v2.Container.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.Container.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = "";
      projectId_ = "";
      fullPath_ = "";
      rootPath_ = "";
      relativePath_ = "";
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      version_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Container_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Container getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.Container.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Container build() {
      com.google.privacy.dlp.v2.Container result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Container buildPartial() {
      com.google.privacy.dlp.v2.Container result = new com.google.privacy.dlp.v2.Container(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.Container result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.fullPath_ = fullPath_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.rootPath_ = rootPath_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.relativePath_ = relativePath_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.version_ = version_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.Container) {
        return mergeFrom((com.google.privacy.dlp.v2.Container) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.Container other) {
      if (other == com.google.privacy.dlp.v2.Container.getDefaultInstance()) return this;
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getFullPath().isEmpty()) {
        fullPath_ = other.fullPath_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getRootPath().isEmpty()) {
        rootPath_ = other.rootPath_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getRelativePath().isEmpty()) {
        relativePath_ = other.relativePath_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                fullPath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                rootPath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                relativePath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                version_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * Container type, for example BigQuery or Cloud Storage.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Container type, for example BigQuery or Cloud Storage.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Container type, for example BigQuery or Cloud Storage.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container type, for example BigQuery or Cloud Storage.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container type, for example BigQuery or Cloud Storage.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Project where the finding was found.
     * Can be different from the project that owns the finding.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project where the finding was found.
     * Can be different from the project that owns the finding.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project where the finding was found.
     * Can be different from the project that owns the finding.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project where the finding was found.
     * Can be different from the project that owns the finding.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project where the finding was found.
     * Can be different from the project that owns the finding.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object fullPath_ = "";
    /**
     *
     *
     * <pre>
     * A string representation of the full container name.
     * Examples:
     * - BigQuery: 'Project:DataSetId.TableId'
     * - Cloud Storage: 'gs://Bucket/folders/filename.txt'
     * </pre>
     *
     * <code>string full_path = 3;</code>
     *
     * @return The fullPath.
     */
    public java.lang.String getFullPath() {
      java.lang.Object ref = fullPath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fullPath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A string representation of the full container name.
     * Examples:
     * - BigQuery: 'Project:DataSetId.TableId'
     * - Cloud Storage: 'gs://Bucket/folders/filename.txt'
     * </pre>
     *
     * <code>string full_path = 3;</code>
     *
     * @return The bytes for fullPath.
     */
    public com.google.protobuf.ByteString getFullPathBytes() {
      java.lang.Object ref = fullPath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fullPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A string representation of the full container name.
     * Examples:
     * - BigQuery: 'Project:DataSetId.TableId'
     * - Cloud Storage: 'gs://Bucket/folders/filename.txt'
     * </pre>
     *
     * <code>string full_path = 3;</code>
     *
     * @param value The fullPath to set.
     * @return This builder for chaining.
     */
    public Builder setFullPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fullPath_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A string representation of the full container name.
     * Examples:
     * - BigQuery: 'Project:DataSetId.TableId'
     * - Cloud Storage: 'gs://Bucket/folders/filename.txt'
     * </pre>
     *
     * <code>string full_path = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFullPath() {
      fullPath_ = getDefaultInstance().getFullPath();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A string representation of the full container name.
     * Examples:
     * - BigQuery: 'Project:DataSetId.TableId'
     * - Cloud Storage: 'gs://Bucket/folders/filename.txt'
     * </pre>
     *
     * <code>string full_path = 3;</code>
     *
     * @param value The bytes for fullPath to set.
     * @return This builder for chaining.
     */
    public Builder setFullPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fullPath_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object rootPath_ = "";
    /**
     *
     *
     * <pre>
     * The root of the container.
     * Examples:
     *
     * - For BigQuery table `project_id:dataset_id.table_id`, the root is
     *  `dataset_id`
     * - For Cloud Storage file `gs://bucket/folder/filename.txt`, the root
     *  is `gs://bucket`
     * </pre>
     *
     * <code>string root_path = 4;</code>
     *
     * @return The rootPath.
     */
    public java.lang.String getRootPath() {
      java.lang.Object ref = rootPath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rootPath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The root of the container.
     * Examples:
     *
     * - For BigQuery table `project_id:dataset_id.table_id`, the root is
     *  `dataset_id`
     * - For Cloud Storage file `gs://bucket/folder/filename.txt`, the root
     *  is `gs://bucket`
     * </pre>
     *
     * <code>string root_path = 4;</code>
     *
     * @return The bytes for rootPath.
     */
    public com.google.protobuf.ByteString getRootPathBytes() {
      java.lang.Object ref = rootPath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rootPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The root of the container.
     * Examples:
     *
     * - For BigQuery table `project_id:dataset_id.table_id`, the root is
     *  `dataset_id`
     * - For Cloud Storage file `gs://bucket/folder/filename.txt`, the root
     *  is `gs://bucket`
     * </pre>
     *
     * <code>string root_path = 4;</code>
     *
     * @param value The rootPath to set.
     * @return This builder for chaining.
     */
    public Builder setRootPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rootPath_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The root of the container.
     * Examples:
     *
     * - For BigQuery table `project_id:dataset_id.table_id`, the root is
     *  `dataset_id`
     * - For Cloud Storage file `gs://bucket/folder/filename.txt`, the root
     *  is `gs://bucket`
     * </pre>
     *
     * <code>string root_path = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRootPath() {
      rootPath_ = getDefaultInstance().getRootPath();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The root of the container.
     * Examples:
     *
     * - For BigQuery table `project_id:dataset_id.table_id`, the root is
     *  `dataset_id`
     * - For Cloud Storage file `gs://bucket/folder/filename.txt`, the root
     *  is `gs://bucket`
     * </pre>
     *
     * <code>string root_path = 4;</code>
     *
     * @param value The bytes for rootPath to set.
     * @return This builder for chaining.
     */
    public Builder setRootPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rootPath_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object relativePath_ = "";
    /**
     *
     *
     * <pre>
     * The rest of the path after the root.
     * Examples:
     *
     * - For BigQuery table `project_id:dataset_id.table_id`, the relative path is
     *  `table_id`
     * - For Cloud Storage file `gs://bucket/folder/filename.txt`, the relative
     *  path is `folder/filename.txt`
     * </pre>
     *
     * <code>string relative_path = 5;</code>
     *
     * @return The relativePath.
     */
    public java.lang.String getRelativePath() {
      java.lang.Object ref = relativePath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        relativePath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The rest of the path after the root.
     * Examples:
     *
     * - For BigQuery table `project_id:dataset_id.table_id`, the relative path is
     *  `table_id`
     * - For Cloud Storage file `gs://bucket/folder/filename.txt`, the relative
     *  path is `folder/filename.txt`
     * </pre>
     *
     * <code>string relative_path = 5;</code>
     *
     * @return The bytes for relativePath.
     */
    public com.google.protobuf.ByteString getRelativePathBytes() {
      java.lang.Object ref = relativePath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        relativePath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The rest of the path after the root.
     * Examples:
     *
     * - For BigQuery table `project_id:dataset_id.table_id`, the relative path is
     *  `table_id`
     * - For Cloud Storage file `gs://bucket/folder/filename.txt`, the relative
     *  path is `folder/filename.txt`
     * </pre>
     *
     * <code>string relative_path = 5;</code>
     *
     * @param value The relativePath to set.
     * @return This builder for chaining.
     */
    public Builder setRelativePath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      relativePath_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The rest of the path after the root.
     * Examples:
     *
     * - For BigQuery table `project_id:dataset_id.table_id`, the relative path is
     *  `table_id`
     * - For Cloud Storage file `gs://bucket/folder/filename.txt`, the relative
     *  path is `folder/filename.txt`
     * </pre>
     *
     * <code>string relative_path = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRelativePath() {
      relativePath_ = getDefaultInstance().getRelativePath();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The rest of the path after the root.
     * Examples:
     *
     * - For BigQuery table `project_id:dataset_id.table_id`, the relative path is
     *  `table_id`
     * - For Cloud Storage file `gs://bucket/folder/filename.txt`, the relative
     *  path is `folder/filename.txt`
     * </pre>
     *
     * <code>string relative_path = 5;</code>
     *
     * @param value The bytes for relativePath to set.
     * @return This builder for chaining.
     */
    public Builder setRelativePathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      relativePath_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Findings container modification timestamp, if applicable. For Cloud
     * Storage, this field contains the last file modification timestamp. For a
     * BigQuery table, this field contains the last_modified_time property. For
     * Datastore, this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 6;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Findings container modification timestamp, if applicable. For Cloud
     * Storage, this field contains the last file modification timestamp. For a
     * BigQuery table, this field contains the last_modified_time property. For
     * Datastore, this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 6;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Findings container modification timestamp, if applicable. For Cloud
     * Storage, this field contains the last file modification timestamp. For a
     * BigQuery table, this field contains the last_modified_time property. For
     * Datastore, this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 6;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings container modification timestamp, if applicable. For Cloud
     * Storage, this field contains the last file modification timestamp. For a
     * BigQuery table, this field contains the last_modified_time property. For
     * Datastore, this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 6;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings container modification timestamp, if applicable. For Cloud
     * Storage, this field contains the last file modification timestamp. For a
     * BigQuery table, this field contains the last_modified_time property. For
     * Datastore, this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 6;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings container modification timestamp, if applicable. For Cloud
     * Storage, this field contains the last file modification timestamp. For a
     * BigQuery table, this field contains the last_modified_time property. For
     * Datastore, this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 6;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings container modification timestamp, if applicable. For Cloud
     * Storage, this field contains the last file modification timestamp. For a
     * BigQuery table, this field contains the last_modified_time property. For
     * Datastore, this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Findings container modification timestamp, if applicable. For Cloud
     * Storage, this field contains the last file modification timestamp. For a
     * BigQuery table, this field contains the last_modified_time property. For
     * Datastore, this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Findings container modification timestamp, if applicable. For Cloud
     * Storage, this field contains the last file modification timestamp. For a
     * BigQuery table, this field contains the last_modified_time property. For
     * Datastore, this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * Findings container version, if available
     * ("generation" for Cloud Storage).
     * </pre>
     *
     * <code>string version = 7;</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Findings container version, if available
     * ("generation" for Cloud Storage).
     * </pre>
     *
     * <code>string version = 7;</code>
     *
     * @return The bytes for version.
     */
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Findings container version, if available
     * ("generation" for Cloud Storage).
     * </pre>
     *
     * <code>string version = 7;</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      version_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings container version, if available
     * ("generation" for Cloud Storage).
     * </pre>
     *
     * <code>string version = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      version_ = getDefaultInstance().getVersion();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings container version, if available
     * ("generation" for Cloud Storage).
     * </pre>
     *
     * <code>string version = 7;</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      version_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.Container)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.Container)
  private static final com.google.privacy.dlp.v2.Container DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.Container();
  }

  public static com.google.privacy.dlp.v2.Container getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Container> PARSER =
      new com.google.protobuf.AbstractParser<Container>() {
        @java.lang.Override
        public Container parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Container> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Container> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.Container getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
