/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Precise location of the finding within a document, record, image, or metadata
 * container.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.ContentLocation}
 */
public final class ContentLocation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.ContentLocation)
    ContentLocationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ContentLocation.newBuilder() to construct.
  private ContentLocation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ContentLocation() {
    containerName_ = "";
    containerVersion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ContentLocation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_ContentLocation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_ContentLocation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.ContentLocation.class,
            com.google.privacy.dlp.v2.ContentLocation.Builder.class);
  }

  private int bitField0_;
  private int locationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object location_;

  public enum LocationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    RECORD_LOCATION(2),
    IMAGE_LOCATION(3),
    DOCUMENT_LOCATION(5),
    METADATA_LOCATION(8),
    LOCATION_NOT_SET(0);
    private final int value;

    private LocationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LocationCase valueOf(int value) {
      return forNumber(value);
    }

    public static LocationCase forNumber(int value) {
      switch (value) {
        case 2:
          return RECORD_LOCATION;
        case 3:
          return IMAGE_LOCATION;
        case 5:
          return DOCUMENT_LOCATION;
        case 8:
          return METADATA_LOCATION;
        case 0:
          return LOCATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public LocationCase getLocationCase() {
    return LocationCase.forNumber(locationCase_);
  }

  public static final int CONTAINER_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object containerName_ = "";
  /**
   *
   *
   * <pre>
   * Name of the container where the finding is located.
   * The top level name is the source file name or table name. Names of some
   * common storage containers are formatted as follows:
   *
   * * BigQuery tables:  `{project_id}:{dataset_id}.{table_id}`
   * * Cloud Storage files: `gs://{bucket}/{path}`
   * * Datastore namespace: {namespace}
   *
   * Nested names could be absent if the embedded object has no string
   * identifier (for example, an image contained within a document).
   * </pre>
   *
   * <code>string container_name = 1;</code>
   *
   * @return The containerName.
   */
  @java.lang.Override
  public java.lang.String getContainerName() {
    java.lang.Object ref = containerName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      containerName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the container where the finding is located.
   * The top level name is the source file name or table name. Names of some
   * common storage containers are formatted as follows:
   *
   * * BigQuery tables:  `{project_id}:{dataset_id}.{table_id}`
   * * Cloud Storage files: `gs://{bucket}/{path}`
   * * Datastore namespace: {namespace}
   *
   * Nested names could be absent if the embedded object has no string
   * identifier (for example, an image contained within a document).
   * </pre>
   *
   * <code>string container_name = 1;</code>
   *
   * @return The bytes for containerName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContainerNameBytes() {
    java.lang.Object ref = containerName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      containerName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECORD_LOCATION_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Location within a row or record of a database table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordLocation record_location = 2;</code>
   *
   * @return Whether the recordLocation field is set.
   */
  @java.lang.Override
  public boolean hasRecordLocation() {
    return locationCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Location within a row or record of a database table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordLocation record_location = 2;</code>
   *
   * @return The recordLocation.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RecordLocation getRecordLocation() {
    if (locationCase_ == 2) {
      return (com.google.privacy.dlp.v2.RecordLocation) location_;
    }
    return com.google.privacy.dlp.v2.RecordLocation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Location within a row or record of a database table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordLocation record_location = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RecordLocationOrBuilder getRecordLocationOrBuilder() {
    if (locationCase_ == 2) {
      return (com.google.privacy.dlp.v2.RecordLocation) location_;
    }
    return com.google.privacy.dlp.v2.RecordLocation.getDefaultInstance();
  }

  public static final int IMAGE_LOCATION_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Location within an image's pixels.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ImageLocation image_location = 3;</code>
   *
   * @return Whether the imageLocation field is set.
   */
  @java.lang.Override
  public boolean hasImageLocation() {
    return locationCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Location within an image's pixels.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ImageLocation image_location = 3;</code>
   *
   * @return The imageLocation.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ImageLocation getImageLocation() {
    if (locationCase_ == 3) {
      return (com.google.privacy.dlp.v2.ImageLocation) location_;
    }
    return com.google.privacy.dlp.v2.ImageLocation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Location within an image's pixels.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ImageLocation image_location = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ImageLocationOrBuilder getImageLocationOrBuilder() {
    if (locationCase_ == 3) {
      return (com.google.privacy.dlp.v2.ImageLocation) location_;
    }
    return com.google.privacy.dlp.v2.ImageLocation.getDefaultInstance();
  }

  public static final int DOCUMENT_LOCATION_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Location data for document files.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DocumentLocation document_location = 5;</code>
   *
   * @return Whether the documentLocation field is set.
   */
  @java.lang.Override
  public boolean hasDocumentLocation() {
    return locationCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Location data for document files.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DocumentLocation document_location = 5;</code>
   *
   * @return The documentLocation.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DocumentLocation getDocumentLocation() {
    if (locationCase_ == 5) {
      return (com.google.privacy.dlp.v2.DocumentLocation) location_;
    }
    return com.google.privacy.dlp.v2.DocumentLocation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Location data for document files.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DocumentLocation document_location = 5;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DocumentLocationOrBuilder getDocumentLocationOrBuilder() {
    if (locationCase_ == 5) {
      return (com.google.privacy.dlp.v2.DocumentLocation) location_;
    }
    return com.google.privacy.dlp.v2.DocumentLocation.getDefaultInstance();
  }

  public static final int METADATA_LOCATION_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Location within the metadata for inspected content.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.MetadataLocation metadata_location = 8;</code>
   *
   * @return Whether the metadataLocation field is set.
   */
  @java.lang.Override
  public boolean hasMetadataLocation() {
    return locationCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Location within the metadata for inspected content.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.MetadataLocation metadata_location = 8;</code>
   *
   * @return The metadataLocation.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.MetadataLocation getMetadataLocation() {
    if (locationCase_ == 8) {
      return (com.google.privacy.dlp.v2.MetadataLocation) location_;
    }
    return com.google.privacy.dlp.v2.MetadataLocation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Location within the metadata for inspected content.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.MetadataLocation metadata_location = 8;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.MetadataLocationOrBuilder getMetadataLocationOrBuilder() {
    if (locationCase_ == 8) {
      return (com.google.privacy.dlp.v2.MetadataLocation) location_;
    }
    return com.google.privacy.dlp.v2.MetadataLocation.getDefaultInstance();
  }

  public static final int CONTAINER_TIMESTAMP_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp containerTimestamp_;
  /**
   *
   *
   * <pre>
   * Finding container modification timestamp, if applicable. For Cloud Storage,
   * this field contains the last file modification timestamp. For a BigQuery
   * table, this field contains the last_modified_time property. For Datastore,
   * this field isn't populated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp container_timestamp = 6;</code>
   *
   * @return Whether the containerTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasContainerTimestamp() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Finding container modification timestamp, if applicable. For Cloud Storage,
   * this field contains the last file modification timestamp. For a BigQuery
   * table, this field contains the last_modified_time property. For Datastore,
   * this field isn't populated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp container_timestamp = 6;</code>
   *
   * @return The containerTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getContainerTimestamp() {
    return containerTimestamp_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : containerTimestamp_;
  }
  /**
   *
   *
   * <pre>
   * Finding container modification timestamp, if applicable. For Cloud Storage,
   * this field contains the last file modification timestamp. For a BigQuery
   * table, this field contains the last_modified_time property. For Datastore,
   * this field isn't populated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp container_timestamp = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getContainerTimestampOrBuilder() {
    return containerTimestamp_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : containerTimestamp_;
  }

  public static final int CONTAINER_VERSION_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object containerVersion_ = "";
  /**
   *
   *
   * <pre>
   * Finding container version, if available
   * ("generation" for Cloud Storage).
   * </pre>
   *
   * <code>string container_version = 7;</code>
   *
   * @return The containerVersion.
   */
  @java.lang.Override
  public java.lang.String getContainerVersion() {
    java.lang.Object ref = containerVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      containerVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Finding container version, if available
   * ("generation" for Cloud Storage).
   * </pre>
   *
   * <code>string container_version = 7;</code>
   *
   * @return The bytes for containerVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContainerVersionBytes() {
    java.lang.Object ref = containerVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      containerVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(containerName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, containerName_);
    }
    if (locationCase_ == 2) {
      output.writeMessage(2, (com.google.privacy.dlp.v2.RecordLocation) location_);
    }
    if (locationCase_ == 3) {
      output.writeMessage(3, (com.google.privacy.dlp.v2.ImageLocation) location_);
    }
    if (locationCase_ == 5) {
      output.writeMessage(5, (com.google.privacy.dlp.v2.DocumentLocation) location_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getContainerTimestamp());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(containerVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, containerVersion_);
    }
    if (locationCase_ == 8) {
      output.writeMessage(8, (com.google.privacy.dlp.v2.MetadataLocation) location_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(containerName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, containerName_);
    }
    if (locationCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.privacy.dlp.v2.RecordLocation) location_);
    }
    if (locationCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.privacy.dlp.v2.ImageLocation) location_);
    }
    if (locationCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.privacy.dlp.v2.DocumentLocation) location_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getContainerTimestamp());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(containerVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, containerVersion_);
    }
    if (locationCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.privacy.dlp.v2.MetadataLocation) location_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.ContentLocation)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.ContentLocation other =
        (com.google.privacy.dlp.v2.ContentLocation) obj;

    if (!getContainerName().equals(other.getContainerName())) return false;
    if (hasContainerTimestamp() != other.hasContainerTimestamp()) return false;
    if (hasContainerTimestamp()) {
      if (!getContainerTimestamp().equals(other.getContainerTimestamp())) return false;
    }
    if (!getContainerVersion().equals(other.getContainerVersion())) return false;
    if (!getLocationCase().equals(other.getLocationCase())) return false;
    switch (locationCase_) {
      case 2:
        if (!getRecordLocation().equals(other.getRecordLocation())) return false;
        break;
      case 3:
        if (!getImageLocation().equals(other.getImageLocation())) return false;
        break;
      case 5:
        if (!getDocumentLocation().equals(other.getDocumentLocation())) return false;
        break;
      case 8:
        if (!getMetadataLocation().equals(other.getMetadataLocation())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONTAINER_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getContainerName().hashCode();
    if (hasContainerTimestamp()) {
      hash = (37 * hash) + CONTAINER_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getContainerTimestamp().hashCode();
    }
    hash = (37 * hash) + CONTAINER_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getContainerVersion().hashCode();
    switch (locationCase_) {
      case 2:
        hash = (37 * hash) + RECORD_LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getRecordLocation().hashCode();
        break;
      case 3:
        hash = (37 * hash) + IMAGE_LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getImageLocation().hashCode();
        break;
      case 5:
        hash = (37 * hash) + DOCUMENT_LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getDocumentLocation().hashCode();
        break;
      case 8:
        hash = (37 * hash) + METADATA_LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getMetadataLocation().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.ContentLocation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.ContentLocation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ContentLocation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.ContentLocation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ContentLocation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.ContentLocation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ContentLocation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.ContentLocation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ContentLocation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.ContentLocation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ContentLocation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.ContentLocation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.ContentLocation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Precise location of the finding within a document, record, image, or metadata
   * container.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.ContentLocation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.ContentLocation)
      com.google.privacy.dlp.v2.ContentLocationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_ContentLocation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_ContentLocation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.ContentLocation.class,
              com.google.privacy.dlp.v2.ContentLocation.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.ContentLocation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getContainerTimestampFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      containerName_ = "";
      if (recordLocationBuilder_ != null) {
        recordLocationBuilder_.clear();
      }
      if (imageLocationBuilder_ != null) {
        imageLocationBuilder_.clear();
      }
      if (documentLocationBuilder_ != null) {
        documentLocationBuilder_.clear();
      }
      if (metadataLocationBuilder_ != null) {
        metadataLocationBuilder_.clear();
      }
      containerTimestamp_ = null;
      if (containerTimestampBuilder_ != null) {
        containerTimestampBuilder_.dispose();
        containerTimestampBuilder_ = null;
      }
      containerVersion_ = "";
      locationCase_ = 0;
      location_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_ContentLocation_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.ContentLocation getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.ContentLocation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.ContentLocation build() {
      com.google.privacy.dlp.v2.ContentLocation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.ContentLocation buildPartial() {
      com.google.privacy.dlp.v2.ContentLocation result =
          new com.google.privacy.dlp.v2.ContentLocation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.ContentLocation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.containerName_ = containerName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.containerTimestamp_ =
            containerTimestampBuilder_ == null
                ? containerTimestamp_
                : containerTimestampBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.containerVersion_ = containerVersion_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.ContentLocation result) {
      result.locationCase_ = locationCase_;
      result.location_ = this.location_;
      if (locationCase_ == 2 && recordLocationBuilder_ != null) {
        result.location_ = recordLocationBuilder_.build();
      }
      if (locationCase_ == 3 && imageLocationBuilder_ != null) {
        result.location_ = imageLocationBuilder_.build();
      }
      if (locationCase_ == 5 && documentLocationBuilder_ != null) {
        result.location_ = documentLocationBuilder_.build();
      }
      if (locationCase_ == 8 && metadataLocationBuilder_ != null) {
        result.location_ = metadataLocationBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.ContentLocation) {
        return mergeFrom((com.google.privacy.dlp.v2.ContentLocation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.ContentLocation other) {
      if (other == com.google.privacy.dlp.v2.ContentLocation.getDefaultInstance()) return this;
      if (!other.getContainerName().isEmpty()) {
        containerName_ = other.containerName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasContainerTimestamp()) {
        mergeContainerTimestamp(other.getContainerTimestamp());
      }
      if (!other.getContainerVersion().isEmpty()) {
        containerVersion_ = other.containerVersion_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      switch (other.getLocationCase()) {
        case RECORD_LOCATION:
          {
            mergeRecordLocation(other.getRecordLocation());
            break;
          }
        case IMAGE_LOCATION:
          {
            mergeImageLocation(other.getImageLocation());
            break;
          }
        case DOCUMENT_LOCATION:
          {
            mergeDocumentLocation(other.getDocumentLocation());
            break;
          }
        case METADATA_LOCATION:
          {
            mergeMetadataLocation(other.getMetadataLocation());
            break;
          }
        case LOCATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                containerName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getRecordLocationFieldBuilder().getBuilder(), extensionRegistry);
                locationCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getImageLocationFieldBuilder().getBuilder(), extensionRegistry);
                locationCase_ = 3;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(
                    getDocumentLocationFieldBuilder().getBuilder(), extensionRegistry);
                locationCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getContainerTimestampFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                containerVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getMetadataLocationFieldBuilder().getBuilder(), extensionRegistry);
                locationCase_ = 8;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int locationCase_ = 0;
    private java.lang.Object location_;

    public LocationCase getLocationCase() {
      return LocationCase.forNumber(locationCase_);
    }

    public Builder clearLocation() {
      locationCase_ = 0;
      location_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object containerName_ = "";
    /**
     *
     *
     * <pre>
     * Name of the container where the finding is located.
     * The top level name is the source file name or table name. Names of some
     * common storage containers are formatted as follows:
     *
     * * BigQuery tables:  `{project_id}:{dataset_id}.{table_id}`
     * * Cloud Storage files: `gs://{bucket}/{path}`
     * * Datastore namespace: {namespace}
     *
     * Nested names could be absent if the embedded object has no string
     * identifier (for example, an image contained within a document).
     * </pre>
     *
     * <code>string container_name = 1;</code>
     *
     * @return The containerName.
     */
    public java.lang.String getContainerName() {
      java.lang.Object ref = containerName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        containerName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the container where the finding is located.
     * The top level name is the source file name or table name. Names of some
     * common storage containers are formatted as follows:
     *
     * * BigQuery tables:  `{project_id}:{dataset_id}.{table_id}`
     * * Cloud Storage files: `gs://{bucket}/{path}`
     * * Datastore namespace: {namespace}
     *
     * Nested names could be absent if the embedded object has no string
     * identifier (for example, an image contained within a document).
     * </pre>
     *
     * <code>string container_name = 1;</code>
     *
     * @return The bytes for containerName.
     */
    public com.google.protobuf.ByteString getContainerNameBytes() {
      java.lang.Object ref = containerName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        containerName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the container where the finding is located.
     * The top level name is the source file name or table name. Names of some
     * common storage containers are formatted as follows:
     *
     * * BigQuery tables:  `{project_id}:{dataset_id}.{table_id}`
     * * Cloud Storage files: `gs://{bucket}/{path}`
     * * Datastore namespace: {namespace}
     *
     * Nested names could be absent if the embedded object has no string
     * identifier (for example, an image contained within a document).
     * </pre>
     *
     * <code>string container_name = 1;</code>
     *
     * @param value The containerName to set.
     * @return This builder for chaining.
     */
    public Builder setContainerName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      containerName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the container where the finding is located.
     * The top level name is the source file name or table name. Names of some
     * common storage containers are formatted as follows:
     *
     * * BigQuery tables:  `{project_id}:{dataset_id}.{table_id}`
     * * Cloud Storage files: `gs://{bucket}/{path}`
     * * Datastore namespace: {namespace}
     *
     * Nested names could be absent if the embedded object has no string
     * identifier (for example, an image contained within a document).
     * </pre>
     *
     * <code>string container_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContainerName() {
      containerName_ = getDefaultInstance().getContainerName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the container where the finding is located.
     * The top level name is the source file name or table name. Names of some
     * common storage containers are formatted as follows:
     *
     * * BigQuery tables:  `{project_id}:{dataset_id}.{table_id}`
     * * Cloud Storage files: `gs://{bucket}/{path}`
     * * Datastore namespace: {namespace}
     *
     * Nested names could be absent if the embedded object has no string
     * identifier (for example, an image contained within a document).
     * </pre>
     *
     * <code>string container_name = 1;</code>
     *
     * @param value The bytes for containerName to set.
     * @return This builder for chaining.
     */
    public Builder setContainerNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      containerName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.RecordLocation,
            com.google.privacy.dlp.v2.RecordLocation.Builder,
            com.google.privacy.dlp.v2.RecordLocationOrBuilder>
        recordLocationBuilder_;
    /**
     *
     *
     * <pre>
     * Location within a row or record of a database table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordLocation record_location = 2;</code>
     *
     * @return Whether the recordLocation field is set.
     */
    @java.lang.Override
    public boolean hasRecordLocation() {
      return locationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Location within a row or record of a database table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordLocation record_location = 2;</code>
     *
     * @return The recordLocation.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordLocation getRecordLocation() {
      if (recordLocationBuilder_ == null) {
        if (locationCase_ == 2) {
          return (com.google.privacy.dlp.v2.RecordLocation) location_;
        }
        return com.google.privacy.dlp.v2.RecordLocation.getDefaultInstance();
      } else {
        if (locationCase_ == 2) {
          return recordLocationBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.RecordLocation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Location within a row or record of a database table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordLocation record_location = 2;</code>
     */
    public Builder setRecordLocation(com.google.privacy.dlp.v2.RecordLocation value) {
      if (recordLocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        location_ = value;
        onChanged();
      } else {
        recordLocationBuilder_.setMessage(value);
      }
      locationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location within a row or record of a database table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordLocation record_location = 2;</code>
     */
    public Builder setRecordLocation(
        com.google.privacy.dlp.v2.RecordLocation.Builder builderForValue) {
      if (recordLocationBuilder_ == null) {
        location_ = builderForValue.build();
        onChanged();
      } else {
        recordLocationBuilder_.setMessage(builderForValue.build());
      }
      locationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location within a row or record of a database table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordLocation record_location = 2;</code>
     */
    public Builder mergeRecordLocation(com.google.privacy.dlp.v2.RecordLocation value) {
      if (recordLocationBuilder_ == null) {
        if (locationCase_ == 2
            && location_ != com.google.privacy.dlp.v2.RecordLocation.getDefaultInstance()) {
          location_ =
              com.google.privacy.dlp.v2.RecordLocation.newBuilder(
                      (com.google.privacy.dlp.v2.RecordLocation) location_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          location_ = value;
        }
        onChanged();
      } else {
        if (locationCase_ == 2) {
          recordLocationBuilder_.mergeFrom(value);
        } else {
          recordLocationBuilder_.setMessage(value);
        }
      }
      locationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location within a row or record of a database table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordLocation record_location = 2;</code>
     */
    public Builder clearRecordLocation() {
      if (recordLocationBuilder_ == null) {
        if (locationCase_ == 2) {
          locationCase_ = 0;
          location_ = null;
          onChanged();
        }
      } else {
        if (locationCase_ == 2) {
          locationCase_ = 0;
          location_ = null;
        }
        recordLocationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location within a row or record of a database table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordLocation record_location = 2;</code>
     */
    public com.google.privacy.dlp.v2.RecordLocation.Builder getRecordLocationBuilder() {
      return getRecordLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Location within a row or record of a database table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordLocation record_location = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordLocationOrBuilder getRecordLocationOrBuilder() {
      if ((locationCase_ == 2) && (recordLocationBuilder_ != null)) {
        return recordLocationBuilder_.getMessageOrBuilder();
      } else {
        if (locationCase_ == 2) {
          return (com.google.privacy.dlp.v2.RecordLocation) location_;
        }
        return com.google.privacy.dlp.v2.RecordLocation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Location within a row or record of a database table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordLocation record_location = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.RecordLocation,
            com.google.privacy.dlp.v2.RecordLocation.Builder,
            com.google.privacy.dlp.v2.RecordLocationOrBuilder>
        getRecordLocationFieldBuilder() {
      if (recordLocationBuilder_ == null) {
        if (!(locationCase_ == 2)) {
          location_ = com.google.privacy.dlp.v2.RecordLocation.getDefaultInstance();
        }
        recordLocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.RecordLocation,
                com.google.privacy.dlp.v2.RecordLocation.Builder,
                com.google.privacy.dlp.v2.RecordLocationOrBuilder>(
                (com.google.privacy.dlp.v2.RecordLocation) location_,
                getParentForChildren(),
                isClean());
        location_ = null;
      }
      locationCase_ = 2;
      onChanged();
      return recordLocationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ImageLocation,
            com.google.privacy.dlp.v2.ImageLocation.Builder,
            com.google.privacy.dlp.v2.ImageLocationOrBuilder>
        imageLocationBuilder_;
    /**
     *
     *
     * <pre>
     * Location within an image's pixels.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageLocation image_location = 3;</code>
     *
     * @return Whether the imageLocation field is set.
     */
    @java.lang.Override
    public boolean hasImageLocation() {
      return locationCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Location within an image's pixels.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageLocation image_location = 3;</code>
     *
     * @return The imageLocation.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ImageLocation getImageLocation() {
      if (imageLocationBuilder_ == null) {
        if (locationCase_ == 3) {
          return (com.google.privacy.dlp.v2.ImageLocation) location_;
        }
        return com.google.privacy.dlp.v2.ImageLocation.getDefaultInstance();
      } else {
        if (locationCase_ == 3) {
          return imageLocationBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.ImageLocation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Location within an image's pixels.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageLocation image_location = 3;</code>
     */
    public Builder setImageLocation(com.google.privacy.dlp.v2.ImageLocation value) {
      if (imageLocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        location_ = value;
        onChanged();
      } else {
        imageLocationBuilder_.setMessage(value);
      }
      locationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location within an image's pixels.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageLocation image_location = 3;</code>
     */
    public Builder setImageLocation(
        com.google.privacy.dlp.v2.ImageLocation.Builder builderForValue) {
      if (imageLocationBuilder_ == null) {
        location_ = builderForValue.build();
        onChanged();
      } else {
        imageLocationBuilder_.setMessage(builderForValue.build());
      }
      locationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location within an image's pixels.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageLocation image_location = 3;</code>
     */
    public Builder mergeImageLocation(com.google.privacy.dlp.v2.ImageLocation value) {
      if (imageLocationBuilder_ == null) {
        if (locationCase_ == 3
            && location_ != com.google.privacy.dlp.v2.ImageLocation.getDefaultInstance()) {
          location_ =
              com.google.privacy.dlp.v2.ImageLocation.newBuilder(
                      (com.google.privacy.dlp.v2.ImageLocation) location_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          location_ = value;
        }
        onChanged();
      } else {
        if (locationCase_ == 3) {
          imageLocationBuilder_.mergeFrom(value);
        } else {
          imageLocationBuilder_.setMessage(value);
        }
      }
      locationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location within an image's pixels.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageLocation image_location = 3;</code>
     */
    public Builder clearImageLocation() {
      if (imageLocationBuilder_ == null) {
        if (locationCase_ == 3) {
          locationCase_ = 0;
          location_ = null;
          onChanged();
        }
      } else {
        if (locationCase_ == 3) {
          locationCase_ = 0;
          location_ = null;
        }
        imageLocationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location within an image's pixels.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageLocation image_location = 3;</code>
     */
    public com.google.privacy.dlp.v2.ImageLocation.Builder getImageLocationBuilder() {
      return getImageLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Location within an image's pixels.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageLocation image_location = 3;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ImageLocationOrBuilder getImageLocationOrBuilder() {
      if ((locationCase_ == 3) && (imageLocationBuilder_ != null)) {
        return imageLocationBuilder_.getMessageOrBuilder();
      } else {
        if (locationCase_ == 3) {
          return (com.google.privacy.dlp.v2.ImageLocation) location_;
        }
        return com.google.privacy.dlp.v2.ImageLocation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Location within an image's pixels.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageLocation image_location = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ImageLocation,
            com.google.privacy.dlp.v2.ImageLocation.Builder,
            com.google.privacy.dlp.v2.ImageLocationOrBuilder>
        getImageLocationFieldBuilder() {
      if (imageLocationBuilder_ == null) {
        if (!(locationCase_ == 3)) {
          location_ = com.google.privacy.dlp.v2.ImageLocation.getDefaultInstance();
        }
        imageLocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.ImageLocation,
                com.google.privacy.dlp.v2.ImageLocation.Builder,
                com.google.privacy.dlp.v2.ImageLocationOrBuilder>(
                (com.google.privacy.dlp.v2.ImageLocation) location_,
                getParentForChildren(),
                isClean());
        location_ = null;
      }
      locationCase_ = 3;
      onChanged();
      return imageLocationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DocumentLocation,
            com.google.privacy.dlp.v2.DocumentLocation.Builder,
            com.google.privacy.dlp.v2.DocumentLocationOrBuilder>
        documentLocationBuilder_;
    /**
     *
     *
     * <pre>
     * Location data for document files.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DocumentLocation document_location = 5;</code>
     *
     * @return Whether the documentLocation field is set.
     */
    @java.lang.Override
    public boolean hasDocumentLocation() {
      return locationCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Location data for document files.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DocumentLocation document_location = 5;</code>
     *
     * @return The documentLocation.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DocumentLocation getDocumentLocation() {
      if (documentLocationBuilder_ == null) {
        if (locationCase_ == 5) {
          return (com.google.privacy.dlp.v2.DocumentLocation) location_;
        }
        return com.google.privacy.dlp.v2.DocumentLocation.getDefaultInstance();
      } else {
        if (locationCase_ == 5) {
          return documentLocationBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.DocumentLocation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Location data for document files.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DocumentLocation document_location = 5;</code>
     */
    public Builder setDocumentLocation(com.google.privacy.dlp.v2.DocumentLocation value) {
      if (documentLocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        location_ = value;
        onChanged();
      } else {
        documentLocationBuilder_.setMessage(value);
      }
      locationCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location data for document files.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DocumentLocation document_location = 5;</code>
     */
    public Builder setDocumentLocation(
        com.google.privacy.dlp.v2.DocumentLocation.Builder builderForValue) {
      if (documentLocationBuilder_ == null) {
        location_ = builderForValue.build();
        onChanged();
      } else {
        documentLocationBuilder_.setMessage(builderForValue.build());
      }
      locationCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location data for document files.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DocumentLocation document_location = 5;</code>
     */
    public Builder mergeDocumentLocation(com.google.privacy.dlp.v2.DocumentLocation value) {
      if (documentLocationBuilder_ == null) {
        if (locationCase_ == 5
            && location_ != com.google.privacy.dlp.v2.DocumentLocation.getDefaultInstance()) {
          location_ =
              com.google.privacy.dlp.v2.DocumentLocation.newBuilder(
                      (com.google.privacy.dlp.v2.DocumentLocation) location_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          location_ = value;
        }
        onChanged();
      } else {
        if (locationCase_ == 5) {
          documentLocationBuilder_.mergeFrom(value);
        } else {
          documentLocationBuilder_.setMessage(value);
        }
      }
      locationCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location data for document files.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DocumentLocation document_location = 5;</code>
     */
    public Builder clearDocumentLocation() {
      if (documentLocationBuilder_ == null) {
        if (locationCase_ == 5) {
          locationCase_ = 0;
          location_ = null;
          onChanged();
        }
      } else {
        if (locationCase_ == 5) {
          locationCase_ = 0;
          location_ = null;
        }
        documentLocationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location data for document files.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DocumentLocation document_location = 5;</code>
     */
    public com.google.privacy.dlp.v2.DocumentLocation.Builder getDocumentLocationBuilder() {
      return getDocumentLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Location data for document files.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DocumentLocation document_location = 5;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DocumentLocationOrBuilder getDocumentLocationOrBuilder() {
      if ((locationCase_ == 5) && (documentLocationBuilder_ != null)) {
        return documentLocationBuilder_.getMessageOrBuilder();
      } else {
        if (locationCase_ == 5) {
          return (com.google.privacy.dlp.v2.DocumentLocation) location_;
        }
        return com.google.privacy.dlp.v2.DocumentLocation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Location data for document files.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DocumentLocation document_location = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DocumentLocation,
            com.google.privacy.dlp.v2.DocumentLocation.Builder,
            com.google.privacy.dlp.v2.DocumentLocationOrBuilder>
        getDocumentLocationFieldBuilder() {
      if (documentLocationBuilder_ == null) {
        if (!(locationCase_ == 5)) {
          location_ = com.google.privacy.dlp.v2.DocumentLocation.getDefaultInstance();
        }
        documentLocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DocumentLocation,
                com.google.privacy.dlp.v2.DocumentLocation.Builder,
                com.google.privacy.dlp.v2.DocumentLocationOrBuilder>(
                (com.google.privacy.dlp.v2.DocumentLocation) location_,
                getParentForChildren(),
                isClean());
        location_ = null;
      }
      locationCase_ = 5;
      onChanged();
      return documentLocationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.MetadataLocation,
            com.google.privacy.dlp.v2.MetadataLocation.Builder,
            com.google.privacy.dlp.v2.MetadataLocationOrBuilder>
        metadataLocationBuilder_;
    /**
     *
     *
     * <pre>
     * Location within the metadata for inspected content.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.MetadataLocation metadata_location = 8;</code>
     *
     * @return Whether the metadataLocation field is set.
     */
    @java.lang.Override
    public boolean hasMetadataLocation() {
      return locationCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Location within the metadata for inspected content.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.MetadataLocation metadata_location = 8;</code>
     *
     * @return The metadataLocation.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.MetadataLocation getMetadataLocation() {
      if (metadataLocationBuilder_ == null) {
        if (locationCase_ == 8) {
          return (com.google.privacy.dlp.v2.MetadataLocation) location_;
        }
        return com.google.privacy.dlp.v2.MetadataLocation.getDefaultInstance();
      } else {
        if (locationCase_ == 8) {
          return metadataLocationBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.MetadataLocation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Location within the metadata for inspected content.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.MetadataLocation metadata_location = 8;</code>
     */
    public Builder setMetadataLocation(com.google.privacy.dlp.v2.MetadataLocation value) {
      if (metadataLocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        location_ = value;
        onChanged();
      } else {
        metadataLocationBuilder_.setMessage(value);
      }
      locationCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location within the metadata for inspected content.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.MetadataLocation metadata_location = 8;</code>
     */
    public Builder setMetadataLocation(
        com.google.privacy.dlp.v2.MetadataLocation.Builder builderForValue) {
      if (metadataLocationBuilder_ == null) {
        location_ = builderForValue.build();
        onChanged();
      } else {
        metadataLocationBuilder_.setMessage(builderForValue.build());
      }
      locationCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location within the metadata for inspected content.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.MetadataLocation metadata_location = 8;</code>
     */
    public Builder mergeMetadataLocation(com.google.privacy.dlp.v2.MetadataLocation value) {
      if (metadataLocationBuilder_ == null) {
        if (locationCase_ == 8
            && location_ != com.google.privacy.dlp.v2.MetadataLocation.getDefaultInstance()) {
          location_ =
              com.google.privacy.dlp.v2.MetadataLocation.newBuilder(
                      (com.google.privacy.dlp.v2.MetadataLocation) location_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          location_ = value;
        }
        onChanged();
      } else {
        if (locationCase_ == 8) {
          metadataLocationBuilder_.mergeFrom(value);
        } else {
          metadataLocationBuilder_.setMessage(value);
        }
      }
      locationCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location within the metadata for inspected content.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.MetadataLocation metadata_location = 8;</code>
     */
    public Builder clearMetadataLocation() {
      if (metadataLocationBuilder_ == null) {
        if (locationCase_ == 8) {
          locationCase_ = 0;
          location_ = null;
          onChanged();
        }
      } else {
        if (locationCase_ == 8) {
          locationCase_ = 0;
          location_ = null;
        }
        metadataLocationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location within the metadata for inspected content.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.MetadataLocation metadata_location = 8;</code>
     */
    public com.google.privacy.dlp.v2.MetadataLocation.Builder getMetadataLocationBuilder() {
      return getMetadataLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Location within the metadata for inspected content.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.MetadataLocation metadata_location = 8;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.MetadataLocationOrBuilder getMetadataLocationOrBuilder() {
      if ((locationCase_ == 8) && (metadataLocationBuilder_ != null)) {
        return metadataLocationBuilder_.getMessageOrBuilder();
      } else {
        if (locationCase_ == 8) {
          return (com.google.privacy.dlp.v2.MetadataLocation) location_;
        }
        return com.google.privacy.dlp.v2.MetadataLocation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Location within the metadata for inspected content.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.MetadataLocation metadata_location = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.MetadataLocation,
            com.google.privacy.dlp.v2.MetadataLocation.Builder,
            com.google.privacy.dlp.v2.MetadataLocationOrBuilder>
        getMetadataLocationFieldBuilder() {
      if (metadataLocationBuilder_ == null) {
        if (!(locationCase_ == 8)) {
          location_ = com.google.privacy.dlp.v2.MetadataLocation.getDefaultInstance();
        }
        metadataLocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.MetadataLocation,
                com.google.privacy.dlp.v2.MetadataLocation.Builder,
                com.google.privacy.dlp.v2.MetadataLocationOrBuilder>(
                (com.google.privacy.dlp.v2.MetadataLocation) location_,
                getParentForChildren(),
                isClean());
        location_ = null;
      }
      locationCase_ = 8;
      onChanged();
      return metadataLocationBuilder_;
    }

    private com.google.protobuf.Timestamp containerTimestamp_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        containerTimestampBuilder_;
    /**
     *
     *
     * <pre>
     * Finding container modification timestamp, if applicable. For Cloud Storage,
     * this field contains the last file modification timestamp. For a BigQuery
     * table, this field contains the last_modified_time property. For Datastore,
     * this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp container_timestamp = 6;</code>
     *
     * @return Whether the containerTimestamp field is set.
     */
    public boolean hasContainerTimestamp() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Finding container modification timestamp, if applicable. For Cloud Storage,
     * this field contains the last file modification timestamp. For a BigQuery
     * table, this field contains the last_modified_time property. For Datastore,
     * this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp container_timestamp = 6;</code>
     *
     * @return The containerTimestamp.
     */
    public com.google.protobuf.Timestamp getContainerTimestamp() {
      if (containerTimestampBuilder_ == null) {
        return containerTimestamp_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : containerTimestamp_;
      } else {
        return containerTimestampBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Finding container modification timestamp, if applicable. For Cloud Storage,
     * this field contains the last file modification timestamp. For a BigQuery
     * table, this field contains the last_modified_time property. For Datastore,
     * this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp container_timestamp = 6;</code>
     */
    public Builder setContainerTimestamp(com.google.protobuf.Timestamp value) {
      if (containerTimestampBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        containerTimestamp_ = value;
      } else {
        containerTimestampBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Finding container modification timestamp, if applicable. For Cloud Storage,
     * this field contains the last file modification timestamp. For a BigQuery
     * table, this field contains the last_modified_time property. For Datastore,
     * this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp container_timestamp = 6;</code>
     */
    public Builder setContainerTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (containerTimestampBuilder_ == null) {
        containerTimestamp_ = builderForValue.build();
      } else {
        containerTimestampBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Finding container modification timestamp, if applicable. For Cloud Storage,
     * this field contains the last file modification timestamp. For a BigQuery
     * table, this field contains the last_modified_time property. For Datastore,
     * this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp container_timestamp = 6;</code>
     */
    public Builder mergeContainerTimestamp(com.google.protobuf.Timestamp value) {
      if (containerTimestampBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && containerTimestamp_ != null
            && containerTimestamp_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getContainerTimestampBuilder().mergeFrom(value);
        } else {
          containerTimestamp_ = value;
        }
      } else {
        containerTimestampBuilder_.mergeFrom(value);
      }
      if (containerTimestamp_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Finding container modification timestamp, if applicable. For Cloud Storage,
     * this field contains the last file modification timestamp. For a BigQuery
     * table, this field contains the last_modified_time property. For Datastore,
     * this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp container_timestamp = 6;</code>
     */
    public Builder clearContainerTimestamp() {
      bitField0_ = (bitField0_ & ~0x00000020);
      containerTimestamp_ = null;
      if (containerTimestampBuilder_ != null) {
        containerTimestampBuilder_.dispose();
        containerTimestampBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Finding container modification timestamp, if applicable. For Cloud Storage,
     * this field contains the last file modification timestamp. For a BigQuery
     * table, this field contains the last_modified_time property. For Datastore,
     * this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp container_timestamp = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getContainerTimestampBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getContainerTimestampFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Finding container modification timestamp, if applicable. For Cloud Storage,
     * this field contains the last file modification timestamp. For a BigQuery
     * table, this field contains the last_modified_time property. For Datastore,
     * this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp container_timestamp = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getContainerTimestampOrBuilder() {
      if (containerTimestampBuilder_ != null) {
        return containerTimestampBuilder_.getMessageOrBuilder();
      } else {
        return containerTimestamp_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : containerTimestamp_;
      }
    }
    /**
     *
     *
     * <pre>
     * Finding container modification timestamp, if applicable. For Cloud Storage,
     * this field contains the last file modification timestamp. For a BigQuery
     * table, this field contains the last_modified_time property. For Datastore,
     * this field isn't populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp container_timestamp = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getContainerTimestampFieldBuilder() {
      if (containerTimestampBuilder_ == null) {
        containerTimestampBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getContainerTimestamp(), getParentForChildren(), isClean());
        containerTimestamp_ = null;
      }
      return containerTimestampBuilder_;
    }

    private java.lang.Object containerVersion_ = "";
    /**
     *
     *
     * <pre>
     * Finding container version, if available
     * ("generation" for Cloud Storage).
     * </pre>
     *
     * <code>string container_version = 7;</code>
     *
     * @return The containerVersion.
     */
    public java.lang.String getContainerVersion() {
      java.lang.Object ref = containerVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        containerVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Finding container version, if available
     * ("generation" for Cloud Storage).
     * </pre>
     *
     * <code>string container_version = 7;</code>
     *
     * @return The bytes for containerVersion.
     */
    public com.google.protobuf.ByteString getContainerVersionBytes() {
      java.lang.Object ref = containerVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        containerVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Finding container version, if available
     * ("generation" for Cloud Storage).
     * </pre>
     *
     * <code>string container_version = 7;</code>
     *
     * @param value The containerVersion to set.
     * @return This builder for chaining.
     */
    public Builder setContainerVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      containerVersion_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Finding container version, if available
     * ("generation" for Cloud Storage).
     * </pre>
     *
     * <code>string container_version = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContainerVersion() {
      containerVersion_ = getDefaultInstance().getContainerVersion();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Finding container version, if available
     * ("generation" for Cloud Storage).
     * </pre>
     *
     * <code>string container_version = 7;</code>
     *
     * @param value The bytes for containerVersion to set.
     * @return This builder for chaining.
     */
    public Builder setContainerVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      containerVersion_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.ContentLocation)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.ContentLocation)
  private static final com.google.privacy.dlp.v2.ContentLocation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.ContentLocation();
  }

  public static com.google.privacy.dlp.v2.ContentLocation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ContentLocation> PARSER =
      new com.google.protobuf.AbstractParser<ContentLocation>() {
        @java.lang.Override
        public ContentLocation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ContentLocation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ContentLocation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.ContentLocation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
