/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Request message for CreateDlpJobRequest. Used to initiate long running
 * jobs such as calculating risk metrics or inspecting Google Cloud
 * Storage.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.CreateDlpJobRequest}
 */
public final class CreateDlpJobRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CreateDlpJobRequest)
    CreateDlpJobRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateDlpJobRequest.newBuilder() to construct.
  private CreateDlpJobRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateDlpJobRequest() {
    parent_ = "";
    jobId_ = "";
    locationId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateDlpJobRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_CreateDlpJobRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_CreateDlpJobRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.CreateDlpJobRequest.class,
            com.google.privacy.dlp.v2.CreateDlpJobRequest.Builder.class);
  }

  private int jobCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object job_;

  public enum JobCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INSPECT_JOB(2),
    RISK_JOB(3),
    JOB_NOT_SET(0);
    private final int value;

    private JobCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static JobCase valueOf(int value) {
      return forNumber(value);
    }

    public static JobCase forNumber(int value) {
      switch (value) {
        case 2:
          return INSPECT_JOB;
        case 3:
          return RISK_JOB;
        case 0:
          return JOB_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public JobCase getJobCase() {
    return JobCase.forNumber(jobCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. Parent resource name.
   *
   * The format of this value varies depending on whether you have [specified a
   * processing
   * location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
   *
   * + Projects scope, location specified:&lt;br/&gt;
   *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
   * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
   *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
   *
   * The following example `parent` string specifies a parent project with the
   * identifier `example-project`, and specifies the `europe-west3` location
   * for processing data:
   *
   *     parent=projects/example-project/locations/europe-west3
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Parent resource name.
   *
   * The format of this value varies depending on whether you have [specified a
   * processing
   * location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
   *
   * + Projects scope, location specified:&lt;br/&gt;
   *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
   * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
   *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
   *
   * The following example `parent` string specifies a parent project with the
   * identifier `example-project`, and specifies the `europe-west3` location
   * for processing data:
   *
   *     parent=projects/example-project/locations/europe-west3
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSPECT_JOB_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * An inspection job scans a storage repository for InfoTypes.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 2;</code>
   *
   * @return Whether the inspectJob field is set.
   */
  @java.lang.Override
  public boolean hasInspectJob() {
    return jobCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * An inspection job scans a storage repository for InfoTypes.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 2;</code>
   *
   * @return The inspectJob.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectJobConfig getInspectJob() {
    if (jobCase_ == 2) {
      return (com.google.privacy.dlp.v2.InspectJobConfig) job_;
    }
    return com.google.privacy.dlp.v2.InspectJobConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An inspection job scans a storage repository for InfoTypes.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectJobConfigOrBuilder getInspectJobOrBuilder() {
    if (jobCase_ == 2) {
      return (com.google.privacy.dlp.v2.InspectJobConfig) job_;
    }
    return com.google.privacy.dlp.v2.InspectJobConfig.getDefaultInstance();
  }

  public static final int RISK_JOB_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * A risk analysis job calculates re-identification risk metrics for a
   * BigQuery table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RiskAnalysisJobConfig risk_job = 3;</code>
   *
   * @return Whether the riskJob field is set.
   */
  @java.lang.Override
  public boolean hasRiskJob() {
    return jobCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * A risk analysis job calculates re-identification risk metrics for a
   * BigQuery table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RiskAnalysisJobConfig risk_job = 3;</code>
   *
   * @return The riskJob.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RiskAnalysisJobConfig getRiskJob() {
    if (jobCase_ == 3) {
      return (com.google.privacy.dlp.v2.RiskAnalysisJobConfig) job_;
    }
    return com.google.privacy.dlp.v2.RiskAnalysisJobConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A risk analysis job calculates re-identification risk metrics for a
   * BigQuery table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RiskAnalysisJobConfig risk_job = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RiskAnalysisJobConfigOrBuilder getRiskJobOrBuilder() {
    if (jobCase_ == 3) {
      return (com.google.privacy.dlp.v2.RiskAnalysisJobConfig) job_;
    }
    return com.google.privacy.dlp.v2.RiskAnalysisJobConfig.getDefaultInstance();
  }

  public static final int JOB_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object jobId_ = "";
  /**
   *
   *
   * <pre>
   * The job id can contain uppercase and lowercase letters,
   * numbers, and hyphens; that is, it must match the regular
   * expression: `[a-zA-Z&#92;d-_]+`. The maximum length is 100
   * characters. Can be empty to allow the system to generate one.
   * </pre>
   *
   * <code>string job_id = 4;</code>
   *
   * @return The jobId.
   */
  @java.lang.Override
  public java.lang.String getJobId() {
    java.lang.Object ref = jobId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      jobId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The job id can contain uppercase and lowercase letters,
   * numbers, and hyphens; that is, it must match the regular
   * expression: `[a-zA-Z&#92;d-_]+`. The maximum length is 100
   * characters. Can be empty to allow the system to generate one.
   * </pre>
   *
   * <code>string job_id = 4;</code>
   *
   * @return The bytes for jobId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getJobIdBytes() {
    java.lang.Object ref = jobId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      jobId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object locationId_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>string location_id = 5;</code>
   *
   * @return The locationId.
   */
  @java.lang.Override
  public java.lang.String getLocationId() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>string location_id = 5;</code>
   *
   * @return The bytes for locationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationIdBytes() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (jobCase_ == 2) {
      output.writeMessage(2, (com.google.privacy.dlp.v2.InspectJobConfig) job_);
    }
    if (jobCase_ == 3) {
      output.writeMessage(3, (com.google.privacy.dlp.v2.RiskAnalysisJobConfig) job_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, jobId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, locationId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (jobCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.privacy.dlp.v2.InspectJobConfig) job_);
    }
    if (jobCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.privacy.dlp.v2.RiskAnalysisJobConfig) job_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, jobId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, locationId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.CreateDlpJobRequest)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.CreateDlpJobRequest other =
        (com.google.privacy.dlp.v2.CreateDlpJobRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getJobId().equals(other.getJobId())) return false;
    if (!getLocationId().equals(other.getLocationId())) return false;
    if (!getJobCase().equals(other.getJobCase())) return false;
    switch (jobCase_) {
      case 2:
        if (!getInspectJob().equals(other.getInspectJob())) return false;
        break;
      case 3:
        if (!getRiskJob().equals(other.getRiskJob())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + JOB_ID_FIELD_NUMBER;
    hash = (53 * hash) + getJobId().hashCode();
    hash = (37 * hash) + LOCATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getLocationId().hashCode();
    switch (jobCase_) {
      case 2:
        hash = (37 * hash) + INSPECT_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getInspectJob().hashCode();
        break;
      case 3:
        hash = (37 * hash) + RISK_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getRiskJob().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.CreateDlpJobRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CreateDlpJobRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CreateDlpJobRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CreateDlpJobRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CreateDlpJobRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CreateDlpJobRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CreateDlpJobRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CreateDlpJobRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CreateDlpJobRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CreateDlpJobRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CreateDlpJobRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CreateDlpJobRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.CreateDlpJobRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for CreateDlpJobRequest. Used to initiate long running
   * jobs such as calculating risk metrics or inspecting Google Cloud
   * Storage.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.CreateDlpJobRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CreateDlpJobRequest)
      com.google.privacy.dlp.v2.CreateDlpJobRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CreateDlpJobRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CreateDlpJobRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.CreateDlpJobRequest.class,
              com.google.privacy.dlp.v2.CreateDlpJobRequest.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.CreateDlpJobRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      if (inspectJobBuilder_ != null) {
        inspectJobBuilder_.clear();
      }
      if (riskJobBuilder_ != null) {
        riskJobBuilder_.clear();
      }
      jobId_ = "";
      locationId_ = "";
      jobCase_ = 0;
      job_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CreateDlpJobRequest_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CreateDlpJobRequest getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.CreateDlpJobRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CreateDlpJobRequest build() {
      com.google.privacy.dlp.v2.CreateDlpJobRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CreateDlpJobRequest buildPartial() {
      com.google.privacy.dlp.v2.CreateDlpJobRequest result =
          new com.google.privacy.dlp.v2.CreateDlpJobRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.CreateDlpJobRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.jobId_ = jobId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.locationId_ = locationId_;
      }
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.CreateDlpJobRequest result) {
      result.jobCase_ = jobCase_;
      result.job_ = this.job_;
      if (jobCase_ == 2 && inspectJobBuilder_ != null) {
        result.job_ = inspectJobBuilder_.build();
      }
      if (jobCase_ == 3 && riskJobBuilder_ != null) {
        result.job_ = riskJobBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.CreateDlpJobRequest) {
        return mergeFrom((com.google.privacy.dlp.v2.CreateDlpJobRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.CreateDlpJobRequest other) {
      if (other == com.google.privacy.dlp.v2.CreateDlpJobRequest.getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getJobId().isEmpty()) {
        jobId_ = other.jobId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getLocationId().isEmpty()) {
        locationId_ = other.locationId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      switch (other.getJobCase()) {
        case INSPECT_JOB:
          {
            mergeInspectJob(other.getInspectJob());
            break;
          }
        case RISK_JOB:
          {
            mergeRiskJob(other.getRiskJob());
            break;
          }
        case JOB_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInspectJobFieldBuilder().getBuilder(), extensionRegistry);
                jobCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getRiskJobFieldBuilder().getBuilder(), extensionRegistry);
                jobCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                jobId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                locationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int jobCase_ = 0;
    private java.lang.Object job_;

    public JobCase getJobCase() {
      return JobCase.forNumber(jobCase_);
    }

    public Builder clearJob() {
      jobCase_ = 0;
      job_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Parent resource name.
     *
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     *
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Parent resource name.
     *
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     *
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Parent resource name.
     *
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     *
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Parent resource name.
     *
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     *
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Parent resource name.
     *
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     *
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectJobConfig,
            com.google.privacy.dlp.v2.InspectJobConfig.Builder,
            com.google.privacy.dlp.v2.InspectJobConfigOrBuilder>
        inspectJobBuilder_;
    /**
     *
     *
     * <pre>
     * An inspection job scans a storage repository for InfoTypes.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 2;</code>
     *
     * @return Whether the inspectJob field is set.
     */
    @java.lang.Override
    public boolean hasInspectJob() {
      return jobCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * An inspection job scans a storage repository for InfoTypes.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 2;</code>
     *
     * @return The inspectJob.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectJobConfig getInspectJob() {
      if (inspectJobBuilder_ == null) {
        if (jobCase_ == 2) {
          return (com.google.privacy.dlp.v2.InspectJobConfig) job_;
        }
        return com.google.privacy.dlp.v2.InspectJobConfig.getDefaultInstance();
      } else {
        if (jobCase_ == 2) {
          return inspectJobBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.InspectJobConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An inspection job scans a storage repository for InfoTypes.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 2;</code>
     */
    public Builder setInspectJob(com.google.privacy.dlp.v2.InspectJobConfig value) {
      if (inspectJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        job_ = value;
        onChanged();
      } else {
        inspectJobBuilder_.setMessage(value);
      }
      jobCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An inspection job scans a storage repository for InfoTypes.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 2;</code>
     */
    public Builder setInspectJob(
        com.google.privacy.dlp.v2.InspectJobConfig.Builder builderForValue) {
      if (inspectJobBuilder_ == null) {
        job_ = builderForValue.build();
        onChanged();
      } else {
        inspectJobBuilder_.setMessage(builderForValue.build());
      }
      jobCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An inspection job scans a storage repository for InfoTypes.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 2;</code>
     */
    public Builder mergeInspectJob(com.google.privacy.dlp.v2.InspectJobConfig value) {
      if (inspectJobBuilder_ == null) {
        if (jobCase_ == 2
            && job_ != com.google.privacy.dlp.v2.InspectJobConfig.getDefaultInstance()) {
          job_ =
              com.google.privacy.dlp.v2.InspectJobConfig.newBuilder(
                      (com.google.privacy.dlp.v2.InspectJobConfig) job_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          job_ = value;
        }
        onChanged();
      } else {
        if (jobCase_ == 2) {
          inspectJobBuilder_.mergeFrom(value);
        } else {
          inspectJobBuilder_.setMessage(value);
        }
      }
      jobCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An inspection job scans a storage repository for InfoTypes.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 2;</code>
     */
    public Builder clearInspectJob() {
      if (inspectJobBuilder_ == null) {
        if (jobCase_ == 2) {
          jobCase_ = 0;
          job_ = null;
          onChanged();
        }
      } else {
        if (jobCase_ == 2) {
          jobCase_ = 0;
          job_ = null;
        }
        inspectJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An inspection job scans a storage repository for InfoTypes.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 2;</code>
     */
    public com.google.privacy.dlp.v2.InspectJobConfig.Builder getInspectJobBuilder() {
      return getInspectJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An inspection job scans a storage repository for InfoTypes.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectJobConfigOrBuilder getInspectJobOrBuilder() {
      if ((jobCase_ == 2) && (inspectJobBuilder_ != null)) {
        return inspectJobBuilder_.getMessageOrBuilder();
      } else {
        if (jobCase_ == 2) {
          return (com.google.privacy.dlp.v2.InspectJobConfig) job_;
        }
        return com.google.privacy.dlp.v2.InspectJobConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An inspection job scans a storage repository for InfoTypes.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectJobConfig,
            com.google.privacy.dlp.v2.InspectJobConfig.Builder,
            com.google.privacy.dlp.v2.InspectJobConfigOrBuilder>
        getInspectJobFieldBuilder() {
      if (inspectJobBuilder_ == null) {
        if (!(jobCase_ == 2)) {
          job_ = com.google.privacy.dlp.v2.InspectJobConfig.getDefaultInstance();
        }
        inspectJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InspectJobConfig,
                com.google.privacy.dlp.v2.InspectJobConfig.Builder,
                com.google.privacy.dlp.v2.InspectJobConfigOrBuilder>(
                (com.google.privacy.dlp.v2.InspectJobConfig) job_,
                getParentForChildren(),
                isClean());
        job_ = null;
      }
      jobCase_ = 2;
      onChanged();
      return inspectJobBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.RiskAnalysisJobConfig,
            com.google.privacy.dlp.v2.RiskAnalysisJobConfig.Builder,
            com.google.privacy.dlp.v2.RiskAnalysisJobConfigOrBuilder>
        riskJobBuilder_;
    /**
     *
     *
     * <pre>
     * A risk analysis job calculates re-identification risk metrics for a
     * BigQuery table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RiskAnalysisJobConfig risk_job = 3;</code>
     *
     * @return Whether the riskJob field is set.
     */
    @java.lang.Override
    public boolean hasRiskJob() {
      return jobCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * A risk analysis job calculates re-identification risk metrics for a
     * BigQuery table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RiskAnalysisJobConfig risk_job = 3;</code>
     *
     * @return The riskJob.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.RiskAnalysisJobConfig getRiskJob() {
      if (riskJobBuilder_ == null) {
        if (jobCase_ == 3) {
          return (com.google.privacy.dlp.v2.RiskAnalysisJobConfig) job_;
        }
        return com.google.privacy.dlp.v2.RiskAnalysisJobConfig.getDefaultInstance();
      } else {
        if (jobCase_ == 3) {
          return riskJobBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.RiskAnalysisJobConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A risk analysis job calculates re-identification risk metrics for a
     * BigQuery table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RiskAnalysisJobConfig risk_job = 3;</code>
     */
    public Builder setRiskJob(com.google.privacy.dlp.v2.RiskAnalysisJobConfig value) {
      if (riskJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        job_ = value;
        onChanged();
      } else {
        riskJobBuilder_.setMessage(value);
      }
      jobCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A risk analysis job calculates re-identification risk metrics for a
     * BigQuery table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RiskAnalysisJobConfig risk_job = 3;</code>
     */
    public Builder setRiskJob(
        com.google.privacy.dlp.v2.RiskAnalysisJobConfig.Builder builderForValue) {
      if (riskJobBuilder_ == null) {
        job_ = builderForValue.build();
        onChanged();
      } else {
        riskJobBuilder_.setMessage(builderForValue.build());
      }
      jobCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A risk analysis job calculates re-identification risk metrics for a
     * BigQuery table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RiskAnalysisJobConfig risk_job = 3;</code>
     */
    public Builder mergeRiskJob(com.google.privacy.dlp.v2.RiskAnalysisJobConfig value) {
      if (riskJobBuilder_ == null) {
        if (jobCase_ == 3
            && job_ != com.google.privacy.dlp.v2.RiskAnalysisJobConfig.getDefaultInstance()) {
          job_ =
              com.google.privacy.dlp.v2.RiskAnalysisJobConfig.newBuilder(
                      (com.google.privacy.dlp.v2.RiskAnalysisJobConfig) job_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          job_ = value;
        }
        onChanged();
      } else {
        if (jobCase_ == 3) {
          riskJobBuilder_.mergeFrom(value);
        } else {
          riskJobBuilder_.setMessage(value);
        }
      }
      jobCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A risk analysis job calculates re-identification risk metrics for a
     * BigQuery table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RiskAnalysisJobConfig risk_job = 3;</code>
     */
    public Builder clearRiskJob() {
      if (riskJobBuilder_ == null) {
        if (jobCase_ == 3) {
          jobCase_ = 0;
          job_ = null;
          onChanged();
        }
      } else {
        if (jobCase_ == 3) {
          jobCase_ = 0;
          job_ = null;
        }
        riskJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A risk analysis job calculates re-identification risk metrics for a
     * BigQuery table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RiskAnalysisJobConfig risk_job = 3;</code>
     */
    public com.google.privacy.dlp.v2.RiskAnalysisJobConfig.Builder getRiskJobBuilder() {
      return getRiskJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A risk analysis job calculates re-identification risk metrics for a
     * BigQuery table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RiskAnalysisJobConfig risk_job = 3;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.RiskAnalysisJobConfigOrBuilder getRiskJobOrBuilder() {
      if ((jobCase_ == 3) && (riskJobBuilder_ != null)) {
        return riskJobBuilder_.getMessageOrBuilder();
      } else {
        if (jobCase_ == 3) {
          return (com.google.privacy.dlp.v2.RiskAnalysisJobConfig) job_;
        }
        return com.google.privacy.dlp.v2.RiskAnalysisJobConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A risk analysis job calculates re-identification risk metrics for a
     * BigQuery table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RiskAnalysisJobConfig risk_job = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.RiskAnalysisJobConfig,
            com.google.privacy.dlp.v2.RiskAnalysisJobConfig.Builder,
            com.google.privacy.dlp.v2.RiskAnalysisJobConfigOrBuilder>
        getRiskJobFieldBuilder() {
      if (riskJobBuilder_ == null) {
        if (!(jobCase_ == 3)) {
          job_ = com.google.privacy.dlp.v2.RiskAnalysisJobConfig.getDefaultInstance();
        }
        riskJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.RiskAnalysisJobConfig,
                com.google.privacy.dlp.v2.RiskAnalysisJobConfig.Builder,
                com.google.privacy.dlp.v2.RiskAnalysisJobConfigOrBuilder>(
                (com.google.privacy.dlp.v2.RiskAnalysisJobConfig) job_,
                getParentForChildren(),
                isClean());
        job_ = null;
      }
      jobCase_ = 3;
      onChanged();
      return riskJobBuilder_;
    }

    private java.lang.Object jobId_ = "";
    /**
     *
     *
     * <pre>
     * The job id can contain uppercase and lowercase letters,
     * numbers, and hyphens; that is, it must match the regular
     * expression: `[a-zA-Z&#92;d-_]+`. The maximum length is 100
     * characters. Can be empty to allow the system to generate one.
     * </pre>
     *
     * <code>string job_id = 4;</code>
     *
     * @return The jobId.
     */
    public java.lang.String getJobId() {
      java.lang.Object ref = jobId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The job id can contain uppercase and lowercase letters,
     * numbers, and hyphens; that is, it must match the regular
     * expression: `[a-zA-Z&#92;d-_]+`. The maximum length is 100
     * characters. Can be empty to allow the system to generate one.
     * </pre>
     *
     * <code>string job_id = 4;</code>
     *
     * @return The bytes for jobId.
     */
    public com.google.protobuf.ByteString getJobIdBytes() {
      java.lang.Object ref = jobId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The job id can contain uppercase and lowercase letters,
     * numbers, and hyphens; that is, it must match the regular
     * expression: `[a-zA-Z&#92;d-_]+`. The maximum length is 100
     * characters. Can be empty to allow the system to generate one.
     * </pre>
     *
     * <code>string job_id = 4;</code>
     *
     * @param value The jobId to set.
     * @return This builder for chaining.
     */
    public Builder setJobId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      jobId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The job id can contain uppercase and lowercase letters,
     * numbers, and hyphens; that is, it must match the regular
     * expression: `[a-zA-Z&#92;d-_]+`. The maximum length is 100
     * characters. Can be empty to allow the system to generate one.
     * </pre>
     *
     * <code>string job_id = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobId() {
      jobId_ = getDefaultInstance().getJobId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The job id can contain uppercase and lowercase letters,
     * numbers, and hyphens; that is, it must match the regular
     * expression: `[a-zA-Z&#92;d-_]+`. The maximum length is 100
     * characters. Can be empty to allow the system to generate one.
     * </pre>
     *
     * <code>string job_id = 4;</code>
     *
     * @param value The bytes for jobId to set.
     * @return This builder for chaining.
     */
    public Builder setJobIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      jobId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object locationId_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 5;</code>
     *
     * @return The locationId.
     */
    public java.lang.String getLocationId() {
      java.lang.Object ref = locationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 5;</code>
     *
     * @return The bytes for locationId.
     */
    public com.google.protobuf.ByteString getLocationIdBytes() {
      java.lang.Object ref = locationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 5;</code>
     *
     * @param value The locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      locationId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationId() {
      locationId_ = getDefaultInstance().getLocationId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 5;</code>
     *
     * @param value The bytes for locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      locationId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CreateDlpJobRequest)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CreateDlpJobRequest)
  private static final com.google.privacy.dlp.v2.CreateDlpJobRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CreateDlpJobRequest();
  }

  public static com.google.privacy.dlp.v2.CreateDlpJobRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateDlpJobRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateDlpJobRequest>() {
        @java.lang.Override
        public CreateDlpJobRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateDlpJobRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateDlpJobRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.CreateDlpJobRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
