/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Replaces an identifier with a surrogate using Format Preserving Encryption
 * (FPE) with the FFX mode of operation; however when used in the
 * `ReidentifyContent` API method, it serves the opposite function by reversing
 * the surrogate back into the original identifier. The identifier must be
 * encoded as ASCII. For a given crypto key and context, the same identifier
 * will be replaced with the same surrogate. Identifiers must be at least two
 * characters long. In the case that the identifier is the empty string, it will
 * be skipped. See
 * https://cloud.google.com/sensitive-data-protection/docs/pseudonymization to
 * learn more.
 *
 * Note: We recommend using  CryptoDeterministicConfig for all use cases which
 * do not require preserving the input alphabet space and size, plus warrant
 * referential integrity.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig}
 */
public final class CryptoReplaceFfxFpeConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig)
    CryptoReplaceFfxFpeConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CryptoReplaceFfxFpeConfig.newBuilder() to construct.
  private CryptoReplaceFfxFpeConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CryptoReplaceFfxFpeConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CryptoReplaceFfxFpeConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_CryptoReplaceFfxFpeConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_CryptoReplaceFfxFpeConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.class,
            com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * These are commonly used subsets of the alphabet that the FFX mode
   * natively supports. In the algorithm, the alphabet is selected using
   * the "radix". Therefore each corresponds to a particular radix.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet}
   */
  public enum FfxCommonNativeAlphabet implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED = 0;</code>
     */
    FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * `[0-9]` (radix of 10)
     * </pre>
     *
     * <code>NUMERIC = 1;</code>
     */
    NUMERIC(1),
    /**
     *
     *
     * <pre>
     * `[0-9A-F]` (radix of 16)
     * </pre>
     *
     * <code>HEXADECIMAL = 2;</code>
     */
    HEXADECIMAL(2),
    /**
     *
     *
     * <pre>
     * `[0-9A-Z]` (radix of 36)
     * </pre>
     *
     * <code>UPPER_CASE_ALPHA_NUMERIC = 3;</code>
     */
    UPPER_CASE_ALPHA_NUMERIC(3),
    /**
     *
     *
     * <pre>
     * `[0-9A-Za-z]` (radix of 62)
     * </pre>
     *
     * <code>ALPHA_NUMERIC = 4;</code>
     */
    ALPHA_NUMERIC(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED = 0;</code>
     */
    public static final int FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * `[0-9]` (radix of 10)
     * </pre>
     *
     * <code>NUMERIC = 1;</code>
     */
    public static final int NUMERIC_VALUE = 1;
    /**
     *
     *
     * <pre>
     * `[0-9A-F]` (radix of 16)
     * </pre>
     *
     * <code>HEXADECIMAL = 2;</code>
     */
    public static final int HEXADECIMAL_VALUE = 2;
    /**
     *
     *
     * <pre>
     * `[0-9A-Z]` (radix of 36)
     * </pre>
     *
     * <code>UPPER_CASE_ALPHA_NUMERIC = 3;</code>
     */
    public static final int UPPER_CASE_ALPHA_NUMERIC_VALUE = 3;
    /**
     *
     *
     * <pre>
     * `[0-9A-Za-z]` (radix of 62)
     * </pre>
     *
     * <code>ALPHA_NUMERIC = 4;</code>
     */
    public static final int ALPHA_NUMERIC_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FfxCommonNativeAlphabet valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FfxCommonNativeAlphabet forNumber(int value) {
      switch (value) {
        case 0:
          return FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED;
        case 1:
          return NUMERIC;
        case 2:
          return HEXADECIMAL;
        case 3:
          return UPPER_CASE_ALPHA_NUMERIC;
        case 4:
          return ALPHA_NUMERIC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FfxCommonNativeAlphabet>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<FfxCommonNativeAlphabet>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<FfxCommonNativeAlphabet>() {
              public FfxCommonNativeAlphabet findValueByNumber(int number) {
                return FfxCommonNativeAlphabet.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final FfxCommonNativeAlphabet[] VALUES = values();

    public static FfxCommonNativeAlphabet valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FfxCommonNativeAlphabet(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet)
  }

  private int bitField0_;
  private int alphabetCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object alphabet_;

  public enum AlphabetCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    COMMON_ALPHABET(4),
    CUSTOM_ALPHABET(5),
    RADIX(6),
    ALPHABET_NOT_SET(0);
    private final int value;

    private AlphabetCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AlphabetCase valueOf(int value) {
      return forNumber(value);
    }

    public static AlphabetCase forNumber(int value) {
      switch (value) {
        case 4:
          return COMMON_ALPHABET;
        case 5:
          return CUSTOM_ALPHABET;
        case 6:
          return RADIX;
        case 0:
          return ALPHABET_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AlphabetCase getAlphabetCase() {
    return AlphabetCase.forNumber(alphabetCase_);
  }

  public static final int CRYPTO_KEY_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.CryptoKey cryptoKey_;
  /**
   *
   *
   * <pre>
   * Required. The key used by the encryption algorithm.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.CryptoKey crypto_key = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the cryptoKey field is set.
   */
  @java.lang.Override
  public boolean hasCryptoKey() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The key used by the encryption algorithm.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.CryptoKey crypto_key = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The cryptoKey.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CryptoKey getCryptoKey() {
    return cryptoKey_ == null
        ? com.google.privacy.dlp.v2.CryptoKey.getDefaultInstance()
        : cryptoKey_;
  }
  /**
   *
   *
   * <pre>
   * Required. The key used by the encryption algorithm.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.CryptoKey crypto_key = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CryptoKeyOrBuilder getCryptoKeyOrBuilder() {
    return cryptoKey_ == null
        ? com.google.privacy.dlp.v2.CryptoKey.getDefaultInstance()
        : cryptoKey_;
  }

  public static final int CONTEXT_FIELD_NUMBER = 2;
  private com.google.privacy.dlp.v2.FieldId context_;
  /**
   *
   *
   * <pre>
   * The 'tweak', a context may be used for higher security since the same
   * identifier in two different contexts won't be given the same surrogate. If
   * the context is not set, a default tweak will be used.
   *
   * If the context is set but:
   *
   * 1. there is no record present when transforming a given value or
   * 1. the field is not present when transforming a given value,
   *
   * a default tweak will be used.
   *
   * Note that case (1) is expected when an `InfoTypeTransformation` is
   * applied to both structured and unstructured `ContentItem`s.
   * Currently, the referenced field may be of value type integer or string.
   *
   * The tweak is constructed as a sequence of bytes in big endian byte order
   * such that:
   *
   * - a 64 bit integer is encoded followed by a single byte of value 1
   * - a string is encoded in UTF-8 format followed by a single byte of value 2
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.FieldId context = 2;</code>
   *
   * @return Whether the context field is set.
   */
  @java.lang.Override
  public boolean hasContext() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The 'tweak', a context may be used for higher security since the same
   * identifier in two different contexts won't be given the same surrogate. If
   * the context is not set, a default tweak will be used.
   *
   * If the context is set but:
   *
   * 1. there is no record present when transforming a given value or
   * 1. the field is not present when transforming a given value,
   *
   * a default tweak will be used.
   *
   * Note that case (1) is expected when an `InfoTypeTransformation` is
   * applied to both structured and unstructured `ContentItem`s.
   * Currently, the referenced field may be of value type integer or string.
   *
   * The tweak is constructed as a sequence of bytes in big endian byte order
   * such that:
   *
   * - a 64 bit integer is encoded followed by a single byte of value 1
   * - a string is encoded in UTF-8 format followed by a single byte of value 2
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.FieldId context = 2;</code>
   *
   * @return The context.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldId getContext() {
    return context_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : context_;
  }
  /**
   *
   *
   * <pre>
   * The 'tweak', a context may be used for higher security since the same
   * identifier in two different contexts won't be given the same surrogate. If
   * the context is not set, a default tweak will be used.
   *
   * If the context is set but:
   *
   * 1. there is no record present when transforming a given value or
   * 1. the field is not present when transforming a given value,
   *
   * a default tweak will be used.
   *
   * Note that case (1) is expected when an `InfoTypeTransformation` is
   * applied to both structured and unstructured `ContentItem`s.
   * Currently, the referenced field may be of value type integer or string.
   *
   * The tweak is constructed as a sequence of bytes in big endian byte order
   * such that:
   *
   * - a 64 bit integer is encoded followed by a single byte of value 1
   * - a string is encoded in UTF-8 format followed by a single byte of value 2
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.FieldId context = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldIdOrBuilder getContextOrBuilder() {
    return context_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : context_;
  }

  public static final int COMMON_ALPHABET_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Common alphabets.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet common_alphabet = 4;
   * </code>
   *
   * @return Whether the commonAlphabet field is set.
   */
  public boolean hasCommonAlphabet() {
    return alphabetCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Common alphabets.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet common_alphabet = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for commonAlphabet.
   */
  public int getCommonAlphabetValue() {
    if (alphabetCase_ == 4) {
      return (java.lang.Integer) alphabet_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * Common alphabets.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet common_alphabet = 4;
   * </code>
   *
   * @return The commonAlphabet.
   */
  public com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet
      getCommonAlphabet() {
    if (alphabetCase_ == 4) {
      com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet result =
          com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet.forNumber(
              (java.lang.Integer) alphabet_);
      return result == null
          ? com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet.UNRECOGNIZED
          : result;
    }
    return com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet
        .FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED;
  }

  public static final int CUSTOM_ALPHABET_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * This is supported by mapping these to the alphanumeric characters
   * that the FFX mode natively supports. This happens before/after
   * encryption/decryption.
   * Each character listed must appear only once.
   * Number of characters must be in the range [2, 95].
   * This must be encoded as ASCII.
   * The order of characters does not matter.
   * The full list of allowed characters is:
   * &lt;code&gt;0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz
   * ~`!&#64;#$%^&amp;*()_-+={[}]|&#92;:;"'&lt;,&gt;.?/&lt;/code&gt;
   * </pre>
   *
   * <code>string custom_alphabet = 5;</code>
   *
   * @return Whether the customAlphabet field is set.
   */
  public boolean hasCustomAlphabet() {
    return alphabetCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * This is supported by mapping these to the alphanumeric characters
   * that the FFX mode natively supports. This happens before/after
   * encryption/decryption.
   * Each character listed must appear only once.
   * Number of characters must be in the range [2, 95].
   * This must be encoded as ASCII.
   * The order of characters does not matter.
   * The full list of allowed characters is:
   * &lt;code&gt;0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz
   * ~`!&#64;#$%^&amp;*()_-+={[}]|&#92;:;"'&lt;,&gt;.?/&lt;/code&gt;
   * </pre>
   *
   * <code>string custom_alphabet = 5;</code>
   *
   * @return The customAlphabet.
   */
  public java.lang.String getCustomAlphabet() {
    java.lang.Object ref = "";
    if (alphabetCase_ == 5) {
      ref = alphabet_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (alphabetCase_ == 5) {
        alphabet_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This is supported by mapping these to the alphanumeric characters
   * that the FFX mode natively supports. This happens before/after
   * encryption/decryption.
   * Each character listed must appear only once.
   * Number of characters must be in the range [2, 95].
   * This must be encoded as ASCII.
   * The order of characters does not matter.
   * The full list of allowed characters is:
   * &lt;code&gt;0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz
   * ~`!&#64;#$%^&amp;*()_-+={[}]|&#92;:;"'&lt;,&gt;.?/&lt;/code&gt;
   * </pre>
   *
   * <code>string custom_alphabet = 5;</code>
   *
   * @return The bytes for customAlphabet.
   */
  public com.google.protobuf.ByteString getCustomAlphabetBytes() {
    java.lang.Object ref = "";
    if (alphabetCase_ == 5) {
      ref = alphabet_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (alphabetCase_ == 5) {
        alphabet_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RADIX_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The native way to select the alphabet. Must be in the range [2, 95].
   * </pre>
   *
   * <code>int32 radix = 6;</code>
   *
   * @return Whether the radix field is set.
   */
  @java.lang.Override
  public boolean hasRadix() {
    return alphabetCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The native way to select the alphabet. Must be in the range [2, 95].
   * </pre>
   *
   * <code>int32 radix = 6;</code>
   *
   * @return The radix.
   */
  @java.lang.Override
  public int getRadix() {
    if (alphabetCase_ == 6) {
      return (java.lang.Integer) alphabet_;
    }
    return 0;
  }

  public static final int SURROGATE_INFO_TYPE_FIELD_NUMBER = 8;
  private com.google.privacy.dlp.v2.InfoType surrogateInfoType_;
  /**
   *
   *
   * <pre>
   * The custom infoType to annotate the surrogate with.
   * This annotation will be applied to the surrogate by prefixing it with
   * the name of the custom infoType followed by the number of
   * characters comprising the surrogate. The following scheme defines the
   * format: info_type_name(surrogate_character_count):surrogate
   *
   * For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and
   * the surrogate is 'abc', the full replacement value
   * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
   *
   * This annotation identifies the surrogate when inspecting content using the
   * custom infoType
   * [`SurrogateType`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/InspectConfig#surrogatetype).
   * This facilitates reversal of the surrogate when it occurs in free text.
   *
   * In order for inspection to work properly, the name of this infoType must
   * not occur naturally anywhere in your data; otherwise, inspection may
   * find a surrogate that does not correspond to an actual identifier.
   * Therefore, choose your custom infoType name carefully after considering
   * what your data looks like. One way to select a name that has a high chance
   * of yielding reliable detection is to include one or more unicode characters
   * that are highly improbable to exist in your data.
   * For example, assuming your data is entered from a regular ASCII keyboard,
   * the symbol with the hex code point 29DD might be used like so:
   * ⧝MY_TOKEN_TYPE
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 8;</code>
   *
   * @return Whether the surrogateInfoType field is set.
   */
  @java.lang.Override
  public boolean hasSurrogateInfoType() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The custom infoType to annotate the surrogate with.
   * This annotation will be applied to the surrogate by prefixing it with
   * the name of the custom infoType followed by the number of
   * characters comprising the surrogate. The following scheme defines the
   * format: info_type_name(surrogate_character_count):surrogate
   *
   * For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and
   * the surrogate is 'abc', the full replacement value
   * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
   *
   * This annotation identifies the surrogate when inspecting content using the
   * custom infoType
   * [`SurrogateType`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/InspectConfig#surrogatetype).
   * This facilitates reversal of the surrogate when it occurs in free text.
   *
   * In order for inspection to work properly, the name of this infoType must
   * not occur naturally anywhere in your data; otherwise, inspection may
   * find a surrogate that does not correspond to an actual identifier.
   * Therefore, choose your custom infoType name carefully after considering
   * what your data looks like. One way to select a name that has a high chance
   * of yielding reliable detection is to include one or more unicode characters
   * that are highly improbable to exist in your data.
   * For example, assuming your data is entered from a regular ASCII keyboard,
   * the symbol with the hex code point 29DD might be used like so:
   * ⧝MY_TOKEN_TYPE
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 8;</code>
   *
   * @return The surrogateInfoType.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoType getSurrogateInfoType() {
    return surrogateInfoType_ == null
        ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
        : surrogateInfoType_;
  }
  /**
   *
   *
   * <pre>
   * The custom infoType to annotate the surrogate with.
   * This annotation will be applied to the surrogate by prefixing it with
   * the name of the custom infoType followed by the number of
   * characters comprising the surrogate. The following scheme defines the
   * format: info_type_name(surrogate_character_count):surrogate
   *
   * For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and
   * the surrogate is 'abc', the full replacement value
   * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
   *
   * This annotation identifies the surrogate when inspecting content using the
   * custom infoType
   * [`SurrogateType`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/InspectConfig#surrogatetype).
   * This facilitates reversal of the surrogate when it occurs in free text.
   *
   * In order for inspection to work properly, the name of this infoType must
   * not occur naturally anywhere in your data; otherwise, inspection may
   * find a surrogate that does not correspond to an actual identifier.
   * Therefore, choose your custom infoType name carefully after considering
   * what your data looks like. One way to select a name that has a high chance
   * of yielding reliable detection is to include one or more unicode characters
   * that are highly improbable to exist in your data.
   * For example, assuming your data is entered from a regular ASCII keyboard,
   * the symbol with the hex code point 29DD might be used like so:
   * ⧝MY_TOKEN_TYPE
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 8;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeOrBuilder getSurrogateInfoTypeOrBuilder() {
    return surrogateInfoType_ == null
        ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
        : surrogateInfoType_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getCryptoKey());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getContext());
    }
    if (alphabetCase_ == 4) {
      output.writeEnum(4, ((java.lang.Integer) alphabet_));
    }
    if (alphabetCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, alphabet_);
    }
    if (alphabetCase_ == 6) {
      output.writeInt32(6, (int) ((java.lang.Integer) alphabet_));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getSurrogateInfoType());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCryptoKey());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getContext());
    }
    if (alphabetCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(4, ((java.lang.Integer) alphabet_));
    }
    if (alphabetCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, alphabet_);
    }
    if (alphabetCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              6, (int) ((java.lang.Integer) alphabet_));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSurrogateInfoType());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig other =
        (com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig) obj;

    if (hasCryptoKey() != other.hasCryptoKey()) return false;
    if (hasCryptoKey()) {
      if (!getCryptoKey().equals(other.getCryptoKey())) return false;
    }
    if (hasContext() != other.hasContext()) return false;
    if (hasContext()) {
      if (!getContext().equals(other.getContext())) return false;
    }
    if (hasSurrogateInfoType() != other.hasSurrogateInfoType()) return false;
    if (hasSurrogateInfoType()) {
      if (!getSurrogateInfoType().equals(other.getSurrogateInfoType())) return false;
    }
    if (!getAlphabetCase().equals(other.getAlphabetCase())) return false;
    switch (alphabetCase_) {
      case 4:
        if (getCommonAlphabetValue() != other.getCommonAlphabetValue()) return false;
        break;
      case 5:
        if (!getCustomAlphabet().equals(other.getCustomAlphabet())) return false;
        break;
      case 6:
        if (getRadix() != other.getRadix()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCryptoKey()) {
      hash = (37 * hash) + CRYPTO_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getCryptoKey().hashCode();
    }
    if (hasContext()) {
      hash = (37 * hash) + CONTEXT_FIELD_NUMBER;
      hash = (53 * hash) + getContext().hashCode();
    }
    if (hasSurrogateInfoType()) {
      hash = (37 * hash) + SURROGATE_INFO_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getSurrogateInfoType().hashCode();
    }
    switch (alphabetCase_) {
      case 4:
        hash = (37 * hash) + COMMON_ALPHABET_FIELD_NUMBER;
        hash = (53 * hash) + getCommonAlphabetValue();
        break;
      case 5:
        hash = (37 * hash) + CUSTOM_ALPHABET_FIELD_NUMBER;
        hash = (53 * hash) + getCustomAlphabet().hashCode();
        break;
      case 6:
        hash = (37 * hash) + RADIX_FIELD_NUMBER;
        hash = (53 * hash) + getRadix();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Replaces an identifier with a surrogate using Format Preserving Encryption
   * (FPE) with the FFX mode of operation; however when used in the
   * `ReidentifyContent` API method, it serves the opposite function by reversing
   * the surrogate back into the original identifier. The identifier must be
   * encoded as ASCII. For a given crypto key and context, the same identifier
   * will be replaced with the same surrogate. Identifiers must be at least two
   * characters long. In the case that the identifier is the empty string, it will
   * be skipped. See
   * https://cloud.google.com/sensitive-data-protection/docs/pseudonymization to
   * learn more.
   *
   * Note: We recommend using  CryptoDeterministicConfig for all use cases which
   * do not require preserving the input alphabet space and size, plus warrant
   * referential integrity.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig)
      com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CryptoReplaceFfxFpeConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CryptoReplaceFfxFpeConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.class,
              com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCryptoKeyFieldBuilder();
        getContextFieldBuilder();
        getSurrogateInfoTypeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      cryptoKey_ = null;
      if (cryptoKeyBuilder_ != null) {
        cryptoKeyBuilder_.dispose();
        cryptoKeyBuilder_ = null;
      }
      context_ = null;
      if (contextBuilder_ != null) {
        contextBuilder_.dispose();
        contextBuilder_ = null;
      }
      surrogateInfoType_ = null;
      if (surrogateInfoTypeBuilder_ != null) {
        surrogateInfoTypeBuilder_.dispose();
        surrogateInfoTypeBuilder_ = null;
      }
      alphabetCase_ = 0;
      alphabet_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CryptoReplaceFfxFpeConfig_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig build() {
      com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig buildPartial() {
      com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig result =
          new com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.cryptoKey_ = cryptoKeyBuilder_ == null ? cryptoKey_ : cryptoKeyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.context_ = contextBuilder_ == null ? context_ : contextBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.surrogateInfoType_ =
            surrogateInfoTypeBuilder_ == null
                ? surrogateInfoType_
                : surrogateInfoTypeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig result) {
      result.alphabetCase_ = alphabetCase_;
      result.alphabet_ = this.alphabet_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig) {
        return mergeFrom((com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig other) {
      if (other == com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.getDefaultInstance())
        return this;
      if (other.hasCryptoKey()) {
        mergeCryptoKey(other.getCryptoKey());
      }
      if (other.hasContext()) {
        mergeContext(other.getContext());
      }
      if (other.hasSurrogateInfoType()) {
        mergeSurrogateInfoType(other.getSurrogateInfoType());
      }
      switch (other.getAlphabetCase()) {
        case COMMON_ALPHABET:
          {
            setCommonAlphabetValue(other.getCommonAlphabetValue());
            break;
          }
        case CUSTOM_ALPHABET:
          {
            alphabetCase_ = 5;
            alphabet_ = other.alphabet_;
            onChanged();
            break;
          }
        case RADIX:
          {
            setRadix(other.getRadix());
            break;
          }
        case ALPHABET_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCryptoKeyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getContextFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 32:
              {
                int rawValue = input.readEnum();
                alphabetCase_ = 4;
                alphabet_ = rawValue;
                break;
              } // case 32
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                alphabetCase_ = 5;
                alphabet_ = s;
                break;
              } // case 42
            case 48:
              {
                alphabet_ = input.readInt32();
                alphabetCase_ = 6;
                break;
              } // case 48
            case 66:
              {
                input.readMessage(
                    getSurrogateInfoTypeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int alphabetCase_ = 0;
    private java.lang.Object alphabet_;

    public AlphabetCase getAlphabetCase() {
      return AlphabetCase.forNumber(alphabetCase_);
    }

    public Builder clearAlphabet() {
      alphabetCase_ = 0;
      alphabet_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.CryptoKey cryptoKey_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CryptoKey,
            com.google.privacy.dlp.v2.CryptoKey.Builder,
            com.google.privacy.dlp.v2.CryptoKeyOrBuilder>
        cryptoKeyBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The key used by the encryption algorithm.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CryptoKey crypto_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the cryptoKey field is set.
     */
    public boolean hasCryptoKey() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The key used by the encryption algorithm.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CryptoKey crypto_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The cryptoKey.
     */
    public com.google.privacy.dlp.v2.CryptoKey getCryptoKey() {
      if (cryptoKeyBuilder_ == null) {
        return cryptoKey_ == null
            ? com.google.privacy.dlp.v2.CryptoKey.getDefaultInstance()
            : cryptoKey_;
      } else {
        return cryptoKeyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The key used by the encryption algorithm.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CryptoKey crypto_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setCryptoKey(com.google.privacy.dlp.v2.CryptoKey value) {
      if (cryptoKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cryptoKey_ = value;
      } else {
        cryptoKeyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The key used by the encryption algorithm.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CryptoKey crypto_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setCryptoKey(com.google.privacy.dlp.v2.CryptoKey.Builder builderForValue) {
      if (cryptoKeyBuilder_ == null) {
        cryptoKey_ = builderForValue.build();
      } else {
        cryptoKeyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The key used by the encryption algorithm.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CryptoKey crypto_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeCryptoKey(com.google.privacy.dlp.v2.CryptoKey value) {
      if (cryptoKeyBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && cryptoKey_ != null
            && cryptoKey_ != com.google.privacy.dlp.v2.CryptoKey.getDefaultInstance()) {
          getCryptoKeyBuilder().mergeFrom(value);
        } else {
          cryptoKey_ = value;
        }
      } else {
        cryptoKeyBuilder_.mergeFrom(value);
      }
      if (cryptoKey_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The key used by the encryption algorithm.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CryptoKey crypto_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearCryptoKey() {
      bitField0_ = (bitField0_ & ~0x00000001);
      cryptoKey_ = null;
      if (cryptoKeyBuilder_ != null) {
        cryptoKeyBuilder_.dispose();
        cryptoKeyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The key used by the encryption algorithm.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CryptoKey crypto_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.CryptoKey.Builder getCryptoKeyBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCryptoKeyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The key used by the encryption algorithm.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CryptoKey crypto_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.CryptoKeyOrBuilder getCryptoKeyOrBuilder() {
      if (cryptoKeyBuilder_ != null) {
        return cryptoKeyBuilder_.getMessageOrBuilder();
      } else {
        return cryptoKey_ == null
            ? com.google.privacy.dlp.v2.CryptoKey.getDefaultInstance()
            : cryptoKey_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The key used by the encryption algorithm.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CryptoKey crypto_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CryptoKey,
            com.google.privacy.dlp.v2.CryptoKey.Builder,
            com.google.privacy.dlp.v2.CryptoKeyOrBuilder>
        getCryptoKeyFieldBuilder() {
      if (cryptoKeyBuilder_ == null) {
        cryptoKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CryptoKey,
                com.google.privacy.dlp.v2.CryptoKey.Builder,
                com.google.privacy.dlp.v2.CryptoKeyOrBuilder>(
                getCryptoKey(), getParentForChildren(), isClean());
        cryptoKey_ = null;
      }
      return cryptoKeyBuilder_;
    }

    private com.google.privacy.dlp.v2.FieldId context_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        contextBuilder_;
    /**
     *
     *
     * <pre>
     * The 'tweak', a context may be used for higher security since the same
     * identifier in two different contexts won't be given the same surrogate. If
     * the context is not set, a default tweak will be used.
     *
     * If the context is set but:
     *
     * 1. there is no record present when transforming a given value or
     * 1. the field is not present when transforming a given value,
     *
     * a default tweak will be used.
     *
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * Currently, the referenced field may be of value type integer or string.
     *
     * The tweak is constructed as a sequence of bytes in big endian byte order
     * such that:
     *
     * - a 64 bit integer is encoded followed by a single byte of value 1
     * - a string is encoded in UTF-8 format followed by a single byte of value 2
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 2;</code>
     *
     * @return Whether the context field is set.
     */
    public boolean hasContext() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The 'tweak', a context may be used for higher security since the same
     * identifier in two different contexts won't be given the same surrogate. If
     * the context is not set, a default tweak will be used.
     *
     * If the context is set but:
     *
     * 1. there is no record present when transforming a given value or
     * 1. the field is not present when transforming a given value,
     *
     * a default tweak will be used.
     *
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * Currently, the referenced field may be of value type integer or string.
     *
     * The tweak is constructed as a sequence of bytes in big endian byte order
     * such that:
     *
     * - a 64 bit integer is encoded followed by a single byte of value 1
     * - a string is encoded in UTF-8 format followed by a single byte of value 2
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 2;</code>
     *
     * @return The context.
     */
    public com.google.privacy.dlp.v2.FieldId getContext() {
      if (contextBuilder_ == null) {
        return context_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : context_;
      } else {
        return contextBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The 'tweak', a context may be used for higher security since the same
     * identifier in two different contexts won't be given the same surrogate. If
     * the context is not set, a default tweak will be used.
     *
     * If the context is set but:
     *
     * 1. there is no record present when transforming a given value or
     * 1. the field is not present when transforming a given value,
     *
     * a default tweak will be used.
     *
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * Currently, the referenced field may be of value type integer or string.
     *
     * The tweak is constructed as a sequence of bytes in big endian byte order
     * such that:
     *
     * - a 64 bit integer is encoded followed by a single byte of value 1
     * - a string is encoded in UTF-8 format followed by a single byte of value 2
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 2;</code>
     */
    public Builder setContext(com.google.privacy.dlp.v2.FieldId value) {
      if (contextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        context_ = value;
      } else {
        contextBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The 'tweak', a context may be used for higher security since the same
     * identifier in two different contexts won't be given the same surrogate. If
     * the context is not set, a default tweak will be used.
     *
     * If the context is set but:
     *
     * 1. there is no record present when transforming a given value or
     * 1. the field is not present when transforming a given value,
     *
     * a default tweak will be used.
     *
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * Currently, the referenced field may be of value type integer or string.
     *
     * The tweak is constructed as a sequence of bytes in big endian byte order
     * such that:
     *
     * - a 64 bit integer is encoded followed by a single byte of value 1
     * - a string is encoded in UTF-8 format followed by a single byte of value 2
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 2;</code>
     */
    public Builder setContext(com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (contextBuilder_ == null) {
        context_ = builderForValue.build();
      } else {
        contextBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The 'tweak', a context may be used for higher security since the same
     * identifier in two different contexts won't be given the same surrogate. If
     * the context is not set, a default tweak will be used.
     *
     * If the context is set but:
     *
     * 1. there is no record present when transforming a given value or
     * 1. the field is not present when transforming a given value,
     *
     * a default tweak will be used.
     *
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * Currently, the referenced field may be of value type integer or string.
     *
     * The tweak is constructed as a sequence of bytes in big endian byte order
     * such that:
     *
     * - a 64 bit integer is encoded followed by a single byte of value 1
     * - a string is encoded in UTF-8 format followed by a single byte of value 2
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 2;</code>
     */
    public Builder mergeContext(com.google.privacy.dlp.v2.FieldId value) {
      if (contextBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && context_ != null
            && context_ != com.google.privacy.dlp.v2.FieldId.getDefaultInstance()) {
          getContextBuilder().mergeFrom(value);
        } else {
          context_ = value;
        }
      } else {
        contextBuilder_.mergeFrom(value);
      }
      if (context_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The 'tweak', a context may be used for higher security since the same
     * identifier in two different contexts won't be given the same surrogate. If
     * the context is not set, a default tweak will be used.
     *
     * If the context is set but:
     *
     * 1. there is no record present when transforming a given value or
     * 1. the field is not present when transforming a given value,
     *
     * a default tweak will be used.
     *
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * Currently, the referenced field may be of value type integer or string.
     *
     * The tweak is constructed as a sequence of bytes in big endian byte order
     * such that:
     *
     * - a 64 bit integer is encoded followed by a single byte of value 1
     * - a string is encoded in UTF-8 format followed by a single byte of value 2
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 2;</code>
     */
    public Builder clearContext() {
      bitField0_ = (bitField0_ & ~0x00000002);
      context_ = null;
      if (contextBuilder_ != null) {
        contextBuilder_.dispose();
        contextBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The 'tweak', a context may be used for higher security since the same
     * identifier in two different contexts won't be given the same surrogate. If
     * the context is not set, a default tweak will be used.
     *
     * If the context is set but:
     *
     * 1. there is no record present when transforming a given value or
     * 1. the field is not present when transforming a given value,
     *
     * a default tweak will be used.
     *
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * Currently, the referenced field may be of value type integer or string.
     *
     * The tweak is constructed as a sequence of bytes in big endian byte order
     * such that:
     *
     * - a 64 bit integer is encoded followed by a single byte of value 1
     * - a string is encoded in UTF-8 format followed by a single byte of value 2
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 2;</code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder getContextBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getContextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The 'tweak', a context may be used for higher security since the same
     * identifier in two different contexts won't be given the same surrogate. If
     * the context is not set, a default tweak will be used.
     *
     * If the context is set but:
     *
     * 1. there is no record present when transforming a given value or
     * 1. the field is not present when transforming a given value,
     *
     * a default tweak will be used.
     *
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * Currently, the referenced field may be of value type integer or string.
     *
     * The tweak is constructed as a sequence of bytes in big endian byte order
     * such that:
     *
     * - a 64 bit integer is encoded followed by a single byte of value 1
     * - a string is encoded in UTF-8 format followed by a single byte of value 2
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 2;</code>
     */
    public com.google.privacy.dlp.v2.FieldIdOrBuilder getContextOrBuilder() {
      if (contextBuilder_ != null) {
        return contextBuilder_.getMessageOrBuilder();
      } else {
        return context_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : context_;
      }
    }
    /**
     *
     *
     * <pre>
     * The 'tweak', a context may be used for higher security since the same
     * identifier in two different contexts won't be given the same surrogate. If
     * the context is not set, a default tweak will be used.
     *
     * If the context is set but:
     *
     * 1. there is no record present when transforming a given value or
     * 1. the field is not present when transforming a given value,
     *
     * a default tweak will be used.
     *
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * Currently, the referenced field may be of value type integer or string.
     *
     * The tweak is constructed as a sequence of bytes in big endian byte order
     * such that:
     *
     * - a 64 bit integer is encoded followed by a single byte of value 1
     * - a string is encoded in UTF-8 format followed by a single byte of value 2
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        getContextFieldBuilder() {
      if (contextBuilder_ == null) {
        contextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.FieldId,
                com.google.privacy.dlp.v2.FieldId.Builder,
                com.google.privacy.dlp.v2.FieldIdOrBuilder>(
                getContext(), getParentForChildren(), isClean());
        context_ = null;
      }
      return contextBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Common alphabets.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet common_alphabet = 4;
     * </code>
     *
     * @return Whether the commonAlphabet field is set.
     */
    @java.lang.Override
    public boolean hasCommonAlphabet() {
      return alphabetCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Common alphabets.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet common_alphabet = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for commonAlphabet.
     */
    @java.lang.Override
    public int getCommonAlphabetValue() {
      if (alphabetCase_ == 4) {
        return ((java.lang.Integer) alphabet_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Common alphabets.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet common_alphabet = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for commonAlphabet to set.
     * @return This builder for chaining.
     */
    public Builder setCommonAlphabetValue(int value) {
      alphabetCase_ = 4;
      alphabet_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common alphabets.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet common_alphabet = 4;
     * </code>
     *
     * @return The commonAlphabet.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet
        getCommonAlphabet() {
      if (alphabetCase_ == 4) {
        com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet result =
            com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet.forNumber(
                (java.lang.Integer) alphabet_);
        return result == null
            ? com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet
                .UNRECOGNIZED
            : result;
      }
      return com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet
          .FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * Common alphabets.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet common_alphabet = 4;
     * </code>
     *
     * @param value The commonAlphabet to set.
     * @return This builder for chaining.
     */
    public Builder setCommonAlphabet(
        com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet value) {
      if (value == null) {
        throw new NullPointerException();
      }
      alphabetCase_ = 4;
      alphabet_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common alphabets.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet common_alphabet = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCommonAlphabet() {
      if (alphabetCase_ == 4) {
        alphabetCase_ = 0;
        alphabet_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * This is supported by mapping these to the alphanumeric characters
     * that the FFX mode natively supports. This happens before/after
     * encryption/decryption.
     * Each character listed must appear only once.
     * Number of characters must be in the range [2, 95].
     * This must be encoded as ASCII.
     * The order of characters does not matter.
     * The full list of allowed characters is:
     * &lt;code&gt;0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz
     * ~`!&#64;#$%^&amp;*()_-+={[}]|&#92;:;"'&lt;,&gt;.?/&lt;/code&gt;
     * </pre>
     *
     * <code>string custom_alphabet = 5;</code>
     *
     * @return Whether the customAlphabet field is set.
     */
    @java.lang.Override
    public boolean hasCustomAlphabet() {
      return alphabetCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * This is supported by mapping these to the alphanumeric characters
     * that the FFX mode natively supports. This happens before/after
     * encryption/decryption.
     * Each character listed must appear only once.
     * Number of characters must be in the range [2, 95].
     * This must be encoded as ASCII.
     * The order of characters does not matter.
     * The full list of allowed characters is:
     * &lt;code&gt;0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz
     * ~`!&#64;#$%^&amp;*()_-+={[}]|&#92;:;"'&lt;,&gt;.?/&lt;/code&gt;
     * </pre>
     *
     * <code>string custom_alphabet = 5;</code>
     *
     * @return The customAlphabet.
     */
    @java.lang.Override
    public java.lang.String getCustomAlphabet() {
      java.lang.Object ref = "";
      if (alphabetCase_ == 5) {
        ref = alphabet_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (alphabetCase_ == 5) {
          alphabet_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This is supported by mapping these to the alphanumeric characters
     * that the FFX mode natively supports. This happens before/after
     * encryption/decryption.
     * Each character listed must appear only once.
     * Number of characters must be in the range [2, 95].
     * This must be encoded as ASCII.
     * The order of characters does not matter.
     * The full list of allowed characters is:
     * &lt;code&gt;0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz
     * ~`!&#64;#$%^&amp;*()_-+={[}]|&#92;:;"'&lt;,&gt;.?/&lt;/code&gt;
     * </pre>
     *
     * <code>string custom_alphabet = 5;</code>
     *
     * @return The bytes for customAlphabet.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCustomAlphabetBytes() {
      java.lang.Object ref = "";
      if (alphabetCase_ == 5) {
        ref = alphabet_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (alphabetCase_ == 5) {
          alphabet_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This is supported by mapping these to the alphanumeric characters
     * that the FFX mode natively supports. This happens before/after
     * encryption/decryption.
     * Each character listed must appear only once.
     * Number of characters must be in the range [2, 95].
     * This must be encoded as ASCII.
     * The order of characters does not matter.
     * The full list of allowed characters is:
     * &lt;code&gt;0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz
     * ~`!&#64;#$%^&amp;*()_-+={[}]|&#92;:;"'&lt;,&gt;.?/&lt;/code&gt;
     * </pre>
     *
     * <code>string custom_alphabet = 5;</code>
     *
     * @param value The customAlphabet to set.
     * @return This builder for chaining.
     */
    public Builder setCustomAlphabet(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      alphabetCase_ = 5;
      alphabet_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is supported by mapping these to the alphanumeric characters
     * that the FFX mode natively supports. This happens before/after
     * encryption/decryption.
     * Each character listed must appear only once.
     * Number of characters must be in the range [2, 95].
     * This must be encoded as ASCII.
     * The order of characters does not matter.
     * The full list of allowed characters is:
     * &lt;code&gt;0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz
     * ~`!&#64;#$%^&amp;*()_-+={[}]|&#92;:;"'&lt;,&gt;.?/&lt;/code&gt;
     * </pre>
     *
     * <code>string custom_alphabet = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomAlphabet() {
      if (alphabetCase_ == 5) {
        alphabetCase_ = 0;
        alphabet_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is supported by mapping these to the alphanumeric characters
     * that the FFX mode natively supports. This happens before/after
     * encryption/decryption.
     * Each character listed must appear only once.
     * Number of characters must be in the range [2, 95].
     * This must be encoded as ASCII.
     * The order of characters does not matter.
     * The full list of allowed characters is:
     * &lt;code&gt;0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz
     * ~`!&#64;#$%^&amp;*()_-+={[}]|&#92;:;"'&lt;,&gt;.?/&lt;/code&gt;
     * </pre>
     *
     * <code>string custom_alphabet = 5;</code>
     *
     * @param value The bytes for customAlphabet to set.
     * @return This builder for chaining.
     */
    public Builder setCustomAlphabetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      alphabetCase_ = 5;
      alphabet_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The native way to select the alphabet. Must be in the range [2, 95].
     * </pre>
     *
     * <code>int32 radix = 6;</code>
     *
     * @return Whether the radix field is set.
     */
    public boolean hasRadix() {
      return alphabetCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The native way to select the alphabet. Must be in the range [2, 95].
     * </pre>
     *
     * <code>int32 radix = 6;</code>
     *
     * @return The radix.
     */
    public int getRadix() {
      if (alphabetCase_ == 6) {
        return (java.lang.Integer) alphabet_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * The native way to select the alphabet. Must be in the range [2, 95].
     * </pre>
     *
     * <code>int32 radix = 6;</code>
     *
     * @param value The radix to set.
     * @return This builder for chaining.
     */
    public Builder setRadix(int value) {

      alphabetCase_ = 6;
      alphabet_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The native way to select the alphabet. Must be in the range [2, 95].
     * </pre>
     *
     * <code>int32 radix = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRadix() {
      if (alphabetCase_ == 6) {
        alphabetCase_ = 0;
        alphabet_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.privacy.dlp.v2.InfoType surrogateInfoType_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoType,
            com.google.privacy.dlp.v2.InfoType.Builder,
            com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        surrogateInfoTypeBuilder_;
    /**
     *
     *
     * <pre>
     * The custom infoType to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom infoType followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: info_type_name(surrogate_character_count):surrogate
     *
     * For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     *
     * This annotation identifies the surrogate when inspecting content using the
     * custom infoType
     * [`SurrogateType`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/InspectConfig#surrogatetype).
     * This facilitates reversal of the surrogate when it occurs in free text.
     *
     * In order for inspection to work properly, the name of this infoType must
     * not occur naturally anywhere in your data; otherwise, inspection may
     * find a surrogate that does not correspond to an actual identifier.
     * Therefore, choose your custom infoType name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 8;</code>
     *
     * @return Whether the surrogateInfoType field is set.
     */
    public boolean hasSurrogateInfoType() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The custom infoType to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom infoType followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: info_type_name(surrogate_character_count):surrogate
     *
     * For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     *
     * This annotation identifies the surrogate when inspecting content using the
     * custom infoType
     * [`SurrogateType`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/InspectConfig#surrogatetype).
     * This facilitates reversal of the surrogate when it occurs in free text.
     *
     * In order for inspection to work properly, the name of this infoType must
     * not occur naturally anywhere in your data; otherwise, inspection may
     * find a surrogate that does not correspond to an actual identifier.
     * Therefore, choose your custom infoType name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 8;</code>
     *
     * @return The surrogateInfoType.
     */
    public com.google.privacy.dlp.v2.InfoType getSurrogateInfoType() {
      if (surrogateInfoTypeBuilder_ == null) {
        return surrogateInfoType_ == null
            ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
            : surrogateInfoType_;
      } else {
        return surrogateInfoTypeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The custom infoType to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom infoType followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: info_type_name(surrogate_character_count):surrogate
     *
     * For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     *
     * This annotation identifies the surrogate when inspecting content using the
     * custom infoType
     * [`SurrogateType`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/InspectConfig#surrogatetype).
     * This facilitates reversal of the surrogate when it occurs in free text.
     *
     * In order for inspection to work properly, the name of this infoType must
     * not occur naturally anywhere in your data; otherwise, inspection may
     * find a surrogate that does not correspond to an actual identifier.
     * Therefore, choose your custom infoType name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 8;</code>
     */
    public Builder setSurrogateInfoType(com.google.privacy.dlp.v2.InfoType value) {
      if (surrogateInfoTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        surrogateInfoType_ = value;
      } else {
        surrogateInfoTypeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom infoType to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom infoType followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: info_type_name(surrogate_character_count):surrogate
     *
     * For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     *
     * This annotation identifies the surrogate when inspecting content using the
     * custom infoType
     * [`SurrogateType`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/InspectConfig#surrogatetype).
     * This facilitates reversal of the surrogate when it occurs in free text.
     *
     * In order for inspection to work properly, the name of this infoType must
     * not occur naturally anywhere in your data; otherwise, inspection may
     * find a surrogate that does not correspond to an actual identifier.
     * Therefore, choose your custom infoType name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 8;</code>
     */
    public Builder setSurrogateInfoType(
        com.google.privacy.dlp.v2.InfoType.Builder builderForValue) {
      if (surrogateInfoTypeBuilder_ == null) {
        surrogateInfoType_ = builderForValue.build();
      } else {
        surrogateInfoTypeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom infoType to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom infoType followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: info_type_name(surrogate_character_count):surrogate
     *
     * For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     *
     * This annotation identifies the surrogate when inspecting content using the
     * custom infoType
     * [`SurrogateType`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/InspectConfig#surrogatetype).
     * This facilitates reversal of the surrogate when it occurs in free text.
     *
     * In order for inspection to work properly, the name of this infoType must
     * not occur naturally anywhere in your data; otherwise, inspection may
     * find a surrogate that does not correspond to an actual identifier.
     * Therefore, choose your custom infoType name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 8;</code>
     */
    public Builder mergeSurrogateInfoType(com.google.privacy.dlp.v2.InfoType value) {
      if (surrogateInfoTypeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && surrogateInfoType_ != null
            && surrogateInfoType_ != com.google.privacy.dlp.v2.InfoType.getDefaultInstance()) {
          getSurrogateInfoTypeBuilder().mergeFrom(value);
        } else {
          surrogateInfoType_ = value;
        }
      } else {
        surrogateInfoTypeBuilder_.mergeFrom(value);
      }
      if (surrogateInfoType_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom infoType to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom infoType followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: info_type_name(surrogate_character_count):surrogate
     *
     * For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     *
     * This annotation identifies the surrogate when inspecting content using the
     * custom infoType
     * [`SurrogateType`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/InspectConfig#surrogatetype).
     * This facilitates reversal of the surrogate when it occurs in free text.
     *
     * In order for inspection to work properly, the name of this infoType must
     * not occur naturally anywhere in your data; otherwise, inspection may
     * find a surrogate that does not correspond to an actual identifier.
     * Therefore, choose your custom infoType name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 8;</code>
     */
    public Builder clearSurrogateInfoType() {
      bitField0_ = (bitField0_ & ~0x00000020);
      surrogateInfoType_ = null;
      if (surrogateInfoTypeBuilder_ != null) {
        surrogateInfoTypeBuilder_.dispose();
        surrogateInfoTypeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom infoType to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom infoType followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: info_type_name(surrogate_character_count):surrogate
     *
     * For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     *
     * This annotation identifies the surrogate when inspecting content using the
     * custom infoType
     * [`SurrogateType`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/InspectConfig#surrogatetype).
     * This facilitates reversal of the surrogate when it occurs in free text.
     *
     * In order for inspection to work properly, the name of this infoType must
     * not occur naturally anywhere in your data; otherwise, inspection may
     * find a surrogate that does not correspond to an actual identifier.
     * Therefore, choose your custom infoType name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 8;</code>
     */
    public com.google.privacy.dlp.v2.InfoType.Builder getSurrogateInfoTypeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getSurrogateInfoTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The custom infoType to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom infoType followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: info_type_name(surrogate_character_count):surrogate
     *
     * For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     *
     * This annotation identifies the surrogate when inspecting content using the
     * custom infoType
     * [`SurrogateType`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/InspectConfig#surrogatetype).
     * This facilitates reversal of the surrogate when it occurs in free text.
     *
     * In order for inspection to work properly, the name of this infoType must
     * not occur naturally anywhere in your data; otherwise, inspection may
     * find a surrogate that does not correspond to an actual identifier.
     * Therefore, choose your custom infoType name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 8;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeOrBuilder getSurrogateInfoTypeOrBuilder() {
      if (surrogateInfoTypeBuilder_ != null) {
        return surrogateInfoTypeBuilder_.getMessageOrBuilder();
      } else {
        return surrogateInfoType_ == null
            ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
            : surrogateInfoType_;
      }
    }
    /**
     *
     *
     * <pre>
     * The custom infoType to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom infoType followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: info_type_name(surrogate_character_count):surrogate
     *
     * For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     *
     * This annotation identifies the surrogate when inspecting content using the
     * custom infoType
     * [`SurrogateType`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/InspectConfig#surrogatetype).
     * This facilitates reversal of the surrogate when it occurs in free text.
     *
     * In order for inspection to work properly, the name of this infoType must
     * not occur naturally anywhere in your data; otherwise, inspection may
     * find a surrogate that does not correspond to an actual identifier.
     * Therefore, choose your custom infoType name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoType,
            com.google.privacy.dlp.v2.InfoType.Builder,
            com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        getSurrogateInfoTypeFieldBuilder() {
      if (surrogateInfoTypeBuilder_ == null) {
        surrogateInfoTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InfoType,
                com.google.privacy.dlp.v2.InfoType.Builder,
                com.google.privacy.dlp.v2.InfoTypeOrBuilder>(
                getSurrogateInfoType(), getParentForChildren(), isClean());
        surrogateInfoType_ = null;
      }
      return surrogateInfoTypeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig)
  private static final com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig();
  }

  public static com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CryptoReplaceFfxFpeConfig> PARSER =
      new com.google.protobuf.AbstractParser<CryptoReplaceFfxFpeConfig>() {
        @java.lang.Override
        public CryptoReplaceFfxFpeConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CryptoReplaceFfxFpeConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CryptoReplaceFfxFpeConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
