/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/storage.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Custom information type provided by the user. Used to find domain-specific
 * sensitive information configurable to the data in question.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType}
 */
public final class CustomInfoType extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CustomInfoType)
    CustomInfoTypeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CustomInfoType.newBuilder() to construct.
  private CustomInfoType(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CustomInfoType() {
    likelihood_ = 0;
    detectionRules_ = java.util.Collections.emptyList();
    exclusionType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CustomInfoType();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpStorage
        .internal_static_google_privacy_dlp_v2_CustomInfoType_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpStorage
        .internal_static_google_privacy_dlp_v2_CustomInfoType_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.CustomInfoType.class,
            com.google.privacy.dlp.v2.CustomInfoType.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of exclusion rule.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.CustomInfoType.ExclusionType}
   */
  public enum ExclusionType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A finding of this custom info type will not be excluded from results.
     * </pre>
     *
     * <code>EXCLUSION_TYPE_UNSPECIFIED = 0;</code>
     */
    EXCLUSION_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A finding of this custom info type will be excluded from final results,
     * but can still affect rule execution.
     * </pre>
     *
     * <code>EXCLUSION_TYPE_EXCLUDE = 1;</code>
     */
    EXCLUSION_TYPE_EXCLUDE(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A finding of this custom info type will not be excluded from results.
     * </pre>
     *
     * <code>EXCLUSION_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int EXCLUSION_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A finding of this custom info type will be excluded from final results,
     * but can still affect rule execution.
     * </pre>
     *
     * <code>EXCLUSION_TYPE_EXCLUDE = 1;</code>
     */
    public static final int EXCLUSION_TYPE_EXCLUDE_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExclusionType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ExclusionType forNumber(int value) {
      switch (value) {
        case 0:
          return EXCLUSION_TYPE_UNSPECIFIED;
        case 1:
          return EXCLUSION_TYPE_EXCLUDE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ExclusionType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ExclusionType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ExclusionType>() {
          public ExclusionType findValueByNumber(int number) {
            return ExclusionType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.CustomInfoType.getDescriptor().getEnumTypes().get(0);
    }

    private static final ExclusionType[] VALUES = values();

    public static ExclusionType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ExclusionType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.CustomInfoType.ExclusionType)
  }

  public interface DictionaryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.CustomInfoType.Dictionary)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * List of words or phrases to search for.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList word_list = 1;</code>
     *
     * @return Whether the wordList field is set.
     */
    boolean hasWordList();
    /**
     *
     *
     * <pre>
     * List of words or phrases to search for.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList word_list = 1;</code>
     *
     * @return The wordList.
     */
    com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList getWordList();
    /**
     *
     *
     * <pre>
     * List of words or phrases to search for.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList word_list = 1;</code>
     */
    com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordListOrBuilder getWordListOrBuilder();

    /**
     *
     *
     * <pre>
     * Newline-delimited file of words in Cloud Storage. Only a single file
     * is accepted.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStoragePath cloud_storage_path = 3;</code>
     *
     * @return Whether the cloudStoragePath field is set.
     */
    boolean hasCloudStoragePath();
    /**
     *
     *
     * <pre>
     * Newline-delimited file of words in Cloud Storage. Only a single file
     * is accepted.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStoragePath cloud_storage_path = 3;</code>
     *
     * @return The cloudStoragePath.
     */
    com.google.privacy.dlp.v2.CloudStoragePath getCloudStoragePath();
    /**
     *
     *
     * <pre>
     * Newline-delimited file of words in Cloud Storage. Only a single file
     * is accepted.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStoragePath cloud_storage_path = 3;</code>
     */
    com.google.privacy.dlp.v2.CloudStoragePathOrBuilder getCloudStoragePathOrBuilder();

    com.google.privacy.dlp.v2.CustomInfoType.Dictionary.SourceCase getSourceCase();
  }
  /**
   *
   *
   * <pre>
   * Custom information type based on a dictionary of words or phrases. This can
   * be used to match sensitive information specific to the data, such as a list
   * of employee IDs or job titles.
   *
   * Dictionary words are case-insensitive and all characters other than letters
   * and digits in the unicode [Basic Multilingual
   * Plane](https://en.wikipedia.org/wiki/Plane_%28Unicode%29#Basic_Multilingual_Plane)
   * will be replaced with whitespace when scanning for matches, so the
   * dictionary phrase "Sam Johnson" will match all three phrases "sam johnson",
   * "Sam, Johnson", and "Sam (Johnson)". Additionally, the characters
   * surrounding any match must be of a different type than the adjacent
   * characters within the word, so letters must be next to non-letters and
   * digits next to non-digits. For example, the dictionary word "jen" will
   * match the first three letters of the text "jen123" but will return no
   * matches for "jennifer".
   *
   * Dictionary words containing a large number of characters that are not
   * letters or digits may result in unexpected findings because such characters
   * are treated as whitespace. The
   * [limits](https://cloud.google.com/sensitive-data-protection/limits) page
   * contains details about the size limits of dictionaries. For dictionaries
   * that do not fit within these constraints, consider using
   * `LargeCustomDictionaryConfig` in the `StoredInfoType` API.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType.Dictionary}
   */
  public static final class Dictionary extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CustomInfoType.Dictionary)
      DictionaryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Dictionary.newBuilder() to construct.
    private Dictionary(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Dictionary() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Dictionary();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CustomInfoType_Dictionary_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CustomInfoType_Dictionary_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.CustomInfoType.Dictionary.class,
              com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder.class);
    }

    public interface WordListOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Words or phrases defining the dictionary. The dictionary must contain
       * at least one phrase and every phrase must contain at least 2 characters
       * that are letters or digits. [required]
       * </pre>
       *
       * <code>repeated string words = 1;</code>
       *
       * @return A list containing the words.
       */
      java.util.List<java.lang.String> getWordsList();
      /**
       *
       *
       * <pre>
       * Words or phrases defining the dictionary. The dictionary must contain
       * at least one phrase and every phrase must contain at least 2 characters
       * that are letters or digits. [required]
       * </pre>
       *
       * <code>repeated string words = 1;</code>
       *
       * @return The count of words.
       */
      int getWordsCount();
      /**
       *
       *
       * <pre>
       * Words or phrases defining the dictionary. The dictionary must contain
       * at least one phrase and every phrase must contain at least 2 characters
       * that are letters or digits. [required]
       * </pre>
       *
       * <code>repeated string words = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The words at the given index.
       */
      java.lang.String getWords(int index);
      /**
       *
       *
       * <pre>
       * Words or phrases defining the dictionary. The dictionary must contain
       * at least one phrase and every phrase must contain at least 2 characters
       * that are letters or digits. [required]
       * </pre>
       *
       * <code>repeated string words = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the words at the given index.
       */
      com.google.protobuf.ByteString getWordsBytes(int index);
    }
    /**
     *
     *
     * <pre>
     * Message defining a list of words or phrases to search for in the data.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList}
     */
    public static final class WordList extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList)
        WordListOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use WordList.newBuilder() to construct.
      private WordList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private WordList() {
        words_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new WordList();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_Dictionary_WordList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_Dictionary_WordList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.class,
                com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.Builder.class);
      }

      public static final int WORDS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList words_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Words or phrases defining the dictionary. The dictionary must contain
       * at least one phrase and every phrase must contain at least 2 characters
       * that are letters or digits. [required]
       * </pre>
       *
       * <code>repeated string words = 1;</code>
       *
       * @return A list containing the words.
       */
      public com.google.protobuf.ProtocolStringList getWordsList() {
        return words_;
      }
      /**
       *
       *
       * <pre>
       * Words or phrases defining the dictionary. The dictionary must contain
       * at least one phrase and every phrase must contain at least 2 characters
       * that are letters or digits. [required]
       * </pre>
       *
       * <code>repeated string words = 1;</code>
       *
       * @return The count of words.
       */
      public int getWordsCount() {
        return words_.size();
      }
      /**
       *
       *
       * <pre>
       * Words or phrases defining the dictionary. The dictionary must contain
       * at least one phrase and every phrase must contain at least 2 characters
       * that are letters or digits. [required]
       * </pre>
       *
       * <code>repeated string words = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The words at the given index.
       */
      public java.lang.String getWords(int index) {
        return words_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Words or phrases defining the dictionary. The dictionary must contain
       * at least one phrase and every phrase must contain at least 2 characters
       * that are letters or digits. [required]
       * </pre>
       *
       * <code>repeated string words = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the words at the given index.
       */
      public com.google.protobuf.ByteString getWordsBytes(int index) {
        return words_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < words_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, words_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < words_.size(); i++) {
            dataSize += computeStringSizeNoTag(words_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getWordsList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList)) {
          return super.equals(obj);
        }
        com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList other =
            (com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList) obj;

        if (!getWordsList().equals(other.getWordsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getWordsCount() > 0) {
          hash = (37 * hash) + WORDS_FIELD_NUMBER;
          hash = (53 * hash) + getWordsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Message defining a list of words or phrases to search for in the data.
       * </pre>
       *
       * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList)
          com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordListOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.privacy.dlp.v2.DlpStorage
              .internal_static_google_privacy_dlp_v2_CustomInfoType_Dictionary_WordList_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.privacy.dlp.v2.DlpStorage
              .internal_static_google_privacy_dlp_v2_CustomInfoType_Dictionary_WordList_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.class,
                  com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.Builder.class);
        }

        // Construct using com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          words_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.privacy.dlp.v2.DlpStorage
              .internal_static_google_privacy_dlp_v2_CustomInfoType_Dictionary_WordList_descriptor;
        }

        @java.lang.Override
        public com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList
            getDefaultInstanceForType() {
          return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList build() {
          com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList buildPartial() {
          com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList result =
              new com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            words_.makeImmutable();
            result.words_ = words_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList) {
            return mergeFrom((com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList other) {
          if (other
              == com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.getDefaultInstance())
            return this;
          if (!other.words_.isEmpty()) {
            if (words_.isEmpty()) {
              words_ = other.words_;
              bitField0_ |= 0x00000001;
            } else {
              ensureWordsIsMutable();
              words_.addAll(other.words_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureWordsIsMutable();
                    words_.add(s);
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList words_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureWordsIsMutable() {
          if (!words_.isModifiable()) {
            words_ = new com.google.protobuf.LazyStringArrayList(words_);
          }
          bitField0_ |= 0x00000001;
        }
        /**
         *
         *
         * <pre>
         * Words or phrases defining the dictionary. The dictionary must contain
         * at least one phrase and every phrase must contain at least 2 characters
         * that are letters or digits. [required]
         * </pre>
         *
         * <code>repeated string words = 1;</code>
         *
         * @return A list containing the words.
         */
        public com.google.protobuf.ProtocolStringList getWordsList() {
          words_.makeImmutable();
          return words_;
        }
        /**
         *
         *
         * <pre>
         * Words or phrases defining the dictionary. The dictionary must contain
         * at least one phrase and every phrase must contain at least 2 characters
         * that are letters or digits. [required]
         * </pre>
         *
         * <code>repeated string words = 1;</code>
         *
         * @return The count of words.
         */
        public int getWordsCount() {
          return words_.size();
        }
        /**
         *
         *
         * <pre>
         * Words or phrases defining the dictionary. The dictionary must contain
         * at least one phrase and every phrase must contain at least 2 characters
         * that are letters or digits. [required]
         * </pre>
         *
         * <code>repeated string words = 1;</code>
         *
         * @param index The index of the element to return.
         * @return The words at the given index.
         */
        public java.lang.String getWords(int index) {
          return words_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Words or phrases defining the dictionary. The dictionary must contain
         * at least one phrase and every phrase must contain at least 2 characters
         * that are letters or digits. [required]
         * </pre>
         *
         * <code>repeated string words = 1;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the words at the given index.
         */
        public com.google.protobuf.ByteString getWordsBytes(int index) {
          return words_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Words or phrases defining the dictionary. The dictionary must contain
         * at least one phrase and every phrase must contain at least 2 characters
         * that are letters or digits. [required]
         * </pre>
         *
         * <code>repeated string words = 1;</code>
         *
         * @param index The index to set the value at.
         * @param value The words to set.
         * @return This builder for chaining.
         */
        public Builder setWords(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureWordsIsMutable();
          words_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Words or phrases defining the dictionary. The dictionary must contain
         * at least one phrase and every phrase must contain at least 2 characters
         * that are letters or digits. [required]
         * </pre>
         *
         * <code>repeated string words = 1;</code>
         *
         * @param value The words to add.
         * @return This builder for chaining.
         */
        public Builder addWords(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureWordsIsMutable();
          words_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Words or phrases defining the dictionary. The dictionary must contain
         * at least one phrase and every phrase must contain at least 2 characters
         * that are letters or digits. [required]
         * </pre>
         *
         * <code>repeated string words = 1;</code>
         *
         * @param values The words to add.
         * @return This builder for chaining.
         */
        public Builder addAllWords(java.lang.Iterable<java.lang.String> values) {
          ensureWordsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, words_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Words or phrases defining the dictionary. The dictionary must contain
         * at least one phrase and every phrase must contain at least 2 characters
         * that are letters or digits. [required]
         * </pre>
         *
         * <code>repeated string words = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearWords() {
          words_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Words or phrases defining the dictionary. The dictionary must contain
         * at least one phrase and every phrase must contain at least 2 characters
         * that are letters or digits. [required]
         * </pre>
         *
         * <code>repeated string words = 1;</code>
         *
         * @param value The bytes of the words to add.
         * @return This builder for chaining.
         */
        public Builder addWordsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureWordsIsMutable();
          words_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList)
      }

      // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList)
      private static final com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList();
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<WordList> PARSER =
          new com.google.protobuf.AbstractParser<WordList>() {
            @java.lang.Override
            public WordList parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<WordList> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<WordList> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int sourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object source_;

    public enum SourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      WORD_LIST(1),
      CLOUD_STORAGE_PATH(3),
      SOURCE_NOT_SET(0);
      private final int value;

      private SourceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static SourceCase forNumber(int value) {
        switch (value) {
          case 1:
            return WORD_LIST;
          case 3:
            return CLOUD_STORAGE_PATH;
          case 0:
            return SOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public static final int WORD_LIST_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * List of words or phrases to search for.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList word_list = 1;</code>
     *
     * @return Whether the wordList field is set.
     */
    @java.lang.Override
    public boolean hasWordList() {
      return sourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * List of words or phrases to search for.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList word_list = 1;</code>
     *
     * @return The wordList.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList getWordList() {
      if (sourceCase_ == 1) {
        return (com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList) source_;
      }
      return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * List of words or phrases to search for.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList word_list = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordListOrBuilder
        getWordListOrBuilder() {
      if (sourceCase_ == 1) {
        return (com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList) source_;
      }
      return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.getDefaultInstance();
    }

    public static final int CLOUD_STORAGE_PATH_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Newline-delimited file of words in Cloud Storage. Only a single file
     * is accepted.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStoragePath cloud_storage_path = 3;</code>
     *
     * @return Whether the cloudStoragePath field is set.
     */
    @java.lang.Override
    public boolean hasCloudStoragePath() {
      return sourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Newline-delimited file of words in Cloud Storage. Only a single file
     * is accepted.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStoragePath cloud_storage_path = 3;</code>
     *
     * @return The cloudStoragePath.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudStoragePath getCloudStoragePath() {
      if (sourceCase_ == 3) {
        return (com.google.privacy.dlp.v2.CloudStoragePath) source_;
      }
      return com.google.privacy.dlp.v2.CloudStoragePath.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Newline-delimited file of words in Cloud Storage. Only a single file
     * is accepted.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStoragePath cloud_storage_path = 3;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudStoragePathOrBuilder getCloudStoragePathOrBuilder() {
      if (sourceCase_ == 3) {
        return (com.google.privacy.dlp.v2.CloudStoragePath) source_;
      }
      return com.google.privacy.dlp.v2.CloudStoragePath.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (sourceCase_ == 1) {
        output.writeMessage(
            1, (com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList) source_);
      }
      if (sourceCase_ == 3) {
        output.writeMessage(3, (com.google.privacy.dlp.v2.CloudStoragePath) source_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (sourceCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList) source_);
      }
      if (sourceCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.privacy.dlp.v2.CloudStoragePath) source_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.CustomInfoType.Dictionary)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.CustomInfoType.Dictionary other =
          (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) obj;

      if (!getSourceCase().equals(other.getSourceCase())) return false;
      switch (sourceCase_) {
        case 1:
          if (!getWordList().equals(other.getWordList())) return false;
          break;
        case 3:
          if (!getCloudStoragePath().equals(other.getCloudStoragePath())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (sourceCase_) {
        case 1:
          hash = (37 * hash) + WORD_LIST_FIELD_NUMBER;
          hash = (53 * hash) + getWordList().hashCode();
          break;
        case 3:
          hash = (37 * hash) + CLOUD_STORAGE_PATH_FIELD_NUMBER;
          hash = (53 * hash) + getCloudStoragePath().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.CustomInfoType.Dictionary prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Custom information type based on a dictionary of words or phrases. This can
     * be used to match sensitive information specific to the data, such as a list
     * of employee IDs or job titles.
     *
     * Dictionary words are case-insensitive and all characters other than letters
     * and digits in the unicode [Basic Multilingual
     * Plane](https://en.wikipedia.org/wiki/Plane_%28Unicode%29#Basic_Multilingual_Plane)
     * will be replaced with whitespace when scanning for matches, so the
     * dictionary phrase "Sam Johnson" will match all three phrases "sam johnson",
     * "Sam, Johnson", and "Sam (Johnson)". Additionally, the characters
     * surrounding any match must be of a different type than the adjacent
     * characters within the word, so letters must be next to non-letters and
     * digits next to non-digits. For example, the dictionary word "jen" will
     * match the first three letters of the text "jen123" but will return no
     * matches for "jennifer".
     *
     * Dictionary words containing a large number of characters that are not
     * letters or digits may result in unexpected findings because such characters
     * are treated as whitespace. The
     * [limits](https://cloud.google.com/sensitive-data-protection/limits) page
     * contains details about the size limits of dictionaries. For dictionaries
     * that do not fit within these constraints, consider using
     * `LargeCustomDictionaryConfig` in the `StoredInfoType` API.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType.Dictionary}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CustomInfoType.Dictionary)
        com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_Dictionary_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_Dictionary_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.CustomInfoType.Dictionary.class,
                com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.CustomInfoType.Dictionary.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (wordListBuilder_ != null) {
          wordListBuilder_.clear();
        }
        if (cloudStoragePathBuilder_ != null) {
          cloudStoragePathBuilder_.clear();
        }
        sourceCase_ = 0;
        source_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_Dictionary_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.Dictionary getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.Dictionary build() {
        com.google.privacy.dlp.v2.CustomInfoType.Dictionary result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.Dictionary buildPartial() {
        com.google.privacy.dlp.v2.CustomInfoType.Dictionary result =
            new com.google.privacy.dlp.v2.CustomInfoType.Dictionary(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.privacy.dlp.v2.CustomInfoType.Dictionary result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(com.google.privacy.dlp.v2.CustomInfoType.Dictionary result) {
        result.sourceCase_ = sourceCase_;
        result.source_ = this.source_;
        if (sourceCase_ == 1 && wordListBuilder_ != null) {
          result.source_ = wordListBuilder_.build();
        }
        if (sourceCase_ == 3 && cloudStoragePathBuilder_ != null) {
          result.source_ = cloudStoragePathBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.CustomInfoType.Dictionary) {
          return mergeFrom((com.google.privacy.dlp.v2.CustomInfoType.Dictionary) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.CustomInfoType.Dictionary other) {
        if (other == com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance())
          return this;
        switch (other.getSourceCase()) {
          case WORD_LIST:
            {
              mergeWordList(other.getWordList());
              break;
            }
          case CLOUD_STORAGE_PATH:
            {
              mergeCloudStoragePath(other.getCloudStoragePath());
              break;
            }
          case SOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getWordListFieldBuilder().getBuilder(), extensionRegistry);
                  sourceCase_ = 1;
                  break;
                } // case 10
              case 26:
                {
                  input.readMessage(
                      getCloudStoragePathFieldBuilder().getBuilder(), extensionRegistry);
                  sourceCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int sourceCase_ = 0;
      private java.lang.Object source_;

      public SourceCase getSourceCase() {
        return SourceCase.forNumber(sourceCase_);
      }

      public Builder clearSource() {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList,
              com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.Builder,
              com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordListOrBuilder>
          wordListBuilder_;
      /**
       *
       *
       * <pre>
       * List of words or phrases to search for.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList word_list = 1;</code>
       *
       * @return Whether the wordList field is set.
       */
      @java.lang.Override
      public boolean hasWordList() {
        return sourceCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * List of words or phrases to search for.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList word_list = 1;</code>
       *
       * @return The wordList.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList getWordList() {
        if (wordListBuilder_ == null) {
          if (sourceCase_ == 1) {
            return (com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList) source_;
          }
          return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.getDefaultInstance();
        } else {
          if (sourceCase_ == 1) {
            return wordListBuilder_.getMessage();
          }
          return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * List of words or phrases to search for.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList word_list = 1;</code>
       */
      public Builder setWordList(
          com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList value) {
        if (wordListBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          wordListBuilder_.setMessage(value);
        }
        sourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of words or phrases to search for.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList word_list = 1;</code>
       */
      public Builder setWordList(
          com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.Builder builderForValue) {
        if (wordListBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          wordListBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of words or phrases to search for.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList word_list = 1;</code>
       */
      public Builder mergeWordList(
          com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList value) {
        if (wordListBuilder_ == null) {
          if (sourceCase_ == 1
              && source_
                  != com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList
                      .getDefaultInstance()) {
            source_ =
                com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.newBuilder(
                        (com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList) source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 1) {
            wordListBuilder_.mergeFrom(value);
          } else {
            wordListBuilder_.setMessage(value);
          }
        }
        sourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of words or phrases to search for.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList word_list = 1;</code>
       */
      public Builder clearWordList() {
        if (wordListBuilder_ == null) {
          if (sourceCase_ == 1) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 1) {
            sourceCase_ = 0;
            source_ = null;
          }
          wordListBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of words or phrases to search for.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList word_list = 1;</code>
       */
      public com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.Builder
          getWordListBuilder() {
        return getWordListFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * List of words or phrases to search for.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList word_list = 1;</code>
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordListOrBuilder
          getWordListOrBuilder() {
        if ((sourceCase_ == 1) && (wordListBuilder_ != null)) {
          return wordListBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 1) {
            return (com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList) source_;
          }
          return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * List of words or phrases to search for.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList word_list = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList,
              com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.Builder,
              com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordListOrBuilder>
          getWordListFieldBuilder() {
        if (wordListBuilder_ == null) {
          if (!(sourceCase_ == 1)) {
            source_ =
                com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.getDefaultInstance();
          }
          wordListBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList,
                  com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList.Builder,
                  com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordListOrBuilder>(
                  (com.google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList) source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 1;
        onChanged();
        return wordListBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.CloudStoragePath,
              com.google.privacy.dlp.v2.CloudStoragePath.Builder,
              com.google.privacy.dlp.v2.CloudStoragePathOrBuilder>
          cloudStoragePathBuilder_;
      /**
       *
       *
       * <pre>
       * Newline-delimited file of words in Cloud Storage. Only a single file
       * is accepted.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStoragePath cloud_storage_path = 3;</code>
       *
       * @return Whether the cloudStoragePath field is set.
       */
      @java.lang.Override
      public boolean hasCloudStoragePath() {
        return sourceCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Newline-delimited file of words in Cloud Storage. Only a single file
       * is accepted.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStoragePath cloud_storage_path = 3;</code>
       *
       * @return The cloudStoragePath.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.CloudStoragePath getCloudStoragePath() {
        if (cloudStoragePathBuilder_ == null) {
          if (sourceCase_ == 3) {
            return (com.google.privacy.dlp.v2.CloudStoragePath) source_;
          }
          return com.google.privacy.dlp.v2.CloudStoragePath.getDefaultInstance();
        } else {
          if (sourceCase_ == 3) {
            return cloudStoragePathBuilder_.getMessage();
          }
          return com.google.privacy.dlp.v2.CloudStoragePath.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Newline-delimited file of words in Cloud Storage. Only a single file
       * is accepted.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStoragePath cloud_storage_path = 3;</code>
       */
      public Builder setCloudStoragePath(com.google.privacy.dlp.v2.CloudStoragePath value) {
        if (cloudStoragePathBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          cloudStoragePathBuilder_.setMessage(value);
        }
        sourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Newline-delimited file of words in Cloud Storage. Only a single file
       * is accepted.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStoragePath cloud_storage_path = 3;</code>
       */
      public Builder setCloudStoragePath(
          com.google.privacy.dlp.v2.CloudStoragePath.Builder builderForValue) {
        if (cloudStoragePathBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          cloudStoragePathBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Newline-delimited file of words in Cloud Storage. Only a single file
       * is accepted.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStoragePath cloud_storage_path = 3;</code>
       */
      public Builder mergeCloudStoragePath(com.google.privacy.dlp.v2.CloudStoragePath value) {
        if (cloudStoragePathBuilder_ == null) {
          if (sourceCase_ == 3
              && source_ != com.google.privacy.dlp.v2.CloudStoragePath.getDefaultInstance()) {
            source_ =
                com.google.privacy.dlp.v2.CloudStoragePath.newBuilder(
                        (com.google.privacy.dlp.v2.CloudStoragePath) source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 3) {
            cloudStoragePathBuilder_.mergeFrom(value);
          } else {
            cloudStoragePathBuilder_.setMessage(value);
          }
        }
        sourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Newline-delimited file of words in Cloud Storage. Only a single file
       * is accepted.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStoragePath cloud_storage_path = 3;</code>
       */
      public Builder clearCloudStoragePath() {
        if (cloudStoragePathBuilder_ == null) {
          if (sourceCase_ == 3) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 3) {
            sourceCase_ = 0;
            source_ = null;
          }
          cloudStoragePathBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Newline-delimited file of words in Cloud Storage. Only a single file
       * is accepted.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStoragePath cloud_storage_path = 3;</code>
       */
      public com.google.privacy.dlp.v2.CloudStoragePath.Builder getCloudStoragePathBuilder() {
        return getCloudStoragePathFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Newline-delimited file of words in Cloud Storage. Only a single file
       * is accepted.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStoragePath cloud_storage_path = 3;</code>
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.CloudStoragePathOrBuilder getCloudStoragePathOrBuilder() {
        if ((sourceCase_ == 3) && (cloudStoragePathBuilder_ != null)) {
          return cloudStoragePathBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 3) {
            return (com.google.privacy.dlp.v2.CloudStoragePath) source_;
          }
          return com.google.privacy.dlp.v2.CloudStoragePath.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Newline-delimited file of words in Cloud Storage. Only a single file
       * is accepted.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStoragePath cloud_storage_path = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.CloudStoragePath,
              com.google.privacy.dlp.v2.CloudStoragePath.Builder,
              com.google.privacy.dlp.v2.CloudStoragePathOrBuilder>
          getCloudStoragePathFieldBuilder() {
        if (cloudStoragePathBuilder_ == null) {
          if (!(sourceCase_ == 3)) {
            source_ = com.google.privacy.dlp.v2.CloudStoragePath.getDefaultInstance();
          }
          cloudStoragePathBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.CloudStoragePath,
                  com.google.privacy.dlp.v2.CloudStoragePath.Builder,
                  com.google.privacy.dlp.v2.CloudStoragePathOrBuilder>(
                  (com.google.privacy.dlp.v2.CloudStoragePath) source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 3;
        onChanged();
        return cloudStoragePathBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CustomInfoType.Dictionary)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CustomInfoType.Dictionary)
    private static final com.google.privacy.dlp.v2.CustomInfoType.Dictionary DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CustomInfoType.Dictionary();
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Dictionary getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Dictionary> PARSER =
        new com.google.protobuf.AbstractParser<Dictionary>() {
          @java.lang.Override
          public Dictionary parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Dictionary> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Dictionary> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.Dictionary getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RegexOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.CustomInfoType.Regex)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Pattern defining the regular expression. Its syntax
     * (https://github.com/google/re2/wiki/Syntax) can be found under the
     * google/re2 repository on GitHub.
     * </pre>
     *
     * <code>string pattern = 1;</code>
     *
     * @return The pattern.
     */
    java.lang.String getPattern();
    /**
     *
     *
     * <pre>
     * Pattern defining the regular expression. Its syntax
     * (https://github.com/google/re2/wiki/Syntax) can be found under the
     * google/re2 repository on GitHub.
     * </pre>
     *
     * <code>string pattern = 1;</code>
     *
     * @return The bytes for pattern.
     */
    com.google.protobuf.ByteString getPatternBytes();

    /**
     *
     *
     * <pre>
     * The index of the submatch to extract as findings. When not
     * specified, the entire match is returned. No more than 3 may be included.
     * </pre>
     *
     * <code>repeated int32 group_indexes = 2;</code>
     *
     * @return A list containing the groupIndexes.
     */
    java.util.List<java.lang.Integer> getGroupIndexesList();
    /**
     *
     *
     * <pre>
     * The index of the submatch to extract as findings. When not
     * specified, the entire match is returned. No more than 3 may be included.
     * </pre>
     *
     * <code>repeated int32 group_indexes = 2;</code>
     *
     * @return The count of groupIndexes.
     */
    int getGroupIndexesCount();
    /**
     *
     *
     * <pre>
     * The index of the submatch to extract as findings. When not
     * specified, the entire match is returned. No more than 3 may be included.
     * </pre>
     *
     * <code>repeated int32 group_indexes = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The groupIndexes at the given index.
     */
    int getGroupIndexes(int index);
  }
  /**
   *
   *
   * <pre>
   * Message defining a custom regular expression.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType.Regex}
   */
  public static final class Regex extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CustomInfoType.Regex)
      RegexOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Regex.newBuilder() to construct.
    private Regex(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Regex() {
      pattern_ = "";
      groupIndexes_ = emptyIntList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Regex();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CustomInfoType_Regex_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CustomInfoType_Regex_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.CustomInfoType.Regex.class,
              com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder.class);
    }

    public static final int PATTERN_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object pattern_ = "";
    /**
     *
     *
     * <pre>
     * Pattern defining the regular expression. Its syntax
     * (https://github.com/google/re2/wiki/Syntax) can be found under the
     * google/re2 repository on GitHub.
     * </pre>
     *
     * <code>string pattern = 1;</code>
     *
     * @return The pattern.
     */
    @java.lang.Override
    public java.lang.String getPattern() {
      java.lang.Object ref = pattern_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pattern_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Pattern defining the regular expression. Its syntax
     * (https://github.com/google/re2/wiki/Syntax) can be found under the
     * google/re2 repository on GitHub.
     * </pre>
     *
     * <code>string pattern = 1;</code>
     *
     * @return The bytes for pattern.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPatternBytes() {
      java.lang.Object ref = pattern_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pattern_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GROUP_INDEXES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.Internal.IntList groupIndexes_ = emptyIntList();
    /**
     *
     *
     * <pre>
     * The index of the submatch to extract as findings. When not
     * specified, the entire match is returned. No more than 3 may be included.
     * </pre>
     *
     * <code>repeated int32 group_indexes = 2;</code>
     *
     * @return A list containing the groupIndexes.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getGroupIndexesList() {
      return groupIndexes_;
    }
    /**
     *
     *
     * <pre>
     * The index of the submatch to extract as findings. When not
     * specified, the entire match is returned. No more than 3 may be included.
     * </pre>
     *
     * <code>repeated int32 group_indexes = 2;</code>
     *
     * @return The count of groupIndexes.
     */
    public int getGroupIndexesCount() {
      return groupIndexes_.size();
    }
    /**
     *
     *
     * <pre>
     * The index of the submatch to extract as findings. When not
     * specified, the entire match is returned. No more than 3 may be included.
     * </pre>
     *
     * <code>repeated int32 group_indexes = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The groupIndexes at the given index.
     */
    public int getGroupIndexes(int index) {
      return groupIndexes_.getInt(index);
    }

    private int groupIndexesMemoizedSerializedSize = -1;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pattern_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pattern_);
      }
      if (getGroupIndexesList().size() > 0) {
        output.writeUInt32NoTag(18);
        output.writeUInt32NoTag(groupIndexesMemoizedSerializedSize);
      }
      for (int i = 0; i < groupIndexes_.size(); i++) {
        output.writeInt32NoTag(groupIndexes_.getInt(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pattern_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pattern_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < groupIndexes_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(groupIndexes_.getInt(i));
        }
        size += dataSize;
        if (!getGroupIndexesList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
        }
        groupIndexesMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.CustomInfoType.Regex)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.CustomInfoType.Regex other =
          (com.google.privacy.dlp.v2.CustomInfoType.Regex) obj;

      if (!getPattern().equals(other.getPattern())) return false;
      if (!getGroupIndexesList().equals(other.getGroupIndexesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PATTERN_FIELD_NUMBER;
      hash = (53 * hash) + getPattern().hashCode();
      if (getGroupIndexesCount() > 0) {
        hash = (37 * hash) + GROUP_INDEXES_FIELD_NUMBER;
        hash = (53 * hash) + getGroupIndexesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Regex parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Regex parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Regex parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Regex parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Regex parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Regex parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Regex parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Regex parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Regex parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Regex parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Regex parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Regex parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.privacy.dlp.v2.CustomInfoType.Regex prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Message defining a custom regular expression.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType.Regex}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CustomInfoType.Regex)
        com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_Regex_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_Regex_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.CustomInfoType.Regex.class,
                com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.CustomInfoType.Regex.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        pattern_ = "";
        groupIndexes_ = emptyIntList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_Regex_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.Regex getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.Regex build() {
        com.google.privacy.dlp.v2.CustomInfoType.Regex result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.Regex buildPartial() {
        com.google.privacy.dlp.v2.CustomInfoType.Regex result =
            new com.google.privacy.dlp.v2.CustomInfoType.Regex(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.privacy.dlp.v2.CustomInfoType.Regex result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.pattern_ = pattern_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          groupIndexes_.makeImmutable();
          result.groupIndexes_ = groupIndexes_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.CustomInfoType.Regex) {
          return mergeFrom((com.google.privacy.dlp.v2.CustomInfoType.Regex) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.CustomInfoType.Regex other) {
        if (other == com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance())
          return this;
        if (!other.getPattern().isEmpty()) {
          pattern_ = other.pattern_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.groupIndexes_.isEmpty()) {
          if (groupIndexes_.isEmpty()) {
            groupIndexes_ = other.groupIndexes_;
            groupIndexes_.makeImmutable();
            bitField0_ |= 0x00000002;
          } else {
            ensureGroupIndexesIsMutable();
            groupIndexes_.addAll(other.groupIndexes_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  pattern_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  int v = input.readInt32();
                  ensureGroupIndexesIsMutable();
                  groupIndexes_.addInt(v);
                  break;
                } // case 16
              case 18:
                {
                  int length = input.readRawVarint32();
                  int limit = input.pushLimit(length);
                  ensureGroupIndexesIsMutable();
                  while (input.getBytesUntilLimit() > 0) {
                    groupIndexes_.addInt(input.readInt32());
                  }
                  input.popLimit(limit);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object pattern_ = "";
      /**
       *
       *
       * <pre>
       * Pattern defining the regular expression. Its syntax
       * (https://github.com/google/re2/wiki/Syntax) can be found under the
       * google/re2 repository on GitHub.
       * </pre>
       *
       * <code>string pattern = 1;</code>
       *
       * @return The pattern.
       */
      public java.lang.String getPattern() {
        java.lang.Object ref = pattern_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pattern_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Pattern defining the regular expression. Its syntax
       * (https://github.com/google/re2/wiki/Syntax) can be found under the
       * google/re2 repository on GitHub.
       * </pre>
       *
       * <code>string pattern = 1;</code>
       *
       * @return The bytes for pattern.
       */
      public com.google.protobuf.ByteString getPatternBytes() {
        java.lang.Object ref = pattern_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pattern_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Pattern defining the regular expression. Its syntax
       * (https://github.com/google/re2/wiki/Syntax) can be found under the
       * google/re2 repository on GitHub.
       * </pre>
       *
       * <code>string pattern = 1;</code>
       *
       * @param value The pattern to set.
       * @return This builder for chaining.
       */
      public Builder setPattern(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        pattern_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pattern defining the regular expression. Its syntax
       * (https://github.com/google/re2/wiki/Syntax) can be found under the
       * google/re2 repository on GitHub.
       * </pre>
       *
       * <code>string pattern = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPattern() {
        pattern_ = getDefaultInstance().getPattern();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pattern defining the regular expression. Its syntax
       * (https://github.com/google/re2/wiki/Syntax) can be found under the
       * google/re2 repository on GitHub.
       * </pre>
       *
       * <code>string pattern = 1;</code>
       *
       * @param value The bytes for pattern to set.
       * @return This builder for chaining.
       */
      public Builder setPatternBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        pattern_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.Internal.IntList groupIndexes_ = emptyIntList();

      private void ensureGroupIndexesIsMutable() {
        if (!groupIndexes_.isModifiable()) {
          groupIndexes_ = makeMutableCopy(groupIndexes_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * The index of the submatch to extract as findings. When not
       * specified, the entire match is returned. No more than 3 may be included.
       * </pre>
       *
       * <code>repeated int32 group_indexes = 2;</code>
       *
       * @return A list containing the groupIndexes.
       */
      public java.util.List<java.lang.Integer> getGroupIndexesList() {
        groupIndexes_.makeImmutable();
        return groupIndexes_;
      }
      /**
       *
       *
       * <pre>
       * The index of the submatch to extract as findings. When not
       * specified, the entire match is returned. No more than 3 may be included.
       * </pre>
       *
       * <code>repeated int32 group_indexes = 2;</code>
       *
       * @return The count of groupIndexes.
       */
      public int getGroupIndexesCount() {
        return groupIndexes_.size();
      }
      /**
       *
       *
       * <pre>
       * The index of the submatch to extract as findings. When not
       * specified, the entire match is returned. No more than 3 may be included.
       * </pre>
       *
       * <code>repeated int32 group_indexes = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The groupIndexes at the given index.
       */
      public int getGroupIndexes(int index) {
        return groupIndexes_.getInt(index);
      }
      /**
       *
       *
       * <pre>
       * The index of the submatch to extract as findings. When not
       * specified, the entire match is returned. No more than 3 may be included.
       * </pre>
       *
       * <code>repeated int32 group_indexes = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The groupIndexes to set.
       * @return This builder for chaining.
       */
      public Builder setGroupIndexes(int index, int value) {

        ensureGroupIndexesIsMutable();
        groupIndexes_.setInt(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The index of the submatch to extract as findings. When not
       * specified, the entire match is returned. No more than 3 may be included.
       * </pre>
       *
       * <code>repeated int32 group_indexes = 2;</code>
       *
       * @param value The groupIndexes to add.
       * @return This builder for chaining.
       */
      public Builder addGroupIndexes(int value) {

        ensureGroupIndexesIsMutable();
        groupIndexes_.addInt(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The index of the submatch to extract as findings. When not
       * specified, the entire match is returned. No more than 3 may be included.
       * </pre>
       *
       * <code>repeated int32 group_indexes = 2;</code>
       *
       * @param values The groupIndexes to add.
       * @return This builder for chaining.
       */
      public Builder addAllGroupIndexes(java.lang.Iterable<? extends java.lang.Integer> values) {
        ensureGroupIndexesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, groupIndexes_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The index of the submatch to extract as findings. When not
       * specified, the entire match is returned. No more than 3 may be included.
       * </pre>
       *
       * <code>repeated int32 group_indexes = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGroupIndexes() {
        groupIndexes_ = emptyIntList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CustomInfoType.Regex)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CustomInfoType.Regex)
    private static final com.google.privacy.dlp.v2.CustomInfoType.Regex DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CustomInfoType.Regex();
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.Regex getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Regex> PARSER =
        new com.google.protobuf.AbstractParser<Regex>() {
          @java.lang.Override
          public Regex parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Regex> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Regex> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.Regex getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SurrogateTypeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.CustomInfoType.SurrogateType)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Message for detecting output from deidentification transformations
   * such as
   * [`CryptoReplaceFfxFpeConfig`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/organizations.deidentifyTemplates#cryptoreplaceffxfpeconfig).
   * These types of transformations are
   * those that perform pseudonymization, thereby producing a "surrogate" as
   * output. This should be used in conjunction with a field on the
   * transformation such as `surrogate_info_type`. This CustomInfoType does
   * not support the use of `detection_rules`.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType.SurrogateType}
   */
  public static final class SurrogateType extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CustomInfoType.SurrogateType)
      SurrogateTypeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SurrogateType.newBuilder() to construct.
    private SurrogateType(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SurrogateType() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SurrogateType();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CustomInfoType_SurrogateType_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CustomInfoType_SurrogateType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.class,
              com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.CustomInfoType.SurrogateType)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.CustomInfoType.SurrogateType other =
          (com.google.privacy.dlp.v2.CustomInfoType.SurrogateType) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.SurrogateType parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.SurrogateType parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.SurrogateType parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.SurrogateType parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.SurrogateType parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.SurrogateType parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.SurrogateType parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.SurrogateType parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.SurrogateType parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.SurrogateType parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.SurrogateType parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.SurrogateType parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.CustomInfoType.SurrogateType prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Message for detecting output from deidentification transformations
     * such as
     * [`CryptoReplaceFfxFpeConfig`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/organizations.deidentifyTemplates#cryptoreplaceffxfpeconfig).
     * These types of transformations are
     * those that perform pseudonymization, thereby producing a "surrogate" as
     * output. This should be used in conjunction with a field on the
     * transformation such as `surrogate_info_type`. This CustomInfoType does
     * not support the use of `detection_rules`.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType.SurrogateType}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CustomInfoType.SurrogateType)
        com.google.privacy.dlp.v2.CustomInfoType.SurrogateTypeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_SurrogateType_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_SurrogateType_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.class,
                com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_SurrogateType_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.SurrogateType getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.SurrogateType build() {
        com.google.privacy.dlp.v2.CustomInfoType.SurrogateType result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.SurrogateType buildPartial() {
        com.google.privacy.dlp.v2.CustomInfoType.SurrogateType result =
            new com.google.privacy.dlp.v2.CustomInfoType.SurrogateType(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.CustomInfoType.SurrogateType) {
          return mergeFrom((com.google.privacy.dlp.v2.CustomInfoType.SurrogateType) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.CustomInfoType.SurrogateType other) {
        if (other == com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CustomInfoType.SurrogateType)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CustomInfoType.SurrogateType)
    private static final com.google.privacy.dlp.v2.CustomInfoType.SurrogateType DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CustomInfoType.SurrogateType();
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.SurrogateType getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SurrogateType> PARSER =
        new com.google.protobuf.AbstractParser<SurrogateType>() {
          @java.lang.Override
          public SurrogateType parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SurrogateType> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SurrogateType> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.SurrogateType getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DetectionRuleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.CustomInfoType.DetectionRule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Hotword-based detection rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule hotword_rule = 1;
     * </code>
     *
     * @return Whether the hotwordRule field is set.
     */
    boolean hasHotwordRule();
    /**
     *
     *
     * <pre>
     * Hotword-based detection rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule hotword_rule = 1;
     * </code>
     *
     * @return The hotwordRule.
     */
    com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule getHotwordRule();
    /**
     *
     *
     * <pre>
     * Hotword-based detection rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule hotword_rule = 1;
     * </code>
     */
    com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRuleOrBuilder
        getHotwordRuleOrBuilder();

    com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.TypeCase getTypeCase();
  }
  /**
   *
   *
   * <pre>
   * Deprecated; use `InspectionRuleSet` instead. Rule for modifying a
   * `CustomInfoType` to alter behavior under certain circumstances, depending
   * on the specific details of the rule. Not supported for the `surrogate_type`
   * custom infoType.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType.DetectionRule}
   */
  public static final class DetectionRule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CustomInfoType.DetectionRule)
      DetectionRuleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DetectionRule.newBuilder() to construct.
    private DetectionRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DetectionRule() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DetectionRule();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.class,
              com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Builder.class);
    }

    public interface ProximityOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Number of characters before the finding to consider. For tabular data,
       * if you want to modify the likelihood of an entire column of findngs,
       * set this to 1. For more information, see
       * [Hotword example: Set the match likelihood of a table column]
       * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
       * </pre>
       *
       * <code>int32 window_before = 1;</code>
       *
       * @return The windowBefore.
       */
      int getWindowBefore();

      /**
       *
       *
       * <pre>
       * Number of characters after the finding to consider.
       * </pre>
       *
       * <code>int32 window_after = 2;</code>
       *
       * @return The windowAfter.
       */
      int getWindowAfter();
    }
    /**
     *
     *
     * <pre>
     * Message for specifying a window around a finding to apply a detection
     * rule.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity}
     */
    public static final class Proximity extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity)
        ProximityOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Proximity.newBuilder() to construct.
      private Proximity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Proximity() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Proximity();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_Proximity_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_Proximity_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity.class,
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity.Builder.class);
      }

      public static final int WINDOW_BEFORE_FIELD_NUMBER = 1;
      private int windowBefore_ = 0;
      /**
       *
       *
       * <pre>
       * Number of characters before the finding to consider. For tabular data,
       * if you want to modify the likelihood of an entire column of findngs,
       * set this to 1. For more information, see
       * [Hotword example: Set the match likelihood of a table column]
       * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
       * </pre>
       *
       * <code>int32 window_before = 1;</code>
       *
       * @return The windowBefore.
       */
      @java.lang.Override
      public int getWindowBefore() {
        return windowBefore_;
      }

      public static final int WINDOW_AFTER_FIELD_NUMBER = 2;
      private int windowAfter_ = 0;
      /**
       *
       *
       * <pre>
       * Number of characters after the finding to consider.
       * </pre>
       *
       * <code>int32 window_after = 2;</code>
       *
       * @return The windowAfter.
       */
      @java.lang.Override
      public int getWindowAfter() {
        return windowAfter_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (windowBefore_ != 0) {
          output.writeInt32(1, windowBefore_);
        }
        if (windowAfter_ != 0) {
          output.writeInt32(2, windowAfter_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (windowBefore_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, windowBefore_);
        }
        if (windowAfter_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, windowAfter_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity)) {
          return super.equals(obj);
        }
        com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity other =
            (com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity) obj;

        if (getWindowBefore() != other.getWindowBefore()) return false;
        if (getWindowAfter() != other.getWindowAfter()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + WINDOW_BEFORE_FIELD_NUMBER;
        hash = (53 * hash) + getWindowBefore();
        hash = (37 * hash) + WINDOW_AFTER_FIELD_NUMBER;
        hash = (53 * hash) + getWindowAfter();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Message for specifying a window around a finding to apply a detection
       * rule.
       * </pre>
       *
       * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity)
          com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.ProximityOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.privacy.dlp.v2.DlpStorage
              .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_Proximity_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.privacy.dlp.v2.DlpStorage
              .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_Proximity_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity.class,
                  com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity.Builder.class);
        }

        // Construct using
        // com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          windowBefore_ = 0;
          windowAfter_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.privacy.dlp.v2.DlpStorage
              .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_Proximity_descriptor;
        }

        @java.lang.Override
        public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity
            getDefaultInstanceForType() {
          return com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity build() {
          com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity buildPartial() {
          com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity result =
              new com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.windowBefore_ = windowBefore_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.windowAfter_ = windowAfter_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity) {
            return mergeFrom(
                (com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity other) {
          if (other
              == com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity
                  .getDefaultInstance()) return this;
          if (other.getWindowBefore() != 0) {
            setWindowBefore(other.getWindowBefore());
          }
          if (other.getWindowAfter() != 0) {
            setWindowAfter(other.getWindowAfter());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    windowBefore_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    windowAfter_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int windowBefore_;
        /**
         *
         *
         * <pre>
         * Number of characters before the finding to consider. For tabular data,
         * if you want to modify the likelihood of an entire column of findngs,
         * set this to 1. For more information, see
         * [Hotword example: Set the match likelihood of a table column]
         * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
         * </pre>
         *
         * <code>int32 window_before = 1;</code>
         *
         * @return The windowBefore.
         */
        @java.lang.Override
        public int getWindowBefore() {
          return windowBefore_;
        }
        /**
         *
         *
         * <pre>
         * Number of characters before the finding to consider. For tabular data,
         * if you want to modify the likelihood of an entire column of findngs,
         * set this to 1. For more information, see
         * [Hotword example: Set the match likelihood of a table column]
         * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
         * </pre>
         *
         * <code>int32 window_before = 1;</code>
         *
         * @param value The windowBefore to set.
         * @return This builder for chaining.
         */
        public Builder setWindowBefore(int value) {

          windowBefore_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of characters before the finding to consider. For tabular data,
         * if you want to modify the likelihood of an entire column of findngs,
         * set this to 1. For more information, see
         * [Hotword example: Set the match likelihood of a table column]
         * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
         * </pre>
         *
         * <code>int32 window_before = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearWindowBefore() {
          bitField0_ = (bitField0_ & ~0x00000001);
          windowBefore_ = 0;
          onChanged();
          return this;
        }

        private int windowAfter_;
        /**
         *
         *
         * <pre>
         * Number of characters after the finding to consider.
         * </pre>
         *
         * <code>int32 window_after = 2;</code>
         *
         * @return The windowAfter.
         */
        @java.lang.Override
        public int getWindowAfter() {
          return windowAfter_;
        }
        /**
         *
         *
         * <pre>
         * Number of characters after the finding to consider.
         * </pre>
         *
         * <code>int32 window_after = 2;</code>
         *
         * @param value The windowAfter to set.
         * @return This builder for chaining.
         */
        public Builder setWindowAfter(int value) {

          windowAfter_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of characters after the finding to consider.
         * </pre>
         *
         * <code>int32 window_after = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearWindowAfter() {
          bitField0_ = (bitField0_ & ~0x00000002);
          windowAfter_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity)
      }

      // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity)
      private static final com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity();
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Proximity> PARSER =
          new com.google.protobuf.AbstractParser<Proximity>() {
            @java.lang.Override
            public Proximity parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Proximity> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Proximity> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface LikelihoodAdjustmentOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Set the likelihood of a finding to a fixed value.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Likelihood fixed_likelihood = 1;</code>
       *
       * @return Whether the fixedLikelihood field is set.
       */
      boolean hasFixedLikelihood();
      /**
       *
       *
       * <pre>
       * Set the likelihood of a finding to a fixed value.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Likelihood fixed_likelihood = 1;</code>
       *
       * @return The enum numeric value on the wire for fixedLikelihood.
       */
      int getFixedLikelihoodValue();
      /**
       *
       *
       * <pre>
       * Set the likelihood of a finding to a fixed value.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Likelihood fixed_likelihood = 1;</code>
       *
       * @return The fixedLikelihood.
       */
      com.google.privacy.dlp.v2.Likelihood getFixedLikelihood();

      /**
       *
       *
       * <pre>
       * Increase or decrease the likelihood by the specified number of
       * levels. For example, if a finding would be `POSSIBLE` without the
       * detection rule and `relative_likelihood` is 1, then it is upgraded to
       * `LIKELY`, while a value of -1 would downgrade it to `UNLIKELY`.
       * Likelihood may never drop below `VERY_UNLIKELY` or exceed
       * `VERY_LIKELY`, so applying an adjustment of 1 followed by an
       * adjustment of -1 when base likelihood is `VERY_LIKELY` will result in
       * a final likelihood of `LIKELY`.
       * </pre>
       *
       * <code>int32 relative_likelihood = 2;</code>
       *
       * @return Whether the relativeLikelihood field is set.
       */
      boolean hasRelativeLikelihood();
      /**
       *
       *
       * <pre>
       * Increase or decrease the likelihood by the specified number of
       * levels. For example, if a finding would be `POSSIBLE` without the
       * detection rule and `relative_likelihood` is 1, then it is upgraded to
       * `LIKELY`, while a value of -1 would downgrade it to `UNLIKELY`.
       * Likelihood may never drop below `VERY_UNLIKELY` or exceed
       * `VERY_LIKELY`, so applying an adjustment of 1 followed by an
       * adjustment of -1 when base likelihood is `VERY_LIKELY` will result in
       * a final likelihood of `LIKELY`.
       * </pre>
       *
       * <code>int32 relative_likelihood = 2;</code>
       *
       * @return The relativeLikelihood.
       */
      int getRelativeLikelihood();

      com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment.AdjustmentCase
          getAdjustmentCase();
    }
    /**
     *
     *
     * <pre>
     * Message for specifying an adjustment to the likelihood of a finding as
     * part of a detection rule.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment}
     */
    public static final class LikelihoodAdjustment extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment)
        LikelihoodAdjustmentOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use LikelihoodAdjustment.newBuilder() to construct.
      private LikelihoodAdjustment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private LikelihoodAdjustment() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new LikelihoodAdjustment();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_LikelihoodAdjustment_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_LikelihoodAdjustment_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment.class,
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment.Builder
                    .class);
      }

      private int adjustmentCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object adjustment_;

      public enum AdjustmentCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        FIXED_LIKELIHOOD(1),
        RELATIVE_LIKELIHOOD(2),
        ADJUSTMENT_NOT_SET(0);
        private final int value;

        private AdjustmentCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static AdjustmentCase valueOf(int value) {
          return forNumber(value);
        }

        public static AdjustmentCase forNumber(int value) {
          switch (value) {
            case 1:
              return FIXED_LIKELIHOOD;
            case 2:
              return RELATIVE_LIKELIHOOD;
            case 0:
              return ADJUSTMENT_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public AdjustmentCase getAdjustmentCase() {
        return AdjustmentCase.forNumber(adjustmentCase_);
      }

      public static final int FIXED_LIKELIHOOD_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * Set the likelihood of a finding to a fixed value.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Likelihood fixed_likelihood = 1;</code>
       *
       * @return Whether the fixedLikelihood field is set.
       */
      public boolean hasFixedLikelihood() {
        return adjustmentCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Set the likelihood of a finding to a fixed value.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Likelihood fixed_likelihood = 1;</code>
       *
       * @return The enum numeric value on the wire for fixedLikelihood.
       */
      public int getFixedLikelihoodValue() {
        if (adjustmentCase_ == 1) {
          return (java.lang.Integer) adjustment_;
        }
        return 0;
      }
      /**
       *
       *
       * <pre>
       * Set the likelihood of a finding to a fixed value.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Likelihood fixed_likelihood = 1;</code>
       *
       * @return The fixedLikelihood.
       */
      public com.google.privacy.dlp.v2.Likelihood getFixedLikelihood() {
        if (adjustmentCase_ == 1) {
          com.google.privacy.dlp.v2.Likelihood result =
              com.google.privacy.dlp.v2.Likelihood.forNumber((java.lang.Integer) adjustment_);
          return result == null ? com.google.privacy.dlp.v2.Likelihood.UNRECOGNIZED : result;
        }
        return com.google.privacy.dlp.v2.Likelihood.LIKELIHOOD_UNSPECIFIED;
      }

      public static final int RELATIVE_LIKELIHOOD_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * Increase or decrease the likelihood by the specified number of
       * levels. For example, if a finding would be `POSSIBLE` without the
       * detection rule and `relative_likelihood` is 1, then it is upgraded to
       * `LIKELY`, while a value of -1 would downgrade it to `UNLIKELY`.
       * Likelihood may never drop below `VERY_UNLIKELY` or exceed
       * `VERY_LIKELY`, so applying an adjustment of 1 followed by an
       * adjustment of -1 when base likelihood is `VERY_LIKELY` will result in
       * a final likelihood of `LIKELY`.
       * </pre>
       *
       * <code>int32 relative_likelihood = 2;</code>
       *
       * @return Whether the relativeLikelihood field is set.
       */
      @java.lang.Override
      public boolean hasRelativeLikelihood() {
        return adjustmentCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Increase or decrease the likelihood by the specified number of
       * levels. For example, if a finding would be `POSSIBLE` without the
       * detection rule and `relative_likelihood` is 1, then it is upgraded to
       * `LIKELY`, while a value of -1 would downgrade it to `UNLIKELY`.
       * Likelihood may never drop below `VERY_UNLIKELY` or exceed
       * `VERY_LIKELY`, so applying an adjustment of 1 followed by an
       * adjustment of -1 when base likelihood is `VERY_LIKELY` will result in
       * a final likelihood of `LIKELY`.
       * </pre>
       *
       * <code>int32 relative_likelihood = 2;</code>
       *
       * @return The relativeLikelihood.
       */
      @java.lang.Override
      public int getRelativeLikelihood() {
        if (adjustmentCase_ == 2) {
          return (java.lang.Integer) adjustment_;
        }
        return 0;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (adjustmentCase_ == 1) {
          output.writeEnum(1, ((java.lang.Integer) adjustment_));
        }
        if (adjustmentCase_ == 2) {
          output.writeInt32(2, (int) ((java.lang.Integer) adjustment_));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (adjustmentCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeEnumSize(
                  1, ((java.lang.Integer) adjustment_));
        }
        if (adjustmentCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt32Size(
                  2, (int) ((java.lang.Integer) adjustment_));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment)) {
          return super.equals(obj);
        }
        com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment other =
            (com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment) obj;

        if (!getAdjustmentCase().equals(other.getAdjustmentCase())) return false;
        switch (adjustmentCase_) {
          case 1:
            if (getFixedLikelihoodValue() != other.getFixedLikelihoodValue()) return false;
            break;
          case 2:
            if (getRelativeLikelihood() != other.getRelativeLikelihood()) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (adjustmentCase_) {
          case 1:
            hash = (37 * hash) + FIXED_LIKELIHOOD_FIELD_NUMBER;
            hash = (53 * hash) + getFixedLikelihoodValue();
            break;
          case 2:
            hash = (37 * hash) + RELATIVE_LIKELIHOOD_FIELD_NUMBER;
            hash = (53 * hash) + getRelativeLikelihood();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Message for specifying an adjustment to the likelihood of a finding as
       * part of a detection rule.
       * </pre>
       *
       * Protobuf type {@code
       * google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment)
          com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustmentOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.privacy.dlp.v2.DlpStorage
              .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_LikelihoodAdjustment_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.privacy.dlp.v2.DlpStorage
              .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_LikelihoodAdjustment_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment.class,
                  com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
                      .Builder.class);
        }

        // Construct using
        // com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          adjustmentCase_ = 0;
          adjustment_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.privacy.dlp.v2.DlpStorage
              .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_LikelihoodAdjustment_descriptor;
        }

        @java.lang.Override
        public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
            getDefaultInstanceForType() {
          return com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment build() {
          com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
            buildPartial() {
          com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment result =
              new com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment result) {
          result.adjustmentCase_ = adjustmentCase_;
          result.adjustment_ = this.adjustment_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment) {
            return mergeFrom(
                (com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment other) {
          if (other
              == com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
                  .getDefaultInstance()) return this;
          switch (other.getAdjustmentCase()) {
            case FIXED_LIKELIHOOD:
              {
                setFixedLikelihoodValue(other.getFixedLikelihoodValue());
                break;
              }
            case RELATIVE_LIKELIHOOD:
              {
                setRelativeLikelihood(other.getRelativeLikelihood());
                break;
              }
            case ADJUSTMENT_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    int rawValue = input.readEnum();
                    adjustmentCase_ = 1;
                    adjustment_ = rawValue;
                    break;
                  } // case 8
                case 16:
                  {
                    adjustment_ = input.readInt32();
                    adjustmentCase_ = 2;
                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int adjustmentCase_ = 0;
        private java.lang.Object adjustment_;

        public AdjustmentCase getAdjustmentCase() {
          return AdjustmentCase.forNumber(adjustmentCase_);
        }

        public Builder clearAdjustment() {
          adjustmentCase_ = 0;
          adjustment_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        /**
         *
         *
         * <pre>
         * Set the likelihood of a finding to a fixed value.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.Likelihood fixed_likelihood = 1;</code>
         *
         * @return Whether the fixedLikelihood field is set.
         */
        @java.lang.Override
        public boolean hasFixedLikelihood() {
          return adjustmentCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * Set the likelihood of a finding to a fixed value.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.Likelihood fixed_likelihood = 1;</code>
         *
         * @return The enum numeric value on the wire for fixedLikelihood.
         */
        @java.lang.Override
        public int getFixedLikelihoodValue() {
          if (adjustmentCase_ == 1) {
            return ((java.lang.Integer) adjustment_).intValue();
          }
          return 0;
        }
        /**
         *
         *
         * <pre>
         * Set the likelihood of a finding to a fixed value.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.Likelihood fixed_likelihood = 1;</code>
         *
         * @param value The enum numeric value on the wire for fixedLikelihood to set.
         * @return This builder for chaining.
         */
        public Builder setFixedLikelihoodValue(int value) {
          adjustmentCase_ = 1;
          adjustment_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set the likelihood of a finding to a fixed value.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.Likelihood fixed_likelihood = 1;</code>
         *
         * @return The fixedLikelihood.
         */
        @java.lang.Override
        public com.google.privacy.dlp.v2.Likelihood getFixedLikelihood() {
          if (adjustmentCase_ == 1) {
            com.google.privacy.dlp.v2.Likelihood result =
                com.google.privacy.dlp.v2.Likelihood.forNumber((java.lang.Integer) adjustment_);
            return result == null ? com.google.privacy.dlp.v2.Likelihood.UNRECOGNIZED : result;
          }
          return com.google.privacy.dlp.v2.Likelihood.LIKELIHOOD_UNSPECIFIED;
        }
        /**
         *
         *
         * <pre>
         * Set the likelihood of a finding to a fixed value.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.Likelihood fixed_likelihood = 1;</code>
         *
         * @param value The fixedLikelihood to set.
         * @return This builder for chaining.
         */
        public Builder setFixedLikelihood(com.google.privacy.dlp.v2.Likelihood value) {
          if (value == null) {
            throw new NullPointerException();
          }
          adjustmentCase_ = 1;
          adjustment_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set the likelihood of a finding to a fixed value.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.Likelihood fixed_likelihood = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFixedLikelihood() {
          if (adjustmentCase_ == 1) {
            adjustmentCase_ = 0;
            adjustment_ = null;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Increase or decrease the likelihood by the specified number of
         * levels. For example, if a finding would be `POSSIBLE` without the
         * detection rule and `relative_likelihood` is 1, then it is upgraded to
         * `LIKELY`, while a value of -1 would downgrade it to `UNLIKELY`.
         * Likelihood may never drop below `VERY_UNLIKELY` or exceed
         * `VERY_LIKELY`, so applying an adjustment of 1 followed by an
         * adjustment of -1 when base likelihood is `VERY_LIKELY` will result in
         * a final likelihood of `LIKELY`.
         * </pre>
         *
         * <code>int32 relative_likelihood = 2;</code>
         *
         * @return Whether the relativeLikelihood field is set.
         */
        public boolean hasRelativeLikelihood() {
          return adjustmentCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * Increase or decrease the likelihood by the specified number of
         * levels. For example, if a finding would be `POSSIBLE` without the
         * detection rule and `relative_likelihood` is 1, then it is upgraded to
         * `LIKELY`, while a value of -1 would downgrade it to `UNLIKELY`.
         * Likelihood may never drop below `VERY_UNLIKELY` or exceed
         * `VERY_LIKELY`, so applying an adjustment of 1 followed by an
         * adjustment of -1 when base likelihood is `VERY_LIKELY` will result in
         * a final likelihood of `LIKELY`.
         * </pre>
         *
         * <code>int32 relative_likelihood = 2;</code>
         *
         * @return The relativeLikelihood.
         */
        public int getRelativeLikelihood() {
          if (adjustmentCase_ == 2) {
            return (java.lang.Integer) adjustment_;
          }
          return 0;
        }
        /**
         *
         *
         * <pre>
         * Increase or decrease the likelihood by the specified number of
         * levels. For example, if a finding would be `POSSIBLE` without the
         * detection rule and `relative_likelihood` is 1, then it is upgraded to
         * `LIKELY`, while a value of -1 would downgrade it to `UNLIKELY`.
         * Likelihood may never drop below `VERY_UNLIKELY` or exceed
         * `VERY_LIKELY`, so applying an adjustment of 1 followed by an
         * adjustment of -1 when base likelihood is `VERY_LIKELY` will result in
         * a final likelihood of `LIKELY`.
         * </pre>
         *
         * <code>int32 relative_likelihood = 2;</code>
         *
         * @param value The relativeLikelihood to set.
         * @return This builder for chaining.
         */
        public Builder setRelativeLikelihood(int value) {

          adjustmentCase_ = 2;
          adjustment_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Increase or decrease the likelihood by the specified number of
         * levels. For example, if a finding would be `POSSIBLE` without the
         * detection rule and `relative_likelihood` is 1, then it is upgraded to
         * `LIKELY`, while a value of -1 would downgrade it to `UNLIKELY`.
         * Likelihood may never drop below `VERY_UNLIKELY` or exceed
         * `VERY_LIKELY`, so applying an adjustment of 1 followed by an
         * adjustment of -1 when base likelihood is `VERY_LIKELY` will result in
         * a final likelihood of `LIKELY`.
         * </pre>
         *
         * <code>int32 relative_likelihood = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRelativeLikelihood() {
          if (adjustmentCase_ == 2) {
            adjustmentCase_ = 0;
            adjustment_ = null;
            onChanged();
          }
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment)
      }

      // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment)
      private static final com.google.privacy.dlp.v2.CustomInfoType.DetectionRule
              .LikelihoodAdjustment
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment();
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<LikelihoodAdjustment> PARSER =
          new com.google.protobuf.AbstractParser<LikelihoodAdjustment>() {
            @java.lang.Override
            public LikelihoodAdjustment parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<LikelihoodAdjustment> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<LikelihoodAdjustment> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface HotwordRuleOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Regular expression pattern defining what qualifies as a hotword.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.Regex hotword_regex = 1;</code>
       *
       * @return Whether the hotwordRegex field is set.
       */
      boolean hasHotwordRegex();
      /**
       *
       *
       * <pre>
       * Regular expression pattern defining what qualifies as a hotword.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.Regex hotword_regex = 1;</code>
       *
       * @return The hotwordRegex.
       */
      com.google.privacy.dlp.v2.CustomInfoType.Regex getHotwordRegex();
      /**
       *
       *
       * <pre>
       * Regular expression pattern defining what qualifies as a hotword.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.Regex hotword_regex = 1;</code>
       */
      com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder getHotwordRegexOrBuilder();

      /**
       *
       *
       * <pre>
       * Range of characters within which the entire hotword must reside.
       * The total length of the window cannot exceed 1000 characters.
       * The finding itself will be included in the window, so that hotwords can
       * be used to match substrings of the finding itself. Suppose you
       * want Cloud DLP to promote the likelihood of the phone number
       * regex "&#92;(&#92;d{3}&#92;) &#92;d{3}-&#92;d{4}" if the area code is known to be the
       * area code of a company's office. In this case, use the hotword regex
       * "&#92;(xxx&#92;)", where "xxx" is the area code in question.
       *
       * For tabular data, if you want to modify the likelihood of an entire
       * column of findngs, see
       * [Hotword example: Set the match likelihood of a table column]
       * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity = 2;</code>
       *
       * @return Whether the proximity field is set.
       */
      boolean hasProximity();
      /**
       *
       *
       * <pre>
       * Range of characters within which the entire hotword must reside.
       * The total length of the window cannot exceed 1000 characters.
       * The finding itself will be included in the window, so that hotwords can
       * be used to match substrings of the finding itself. Suppose you
       * want Cloud DLP to promote the likelihood of the phone number
       * regex "&#92;(&#92;d{3}&#92;) &#92;d{3}-&#92;d{4}" if the area code is known to be the
       * area code of a company's office. In this case, use the hotword regex
       * "&#92;(xxx&#92;)", where "xxx" is the area code in question.
       *
       * For tabular data, if you want to modify the likelihood of an entire
       * column of findngs, see
       * [Hotword example: Set the match likelihood of a table column]
       * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity = 2;</code>
       *
       * @return The proximity.
       */
      com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity getProximity();
      /**
       *
       *
       * <pre>
       * Range of characters within which the entire hotword must reside.
       * The total length of the window cannot exceed 1000 characters.
       * The finding itself will be included in the window, so that hotwords can
       * be used to match substrings of the finding itself. Suppose you
       * want Cloud DLP to promote the likelihood of the phone number
       * regex "&#92;(&#92;d{3}&#92;) &#92;d{3}-&#92;d{4}" if the area code is known to be the
       * area code of a company's office. In this case, use the hotword regex
       * "&#92;(xxx&#92;)", where "xxx" is the area code in question.
       *
       * For tabular data, if you want to modify the likelihood of an entire
       * column of findngs, see
       * [Hotword example: Set the match likelihood of a table column]
       * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity = 2;</code>
       */
      com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.ProximityOrBuilder
          getProximityOrBuilder();

      /**
       *
       *
       * <pre>
       * Likelihood adjustment to apply to all matching findings.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment likelihood_adjustment = 3;
       * </code>
       *
       * @return Whether the likelihoodAdjustment field is set.
       */
      boolean hasLikelihoodAdjustment();
      /**
       *
       *
       * <pre>
       * Likelihood adjustment to apply to all matching findings.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment likelihood_adjustment = 3;
       * </code>
       *
       * @return The likelihoodAdjustment.
       */
      com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          getLikelihoodAdjustment();
      /**
       *
       *
       * <pre>
       * Likelihood adjustment to apply to all matching findings.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment likelihood_adjustment = 3;
       * </code>
       */
      com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustmentOrBuilder
          getLikelihoodAdjustmentOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * The rule that adjusts the likelihood of findings within a certain
     * proximity of hotwords.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule}
     */
    public static final class HotwordRule extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule)
        HotwordRuleOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use HotwordRule.newBuilder() to construct.
      private HotwordRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private HotwordRule() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new HotwordRule();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_HotwordRule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_HotwordRule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule.class,
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule.Builder.class);
      }

      private int bitField0_;
      public static final int HOTWORD_REGEX_FIELD_NUMBER = 1;
      private com.google.privacy.dlp.v2.CustomInfoType.Regex hotwordRegex_;
      /**
       *
       *
       * <pre>
       * Regular expression pattern defining what qualifies as a hotword.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.Regex hotword_regex = 1;</code>
       *
       * @return Whether the hotwordRegex field is set.
       */
      @java.lang.Override
      public boolean hasHotwordRegex() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Regular expression pattern defining what qualifies as a hotword.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.Regex hotword_regex = 1;</code>
       *
       * @return The hotwordRegex.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.Regex getHotwordRegex() {
        return hotwordRegex_ == null
            ? com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance()
            : hotwordRegex_;
      }
      /**
       *
       *
       * <pre>
       * Regular expression pattern defining what qualifies as a hotword.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.Regex hotword_regex = 1;</code>
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder getHotwordRegexOrBuilder() {
        return hotwordRegex_ == null
            ? com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance()
            : hotwordRegex_;
      }

      public static final int PROXIMITY_FIELD_NUMBER = 2;
      private com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity_;
      /**
       *
       *
       * <pre>
       * Range of characters within which the entire hotword must reside.
       * The total length of the window cannot exceed 1000 characters.
       * The finding itself will be included in the window, so that hotwords can
       * be used to match substrings of the finding itself. Suppose you
       * want Cloud DLP to promote the likelihood of the phone number
       * regex "&#92;(&#92;d{3}&#92;) &#92;d{3}-&#92;d{4}" if the area code is known to be the
       * area code of a company's office. In this case, use the hotword regex
       * "&#92;(xxx&#92;)", where "xxx" is the area code in question.
       *
       * For tabular data, if you want to modify the likelihood of an entire
       * column of findngs, see
       * [Hotword example: Set the match likelihood of a table column]
       * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity = 2;</code>
       *
       * @return Whether the proximity field is set.
       */
      @java.lang.Override
      public boolean hasProximity() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Range of characters within which the entire hotword must reside.
       * The total length of the window cannot exceed 1000 characters.
       * The finding itself will be included in the window, so that hotwords can
       * be used to match substrings of the finding itself. Suppose you
       * want Cloud DLP to promote the likelihood of the phone number
       * regex "&#92;(&#92;d{3}&#92;) &#92;d{3}-&#92;d{4}" if the area code is known to be the
       * area code of a company's office. In this case, use the hotword regex
       * "&#92;(xxx&#92;)", where "xxx" is the area code in question.
       *
       * For tabular data, if you want to modify the likelihood of an entire
       * column of findngs, see
       * [Hotword example: Set the match likelihood of a table column]
       * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity = 2;</code>
       *
       * @return The proximity.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity getProximity() {
        return proximity_ == null
            ? com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity.getDefaultInstance()
            : proximity_;
      }
      /**
       *
       *
       * <pre>
       * Range of characters within which the entire hotword must reside.
       * The total length of the window cannot exceed 1000 characters.
       * The finding itself will be included in the window, so that hotwords can
       * be used to match substrings of the finding itself. Suppose you
       * want Cloud DLP to promote the likelihood of the phone number
       * regex "&#92;(&#92;d{3}&#92;) &#92;d{3}-&#92;d{4}" if the area code is known to be the
       * area code of a company's office. In this case, use the hotword regex
       * "&#92;(xxx&#92;)", where "xxx" is the area code in question.
       *
       * For tabular data, if you want to modify the likelihood of an entire
       * column of findngs, see
       * [Hotword example: Set the match likelihood of a table column]
       * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity = 2;</code>
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.ProximityOrBuilder
          getProximityOrBuilder() {
        return proximity_ == null
            ? com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity.getDefaultInstance()
            : proximity_;
      }

      public static final int LIKELIHOOD_ADJUSTMENT_FIELD_NUMBER = 3;
      private com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          likelihoodAdjustment_;
      /**
       *
       *
       * <pre>
       * Likelihood adjustment to apply to all matching findings.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment likelihood_adjustment = 3;
       * </code>
       *
       * @return Whether the likelihoodAdjustment field is set.
       */
      @java.lang.Override
      public boolean hasLikelihoodAdjustment() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Likelihood adjustment to apply to all matching findings.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment likelihood_adjustment = 3;
       * </code>
       *
       * @return The likelihoodAdjustment.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
          getLikelihoodAdjustment() {
        return likelihoodAdjustment_ == null
            ? com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
                .getDefaultInstance()
            : likelihoodAdjustment_;
      }
      /**
       *
       *
       * <pre>
       * Likelihood adjustment to apply to all matching findings.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment likelihood_adjustment = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustmentOrBuilder
          getLikelihoodAdjustmentOrBuilder() {
        return likelihoodAdjustment_ == null
            ? com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
                .getDefaultInstance()
            : likelihoodAdjustment_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getHotwordRegex());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getProximity());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeMessage(3, getLikelihoodAdjustment());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getHotwordRegex());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getProximity());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3, getLikelihoodAdjustment());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule)) {
          return super.equals(obj);
        }
        com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule other =
            (com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule) obj;

        if (hasHotwordRegex() != other.hasHotwordRegex()) return false;
        if (hasHotwordRegex()) {
          if (!getHotwordRegex().equals(other.getHotwordRegex())) return false;
        }
        if (hasProximity() != other.hasProximity()) return false;
        if (hasProximity()) {
          if (!getProximity().equals(other.getProximity())) return false;
        }
        if (hasLikelihoodAdjustment() != other.hasLikelihoodAdjustment()) return false;
        if (hasLikelihoodAdjustment()) {
          if (!getLikelihoodAdjustment().equals(other.getLikelihoodAdjustment())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasHotwordRegex()) {
          hash = (37 * hash) + HOTWORD_REGEX_FIELD_NUMBER;
          hash = (53 * hash) + getHotwordRegex().hashCode();
        }
        if (hasProximity()) {
          hash = (37 * hash) + PROXIMITY_FIELD_NUMBER;
          hash = (53 * hash) + getProximity().hashCode();
        }
        if (hasLikelihoodAdjustment()) {
          hash = (37 * hash) + LIKELIHOOD_ADJUSTMENT_FIELD_NUMBER;
          hash = (53 * hash) + getLikelihoodAdjustment().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The rule that adjusts the likelihood of findings within a certain
       * proximity of hotwords.
       * </pre>
       *
       * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule)
          com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRuleOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.privacy.dlp.v2.DlpStorage
              .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_HotwordRule_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.privacy.dlp.v2.DlpStorage
              .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_HotwordRule_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule.class,
                  com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule.Builder.class);
        }

        // Construct using
        // com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getHotwordRegexFieldBuilder();
            getProximityFieldBuilder();
            getLikelihoodAdjustmentFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          hotwordRegex_ = null;
          if (hotwordRegexBuilder_ != null) {
            hotwordRegexBuilder_.dispose();
            hotwordRegexBuilder_ = null;
          }
          proximity_ = null;
          if (proximityBuilder_ != null) {
            proximityBuilder_.dispose();
            proximityBuilder_ = null;
          }
          likelihoodAdjustment_ = null;
          if (likelihoodAdjustmentBuilder_ != null) {
            likelihoodAdjustmentBuilder_.dispose();
            likelihoodAdjustmentBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.privacy.dlp.v2.DlpStorage
              .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_HotwordRule_descriptor;
        }

        @java.lang.Override
        public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
            getDefaultInstanceForType() {
          return com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule build() {
          com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule buildPartial() {
          com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule result =
              new com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.hotwordRegex_ =
                hotwordRegexBuilder_ == null ? hotwordRegex_ : hotwordRegexBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.proximity_ = proximityBuilder_ == null ? proximity_ : proximityBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.likelihoodAdjustment_ =
                likelihoodAdjustmentBuilder_ == null
                    ? likelihoodAdjustment_
                    : likelihoodAdjustmentBuilder_.build();
            to_bitField0_ |= 0x00000004;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule) {
            return mergeFrom(
                (com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule other) {
          if (other
              == com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
                  .getDefaultInstance()) return this;
          if (other.hasHotwordRegex()) {
            mergeHotwordRegex(other.getHotwordRegex());
          }
          if (other.hasProximity()) {
            mergeProximity(other.getProximity());
          }
          if (other.hasLikelihoodAdjustment()) {
            mergeLikelihoodAdjustment(other.getLikelihoodAdjustment());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        getHotwordRegexFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getProximityFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(
                        getLikelihoodAdjustmentFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.privacy.dlp.v2.CustomInfoType.Regex hotwordRegex_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CustomInfoType.Regex,
                com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder,
                com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder>
            hotwordRegexBuilder_;
        /**
         *
         *
         * <pre>
         * Regular expression pattern defining what qualifies as a hotword.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.Regex hotword_regex = 1;</code>
         *
         * @return Whether the hotwordRegex field is set.
         */
        public boolean hasHotwordRegex() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Regular expression pattern defining what qualifies as a hotword.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.Regex hotword_regex = 1;</code>
         *
         * @return The hotwordRegex.
         */
        public com.google.privacy.dlp.v2.CustomInfoType.Regex getHotwordRegex() {
          if (hotwordRegexBuilder_ == null) {
            return hotwordRegex_ == null
                ? com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance()
                : hotwordRegex_;
          } else {
            return hotwordRegexBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Regular expression pattern defining what qualifies as a hotword.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.Regex hotword_regex = 1;</code>
         */
        public Builder setHotwordRegex(com.google.privacy.dlp.v2.CustomInfoType.Regex value) {
          if (hotwordRegexBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            hotwordRegex_ = value;
          } else {
            hotwordRegexBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Regular expression pattern defining what qualifies as a hotword.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.Regex hotword_regex = 1;</code>
         */
        public Builder setHotwordRegex(
            com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder builderForValue) {
          if (hotwordRegexBuilder_ == null) {
            hotwordRegex_ = builderForValue.build();
          } else {
            hotwordRegexBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Regular expression pattern defining what qualifies as a hotword.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.Regex hotword_regex = 1;</code>
         */
        public Builder mergeHotwordRegex(com.google.privacy.dlp.v2.CustomInfoType.Regex value) {
          if (hotwordRegexBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && hotwordRegex_ != null
                && hotwordRegex_
                    != com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance()) {
              getHotwordRegexBuilder().mergeFrom(value);
            } else {
              hotwordRegex_ = value;
            }
          } else {
            hotwordRegexBuilder_.mergeFrom(value);
          }
          if (hotwordRegex_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Regular expression pattern defining what qualifies as a hotword.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.Regex hotword_regex = 1;</code>
         */
        public Builder clearHotwordRegex() {
          bitField0_ = (bitField0_ & ~0x00000001);
          hotwordRegex_ = null;
          if (hotwordRegexBuilder_ != null) {
            hotwordRegexBuilder_.dispose();
            hotwordRegexBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Regular expression pattern defining what qualifies as a hotword.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.Regex hotword_regex = 1;</code>
         */
        public com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder getHotwordRegexBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getHotwordRegexFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Regular expression pattern defining what qualifies as a hotword.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.Regex hotword_regex = 1;</code>
         */
        public com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder getHotwordRegexOrBuilder() {
          if (hotwordRegexBuilder_ != null) {
            return hotwordRegexBuilder_.getMessageOrBuilder();
          } else {
            return hotwordRegex_ == null
                ? com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance()
                : hotwordRegex_;
          }
        }
        /**
         *
         *
         * <pre>
         * Regular expression pattern defining what qualifies as a hotword.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.Regex hotword_regex = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CustomInfoType.Regex,
                com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder,
                com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder>
            getHotwordRegexFieldBuilder() {
          if (hotwordRegexBuilder_ == null) {
            hotwordRegexBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.privacy.dlp.v2.CustomInfoType.Regex,
                    com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder,
                    com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder>(
                    getHotwordRegex(), getParentForChildren(), isClean());
            hotwordRegex_ = null;
          }
          return hotwordRegexBuilder_;
        }

        private com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity,
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity.Builder,
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.ProximityOrBuilder>
            proximityBuilder_;
        /**
         *
         *
         * <pre>
         * Range of characters within which the entire hotword must reside.
         * The total length of the window cannot exceed 1000 characters.
         * The finding itself will be included in the window, so that hotwords can
         * be used to match substrings of the finding itself. Suppose you
         * want Cloud DLP to promote the likelihood of the phone number
         * regex "&#92;(&#92;d{3}&#92;) &#92;d{3}-&#92;d{4}" if the area code is known to be the
         * area code of a company's office. In this case, use the hotword regex
         * "&#92;(xxx&#92;)", where "xxx" is the area code in question.
         *
         * For tabular data, if you want to modify the likelihood of an entire
         * column of findngs, see
         * [Hotword example: Set the match likelihood of a table column]
         * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity = 2;</code>
         *
         * @return Whether the proximity field is set.
         */
        public boolean hasProximity() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * Range of characters within which the entire hotword must reside.
         * The total length of the window cannot exceed 1000 characters.
         * The finding itself will be included in the window, so that hotwords can
         * be used to match substrings of the finding itself. Suppose you
         * want Cloud DLP to promote the likelihood of the phone number
         * regex "&#92;(&#92;d{3}&#92;) &#92;d{3}-&#92;d{4}" if the area code is known to be the
         * area code of a company's office. In this case, use the hotword regex
         * "&#92;(xxx&#92;)", where "xxx" is the area code in question.
         *
         * For tabular data, if you want to modify the likelihood of an entire
         * column of findngs, see
         * [Hotword example: Set the match likelihood of a table column]
         * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity = 2;</code>
         *
         * @return The proximity.
         */
        public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity getProximity() {
          if (proximityBuilder_ == null) {
            return proximity_ == null
                ? com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity
                    .getDefaultInstance()
                : proximity_;
          } else {
            return proximityBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Range of characters within which the entire hotword must reside.
         * The total length of the window cannot exceed 1000 characters.
         * The finding itself will be included in the window, so that hotwords can
         * be used to match substrings of the finding itself. Suppose you
         * want Cloud DLP to promote the likelihood of the phone number
         * regex "&#92;(&#92;d{3}&#92;) &#92;d{3}-&#92;d{4}" if the area code is known to be the
         * area code of a company's office. In this case, use the hotword regex
         * "&#92;(xxx&#92;)", where "xxx" is the area code in question.
         *
         * For tabular data, if you want to modify the likelihood of an entire
         * column of findngs, see
         * [Hotword example: Set the match likelihood of a table column]
         * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity = 2;</code>
         */
        public Builder setProximity(
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity value) {
          if (proximityBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            proximity_ = value;
          } else {
            proximityBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Range of characters within which the entire hotword must reside.
         * The total length of the window cannot exceed 1000 characters.
         * The finding itself will be included in the window, so that hotwords can
         * be used to match substrings of the finding itself. Suppose you
         * want Cloud DLP to promote the likelihood of the phone number
         * regex "&#92;(&#92;d{3}&#92;) &#92;d{3}-&#92;d{4}" if the area code is known to be the
         * area code of a company's office. In this case, use the hotword regex
         * "&#92;(xxx&#92;)", where "xxx" is the area code in question.
         *
         * For tabular data, if you want to modify the likelihood of an entire
         * column of findngs, see
         * [Hotword example: Set the match likelihood of a table column]
         * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity = 2;</code>
         */
        public Builder setProximity(
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity.Builder
                builderForValue) {
          if (proximityBuilder_ == null) {
            proximity_ = builderForValue.build();
          } else {
            proximityBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Range of characters within which the entire hotword must reside.
         * The total length of the window cannot exceed 1000 characters.
         * The finding itself will be included in the window, so that hotwords can
         * be used to match substrings of the finding itself. Suppose you
         * want Cloud DLP to promote the likelihood of the phone number
         * regex "&#92;(&#92;d{3}&#92;) &#92;d{3}-&#92;d{4}" if the area code is known to be the
         * area code of a company's office. In this case, use the hotword regex
         * "&#92;(xxx&#92;)", where "xxx" is the area code in question.
         *
         * For tabular data, if you want to modify the likelihood of an entire
         * column of findngs, see
         * [Hotword example: Set the match likelihood of a table column]
         * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity = 2;</code>
         */
        public Builder mergeProximity(
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity value) {
          if (proximityBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && proximity_ != null
                && proximity_
                    != com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity
                        .getDefaultInstance()) {
              getProximityBuilder().mergeFrom(value);
            } else {
              proximity_ = value;
            }
          } else {
            proximityBuilder_.mergeFrom(value);
          }
          if (proximity_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Range of characters within which the entire hotword must reside.
         * The total length of the window cannot exceed 1000 characters.
         * The finding itself will be included in the window, so that hotwords can
         * be used to match substrings of the finding itself. Suppose you
         * want Cloud DLP to promote the likelihood of the phone number
         * regex "&#92;(&#92;d{3}&#92;) &#92;d{3}-&#92;d{4}" if the area code is known to be the
         * area code of a company's office. In this case, use the hotword regex
         * "&#92;(xxx&#92;)", where "xxx" is the area code in question.
         *
         * For tabular data, if you want to modify the likelihood of an entire
         * column of findngs, see
         * [Hotword example: Set the match likelihood of a table column]
         * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity = 2;</code>
         */
        public Builder clearProximity() {
          bitField0_ = (bitField0_ & ~0x00000002);
          proximity_ = null;
          if (proximityBuilder_ != null) {
            proximityBuilder_.dispose();
            proximityBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Range of characters within which the entire hotword must reside.
         * The total length of the window cannot exceed 1000 characters.
         * The finding itself will be included in the window, so that hotwords can
         * be used to match substrings of the finding itself. Suppose you
         * want Cloud DLP to promote the likelihood of the phone number
         * regex "&#92;(&#92;d{3}&#92;) &#92;d{3}-&#92;d{4}" if the area code is known to be the
         * area code of a company's office. In this case, use the hotword regex
         * "&#92;(xxx&#92;)", where "xxx" is the area code in question.
         *
         * For tabular data, if you want to modify the likelihood of an entire
         * column of findngs, see
         * [Hotword example: Set the match likelihood of a table column]
         * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity = 2;</code>
         */
        public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity.Builder
            getProximityBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getProximityFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Range of characters within which the entire hotword must reside.
         * The total length of the window cannot exceed 1000 characters.
         * The finding itself will be included in the window, so that hotwords can
         * be used to match substrings of the finding itself. Suppose you
         * want Cloud DLP to promote the likelihood of the phone number
         * regex "&#92;(&#92;d{3}&#92;) &#92;d{3}-&#92;d{4}" if the area code is known to be the
         * area code of a company's office. In this case, use the hotword regex
         * "&#92;(xxx&#92;)", where "xxx" is the area code in question.
         *
         * For tabular data, if you want to modify the likelihood of an entire
         * column of findngs, see
         * [Hotword example: Set the match likelihood of a table column]
         * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity = 2;</code>
         */
        public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.ProximityOrBuilder
            getProximityOrBuilder() {
          if (proximityBuilder_ != null) {
            return proximityBuilder_.getMessageOrBuilder();
          } else {
            return proximity_ == null
                ? com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity
                    .getDefaultInstance()
                : proximity_;
          }
        }
        /**
         *
         *
         * <pre>
         * Range of characters within which the entire hotword must reside.
         * The total length of the window cannot exceed 1000 characters.
         * The finding itself will be included in the window, so that hotwords can
         * be used to match substrings of the finding itself. Suppose you
         * want Cloud DLP to promote the likelihood of the phone number
         * regex "&#92;(&#92;d{3}&#92;) &#92;d{3}-&#92;d{4}" if the area code is known to be the
         * area code of a company's office. In this case, use the hotword regex
         * "&#92;(xxx&#92;)", where "xxx" is the area code in question.
         *
         * For tabular data, if you want to modify the likelihood of an entire
         * column of findngs, see
         * [Hotword example: Set the match likelihood of a table column]
         * (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity proximity = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity,
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity.Builder,
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.ProximityOrBuilder>
            getProximityFieldBuilder() {
          if (proximityBuilder_ == null) {
            proximityBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity,
                    com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity.Builder,
                    com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.ProximityOrBuilder>(
                    getProximity(), getParentForChildren(), isClean());
            proximity_ = null;
          }
          return proximityBuilder_;
        }

        private com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
            likelihoodAdjustment_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment,
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment.Builder,
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule
                    .LikelihoodAdjustmentOrBuilder>
            likelihoodAdjustmentBuilder_;
        /**
         *
         *
         * <pre>
         * Likelihood adjustment to apply to all matching findings.
         * </pre>
         *
         * <code>
         * .google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment likelihood_adjustment = 3;
         * </code>
         *
         * @return Whether the likelihoodAdjustment field is set.
         */
        public boolean hasLikelihoodAdjustment() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * Likelihood adjustment to apply to all matching findings.
         * </pre>
         *
         * <code>
         * .google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment likelihood_adjustment = 3;
         * </code>
         *
         * @return The likelihoodAdjustment.
         */
        public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
            getLikelihoodAdjustment() {
          if (likelihoodAdjustmentBuilder_ == null) {
            return likelihoodAdjustment_ == null
                ? com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
                    .getDefaultInstance()
                : likelihoodAdjustment_;
          } else {
            return likelihoodAdjustmentBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Likelihood adjustment to apply to all matching findings.
         * </pre>
         *
         * <code>
         * .google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment likelihood_adjustment = 3;
         * </code>
         */
        public Builder setLikelihoodAdjustment(
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment value) {
          if (likelihoodAdjustmentBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            likelihoodAdjustment_ = value;
          } else {
            likelihoodAdjustmentBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Likelihood adjustment to apply to all matching findings.
         * </pre>
         *
         * <code>
         * .google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment likelihood_adjustment = 3;
         * </code>
         */
        public Builder setLikelihoodAdjustment(
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment.Builder
                builderForValue) {
          if (likelihoodAdjustmentBuilder_ == null) {
            likelihoodAdjustment_ = builderForValue.build();
          } else {
            likelihoodAdjustmentBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Likelihood adjustment to apply to all matching findings.
         * </pre>
         *
         * <code>
         * .google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment likelihood_adjustment = 3;
         * </code>
         */
        public Builder mergeLikelihoodAdjustment(
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment value) {
          if (likelihoodAdjustmentBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && likelihoodAdjustment_ != null
                && likelihoodAdjustment_
                    != com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
                        .getDefaultInstance()) {
              getLikelihoodAdjustmentBuilder().mergeFrom(value);
            } else {
              likelihoodAdjustment_ = value;
            }
          } else {
            likelihoodAdjustmentBuilder_.mergeFrom(value);
          }
          if (likelihoodAdjustment_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Likelihood adjustment to apply to all matching findings.
         * </pre>
         *
         * <code>
         * .google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment likelihood_adjustment = 3;
         * </code>
         */
        public Builder clearLikelihoodAdjustment() {
          bitField0_ = (bitField0_ & ~0x00000004);
          likelihoodAdjustment_ = null;
          if (likelihoodAdjustmentBuilder_ != null) {
            likelihoodAdjustmentBuilder_.dispose();
            likelihoodAdjustmentBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Likelihood adjustment to apply to all matching findings.
         * </pre>
         *
         * <code>
         * .google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment likelihood_adjustment = 3;
         * </code>
         */
        public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment.Builder
            getLikelihoodAdjustmentBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getLikelihoodAdjustmentFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Likelihood adjustment to apply to all matching findings.
         * </pre>
         *
         * <code>
         * .google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment likelihood_adjustment = 3;
         * </code>
         */
        public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustmentOrBuilder
            getLikelihoodAdjustmentOrBuilder() {
          if (likelihoodAdjustmentBuilder_ != null) {
            return likelihoodAdjustmentBuilder_.getMessageOrBuilder();
          } else {
            return likelihoodAdjustment_ == null
                ? com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
                    .getDefaultInstance()
                : likelihoodAdjustment_;
          }
        }
        /**
         *
         *
         * <pre>
         * Likelihood adjustment to apply to all matching findings.
         * </pre>
         *
         * <code>
         * .google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment likelihood_adjustment = 3;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment,
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment.Builder,
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule
                    .LikelihoodAdjustmentOrBuilder>
            getLikelihoodAdjustmentFieldBuilder() {
          if (likelihoodAdjustmentBuilder_ == null) {
            likelihoodAdjustmentBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment,
                    com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
                        .Builder,
                    com.google.privacy.dlp.v2.CustomInfoType.DetectionRule
                        .LikelihoodAdjustmentOrBuilder>(
                    getLikelihoodAdjustment(), getParentForChildren(), isClean());
            likelihoodAdjustment_ = null;
          }
          return likelihoodAdjustmentBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule)
      }

      // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule)
      private static final com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule();
      }

      public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<HotwordRule> PARSER =
          new com.google.protobuf.AbstractParser<HotwordRule>() {
            @java.lang.Override
            public HotwordRule parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<HotwordRule> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<HotwordRule> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int typeCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object type_;

    public enum TypeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      HOTWORD_RULE(1),
      TYPE_NOT_SET(0);
      private final int value;

      private TypeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TypeCase valueOf(int value) {
        return forNumber(value);
      }

      public static TypeCase forNumber(int value) {
        switch (value) {
          case 1:
            return HOTWORD_RULE;
          case 0:
            return TYPE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public TypeCase getTypeCase() {
      return TypeCase.forNumber(typeCase_);
    }

    public static final int HOTWORD_RULE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Hotword-based detection rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule hotword_rule = 1;
     * </code>
     *
     * @return Whether the hotwordRule field is set.
     */
    @java.lang.Override
    public boolean hasHotwordRule() {
      return typeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Hotword-based detection rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule hotword_rule = 1;
     * </code>
     *
     * @return The hotwordRule.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule getHotwordRule() {
      if (typeCase_ == 1) {
        return (com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule) type_;
      }
      return com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Hotword-based detection rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule hotword_rule = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRuleOrBuilder
        getHotwordRuleOrBuilder() {
      if (typeCase_ == 1) {
        return (com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule) type_;
      }
      return com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (typeCase_ == 1) {
        output.writeMessage(
            1, (com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule) type_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (typeCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule) type_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.CustomInfoType.DetectionRule)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.CustomInfoType.DetectionRule other =
          (com.google.privacy.dlp.v2.CustomInfoType.DetectionRule) obj;

      if (!getTypeCase().equals(other.getTypeCase())) return false;
      switch (typeCase_) {
        case 1:
          if (!getHotwordRule().equals(other.getHotwordRule())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (typeCase_) {
        case 1:
          hash = (37 * hash) + HOTWORD_RULE_FIELD_NUMBER;
          hash = (53 * hash) + getHotwordRule().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.CustomInfoType.DetectionRule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Deprecated; use `InspectionRuleSet` instead. Rule for modifying a
     * `CustomInfoType` to alter behavior under certain circumstances, depending
     * on the specific details of the rule. Not supported for the `surrogate_type`
     * custom infoType.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType.DetectionRule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CustomInfoType.DetectionRule)
        com.google.privacy.dlp.v2.CustomInfoType.DetectionRuleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.class,
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (hotwordRuleBuilder_ != null) {
          hotwordRuleBuilder_.clear();
        }
        typeCase_ = 0;
        type_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CustomInfoType_DetectionRule_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule build() {
        com.google.privacy.dlp.v2.CustomInfoType.DetectionRule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule buildPartial() {
        com.google.privacy.dlp.v2.CustomInfoType.DetectionRule result =
            new com.google.privacy.dlp.v2.CustomInfoType.DetectionRule(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.privacy.dlp.v2.CustomInfoType.DetectionRule result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.privacy.dlp.v2.CustomInfoType.DetectionRule result) {
        result.typeCase_ = typeCase_;
        result.type_ = this.type_;
        if (typeCase_ == 1 && hotwordRuleBuilder_ != null) {
          result.type_ = hotwordRuleBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.CustomInfoType.DetectionRule) {
          return mergeFrom((com.google.privacy.dlp.v2.CustomInfoType.DetectionRule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.CustomInfoType.DetectionRule other) {
        if (other == com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.getDefaultInstance())
          return this;
        switch (other.getTypeCase()) {
          case HOTWORD_RULE:
            {
              mergeHotwordRule(other.getHotwordRule());
              break;
            }
          case TYPE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getHotwordRuleFieldBuilder().getBuilder(), extensionRegistry);
                  typeCase_ = 1;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int typeCase_ = 0;
      private java.lang.Object type_;

      public TypeCase getTypeCase() {
        return TypeCase.forNumber(typeCase_);
      }

      public Builder clearType() {
        typeCase_ = 0;
        type_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule,
              com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule.Builder,
              com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRuleOrBuilder>
          hotwordRuleBuilder_;
      /**
       *
       *
       * <pre>
       * Hotword-based detection rule.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule hotword_rule = 1;
       * </code>
       *
       * @return Whether the hotwordRule field is set.
       */
      @java.lang.Override
      public boolean hasHotwordRule() {
        return typeCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Hotword-based detection rule.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule hotword_rule = 1;
       * </code>
       *
       * @return The hotwordRule.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule getHotwordRule() {
        if (hotwordRuleBuilder_ == null) {
          if (typeCase_ == 1) {
            return (com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule) type_;
          }
          return com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
              .getDefaultInstance();
        } else {
          if (typeCase_ == 1) {
            return hotwordRuleBuilder_.getMessage();
          }
          return com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Hotword-based detection rule.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule hotword_rule = 1;
       * </code>
       */
      public Builder setHotwordRule(
          com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule value) {
        if (hotwordRuleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          type_ = value;
          onChanged();
        } else {
          hotwordRuleBuilder_.setMessage(value);
        }
        typeCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Hotword-based detection rule.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule hotword_rule = 1;
       * </code>
       */
      public Builder setHotwordRule(
          com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule.Builder
              builderForValue) {
        if (hotwordRuleBuilder_ == null) {
          type_ = builderForValue.build();
          onChanged();
        } else {
          hotwordRuleBuilder_.setMessage(builderForValue.build());
        }
        typeCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Hotword-based detection rule.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule hotword_rule = 1;
       * </code>
       */
      public Builder mergeHotwordRule(
          com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule value) {
        if (hotwordRuleBuilder_ == null) {
          if (typeCase_ == 1
              && type_
                  != com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
                      .getDefaultInstance()) {
            type_ =
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule.newBuilder(
                        (com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule) type_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            type_ = value;
          }
          onChanged();
        } else {
          if (typeCase_ == 1) {
            hotwordRuleBuilder_.mergeFrom(value);
          } else {
            hotwordRuleBuilder_.setMessage(value);
          }
        }
        typeCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Hotword-based detection rule.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule hotword_rule = 1;
       * </code>
       */
      public Builder clearHotwordRule() {
        if (hotwordRuleBuilder_ == null) {
          if (typeCase_ == 1) {
            typeCase_ = 0;
            type_ = null;
            onChanged();
          }
        } else {
          if (typeCase_ == 1) {
            typeCase_ = 0;
            type_ = null;
          }
          hotwordRuleBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Hotword-based detection rule.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule hotword_rule = 1;
       * </code>
       */
      public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule.Builder
          getHotwordRuleBuilder() {
        return getHotwordRuleFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Hotword-based detection rule.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule hotword_rule = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRuleOrBuilder
          getHotwordRuleOrBuilder() {
        if ((typeCase_ == 1) && (hotwordRuleBuilder_ != null)) {
          return hotwordRuleBuilder_.getMessageOrBuilder();
        } else {
          if (typeCase_ == 1) {
            return (com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule) type_;
          }
          return com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Hotword-based detection rule.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule hotword_rule = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule,
              com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule.Builder,
              com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRuleOrBuilder>
          getHotwordRuleFieldBuilder() {
        if (hotwordRuleBuilder_ == null) {
          if (!(typeCase_ == 1)) {
            type_ =
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
                    .getDefaultInstance();
          }
          hotwordRuleBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule,
                  com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule.Builder,
                  com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRuleOrBuilder>(
                  (com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule) type_,
                  getParentForChildren(),
                  isClean());
          type_ = null;
        }
        typeCase_ = 1;
        onChanged();
        return hotwordRuleBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CustomInfoType.DetectionRule)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CustomInfoType.DetectionRule)
    private static final com.google.privacy.dlp.v2.CustomInfoType.DetectionRule DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CustomInfoType.DetectionRule();
    }

    public static com.google.privacy.dlp.v2.CustomInfoType.DetectionRule getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DetectionRule> PARSER =
        new com.google.protobuf.AbstractParser<DetectionRule>() {
          @java.lang.Override
          public DetectionRule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DetectionRule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DetectionRule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int typeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object type_;

  public enum TypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DICTIONARY(2),
    REGEX(3),
    SURROGATE_TYPE(4),
    STORED_TYPE(5),
    TYPE_NOT_SET(0);
    private final int value;

    private TypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TypeCase forNumber(int value) {
      switch (value) {
        case 2:
          return DICTIONARY;
        case 3:
          return REGEX;
        case 4:
          return SURROGATE_TYPE;
        case 5:
          return STORED_TYPE;
        case 0:
          return TYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TypeCase getTypeCase() {
    return TypeCase.forNumber(typeCase_);
  }

  public static final int INFO_TYPE_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.InfoType infoType_;
  /**
   *
   *
   * <pre>
   * CustomInfoType can either be a new infoType, or an extension of built-in
   * infoType, when the name matches one of existing infoTypes and that infoType
   * is specified in `InspectContent.info_types` field. Specifying the latter
   * adds findings to the one detected by the system. If built-in info type is
   * not specified in `InspectContent.info_types` list then the name is treated
   * as a custom info type.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
   *
   * @return Whether the infoType field is set.
   */
  @java.lang.Override
  public boolean hasInfoType() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * CustomInfoType can either be a new infoType, or an extension of built-in
   * infoType, when the name matches one of existing infoTypes and that infoType
   * is specified in `InspectContent.info_types` field. Specifying the latter
   * adds findings to the one detected by the system. If built-in info type is
   * not specified in `InspectContent.info_types` list then the name is treated
   * as a custom info type.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
   *
   * @return The infoType.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoType getInfoType() {
    return infoType_ == null ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance() : infoType_;
  }
  /**
   *
   *
   * <pre>
   * CustomInfoType can either be a new infoType, or an extension of built-in
   * infoType, when the name matches one of existing infoTypes and that infoType
   * is specified in `InspectContent.info_types` field. Specifying the latter
   * adds findings to the one detected by the system. If built-in info type is
   * not specified in `InspectContent.info_types` list then the name is treated
   * as a custom info type.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder() {
    return infoType_ == null ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance() : infoType_;
  }

  public static final int LIKELIHOOD_FIELD_NUMBER = 6;
  private int likelihood_ = 0;
  /**
   *
   *
   * <pre>
   * Likelihood to return for this CustomInfoType. This base value can be
   * altered by a detection rule if the finding meets the criteria specified by
   * the rule. Defaults to `VERY_LIKELY` if not specified.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Likelihood likelihood = 6;</code>
   *
   * @return The enum numeric value on the wire for likelihood.
   */
  @java.lang.Override
  public int getLikelihoodValue() {
    return likelihood_;
  }
  /**
   *
   *
   * <pre>
   * Likelihood to return for this CustomInfoType. This base value can be
   * altered by a detection rule if the finding meets the criteria specified by
   * the rule. Defaults to `VERY_LIKELY` if not specified.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Likelihood likelihood = 6;</code>
   *
   * @return The likelihood.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Likelihood getLikelihood() {
    com.google.privacy.dlp.v2.Likelihood result =
        com.google.privacy.dlp.v2.Likelihood.forNumber(likelihood_);
    return result == null ? com.google.privacy.dlp.v2.Likelihood.UNRECOGNIZED : result;
  }

  public static final int DICTIONARY_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A list of phrases to detect as a CustomInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 2;</code>
   *
   * @return Whether the dictionary field is set.
   */
  @java.lang.Override
  public boolean hasDictionary() {
    return typeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A list of phrases to detect as a CustomInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 2;</code>
   *
   * @return The dictionary.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.Dictionary getDictionary() {
    if (typeCase_ == 2) {
      return (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_;
    }
    return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A list of phrases to detect as a CustomInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder getDictionaryOrBuilder() {
    if (typeCase_ == 2) {
      return (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_;
    }
    return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
  }

  public static final int REGEX_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Regular expression based CustomInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 3;</code>
   *
   * @return Whether the regex field is set.
   */
  @java.lang.Override
  public boolean hasRegex() {
    return typeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Regular expression based CustomInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 3;</code>
   *
   * @return The regex.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.Regex getRegex() {
    if (typeCase_ == 3) {
      return (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_;
    }
    return com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Regular expression based CustomInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder getRegexOrBuilder() {
    if (typeCase_ == 3) {
      return (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_;
    }
    return com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
  }

  public static final int SURROGATE_TYPE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Message for detecting output from deidentification transformations that
   * support reversing.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.SurrogateType surrogate_type = 4;</code>
   *
   * @return Whether the surrogateType field is set.
   */
  @java.lang.Override
  public boolean hasSurrogateType() {
    return typeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Message for detecting output from deidentification transformations that
   * support reversing.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.SurrogateType surrogate_type = 4;</code>
   *
   * @return The surrogateType.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.SurrogateType getSurrogateType() {
    if (typeCase_ == 4) {
      return (com.google.privacy.dlp.v2.CustomInfoType.SurrogateType) type_;
    }
    return com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Message for detecting output from deidentification transformations that
   * support reversing.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.SurrogateType surrogate_type = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.SurrogateTypeOrBuilder
      getSurrogateTypeOrBuilder() {
    if (typeCase_ == 4) {
      return (com.google.privacy.dlp.v2.CustomInfoType.SurrogateType) type_;
    }
    return com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.getDefaultInstance();
  }

  public static final int STORED_TYPE_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Load an existing `StoredInfoType` resource for use in
   * `InspectDataSource`. Not currently supported in `InspectContent`.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredType stored_type = 5;</code>
   *
   * @return Whether the storedType field is set.
   */
  @java.lang.Override
  public boolean hasStoredType() {
    return typeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Load an existing `StoredInfoType` resource for use in
   * `InspectDataSource`. Not currently supported in `InspectContent`.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredType stored_type = 5;</code>
   *
   * @return The storedType.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StoredType getStoredType() {
    if (typeCase_ == 5) {
      return (com.google.privacy.dlp.v2.StoredType) type_;
    }
    return com.google.privacy.dlp.v2.StoredType.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Load an existing `StoredInfoType` resource for use in
   * `InspectDataSource`. Not currently supported in `InspectContent`.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredType stored_type = 5;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StoredTypeOrBuilder getStoredTypeOrBuilder() {
    if (typeCase_ == 5) {
      return (com.google.privacy.dlp.v2.StoredType) type_;
    }
    return com.google.privacy.dlp.v2.StoredType.getDefaultInstance();
  }

  public static final int DETECTION_RULES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.CustomInfoType.DetectionRule> detectionRules_;
  /**
   *
   *
   * <pre>
   * Set of detection rules to apply to all findings of this CustomInfoType.
   * Rules are applied in order that they are specified. Not supported for the
   * `surrogate_type` CustomInfoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.CustomInfoType.DetectionRule>
      getDetectionRulesList() {
    return detectionRules_;
  }
  /**
   *
   *
   * <pre>
   * Set of detection rules to apply to all findings of this CustomInfoType.
   * Rules are applied in order that they are specified. Not supported for the
   * `surrogate_type` CustomInfoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.CustomInfoType.DetectionRuleOrBuilder>
      getDetectionRulesOrBuilderList() {
    return detectionRules_;
  }
  /**
   *
   *
   * <pre>
   * Set of detection rules to apply to all findings of this CustomInfoType.
   * Rules are applied in order that they are specified. Not supported for the
   * `surrogate_type` CustomInfoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;</code>
   */
  @java.lang.Override
  public int getDetectionRulesCount() {
    return detectionRules_.size();
  }
  /**
   *
   *
   * <pre>
   * Set of detection rules to apply to all findings of this CustomInfoType.
   * Rules are applied in order that they are specified. Not supported for the
   * `surrogate_type` CustomInfoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule getDetectionRules(int index) {
    return detectionRules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Set of detection rules to apply to all findings of this CustomInfoType.
   * Rules are applied in order that they are specified. Not supported for the
   * `surrogate_type` CustomInfoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.DetectionRuleOrBuilder getDetectionRulesOrBuilder(
      int index) {
    return detectionRules_.get(index);
  }

  public static final int EXCLUSION_TYPE_FIELD_NUMBER = 8;
  private int exclusionType_ = 0;
  /**
   *
   *
   * <pre>
   * If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding
   * to be returned. It still can be used for rules matching.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.ExclusionType exclusion_type = 8;</code>
   *
   * @return The enum numeric value on the wire for exclusionType.
   */
  @java.lang.Override
  public int getExclusionTypeValue() {
    return exclusionType_;
  }
  /**
   *
   *
   * <pre>
   * If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding
   * to be returned. It still can be used for rules matching.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.ExclusionType exclusion_type = 8;</code>
   *
   * @return The exclusionType.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.ExclusionType getExclusionType() {
    com.google.privacy.dlp.v2.CustomInfoType.ExclusionType result =
        com.google.privacy.dlp.v2.CustomInfoType.ExclusionType.forNumber(exclusionType_);
    return result == null
        ? com.google.privacy.dlp.v2.CustomInfoType.ExclusionType.UNRECOGNIZED
        : result;
  }

  public static final int SENSITIVITY_SCORE_FIELD_NUMBER = 9;
  private com.google.privacy.dlp.v2.SensitivityScore sensitivityScore_;
  /**
   *
   *
   * <pre>
   * Sensitivity for this CustomInfoType. If this CustomInfoType extends an
   * existing InfoType, the sensitivity here will take precedence over that of
   * the original InfoType. If unset for a CustomInfoType, it will default to
   * HIGH.
   * This only applies to data profiling.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 9;</code>
   *
   * @return Whether the sensitivityScore field is set.
   */
  @java.lang.Override
  public boolean hasSensitivityScore() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Sensitivity for this CustomInfoType. If this CustomInfoType extends an
   * existing InfoType, the sensitivity here will take precedence over that of
   * the original InfoType. If unset for a CustomInfoType, it will default to
   * HIGH.
   * This only applies to data profiling.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 9;</code>
   *
   * @return The sensitivityScore.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.SensitivityScore getSensitivityScore() {
    return sensitivityScore_ == null
        ? com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()
        : sensitivityScore_;
  }
  /**
   *
   *
   * <pre>
   * Sensitivity for this CustomInfoType. If this CustomInfoType extends an
   * existing InfoType, the sensitivity here will take precedence over that of
   * the original InfoType. If unset for a CustomInfoType, it will default to
   * HIGH.
   * This only applies to data profiling.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 9;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.SensitivityScoreOrBuilder getSensitivityScoreOrBuilder() {
    return sensitivityScore_ == null
        ? com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()
        : sensitivityScore_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getInfoType());
    }
    if (typeCase_ == 2) {
      output.writeMessage(2, (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_);
    }
    if (typeCase_ == 3) {
      output.writeMessage(3, (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_);
    }
    if (typeCase_ == 4) {
      output.writeMessage(4, (com.google.privacy.dlp.v2.CustomInfoType.SurrogateType) type_);
    }
    if (typeCase_ == 5) {
      output.writeMessage(5, (com.google.privacy.dlp.v2.StoredType) type_);
    }
    if (likelihood_ != com.google.privacy.dlp.v2.Likelihood.LIKELIHOOD_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, likelihood_);
    }
    for (int i = 0; i < detectionRules_.size(); i++) {
      output.writeMessage(7, detectionRules_.get(i));
    }
    if (exclusionType_
        != com.google.privacy.dlp.v2.CustomInfoType.ExclusionType.EXCLUSION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, exclusionType_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getSensitivityScore());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInfoType());
    }
    if (typeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_);
    }
    if (typeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_);
    }
    if (typeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.privacy.dlp.v2.CustomInfoType.SurrogateType) type_);
    }
    if (typeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.privacy.dlp.v2.StoredType) type_);
    }
    if (likelihood_ != com.google.privacy.dlp.v2.Likelihood.LIKELIHOOD_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, likelihood_);
    }
    for (int i = 0; i < detectionRules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, detectionRules_.get(i));
    }
    if (exclusionType_
        != com.google.privacy.dlp.v2.CustomInfoType.ExclusionType.EXCLUSION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, exclusionType_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getSensitivityScore());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.CustomInfoType)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.CustomInfoType other = (com.google.privacy.dlp.v2.CustomInfoType) obj;

    if (hasInfoType() != other.hasInfoType()) return false;
    if (hasInfoType()) {
      if (!getInfoType().equals(other.getInfoType())) return false;
    }
    if (likelihood_ != other.likelihood_) return false;
    if (!getDetectionRulesList().equals(other.getDetectionRulesList())) return false;
    if (exclusionType_ != other.exclusionType_) return false;
    if (hasSensitivityScore() != other.hasSensitivityScore()) return false;
    if (hasSensitivityScore()) {
      if (!getSensitivityScore().equals(other.getSensitivityScore())) return false;
    }
    if (!getTypeCase().equals(other.getTypeCase())) return false;
    switch (typeCase_) {
      case 2:
        if (!getDictionary().equals(other.getDictionary())) return false;
        break;
      case 3:
        if (!getRegex().equals(other.getRegex())) return false;
        break;
      case 4:
        if (!getSurrogateType().equals(other.getSurrogateType())) return false;
        break;
      case 5:
        if (!getStoredType().equals(other.getStoredType())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasInfoType()) {
      hash = (37 * hash) + INFO_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getInfoType().hashCode();
    }
    hash = (37 * hash) + LIKELIHOOD_FIELD_NUMBER;
    hash = (53 * hash) + likelihood_;
    if (getDetectionRulesCount() > 0) {
      hash = (37 * hash) + DETECTION_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getDetectionRulesList().hashCode();
    }
    hash = (37 * hash) + EXCLUSION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + exclusionType_;
    if (hasSensitivityScore()) {
      hash = (37 * hash) + SENSITIVITY_SCORE_FIELD_NUMBER;
      hash = (53 * hash) + getSensitivityScore().hashCode();
    }
    switch (typeCase_) {
      case 2:
        hash = (37 * hash) + DICTIONARY_FIELD_NUMBER;
        hash = (53 * hash) + getDictionary().hashCode();
        break;
      case 3:
        hash = (37 * hash) + REGEX_FIELD_NUMBER;
        hash = (53 * hash) + getRegex().hashCode();
        break;
      case 4:
        hash = (37 * hash) + SURROGATE_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getSurrogateType().hashCode();
        break;
      case 5:
        hash = (37 * hash) + STORED_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getStoredType().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.CustomInfoType parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CustomInfoType parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CustomInfoType parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CustomInfoType parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CustomInfoType parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CustomInfoType parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CustomInfoType parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CustomInfoType parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CustomInfoType parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CustomInfoType parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CustomInfoType parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CustomInfoType parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.CustomInfoType prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Custom information type provided by the user. Used to find domain-specific
   * sensitive information configurable to the data in question.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.CustomInfoType}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CustomInfoType)
      com.google.privacy.dlp.v2.CustomInfoTypeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CustomInfoType_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CustomInfoType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.CustomInfoType.class,
              com.google.privacy.dlp.v2.CustomInfoType.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.CustomInfoType.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInfoTypeFieldBuilder();
        getDetectionRulesFieldBuilder();
        getSensitivityScoreFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      infoType_ = null;
      if (infoTypeBuilder_ != null) {
        infoTypeBuilder_.dispose();
        infoTypeBuilder_ = null;
      }
      likelihood_ = 0;
      if (dictionaryBuilder_ != null) {
        dictionaryBuilder_.clear();
      }
      if (regexBuilder_ != null) {
        regexBuilder_.clear();
      }
      if (surrogateTypeBuilder_ != null) {
        surrogateTypeBuilder_.clear();
      }
      if (storedTypeBuilder_ != null) {
        storedTypeBuilder_.clear();
      }
      if (detectionRulesBuilder_ == null) {
        detectionRules_ = java.util.Collections.emptyList();
      } else {
        detectionRules_ = null;
        detectionRulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      exclusionType_ = 0;
      sensitivityScore_ = null;
      if (sensitivityScoreBuilder_ != null) {
        sensitivityScoreBuilder_.dispose();
        sensitivityScoreBuilder_ = null;
      }
      typeCase_ = 0;
      type_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CustomInfoType_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.CustomInfoType.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType build() {
      com.google.privacy.dlp.v2.CustomInfoType result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType buildPartial() {
      com.google.privacy.dlp.v2.CustomInfoType result =
          new com.google.privacy.dlp.v2.CustomInfoType(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.privacy.dlp.v2.CustomInfoType result) {
      if (detectionRulesBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          detectionRules_ = java.util.Collections.unmodifiableList(detectionRules_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.detectionRules_ = detectionRules_;
      } else {
        result.detectionRules_ = detectionRulesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.privacy.dlp.v2.CustomInfoType result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.infoType_ = infoTypeBuilder_ == null ? infoType_ : infoTypeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.likelihood_ = likelihood_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.exclusionType_ = exclusionType_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.sensitivityScore_ =
            sensitivityScoreBuilder_ == null ? sensitivityScore_ : sensitivityScoreBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.CustomInfoType result) {
      result.typeCase_ = typeCase_;
      result.type_ = this.type_;
      if (typeCase_ == 2 && dictionaryBuilder_ != null) {
        result.type_ = dictionaryBuilder_.build();
      }
      if (typeCase_ == 3 && regexBuilder_ != null) {
        result.type_ = regexBuilder_.build();
      }
      if (typeCase_ == 4 && surrogateTypeBuilder_ != null) {
        result.type_ = surrogateTypeBuilder_.build();
      }
      if (typeCase_ == 5 && storedTypeBuilder_ != null) {
        result.type_ = storedTypeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.CustomInfoType) {
        return mergeFrom((com.google.privacy.dlp.v2.CustomInfoType) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.CustomInfoType other) {
      if (other == com.google.privacy.dlp.v2.CustomInfoType.getDefaultInstance()) return this;
      if (other.hasInfoType()) {
        mergeInfoType(other.getInfoType());
      }
      if (other.likelihood_ != 0) {
        setLikelihoodValue(other.getLikelihoodValue());
      }
      if (detectionRulesBuilder_ == null) {
        if (!other.detectionRules_.isEmpty()) {
          if (detectionRules_.isEmpty()) {
            detectionRules_ = other.detectionRules_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureDetectionRulesIsMutable();
            detectionRules_.addAll(other.detectionRules_);
          }
          onChanged();
        }
      } else {
        if (!other.detectionRules_.isEmpty()) {
          if (detectionRulesBuilder_.isEmpty()) {
            detectionRulesBuilder_.dispose();
            detectionRulesBuilder_ = null;
            detectionRules_ = other.detectionRules_;
            bitField0_ = (bitField0_ & ~0x00000040);
            detectionRulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDetectionRulesFieldBuilder()
                    : null;
          } else {
            detectionRulesBuilder_.addAllMessages(other.detectionRules_);
          }
        }
      }
      if (other.exclusionType_ != 0) {
        setExclusionTypeValue(other.getExclusionTypeValue());
      }
      if (other.hasSensitivityScore()) {
        mergeSensitivityScore(other.getSensitivityScore());
      }
      switch (other.getTypeCase()) {
        case DICTIONARY:
          {
            mergeDictionary(other.getDictionary());
            break;
          }
        case REGEX:
          {
            mergeRegex(other.getRegex());
            break;
          }
        case SURROGATE_TYPE:
          {
            mergeSurrogateType(other.getSurrogateType());
            break;
          }
        case STORED_TYPE:
          {
            mergeStoredType(other.getStoredType());
            break;
          }
        case TYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getInfoTypeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDictionaryFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getRegexFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getSurrogateTypeFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getStoredTypeFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 5;
                break;
              } // case 42
            case 48:
              {
                likelihood_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 48
            case 58:
              {
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.parser(),
                        extensionRegistry);
                if (detectionRulesBuilder_ == null) {
                  ensureDetectionRulesIsMutable();
                  detectionRules_.add(m);
                } else {
                  detectionRulesBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 64:
              {
                exclusionType_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(
                    getSensitivityScoreFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int typeCase_ = 0;
    private java.lang.Object type_;

    public TypeCase getTypeCase() {
      return TypeCase.forNumber(typeCase_);
    }

    public Builder clearType() {
      typeCase_ = 0;
      type_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.InfoType infoType_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoType,
            com.google.privacy.dlp.v2.InfoType.Builder,
            com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        infoTypeBuilder_;
    /**
     *
     *
     * <pre>
     * CustomInfoType can either be a new infoType, or an extension of built-in
     * infoType, when the name matches one of existing infoTypes and that infoType
     * is specified in `InspectContent.info_types` field. Specifying the latter
     * adds findings to the one detected by the system. If built-in info type is
     * not specified in `InspectContent.info_types` list then the name is treated
     * as a custom info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     *
     * @return Whether the infoType field is set.
     */
    public boolean hasInfoType() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * CustomInfoType can either be a new infoType, or an extension of built-in
     * infoType, when the name matches one of existing infoTypes and that infoType
     * is specified in `InspectContent.info_types` field. Specifying the latter
     * adds findings to the one detected by the system. If built-in info type is
     * not specified in `InspectContent.info_types` list then the name is treated
     * as a custom info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     *
     * @return The infoType.
     */
    public com.google.privacy.dlp.v2.InfoType getInfoType() {
      if (infoTypeBuilder_ == null) {
        return infoType_ == null
            ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
            : infoType_;
      } else {
        return infoTypeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * CustomInfoType can either be a new infoType, or an extension of built-in
     * infoType, when the name matches one of existing infoTypes and that infoType
     * is specified in `InspectContent.info_types` field. Specifying the latter
     * adds findings to the one detected by the system. If built-in info type is
     * not specified in `InspectContent.info_types` list then the name is treated
     * as a custom info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     */
    public Builder setInfoType(com.google.privacy.dlp.v2.InfoType value) {
      if (infoTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        infoType_ = value;
      } else {
        infoTypeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CustomInfoType can either be a new infoType, or an extension of built-in
     * infoType, when the name matches one of existing infoTypes and that infoType
     * is specified in `InspectContent.info_types` field. Specifying the latter
     * adds findings to the one detected by the system. If built-in info type is
     * not specified in `InspectContent.info_types` list then the name is treated
     * as a custom info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     */
    public Builder setInfoType(com.google.privacy.dlp.v2.InfoType.Builder builderForValue) {
      if (infoTypeBuilder_ == null) {
        infoType_ = builderForValue.build();
      } else {
        infoTypeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CustomInfoType can either be a new infoType, or an extension of built-in
     * infoType, when the name matches one of existing infoTypes and that infoType
     * is specified in `InspectContent.info_types` field. Specifying the latter
     * adds findings to the one detected by the system. If built-in info type is
     * not specified in `InspectContent.info_types` list then the name is treated
     * as a custom info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     */
    public Builder mergeInfoType(com.google.privacy.dlp.v2.InfoType value) {
      if (infoTypeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && infoType_ != null
            && infoType_ != com.google.privacy.dlp.v2.InfoType.getDefaultInstance()) {
          getInfoTypeBuilder().mergeFrom(value);
        } else {
          infoType_ = value;
        }
      } else {
        infoTypeBuilder_.mergeFrom(value);
      }
      if (infoType_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * CustomInfoType can either be a new infoType, or an extension of built-in
     * infoType, when the name matches one of existing infoTypes and that infoType
     * is specified in `InspectContent.info_types` field. Specifying the latter
     * adds findings to the one detected by the system. If built-in info type is
     * not specified in `InspectContent.info_types` list then the name is treated
     * as a custom info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     */
    public Builder clearInfoType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      infoType_ = null;
      if (infoTypeBuilder_ != null) {
        infoTypeBuilder_.dispose();
        infoTypeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CustomInfoType can either be a new infoType, or an extension of built-in
     * infoType, when the name matches one of existing infoTypes and that infoType
     * is specified in `InspectContent.info_types` field. Specifying the latter
     * adds findings to the one detected by the system. If built-in info type is
     * not specified in `InspectContent.info_types` list then the name is treated
     * as a custom info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     */
    public com.google.privacy.dlp.v2.InfoType.Builder getInfoTypeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getInfoTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * CustomInfoType can either be a new infoType, or an extension of built-in
     * infoType, when the name matches one of existing infoTypes and that infoType
     * is specified in `InspectContent.info_types` field. Specifying the latter
     * adds findings to the one detected by the system. If built-in info type is
     * not specified in `InspectContent.info_types` list then the name is treated
     * as a custom info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder() {
      if (infoTypeBuilder_ != null) {
        return infoTypeBuilder_.getMessageOrBuilder();
      } else {
        return infoType_ == null
            ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
            : infoType_;
      }
    }
    /**
     *
     *
     * <pre>
     * CustomInfoType can either be a new infoType, or an extension of built-in
     * infoType, when the name matches one of existing infoTypes and that infoType
     * is specified in `InspectContent.info_types` field. Specifying the latter
     * adds findings to the one detected by the system. If built-in info type is
     * not specified in `InspectContent.info_types` list then the name is treated
     * as a custom info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoType,
            com.google.privacy.dlp.v2.InfoType.Builder,
            com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        getInfoTypeFieldBuilder() {
      if (infoTypeBuilder_ == null) {
        infoTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InfoType,
                com.google.privacy.dlp.v2.InfoType.Builder,
                com.google.privacy.dlp.v2.InfoTypeOrBuilder>(
                getInfoType(), getParentForChildren(), isClean());
        infoType_ = null;
      }
      return infoTypeBuilder_;
    }

    private int likelihood_ = 0;
    /**
     *
     *
     * <pre>
     * Likelihood to return for this CustomInfoType. This base value can be
     * altered by a detection rule if the finding meets the criteria specified by
     * the rule. Defaults to `VERY_LIKELY` if not specified.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Likelihood likelihood = 6;</code>
     *
     * @return The enum numeric value on the wire for likelihood.
     */
    @java.lang.Override
    public int getLikelihoodValue() {
      return likelihood_;
    }
    /**
     *
     *
     * <pre>
     * Likelihood to return for this CustomInfoType. This base value can be
     * altered by a detection rule if the finding meets the criteria specified by
     * the rule. Defaults to `VERY_LIKELY` if not specified.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Likelihood likelihood = 6;</code>
     *
     * @param value The enum numeric value on the wire for likelihood to set.
     * @return This builder for chaining.
     */
    public Builder setLikelihoodValue(int value) {
      likelihood_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Likelihood to return for this CustomInfoType. This base value can be
     * altered by a detection rule if the finding meets the criteria specified by
     * the rule. Defaults to `VERY_LIKELY` if not specified.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Likelihood likelihood = 6;</code>
     *
     * @return The likelihood.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Likelihood getLikelihood() {
      com.google.privacy.dlp.v2.Likelihood result =
          com.google.privacy.dlp.v2.Likelihood.forNumber(likelihood_);
      return result == null ? com.google.privacy.dlp.v2.Likelihood.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Likelihood to return for this CustomInfoType. This base value can be
     * altered by a detection rule if the finding meets the criteria specified by
     * the rule. Defaults to `VERY_LIKELY` if not specified.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Likelihood likelihood = 6;</code>
     *
     * @param value The likelihood to set.
     * @return This builder for chaining.
     */
    public Builder setLikelihood(com.google.privacy.dlp.v2.Likelihood value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      likelihood_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Likelihood to return for this CustomInfoType. This base value can be
     * altered by a detection rule if the finding meets the criteria specified by
     * the rule. Defaults to `VERY_LIKELY` if not specified.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Likelihood likelihood = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLikelihood() {
      bitField0_ = (bitField0_ & ~0x00000002);
      likelihood_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType.Dictionary,
            com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder,
            com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder>
        dictionaryBuilder_;
    /**
     *
     *
     * <pre>
     * A list of phrases to detect as a CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 2;</code>
     *
     * @return Whether the dictionary field is set.
     */
    @java.lang.Override
    public boolean hasDictionary() {
      return typeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A list of phrases to detect as a CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 2;</code>
     *
     * @return The dictionary.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.Dictionary getDictionary() {
      if (dictionaryBuilder_ == null) {
        if (typeCase_ == 2) {
          return (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_;
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
      } else {
        if (typeCase_ == 2) {
          return dictionaryBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of phrases to detect as a CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 2;</code>
     */
    public Builder setDictionary(com.google.privacy.dlp.v2.CustomInfoType.Dictionary value) {
      if (dictionaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        dictionaryBuilder_.setMessage(value);
      }
      typeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phrases to detect as a CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 2;</code>
     */
    public Builder setDictionary(
        com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder builderForValue) {
      if (dictionaryBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        dictionaryBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phrases to detect as a CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 2;</code>
     */
    public Builder mergeDictionary(com.google.privacy.dlp.v2.CustomInfoType.Dictionary value) {
      if (dictionaryBuilder_ == null) {
        if (typeCase_ == 2
            && type_ != com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance()) {
          type_ =
              com.google.privacy.dlp.v2.CustomInfoType.Dictionary.newBuilder(
                      (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 2) {
          dictionaryBuilder_.mergeFrom(value);
        } else {
          dictionaryBuilder_.setMessage(value);
        }
      }
      typeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phrases to detect as a CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 2;</code>
     */
    public Builder clearDictionary() {
      if (dictionaryBuilder_ == null) {
        if (typeCase_ == 2) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 2) {
          typeCase_ = 0;
          type_ = null;
        }
        dictionaryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phrases to detect as a CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 2;</code>
     */
    public com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder getDictionaryBuilder() {
      return getDictionaryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A list of phrases to detect as a CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder getDictionaryOrBuilder() {
      if ((typeCase_ == 2) && (dictionaryBuilder_ != null)) {
        return dictionaryBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 2) {
          return (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_;
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of phrases to detect as a CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType.Dictionary,
            com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder,
            com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder>
        getDictionaryFieldBuilder() {
      if (dictionaryBuilder_ == null) {
        if (!(typeCase_ == 2)) {
          type_ = com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
        }
        dictionaryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CustomInfoType.Dictionary,
                com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder,
                com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder>(
                (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 2;
      onChanged();
      return dictionaryBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType.Regex,
            com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder,
            com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder>
        regexBuilder_;
    /**
     *
     *
     * <pre>
     * Regular expression based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 3;</code>
     *
     * @return Whether the regex field is set.
     */
    @java.lang.Override
    public boolean hasRegex() {
      return typeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Regular expression based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 3;</code>
     *
     * @return The regex.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.Regex getRegex() {
      if (regexBuilder_ == null) {
        if (typeCase_ == 3) {
          return (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_;
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
      } else {
        if (typeCase_ == 3) {
          return regexBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Regular expression based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 3;</code>
     */
    public Builder setRegex(com.google.privacy.dlp.v2.CustomInfoType.Regex value) {
      if (regexBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        regexBuilder_.setMessage(value);
      }
      typeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regular expression based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 3;</code>
     */
    public Builder setRegex(
        com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder builderForValue) {
      if (regexBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        regexBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regular expression based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 3;</code>
     */
    public Builder mergeRegex(com.google.privacy.dlp.v2.CustomInfoType.Regex value) {
      if (regexBuilder_ == null) {
        if (typeCase_ == 3
            && type_ != com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance()) {
          type_ =
              com.google.privacy.dlp.v2.CustomInfoType.Regex.newBuilder(
                      (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 3) {
          regexBuilder_.mergeFrom(value);
        } else {
          regexBuilder_.setMessage(value);
        }
      }
      typeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regular expression based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 3;</code>
     */
    public Builder clearRegex() {
      if (regexBuilder_ == null) {
        if (typeCase_ == 3) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 3) {
          typeCase_ = 0;
          type_ = null;
        }
        regexBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regular expression based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 3;</code>
     */
    public com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder getRegexBuilder() {
      return getRegexFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Regular expression based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 3;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder getRegexOrBuilder() {
      if ((typeCase_ == 3) && (regexBuilder_ != null)) {
        return regexBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 3) {
          return (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_;
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Regular expression based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType.Regex,
            com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder,
            com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder>
        getRegexFieldBuilder() {
      if (regexBuilder_ == null) {
        if (!(typeCase_ == 3)) {
          type_ = com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
        }
        regexBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CustomInfoType.Regex,
                com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder,
                com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder>(
                (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 3;
      onChanged();
      return regexBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType.SurrogateType,
            com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.Builder,
            com.google.privacy.dlp.v2.CustomInfoType.SurrogateTypeOrBuilder>
        surrogateTypeBuilder_;
    /**
     *
     *
     * <pre>
     * Message for detecting output from deidentification transformations that
     * support reversing.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.SurrogateType surrogate_type = 4;</code>
     *
     * @return Whether the surrogateType field is set.
     */
    @java.lang.Override
    public boolean hasSurrogateType() {
      return typeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Message for detecting output from deidentification transformations that
     * support reversing.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.SurrogateType surrogate_type = 4;</code>
     *
     * @return The surrogateType.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.SurrogateType getSurrogateType() {
      if (surrogateTypeBuilder_ == null) {
        if (typeCase_ == 4) {
          return (com.google.privacy.dlp.v2.CustomInfoType.SurrogateType) type_;
        }
        return com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.getDefaultInstance();
      } else {
        if (typeCase_ == 4) {
          return surrogateTypeBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Message for detecting output from deidentification transformations that
     * support reversing.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.SurrogateType surrogate_type = 4;</code>
     */
    public Builder setSurrogateType(com.google.privacy.dlp.v2.CustomInfoType.SurrogateType value) {
      if (surrogateTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        surrogateTypeBuilder_.setMessage(value);
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Message for detecting output from deidentification transformations that
     * support reversing.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.SurrogateType surrogate_type = 4;</code>
     */
    public Builder setSurrogateType(
        com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.Builder builderForValue) {
      if (surrogateTypeBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        surrogateTypeBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Message for detecting output from deidentification transformations that
     * support reversing.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.SurrogateType surrogate_type = 4;</code>
     */
    public Builder mergeSurrogateType(
        com.google.privacy.dlp.v2.CustomInfoType.SurrogateType value) {
      if (surrogateTypeBuilder_ == null) {
        if (typeCase_ == 4
            && type_
                != com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.getDefaultInstance()) {
          type_ =
              com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.newBuilder(
                      (com.google.privacy.dlp.v2.CustomInfoType.SurrogateType) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 4) {
          surrogateTypeBuilder_.mergeFrom(value);
        } else {
          surrogateTypeBuilder_.setMessage(value);
        }
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Message for detecting output from deidentification transformations that
     * support reversing.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.SurrogateType surrogate_type = 4;</code>
     */
    public Builder clearSurrogateType() {
      if (surrogateTypeBuilder_ == null) {
        if (typeCase_ == 4) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 4) {
          typeCase_ = 0;
          type_ = null;
        }
        surrogateTypeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Message for detecting output from deidentification transformations that
     * support reversing.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.SurrogateType surrogate_type = 4;</code>
     */
    public com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.Builder
        getSurrogateTypeBuilder() {
      return getSurrogateTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Message for detecting output from deidentification transformations that
     * support reversing.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.SurrogateType surrogate_type = 4;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.SurrogateTypeOrBuilder
        getSurrogateTypeOrBuilder() {
      if ((typeCase_ == 4) && (surrogateTypeBuilder_ != null)) {
        return surrogateTypeBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 4) {
          return (com.google.privacy.dlp.v2.CustomInfoType.SurrogateType) type_;
        }
        return com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Message for detecting output from deidentification transformations that
     * support reversing.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.SurrogateType surrogate_type = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType.SurrogateType,
            com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.Builder,
            com.google.privacy.dlp.v2.CustomInfoType.SurrogateTypeOrBuilder>
        getSurrogateTypeFieldBuilder() {
      if (surrogateTypeBuilder_ == null) {
        if (!(typeCase_ == 4)) {
          type_ = com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.getDefaultInstance();
        }
        surrogateTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CustomInfoType.SurrogateType,
                com.google.privacy.dlp.v2.CustomInfoType.SurrogateType.Builder,
                com.google.privacy.dlp.v2.CustomInfoType.SurrogateTypeOrBuilder>(
                (com.google.privacy.dlp.v2.CustomInfoType.SurrogateType) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 4;
      onChanged();
      return surrogateTypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.StoredType,
            com.google.privacy.dlp.v2.StoredType.Builder,
            com.google.privacy.dlp.v2.StoredTypeOrBuilder>
        storedTypeBuilder_;
    /**
     *
     *
     * <pre>
     * Load an existing `StoredInfoType` resource for use in
     * `InspectDataSource`. Not currently supported in `InspectContent`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredType stored_type = 5;</code>
     *
     * @return Whether the storedType field is set.
     */
    @java.lang.Override
    public boolean hasStoredType() {
      return typeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Load an existing `StoredInfoType` resource for use in
     * `InspectDataSource`. Not currently supported in `InspectContent`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredType stored_type = 5;</code>
     *
     * @return The storedType.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.StoredType getStoredType() {
      if (storedTypeBuilder_ == null) {
        if (typeCase_ == 5) {
          return (com.google.privacy.dlp.v2.StoredType) type_;
        }
        return com.google.privacy.dlp.v2.StoredType.getDefaultInstance();
      } else {
        if (typeCase_ == 5) {
          return storedTypeBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.StoredType.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Load an existing `StoredInfoType` resource for use in
     * `InspectDataSource`. Not currently supported in `InspectContent`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredType stored_type = 5;</code>
     */
    public Builder setStoredType(com.google.privacy.dlp.v2.StoredType value) {
      if (storedTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        storedTypeBuilder_.setMessage(value);
      }
      typeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Load an existing `StoredInfoType` resource for use in
     * `InspectDataSource`. Not currently supported in `InspectContent`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredType stored_type = 5;</code>
     */
    public Builder setStoredType(com.google.privacy.dlp.v2.StoredType.Builder builderForValue) {
      if (storedTypeBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        storedTypeBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Load an existing `StoredInfoType` resource for use in
     * `InspectDataSource`. Not currently supported in `InspectContent`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredType stored_type = 5;</code>
     */
    public Builder mergeStoredType(com.google.privacy.dlp.v2.StoredType value) {
      if (storedTypeBuilder_ == null) {
        if (typeCase_ == 5 && type_ != com.google.privacy.dlp.v2.StoredType.getDefaultInstance()) {
          type_ =
              com.google.privacy.dlp.v2.StoredType.newBuilder(
                      (com.google.privacy.dlp.v2.StoredType) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 5) {
          storedTypeBuilder_.mergeFrom(value);
        } else {
          storedTypeBuilder_.setMessage(value);
        }
      }
      typeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Load an existing `StoredInfoType` resource for use in
     * `InspectDataSource`. Not currently supported in `InspectContent`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredType stored_type = 5;</code>
     */
    public Builder clearStoredType() {
      if (storedTypeBuilder_ == null) {
        if (typeCase_ == 5) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 5) {
          typeCase_ = 0;
          type_ = null;
        }
        storedTypeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Load an existing `StoredInfoType` resource for use in
     * `InspectDataSource`. Not currently supported in `InspectContent`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredType stored_type = 5;</code>
     */
    public com.google.privacy.dlp.v2.StoredType.Builder getStoredTypeBuilder() {
      return getStoredTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Load an existing `StoredInfoType` resource for use in
     * `InspectDataSource`. Not currently supported in `InspectContent`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredType stored_type = 5;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.StoredTypeOrBuilder getStoredTypeOrBuilder() {
      if ((typeCase_ == 5) && (storedTypeBuilder_ != null)) {
        return storedTypeBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 5) {
          return (com.google.privacy.dlp.v2.StoredType) type_;
        }
        return com.google.privacy.dlp.v2.StoredType.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Load an existing `StoredInfoType` resource for use in
     * `InspectDataSource`. Not currently supported in `InspectContent`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredType stored_type = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.StoredType,
            com.google.privacy.dlp.v2.StoredType.Builder,
            com.google.privacy.dlp.v2.StoredTypeOrBuilder>
        getStoredTypeFieldBuilder() {
      if (storedTypeBuilder_ == null) {
        if (!(typeCase_ == 5)) {
          type_ = com.google.privacy.dlp.v2.StoredType.getDefaultInstance();
        }
        storedTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.StoredType,
                com.google.privacy.dlp.v2.StoredType.Builder,
                com.google.privacy.dlp.v2.StoredTypeOrBuilder>(
                (com.google.privacy.dlp.v2.StoredType) type_, getParentForChildren(), isClean());
        type_ = null;
      }
      typeCase_ = 5;
      onChanged();
      return storedTypeBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.CustomInfoType.DetectionRule> detectionRules_ =
        java.util.Collections.emptyList();

    private void ensureDetectionRulesIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        detectionRules_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.CustomInfoType.DetectionRule>(
                detectionRules_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule,
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Builder,
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRuleOrBuilder>
        detectionRulesBuilder_;

    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public java.util.List<com.google.privacy.dlp.v2.CustomInfoType.DetectionRule>
        getDetectionRulesList() {
      if (detectionRulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(detectionRules_);
      } else {
        return detectionRulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public int getDetectionRulesCount() {
      if (detectionRulesBuilder_ == null) {
        return detectionRules_.size();
      } else {
        return detectionRulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule getDetectionRules(int index) {
      if (detectionRulesBuilder_ == null) {
        return detectionRules_.get(index);
      } else {
        return detectionRulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public Builder setDetectionRules(
        int index, com.google.privacy.dlp.v2.CustomInfoType.DetectionRule value) {
      if (detectionRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDetectionRulesIsMutable();
        detectionRules_.set(index, value);
        onChanged();
      } else {
        detectionRulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public Builder setDetectionRules(
        int index, com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Builder builderForValue) {
      if (detectionRulesBuilder_ == null) {
        ensureDetectionRulesIsMutable();
        detectionRules_.set(index, builderForValue.build());
        onChanged();
      } else {
        detectionRulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public Builder addDetectionRules(com.google.privacy.dlp.v2.CustomInfoType.DetectionRule value) {
      if (detectionRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDetectionRulesIsMutable();
        detectionRules_.add(value);
        onChanged();
      } else {
        detectionRulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public Builder addDetectionRules(
        int index, com.google.privacy.dlp.v2.CustomInfoType.DetectionRule value) {
      if (detectionRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDetectionRulesIsMutable();
        detectionRules_.add(index, value);
        onChanged();
      } else {
        detectionRulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public Builder addDetectionRules(
        com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Builder builderForValue) {
      if (detectionRulesBuilder_ == null) {
        ensureDetectionRulesIsMutable();
        detectionRules_.add(builderForValue.build());
        onChanged();
      } else {
        detectionRulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public Builder addDetectionRules(
        int index, com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Builder builderForValue) {
      if (detectionRulesBuilder_ == null) {
        ensureDetectionRulesIsMutable();
        detectionRules_.add(index, builderForValue.build());
        onChanged();
      } else {
        detectionRulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public Builder addAllDetectionRules(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.CustomInfoType.DetectionRule>
            values) {
      if (detectionRulesBuilder_ == null) {
        ensureDetectionRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectionRules_);
        onChanged();
      } else {
        detectionRulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public Builder clearDetectionRules() {
      if (detectionRulesBuilder_ == null) {
        detectionRules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        detectionRulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public Builder removeDetectionRules(int index) {
      if (detectionRulesBuilder_ == null) {
        ensureDetectionRulesIsMutable();
        detectionRules_.remove(index);
        onChanged();
      } else {
        detectionRulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Builder getDetectionRulesBuilder(
        int index) {
      return getDetectionRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public com.google.privacy.dlp.v2.CustomInfoType.DetectionRuleOrBuilder
        getDetectionRulesOrBuilder(int index) {
      if (detectionRulesBuilder_ == null) {
        return detectionRules_.get(index);
      } else {
        return detectionRulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.CustomInfoType.DetectionRuleOrBuilder>
        getDetectionRulesOrBuilderList() {
      if (detectionRulesBuilder_ != null) {
        return detectionRulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(detectionRules_);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Builder
        addDetectionRulesBuilder() {
      return getDetectionRulesFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Builder addDetectionRulesBuilder(
        int index) {
      return getDetectionRulesFieldBuilder()
          .addBuilder(
              index, com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of detection rules to apply to all findings of this CustomInfoType.
     * Rules are applied in order that they are specified. Not supported for the
     * `surrogate_type` CustomInfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;
     * </code>
     */
    public java.util.List<com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Builder>
        getDetectionRulesBuilderList() {
      return getDetectionRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule,
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Builder,
            com.google.privacy.dlp.v2.CustomInfoType.DetectionRuleOrBuilder>
        getDetectionRulesFieldBuilder() {
      if (detectionRulesBuilder_ == null) {
        detectionRulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule,
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRule.Builder,
                com.google.privacy.dlp.v2.CustomInfoType.DetectionRuleOrBuilder>(
                detectionRules_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        detectionRules_ = null;
      }
      return detectionRulesBuilder_;
    }

    private int exclusionType_ = 0;
    /**
     *
     *
     * <pre>
     * If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding
     * to be returned. It still can be used for rules matching.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.ExclusionType exclusion_type = 8;</code>
     *
     * @return The enum numeric value on the wire for exclusionType.
     */
    @java.lang.Override
    public int getExclusionTypeValue() {
      return exclusionType_;
    }
    /**
     *
     *
     * <pre>
     * If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding
     * to be returned. It still can be used for rules matching.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.ExclusionType exclusion_type = 8;</code>
     *
     * @param value The enum numeric value on the wire for exclusionType to set.
     * @return This builder for chaining.
     */
    public Builder setExclusionTypeValue(int value) {
      exclusionType_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding
     * to be returned. It still can be used for rules matching.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.ExclusionType exclusion_type = 8;</code>
     *
     * @return The exclusionType.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.ExclusionType getExclusionType() {
      com.google.privacy.dlp.v2.CustomInfoType.ExclusionType result =
          com.google.privacy.dlp.v2.CustomInfoType.ExclusionType.forNumber(exclusionType_);
      return result == null
          ? com.google.privacy.dlp.v2.CustomInfoType.ExclusionType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding
     * to be returned. It still can be used for rules matching.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.ExclusionType exclusion_type = 8;</code>
     *
     * @param value The exclusionType to set.
     * @return This builder for chaining.
     */
    public Builder setExclusionType(com.google.privacy.dlp.v2.CustomInfoType.ExclusionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      exclusionType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding
     * to be returned. It still can be used for rules matching.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.ExclusionType exclusion_type = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExclusionType() {
      bitField0_ = (bitField0_ & ~0x00000080);
      exclusionType_ = 0;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.SensitivityScore sensitivityScore_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.SensitivityScore,
            com.google.privacy.dlp.v2.SensitivityScore.Builder,
            com.google.privacy.dlp.v2.SensitivityScoreOrBuilder>
        sensitivityScoreBuilder_;
    /**
     *
     *
     * <pre>
     * Sensitivity for this CustomInfoType. If this CustomInfoType extends an
     * existing InfoType, the sensitivity here will take precedence over that of
     * the original InfoType. If unset for a CustomInfoType, it will default to
     * HIGH.
     * This only applies to data profiling.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 9;</code>
     *
     * @return Whether the sensitivityScore field is set.
     */
    public boolean hasSensitivityScore() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Sensitivity for this CustomInfoType. If this CustomInfoType extends an
     * existing InfoType, the sensitivity here will take precedence over that of
     * the original InfoType. If unset for a CustomInfoType, it will default to
     * HIGH.
     * This only applies to data profiling.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 9;</code>
     *
     * @return The sensitivityScore.
     */
    public com.google.privacy.dlp.v2.SensitivityScore getSensitivityScore() {
      if (sensitivityScoreBuilder_ == null) {
        return sensitivityScore_ == null
            ? com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()
            : sensitivityScore_;
      } else {
        return sensitivityScoreBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Sensitivity for this CustomInfoType. If this CustomInfoType extends an
     * existing InfoType, the sensitivity here will take precedence over that of
     * the original InfoType. If unset for a CustomInfoType, it will default to
     * HIGH.
     * This only applies to data profiling.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 9;</code>
     */
    public Builder setSensitivityScore(com.google.privacy.dlp.v2.SensitivityScore value) {
      if (sensitivityScoreBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sensitivityScore_ = value;
      } else {
        sensitivityScoreBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sensitivity for this CustomInfoType. If this CustomInfoType extends an
     * existing InfoType, the sensitivity here will take precedence over that of
     * the original InfoType. If unset for a CustomInfoType, it will default to
     * HIGH.
     * This only applies to data profiling.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 9;</code>
     */
    public Builder setSensitivityScore(
        com.google.privacy.dlp.v2.SensitivityScore.Builder builderForValue) {
      if (sensitivityScoreBuilder_ == null) {
        sensitivityScore_ = builderForValue.build();
      } else {
        sensitivityScoreBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sensitivity for this CustomInfoType. If this CustomInfoType extends an
     * existing InfoType, the sensitivity here will take precedence over that of
     * the original InfoType. If unset for a CustomInfoType, it will default to
     * HIGH.
     * This only applies to data profiling.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 9;</code>
     */
    public Builder mergeSensitivityScore(com.google.privacy.dlp.v2.SensitivityScore value) {
      if (sensitivityScoreBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && sensitivityScore_ != null
            && sensitivityScore_
                != com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()) {
          getSensitivityScoreBuilder().mergeFrom(value);
        } else {
          sensitivityScore_ = value;
        }
      } else {
        sensitivityScoreBuilder_.mergeFrom(value);
      }
      if (sensitivityScore_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sensitivity for this CustomInfoType. If this CustomInfoType extends an
     * existing InfoType, the sensitivity here will take precedence over that of
     * the original InfoType. If unset for a CustomInfoType, it will default to
     * HIGH.
     * This only applies to data profiling.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 9;</code>
     */
    public Builder clearSensitivityScore() {
      bitField0_ = (bitField0_ & ~0x00000100);
      sensitivityScore_ = null;
      if (sensitivityScoreBuilder_ != null) {
        sensitivityScoreBuilder_.dispose();
        sensitivityScoreBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sensitivity for this CustomInfoType. If this CustomInfoType extends an
     * existing InfoType, the sensitivity here will take precedence over that of
     * the original InfoType. If unset for a CustomInfoType, it will default to
     * HIGH.
     * This only applies to data profiling.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 9;</code>
     */
    public com.google.privacy.dlp.v2.SensitivityScore.Builder getSensitivityScoreBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getSensitivityScoreFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Sensitivity for this CustomInfoType. If this CustomInfoType extends an
     * existing InfoType, the sensitivity here will take precedence over that of
     * the original InfoType. If unset for a CustomInfoType, it will default to
     * HIGH.
     * This only applies to data profiling.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 9;</code>
     */
    public com.google.privacy.dlp.v2.SensitivityScoreOrBuilder getSensitivityScoreOrBuilder() {
      if (sensitivityScoreBuilder_ != null) {
        return sensitivityScoreBuilder_.getMessageOrBuilder();
      } else {
        return sensitivityScore_ == null
            ? com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()
            : sensitivityScore_;
      }
    }
    /**
     *
     *
     * <pre>
     * Sensitivity for this CustomInfoType. If this CustomInfoType extends an
     * existing InfoType, the sensitivity here will take precedence over that of
     * the original InfoType. If unset for a CustomInfoType, it will default to
     * HIGH.
     * This only applies to data profiling.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.SensitivityScore,
            com.google.privacy.dlp.v2.SensitivityScore.Builder,
            com.google.privacy.dlp.v2.SensitivityScoreOrBuilder>
        getSensitivityScoreFieldBuilder() {
      if (sensitivityScoreBuilder_ == null) {
        sensitivityScoreBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.SensitivityScore,
                com.google.privacy.dlp.v2.SensitivityScore.Builder,
                com.google.privacy.dlp.v2.SensitivityScoreOrBuilder>(
                getSensitivityScore(), getParentForChildren(), isClean());
        sensitivityScore_ = null;
      }
      return sensitivityScoreBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CustomInfoType)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CustomInfoType)
  private static final com.google.privacy.dlp.v2.CustomInfoType DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CustomInfoType();
  }

  public static com.google.privacy.dlp.v2.CustomInfoType getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CustomInfoType> PARSER =
      new com.google.protobuf.AbstractParser<CustomInfoType>() {
        @java.lang.Override
        public CustomInfoType parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CustomInfoType> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CustomInfoType> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
