/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Message for a date time object.
 * e.g. 2018-01-01, 5th August.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.DateTime}
 */
public final class DateTime extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DateTime)
    DateTimeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DateTime.newBuilder() to construct.
  private DateTime(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DateTime() {
    dayOfWeek_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DateTime();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DateTime_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DateTime_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.DateTime.class,
            com.google.privacy.dlp.v2.DateTime.Builder.class);
  }

  public interface TimeZoneOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.DateTime.TimeZone)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Set only if the offset can be determined. Positive for time ahead of UTC.
     * E.g. For "UTC-9", this value is -540.
     * </pre>
     *
     * <code>int32 offset_minutes = 1;</code>
     *
     * @return The offsetMinutes.
     */
    int getOffsetMinutes();
  }
  /**
   *
   *
   * <pre>
   * Time zone of the date time object.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DateTime.TimeZone}
   */
  public static final class TimeZone extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DateTime.TimeZone)
      TimeZoneOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TimeZone.newBuilder() to construct.
    private TimeZone(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TimeZone() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TimeZone();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DateTime_TimeZone_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DateTime_TimeZone_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DateTime.TimeZone.class,
              com.google.privacy.dlp.v2.DateTime.TimeZone.Builder.class);
    }

    public static final int OFFSET_MINUTES_FIELD_NUMBER = 1;
    private int offsetMinutes_ = 0;
    /**
     *
     *
     * <pre>
     * Set only if the offset can be determined. Positive for time ahead of UTC.
     * E.g. For "UTC-9", this value is -540.
     * </pre>
     *
     * <code>int32 offset_minutes = 1;</code>
     *
     * @return The offsetMinutes.
     */
    @java.lang.Override
    public int getOffsetMinutes() {
      return offsetMinutes_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (offsetMinutes_ != 0) {
        output.writeInt32(1, offsetMinutes_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (offsetMinutes_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, offsetMinutes_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.DateTime.TimeZone)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.DateTime.TimeZone other =
          (com.google.privacy.dlp.v2.DateTime.TimeZone) obj;

      if (getOffsetMinutes() != other.getOffsetMinutes()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OFFSET_MINUTES_FIELD_NUMBER;
      hash = (53 * hash) + getOffsetMinutes();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.DateTime.TimeZone parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DateTime.TimeZone parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DateTime.TimeZone parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DateTime.TimeZone parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DateTime.TimeZone parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DateTime.TimeZone parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DateTime.TimeZone parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DateTime.TimeZone parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DateTime.TimeZone parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DateTime.TimeZone parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DateTime.TimeZone parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DateTime.TimeZone parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.privacy.dlp.v2.DateTime.TimeZone prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Time zone of the date time object.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.DateTime.TimeZone}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DateTime.TimeZone)
        com.google.privacy.dlp.v2.DateTime.TimeZoneOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DateTime_TimeZone_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DateTime_TimeZone_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.DateTime.TimeZone.class,
                com.google.privacy.dlp.v2.DateTime.TimeZone.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.DateTime.TimeZone.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        offsetMinutes_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DateTime_TimeZone_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DateTime.TimeZone getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.DateTime.TimeZone.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DateTime.TimeZone build() {
        com.google.privacy.dlp.v2.DateTime.TimeZone result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DateTime.TimeZone buildPartial() {
        com.google.privacy.dlp.v2.DateTime.TimeZone result =
            new com.google.privacy.dlp.v2.DateTime.TimeZone(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.privacy.dlp.v2.DateTime.TimeZone result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.offsetMinutes_ = offsetMinutes_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.DateTime.TimeZone) {
          return mergeFrom((com.google.privacy.dlp.v2.DateTime.TimeZone) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.DateTime.TimeZone other) {
        if (other == com.google.privacy.dlp.v2.DateTime.TimeZone.getDefaultInstance()) return this;
        if (other.getOffsetMinutes() != 0) {
          setOffsetMinutes(other.getOffsetMinutes());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  offsetMinutes_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int offsetMinutes_;
      /**
       *
       *
       * <pre>
       * Set only if the offset can be determined. Positive for time ahead of UTC.
       * E.g. For "UTC-9", this value is -540.
       * </pre>
       *
       * <code>int32 offset_minutes = 1;</code>
       *
       * @return The offsetMinutes.
       */
      @java.lang.Override
      public int getOffsetMinutes() {
        return offsetMinutes_;
      }
      /**
       *
       *
       * <pre>
       * Set only if the offset can be determined. Positive for time ahead of UTC.
       * E.g. For "UTC-9", this value is -540.
       * </pre>
       *
       * <code>int32 offset_minutes = 1;</code>
       *
       * @param value The offsetMinutes to set.
       * @return This builder for chaining.
       */
      public Builder setOffsetMinutes(int value) {

        offsetMinutes_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set only if the offset can be determined. Positive for time ahead of UTC.
       * E.g. For "UTC-9", this value is -540.
       * </pre>
       *
       * <code>int32 offset_minutes = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOffsetMinutes() {
        bitField0_ = (bitField0_ & ~0x00000001);
        offsetMinutes_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DateTime.TimeZone)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DateTime.TimeZone)
    private static final com.google.privacy.dlp.v2.DateTime.TimeZone DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DateTime.TimeZone();
    }

    public static com.google.privacy.dlp.v2.DateTime.TimeZone getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TimeZone> PARSER =
        new com.google.protobuf.AbstractParser<TimeZone>() {
          @java.lang.Override
          public TimeZone parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TimeZone> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TimeZone> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DateTime.TimeZone getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int DATE_FIELD_NUMBER = 1;
  private com.google.type.Date date_;
  /**
   *
   *
   * <pre>
   * One or more of the following must be set.
   * Must be a valid date or time value.
   * </pre>
   *
   * <code>.google.type.Date date = 1;</code>
   *
   * @return Whether the date field is set.
   */
  @java.lang.Override
  public boolean hasDate() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * One or more of the following must be set.
   * Must be a valid date or time value.
   * </pre>
   *
   * <code>.google.type.Date date = 1;</code>
   *
   * @return The date.
   */
  @java.lang.Override
  public com.google.type.Date getDate() {
    return date_ == null ? com.google.type.Date.getDefaultInstance() : date_;
  }
  /**
   *
   *
   * <pre>
   * One or more of the following must be set.
   * Must be a valid date or time value.
   * </pre>
   *
   * <code>.google.type.Date date = 1;</code>
   */
  @java.lang.Override
  public com.google.type.DateOrBuilder getDateOrBuilder() {
    return date_ == null ? com.google.type.Date.getDefaultInstance() : date_;
  }

  public static final int DAY_OF_WEEK_FIELD_NUMBER = 2;
  private int dayOfWeek_ = 0;
  /**
   *
   *
   * <pre>
   * Day of week
   * </pre>
   *
   * <code>.google.type.DayOfWeek day_of_week = 2;</code>
   *
   * @return The enum numeric value on the wire for dayOfWeek.
   */
  @java.lang.Override
  public int getDayOfWeekValue() {
    return dayOfWeek_;
  }
  /**
   *
   *
   * <pre>
   * Day of week
   * </pre>
   *
   * <code>.google.type.DayOfWeek day_of_week = 2;</code>
   *
   * @return The dayOfWeek.
   */
  @java.lang.Override
  public com.google.type.DayOfWeek getDayOfWeek() {
    com.google.type.DayOfWeek result = com.google.type.DayOfWeek.forNumber(dayOfWeek_);
    return result == null ? com.google.type.DayOfWeek.UNRECOGNIZED : result;
  }

  public static final int TIME_FIELD_NUMBER = 3;
  private com.google.type.TimeOfDay time_;
  /**
   *
   *
   * <pre>
   * Time of day
   * </pre>
   *
   * <code>.google.type.TimeOfDay time = 3;</code>
   *
   * @return Whether the time field is set.
   */
  @java.lang.Override
  public boolean hasTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Time of day
   * </pre>
   *
   * <code>.google.type.TimeOfDay time = 3;</code>
   *
   * @return The time.
   */
  @java.lang.Override
  public com.google.type.TimeOfDay getTime() {
    return time_ == null ? com.google.type.TimeOfDay.getDefaultInstance() : time_;
  }
  /**
   *
   *
   * <pre>
   * Time of day
   * </pre>
   *
   * <code>.google.type.TimeOfDay time = 3;</code>
   */
  @java.lang.Override
  public com.google.type.TimeOfDayOrBuilder getTimeOrBuilder() {
    return time_ == null ? com.google.type.TimeOfDay.getDefaultInstance() : time_;
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 4;
  private com.google.privacy.dlp.v2.DateTime.TimeZone timeZone_;
  /**
   *
   *
   * <pre>
   * Time zone
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DateTime.TimeZone time_zone = 4;</code>
   *
   * @return Whether the timeZone field is set.
   */
  @java.lang.Override
  public boolean hasTimeZone() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Time zone
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DateTime.TimeZone time_zone = 4;</code>
   *
   * @return The timeZone.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DateTime.TimeZone getTimeZone() {
    return timeZone_ == null
        ? com.google.privacy.dlp.v2.DateTime.TimeZone.getDefaultInstance()
        : timeZone_;
  }
  /**
   *
   *
   * <pre>
   * Time zone
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DateTime.TimeZone time_zone = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DateTime.TimeZoneOrBuilder getTimeZoneOrBuilder() {
    return timeZone_ == null
        ? com.google.privacy.dlp.v2.DateTime.TimeZone.getDefaultInstance()
        : timeZone_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getDate());
    }
    if (dayOfWeek_ != com.google.type.DayOfWeek.DAY_OF_WEEK_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, dayOfWeek_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getTimeZone());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDate());
    }
    if (dayOfWeek_ != com.google.type.DayOfWeek.DAY_OF_WEEK_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, dayOfWeek_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTimeZone());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.DateTime)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.DateTime other = (com.google.privacy.dlp.v2.DateTime) obj;

    if (hasDate() != other.hasDate()) return false;
    if (hasDate()) {
      if (!getDate().equals(other.getDate())) return false;
    }
    if (dayOfWeek_ != other.dayOfWeek_) return false;
    if (hasTime() != other.hasTime()) return false;
    if (hasTime()) {
      if (!getTime().equals(other.getTime())) return false;
    }
    if (hasTimeZone() != other.hasTimeZone()) return false;
    if (hasTimeZone()) {
      if (!getTimeZone().equals(other.getTimeZone())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDate()) {
      hash = (37 * hash) + DATE_FIELD_NUMBER;
      hash = (53 * hash) + getDate().hashCode();
    }
    hash = (37 * hash) + DAY_OF_WEEK_FIELD_NUMBER;
    hash = (53 * hash) + dayOfWeek_;
    if (hasTime()) {
      hash = (37 * hash) + TIME_FIELD_NUMBER;
      hash = (53 * hash) + getTime().hashCode();
    }
    if (hasTimeZone()) {
      hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getTimeZone().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.DateTime parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DateTime parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DateTime parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DateTime parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DateTime parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DateTime parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DateTime parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DateTime parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DateTime parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DateTime parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DateTime parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DateTime parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.DateTime prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Message for a date time object.
   * e.g. 2018-01-01, 5th August.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DateTime}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DateTime)
      com.google.privacy.dlp.v2.DateTimeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DateTime_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DateTime_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DateTime.class,
              com.google.privacy.dlp.v2.DateTime.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.DateTime.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDateFieldBuilder();
        getTimeFieldBuilder();
        getTimeZoneFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      date_ = null;
      if (dateBuilder_ != null) {
        dateBuilder_.dispose();
        dateBuilder_ = null;
      }
      dayOfWeek_ = 0;
      time_ = null;
      if (timeBuilder_ != null) {
        timeBuilder_.dispose();
        timeBuilder_ = null;
      }
      timeZone_ = null;
      if (timeZoneBuilder_ != null) {
        timeZoneBuilder_.dispose();
        timeZoneBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DateTime_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DateTime getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.DateTime.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DateTime build() {
      com.google.privacy.dlp.v2.DateTime result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DateTime buildPartial() {
      com.google.privacy.dlp.v2.DateTime result = new com.google.privacy.dlp.v2.DateTime(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.DateTime result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.date_ = dateBuilder_ == null ? date_ : dateBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dayOfWeek_ = dayOfWeek_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.time_ = timeBuilder_ == null ? time_ : timeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.timeZone_ = timeZoneBuilder_ == null ? timeZone_ : timeZoneBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.DateTime) {
        return mergeFrom((com.google.privacy.dlp.v2.DateTime) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.DateTime other) {
      if (other == com.google.privacy.dlp.v2.DateTime.getDefaultInstance()) return this;
      if (other.hasDate()) {
        mergeDate(other.getDate());
      }
      if (other.dayOfWeek_ != 0) {
        setDayOfWeekValue(other.getDayOfWeekValue());
      }
      if (other.hasTime()) {
        mergeTime(other.getTime());
      }
      if (other.hasTimeZone()) {
        mergeTimeZone(other.getTimeZone());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                dayOfWeek_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getTimeZoneFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.type.Date date_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
        dateBuilder_;
    /**
     *
     *
     * <pre>
     * One or more of the following must be set.
     * Must be a valid date or time value.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     *
     * @return Whether the date field is set.
     */
    public boolean hasDate() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * One or more of the following must be set.
     * Must be a valid date or time value.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     *
     * @return The date.
     */
    public com.google.type.Date getDate() {
      if (dateBuilder_ == null) {
        return date_ == null ? com.google.type.Date.getDefaultInstance() : date_;
      } else {
        return dateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * One or more of the following must be set.
     * Must be a valid date or time value.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     */
    public Builder setDate(com.google.type.Date value) {
      if (dateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        date_ = value;
      } else {
        dateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more of the following must be set.
     * Must be a valid date or time value.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     */
    public Builder setDate(com.google.type.Date.Builder builderForValue) {
      if (dateBuilder_ == null) {
        date_ = builderForValue.build();
      } else {
        dateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more of the following must be set.
     * Must be a valid date or time value.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     */
    public Builder mergeDate(com.google.type.Date value) {
      if (dateBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && date_ != null
            && date_ != com.google.type.Date.getDefaultInstance()) {
          getDateBuilder().mergeFrom(value);
        } else {
          date_ = value;
        }
      } else {
        dateBuilder_.mergeFrom(value);
      }
      if (date_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more of the following must be set.
     * Must be a valid date or time value.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     */
    public Builder clearDate() {
      bitField0_ = (bitField0_ & ~0x00000001);
      date_ = null;
      if (dateBuilder_ != null) {
        dateBuilder_.dispose();
        dateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more of the following must be set.
     * Must be a valid date or time value.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     */
    public com.google.type.Date.Builder getDateBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getDateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * One or more of the following must be set.
     * Must be a valid date or time value.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     */
    public com.google.type.DateOrBuilder getDateOrBuilder() {
      if (dateBuilder_ != null) {
        return dateBuilder_.getMessageOrBuilder();
      } else {
        return date_ == null ? com.google.type.Date.getDefaultInstance() : date_;
      }
    }
    /**
     *
     *
     * <pre>
     * One or more of the following must be set.
     * Must be a valid date or time value.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
        getDateFieldBuilder() {
      if (dateBuilder_ == null) {
        dateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>(
                getDate(), getParentForChildren(), isClean());
        date_ = null;
      }
      return dateBuilder_;
    }

    private int dayOfWeek_ = 0;
    /**
     *
     *
     * <pre>
     * Day of week
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week = 2;</code>
     *
     * @return The enum numeric value on the wire for dayOfWeek.
     */
    @java.lang.Override
    public int getDayOfWeekValue() {
      return dayOfWeek_;
    }
    /**
     *
     *
     * <pre>
     * Day of week
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week = 2;</code>
     *
     * @param value The enum numeric value on the wire for dayOfWeek to set.
     * @return This builder for chaining.
     */
    public Builder setDayOfWeekValue(int value) {
      dayOfWeek_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Day of week
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week = 2;</code>
     *
     * @return The dayOfWeek.
     */
    @java.lang.Override
    public com.google.type.DayOfWeek getDayOfWeek() {
      com.google.type.DayOfWeek result = com.google.type.DayOfWeek.forNumber(dayOfWeek_);
      return result == null ? com.google.type.DayOfWeek.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Day of week
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week = 2;</code>
     *
     * @param value The dayOfWeek to set.
     * @return This builder for chaining.
     */
    public Builder setDayOfWeek(com.google.type.DayOfWeek value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      dayOfWeek_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Day of week
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDayOfWeek() {
      bitField0_ = (bitField0_ & ~0x00000002);
      dayOfWeek_ = 0;
      onChanged();
      return this;
    }

    private com.google.type.TimeOfDay time_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.TimeOfDay,
            com.google.type.TimeOfDay.Builder,
            com.google.type.TimeOfDayOrBuilder>
        timeBuilder_;
    /**
     *
     *
     * <pre>
     * Time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time = 3;</code>
     *
     * @return Whether the time field is set.
     */
    public boolean hasTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time = 3;</code>
     *
     * @return The time.
     */
    public com.google.type.TimeOfDay getTime() {
      if (timeBuilder_ == null) {
        return time_ == null ? com.google.type.TimeOfDay.getDefaultInstance() : time_;
      } else {
        return timeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time = 3;</code>
     */
    public Builder setTime(com.google.type.TimeOfDay value) {
      if (timeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        time_ = value;
      } else {
        timeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time = 3;</code>
     */
    public Builder setTime(com.google.type.TimeOfDay.Builder builderForValue) {
      if (timeBuilder_ == null) {
        time_ = builderForValue.build();
      } else {
        timeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time = 3;</code>
     */
    public Builder mergeTime(com.google.type.TimeOfDay value) {
      if (timeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && time_ != null
            && time_ != com.google.type.TimeOfDay.getDefaultInstance()) {
          getTimeBuilder().mergeFrom(value);
        } else {
          time_ = value;
        }
      } else {
        timeBuilder_.mergeFrom(value);
      }
      if (time_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time = 3;</code>
     */
    public Builder clearTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      time_ = null;
      if (timeBuilder_ != null) {
        timeBuilder_.dispose();
        timeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time = 3;</code>
     */
    public com.google.type.TimeOfDay.Builder getTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time = 3;</code>
     */
    public com.google.type.TimeOfDayOrBuilder getTimeOrBuilder() {
      if (timeBuilder_ != null) {
        return timeBuilder_.getMessageOrBuilder();
      } else {
        return time_ == null ? com.google.type.TimeOfDay.getDefaultInstance() : time_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.TimeOfDay,
            com.google.type.TimeOfDay.Builder,
            com.google.type.TimeOfDayOrBuilder>
        getTimeFieldBuilder() {
      if (timeBuilder_ == null) {
        timeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.TimeOfDay,
                com.google.type.TimeOfDay.Builder,
                com.google.type.TimeOfDayOrBuilder>(getTime(), getParentForChildren(), isClean());
        time_ = null;
      }
      return timeBuilder_;
    }

    private com.google.privacy.dlp.v2.DateTime.TimeZone timeZone_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DateTime.TimeZone,
            com.google.privacy.dlp.v2.DateTime.TimeZone.Builder,
            com.google.privacy.dlp.v2.DateTime.TimeZoneOrBuilder>
        timeZoneBuilder_;
    /**
     *
     *
     * <pre>
     * Time zone
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateTime.TimeZone time_zone = 4;</code>
     *
     * @return Whether the timeZone field is set.
     */
    public boolean hasTimeZone() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time zone
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateTime.TimeZone time_zone = 4;</code>
     *
     * @return The timeZone.
     */
    public com.google.privacy.dlp.v2.DateTime.TimeZone getTimeZone() {
      if (timeZoneBuilder_ == null) {
        return timeZone_ == null
            ? com.google.privacy.dlp.v2.DateTime.TimeZone.getDefaultInstance()
            : timeZone_;
      } else {
        return timeZoneBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time zone
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateTime.TimeZone time_zone = 4;</code>
     */
    public Builder setTimeZone(com.google.privacy.dlp.v2.DateTime.TimeZone value) {
      if (timeZoneBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeZone_ = value;
      } else {
        timeZoneBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time zone
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateTime.TimeZone time_zone = 4;</code>
     */
    public Builder setTimeZone(
        com.google.privacy.dlp.v2.DateTime.TimeZone.Builder builderForValue) {
      if (timeZoneBuilder_ == null) {
        timeZone_ = builderForValue.build();
      } else {
        timeZoneBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time zone
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateTime.TimeZone time_zone = 4;</code>
     */
    public Builder mergeTimeZone(com.google.privacy.dlp.v2.DateTime.TimeZone value) {
      if (timeZoneBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && timeZone_ != null
            && timeZone_ != com.google.privacy.dlp.v2.DateTime.TimeZone.getDefaultInstance()) {
          getTimeZoneBuilder().mergeFrom(value);
        } else {
          timeZone_ = value;
        }
      } else {
        timeZoneBuilder_.mergeFrom(value);
      }
      if (timeZone_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time zone
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateTime.TimeZone time_zone = 4;</code>
     */
    public Builder clearTimeZone() {
      bitField0_ = (bitField0_ & ~0x00000008);
      timeZone_ = null;
      if (timeZoneBuilder_ != null) {
        timeZoneBuilder_.dispose();
        timeZoneBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time zone
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateTime.TimeZone time_zone = 4;</code>
     */
    public com.google.privacy.dlp.v2.DateTime.TimeZone.Builder getTimeZoneBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getTimeZoneFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time zone
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateTime.TimeZone time_zone = 4;</code>
     */
    public com.google.privacy.dlp.v2.DateTime.TimeZoneOrBuilder getTimeZoneOrBuilder() {
      if (timeZoneBuilder_ != null) {
        return timeZoneBuilder_.getMessageOrBuilder();
      } else {
        return timeZone_ == null
            ? com.google.privacy.dlp.v2.DateTime.TimeZone.getDefaultInstance()
            : timeZone_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time zone
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateTime.TimeZone time_zone = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DateTime.TimeZone,
            com.google.privacy.dlp.v2.DateTime.TimeZone.Builder,
            com.google.privacy.dlp.v2.DateTime.TimeZoneOrBuilder>
        getTimeZoneFieldBuilder() {
      if (timeZoneBuilder_ == null) {
        timeZoneBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DateTime.TimeZone,
                com.google.privacy.dlp.v2.DateTime.TimeZone.Builder,
                com.google.privacy.dlp.v2.DateTime.TimeZoneOrBuilder>(
                getTimeZone(), getParentForChildren(), isClean());
        timeZone_ = null;
      }
      return timeZoneBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DateTime)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DateTime)
  private static final com.google.privacy.dlp.v2.DateTime DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DateTime();
  }

  public static com.google.privacy.dlp.v2.DateTime getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DateTime> PARSER =
      new com.google.protobuf.AbstractParser<DateTime>() {
        @java.lang.Override
        public DateTime parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DateTime> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DateTime> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.DateTime getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
