/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Requirements that must be true before a table is scanned in discovery for the
 * first time. There is an AND relationship between the top-level attributes.
 * Additionally, minimum conditions with an OR relationship that must be met
 * before Cloud DLP scans a table can be set (like a minimum row count or a
 * minimum table age).
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.DiscoveryBigQueryConditions}
 */
public final class DiscoveryBigQueryConditions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DiscoveryBigQueryConditions)
    DiscoveryBigQueryConditionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DiscoveryBigQueryConditions.newBuilder() to construct.
  private DiscoveryBigQueryConditions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DiscoveryBigQueryConditions() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DiscoveryBigQueryConditions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryConditions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryConditions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.class,
            com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.Builder.class);
  }

  public interface OrConditionsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Minimum number of rows that should be present before Cloud DLP
     * profiles a table
     * </pre>
     *
     * <code>int32 min_row_count = 1;</code>
     *
     * @return The minRowCount.
     */
    int getMinRowCount();

    /**
     *
     *
     * <pre>
     * Minimum age a table must have before Cloud DLP can profile it. Value must
     * be 1 hour or greater.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_age = 2;</code>
     *
     * @return Whether the minAge field is set.
     */
    boolean hasMinAge();
    /**
     *
     *
     * <pre>
     * Minimum age a table must have before Cloud DLP can profile it. Value must
     * be 1 hour or greater.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_age = 2;</code>
     *
     * @return The minAge.
     */
    com.google.protobuf.Duration getMinAge();
    /**
     *
     *
     * <pre>
     * Minimum age a table must have before Cloud DLP can profile it. Value must
     * be 1 hour or greater.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_age = 2;</code>
     */
    com.google.protobuf.DurationOrBuilder getMinAgeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * There is an OR relationship between these attributes. They are used to
   * determine if a table should be scanned or not in Discovery.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions}
   */
  public static final class OrConditions extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions)
      OrConditionsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OrConditions.newBuilder() to construct.
    private OrConditions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OrConditions() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OrConditions();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryConditions_OrConditions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryConditions_OrConditions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions.class,
              com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions.Builder.class);
    }

    private int bitField0_;
    public static final int MIN_ROW_COUNT_FIELD_NUMBER = 1;
    private int minRowCount_ = 0;
    /**
     *
     *
     * <pre>
     * Minimum number of rows that should be present before Cloud DLP
     * profiles a table
     * </pre>
     *
     * <code>int32 min_row_count = 1;</code>
     *
     * @return The minRowCount.
     */
    @java.lang.Override
    public int getMinRowCount() {
      return minRowCount_;
    }

    public static final int MIN_AGE_FIELD_NUMBER = 2;
    private com.google.protobuf.Duration minAge_;
    /**
     *
     *
     * <pre>
     * Minimum age a table must have before Cloud DLP can profile it. Value must
     * be 1 hour or greater.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_age = 2;</code>
     *
     * @return Whether the minAge field is set.
     */
    @java.lang.Override
    public boolean hasMinAge() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Minimum age a table must have before Cloud DLP can profile it. Value must
     * be 1 hour or greater.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_age = 2;</code>
     *
     * @return The minAge.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getMinAge() {
      return minAge_ == null ? com.google.protobuf.Duration.getDefaultInstance() : minAge_;
    }
    /**
     *
     *
     * <pre>
     * Minimum age a table must have before Cloud DLP can profile it. Value must
     * be 1 hour or greater.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_age = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getMinAgeOrBuilder() {
      return minAge_ == null ? com.google.protobuf.Duration.getDefaultInstance() : minAge_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (minRowCount_ != 0) {
        output.writeInt32(1, minRowCount_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getMinAge());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (minRowCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, minRowCount_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMinAge());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions other =
          (com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions) obj;

      if (getMinRowCount() != other.getMinRowCount()) return false;
      if (hasMinAge() != other.hasMinAge()) return false;
      if (hasMinAge()) {
        if (!getMinAge().equals(other.getMinAge())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MIN_ROW_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getMinRowCount();
      if (hasMinAge()) {
        hash = (37 * hash) + MIN_AGE_FIELD_NUMBER;
        hash = (53 * hash) + getMinAge().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * There is an OR relationship between these attributes. They are used to
     * determine if a table should be scanned or not in Discovery.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions)
        com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryConditions_OrConditions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryConditions_OrConditions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions.class,
                com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions.Builder.class);
      }

      // Construct using
      // com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMinAgeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        minRowCount_ = 0;
        minAge_ = null;
        if (minAgeBuilder_ != null) {
          minAgeBuilder_.dispose();
          minAgeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryConditions_OrConditions_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions
          getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions build() {
        com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions buildPartial() {
        com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions result =
            new com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.minRowCount_ = minRowCount_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.minAge_ = minAgeBuilder_ == null ? minAge_ : minAgeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions) {
          return mergeFrom(
              (com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions other) {
        if (other
            == com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions
                .getDefaultInstance()) return this;
        if (other.getMinRowCount() != 0) {
          setMinRowCount(other.getMinRowCount());
        }
        if (other.hasMinAge()) {
          mergeMinAge(other.getMinAge());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  minRowCount_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(getMinAgeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int minRowCount_;
      /**
       *
       *
       * <pre>
       * Minimum number of rows that should be present before Cloud DLP
       * profiles a table
       * </pre>
       *
       * <code>int32 min_row_count = 1;</code>
       *
       * @return The minRowCount.
       */
      @java.lang.Override
      public int getMinRowCount() {
        return minRowCount_;
      }
      /**
       *
       *
       * <pre>
       * Minimum number of rows that should be present before Cloud DLP
       * profiles a table
       * </pre>
       *
       * <code>int32 min_row_count = 1;</code>
       *
       * @param value The minRowCount to set.
       * @return This builder for chaining.
       */
      public Builder setMinRowCount(int value) {

        minRowCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Minimum number of rows that should be present before Cloud DLP
       * profiles a table
       * </pre>
       *
       * <code>int32 min_row_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinRowCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        minRowCount_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Duration minAge_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          minAgeBuilder_;
      /**
       *
       *
       * <pre>
       * Minimum age a table must have before Cloud DLP can profile it. Value must
       * be 1 hour or greater.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_age = 2;</code>
       *
       * @return Whether the minAge field is set.
       */
      public boolean hasMinAge() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Minimum age a table must have before Cloud DLP can profile it. Value must
       * be 1 hour or greater.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_age = 2;</code>
       *
       * @return The minAge.
       */
      public com.google.protobuf.Duration getMinAge() {
        if (minAgeBuilder_ == null) {
          return minAge_ == null ? com.google.protobuf.Duration.getDefaultInstance() : minAge_;
        } else {
          return minAgeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Minimum age a table must have before Cloud DLP can profile it. Value must
       * be 1 hour or greater.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_age = 2;</code>
       */
      public Builder setMinAge(com.google.protobuf.Duration value) {
        if (minAgeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          minAge_ = value;
        } else {
          minAgeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Minimum age a table must have before Cloud DLP can profile it. Value must
       * be 1 hour or greater.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_age = 2;</code>
       */
      public Builder setMinAge(com.google.protobuf.Duration.Builder builderForValue) {
        if (minAgeBuilder_ == null) {
          minAge_ = builderForValue.build();
        } else {
          minAgeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Minimum age a table must have before Cloud DLP can profile it. Value must
       * be 1 hour or greater.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_age = 2;</code>
       */
      public Builder mergeMinAge(com.google.protobuf.Duration value) {
        if (minAgeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && minAge_ != null
              && minAge_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getMinAgeBuilder().mergeFrom(value);
          } else {
            minAge_ = value;
          }
        } else {
          minAgeBuilder_.mergeFrom(value);
        }
        if (minAge_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Minimum age a table must have before Cloud DLP can profile it. Value must
       * be 1 hour or greater.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_age = 2;</code>
       */
      public Builder clearMinAge() {
        bitField0_ = (bitField0_ & ~0x00000002);
        minAge_ = null;
        if (minAgeBuilder_ != null) {
          minAgeBuilder_.dispose();
          minAgeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Minimum age a table must have before Cloud DLP can profile it. Value must
       * be 1 hour or greater.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_age = 2;</code>
       */
      public com.google.protobuf.Duration.Builder getMinAgeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getMinAgeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Minimum age a table must have before Cloud DLP can profile it. Value must
       * be 1 hour or greater.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_age = 2;</code>
       */
      public com.google.protobuf.DurationOrBuilder getMinAgeOrBuilder() {
        if (minAgeBuilder_ != null) {
          return minAgeBuilder_.getMessageOrBuilder();
        } else {
          return minAge_ == null ? com.google.protobuf.Duration.getDefaultInstance() : minAge_;
        }
      }
      /**
       *
       *
       * <pre>
       * Minimum age a table must have before Cloud DLP can profile it. Value must
       * be 1 hour or greater.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_age = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getMinAgeFieldBuilder() {
        if (minAgeBuilder_ == null) {
          minAgeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getMinAge(), getParentForChildren(), isClean());
          minAge_ = null;
        }
        return minAgeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions)
    private static final com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions();
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OrConditions> PARSER =
        new com.google.protobuf.AbstractParser<OrConditions>() {
          @java.lang.Override
          public OrConditions parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OrConditions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OrConditions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int includedTypesCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object includedTypes_;

  public enum IncludedTypesCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TYPES(2),
    TYPE_COLLECTION(3),
    INCLUDEDTYPES_NOT_SET(0);
    private final int value;

    private IncludedTypesCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IncludedTypesCase valueOf(int value) {
      return forNumber(value);
    }

    public static IncludedTypesCase forNumber(int value) {
      switch (value) {
        case 2:
          return TYPES;
        case 3:
          return TYPE_COLLECTION;
        case 0:
          return INCLUDEDTYPES_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public IncludedTypesCase getIncludedTypesCase() {
    return IncludedTypesCase.forNumber(includedTypesCase_);
  }

  public static final int CREATED_AFTER_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp createdAfter_;
  /**
   *
   *
   * <pre>
   * BigQuery table must have been created after this date. Used to avoid
   * backfilling.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp created_after = 1;</code>
   *
   * @return Whether the createdAfter field is set.
   */
  @java.lang.Override
  public boolean hasCreatedAfter() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * BigQuery table must have been created after this date. Used to avoid
   * backfilling.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp created_after = 1;</code>
   *
   * @return The createdAfter.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreatedAfter() {
    return createdAfter_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : createdAfter_;
  }
  /**
   *
   *
   * <pre>
   * BigQuery table must have been created after this date. Used to avoid
   * backfilling.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp created_after = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreatedAfterOrBuilder() {
    return createdAfter_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : createdAfter_;
  }

  public static final int TYPES_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Restrict discovery to specific table types.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTableTypes types = 2;</code>
   *
   * @return Whether the types field is set.
   */
  @java.lang.Override
  public boolean hasTypes() {
    return includedTypesCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Restrict discovery to specific table types.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTableTypes types = 2;</code>
   *
   * @return The types.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryTableTypes getTypes() {
    if (includedTypesCase_ == 2) {
      return (com.google.privacy.dlp.v2.BigQueryTableTypes) includedTypes_;
    }
    return com.google.privacy.dlp.v2.BigQueryTableTypes.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Restrict discovery to specific table types.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTableTypes types = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryTableTypesOrBuilder getTypesOrBuilder() {
    if (includedTypesCase_ == 2) {
      return (com.google.privacy.dlp.v2.BigQueryTableTypes) includedTypes_;
    }
    return com.google.privacy.dlp.v2.BigQueryTableTypes.getDefaultInstance();
  }

  public static final int TYPE_COLLECTION_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Restrict discovery to categories of table types.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTableTypeCollection type_collection = 3;</code>
   *
   * @return Whether the typeCollection field is set.
   */
  public boolean hasTypeCollection() {
    return includedTypesCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Restrict discovery to categories of table types.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTableTypeCollection type_collection = 3;</code>
   *
   * @return The enum numeric value on the wire for typeCollection.
   */
  public int getTypeCollectionValue() {
    if (includedTypesCase_ == 3) {
      return (java.lang.Integer) includedTypes_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * Restrict discovery to categories of table types.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTableTypeCollection type_collection = 3;</code>
   *
   * @return The typeCollection.
   */
  public com.google.privacy.dlp.v2.BigQueryTableTypeCollection getTypeCollection() {
    if (includedTypesCase_ == 3) {
      com.google.privacy.dlp.v2.BigQueryTableTypeCollection result =
          com.google.privacy.dlp.v2.BigQueryTableTypeCollection.forNumber(
              (java.lang.Integer) includedTypes_);
      return result == null
          ? com.google.privacy.dlp.v2.BigQueryTableTypeCollection.UNRECOGNIZED
          : result;
    }
    return com.google.privacy.dlp.v2.BigQueryTableTypeCollection.BIG_QUERY_COLLECTION_UNSPECIFIED;
  }

  public static final int OR_CONDITIONS_FIELD_NUMBER = 4;
  private com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions orConditions_;
  /**
   *
   *
   * <pre>
   * At least one of the conditions must be true for a table to be scanned.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions or_conditions = 4;</code>
   *
   * @return Whether the orConditions field is set.
   */
  @java.lang.Override
  public boolean hasOrConditions() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * At least one of the conditions must be true for a table to be scanned.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions or_conditions = 4;</code>
   *
   * @return The orConditions.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions getOrConditions() {
    return orConditions_ == null
        ? com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions.getDefaultInstance()
        : orConditions_;
  }
  /**
   *
   *
   * <pre>
   * At least one of the conditions must be true for a table to be scanned.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions or_conditions = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditionsOrBuilder
      getOrConditionsOrBuilder() {
    return orConditions_ == null
        ? com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions.getDefaultInstance()
        : orConditions_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getCreatedAfter());
    }
    if (includedTypesCase_ == 2) {
      output.writeMessage(2, (com.google.privacy.dlp.v2.BigQueryTableTypes) includedTypes_);
    }
    if (includedTypesCase_ == 3) {
      output.writeEnum(3, ((java.lang.Integer) includedTypes_));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getOrConditions());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCreatedAfter());
    }
    if (includedTypesCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.privacy.dlp.v2.BigQueryTableTypes) includedTypes_);
    }
    if (includedTypesCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              3, ((java.lang.Integer) includedTypes_));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getOrConditions());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.DiscoveryBigQueryConditions)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.DiscoveryBigQueryConditions other =
        (com.google.privacy.dlp.v2.DiscoveryBigQueryConditions) obj;

    if (hasCreatedAfter() != other.hasCreatedAfter()) return false;
    if (hasCreatedAfter()) {
      if (!getCreatedAfter().equals(other.getCreatedAfter())) return false;
    }
    if (hasOrConditions() != other.hasOrConditions()) return false;
    if (hasOrConditions()) {
      if (!getOrConditions().equals(other.getOrConditions())) return false;
    }
    if (!getIncludedTypesCase().equals(other.getIncludedTypesCase())) return false;
    switch (includedTypesCase_) {
      case 2:
        if (!getTypes().equals(other.getTypes())) return false;
        break;
      case 3:
        if (getTypeCollectionValue() != other.getTypeCollectionValue()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreatedAfter()) {
      hash = (37 * hash) + CREATED_AFTER_FIELD_NUMBER;
      hash = (53 * hash) + getCreatedAfter().hashCode();
    }
    if (hasOrConditions()) {
      hash = (37 * hash) + OR_CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getOrConditions().hashCode();
    }
    switch (includedTypesCase_) {
      case 2:
        hash = (37 * hash) + TYPES_FIELD_NUMBER;
        hash = (53 * hash) + getTypes().hashCode();
        break;
      case 3:
        hash = (37 * hash) + TYPE_COLLECTION_FIELD_NUMBER;
        hash = (53 * hash) + getTypeCollectionValue();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.privacy.dlp.v2.DiscoveryBigQueryConditions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Requirements that must be true before a table is scanned in discovery for the
   * first time. There is an AND relationship between the top-level attributes.
   * Additionally, minimum conditions with an OR relationship that must be met
   * before Cloud DLP scans a table can be set (like a minimum row count or a
   * minimum table age).
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DiscoveryBigQueryConditions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DiscoveryBigQueryConditions)
      com.google.privacy.dlp.v2.DiscoveryBigQueryConditionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryConditions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryConditions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.class,
              com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreatedAfterFieldBuilder();
        getOrConditionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      createdAfter_ = null;
      if (createdAfterBuilder_ != null) {
        createdAfterBuilder_.dispose();
        createdAfterBuilder_ = null;
      }
      if (typesBuilder_ != null) {
        typesBuilder_.clear();
      }
      orConditions_ = null;
      if (orConditionsBuilder_ != null) {
        orConditionsBuilder_.dispose();
        orConditionsBuilder_ = null;
      }
      includedTypesCase_ = 0;
      includedTypes_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryConditions_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryBigQueryConditions getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryBigQueryConditions build() {
      com.google.privacy.dlp.v2.DiscoveryBigQueryConditions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryBigQueryConditions buildPartial() {
      com.google.privacy.dlp.v2.DiscoveryBigQueryConditions result =
          new com.google.privacy.dlp.v2.DiscoveryBigQueryConditions(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.DiscoveryBigQueryConditions result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.createdAfter_ =
            createdAfterBuilder_ == null ? createdAfter_ : createdAfterBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.orConditions_ =
            orConditionsBuilder_ == null ? orConditions_ : orConditionsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.DiscoveryBigQueryConditions result) {
      result.includedTypesCase_ = includedTypesCase_;
      result.includedTypes_ = this.includedTypes_;
      if (includedTypesCase_ == 2 && typesBuilder_ != null) {
        result.includedTypes_ = typesBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.DiscoveryBigQueryConditions) {
        return mergeFrom((com.google.privacy.dlp.v2.DiscoveryBigQueryConditions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.DiscoveryBigQueryConditions other) {
      if (other == com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.getDefaultInstance())
        return this;
      if (other.hasCreatedAfter()) {
        mergeCreatedAfter(other.getCreatedAfter());
      }
      if (other.hasOrConditions()) {
        mergeOrConditions(other.getOrConditions());
      }
      switch (other.getIncludedTypesCase()) {
        case TYPES:
          {
            mergeTypes(other.getTypes());
            break;
          }
        case TYPE_COLLECTION:
          {
            setTypeCollectionValue(other.getTypeCollectionValue());
            break;
          }
        case INCLUDEDTYPES_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCreatedAfterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getTypesFieldBuilder().getBuilder(), extensionRegistry);
                includedTypesCase_ = 2;
                break;
              } // case 18
            case 24:
              {
                int rawValue = input.readEnum();
                includedTypesCase_ = 3;
                includedTypes_ = rawValue;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getOrConditionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int includedTypesCase_ = 0;
    private java.lang.Object includedTypes_;

    public IncludedTypesCase getIncludedTypesCase() {
      return IncludedTypesCase.forNumber(includedTypesCase_);
    }

    public Builder clearIncludedTypes() {
      includedTypesCase_ = 0;
      includedTypes_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp createdAfter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createdAfterBuilder_;
    /**
     *
     *
     * <pre>
     * BigQuery table must have been created after this date. Used to avoid
     * backfilling.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_after = 1;</code>
     *
     * @return Whether the createdAfter field is set.
     */
    public boolean hasCreatedAfter() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * BigQuery table must have been created after this date. Used to avoid
     * backfilling.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_after = 1;</code>
     *
     * @return The createdAfter.
     */
    public com.google.protobuf.Timestamp getCreatedAfter() {
      if (createdAfterBuilder_ == null) {
        return createdAfter_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createdAfter_;
      } else {
        return createdAfterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * BigQuery table must have been created after this date. Used to avoid
     * backfilling.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_after = 1;</code>
     */
    public Builder setCreatedAfter(com.google.protobuf.Timestamp value) {
      if (createdAfterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createdAfter_ = value;
      } else {
        createdAfterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery table must have been created after this date. Used to avoid
     * backfilling.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_after = 1;</code>
     */
    public Builder setCreatedAfter(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createdAfterBuilder_ == null) {
        createdAfter_ = builderForValue.build();
      } else {
        createdAfterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery table must have been created after this date. Used to avoid
     * backfilling.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_after = 1;</code>
     */
    public Builder mergeCreatedAfter(com.google.protobuf.Timestamp value) {
      if (createdAfterBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && createdAfter_ != null
            && createdAfter_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreatedAfterBuilder().mergeFrom(value);
        } else {
          createdAfter_ = value;
        }
      } else {
        createdAfterBuilder_.mergeFrom(value);
      }
      if (createdAfter_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery table must have been created after this date. Used to avoid
     * backfilling.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_after = 1;</code>
     */
    public Builder clearCreatedAfter() {
      bitField0_ = (bitField0_ & ~0x00000001);
      createdAfter_ = null;
      if (createdAfterBuilder_ != null) {
        createdAfterBuilder_.dispose();
        createdAfterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery table must have been created after this date. Used to avoid
     * backfilling.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_after = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreatedAfterBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCreatedAfterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * BigQuery table must have been created after this date. Used to avoid
     * backfilling.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_after = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreatedAfterOrBuilder() {
      if (createdAfterBuilder_ != null) {
        return createdAfterBuilder_.getMessageOrBuilder();
      } else {
        return createdAfter_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createdAfter_;
      }
    }
    /**
     *
     *
     * <pre>
     * BigQuery table must have been created after this date. Used to avoid
     * backfilling.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_after = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreatedAfterFieldBuilder() {
      if (createdAfterBuilder_ == null) {
        createdAfterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreatedAfter(), getParentForChildren(), isClean());
        createdAfter_ = null;
      }
      return createdAfterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BigQueryTableTypes,
            com.google.privacy.dlp.v2.BigQueryTableTypes.Builder,
            com.google.privacy.dlp.v2.BigQueryTableTypesOrBuilder>
        typesBuilder_;
    /**
     *
     *
     * <pre>
     * Restrict discovery to specific table types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableTypes types = 2;</code>
     *
     * @return Whether the types field is set.
     */
    @java.lang.Override
    public boolean hasTypes() {
      return includedTypesCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Restrict discovery to specific table types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableTypes types = 2;</code>
     *
     * @return The types.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryTableTypes getTypes() {
      if (typesBuilder_ == null) {
        if (includedTypesCase_ == 2) {
          return (com.google.privacy.dlp.v2.BigQueryTableTypes) includedTypes_;
        }
        return com.google.privacy.dlp.v2.BigQueryTableTypes.getDefaultInstance();
      } else {
        if (includedTypesCase_ == 2) {
          return typesBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.BigQueryTableTypes.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Restrict discovery to specific table types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableTypes types = 2;</code>
     */
    public Builder setTypes(com.google.privacy.dlp.v2.BigQueryTableTypes value) {
      if (typesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        includedTypes_ = value;
        onChanged();
      } else {
        typesBuilder_.setMessage(value);
      }
      includedTypesCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restrict discovery to specific table types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableTypes types = 2;</code>
     */
    public Builder setTypes(com.google.privacy.dlp.v2.BigQueryTableTypes.Builder builderForValue) {
      if (typesBuilder_ == null) {
        includedTypes_ = builderForValue.build();
        onChanged();
      } else {
        typesBuilder_.setMessage(builderForValue.build());
      }
      includedTypesCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restrict discovery to specific table types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableTypes types = 2;</code>
     */
    public Builder mergeTypes(com.google.privacy.dlp.v2.BigQueryTableTypes value) {
      if (typesBuilder_ == null) {
        if (includedTypesCase_ == 2
            && includedTypes_
                != com.google.privacy.dlp.v2.BigQueryTableTypes.getDefaultInstance()) {
          includedTypes_ =
              com.google.privacy.dlp.v2.BigQueryTableTypes.newBuilder(
                      (com.google.privacy.dlp.v2.BigQueryTableTypes) includedTypes_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          includedTypes_ = value;
        }
        onChanged();
      } else {
        if (includedTypesCase_ == 2) {
          typesBuilder_.mergeFrom(value);
        } else {
          typesBuilder_.setMessage(value);
        }
      }
      includedTypesCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restrict discovery to specific table types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableTypes types = 2;</code>
     */
    public Builder clearTypes() {
      if (typesBuilder_ == null) {
        if (includedTypesCase_ == 2) {
          includedTypesCase_ = 0;
          includedTypes_ = null;
          onChanged();
        }
      } else {
        if (includedTypesCase_ == 2) {
          includedTypesCase_ = 0;
          includedTypes_ = null;
        }
        typesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restrict discovery to specific table types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableTypes types = 2;</code>
     */
    public com.google.privacy.dlp.v2.BigQueryTableTypes.Builder getTypesBuilder() {
      return getTypesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Restrict discovery to specific table types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableTypes types = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryTableTypesOrBuilder getTypesOrBuilder() {
      if ((includedTypesCase_ == 2) && (typesBuilder_ != null)) {
        return typesBuilder_.getMessageOrBuilder();
      } else {
        if (includedTypesCase_ == 2) {
          return (com.google.privacy.dlp.v2.BigQueryTableTypes) includedTypes_;
        }
        return com.google.privacy.dlp.v2.BigQueryTableTypes.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Restrict discovery to specific table types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableTypes types = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BigQueryTableTypes,
            com.google.privacy.dlp.v2.BigQueryTableTypes.Builder,
            com.google.privacy.dlp.v2.BigQueryTableTypesOrBuilder>
        getTypesFieldBuilder() {
      if (typesBuilder_ == null) {
        if (!(includedTypesCase_ == 2)) {
          includedTypes_ = com.google.privacy.dlp.v2.BigQueryTableTypes.getDefaultInstance();
        }
        typesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.BigQueryTableTypes,
                com.google.privacy.dlp.v2.BigQueryTableTypes.Builder,
                com.google.privacy.dlp.v2.BigQueryTableTypesOrBuilder>(
                (com.google.privacy.dlp.v2.BigQueryTableTypes) includedTypes_,
                getParentForChildren(),
                isClean());
        includedTypes_ = null;
      }
      includedTypesCase_ = 2;
      onChanged();
      return typesBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Restrict discovery to categories of table types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableTypeCollection type_collection = 3;</code>
     *
     * @return Whether the typeCollection field is set.
     */
    @java.lang.Override
    public boolean hasTypeCollection() {
      return includedTypesCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Restrict discovery to categories of table types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableTypeCollection type_collection = 3;</code>
     *
     * @return The enum numeric value on the wire for typeCollection.
     */
    @java.lang.Override
    public int getTypeCollectionValue() {
      if (includedTypesCase_ == 3) {
        return ((java.lang.Integer) includedTypes_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Restrict discovery to categories of table types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableTypeCollection type_collection = 3;</code>
     *
     * @param value The enum numeric value on the wire for typeCollection to set.
     * @return This builder for chaining.
     */
    public Builder setTypeCollectionValue(int value) {
      includedTypesCase_ = 3;
      includedTypes_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restrict discovery to categories of table types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableTypeCollection type_collection = 3;</code>
     *
     * @return The typeCollection.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryTableTypeCollection getTypeCollection() {
      if (includedTypesCase_ == 3) {
        com.google.privacy.dlp.v2.BigQueryTableTypeCollection result =
            com.google.privacy.dlp.v2.BigQueryTableTypeCollection.forNumber(
                (java.lang.Integer) includedTypes_);
        return result == null
            ? com.google.privacy.dlp.v2.BigQueryTableTypeCollection.UNRECOGNIZED
            : result;
      }
      return com.google.privacy.dlp.v2.BigQueryTableTypeCollection.BIG_QUERY_COLLECTION_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * Restrict discovery to categories of table types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableTypeCollection type_collection = 3;</code>
     *
     * @param value The typeCollection to set.
     * @return This builder for chaining.
     */
    public Builder setTypeCollection(com.google.privacy.dlp.v2.BigQueryTableTypeCollection value) {
      if (value == null) {
        throw new NullPointerException();
      }
      includedTypesCase_ = 3;
      includedTypes_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restrict discovery to categories of table types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableTypeCollection type_collection = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTypeCollection() {
      if (includedTypesCase_ == 3) {
        includedTypesCase_ = 0;
        includedTypes_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions orConditions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions,
            com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions.Builder,
            com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditionsOrBuilder>
        orConditionsBuilder_;
    /**
     *
     *
     * <pre>
     * At least one of the conditions must be true for a table to be scanned.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions or_conditions = 4;
     * </code>
     *
     * @return Whether the orConditions field is set.
     */
    public boolean hasOrConditions() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * At least one of the conditions must be true for a table to be scanned.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions or_conditions = 4;
     * </code>
     *
     * @return The orConditions.
     */
    public com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions getOrConditions() {
      if (orConditionsBuilder_ == null) {
        return orConditions_ == null
            ? com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions
                .getDefaultInstance()
            : orConditions_;
      } else {
        return orConditionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * At least one of the conditions must be true for a table to be scanned.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions or_conditions = 4;
     * </code>
     */
    public Builder setOrConditions(
        com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions value) {
      if (orConditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        orConditions_ = value;
      } else {
        orConditionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * At least one of the conditions must be true for a table to be scanned.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions or_conditions = 4;
     * </code>
     */
    public Builder setOrConditions(
        com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions.Builder
            builderForValue) {
      if (orConditionsBuilder_ == null) {
        orConditions_ = builderForValue.build();
      } else {
        orConditionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * At least one of the conditions must be true for a table to be scanned.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions or_conditions = 4;
     * </code>
     */
    public Builder mergeOrConditions(
        com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions value) {
      if (orConditionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && orConditions_ != null
            && orConditions_
                != com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions
                    .getDefaultInstance()) {
          getOrConditionsBuilder().mergeFrom(value);
        } else {
          orConditions_ = value;
        }
      } else {
        orConditionsBuilder_.mergeFrom(value);
      }
      if (orConditions_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * At least one of the conditions must be true for a table to be scanned.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions or_conditions = 4;
     * </code>
     */
    public Builder clearOrConditions() {
      bitField0_ = (bitField0_ & ~0x00000008);
      orConditions_ = null;
      if (orConditionsBuilder_ != null) {
        orConditionsBuilder_.dispose();
        orConditionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * At least one of the conditions must be true for a table to be scanned.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions or_conditions = 4;
     * </code>
     */
    public com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions.Builder
        getOrConditionsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getOrConditionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * At least one of the conditions must be true for a table to be scanned.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions or_conditions = 4;
     * </code>
     */
    public com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditionsOrBuilder
        getOrConditionsOrBuilder() {
      if (orConditionsBuilder_ != null) {
        return orConditionsBuilder_.getMessageOrBuilder();
      } else {
        return orConditions_ == null
            ? com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions
                .getDefaultInstance()
            : orConditions_;
      }
    }
    /**
     *
     *
     * <pre>
     * At least one of the conditions must be true for a table to be scanned.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions or_conditions = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions,
            com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions.Builder,
            com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditionsOrBuilder>
        getOrConditionsFieldBuilder() {
      if (orConditionsBuilder_ == null) {
        orConditionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions,
                com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditions.Builder,
                com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.OrConditionsOrBuilder>(
                getOrConditions(), getParentForChildren(), isClean());
        orConditions_ = null;
      }
      return orConditionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DiscoveryBigQueryConditions)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DiscoveryBigQueryConditions)
  private static final com.google.privacy.dlp.v2.DiscoveryBigQueryConditions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DiscoveryBigQueryConditions();
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryConditions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DiscoveryBigQueryConditions> PARSER =
      new com.google.protobuf.AbstractParser<DiscoveryBigQueryConditions>() {
        @java.lang.Override
        public DiscoveryBigQueryConditions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DiscoveryBigQueryConditions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DiscoveryBigQueryConditions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryBigQueryConditions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
