/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Determines what tables will have profiles generated within an organization
 * or project. Includes the ability to filter by regular expression patterns
 * on project ID, dataset ID, and table ID.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.DiscoveryBigQueryFilter}
 */
public final class DiscoveryBigQueryFilter extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DiscoveryBigQueryFilter)
    DiscoveryBigQueryFilterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DiscoveryBigQueryFilter.newBuilder() to construct.
  private DiscoveryBigQueryFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DiscoveryBigQueryFilter() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DiscoveryBigQueryFilter();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryFilter_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryFilter_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.class,
            com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.Builder.class);
  }

  public interface AllOtherBigQueryTablesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Catch-all for all other tables not specified by other filters. Should
   * always be last, except for single-table configurations, which will only
   * have a TableReference target.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables}
   */
  public static final class AllOtherBigQueryTables extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables)
      AllOtherBigQueryTablesOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AllOtherBigQueryTables.newBuilder() to construct.
    private AllOtherBigQueryTables(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AllOtherBigQueryTables() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AllOtherBigQueryTables();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryFilter_AllOtherBigQueryTables_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryFilter_AllOtherBigQueryTables_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables.class,
              com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables.Builder
                  .class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables other =
          (com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Catch-all for all other tables not specified by other filters. Should
     * always be last, except for single-table configurations, which will only
     * have a TableReference target.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables)
        com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTablesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryFilter_AllOtherBigQueryTables_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryFilter_AllOtherBigQueryTables_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables.class,
                com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables.Builder
                    .class);
      }

      // Construct using
      // com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryFilter_AllOtherBigQueryTables_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
          getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables build() {
        com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
          buildPartial() {
        com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables result =
            new com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables) {
          return mergeFrom(
              (com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables other) {
        if (other
            == com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
                .getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables)
    private static final com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables();
    }

    public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AllOtherBigQueryTables> PARSER =
        new com.google.protobuf.AbstractParser<AllOtherBigQueryTables>() {
          @java.lang.Override
          public AllOtherBigQueryTables parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AllOtherBigQueryTables> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AllOtherBigQueryTables> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int filterCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object filter_;

  public enum FilterCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TABLES(1),
    OTHER_TABLES(2),
    FILTER_NOT_SET(0);
    private final int value;

    private FilterCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FilterCase valueOf(int value) {
      return forNumber(value);
    }

    public static FilterCase forNumber(int value) {
      switch (value) {
        case 1:
          return TABLES;
        case 2:
          return OTHER_TABLES;
        case 0:
          return FILTER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FilterCase getFilterCase() {
    return FilterCase.forNumber(filterCase_);
  }

  public static final int TABLES_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * A specific set of tables for this filter to apply to. A table collection
   * must be specified in only one filter per config.
   * If a table id or dataset is empty, Cloud DLP assumes all tables in that
   * collection must be profiled. Must specify a project ID.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTableCollection tables = 1;</code>
   *
   * @return Whether the tables field is set.
   */
  @java.lang.Override
  public boolean hasTables() {
    return filterCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * A specific set of tables for this filter to apply to. A table collection
   * must be specified in only one filter per config.
   * If a table id or dataset is empty, Cloud DLP assumes all tables in that
   * collection must be profiled. Must specify a project ID.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTableCollection tables = 1;</code>
   *
   * @return The tables.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryTableCollection getTables() {
    if (filterCase_ == 1) {
      return (com.google.privacy.dlp.v2.BigQueryTableCollection) filter_;
    }
    return com.google.privacy.dlp.v2.BigQueryTableCollection.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A specific set of tables for this filter to apply to. A table collection
   * must be specified in only one filter per config.
   * If a table id or dataset is empty, Cloud DLP assumes all tables in that
   * collection must be profiled. Must specify a project ID.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTableCollection tables = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryTableCollectionOrBuilder getTablesOrBuilder() {
    if (filterCase_ == 1) {
      return (com.google.privacy.dlp.v2.BigQueryTableCollection) filter_;
    }
    return com.google.privacy.dlp.v2.BigQueryTableCollection.getDefaultInstance();
  }

  public static final int OTHER_TABLES_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Catch-all. This should always be the last filter in the list because
   * anything above it will apply first. Should only appear once in a
   * configuration. If none is specified, a default one will be added
   * automatically.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables other_tables = 2;
   * </code>
   *
   * @return Whether the otherTables field is set.
   */
  @java.lang.Override
  public boolean hasOtherTables() {
    return filterCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Catch-all. This should always be the last filter in the list because
   * anything above it will apply first. Should only appear once in a
   * configuration. If none is specified, a default one will be added
   * automatically.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables other_tables = 2;
   * </code>
   *
   * @return The otherTables.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables getOtherTables() {
    if (filterCase_ == 2) {
      return (com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables) filter_;
    }
    return com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Catch-all. This should always be the last filter in the list because
   * anything above it will apply first. Should only appear once in a
   * configuration. If none is specified, a default one will be added
   * automatically.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables other_tables = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTablesOrBuilder
      getOtherTablesOrBuilder() {
    if (filterCase_ == 2) {
      return (com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables) filter_;
    }
    return com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (filterCase_ == 1) {
      output.writeMessage(1, (com.google.privacy.dlp.v2.BigQueryTableCollection) filter_);
    }
    if (filterCase_ == 2) {
      output.writeMessage(
          2, (com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables) filter_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (filterCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.privacy.dlp.v2.BigQueryTableCollection) filter_);
    }
    if (filterCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables) filter_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.DiscoveryBigQueryFilter)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.DiscoveryBigQueryFilter other =
        (com.google.privacy.dlp.v2.DiscoveryBigQueryFilter) obj;

    if (!getFilterCase().equals(other.getFilterCase())) return false;
    switch (filterCase_) {
      case 1:
        if (!getTables().equals(other.getTables())) return false;
        break;
      case 2:
        if (!getOtherTables().equals(other.getOtherTables())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (filterCase_) {
      case 1:
        hash = (37 * hash) + TABLES_FIELD_NUMBER;
        hash = (53 * hash) + getTables().hashCode();
        break;
      case 2:
        hash = (37 * hash) + OTHER_TABLES_FIELD_NUMBER;
        hash = (53 * hash) + getOtherTables().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.DiscoveryBigQueryFilter prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Determines what tables will have profiles generated within an organization
   * or project. Includes the ability to filter by regular expression patterns
   * on project ID, dataset ID, and table ID.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DiscoveryBigQueryFilter}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DiscoveryBigQueryFilter)
      com.google.privacy.dlp.v2.DiscoveryBigQueryFilterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.class,
              com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (tablesBuilder_ != null) {
        tablesBuilder_.clear();
      }
      if (otherTablesBuilder_ != null) {
        otherTablesBuilder_.clear();
      }
      filterCase_ = 0;
      filter_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryBigQueryFilter_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryBigQueryFilter getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryBigQueryFilter build() {
      com.google.privacy.dlp.v2.DiscoveryBigQueryFilter result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryBigQueryFilter buildPartial() {
      com.google.privacy.dlp.v2.DiscoveryBigQueryFilter result =
          new com.google.privacy.dlp.v2.DiscoveryBigQueryFilter(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.DiscoveryBigQueryFilter result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.DiscoveryBigQueryFilter result) {
      result.filterCase_ = filterCase_;
      result.filter_ = this.filter_;
      if (filterCase_ == 1 && tablesBuilder_ != null) {
        result.filter_ = tablesBuilder_.build();
      }
      if (filterCase_ == 2 && otherTablesBuilder_ != null) {
        result.filter_ = otherTablesBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.DiscoveryBigQueryFilter) {
        return mergeFrom((com.google.privacy.dlp.v2.DiscoveryBigQueryFilter) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.DiscoveryBigQueryFilter other) {
      if (other == com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.getDefaultInstance())
        return this;
      switch (other.getFilterCase()) {
        case TABLES:
          {
            mergeTables(other.getTables());
            break;
          }
        case OTHER_TABLES:
          {
            mergeOtherTables(other.getOtherTables());
            break;
          }
        case FILTER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTablesFieldBuilder().getBuilder(), extensionRegistry);
                filterCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getOtherTablesFieldBuilder().getBuilder(), extensionRegistry);
                filterCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int filterCase_ = 0;
    private java.lang.Object filter_;

    public FilterCase getFilterCase() {
      return FilterCase.forNumber(filterCase_);
    }

    public Builder clearFilter() {
      filterCase_ = 0;
      filter_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BigQueryTableCollection,
            com.google.privacy.dlp.v2.BigQueryTableCollection.Builder,
            com.google.privacy.dlp.v2.BigQueryTableCollectionOrBuilder>
        tablesBuilder_;
    /**
     *
     *
     * <pre>
     * A specific set of tables for this filter to apply to. A table collection
     * must be specified in only one filter per config.
     * If a table id or dataset is empty, Cloud DLP assumes all tables in that
     * collection must be profiled. Must specify a project ID.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableCollection tables = 1;</code>
     *
     * @return Whether the tables field is set.
     */
    @java.lang.Override
    public boolean hasTables() {
      return filterCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A specific set of tables for this filter to apply to. A table collection
     * must be specified in only one filter per config.
     * If a table id or dataset is empty, Cloud DLP assumes all tables in that
     * collection must be profiled. Must specify a project ID.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableCollection tables = 1;</code>
     *
     * @return The tables.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryTableCollection getTables() {
      if (tablesBuilder_ == null) {
        if (filterCase_ == 1) {
          return (com.google.privacy.dlp.v2.BigQueryTableCollection) filter_;
        }
        return com.google.privacy.dlp.v2.BigQueryTableCollection.getDefaultInstance();
      } else {
        if (filterCase_ == 1) {
          return tablesBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.BigQueryTableCollection.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A specific set of tables for this filter to apply to. A table collection
     * must be specified in only one filter per config.
     * If a table id or dataset is empty, Cloud DLP assumes all tables in that
     * collection must be profiled. Must specify a project ID.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableCollection tables = 1;</code>
     */
    public Builder setTables(com.google.privacy.dlp.v2.BigQueryTableCollection value) {
      if (tablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        tablesBuilder_.setMessage(value);
      }
      filterCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A specific set of tables for this filter to apply to. A table collection
     * must be specified in only one filter per config.
     * If a table id or dataset is empty, Cloud DLP assumes all tables in that
     * collection must be profiled. Must specify a project ID.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableCollection tables = 1;</code>
     */
    public Builder setTables(
        com.google.privacy.dlp.v2.BigQueryTableCollection.Builder builderForValue) {
      if (tablesBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        tablesBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A specific set of tables for this filter to apply to. A table collection
     * must be specified in only one filter per config.
     * If a table id or dataset is empty, Cloud DLP assumes all tables in that
     * collection must be profiled. Must specify a project ID.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableCollection tables = 1;</code>
     */
    public Builder mergeTables(com.google.privacy.dlp.v2.BigQueryTableCollection value) {
      if (tablesBuilder_ == null) {
        if (filterCase_ == 1
            && filter_ != com.google.privacy.dlp.v2.BigQueryTableCollection.getDefaultInstance()) {
          filter_ =
              com.google.privacy.dlp.v2.BigQueryTableCollection.newBuilder(
                      (com.google.privacy.dlp.v2.BigQueryTableCollection) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 1) {
          tablesBuilder_.mergeFrom(value);
        } else {
          tablesBuilder_.setMessage(value);
        }
      }
      filterCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A specific set of tables for this filter to apply to. A table collection
     * must be specified in only one filter per config.
     * If a table id or dataset is empty, Cloud DLP assumes all tables in that
     * collection must be profiled. Must specify a project ID.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableCollection tables = 1;</code>
     */
    public Builder clearTables() {
      if (tablesBuilder_ == null) {
        if (filterCase_ == 1) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 1) {
          filterCase_ = 0;
          filter_ = null;
        }
        tablesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A specific set of tables for this filter to apply to. A table collection
     * must be specified in only one filter per config.
     * If a table id or dataset is empty, Cloud DLP assumes all tables in that
     * collection must be profiled. Must specify a project ID.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableCollection tables = 1;</code>
     */
    public com.google.privacy.dlp.v2.BigQueryTableCollection.Builder getTablesBuilder() {
      return getTablesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A specific set of tables for this filter to apply to. A table collection
     * must be specified in only one filter per config.
     * If a table id or dataset is empty, Cloud DLP assumes all tables in that
     * collection must be profiled. Must specify a project ID.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableCollection tables = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryTableCollectionOrBuilder getTablesOrBuilder() {
      if ((filterCase_ == 1) && (tablesBuilder_ != null)) {
        return tablesBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 1) {
          return (com.google.privacy.dlp.v2.BigQueryTableCollection) filter_;
        }
        return com.google.privacy.dlp.v2.BigQueryTableCollection.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A specific set of tables for this filter to apply to. A table collection
     * must be specified in only one filter per config.
     * If a table id or dataset is empty, Cloud DLP assumes all tables in that
     * collection must be profiled. Must specify a project ID.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTableCollection tables = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BigQueryTableCollection,
            com.google.privacy.dlp.v2.BigQueryTableCollection.Builder,
            com.google.privacy.dlp.v2.BigQueryTableCollectionOrBuilder>
        getTablesFieldBuilder() {
      if (tablesBuilder_ == null) {
        if (!(filterCase_ == 1)) {
          filter_ = com.google.privacy.dlp.v2.BigQueryTableCollection.getDefaultInstance();
        }
        tablesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.BigQueryTableCollection,
                com.google.privacy.dlp.v2.BigQueryTableCollection.Builder,
                com.google.privacy.dlp.v2.BigQueryTableCollectionOrBuilder>(
                (com.google.privacy.dlp.v2.BigQueryTableCollection) filter_,
                getParentForChildren(),
                isClean());
        filter_ = null;
      }
      filterCase_ = 1;
      onChanged();
      return tablesBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables,
            com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables.Builder,
            com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTablesOrBuilder>
        otherTablesBuilder_;
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last filter in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables other_tables = 2;
     * </code>
     *
     * @return Whether the otherTables field is set.
     */
    @java.lang.Override
    public boolean hasOtherTables() {
      return filterCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last filter in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables other_tables = 2;
     * </code>
     *
     * @return The otherTables.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
        getOtherTables() {
      if (otherTablesBuilder_ == null) {
        if (filterCase_ == 2) {
          return (com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables) filter_;
        }
        return com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
            .getDefaultInstance();
      } else {
        if (filterCase_ == 2) {
          return otherTablesBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last filter in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables other_tables = 2;
     * </code>
     */
    public Builder setOtherTables(
        com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables value) {
      if (otherTablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        otherTablesBuilder_.setMessage(value);
      }
      filterCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last filter in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables other_tables = 2;
     * </code>
     */
    public Builder setOtherTables(
        com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables.Builder
            builderForValue) {
      if (otherTablesBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        otherTablesBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last filter in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables other_tables = 2;
     * </code>
     */
    public Builder mergeOtherTables(
        com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables value) {
      if (otherTablesBuilder_ == null) {
        if (filterCase_ == 2
            && filter_
                != com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
                    .getDefaultInstance()) {
          filter_ =
              com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables.newBuilder(
                      (com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables)
                          filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 2) {
          otherTablesBuilder_.mergeFrom(value);
        } else {
          otherTablesBuilder_.setMessage(value);
        }
      }
      filterCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last filter in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables other_tables = 2;
     * </code>
     */
    public Builder clearOtherTables() {
      if (otherTablesBuilder_ == null) {
        if (filterCase_ == 2) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 2) {
          filterCase_ = 0;
          filter_ = null;
        }
        otherTablesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last filter in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables other_tables = 2;
     * </code>
     */
    public com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables.Builder
        getOtherTablesBuilder() {
      return getOtherTablesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last filter in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables other_tables = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTablesOrBuilder
        getOtherTablesOrBuilder() {
      if ((filterCase_ == 2) && (otherTablesBuilder_ != null)) {
        return otherTablesBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 2) {
          return (com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables) filter_;
        }
        return com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last filter in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables other_tables = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables,
            com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables.Builder,
            com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTablesOrBuilder>
        getOtherTablesFieldBuilder() {
      if (otherTablesBuilder_ == null) {
        if (!(filterCase_ == 2)) {
          filter_ =
              com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables
                  .getDefaultInstance();
        }
        otherTablesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables,
                com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables.Builder,
                com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTablesOrBuilder>(
                (com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables) filter_,
                getParentForChildren(),
                isClean());
        filter_ = null;
      }
      filterCase_ = 2;
      onChanged();
      return otherTablesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DiscoveryBigQueryFilter)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DiscoveryBigQueryFilter)
  private static final com.google.privacy.dlp.v2.DiscoveryBigQueryFilter DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DiscoveryBigQueryFilter();
  }

  public static com.google.privacy.dlp.v2.DiscoveryBigQueryFilter getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DiscoveryBigQueryFilter> PARSER =
      new com.google.protobuf.AbstractParser<DiscoveryBigQueryFilter>() {
        @java.lang.Override
        public DiscoveryBigQueryFilter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DiscoveryBigQueryFilter> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DiscoveryBigQueryFilter> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryBigQueryFilter getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
