/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Requirements that must be true before a table is profiled for the
 * first time.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.DiscoveryCloudSqlConditions}
 */
public final class DiscoveryCloudSqlConditions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DiscoveryCloudSqlConditions)
    DiscoveryCloudSqlConditionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DiscoveryCloudSqlConditions.newBuilder() to construct.
  private DiscoveryCloudSqlConditions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DiscoveryCloudSqlConditions() {
    databaseEngines_ = java.util.Collections.emptyList();
    types_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DiscoveryCloudSqlConditions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlConditions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlConditions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.class,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The database engines that should be profiled.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine}
   */
  public enum DatabaseEngine implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>DATABASE_ENGINE_UNSPECIFIED = 0;</code>
     */
    DATABASE_ENGINE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Include all supported database engines.
     * </pre>
     *
     * <code>ALL_SUPPORTED_DATABASE_ENGINES = 1;</code>
     */
    ALL_SUPPORTED_DATABASE_ENGINES(1),
    /**
     *
     *
     * <pre>
     * MySql database.
     * </pre>
     *
     * <code>MYSQL = 2;</code>
     */
    MYSQL(2),
    /**
     *
     *
     * <pre>
     * PostGres database.
     * </pre>
     *
     * <code>POSTGRES = 3;</code>
     */
    POSTGRES(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>DATABASE_ENGINE_UNSPECIFIED = 0;</code>
     */
    public static final int DATABASE_ENGINE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Include all supported database engines.
     * </pre>
     *
     * <code>ALL_SUPPORTED_DATABASE_ENGINES = 1;</code>
     */
    public static final int ALL_SUPPORTED_DATABASE_ENGINES_VALUE = 1;
    /**
     *
     *
     * <pre>
     * MySql database.
     * </pre>
     *
     * <code>MYSQL = 2;</code>
     */
    public static final int MYSQL_VALUE = 2;
    /**
     *
     *
     * <pre>
     * PostGres database.
     * </pre>
     *
     * <code>POSTGRES = 3;</code>
     */
    public static final int POSTGRES_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DatabaseEngine valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DatabaseEngine forNumber(int value) {
      switch (value) {
        case 0:
          return DATABASE_ENGINE_UNSPECIFIED;
        case 1:
          return ALL_SUPPORTED_DATABASE_ENGINES;
        case 2:
          return MYSQL;
        case 3:
          return POSTGRES;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DatabaseEngine> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DatabaseEngine> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DatabaseEngine>() {
          public DatabaseEngine findValueByNumber(int number) {
            return DatabaseEngine.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final DatabaseEngine[] VALUES = values();

    public static DatabaseEngine valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DatabaseEngine(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine)
  }

  /**
   *
   *
   * <pre>
   * Cloud SQL database resource types. New values can be added at a later time.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType}
   */
  public enum DatabaseResourceType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>DATABASE_RESOURCE_TYPE_UNSPECIFIED = 0;</code>
     */
    DATABASE_RESOURCE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Includes database resource types that become supported at a later time.
     * </pre>
     *
     * <code>DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES = 1;</code>
     */
    DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES(1),
    /**
     *
     *
     * <pre>
     * Tables.
     * </pre>
     *
     * <code>DATABASE_RESOURCE_TYPE_TABLE = 2;</code>
     */
    DATABASE_RESOURCE_TYPE_TABLE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>DATABASE_RESOURCE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int DATABASE_RESOURCE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Includes database resource types that become supported at a later time.
     * </pre>
     *
     * <code>DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES = 1;</code>
     */
    public static final int DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Tables.
     * </pre>
     *
     * <code>DATABASE_RESOURCE_TYPE_TABLE = 2;</code>
     */
    public static final int DATABASE_RESOURCE_TYPE_TABLE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DatabaseResourceType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DatabaseResourceType forNumber(int value) {
      switch (value) {
        case 0:
          return DATABASE_RESOURCE_TYPE_UNSPECIFIED;
        case 1:
          return DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES;
        case 2:
          return DATABASE_RESOURCE_TYPE_TABLE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DatabaseResourceType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DatabaseResourceType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DatabaseResourceType>() {
              public DatabaseResourceType findValueByNumber(int number) {
                return DatabaseResourceType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final DatabaseResourceType[] VALUES = values();

    public static DatabaseResourceType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DatabaseResourceType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType)
  }

  public static final int DATABASE_ENGINES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> databaseEngines_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine>
      databaseEngines_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine>() {
            public com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine convert(
                java.lang.Integer from) {
              com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine result =
                  com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine.forNumber(
                      from);
              return result == null
                  ? com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine
                      .UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Optional. Database engines that should be profiled.
   * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the databaseEngines.
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine>
      getDatabaseEnginesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine>(
        databaseEngines_, databaseEngines_converter_);
  }
  /**
   *
   *
   * <pre>
   * Optional. Database engines that should be profiled.
   * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of databaseEngines.
   */
  @java.lang.Override
  public int getDatabaseEnginesCount() {
    return databaseEngines_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Database engines that should be profiled.
   * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The databaseEngines at the given index.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine getDatabaseEngines(
      int index) {
    return databaseEngines_converter_.convert(databaseEngines_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Optional. Database engines that should be profiled.
   * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for databaseEngines.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getDatabaseEnginesValueList() {
    return databaseEngines_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Database engines that should be profiled.
   * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of databaseEngines at the given index.
   */
  @java.lang.Override
  public int getDatabaseEnginesValue(int index) {
    return databaseEngines_.get(index);
  }

  private int databaseEnginesMemoizedSerializedSize;

  public static final int TYPES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> types_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer,
          com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType>
      types_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType>() {
            public com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType
                convert(java.lang.Integer from) {
              com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType result =
                  com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType
                      .forNumber(from);
              return result == null
                  ? com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType
                      .UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Data profiles will only be generated for the database resource types
   * specified in this field.
   * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
   * </code>
   *
   * @return A list containing the types.
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType>
      getTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer,
        com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType>(
        types_, types_converter_);
  }
  /**
   *
   *
   * <pre>
   * Data profiles will only be generated for the database resource types
   * specified in this field.
   * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
   * </code>
   *
   * @return The count of types.
   */
  @java.lang.Override
  public int getTypesCount() {
    return types_.size();
  }
  /**
   *
   *
   * <pre>
   * Data profiles will only be generated for the database resource types
   * specified in this field.
   * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The types at the given index.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType getTypes(
      int index) {
    return types_converter_.convert(types_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Data profiles will only be generated for the database resource types
   * specified in this field.
   * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for types.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getTypesValueList() {
    return types_;
  }
  /**
   *
   *
   * <pre>
   * Data profiles will only be generated for the database resource types
   * specified in this field.
   * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of types at the given index.
   */
  @java.lang.Override
  public int getTypesValue(int index) {
    return types_.get(index);
  }

  private int typesMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (getDatabaseEnginesList().size() > 0) {
      output.writeUInt32NoTag(10);
      output.writeUInt32NoTag(databaseEnginesMemoizedSerializedSize);
    }
    for (int i = 0; i < databaseEngines_.size(); i++) {
      output.writeEnumNoTag(databaseEngines_.get(i));
    }
    if (getTypesList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(typesMemoizedSerializedSize);
    }
    for (int i = 0; i < types_.size(); i++) {
      output.writeEnumNoTag(types_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < databaseEngines_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(databaseEngines_.get(i));
      }
      size += dataSize;
      if (!getDatabaseEnginesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      databaseEnginesMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < types_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(types_.get(i));
      }
      size += dataSize;
      if (!getTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      typesMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions other =
        (com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions) obj;

    if (!databaseEngines_.equals(other.databaseEngines_)) return false;
    if (!types_.equals(other.types_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getDatabaseEnginesCount() > 0) {
      hash = (37 * hash) + DATABASE_ENGINES_FIELD_NUMBER;
      hash = (53 * hash) + databaseEngines_.hashCode();
    }
    if (getTypesCount() > 0) {
      hash = (37 * hash) + TYPES_FIELD_NUMBER;
      hash = (53 * hash) + types_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Requirements that must be true before a table is profiled for the
   * first time.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DiscoveryCloudSqlConditions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DiscoveryCloudSqlConditions)
      com.google.privacy.dlp.v2.DiscoveryCloudSqlConditionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlConditions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlConditions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.class,
              com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      databaseEngines_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      types_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlConditions_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions build() {
      com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions buildPartial() {
      com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions result =
          new com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions result) {
      if (((bitField0_ & 0x00000001) != 0)) {
        databaseEngines_ = java.util.Collections.unmodifiableList(databaseEngines_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.databaseEngines_ = databaseEngines_;
      if (((bitField0_ & 0x00000002) != 0)) {
        types_ = java.util.Collections.unmodifiableList(types_);
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.types_ = types_;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions) {
        return mergeFrom((com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions other) {
      if (other == com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.getDefaultInstance())
        return this;
      if (!other.databaseEngines_.isEmpty()) {
        if (databaseEngines_.isEmpty()) {
          databaseEngines_ = other.databaseEngines_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureDatabaseEnginesIsMutable();
          databaseEngines_.addAll(other.databaseEngines_);
        }
        onChanged();
      }
      if (!other.types_.isEmpty()) {
        if (types_.isEmpty()) {
          types_ = other.types_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureTypesIsMutable();
          types_.addAll(other.types_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int tmpRaw = input.readEnum();
                ensureDatabaseEnginesIsMutable();
                databaseEngines_.add(tmpRaw);
                break;
              } // case 8
            case 10:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureDatabaseEnginesIsMutable();
                  databaseEngines_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 10
            case 24:
              {
                int tmpRaw = input.readEnum();
                ensureTypesIsMutable();
                types_.add(tmpRaw);
                break;
              } // case 24
            case 26:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureTypesIsMutable();
                  types_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<java.lang.Integer> databaseEngines_ = java.util.Collections.emptyList();

    private void ensureDatabaseEnginesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        databaseEngines_ = new java.util.ArrayList<java.lang.Integer>(databaseEngines_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Database engines that should be profiled.
     * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the databaseEngines.
     */
    public java.util.List<com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine>
        getDatabaseEnginesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine>(
          databaseEngines_, databaseEngines_converter_);
    }
    /**
     *
     *
     * <pre>
     * Optional. Database engines that should be profiled.
     * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of databaseEngines.
     */
    public int getDatabaseEnginesCount() {
      return databaseEngines_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Database engines that should be profiled.
     * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The databaseEngines at the given index.
     */
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine getDatabaseEngines(
        int index) {
      return databaseEngines_converter_.convert(databaseEngines_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Optional. Database engines that should be profiled.
     * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The databaseEngines to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseEngines(
        int index, com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDatabaseEnginesIsMutable();
      databaseEngines_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Database engines that should be profiled.
     * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The databaseEngines to add.
     * @return This builder for chaining.
     */
    public Builder addDatabaseEngines(
        com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDatabaseEnginesIsMutable();
      databaseEngines_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Database engines that should be profiled.
     * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The databaseEngines to add.
     * @return This builder for chaining.
     */
    public Builder addAllDatabaseEngines(
        java.lang.Iterable<
                ? extends com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine>
            values) {
      ensureDatabaseEnginesIsMutable();
      for (com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine value : values) {
        databaseEngines_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Database engines that should be profiled.
     * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseEngines() {
      databaseEngines_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Database engines that should be profiled.
     * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for databaseEngines.
     */
    public java.util.List<java.lang.Integer> getDatabaseEnginesValueList() {
      return java.util.Collections.unmodifiableList(databaseEngines_);
    }
    /**
     *
     *
     * <pre>
     * Optional. Database engines that should be profiled.
     * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of databaseEngines at the given index.
     */
    public int getDatabaseEnginesValue(int index) {
      return databaseEngines_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Database engines that should be profiled.
     * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for databaseEngines to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseEnginesValue(int index, int value) {
      ensureDatabaseEnginesIsMutable();
      databaseEngines_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Database engines that should be profiled.
     * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for databaseEngines to add.
     * @return This builder for chaining.
     */
    public Builder addDatabaseEnginesValue(int value) {
      ensureDatabaseEnginesIsMutable();
      databaseEngines_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Database engines that should be profiled.
     * Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseEngine database_engines = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for databaseEngines to add.
     * @return This builder for chaining.
     */
    public Builder addAllDatabaseEnginesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureDatabaseEnginesIsMutable();
      for (int value : values) {
        databaseEngines_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> types_ = java.util.Collections.emptyList();

    private void ensureTypesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        types_ = new java.util.ArrayList<java.lang.Integer>(types_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Data profiles will only be generated for the database resource types
     * specified in this field.
     * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
     * </code>
     *
     * @return A list containing the types.
     */
    public java.util.List<
            com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType>
        getTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer,
          com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType>(
          types_, types_converter_);
    }
    /**
     *
     *
     * <pre>
     * Data profiles will only be generated for the database resource types
     * specified in this field.
     * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
     * </code>
     *
     * @return The count of types.
     */
    public int getTypesCount() {
      return types_.size();
    }
    /**
     *
     *
     * <pre>
     * Data profiles will only be generated for the database resource types
     * specified in this field.
     * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The types at the given index.
     */
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType getTypes(
        int index) {
      return types_converter_.convert(types_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Data profiles will only be generated for the database resource types
     * specified in this field.
     * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The types to set.
     * @return This builder for chaining.
     */
    public Builder setTypes(
        int index,
        com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTypesIsMutable();
      types_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data profiles will only be generated for the database resource types
     * specified in this field.
     * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
     * </code>
     *
     * @param value The types to add.
     * @return This builder for chaining.
     */
    public Builder addTypes(
        com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTypesIsMutable();
      types_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data profiles will only be generated for the database resource types
     * specified in this field.
     * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
     * </code>
     *
     * @param values The types to add.
     * @return This builder for chaining.
     */
    public Builder addAllTypes(
        java.lang.Iterable<
                ? extends
                    com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType>
            values) {
      ensureTypesIsMutable();
      for (com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType value :
          values) {
        types_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data profiles will only be generated for the database resource types
     * specified in this field.
     * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTypes() {
      types_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data profiles will only be generated for the database resource types
     * specified in this field.
     * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for types.
     */
    public java.util.List<java.lang.Integer> getTypesValueList() {
      return java.util.Collections.unmodifiableList(types_);
    }
    /**
     *
     *
     * <pre>
     * Data profiles will only be generated for the database resource types
     * specified in this field.
     * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of types at the given index.
     */
    public int getTypesValue(int index) {
      return types_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Data profiles will only be generated for the database resource types
     * specified in this field.
     * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for types to set.
     * @return This builder for chaining.
     */
    public Builder setTypesValue(int index, int value) {
      ensureTypesIsMutable();
      types_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data profiles will only be generated for the database resource types
     * specified in this field.
     * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for types to add.
     * @return This builder for chaining.
     */
    public Builder addTypesValue(int value) {
      ensureTypesIsMutable();
      types_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data profiles will only be generated for the database resource types
     * specified in this field.
     * If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlConditions.DatabaseResourceType types = 3;
     * </code>
     *
     * @param values The enum numeric values on the wire for types to add.
     * @return This builder for chaining.
     */
    public Builder addAllTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureTypesIsMutable();
      for (int value : values) {
        types_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DiscoveryCloudSqlConditions)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DiscoveryCloudSqlConditions)
  private static final com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions();
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DiscoveryCloudSqlConditions> PARSER =
      new com.google.protobuf.AbstractParser<DiscoveryCloudSqlConditions>() {
        @java.lang.Override
        public DiscoveryCloudSqlConditions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DiscoveryCloudSqlConditions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DiscoveryCloudSqlConditions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
