/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Determines what tables will have profiles generated within an organization
 * or project. Includes the ability to filter by regular expression patterns
 * on project ID, location, instance, database, and database resource name.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.DiscoveryCloudSqlFilter}
 */
public final class DiscoveryCloudSqlFilter extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DiscoveryCloudSqlFilter)
    DiscoveryCloudSqlFilterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DiscoveryCloudSqlFilter.newBuilder() to construct.
  private DiscoveryCloudSqlFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DiscoveryCloudSqlFilter() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DiscoveryCloudSqlFilter();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlFilter_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlFilter_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.class,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.Builder.class);
  }

  private int filterCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object filter_;

  public enum FilterCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    COLLECTION(1),
    OTHERS(2),
    DATABASE_RESOURCE_REFERENCE(3),
    FILTER_NOT_SET(0);
    private final int value;

    private FilterCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FilterCase valueOf(int value) {
      return forNumber(value);
    }

    public static FilterCase forNumber(int value) {
      switch (value) {
        case 1:
          return COLLECTION;
        case 2:
          return OTHERS;
        case 3:
          return DATABASE_RESOURCE_REFERENCE;
        case 0:
          return FILTER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FilterCase getFilterCase() {
    return FilterCase.forNumber(filterCase_);
  }

  public static final int COLLECTION_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * A specific set of database resources for this filter to apply to.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DatabaseResourceCollection collection = 1;</code>
   *
   * @return Whether the collection field is set.
   */
  @java.lang.Override
  public boolean hasCollection() {
    return filterCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * A specific set of database resources for this filter to apply to.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DatabaseResourceCollection collection = 1;</code>
   *
   * @return The collection.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DatabaseResourceCollection getCollection() {
    if (filterCase_ == 1) {
      return (com.google.privacy.dlp.v2.DatabaseResourceCollection) filter_;
    }
    return com.google.privacy.dlp.v2.DatabaseResourceCollection.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A specific set of database resources for this filter to apply to.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DatabaseResourceCollection collection = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DatabaseResourceCollectionOrBuilder getCollectionOrBuilder() {
    if (filterCase_ == 1) {
      return (com.google.privacy.dlp.v2.DatabaseResourceCollection) filter_;
    }
    return com.google.privacy.dlp.v2.DatabaseResourceCollection.getDefaultInstance();
  }

  public static final int OTHERS_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Catch-all. This should always be the last target in the list because
   * anything above it will apply first. Should only appear once in a
   * configuration. If none is specified, a default one will be added
   * automatically.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.AllOtherDatabaseResources others = 2;</code>
   *
   * @return Whether the others field is set.
   */
  @java.lang.Override
  public boolean hasOthers() {
    return filterCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Catch-all. This should always be the last target in the list because
   * anything above it will apply first. Should only appear once in a
   * configuration. If none is specified, a default one will be added
   * automatically.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.AllOtherDatabaseResources others = 2;</code>
   *
   * @return The others.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.AllOtherDatabaseResources getOthers() {
    if (filterCase_ == 2) {
      return (com.google.privacy.dlp.v2.AllOtherDatabaseResources) filter_;
    }
    return com.google.privacy.dlp.v2.AllOtherDatabaseResources.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Catch-all. This should always be the last target in the list because
   * anything above it will apply first. Should only appear once in a
   * configuration. If none is specified, a default one will be added
   * automatically.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.AllOtherDatabaseResources others = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.AllOtherDatabaseResourcesOrBuilder getOthersOrBuilder() {
    if (filterCase_ == 2) {
      return (com.google.privacy.dlp.v2.AllOtherDatabaseResources) filter_;
    }
    return com.google.privacy.dlp.v2.AllOtherDatabaseResources.getDefaultInstance();
  }

  public static final int DATABASE_RESOURCE_REFERENCE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The database resource to scan. Targets including this can only include
   * one target (the target with this database resource reference).
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DatabaseResourceReference database_resource_reference = 3;</code>
   *
   * @return Whether the databaseResourceReference field is set.
   */
  @java.lang.Override
  public boolean hasDatabaseResourceReference() {
    return filterCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The database resource to scan. Targets including this can only include
   * one target (the target with this database resource reference).
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DatabaseResourceReference database_resource_reference = 3;</code>
   *
   * @return The databaseResourceReference.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DatabaseResourceReference getDatabaseResourceReference() {
    if (filterCase_ == 3) {
      return (com.google.privacy.dlp.v2.DatabaseResourceReference) filter_;
    }
    return com.google.privacy.dlp.v2.DatabaseResourceReference.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The database resource to scan. Targets including this can only include
   * one target (the target with this database resource reference).
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DatabaseResourceReference database_resource_reference = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DatabaseResourceReferenceOrBuilder
      getDatabaseResourceReferenceOrBuilder() {
    if (filterCase_ == 3) {
      return (com.google.privacy.dlp.v2.DatabaseResourceReference) filter_;
    }
    return com.google.privacy.dlp.v2.DatabaseResourceReference.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (filterCase_ == 1) {
      output.writeMessage(1, (com.google.privacy.dlp.v2.DatabaseResourceCollection) filter_);
    }
    if (filterCase_ == 2) {
      output.writeMessage(2, (com.google.privacy.dlp.v2.AllOtherDatabaseResources) filter_);
    }
    if (filterCase_ == 3) {
      output.writeMessage(3, (com.google.privacy.dlp.v2.DatabaseResourceReference) filter_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (filterCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.privacy.dlp.v2.DatabaseResourceCollection) filter_);
    }
    if (filterCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.privacy.dlp.v2.AllOtherDatabaseResources) filter_);
    }
    if (filterCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.privacy.dlp.v2.DatabaseResourceReference) filter_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter other =
        (com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter) obj;

    if (!getFilterCase().equals(other.getFilterCase())) return false;
    switch (filterCase_) {
      case 1:
        if (!getCollection().equals(other.getCollection())) return false;
        break;
      case 2:
        if (!getOthers().equals(other.getOthers())) return false;
        break;
      case 3:
        if (!getDatabaseResourceReference().equals(other.getDatabaseResourceReference()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (filterCase_) {
      case 1:
        hash = (37 * hash) + COLLECTION_FIELD_NUMBER;
        hash = (53 * hash) + getCollection().hashCode();
        break;
      case 2:
        hash = (37 * hash) + OTHERS_FIELD_NUMBER;
        hash = (53 * hash) + getOthers().hashCode();
        break;
      case 3:
        hash = (37 * hash) + DATABASE_RESOURCE_REFERENCE_FIELD_NUMBER;
        hash = (53 * hash) + getDatabaseResourceReference().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Determines what tables will have profiles generated within an organization
   * or project. Includes the ability to filter by regular expression patterns
   * on project ID, location, instance, database, and database resource name.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DiscoveryCloudSqlFilter}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DiscoveryCloudSqlFilter)
      com.google.privacy.dlp.v2.DiscoveryCloudSqlFilterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.class,
              com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (collectionBuilder_ != null) {
        collectionBuilder_.clear();
      }
      if (othersBuilder_ != null) {
        othersBuilder_.clear();
      }
      if (databaseResourceReferenceBuilder_ != null) {
        databaseResourceReferenceBuilder_.clear();
      }
      filterCase_ = 0;
      filter_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlFilter_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter build() {
      com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter buildPartial() {
      com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter result =
          new com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter result) {
      result.filterCase_ = filterCase_;
      result.filter_ = this.filter_;
      if (filterCase_ == 1 && collectionBuilder_ != null) {
        result.filter_ = collectionBuilder_.build();
      }
      if (filterCase_ == 2 && othersBuilder_ != null) {
        result.filter_ = othersBuilder_.build();
      }
      if (filterCase_ == 3 && databaseResourceReferenceBuilder_ != null) {
        result.filter_ = databaseResourceReferenceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter) {
        return mergeFrom((com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter other) {
      if (other == com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.getDefaultInstance())
        return this;
      switch (other.getFilterCase()) {
        case COLLECTION:
          {
            mergeCollection(other.getCollection());
            break;
          }
        case OTHERS:
          {
            mergeOthers(other.getOthers());
            break;
          }
        case DATABASE_RESOURCE_REFERENCE:
          {
            mergeDatabaseResourceReference(other.getDatabaseResourceReference());
            break;
          }
        case FILTER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCollectionFieldBuilder().getBuilder(), extensionRegistry);
                filterCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getOthersFieldBuilder().getBuilder(), extensionRegistry);
                filterCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getDatabaseResourceReferenceFieldBuilder().getBuilder(), extensionRegistry);
                filterCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int filterCase_ = 0;
    private java.lang.Object filter_;

    public FilterCase getFilterCase() {
      return FilterCase.forNumber(filterCase_);
    }

    public Builder clearFilter() {
      filterCase_ = 0;
      filter_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DatabaseResourceCollection,
            com.google.privacy.dlp.v2.DatabaseResourceCollection.Builder,
            com.google.privacy.dlp.v2.DatabaseResourceCollectionOrBuilder>
        collectionBuilder_;
    /**
     *
     *
     * <pre>
     * A specific set of database resources for this filter to apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceCollection collection = 1;</code>
     *
     * @return Whether the collection field is set.
     */
    @java.lang.Override
    public boolean hasCollection() {
      return filterCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A specific set of database resources for this filter to apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceCollection collection = 1;</code>
     *
     * @return The collection.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DatabaseResourceCollection getCollection() {
      if (collectionBuilder_ == null) {
        if (filterCase_ == 1) {
          return (com.google.privacy.dlp.v2.DatabaseResourceCollection) filter_;
        }
        return com.google.privacy.dlp.v2.DatabaseResourceCollection.getDefaultInstance();
      } else {
        if (filterCase_ == 1) {
          return collectionBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.DatabaseResourceCollection.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A specific set of database resources for this filter to apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceCollection collection = 1;</code>
     */
    public Builder setCollection(com.google.privacy.dlp.v2.DatabaseResourceCollection value) {
      if (collectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        collectionBuilder_.setMessage(value);
      }
      filterCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A specific set of database resources for this filter to apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceCollection collection = 1;</code>
     */
    public Builder setCollection(
        com.google.privacy.dlp.v2.DatabaseResourceCollection.Builder builderForValue) {
      if (collectionBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        collectionBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A specific set of database resources for this filter to apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceCollection collection = 1;</code>
     */
    public Builder mergeCollection(com.google.privacy.dlp.v2.DatabaseResourceCollection value) {
      if (collectionBuilder_ == null) {
        if (filterCase_ == 1
            && filter_
                != com.google.privacy.dlp.v2.DatabaseResourceCollection.getDefaultInstance()) {
          filter_ =
              com.google.privacy.dlp.v2.DatabaseResourceCollection.newBuilder(
                      (com.google.privacy.dlp.v2.DatabaseResourceCollection) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 1) {
          collectionBuilder_.mergeFrom(value);
        } else {
          collectionBuilder_.setMessage(value);
        }
      }
      filterCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A specific set of database resources for this filter to apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceCollection collection = 1;</code>
     */
    public Builder clearCollection() {
      if (collectionBuilder_ == null) {
        if (filterCase_ == 1) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 1) {
          filterCase_ = 0;
          filter_ = null;
        }
        collectionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A specific set of database resources for this filter to apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceCollection collection = 1;</code>
     */
    public com.google.privacy.dlp.v2.DatabaseResourceCollection.Builder getCollectionBuilder() {
      return getCollectionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A specific set of database resources for this filter to apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceCollection collection = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DatabaseResourceCollectionOrBuilder getCollectionOrBuilder() {
      if ((filterCase_ == 1) && (collectionBuilder_ != null)) {
        return collectionBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 1) {
          return (com.google.privacy.dlp.v2.DatabaseResourceCollection) filter_;
        }
        return com.google.privacy.dlp.v2.DatabaseResourceCollection.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A specific set of database resources for this filter to apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceCollection collection = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DatabaseResourceCollection,
            com.google.privacy.dlp.v2.DatabaseResourceCollection.Builder,
            com.google.privacy.dlp.v2.DatabaseResourceCollectionOrBuilder>
        getCollectionFieldBuilder() {
      if (collectionBuilder_ == null) {
        if (!(filterCase_ == 1)) {
          filter_ = com.google.privacy.dlp.v2.DatabaseResourceCollection.getDefaultInstance();
        }
        collectionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DatabaseResourceCollection,
                com.google.privacy.dlp.v2.DatabaseResourceCollection.Builder,
                com.google.privacy.dlp.v2.DatabaseResourceCollectionOrBuilder>(
                (com.google.privacy.dlp.v2.DatabaseResourceCollection) filter_,
                getParentForChildren(),
                isClean());
        filter_ = null;
      }
      filterCase_ = 1;
      onChanged();
      return collectionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.AllOtherDatabaseResources,
            com.google.privacy.dlp.v2.AllOtherDatabaseResources.Builder,
            com.google.privacy.dlp.v2.AllOtherDatabaseResourcesOrBuilder>
        othersBuilder_;
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last target in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AllOtherDatabaseResources others = 2;</code>
     *
     * @return Whether the others field is set.
     */
    @java.lang.Override
    public boolean hasOthers() {
      return filterCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last target in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AllOtherDatabaseResources others = 2;</code>
     *
     * @return The others.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.AllOtherDatabaseResources getOthers() {
      if (othersBuilder_ == null) {
        if (filterCase_ == 2) {
          return (com.google.privacy.dlp.v2.AllOtherDatabaseResources) filter_;
        }
        return com.google.privacy.dlp.v2.AllOtherDatabaseResources.getDefaultInstance();
      } else {
        if (filterCase_ == 2) {
          return othersBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.AllOtherDatabaseResources.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last target in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AllOtherDatabaseResources others = 2;</code>
     */
    public Builder setOthers(com.google.privacy.dlp.v2.AllOtherDatabaseResources value) {
      if (othersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        othersBuilder_.setMessage(value);
      }
      filterCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last target in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AllOtherDatabaseResources others = 2;</code>
     */
    public Builder setOthers(
        com.google.privacy.dlp.v2.AllOtherDatabaseResources.Builder builderForValue) {
      if (othersBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        othersBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last target in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AllOtherDatabaseResources others = 2;</code>
     */
    public Builder mergeOthers(com.google.privacy.dlp.v2.AllOtherDatabaseResources value) {
      if (othersBuilder_ == null) {
        if (filterCase_ == 2
            && filter_
                != com.google.privacy.dlp.v2.AllOtherDatabaseResources.getDefaultInstance()) {
          filter_ =
              com.google.privacy.dlp.v2.AllOtherDatabaseResources.newBuilder(
                      (com.google.privacy.dlp.v2.AllOtherDatabaseResources) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 2) {
          othersBuilder_.mergeFrom(value);
        } else {
          othersBuilder_.setMessage(value);
        }
      }
      filterCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last target in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AllOtherDatabaseResources others = 2;</code>
     */
    public Builder clearOthers() {
      if (othersBuilder_ == null) {
        if (filterCase_ == 2) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 2) {
          filterCase_ = 0;
          filter_ = null;
        }
        othersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last target in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AllOtherDatabaseResources others = 2;</code>
     */
    public com.google.privacy.dlp.v2.AllOtherDatabaseResources.Builder getOthersBuilder() {
      return getOthersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last target in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AllOtherDatabaseResources others = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.AllOtherDatabaseResourcesOrBuilder getOthersOrBuilder() {
      if ((filterCase_ == 2) && (othersBuilder_ != null)) {
        return othersBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 2) {
          return (com.google.privacy.dlp.v2.AllOtherDatabaseResources) filter_;
        }
        return com.google.privacy.dlp.v2.AllOtherDatabaseResources.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Catch-all. This should always be the last target in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AllOtherDatabaseResources others = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.AllOtherDatabaseResources,
            com.google.privacy.dlp.v2.AllOtherDatabaseResources.Builder,
            com.google.privacy.dlp.v2.AllOtherDatabaseResourcesOrBuilder>
        getOthersFieldBuilder() {
      if (othersBuilder_ == null) {
        if (!(filterCase_ == 2)) {
          filter_ = com.google.privacy.dlp.v2.AllOtherDatabaseResources.getDefaultInstance();
        }
        othersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.AllOtherDatabaseResources,
                com.google.privacy.dlp.v2.AllOtherDatabaseResources.Builder,
                com.google.privacy.dlp.v2.AllOtherDatabaseResourcesOrBuilder>(
                (com.google.privacy.dlp.v2.AllOtherDatabaseResources) filter_,
                getParentForChildren(),
                isClean());
        filter_ = null;
      }
      filterCase_ = 2;
      onChanged();
      return othersBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DatabaseResourceReference,
            com.google.privacy.dlp.v2.DatabaseResourceReference.Builder,
            com.google.privacy.dlp.v2.DatabaseResourceReferenceOrBuilder>
        databaseResourceReferenceBuilder_;
    /**
     *
     *
     * <pre>
     * The database resource to scan. Targets including this can only include
     * one target (the target with this database resource reference).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceReference database_resource_reference = 3;
     * </code>
     *
     * @return Whether the databaseResourceReference field is set.
     */
    @java.lang.Override
    public boolean hasDatabaseResourceReference() {
      return filterCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The database resource to scan. Targets including this can only include
     * one target (the target with this database resource reference).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceReference database_resource_reference = 3;
     * </code>
     *
     * @return The databaseResourceReference.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DatabaseResourceReference getDatabaseResourceReference() {
      if (databaseResourceReferenceBuilder_ == null) {
        if (filterCase_ == 3) {
          return (com.google.privacy.dlp.v2.DatabaseResourceReference) filter_;
        }
        return com.google.privacy.dlp.v2.DatabaseResourceReference.getDefaultInstance();
      } else {
        if (filterCase_ == 3) {
          return databaseResourceReferenceBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.DatabaseResourceReference.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The database resource to scan. Targets including this can only include
     * one target (the target with this database resource reference).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceReference database_resource_reference = 3;
     * </code>
     */
    public Builder setDatabaseResourceReference(
        com.google.privacy.dlp.v2.DatabaseResourceReference value) {
      if (databaseResourceReferenceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        databaseResourceReferenceBuilder_.setMessage(value);
      }
      filterCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database resource to scan. Targets including this can only include
     * one target (the target with this database resource reference).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceReference database_resource_reference = 3;
     * </code>
     */
    public Builder setDatabaseResourceReference(
        com.google.privacy.dlp.v2.DatabaseResourceReference.Builder builderForValue) {
      if (databaseResourceReferenceBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        databaseResourceReferenceBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database resource to scan. Targets including this can only include
     * one target (the target with this database resource reference).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceReference database_resource_reference = 3;
     * </code>
     */
    public Builder mergeDatabaseResourceReference(
        com.google.privacy.dlp.v2.DatabaseResourceReference value) {
      if (databaseResourceReferenceBuilder_ == null) {
        if (filterCase_ == 3
            && filter_
                != com.google.privacy.dlp.v2.DatabaseResourceReference.getDefaultInstance()) {
          filter_ =
              com.google.privacy.dlp.v2.DatabaseResourceReference.newBuilder(
                      (com.google.privacy.dlp.v2.DatabaseResourceReference) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 3) {
          databaseResourceReferenceBuilder_.mergeFrom(value);
        } else {
          databaseResourceReferenceBuilder_.setMessage(value);
        }
      }
      filterCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database resource to scan. Targets including this can only include
     * one target (the target with this database resource reference).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceReference database_resource_reference = 3;
     * </code>
     */
    public Builder clearDatabaseResourceReference() {
      if (databaseResourceReferenceBuilder_ == null) {
        if (filterCase_ == 3) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 3) {
          filterCase_ = 0;
          filter_ = null;
        }
        databaseResourceReferenceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database resource to scan. Targets including this can only include
     * one target (the target with this database resource reference).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceReference database_resource_reference = 3;
     * </code>
     */
    public com.google.privacy.dlp.v2.DatabaseResourceReference.Builder
        getDatabaseResourceReferenceBuilder() {
      return getDatabaseResourceReferenceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The database resource to scan. Targets including this can only include
     * one target (the target with this database resource reference).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceReference database_resource_reference = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DatabaseResourceReferenceOrBuilder
        getDatabaseResourceReferenceOrBuilder() {
      if ((filterCase_ == 3) && (databaseResourceReferenceBuilder_ != null)) {
        return databaseResourceReferenceBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 3) {
          return (com.google.privacy.dlp.v2.DatabaseResourceReference) filter_;
        }
        return com.google.privacy.dlp.v2.DatabaseResourceReference.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The database resource to scan. Targets including this can only include
     * one target (the target with this database resource reference).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatabaseResourceReference database_resource_reference = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DatabaseResourceReference,
            com.google.privacy.dlp.v2.DatabaseResourceReference.Builder,
            com.google.privacy.dlp.v2.DatabaseResourceReferenceOrBuilder>
        getDatabaseResourceReferenceFieldBuilder() {
      if (databaseResourceReferenceBuilder_ == null) {
        if (!(filterCase_ == 3)) {
          filter_ = com.google.privacy.dlp.v2.DatabaseResourceReference.getDefaultInstance();
        }
        databaseResourceReferenceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DatabaseResourceReference,
                com.google.privacy.dlp.v2.DatabaseResourceReference.Builder,
                com.google.privacy.dlp.v2.DatabaseResourceReferenceOrBuilder>(
                (com.google.privacy.dlp.v2.DatabaseResourceReference) filter_,
                getParentForChildren(),
                isClean());
        filter_ = null;
      }
      filterCase_ = 3;
      onChanged();
      return databaseResourceReferenceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DiscoveryCloudSqlFilter)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DiscoveryCloudSqlFilter)
  private static final com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter();
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DiscoveryCloudSqlFilter> PARSER =
      new com.google.protobuf.AbstractParser<DiscoveryCloudSqlFilter>() {
        @java.lang.Override
        public DiscoveryCloudSqlFilter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DiscoveryCloudSqlFilter> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DiscoveryCloudSqlFilter> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
