/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * How often existing tables should have their profiles refreshed.
 * New tables are scanned as quickly as possible depending on system
 * capacity.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence}
 */
public final class DiscoveryCloudSqlGenerationCadence extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence)
    DiscoveryCloudSqlGenerationCadenceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DiscoveryCloudSqlGenerationCadence.newBuilder() to construct.
  private DiscoveryCloudSqlGenerationCadence(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DiscoveryCloudSqlGenerationCadence() {
    refreshFrequency_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DiscoveryCloudSqlGenerationCadence();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlGenerationCadence_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlGenerationCadence_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.class,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.Builder.class);
  }

  public interface SchemaModifiedCadenceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The types of schema modifications to consider.
     * Defaults to NEW_COLUMNS.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
     * </code>
     *
     * @return A list containing the types.
     */
    java.util.List<
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                .CloudSqlSchemaModification>
        getTypesList();
    /**
     *
     *
     * <pre>
     * The types of schema modifications to consider.
     * Defaults to NEW_COLUMNS.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
     * </code>
     *
     * @return The count of types.
     */
    int getTypesCount();
    /**
     *
     *
     * <pre>
     * The types of schema modifications to consider.
     * Defaults to NEW_COLUMNS.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The types at the given index.
     */
    com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
            .CloudSqlSchemaModification
        getTypes(int index);
    /**
     *
     *
     * <pre>
     * The types of schema modifications to consider.
     * Defaults to NEW_COLUMNS.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for types.
     */
    java.util.List<java.lang.Integer> getTypesValueList();
    /**
     *
     *
     * <pre>
     * The types of schema modifications to consider.
     * Defaults to NEW_COLUMNS.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of types at the given index.
     */
    int getTypesValue(int index);

    /**
     *
     *
     * <pre>
     * Frequency to regenerate data profiles when the schema is modified.
     * Defaults to monthly.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileUpdateFrequency frequency = 2;</code>
     *
     * @return The enum numeric value on the wire for frequency.
     */
    int getFrequencyValue();
    /**
     *
     *
     * <pre>
     * Frequency to regenerate data profiles when the schema is modified.
     * Defaults to monthly.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileUpdateFrequency frequency = 2;</code>
     *
     * @return The frequency.
     */
    com.google.privacy.dlp.v2.DataProfileUpdateFrequency getFrequency();
  }
  /**
   *
   *
   * <pre>
   * How frequency to modify the profile when the table's schema is modified.
   * </pre>
   *
   * Protobuf type {@code
   * google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence}
   */
  public static final class SchemaModifiedCadence extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence)
      SchemaModifiedCadenceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SchemaModifiedCadence.newBuilder() to construct.
    private SchemaModifiedCadence(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SchemaModifiedCadence() {
      types_ = java.util.Collections.emptyList();
      frequency_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SchemaModifiedCadence();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlGenerationCadence_SchemaModifiedCadence_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlGenerationCadence_SchemaModifiedCadence_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                  .class,
              com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                  .Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The type of modification that causes a profile update.
     * </pre>
     *
     * Protobuf enum {@code
     * google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification}
     */
    public enum CloudSqlSchemaModification implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unused.
       * </pre>
       *
       * <code>SQL_SCHEMA_MODIFICATION_UNSPECIFIED = 0;</code>
       */
      SQL_SCHEMA_MODIFICATION_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * New columns has appeared.
       * </pre>
       *
       * <code>NEW_COLUMNS = 1;</code>
       */
      NEW_COLUMNS(1),
      /**
       *
       *
       * <pre>
       * Columns have been removed from the table.
       * </pre>
       *
       * <code>REMOVED_COLUMNS = 2;</code>
       */
      REMOVED_COLUMNS(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unused.
       * </pre>
       *
       * <code>SQL_SCHEMA_MODIFICATION_UNSPECIFIED = 0;</code>
       */
      public static final int SQL_SCHEMA_MODIFICATION_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * New columns has appeared.
       * </pre>
       *
       * <code>NEW_COLUMNS = 1;</code>
       */
      public static final int NEW_COLUMNS_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Columns have been removed from the table.
       * </pre>
       *
       * <code>REMOVED_COLUMNS = 2;</code>
       */
      public static final int REMOVED_COLUMNS_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static CloudSqlSchemaModification valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static CloudSqlSchemaModification forNumber(int value) {
        switch (value) {
          case 0:
            return SQL_SCHEMA_MODIFICATION_UNSPECIFIED;
          case 1:
            return NEW_COLUMNS;
          case 2:
            return REMOVED_COLUMNS;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<CloudSqlSchemaModification>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<CloudSqlSchemaModification>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<CloudSqlSchemaModification>() {
                public CloudSqlSchemaModification findValueByNumber(int number) {
                  return CloudSqlSchemaModification.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final CloudSqlSchemaModification[] VALUES = values();

      public static CloudSqlSchemaModification valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private CloudSqlSchemaModification(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification)
    }

    public static final int TYPES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<java.lang.Integer> types_;

    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                .CloudSqlSchemaModification>
        types_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer,
                com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                    .CloudSqlSchemaModification>() {
              public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence
                      .SchemaModifiedCadence.CloudSqlSchemaModification
                  convert(java.lang.Integer from) {
                com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                        .CloudSqlSchemaModification
                    result =
                        com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence
                            .SchemaModifiedCadence.CloudSqlSchemaModification.forNumber(from);
                return result == null
                    ? com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence
                        .SchemaModifiedCadence.CloudSqlSchemaModification.UNRECOGNIZED
                    : result;
              }
            };
    /**
     *
     *
     * <pre>
     * The types of schema modifications to consider.
     * Defaults to NEW_COLUMNS.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
     * </code>
     *
     * @return A list containing the types.
     */
    @java.lang.Override
    public java.util.List<
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                .CloudSqlSchemaModification>
        getTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer,
          com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
              .CloudSqlSchemaModification>(types_, types_converter_);
    }
    /**
     *
     *
     * <pre>
     * The types of schema modifications to consider.
     * Defaults to NEW_COLUMNS.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
     * </code>
     *
     * @return The count of types.
     */
    @java.lang.Override
    public int getTypesCount() {
      return types_.size();
    }
    /**
     *
     *
     * <pre>
     * The types of schema modifications to consider.
     * Defaults to NEW_COLUMNS.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The types at the given index.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
            .CloudSqlSchemaModification
        getTypes(int index) {
      return types_converter_.convert(types_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The types of schema modifications to consider.
     * Defaults to NEW_COLUMNS.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for types.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getTypesValueList() {
      return types_;
    }
    /**
     *
     *
     * <pre>
     * The types of schema modifications to consider.
     * Defaults to NEW_COLUMNS.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of types at the given index.
     */
    @java.lang.Override
    public int getTypesValue(int index) {
      return types_.get(index);
    }

    private int typesMemoizedSerializedSize;

    public static final int FREQUENCY_FIELD_NUMBER = 2;
    private int frequency_ = 0;
    /**
     *
     *
     * <pre>
     * Frequency to regenerate data profiles when the schema is modified.
     * Defaults to monthly.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileUpdateFrequency frequency = 2;</code>
     *
     * @return The enum numeric value on the wire for frequency.
     */
    @java.lang.Override
    public int getFrequencyValue() {
      return frequency_;
    }
    /**
     *
     *
     * <pre>
     * Frequency to regenerate data profiles when the schema is modified.
     * Defaults to monthly.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileUpdateFrequency frequency = 2;</code>
     *
     * @return The frequency.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfileUpdateFrequency getFrequency() {
      com.google.privacy.dlp.v2.DataProfileUpdateFrequency result =
          com.google.privacy.dlp.v2.DataProfileUpdateFrequency.forNumber(frequency_);
      return result == null
          ? com.google.privacy.dlp.v2.DataProfileUpdateFrequency.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (getTypesList().size() > 0) {
        output.writeUInt32NoTag(10);
        output.writeUInt32NoTag(typesMemoizedSerializedSize);
      }
      for (int i = 0; i < types_.size(); i++) {
        output.writeEnumNoTag(types_.get(i));
      }
      if (frequency_
          != com.google.privacy.dlp.v2.DataProfileUpdateFrequency.UPDATE_FREQUENCY_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, frequency_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < types_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(types_.get(i));
        }
        size += dataSize;
        if (!getTypesList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        typesMemoizedSerializedSize = dataSize;
      }
      if (frequency_
          != com.google.privacy.dlp.v2.DataProfileUpdateFrequency.UPDATE_FREQUENCY_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, frequency_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence other =
          (com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence) obj;

      if (!types_.equals(other.types_)) return false;
      if (frequency_ != other.frequency_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getTypesCount() > 0) {
        hash = (37 * hash) + TYPES_FIELD_NUMBER;
        hash = (53 * hash) + types_.hashCode();
      }
      hash = (37 * hash) + FREQUENCY_FIELD_NUMBER;
      hash = (53 * hash) + frequency_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * How frequency to modify the profile when the table's schema is modified.
     * </pre>
     *
     * Protobuf type {@code
     * google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence)
        com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence
            .SchemaModifiedCadenceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlGenerationCadence_SchemaModifiedCadence_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlGenerationCadence_SchemaModifiedCadence_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                    .class,
                com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                    .Builder.class);
      }

      // Construct using
      // com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        types_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        frequency_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlGenerationCadence_SchemaModifiedCadence_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
          getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
          build() {
        com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
          buildPartial() {
        com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence result =
            new com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence(
                this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
              result) {
        if (((bitField0_ & 0x00000001) != 0)) {
          types_ = java.util.Collections.unmodifiableList(types_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.types_ = types_;
      }

      private void buildPartial0(
          com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.frequency_ = frequency_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence) {
          return mergeFrom(
              (com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
              other) {
        if (other
            == com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                .getDefaultInstance()) return this;
        if (!other.types_.isEmpty()) {
          if (types_.isEmpty()) {
            types_ = other.types_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTypesIsMutable();
            types_.addAll(other.types_);
          }
          onChanged();
        }
        if (other.frequency_ != 0) {
          setFrequencyValue(other.getFrequencyValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  int tmpRaw = input.readEnum();
                  ensureTypesIsMutable();
                  types_.add(tmpRaw);
                  break;
                } // case 8
              case 10:
                {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while (input.getBytesUntilLimit() > 0) {
                    int tmpRaw = input.readEnum();
                    ensureTypesIsMutable();
                    types_.add(tmpRaw);
                  }
                  input.popLimit(oldLimit);
                  break;
                } // case 10
              case 16:
                {
                  frequency_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<java.lang.Integer> types_ = java.util.Collections.emptyList();

      private void ensureTypesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          types_ = new java.util.ArrayList<java.lang.Integer>(types_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * The types of schema modifications to consider.
       * Defaults to NEW_COLUMNS.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
       * </code>
       *
       * @return A list containing the types.
       */
      public java.util.List<
              com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                  .CloudSqlSchemaModification>
          getTypesList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                .CloudSqlSchemaModification>(types_, types_converter_);
      }
      /**
       *
       *
       * <pre>
       * The types of schema modifications to consider.
       * Defaults to NEW_COLUMNS.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
       * </code>
       *
       * @return The count of types.
       */
      public int getTypesCount() {
        return types_.size();
      }
      /**
       *
       *
       * <pre>
       * The types of schema modifications to consider.
       * Defaults to NEW_COLUMNS.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
       * </code>
       *
       * @param index The index of the element to return.
       * @return The types at the given index.
       */
      public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
              .CloudSqlSchemaModification
          getTypes(int index) {
        return types_converter_.convert(types_.get(index));
      }
      /**
       *
       *
       * <pre>
       * The types of schema modifications to consider.
       * Defaults to NEW_COLUMNS.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The types to set.
       * @return This builder for chaining.
       */
      public Builder setTypes(
          int index,
          com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                  .CloudSqlSchemaModification
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTypesIsMutable();
        types_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The types of schema modifications to consider.
       * Defaults to NEW_COLUMNS.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
       * </code>
       *
       * @param value The types to add.
       * @return This builder for chaining.
       */
      public Builder addTypes(
          com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                  .CloudSqlSchemaModification
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTypesIsMutable();
        types_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The types of schema modifications to consider.
       * Defaults to NEW_COLUMNS.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
       * </code>
       *
       * @param values The types to add.
       * @return This builder for chaining.
       */
      public Builder addAllTypes(
          java.lang.Iterable<
                  ? extends
                      com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence
                          .SchemaModifiedCadence.CloudSqlSchemaModification>
              values) {
        ensureTypesIsMutable();
        for (com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                .CloudSqlSchemaModification
            value : values) {
          types_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The types of schema modifications to consider.
       * Defaults to NEW_COLUMNS.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTypes() {
        types_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The types of schema modifications to consider.
       * Defaults to NEW_COLUMNS.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for types.
       */
      public java.util.List<java.lang.Integer> getTypesValueList() {
        return java.util.Collections.unmodifiableList(types_);
      }
      /**
       *
       *
       * <pre>
       * The types of schema modifications to consider.
       * Defaults to NEW_COLUMNS.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of types at the given index.
       */
      public int getTypesValue(int index) {
        return types_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The types of schema modifications to consider.
       * Defaults to NEW_COLUMNS.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The enum numeric value on the wire for types to set.
       * @return This builder for chaining.
       */
      public Builder setTypesValue(int index, int value) {
        ensureTypesIsMutable();
        types_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The types of schema modifications to consider.
       * Defaults to NEW_COLUMNS.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for types to add.
       * @return This builder for chaining.
       */
      public Builder addTypesValue(int value) {
        ensureTypesIsMutable();
        types_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The types of schema modifications to consider.
       * Defaults to NEW_COLUMNS.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.CloudSqlSchemaModification types = 1;
       * </code>
       *
       * @param values The enum numeric values on the wire for types to add.
       * @return This builder for chaining.
       */
      public Builder addAllTypesValue(java.lang.Iterable<java.lang.Integer> values) {
        ensureTypesIsMutable();
        for (int value : values) {
          types_.add(value);
        }
        onChanged();
        return this;
      }

      private int frequency_ = 0;
      /**
       *
       *
       * <pre>
       * Frequency to regenerate data profiles when the schema is modified.
       * Defaults to monthly.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfileUpdateFrequency frequency = 2;</code>
       *
       * @return The enum numeric value on the wire for frequency.
       */
      @java.lang.Override
      public int getFrequencyValue() {
        return frequency_;
      }
      /**
       *
       *
       * <pre>
       * Frequency to regenerate data profiles when the schema is modified.
       * Defaults to monthly.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfileUpdateFrequency frequency = 2;</code>
       *
       * @param value The enum numeric value on the wire for frequency to set.
       * @return This builder for chaining.
       */
      public Builder setFrequencyValue(int value) {
        frequency_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Frequency to regenerate data profiles when the schema is modified.
       * Defaults to monthly.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfileUpdateFrequency frequency = 2;</code>
       *
       * @return The frequency.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfileUpdateFrequency getFrequency() {
        com.google.privacy.dlp.v2.DataProfileUpdateFrequency result =
            com.google.privacy.dlp.v2.DataProfileUpdateFrequency.forNumber(frequency_);
        return result == null
            ? com.google.privacy.dlp.v2.DataProfileUpdateFrequency.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Frequency to regenerate data profiles when the schema is modified.
       * Defaults to monthly.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfileUpdateFrequency frequency = 2;</code>
       *
       * @param value The frequency to set.
       * @return This builder for chaining.
       */
      public Builder setFrequency(com.google.privacy.dlp.v2.DataProfileUpdateFrequency value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        frequency_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Frequency to regenerate data profiles when the schema is modified.
       * Defaults to monthly.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfileUpdateFrequency frequency = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFrequency() {
        bitField0_ = (bitField0_ & ~0x00000002);
        frequency_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence)
    private static final com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence
            .SchemaModifiedCadence
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence();
    }

    public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SchemaModifiedCadence> PARSER =
        new com.google.protobuf.AbstractParser<SchemaModifiedCadence>() {
          @java.lang.Override
          public SchemaModifiedCadence parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SchemaModifiedCadence> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SchemaModifiedCadence> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int SCHEMA_MODIFIED_CADENCE_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
      schemaModifiedCadence_;
  /**
   *
   *
   * <pre>
   * When to reprofile if the schema has changed.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence schema_modified_cadence = 1;
   * </code>
   *
   * @return Whether the schemaModifiedCadence field is set.
   */
  @java.lang.Override
  public boolean hasSchemaModifiedCadence() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * When to reprofile if the schema has changed.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence schema_modified_cadence = 1;
   * </code>
   *
   * @return The schemaModifiedCadence.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
      getSchemaModifiedCadence() {
    return schemaModifiedCadence_ == null
        ? com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
            .getDefaultInstance()
        : schemaModifiedCadence_;
  }
  /**
   *
   *
   * <pre>
   * When to reprofile if the schema has changed.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence schema_modified_cadence = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadenceOrBuilder
      getSchemaModifiedCadenceOrBuilder() {
    return schemaModifiedCadence_ == null
        ? com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
            .getDefaultInstance()
        : schemaModifiedCadence_;
  }

  public static final int REFRESH_FREQUENCY_FIELD_NUMBER = 2;
  private int refreshFrequency_ = 0;
  /**
   *
   *
   * <pre>
   * Data changes (non-schema changes) in Cloud SQL tables can't trigger
   * reprofiling. If you set this field, profiles are refreshed at this
   * frequency regardless of whether the underlying tables have changes.
   * Defaults to never.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfileUpdateFrequency refresh_frequency = 2;</code>
   *
   * @return The enum numeric value on the wire for refreshFrequency.
   */
  @java.lang.Override
  public int getRefreshFrequencyValue() {
    return refreshFrequency_;
  }
  /**
   *
   *
   * <pre>
   * Data changes (non-schema changes) in Cloud SQL tables can't trigger
   * reprofiling. If you set this field, profiles are refreshed at this
   * frequency regardless of whether the underlying tables have changes.
   * Defaults to never.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfileUpdateFrequency refresh_frequency = 2;</code>
   *
   * @return The refreshFrequency.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfileUpdateFrequency getRefreshFrequency() {
    com.google.privacy.dlp.v2.DataProfileUpdateFrequency result =
        com.google.privacy.dlp.v2.DataProfileUpdateFrequency.forNumber(refreshFrequency_);
    return result == null
        ? com.google.privacy.dlp.v2.DataProfileUpdateFrequency.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getSchemaModifiedCadence());
    }
    if (refreshFrequency_
        != com.google.privacy.dlp.v2.DataProfileUpdateFrequency.UPDATE_FREQUENCY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, refreshFrequency_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSchemaModifiedCadence());
    }
    if (refreshFrequency_
        != com.google.privacy.dlp.v2.DataProfileUpdateFrequency.UPDATE_FREQUENCY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, refreshFrequency_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence other =
        (com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence) obj;

    if (hasSchemaModifiedCadence() != other.hasSchemaModifiedCadence()) return false;
    if (hasSchemaModifiedCadence()) {
      if (!getSchemaModifiedCadence().equals(other.getSchemaModifiedCadence())) return false;
    }
    if (refreshFrequency_ != other.refreshFrequency_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasSchemaModifiedCadence()) {
      hash = (37 * hash) + SCHEMA_MODIFIED_CADENCE_FIELD_NUMBER;
      hash = (53 * hash) + getSchemaModifiedCadence().hashCode();
    }
    hash = (37 * hash) + REFRESH_FREQUENCY_FIELD_NUMBER;
    hash = (53 * hash) + refreshFrequency_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * How often existing tables should have their profiles refreshed.
   * New tables are scanned as quickly as possible depending on system
   * capacity.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence)
      com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadenceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlGenerationCadence_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlGenerationCadence_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.class,
              com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSchemaModifiedCadenceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      schemaModifiedCadence_ = null;
      if (schemaModifiedCadenceBuilder_ != null) {
        schemaModifiedCadenceBuilder_.dispose();
        schemaModifiedCadenceBuilder_ = null;
      }
      refreshFrequency_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryCloudSqlGenerationCadence_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence
        getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence build() {
      com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence buildPartial() {
      com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence result =
          new com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.schemaModifiedCadence_ =
            schemaModifiedCadenceBuilder_ == null
                ? schemaModifiedCadence_
                : schemaModifiedCadenceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.refreshFrequency_ = refreshFrequency_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence) {
        return mergeFrom((com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence other) {
      if (other
          == com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.getDefaultInstance())
        return this;
      if (other.hasSchemaModifiedCadence()) {
        mergeSchemaModifiedCadence(other.getSchemaModifiedCadence());
      }
      if (other.refreshFrequency_ != 0) {
        setRefreshFrequencyValue(other.getRefreshFrequencyValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getSchemaModifiedCadenceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                refreshFrequency_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
        schemaModifiedCadence_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                .Builder,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence
                .SchemaModifiedCadenceOrBuilder>
        schemaModifiedCadenceBuilder_;
    /**
     *
     *
     * <pre>
     * When to reprofile if the schema has changed.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence schema_modified_cadence = 1;
     * </code>
     *
     * @return Whether the schemaModifiedCadence field is set.
     */
    public boolean hasSchemaModifiedCadence() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * When to reprofile if the schema has changed.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence schema_modified_cadence = 1;
     * </code>
     *
     * @return The schemaModifiedCadence.
     */
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
        getSchemaModifiedCadence() {
      if (schemaModifiedCadenceBuilder_ == null) {
        return schemaModifiedCadence_ == null
            ? com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                .getDefaultInstance()
            : schemaModifiedCadence_;
      } else {
        return schemaModifiedCadenceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * When to reprofile if the schema has changed.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence schema_modified_cadence = 1;
     * </code>
     */
    public Builder setSchemaModifiedCadence(
        com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence value) {
      if (schemaModifiedCadenceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schemaModifiedCadence_ = value;
      } else {
        schemaModifiedCadenceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When to reprofile if the schema has changed.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence schema_modified_cadence = 1;
     * </code>
     */
    public Builder setSchemaModifiedCadence(
        com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence.Builder
            builderForValue) {
      if (schemaModifiedCadenceBuilder_ == null) {
        schemaModifiedCadence_ = builderForValue.build();
      } else {
        schemaModifiedCadenceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When to reprofile if the schema has changed.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence schema_modified_cadence = 1;
     * </code>
     */
    public Builder mergeSchemaModifiedCadence(
        com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence value) {
      if (schemaModifiedCadenceBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && schemaModifiedCadence_ != null
            && schemaModifiedCadence_
                != com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence
                    .SchemaModifiedCadence.getDefaultInstance()) {
          getSchemaModifiedCadenceBuilder().mergeFrom(value);
        } else {
          schemaModifiedCadence_ = value;
        }
      } else {
        schemaModifiedCadenceBuilder_.mergeFrom(value);
      }
      if (schemaModifiedCadence_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When to reprofile if the schema has changed.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence schema_modified_cadence = 1;
     * </code>
     */
    public Builder clearSchemaModifiedCadence() {
      bitField0_ = (bitField0_ & ~0x00000001);
      schemaModifiedCadence_ = null;
      if (schemaModifiedCadenceBuilder_ != null) {
        schemaModifiedCadenceBuilder_.dispose();
        schemaModifiedCadenceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When to reprofile if the schema has changed.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence schema_modified_cadence = 1;
     * </code>
     */
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
            .Builder
        getSchemaModifiedCadenceBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getSchemaModifiedCadenceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * When to reprofile if the schema has changed.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence schema_modified_cadence = 1;
     * </code>
     */
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence
            .SchemaModifiedCadenceOrBuilder
        getSchemaModifiedCadenceOrBuilder() {
      if (schemaModifiedCadenceBuilder_ != null) {
        return schemaModifiedCadenceBuilder_.getMessageOrBuilder();
      } else {
        return schemaModifiedCadence_ == null
            ? com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                .getDefaultInstance()
            : schemaModifiedCadence_;
      }
    }
    /**
     *
     *
     * <pre>
     * When to reprofile if the schema has changed.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence schema_modified_cadence = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                .Builder,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence
                .SchemaModifiedCadenceOrBuilder>
        getSchemaModifiedCadenceFieldBuilder() {
      if (schemaModifiedCadenceBuilder_ == null) {
        schemaModifiedCadenceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence,
                com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.SchemaModifiedCadence
                    .Builder,
                com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence
                    .SchemaModifiedCadenceOrBuilder>(
                getSchemaModifiedCadence(), getParentForChildren(), isClean());
        schemaModifiedCadence_ = null;
      }
      return schemaModifiedCadenceBuilder_;
    }

    private int refreshFrequency_ = 0;
    /**
     *
     *
     * <pre>
     * Data changes (non-schema changes) in Cloud SQL tables can't trigger
     * reprofiling. If you set this field, profiles are refreshed at this
     * frequency regardless of whether the underlying tables have changes.
     * Defaults to never.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileUpdateFrequency refresh_frequency = 2;</code>
     *
     * @return The enum numeric value on the wire for refreshFrequency.
     */
    @java.lang.Override
    public int getRefreshFrequencyValue() {
      return refreshFrequency_;
    }
    /**
     *
     *
     * <pre>
     * Data changes (non-schema changes) in Cloud SQL tables can't trigger
     * reprofiling. If you set this field, profiles are refreshed at this
     * frequency regardless of whether the underlying tables have changes.
     * Defaults to never.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileUpdateFrequency refresh_frequency = 2;</code>
     *
     * @param value The enum numeric value on the wire for refreshFrequency to set.
     * @return This builder for chaining.
     */
    public Builder setRefreshFrequencyValue(int value) {
      refreshFrequency_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data changes (non-schema changes) in Cloud SQL tables can't trigger
     * reprofiling. If you set this field, profiles are refreshed at this
     * frequency regardless of whether the underlying tables have changes.
     * Defaults to never.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileUpdateFrequency refresh_frequency = 2;</code>
     *
     * @return The refreshFrequency.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfileUpdateFrequency getRefreshFrequency() {
      com.google.privacy.dlp.v2.DataProfileUpdateFrequency result =
          com.google.privacy.dlp.v2.DataProfileUpdateFrequency.forNumber(refreshFrequency_);
      return result == null
          ? com.google.privacy.dlp.v2.DataProfileUpdateFrequency.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Data changes (non-schema changes) in Cloud SQL tables can't trigger
     * reprofiling. If you set this field, profiles are refreshed at this
     * frequency regardless of whether the underlying tables have changes.
     * Defaults to never.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileUpdateFrequency refresh_frequency = 2;</code>
     *
     * @param value The refreshFrequency to set.
     * @return This builder for chaining.
     */
    public Builder setRefreshFrequency(com.google.privacy.dlp.v2.DataProfileUpdateFrequency value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      refreshFrequency_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data changes (non-schema changes) in Cloud SQL tables can't trigger
     * reprofiling. If you set this field, profiles are refreshed at this
     * frequency regardless of whether the underlying tables have changes.
     * Defaults to never.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileUpdateFrequency refresh_frequency = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRefreshFrequency() {
      bitField0_ = (bitField0_ & ~0x00000002);
      refreshFrequency_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence)
  private static final com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence();
  }

  public static com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DiscoveryCloudSqlGenerationCadence> PARSER =
      new com.google.protobuf.AbstractParser<DiscoveryCloudSqlGenerationCadence>() {
        @java.lang.Override
        public DiscoveryCloudSqlGenerationCadence parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DiscoveryCloudSqlGenerationCadence> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DiscoveryCloudSqlGenerationCadence> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
