/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Configuration for discovery to scan resources for profile generation.
 * Only one discovery configuration may exist per organization, folder,
 * or project.
 *
 * The generated data profiles are retained according to the
 * [data retention policy]
 * (https://cloud.google.com/sensitive-data-protection/docs/data-profiles#retention).
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.DiscoveryConfig}
 */
public final class DiscoveryConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DiscoveryConfig)
    DiscoveryConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DiscoveryConfig.newBuilder() to construct.
  private DiscoveryConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DiscoveryConfig() {
    name_ = "";
    displayName_ = "";
    inspectTemplates_ = com.google.protobuf.LazyStringArrayList.emptyList();
    actions_ = java.util.Collections.emptyList();
    targets_ = java.util.Collections.emptyList();
    errors_ = java.util.Collections.emptyList();
    status_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DiscoveryConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DiscoveryConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DiscoveryConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.DiscoveryConfig.class,
            com.google.privacy.dlp.v2.DiscoveryConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Whether the discovery config is currently active. New options may be added
   * at a later time.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.DiscoveryConfig.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused
     * </pre>
     *
     * <code>STATUS_UNSPECIFIED = 0;</code>
     */
    STATUS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The discovery config is currently active.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    RUNNING(1),
    /**
     *
     *
     * <pre>
     * The discovery config is paused temporarily.
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    PAUSED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused
     * </pre>
     *
     * <code>STATUS_UNSPECIFIED = 0;</code>
     */
    public static final int STATUS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The discovery config is currently active.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    public static final int RUNNING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The discovery config is paused temporarily.
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    public static final int PAUSED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return STATUS_UNSPECIFIED;
        case 1:
          return RUNNING;
        case 2:
          return PAUSED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DiscoveryConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.DiscoveryConfig.Status)
  }

  public interface OrgConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.DiscoveryConfig.OrgConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The data to scan: folder, org, or project
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryStartingLocation location = 1;</code>
     *
     * @return Whether the location field is set.
     */
    boolean hasLocation();
    /**
     *
     *
     * <pre>
     * The data to scan: folder, org, or project
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryStartingLocation location = 1;</code>
     *
     * @return The location.
     */
    com.google.privacy.dlp.v2.DiscoveryStartingLocation getLocation();
    /**
     *
     *
     * <pre>
     * The data to scan: folder, org, or project
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryStartingLocation location = 1;</code>
     */
    com.google.privacy.dlp.v2.DiscoveryStartingLocationOrBuilder getLocationOrBuilder();

    /**
     *
     *
     * <pre>
     * The project that will run the scan. The DLP service
     * account that exists within this project must have access to all resources
     * that are profiled, and the Cloud DLP API must be enabled.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The projectId.
     */
    java.lang.String getProjectId();
    /**
     *
     *
     * <pre>
     * The project that will run the scan. The DLP service
     * account that exists within this project must have access to all resources
     * that are profiled, and the Cloud DLP API must be enabled.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The bytes for projectId.
     */
    com.google.protobuf.ByteString getProjectIdBytes();
  }
  /**
   *
   *
   * <pre>
   * Project and scan location information. Only set when the parent is an org.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DiscoveryConfig.OrgConfig}
   */
  public static final class OrgConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DiscoveryConfig.OrgConfig)
      OrgConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OrgConfig.newBuilder() to construct.
    private OrgConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OrgConfig() {
      projectId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OrgConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryConfig_OrgConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryConfig_OrgConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.class,
              com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.Builder.class);
    }

    private int bitField0_;
    public static final int LOCATION_FIELD_NUMBER = 1;
    private com.google.privacy.dlp.v2.DiscoveryStartingLocation location_;
    /**
     *
     *
     * <pre>
     * The data to scan: folder, org, or project
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryStartingLocation location = 1;</code>
     *
     * @return Whether the location field is set.
     */
    @java.lang.Override
    public boolean hasLocation() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The data to scan: folder, org, or project
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryStartingLocation location = 1;</code>
     *
     * @return The location.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryStartingLocation getLocation() {
      return location_ == null
          ? com.google.privacy.dlp.v2.DiscoveryStartingLocation.getDefaultInstance()
          : location_;
    }
    /**
     *
     *
     * <pre>
     * The data to scan: folder, org, or project
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryStartingLocation location = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryStartingLocationOrBuilder getLocationOrBuilder() {
      return location_ == null
          ? com.google.privacy.dlp.v2.DiscoveryStartingLocation.getDefaultInstance()
          : location_;
    }

    public static final int PROJECT_ID_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * The project that will run the scan. The DLP service
     * account that exists within this project must have access to all resources
     * that are profiled, and the Cloud DLP API must be enabled.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The projectId.
     */
    @java.lang.Override
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The project that will run the scan. The DLP service
     * account that exists within this project must have access to all resources
     * that are profiled, and the Cloud DLP API must be enabled.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The bytes for projectId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getLocation());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, projectId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLocation());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, projectId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig other =
          (com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig) obj;

      if (hasLocation() != other.hasLocation()) return false;
      if (hasLocation()) {
        if (!getLocation().equals(other.getLocation())) return false;
      }
      if (!getProjectId().equals(other.getProjectId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasLocation()) {
        hash = (37 * hash) + LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getLocation().hashCode();
      }
      hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getProjectId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Project and scan location information. Only set when the parent is an org.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.DiscoveryConfig.OrgConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DiscoveryConfig.OrgConfig)
        com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DiscoveryConfig_OrgConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DiscoveryConfig_OrgConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.class,
                com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getLocationFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        location_ = null;
        if (locationBuilder_ != null) {
          locationBuilder_.dispose();
          locationBuilder_ = null;
        }
        projectId_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DiscoveryConfig_OrgConfig_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig build() {
        com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig buildPartial() {
        com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig result =
            new com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.location_ = locationBuilder_ == null ? location_ : locationBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.projectId_ = projectId_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig) {
          return mergeFrom((com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig other) {
        if (other == com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.getDefaultInstance())
          return this;
        if (other.hasLocation()) {
          mergeLocation(other.getLocation());
        }
        if (!other.getProjectId().isEmpty()) {
          projectId_ = other.projectId_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getLocationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  projectId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.privacy.dlp.v2.DiscoveryStartingLocation location_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.DiscoveryStartingLocation,
              com.google.privacy.dlp.v2.DiscoveryStartingLocation.Builder,
              com.google.privacy.dlp.v2.DiscoveryStartingLocationOrBuilder>
          locationBuilder_;
      /**
       *
       *
       * <pre>
       * The data to scan: folder, org, or project
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DiscoveryStartingLocation location = 1;</code>
       *
       * @return Whether the location field is set.
       */
      public boolean hasLocation() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The data to scan: folder, org, or project
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DiscoveryStartingLocation location = 1;</code>
       *
       * @return The location.
       */
      public com.google.privacy.dlp.v2.DiscoveryStartingLocation getLocation() {
        if (locationBuilder_ == null) {
          return location_ == null
              ? com.google.privacy.dlp.v2.DiscoveryStartingLocation.getDefaultInstance()
              : location_;
        } else {
          return locationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The data to scan: folder, org, or project
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DiscoveryStartingLocation location = 1;</code>
       */
      public Builder setLocation(com.google.privacy.dlp.v2.DiscoveryStartingLocation value) {
        if (locationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          location_ = value;
        } else {
          locationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The data to scan: folder, org, or project
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DiscoveryStartingLocation location = 1;</code>
       */
      public Builder setLocation(
          com.google.privacy.dlp.v2.DiscoveryStartingLocation.Builder builderForValue) {
        if (locationBuilder_ == null) {
          location_ = builderForValue.build();
        } else {
          locationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The data to scan: folder, org, or project
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DiscoveryStartingLocation location = 1;</code>
       */
      public Builder mergeLocation(com.google.privacy.dlp.v2.DiscoveryStartingLocation value) {
        if (locationBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && location_ != null
              && location_
                  != com.google.privacy.dlp.v2.DiscoveryStartingLocation.getDefaultInstance()) {
            getLocationBuilder().mergeFrom(value);
          } else {
            location_ = value;
          }
        } else {
          locationBuilder_.mergeFrom(value);
        }
        if (location_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The data to scan: folder, org, or project
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DiscoveryStartingLocation location = 1;</code>
       */
      public Builder clearLocation() {
        bitField0_ = (bitField0_ & ~0x00000001);
        location_ = null;
        if (locationBuilder_ != null) {
          locationBuilder_.dispose();
          locationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The data to scan: folder, org, or project
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DiscoveryStartingLocation location = 1;</code>
       */
      public com.google.privacy.dlp.v2.DiscoveryStartingLocation.Builder getLocationBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getLocationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The data to scan: folder, org, or project
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DiscoveryStartingLocation location = 1;</code>
       */
      public com.google.privacy.dlp.v2.DiscoveryStartingLocationOrBuilder getLocationOrBuilder() {
        if (locationBuilder_ != null) {
          return locationBuilder_.getMessageOrBuilder();
        } else {
          return location_ == null
              ? com.google.privacy.dlp.v2.DiscoveryStartingLocation.getDefaultInstance()
              : location_;
        }
      }
      /**
       *
       *
       * <pre>
       * The data to scan: folder, org, or project
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DiscoveryStartingLocation location = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.DiscoveryStartingLocation,
              com.google.privacy.dlp.v2.DiscoveryStartingLocation.Builder,
              com.google.privacy.dlp.v2.DiscoveryStartingLocationOrBuilder>
          getLocationFieldBuilder() {
        if (locationBuilder_ == null) {
          locationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.DiscoveryStartingLocation,
                  com.google.privacy.dlp.v2.DiscoveryStartingLocation.Builder,
                  com.google.privacy.dlp.v2.DiscoveryStartingLocationOrBuilder>(
                  getLocation(), getParentForChildren(), isClean());
          location_ = null;
        }
        return locationBuilder_;
      }

      private java.lang.Object projectId_ = "";
      /**
       *
       *
       * <pre>
       * The project that will run the scan. The DLP service
       * account that exists within this project must have access to all resources
       * that are profiled, and the Cloud DLP API must be enabled.
       * </pre>
       *
       * <code>string project_id = 2;</code>
       *
       * @return The projectId.
       */
      public java.lang.String getProjectId() {
        java.lang.Object ref = projectId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          projectId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The project that will run the scan. The DLP service
       * account that exists within this project must have access to all resources
       * that are profiled, and the Cloud DLP API must be enabled.
       * </pre>
       *
       * <code>string project_id = 2;</code>
       *
       * @return The bytes for projectId.
       */
      public com.google.protobuf.ByteString getProjectIdBytes() {
        java.lang.Object ref = projectId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          projectId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The project that will run the scan. The DLP service
       * account that exists within this project must have access to all resources
       * that are profiled, and the Cloud DLP API must be enabled.
       * </pre>
       *
       * <code>string project_id = 2;</code>
       *
       * @param value The projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        projectId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The project that will run the scan. The DLP service
       * account that exists within this project must have access to all resources
       * that are profiled, and the Cloud DLP API must be enabled.
       * </pre>
       *
       * <code>string project_id = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProjectId() {
        projectId_ = getDefaultInstance().getProjectId();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The project that will run the scan. The DLP service
       * account that exists within this project must have access to all resources
       * that are profiled, and the Cloud DLP API must be enabled.
       * </pre>
       *
       * <code>string project_id = 2;</code>
       *
       * @param value The bytes for projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        projectId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DiscoveryConfig.OrgConfig)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DiscoveryConfig.OrgConfig)
    private static final com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig();
    }

    public static com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OrgConfig> PARSER =
        new com.google.protobuf.AbstractParser<OrgConfig>() {
          @java.lang.Override
          public OrgConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OrgConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OrgConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Unique resource name for the DiscoveryConfig, assigned by the service when
   * the DiscoveryConfig is created, for example
   * `projects/dlp-test-project/locations/global/discoveryConfigs/53234423`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique resource name for the DiscoveryConfig, assigned by the service when
   * the DiscoveryConfig is created, for example
   * `projects/dlp-test-project/locations/global/discoveryConfigs/53234423`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Display name (max 100 chars)
   * </pre>
   *
   * <code>string display_name = 11;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Display name (max 100 chars)
   * </pre>
   *
   * <code>string display_name = 11;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORG_CONFIG_FIELD_NUMBER = 2;
  private com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig orgConfig_;
  /**
   *
   *
   * <pre>
   * Only set when the parent is an org.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig org_config = 2;</code>
   *
   * @return Whether the orgConfig field is set.
   */
  @java.lang.Override
  public boolean hasOrgConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Only set when the parent is an org.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig org_config = 2;</code>
   *
   * @return The orgConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig getOrgConfig() {
    return orgConfig_ == null
        ? com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.getDefaultInstance()
        : orgConfig_;
  }
  /**
   *
   *
   * <pre>
   * Only set when the parent is an org.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig org_config = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfigOrBuilder getOrgConfigOrBuilder() {
    return orgConfig_ == null
        ? com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.getDefaultInstance()
        : orgConfig_;
  }

  public static final int INSPECT_TEMPLATES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList inspectTemplates_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Detection logic for profile generation.
   *
   * Not all template features are used by Discovery. FindingLimits,
   * include_quote and exclude_info_types have no impact on
   * Discovery.
   *
   * Multiple templates may be provided if there is data in multiple regions.
   * At most one template must be specified per-region (including "global").
   * Each region is scanned using the applicable template. If no region-specific
   * template is specified, but a "global" template is specified, it will be
   * copied to that region and used instead. If no global or region-specific
   * template is provided for a region with data, that region's data will not be
   * scanned.
   *
   * For more information, see
   * https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
   * </pre>
   *
   * <code>repeated string inspect_templates = 3;</code>
   *
   * @return A list containing the inspectTemplates.
   */
  public com.google.protobuf.ProtocolStringList getInspectTemplatesList() {
    return inspectTemplates_;
  }
  /**
   *
   *
   * <pre>
   * Detection logic for profile generation.
   *
   * Not all template features are used by Discovery. FindingLimits,
   * include_quote and exclude_info_types have no impact on
   * Discovery.
   *
   * Multiple templates may be provided if there is data in multiple regions.
   * At most one template must be specified per-region (including "global").
   * Each region is scanned using the applicable template. If no region-specific
   * template is specified, but a "global" template is specified, it will be
   * copied to that region and used instead. If no global or region-specific
   * template is provided for a region with data, that region's data will not be
   * scanned.
   *
   * For more information, see
   * https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
   * </pre>
   *
   * <code>repeated string inspect_templates = 3;</code>
   *
   * @return The count of inspectTemplates.
   */
  public int getInspectTemplatesCount() {
    return inspectTemplates_.size();
  }
  /**
   *
   *
   * <pre>
   * Detection logic for profile generation.
   *
   * Not all template features are used by Discovery. FindingLimits,
   * include_quote and exclude_info_types have no impact on
   * Discovery.
   *
   * Multiple templates may be provided if there is data in multiple regions.
   * At most one template must be specified per-region (including "global").
   * Each region is scanned using the applicable template. If no region-specific
   * template is specified, but a "global" template is specified, it will be
   * copied to that region and used instead. If no global or region-specific
   * template is provided for a region with data, that region's data will not be
   * scanned.
   *
   * For more information, see
   * https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
   * </pre>
   *
   * <code>repeated string inspect_templates = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The inspectTemplates at the given index.
   */
  public java.lang.String getInspectTemplates(int index) {
    return inspectTemplates_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Detection logic for profile generation.
   *
   * Not all template features are used by Discovery. FindingLimits,
   * include_quote and exclude_info_types have no impact on
   * Discovery.
   *
   * Multiple templates may be provided if there is data in multiple regions.
   * At most one template must be specified per-region (including "global").
   * Each region is scanned using the applicable template. If no region-specific
   * template is specified, but a "global" template is specified, it will be
   * copied to that region and used instead. If no global or region-specific
   * template is provided for a region with data, that region's data will not be
   * scanned.
   *
   * For more information, see
   * https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
   * </pre>
   *
   * <code>repeated string inspect_templates = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the inspectTemplates at the given index.
   */
  public com.google.protobuf.ByteString getInspectTemplatesBytes(int index) {
    return inspectTemplates_.getByteString(index);
  }

  public static final int ACTIONS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.DataProfileAction> actions_;
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of scanning.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.DataProfileAction> getActionsList() {
    return actions_;
  }
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of scanning.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.DataProfileActionOrBuilder>
      getActionsOrBuilderList() {
    return actions_;
  }
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of scanning.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
   */
  @java.lang.Override
  public int getActionsCount() {
    return actions_.size();
  }
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of scanning.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfileAction getActions(int index) {
    return actions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of scanning.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfileActionOrBuilder getActionsOrBuilder(int index) {
    return actions_.get(index);
  }

  public static final int TARGETS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.DiscoveryTarget> targets_;
  /**
   *
   *
   * <pre>
   * Target to match against for determining what to scan and how frequently.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.DiscoveryTarget> getTargetsList() {
    return targets_;
  }
  /**
   *
   *
   * <pre>
   * Target to match against for determining what to scan and how frequently.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.DiscoveryTargetOrBuilder>
      getTargetsOrBuilderList() {
    return targets_;
  }
  /**
   *
   *
   * <pre>
   * Target to match against for determining what to scan and how frequently.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
   */
  @java.lang.Override
  public int getTargetsCount() {
    return targets_.size();
  }
  /**
   *
   *
   * <pre>
   * Target to match against for determining what to scan and how frequently.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryTarget getTargets(int index) {
    return targets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Target to match against for determining what to scan and how frequently.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryTargetOrBuilder getTargetsOrBuilder(int index) {
    return targets_.get(index);
  }

  public static final int ERRORS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.Error> errors_;
  /**
   *
   *
   * <pre>
   * Output only. A stream of errors encountered when the config was activated.
   * Repeated errors may result in the config automatically being paused. Output
   * only field. Will return the last 100 errors. Whenever the config is
   * modified this list will be cleared.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.Error> getErrorsList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A stream of errors encountered when the config was activated.
   * Repeated errors may result in the config automatically being paused. Output
   * only field. Will return the last 100 errors. Whenever the config is
   * modified this list will be cleared.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.ErrorOrBuilder>
      getErrorsOrBuilderList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A stream of errors encountered when the config was activated.
   * Repeated errors may result in the config automatically being paused. Output
   * only field. Will return the last 100 errors. Whenever the config is
   * modified this list will be cleared.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getErrorsCount() {
    return errors_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. A stream of errors encountered when the config was activated.
   * Repeated errors may result in the config automatically being paused. Output
   * only field. Will return the last 100 errors. Whenever the config is
   * modified this list will be cleared.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Error getErrors(int index) {
    return errors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. A stream of errors encountered when the config was activated.
   * Repeated errors may result in the config automatically being paused. Output
   * only field. Will return the last 100 errors. Whenever the config is
   * modified this list will be cleared.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ErrorOrBuilder getErrorsOrBuilder(int index) {
    return errors_.get(index);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a DiscoveryConfig.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a DiscoveryConfig.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a DiscoveryConfig.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a DiscoveryConfig.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a DiscoveryConfig.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a DiscoveryConfig.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LAST_RUN_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp lastRunTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of the last time this config was executed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastRunTime field is set.
   */
  @java.lang.Override
  public boolean hasLastRunTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of the last time this config was executed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastRunTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastRunTime() {
    return lastRunTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : lastRunTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of the last time this config was executed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastRunTimeOrBuilder() {
    return lastRunTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : lastRunTime_;
  }

  public static final int STATUS_FIELD_NUMBER = 10;
  private int status_ = 0;
  /**
   *
   *
   * <pre>
   * Required. A status for this configuration.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.DiscoveryConfig.Status status = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override
  public int getStatusValue() {
    return status_;
  }
  /**
   *
   *
   * <pre>
   * Required. A status for this configuration.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.DiscoveryConfig.Status status = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryConfig.Status getStatus() {
    com.google.privacy.dlp.v2.DiscoveryConfig.Status result =
        com.google.privacy.dlp.v2.DiscoveryConfig.Status.forNumber(status_);
    return result == null ? com.google.privacy.dlp.v2.DiscoveryConfig.Status.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getOrgConfig());
    }
    for (int i = 0; i < inspectTemplates_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, inspectTemplates_.getRaw(i));
    }
    for (int i = 0; i < actions_.size(); i++) {
      output.writeMessage(4, actions_.get(i));
    }
    for (int i = 0; i < targets_.size(); i++) {
      output.writeMessage(5, targets_.get(i));
    }
    for (int i = 0; i < errors_.size(); i++) {
      output.writeMessage(6, errors_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getUpdateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(9, getLastRunTime());
    }
    if (status_
        != com.google.privacy.dlp.v2.DiscoveryConfig.Status.STATUS_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOrgConfig());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < inspectTemplates_.size(); i++) {
        dataSize += computeStringSizeNoTag(inspectTemplates_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getInspectTemplatesList().size();
    }
    for (int i = 0; i < actions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, actions_.get(i));
    }
    for (int i = 0; i < targets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, targets_.get(i));
    }
    for (int i = 0; i < errors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, errors_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getUpdateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getLastRunTime());
    }
    if (status_
        != com.google.privacy.dlp.v2.DiscoveryConfig.Status.STATUS_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.DiscoveryConfig)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.DiscoveryConfig other =
        (com.google.privacy.dlp.v2.DiscoveryConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasOrgConfig() != other.hasOrgConfig()) return false;
    if (hasOrgConfig()) {
      if (!getOrgConfig().equals(other.getOrgConfig())) return false;
    }
    if (!getInspectTemplatesList().equals(other.getInspectTemplatesList())) return false;
    if (!getActionsList().equals(other.getActionsList())) return false;
    if (!getTargetsList().equals(other.getTargetsList())) return false;
    if (!getErrorsList().equals(other.getErrorsList())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasLastRunTime() != other.hasLastRunTime()) return false;
    if (hasLastRunTime()) {
      if (!getLastRunTime().equals(other.getLastRunTime())) return false;
    }
    if (status_ != other.status_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasOrgConfig()) {
      hash = (37 * hash) + ORG_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOrgConfig().hashCode();
    }
    if (getInspectTemplatesCount() > 0) {
      hash = (37 * hash) + INSPECT_TEMPLATES_FIELD_NUMBER;
      hash = (53 * hash) + getInspectTemplatesList().hashCode();
    }
    if (getActionsCount() > 0) {
      hash = (37 * hash) + ACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getActionsList().hashCode();
    }
    if (getTargetsCount() > 0) {
      hash = (37 * hash) + TARGETS_FIELD_NUMBER;
      hash = (53 * hash) + getTargetsList().hashCode();
    }
    if (getErrorsCount() > 0) {
      hash = (37 * hash) + ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorsList().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasLastRunTime()) {
      hash = (37 * hash) + LAST_RUN_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastRunTime().hashCode();
    }
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.DiscoveryConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DiscoveryConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DiscoveryConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DiscoveryConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.DiscoveryConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for discovery to scan resources for profile generation.
   * Only one discovery configuration may exist per organization, folder,
   * or project.
   *
   * The generated data profiles are retained according to the
   * [data retention policy]
   * (https://cloud.google.com/sensitive-data-protection/docs/data-profiles#retention).
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DiscoveryConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DiscoveryConfig)
      com.google.privacy.dlp.v2.DiscoveryConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DiscoveryConfig.class,
              com.google.privacy.dlp.v2.DiscoveryConfig.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.DiscoveryConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getOrgConfigFieldBuilder();
        getActionsFieldBuilder();
        getTargetsFieldBuilder();
        getErrorsFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getLastRunTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      orgConfig_ = null;
      if (orgConfigBuilder_ != null) {
        orgConfigBuilder_.dispose();
        orgConfigBuilder_ = null;
      }
      inspectTemplates_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (actionsBuilder_ == null) {
        actions_ = java.util.Collections.emptyList();
      } else {
        actions_ = null;
        actionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (targetsBuilder_ == null) {
        targets_ = java.util.Collections.emptyList();
      } else {
        targets_ = null;
        targetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
      } else {
        errors_ = null;
        errorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      lastRunTime_ = null;
      if (lastRunTimeBuilder_ != null) {
        lastRunTimeBuilder_.dispose();
        lastRunTimeBuilder_ = null;
      }
      status_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DiscoveryConfig_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryConfig getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.DiscoveryConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryConfig build() {
      com.google.privacy.dlp.v2.DiscoveryConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryConfig buildPartial() {
      com.google.privacy.dlp.v2.DiscoveryConfig result =
          new com.google.privacy.dlp.v2.DiscoveryConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.privacy.dlp.v2.DiscoveryConfig result) {
      if (actionsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          actions_ = java.util.Collections.unmodifiableList(actions_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.actions_ = actions_;
      } else {
        result.actions_ = actionsBuilder_.build();
      }
      if (targetsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          targets_ = java.util.Collections.unmodifiableList(targets_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.targets_ = targets_;
      } else {
        result.targets_ = targetsBuilder_.build();
      }
      if (errorsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          errors_ = java.util.Collections.unmodifiableList(errors_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.errors_ = errors_;
      } else {
        result.errors_ = errorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.privacy.dlp.v2.DiscoveryConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.orgConfig_ = orgConfigBuilder_ == null ? orgConfig_ : orgConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        inspectTemplates_.makeImmutable();
        result.inspectTemplates_ = inspectTemplates_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.lastRunTime_ =
            lastRunTimeBuilder_ == null ? lastRunTime_ : lastRunTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.status_ = status_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.DiscoveryConfig) {
        return mergeFrom((com.google.privacy.dlp.v2.DiscoveryConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.DiscoveryConfig other) {
      if (other == com.google.privacy.dlp.v2.DiscoveryConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasOrgConfig()) {
        mergeOrgConfig(other.getOrgConfig());
      }
      if (!other.inspectTemplates_.isEmpty()) {
        if (inspectTemplates_.isEmpty()) {
          inspectTemplates_ = other.inspectTemplates_;
          bitField0_ |= 0x00000008;
        } else {
          ensureInspectTemplatesIsMutable();
          inspectTemplates_.addAll(other.inspectTemplates_);
        }
        onChanged();
      }
      if (actionsBuilder_ == null) {
        if (!other.actions_.isEmpty()) {
          if (actions_.isEmpty()) {
            actions_ = other.actions_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureActionsIsMutable();
            actions_.addAll(other.actions_);
          }
          onChanged();
        }
      } else {
        if (!other.actions_.isEmpty()) {
          if (actionsBuilder_.isEmpty()) {
            actionsBuilder_.dispose();
            actionsBuilder_ = null;
            actions_ = other.actions_;
            bitField0_ = (bitField0_ & ~0x00000010);
            actionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getActionsFieldBuilder()
                    : null;
          } else {
            actionsBuilder_.addAllMessages(other.actions_);
          }
        }
      }
      if (targetsBuilder_ == null) {
        if (!other.targets_.isEmpty()) {
          if (targets_.isEmpty()) {
            targets_ = other.targets_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureTargetsIsMutable();
            targets_.addAll(other.targets_);
          }
          onChanged();
        }
      } else {
        if (!other.targets_.isEmpty()) {
          if (targetsBuilder_.isEmpty()) {
            targetsBuilder_.dispose();
            targetsBuilder_ = null;
            targets_ = other.targets_;
            bitField0_ = (bitField0_ & ~0x00000020);
            targetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTargetsFieldBuilder()
                    : null;
          } else {
            targetsBuilder_.addAllMessages(other.targets_);
          }
        }
      }
      if (errorsBuilder_ == null) {
        if (!other.errors_.isEmpty()) {
          if (errors_.isEmpty()) {
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureErrorsIsMutable();
            errors_.addAll(other.errors_);
          }
          onChanged();
        }
      } else {
        if (!other.errors_.isEmpty()) {
          if (errorsBuilder_.isEmpty()) {
            errorsBuilder_.dispose();
            errorsBuilder_ = null;
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000040);
            errorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorsFieldBuilder()
                    : null;
          } else {
            errorsBuilder_.addAllMessages(other.errors_);
          }
        }
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasLastRunTime()) {
        mergeLastRunTime(other.getLastRunTime());
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getOrgConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureInspectTemplatesIsMutable();
                inspectTemplates_.add(s);
                break;
              } // case 26
            case 34:
              {
                com.google.privacy.dlp.v2.DataProfileAction m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.DataProfileAction.parser(), extensionRegistry);
                if (actionsBuilder_ == null) {
                  ensureActionsIsMutable();
                  actions_.add(m);
                } else {
                  actionsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.privacy.dlp.v2.DiscoveryTarget m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.DiscoveryTarget.parser(), extensionRegistry);
                if (targetsBuilder_ == null) {
                  ensureTargetsIsMutable();
                  targets_.add(m);
                } else {
                  targetsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                com.google.privacy.dlp.v2.Error m =
                    input.readMessage(com.google.privacy.dlp.v2.Error.parser(), extensionRegistry);
                if (errorsBuilder_ == null) {
                  ensureErrorsIsMutable();
                  errors_.add(m);
                } else {
                  errorsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getLastRunTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 74
            case 80:
              {
                status_ = input.readEnum();
                bitField0_ |= 0x00000400;
                break;
              } // case 80
            case 90:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Unique resource name for the DiscoveryConfig, assigned by the service when
     * the DiscoveryConfig is created, for example
     * `projects/dlp-test-project/locations/global/discoveryConfigs/53234423`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique resource name for the DiscoveryConfig, assigned by the service when
     * the DiscoveryConfig is created, for example
     * `projects/dlp-test-project/locations/global/discoveryConfigs/53234423`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique resource name for the DiscoveryConfig, assigned by the service when
     * the DiscoveryConfig is created, for example
     * `projects/dlp-test-project/locations/global/discoveryConfigs/53234423`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique resource name for the DiscoveryConfig, assigned by the service when
     * the DiscoveryConfig is created, for example
     * `projects/dlp-test-project/locations/global/discoveryConfigs/53234423`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique resource name for the DiscoveryConfig, assigned by the service when
     * the DiscoveryConfig is created, for example
     * `projects/dlp-test-project/locations/global/discoveryConfigs/53234423`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Display name (max 100 chars)
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name (max 100 chars)
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name (max 100 chars)
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display name (max 100 chars)
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display name (max 100 chars)
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig orgConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig,
            com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.Builder,
            com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfigOrBuilder>
        orgConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Only set when the parent is an org.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig org_config = 2;</code>
     *
     * @return Whether the orgConfig field is set.
     */
    public boolean hasOrgConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Only set when the parent is an org.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig org_config = 2;</code>
     *
     * @return The orgConfig.
     */
    public com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig getOrgConfig() {
      if (orgConfigBuilder_ == null) {
        return orgConfig_ == null
            ? com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.getDefaultInstance()
            : orgConfig_;
      } else {
        return orgConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Only set when the parent is an org.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig org_config = 2;</code>
     */
    public Builder setOrgConfig(com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig value) {
      if (orgConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        orgConfig_ = value;
      } else {
        orgConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only set when the parent is an org.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig org_config = 2;</code>
     */
    public Builder setOrgConfig(
        com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.Builder builderForValue) {
      if (orgConfigBuilder_ == null) {
        orgConfig_ = builderForValue.build();
      } else {
        orgConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only set when the parent is an org.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig org_config = 2;</code>
     */
    public Builder mergeOrgConfig(com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig value) {
      if (orgConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && orgConfig_ != null
            && orgConfig_
                != com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.getDefaultInstance()) {
          getOrgConfigBuilder().mergeFrom(value);
        } else {
          orgConfig_ = value;
        }
      } else {
        orgConfigBuilder_.mergeFrom(value);
      }
      if (orgConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only set when the parent is an org.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig org_config = 2;</code>
     */
    public Builder clearOrgConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      orgConfig_ = null;
      if (orgConfigBuilder_ != null) {
        orgConfigBuilder_.dispose();
        orgConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only set when the parent is an org.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig org_config = 2;</code>
     */
    public com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.Builder getOrgConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getOrgConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Only set when the parent is an org.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig org_config = 2;</code>
     */
    public com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfigOrBuilder getOrgConfigOrBuilder() {
      if (orgConfigBuilder_ != null) {
        return orgConfigBuilder_.getMessageOrBuilder();
      } else {
        return orgConfig_ == null
            ? com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.getDefaultInstance()
            : orgConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Only set when the parent is an org.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig org_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig,
            com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.Builder,
            com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfigOrBuilder>
        getOrgConfigFieldBuilder() {
      if (orgConfigBuilder_ == null) {
        orgConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig,
                com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig.Builder,
                com.google.privacy.dlp.v2.DiscoveryConfig.OrgConfigOrBuilder>(
                getOrgConfig(), getParentForChildren(), isClean());
        orgConfig_ = null;
      }
      return orgConfigBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList inspectTemplates_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureInspectTemplatesIsMutable() {
      if (!inspectTemplates_.isModifiable()) {
        inspectTemplates_ = new com.google.protobuf.LazyStringArrayList(inspectTemplates_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     *
     * Not all template features are used by Discovery. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * Discovery.
     *
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     *
     * For more information, see
     * https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 3;</code>
     *
     * @return A list containing the inspectTemplates.
     */
    public com.google.protobuf.ProtocolStringList getInspectTemplatesList() {
      inspectTemplates_.makeImmutable();
      return inspectTemplates_;
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     *
     * Not all template features are used by Discovery. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * Discovery.
     *
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     *
     * For more information, see
     * https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 3;</code>
     *
     * @return The count of inspectTemplates.
     */
    public int getInspectTemplatesCount() {
      return inspectTemplates_.size();
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     *
     * Not all template features are used by Discovery. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * Discovery.
     *
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     *
     * For more information, see
     * https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The inspectTemplates at the given index.
     */
    public java.lang.String getInspectTemplates(int index) {
      return inspectTemplates_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     *
     * Not all template features are used by Discovery. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * Discovery.
     *
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     *
     * For more information, see
     * https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the inspectTemplates at the given index.
     */
    public com.google.protobuf.ByteString getInspectTemplatesBytes(int index) {
      return inspectTemplates_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     *
     * Not all template features are used by Discovery. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * Discovery.
     *
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     *
     * For more information, see
     * https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The inspectTemplates to set.
     * @return This builder for chaining.
     */
    public Builder setInspectTemplates(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInspectTemplatesIsMutable();
      inspectTemplates_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     *
     * Not all template features are used by Discovery. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * Discovery.
     *
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     *
     * For more information, see
     * https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 3;</code>
     *
     * @param value The inspectTemplates to add.
     * @return This builder for chaining.
     */
    public Builder addInspectTemplates(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInspectTemplatesIsMutable();
      inspectTemplates_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     *
     * Not all template features are used by Discovery. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * Discovery.
     *
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     *
     * For more information, see
     * https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 3;</code>
     *
     * @param values The inspectTemplates to add.
     * @return This builder for chaining.
     */
    public Builder addAllInspectTemplates(java.lang.Iterable<java.lang.String> values) {
      ensureInspectTemplatesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, inspectTemplates_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     *
     * Not all template features are used by Discovery. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * Discovery.
     *
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     *
     * For more information, see
     * https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInspectTemplates() {
      inspectTemplates_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     *
     * Not all template features are used by Discovery. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * Discovery.
     *
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     *
     * For more information, see
     * https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 3;</code>
     *
     * @param value The bytes of the inspectTemplates to add.
     * @return This builder for chaining.
     */
    public Builder addInspectTemplatesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureInspectTemplatesIsMutable();
      inspectTemplates_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<com.google.privacy.dlp.v2.DataProfileAction> actions_ =
        java.util.Collections.emptyList();

    private void ensureActionsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        actions_ = new java.util.ArrayList<com.google.privacy.dlp.v2.DataProfileAction>(actions_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.DataProfileAction,
            com.google.privacy.dlp.v2.DataProfileAction.Builder,
            com.google.privacy.dlp.v2.DataProfileActionOrBuilder>
        actionsBuilder_;

    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.DataProfileAction> getActionsList() {
      if (actionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(actions_);
      } else {
        return actionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public int getActionsCount() {
      if (actionsBuilder_ == null) {
        return actions_.size();
      } else {
        return actionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public com.google.privacy.dlp.v2.DataProfileAction getActions(int index) {
      if (actionsBuilder_ == null) {
        return actions_.get(index);
      } else {
        return actionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public Builder setActions(int index, com.google.privacy.dlp.v2.DataProfileAction value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.set(index, value);
        onChanged();
      } else {
        actionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public Builder setActions(
        int index, com.google.privacy.dlp.v2.DataProfileAction.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.set(index, builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public Builder addActions(com.google.privacy.dlp.v2.DataProfileAction value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.add(value);
        onChanged();
      } else {
        actionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public Builder addActions(int index, com.google.privacy.dlp.v2.DataProfileAction value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.add(index, value);
        onChanged();
      } else {
        actionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public Builder addActions(com.google.privacy.dlp.v2.DataProfileAction.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.add(builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public Builder addActions(
        int index, com.google.privacy.dlp.v2.DataProfileAction.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.add(index, builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public Builder addAllActions(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.DataProfileAction> values) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, actions_);
        onChanged();
      } else {
        actionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public Builder clearActions() {
      if (actionsBuilder_ == null) {
        actions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        actionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public Builder removeActions(int index) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.remove(index);
        onChanged();
      } else {
        actionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public com.google.privacy.dlp.v2.DataProfileAction.Builder getActionsBuilder(int index) {
      return getActionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public com.google.privacy.dlp.v2.DataProfileActionOrBuilder getActionsOrBuilder(int index) {
      if (actionsBuilder_ == null) {
        return actions_.get(index);
      } else {
        return actionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.DataProfileActionOrBuilder>
        getActionsOrBuilderList() {
      if (actionsBuilder_ != null) {
        return actionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(actions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public com.google.privacy.dlp.v2.DataProfileAction.Builder addActionsBuilder() {
      return getActionsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.DataProfileAction.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public com.google.privacy.dlp.v2.DataProfileAction.Builder addActionsBuilder(int index) {
      return getActionsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.DataProfileAction.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of scanning.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.DataProfileAction.Builder>
        getActionsBuilderList() {
      return getActionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.DataProfileAction,
            com.google.privacy.dlp.v2.DataProfileAction.Builder,
            com.google.privacy.dlp.v2.DataProfileActionOrBuilder>
        getActionsFieldBuilder() {
      if (actionsBuilder_ == null) {
        actionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.DataProfileAction,
                com.google.privacy.dlp.v2.DataProfileAction.Builder,
                com.google.privacy.dlp.v2.DataProfileActionOrBuilder>(
                actions_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        actions_ = null;
      }
      return actionsBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.DiscoveryTarget> targets_ =
        java.util.Collections.emptyList();

    private void ensureTargetsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        targets_ = new java.util.ArrayList<com.google.privacy.dlp.v2.DiscoveryTarget>(targets_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryTarget,
            com.google.privacy.dlp.v2.DiscoveryTarget.Builder,
            com.google.privacy.dlp.v2.DiscoveryTargetOrBuilder>
        targetsBuilder_;

    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.DiscoveryTarget> getTargetsList() {
      if (targetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(targets_);
      } else {
        return targetsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public int getTargetsCount() {
      if (targetsBuilder_ == null) {
        return targets_.size();
      } else {
        return targetsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public com.google.privacy.dlp.v2.DiscoveryTarget getTargets(int index) {
      if (targetsBuilder_ == null) {
        return targets_.get(index);
      } else {
        return targetsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public Builder setTargets(int index, com.google.privacy.dlp.v2.DiscoveryTarget value) {
      if (targetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetsIsMutable();
        targets_.set(index, value);
        onChanged();
      } else {
        targetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public Builder setTargets(
        int index, com.google.privacy.dlp.v2.DiscoveryTarget.Builder builderForValue) {
      if (targetsBuilder_ == null) {
        ensureTargetsIsMutable();
        targets_.set(index, builderForValue.build());
        onChanged();
      } else {
        targetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public Builder addTargets(com.google.privacy.dlp.v2.DiscoveryTarget value) {
      if (targetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetsIsMutable();
        targets_.add(value);
        onChanged();
      } else {
        targetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public Builder addTargets(int index, com.google.privacy.dlp.v2.DiscoveryTarget value) {
      if (targetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetsIsMutable();
        targets_.add(index, value);
        onChanged();
      } else {
        targetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public Builder addTargets(com.google.privacy.dlp.v2.DiscoveryTarget.Builder builderForValue) {
      if (targetsBuilder_ == null) {
        ensureTargetsIsMutable();
        targets_.add(builderForValue.build());
        onChanged();
      } else {
        targetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public Builder addTargets(
        int index, com.google.privacy.dlp.v2.DiscoveryTarget.Builder builderForValue) {
      if (targetsBuilder_ == null) {
        ensureTargetsIsMutable();
        targets_.add(index, builderForValue.build());
        onChanged();
      } else {
        targetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public Builder addAllTargets(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.DiscoveryTarget> values) {
      if (targetsBuilder_ == null) {
        ensureTargetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targets_);
        onChanged();
      } else {
        targetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public Builder clearTargets() {
      if (targetsBuilder_ == null) {
        targets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        targetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public Builder removeTargets(int index) {
      if (targetsBuilder_ == null) {
        ensureTargetsIsMutable();
        targets_.remove(index);
        onChanged();
      } else {
        targetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public com.google.privacy.dlp.v2.DiscoveryTarget.Builder getTargetsBuilder(int index) {
      return getTargetsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public com.google.privacy.dlp.v2.DiscoveryTargetOrBuilder getTargetsOrBuilder(int index) {
      if (targetsBuilder_ == null) {
        return targets_.get(index);
      } else {
        return targetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.DiscoveryTargetOrBuilder>
        getTargetsOrBuilderList() {
      if (targetsBuilder_ != null) {
        return targetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(targets_);
      }
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public com.google.privacy.dlp.v2.DiscoveryTarget.Builder addTargetsBuilder() {
      return getTargetsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.DiscoveryTarget.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public com.google.privacy.dlp.v2.DiscoveryTarget.Builder addTargetsBuilder(int index) {
      return getTargetsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.DiscoveryTarget.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Target to match against for determining what to scan and how frequently.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.DiscoveryTarget.Builder>
        getTargetsBuilderList() {
      return getTargetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryTarget,
            com.google.privacy.dlp.v2.DiscoveryTarget.Builder,
            com.google.privacy.dlp.v2.DiscoveryTargetOrBuilder>
        getTargetsFieldBuilder() {
      if (targetsBuilder_ == null) {
        targetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.DiscoveryTarget,
                com.google.privacy.dlp.v2.DiscoveryTarget.Builder,
                com.google.privacy.dlp.v2.DiscoveryTargetOrBuilder>(
                targets_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        targets_ = null;
      }
      return targetsBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.Error> errors_ =
        java.util.Collections.emptyList();

    private void ensureErrorsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        errors_ = new java.util.ArrayList<com.google.privacy.dlp.v2.Error>(errors_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.Error,
            com.google.privacy.dlp.v2.Error.Builder,
            com.google.privacy.dlp.v2.ErrorOrBuilder>
        errorsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.privacy.dlp.v2.Error> getErrorsList() {
      if (errorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errors_);
      } else {
        return errorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getErrorsCount() {
      if (errorsBuilder_ == null) {
        return errors_.size();
      } else {
        return errorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.privacy.dlp.v2.Error getErrors(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setErrors(int index, com.google.privacy.dlp.v2.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.set(index, value);
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setErrors(int index, com.google.privacy.dlp.v2.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(com.google.privacy.dlp.v2.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(int index, com.google.privacy.dlp.v2.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(index, value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(com.google.privacy.dlp.v2.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(int index, com.google.privacy.dlp.v2.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllErrors(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.Error> values) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errors_);
        onChanged();
      } else {
        errorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearErrors() {
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        errorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeErrors(int index) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.remove(index);
        onChanged();
      } else {
        errorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.privacy.dlp.v2.Error.Builder getErrorsBuilder(int index) {
      return getErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.privacy.dlp.v2.ErrorOrBuilder getErrorsOrBuilder(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.ErrorOrBuilder>
        getErrorsOrBuilderList() {
      if (errorsBuilder_ != null) {
        return errorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.privacy.dlp.v2.Error.Builder addErrorsBuilder() {
      return getErrorsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.privacy.dlp.v2.Error.Builder addErrorsBuilder(int index) {
      return getErrorsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.privacy.dlp.v2.Error.Builder> getErrorsBuilderList() {
      return getErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.Error,
            com.google.privacy.dlp.v2.Error.Builder,
            com.google.privacy.dlp.v2.ErrorOrBuilder>
        getErrorsFieldBuilder() {
      if (errorsBuilder_ == null) {
        errorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.Error,
                com.google.privacy.dlp.v2.Error.Builder,
                com.google.privacy.dlp.v2.ErrorOrBuilder>(
                errors_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        errors_ = null;
      }
      return errorsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DiscoveryConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastRunTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastRunTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this config was executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastRunTime field is set.
     */
    public boolean hasLastRunTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this config was executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastRunTime.
     */
    public com.google.protobuf.Timestamp getLastRunTime() {
      if (lastRunTimeBuilder_ == null) {
        return lastRunTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastRunTime_;
      } else {
        return lastRunTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this config was executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastRunTime(com.google.protobuf.Timestamp value) {
      if (lastRunTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastRunTime_ = value;
      } else {
        lastRunTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this config was executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastRunTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastRunTimeBuilder_ == null) {
        lastRunTime_ = builderForValue.build();
      } else {
        lastRunTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this config was executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastRunTime(com.google.protobuf.Timestamp value) {
      if (lastRunTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && lastRunTime_ != null
            && lastRunTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastRunTimeBuilder().mergeFrom(value);
        } else {
          lastRunTime_ = value;
        }
      } else {
        lastRunTimeBuilder_.mergeFrom(value);
      }
      if (lastRunTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this config was executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastRunTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      lastRunTime_ = null;
      if (lastRunTimeBuilder_ != null) {
        lastRunTimeBuilder_.dispose();
        lastRunTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this config was executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastRunTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getLastRunTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this config was executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastRunTimeOrBuilder() {
      if (lastRunTimeBuilder_ != null) {
        return lastRunTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastRunTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastRunTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this config was executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastRunTimeFieldBuilder() {
      if (lastRunTimeBuilder_ == null) {
        lastRunTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastRunTime(), getParentForChildren(), isClean());
        lastRunTime_ = null;
      }
      return lastRunTimeBuilder_;
    }

    private int status_ = 0;
    /**
     *
     *
     * <pre>
     * Required. A status for this configuration.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryConfig.Status status = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override
    public int getStatusValue() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * Required. A status for this configuration.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryConfig.Status status = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A status for this configuration.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryConfig.Status status = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryConfig.Status getStatus() {
      com.google.privacy.dlp.v2.DiscoveryConfig.Status result =
          com.google.privacy.dlp.v2.DiscoveryConfig.Status.forNumber(status_);
      return result == null
          ? com.google.privacy.dlp.v2.DiscoveryConfig.Status.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. A status for this configuration.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryConfig.Status status = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.privacy.dlp.v2.DiscoveryConfig.Status value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A status for this configuration.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryConfig.Status status = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000400);
      status_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DiscoveryConfig)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DiscoveryConfig)
  private static final com.google.privacy.dlp.v2.DiscoveryConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DiscoveryConfig();
  }

  public static com.google.privacy.dlp.v2.DiscoveryConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DiscoveryConfig> PARSER =
      new com.google.protobuf.AbstractParser<DiscoveryConfig>() {
        @java.lang.Override
        public DiscoveryConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DiscoveryConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DiscoveryConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
