/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Combines all of the information about a DLP job.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.DlpJob}
 */
public final class DlpJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DlpJob)
    DlpJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DlpJob.newBuilder() to construct.
  private DlpJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DlpJob() {
    name_ = "";
    type_ = 0;
    state_ = 0;
    jobTriggerName_ = "";
    errors_ = java.util.Collections.emptyList();
    actionDetails_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DlpJob();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DlpJob_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DlpJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.DlpJob.class, com.google.privacy.dlp.v2.DlpJob.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states of a job. New items may be added.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.DlpJob.JobState}
   */
  public enum JobState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>JOB_STATE_UNSPECIFIED = 0;</code>
     */
    JOB_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The job has not yet started.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * The job is currently running. Once a job has finished it will transition
     * to FAILED or DONE.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The job is no longer running.
     * </pre>
     *
     * <code>DONE = 3;</code>
     */
    DONE(3),
    /**
     *
     *
     * <pre>
     * The job was canceled before it could be completed.
     * </pre>
     *
     * <code>CANCELED = 4;</code>
     */
    CANCELED(4),
    /**
     *
     *
     * <pre>
     * The job had an error and did not complete.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    FAILED(5),
    /**
     *
     *
     * <pre>
     * The job is currently accepting findings via hybridInspect.
     * A hybrid job in ACTIVE state may continue to have findings added to it
     * through the calling of hybridInspect. After the job has finished no more
     * calls to hybridInspect may be made. ACTIVE jobs can transition to DONE.
     * </pre>
     *
     * <code>ACTIVE = 6;</code>
     */
    ACTIVE(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>JOB_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int JOB_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The job has not yet started.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The job is currently running. Once a job has finished it will transition
     * to FAILED or DONE.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The job is no longer running.
     * </pre>
     *
     * <code>DONE = 3;</code>
     */
    public static final int DONE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The job was canceled before it could be completed.
     * </pre>
     *
     * <code>CANCELED = 4;</code>
     */
    public static final int CANCELED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The job had an error and did not complete.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    public static final int FAILED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The job is currently accepting findings via hybridInspect.
     * A hybrid job in ACTIVE state may continue to have findings added to it
     * through the calling of hybridInspect. After the job has finished no more
     * calls to hybridInspect may be made. ACTIVE jobs can transition to DONE.
     * </pre>
     *
     * <code>ACTIVE = 6;</code>
     */
    public static final int ACTIVE_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static JobState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static JobState forNumber(int value) {
      switch (value) {
        case 0:
          return JOB_STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return RUNNING;
        case 3:
          return DONE;
        case 4:
          return CANCELED;
        case 5:
          return FAILED;
        case 6:
          return ACTIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<JobState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<JobState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<JobState>() {
          public JobState findValueByNumber(int number) {
            return JobState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpJob.getDescriptor().getEnumTypes().get(0);
    }

    private static final JobState[] VALUES = values();

    public static JobState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private JobState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.DlpJob.JobState)
  }

  private int bitField0_;
  private int detailsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object details_;

  public enum DetailsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    RISK_DETAILS(4),
    INSPECT_DETAILS(5),
    DETAILS_NOT_SET(0);
    private final int value;

    private DetailsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DetailsCase valueOf(int value) {
      return forNumber(value);
    }

    public static DetailsCase forNumber(int value) {
      switch (value) {
        case 4:
          return RISK_DETAILS;
        case 5:
          return INSPECT_DETAILS;
        case 0:
          return DETAILS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DetailsCase getDetailsCase() {
    return DetailsCase.forNumber(detailsCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The server-assigned name.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The server-assigned name.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * The type of job.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DlpJobType type = 2;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * The type of job.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DlpJobType type = 2;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DlpJobType getType() {
    com.google.privacy.dlp.v2.DlpJobType result =
        com.google.privacy.dlp.v2.DlpJobType.forNumber(type_);
    return result == null ? com.google.privacy.dlp.v2.DlpJobType.UNRECOGNIZED : result;
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * State of a job.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DlpJob.JobState state = 3;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * State of a job.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DlpJob.JobState state = 3;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DlpJob.JobState getState() {
    com.google.privacy.dlp.v2.DlpJob.JobState result =
        com.google.privacy.dlp.v2.DlpJob.JobState.forNumber(state_);
    return result == null ? com.google.privacy.dlp.v2.DlpJob.JobState.UNRECOGNIZED : result;
  }

  public static final int RISK_DETAILS_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Results from analyzing risk of a data source.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails risk_details = 4;</code>
   *
   * @return Whether the riskDetails field is set.
   */
  @java.lang.Override
  public boolean hasRiskDetails() {
    return detailsCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Results from analyzing risk of a data source.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails risk_details = 4;</code>
   *
   * @return The riskDetails.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails getRiskDetails() {
    if (detailsCase_ == 4) {
      return (com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails) details_;
    }
    return com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Results from analyzing risk of a data source.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails risk_details = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetailsOrBuilder getRiskDetailsOrBuilder() {
    if (detailsCase_ == 4) {
      return (com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails) details_;
    }
    return com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.getDefaultInstance();
  }

  public static final int INSPECT_DETAILS_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Results from inspecting a data source.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectDataSourceDetails inspect_details = 5;</code>
   *
   * @return Whether the inspectDetails field is set.
   */
  @java.lang.Override
  public boolean hasInspectDetails() {
    return detailsCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Results from inspecting a data source.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectDataSourceDetails inspect_details = 5;</code>
   *
   * @return The inspectDetails.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectDataSourceDetails getInspectDetails() {
    if (detailsCase_ == 5) {
      return (com.google.privacy.dlp.v2.InspectDataSourceDetails) details_;
    }
    return com.google.privacy.dlp.v2.InspectDataSourceDetails.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Results from inspecting a data source.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectDataSourceDetails inspect_details = 5;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectDataSourceDetailsOrBuilder getInspectDetailsOrBuilder() {
    if (detailsCase_ == 5) {
      return (com.google.privacy.dlp.v2.InspectDataSourceDetails) details_;
    }
    return com.google.privacy.dlp.v2.InspectDataSourceDetails.getDefaultInstance();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Time when the job was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Time when the job was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Time when the job was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int START_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Time when the job started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Time when the job started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Time when the job started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Time when the job finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Time when the job finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Time when the job finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int LAST_MODIFIED_FIELD_NUMBER = 15;
  private com.google.protobuf.Timestamp lastModified_;
  /**
   *
   *
   * <pre>
   * Time when the job was last modified by the system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_modified = 15;</code>
   *
   * @return Whether the lastModified field is set.
   */
  @java.lang.Override
  public boolean hasLastModified() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Time when the job was last modified by the system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_modified = 15;</code>
   *
   * @return The lastModified.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastModified() {
    return lastModified_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastModified_;
  }
  /**
   *
   *
   * <pre>
   * Time when the job was last modified by the system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_modified = 15;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastModifiedOrBuilder() {
    return lastModified_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastModified_;
  }

  public static final int JOB_TRIGGER_NAME_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object jobTriggerName_ = "";
  /**
   *
   *
   * <pre>
   * If created by a job trigger, the resource name of the trigger that
   * instantiated the job.
   * </pre>
   *
   * <code>string job_trigger_name = 10;</code>
   *
   * @return The jobTriggerName.
   */
  @java.lang.Override
  public java.lang.String getJobTriggerName() {
    java.lang.Object ref = jobTriggerName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      jobTriggerName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If created by a job trigger, the resource name of the trigger that
   * instantiated the job.
   * </pre>
   *
   * <code>string job_trigger_name = 10;</code>
   *
   * @return The bytes for jobTriggerName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getJobTriggerNameBytes() {
    java.lang.Object ref = jobTriggerName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      jobTriggerName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERRORS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.Error> errors_;
  /**
   *
   *
   * <pre>
   * A stream of errors encountered running the job.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.Error> getErrorsList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * A stream of errors encountered running the job.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.ErrorOrBuilder>
      getErrorsOrBuilderList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * A stream of errors encountered running the job.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
   */
  @java.lang.Override
  public int getErrorsCount() {
    return errors_.size();
  }
  /**
   *
   *
   * <pre>
   * A stream of errors encountered running the job.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Error getErrors(int index) {
    return errors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A stream of errors encountered running the job.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ErrorOrBuilder getErrorsOrBuilder(int index) {
    return errors_.get(index);
  }

  public static final int ACTION_DETAILS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.ActionDetails> actionDetails_;
  /**
   *
   *
   * <pre>
   * Events that should occur after the job has completed.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.ActionDetails> getActionDetailsList() {
    return actionDetails_;
  }
  /**
   *
   *
   * <pre>
   * Events that should occur after the job has completed.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.ActionDetailsOrBuilder>
      getActionDetailsOrBuilderList() {
    return actionDetails_;
  }
  /**
   *
   *
   * <pre>
   * Events that should occur after the job has completed.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
   */
  @java.lang.Override
  public int getActionDetailsCount() {
    return actionDetails_.size();
  }
  /**
   *
   *
   * <pre>
   * Events that should occur after the job has completed.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ActionDetails getActionDetails(int index) {
    return actionDetails_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Events that should occur after the job has completed.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ActionDetailsOrBuilder getActionDetailsOrBuilder(int index) {
    return actionDetails_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (type_ != com.google.privacy.dlp.v2.DlpJobType.DLP_JOB_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, type_);
    }
    if (state_ != com.google.privacy.dlp.v2.DlpJob.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, state_);
    }
    if (detailsCase_ == 4) {
      output.writeMessage(4, (com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails) details_);
    }
    if (detailsCase_ == 5) {
      output.writeMessage(5, (com.google.privacy.dlp.v2.InspectDataSourceDetails) details_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getStartTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobTriggerName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, jobTriggerName_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      output.writeMessage(11, errors_.get(i));
    }
    for (int i = 0; i < actionDetails_.size(); i++) {
      output.writeMessage(12, actionDetails_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(15, getLastModified());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (type_ != com.google.privacy.dlp.v2.DlpJobType.DLP_JOB_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
    }
    if (state_ != com.google.privacy.dlp.v2.DlpJob.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    if (detailsCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails) details_);
    }
    if (detailsCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.privacy.dlp.v2.InspectDataSourceDetails) details_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getStartTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobTriggerName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, jobTriggerName_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, errors_.get(i));
    }
    for (int i = 0; i < actionDetails_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, actionDetails_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getLastModified());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.DlpJob)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.DlpJob other = (com.google.privacy.dlp.v2.DlpJob) obj;

    if (!getName().equals(other.getName())) return false;
    if (type_ != other.type_) return false;
    if (state_ != other.state_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasLastModified() != other.hasLastModified()) return false;
    if (hasLastModified()) {
      if (!getLastModified().equals(other.getLastModified())) return false;
    }
    if (!getJobTriggerName().equals(other.getJobTriggerName())) return false;
    if (!getErrorsList().equals(other.getErrorsList())) return false;
    if (!getActionDetailsList().equals(other.getActionDetailsList())) return false;
    if (!getDetailsCase().equals(other.getDetailsCase())) return false;
    switch (detailsCase_) {
      case 4:
        if (!getRiskDetails().equals(other.getRiskDetails())) return false;
        break;
      case 5:
        if (!getInspectDetails().equals(other.getInspectDetails())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasLastModified()) {
      hash = (37 * hash) + LAST_MODIFIED_FIELD_NUMBER;
      hash = (53 * hash) + getLastModified().hashCode();
    }
    hash = (37 * hash) + JOB_TRIGGER_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getJobTriggerName().hashCode();
    if (getErrorsCount() > 0) {
      hash = (37 * hash) + ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorsList().hashCode();
    }
    if (getActionDetailsCount() > 0) {
      hash = (37 * hash) + ACTION_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getActionDetailsList().hashCode();
    }
    switch (detailsCase_) {
      case 4:
        hash = (37 * hash) + RISK_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getRiskDetails().hashCode();
        break;
      case 5:
        hash = (37 * hash) + INSPECT_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getInspectDetails().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.DlpJob parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DlpJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DlpJob parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DlpJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DlpJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DlpJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DlpJob parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DlpJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DlpJob parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DlpJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DlpJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DlpJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.DlpJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Combines all of the information about a DLP job.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DlpJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DlpJob)
      com.google.privacy.dlp.v2.DlpJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DlpJob_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DlpJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DlpJob.class,
              com.google.privacy.dlp.v2.DlpJob.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.DlpJob.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getLastModifiedFieldBuilder();
        getErrorsFieldBuilder();
        getActionDetailsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      type_ = 0;
      state_ = 0;
      if (riskDetailsBuilder_ != null) {
        riskDetailsBuilder_.clear();
      }
      if (inspectDetailsBuilder_ != null) {
        inspectDetailsBuilder_.clear();
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      lastModified_ = null;
      if (lastModifiedBuilder_ != null) {
        lastModifiedBuilder_.dispose();
        lastModifiedBuilder_ = null;
      }
      jobTriggerName_ = "";
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
      } else {
        errors_ = null;
        errorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      if (actionDetailsBuilder_ == null) {
        actionDetails_ = java.util.Collections.emptyList();
      } else {
        actionDetails_ = null;
        actionDetailsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      detailsCase_ = 0;
      details_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DlpJob_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DlpJob getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.DlpJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DlpJob build() {
      com.google.privacy.dlp.v2.DlpJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DlpJob buildPartial() {
      com.google.privacy.dlp.v2.DlpJob result = new com.google.privacy.dlp.v2.DlpJob(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.privacy.dlp.v2.DlpJob result) {
      if (errorsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          errors_ = java.util.Collections.unmodifiableList(errors_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.errors_ = errors_;
      } else {
        result.errors_ = errorsBuilder_.build();
      }
      if (actionDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          actionDetails_ = java.util.Collections.unmodifiableList(actionDetails_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.actionDetails_ = actionDetails_;
      } else {
        result.actionDetails_ = actionDetailsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.privacy.dlp.v2.DlpJob result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.state_ = state_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.lastModified_ =
            lastModifiedBuilder_ == null ? lastModified_ : lastModifiedBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.jobTriggerName_ = jobTriggerName_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.DlpJob result) {
      result.detailsCase_ = detailsCase_;
      result.details_ = this.details_;
      if (detailsCase_ == 4 && riskDetailsBuilder_ != null) {
        result.details_ = riskDetailsBuilder_.build();
      }
      if (detailsCase_ == 5 && inspectDetailsBuilder_ != null) {
        result.details_ = inspectDetailsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.DlpJob) {
        return mergeFrom((com.google.privacy.dlp.v2.DlpJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.DlpJob other) {
      if (other == com.google.privacy.dlp.v2.DlpJob.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasLastModified()) {
        mergeLastModified(other.getLastModified());
      }
      if (!other.getJobTriggerName().isEmpty()) {
        jobTriggerName_ = other.jobTriggerName_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (errorsBuilder_ == null) {
        if (!other.errors_.isEmpty()) {
          if (errors_.isEmpty()) {
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureErrorsIsMutable();
            errors_.addAll(other.errors_);
          }
          onChanged();
        }
      } else {
        if (!other.errors_.isEmpty()) {
          if (errorsBuilder_.isEmpty()) {
            errorsBuilder_.dispose();
            errorsBuilder_ = null;
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000400);
            errorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorsFieldBuilder()
                    : null;
          } else {
            errorsBuilder_.addAllMessages(other.errors_);
          }
        }
      }
      if (actionDetailsBuilder_ == null) {
        if (!other.actionDetails_.isEmpty()) {
          if (actionDetails_.isEmpty()) {
            actionDetails_ = other.actionDetails_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureActionDetailsIsMutable();
            actionDetails_.addAll(other.actionDetails_);
          }
          onChanged();
        }
      } else {
        if (!other.actionDetails_.isEmpty()) {
          if (actionDetailsBuilder_.isEmpty()) {
            actionDetailsBuilder_.dispose();
            actionDetailsBuilder_ = null;
            actionDetails_ = other.actionDetails_;
            bitField0_ = (bitField0_ & ~0x00000800);
            actionDetailsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getActionDetailsFieldBuilder()
                    : null;
          } else {
            actionDetailsBuilder_.addAllMessages(other.actionDetails_);
          }
        }
      }
      switch (other.getDetailsCase()) {
        case RISK_DETAILS:
          {
            mergeRiskDetails(other.getRiskDetails());
            break;
          }
        case INSPECT_DETAILS:
          {
            mergeInspectDetails(other.getInspectDetails());
            break;
          }
        case DETAILS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getRiskDetailsFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getInspectDetailsFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 82:
              {
                jobTriggerName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                com.google.privacy.dlp.v2.Error m =
                    input.readMessage(com.google.privacy.dlp.v2.Error.parser(), extensionRegistry);
                if (errorsBuilder_ == null) {
                  ensureErrorsIsMutable();
                  errors_.add(m);
                } else {
                  errorsBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 98:
              {
                com.google.privacy.dlp.v2.ActionDetails m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.ActionDetails.parser(), extensionRegistry);
                if (actionDetailsBuilder_ == null) {
                  ensureActionDetailsIsMutable();
                  actionDetails_.add(m);
                } else {
                  actionDetailsBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 122:
              {
                input.readMessage(getLastModifiedFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int detailsCase_ = 0;
    private java.lang.Object details_;

    public DetailsCase getDetailsCase() {
      return DetailsCase.forNumber(detailsCase_);
    }

    public Builder clearDetails() {
      detailsCase_ = 0;
      details_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The server-assigned name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The server-assigned name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The server-assigned name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The server-assigned name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The server-assigned name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The type of job.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DlpJobType type = 2;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The type of job.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DlpJobType type = 2;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of job.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DlpJobType type = 2;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DlpJobType getType() {
      com.google.privacy.dlp.v2.DlpJobType result =
          com.google.privacy.dlp.v2.DlpJobType.forNumber(type_);
      return result == null ? com.google.privacy.dlp.v2.DlpJobType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The type of job.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DlpJobType type = 2;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.privacy.dlp.v2.DlpJobType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of job.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DlpJobType type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      type_ = 0;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * State of a job.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DlpJob.JobState state = 3;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * State of a job.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DlpJob.JobState state = 3;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of a job.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DlpJob.JobState state = 3;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DlpJob.JobState getState() {
      com.google.privacy.dlp.v2.DlpJob.JobState result =
          com.google.privacy.dlp.v2.DlpJob.JobState.forNumber(state_);
      return result == null ? com.google.privacy.dlp.v2.DlpJob.JobState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * State of a job.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DlpJob.JobState state = 3;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.privacy.dlp.v2.DlpJob.JobState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of a job.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DlpJob.JobState state = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails,
            com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.Builder,
            com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetailsOrBuilder>
        riskDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Results from analyzing risk of a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails risk_details = 4;</code>
     *
     * @return Whether the riskDetails field is set.
     */
    @java.lang.Override
    public boolean hasRiskDetails() {
      return detailsCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Results from analyzing risk of a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails risk_details = 4;</code>
     *
     * @return The riskDetails.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails getRiskDetails() {
      if (riskDetailsBuilder_ == null) {
        if (detailsCase_ == 4) {
          return (com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails) details_;
        }
        return com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.getDefaultInstance();
      } else {
        if (detailsCase_ == 4) {
          return riskDetailsBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Results from analyzing risk of a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails risk_details = 4;</code>
     */
    public Builder setRiskDetails(com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails value) {
      if (riskDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        riskDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results from analyzing risk of a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails risk_details = 4;</code>
     */
    public Builder setRiskDetails(
        com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.Builder builderForValue) {
      if (riskDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        riskDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results from analyzing risk of a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails risk_details = 4;</code>
     */
    public Builder mergeRiskDetails(com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails value) {
      if (riskDetailsBuilder_ == null) {
        if (detailsCase_ == 4
            && details_
                != com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.getDefaultInstance()) {
          details_ =
              com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.newBuilder(
                      (com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 4) {
          riskDetailsBuilder_.mergeFrom(value);
        } else {
          riskDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results from analyzing risk of a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails risk_details = 4;</code>
     */
    public Builder clearRiskDetails() {
      if (riskDetailsBuilder_ == null) {
        if (detailsCase_ == 4) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 4) {
          detailsCase_ = 0;
          details_ = null;
        }
        riskDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results from analyzing risk of a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails risk_details = 4;</code>
     */
    public com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.Builder getRiskDetailsBuilder() {
      return getRiskDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Results from analyzing risk of a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails risk_details = 4;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetailsOrBuilder
        getRiskDetailsOrBuilder() {
      if ((detailsCase_ == 4) && (riskDetailsBuilder_ != null)) {
        return riskDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 4) {
          return (com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails) details_;
        }
        return com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Results from analyzing risk of a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails risk_details = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails,
            com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.Builder,
            com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetailsOrBuilder>
        getRiskDetailsFieldBuilder() {
      if (riskDetailsBuilder_ == null) {
        if (!(detailsCase_ == 4)) {
          details_ = com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.getDefaultInstance();
        }
        riskDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails,
                com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.Builder,
                com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetailsOrBuilder>(
                (com.google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 4;
      onChanged();
      return riskDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectDataSourceDetails,
            com.google.privacy.dlp.v2.InspectDataSourceDetails.Builder,
            com.google.privacy.dlp.v2.InspectDataSourceDetailsOrBuilder>
        inspectDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Results from inspecting a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectDataSourceDetails inspect_details = 5;</code>
     *
     * @return Whether the inspectDetails field is set.
     */
    @java.lang.Override
    public boolean hasInspectDetails() {
      return detailsCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Results from inspecting a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectDataSourceDetails inspect_details = 5;</code>
     *
     * @return The inspectDetails.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectDataSourceDetails getInspectDetails() {
      if (inspectDetailsBuilder_ == null) {
        if (detailsCase_ == 5) {
          return (com.google.privacy.dlp.v2.InspectDataSourceDetails) details_;
        }
        return com.google.privacy.dlp.v2.InspectDataSourceDetails.getDefaultInstance();
      } else {
        if (detailsCase_ == 5) {
          return inspectDetailsBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.InspectDataSourceDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Results from inspecting a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectDataSourceDetails inspect_details = 5;</code>
     */
    public Builder setInspectDetails(com.google.privacy.dlp.v2.InspectDataSourceDetails value) {
      if (inspectDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        inspectDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results from inspecting a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectDataSourceDetails inspect_details = 5;</code>
     */
    public Builder setInspectDetails(
        com.google.privacy.dlp.v2.InspectDataSourceDetails.Builder builderForValue) {
      if (inspectDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        inspectDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results from inspecting a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectDataSourceDetails inspect_details = 5;</code>
     */
    public Builder mergeInspectDetails(com.google.privacy.dlp.v2.InspectDataSourceDetails value) {
      if (inspectDetailsBuilder_ == null) {
        if (detailsCase_ == 5
            && details_
                != com.google.privacy.dlp.v2.InspectDataSourceDetails.getDefaultInstance()) {
          details_ =
              com.google.privacy.dlp.v2.InspectDataSourceDetails.newBuilder(
                      (com.google.privacy.dlp.v2.InspectDataSourceDetails) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 5) {
          inspectDetailsBuilder_.mergeFrom(value);
        } else {
          inspectDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results from inspecting a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectDataSourceDetails inspect_details = 5;</code>
     */
    public Builder clearInspectDetails() {
      if (inspectDetailsBuilder_ == null) {
        if (detailsCase_ == 5) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 5) {
          detailsCase_ = 0;
          details_ = null;
        }
        inspectDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results from inspecting a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectDataSourceDetails inspect_details = 5;</code>
     */
    public com.google.privacy.dlp.v2.InspectDataSourceDetails.Builder getInspectDetailsBuilder() {
      return getInspectDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Results from inspecting a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectDataSourceDetails inspect_details = 5;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectDataSourceDetailsOrBuilder
        getInspectDetailsOrBuilder() {
      if ((detailsCase_ == 5) && (inspectDetailsBuilder_ != null)) {
        return inspectDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 5) {
          return (com.google.privacy.dlp.v2.InspectDataSourceDetails) details_;
        }
        return com.google.privacy.dlp.v2.InspectDataSourceDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Results from inspecting a data source.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectDataSourceDetails inspect_details = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectDataSourceDetails,
            com.google.privacy.dlp.v2.InspectDataSourceDetails.Builder,
            com.google.privacy.dlp.v2.InspectDataSourceDetailsOrBuilder>
        getInspectDetailsFieldBuilder() {
      if (inspectDetailsBuilder_ == null) {
        if (!(detailsCase_ == 5)) {
          details_ = com.google.privacy.dlp.v2.InspectDataSourceDetails.getDefaultInstance();
        }
        inspectDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InspectDataSourceDetails,
                com.google.privacy.dlp.v2.InspectDataSourceDetails.Builder,
                com.google.privacy.dlp.v2.InspectDataSourceDetailsOrBuilder>(
                (com.google.privacy.dlp.v2.InspectDataSourceDetails) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 5;
      onChanged();
      return inspectDetailsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time when the job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the job started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time when the job started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the job started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the job started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the job started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the job started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the job started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the job started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the job started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the job finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time when the job finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the job finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the job finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the job finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the job finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the job finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the job finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the job finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastModified_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastModifiedBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the job was last modified by the system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified = 15;</code>
     *
     * @return Whether the lastModified field is set.
     */
    public boolean hasLastModified() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time when the job was last modified by the system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified = 15;</code>
     *
     * @return The lastModified.
     */
    public com.google.protobuf.Timestamp getLastModified() {
      if (lastModifiedBuilder_ == null) {
        return lastModified_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastModified_;
      } else {
        return lastModifiedBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the job was last modified by the system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified = 15;</code>
     */
    public Builder setLastModified(com.google.protobuf.Timestamp value) {
      if (lastModifiedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastModified_ = value;
      } else {
        lastModifiedBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the job was last modified by the system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified = 15;</code>
     */
    public Builder setLastModified(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastModifiedBuilder_ == null) {
        lastModified_ = builderForValue.build();
      } else {
        lastModifiedBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the job was last modified by the system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified = 15;</code>
     */
    public Builder mergeLastModified(com.google.protobuf.Timestamp value) {
      if (lastModifiedBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && lastModified_ != null
            && lastModified_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastModifiedBuilder().mergeFrom(value);
        } else {
          lastModified_ = value;
        }
      } else {
        lastModifiedBuilder_.mergeFrom(value);
      }
      if (lastModified_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the job was last modified by the system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified = 15;</code>
     */
    public Builder clearLastModified() {
      bitField0_ = (bitField0_ & ~0x00000100);
      lastModified_ = null;
      if (lastModifiedBuilder_ != null) {
        lastModifiedBuilder_.dispose();
        lastModifiedBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the job was last modified by the system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified = 15;</code>
     */
    public com.google.protobuf.Timestamp.Builder getLastModifiedBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getLastModifiedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the job was last modified by the system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified = 15;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastModifiedOrBuilder() {
      if (lastModifiedBuilder_ != null) {
        return lastModifiedBuilder_.getMessageOrBuilder();
      } else {
        return lastModified_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastModified_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the job was last modified by the system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastModifiedFieldBuilder() {
      if (lastModifiedBuilder_ == null) {
        lastModifiedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastModified(), getParentForChildren(), isClean());
        lastModified_ = null;
      }
      return lastModifiedBuilder_;
    }

    private java.lang.Object jobTriggerName_ = "";
    /**
     *
     *
     * <pre>
     * If created by a job trigger, the resource name of the trigger that
     * instantiated the job.
     * </pre>
     *
     * <code>string job_trigger_name = 10;</code>
     *
     * @return The jobTriggerName.
     */
    public java.lang.String getJobTriggerName() {
      java.lang.Object ref = jobTriggerName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobTriggerName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If created by a job trigger, the resource name of the trigger that
     * instantiated the job.
     * </pre>
     *
     * <code>string job_trigger_name = 10;</code>
     *
     * @return The bytes for jobTriggerName.
     */
    public com.google.protobuf.ByteString getJobTriggerNameBytes() {
      java.lang.Object ref = jobTriggerName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobTriggerName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If created by a job trigger, the resource name of the trigger that
     * instantiated the job.
     * </pre>
     *
     * <code>string job_trigger_name = 10;</code>
     *
     * @param value The jobTriggerName to set.
     * @return This builder for chaining.
     */
    public Builder setJobTriggerName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      jobTriggerName_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If created by a job trigger, the resource name of the trigger that
     * instantiated the job.
     * </pre>
     *
     * <code>string job_trigger_name = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobTriggerName() {
      jobTriggerName_ = getDefaultInstance().getJobTriggerName();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If created by a job trigger, the resource name of the trigger that
     * instantiated the job.
     * </pre>
     *
     * <code>string job_trigger_name = 10;</code>
     *
     * @param value The bytes for jobTriggerName to set.
     * @return This builder for chaining.
     */
    public Builder setJobTriggerNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      jobTriggerName_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.util.List<com.google.privacy.dlp.v2.Error> errors_ =
        java.util.Collections.emptyList();

    private void ensureErrorsIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        errors_ = new java.util.ArrayList<com.google.privacy.dlp.v2.Error>(errors_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.Error,
            com.google.privacy.dlp.v2.Error.Builder,
            com.google.privacy.dlp.v2.ErrorOrBuilder>
        errorsBuilder_;

    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.Error> getErrorsList() {
      if (errorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errors_);
      } else {
        return errorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public int getErrorsCount() {
      if (errorsBuilder_ == null) {
        return errors_.size();
      } else {
        return errorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public com.google.privacy.dlp.v2.Error getErrors(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public Builder setErrors(int index, com.google.privacy.dlp.v2.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.set(index, value);
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public Builder setErrors(int index, com.google.privacy.dlp.v2.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public Builder addErrors(com.google.privacy.dlp.v2.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public Builder addErrors(int index, com.google.privacy.dlp.v2.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(index, value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public Builder addErrors(com.google.privacy.dlp.v2.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public Builder addErrors(int index, com.google.privacy.dlp.v2.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public Builder addAllErrors(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.Error> values) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errors_);
        onChanged();
      } else {
        errorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public Builder clearErrors() {
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        errorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public Builder removeErrors(int index) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.remove(index);
        onChanged();
      } else {
        errorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public com.google.privacy.dlp.v2.Error.Builder getErrorsBuilder(int index) {
      return getErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public com.google.privacy.dlp.v2.ErrorOrBuilder getErrorsOrBuilder(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.ErrorOrBuilder>
        getErrorsOrBuilderList() {
      if (errorsBuilder_ != null) {
        return errorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errors_);
      }
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public com.google.privacy.dlp.v2.Error.Builder addErrorsBuilder() {
      return getErrorsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public com.google.privacy.dlp.v2.Error.Builder addErrorsBuilder(int index) {
      return getErrorsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A stream of errors encountered running the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 11;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.Error.Builder> getErrorsBuilderList() {
      return getErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.Error,
            com.google.privacy.dlp.v2.Error.Builder,
            com.google.privacy.dlp.v2.ErrorOrBuilder>
        getErrorsFieldBuilder() {
      if (errorsBuilder_ == null) {
        errorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.Error,
                com.google.privacy.dlp.v2.Error.Builder,
                com.google.privacy.dlp.v2.ErrorOrBuilder>(
                errors_, ((bitField0_ & 0x00000400) != 0), getParentForChildren(), isClean());
        errors_ = null;
      }
      return errorsBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.ActionDetails> actionDetails_ =
        java.util.Collections.emptyList();

    private void ensureActionDetailsIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        actionDetails_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.ActionDetails>(actionDetails_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.ActionDetails,
            com.google.privacy.dlp.v2.ActionDetails.Builder,
            com.google.privacy.dlp.v2.ActionDetailsOrBuilder>
        actionDetailsBuilder_;

    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.ActionDetails> getActionDetailsList() {
      if (actionDetailsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(actionDetails_);
      } else {
        return actionDetailsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public int getActionDetailsCount() {
      if (actionDetailsBuilder_ == null) {
        return actionDetails_.size();
      } else {
        return actionDetailsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public com.google.privacy.dlp.v2.ActionDetails getActionDetails(int index) {
      if (actionDetailsBuilder_ == null) {
        return actionDetails_.get(index);
      } else {
        return actionDetailsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public Builder setActionDetails(int index, com.google.privacy.dlp.v2.ActionDetails value) {
      if (actionDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionDetailsIsMutable();
        actionDetails_.set(index, value);
        onChanged();
      } else {
        actionDetailsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public Builder setActionDetails(
        int index, com.google.privacy.dlp.v2.ActionDetails.Builder builderForValue) {
      if (actionDetailsBuilder_ == null) {
        ensureActionDetailsIsMutable();
        actionDetails_.set(index, builderForValue.build());
        onChanged();
      } else {
        actionDetailsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public Builder addActionDetails(com.google.privacy.dlp.v2.ActionDetails value) {
      if (actionDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionDetailsIsMutable();
        actionDetails_.add(value);
        onChanged();
      } else {
        actionDetailsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public Builder addActionDetails(int index, com.google.privacy.dlp.v2.ActionDetails value) {
      if (actionDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionDetailsIsMutable();
        actionDetails_.add(index, value);
        onChanged();
      } else {
        actionDetailsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public Builder addActionDetails(
        com.google.privacy.dlp.v2.ActionDetails.Builder builderForValue) {
      if (actionDetailsBuilder_ == null) {
        ensureActionDetailsIsMutable();
        actionDetails_.add(builderForValue.build());
        onChanged();
      } else {
        actionDetailsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public Builder addActionDetails(
        int index, com.google.privacy.dlp.v2.ActionDetails.Builder builderForValue) {
      if (actionDetailsBuilder_ == null) {
        ensureActionDetailsIsMutable();
        actionDetails_.add(index, builderForValue.build());
        onChanged();
      } else {
        actionDetailsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public Builder addAllActionDetails(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.ActionDetails> values) {
      if (actionDetailsBuilder_ == null) {
        ensureActionDetailsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, actionDetails_);
        onChanged();
      } else {
        actionDetailsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public Builder clearActionDetails() {
      if (actionDetailsBuilder_ == null) {
        actionDetails_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        actionDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public Builder removeActionDetails(int index) {
      if (actionDetailsBuilder_ == null) {
        ensureActionDetailsIsMutable();
        actionDetails_.remove(index);
        onChanged();
      } else {
        actionDetailsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public com.google.privacy.dlp.v2.ActionDetails.Builder getActionDetailsBuilder(int index) {
      return getActionDetailsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public com.google.privacy.dlp.v2.ActionDetailsOrBuilder getActionDetailsOrBuilder(int index) {
      if (actionDetailsBuilder_ == null) {
        return actionDetails_.get(index);
      } else {
        return actionDetailsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.ActionDetailsOrBuilder>
        getActionDetailsOrBuilderList() {
      if (actionDetailsBuilder_ != null) {
        return actionDetailsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(actionDetails_);
      }
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public com.google.privacy.dlp.v2.ActionDetails.Builder addActionDetailsBuilder() {
      return getActionDetailsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.ActionDetails.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public com.google.privacy.dlp.v2.ActionDetails.Builder addActionDetailsBuilder(int index) {
      return getActionDetailsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.ActionDetails.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Events that should occur after the job has completed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ActionDetails action_details = 12;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.ActionDetails.Builder>
        getActionDetailsBuilderList() {
      return getActionDetailsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.ActionDetails,
            com.google.privacy.dlp.v2.ActionDetails.Builder,
            com.google.privacy.dlp.v2.ActionDetailsOrBuilder>
        getActionDetailsFieldBuilder() {
      if (actionDetailsBuilder_ == null) {
        actionDetailsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.ActionDetails,
                com.google.privacy.dlp.v2.ActionDetails.Builder,
                com.google.privacy.dlp.v2.ActionDetailsOrBuilder>(
                actionDetails_,
                ((bitField0_ & 0x00000800) != 0),
                getParentForChildren(),
                isClean());
        actionDetails_ = null;
      }
      return actionDetailsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DlpJob)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DlpJob)
  private static final com.google.privacy.dlp.v2.DlpJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DlpJob();
  }

  public static com.google.privacy.dlp.v2.DlpJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DlpJob> PARSER =
      new com.google.protobuf.AbstractParser<DlpJob>() {
        @java.lang.Override
        public DlpJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DlpJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DlpJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.DlpJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
