/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * The transformation to apply to the field.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.FieldTransformation}
 */
public final class FieldTransformation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.FieldTransformation)
    FieldTransformationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FieldTransformation.newBuilder() to construct.
  private FieldTransformation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FieldTransformation() {
    fields_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FieldTransformation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_FieldTransformation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_FieldTransformation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.FieldTransformation.class,
            com.google.privacy.dlp.v2.FieldTransformation.Builder.class);
  }

  private int bitField0_;
  private int transformationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object transformation_;

  public enum TransformationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PRIMITIVE_TRANSFORMATION(4),
    INFO_TYPE_TRANSFORMATIONS(5),
    TRANSFORMATION_NOT_SET(0);
    private final int value;

    private TransformationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TransformationCase valueOf(int value) {
      return forNumber(value);
    }

    public static TransformationCase forNumber(int value) {
      switch (value) {
        case 4:
          return PRIMITIVE_TRANSFORMATION;
        case 5:
          return INFO_TYPE_TRANSFORMATIONS;
        case 0:
          return TRANSFORMATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TransformationCase getTransformationCase() {
    return TransformationCase.forNumber(transformationCase_);
  }

  public static final int FIELDS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.FieldId> fields_;
  /**
   *
   *
   * <pre>
   * Required. Input field(s) to apply the transformation to.
   * When you have columns that reference their position within a list,
   * omit the index from the FieldId. FieldId name matching ignores the index.
   * For example, instead of "contact.nums[0].type", use "contact.nums.type".
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.FieldId> getFieldsList() {
    return fields_;
  }
  /**
   *
   *
   * <pre>
   * Required. Input field(s) to apply the transformation to.
   * When you have columns that reference their position within a list,
   * omit the index from the FieldId. FieldId name matching ignores the index.
   * For example, instead of "contact.nums[0].type", use "contact.nums.type".
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.FieldIdOrBuilder>
      getFieldsOrBuilderList() {
    return fields_;
  }
  /**
   *
   *
   * <pre>
   * Required. Input field(s) to apply the transformation to.
   * When you have columns that reference their position within a list,
   * omit the index from the FieldId. FieldId name matching ignores the index.
   * For example, instead of "contact.nums[0].type", use "contact.nums.type".
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getFieldsCount() {
    return fields_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Input field(s) to apply the transformation to.
   * When you have columns that reference their position within a list,
   * omit the index from the FieldId. FieldId name matching ignores the index.
   * For example, instead of "contact.nums[0].type", use "contact.nums.type".
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldId getFields(int index) {
    return fields_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Input field(s) to apply the transformation to.
   * When you have columns that reference their position within a list,
   * omit the index from the FieldId. FieldId name matching ignores the index.
   * For example, instead of "contact.nums[0].type", use "contact.nums.type".
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldIdOrBuilder getFieldsOrBuilder(int index) {
    return fields_.get(index);
  }

  public static final int CONDITION_FIELD_NUMBER = 3;
  private com.google.privacy.dlp.v2.RecordCondition condition_;
  /**
   *
   *
   * <pre>
   * Only apply the transformation if the condition evaluates to true for the
   * given `RecordCondition`. The conditions are allowed to reference fields
   * that are not used in the actual transformation.
   *
   * Example Use Cases:
   *
   * - Apply a different bucket transformation to an age column if the zip code
   * column for the same record is within a specific range.
   * - Redact a field if the date of birth field is greater than 85.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordCondition condition = 3;</code>
   *
   * @return Whether the condition field is set.
   */
  @java.lang.Override
  public boolean hasCondition() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Only apply the transformation if the condition evaluates to true for the
   * given `RecordCondition`. The conditions are allowed to reference fields
   * that are not used in the actual transformation.
   *
   * Example Use Cases:
   *
   * - Apply a different bucket transformation to an age column if the zip code
   * column for the same record is within a specific range.
   * - Redact a field if the date of birth field is greater than 85.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordCondition condition = 3;</code>
   *
   * @return The condition.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RecordCondition getCondition() {
    return condition_ == null
        ? com.google.privacy.dlp.v2.RecordCondition.getDefaultInstance()
        : condition_;
  }
  /**
   *
   *
   * <pre>
   * Only apply the transformation if the condition evaluates to true for the
   * given `RecordCondition`. The conditions are allowed to reference fields
   * that are not used in the actual transformation.
   *
   * Example Use Cases:
   *
   * - Apply a different bucket transformation to an age column if the zip code
   * column for the same record is within a specific range.
   * - Redact a field if the date of birth field is greater than 85.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordCondition condition = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RecordConditionOrBuilder getConditionOrBuilder() {
    return condition_ == null
        ? com.google.privacy.dlp.v2.RecordCondition.getDefaultInstance()
        : condition_;
  }

  public static final int PRIMITIVE_TRANSFORMATION_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Apply the transformation to the entire field.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 4;</code>
   *
   * @return Whether the primitiveTransformation field is set.
   */
  @java.lang.Override
  public boolean hasPrimitiveTransformation() {
    return transformationCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Apply the transformation to the entire field.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 4;</code>
   *
   * @return The primitiveTransformation.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.PrimitiveTransformation getPrimitiveTransformation() {
    if (transformationCase_ == 4) {
      return (com.google.privacy.dlp.v2.PrimitiveTransformation) transformation_;
    }
    return com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Apply the transformation to the entire field.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder
      getPrimitiveTransformationOrBuilder() {
    if (transformationCase_ == 4) {
      return (com.google.privacy.dlp.v2.PrimitiveTransformation) transformation_;
    }
    return com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance();
  }

  public static final int INFO_TYPE_TRANSFORMATIONS_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Treat the contents of the field as free text, and selectively
   * transform content that matches an `InfoType`.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 5;</code>
   *
   * @return Whether the infoTypeTransformations field is set.
   */
  @java.lang.Override
  public boolean hasInfoTypeTransformations() {
    return transformationCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Treat the contents of the field as free text, and selectively
   * transform content that matches an `InfoType`.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 5;</code>
   *
   * @return The infoTypeTransformations.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeTransformations getInfoTypeTransformations() {
    if (transformationCase_ == 5) {
      return (com.google.privacy.dlp.v2.InfoTypeTransformations) transformation_;
    }
    return com.google.privacy.dlp.v2.InfoTypeTransformations.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Treat the contents of the field as free text, and selectively
   * transform content that matches an `InfoType`.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 5;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeTransformationsOrBuilder
      getInfoTypeTransformationsOrBuilder() {
    if (transformationCase_ == 5) {
      return (com.google.privacy.dlp.v2.InfoTypeTransformations) transformation_;
    }
    return com.google.privacy.dlp.v2.InfoTypeTransformations.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < fields_.size(); i++) {
      output.writeMessage(1, fields_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCondition());
    }
    if (transformationCase_ == 4) {
      output.writeMessage(4, (com.google.privacy.dlp.v2.PrimitiveTransformation) transformation_);
    }
    if (transformationCase_ == 5) {
      output.writeMessage(5, (com.google.privacy.dlp.v2.InfoTypeTransformations) transformation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < fields_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, fields_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCondition());
    }
    if (transformationCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.privacy.dlp.v2.PrimitiveTransformation) transformation_);
    }
    if (transformationCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.privacy.dlp.v2.InfoTypeTransformations) transformation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.FieldTransformation)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.FieldTransformation other =
        (com.google.privacy.dlp.v2.FieldTransformation) obj;

    if (!getFieldsList().equals(other.getFieldsList())) return false;
    if (hasCondition() != other.hasCondition()) return false;
    if (hasCondition()) {
      if (!getCondition().equals(other.getCondition())) return false;
    }
    if (!getTransformationCase().equals(other.getTransformationCase())) return false;
    switch (transformationCase_) {
      case 4:
        if (!getPrimitiveTransformation().equals(other.getPrimitiveTransformation())) return false;
        break;
      case 5:
        if (!getInfoTypeTransformations().equals(other.getInfoTypeTransformations())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFieldsCount() > 0) {
      hash = (37 * hash) + FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getFieldsList().hashCode();
    }
    if (hasCondition()) {
      hash = (37 * hash) + CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + getCondition().hashCode();
    }
    switch (transformationCase_) {
      case 4:
        hash = (37 * hash) + PRIMITIVE_TRANSFORMATION_FIELD_NUMBER;
        hash = (53 * hash) + getPrimitiveTransformation().hashCode();
        break;
      case 5:
        hash = (37 * hash) + INFO_TYPE_TRANSFORMATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getInfoTypeTransformations().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.FieldTransformation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.FieldTransformation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.FieldTransformation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.FieldTransformation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.FieldTransformation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.FieldTransformation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.FieldTransformation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.FieldTransformation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.FieldTransformation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.FieldTransformation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.FieldTransformation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.FieldTransformation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.FieldTransformation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The transformation to apply to the field.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.FieldTransformation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.FieldTransformation)
      com.google.privacy.dlp.v2.FieldTransformationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_FieldTransformation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_FieldTransformation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.FieldTransformation.class,
              com.google.privacy.dlp.v2.FieldTransformation.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.FieldTransformation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFieldsFieldBuilder();
        getConditionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (fieldsBuilder_ == null) {
        fields_ = java.util.Collections.emptyList();
      } else {
        fields_ = null;
        fieldsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      condition_ = null;
      if (conditionBuilder_ != null) {
        conditionBuilder_.dispose();
        conditionBuilder_ = null;
      }
      if (primitiveTransformationBuilder_ != null) {
        primitiveTransformationBuilder_.clear();
      }
      if (infoTypeTransformationsBuilder_ != null) {
        infoTypeTransformationsBuilder_.clear();
      }
      transformationCase_ = 0;
      transformation_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_FieldTransformation_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.FieldTransformation getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.FieldTransformation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.FieldTransformation build() {
      com.google.privacy.dlp.v2.FieldTransformation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.FieldTransformation buildPartial() {
      com.google.privacy.dlp.v2.FieldTransformation result =
          new com.google.privacy.dlp.v2.FieldTransformation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.privacy.dlp.v2.FieldTransformation result) {
      if (fieldsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          fields_ = java.util.Collections.unmodifiableList(fields_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.fields_ = fields_;
      } else {
        result.fields_ = fieldsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.privacy.dlp.v2.FieldTransformation result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.condition_ = conditionBuilder_ == null ? condition_ : conditionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.FieldTransformation result) {
      result.transformationCase_ = transformationCase_;
      result.transformation_ = this.transformation_;
      if (transformationCase_ == 4 && primitiveTransformationBuilder_ != null) {
        result.transformation_ = primitiveTransformationBuilder_.build();
      }
      if (transformationCase_ == 5 && infoTypeTransformationsBuilder_ != null) {
        result.transformation_ = infoTypeTransformationsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.FieldTransformation) {
        return mergeFrom((com.google.privacy.dlp.v2.FieldTransformation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.FieldTransformation other) {
      if (other == com.google.privacy.dlp.v2.FieldTransformation.getDefaultInstance()) return this;
      if (fieldsBuilder_ == null) {
        if (!other.fields_.isEmpty()) {
          if (fields_.isEmpty()) {
            fields_ = other.fields_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFieldsIsMutable();
            fields_.addAll(other.fields_);
          }
          onChanged();
        }
      } else {
        if (!other.fields_.isEmpty()) {
          if (fieldsBuilder_.isEmpty()) {
            fieldsBuilder_.dispose();
            fieldsBuilder_ = null;
            fields_ = other.fields_;
            bitField0_ = (bitField0_ & ~0x00000001);
            fieldsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFieldsFieldBuilder()
                    : null;
          } else {
            fieldsBuilder_.addAllMessages(other.fields_);
          }
        }
      }
      if (other.hasCondition()) {
        mergeCondition(other.getCondition());
      }
      switch (other.getTransformationCase()) {
        case PRIMITIVE_TRANSFORMATION:
          {
            mergePrimitiveTransformation(other.getPrimitiveTransformation());
            break;
          }
        case INFO_TYPE_TRANSFORMATIONS:
          {
            mergeInfoTypeTransformations(other.getInfoTypeTransformations());
            break;
          }
        case TRANSFORMATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.privacy.dlp.v2.FieldId m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.FieldId.parser(), extensionRegistry);
                if (fieldsBuilder_ == null) {
                  ensureFieldsIsMutable();
                  fields_.add(m);
                } else {
                  fieldsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getConditionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getPrimitiveTransformationFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getInfoTypeTransformationsFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int transformationCase_ = 0;
    private java.lang.Object transformation_;

    public TransformationCase getTransformationCase() {
      return TransformationCase.forNumber(transformationCase_);
    }

    public Builder clearTransformation() {
      transformationCase_ = 0;
      transformation_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.privacy.dlp.v2.FieldId> fields_ =
        java.util.Collections.emptyList();

    private void ensureFieldsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        fields_ = new java.util.ArrayList<com.google.privacy.dlp.v2.FieldId>(fields_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        fieldsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.privacy.dlp.v2.FieldId> getFieldsList() {
      if (fieldsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fields_);
      } else {
        return fieldsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getFieldsCount() {
      if (fieldsBuilder_ == null) {
        return fields_.size();
      } else {
        return fieldsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.FieldId getFields(int index) {
      if (fieldsBuilder_ == null) {
        return fields_.get(index);
      } else {
        return fieldsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFields(int index, com.google.privacy.dlp.v2.FieldId value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.set(index, value);
        onChanged();
      } else {
        fieldsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFields(int index, com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.set(index, builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addFields(com.google.privacy.dlp.v2.FieldId value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.add(value);
        onChanged();
      } else {
        fieldsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addFields(int index, com.google.privacy.dlp.v2.FieldId value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.add(index, value);
        onChanged();
      } else {
        fieldsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addFields(com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.add(builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addFields(int index, com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.add(index, builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllFields(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.FieldId> values) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fields_);
        onChanged();
      } else {
        fieldsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearFields() {
      if (fieldsBuilder_ == null) {
        fields_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        fieldsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeFields(int index) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.remove(index);
        onChanged();
      } else {
        fieldsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder getFieldsBuilder(int index) {
      return getFieldsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.FieldIdOrBuilder getFieldsOrBuilder(int index) {
      if (fieldsBuilder_ == null) {
        return fields_.get(index);
      } else {
        return fieldsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.FieldIdOrBuilder>
        getFieldsOrBuilderList() {
      if (fieldsBuilder_ != null) {
        return fieldsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fields_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder addFieldsBuilder() {
      return getFieldsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.FieldId.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder addFieldsBuilder(int index) {
      return getFieldsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.FieldId.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Input field(s) to apply the transformation to.
     * When you have columns that reference their position within a list,
     * omit the index from the FieldId. FieldId name matching ignores the index.
     * For example, instead of "contact.nums[0].type", use "contact.nums.type".
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.FieldId fields = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.privacy.dlp.v2.FieldId.Builder> getFieldsBuilderList() {
      return getFieldsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        getFieldsFieldBuilder() {
      if (fieldsBuilder_ == null) {
        fieldsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.FieldId,
                com.google.privacy.dlp.v2.FieldId.Builder,
                com.google.privacy.dlp.v2.FieldIdOrBuilder>(
                fields_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        fields_ = null;
      }
      return fieldsBuilder_;
    }

    private com.google.privacy.dlp.v2.RecordCondition condition_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.RecordCondition,
            com.google.privacy.dlp.v2.RecordCondition.Builder,
            com.google.privacy.dlp.v2.RecordConditionOrBuilder>
        conditionBuilder_;
    /**
     *
     *
     * <pre>
     * Only apply the transformation if the condition evaluates to true for the
     * given `RecordCondition`. The conditions are allowed to reference fields
     * that are not used in the actual transformation.
     *
     * Example Use Cases:
     *
     * - Apply a different bucket transformation to an age column if the zip code
     * column for the same record is within a specific range.
     * - Redact a field if the date of birth field is greater than 85.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition condition = 3;</code>
     *
     * @return Whether the condition field is set.
     */
    public boolean hasCondition() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Only apply the transformation if the condition evaluates to true for the
     * given `RecordCondition`. The conditions are allowed to reference fields
     * that are not used in the actual transformation.
     *
     * Example Use Cases:
     *
     * - Apply a different bucket transformation to an age column if the zip code
     * column for the same record is within a specific range.
     * - Redact a field if the date of birth field is greater than 85.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition condition = 3;</code>
     *
     * @return The condition.
     */
    public com.google.privacy.dlp.v2.RecordCondition getCondition() {
      if (conditionBuilder_ == null) {
        return condition_ == null
            ? com.google.privacy.dlp.v2.RecordCondition.getDefaultInstance()
            : condition_;
      } else {
        return conditionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Only apply the transformation if the condition evaluates to true for the
     * given `RecordCondition`. The conditions are allowed to reference fields
     * that are not used in the actual transformation.
     *
     * Example Use Cases:
     *
     * - Apply a different bucket transformation to an age column if the zip code
     * column for the same record is within a specific range.
     * - Redact a field if the date of birth field is greater than 85.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition condition = 3;</code>
     */
    public Builder setCondition(com.google.privacy.dlp.v2.RecordCondition value) {
      if (conditionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        condition_ = value;
      } else {
        conditionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only apply the transformation if the condition evaluates to true for the
     * given `RecordCondition`. The conditions are allowed to reference fields
     * that are not used in the actual transformation.
     *
     * Example Use Cases:
     *
     * - Apply a different bucket transformation to an age column if the zip code
     * column for the same record is within a specific range.
     * - Redact a field if the date of birth field is greater than 85.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition condition = 3;</code>
     */
    public Builder setCondition(com.google.privacy.dlp.v2.RecordCondition.Builder builderForValue) {
      if (conditionBuilder_ == null) {
        condition_ = builderForValue.build();
      } else {
        conditionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only apply the transformation if the condition evaluates to true for the
     * given `RecordCondition`. The conditions are allowed to reference fields
     * that are not used in the actual transformation.
     *
     * Example Use Cases:
     *
     * - Apply a different bucket transformation to an age column if the zip code
     * column for the same record is within a specific range.
     * - Redact a field if the date of birth field is greater than 85.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition condition = 3;</code>
     */
    public Builder mergeCondition(com.google.privacy.dlp.v2.RecordCondition value) {
      if (conditionBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && condition_ != null
            && condition_ != com.google.privacy.dlp.v2.RecordCondition.getDefaultInstance()) {
          getConditionBuilder().mergeFrom(value);
        } else {
          condition_ = value;
        }
      } else {
        conditionBuilder_.mergeFrom(value);
      }
      if (condition_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only apply the transformation if the condition evaluates to true for the
     * given `RecordCondition`. The conditions are allowed to reference fields
     * that are not used in the actual transformation.
     *
     * Example Use Cases:
     *
     * - Apply a different bucket transformation to an age column if the zip code
     * column for the same record is within a specific range.
     * - Redact a field if the date of birth field is greater than 85.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition condition = 3;</code>
     */
    public Builder clearCondition() {
      bitField0_ = (bitField0_ & ~0x00000002);
      condition_ = null;
      if (conditionBuilder_ != null) {
        conditionBuilder_.dispose();
        conditionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only apply the transformation if the condition evaluates to true for the
     * given `RecordCondition`. The conditions are allowed to reference fields
     * that are not used in the actual transformation.
     *
     * Example Use Cases:
     *
     * - Apply a different bucket transformation to an age column if the zip code
     * column for the same record is within a specific range.
     * - Redact a field if the date of birth field is greater than 85.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition condition = 3;</code>
     */
    public com.google.privacy.dlp.v2.RecordCondition.Builder getConditionBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getConditionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Only apply the transformation if the condition evaluates to true for the
     * given `RecordCondition`. The conditions are allowed to reference fields
     * that are not used in the actual transformation.
     *
     * Example Use Cases:
     *
     * - Apply a different bucket transformation to an age column if the zip code
     * column for the same record is within a specific range.
     * - Redact a field if the date of birth field is greater than 85.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition condition = 3;</code>
     */
    public com.google.privacy.dlp.v2.RecordConditionOrBuilder getConditionOrBuilder() {
      if (conditionBuilder_ != null) {
        return conditionBuilder_.getMessageOrBuilder();
      } else {
        return condition_ == null
            ? com.google.privacy.dlp.v2.RecordCondition.getDefaultInstance()
            : condition_;
      }
    }
    /**
     *
     *
     * <pre>
     * Only apply the transformation if the condition evaluates to true for the
     * given `RecordCondition`. The conditions are allowed to reference fields
     * that are not used in the actual transformation.
     *
     * Example Use Cases:
     *
     * - Apply a different bucket transformation to an age column if the zip code
     * column for the same record is within a specific range.
     * - Redact a field if the date of birth field is greater than 85.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition condition = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.RecordCondition,
            com.google.privacy.dlp.v2.RecordCondition.Builder,
            com.google.privacy.dlp.v2.RecordConditionOrBuilder>
        getConditionFieldBuilder() {
      if (conditionBuilder_ == null) {
        conditionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.RecordCondition,
                com.google.privacy.dlp.v2.RecordCondition.Builder,
                com.google.privacy.dlp.v2.RecordConditionOrBuilder>(
                getCondition(), getParentForChildren(), isClean());
        condition_ = null;
      }
      return conditionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.PrimitiveTransformation,
            com.google.privacy.dlp.v2.PrimitiveTransformation.Builder,
            com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder>
        primitiveTransformationBuilder_;
    /**
     *
     *
     * <pre>
     * Apply the transformation to the entire field.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 4;</code>
     *
     * @return Whether the primitiveTransformation field is set.
     */
    @java.lang.Override
    public boolean hasPrimitiveTransformation() {
      return transformationCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Apply the transformation to the entire field.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 4;</code>
     *
     * @return The primitiveTransformation.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.PrimitiveTransformation getPrimitiveTransformation() {
      if (primitiveTransformationBuilder_ == null) {
        if (transformationCase_ == 4) {
          return (com.google.privacy.dlp.v2.PrimitiveTransformation) transformation_;
        }
        return com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance();
      } else {
        if (transformationCase_ == 4) {
          return primitiveTransformationBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Apply the transformation to the entire field.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 4;</code>
     */
    public Builder setPrimitiveTransformation(
        com.google.privacy.dlp.v2.PrimitiveTransformation value) {
      if (primitiveTransformationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        primitiveTransformationBuilder_.setMessage(value);
      }
      transformationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Apply the transformation to the entire field.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 4;</code>
     */
    public Builder setPrimitiveTransformation(
        com.google.privacy.dlp.v2.PrimitiveTransformation.Builder builderForValue) {
      if (primitiveTransformationBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        primitiveTransformationBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Apply the transformation to the entire field.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 4;</code>
     */
    public Builder mergePrimitiveTransformation(
        com.google.privacy.dlp.v2.PrimitiveTransformation value) {
      if (primitiveTransformationBuilder_ == null) {
        if (transformationCase_ == 4
            && transformation_
                != com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.PrimitiveTransformation.newBuilder(
                      (com.google.privacy.dlp.v2.PrimitiveTransformation) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 4) {
          primitiveTransformationBuilder_.mergeFrom(value);
        } else {
          primitiveTransformationBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Apply the transformation to the entire field.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 4;</code>
     */
    public Builder clearPrimitiveTransformation() {
      if (primitiveTransformationBuilder_ == null) {
        if (transformationCase_ == 4) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 4) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        primitiveTransformationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Apply the transformation to the entire field.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 4;</code>
     */
    public com.google.privacy.dlp.v2.PrimitiveTransformation.Builder
        getPrimitiveTransformationBuilder() {
      return getPrimitiveTransformationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Apply the transformation to the entire field.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 4;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder
        getPrimitiveTransformationOrBuilder() {
      if ((transformationCase_ == 4) && (primitiveTransformationBuilder_ != null)) {
        return primitiveTransformationBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 4) {
          return (com.google.privacy.dlp.v2.PrimitiveTransformation) transformation_;
        }
        return com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Apply the transformation to the entire field.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.PrimitiveTransformation,
            com.google.privacy.dlp.v2.PrimitiveTransformation.Builder,
            com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder>
        getPrimitiveTransformationFieldBuilder() {
      if (primitiveTransformationBuilder_ == null) {
        if (!(transformationCase_ == 4)) {
          transformation_ = com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance();
        }
        primitiveTransformationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.PrimitiveTransformation,
                com.google.privacy.dlp.v2.PrimitiveTransformation.Builder,
                com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder>(
                (com.google.privacy.dlp.v2.PrimitiveTransformation) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 4;
      onChanged();
      return primitiveTransformationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoTypeTransformations,
            com.google.privacy.dlp.v2.InfoTypeTransformations.Builder,
            com.google.privacy.dlp.v2.InfoTypeTransformationsOrBuilder>
        infoTypeTransformationsBuilder_;
    /**
     *
     *
     * <pre>
     * Treat the contents of the field as free text, and selectively
     * transform content that matches an `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 5;</code>
     *
     * @return Whether the infoTypeTransformations field is set.
     */
    @java.lang.Override
    public boolean hasInfoTypeTransformations() {
      return transformationCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Treat the contents of the field as free text, and selectively
     * transform content that matches an `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 5;</code>
     *
     * @return The infoTypeTransformations.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeTransformations getInfoTypeTransformations() {
      if (infoTypeTransformationsBuilder_ == null) {
        if (transformationCase_ == 5) {
          return (com.google.privacy.dlp.v2.InfoTypeTransformations) transformation_;
        }
        return com.google.privacy.dlp.v2.InfoTypeTransformations.getDefaultInstance();
      } else {
        if (transformationCase_ == 5) {
          return infoTypeTransformationsBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.InfoTypeTransformations.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Treat the contents of the field as free text, and selectively
     * transform content that matches an `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 5;</code>
     */
    public Builder setInfoTypeTransformations(
        com.google.privacy.dlp.v2.InfoTypeTransformations value) {
      if (infoTypeTransformationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        infoTypeTransformationsBuilder_.setMessage(value);
      }
      transformationCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treat the contents of the field as free text, and selectively
     * transform content that matches an `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 5;</code>
     */
    public Builder setInfoTypeTransformations(
        com.google.privacy.dlp.v2.InfoTypeTransformations.Builder builderForValue) {
      if (infoTypeTransformationsBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        infoTypeTransformationsBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treat the contents of the field as free text, and selectively
     * transform content that matches an `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 5;</code>
     */
    public Builder mergeInfoTypeTransformations(
        com.google.privacy.dlp.v2.InfoTypeTransformations value) {
      if (infoTypeTransformationsBuilder_ == null) {
        if (transformationCase_ == 5
            && transformation_
                != com.google.privacy.dlp.v2.InfoTypeTransformations.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.InfoTypeTransformations.newBuilder(
                      (com.google.privacy.dlp.v2.InfoTypeTransformations) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 5) {
          infoTypeTransformationsBuilder_.mergeFrom(value);
        } else {
          infoTypeTransformationsBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treat the contents of the field as free text, and selectively
     * transform content that matches an `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 5;</code>
     */
    public Builder clearInfoTypeTransformations() {
      if (infoTypeTransformationsBuilder_ == null) {
        if (transformationCase_ == 5) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 5) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        infoTypeTransformationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treat the contents of the field as free text, and selectively
     * transform content that matches an `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 5;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeTransformations.Builder
        getInfoTypeTransformationsBuilder() {
      return getInfoTypeTransformationsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Treat the contents of the field as free text, and selectively
     * transform content that matches an `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 5;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeTransformationsOrBuilder
        getInfoTypeTransformationsOrBuilder() {
      if ((transformationCase_ == 5) && (infoTypeTransformationsBuilder_ != null)) {
        return infoTypeTransformationsBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 5) {
          return (com.google.privacy.dlp.v2.InfoTypeTransformations) transformation_;
        }
        return com.google.privacy.dlp.v2.InfoTypeTransformations.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Treat the contents of the field as free text, and selectively
     * transform content that matches an `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoTypeTransformations,
            com.google.privacy.dlp.v2.InfoTypeTransformations.Builder,
            com.google.privacy.dlp.v2.InfoTypeTransformationsOrBuilder>
        getInfoTypeTransformationsFieldBuilder() {
      if (infoTypeTransformationsBuilder_ == null) {
        if (!(transformationCase_ == 5)) {
          transformation_ = com.google.privacy.dlp.v2.InfoTypeTransformations.getDefaultInstance();
        }
        infoTypeTransformationsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InfoTypeTransformations,
                com.google.privacy.dlp.v2.InfoTypeTransformations.Builder,
                com.google.privacy.dlp.v2.InfoTypeTransformationsOrBuilder>(
                (com.google.privacy.dlp.v2.InfoTypeTransformations) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 5;
      onChanged();
      return infoTypeTransformationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.FieldTransformation)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.FieldTransformation)
  private static final com.google.privacy.dlp.v2.FieldTransformation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.FieldTransformation();
  }

  public static com.google.privacy.dlp.v2.FieldTransformation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FieldTransformation> PARSER =
      new com.google.protobuf.AbstractParser<FieldTransformation>() {
        @java.lang.Override
        public FieldTransformation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FieldTransformation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FieldTransformation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldTransformation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
