/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Populate to associate additional data with each finding.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.HybridFindingDetails}
 */
public final class HybridFindingDetails extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.HybridFindingDetails)
    HybridFindingDetailsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HybridFindingDetails.newBuilder() to construct.
  private HybridFindingDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HybridFindingDetails() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HybridFindingDetails();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_HybridFindingDetails_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_HybridFindingDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.HybridFindingDetails.class,
            com.google.privacy.dlp.v2.HybridFindingDetails.Builder.class);
  }

  private int bitField0_;
  public static final int CONTAINER_DETAILS_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.Container containerDetails_;
  /**
   *
   *
   * <pre>
   * Details about the container where the content being inspected is from.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Container container_details = 1;</code>
   *
   * @return Whether the containerDetails field is set.
   */
  @java.lang.Override
  public boolean hasContainerDetails() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Details about the container where the content being inspected is from.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Container container_details = 1;</code>
   *
   * @return The containerDetails.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Container getContainerDetails() {
    return containerDetails_ == null
        ? com.google.privacy.dlp.v2.Container.getDefaultInstance()
        : containerDetails_;
  }
  /**
   *
   *
   * <pre>
   * Details about the container where the content being inspected is from.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Container container_details = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ContainerOrBuilder getContainerDetailsOrBuilder() {
    return containerDetails_ == null
        ? com.google.privacy.dlp.v2.Container.getDefaultInstance()
        : containerDetails_;
  }

  public static final int FILE_OFFSET_FIELD_NUMBER = 2;
  private long fileOffset_ = 0L;
  /**
   *
   *
   * <pre>
   * Offset in bytes of the line, from the beginning of the file, where the
   * finding  is located. Populate if the item being scanned is only part of a
   * bigger item, such as a shard of a file and you want to track the absolute
   * position of the finding.
   * </pre>
   *
   * <code>int64 file_offset = 2;</code>
   *
   * @return The fileOffset.
   */
  @java.lang.Override
  public long getFileOffset() {
    return fileOffset_;
  }

  public static final int ROW_OFFSET_FIELD_NUMBER = 3;
  private long rowOffset_ = 0L;
  /**
   *
   *
   * <pre>
   * Offset of the row for tables. Populate if the row(s) being scanned are
   * part of a bigger dataset and you want to keep track of their absolute
   * position.
   * </pre>
   *
   * <code>int64 row_offset = 3;</code>
   *
   * @return The rowOffset.
   */
  @java.lang.Override
  public long getRowOffset() {
    return rowOffset_;
  }

  public static final int TABLE_OPTIONS_FIELD_NUMBER = 4;
  private com.google.privacy.dlp.v2.TableOptions tableOptions_;
  /**
   *
   *
   * <pre>
   * If the container is a table, additional information to make findings
   * meaningful such as the columns that are primary keys. If not known ahead
   * of time, can also be set within each inspect hybrid call and the two
   * will be merged. Note that identifying_fields will only be stored to
   * BigQuery, and only if the BigQuery action has been included.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
   *
   * @return Whether the tableOptions field is set.
   */
  @java.lang.Override
  public boolean hasTableOptions() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * If the container is a table, additional information to make findings
   * meaningful such as the columns that are primary keys. If not known ahead
   * of time, can also be set within each inspect hybrid call and the two
   * will be merged. Note that identifying_fields will only be stored to
   * BigQuery, and only if the BigQuery action has been included.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
   *
   * @return The tableOptions.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TableOptions getTableOptions() {
    return tableOptions_ == null
        ? com.google.privacy.dlp.v2.TableOptions.getDefaultInstance()
        : tableOptions_;
  }
  /**
   *
   *
   * <pre>
   * If the container is a table, additional information to make findings
   * meaningful such as the columns that are primary keys. If not known ahead
   * of time, can also be set within each inspect hybrid call and the two
   * will be merged. Note that identifying_fields will only be stored to
   * BigQuery, and only if the BigQuery action has been included.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TableOptionsOrBuilder getTableOptionsOrBuilder() {
    return tableOptions_ == null
        ? com.google.privacy.dlp.v2.TableOptions.getDefaultInstance()
        : tableOptions_;
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.privacy.dlp.v2.DlpProto
                .internal_static_google_privacy_dlp_v2_HybridFindingDetails_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels to represent user provided metadata about the data being inspected.
   * If configured by the job, some key values may be required.
   * The labels associated with `Finding`'s produced by hybrid
   * inspection.
   *
   * Label keys must be between 1 and 63 characters long and must conform
   * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   *
   * Label values must be between 0 and 63 characters long and must conform
   * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
   *
   * No more than 10 labels can be associated with a given finding.
   *
   * Examples:
   * * `"environment" : "production"`
   * * `"pipeline" : "etl"`
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to represent user provided metadata about the data being inspected.
   * If configured by the job, some key values may be required.
   * The labels associated with `Finding`'s produced by hybrid
   * inspection.
   *
   * Label keys must be between 1 and 63 characters long and must conform
   * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   *
   * Label values must be between 0 and 63 characters long and must conform
   * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
   *
   * No more than 10 labels can be associated with a given finding.
   *
   * Examples:
   * * `"environment" : "production"`
   * * `"pipeline" : "etl"`
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to represent user provided metadata about the data being inspected.
   * If configured by the job, some key values may be required.
   * The labels associated with `Finding`'s produced by hybrid
   * inspection.
   *
   * Label keys must be between 1 and 63 characters long and must conform
   * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   *
   * Label values must be between 0 and 63 characters long and must conform
   * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
   *
   * No more than 10 labels can be associated with a given finding.
   *
   * Examples:
   * * `"environment" : "production"`
   * * `"pipeline" : "etl"`
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels to represent user provided metadata about the data being inspected.
   * If configured by the job, some key values may be required.
   * The labels associated with `Finding`'s produced by hybrid
   * inspection.
   *
   * Label keys must be between 1 and 63 characters long and must conform
   * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   *
   * Label values must be between 0 and 63 characters long and must conform
   * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
   *
   * No more than 10 labels can be associated with a given finding.
   *
   * Examples:
   * * `"environment" : "production"`
   * * `"pipeline" : "etl"`
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getContainerDetails());
    }
    if (fileOffset_ != 0L) {
      output.writeInt64(2, fileOffset_);
    }
    if (rowOffset_ != 0L) {
      output.writeInt64(3, rowOffset_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getTableOptions());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getContainerDetails());
    }
    if (fileOffset_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, fileOffset_);
    }
    if (rowOffset_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, rowOffset_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTableOptions());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.HybridFindingDetails)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.HybridFindingDetails other =
        (com.google.privacy.dlp.v2.HybridFindingDetails) obj;

    if (hasContainerDetails() != other.hasContainerDetails()) return false;
    if (hasContainerDetails()) {
      if (!getContainerDetails().equals(other.getContainerDetails())) return false;
    }
    if (getFileOffset() != other.getFileOffset()) return false;
    if (getRowOffset() != other.getRowOffset()) return false;
    if (hasTableOptions() != other.hasTableOptions()) return false;
    if (hasTableOptions()) {
      if (!getTableOptions().equals(other.getTableOptions())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasContainerDetails()) {
      hash = (37 * hash) + CONTAINER_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getContainerDetails().hashCode();
    }
    hash = (37 * hash) + FILE_OFFSET_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getFileOffset());
    hash = (37 * hash) + ROW_OFFSET_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRowOffset());
    if (hasTableOptions()) {
      hash = (37 * hash) + TABLE_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getTableOptions().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.HybridFindingDetails parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.HybridFindingDetails parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.HybridFindingDetails parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.HybridFindingDetails parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.HybridFindingDetails parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.HybridFindingDetails parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.HybridFindingDetails parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.HybridFindingDetails parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.HybridFindingDetails parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.HybridFindingDetails parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.HybridFindingDetails parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.HybridFindingDetails parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.HybridFindingDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Populate to associate additional data with each finding.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.HybridFindingDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.HybridFindingDetails)
      com.google.privacy.dlp.v2.HybridFindingDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_HybridFindingDetails_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_HybridFindingDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.HybridFindingDetails.class,
              com.google.privacy.dlp.v2.HybridFindingDetails.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.HybridFindingDetails.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getContainerDetailsFieldBuilder();
        getTableOptionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      containerDetails_ = null;
      if (containerDetailsBuilder_ != null) {
        containerDetailsBuilder_.dispose();
        containerDetailsBuilder_ = null;
      }
      fileOffset_ = 0L;
      rowOffset_ = 0L;
      tableOptions_ = null;
      if (tableOptionsBuilder_ != null) {
        tableOptionsBuilder_.dispose();
        tableOptionsBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_HybridFindingDetails_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.HybridFindingDetails getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.HybridFindingDetails.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.HybridFindingDetails build() {
      com.google.privacy.dlp.v2.HybridFindingDetails result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.HybridFindingDetails buildPartial() {
      com.google.privacy.dlp.v2.HybridFindingDetails result =
          new com.google.privacy.dlp.v2.HybridFindingDetails(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.HybridFindingDetails result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.containerDetails_ =
            containerDetailsBuilder_ == null ? containerDetails_ : containerDetailsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.fileOffset_ = fileOffset_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.rowOffset_ = rowOffset_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.tableOptions_ =
            tableOptionsBuilder_ == null ? tableOptions_ : tableOptionsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.HybridFindingDetails) {
        return mergeFrom((com.google.privacy.dlp.v2.HybridFindingDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.HybridFindingDetails other) {
      if (other == com.google.privacy.dlp.v2.HybridFindingDetails.getDefaultInstance()) return this;
      if (other.hasContainerDetails()) {
        mergeContainerDetails(other.getContainerDetails());
      }
      if (other.getFileOffset() != 0L) {
        setFileOffset(other.getFileOffset());
      }
      if (other.getRowOffset() != 0L) {
        setRowOffset(other.getRowOffset());
      }
      if (other.hasTableOptions()) {
        mergeTableOptions(other.getTableOptions());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000010;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getContainerDetailsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                fileOffset_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                rowOffset_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getTableOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.Container containerDetails_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Container,
            com.google.privacy.dlp.v2.Container.Builder,
            com.google.privacy.dlp.v2.ContainerOrBuilder>
        containerDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details about the container where the content being inspected is from.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container_details = 1;</code>
     *
     * @return Whether the containerDetails field is set.
     */
    public boolean hasContainerDetails() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Details about the container where the content being inspected is from.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container_details = 1;</code>
     *
     * @return The containerDetails.
     */
    public com.google.privacy.dlp.v2.Container getContainerDetails() {
      if (containerDetailsBuilder_ == null) {
        return containerDetails_ == null
            ? com.google.privacy.dlp.v2.Container.getDefaultInstance()
            : containerDetails_;
      } else {
        return containerDetailsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Details about the container where the content being inspected is from.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container_details = 1;</code>
     */
    public Builder setContainerDetails(com.google.privacy.dlp.v2.Container value) {
      if (containerDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        containerDetails_ = value;
      } else {
        containerDetailsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the container where the content being inspected is from.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container_details = 1;</code>
     */
    public Builder setContainerDetails(
        com.google.privacy.dlp.v2.Container.Builder builderForValue) {
      if (containerDetailsBuilder_ == null) {
        containerDetails_ = builderForValue.build();
      } else {
        containerDetailsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the container where the content being inspected is from.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container_details = 1;</code>
     */
    public Builder mergeContainerDetails(com.google.privacy.dlp.v2.Container value) {
      if (containerDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && containerDetails_ != null
            && containerDetails_ != com.google.privacy.dlp.v2.Container.getDefaultInstance()) {
          getContainerDetailsBuilder().mergeFrom(value);
        } else {
          containerDetails_ = value;
        }
      } else {
        containerDetailsBuilder_.mergeFrom(value);
      }
      if (containerDetails_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the container where the content being inspected is from.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container_details = 1;</code>
     */
    public Builder clearContainerDetails() {
      bitField0_ = (bitField0_ & ~0x00000001);
      containerDetails_ = null;
      if (containerDetailsBuilder_ != null) {
        containerDetailsBuilder_.dispose();
        containerDetailsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the container where the content being inspected is from.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container_details = 1;</code>
     */
    public com.google.privacy.dlp.v2.Container.Builder getContainerDetailsBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getContainerDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details about the container where the content being inspected is from.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container_details = 1;</code>
     */
    public com.google.privacy.dlp.v2.ContainerOrBuilder getContainerDetailsOrBuilder() {
      if (containerDetailsBuilder_ != null) {
        return containerDetailsBuilder_.getMessageOrBuilder();
      } else {
        return containerDetails_ == null
            ? com.google.privacy.dlp.v2.Container.getDefaultInstance()
            : containerDetails_;
      }
    }
    /**
     *
     *
     * <pre>
     * Details about the container where the content being inspected is from.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container_details = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Container,
            com.google.privacy.dlp.v2.Container.Builder,
            com.google.privacy.dlp.v2.ContainerOrBuilder>
        getContainerDetailsFieldBuilder() {
      if (containerDetailsBuilder_ == null) {
        containerDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.Container,
                com.google.privacy.dlp.v2.Container.Builder,
                com.google.privacy.dlp.v2.ContainerOrBuilder>(
                getContainerDetails(), getParentForChildren(), isClean());
        containerDetails_ = null;
      }
      return containerDetailsBuilder_;
    }

    private long fileOffset_;
    /**
     *
     *
     * <pre>
     * Offset in bytes of the line, from the beginning of the file, where the
     * finding  is located. Populate if the item being scanned is only part of a
     * bigger item, such as a shard of a file and you want to track the absolute
     * position of the finding.
     * </pre>
     *
     * <code>int64 file_offset = 2;</code>
     *
     * @return The fileOffset.
     */
    @java.lang.Override
    public long getFileOffset() {
      return fileOffset_;
    }
    /**
     *
     *
     * <pre>
     * Offset in bytes of the line, from the beginning of the file, where the
     * finding  is located. Populate if the item being scanned is only part of a
     * bigger item, such as a shard of a file and you want to track the absolute
     * position of the finding.
     * </pre>
     *
     * <code>int64 file_offset = 2;</code>
     *
     * @param value The fileOffset to set.
     * @return This builder for chaining.
     */
    public Builder setFileOffset(long value) {

      fileOffset_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Offset in bytes of the line, from the beginning of the file, where the
     * finding  is located. Populate if the item being scanned is only part of a
     * bigger item, such as a shard of a file and you want to track the absolute
     * position of the finding.
     * </pre>
     *
     * <code>int64 file_offset = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFileOffset() {
      bitField0_ = (bitField0_ & ~0x00000002);
      fileOffset_ = 0L;
      onChanged();
      return this;
    }

    private long rowOffset_;
    /**
     *
     *
     * <pre>
     * Offset of the row for tables. Populate if the row(s) being scanned are
     * part of a bigger dataset and you want to keep track of their absolute
     * position.
     * </pre>
     *
     * <code>int64 row_offset = 3;</code>
     *
     * @return The rowOffset.
     */
    @java.lang.Override
    public long getRowOffset() {
      return rowOffset_;
    }
    /**
     *
     *
     * <pre>
     * Offset of the row for tables. Populate if the row(s) being scanned are
     * part of a bigger dataset and you want to keep track of their absolute
     * position.
     * </pre>
     *
     * <code>int64 row_offset = 3;</code>
     *
     * @param value The rowOffset to set.
     * @return This builder for chaining.
     */
    public Builder setRowOffset(long value) {

      rowOffset_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Offset of the row for tables. Populate if the row(s) being scanned are
     * part of a bigger dataset and you want to keep track of their absolute
     * position.
     * </pre>
     *
     * <code>int64 row_offset = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowOffset() {
      bitField0_ = (bitField0_ & ~0x00000004);
      rowOffset_ = 0L;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.TableOptions tableOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.TableOptions,
            com.google.privacy.dlp.v2.TableOptions.Builder,
            com.google.privacy.dlp.v2.TableOptionsOrBuilder>
        tableOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys. If not known ahead
     * of time, can also be set within each inspect hybrid call and the two
     * will be merged. Note that identifying_fields will only be stored to
     * BigQuery, and only if the BigQuery action has been included.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     *
     * @return Whether the tableOptions field is set.
     */
    public boolean hasTableOptions() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys. If not known ahead
     * of time, can also be set within each inspect hybrid call and the two
     * will be merged. Note that identifying_fields will only be stored to
     * BigQuery, and only if the BigQuery action has been included.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     *
     * @return The tableOptions.
     */
    public com.google.privacy.dlp.v2.TableOptions getTableOptions() {
      if (tableOptionsBuilder_ == null) {
        return tableOptions_ == null
            ? com.google.privacy.dlp.v2.TableOptions.getDefaultInstance()
            : tableOptions_;
      } else {
        return tableOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys. If not known ahead
     * of time, can also be set within each inspect hybrid call and the two
     * will be merged. Note that identifying_fields will only be stored to
     * BigQuery, and only if the BigQuery action has been included.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     */
    public Builder setTableOptions(com.google.privacy.dlp.v2.TableOptions value) {
      if (tableOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tableOptions_ = value;
      } else {
        tableOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys. If not known ahead
     * of time, can also be set within each inspect hybrid call and the two
     * will be merged. Note that identifying_fields will only be stored to
     * BigQuery, and only if the BigQuery action has been included.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     */
    public Builder setTableOptions(com.google.privacy.dlp.v2.TableOptions.Builder builderForValue) {
      if (tableOptionsBuilder_ == null) {
        tableOptions_ = builderForValue.build();
      } else {
        tableOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys. If not known ahead
     * of time, can also be set within each inspect hybrid call and the two
     * will be merged. Note that identifying_fields will only be stored to
     * BigQuery, and only if the BigQuery action has been included.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     */
    public Builder mergeTableOptions(com.google.privacy.dlp.v2.TableOptions value) {
      if (tableOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && tableOptions_ != null
            && tableOptions_ != com.google.privacy.dlp.v2.TableOptions.getDefaultInstance()) {
          getTableOptionsBuilder().mergeFrom(value);
        } else {
          tableOptions_ = value;
        }
      } else {
        tableOptionsBuilder_.mergeFrom(value);
      }
      if (tableOptions_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys. If not known ahead
     * of time, can also be set within each inspect hybrid call and the two
     * will be merged. Note that identifying_fields will only be stored to
     * BigQuery, and only if the BigQuery action has been included.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     */
    public Builder clearTableOptions() {
      bitField0_ = (bitField0_ & ~0x00000008);
      tableOptions_ = null;
      if (tableOptionsBuilder_ != null) {
        tableOptionsBuilder_.dispose();
        tableOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys. If not known ahead
     * of time, can also be set within each inspect hybrid call and the two
     * will be merged. Note that identifying_fields will only be stored to
     * BigQuery, and only if the BigQuery action has been included.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     */
    public com.google.privacy.dlp.v2.TableOptions.Builder getTableOptionsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getTableOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys. If not known ahead
     * of time, can also be set within each inspect hybrid call and the two
     * will be merged. Note that identifying_fields will only be stored to
     * BigQuery, and only if the BigQuery action has been included.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     */
    public com.google.privacy.dlp.v2.TableOptionsOrBuilder getTableOptionsOrBuilder() {
      if (tableOptionsBuilder_ != null) {
        return tableOptionsBuilder_.getMessageOrBuilder();
      } else {
        return tableOptions_ == null
            ? com.google.privacy.dlp.v2.TableOptions.getDefaultInstance()
            : tableOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys. If not known ahead
     * of time, can also be set within each inspect hybrid call and the two
     * will be merged. Note that identifying_fields will only be stored to
     * BigQuery, and only if the BigQuery action has been included.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.TableOptions,
            com.google.privacy.dlp.v2.TableOptions.Builder,
            com.google.privacy.dlp.v2.TableOptionsOrBuilder>
        getTableOptionsFieldBuilder() {
      if (tableOptionsBuilder_ == null) {
        tableOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.TableOptions,
                com.google.privacy.dlp.v2.TableOptions.Builder,
                com.google.privacy.dlp.v2.TableOptionsOrBuilder>(
                getTableOptions(), getParentForChildren(), isClean());
        tableOptions_ = null;
      }
      return tableOptionsBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels to represent user provided metadata about the data being inspected.
     * If configured by the job, some key values may be required.
     * The labels associated with `Finding`'s produced by hybrid
     * inspection.
     *
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     *
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     *
     * No more than 10 labels can be associated with a given finding.
     *
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to represent user provided metadata about the data being inspected.
     * If configured by the job, some key values may be required.
     * The labels associated with `Finding`'s produced by hybrid
     * inspection.
     *
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     *
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     *
     * No more than 10 labels can be associated with a given finding.
     *
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to represent user provided metadata about the data being inspected.
     * If configured by the job, some key values may be required.
     * The labels associated with `Finding`'s produced by hybrid
     * inspection.
     *
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     *
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     *
     * No more than 10 labels can be associated with a given finding.
     *
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels to represent user provided metadata about the data being inspected.
     * If configured by the job, some key values may be required.
     * The labels associated with `Finding`'s produced by hybrid
     * inspection.
     *
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     *
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     *
     * No more than 10 labels can be associated with a given finding.
     *
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to represent user provided metadata about the data being inspected.
     * If configured by the job, some key values may be required.
     * The labels associated with `Finding`'s produced by hybrid
     * inspection.
     *
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     *
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     *
     * No more than 10 labels can be associated with a given finding.
     *
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000010;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to represent user provided metadata about the data being inspected.
     * If configured by the job, some key values may be required.
     * The labels associated with `Finding`'s produced by hybrid
     * inspection.
     *
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     *
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     *
     * No more than 10 labels can be associated with a given finding.
     *
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to represent user provided metadata about the data being inspected.
     * If configured by the job, some key values may be required.
     * The labels associated with `Finding`'s produced by hybrid
     * inspection.
     *
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     *
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     *
     * No more than 10 labels can be associated with a given finding.
     *
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.HybridFindingDetails)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.HybridFindingDetails)
  private static final com.google.privacy.dlp.v2.HybridFindingDetails DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.HybridFindingDetails();
  }

  public static com.google.privacy.dlp.v2.HybridFindingDetails getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HybridFindingDetails> PARSER =
      new com.google.protobuf.AbstractParser<HybridFindingDetails>() {
        @java.lang.Override
        public HybridFindingDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HybridFindingDetails> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HybridFindingDetails> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.HybridFindingDetails getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
