/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Classification of infoTypes to organize them according to geographic
 * location, industry, and data type.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.InfoTypeCategory}
 */
public final class InfoTypeCategory extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.InfoTypeCategory)
    InfoTypeCategoryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InfoTypeCategory.newBuilder() to construct.
  private InfoTypeCategory(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InfoTypeCategory() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InfoTypeCategory();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_InfoTypeCategory_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_InfoTypeCategory_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.InfoTypeCategory.class,
            com.google.privacy.dlp.v2.InfoTypeCategory.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Enum of the current locations.
   * We might add more locations in the future.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.InfoTypeCategory.LocationCategory}
   */
  public enum LocationCategory implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused location
     * </pre>
     *
     * <code>LOCATION_UNSPECIFIED = 0;</code>
     */
    LOCATION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The infoType is not issued by or tied to a specific region, but is used
     * almost everywhere.
     * </pre>
     *
     * <code>GLOBAL = 1;</code>
     */
    GLOBAL(1),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Argentina.
     * </pre>
     *
     * <code>ARGENTINA = 2;</code>
     */
    ARGENTINA(2),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Australia.
     * </pre>
     *
     * <code>AUSTRALIA = 3;</code>
     */
    AUSTRALIA(3),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Belgium.
     * </pre>
     *
     * <code>BELGIUM = 4;</code>
     */
    BELGIUM(4),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Brazil.
     * </pre>
     *
     * <code>BRAZIL = 5;</code>
     */
    BRAZIL(5),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Canada.
     * </pre>
     *
     * <code>CANADA = 6;</code>
     */
    CANADA(6),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Chile.
     * </pre>
     *
     * <code>CHILE = 7;</code>
     */
    CHILE(7),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in China.
     * </pre>
     *
     * <code>CHINA = 8;</code>
     */
    CHINA(8),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Colombia.
     * </pre>
     *
     * <code>COLOMBIA = 9;</code>
     */
    COLOMBIA(9),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Croatia.
     * </pre>
     *
     * <code>CROATIA = 42;</code>
     */
    CROATIA(42),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Denmark.
     * </pre>
     *
     * <code>DENMARK = 10;</code>
     */
    DENMARK(10),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in France.
     * </pre>
     *
     * <code>FRANCE = 11;</code>
     */
    FRANCE(11),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Finland.
     * </pre>
     *
     * <code>FINLAND = 12;</code>
     */
    FINLAND(12),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Germany.
     * </pre>
     *
     * <code>GERMANY = 13;</code>
     */
    GERMANY(13),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Hong Kong.
     * </pre>
     *
     * <code>HONG_KONG = 14;</code>
     */
    HONG_KONG(14),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in India.
     * </pre>
     *
     * <code>INDIA = 15;</code>
     */
    INDIA(15),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Indonesia.
     * </pre>
     *
     * <code>INDONESIA = 16;</code>
     */
    INDONESIA(16),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Ireland.
     * </pre>
     *
     * <code>IRELAND = 17;</code>
     */
    IRELAND(17),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Israel.
     * </pre>
     *
     * <code>ISRAEL = 18;</code>
     */
    ISRAEL(18),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Italy.
     * </pre>
     *
     * <code>ITALY = 19;</code>
     */
    ITALY(19),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Japan.
     * </pre>
     *
     * <code>JAPAN = 20;</code>
     */
    JAPAN(20),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Kazakhstan.
     * </pre>
     *
     * <code>KAZAKHSTAN = 47;</code>
     */
    KAZAKHSTAN(47),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Korea.
     * </pre>
     *
     * <code>KOREA = 21;</code>
     */
    KOREA(21),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Mexico.
     * </pre>
     *
     * <code>MEXICO = 22;</code>
     */
    MEXICO(22),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in the Netherlands.
     * </pre>
     *
     * <code>THE_NETHERLANDS = 23;</code>
     */
    THE_NETHERLANDS(23),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in New Zealand.
     * </pre>
     *
     * <code>NEW_ZEALAND = 41;</code>
     */
    NEW_ZEALAND(41),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Norway.
     * </pre>
     *
     * <code>NORWAY = 24;</code>
     */
    NORWAY(24),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Paraguay.
     * </pre>
     *
     * <code>PARAGUAY = 25;</code>
     */
    PARAGUAY(25),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Peru.
     * </pre>
     *
     * <code>PERU = 26;</code>
     */
    PERU(26),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Poland.
     * </pre>
     *
     * <code>POLAND = 27;</code>
     */
    POLAND(27),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Portugal.
     * </pre>
     *
     * <code>PORTUGAL = 28;</code>
     */
    PORTUGAL(28),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Russia.
     * </pre>
     *
     * <code>RUSSIA = 44;</code>
     */
    RUSSIA(44),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Singapore.
     * </pre>
     *
     * <code>SINGAPORE = 29;</code>
     */
    SINGAPORE(29),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in South Africa.
     * </pre>
     *
     * <code>SOUTH_AFRICA = 30;</code>
     */
    SOUTH_AFRICA(30),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Spain.
     * </pre>
     *
     * <code>SPAIN = 31;</code>
     */
    SPAIN(31),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Sweden.
     * </pre>
     *
     * <code>SWEDEN = 32;</code>
     */
    SWEDEN(32),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Switzerland.
     * </pre>
     *
     * <code>SWITZERLAND = 43;</code>
     */
    SWITZERLAND(43),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Taiwan.
     * </pre>
     *
     * <code>TAIWAN = 33;</code>
     */
    TAIWAN(33),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Thailand.
     * </pre>
     *
     * <code>THAILAND = 34;</code>
     */
    THAILAND(34),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Turkey.
     * </pre>
     *
     * <code>TURKEY = 35;</code>
     */
    TURKEY(35),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Ukraine.
     * </pre>
     *
     * <code>UKRAINE = 45;</code>
     */
    UKRAINE(45),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in the United Kingdom.
     * </pre>
     *
     * <code>UNITED_KINGDOM = 36;</code>
     */
    UNITED_KINGDOM(36),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in the United States.
     * </pre>
     *
     * <code>UNITED_STATES = 37;</code>
     */
    UNITED_STATES(37),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Uruguay.
     * </pre>
     *
     * <code>URUGUAY = 38;</code>
     */
    URUGUAY(38),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Uzbekistan.
     * </pre>
     *
     * <code>UZBEKISTAN = 46;</code>
     */
    UZBEKISTAN(46),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Venezuela.
     * </pre>
     *
     * <code>VENEZUELA = 39;</code>
     */
    VENEZUELA(39),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Google internally.
     * </pre>
     *
     * <code>INTERNAL = 40;</code>
     */
    INTERNAL(40),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused location
     * </pre>
     *
     * <code>LOCATION_UNSPECIFIED = 0;</code>
     */
    public static final int LOCATION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The infoType is not issued by or tied to a specific region, but is used
     * almost everywhere.
     * </pre>
     *
     * <code>GLOBAL = 1;</code>
     */
    public static final int GLOBAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Argentina.
     * </pre>
     *
     * <code>ARGENTINA = 2;</code>
     */
    public static final int ARGENTINA_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Australia.
     * </pre>
     *
     * <code>AUSTRALIA = 3;</code>
     */
    public static final int AUSTRALIA_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Belgium.
     * </pre>
     *
     * <code>BELGIUM = 4;</code>
     */
    public static final int BELGIUM_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Brazil.
     * </pre>
     *
     * <code>BRAZIL = 5;</code>
     */
    public static final int BRAZIL_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Canada.
     * </pre>
     *
     * <code>CANADA = 6;</code>
     */
    public static final int CANADA_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Chile.
     * </pre>
     *
     * <code>CHILE = 7;</code>
     */
    public static final int CHILE_VALUE = 7;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in China.
     * </pre>
     *
     * <code>CHINA = 8;</code>
     */
    public static final int CHINA_VALUE = 8;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Colombia.
     * </pre>
     *
     * <code>COLOMBIA = 9;</code>
     */
    public static final int COLOMBIA_VALUE = 9;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Croatia.
     * </pre>
     *
     * <code>CROATIA = 42;</code>
     */
    public static final int CROATIA_VALUE = 42;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Denmark.
     * </pre>
     *
     * <code>DENMARK = 10;</code>
     */
    public static final int DENMARK_VALUE = 10;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in France.
     * </pre>
     *
     * <code>FRANCE = 11;</code>
     */
    public static final int FRANCE_VALUE = 11;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Finland.
     * </pre>
     *
     * <code>FINLAND = 12;</code>
     */
    public static final int FINLAND_VALUE = 12;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Germany.
     * </pre>
     *
     * <code>GERMANY = 13;</code>
     */
    public static final int GERMANY_VALUE = 13;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Hong Kong.
     * </pre>
     *
     * <code>HONG_KONG = 14;</code>
     */
    public static final int HONG_KONG_VALUE = 14;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in India.
     * </pre>
     *
     * <code>INDIA = 15;</code>
     */
    public static final int INDIA_VALUE = 15;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Indonesia.
     * </pre>
     *
     * <code>INDONESIA = 16;</code>
     */
    public static final int INDONESIA_VALUE = 16;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Ireland.
     * </pre>
     *
     * <code>IRELAND = 17;</code>
     */
    public static final int IRELAND_VALUE = 17;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Israel.
     * </pre>
     *
     * <code>ISRAEL = 18;</code>
     */
    public static final int ISRAEL_VALUE = 18;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Italy.
     * </pre>
     *
     * <code>ITALY = 19;</code>
     */
    public static final int ITALY_VALUE = 19;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Japan.
     * </pre>
     *
     * <code>JAPAN = 20;</code>
     */
    public static final int JAPAN_VALUE = 20;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Kazakhstan.
     * </pre>
     *
     * <code>KAZAKHSTAN = 47;</code>
     */
    public static final int KAZAKHSTAN_VALUE = 47;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Korea.
     * </pre>
     *
     * <code>KOREA = 21;</code>
     */
    public static final int KOREA_VALUE = 21;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Mexico.
     * </pre>
     *
     * <code>MEXICO = 22;</code>
     */
    public static final int MEXICO_VALUE = 22;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in the Netherlands.
     * </pre>
     *
     * <code>THE_NETHERLANDS = 23;</code>
     */
    public static final int THE_NETHERLANDS_VALUE = 23;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in New Zealand.
     * </pre>
     *
     * <code>NEW_ZEALAND = 41;</code>
     */
    public static final int NEW_ZEALAND_VALUE = 41;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Norway.
     * </pre>
     *
     * <code>NORWAY = 24;</code>
     */
    public static final int NORWAY_VALUE = 24;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Paraguay.
     * </pre>
     *
     * <code>PARAGUAY = 25;</code>
     */
    public static final int PARAGUAY_VALUE = 25;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Peru.
     * </pre>
     *
     * <code>PERU = 26;</code>
     */
    public static final int PERU_VALUE = 26;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Poland.
     * </pre>
     *
     * <code>POLAND = 27;</code>
     */
    public static final int POLAND_VALUE = 27;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Portugal.
     * </pre>
     *
     * <code>PORTUGAL = 28;</code>
     */
    public static final int PORTUGAL_VALUE = 28;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Russia.
     * </pre>
     *
     * <code>RUSSIA = 44;</code>
     */
    public static final int RUSSIA_VALUE = 44;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Singapore.
     * </pre>
     *
     * <code>SINGAPORE = 29;</code>
     */
    public static final int SINGAPORE_VALUE = 29;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in South Africa.
     * </pre>
     *
     * <code>SOUTH_AFRICA = 30;</code>
     */
    public static final int SOUTH_AFRICA_VALUE = 30;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Spain.
     * </pre>
     *
     * <code>SPAIN = 31;</code>
     */
    public static final int SPAIN_VALUE = 31;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Sweden.
     * </pre>
     *
     * <code>SWEDEN = 32;</code>
     */
    public static final int SWEDEN_VALUE = 32;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Switzerland.
     * </pre>
     *
     * <code>SWITZERLAND = 43;</code>
     */
    public static final int SWITZERLAND_VALUE = 43;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Taiwan.
     * </pre>
     *
     * <code>TAIWAN = 33;</code>
     */
    public static final int TAIWAN_VALUE = 33;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Thailand.
     * </pre>
     *
     * <code>THAILAND = 34;</code>
     */
    public static final int THAILAND_VALUE = 34;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Turkey.
     * </pre>
     *
     * <code>TURKEY = 35;</code>
     */
    public static final int TURKEY_VALUE = 35;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Ukraine.
     * </pre>
     *
     * <code>UKRAINE = 45;</code>
     */
    public static final int UKRAINE_VALUE = 45;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in the United Kingdom.
     * </pre>
     *
     * <code>UNITED_KINGDOM = 36;</code>
     */
    public static final int UNITED_KINGDOM_VALUE = 36;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in the United States.
     * </pre>
     *
     * <code>UNITED_STATES = 37;</code>
     */
    public static final int UNITED_STATES_VALUE = 37;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Uruguay.
     * </pre>
     *
     * <code>URUGUAY = 38;</code>
     */
    public static final int URUGUAY_VALUE = 38;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Uzbekistan.
     * </pre>
     *
     * <code>UZBEKISTAN = 46;</code>
     */
    public static final int UZBEKISTAN_VALUE = 46;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Venezuela.
     * </pre>
     *
     * <code>VENEZUELA = 39;</code>
     */
    public static final int VENEZUELA_VALUE = 39;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in Google internally.
     * </pre>
     *
     * <code>INTERNAL = 40;</code>
     */
    public static final int INTERNAL_VALUE = 40;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LocationCategory valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LocationCategory forNumber(int value) {
      switch (value) {
        case 0:
          return LOCATION_UNSPECIFIED;
        case 1:
          return GLOBAL;
        case 2:
          return ARGENTINA;
        case 3:
          return AUSTRALIA;
        case 4:
          return BELGIUM;
        case 5:
          return BRAZIL;
        case 6:
          return CANADA;
        case 7:
          return CHILE;
        case 8:
          return CHINA;
        case 9:
          return COLOMBIA;
        case 42:
          return CROATIA;
        case 10:
          return DENMARK;
        case 11:
          return FRANCE;
        case 12:
          return FINLAND;
        case 13:
          return GERMANY;
        case 14:
          return HONG_KONG;
        case 15:
          return INDIA;
        case 16:
          return INDONESIA;
        case 17:
          return IRELAND;
        case 18:
          return ISRAEL;
        case 19:
          return ITALY;
        case 20:
          return JAPAN;
        case 47:
          return KAZAKHSTAN;
        case 21:
          return KOREA;
        case 22:
          return MEXICO;
        case 23:
          return THE_NETHERLANDS;
        case 41:
          return NEW_ZEALAND;
        case 24:
          return NORWAY;
        case 25:
          return PARAGUAY;
        case 26:
          return PERU;
        case 27:
          return POLAND;
        case 28:
          return PORTUGAL;
        case 44:
          return RUSSIA;
        case 29:
          return SINGAPORE;
        case 30:
          return SOUTH_AFRICA;
        case 31:
          return SPAIN;
        case 32:
          return SWEDEN;
        case 43:
          return SWITZERLAND;
        case 33:
          return TAIWAN;
        case 34:
          return THAILAND;
        case 35:
          return TURKEY;
        case 45:
          return UKRAINE;
        case 36:
          return UNITED_KINGDOM;
        case 37:
          return UNITED_STATES;
        case 38:
          return URUGUAY;
        case 46:
          return UZBEKISTAN;
        case 39:
          return VENEZUELA;
        case 40:
          return INTERNAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LocationCategory> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LocationCategory>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<LocationCategory>() {
              public LocationCategory findValueByNumber(int number) {
                return LocationCategory.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.InfoTypeCategory.getDescriptor().getEnumTypes().get(0);
    }

    private static final LocationCategory[] VALUES = values();

    public static LocationCategory valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LocationCategory(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.InfoTypeCategory.LocationCategory)
  }

  /**
   *
   *
   * <pre>
   * Enum of the current industries in the category.
   * We might add more industries in the future.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory}
   */
  public enum IndustryCategory implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused industry
     * </pre>
     *
     * <code>INDUSTRY_UNSPECIFIED = 0;</code>
     */
    INDUSTRY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in the finance industry.
     * </pre>
     *
     * <code>FINANCE = 1;</code>
     */
    FINANCE(1),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in the health industry.
     * </pre>
     *
     * <code>HEALTH = 2;</code>
     */
    HEALTH(2),
    /**
     *
     *
     * <pre>
     * The infoType is typically used in the telecommunications industry.
     * </pre>
     *
     * <code>TELECOMMUNICATIONS = 3;</code>
     */
    TELECOMMUNICATIONS(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused industry
     * </pre>
     *
     * <code>INDUSTRY_UNSPECIFIED = 0;</code>
     */
    public static final int INDUSTRY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in the finance industry.
     * </pre>
     *
     * <code>FINANCE = 1;</code>
     */
    public static final int FINANCE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in the health industry.
     * </pre>
     *
     * <code>HEALTH = 2;</code>
     */
    public static final int HEALTH_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The infoType is typically used in the telecommunications industry.
     * </pre>
     *
     * <code>TELECOMMUNICATIONS = 3;</code>
     */
    public static final int TELECOMMUNICATIONS_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IndustryCategory valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IndustryCategory forNumber(int value) {
      switch (value) {
        case 0:
          return INDUSTRY_UNSPECIFIED;
        case 1:
          return FINANCE;
        case 2:
          return HEALTH;
        case 3:
          return TELECOMMUNICATIONS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IndustryCategory> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IndustryCategory>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<IndustryCategory>() {
              public IndustryCategory findValueByNumber(int number) {
                return IndustryCategory.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.InfoTypeCategory.getDescriptor().getEnumTypes().get(1);
    }

    private static final IndustryCategory[] VALUES = values();

    public static IndustryCategory valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IndustryCategory(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory)
  }

  /**
   *
   *
   * <pre>
   * Enum of the current types in the category.
   * We might add more types in the future.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.InfoTypeCategory.TypeCategory}
   */
  public enum TypeCategory implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused type
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Personally identifiable information, for example, a
     * name or phone number
     * </pre>
     *
     * <code>PII = 1;</code>
     */
    PII(1),
    /**
     *
     *
     * <pre>
     * Personally identifiable information that is especially sensitive, for
     * example, a passport number.
     * </pre>
     *
     * <code>SPII = 2;</code>
     */
    SPII(2),
    /**
     *
     *
     * <pre>
     * Attributes that can partially identify someone, especially in
     * combination with other attributes, like age, height, and gender.
     * </pre>
     *
     * <code>DEMOGRAPHIC = 3;</code>
     */
    DEMOGRAPHIC(3),
    /**
     *
     *
     * <pre>
     * Confidential or secret information, for example, a password.
     * </pre>
     *
     * <code>CREDENTIAL = 4;</code>
     */
    CREDENTIAL(4),
    /**
     *
     *
     * <pre>
     * An identification document issued by a government.
     * </pre>
     *
     * <code>GOVERNMENT_ID = 5;</code>
     */
    GOVERNMENT_ID(5),
    /**
     *
     *
     * <pre>
     * A document, for example, a resume or source code.
     * </pre>
     *
     * <code>DOCUMENT = 6;</code>
     */
    DOCUMENT(6),
    /**
     *
     *
     * <pre>
     * Information that is not sensitive on its own, but provides details about
     * the circumstances surrounding an entity or an event.
     * </pre>
     *
     * <code>CONTEXTUAL_INFORMATION = 7;</code>
     */
    CONTEXTUAL_INFORMATION(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused type
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Personally identifiable information, for example, a
     * name or phone number
     * </pre>
     *
     * <code>PII = 1;</code>
     */
    public static final int PII_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Personally identifiable information that is especially sensitive, for
     * example, a passport number.
     * </pre>
     *
     * <code>SPII = 2;</code>
     */
    public static final int SPII_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Attributes that can partially identify someone, especially in
     * combination with other attributes, like age, height, and gender.
     * </pre>
     *
     * <code>DEMOGRAPHIC = 3;</code>
     */
    public static final int DEMOGRAPHIC_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Confidential or secret information, for example, a password.
     * </pre>
     *
     * <code>CREDENTIAL = 4;</code>
     */
    public static final int CREDENTIAL_VALUE = 4;
    /**
     *
     *
     * <pre>
     * An identification document issued by a government.
     * </pre>
     *
     * <code>GOVERNMENT_ID = 5;</code>
     */
    public static final int GOVERNMENT_ID_VALUE = 5;
    /**
     *
     *
     * <pre>
     * A document, for example, a resume or source code.
     * </pre>
     *
     * <code>DOCUMENT = 6;</code>
     */
    public static final int DOCUMENT_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Information that is not sensitive on its own, but provides details about
     * the circumstances surrounding an entity or an event.
     * </pre>
     *
     * <code>CONTEXTUAL_INFORMATION = 7;</code>
     */
    public static final int CONTEXTUAL_INFORMATION_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TypeCategory valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TypeCategory forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return PII;
        case 2:
          return SPII;
        case 3:
          return DEMOGRAPHIC;
        case 4:
          return CREDENTIAL;
        case 5:
          return GOVERNMENT_ID;
        case 6:
          return DOCUMENT;
        case 7:
          return CONTEXTUAL_INFORMATION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TypeCategory> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TypeCategory> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TypeCategory>() {
          public TypeCategory findValueByNumber(int number) {
            return TypeCategory.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.InfoTypeCategory.getDescriptor().getEnumTypes().get(2);
    }

    private static final TypeCategory[] VALUES = values();

    public static TypeCategory valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TypeCategory(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.InfoTypeCategory.TypeCategory)
  }

  private int categoryCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object category_;

  public enum CategoryCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    LOCATION_CATEGORY(1),
    INDUSTRY_CATEGORY(2),
    TYPE_CATEGORY(3),
    CATEGORY_NOT_SET(0);
    private final int value;

    private CategoryCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CategoryCase valueOf(int value) {
      return forNumber(value);
    }

    public static CategoryCase forNumber(int value) {
      switch (value) {
        case 1:
          return LOCATION_CATEGORY;
        case 2:
          return INDUSTRY_CATEGORY;
        case 3:
          return TYPE_CATEGORY;
        case 0:
          return CATEGORY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public CategoryCase getCategoryCase() {
    return CategoryCase.forNumber(categoryCase_);
  }

  public static final int LOCATION_CATEGORY_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The region or country that issued the ID or document represented by the
   * infoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory location_category = 1;</code>
   *
   * @return Whether the locationCategory field is set.
   */
  public boolean hasLocationCategory() {
    return categoryCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The region or country that issued the ID or document represented by the
   * infoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory location_category = 1;</code>
   *
   * @return The enum numeric value on the wire for locationCategory.
   */
  public int getLocationCategoryValue() {
    if (categoryCase_ == 1) {
      return (java.lang.Integer) category_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * The region or country that issued the ID or document represented by the
   * infoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory location_category = 1;</code>
   *
   * @return The locationCategory.
   */
  public com.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory getLocationCategory() {
    if (categoryCase_ == 1) {
      com.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory result =
          com.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory.forNumber(
              (java.lang.Integer) category_);
      return result == null
          ? com.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory.UNRECOGNIZED
          : result;
    }
    return com.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory.LOCATION_UNSPECIFIED;
  }

  public static final int INDUSTRY_CATEGORY_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The group of relevant businesses where this infoType is commonly used
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory industry_category = 2;</code>
   *
   * @return Whether the industryCategory field is set.
   */
  public boolean hasIndustryCategory() {
    return categoryCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The group of relevant businesses where this infoType is commonly used
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory industry_category = 2;</code>
   *
   * @return The enum numeric value on the wire for industryCategory.
   */
  public int getIndustryCategoryValue() {
    if (categoryCase_ == 2) {
      return (java.lang.Integer) category_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * The group of relevant businesses where this infoType is commonly used
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory industry_category = 2;</code>
   *
   * @return The industryCategory.
   */
  public com.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory getIndustryCategory() {
    if (categoryCase_ == 2) {
      com.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory result =
          com.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory.forNumber(
              (java.lang.Integer) category_);
      return result == null
          ? com.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory.UNRECOGNIZED
          : result;
    }
    return com.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory.INDUSTRY_UNSPECIFIED;
  }

  public static final int TYPE_CATEGORY_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The class of identifiers where this infoType belongs
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory type_category = 3;</code>
   *
   * @return Whether the typeCategory field is set.
   */
  public boolean hasTypeCategory() {
    return categoryCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The class of identifiers where this infoType belongs
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory type_category = 3;</code>
   *
   * @return The enum numeric value on the wire for typeCategory.
   */
  public int getTypeCategoryValue() {
    if (categoryCase_ == 3) {
      return (java.lang.Integer) category_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * The class of identifiers where this infoType belongs
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory type_category = 3;</code>
   *
   * @return The typeCategory.
   */
  public com.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory getTypeCategory() {
    if (categoryCase_ == 3) {
      com.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory result =
          com.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory.forNumber(
              (java.lang.Integer) category_);
      return result == null
          ? com.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory.UNRECOGNIZED
          : result;
    }
    return com.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory.TYPE_UNSPECIFIED;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (categoryCase_ == 1) {
      output.writeEnum(1, ((java.lang.Integer) category_));
    }
    if (categoryCase_ == 2) {
      output.writeEnum(2, ((java.lang.Integer) category_));
    }
    if (categoryCase_ == 3) {
      output.writeEnum(3, ((java.lang.Integer) category_));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (categoryCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(1, ((java.lang.Integer) category_));
    }
    if (categoryCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(2, ((java.lang.Integer) category_));
    }
    if (categoryCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(3, ((java.lang.Integer) category_));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.InfoTypeCategory)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.InfoTypeCategory other =
        (com.google.privacy.dlp.v2.InfoTypeCategory) obj;

    if (!getCategoryCase().equals(other.getCategoryCase())) return false;
    switch (categoryCase_) {
      case 1:
        if (getLocationCategoryValue() != other.getLocationCategoryValue()) return false;
        break;
      case 2:
        if (getIndustryCategoryValue() != other.getIndustryCategoryValue()) return false;
        break;
      case 3:
        if (getTypeCategoryValue() != other.getTypeCategoryValue()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (categoryCase_) {
      case 1:
        hash = (37 * hash) + LOCATION_CATEGORY_FIELD_NUMBER;
        hash = (53 * hash) + getLocationCategoryValue();
        break;
      case 2:
        hash = (37 * hash) + INDUSTRY_CATEGORY_FIELD_NUMBER;
        hash = (53 * hash) + getIndustryCategoryValue();
        break;
      case 3:
        hash = (37 * hash) + TYPE_CATEGORY_FIELD_NUMBER;
        hash = (53 * hash) + getTypeCategoryValue();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.InfoTypeCategory parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InfoTypeCategory parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InfoTypeCategory parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InfoTypeCategory parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InfoTypeCategory parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InfoTypeCategory parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InfoTypeCategory parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InfoTypeCategory parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InfoTypeCategory parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InfoTypeCategory parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InfoTypeCategory parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InfoTypeCategory parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.InfoTypeCategory prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Classification of infoTypes to organize them according to geographic
   * location, industry, and data type.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.InfoTypeCategory}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.InfoTypeCategory)
      com.google.privacy.dlp.v2.InfoTypeCategoryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InfoTypeCategory_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InfoTypeCategory_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.InfoTypeCategory.class,
              com.google.privacy.dlp.v2.InfoTypeCategory.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.InfoTypeCategory.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      categoryCase_ = 0;
      category_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InfoTypeCategory_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeCategory getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.InfoTypeCategory.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeCategory build() {
      com.google.privacy.dlp.v2.InfoTypeCategory result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeCategory buildPartial() {
      com.google.privacy.dlp.v2.InfoTypeCategory result =
          new com.google.privacy.dlp.v2.InfoTypeCategory(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.InfoTypeCategory result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.InfoTypeCategory result) {
      result.categoryCase_ = categoryCase_;
      result.category_ = this.category_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.InfoTypeCategory) {
        return mergeFrom((com.google.privacy.dlp.v2.InfoTypeCategory) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.InfoTypeCategory other) {
      if (other == com.google.privacy.dlp.v2.InfoTypeCategory.getDefaultInstance()) return this;
      switch (other.getCategoryCase()) {
        case LOCATION_CATEGORY:
          {
            setLocationCategoryValue(other.getLocationCategoryValue());
            break;
          }
        case INDUSTRY_CATEGORY:
          {
            setIndustryCategoryValue(other.getIndustryCategoryValue());
            break;
          }
        case TYPE_CATEGORY:
          {
            setTypeCategoryValue(other.getTypeCategoryValue());
            break;
          }
        case CATEGORY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int rawValue = input.readEnum();
                categoryCase_ = 1;
                category_ = rawValue;
                break;
              } // case 8
            case 16:
              {
                int rawValue = input.readEnum();
                categoryCase_ = 2;
                category_ = rawValue;
                break;
              } // case 16
            case 24:
              {
                int rawValue = input.readEnum();
                categoryCase_ = 3;
                category_ = rawValue;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int categoryCase_ = 0;
    private java.lang.Object category_;

    public CategoryCase getCategoryCase() {
      return CategoryCase.forNumber(categoryCase_);
    }

    public Builder clearCategory() {
      categoryCase_ = 0;
      category_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * The region or country that issued the ID or document represented by the
     * infoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory location_category = 1;</code>
     *
     * @return Whether the locationCategory field is set.
     */
    @java.lang.Override
    public boolean hasLocationCategory() {
      return categoryCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The region or country that issued the ID or document represented by the
     * infoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory location_category = 1;</code>
     *
     * @return The enum numeric value on the wire for locationCategory.
     */
    @java.lang.Override
    public int getLocationCategoryValue() {
      if (categoryCase_ == 1) {
        return ((java.lang.Integer) category_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * The region or country that issued the ID or document represented by the
     * infoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory location_category = 1;</code>
     *
     * @param value The enum numeric value on the wire for locationCategory to set.
     * @return This builder for chaining.
     */
    public Builder setLocationCategoryValue(int value) {
      categoryCase_ = 1;
      category_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The region or country that issued the ID or document represented by the
     * infoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory location_category = 1;</code>
     *
     * @return The locationCategory.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory getLocationCategory() {
      if (categoryCase_ == 1) {
        com.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory result =
            com.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory.forNumber(
                (java.lang.Integer) category_);
        return result == null
            ? com.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory.UNRECOGNIZED
            : result;
      }
      return com.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory.LOCATION_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * The region or country that issued the ID or document represented by the
     * infoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory location_category = 1;</code>
     *
     * @param value The locationCategory to set.
     * @return This builder for chaining.
     */
    public Builder setLocationCategory(
        com.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory value) {
      if (value == null) {
        throw new NullPointerException();
      }
      categoryCase_ = 1;
      category_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The region or country that issued the ID or document represented by the
     * infoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.LocationCategory location_category = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationCategory() {
      if (categoryCase_ == 1) {
        categoryCase_ = 0;
        category_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The group of relevant businesses where this infoType is commonly used
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory industry_category = 2;</code>
     *
     * @return Whether the industryCategory field is set.
     */
    @java.lang.Override
    public boolean hasIndustryCategory() {
      return categoryCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The group of relevant businesses where this infoType is commonly used
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory industry_category = 2;</code>
     *
     * @return The enum numeric value on the wire for industryCategory.
     */
    @java.lang.Override
    public int getIndustryCategoryValue() {
      if (categoryCase_ == 2) {
        return ((java.lang.Integer) category_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * The group of relevant businesses where this infoType is commonly used
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory industry_category = 2;</code>
     *
     * @param value The enum numeric value on the wire for industryCategory to set.
     * @return This builder for chaining.
     */
    public Builder setIndustryCategoryValue(int value) {
      categoryCase_ = 2;
      category_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The group of relevant businesses where this infoType is commonly used
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory industry_category = 2;</code>
     *
     * @return The industryCategory.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory getIndustryCategory() {
      if (categoryCase_ == 2) {
        com.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory result =
            com.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory.forNumber(
                (java.lang.Integer) category_);
        return result == null
            ? com.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory.UNRECOGNIZED
            : result;
      }
      return com.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory.INDUSTRY_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * The group of relevant businesses where this infoType is commonly used
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory industry_category = 2;</code>
     *
     * @param value The industryCategory to set.
     * @return This builder for chaining.
     */
    public Builder setIndustryCategory(
        com.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory value) {
      if (value == null) {
        throw new NullPointerException();
      }
      categoryCase_ = 2;
      category_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The group of relevant businesses where this infoType is commonly used
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.IndustryCategory industry_category = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndustryCategory() {
      if (categoryCase_ == 2) {
        categoryCase_ = 0;
        category_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The class of identifiers where this infoType belongs
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory type_category = 3;</code>
     *
     * @return Whether the typeCategory field is set.
     */
    @java.lang.Override
    public boolean hasTypeCategory() {
      return categoryCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The class of identifiers where this infoType belongs
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory type_category = 3;</code>
     *
     * @return The enum numeric value on the wire for typeCategory.
     */
    @java.lang.Override
    public int getTypeCategoryValue() {
      if (categoryCase_ == 3) {
        return ((java.lang.Integer) category_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * The class of identifiers where this infoType belongs
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory type_category = 3;</code>
     *
     * @param value The enum numeric value on the wire for typeCategory to set.
     * @return This builder for chaining.
     */
    public Builder setTypeCategoryValue(int value) {
      categoryCase_ = 3;
      category_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The class of identifiers where this infoType belongs
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory type_category = 3;</code>
     *
     * @return The typeCategory.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory getTypeCategory() {
      if (categoryCase_ == 3) {
        com.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory result =
            com.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory.forNumber(
                (java.lang.Integer) category_);
        return result == null
            ? com.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory.UNRECOGNIZED
            : result;
      }
      return com.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory.TYPE_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * The class of identifiers where this infoType belongs
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory type_category = 3;</code>
     *
     * @param value The typeCategory to set.
     * @return This builder for chaining.
     */
    public Builder setTypeCategory(com.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory value) {
      if (value == null) {
        throw new NullPointerException();
      }
      categoryCase_ = 3;
      category_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The class of identifiers where this infoType belongs
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeCategory.TypeCategory type_category = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTypeCategory() {
      if (categoryCase_ == 3) {
        categoryCase_ = 0;
        category_ = null;
        onChanged();
      }
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.InfoTypeCategory)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.InfoTypeCategory)
  private static final com.google.privacy.dlp.v2.InfoTypeCategory DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.InfoTypeCategory();
  }

  public static com.google.privacy.dlp.v2.InfoTypeCategory getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InfoTypeCategory> PARSER =
      new com.google.protobuf.AbstractParser<InfoTypeCategory>() {
        @java.lang.Override
        public InfoTypeCategory parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InfoTypeCategory> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InfoTypeCategory> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeCategory getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
