/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * InfoType description.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.InfoTypeDescription}
 */
public final class InfoTypeDescription extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.InfoTypeDescription)
    InfoTypeDescriptionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InfoTypeDescription.newBuilder() to construct.
  private InfoTypeDescription(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InfoTypeDescription() {
    name_ = "";
    displayName_ = "";
    supportedBy_ = java.util.Collections.emptyList();
    description_ = "";
    versions_ = java.util.Collections.emptyList();
    categories_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InfoTypeDescription();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_InfoTypeDescription_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_InfoTypeDescription_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.InfoTypeDescription.class,
            com.google.privacy.dlp.v2.InfoTypeDescription.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Internal name of the infoType.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Internal name of the infoType.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Human readable form of the infoType name.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Human readable form of the infoType name.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUPPORTED_BY_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> supportedBy_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.privacy.dlp.v2.InfoTypeSupportedBy>
      supportedBy_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.privacy.dlp.v2.InfoTypeSupportedBy>() {
            public com.google.privacy.dlp.v2.InfoTypeSupportedBy convert(java.lang.Integer from) {
              com.google.privacy.dlp.v2.InfoTypeSupportedBy result =
                  com.google.privacy.dlp.v2.InfoTypeSupportedBy.forNumber(from);
              return result == null
                  ? com.google.privacy.dlp.v2.InfoTypeSupportedBy.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Which parts of the API supports this InfoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
   *
   * @return A list containing the supportedBy.
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.InfoTypeSupportedBy> getSupportedByList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.privacy.dlp.v2.InfoTypeSupportedBy>(
        supportedBy_, supportedBy_converter_);
  }
  /**
   *
   *
   * <pre>
   * Which parts of the API supports this InfoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
   *
   * @return The count of supportedBy.
   */
  @java.lang.Override
  public int getSupportedByCount() {
    return supportedBy_.size();
  }
  /**
   *
   *
   * <pre>
   * Which parts of the API supports this InfoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The supportedBy at the given index.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeSupportedBy getSupportedBy(int index) {
    return supportedBy_converter_.convert(supportedBy_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Which parts of the API supports this InfoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
   *
   * @return A list containing the enum numeric values on the wire for supportedBy.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSupportedByValueList() {
    return supportedBy_;
  }
  /**
   *
   *
   * <pre>
   * Which parts of the API supports this InfoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of supportedBy at the given index.
   */
  @java.lang.Override
  public int getSupportedByValue(int index) {
    return supportedBy_.get(index);
  }

  private int supportedByMemoizedSerializedSize;

  public static final int DESCRIPTION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Description of the infotype. Translated when language is provided in the
   * request.
   * </pre>
   *
   * <code>string description = 4;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Description of the infotype. Translated when language is provided in the
   * request.
   * </pre>
   *
   * <code>string description = 4;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSIONS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.VersionDescription> versions_;
  /**
   *
   *
   * <pre>
   * A list of available versions for the infotype.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.VersionDescription> getVersionsList() {
    return versions_;
  }
  /**
   *
   *
   * <pre>
   * A list of available versions for the infotype.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.VersionDescriptionOrBuilder>
      getVersionsOrBuilderList() {
    return versions_;
  }
  /**
   *
   *
   * <pre>
   * A list of available versions for the infotype.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
   */
  @java.lang.Override
  public int getVersionsCount() {
    return versions_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of available versions for the infotype.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.VersionDescription getVersions(int index) {
    return versions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of available versions for the infotype.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.VersionDescriptionOrBuilder getVersionsOrBuilder(int index) {
    return versions_.get(index);
  }

  public static final int CATEGORIES_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.InfoTypeCategory> categories_;
  /**
   *
   *
   * <pre>
   * The category of the infoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.InfoTypeCategory> getCategoriesList() {
    return categories_;
  }
  /**
   *
   *
   * <pre>
   * The category of the infoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.InfoTypeCategoryOrBuilder>
      getCategoriesOrBuilderList() {
    return categories_;
  }
  /**
   *
   *
   * <pre>
   * The category of the infoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
   */
  @java.lang.Override
  public int getCategoriesCount() {
    return categories_.size();
  }
  /**
   *
   *
   * <pre>
   * The category of the infoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeCategory getCategories(int index) {
    return categories_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The category of the infoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeCategoryOrBuilder getCategoriesOrBuilder(int index) {
    return categories_.get(index);
  }

  public static final int SENSITIVITY_SCORE_FIELD_NUMBER = 11;
  private com.google.privacy.dlp.v2.SensitivityScore sensitivityScore_;
  /**
   *
   *
   * <pre>
   * The default sensitivity of the infoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 11;</code>
   *
   * @return Whether the sensitivityScore field is set.
   */
  @java.lang.Override
  public boolean hasSensitivityScore() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The default sensitivity of the infoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 11;</code>
   *
   * @return The sensitivityScore.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.SensitivityScore getSensitivityScore() {
    return sensitivityScore_ == null
        ? com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()
        : sensitivityScore_;
  }
  /**
   *
   *
   * <pre>
   * The default sensitivity of the infoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 11;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.SensitivityScoreOrBuilder getSensitivityScoreOrBuilder() {
    return sensitivityScore_ == null
        ? com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()
        : sensitivityScore_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (getSupportedByList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(supportedByMemoizedSerializedSize);
    }
    for (int i = 0; i < supportedBy_.size(); i++) {
      output.writeEnumNoTag(supportedBy_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, description_);
    }
    for (int i = 0; i < versions_.size(); i++) {
      output.writeMessage(9, versions_.get(i));
    }
    for (int i = 0; i < categories_.size(); i++) {
      output.writeMessage(10, categories_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(11, getSensitivityScore());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < supportedBy_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(supportedBy_.get(i));
      }
      size += dataSize;
      if (!getSupportedByList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      supportedByMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, description_);
    }
    for (int i = 0; i < versions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, versions_.get(i));
    }
    for (int i = 0; i < categories_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, categories_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getSensitivityScore());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.InfoTypeDescription)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.InfoTypeDescription other =
        (com.google.privacy.dlp.v2.InfoTypeDescription) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!supportedBy_.equals(other.supportedBy_)) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getVersionsList().equals(other.getVersionsList())) return false;
    if (!getCategoriesList().equals(other.getCategoriesList())) return false;
    if (hasSensitivityScore() != other.hasSensitivityScore()) return false;
    if (hasSensitivityScore()) {
      if (!getSensitivityScore().equals(other.getSensitivityScore())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (getSupportedByCount() > 0) {
      hash = (37 * hash) + SUPPORTED_BY_FIELD_NUMBER;
      hash = (53 * hash) + supportedBy_.hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getVersionsCount() > 0) {
      hash = (37 * hash) + VERSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getVersionsList().hashCode();
    }
    if (getCategoriesCount() > 0) {
      hash = (37 * hash) + CATEGORIES_FIELD_NUMBER;
      hash = (53 * hash) + getCategoriesList().hashCode();
    }
    if (hasSensitivityScore()) {
      hash = (37 * hash) + SENSITIVITY_SCORE_FIELD_NUMBER;
      hash = (53 * hash) + getSensitivityScore().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.InfoTypeDescription parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InfoTypeDescription parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InfoTypeDescription parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InfoTypeDescription parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InfoTypeDescription parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InfoTypeDescription parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InfoTypeDescription parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InfoTypeDescription parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InfoTypeDescription parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InfoTypeDescription parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InfoTypeDescription parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InfoTypeDescription parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.InfoTypeDescription prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * InfoType description.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.InfoTypeDescription}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.InfoTypeDescription)
      com.google.privacy.dlp.v2.InfoTypeDescriptionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InfoTypeDescription_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InfoTypeDescription_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.InfoTypeDescription.class,
              com.google.privacy.dlp.v2.InfoTypeDescription.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.InfoTypeDescription.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getVersionsFieldBuilder();
        getCategoriesFieldBuilder();
        getSensitivityScoreFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      supportedBy_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      description_ = "";
      if (versionsBuilder_ == null) {
        versions_ = java.util.Collections.emptyList();
      } else {
        versions_ = null;
        versionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (categoriesBuilder_ == null) {
        categories_ = java.util.Collections.emptyList();
      } else {
        categories_ = null;
        categoriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      sensitivityScore_ = null;
      if (sensitivityScoreBuilder_ != null) {
        sensitivityScoreBuilder_.dispose();
        sensitivityScoreBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InfoTypeDescription_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeDescription getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.InfoTypeDescription.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeDescription build() {
      com.google.privacy.dlp.v2.InfoTypeDescription result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeDescription buildPartial() {
      com.google.privacy.dlp.v2.InfoTypeDescription result =
          new com.google.privacy.dlp.v2.InfoTypeDescription(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.privacy.dlp.v2.InfoTypeDescription result) {
      if (((bitField0_ & 0x00000004) != 0)) {
        supportedBy_ = java.util.Collections.unmodifiableList(supportedBy_);
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.supportedBy_ = supportedBy_;
      if (versionsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          versions_ = java.util.Collections.unmodifiableList(versions_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.versions_ = versions_;
      } else {
        result.versions_ = versionsBuilder_.build();
      }
      if (categoriesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          categories_ = java.util.Collections.unmodifiableList(categories_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.categories_ = categories_;
      } else {
        result.categories_ = categoriesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.privacy.dlp.v2.InfoTypeDescription result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.sensitivityScore_ =
            sensitivityScoreBuilder_ == null ? sensitivityScore_ : sensitivityScoreBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.InfoTypeDescription) {
        return mergeFrom((com.google.privacy.dlp.v2.InfoTypeDescription) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.InfoTypeDescription other) {
      if (other == com.google.privacy.dlp.v2.InfoTypeDescription.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.supportedBy_.isEmpty()) {
        if (supportedBy_.isEmpty()) {
          supportedBy_ = other.supportedBy_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureSupportedByIsMutable();
          supportedBy_.addAll(other.supportedBy_);
        }
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (versionsBuilder_ == null) {
        if (!other.versions_.isEmpty()) {
          if (versions_.isEmpty()) {
            versions_ = other.versions_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureVersionsIsMutable();
            versions_.addAll(other.versions_);
          }
          onChanged();
        }
      } else {
        if (!other.versions_.isEmpty()) {
          if (versionsBuilder_.isEmpty()) {
            versionsBuilder_.dispose();
            versionsBuilder_ = null;
            versions_ = other.versions_;
            bitField0_ = (bitField0_ & ~0x00000010);
            versionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVersionsFieldBuilder()
                    : null;
          } else {
            versionsBuilder_.addAllMessages(other.versions_);
          }
        }
      }
      if (categoriesBuilder_ == null) {
        if (!other.categories_.isEmpty()) {
          if (categories_.isEmpty()) {
            categories_ = other.categories_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureCategoriesIsMutable();
            categories_.addAll(other.categories_);
          }
          onChanged();
        }
      } else {
        if (!other.categories_.isEmpty()) {
          if (categoriesBuilder_.isEmpty()) {
            categoriesBuilder_.dispose();
            categoriesBuilder_ = null;
            categories_ = other.categories_;
            bitField0_ = (bitField0_ & ~0x00000020);
            categoriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCategoriesFieldBuilder()
                    : null;
          } else {
            categoriesBuilder_.addAllMessages(other.categories_);
          }
        }
      }
      if (other.hasSensitivityScore()) {
        mergeSensitivityScore(other.getSensitivityScore());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                int tmpRaw = input.readEnum();
                ensureSupportedByIsMutable();
                supportedBy_.add(tmpRaw);
                break;
              } // case 24
            case 26:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureSupportedByIsMutable();
                  supportedBy_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 26
            case 34:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 74:
              {
                com.google.privacy.dlp.v2.VersionDescription m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.VersionDescription.parser(), extensionRegistry);
                if (versionsBuilder_ == null) {
                  ensureVersionsIsMutable();
                  versions_.add(m);
                } else {
                  versionsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                com.google.privacy.dlp.v2.InfoTypeCategory m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.InfoTypeCategory.parser(), extensionRegistry);
                if (categoriesBuilder_ == null) {
                  ensureCategoriesIsMutable();
                  categories_.add(m);
                } else {
                  categoriesBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    getSensitivityScoreFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Internal name of the infoType.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Internal name of the infoType.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Internal name of the infoType.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Internal name of the infoType.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Internal name of the infoType.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Human readable form of the infoType name.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human readable form of the infoType name.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human readable form of the infoType name.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human readable form of the infoType name.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human readable form of the infoType name.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> supportedBy_ = java.util.Collections.emptyList();

    private void ensureSupportedByIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        supportedBy_ = new java.util.ArrayList<java.lang.Integer>(supportedBy_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * Which parts of the API supports this InfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
     *
     * @return A list containing the supportedBy.
     */
    public java.util.List<com.google.privacy.dlp.v2.InfoTypeSupportedBy> getSupportedByList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.privacy.dlp.v2.InfoTypeSupportedBy>(
          supportedBy_, supportedBy_converter_);
    }
    /**
     *
     *
     * <pre>
     * Which parts of the API supports this InfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
     *
     * @return The count of supportedBy.
     */
    public int getSupportedByCount() {
      return supportedBy_.size();
    }
    /**
     *
     *
     * <pre>
     * Which parts of the API supports this InfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The supportedBy at the given index.
     */
    public com.google.privacy.dlp.v2.InfoTypeSupportedBy getSupportedBy(int index) {
      return supportedBy_converter_.convert(supportedBy_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Which parts of the API supports this InfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The supportedBy to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedBy(int index, com.google.privacy.dlp.v2.InfoTypeSupportedBy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedByIsMutable();
      supportedBy_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which parts of the API supports this InfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
     *
     * @param value The supportedBy to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedBy(com.google.privacy.dlp.v2.InfoTypeSupportedBy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedByIsMutable();
      supportedBy_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which parts of the API supports this InfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
     *
     * @param values The supportedBy to add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedBy(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.InfoTypeSupportedBy> values) {
      ensureSupportedByIsMutable();
      for (com.google.privacy.dlp.v2.InfoTypeSupportedBy value : values) {
        supportedBy_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which parts of the API supports this InfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSupportedBy() {
      supportedBy_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which parts of the API supports this InfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
     *
     * @return A list containing the enum numeric values on the wire for supportedBy.
     */
    public java.util.List<java.lang.Integer> getSupportedByValueList() {
      return java.util.Collections.unmodifiableList(supportedBy_);
    }
    /**
     *
     *
     * <pre>
     * Which parts of the API supports this InfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of supportedBy at the given index.
     */
    public int getSupportedByValue(int index) {
      return supportedBy_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Which parts of the API supports this InfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for supportedBy to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedByValue(int index, int value) {
      ensureSupportedByIsMutable();
      supportedBy_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which parts of the API supports this InfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
     *
     * @param value The enum numeric value on the wire for supportedBy to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedByValue(int value) {
      ensureSupportedByIsMutable();
      supportedBy_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which parts of the API supports this InfoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSupportedBy supported_by = 3;</code>
     *
     * @param values The enum numeric values on the wire for supportedBy to add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedByValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureSupportedByIsMutable();
      for (int value : values) {
        supportedBy_.add(value);
      }
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Description of the infotype. Translated when language is provided in the
     * request.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the infotype. Translated when language is provided in the
     * request.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the infotype. Translated when language is provided in the
     * request.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the infotype. Translated when language is provided in the
     * request.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the infotype. Translated when language is provided in the
     * request.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<com.google.privacy.dlp.v2.VersionDescription> versions_ =
        java.util.Collections.emptyList();

    private void ensureVersionsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        versions_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.VersionDescription>(versions_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.VersionDescription,
            com.google.privacy.dlp.v2.VersionDescription.Builder,
            com.google.privacy.dlp.v2.VersionDescriptionOrBuilder>
        versionsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.VersionDescription> getVersionsList() {
      if (versionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(versions_);
      } else {
        return versionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public int getVersionsCount() {
      if (versionsBuilder_ == null) {
        return versions_.size();
      } else {
        return versionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public com.google.privacy.dlp.v2.VersionDescription getVersions(int index) {
      if (versionsBuilder_ == null) {
        return versions_.get(index);
      } else {
        return versionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public Builder setVersions(int index, com.google.privacy.dlp.v2.VersionDescription value) {
      if (versionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVersionsIsMutable();
        versions_.set(index, value);
        onChanged();
      } else {
        versionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public Builder setVersions(
        int index, com.google.privacy.dlp.v2.VersionDescription.Builder builderForValue) {
      if (versionsBuilder_ == null) {
        ensureVersionsIsMutable();
        versions_.set(index, builderForValue.build());
        onChanged();
      } else {
        versionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public Builder addVersions(com.google.privacy.dlp.v2.VersionDescription value) {
      if (versionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVersionsIsMutable();
        versions_.add(value);
        onChanged();
      } else {
        versionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public Builder addVersions(int index, com.google.privacy.dlp.v2.VersionDescription value) {
      if (versionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVersionsIsMutable();
        versions_.add(index, value);
        onChanged();
      } else {
        versionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public Builder addVersions(
        com.google.privacy.dlp.v2.VersionDescription.Builder builderForValue) {
      if (versionsBuilder_ == null) {
        ensureVersionsIsMutable();
        versions_.add(builderForValue.build());
        onChanged();
      } else {
        versionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public Builder addVersions(
        int index, com.google.privacy.dlp.v2.VersionDescription.Builder builderForValue) {
      if (versionsBuilder_ == null) {
        ensureVersionsIsMutable();
        versions_.add(index, builderForValue.build());
        onChanged();
      } else {
        versionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public Builder addAllVersions(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.VersionDescription> values) {
      if (versionsBuilder_ == null) {
        ensureVersionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, versions_);
        onChanged();
      } else {
        versionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public Builder clearVersions() {
      if (versionsBuilder_ == null) {
        versions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        versionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public Builder removeVersions(int index) {
      if (versionsBuilder_ == null) {
        ensureVersionsIsMutable();
        versions_.remove(index);
        onChanged();
      } else {
        versionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public com.google.privacy.dlp.v2.VersionDescription.Builder getVersionsBuilder(int index) {
      return getVersionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public com.google.privacy.dlp.v2.VersionDescriptionOrBuilder getVersionsOrBuilder(int index) {
      if (versionsBuilder_ == null) {
        return versions_.get(index);
      } else {
        return versionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.VersionDescriptionOrBuilder>
        getVersionsOrBuilderList() {
      if (versionsBuilder_ != null) {
        return versionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(versions_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public com.google.privacy.dlp.v2.VersionDescription.Builder addVersionsBuilder() {
      return getVersionsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.VersionDescription.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public com.google.privacy.dlp.v2.VersionDescription.Builder addVersionsBuilder(int index) {
      return getVersionsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.VersionDescription.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of available versions for the infotype.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.VersionDescription versions = 9;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.VersionDescription.Builder>
        getVersionsBuilderList() {
      return getVersionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.VersionDescription,
            com.google.privacy.dlp.v2.VersionDescription.Builder,
            com.google.privacy.dlp.v2.VersionDescriptionOrBuilder>
        getVersionsFieldBuilder() {
      if (versionsBuilder_ == null) {
        versionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.VersionDescription,
                com.google.privacy.dlp.v2.VersionDescription.Builder,
                com.google.privacy.dlp.v2.VersionDescriptionOrBuilder>(
                versions_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        versions_ = null;
      }
      return versionsBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.InfoTypeCategory> categories_ =
        java.util.Collections.emptyList();

    private void ensureCategoriesIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        categories_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.InfoTypeCategory>(categories_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoTypeCategory,
            com.google.privacy.dlp.v2.InfoTypeCategory.Builder,
            com.google.privacy.dlp.v2.InfoTypeCategoryOrBuilder>
        categoriesBuilder_;

    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.InfoTypeCategory> getCategoriesList() {
      if (categoriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(categories_);
      } else {
        return categoriesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public int getCategoriesCount() {
      if (categoriesBuilder_ == null) {
        return categories_.size();
      } else {
        return categoriesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeCategory getCategories(int index) {
      if (categoriesBuilder_ == null) {
        return categories_.get(index);
      } else {
        return categoriesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public Builder setCategories(int index, com.google.privacy.dlp.v2.InfoTypeCategory value) {
      if (categoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCategoriesIsMutable();
        categories_.set(index, value);
        onChanged();
      } else {
        categoriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public Builder setCategories(
        int index, com.google.privacy.dlp.v2.InfoTypeCategory.Builder builderForValue) {
      if (categoriesBuilder_ == null) {
        ensureCategoriesIsMutable();
        categories_.set(index, builderForValue.build());
        onChanged();
      } else {
        categoriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public Builder addCategories(com.google.privacy.dlp.v2.InfoTypeCategory value) {
      if (categoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCategoriesIsMutable();
        categories_.add(value);
        onChanged();
      } else {
        categoriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public Builder addCategories(int index, com.google.privacy.dlp.v2.InfoTypeCategory value) {
      if (categoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCategoriesIsMutable();
        categories_.add(index, value);
        onChanged();
      } else {
        categoriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public Builder addCategories(
        com.google.privacy.dlp.v2.InfoTypeCategory.Builder builderForValue) {
      if (categoriesBuilder_ == null) {
        ensureCategoriesIsMutable();
        categories_.add(builderForValue.build());
        onChanged();
      } else {
        categoriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public Builder addCategories(
        int index, com.google.privacy.dlp.v2.InfoTypeCategory.Builder builderForValue) {
      if (categoriesBuilder_ == null) {
        ensureCategoriesIsMutable();
        categories_.add(index, builderForValue.build());
        onChanged();
      } else {
        categoriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public Builder addAllCategories(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.InfoTypeCategory> values) {
      if (categoriesBuilder_ == null) {
        ensureCategoriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, categories_);
        onChanged();
      } else {
        categoriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public Builder clearCategories() {
      if (categoriesBuilder_ == null) {
        categories_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        categoriesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public Builder removeCategories(int index) {
      if (categoriesBuilder_ == null) {
        ensureCategoriesIsMutable();
        categories_.remove(index);
        onChanged();
      } else {
        categoriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeCategory.Builder getCategoriesBuilder(int index) {
      return getCategoriesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeCategoryOrBuilder getCategoriesOrBuilder(int index) {
      if (categoriesBuilder_ == null) {
        return categories_.get(index);
      } else {
        return categoriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.InfoTypeCategoryOrBuilder>
        getCategoriesOrBuilderList() {
      if (categoriesBuilder_ != null) {
        return categoriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(categories_);
      }
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeCategory.Builder addCategoriesBuilder() {
      return getCategoriesFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.InfoTypeCategory.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeCategory.Builder addCategoriesBuilder(int index) {
      return getCategoriesFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.InfoTypeCategory.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The category of the infoType.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeCategory categories = 10;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.InfoTypeCategory.Builder>
        getCategoriesBuilderList() {
      return getCategoriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoTypeCategory,
            com.google.privacy.dlp.v2.InfoTypeCategory.Builder,
            com.google.privacy.dlp.v2.InfoTypeCategoryOrBuilder>
        getCategoriesFieldBuilder() {
      if (categoriesBuilder_ == null) {
        categoriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.InfoTypeCategory,
                com.google.privacy.dlp.v2.InfoTypeCategory.Builder,
                com.google.privacy.dlp.v2.InfoTypeCategoryOrBuilder>(
                categories_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        categories_ = null;
      }
      return categoriesBuilder_;
    }

    private com.google.privacy.dlp.v2.SensitivityScore sensitivityScore_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.SensitivityScore,
            com.google.privacy.dlp.v2.SensitivityScore.Builder,
            com.google.privacy.dlp.v2.SensitivityScoreOrBuilder>
        sensitivityScoreBuilder_;
    /**
     *
     *
     * <pre>
     * The default sensitivity of the infoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 11;</code>
     *
     * @return Whether the sensitivityScore field is set.
     */
    public boolean hasSensitivityScore() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The default sensitivity of the infoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 11;</code>
     *
     * @return The sensitivityScore.
     */
    public com.google.privacy.dlp.v2.SensitivityScore getSensitivityScore() {
      if (sensitivityScoreBuilder_ == null) {
        return sensitivityScore_ == null
            ? com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()
            : sensitivityScore_;
      } else {
        return sensitivityScoreBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The default sensitivity of the infoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 11;</code>
     */
    public Builder setSensitivityScore(com.google.privacy.dlp.v2.SensitivityScore value) {
      if (sensitivityScoreBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sensitivityScore_ = value;
      } else {
        sensitivityScoreBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default sensitivity of the infoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 11;</code>
     */
    public Builder setSensitivityScore(
        com.google.privacy.dlp.v2.SensitivityScore.Builder builderForValue) {
      if (sensitivityScoreBuilder_ == null) {
        sensitivityScore_ = builderForValue.build();
      } else {
        sensitivityScoreBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default sensitivity of the infoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 11;</code>
     */
    public Builder mergeSensitivityScore(com.google.privacy.dlp.v2.SensitivityScore value) {
      if (sensitivityScoreBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && sensitivityScore_ != null
            && sensitivityScore_
                != com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()) {
          getSensitivityScoreBuilder().mergeFrom(value);
        } else {
          sensitivityScore_ = value;
        }
      } else {
        sensitivityScoreBuilder_.mergeFrom(value);
      }
      if (sensitivityScore_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default sensitivity of the infoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 11;</code>
     */
    public Builder clearSensitivityScore() {
      bitField0_ = (bitField0_ & ~0x00000040);
      sensitivityScore_ = null;
      if (sensitivityScoreBuilder_ != null) {
        sensitivityScoreBuilder_.dispose();
        sensitivityScoreBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default sensitivity of the infoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 11;</code>
     */
    public com.google.privacy.dlp.v2.SensitivityScore.Builder getSensitivityScoreBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getSensitivityScoreFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The default sensitivity of the infoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 11;</code>
     */
    public com.google.privacy.dlp.v2.SensitivityScoreOrBuilder getSensitivityScoreOrBuilder() {
      if (sensitivityScoreBuilder_ != null) {
        return sensitivityScoreBuilder_.getMessageOrBuilder();
      } else {
        return sensitivityScore_ == null
            ? com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()
            : sensitivityScore_;
      }
    }
    /**
     *
     *
     * <pre>
     * The default sensitivity of the infoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.SensitivityScore,
            com.google.privacy.dlp.v2.SensitivityScore.Builder,
            com.google.privacy.dlp.v2.SensitivityScoreOrBuilder>
        getSensitivityScoreFieldBuilder() {
      if (sensitivityScoreBuilder_ == null) {
        sensitivityScoreBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.SensitivityScore,
                com.google.privacy.dlp.v2.SensitivityScore.Builder,
                com.google.privacy.dlp.v2.SensitivityScoreOrBuilder>(
                getSensitivityScore(), getParentForChildren(), isClean());
        sensitivityScore_ = null;
      }
      return sensitivityScoreBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.InfoTypeDescription)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.InfoTypeDescription)
  private static final com.google.privacy.dlp.v2.InfoTypeDescription DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.InfoTypeDescription();
  }

  public static com.google.privacy.dlp.v2.InfoTypeDescription getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InfoTypeDescription> PARSER =
      new com.google.protobuf.AbstractParser<InfoTypeDescription>() {
        @java.lang.Override
        public InfoTypeDescription parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InfoTypeDescription> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InfoTypeDescription> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeDescription getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
