/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * A type of transformation that will scan unstructured text and
 * apply various `PrimitiveTransformation`s to each finding, where the
 * transformation is applied to only values that were identified as a specific
 * info_type.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.InfoTypeTransformations}
 */
public final class InfoTypeTransformations extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.InfoTypeTransformations)
    InfoTypeTransformationsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InfoTypeTransformations.newBuilder() to construct.
  private InfoTypeTransformations(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InfoTypeTransformations() {
    transformations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InfoTypeTransformations();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_InfoTypeTransformations_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_InfoTypeTransformations_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.InfoTypeTransformations.class,
            com.google.privacy.dlp.v2.InfoTypeTransformations.Builder.class);
  }

  public interface InfoTypeTransformationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * InfoTypes to apply the transformation to. An empty list will cause
     * this transformation to apply to all findings that correspond to
     * infoTypes that were requested in `InspectConfig`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    java.util.List<com.google.privacy.dlp.v2.InfoType> getInfoTypesList();
    /**
     *
     *
     * <pre>
     * InfoTypes to apply the transformation to. An empty list will cause
     * this transformation to apply to all findings that correspond to
     * infoTypes that were requested in `InspectConfig`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    com.google.privacy.dlp.v2.InfoType getInfoTypes(int index);
    /**
     *
     *
     * <pre>
     * InfoTypes to apply the transformation to. An empty list will cause
     * this transformation to apply to all findings that correspond to
     * infoTypes that were requested in `InspectConfig`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    int getInfoTypesCount();
    /**
     *
     *
     * <pre>
     * InfoTypes to apply the transformation to. An empty list will cause
     * this transformation to apply to all findings that correspond to
     * infoTypes that were requested in `InspectConfig`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    java.util.List<? extends com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        getInfoTypesOrBuilderList();
    /**
     *
     *
     * <pre>
     * InfoTypes to apply the transformation to. An empty list will cause
     * this transformation to apply to all findings that correspond to
     * infoTypes that were requested in `InspectConfig`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Required. Primitive transformation to apply to the infoType.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the primitiveTransformation field is set.
     */
    boolean hasPrimitiveTransformation();
    /**
     *
     *
     * <pre>
     * Required. Primitive transformation to apply to the infoType.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The primitiveTransformation.
     */
    com.google.privacy.dlp.v2.PrimitiveTransformation getPrimitiveTransformation();
    /**
     *
     *
     * <pre>
     * Required. Primitive transformation to apply to the infoType.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder
        getPrimitiveTransformationOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A transformation to apply to text that is identified as a specific
   * info_type.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation}
   */
  public static final class InfoTypeTransformation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation)
      InfoTypeTransformationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InfoTypeTransformation.newBuilder() to construct.
    private InfoTypeTransformation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InfoTypeTransformation() {
      infoTypes_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InfoTypeTransformation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InfoTypeTransformations_InfoTypeTransformation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InfoTypeTransformations_InfoTypeTransformation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.class,
              com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.Builder
                  .class);
    }

    private int bitField0_;
    public static final int INFO_TYPES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.privacy.dlp.v2.InfoType> infoTypes_;
    /**
     *
     *
     * <pre>
     * InfoTypes to apply the transformation to. An empty list will cause
     * this transformation to apply to all findings that correspond to
     * infoTypes that were requested in `InspectConfig`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.privacy.dlp.v2.InfoType> getInfoTypesList() {
      return infoTypes_;
    }
    /**
     *
     *
     * <pre>
     * InfoTypes to apply the transformation to. An empty list will cause
     * this transformation to apply to all findings that correspond to
     * infoTypes that were requested in `InspectConfig`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        getInfoTypesOrBuilderList() {
      return infoTypes_;
    }
    /**
     *
     *
     * <pre>
     * InfoTypes to apply the transformation to. An empty list will cause
     * this transformation to apply to all findings that correspond to
     * infoTypes that were requested in `InspectConfig`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    @java.lang.Override
    public int getInfoTypesCount() {
      return infoTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * InfoTypes to apply the transformation to. An empty list will cause
     * this transformation to apply to all findings that correspond to
     * infoTypes that were requested in `InspectConfig`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoType getInfoTypes(int index) {
      return infoTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * InfoTypes to apply the transformation to. An empty list will cause
     * this transformation to apply to all findings that correspond to
     * infoTypes that were requested in `InspectConfig`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypesOrBuilder(int index) {
      return infoTypes_.get(index);
    }

    public static final int PRIMITIVE_TRANSFORMATION_FIELD_NUMBER = 2;
    private com.google.privacy.dlp.v2.PrimitiveTransformation primitiveTransformation_;
    /**
     *
     *
     * <pre>
     * Required. Primitive transformation to apply to the infoType.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the primitiveTransformation field is set.
     */
    @java.lang.Override
    public boolean hasPrimitiveTransformation() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Primitive transformation to apply to the infoType.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The primitiveTransformation.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.PrimitiveTransformation getPrimitiveTransformation() {
      return primitiveTransformation_ == null
          ? com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance()
          : primitiveTransformation_;
    }
    /**
     *
     *
     * <pre>
     * Required. Primitive transformation to apply to the infoType.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder
        getPrimitiveTransformationOrBuilder() {
      return primitiveTransformation_ == null
          ? com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance()
          : primitiveTransformation_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < infoTypes_.size(); i++) {
        output.writeMessage(1, infoTypes_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getPrimitiveTransformation());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < infoTypes_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, infoTypes_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, getPrimitiveTransformation());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation other =
          (com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation) obj;

      if (!getInfoTypesList().equals(other.getInfoTypesList())) return false;
      if (hasPrimitiveTransformation() != other.hasPrimitiveTransformation()) return false;
      if (hasPrimitiveTransformation()) {
        if (!getPrimitiveTransformation().equals(other.getPrimitiveTransformation())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getInfoTypesCount() > 0) {
        hash = (37 * hash) + INFO_TYPES_FIELD_NUMBER;
        hash = (53 * hash) + getInfoTypesList().hashCode();
      }
      if (hasPrimitiveTransformation()) {
        hash = (37 * hash) + PRIMITIVE_TRANSFORMATION_FIELD_NUMBER;
        hash = (53 * hash) + getPrimitiveTransformation().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A transformation to apply to text that is identified as a specific
     * info_type.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation)
        com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_InfoTypeTransformations_InfoTypeTransformation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_InfoTypeTransformations_InfoTypeTransformation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.class,
                com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.Builder
                    .class);
      }

      // Construct using
      // com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getInfoTypesFieldBuilder();
          getPrimitiveTransformationFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (infoTypesBuilder_ == null) {
          infoTypes_ = java.util.Collections.emptyList();
        } else {
          infoTypes_ = null;
          infoTypesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        primitiveTransformation_ = null;
        if (primitiveTransformationBuilder_ != null) {
          primitiveTransformationBuilder_.dispose();
          primitiveTransformationBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_InfoTypeTransformations_InfoTypeTransformation_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
          getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation build() {
        com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
          buildPartial() {
        com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation result =
            new com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation result) {
        if (infoTypesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            infoTypes_ = java.util.Collections.unmodifiableList(infoTypes_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.infoTypes_ = infoTypes_;
        } else {
          result.infoTypes_ = infoTypesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.primitiveTransformation_ =
              primitiveTransformationBuilder_ == null
                  ? primitiveTransformation_
                  : primitiveTransformationBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation) {
          return mergeFrom(
              (com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation other) {
        if (other
            == com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
                .getDefaultInstance()) return this;
        if (infoTypesBuilder_ == null) {
          if (!other.infoTypes_.isEmpty()) {
            if (infoTypes_.isEmpty()) {
              infoTypes_ = other.infoTypes_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureInfoTypesIsMutable();
              infoTypes_.addAll(other.infoTypes_);
            }
            onChanged();
          }
        } else {
          if (!other.infoTypes_.isEmpty()) {
            if (infoTypesBuilder_.isEmpty()) {
              infoTypesBuilder_.dispose();
              infoTypesBuilder_ = null;
              infoTypes_ = other.infoTypes_;
              bitField0_ = (bitField0_ & ~0x00000001);
              infoTypesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getInfoTypesFieldBuilder()
                      : null;
            } else {
              infoTypesBuilder_.addAllMessages(other.infoTypes_);
            }
          }
        }
        if (other.hasPrimitiveTransformation()) {
          mergePrimitiveTransformation(other.getPrimitiveTransformation());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.privacy.dlp.v2.InfoType m =
                      input.readMessage(
                          com.google.privacy.dlp.v2.InfoType.parser(), extensionRegistry);
                  if (infoTypesBuilder_ == null) {
                    ensureInfoTypesIsMutable();
                    infoTypes_.add(m);
                  } else {
                    infoTypesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getPrimitiveTransformationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.privacy.dlp.v2.InfoType> infoTypes_ =
          java.util.Collections.emptyList();

      private void ensureInfoTypesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          infoTypes_ = new java.util.ArrayList<com.google.privacy.dlp.v2.InfoType>(infoTypes_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.privacy.dlp.v2.InfoType,
              com.google.privacy.dlp.v2.InfoType.Builder,
              com.google.privacy.dlp.v2.InfoTypeOrBuilder>
          infoTypesBuilder_;

      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public java.util.List<com.google.privacy.dlp.v2.InfoType> getInfoTypesList() {
        if (infoTypesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(infoTypes_);
        } else {
          return infoTypesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public int getInfoTypesCount() {
        if (infoTypesBuilder_ == null) {
          return infoTypes_.size();
        } else {
          return infoTypesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public com.google.privacy.dlp.v2.InfoType getInfoTypes(int index) {
        if (infoTypesBuilder_ == null) {
          return infoTypes_.get(index);
        } else {
          return infoTypesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public Builder setInfoTypes(int index, com.google.privacy.dlp.v2.InfoType value) {
        if (infoTypesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInfoTypesIsMutable();
          infoTypes_.set(index, value);
          onChanged();
        } else {
          infoTypesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public Builder setInfoTypes(
          int index, com.google.privacy.dlp.v2.InfoType.Builder builderForValue) {
        if (infoTypesBuilder_ == null) {
          ensureInfoTypesIsMutable();
          infoTypes_.set(index, builderForValue.build());
          onChanged();
        } else {
          infoTypesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public Builder addInfoTypes(com.google.privacy.dlp.v2.InfoType value) {
        if (infoTypesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInfoTypesIsMutable();
          infoTypes_.add(value);
          onChanged();
        } else {
          infoTypesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public Builder addInfoTypes(int index, com.google.privacy.dlp.v2.InfoType value) {
        if (infoTypesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInfoTypesIsMutable();
          infoTypes_.add(index, value);
          onChanged();
        } else {
          infoTypesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public Builder addInfoTypes(com.google.privacy.dlp.v2.InfoType.Builder builderForValue) {
        if (infoTypesBuilder_ == null) {
          ensureInfoTypesIsMutable();
          infoTypes_.add(builderForValue.build());
          onChanged();
        } else {
          infoTypesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public Builder addInfoTypes(
          int index, com.google.privacy.dlp.v2.InfoType.Builder builderForValue) {
        if (infoTypesBuilder_ == null) {
          ensureInfoTypesIsMutable();
          infoTypes_.add(index, builderForValue.build());
          onChanged();
        } else {
          infoTypesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public Builder addAllInfoTypes(
          java.lang.Iterable<? extends com.google.privacy.dlp.v2.InfoType> values) {
        if (infoTypesBuilder_ == null) {
          ensureInfoTypesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, infoTypes_);
          onChanged();
        } else {
          infoTypesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public Builder clearInfoTypes() {
        if (infoTypesBuilder_ == null) {
          infoTypes_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          infoTypesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public Builder removeInfoTypes(int index) {
        if (infoTypesBuilder_ == null) {
          ensureInfoTypesIsMutable();
          infoTypes_.remove(index);
          onChanged();
        } else {
          infoTypesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public com.google.privacy.dlp.v2.InfoType.Builder getInfoTypesBuilder(int index) {
        return getInfoTypesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypesOrBuilder(int index) {
        if (infoTypesBuilder_ == null) {
          return infoTypes_.get(index);
        } else {
          return infoTypesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public java.util.List<? extends com.google.privacy.dlp.v2.InfoTypeOrBuilder>
          getInfoTypesOrBuilderList() {
        if (infoTypesBuilder_ != null) {
          return infoTypesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(infoTypes_);
        }
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public com.google.privacy.dlp.v2.InfoType.Builder addInfoTypesBuilder() {
        return getInfoTypesFieldBuilder()
            .addBuilder(com.google.privacy.dlp.v2.InfoType.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public com.google.privacy.dlp.v2.InfoType.Builder addInfoTypesBuilder(int index) {
        return getInfoTypesFieldBuilder()
            .addBuilder(index, com.google.privacy.dlp.v2.InfoType.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * InfoTypes to apply the transformation to. An empty list will cause
       * this transformation to apply to all findings that correspond to
       * infoTypes that were requested in `InspectConfig`.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
       */
      public java.util.List<com.google.privacy.dlp.v2.InfoType.Builder> getInfoTypesBuilderList() {
        return getInfoTypesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.privacy.dlp.v2.InfoType,
              com.google.privacy.dlp.v2.InfoType.Builder,
              com.google.privacy.dlp.v2.InfoTypeOrBuilder>
          getInfoTypesFieldBuilder() {
        if (infoTypesBuilder_ == null) {
          infoTypesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.privacy.dlp.v2.InfoType,
                  com.google.privacy.dlp.v2.InfoType.Builder,
                  com.google.privacy.dlp.v2.InfoTypeOrBuilder>(
                  infoTypes_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          infoTypes_ = null;
        }
        return infoTypesBuilder_;
      }

      private com.google.privacy.dlp.v2.PrimitiveTransformation primitiveTransformation_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.PrimitiveTransformation,
              com.google.privacy.dlp.v2.PrimitiveTransformation.Builder,
              com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder>
          primitiveTransformationBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Primitive transformation to apply to the infoType.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the primitiveTransformation field is set.
       */
      public boolean hasPrimitiveTransformation() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Primitive transformation to apply to the infoType.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The primitiveTransformation.
       */
      public com.google.privacy.dlp.v2.PrimitiveTransformation getPrimitiveTransformation() {
        if (primitiveTransformationBuilder_ == null) {
          return primitiveTransformation_ == null
              ? com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance()
              : primitiveTransformation_;
        } else {
          return primitiveTransformationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Primitive transformation to apply to the infoType.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setPrimitiveTransformation(
          com.google.privacy.dlp.v2.PrimitiveTransformation value) {
        if (primitiveTransformationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          primitiveTransformation_ = value;
        } else {
          primitiveTransformationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Primitive transformation to apply to the infoType.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setPrimitiveTransformation(
          com.google.privacy.dlp.v2.PrimitiveTransformation.Builder builderForValue) {
        if (primitiveTransformationBuilder_ == null) {
          primitiveTransformation_ = builderForValue.build();
        } else {
          primitiveTransformationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Primitive transformation to apply to the infoType.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergePrimitiveTransformation(
          com.google.privacy.dlp.v2.PrimitiveTransformation value) {
        if (primitiveTransformationBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && primitiveTransformation_ != null
              && primitiveTransformation_
                  != com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance()) {
            getPrimitiveTransformationBuilder().mergeFrom(value);
          } else {
            primitiveTransformation_ = value;
          }
        } else {
          primitiveTransformationBuilder_.mergeFrom(value);
        }
        if (primitiveTransformation_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Primitive transformation to apply to the infoType.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearPrimitiveTransformation() {
        bitField0_ = (bitField0_ & ~0x00000002);
        primitiveTransformation_ = null;
        if (primitiveTransformationBuilder_ != null) {
          primitiveTransformationBuilder_.dispose();
          primitiveTransformationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Primitive transformation to apply to the infoType.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.privacy.dlp.v2.PrimitiveTransformation.Builder
          getPrimitiveTransformationBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getPrimitiveTransformationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Primitive transformation to apply to the infoType.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder
          getPrimitiveTransformationOrBuilder() {
        if (primitiveTransformationBuilder_ != null) {
          return primitiveTransformationBuilder_.getMessageOrBuilder();
        } else {
          return primitiveTransformation_ == null
              ? com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance()
              : primitiveTransformation_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Primitive transformation to apply to the infoType.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.PrimitiveTransformation primitive_transformation = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.PrimitiveTransformation,
              com.google.privacy.dlp.v2.PrimitiveTransformation.Builder,
              com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder>
          getPrimitiveTransformationFieldBuilder() {
        if (primitiveTransformationBuilder_ == null) {
          primitiveTransformationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.PrimitiveTransformation,
                  com.google.privacy.dlp.v2.PrimitiveTransformation.Builder,
                  com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder>(
                  getPrimitiveTransformation(), getParentForChildren(), isClean());
          primitiveTransformation_ = null;
        }
        return primitiveTransformationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation)
    private static final com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation();
    }

    public static com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InfoTypeTransformation> PARSER =
        new com.google.protobuf.AbstractParser<InfoTypeTransformation>() {
          @java.lang.Override
          public InfoTypeTransformation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InfoTypeTransformation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InfoTypeTransformation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int TRANSFORMATIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation>
      transformations_;
  /**
   *
   *
   * <pre>
   * Required. Transformation for each infoType. Cannot specify more than one
   * for a given infoType.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation>
      getTransformationsList() {
    return transformations_;
  }
  /**
   *
   *
   * <pre>
   * Required. Transformation for each infoType. Cannot specify more than one
   * for a given infoType.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformationOrBuilder>
      getTransformationsOrBuilderList() {
    return transformations_;
  }
  /**
   *
   *
   * <pre>
   * Required. Transformation for each infoType. Cannot specify more than one
   * for a given infoType.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getTransformationsCount() {
    return transformations_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Transformation for each infoType. Cannot specify more than one
   * for a given infoType.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
      getTransformations(int index) {
    return transformations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Transformation for each infoType. Cannot specify more than one
   * for a given infoType.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformationOrBuilder
      getTransformationsOrBuilder(int index) {
    return transformations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < transformations_.size(); i++) {
      output.writeMessage(1, transformations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < transformations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, transformations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.InfoTypeTransformations)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.InfoTypeTransformations other =
        (com.google.privacy.dlp.v2.InfoTypeTransformations) obj;

    if (!getTransformationsList().equals(other.getTransformationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getTransformationsCount() > 0) {
      hash = (37 * hash) + TRANSFORMATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getTransformationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.InfoTypeTransformations parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InfoTypeTransformations parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InfoTypeTransformations parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InfoTypeTransformations parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InfoTypeTransformations parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InfoTypeTransformations parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InfoTypeTransformations parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InfoTypeTransformations parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InfoTypeTransformations parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InfoTypeTransformations parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InfoTypeTransformations parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InfoTypeTransformations parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.InfoTypeTransformations prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A type of transformation that will scan unstructured text and
   * apply various `PrimitiveTransformation`s to each finding, where the
   * transformation is applied to only values that were identified as a specific
   * info_type.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.InfoTypeTransformations}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.InfoTypeTransformations)
      com.google.privacy.dlp.v2.InfoTypeTransformationsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InfoTypeTransformations_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InfoTypeTransformations_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.InfoTypeTransformations.class,
              com.google.privacy.dlp.v2.InfoTypeTransformations.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.InfoTypeTransformations.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (transformationsBuilder_ == null) {
        transformations_ = java.util.Collections.emptyList();
      } else {
        transformations_ = null;
        transformationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InfoTypeTransformations_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeTransformations getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.InfoTypeTransformations.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeTransformations build() {
      com.google.privacy.dlp.v2.InfoTypeTransformations result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeTransformations buildPartial() {
      com.google.privacy.dlp.v2.InfoTypeTransformations result =
          new com.google.privacy.dlp.v2.InfoTypeTransformations(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.privacy.dlp.v2.InfoTypeTransformations result) {
      if (transformationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          transformations_ = java.util.Collections.unmodifiableList(transformations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.transformations_ = transformations_;
      } else {
        result.transformations_ = transformationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.privacy.dlp.v2.InfoTypeTransformations result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.InfoTypeTransformations) {
        return mergeFrom((com.google.privacy.dlp.v2.InfoTypeTransformations) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.InfoTypeTransformations other) {
      if (other == com.google.privacy.dlp.v2.InfoTypeTransformations.getDefaultInstance())
        return this;
      if (transformationsBuilder_ == null) {
        if (!other.transformations_.isEmpty()) {
          if (transformations_.isEmpty()) {
            transformations_ = other.transformations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTransformationsIsMutable();
            transformations_.addAll(other.transformations_);
          }
          onChanged();
        }
      } else {
        if (!other.transformations_.isEmpty()) {
          if (transformationsBuilder_.isEmpty()) {
            transformationsBuilder_.dispose();
            transformationsBuilder_ = null;
            transformations_ = other.transformations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            transformationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTransformationsFieldBuilder()
                    : null;
          } else {
            transformationsBuilder_.addAllMessages(other.transformations_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
                            .parser(),
                        extensionRegistry);
                if (transformationsBuilder_ == null) {
                  ensureTransformationsIsMutable();
                  transformations_.add(m);
                } else {
                  transformationsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation>
        transformations_ = java.util.Collections.emptyList();

    private void ensureTransformationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        transformations_ =
            new java.util.ArrayList<
                com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation>(
                transformations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation,
            com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.Builder,
            com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformationOrBuilder>
        transformationsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation>
        getTransformationsList() {
      if (transformationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(transformations_);
      } else {
        return transformationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getTransformationsCount() {
      if (transformationsBuilder_ == null) {
        return transformations_.size();
      } else {
        return transformationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
        getTransformations(int index) {
      if (transformationsBuilder_ == null) {
        return transformations_.get(index);
      } else {
        return transformationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTransformations(
        int index, com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation value) {
      if (transformationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransformationsIsMutable();
        transformations_.set(index, value);
        onChanged();
      } else {
        transformationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTransformations(
        int index,
        com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.Builder
            builderForValue) {
      if (transformationsBuilder_ == null) {
        ensureTransformationsIsMutable();
        transformations_.set(index, builderForValue.build());
        onChanged();
      } else {
        transformationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addTransformations(
        com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation value) {
      if (transformationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransformationsIsMutable();
        transformations_.add(value);
        onChanged();
      } else {
        transformationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addTransformations(
        int index, com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation value) {
      if (transformationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransformationsIsMutable();
        transformations_.add(index, value);
        onChanged();
      } else {
        transformationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addTransformations(
        com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.Builder
            builderForValue) {
      if (transformationsBuilder_ == null) {
        ensureTransformationsIsMutable();
        transformations_.add(builderForValue.build());
        onChanged();
      } else {
        transformationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addTransformations(
        int index,
        com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.Builder
            builderForValue) {
      if (transformationsBuilder_ == null) {
        ensureTransformationsIsMutable();
        transformations_.add(index, builderForValue.build());
        onChanged();
      } else {
        transformationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllTransformations(
        java.lang.Iterable<
                ? extends com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation>
            values) {
      if (transformationsBuilder_ == null) {
        ensureTransformationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, transformations_);
        onChanged();
      } else {
        transformationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearTransformations() {
      if (transformationsBuilder_ == null) {
        transformations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        transformationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeTransformations(int index) {
      if (transformationsBuilder_ == null) {
        ensureTransformationsIsMutable();
        transformations_.remove(index);
        onChanged();
      } else {
        transformationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.Builder
        getTransformationsBuilder(int index) {
      return getTransformationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformationOrBuilder
        getTransformationsOrBuilder(int index) {
      if (transformationsBuilder_ == null) {
        return transformations_.get(index);
      } else {
        return transformationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformationOrBuilder>
        getTransformationsOrBuilderList() {
      if (transformationsBuilder_ != null) {
        return transformationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(transformations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.Builder
        addTransformationsBuilder() {
      return getTransformationsFieldBuilder()
          .addBuilder(
              com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.Builder
        addTransformationsBuilder(int index) {
      return getTransformationsFieldBuilder()
          .addBuilder(
              index,
              com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Transformation for each infoType. Cannot specify more than one
     * for a given infoType.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation transformations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.Builder>
        getTransformationsBuilderList() {
      return getTransformationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation,
            com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.Builder,
            com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformationOrBuilder>
        getTransformationsFieldBuilder() {
      if (transformationsBuilder_ == null) {
        transformationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation,
                com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.Builder,
                com.google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformationOrBuilder>(
                transformations_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        transformations_ = null;
      }
      return transformationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.InfoTypeTransformations)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.InfoTypeTransformations)
  private static final com.google.privacy.dlp.v2.InfoTypeTransformations DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.InfoTypeTransformations();
  }

  public static com.google.privacy.dlp.v2.InfoTypeTransformations getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InfoTypeTransformations> PARSER =
      new com.google.protobuf.AbstractParser<InfoTypeTransformations>() {
        @java.lang.Override
        public InfoTypeTransformations parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InfoTypeTransformations> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InfoTypeTransformations> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeTransformations getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
