/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Request to search for potentially sensitive info in a ContentItem.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.InspectContentRequest}
 */
public final class InspectContentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.InspectContentRequest)
    InspectContentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InspectContentRequest.newBuilder() to construct.
  private InspectContentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InspectContentRequest() {
    parent_ = "";
    inspectTemplateName_ = "";
    locationId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InspectContentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_InspectContentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_InspectContentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.InspectContentRequest.class,
            com.google.privacy.dlp.v2.InspectContentRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Parent resource name.
   *
   * The format of this value varies depending on whether you have [specified a
   * processing
   * location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
   *
   * + Projects scope, location specified:&lt;br/&gt;
   *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
   * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
   *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
   *
   * The following example `parent` string specifies a parent project with the
   * identifier `example-project`, and specifies the `europe-west3` location
   * for processing data:
   *
   *     parent=projects/example-project/locations/europe-west3
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Parent resource name.
   *
   * The format of this value varies depending on whether you have [specified a
   * processing
   * location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
   *
   * + Projects scope, location specified:&lt;br/&gt;
   *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
   * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
   *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
   *
   * The following example `parent` string specifies a parent project with the
   * identifier `example-project`, and specifies the `europe-west3` location
   * for processing data:
   *
   *     parent=projects/example-project/locations/europe-west3
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSPECT_CONFIG_FIELD_NUMBER = 2;
  private com.google.privacy.dlp.v2.InspectConfig inspectConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for the inspector. What specified here will override
   * the template referenced by the inspect_template_name argument.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
   *
   * @return Whether the inspectConfig field is set.
   */
  @java.lang.Override
  public boolean hasInspectConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the inspector. What specified here will override
   * the template referenced by the inspect_template_name argument.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
   *
   * @return The inspectConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectConfig getInspectConfig() {
    return inspectConfig_ == null
        ? com.google.privacy.dlp.v2.InspectConfig.getDefaultInstance()
        : inspectConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the inspector. What specified here will override
   * the template referenced by the inspect_template_name argument.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectConfigOrBuilder getInspectConfigOrBuilder() {
    return inspectConfig_ == null
        ? com.google.privacy.dlp.v2.InspectConfig.getDefaultInstance()
        : inspectConfig_;
  }

  public static final int ITEM_FIELD_NUMBER = 3;
  private com.google.privacy.dlp.v2.ContentItem item_;
  /**
   *
   *
   * <pre>
   * The item to inspect.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ContentItem item = 3;</code>
   *
   * @return Whether the item field is set.
   */
  @java.lang.Override
  public boolean hasItem() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The item to inspect.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ContentItem item = 3;</code>
   *
   * @return The item.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ContentItem getItem() {
    return item_ == null ? com.google.privacy.dlp.v2.ContentItem.getDefaultInstance() : item_;
  }
  /**
   *
   *
   * <pre>
   * The item to inspect.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ContentItem item = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ContentItemOrBuilder getItemOrBuilder() {
    return item_ == null ? com.google.privacy.dlp.v2.ContentItem.getDefaultInstance() : item_;
  }

  public static final int INSPECT_TEMPLATE_NAME_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object inspectTemplateName_ = "";
  /**
   *
   *
   * <pre>
   * Template to use. Any configuration directly specified in
   * inspect_config will override those set in the template. Singular fields
   * that are set in this request will replace their corresponding fields in the
   * template. Repeated fields are appended. Singular sub-messages and groups
   * are recursively merged.
   * </pre>
   *
   * <code>string inspect_template_name = 4;</code>
   *
   * @return The inspectTemplateName.
   */
  @java.lang.Override
  public java.lang.String getInspectTemplateName() {
    java.lang.Object ref = inspectTemplateName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      inspectTemplateName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Template to use. Any configuration directly specified in
   * inspect_config will override those set in the template. Singular fields
   * that are set in this request will replace their corresponding fields in the
   * template. Repeated fields are appended. Singular sub-messages and groups
   * are recursively merged.
   * </pre>
   *
   * <code>string inspect_template_name = 4;</code>
   *
   * @return The bytes for inspectTemplateName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInspectTemplateNameBytes() {
    java.lang.Object ref = inspectTemplateName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      inspectTemplateName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object locationId_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>string location_id = 5;</code>
   *
   * @return The locationId.
   */
  @java.lang.Override
  public java.lang.String getLocationId() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>string location_id = 5;</code>
   *
   * @return The bytes for locationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationIdBytes() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getInspectConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getItem());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inspectTemplateName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, inspectTemplateName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, locationId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getInspectConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getItem());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inspectTemplateName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, inspectTemplateName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, locationId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.InspectContentRequest)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.InspectContentRequest other =
        (com.google.privacy.dlp.v2.InspectContentRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasInspectConfig() != other.hasInspectConfig()) return false;
    if (hasInspectConfig()) {
      if (!getInspectConfig().equals(other.getInspectConfig())) return false;
    }
    if (hasItem() != other.hasItem()) return false;
    if (hasItem()) {
      if (!getItem().equals(other.getItem())) return false;
    }
    if (!getInspectTemplateName().equals(other.getInspectTemplateName())) return false;
    if (!getLocationId().equals(other.getLocationId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasInspectConfig()) {
      hash = (37 * hash) + INSPECT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInspectConfig().hashCode();
    }
    if (hasItem()) {
      hash = (37 * hash) + ITEM_FIELD_NUMBER;
      hash = (53 * hash) + getItem().hashCode();
    }
    hash = (37 * hash) + INSPECT_TEMPLATE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getInspectTemplateName().hashCode();
    hash = (37 * hash) + LOCATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getLocationId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.InspectContentRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InspectContentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InspectContentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InspectContentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InspectContentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InspectContentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InspectContentRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InspectContentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InspectContentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InspectContentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InspectContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InspectContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.InspectContentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request to search for potentially sensitive info in a ContentItem.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.InspectContentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.InspectContentRequest)
      com.google.privacy.dlp.v2.InspectContentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InspectContentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InspectContentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.InspectContentRequest.class,
              com.google.privacy.dlp.v2.InspectContentRequest.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.InspectContentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInspectConfigFieldBuilder();
        getItemFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      inspectConfig_ = null;
      if (inspectConfigBuilder_ != null) {
        inspectConfigBuilder_.dispose();
        inspectConfigBuilder_ = null;
      }
      item_ = null;
      if (itemBuilder_ != null) {
        itemBuilder_.dispose();
        itemBuilder_ = null;
      }
      inspectTemplateName_ = "";
      locationId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InspectContentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectContentRequest getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.InspectContentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectContentRequest build() {
      com.google.privacy.dlp.v2.InspectContentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectContentRequest buildPartial() {
      com.google.privacy.dlp.v2.InspectContentRequest result =
          new com.google.privacy.dlp.v2.InspectContentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.InspectContentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.inspectConfig_ =
            inspectConfigBuilder_ == null ? inspectConfig_ : inspectConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.item_ = itemBuilder_ == null ? item_ : itemBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.inspectTemplateName_ = inspectTemplateName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.locationId_ = locationId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.InspectContentRequest) {
        return mergeFrom((com.google.privacy.dlp.v2.InspectContentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.InspectContentRequest other) {
      if (other == com.google.privacy.dlp.v2.InspectContentRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasInspectConfig()) {
        mergeInspectConfig(other.getInspectConfig());
      }
      if (other.hasItem()) {
        mergeItem(other.getItem());
      }
      if (!other.getInspectTemplateName().isEmpty()) {
        inspectTemplateName_ = other.inspectTemplateName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getLocationId().isEmpty()) {
        locationId_ = other.locationId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInspectConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getItemFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                inspectTemplateName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                locationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Parent resource name.
     *
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     *
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Parent resource name.
     *
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     *
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Parent resource name.
     *
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     *
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parent resource name.
     *
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     *
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parent resource name.
     *
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     *
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.InspectConfig inspectConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectConfig,
            com.google.privacy.dlp.v2.InspectConfig.Builder,
            com.google.privacy.dlp.v2.InspectConfigOrBuilder>
        inspectConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the inspector. What specified here will override
     * the template referenced by the inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     *
     * @return Whether the inspectConfig field is set.
     */
    public boolean hasInspectConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector. What specified here will override
     * the template referenced by the inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     *
     * @return The inspectConfig.
     */
    public com.google.privacy.dlp.v2.InspectConfig getInspectConfig() {
      if (inspectConfigBuilder_ == null) {
        return inspectConfig_ == null
            ? com.google.privacy.dlp.v2.InspectConfig.getDefaultInstance()
            : inspectConfig_;
      } else {
        return inspectConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector. What specified here will override
     * the template referenced by the inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public Builder setInspectConfig(com.google.privacy.dlp.v2.InspectConfig value) {
      if (inspectConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inspectConfig_ = value;
      } else {
        inspectConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector. What specified here will override
     * the template referenced by the inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public Builder setInspectConfig(
        com.google.privacy.dlp.v2.InspectConfig.Builder builderForValue) {
      if (inspectConfigBuilder_ == null) {
        inspectConfig_ = builderForValue.build();
      } else {
        inspectConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector. What specified here will override
     * the template referenced by the inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public Builder mergeInspectConfig(com.google.privacy.dlp.v2.InspectConfig value) {
      if (inspectConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && inspectConfig_ != null
            && inspectConfig_ != com.google.privacy.dlp.v2.InspectConfig.getDefaultInstance()) {
          getInspectConfigBuilder().mergeFrom(value);
        } else {
          inspectConfig_ = value;
        }
      } else {
        inspectConfigBuilder_.mergeFrom(value);
      }
      if (inspectConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector. What specified here will override
     * the template referenced by the inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public Builder clearInspectConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      inspectConfig_ = null;
      if (inspectConfigBuilder_ != null) {
        inspectConfigBuilder_.dispose();
        inspectConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector. What specified here will override
     * the template referenced by the inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public com.google.privacy.dlp.v2.InspectConfig.Builder getInspectConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getInspectConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector. What specified here will override
     * the template referenced by the inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public com.google.privacy.dlp.v2.InspectConfigOrBuilder getInspectConfigOrBuilder() {
      if (inspectConfigBuilder_ != null) {
        return inspectConfigBuilder_.getMessageOrBuilder();
      } else {
        return inspectConfig_ == null
            ? com.google.privacy.dlp.v2.InspectConfig.getDefaultInstance()
            : inspectConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector. What specified here will override
     * the template referenced by the inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectConfig,
            com.google.privacy.dlp.v2.InspectConfig.Builder,
            com.google.privacy.dlp.v2.InspectConfigOrBuilder>
        getInspectConfigFieldBuilder() {
      if (inspectConfigBuilder_ == null) {
        inspectConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InspectConfig,
                com.google.privacy.dlp.v2.InspectConfig.Builder,
                com.google.privacy.dlp.v2.InspectConfigOrBuilder>(
                getInspectConfig(), getParentForChildren(), isClean());
        inspectConfig_ = null;
      }
      return inspectConfigBuilder_;
    }

    private com.google.privacy.dlp.v2.ContentItem item_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ContentItem,
            com.google.privacy.dlp.v2.ContentItem.Builder,
            com.google.privacy.dlp.v2.ContentItemOrBuilder>
        itemBuilder_;
    /**
     *
     *
     * <pre>
     * The item to inspect.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 3;</code>
     *
     * @return Whether the item field is set.
     */
    public boolean hasItem() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The item to inspect.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 3;</code>
     *
     * @return The item.
     */
    public com.google.privacy.dlp.v2.ContentItem getItem() {
      if (itemBuilder_ == null) {
        return item_ == null ? com.google.privacy.dlp.v2.ContentItem.getDefaultInstance() : item_;
      } else {
        return itemBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The item to inspect.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 3;</code>
     */
    public Builder setItem(com.google.privacy.dlp.v2.ContentItem value) {
      if (itemBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        item_ = value;
      } else {
        itemBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The item to inspect.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 3;</code>
     */
    public Builder setItem(com.google.privacy.dlp.v2.ContentItem.Builder builderForValue) {
      if (itemBuilder_ == null) {
        item_ = builderForValue.build();
      } else {
        itemBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The item to inspect.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 3;</code>
     */
    public Builder mergeItem(com.google.privacy.dlp.v2.ContentItem value) {
      if (itemBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && item_ != null
            && item_ != com.google.privacy.dlp.v2.ContentItem.getDefaultInstance()) {
          getItemBuilder().mergeFrom(value);
        } else {
          item_ = value;
        }
      } else {
        itemBuilder_.mergeFrom(value);
      }
      if (item_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The item to inspect.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 3;</code>
     */
    public Builder clearItem() {
      bitField0_ = (bitField0_ & ~0x00000004);
      item_ = null;
      if (itemBuilder_ != null) {
        itemBuilder_.dispose();
        itemBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The item to inspect.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 3;</code>
     */
    public com.google.privacy.dlp.v2.ContentItem.Builder getItemBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getItemFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The item to inspect.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 3;</code>
     */
    public com.google.privacy.dlp.v2.ContentItemOrBuilder getItemOrBuilder() {
      if (itemBuilder_ != null) {
        return itemBuilder_.getMessageOrBuilder();
      } else {
        return item_ == null ? com.google.privacy.dlp.v2.ContentItem.getDefaultInstance() : item_;
      }
    }
    /**
     *
     *
     * <pre>
     * The item to inspect.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ContentItem,
            com.google.privacy.dlp.v2.ContentItem.Builder,
            com.google.privacy.dlp.v2.ContentItemOrBuilder>
        getItemFieldBuilder() {
      if (itemBuilder_ == null) {
        itemBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.ContentItem,
                com.google.privacy.dlp.v2.ContentItem.Builder,
                com.google.privacy.dlp.v2.ContentItemOrBuilder>(
                getItem(), getParentForChildren(), isClean());
        item_ = null;
      }
      return itemBuilder_;
    }

    private java.lang.Object inspectTemplateName_ = "";
    /**
     *
     *
     * <pre>
     * Template to use. Any configuration directly specified in
     * inspect_config will override those set in the template. Singular fields
     * that are set in this request will replace their corresponding fields in the
     * template. Repeated fields are appended. Singular sub-messages and groups
     * are recursively merged.
     * </pre>
     *
     * <code>string inspect_template_name = 4;</code>
     *
     * @return The inspectTemplateName.
     */
    public java.lang.String getInspectTemplateName() {
      java.lang.Object ref = inspectTemplateName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inspectTemplateName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Template to use. Any configuration directly specified in
     * inspect_config will override those set in the template. Singular fields
     * that are set in this request will replace their corresponding fields in the
     * template. Repeated fields are appended. Singular sub-messages and groups
     * are recursively merged.
     * </pre>
     *
     * <code>string inspect_template_name = 4;</code>
     *
     * @return The bytes for inspectTemplateName.
     */
    public com.google.protobuf.ByteString getInspectTemplateNameBytes() {
      java.lang.Object ref = inspectTemplateName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inspectTemplateName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Template to use. Any configuration directly specified in
     * inspect_config will override those set in the template. Singular fields
     * that are set in this request will replace their corresponding fields in the
     * template. Repeated fields are appended. Singular sub-messages and groups
     * are recursively merged.
     * </pre>
     *
     * <code>string inspect_template_name = 4;</code>
     *
     * @param value The inspectTemplateName to set.
     * @return This builder for chaining.
     */
    public Builder setInspectTemplateName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inspectTemplateName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Template to use. Any configuration directly specified in
     * inspect_config will override those set in the template. Singular fields
     * that are set in this request will replace their corresponding fields in the
     * template. Repeated fields are appended. Singular sub-messages and groups
     * are recursively merged.
     * </pre>
     *
     * <code>string inspect_template_name = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInspectTemplateName() {
      inspectTemplateName_ = getDefaultInstance().getInspectTemplateName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Template to use. Any configuration directly specified in
     * inspect_config will override those set in the template. Singular fields
     * that are set in this request will replace their corresponding fields in the
     * template. Repeated fields are appended. Singular sub-messages and groups
     * are recursively merged.
     * </pre>
     *
     * <code>string inspect_template_name = 4;</code>
     *
     * @param value The bytes for inspectTemplateName to set.
     * @return This builder for chaining.
     */
    public Builder setInspectTemplateNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      inspectTemplateName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object locationId_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 5;</code>
     *
     * @return The locationId.
     */
    public java.lang.String getLocationId() {
      java.lang.Object ref = locationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 5;</code>
     *
     * @return The bytes for locationId.
     */
    public com.google.protobuf.ByteString getLocationIdBytes() {
      java.lang.Object ref = locationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 5;</code>
     *
     * @param value The locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      locationId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationId() {
      locationId_ = getDefaultInstance().getLocationId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 5;</code>
     *
     * @param value The bytes for locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      locationId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.InspectContentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.InspectContentRequest)
  private static final com.google.privacy.dlp.v2.InspectContentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.InspectContentRequest();
  }

  public static com.google.privacy.dlp.v2.InspectContentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InspectContentRequest> PARSER =
      new com.google.protobuf.AbstractParser<InspectContentRequest>() {
        @java.lang.Override
        public InspectContentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InspectContentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InspectContentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectContentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
