/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Contains a configuration to make api calls on a repeating basis.
 * See
 * https://cloud.google.com/sensitive-data-protection/docs/concepts-job-triggers
 * to learn more.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.JobTrigger}
 */
public final class JobTrigger extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.JobTrigger)
    JobTriggerOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use JobTrigger.newBuilder() to construct.
  private JobTrigger(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private JobTrigger() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    triggers_ = java.util.Collections.emptyList();
    errors_ = java.util.Collections.emptyList();
    status_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new JobTrigger();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_JobTrigger_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_JobTrigger_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.JobTrigger.class,
            com.google.privacy.dlp.v2.JobTrigger.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Whether the trigger is currently active. If PAUSED or CANCELLED, no jobs
   * will be created with this configuration. The service may automatically
   * pause triggers experiencing frequent errors. To restart a job, set the
   * status to HEALTHY after correcting user errors.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.JobTrigger.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>STATUS_UNSPECIFIED = 0;</code>
     */
    STATUS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Trigger is healthy.
     * </pre>
     *
     * <code>HEALTHY = 1;</code>
     */
    HEALTHY(1),
    /**
     *
     *
     * <pre>
     * Trigger is temporarily paused.
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    PAUSED(2),
    /**
     *
     *
     * <pre>
     * Trigger is cancelled and can not be resumed.
     * </pre>
     *
     * <code>CANCELLED = 3;</code>
     */
    CANCELLED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>STATUS_UNSPECIFIED = 0;</code>
     */
    public static final int STATUS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Trigger is healthy.
     * </pre>
     *
     * <code>HEALTHY = 1;</code>
     */
    public static final int HEALTHY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Trigger is temporarily paused.
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    public static final int PAUSED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Trigger is cancelled and can not be resumed.
     * </pre>
     *
     * <code>CANCELLED = 3;</code>
     */
    public static final int CANCELLED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return STATUS_UNSPECIFIED;
        case 1:
          return HEALTHY;
        case 2:
          return PAUSED;
        case 3:
          return CANCELLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.JobTrigger.getDescriptor().getEnumTypes().get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.JobTrigger.Status)
  }

  public interface TriggerOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.JobTrigger.Trigger)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Create a job on a repeating basis based on the elapse of time.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Schedule schedule = 1;</code>
     *
     * @return Whether the schedule field is set.
     */
    boolean hasSchedule();
    /**
     *
     *
     * <pre>
     * Create a job on a repeating basis based on the elapse of time.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Schedule schedule = 1;</code>
     *
     * @return The schedule.
     */
    com.google.privacy.dlp.v2.Schedule getSchedule();
    /**
     *
     *
     * <pre>
     * Create a job on a repeating basis based on the elapse of time.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Schedule schedule = 1;</code>
     */
    com.google.privacy.dlp.v2.ScheduleOrBuilder getScheduleOrBuilder();

    /**
     *
     *
     * <pre>
     * For use with hybrid jobs. Jobs must be manually created and finished.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Manual manual = 2;</code>
     *
     * @return Whether the manual field is set.
     */
    boolean hasManual();
    /**
     *
     *
     * <pre>
     * For use with hybrid jobs. Jobs must be manually created and finished.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Manual manual = 2;</code>
     *
     * @return The manual.
     */
    com.google.privacy.dlp.v2.Manual getManual();
    /**
     *
     *
     * <pre>
     * For use with hybrid jobs. Jobs must be manually created and finished.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Manual manual = 2;</code>
     */
    com.google.privacy.dlp.v2.ManualOrBuilder getManualOrBuilder();

    com.google.privacy.dlp.v2.JobTrigger.Trigger.TriggerCase getTriggerCase();
  }
  /**
   *
   *
   * <pre>
   * What event needs to occur for a new job to be started.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.JobTrigger.Trigger}
   */
  public static final class Trigger extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.JobTrigger.Trigger)
      TriggerOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Trigger.newBuilder() to construct.
    private Trigger(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Trigger() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Trigger();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_JobTrigger_Trigger_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_JobTrigger_Trigger_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.JobTrigger.Trigger.class,
              com.google.privacy.dlp.v2.JobTrigger.Trigger.Builder.class);
    }

    private int triggerCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object trigger_;

    public enum TriggerCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      SCHEDULE(1),
      MANUAL(2),
      TRIGGER_NOT_SET(0);
      private final int value;

      private TriggerCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TriggerCase valueOf(int value) {
        return forNumber(value);
      }

      public static TriggerCase forNumber(int value) {
        switch (value) {
          case 1:
            return SCHEDULE;
          case 2:
            return MANUAL;
          case 0:
            return TRIGGER_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public TriggerCase getTriggerCase() {
      return TriggerCase.forNumber(triggerCase_);
    }

    public static final int SCHEDULE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Create a job on a repeating basis based on the elapse of time.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Schedule schedule = 1;</code>
     *
     * @return Whether the schedule field is set.
     */
    @java.lang.Override
    public boolean hasSchedule() {
      return triggerCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Create a job on a repeating basis based on the elapse of time.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Schedule schedule = 1;</code>
     *
     * @return The schedule.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Schedule getSchedule() {
      if (triggerCase_ == 1) {
        return (com.google.privacy.dlp.v2.Schedule) trigger_;
      }
      return com.google.privacy.dlp.v2.Schedule.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Create a job on a repeating basis based on the elapse of time.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Schedule schedule = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ScheduleOrBuilder getScheduleOrBuilder() {
      if (triggerCase_ == 1) {
        return (com.google.privacy.dlp.v2.Schedule) trigger_;
      }
      return com.google.privacy.dlp.v2.Schedule.getDefaultInstance();
    }

    public static final int MANUAL_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * For use with hybrid jobs. Jobs must be manually created and finished.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Manual manual = 2;</code>
     *
     * @return Whether the manual field is set.
     */
    @java.lang.Override
    public boolean hasManual() {
      return triggerCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * For use with hybrid jobs. Jobs must be manually created and finished.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Manual manual = 2;</code>
     *
     * @return The manual.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Manual getManual() {
      if (triggerCase_ == 2) {
        return (com.google.privacy.dlp.v2.Manual) trigger_;
      }
      return com.google.privacy.dlp.v2.Manual.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * For use with hybrid jobs. Jobs must be manually created and finished.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Manual manual = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ManualOrBuilder getManualOrBuilder() {
      if (triggerCase_ == 2) {
        return (com.google.privacy.dlp.v2.Manual) trigger_;
      }
      return com.google.privacy.dlp.v2.Manual.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (triggerCase_ == 1) {
        output.writeMessage(1, (com.google.privacy.dlp.v2.Schedule) trigger_);
      }
      if (triggerCase_ == 2) {
        output.writeMessage(2, (com.google.privacy.dlp.v2.Manual) trigger_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (triggerCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.privacy.dlp.v2.Schedule) trigger_);
      }
      if (triggerCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.privacy.dlp.v2.Manual) trigger_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.JobTrigger.Trigger)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.JobTrigger.Trigger other =
          (com.google.privacy.dlp.v2.JobTrigger.Trigger) obj;

      if (!getTriggerCase().equals(other.getTriggerCase())) return false;
      switch (triggerCase_) {
        case 1:
          if (!getSchedule().equals(other.getSchedule())) return false;
          break;
        case 2:
          if (!getManual().equals(other.getManual())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (triggerCase_) {
        case 1:
          hash = (37 * hash) + SCHEDULE_FIELD_NUMBER;
          hash = (53 * hash) + getSchedule().hashCode();
          break;
        case 2:
          hash = (37 * hash) + MANUAL_FIELD_NUMBER;
          hash = (53 * hash) + getManual().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.JobTrigger.Trigger parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.JobTrigger.Trigger parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.JobTrigger.Trigger parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.JobTrigger.Trigger parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.JobTrigger.Trigger parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.JobTrigger.Trigger parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.JobTrigger.Trigger parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.JobTrigger.Trigger parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.JobTrigger.Trigger parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.JobTrigger.Trigger parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.JobTrigger.Trigger parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.JobTrigger.Trigger parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.privacy.dlp.v2.JobTrigger.Trigger prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * What event needs to occur for a new job to be started.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.JobTrigger.Trigger}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.JobTrigger.Trigger)
        com.google.privacy.dlp.v2.JobTrigger.TriggerOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_JobTrigger_Trigger_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_JobTrigger_Trigger_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.JobTrigger.Trigger.class,
                com.google.privacy.dlp.v2.JobTrigger.Trigger.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.JobTrigger.Trigger.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (scheduleBuilder_ != null) {
          scheduleBuilder_.clear();
        }
        if (manualBuilder_ != null) {
          manualBuilder_.clear();
        }
        triggerCase_ = 0;
        trigger_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_JobTrigger_Trigger_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.JobTrigger.Trigger getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.JobTrigger.Trigger.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.JobTrigger.Trigger build() {
        com.google.privacy.dlp.v2.JobTrigger.Trigger result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.JobTrigger.Trigger buildPartial() {
        com.google.privacy.dlp.v2.JobTrigger.Trigger result =
            new com.google.privacy.dlp.v2.JobTrigger.Trigger(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.privacy.dlp.v2.JobTrigger.Trigger result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(com.google.privacy.dlp.v2.JobTrigger.Trigger result) {
        result.triggerCase_ = triggerCase_;
        result.trigger_ = this.trigger_;
        if (triggerCase_ == 1 && scheduleBuilder_ != null) {
          result.trigger_ = scheduleBuilder_.build();
        }
        if (triggerCase_ == 2 && manualBuilder_ != null) {
          result.trigger_ = manualBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.JobTrigger.Trigger) {
          return mergeFrom((com.google.privacy.dlp.v2.JobTrigger.Trigger) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.JobTrigger.Trigger other) {
        if (other == com.google.privacy.dlp.v2.JobTrigger.Trigger.getDefaultInstance()) return this;
        switch (other.getTriggerCase()) {
          case SCHEDULE:
            {
              mergeSchedule(other.getSchedule());
              break;
            }
          case MANUAL:
            {
              mergeManual(other.getManual());
              break;
            }
          case TRIGGER_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getScheduleFieldBuilder().getBuilder(), extensionRegistry);
                  triggerCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getManualFieldBuilder().getBuilder(), extensionRegistry);
                  triggerCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int triggerCase_ = 0;
      private java.lang.Object trigger_;

      public TriggerCase getTriggerCase() {
        return TriggerCase.forNumber(triggerCase_);
      }

      public Builder clearTrigger() {
        triggerCase_ = 0;
        trigger_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.Schedule,
              com.google.privacy.dlp.v2.Schedule.Builder,
              com.google.privacy.dlp.v2.ScheduleOrBuilder>
          scheduleBuilder_;
      /**
       *
       *
       * <pre>
       * Create a job on a repeating basis based on the elapse of time.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Schedule schedule = 1;</code>
       *
       * @return Whether the schedule field is set.
       */
      @java.lang.Override
      public boolean hasSchedule() {
        return triggerCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Create a job on a repeating basis based on the elapse of time.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Schedule schedule = 1;</code>
       *
       * @return The schedule.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.Schedule getSchedule() {
        if (scheduleBuilder_ == null) {
          if (triggerCase_ == 1) {
            return (com.google.privacy.dlp.v2.Schedule) trigger_;
          }
          return com.google.privacy.dlp.v2.Schedule.getDefaultInstance();
        } else {
          if (triggerCase_ == 1) {
            return scheduleBuilder_.getMessage();
          }
          return com.google.privacy.dlp.v2.Schedule.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Create a job on a repeating basis based on the elapse of time.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Schedule schedule = 1;</code>
       */
      public Builder setSchedule(com.google.privacy.dlp.v2.Schedule value) {
        if (scheduleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          trigger_ = value;
          onChanged();
        } else {
          scheduleBuilder_.setMessage(value);
        }
        triggerCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Create a job on a repeating basis based on the elapse of time.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Schedule schedule = 1;</code>
       */
      public Builder setSchedule(com.google.privacy.dlp.v2.Schedule.Builder builderForValue) {
        if (scheduleBuilder_ == null) {
          trigger_ = builderForValue.build();
          onChanged();
        } else {
          scheduleBuilder_.setMessage(builderForValue.build());
        }
        triggerCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Create a job on a repeating basis based on the elapse of time.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Schedule schedule = 1;</code>
       */
      public Builder mergeSchedule(com.google.privacy.dlp.v2.Schedule value) {
        if (scheduleBuilder_ == null) {
          if (triggerCase_ == 1
              && trigger_ != com.google.privacy.dlp.v2.Schedule.getDefaultInstance()) {
            trigger_ =
                com.google.privacy.dlp.v2.Schedule.newBuilder(
                        (com.google.privacy.dlp.v2.Schedule) trigger_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            trigger_ = value;
          }
          onChanged();
        } else {
          if (triggerCase_ == 1) {
            scheduleBuilder_.mergeFrom(value);
          } else {
            scheduleBuilder_.setMessage(value);
          }
        }
        triggerCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Create a job on a repeating basis based on the elapse of time.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Schedule schedule = 1;</code>
       */
      public Builder clearSchedule() {
        if (scheduleBuilder_ == null) {
          if (triggerCase_ == 1) {
            triggerCase_ = 0;
            trigger_ = null;
            onChanged();
          }
        } else {
          if (triggerCase_ == 1) {
            triggerCase_ = 0;
            trigger_ = null;
          }
          scheduleBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Create a job on a repeating basis based on the elapse of time.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Schedule schedule = 1;</code>
       */
      public com.google.privacy.dlp.v2.Schedule.Builder getScheduleBuilder() {
        return getScheduleFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Create a job on a repeating basis based on the elapse of time.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Schedule schedule = 1;</code>
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.ScheduleOrBuilder getScheduleOrBuilder() {
        if ((triggerCase_ == 1) && (scheduleBuilder_ != null)) {
          return scheduleBuilder_.getMessageOrBuilder();
        } else {
          if (triggerCase_ == 1) {
            return (com.google.privacy.dlp.v2.Schedule) trigger_;
          }
          return com.google.privacy.dlp.v2.Schedule.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Create a job on a repeating basis based on the elapse of time.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Schedule schedule = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.Schedule,
              com.google.privacy.dlp.v2.Schedule.Builder,
              com.google.privacy.dlp.v2.ScheduleOrBuilder>
          getScheduleFieldBuilder() {
        if (scheduleBuilder_ == null) {
          if (!(triggerCase_ == 1)) {
            trigger_ = com.google.privacy.dlp.v2.Schedule.getDefaultInstance();
          }
          scheduleBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.Schedule,
                  com.google.privacy.dlp.v2.Schedule.Builder,
                  com.google.privacy.dlp.v2.ScheduleOrBuilder>(
                  (com.google.privacy.dlp.v2.Schedule) trigger_, getParentForChildren(), isClean());
          trigger_ = null;
        }
        triggerCase_ = 1;
        onChanged();
        return scheduleBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.Manual,
              com.google.privacy.dlp.v2.Manual.Builder,
              com.google.privacy.dlp.v2.ManualOrBuilder>
          manualBuilder_;
      /**
       *
       *
       * <pre>
       * For use with hybrid jobs. Jobs must be manually created and finished.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Manual manual = 2;</code>
       *
       * @return Whether the manual field is set.
       */
      @java.lang.Override
      public boolean hasManual() {
        return triggerCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * For use with hybrid jobs. Jobs must be manually created and finished.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Manual manual = 2;</code>
       *
       * @return The manual.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.Manual getManual() {
        if (manualBuilder_ == null) {
          if (triggerCase_ == 2) {
            return (com.google.privacy.dlp.v2.Manual) trigger_;
          }
          return com.google.privacy.dlp.v2.Manual.getDefaultInstance();
        } else {
          if (triggerCase_ == 2) {
            return manualBuilder_.getMessage();
          }
          return com.google.privacy.dlp.v2.Manual.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * For use with hybrid jobs. Jobs must be manually created and finished.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Manual manual = 2;</code>
       */
      public Builder setManual(com.google.privacy.dlp.v2.Manual value) {
        if (manualBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          trigger_ = value;
          onChanged();
        } else {
          manualBuilder_.setMessage(value);
        }
        triggerCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * For use with hybrid jobs. Jobs must be manually created and finished.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Manual manual = 2;</code>
       */
      public Builder setManual(com.google.privacy.dlp.v2.Manual.Builder builderForValue) {
        if (manualBuilder_ == null) {
          trigger_ = builderForValue.build();
          onChanged();
        } else {
          manualBuilder_.setMessage(builderForValue.build());
        }
        triggerCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * For use with hybrid jobs. Jobs must be manually created and finished.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Manual manual = 2;</code>
       */
      public Builder mergeManual(com.google.privacy.dlp.v2.Manual value) {
        if (manualBuilder_ == null) {
          if (triggerCase_ == 2
              && trigger_ != com.google.privacy.dlp.v2.Manual.getDefaultInstance()) {
            trigger_ =
                com.google.privacy.dlp.v2.Manual.newBuilder(
                        (com.google.privacy.dlp.v2.Manual) trigger_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            trigger_ = value;
          }
          onChanged();
        } else {
          if (triggerCase_ == 2) {
            manualBuilder_.mergeFrom(value);
          } else {
            manualBuilder_.setMessage(value);
          }
        }
        triggerCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * For use with hybrid jobs. Jobs must be manually created and finished.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Manual manual = 2;</code>
       */
      public Builder clearManual() {
        if (manualBuilder_ == null) {
          if (triggerCase_ == 2) {
            triggerCase_ = 0;
            trigger_ = null;
            onChanged();
          }
        } else {
          if (triggerCase_ == 2) {
            triggerCase_ = 0;
            trigger_ = null;
          }
          manualBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * For use with hybrid jobs. Jobs must be manually created and finished.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Manual manual = 2;</code>
       */
      public com.google.privacy.dlp.v2.Manual.Builder getManualBuilder() {
        return getManualFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * For use with hybrid jobs. Jobs must be manually created and finished.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Manual manual = 2;</code>
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.ManualOrBuilder getManualOrBuilder() {
        if ((triggerCase_ == 2) && (manualBuilder_ != null)) {
          return manualBuilder_.getMessageOrBuilder();
        } else {
          if (triggerCase_ == 2) {
            return (com.google.privacy.dlp.v2.Manual) trigger_;
          }
          return com.google.privacy.dlp.v2.Manual.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * For use with hybrid jobs. Jobs must be manually created and finished.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Manual manual = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.Manual,
              com.google.privacy.dlp.v2.Manual.Builder,
              com.google.privacy.dlp.v2.ManualOrBuilder>
          getManualFieldBuilder() {
        if (manualBuilder_ == null) {
          if (!(triggerCase_ == 2)) {
            trigger_ = com.google.privacy.dlp.v2.Manual.getDefaultInstance();
          }
          manualBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.Manual,
                  com.google.privacy.dlp.v2.Manual.Builder,
                  com.google.privacy.dlp.v2.ManualOrBuilder>(
                  (com.google.privacy.dlp.v2.Manual) trigger_, getParentForChildren(), isClean());
          trigger_ = null;
        }
        triggerCase_ = 2;
        onChanged();
        return manualBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.JobTrigger.Trigger)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.JobTrigger.Trigger)
    private static final com.google.privacy.dlp.v2.JobTrigger.Trigger DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.JobTrigger.Trigger();
    }

    public static com.google.privacy.dlp.v2.JobTrigger.Trigger getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Trigger> PARSER =
        new com.google.protobuf.AbstractParser<Trigger>() {
          @java.lang.Override
          public Trigger parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Trigger> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Trigger> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.JobTrigger.Trigger getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int jobCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object job_;

  public enum JobCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INSPECT_JOB(4),
    JOB_NOT_SET(0);
    private final int value;

    private JobCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static JobCase valueOf(int value) {
      return forNumber(value);
    }

    public static JobCase forNumber(int value) {
      switch (value) {
        case 4:
          return INSPECT_JOB;
        case 0:
          return JOB_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public JobCase getJobCase() {
    return JobCase.forNumber(jobCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Unique resource name for the triggeredJob, assigned by the service when the
   * triggeredJob is created, for example
   * `projects/dlp-test-project/jobTriggers/53234423`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique resource name for the triggeredJob, assigned by the service when the
   * triggeredJob is created, for example
   * `projects/dlp-test-project/jobTriggers/53234423`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Display name (max 100 chars)
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Display name (max 100 chars)
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * User provided description (max 256 chars)
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User provided description (max 256 chars)
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSPECT_JOB_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * For inspect jobs, a snapshot of the configuration.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 4;</code>
   *
   * @return Whether the inspectJob field is set.
   */
  @java.lang.Override
  public boolean hasInspectJob() {
    return jobCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * For inspect jobs, a snapshot of the configuration.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 4;</code>
   *
   * @return The inspectJob.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectJobConfig getInspectJob() {
    if (jobCase_ == 4) {
      return (com.google.privacy.dlp.v2.InspectJobConfig) job_;
    }
    return com.google.privacy.dlp.v2.InspectJobConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * For inspect jobs, a snapshot of the configuration.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectJobConfigOrBuilder getInspectJobOrBuilder() {
    if (jobCase_ == 4) {
      return (com.google.privacy.dlp.v2.InspectJobConfig) job_;
    }
    return com.google.privacy.dlp.v2.InspectJobConfig.getDefaultInstance();
  }

  public static final int TRIGGERS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.JobTrigger.Trigger> triggers_;
  /**
   *
   *
   * <pre>
   * A list of triggers which will be OR'ed together. Only one in the list
   * needs to trigger for a job to be started. The list may contain only
   * a single Schedule trigger and must have at least one object.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.JobTrigger.Trigger> getTriggersList() {
    return triggers_;
  }
  /**
   *
   *
   * <pre>
   * A list of triggers which will be OR'ed together. Only one in the list
   * needs to trigger for a job to be started. The list may contain only
   * a single Schedule trigger and must have at least one object.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.JobTrigger.TriggerOrBuilder>
      getTriggersOrBuilderList() {
    return triggers_;
  }
  /**
   *
   *
   * <pre>
   * A list of triggers which will be OR'ed together. Only one in the list
   * needs to trigger for a job to be started. The list may contain only
   * a single Schedule trigger and must have at least one object.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
   */
  @java.lang.Override
  public int getTriggersCount() {
    return triggers_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of triggers which will be OR'ed together. Only one in the list
   * needs to trigger for a job to be started. The list may contain only
   * a single Schedule trigger and must have at least one object.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.JobTrigger.Trigger getTriggers(int index) {
    return triggers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of triggers which will be OR'ed together. Only one in the list
   * needs to trigger for a job to be started. The list may contain only
   * a single Schedule trigger and must have at least one object.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.JobTrigger.TriggerOrBuilder getTriggersOrBuilder(int index) {
    return triggers_.get(index);
  }

  public static final int ERRORS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.Error> errors_;
  /**
   *
   *
   * <pre>
   * Output only. A stream of errors encountered when the trigger was activated.
   * Repeated errors may result in the JobTrigger automatically being paused.
   * Will return the last 100 errors. Whenever the JobTrigger is modified
   * this list will be cleared.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.Error> getErrorsList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A stream of errors encountered when the trigger was activated.
   * Repeated errors may result in the JobTrigger automatically being paused.
   * Will return the last 100 errors. Whenever the JobTrigger is modified
   * this list will be cleared.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.ErrorOrBuilder>
      getErrorsOrBuilderList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A stream of errors encountered when the trigger was activated.
   * Repeated errors may result in the JobTrigger automatically being paused.
   * Will return the last 100 errors. Whenever the JobTrigger is modified
   * this list will be cleared.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getErrorsCount() {
    return errors_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. A stream of errors encountered when the trigger was activated.
   * Repeated errors may result in the JobTrigger automatically being paused.
   * Will return the last 100 errors. Whenever the JobTrigger is modified
   * this list will be cleared.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Error getErrors(int index) {
    return errors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. A stream of errors encountered when the trigger was activated.
   * Repeated errors may result in the JobTrigger automatically being paused.
   * Will return the last 100 errors. Whenever the JobTrigger is modified
   * this list will be cleared.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ErrorOrBuilder getErrorsOrBuilder(int index) {
    return errors_.get(index);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a triggeredJob.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a triggeredJob.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a triggeredJob.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a triggeredJob.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a triggeredJob.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a triggeredJob.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LAST_RUN_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp lastRunTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of the last time this trigger executed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastRunTime field is set.
   */
  @java.lang.Override
  public boolean hasLastRunTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of the last time this trigger executed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastRunTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastRunTime() {
    return lastRunTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : lastRunTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of the last time this trigger executed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastRunTimeOrBuilder() {
    return lastRunTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : lastRunTime_;
  }

  public static final int STATUS_FIELD_NUMBER = 10;
  private int status_ = 0;
  /**
   *
   *
   * <pre>
   * Required. A status for this trigger.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.JobTrigger.Status status = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override
  public int getStatusValue() {
    return status_;
  }
  /**
   *
   *
   * <pre>
   * Required. A status for this trigger.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.JobTrigger.Status status = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.JobTrigger.Status getStatus() {
    com.google.privacy.dlp.v2.JobTrigger.Status result =
        com.google.privacy.dlp.v2.JobTrigger.Status.forNumber(status_);
    return result == null ? com.google.privacy.dlp.v2.JobTrigger.Status.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (jobCase_ == 4) {
      output.writeMessage(4, (com.google.privacy.dlp.v2.InspectJobConfig) job_);
    }
    for (int i = 0; i < triggers_.size(); i++) {
      output.writeMessage(5, triggers_.get(i));
    }
    for (int i = 0; i < errors_.size(); i++) {
      output.writeMessage(6, errors_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getLastRunTime());
    }
    if (status_ != com.google.privacy.dlp.v2.JobTrigger.Status.STATUS_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, status_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (jobCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.privacy.dlp.v2.InspectJobConfig) job_);
    }
    for (int i = 0; i < triggers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, triggers_.get(i));
    }
    for (int i = 0; i < errors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, errors_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getLastRunTime());
    }
    if (status_ != com.google.privacy.dlp.v2.JobTrigger.Status.STATUS_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, status_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.JobTrigger)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.JobTrigger other = (com.google.privacy.dlp.v2.JobTrigger) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getTriggersList().equals(other.getTriggersList())) return false;
    if (!getErrorsList().equals(other.getErrorsList())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasLastRunTime() != other.hasLastRunTime()) return false;
    if (hasLastRunTime()) {
      if (!getLastRunTime().equals(other.getLastRunTime())) return false;
    }
    if (status_ != other.status_) return false;
    if (!getJobCase().equals(other.getJobCase())) return false;
    switch (jobCase_) {
      case 4:
        if (!getInspectJob().equals(other.getInspectJob())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getTriggersCount() > 0) {
      hash = (37 * hash) + TRIGGERS_FIELD_NUMBER;
      hash = (53 * hash) + getTriggersList().hashCode();
    }
    if (getErrorsCount() > 0) {
      hash = (37 * hash) + ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorsList().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasLastRunTime()) {
      hash = (37 * hash) + LAST_RUN_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastRunTime().hashCode();
    }
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    switch (jobCase_) {
      case 4:
        hash = (37 * hash) + INSPECT_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getInspectJob().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.JobTrigger parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.JobTrigger parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.JobTrigger parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.JobTrigger parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.JobTrigger parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.JobTrigger parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.JobTrigger parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.JobTrigger parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.JobTrigger parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.JobTrigger parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.JobTrigger parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.JobTrigger parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.JobTrigger prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains a configuration to make api calls on a repeating basis.
   * See
   * https://cloud.google.com/sensitive-data-protection/docs/concepts-job-triggers
   * to learn more.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.JobTrigger}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.JobTrigger)
      com.google.privacy.dlp.v2.JobTriggerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_JobTrigger_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_JobTrigger_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.JobTrigger.class,
              com.google.privacy.dlp.v2.JobTrigger.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.JobTrigger.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTriggersFieldBuilder();
        getErrorsFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getLastRunTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      if (inspectJobBuilder_ != null) {
        inspectJobBuilder_.clear();
      }
      if (triggersBuilder_ == null) {
        triggers_ = java.util.Collections.emptyList();
      } else {
        triggers_ = null;
        triggersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
      } else {
        errors_ = null;
        errorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      lastRunTime_ = null;
      if (lastRunTimeBuilder_ != null) {
        lastRunTimeBuilder_.dispose();
        lastRunTimeBuilder_ = null;
      }
      status_ = 0;
      jobCase_ = 0;
      job_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_JobTrigger_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.JobTrigger getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.JobTrigger.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.JobTrigger build() {
      com.google.privacy.dlp.v2.JobTrigger result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.JobTrigger buildPartial() {
      com.google.privacy.dlp.v2.JobTrigger result = new com.google.privacy.dlp.v2.JobTrigger(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.privacy.dlp.v2.JobTrigger result) {
      if (triggersBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          triggers_ = java.util.Collections.unmodifiableList(triggers_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.triggers_ = triggers_;
      } else {
        result.triggers_ = triggersBuilder_.build();
      }
      if (errorsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          errors_ = java.util.Collections.unmodifiableList(errors_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.errors_ = errors_;
      } else {
        result.errors_ = errorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.privacy.dlp.v2.JobTrigger result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.lastRunTime_ =
            lastRunTimeBuilder_ == null ? lastRunTime_ : lastRunTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.status_ = status_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.JobTrigger result) {
      result.jobCase_ = jobCase_;
      result.job_ = this.job_;
      if (jobCase_ == 4 && inspectJobBuilder_ != null) {
        result.job_ = inspectJobBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.JobTrigger) {
        return mergeFrom((com.google.privacy.dlp.v2.JobTrigger) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.JobTrigger other) {
      if (other == com.google.privacy.dlp.v2.JobTrigger.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (triggersBuilder_ == null) {
        if (!other.triggers_.isEmpty()) {
          if (triggers_.isEmpty()) {
            triggers_ = other.triggers_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureTriggersIsMutable();
            triggers_.addAll(other.triggers_);
          }
          onChanged();
        }
      } else {
        if (!other.triggers_.isEmpty()) {
          if (triggersBuilder_.isEmpty()) {
            triggersBuilder_.dispose();
            triggersBuilder_ = null;
            triggers_ = other.triggers_;
            bitField0_ = (bitField0_ & ~0x00000010);
            triggersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTriggersFieldBuilder()
                    : null;
          } else {
            triggersBuilder_.addAllMessages(other.triggers_);
          }
        }
      }
      if (errorsBuilder_ == null) {
        if (!other.errors_.isEmpty()) {
          if (errors_.isEmpty()) {
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureErrorsIsMutable();
            errors_.addAll(other.errors_);
          }
          onChanged();
        }
      } else {
        if (!other.errors_.isEmpty()) {
          if (errorsBuilder_.isEmpty()) {
            errorsBuilder_.dispose();
            errorsBuilder_ = null;
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000020);
            errorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorsFieldBuilder()
                    : null;
          } else {
            errorsBuilder_.addAllMessages(other.errors_);
          }
        }
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasLastRunTime()) {
        mergeLastRunTime(other.getLastRunTime());
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      switch (other.getJobCase()) {
        case INSPECT_JOB:
          {
            mergeInspectJob(other.getInspectJob());
            break;
          }
        case JOB_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getInspectJobFieldBuilder().getBuilder(), extensionRegistry);
                jobCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                com.google.privacy.dlp.v2.JobTrigger.Trigger m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.JobTrigger.Trigger.parser(), extensionRegistry);
                if (triggersBuilder_ == null) {
                  ensureTriggersIsMutable();
                  triggers_.add(m);
                } else {
                  triggersBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                com.google.privacy.dlp.v2.Error m =
                    input.readMessage(com.google.privacy.dlp.v2.Error.parser(), extensionRegistry);
                if (errorsBuilder_ == null) {
                  ensureErrorsIsMutable();
                  errors_.add(m);
                } else {
                  errorsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getLastRunTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 80:
              {
                status_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int jobCase_ = 0;
    private java.lang.Object job_;

    public JobCase getJobCase() {
      return JobCase.forNumber(jobCase_);
    }

    public Builder clearJob() {
      jobCase_ = 0;
      job_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Unique resource name for the triggeredJob, assigned by the service when the
     * triggeredJob is created, for example
     * `projects/dlp-test-project/jobTriggers/53234423`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique resource name for the triggeredJob, assigned by the service when the
     * triggeredJob is created, for example
     * `projects/dlp-test-project/jobTriggers/53234423`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique resource name for the triggeredJob, assigned by the service when the
     * triggeredJob is created, for example
     * `projects/dlp-test-project/jobTriggers/53234423`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique resource name for the triggeredJob, assigned by the service when the
     * triggeredJob is created, for example
     * `projects/dlp-test-project/jobTriggers/53234423`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique resource name for the triggeredJob, assigned by the service when the
     * triggeredJob is created, for example
     * `projects/dlp-test-project/jobTriggers/53234423`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Display name (max 100 chars)
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name (max 100 chars)
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name (max 100 chars)
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display name (max 100 chars)
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display name (max 100 chars)
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * User provided description (max 256 chars)
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User provided description (max 256 chars)
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User provided description (max 256 chars)
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User provided description (max 256 chars)
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User provided description (max 256 chars)
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectJobConfig,
            com.google.privacy.dlp.v2.InspectJobConfig.Builder,
            com.google.privacy.dlp.v2.InspectJobConfigOrBuilder>
        inspectJobBuilder_;
    /**
     *
     *
     * <pre>
     * For inspect jobs, a snapshot of the configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 4;</code>
     *
     * @return Whether the inspectJob field is set.
     */
    @java.lang.Override
    public boolean hasInspectJob() {
      return jobCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * For inspect jobs, a snapshot of the configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 4;</code>
     *
     * @return The inspectJob.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectJobConfig getInspectJob() {
      if (inspectJobBuilder_ == null) {
        if (jobCase_ == 4) {
          return (com.google.privacy.dlp.v2.InspectJobConfig) job_;
        }
        return com.google.privacy.dlp.v2.InspectJobConfig.getDefaultInstance();
      } else {
        if (jobCase_ == 4) {
          return inspectJobBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.InspectJobConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * For inspect jobs, a snapshot of the configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 4;</code>
     */
    public Builder setInspectJob(com.google.privacy.dlp.v2.InspectJobConfig value) {
      if (inspectJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        job_ = value;
        onChanged();
      } else {
        inspectJobBuilder_.setMessage(value);
      }
      jobCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * For inspect jobs, a snapshot of the configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 4;</code>
     */
    public Builder setInspectJob(
        com.google.privacy.dlp.v2.InspectJobConfig.Builder builderForValue) {
      if (inspectJobBuilder_ == null) {
        job_ = builderForValue.build();
        onChanged();
      } else {
        inspectJobBuilder_.setMessage(builderForValue.build());
      }
      jobCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * For inspect jobs, a snapshot of the configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 4;</code>
     */
    public Builder mergeInspectJob(com.google.privacy.dlp.v2.InspectJobConfig value) {
      if (inspectJobBuilder_ == null) {
        if (jobCase_ == 4
            && job_ != com.google.privacy.dlp.v2.InspectJobConfig.getDefaultInstance()) {
          job_ =
              com.google.privacy.dlp.v2.InspectJobConfig.newBuilder(
                      (com.google.privacy.dlp.v2.InspectJobConfig) job_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          job_ = value;
        }
        onChanged();
      } else {
        if (jobCase_ == 4) {
          inspectJobBuilder_.mergeFrom(value);
        } else {
          inspectJobBuilder_.setMessage(value);
        }
      }
      jobCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * For inspect jobs, a snapshot of the configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 4;</code>
     */
    public Builder clearInspectJob() {
      if (inspectJobBuilder_ == null) {
        if (jobCase_ == 4) {
          jobCase_ = 0;
          job_ = null;
          onChanged();
        }
      } else {
        if (jobCase_ == 4) {
          jobCase_ = 0;
          job_ = null;
        }
        inspectJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For inspect jobs, a snapshot of the configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 4;</code>
     */
    public com.google.privacy.dlp.v2.InspectJobConfig.Builder getInspectJobBuilder() {
      return getInspectJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * For inspect jobs, a snapshot of the configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 4;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectJobConfigOrBuilder getInspectJobOrBuilder() {
      if ((jobCase_ == 4) && (inspectJobBuilder_ != null)) {
        return inspectJobBuilder_.getMessageOrBuilder();
      } else {
        if (jobCase_ == 4) {
          return (com.google.privacy.dlp.v2.InspectJobConfig) job_;
        }
        return com.google.privacy.dlp.v2.InspectJobConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * For inspect jobs, a snapshot of the configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectJobConfig inspect_job = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectJobConfig,
            com.google.privacy.dlp.v2.InspectJobConfig.Builder,
            com.google.privacy.dlp.v2.InspectJobConfigOrBuilder>
        getInspectJobFieldBuilder() {
      if (inspectJobBuilder_ == null) {
        if (!(jobCase_ == 4)) {
          job_ = com.google.privacy.dlp.v2.InspectJobConfig.getDefaultInstance();
        }
        inspectJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InspectJobConfig,
                com.google.privacy.dlp.v2.InspectJobConfig.Builder,
                com.google.privacy.dlp.v2.InspectJobConfigOrBuilder>(
                (com.google.privacy.dlp.v2.InspectJobConfig) job_,
                getParentForChildren(),
                isClean());
        job_ = null;
      }
      jobCase_ = 4;
      onChanged();
      return inspectJobBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.JobTrigger.Trigger> triggers_ =
        java.util.Collections.emptyList();

    private void ensureTriggersIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        triggers_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.JobTrigger.Trigger>(triggers_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.JobTrigger.Trigger,
            com.google.privacy.dlp.v2.JobTrigger.Trigger.Builder,
            com.google.privacy.dlp.v2.JobTrigger.TriggerOrBuilder>
        triggersBuilder_;

    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.JobTrigger.Trigger> getTriggersList() {
      if (triggersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(triggers_);
      } else {
        return triggersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public int getTriggersCount() {
      if (triggersBuilder_ == null) {
        return triggers_.size();
      } else {
        return triggersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public com.google.privacy.dlp.v2.JobTrigger.Trigger getTriggers(int index) {
      if (triggersBuilder_ == null) {
        return triggers_.get(index);
      } else {
        return triggersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public Builder setTriggers(int index, com.google.privacy.dlp.v2.JobTrigger.Trigger value) {
      if (triggersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTriggersIsMutable();
        triggers_.set(index, value);
        onChanged();
      } else {
        triggersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public Builder setTriggers(
        int index, com.google.privacy.dlp.v2.JobTrigger.Trigger.Builder builderForValue) {
      if (triggersBuilder_ == null) {
        ensureTriggersIsMutable();
        triggers_.set(index, builderForValue.build());
        onChanged();
      } else {
        triggersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public Builder addTriggers(com.google.privacy.dlp.v2.JobTrigger.Trigger value) {
      if (triggersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTriggersIsMutable();
        triggers_.add(value);
        onChanged();
      } else {
        triggersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public Builder addTriggers(int index, com.google.privacy.dlp.v2.JobTrigger.Trigger value) {
      if (triggersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTriggersIsMutable();
        triggers_.add(index, value);
        onChanged();
      } else {
        triggersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public Builder addTriggers(
        com.google.privacy.dlp.v2.JobTrigger.Trigger.Builder builderForValue) {
      if (triggersBuilder_ == null) {
        ensureTriggersIsMutable();
        triggers_.add(builderForValue.build());
        onChanged();
      } else {
        triggersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public Builder addTriggers(
        int index, com.google.privacy.dlp.v2.JobTrigger.Trigger.Builder builderForValue) {
      if (triggersBuilder_ == null) {
        ensureTriggersIsMutable();
        triggers_.add(index, builderForValue.build());
        onChanged();
      } else {
        triggersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public Builder addAllTriggers(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.JobTrigger.Trigger> values) {
      if (triggersBuilder_ == null) {
        ensureTriggersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, triggers_);
        onChanged();
      } else {
        triggersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public Builder clearTriggers() {
      if (triggersBuilder_ == null) {
        triggers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        triggersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public Builder removeTriggers(int index) {
      if (triggersBuilder_ == null) {
        ensureTriggersIsMutable();
        triggers_.remove(index);
        onChanged();
      } else {
        triggersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public com.google.privacy.dlp.v2.JobTrigger.Trigger.Builder getTriggersBuilder(int index) {
      return getTriggersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public com.google.privacy.dlp.v2.JobTrigger.TriggerOrBuilder getTriggersOrBuilder(int index) {
      if (triggersBuilder_ == null) {
        return triggers_.get(index);
      } else {
        return triggersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.JobTrigger.TriggerOrBuilder>
        getTriggersOrBuilderList() {
      if (triggersBuilder_ != null) {
        return triggersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(triggers_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public com.google.privacy.dlp.v2.JobTrigger.Trigger.Builder addTriggersBuilder() {
      return getTriggersFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.JobTrigger.Trigger.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public com.google.privacy.dlp.v2.JobTrigger.Trigger.Builder addTriggersBuilder(int index) {
      return getTriggersFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.JobTrigger.Trigger.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of triggers which will be OR'ed together. Only one in the list
     * needs to trigger for a job to be started. The list may contain only
     * a single Schedule trigger and must have at least one object.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.JobTrigger.Trigger triggers = 5;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.JobTrigger.Trigger.Builder>
        getTriggersBuilderList() {
      return getTriggersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.JobTrigger.Trigger,
            com.google.privacy.dlp.v2.JobTrigger.Trigger.Builder,
            com.google.privacy.dlp.v2.JobTrigger.TriggerOrBuilder>
        getTriggersFieldBuilder() {
      if (triggersBuilder_ == null) {
        triggersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.JobTrigger.Trigger,
                com.google.privacy.dlp.v2.JobTrigger.Trigger.Builder,
                com.google.privacy.dlp.v2.JobTrigger.TriggerOrBuilder>(
                triggers_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        triggers_ = null;
      }
      return triggersBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.Error> errors_ =
        java.util.Collections.emptyList();

    private void ensureErrorsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        errors_ = new java.util.ArrayList<com.google.privacy.dlp.v2.Error>(errors_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.Error,
            com.google.privacy.dlp.v2.Error.Builder,
            com.google.privacy.dlp.v2.ErrorOrBuilder>
        errorsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.privacy.dlp.v2.Error> getErrorsList() {
      if (errorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errors_);
      } else {
        return errorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getErrorsCount() {
      if (errorsBuilder_ == null) {
        return errors_.size();
      } else {
        return errorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.privacy.dlp.v2.Error getErrors(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setErrors(int index, com.google.privacy.dlp.v2.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.set(index, value);
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setErrors(int index, com.google.privacy.dlp.v2.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(com.google.privacy.dlp.v2.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(int index, com.google.privacy.dlp.v2.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(index, value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(com.google.privacy.dlp.v2.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(int index, com.google.privacy.dlp.v2.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllErrors(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.Error> values) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errors_);
        onChanged();
      } else {
        errorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearErrors() {
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        errorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeErrors(int index) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.remove(index);
        onChanged();
      } else {
        errorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.privacy.dlp.v2.Error.Builder getErrorsBuilder(int index) {
      return getErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.privacy.dlp.v2.ErrorOrBuilder getErrorsOrBuilder(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.ErrorOrBuilder>
        getErrorsOrBuilderList() {
      if (errorsBuilder_ != null) {
        return errorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.privacy.dlp.v2.Error.Builder addErrorsBuilder() {
      return getErrorsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.privacy.dlp.v2.Error.Builder addErrorsBuilder(int index) {
      return getErrorsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A stream of errors encountered when the trigger was activated.
     * Repeated errors may result in the JobTrigger automatically being paused.
     * Will return the last 100 errors. Whenever the JobTrigger is modified
     * this list will be cleared.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.privacy.dlp.v2.Error.Builder> getErrorsBuilderList() {
      return getErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.Error,
            com.google.privacy.dlp.v2.Error.Builder,
            com.google.privacy.dlp.v2.ErrorOrBuilder>
        getErrorsFieldBuilder() {
      if (errorsBuilder_ == null) {
        errorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.Error,
                com.google.privacy.dlp.v2.Error.Builder,
                com.google.privacy.dlp.v2.ErrorOrBuilder>(
                errors_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        errors_ = null;
      }
      return errorsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a triggeredJob.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastRunTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastRunTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this trigger executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastRunTime field is set.
     */
    public boolean hasLastRunTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this trigger executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastRunTime.
     */
    public com.google.protobuf.Timestamp getLastRunTime() {
      if (lastRunTimeBuilder_ == null) {
        return lastRunTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastRunTime_;
      } else {
        return lastRunTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this trigger executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastRunTime(com.google.protobuf.Timestamp value) {
      if (lastRunTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastRunTime_ = value;
      } else {
        lastRunTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this trigger executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastRunTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastRunTimeBuilder_ == null) {
        lastRunTime_ = builderForValue.build();
      } else {
        lastRunTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this trigger executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastRunTime(com.google.protobuf.Timestamp value) {
      if (lastRunTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && lastRunTime_ != null
            && lastRunTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastRunTimeBuilder().mergeFrom(value);
        } else {
          lastRunTime_ = value;
        }
      } else {
        lastRunTimeBuilder_.mergeFrom(value);
      }
      if (lastRunTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this trigger executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastRunTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      lastRunTime_ = null;
      if (lastRunTimeBuilder_ != null) {
        lastRunTimeBuilder_.dispose();
        lastRunTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this trigger executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastRunTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getLastRunTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this trigger executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastRunTimeOrBuilder() {
      if (lastRunTimeBuilder_ != null) {
        return lastRunTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastRunTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastRunTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last time this trigger executed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastRunTimeFieldBuilder() {
      if (lastRunTimeBuilder_ == null) {
        lastRunTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastRunTime(), getParentForChildren(), isClean());
        lastRunTime_ = null;
      }
      return lastRunTimeBuilder_;
    }

    private int status_ = 0;
    /**
     *
     *
     * <pre>
     * Required. A status for this trigger.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.JobTrigger.Status status = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override
    public int getStatusValue() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * Required. A status for this trigger.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.JobTrigger.Status status = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A status for this trigger.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.JobTrigger.Status status = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.JobTrigger.Status getStatus() {
      com.google.privacy.dlp.v2.JobTrigger.Status result =
          com.google.privacy.dlp.v2.JobTrigger.Status.forNumber(status_);
      return result == null ? com.google.privacy.dlp.v2.JobTrigger.Status.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. A status for this trigger.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.JobTrigger.Status status = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.privacy.dlp.v2.JobTrigger.Status value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A status for this trigger.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.JobTrigger.Status status = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000200);
      status_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.JobTrigger)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.JobTrigger)
  private static final com.google.privacy.dlp.v2.JobTrigger DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.JobTrigger();
  }

  public static com.google.privacy.dlp.v2.JobTrigger getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<JobTrigger> PARSER =
      new com.google.protobuf.AbstractParser<JobTrigger>() {
        @java.lang.Override
        public JobTrigger parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<JobTrigger> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<JobTrigger> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.JobTrigger getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
