/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Configuration for a custom dictionary created from a data source of any size
 * up to the maximum size defined in the
 * [limits](https://cloud.google.com/sensitive-data-protection/limits) page. The
 * artifacts of dictionary creation are stored in the specified Cloud Storage
 * location. Consider using `CustomInfoType.Dictionary` for smaller dictionaries
 * that satisfy the size requirements.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.LargeCustomDictionaryConfig}
 */
public final class LargeCustomDictionaryConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.LargeCustomDictionaryConfig)
    LargeCustomDictionaryConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LargeCustomDictionaryConfig.newBuilder() to construct.
  private LargeCustomDictionaryConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LargeCustomDictionaryConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LargeCustomDictionaryConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_LargeCustomDictionaryConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_LargeCustomDictionaryConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.class,
            com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.Builder.class);
  }

  private int bitField0_;
  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CLOUD_STORAGE_FILE_SET(2),
    BIG_QUERY_FIELD(3),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return CLOUD_STORAGE_FILE_SET;
        case 3:
          return BIG_QUERY_FIELD;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int OUTPUT_PATH_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.CloudStoragePath outputPath_;
  /**
   *
   *
   * <pre>
   * Location to store dictionary artifacts in Cloud Storage. These files
   * will only be accessible by project owners and the DLP API. If any of these
   * artifacts are modified, the dictionary is considered invalid and can no
   * longer be used.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudStoragePath output_path = 1;</code>
   *
   * @return Whether the outputPath field is set.
   */
  @java.lang.Override
  public boolean hasOutputPath() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Location to store dictionary artifacts in Cloud Storage. These files
   * will only be accessible by project owners and the DLP API. If any of these
   * artifacts are modified, the dictionary is considered invalid and can no
   * longer be used.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudStoragePath output_path = 1;</code>
   *
   * @return The outputPath.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudStoragePath getOutputPath() {
    return outputPath_ == null
        ? com.google.privacy.dlp.v2.CloudStoragePath.getDefaultInstance()
        : outputPath_;
  }
  /**
   *
   *
   * <pre>
   * Location to store dictionary artifacts in Cloud Storage. These files
   * will only be accessible by project owners and the DLP API. If any of these
   * artifacts are modified, the dictionary is considered invalid and can no
   * longer be used.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudStoragePath output_path = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudStoragePathOrBuilder getOutputPathOrBuilder() {
    return outputPath_ == null
        ? com.google.privacy.dlp.v2.CloudStoragePath.getDefaultInstance()
        : outputPath_;
  }

  public static final int CLOUD_STORAGE_FILE_SET_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Set of files containing newline-delimited lists of dictionary phrases.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudStorageFileSet cloud_storage_file_set = 2;</code>
   *
   * @return Whether the cloudStorageFileSet field is set.
   */
  @java.lang.Override
  public boolean hasCloudStorageFileSet() {
    return sourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Set of files containing newline-delimited lists of dictionary phrases.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudStorageFileSet cloud_storage_file_set = 2;</code>
   *
   * @return The cloudStorageFileSet.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudStorageFileSet getCloudStorageFileSet() {
    if (sourceCase_ == 2) {
      return (com.google.privacy.dlp.v2.CloudStorageFileSet) source_;
    }
    return com.google.privacy.dlp.v2.CloudStorageFileSet.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Set of files containing newline-delimited lists of dictionary phrases.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudStorageFileSet cloud_storage_file_set = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudStorageFileSetOrBuilder getCloudStorageFileSetOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.privacy.dlp.v2.CloudStorageFileSet) source_;
    }
    return com.google.privacy.dlp.v2.CloudStorageFileSet.getDefaultInstance();
  }

  public static final int BIG_QUERY_FIELD_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Field in a BigQuery table where each cell represents a dictionary phrase.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryField big_query_field = 3;</code>
   *
   * @return Whether the bigQueryField field is set.
   */
  @java.lang.Override
  public boolean hasBigQueryField() {
    return sourceCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Field in a BigQuery table where each cell represents a dictionary phrase.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryField big_query_field = 3;</code>
   *
   * @return The bigQueryField.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryField getBigQueryField() {
    if (sourceCase_ == 3) {
      return (com.google.privacy.dlp.v2.BigQueryField) source_;
    }
    return com.google.privacy.dlp.v2.BigQueryField.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Field in a BigQuery table where each cell represents a dictionary phrase.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryField big_query_field = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryFieldOrBuilder getBigQueryFieldOrBuilder() {
    if (sourceCase_ == 3) {
      return (com.google.privacy.dlp.v2.BigQueryField) source_;
    }
    return com.google.privacy.dlp.v2.BigQueryField.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getOutputPath());
    }
    if (sourceCase_ == 2) {
      output.writeMessage(2, (com.google.privacy.dlp.v2.CloudStorageFileSet) source_);
    }
    if (sourceCase_ == 3) {
      output.writeMessage(3, (com.google.privacy.dlp.v2.BigQueryField) source_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getOutputPath());
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.privacy.dlp.v2.CloudStorageFileSet) source_);
    }
    if (sourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.privacy.dlp.v2.BigQueryField) source_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.LargeCustomDictionaryConfig)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.LargeCustomDictionaryConfig other =
        (com.google.privacy.dlp.v2.LargeCustomDictionaryConfig) obj;

    if (hasOutputPath() != other.hasOutputPath()) return false;
    if (hasOutputPath()) {
      if (!getOutputPath().equals(other.getOutputPath())) return false;
    }
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 2:
        if (!getCloudStorageFileSet().equals(other.getCloudStorageFileSet())) return false;
        break;
      case 3:
        if (!getBigQueryField().equals(other.getBigQueryField())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasOutputPath()) {
      hash = (37 * hash) + OUTPUT_PATH_FIELD_NUMBER;
      hash = (53 * hash) + getOutputPath().hashCode();
    }
    switch (sourceCase_) {
      case 2:
        hash = (37 * hash) + CLOUD_STORAGE_FILE_SET_FIELD_NUMBER;
        hash = (53 * hash) + getCloudStorageFileSet().hashCode();
        break;
      case 3:
        hash = (37 * hash) + BIG_QUERY_FIELD_FIELD_NUMBER;
        hash = (53 * hash) + getBigQueryField().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.LargeCustomDictionaryConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.LargeCustomDictionaryConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.LargeCustomDictionaryConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.LargeCustomDictionaryConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.LargeCustomDictionaryConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.LargeCustomDictionaryConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.LargeCustomDictionaryConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.LargeCustomDictionaryConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.LargeCustomDictionaryConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.LargeCustomDictionaryConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.LargeCustomDictionaryConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.LargeCustomDictionaryConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.privacy.dlp.v2.LargeCustomDictionaryConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a custom dictionary created from a data source of any size
   * up to the maximum size defined in the
   * [limits](https://cloud.google.com/sensitive-data-protection/limits) page. The
   * artifacts of dictionary creation are stored in the specified Cloud Storage
   * location. Consider using `CustomInfoType.Dictionary` for smaller dictionaries
   * that satisfy the size requirements.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.LargeCustomDictionaryConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.LargeCustomDictionaryConfig)
      com.google.privacy.dlp.v2.LargeCustomDictionaryConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_LargeCustomDictionaryConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_LargeCustomDictionaryConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.class,
              com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getOutputPathFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      outputPath_ = null;
      if (outputPathBuilder_ != null) {
        outputPathBuilder_.dispose();
        outputPathBuilder_ = null;
      }
      if (cloudStorageFileSetBuilder_ != null) {
        cloudStorageFileSetBuilder_.clear();
      }
      if (bigQueryFieldBuilder_ != null) {
        bigQueryFieldBuilder_.clear();
      }
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_LargeCustomDictionaryConfig_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.LargeCustomDictionaryConfig getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.LargeCustomDictionaryConfig build() {
      com.google.privacy.dlp.v2.LargeCustomDictionaryConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.LargeCustomDictionaryConfig buildPartial() {
      com.google.privacy.dlp.v2.LargeCustomDictionaryConfig result =
          new com.google.privacy.dlp.v2.LargeCustomDictionaryConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.LargeCustomDictionaryConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.outputPath_ = outputPathBuilder_ == null ? outputPath_ : outputPathBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.LargeCustomDictionaryConfig result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 2 && cloudStorageFileSetBuilder_ != null) {
        result.source_ = cloudStorageFileSetBuilder_.build();
      }
      if (sourceCase_ == 3 && bigQueryFieldBuilder_ != null) {
        result.source_ = bigQueryFieldBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.LargeCustomDictionaryConfig) {
        return mergeFrom((com.google.privacy.dlp.v2.LargeCustomDictionaryConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.LargeCustomDictionaryConfig other) {
      if (other == com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.getDefaultInstance())
        return this;
      if (other.hasOutputPath()) {
        mergeOutputPath(other.getOutputPath());
      }
      switch (other.getSourceCase()) {
        case CLOUD_STORAGE_FILE_SET:
          {
            mergeCloudStorageFileSet(other.getCloudStorageFileSet());
            break;
          }
        case BIG_QUERY_FIELD:
          {
            mergeBigQueryField(other.getBigQueryField());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getOutputPathFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getCloudStorageFileSetFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getBigQueryFieldFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.CloudStoragePath outputPath_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CloudStoragePath,
            com.google.privacy.dlp.v2.CloudStoragePath.Builder,
            com.google.privacy.dlp.v2.CloudStoragePathOrBuilder>
        outputPathBuilder_;
    /**
     *
     *
     * <pre>
     * Location to store dictionary artifacts in Cloud Storage. These files
     * will only be accessible by project owners and the DLP API. If any of these
     * artifacts are modified, the dictionary is considered invalid and can no
     * longer be used.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStoragePath output_path = 1;</code>
     *
     * @return Whether the outputPath field is set.
     */
    public boolean hasOutputPath() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Location to store dictionary artifacts in Cloud Storage. These files
     * will only be accessible by project owners and the DLP API. If any of these
     * artifacts are modified, the dictionary is considered invalid and can no
     * longer be used.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStoragePath output_path = 1;</code>
     *
     * @return The outputPath.
     */
    public com.google.privacy.dlp.v2.CloudStoragePath getOutputPath() {
      if (outputPathBuilder_ == null) {
        return outputPath_ == null
            ? com.google.privacy.dlp.v2.CloudStoragePath.getDefaultInstance()
            : outputPath_;
      } else {
        return outputPathBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Location to store dictionary artifacts in Cloud Storage. These files
     * will only be accessible by project owners and the DLP API. If any of these
     * artifacts are modified, the dictionary is considered invalid and can no
     * longer be used.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStoragePath output_path = 1;</code>
     */
    public Builder setOutputPath(com.google.privacy.dlp.v2.CloudStoragePath value) {
      if (outputPathBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputPath_ = value;
      } else {
        outputPathBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location to store dictionary artifacts in Cloud Storage. These files
     * will only be accessible by project owners and the DLP API. If any of these
     * artifacts are modified, the dictionary is considered invalid and can no
     * longer be used.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStoragePath output_path = 1;</code>
     */
    public Builder setOutputPath(
        com.google.privacy.dlp.v2.CloudStoragePath.Builder builderForValue) {
      if (outputPathBuilder_ == null) {
        outputPath_ = builderForValue.build();
      } else {
        outputPathBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location to store dictionary artifacts in Cloud Storage. These files
     * will only be accessible by project owners and the DLP API. If any of these
     * artifacts are modified, the dictionary is considered invalid and can no
     * longer be used.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStoragePath output_path = 1;</code>
     */
    public Builder mergeOutputPath(com.google.privacy.dlp.v2.CloudStoragePath value) {
      if (outputPathBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && outputPath_ != null
            && outputPath_ != com.google.privacy.dlp.v2.CloudStoragePath.getDefaultInstance()) {
          getOutputPathBuilder().mergeFrom(value);
        } else {
          outputPath_ = value;
        }
      } else {
        outputPathBuilder_.mergeFrom(value);
      }
      if (outputPath_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location to store dictionary artifacts in Cloud Storage. These files
     * will only be accessible by project owners and the DLP API. If any of these
     * artifacts are modified, the dictionary is considered invalid and can no
     * longer be used.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStoragePath output_path = 1;</code>
     */
    public Builder clearOutputPath() {
      bitField0_ = (bitField0_ & ~0x00000001);
      outputPath_ = null;
      if (outputPathBuilder_ != null) {
        outputPathBuilder_.dispose();
        outputPathBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location to store dictionary artifacts in Cloud Storage. These files
     * will only be accessible by project owners and the DLP API. If any of these
     * artifacts are modified, the dictionary is considered invalid and can no
     * longer be used.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStoragePath output_path = 1;</code>
     */
    public com.google.privacy.dlp.v2.CloudStoragePath.Builder getOutputPathBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getOutputPathFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Location to store dictionary artifacts in Cloud Storage. These files
     * will only be accessible by project owners and the DLP API. If any of these
     * artifacts are modified, the dictionary is considered invalid and can no
     * longer be used.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStoragePath output_path = 1;</code>
     */
    public com.google.privacy.dlp.v2.CloudStoragePathOrBuilder getOutputPathOrBuilder() {
      if (outputPathBuilder_ != null) {
        return outputPathBuilder_.getMessageOrBuilder();
      } else {
        return outputPath_ == null
            ? com.google.privacy.dlp.v2.CloudStoragePath.getDefaultInstance()
            : outputPath_;
      }
    }
    /**
     *
     *
     * <pre>
     * Location to store dictionary artifacts in Cloud Storage. These files
     * will only be accessible by project owners and the DLP API. If any of these
     * artifacts are modified, the dictionary is considered invalid and can no
     * longer be used.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStoragePath output_path = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CloudStoragePath,
            com.google.privacy.dlp.v2.CloudStoragePath.Builder,
            com.google.privacy.dlp.v2.CloudStoragePathOrBuilder>
        getOutputPathFieldBuilder() {
      if (outputPathBuilder_ == null) {
        outputPathBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CloudStoragePath,
                com.google.privacy.dlp.v2.CloudStoragePath.Builder,
                com.google.privacy.dlp.v2.CloudStoragePathOrBuilder>(
                getOutputPath(), getParentForChildren(), isClean());
        outputPath_ = null;
      }
      return outputPathBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CloudStorageFileSet,
            com.google.privacy.dlp.v2.CloudStorageFileSet.Builder,
            com.google.privacy.dlp.v2.CloudStorageFileSetOrBuilder>
        cloudStorageFileSetBuilder_;
    /**
     *
     *
     * <pre>
     * Set of files containing newline-delimited lists of dictionary phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageFileSet cloud_storage_file_set = 2;</code>
     *
     * @return Whether the cloudStorageFileSet field is set.
     */
    @java.lang.Override
    public boolean hasCloudStorageFileSet() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Set of files containing newline-delimited lists of dictionary phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageFileSet cloud_storage_file_set = 2;</code>
     *
     * @return The cloudStorageFileSet.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudStorageFileSet getCloudStorageFileSet() {
      if (cloudStorageFileSetBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.privacy.dlp.v2.CloudStorageFileSet) source_;
        }
        return com.google.privacy.dlp.v2.CloudStorageFileSet.getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return cloudStorageFileSetBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.CloudStorageFileSet.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of files containing newline-delimited lists of dictionary phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageFileSet cloud_storage_file_set = 2;</code>
     */
    public Builder setCloudStorageFileSet(com.google.privacy.dlp.v2.CloudStorageFileSet value) {
      if (cloudStorageFileSetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        cloudStorageFileSetBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of files containing newline-delimited lists of dictionary phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageFileSet cloud_storage_file_set = 2;</code>
     */
    public Builder setCloudStorageFileSet(
        com.google.privacy.dlp.v2.CloudStorageFileSet.Builder builderForValue) {
      if (cloudStorageFileSetBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        cloudStorageFileSetBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of files containing newline-delimited lists of dictionary phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageFileSet cloud_storage_file_set = 2;</code>
     */
    public Builder mergeCloudStorageFileSet(com.google.privacy.dlp.v2.CloudStorageFileSet value) {
      if (cloudStorageFileSetBuilder_ == null) {
        if (sourceCase_ == 2
            && source_ != com.google.privacy.dlp.v2.CloudStorageFileSet.getDefaultInstance()) {
          source_ =
              com.google.privacy.dlp.v2.CloudStorageFileSet.newBuilder(
                      (com.google.privacy.dlp.v2.CloudStorageFileSet) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          cloudStorageFileSetBuilder_.mergeFrom(value);
        } else {
          cloudStorageFileSetBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of files containing newline-delimited lists of dictionary phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageFileSet cloud_storage_file_set = 2;</code>
     */
    public Builder clearCloudStorageFileSet() {
      if (cloudStorageFileSetBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        cloudStorageFileSetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of files containing newline-delimited lists of dictionary phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageFileSet cloud_storage_file_set = 2;</code>
     */
    public com.google.privacy.dlp.v2.CloudStorageFileSet.Builder getCloudStorageFileSetBuilder() {
      return getCloudStorageFileSetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Set of files containing newline-delimited lists of dictionary phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageFileSet cloud_storage_file_set = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudStorageFileSetOrBuilder
        getCloudStorageFileSetOrBuilder() {
      if ((sourceCase_ == 2) && (cloudStorageFileSetBuilder_ != null)) {
        return cloudStorageFileSetBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.privacy.dlp.v2.CloudStorageFileSet) source_;
        }
        return com.google.privacy.dlp.v2.CloudStorageFileSet.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of files containing newline-delimited lists of dictionary phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageFileSet cloud_storage_file_set = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CloudStorageFileSet,
            com.google.privacy.dlp.v2.CloudStorageFileSet.Builder,
            com.google.privacy.dlp.v2.CloudStorageFileSetOrBuilder>
        getCloudStorageFileSetFieldBuilder() {
      if (cloudStorageFileSetBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ = com.google.privacy.dlp.v2.CloudStorageFileSet.getDefaultInstance();
        }
        cloudStorageFileSetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CloudStorageFileSet,
                com.google.privacy.dlp.v2.CloudStorageFileSet.Builder,
                com.google.privacy.dlp.v2.CloudStorageFileSetOrBuilder>(
                (com.google.privacy.dlp.v2.CloudStorageFileSet) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      return cloudStorageFileSetBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BigQueryField,
            com.google.privacy.dlp.v2.BigQueryField.Builder,
            com.google.privacy.dlp.v2.BigQueryFieldOrBuilder>
        bigQueryFieldBuilder_;
    /**
     *
     *
     * <pre>
     * Field in a BigQuery table where each cell represents a dictionary phrase.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryField big_query_field = 3;</code>
     *
     * @return Whether the bigQueryField field is set.
     */
    @java.lang.Override
    public boolean hasBigQueryField() {
      return sourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Field in a BigQuery table where each cell represents a dictionary phrase.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryField big_query_field = 3;</code>
     *
     * @return The bigQueryField.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryField getBigQueryField() {
      if (bigQueryFieldBuilder_ == null) {
        if (sourceCase_ == 3) {
          return (com.google.privacy.dlp.v2.BigQueryField) source_;
        }
        return com.google.privacy.dlp.v2.BigQueryField.getDefaultInstance();
      } else {
        if (sourceCase_ == 3) {
          return bigQueryFieldBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.BigQueryField.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Field in a BigQuery table where each cell represents a dictionary phrase.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryField big_query_field = 3;</code>
     */
    public Builder setBigQueryField(com.google.privacy.dlp.v2.BigQueryField value) {
      if (bigQueryFieldBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        bigQueryFieldBuilder_.setMessage(value);
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Field in a BigQuery table where each cell represents a dictionary phrase.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryField big_query_field = 3;</code>
     */
    public Builder setBigQueryField(
        com.google.privacy.dlp.v2.BigQueryField.Builder builderForValue) {
      if (bigQueryFieldBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        bigQueryFieldBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Field in a BigQuery table where each cell represents a dictionary phrase.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryField big_query_field = 3;</code>
     */
    public Builder mergeBigQueryField(com.google.privacy.dlp.v2.BigQueryField value) {
      if (bigQueryFieldBuilder_ == null) {
        if (sourceCase_ == 3
            && source_ != com.google.privacy.dlp.v2.BigQueryField.getDefaultInstance()) {
          source_ =
              com.google.privacy.dlp.v2.BigQueryField.newBuilder(
                      (com.google.privacy.dlp.v2.BigQueryField) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 3) {
          bigQueryFieldBuilder_.mergeFrom(value);
        } else {
          bigQueryFieldBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Field in a BigQuery table where each cell represents a dictionary phrase.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryField big_query_field = 3;</code>
     */
    public Builder clearBigQueryField() {
      if (bigQueryFieldBuilder_ == null) {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
        }
        bigQueryFieldBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Field in a BigQuery table where each cell represents a dictionary phrase.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryField big_query_field = 3;</code>
     */
    public com.google.privacy.dlp.v2.BigQueryField.Builder getBigQueryFieldBuilder() {
      return getBigQueryFieldFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Field in a BigQuery table where each cell represents a dictionary phrase.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryField big_query_field = 3;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryFieldOrBuilder getBigQueryFieldOrBuilder() {
      if ((sourceCase_ == 3) && (bigQueryFieldBuilder_ != null)) {
        return bigQueryFieldBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 3) {
          return (com.google.privacy.dlp.v2.BigQueryField) source_;
        }
        return com.google.privacy.dlp.v2.BigQueryField.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Field in a BigQuery table where each cell represents a dictionary phrase.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryField big_query_field = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BigQueryField,
            com.google.privacy.dlp.v2.BigQueryField.Builder,
            com.google.privacy.dlp.v2.BigQueryFieldOrBuilder>
        getBigQueryFieldFieldBuilder() {
      if (bigQueryFieldBuilder_ == null) {
        if (!(sourceCase_ == 3)) {
          source_ = com.google.privacy.dlp.v2.BigQueryField.getDefaultInstance();
        }
        bigQueryFieldBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.BigQueryField,
                com.google.privacy.dlp.v2.BigQueryField.Builder,
                com.google.privacy.dlp.v2.BigQueryFieldOrBuilder>(
                (com.google.privacy.dlp.v2.BigQueryField) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 3;
      onChanged();
      return bigQueryFieldBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.LargeCustomDictionaryConfig)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.LargeCustomDictionaryConfig)
  private static final com.google.privacy.dlp.v2.LargeCustomDictionaryConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.LargeCustomDictionaryConfig();
  }

  public static com.google.privacy.dlp.v2.LargeCustomDictionaryConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LargeCustomDictionaryConfig> PARSER =
      new com.google.protobuf.AbstractParser<LargeCustomDictionaryConfig>() {
        @java.lang.Override
        public LargeCustomDictionaryConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LargeCustomDictionaryConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LargeCustomDictionaryConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.LargeCustomDictionaryConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
