/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Cloud repository for storing output.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.OutputStorageConfig}
 */
public final class OutputStorageConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.OutputStorageConfig)
    OutputStorageConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OutputStorageConfig.newBuilder() to construct.
  private OutputStorageConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OutputStorageConfig() {
    outputSchema_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OutputStorageConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_OutputStorageConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_OutputStorageConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.OutputStorageConfig.class,
            com.google.privacy.dlp.v2.OutputStorageConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Predefined schemas for storing findings.
   * Only for use with external storage.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.OutputStorageConfig.OutputSchema}
   */
  public enum OutputSchema implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>OUTPUT_SCHEMA_UNSPECIFIED = 0;</code>
     */
    OUTPUT_SCHEMA_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Basic schema including only `info_type`, `quote`, `certainty`, and
     * `timestamp`.
     * </pre>
     *
     * <code>BASIC_COLUMNS = 1;</code>
     */
    BASIC_COLUMNS(1),
    /**
     *
     *
     * <pre>
     * Schema tailored to findings from scanning Cloud Storage.
     * </pre>
     *
     * <code>GCS_COLUMNS = 2;</code>
     */
    GCS_COLUMNS(2),
    /**
     *
     *
     * <pre>
     * Schema tailored to findings from scanning Google Datastore.
     * </pre>
     *
     * <code>DATASTORE_COLUMNS = 3;</code>
     */
    DATASTORE_COLUMNS(3),
    /**
     *
     *
     * <pre>
     * Schema tailored to findings from scanning Google BigQuery.
     * </pre>
     *
     * <code>BIG_QUERY_COLUMNS = 4;</code>
     */
    BIG_QUERY_COLUMNS(4),
    /**
     *
     *
     * <pre>
     * Schema containing all columns.
     * </pre>
     *
     * <code>ALL_COLUMNS = 5;</code>
     */
    ALL_COLUMNS(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>OUTPUT_SCHEMA_UNSPECIFIED = 0;</code>
     */
    public static final int OUTPUT_SCHEMA_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Basic schema including only `info_type`, `quote`, `certainty`, and
     * `timestamp`.
     * </pre>
     *
     * <code>BASIC_COLUMNS = 1;</code>
     */
    public static final int BASIC_COLUMNS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Schema tailored to findings from scanning Cloud Storage.
     * </pre>
     *
     * <code>GCS_COLUMNS = 2;</code>
     */
    public static final int GCS_COLUMNS_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Schema tailored to findings from scanning Google Datastore.
     * </pre>
     *
     * <code>DATASTORE_COLUMNS = 3;</code>
     */
    public static final int DATASTORE_COLUMNS_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Schema tailored to findings from scanning Google BigQuery.
     * </pre>
     *
     * <code>BIG_QUERY_COLUMNS = 4;</code>
     */
    public static final int BIG_QUERY_COLUMNS_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Schema containing all columns.
     * </pre>
     *
     * <code>ALL_COLUMNS = 5;</code>
     */
    public static final int ALL_COLUMNS_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OutputSchema valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static OutputSchema forNumber(int value) {
      switch (value) {
        case 0:
          return OUTPUT_SCHEMA_UNSPECIFIED;
        case 1:
          return BASIC_COLUMNS;
        case 2:
          return GCS_COLUMNS;
        case 3:
          return DATASTORE_COLUMNS;
        case 4:
          return BIG_QUERY_COLUMNS;
        case 5:
          return ALL_COLUMNS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<OutputSchema> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<OutputSchema> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<OutputSchema>() {
          public OutputSchema findValueByNumber(int number) {
            return OutputSchema.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.OutputStorageConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final OutputSchema[] VALUES = values();

    public static OutputSchema valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private OutputSchema(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.OutputStorageConfig.OutputSchema)
  }

  private int typeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object type_;

  public enum TypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TABLE(1),
    TYPE_NOT_SET(0);
    private final int value;

    private TypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TypeCase forNumber(int value) {
      switch (value) {
        case 1:
          return TABLE;
        case 0:
          return TYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TypeCase getTypeCase() {
    return TypeCase.forNumber(typeCase_);
  }

  public static final int TABLE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Store findings in an existing table or a new table in an existing
   * dataset. If table_id is not set a new one will be generated
   * for you with the following format:
   * dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific time zone will be used
   * for generating the date details.
   *
   * For Inspect, each column in an existing output table must have the same
   * name, type, and mode of a field in the `Finding` object.
   *
   * For Risk, an existing output table should be the output of a previous
   * Risk analysis job run on the same source table, with the same privacy
   * metric and quasi-identifiers. Risk jobs that analyze the same table but
   * compute a different privacy metric, or use different sets of
   * quasi-identifiers, cannot store their results in the same table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTable table = 1;</code>
   *
   * @return Whether the table field is set.
   */
  @java.lang.Override
  public boolean hasTable() {
    return typeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Store findings in an existing table or a new table in an existing
   * dataset. If table_id is not set a new one will be generated
   * for you with the following format:
   * dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific time zone will be used
   * for generating the date details.
   *
   * For Inspect, each column in an existing output table must have the same
   * name, type, and mode of a field in the `Finding` object.
   *
   * For Risk, an existing output table should be the output of a previous
   * Risk analysis job run on the same source table, with the same privacy
   * metric and quasi-identifiers. Risk jobs that analyze the same table but
   * compute a different privacy metric, or use different sets of
   * quasi-identifiers, cannot store their results in the same table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTable table = 1;</code>
   *
   * @return The table.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryTable getTable() {
    if (typeCase_ == 1) {
      return (com.google.privacy.dlp.v2.BigQueryTable) type_;
    }
    return com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Store findings in an existing table or a new table in an existing
   * dataset. If table_id is not set a new one will be generated
   * for you with the following format:
   * dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific time zone will be used
   * for generating the date details.
   *
   * For Inspect, each column in an existing output table must have the same
   * name, type, and mode of a field in the `Finding` object.
   *
   * For Risk, an existing output table should be the output of a previous
   * Risk analysis job run on the same source table, with the same privacy
   * metric and quasi-identifiers. Risk jobs that analyze the same table but
   * compute a different privacy metric, or use different sets of
   * quasi-identifiers, cannot store their results in the same table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTable table = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryTableOrBuilder getTableOrBuilder() {
    if (typeCase_ == 1) {
      return (com.google.privacy.dlp.v2.BigQueryTable) type_;
    }
    return com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance();
  }

  public static final int OUTPUT_SCHEMA_FIELD_NUMBER = 3;
  private int outputSchema_ = 0;
  /**
   *
   *
   * <pre>
   * Schema used for writing the findings for Inspect jobs. This field is only
   * used for Inspect and must be unspecified for Risk jobs. Columns are derived
   * from the `Finding` object. If appending to an existing table, any columns
   * from the predefined schema that are missing will be added. No columns in
   * the existing table will be deleted.
   *
   * If unspecified, then all available columns will be used for a new table or
   * an (existing) table with no schema, and no changes will be made to an
   * existing table that has a schema.
   * Only for use with external storage.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema output_schema = 3;</code>
   *
   * @return The enum numeric value on the wire for outputSchema.
   */
  @java.lang.Override
  public int getOutputSchemaValue() {
    return outputSchema_;
  }
  /**
   *
   *
   * <pre>
   * Schema used for writing the findings for Inspect jobs. This field is only
   * used for Inspect and must be unspecified for Risk jobs. Columns are derived
   * from the `Finding` object. If appending to an existing table, any columns
   * from the predefined schema that are missing will be added. No columns in
   * the existing table will be deleted.
   *
   * If unspecified, then all available columns will be used for a new table or
   * an (existing) table with no schema, and no changes will be made to an
   * existing table that has a schema.
   * Only for use with external storage.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema output_schema = 3;</code>
   *
   * @return The outputSchema.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema getOutputSchema() {
    com.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema result =
        com.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema.forNumber(outputSchema_);
    return result == null
        ? com.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (typeCase_ == 1) {
      output.writeMessage(1, (com.google.privacy.dlp.v2.BigQueryTable) type_);
    }
    if (outputSchema_
        != com.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema.OUTPUT_SCHEMA_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, outputSchema_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (typeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.privacy.dlp.v2.BigQueryTable) type_);
    }
    if (outputSchema_
        != com.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema.OUTPUT_SCHEMA_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, outputSchema_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.OutputStorageConfig)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.OutputStorageConfig other =
        (com.google.privacy.dlp.v2.OutputStorageConfig) obj;

    if (outputSchema_ != other.outputSchema_) return false;
    if (!getTypeCase().equals(other.getTypeCase())) return false;
    switch (typeCase_) {
      case 1:
        if (!getTable().equals(other.getTable())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + OUTPUT_SCHEMA_FIELD_NUMBER;
    hash = (53 * hash) + outputSchema_;
    switch (typeCase_) {
      case 1:
        hash = (37 * hash) + TABLE_FIELD_NUMBER;
        hash = (53 * hash) + getTable().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.OutputStorageConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.OutputStorageConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.OutputStorageConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.OutputStorageConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.OutputStorageConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.OutputStorageConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.OutputStorageConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.OutputStorageConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.OutputStorageConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.OutputStorageConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.OutputStorageConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.OutputStorageConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.OutputStorageConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Cloud repository for storing output.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.OutputStorageConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.OutputStorageConfig)
      com.google.privacy.dlp.v2.OutputStorageConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_OutputStorageConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_OutputStorageConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.OutputStorageConfig.class,
              com.google.privacy.dlp.v2.OutputStorageConfig.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.OutputStorageConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (tableBuilder_ != null) {
        tableBuilder_.clear();
      }
      outputSchema_ = 0;
      typeCase_ = 0;
      type_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_OutputStorageConfig_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.OutputStorageConfig getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.OutputStorageConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.OutputStorageConfig build() {
      com.google.privacy.dlp.v2.OutputStorageConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.OutputStorageConfig buildPartial() {
      com.google.privacy.dlp.v2.OutputStorageConfig result =
          new com.google.privacy.dlp.v2.OutputStorageConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.OutputStorageConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.outputSchema_ = outputSchema_;
      }
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.OutputStorageConfig result) {
      result.typeCase_ = typeCase_;
      result.type_ = this.type_;
      if (typeCase_ == 1 && tableBuilder_ != null) {
        result.type_ = tableBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.OutputStorageConfig) {
        return mergeFrom((com.google.privacy.dlp.v2.OutputStorageConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.OutputStorageConfig other) {
      if (other == com.google.privacy.dlp.v2.OutputStorageConfig.getDefaultInstance()) return this;
      if (other.outputSchema_ != 0) {
        setOutputSchemaValue(other.getOutputSchemaValue());
      }
      switch (other.getTypeCase()) {
        case TABLE:
          {
            mergeTable(other.getTable());
            break;
          }
        case TYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTableFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 1;
                break;
              } // case 10
            case 24:
              {
                outputSchema_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int typeCase_ = 0;
    private java.lang.Object type_;

    public TypeCase getTypeCase() {
      return TypeCase.forNumber(typeCase_);
    }

    public Builder clearType() {
      typeCase_ = 0;
      type_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BigQueryTable,
            com.google.privacy.dlp.v2.BigQueryTable.Builder,
            com.google.privacy.dlp.v2.BigQueryTableOrBuilder>
        tableBuilder_;
    /**
     *
     *
     * <pre>
     * Store findings in an existing table or a new table in an existing
     * dataset. If table_id is not set a new one will be generated
     * for you with the following format:
     * dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific time zone will be used
     * for generating the date details.
     *
     * For Inspect, each column in an existing output table must have the same
     * name, type, and mode of a field in the `Finding` object.
     *
     * For Risk, an existing output table should be the output of a previous
     * Risk analysis job run on the same source table, with the same privacy
     * metric and quasi-identifiers. Risk jobs that analyze the same table but
     * compute a different privacy metric, or use different sets of
     * quasi-identifiers, cannot store their results in the same table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table = 1;</code>
     *
     * @return Whether the table field is set.
     */
    @java.lang.Override
    public boolean hasTable() {
      return typeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Store findings in an existing table or a new table in an existing
     * dataset. If table_id is not set a new one will be generated
     * for you with the following format:
     * dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific time zone will be used
     * for generating the date details.
     *
     * For Inspect, each column in an existing output table must have the same
     * name, type, and mode of a field in the `Finding` object.
     *
     * For Risk, an existing output table should be the output of a previous
     * Risk analysis job run on the same source table, with the same privacy
     * metric and quasi-identifiers. Risk jobs that analyze the same table but
     * compute a different privacy metric, or use different sets of
     * quasi-identifiers, cannot store their results in the same table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table = 1;</code>
     *
     * @return The table.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryTable getTable() {
      if (tableBuilder_ == null) {
        if (typeCase_ == 1) {
          return (com.google.privacy.dlp.v2.BigQueryTable) type_;
        }
        return com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance();
      } else {
        if (typeCase_ == 1) {
          return tableBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Store findings in an existing table or a new table in an existing
     * dataset. If table_id is not set a new one will be generated
     * for you with the following format:
     * dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific time zone will be used
     * for generating the date details.
     *
     * For Inspect, each column in an existing output table must have the same
     * name, type, and mode of a field in the `Finding` object.
     *
     * For Risk, an existing output table should be the output of a previous
     * Risk analysis job run on the same source table, with the same privacy
     * metric and quasi-identifiers. Risk jobs that analyze the same table but
     * compute a different privacy metric, or use different sets of
     * quasi-identifiers, cannot store their results in the same table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table = 1;</code>
     */
    public Builder setTable(com.google.privacy.dlp.v2.BigQueryTable value) {
      if (tableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        tableBuilder_.setMessage(value);
      }
      typeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Store findings in an existing table or a new table in an existing
     * dataset. If table_id is not set a new one will be generated
     * for you with the following format:
     * dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific time zone will be used
     * for generating the date details.
     *
     * For Inspect, each column in an existing output table must have the same
     * name, type, and mode of a field in the `Finding` object.
     *
     * For Risk, an existing output table should be the output of a previous
     * Risk analysis job run on the same source table, with the same privacy
     * metric and quasi-identifiers. Risk jobs that analyze the same table but
     * compute a different privacy metric, or use different sets of
     * quasi-identifiers, cannot store their results in the same table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table = 1;</code>
     */
    public Builder setTable(com.google.privacy.dlp.v2.BigQueryTable.Builder builderForValue) {
      if (tableBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        tableBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Store findings in an existing table or a new table in an existing
     * dataset. If table_id is not set a new one will be generated
     * for you with the following format:
     * dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific time zone will be used
     * for generating the date details.
     *
     * For Inspect, each column in an existing output table must have the same
     * name, type, and mode of a field in the `Finding` object.
     *
     * For Risk, an existing output table should be the output of a previous
     * Risk analysis job run on the same source table, with the same privacy
     * metric and quasi-identifiers. Risk jobs that analyze the same table but
     * compute a different privacy metric, or use different sets of
     * quasi-identifiers, cannot store their results in the same table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table = 1;</code>
     */
    public Builder mergeTable(com.google.privacy.dlp.v2.BigQueryTable value) {
      if (tableBuilder_ == null) {
        if (typeCase_ == 1
            && type_ != com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance()) {
          type_ =
              com.google.privacy.dlp.v2.BigQueryTable.newBuilder(
                      (com.google.privacy.dlp.v2.BigQueryTable) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 1) {
          tableBuilder_.mergeFrom(value);
        } else {
          tableBuilder_.setMessage(value);
        }
      }
      typeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Store findings in an existing table or a new table in an existing
     * dataset. If table_id is not set a new one will be generated
     * for you with the following format:
     * dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific time zone will be used
     * for generating the date details.
     *
     * For Inspect, each column in an existing output table must have the same
     * name, type, and mode of a field in the `Finding` object.
     *
     * For Risk, an existing output table should be the output of a previous
     * Risk analysis job run on the same source table, with the same privacy
     * metric and quasi-identifiers. Risk jobs that analyze the same table but
     * compute a different privacy metric, or use different sets of
     * quasi-identifiers, cannot store their results in the same table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table = 1;</code>
     */
    public Builder clearTable() {
      if (tableBuilder_ == null) {
        if (typeCase_ == 1) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 1) {
          typeCase_ = 0;
          type_ = null;
        }
        tableBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Store findings in an existing table or a new table in an existing
     * dataset. If table_id is not set a new one will be generated
     * for you with the following format:
     * dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific time zone will be used
     * for generating the date details.
     *
     * For Inspect, each column in an existing output table must have the same
     * name, type, and mode of a field in the `Finding` object.
     *
     * For Risk, an existing output table should be the output of a previous
     * Risk analysis job run on the same source table, with the same privacy
     * metric and quasi-identifiers. Risk jobs that analyze the same table but
     * compute a different privacy metric, or use different sets of
     * quasi-identifiers, cannot store their results in the same table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table = 1;</code>
     */
    public com.google.privacy.dlp.v2.BigQueryTable.Builder getTableBuilder() {
      return getTableFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Store findings in an existing table or a new table in an existing
     * dataset. If table_id is not set a new one will be generated
     * for you with the following format:
     * dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific time zone will be used
     * for generating the date details.
     *
     * For Inspect, each column in an existing output table must have the same
     * name, type, and mode of a field in the `Finding` object.
     *
     * For Risk, an existing output table should be the output of a previous
     * Risk analysis job run on the same source table, with the same privacy
     * metric and quasi-identifiers. Risk jobs that analyze the same table but
     * compute a different privacy metric, or use different sets of
     * quasi-identifiers, cannot store their results in the same table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryTableOrBuilder getTableOrBuilder() {
      if ((typeCase_ == 1) && (tableBuilder_ != null)) {
        return tableBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 1) {
          return (com.google.privacy.dlp.v2.BigQueryTable) type_;
        }
        return com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Store findings in an existing table or a new table in an existing
     * dataset. If table_id is not set a new one will be generated
     * for you with the following format:
     * dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific time zone will be used
     * for generating the date details.
     *
     * For Inspect, each column in an existing output table must have the same
     * name, type, and mode of a field in the `Finding` object.
     *
     * For Risk, an existing output table should be the output of a previous
     * Risk analysis job run on the same source table, with the same privacy
     * metric and quasi-identifiers. Risk jobs that analyze the same table but
     * compute a different privacy metric, or use different sets of
     * quasi-identifiers, cannot store their results in the same table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BigQueryTable,
            com.google.privacy.dlp.v2.BigQueryTable.Builder,
            com.google.privacy.dlp.v2.BigQueryTableOrBuilder>
        getTableFieldBuilder() {
      if (tableBuilder_ == null) {
        if (!(typeCase_ == 1)) {
          type_ = com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance();
        }
        tableBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.BigQueryTable,
                com.google.privacy.dlp.v2.BigQueryTable.Builder,
                com.google.privacy.dlp.v2.BigQueryTableOrBuilder>(
                (com.google.privacy.dlp.v2.BigQueryTable) type_, getParentForChildren(), isClean());
        type_ = null;
      }
      typeCase_ = 1;
      onChanged();
      return tableBuilder_;
    }

    private int outputSchema_ = 0;
    /**
     *
     *
     * <pre>
     * Schema used for writing the findings for Inspect jobs. This field is only
     * used for Inspect and must be unspecified for Risk jobs. Columns are derived
     * from the `Finding` object. If appending to an existing table, any columns
     * from the predefined schema that are missing will be added. No columns in
     * the existing table will be deleted.
     *
     * If unspecified, then all available columns will be used for a new table or
     * an (existing) table with no schema, and no changes will be made to an
     * existing table that has a schema.
     * Only for use with external storage.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema output_schema = 3;</code>
     *
     * @return The enum numeric value on the wire for outputSchema.
     */
    @java.lang.Override
    public int getOutputSchemaValue() {
      return outputSchema_;
    }
    /**
     *
     *
     * <pre>
     * Schema used for writing the findings for Inspect jobs. This field is only
     * used for Inspect and must be unspecified for Risk jobs. Columns are derived
     * from the `Finding` object. If appending to an existing table, any columns
     * from the predefined schema that are missing will be added. No columns in
     * the existing table will be deleted.
     *
     * If unspecified, then all available columns will be used for a new table or
     * an (existing) table with no schema, and no changes will be made to an
     * existing table that has a schema.
     * Only for use with external storage.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema output_schema = 3;</code>
     *
     * @param value The enum numeric value on the wire for outputSchema to set.
     * @return This builder for chaining.
     */
    public Builder setOutputSchemaValue(int value) {
      outputSchema_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Schema used for writing the findings for Inspect jobs. This field is only
     * used for Inspect and must be unspecified for Risk jobs. Columns are derived
     * from the `Finding` object. If appending to an existing table, any columns
     * from the predefined schema that are missing will be added. No columns in
     * the existing table will be deleted.
     *
     * If unspecified, then all available columns will be used for a new table or
     * an (existing) table with no schema, and no changes will be made to an
     * existing table that has a schema.
     * Only for use with external storage.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema output_schema = 3;</code>
     *
     * @return The outputSchema.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema getOutputSchema() {
      com.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema result =
          com.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema.forNumber(outputSchema_);
      return result == null
          ? com.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Schema used for writing the findings for Inspect jobs. This field is only
     * used for Inspect and must be unspecified for Risk jobs. Columns are derived
     * from the `Finding` object. If appending to an existing table, any columns
     * from the predefined schema that are missing will be added. No columns in
     * the existing table will be deleted.
     *
     * If unspecified, then all available columns will be used for a new table or
     * an (existing) table with no schema, and no changes will be made to an
     * existing table that has a schema.
     * Only for use with external storage.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema output_schema = 3;</code>
     *
     * @param value The outputSchema to set.
     * @return This builder for chaining.
     */
    public Builder setOutputSchema(
        com.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      outputSchema_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Schema used for writing the findings for Inspect jobs. This field is only
     * used for Inspect and must be unspecified for Risk jobs. Columns are derived
     * from the `Finding` object. If appending to an existing table, any columns
     * from the predefined schema that are missing will be added. No columns in
     * the existing table will be deleted.
     *
     * If unspecified, then all available columns will be used for a new table or
     * an (existing) table with no schema, and no changes will be made to an
     * existing table that has a schema.
     * Only for use with external storage.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.OutputStorageConfig.OutputSchema output_schema = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputSchema() {
      bitField0_ = (bitField0_ & ~0x00000002);
      outputSchema_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.OutputStorageConfig)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.OutputStorageConfig)
  private static final com.google.privacy.dlp.v2.OutputStorageConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.OutputStorageConfig();
  }

  public static com.google.privacy.dlp.v2.OutputStorageConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OutputStorageConfig> PARSER =
      new com.google.protobuf.AbstractParser<OutputStorageConfig>() {
        @java.lang.Override
        public OutputStorageConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OutputStorageConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OutputStorageConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.OutputStorageConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
