/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * A rule for transforming a value.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.PrimitiveTransformation}
 */
public final class PrimitiveTransformation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.PrimitiveTransformation)
    PrimitiveTransformationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PrimitiveTransformation.newBuilder() to construct.
  private PrimitiveTransformation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PrimitiveTransformation() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PrimitiveTransformation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_PrimitiveTransformation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_PrimitiveTransformation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.PrimitiveTransformation.class,
            com.google.privacy.dlp.v2.PrimitiveTransformation.Builder.class);
  }

  private int transformationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object transformation_;

  public enum TransformationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    REPLACE_CONFIG(1),
    REDACT_CONFIG(2),
    CHARACTER_MASK_CONFIG(3),
    CRYPTO_REPLACE_FFX_FPE_CONFIG(4),
    FIXED_SIZE_BUCKETING_CONFIG(5),
    BUCKETING_CONFIG(6),
    REPLACE_WITH_INFO_TYPE_CONFIG(7),
    TIME_PART_CONFIG(8),
    CRYPTO_HASH_CONFIG(9),
    DATE_SHIFT_CONFIG(11),
    CRYPTO_DETERMINISTIC_CONFIG(12),
    REPLACE_DICTIONARY_CONFIG(13),
    TRANSFORMATION_NOT_SET(0);
    private final int value;

    private TransformationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TransformationCase valueOf(int value) {
      return forNumber(value);
    }

    public static TransformationCase forNumber(int value) {
      switch (value) {
        case 1:
          return REPLACE_CONFIG;
        case 2:
          return REDACT_CONFIG;
        case 3:
          return CHARACTER_MASK_CONFIG;
        case 4:
          return CRYPTO_REPLACE_FFX_FPE_CONFIG;
        case 5:
          return FIXED_SIZE_BUCKETING_CONFIG;
        case 6:
          return BUCKETING_CONFIG;
        case 7:
          return REPLACE_WITH_INFO_TYPE_CONFIG;
        case 8:
          return TIME_PART_CONFIG;
        case 9:
          return CRYPTO_HASH_CONFIG;
        case 11:
          return DATE_SHIFT_CONFIG;
        case 12:
          return CRYPTO_DETERMINISTIC_CONFIG;
        case 13:
          return REPLACE_DICTIONARY_CONFIG;
        case 0:
          return TRANSFORMATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TransformationCase getTransformationCase() {
    return TransformationCase.forNumber(transformationCase_);
  }

  public static final int REPLACE_CONFIG_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Replace with a specified value.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ReplaceValueConfig replace_config = 1;</code>
   *
   * @return Whether the replaceConfig field is set.
   */
  @java.lang.Override
  public boolean hasReplaceConfig() {
    return transformationCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Replace with a specified value.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ReplaceValueConfig replace_config = 1;</code>
   *
   * @return The replaceConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ReplaceValueConfig getReplaceConfig() {
    if (transformationCase_ == 1) {
      return (com.google.privacy.dlp.v2.ReplaceValueConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.ReplaceValueConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Replace with a specified value.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ReplaceValueConfig replace_config = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ReplaceValueConfigOrBuilder getReplaceConfigOrBuilder() {
    if (transformationCase_ == 1) {
      return (com.google.privacy.dlp.v2.ReplaceValueConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.ReplaceValueConfig.getDefaultInstance();
  }

  public static final int REDACT_CONFIG_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Redact
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RedactConfig redact_config = 2;</code>
   *
   * @return Whether the redactConfig field is set.
   */
  @java.lang.Override
  public boolean hasRedactConfig() {
    return transformationCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Redact
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RedactConfig redact_config = 2;</code>
   *
   * @return The redactConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RedactConfig getRedactConfig() {
    if (transformationCase_ == 2) {
      return (com.google.privacy.dlp.v2.RedactConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.RedactConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Redact
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RedactConfig redact_config = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RedactConfigOrBuilder getRedactConfigOrBuilder() {
    if (transformationCase_ == 2) {
      return (com.google.privacy.dlp.v2.RedactConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.RedactConfig.getDefaultInstance();
  }

  public static final int CHARACTER_MASK_CONFIG_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Mask
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CharacterMaskConfig character_mask_config = 3;</code>
   *
   * @return Whether the characterMaskConfig field is set.
   */
  @java.lang.Override
  public boolean hasCharacterMaskConfig() {
    return transformationCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Mask
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CharacterMaskConfig character_mask_config = 3;</code>
   *
   * @return The characterMaskConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CharacterMaskConfig getCharacterMaskConfig() {
    if (transformationCase_ == 3) {
      return (com.google.privacy.dlp.v2.CharacterMaskConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.CharacterMaskConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Mask
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CharacterMaskConfig character_mask_config = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CharacterMaskConfigOrBuilder getCharacterMaskConfigOrBuilder() {
    if (transformationCase_ == 3) {
      return (com.google.privacy.dlp.v2.CharacterMaskConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.CharacterMaskConfig.getDefaultInstance();
  }

  public static final int CRYPTO_REPLACE_FFX_FPE_CONFIG_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Ffx-Fpe
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig crypto_replace_ffx_fpe_config = 4;
   * </code>
   *
   * @return Whether the cryptoReplaceFfxFpeConfig field is set.
   */
  @java.lang.Override
  public boolean hasCryptoReplaceFfxFpeConfig() {
    return transformationCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Ffx-Fpe
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig crypto_replace_ffx_fpe_config = 4;
   * </code>
   *
   * @return The cryptoReplaceFfxFpeConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig getCryptoReplaceFfxFpeConfig() {
    if (transformationCase_ == 4) {
      return (com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Ffx-Fpe
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig crypto_replace_ffx_fpe_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfigOrBuilder
      getCryptoReplaceFfxFpeConfigOrBuilder() {
    if (transformationCase_ == 4) {
      return (com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.getDefaultInstance();
  }

  public static final int FIXED_SIZE_BUCKETING_CONFIG_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Fixed size bucketing
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.FixedSizeBucketingConfig fixed_size_bucketing_config = 5;</code>
   *
   * @return Whether the fixedSizeBucketingConfig field is set.
   */
  @java.lang.Override
  public boolean hasFixedSizeBucketingConfig() {
    return transformationCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Fixed size bucketing
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.FixedSizeBucketingConfig fixed_size_bucketing_config = 5;</code>
   *
   * @return The fixedSizeBucketingConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FixedSizeBucketingConfig getFixedSizeBucketingConfig() {
    if (transformationCase_ == 5) {
      return (com.google.privacy.dlp.v2.FixedSizeBucketingConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.FixedSizeBucketingConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Fixed size bucketing
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.FixedSizeBucketingConfig fixed_size_bucketing_config = 5;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FixedSizeBucketingConfigOrBuilder
      getFixedSizeBucketingConfigOrBuilder() {
    if (transformationCase_ == 5) {
      return (com.google.privacy.dlp.v2.FixedSizeBucketingConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.FixedSizeBucketingConfig.getDefaultInstance();
  }

  public static final int BUCKETING_CONFIG_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Bucketing
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BucketingConfig bucketing_config = 6;</code>
   *
   * @return Whether the bucketingConfig field is set.
   */
  @java.lang.Override
  public boolean hasBucketingConfig() {
    return transformationCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Bucketing
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BucketingConfig bucketing_config = 6;</code>
   *
   * @return The bucketingConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BucketingConfig getBucketingConfig() {
    if (transformationCase_ == 6) {
      return (com.google.privacy.dlp.v2.BucketingConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.BucketingConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Bucketing
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BucketingConfig bucketing_config = 6;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BucketingConfigOrBuilder getBucketingConfigOrBuilder() {
    if (transformationCase_ == 6) {
      return (com.google.privacy.dlp.v2.BucketingConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.BucketingConfig.getDefaultInstance();
  }

  public static final int REPLACE_WITH_INFO_TYPE_CONFIG_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Replace with infotype
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig replace_with_info_type_config = 7;
   * </code>
   *
   * @return Whether the replaceWithInfoTypeConfig field is set.
   */
  @java.lang.Override
  public boolean hasReplaceWithInfoTypeConfig() {
    return transformationCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Replace with infotype
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig replace_with_info_type_config = 7;
   * </code>
   *
   * @return The replaceWithInfoTypeConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig getReplaceWithInfoTypeConfig() {
    if (transformationCase_ == 7) {
      return (com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Replace with infotype
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig replace_with_info_type_config = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfigOrBuilder
      getReplaceWithInfoTypeConfigOrBuilder() {
    if (transformationCase_ == 7) {
      return (com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig.getDefaultInstance();
  }

  public static final int TIME_PART_CONFIG_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Time extraction
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TimePartConfig time_part_config = 8;</code>
   *
   * @return Whether the timePartConfig field is set.
   */
  @java.lang.Override
  public boolean hasTimePartConfig() {
    return transformationCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Time extraction
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TimePartConfig time_part_config = 8;</code>
   *
   * @return The timePartConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TimePartConfig getTimePartConfig() {
    if (transformationCase_ == 8) {
      return (com.google.privacy.dlp.v2.TimePartConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.TimePartConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Time extraction
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TimePartConfig time_part_config = 8;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TimePartConfigOrBuilder getTimePartConfigOrBuilder() {
    if (transformationCase_ == 8) {
      return (com.google.privacy.dlp.v2.TimePartConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.TimePartConfig.getDefaultInstance();
  }

  public static final int CRYPTO_HASH_CONFIG_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Crypto
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CryptoHashConfig crypto_hash_config = 9;</code>
   *
   * @return Whether the cryptoHashConfig field is set.
   */
  @java.lang.Override
  public boolean hasCryptoHashConfig() {
    return transformationCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Crypto
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CryptoHashConfig crypto_hash_config = 9;</code>
   *
   * @return The cryptoHashConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CryptoHashConfig getCryptoHashConfig() {
    if (transformationCase_ == 9) {
      return (com.google.privacy.dlp.v2.CryptoHashConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.CryptoHashConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Crypto
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CryptoHashConfig crypto_hash_config = 9;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CryptoHashConfigOrBuilder getCryptoHashConfigOrBuilder() {
    if (transformationCase_ == 9) {
      return (com.google.privacy.dlp.v2.CryptoHashConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.CryptoHashConfig.getDefaultInstance();
  }

  public static final int DATE_SHIFT_CONFIG_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Date Shift
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DateShiftConfig date_shift_config = 11;</code>
   *
   * @return Whether the dateShiftConfig field is set.
   */
  @java.lang.Override
  public boolean hasDateShiftConfig() {
    return transformationCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Date Shift
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DateShiftConfig date_shift_config = 11;</code>
   *
   * @return The dateShiftConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DateShiftConfig getDateShiftConfig() {
    if (transformationCase_ == 11) {
      return (com.google.privacy.dlp.v2.DateShiftConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.DateShiftConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Date Shift
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DateShiftConfig date_shift_config = 11;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DateShiftConfigOrBuilder getDateShiftConfigOrBuilder() {
    if (transformationCase_ == 11) {
      return (com.google.privacy.dlp.v2.DateShiftConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.DateShiftConfig.getDefaultInstance();
  }

  public static final int CRYPTO_DETERMINISTIC_CONFIG_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Deterministic Crypto
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CryptoDeterministicConfig crypto_deterministic_config = 12;</code>
   *
   * @return Whether the cryptoDeterministicConfig field is set.
   */
  @java.lang.Override
  public boolean hasCryptoDeterministicConfig() {
    return transformationCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Deterministic Crypto
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CryptoDeterministicConfig crypto_deterministic_config = 12;</code>
   *
   * @return The cryptoDeterministicConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CryptoDeterministicConfig getCryptoDeterministicConfig() {
    if (transformationCase_ == 12) {
      return (com.google.privacy.dlp.v2.CryptoDeterministicConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.CryptoDeterministicConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Deterministic Crypto
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CryptoDeterministicConfig crypto_deterministic_config = 12;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CryptoDeterministicConfigOrBuilder
      getCryptoDeterministicConfigOrBuilder() {
    if (transformationCase_ == 12) {
      return (com.google.privacy.dlp.v2.CryptoDeterministicConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.CryptoDeterministicConfig.getDefaultInstance();
  }

  public static final int REPLACE_DICTIONARY_CONFIG_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Replace with a value randomly drawn (with replacement) from a dictionary.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ReplaceDictionaryConfig replace_dictionary_config = 13;</code>
   *
   * @return Whether the replaceDictionaryConfig field is set.
   */
  @java.lang.Override
  public boolean hasReplaceDictionaryConfig() {
    return transformationCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Replace with a value randomly drawn (with replacement) from a dictionary.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ReplaceDictionaryConfig replace_dictionary_config = 13;</code>
   *
   * @return The replaceDictionaryConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ReplaceDictionaryConfig getReplaceDictionaryConfig() {
    if (transformationCase_ == 13) {
      return (com.google.privacy.dlp.v2.ReplaceDictionaryConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.ReplaceDictionaryConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Replace with a value randomly drawn (with replacement) from a dictionary.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ReplaceDictionaryConfig replace_dictionary_config = 13;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ReplaceDictionaryConfigOrBuilder
      getReplaceDictionaryConfigOrBuilder() {
    if (transformationCase_ == 13) {
      return (com.google.privacy.dlp.v2.ReplaceDictionaryConfig) transformation_;
    }
    return com.google.privacy.dlp.v2.ReplaceDictionaryConfig.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (transformationCase_ == 1) {
      output.writeMessage(1, (com.google.privacy.dlp.v2.ReplaceValueConfig) transformation_);
    }
    if (transformationCase_ == 2) {
      output.writeMessage(2, (com.google.privacy.dlp.v2.RedactConfig) transformation_);
    }
    if (transformationCase_ == 3) {
      output.writeMessage(3, (com.google.privacy.dlp.v2.CharacterMaskConfig) transformation_);
    }
    if (transformationCase_ == 4) {
      output.writeMessage(4, (com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig) transformation_);
    }
    if (transformationCase_ == 5) {
      output.writeMessage(5, (com.google.privacy.dlp.v2.FixedSizeBucketingConfig) transformation_);
    }
    if (transformationCase_ == 6) {
      output.writeMessage(6, (com.google.privacy.dlp.v2.BucketingConfig) transformation_);
    }
    if (transformationCase_ == 7) {
      output.writeMessage(7, (com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig) transformation_);
    }
    if (transformationCase_ == 8) {
      output.writeMessage(8, (com.google.privacy.dlp.v2.TimePartConfig) transformation_);
    }
    if (transformationCase_ == 9) {
      output.writeMessage(9, (com.google.privacy.dlp.v2.CryptoHashConfig) transformation_);
    }
    if (transformationCase_ == 11) {
      output.writeMessage(11, (com.google.privacy.dlp.v2.DateShiftConfig) transformation_);
    }
    if (transformationCase_ == 12) {
      output.writeMessage(
          12, (com.google.privacy.dlp.v2.CryptoDeterministicConfig) transformation_);
    }
    if (transformationCase_ == 13) {
      output.writeMessage(13, (com.google.privacy.dlp.v2.ReplaceDictionaryConfig) transformation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (transformationCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.privacy.dlp.v2.ReplaceValueConfig) transformation_);
    }
    if (transformationCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.privacy.dlp.v2.RedactConfig) transformation_);
    }
    if (transformationCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.privacy.dlp.v2.CharacterMaskConfig) transformation_);
    }
    if (transformationCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig) transformation_);
    }
    if (transformationCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.privacy.dlp.v2.FixedSizeBucketingConfig) transformation_);
    }
    if (transformationCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.privacy.dlp.v2.BucketingConfig) transformation_);
    }
    if (transformationCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig) transformation_);
    }
    if (transformationCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.privacy.dlp.v2.TimePartConfig) transformation_);
    }
    if (transformationCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.privacy.dlp.v2.CryptoHashConfig) transformation_);
    }
    if (transformationCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.privacy.dlp.v2.DateShiftConfig) transformation_);
    }
    if (transformationCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.privacy.dlp.v2.CryptoDeterministicConfig) transformation_);
    }
    if (transformationCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.privacy.dlp.v2.ReplaceDictionaryConfig) transformation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.PrimitiveTransformation)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.PrimitiveTransformation other =
        (com.google.privacy.dlp.v2.PrimitiveTransformation) obj;

    if (!getTransformationCase().equals(other.getTransformationCase())) return false;
    switch (transformationCase_) {
      case 1:
        if (!getReplaceConfig().equals(other.getReplaceConfig())) return false;
        break;
      case 2:
        if (!getRedactConfig().equals(other.getRedactConfig())) return false;
        break;
      case 3:
        if (!getCharacterMaskConfig().equals(other.getCharacterMaskConfig())) return false;
        break;
      case 4:
        if (!getCryptoReplaceFfxFpeConfig().equals(other.getCryptoReplaceFfxFpeConfig()))
          return false;
        break;
      case 5:
        if (!getFixedSizeBucketingConfig().equals(other.getFixedSizeBucketingConfig()))
          return false;
        break;
      case 6:
        if (!getBucketingConfig().equals(other.getBucketingConfig())) return false;
        break;
      case 7:
        if (!getReplaceWithInfoTypeConfig().equals(other.getReplaceWithInfoTypeConfig()))
          return false;
        break;
      case 8:
        if (!getTimePartConfig().equals(other.getTimePartConfig())) return false;
        break;
      case 9:
        if (!getCryptoHashConfig().equals(other.getCryptoHashConfig())) return false;
        break;
      case 11:
        if (!getDateShiftConfig().equals(other.getDateShiftConfig())) return false;
        break;
      case 12:
        if (!getCryptoDeterministicConfig().equals(other.getCryptoDeterministicConfig()))
          return false;
        break;
      case 13:
        if (!getReplaceDictionaryConfig().equals(other.getReplaceDictionaryConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (transformationCase_) {
      case 1:
        hash = (37 * hash) + REPLACE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getReplaceConfig().hashCode();
        break;
      case 2:
        hash = (37 * hash) + REDACT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getRedactConfig().hashCode();
        break;
      case 3:
        hash = (37 * hash) + CHARACTER_MASK_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getCharacterMaskConfig().hashCode();
        break;
      case 4:
        hash = (37 * hash) + CRYPTO_REPLACE_FFX_FPE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getCryptoReplaceFfxFpeConfig().hashCode();
        break;
      case 5:
        hash = (37 * hash) + FIXED_SIZE_BUCKETING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getFixedSizeBucketingConfig().hashCode();
        break;
      case 6:
        hash = (37 * hash) + BUCKETING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getBucketingConfig().hashCode();
        break;
      case 7:
        hash = (37 * hash) + REPLACE_WITH_INFO_TYPE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getReplaceWithInfoTypeConfig().hashCode();
        break;
      case 8:
        hash = (37 * hash) + TIME_PART_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTimePartConfig().hashCode();
        break;
      case 9:
        hash = (37 * hash) + CRYPTO_HASH_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getCryptoHashConfig().hashCode();
        break;
      case 11:
        hash = (37 * hash) + DATE_SHIFT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getDateShiftConfig().hashCode();
        break;
      case 12:
        hash = (37 * hash) + CRYPTO_DETERMINISTIC_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getCryptoDeterministicConfig().hashCode();
        break;
      case 13:
        hash = (37 * hash) + REPLACE_DICTIONARY_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getReplaceDictionaryConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.PrimitiveTransformation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.PrimitiveTransformation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.PrimitiveTransformation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.PrimitiveTransformation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.PrimitiveTransformation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.PrimitiveTransformation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.PrimitiveTransformation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.PrimitiveTransformation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.PrimitiveTransformation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.PrimitiveTransformation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.PrimitiveTransformation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.PrimitiveTransformation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.PrimitiveTransformation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A rule for transforming a value.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.PrimitiveTransformation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.PrimitiveTransformation)
      com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_PrimitiveTransformation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_PrimitiveTransformation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.PrimitiveTransformation.class,
              com.google.privacy.dlp.v2.PrimitiveTransformation.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.PrimitiveTransformation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (replaceConfigBuilder_ != null) {
        replaceConfigBuilder_.clear();
      }
      if (redactConfigBuilder_ != null) {
        redactConfigBuilder_.clear();
      }
      if (characterMaskConfigBuilder_ != null) {
        characterMaskConfigBuilder_.clear();
      }
      if (cryptoReplaceFfxFpeConfigBuilder_ != null) {
        cryptoReplaceFfxFpeConfigBuilder_.clear();
      }
      if (fixedSizeBucketingConfigBuilder_ != null) {
        fixedSizeBucketingConfigBuilder_.clear();
      }
      if (bucketingConfigBuilder_ != null) {
        bucketingConfigBuilder_.clear();
      }
      if (replaceWithInfoTypeConfigBuilder_ != null) {
        replaceWithInfoTypeConfigBuilder_.clear();
      }
      if (timePartConfigBuilder_ != null) {
        timePartConfigBuilder_.clear();
      }
      if (cryptoHashConfigBuilder_ != null) {
        cryptoHashConfigBuilder_.clear();
      }
      if (dateShiftConfigBuilder_ != null) {
        dateShiftConfigBuilder_.clear();
      }
      if (cryptoDeterministicConfigBuilder_ != null) {
        cryptoDeterministicConfigBuilder_.clear();
      }
      if (replaceDictionaryConfigBuilder_ != null) {
        replaceDictionaryConfigBuilder_.clear();
      }
      transformationCase_ = 0;
      transformation_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_PrimitiveTransformation_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.PrimitiveTransformation getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.PrimitiveTransformation build() {
      com.google.privacy.dlp.v2.PrimitiveTransformation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.PrimitiveTransformation buildPartial() {
      com.google.privacy.dlp.v2.PrimitiveTransformation result =
          new com.google.privacy.dlp.v2.PrimitiveTransformation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.PrimitiveTransformation result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.PrimitiveTransformation result) {
      result.transformationCase_ = transformationCase_;
      result.transformation_ = this.transformation_;
      if (transformationCase_ == 1 && replaceConfigBuilder_ != null) {
        result.transformation_ = replaceConfigBuilder_.build();
      }
      if (transformationCase_ == 2 && redactConfigBuilder_ != null) {
        result.transformation_ = redactConfigBuilder_.build();
      }
      if (transformationCase_ == 3 && characterMaskConfigBuilder_ != null) {
        result.transformation_ = characterMaskConfigBuilder_.build();
      }
      if (transformationCase_ == 4 && cryptoReplaceFfxFpeConfigBuilder_ != null) {
        result.transformation_ = cryptoReplaceFfxFpeConfigBuilder_.build();
      }
      if (transformationCase_ == 5 && fixedSizeBucketingConfigBuilder_ != null) {
        result.transformation_ = fixedSizeBucketingConfigBuilder_.build();
      }
      if (transformationCase_ == 6 && bucketingConfigBuilder_ != null) {
        result.transformation_ = bucketingConfigBuilder_.build();
      }
      if (transformationCase_ == 7 && replaceWithInfoTypeConfigBuilder_ != null) {
        result.transformation_ = replaceWithInfoTypeConfigBuilder_.build();
      }
      if (transformationCase_ == 8 && timePartConfigBuilder_ != null) {
        result.transformation_ = timePartConfigBuilder_.build();
      }
      if (transformationCase_ == 9 && cryptoHashConfigBuilder_ != null) {
        result.transformation_ = cryptoHashConfigBuilder_.build();
      }
      if (transformationCase_ == 11 && dateShiftConfigBuilder_ != null) {
        result.transformation_ = dateShiftConfigBuilder_.build();
      }
      if (transformationCase_ == 12 && cryptoDeterministicConfigBuilder_ != null) {
        result.transformation_ = cryptoDeterministicConfigBuilder_.build();
      }
      if (transformationCase_ == 13 && replaceDictionaryConfigBuilder_ != null) {
        result.transformation_ = replaceDictionaryConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.PrimitiveTransformation) {
        return mergeFrom((com.google.privacy.dlp.v2.PrimitiveTransformation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.PrimitiveTransformation other) {
      if (other == com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance())
        return this;
      switch (other.getTransformationCase()) {
        case REPLACE_CONFIG:
          {
            mergeReplaceConfig(other.getReplaceConfig());
            break;
          }
        case REDACT_CONFIG:
          {
            mergeRedactConfig(other.getRedactConfig());
            break;
          }
        case CHARACTER_MASK_CONFIG:
          {
            mergeCharacterMaskConfig(other.getCharacterMaskConfig());
            break;
          }
        case CRYPTO_REPLACE_FFX_FPE_CONFIG:
          {
            mergeCryptoReplaceFfxFpeConfig(other.getCryptoReplaceFfxFpeConfig());
            break;
          }
        case FIXED_SIZE_BUCKETING_CONFIG:
          {
            mergeFixedSizeBucketingConfig(other.getFixedSizeBucketingConfig());
            break;
          }
        case BUCKETING_CONFIG:
          {
            mergeBucketingConfig(other.getBucketingConfig());
            break;
          }
        case REPLACE_WITH_INFO_TYPE_CONFIG:
          {
            mergeReplaceWithInfoTypeConfig(other.getReplaceWithInfoTypeConfig());
            break;
          }
        case TIME_PART_CONFIG:
          {
            mergeTimePartConfig(other.getTimePartConfig());
            break;
          }
        case CRYPTO_HASH_CONFIG:
          {
            mergeCryptoHashConfig(other.getCryptoHashConfig());
            break;
          }
        case DATE_SHIFT_CONFIG:
          {
            mergeDateShiftConfig(other.getDateShiftConfig());
            break;
          }
        case CRYPTO_DETERMINISTIC_CONFIG:
          {
            mergeCryptoDeterministicConfig(other.getCryptoDeterministicConfig());
            break;
          }
        case REPLACE_DICTIONARY_CONFIG:
          {
            mergeReplaceDictionaryConfig(other.getReplaceDictionaryConfig());
            break;
          }
        case TRANSFORMATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getReplaceConfigFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getRedactConfigFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getCharacterMaskConfigFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getCryptoReplaceFfxFpeConfigFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getFixedSizeBucketingConfigFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getBucketingConfigFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getReplaceWithInfoTypeConfigFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getTimePartConfigFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getCryptoHashConfigFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 9;
                break;
              } // case 74
            case 90:
              {
                input.readMessage(getDateShiftConfigFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getCryptoDeterministicConfigFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getReplaceDictionaryConfigFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 13;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int transformationCase_ = 0;
    private java.lang.Object transformation_;

    public TransformationCase getTransformationCase() {
      return TransformationCase.forNumber(transformationCase_);
    }

    public Builder clearTransformation() {
      transformationCase_ = 0;
      transformation_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ReplaceValueConfig,
            com.google.privacy.dlp.v2.ReplaceValueConfig.Builder,
            com.google.privacy.dlp.v2.ReplaceValueConfigOrBuilder>
        replaceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Replace with a specified value.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceValueConfig replace_config = 1;</code>
     *
     * @return Whether the replaceConfig field is set.
     */
    @java.lang.Override
    public boolean hasReplaceConfig() {
      return transformationCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Replace with a specified value.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceValueConfig replace_config = 1;</code>
     *
     * @return The replaceConfig.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ReplaceValueConfig getReplaceConfig() {
      if (replaceConfigBuilder_ == null) {
        if (transformationCase_ == 1) {
          return (com.google.privacy.dlp.v2.ReplaceValueConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.ReplaceValueConfig.getDefaultInstance();
      } else {
        if (transformationCase_ == 1) {
          return replaceConfigBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.ReplaceValueConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Replace with a specified value.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceValueConfig replace_config = 1;</code>
     */
    public Builder setReplaceConfig(com.google.privacy.dlp.v2.ReplaceValueConfig value) {
      if (replaceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        replaceConfigBuilder_.setMessage(value);
      }
      transformationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replace with a specified value.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceValueConfig replace_config = 1;</code>
     */
    public Builder setReplaceConfig(
        com.google.privacy.dlp.v2.ReplaceValueConfig.Builder builderForValue) {
      if (replaceConfigBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        replaceConfigBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replace with a specified value.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceValueConfig replace_config = 1;</code>
     */
    public Builder mergeReplaceConfig(com.google.privacy.dlp.v2.ReplaceValueConfig value) {
      if (replaceConfigBuilder_ == null) {
        if (transformationCase_ == 1
            && transformation_
                != com.google.privacy.dlp.v2.ReplaceValueConfig.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.ReplaceValueConfig.newBuilder(
                      (com.google.privacy.dlp.v2.ReplaceValueConfig) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 1) {
          replaceConfigBuilder_.mergeFrom(value);
        } else {
          replaceConfigBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replace with a specified value.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceValueConfig replace_config = 1;</code>
     */
    public Builder clearReplaceConfig() {
      if (replaceConfigBuilder_ == null) {
        if (transformationCase_ == 1) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 1) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        replaceConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replace with a specified value.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceValueConfig replace_config = 1;</code>
     */
    public com.google.privacy.dlp.v2.ReplaceValueConfig.Builder getReplaceConfigBuilder() {
      return getReplaceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Replace with a specified value.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceValueConfig replace_config = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ReplaceValueConfigOrBuilder getReplaceConfigOrBuilder() {
      if ((transformationCase_ == 1) && (replaceConfigBuilder_ != null)) {
        return replaceConfigBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 1) {
          return (com.google.privacy.dlp.v2.ReplaceValueConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.ReplaceValueConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Replace with a specified value.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceValueConfig replace_config = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ReplaceValueConfig,
            com.google.privacy.dlp.v2.ReplaceValueConfig.Builder,
            com.google.privacy.dlp.v2.ReplaceValueConfigOrBuilder>
        getReplaceConfigFieldBuilder() {
      if (replaceConfigBuilder_ == null) {
        if (!(transformationCase_ == 1)) {
          transformation_ = com.google.privacy.dlp.v2.ReplaceValueConfig.getDefaultInstance();
        }
        replaceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.ReplaceValueConfig,
                com.google.privacy.dlp.v2.ReplaceValueConfig.Builder,
                com.google.privacy.dlp.v2.ReplaceValueConfigOrBuilder>(
                (com.google.privacy.dlp.v2.ReplaceValueConfig) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 1;
      onChanged();
      return replaceConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.RedactConfig,
            com.google.privacy.dlp.v2.RedactConfig.Builder,
            com.google.privacy.dlp.v2.RedactConfigOrBuilder>
        redactConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Redact
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RedactConfig redact_config = 2;</code>
     *
     * @return Whether the redactConfig field is set.
     */
    @java.lang.Override
    public boolean hasRedactConfig() {
      return transformationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Redact
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RedactConfig redact_config = 2;</code>
     *
     * @return The redactConfig.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.RedactConfig getRedactConfig() {
      if (redactConfigBuilder_ == null) {
        if (transformationCase_ == 2) {
          return (com.google.privacy.dlp.v2.RedactConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.RedactConfig.getDefaultInstance();
      } else {
        if (transformationCase_ == 2) {
          return redactConfigBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.RedactConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Redact
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RedactConfig redact_config = 2;</code>
     */
    public Builder setRedactConfig(com.google.privacy.dlp.v2.RedactConfig value) {
      if (redactConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        redactConfigBuilder_.setMessage(value);
      }
      transformationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Redact
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RedactConfig redact_config = 2;</code>
     */
    public Builder setRedactConfig(com.google.privacy.dlp.v2.RedactConfig.Builder builderForValue) {
      if (redactConfigBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        redactConfigBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Redact
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RedactConfig redact_config = 2;</code>
     */
    public Builder mergeRedactConfig(com.google.privacy.dlp.v2.RedactConfig value) {
      if (redactConfigBuilder_ == null) {
        if (transformationCase_ == 2
            && transformation_ != com.google.privacy.dlp.v2.RedactConfig.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.RedactConfig.newBuilder(
                      (com.google.privacy.dlp.v2.RedactConfig) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 2) {
          redactConfigBuilder_.mergeFrom(value);
        } else {
          redactConfigBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Redact
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RedactConfig redact_config = 2;</code>
     */
    public Builder clearRedactConfig() {
      if (redactConfigBuilder_ == null) {
        if (transformationCase_ == 2) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 2) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        redactConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Redact
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RedactConfig redact_config = 2;</code>
     */
    public com.google.privacy.dlp.v2.RedactConfig.Builder getRedactConfigBuilder() {
      return getRedactConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Redact
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RedactConfig redact_config = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.RedactConfigOrBuilder getRedactConfigOrBuilder() {
      if ((transformationCase_ == 2) && (redactConfigBuilder_ != null)) {
        return redactConfigBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 2) {
          return (com.google.privacy.dlp.v2.RedactConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.RedactConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Redact
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RedactConfig redact_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.RedactConfig,
            com.google.privacy.dlp.v2.RedactConfig.Builder,
            com.google.privacy.dlp.v2.RedactConfigOrBuilder>
        getRedactConfigFieldBuilder() {
      if (redactConfigBuilder_ == null) {
        if (!(transformationCase_ == 2)) {
          transformation_ = com.google.privacy.dlp.v2.RedactConfig.getDefaultInstance();
        }
        redactConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.RedactConfig,
                com.google.privacy.dlp.v2.RedactConfig.Builder,
                com.google.privacy.dlp.v2.RedactConfigOrBuilder>(
                (com.google.privacy.dlp.v2.RedactConfig) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 2;
      onChanged();
      return redactConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CharacterMaskConfig,
            com.google.privacy.dlp.v2.CharacterMaskConfig.Builder,
            com.google.privacy.dlp.v2.CharacterMaskConfigOrBuilder>
        characterMaskConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Mask
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CharacterMaskConfig character_mask_config = 3;</code>
     *
     * @return Whether the characterMaskConfig field is set.
     */
    @java.lang.Override
    public boolean hasCharacterMaskConfig() {
      return transformationCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Mask
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CharacterMaskConfig character_mask_config = 3;</code>
     *
     * @return The characterMaskConfig.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CharacterMaskConfig getCharacterMaskConfig() {
      if (characterMaskConfigBuilder_ == null) {
        if (transformationCase_ == 3) {
          return (com.google.privacy.dlp.v2.CharacterMaskConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.CharacterMaskConfig.getDefaultInstance();
      } else {
        if (transformationCase_ == 3) {
          return characterMaskConfigBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.CharacterMaskConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Mask
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CharacterMaskConfig character_mask_config = 3;</code>
     */
    public Builder setCharacterMaskConfig(com.google.privacy.dlp.v2.CharacterMaskConfig value) {
      if (characterMaskConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        characterMaskConfigBuilder_.setMessage(value);
      }
      transformationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CharacterMaskConfig character_mask_config = 3;</code>
     */
    public Builder setCharacterMaskConfig(
        com.google.privacy.dlp.v2.CharacterMaskConfig.Builder builderForValue) {
      if (characterMaskConfigBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        characterMaskConfigBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CharacterMaskConfig character_mask_config = 3;</code>
     */
    public Builder mergeCharacterMaskConfig(com.google.privacy.dlp.v2.CharacterMaskConfig value) {
      if (characterMaskConfigBuilder_ == null) {
        if (transformationCase_ == 3
            && transformation_
                != com.google.privacy.dlp.v2.CharacterMaskConfig.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.CharacterMaskConfig.newBuilder(
                      (com.google.privacy.dlp.v2.CharacterMaskConfig) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 3) {
          characterMaskConfigBuilder_.mergeFrom(value);
        } else {
          characterMaskConfigBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CharacterMaskConfig character_mask_config = 3;</code>
     */
    public Builder clearCharacterMaskConfig() {
      if (characterMaskConfigBuilder_ == null) {
        if (transformationCase_ == 3) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 3) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        characterMaskConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CharacterMaskConfig character_mask_config = 3;</code>
     */
    public com.google.privacy.dlp.v2.CharacterMaskConfig.Builder getCharacterMaskConfigBuilder() {
      return getCharacterMaskConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Mask
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CharacterMaskConfig character_mask_config = 3;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CharacterMaskConfigOrBuilder
        getCharacterMaskConfigOrBuilder() {
      if ((transformationCase_ == 3) && (characterMaskConfigBuilder_ != null)) {
        return characterMaskConfigBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 3) {
          return (com.google.privacy.dlp.v2.CharacterMaskConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.CharacterMaskConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Mask
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CharacterMaskConfig character_mask_config = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CharacterMaskConfig,
            com.google.privacy.dlp.v2.CharacterMaskConfig.Builder,
            com.google.privacy.dlp.v2.CharacterMaskConfigOrBuilder>
        getCharacterMaskConfigFieldBuilder() {
      if (characterMaskConfigBuilder_ == null) {
        if (!(transformationCase_ == 3)) {
          transformation_ = com.google.privacy.dlp.v2.CharacterMaskConfig.getDefaultInstance();
        }
        characterMaskConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CharacterMaskConfig,
                com.google.privacy.dlp.v2.CharacterMaskConfig.Builder,
                com.google.privacy.dlp.v2.CharacterMaskConfigOrBuilder>(
                (com.google.privacy.dlp.v2.CharacterMaskConfig) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 3;
      onChanged();
      return characterMaskConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig,
            com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.Builder,
            com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfigOrBuilder>
        cryptoReplaceFfxFpeConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Ffx-Fpe
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig crypto_replace_ffx_fpe_config = 4;
     * </code>
     *
     * @return Whether the cryptoReplaceFfxFpeConfig field is set.
     */
    @java.lang.Override
    public boolean hasCryptoReplaceFfxFpeConfig() {
      return transformationCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Ffx-Fpe
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig crypto_replace_ffx_fpe_config = 4;
     * </code>
     *
     * @return The cryptoReplaceFfxFpeConfig.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig getCryptoReplaceFfxFpeConfig() {
      if (cryptoReplaceFfxFpeConfigBuilder_ == null) {
        if (transformationCase_ == 4) {
          return (com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.getDefaultInstance();
      } else {
        if (transformationCase_ == 4) {
          return cryptoReplaceFfxFpeConfigBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Ffx-Fpe
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig crypto_replace_ffx_fpe_config = 4;
     * </code>
     */
    public Builder setCryptoReplaceFfxFpeConfig(
        com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig value) {
      if (cryptoReplaceFfxFpeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        cryptoReplaceFfxFpeConfigBuilder_.setMessage(value);
      }
      transformationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ffx-Fpe
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig crypto_replace_ffx_fpe_config = 4;
     * </code>
     */
    public Builder setCryptoReplaceFfxFpeConfig(
        com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.Builder builderForValue) {
      if (cryptoReplaceFfxFpeConfigBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        cryptoReplaceFfxFpeConfigBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ffx-Fpe
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig crypto_replace_ffx_fpe_config = 4;
     * </code>
     */
    public Builder mergeCryptoReplaceFfxFpeConfig(
        com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig value) {
      if (cryptoReplaceFfxFpeConfigBuilder_ == null) {
        if (transformationCase_ == 4
            && transformation_
                != com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.newBuilder(
                      (com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 4) {
          cryptoReplaceFfxFpeConfigBuilder_.mergeFrom(value);
        } else {
          cryptoReplaceFfxFpeConfigBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ffx-Fpe
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig crypto_replace_ffx_fpe_config = 4;
     * </code>
     */
    public Builder clearCryptoReplaceFfxFpeConfig() {
      if (cryptoReplaceFfxFpeConfigBuilder_ == null) {
        if (transformationCase_ == 4) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 4) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        cryptoReplaceFfxFpeConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ffx-Fpe
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig crypto_replace_ffx_fpe_config = 4;
     * </code>
     */
    public com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.Builder
        getCryptoReplaceFfxFpeConfigBuilder() {
      return getCryptoReplaceFfxFpeConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Ffx-Fpe
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig crypto_replace_ffx_fpe_config = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfigOrBuilder
        getCryptoReplaceFfxFpeConfigOrBuilder() {
      if ((transformationCase_ == 4) && (cryptoReplaceFfxFpeConfigBuilder_ != null)) {
        return cryptoReplaceFfxFpeConfigBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 4) {
          return (com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Ffx-Fpe
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig crypto_replace_ffx_fpe_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig,
            com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.Builder,
            com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfigOrBuilder>
        getCryptoReplaceFfxFpeConfigFieldBuilder() {
      if (cryptoReplaceFfxFpeConfigBuilder_ == null) {
        if (!(transformationCase_ == 4)) {
          transformation_ =
              com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.getDefaultInstance();
        }
        cryptoReplaceFfxFpeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig,
                com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.Builder,
                com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfigOrBuilder>(
                (com.google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 4;
      onChanged();
      return cryptoReplaceFfxFpeConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.FixedSizeBucketingConfig,
            com.google.privacy.dlp.v2.FixedSizeBucketingConfig.Builder,
            com.google.privacy.dlp.v2.FixedSizeBucketingConfigOrBuilder>
        fixedSizeBucketingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Fixed size bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FixedSizeBucketingConfig fixed_size_bucketing_config = 5;</code>
     *
     * @return Whether the fixedSizeBucketingConfig field is set.
     */
    @java.lang.Override
    public boolean hasFixedSizeBucketingConfig() {
      return transformationCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Fixed size bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FixedSizeBucketingConfig fixed_size_bucketing_config = 5;</code>
     *
     * @return The fixedSizeBucketingConfig.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.FixedSizeBucketingConfig getFixedSizeBucketingConfig() {
      if (fixedSizeBucketingConfigBuilder_ == null) {
        if (transformationCase_ == 5) {
          return (com.google.privacy.dlp.v2.FixedSizeBucketingConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.FixedSizeBucketingConfig.getDefaultInstance();
      } else {
        if (transformationCase_ == 5) {
          return fixedSizeBucketingConfigBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.FixedSizeBucketingConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Fixed size bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FixedSizeBucketingConfig fixed_size_bucketing_config = 5;</code>
     */
    public Builder setFixedSizeBucketingConfig(
        com.google.privacy.dlp.v2.FixedSizeBucketingConfig value) {
      if (fixedSizeBucketingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        fixedSizeBucketingConfigBuilder_.setMessage(value);
      }
      transformationCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fixed size bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FixedSizeBucketingConfig fixed_size_bucketing_config = 5;</code>
     */
    public Builder setFixedSizeBucketingConfig(
        com.google.privacy.dlp.v2.FixedSizeBucketingConfig.Builder builderForValue) {
      if (fixedSizeBucketingConfigBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        fixedSizeBucketingConfigBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fixed size bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FixedSizeBucketingConfig fixed_size_bucketing_config = 5;</code>
     */
    public Builder mergeFixedSizeBucketingConfig(
        com.google.privacy.dlp.v2.FixedSizeBucketingConfig value) {
      if (fixedSizeBucketingConfigBuilder_ == null) {
        if (transformationCase_ == 5
            && transformation_
                != com.google.privacy.dlp.v2.FixedSizeBucketingConfig.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.FixedSizeBucketingConfig.newBuilder(
                      (com.google.privacy.dlp.v2.FixedSizeBucketingConfig) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 5) {
          fixedSizeBucketingConfigBuilder_.mergeFrom(value);
        } else {
          fixedSizeBucketingConfigBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fixed size bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FixedSizeBucketingConfig fixed_size_bucketing_config = 5;</code>
     */
    public Builder clearFixedSizeBucketingConfig() {
      if (fixedSizeBucketingConfigBuilder_ == null) {
        if (transformationCase_ == 5) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 5) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        fixedSizeBucketingConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fixed size bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FixedSizeBucketingConfig fixed_size_bucketing_config = 5;</code>
     */
    public com.google.privacy.dlp.v2.FixedSizeBucketingConfig.Builder
        getFixedSizeBucketingConfigBuilder() {
      return getFixedSizeBucketingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Fixed size bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FixedSizeBucketingConfig fixed_size_bucketing_config = 5;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.FixedSizeBucketingConfigOrBuilder
        getFixedSizeBucketingConfigOrBuilder() {
      if ((transformationCase_ == 5) && (fixedSizeBucketingConfigBuilder_ != null)) {
        return fixedSizeBucketingConfigBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 5) {
          return (com.google.privacy.dlp.v2.FixedSizeBucketingConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.FixedSizeBucketingConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Fixed size bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FixedSizeBucketingConfig fixed_size_bucketing_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.FixedSizeBucketingConfig,
            com.google.privacy.dlp.v2.FixedSizeBucketingConfig.Builder,
            com.google.privacy.dlp.v2.FixedSizeBucketingConfigOrBuilder>
        getFixedSizeBucketingConfigFieldBuilder() {
      if (fixedSizeBucketingConfigBuilder_ == null) {
        if (!(transformationCase_ == 5)) {
          transformation_ = com.google.privacy.dlp.v2.FixedSizeBucketingConfig.getDefaultInstance();
        }
        fixedSizeBucketingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.FixedSizeBucketingConfig,
                com.google.privacy.dlp.v2.FixedSizeBucketingConfig.Builder,
                com.google.privacy.dlp.v2.FixedSizeBucketingConfigOrBuilder>(
                (com.google.privacy.dlp.v2.FixedSizeBucketingConfig) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 5;
      onChanged();
      return fixedSizeBucketingConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BucketingConfig,
            com.google.privacy.dlp.v2.BucketingConfig.Builder,
            com.google.privacy.dlp.v2.BucketingConfigOrBuilder>
        bucketingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BucketingConfig bucketing_config = 6;</code>
     *
     * @return Whether the bucketingConfig field is set.
     */
    @java.lang.Override
    public boolean hasBucketingConfig() {
      return transformationCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BucketingConfig bucketing_config = 6;</code>
     *
     * @return The bucketingConfig.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.BucketingConfig getBucketingConfig() {
      if (bucketingConfigBuilder_ == null) {
        if (transformationCase_ == 6) {
          return (com.google.privacy.dlp.v2.BucketingConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.BucketingConfig.getDefaultInstance();
      } else {
        if (transformationCase_ == 6) {
          return bucketingConfigBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.BucketingConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BucketingConfig bucketing_config = 6;</code>
     */
    public Builder setBucketingConfig(com.google.privacy.dlp.v2.BucketingConfig value) {
      if (bucketingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        bucketingConfigBuilder_.setMessage(value);
      }
      transformationCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BucketingConfig bucketing_config = 6;</code>
     */
    public Builder setBucketingConfig(
        com.google.privacy.dlp.v2.BucketingConfig.Builder builderForValue) {
      if (bucketingConfigBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        bucketingConfigBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BucketingConfig bucketing_config = 6;</code>
     */
    public Builder mergeBucketingConfig(com.google.privacy.dlp.v2.BucketingConfig value) {
      if (bucketingConfigBuilder_ == null) {
        if (transformationCase_ == 6
            && transformation_ != com.google.privacy.dlp.v2.BucketingConfig.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.BucketingConfig.newBuilder(
                      (com.google.privacy.dlp.v2.BucketingConfig) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 6) {
          bucketingConfigBuilder_.mergeFrom(value);
        } else {
          bucketingConfigBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BucketingConfig bucketing_config = 6;</code>
     */
    public Builder clearBucketingConfig() {
      if (bucketingConfigBuilder_ == null) {
        if (transformationCase_ == 6) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 6) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        bucketingConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BucketingConfig bucketing_config = 6;</code>
     */
    public com.google.privacy.dlp.v2.BucketingConfig.Builder getBucketingConfigBuilder() {
      return getBucketingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BucketingConfig bucketing_config = 6;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.BucketingConfigOrBuilder getBucketingConfigOrBuilder() {
      if ((transformationCase_ == 6) && (bucketingConfigBuilder_ != null)) {
        return bucketingConfigBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 6) {
          return (com.google.privacy.dlp.v2.BucketingConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.BucketingConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Bucketing
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BucketingConfig bucketing_config = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BucketingConfig,
            com.google.privacy.dlp.v2.BucketingConfig.Builder,
            com.google.privacy.dlp.v2.BucketingConfigOrBuilder>
        getBucketingConfigFieldBuilder() {
      if (bucketingConfigBuilder_ == null) {
        if (!(transformationCase_ == 6)) {
          transformation_ = com.google.privacy.dlp.v2.BucketingConfig.getDefaultInstance();
        }
        bucketingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.BucketingConfig,
                com.google.privacy.dlp.v2.BucketingConfig.Builder,
                com.google.privacy.dlp.v2.BucketingConfigOrBuilder>(
                (com.google.privacy.dlp.v2.BucketingConfig) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 6;
      onChanged();
      return bucketingConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig,
            com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig.Builder,
            com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfigOrBuilder>
        replaceWithInfoTypeConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Replace with infotype
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig replace_with_info_type_config = 7;
     * </code>
     *
     * @return Whether the replaceWithInfoTypeConfig field is set.
     */
    @java.lang.Override
    public boolean hasReplaceWithInfoTypeConfig() {
      return transformationCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Replace with infotype
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig replace_with_info_type_config = 7;
     * </code>
     *
     * @return The replaceWithInfoTypeConfig.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig getReplaceWithInfoTypeConfig() {
      if (replaceWithInfoTypeConfigBuilder_ == null) {
        if (transformationCase_ == 7) {
          return (com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig.getDefaultInstance();
      } else {
        if (transformationCase_ == 7) {
          return replaceWithInfoTypeConfigBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Replace with infotype
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig replace_with_info_type_config = 7;
     * </code>
     */
    public Builder setReplaceWithInfoTypeConfig(
        com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig value) {
      if (replaceWithInfoTypeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        replaceWithInfoTypeConfigBuilder_.setMessage(value);
      }
      transformationCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replace with infotype
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig replace_with_info_type_config = 7;
     * </code>
     */
    public Builder setReplaceWithInfoTypeConfig(
        com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig.Builder builderForValue) {
      if (replaceWithInfoTypeConfigBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        replaceWithInfoTypeConfigBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replace with infotype
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig replace_with_info_type_config = 7;
     * </code>
     */
    public Builder mergeReplaceWithInfoTypeConfig(
        com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig value) {
      if (replaceWithInfoTypeConfigBuilder_ == null) {
        if (transformationCase_ == 7
            && transformation_
                != com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig.newBuilder(
                      (com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 7) {
          replaceWithInfoTypeConfigBuilder_.mergeFrom(value);
        } else {
          replaceWithInfoTypeConfigBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replace with infotype
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig replace_with_info_type_config = 7;
     * </code>
     */
    public Builder clearReplaceWithInfoTypeConfig() {
      if (replaceWithInfoTypeConfigBuilder_ == null) {
        if (transformationCase_ == 7) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 7) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        replaceWithInfoTypeConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replace with infotype
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig replace_with_info_type_config = 7;
     * </code>
     */
    public com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig.Builder
        getReplaceWithInfoTypeConfigBuilder() {
      return getReplaceWithInfoTypeConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Replace with infotype
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig replace_with_info_type_config = 7;
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfigOrBuilder
        getReplaceWithInfoTypeConfigOrBuilder() {
      if ((transformationCase_ == 7) && (replaceWithInfoTypeConfigBuilder_ != null)) {
        return replaceWithInfoTypeConfigBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 7) {
          return (com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Replace with infotype
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig replace_with_info_type_config = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig,
            com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig.Builder,
            com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfigOrBuilder>
        getReplaceWithInfoTypeConfigFieldBuilder() {
      if (replaceWithInfoTypeConfigBuilder_ == null) {
        if (!(transformationCase_ == 7)) {
          transformation_ =
              com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig.getDefaultInstance();
        }
        replaceWithInfoTypeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig,
                com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig.Builder,
                com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfigOrBuilder>(
                (com.google.privacy.dlp.v2.ReplaceWithInfoTypeConfig) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 7;
      onChanged();
      return replaceWithInfoTypeConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.TimePartConfig,
            com.google.privacy.dlp.v2.TimePartConfig.Builder,
            com.google.privacy.dlp.v2.TimePartConfigOrBuilder>
        timePartConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Time extraction
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TimePartConfig time_part_config = 8;</code>
     *
     * @return Whether the timePartConfig field is set.
     */
    @java.lang.Override
    public boolean hasTimePartConfig() {
      return transformationCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Time extraction
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TimePartConfig time_part_config = 8;</code>
     *
     * @return The timePartConfig.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.TimePartConfig getTimePartConfig() {
      if (timePartConfigBuilder_ == null) {
        if (transformationCase_ == 8) {
          return (com.google.privacy.dlp.v2.TimePartConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.TimePartConfig.getDefaultInstance();
      } else {
        if (transformationCase_ == 8) {
          return timePartConfigBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.TimePartConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Time extraction
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TimePartConfig time_part_config = 8;</code>
     */
    public Builder setTimePartConfig(com.google.privacy.dlp.v2.TimePartConfig value) {
      if (timePartConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        timePartConfigBuilder_.setMessage(value);
      }
      transformationCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time extraction
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TimePartConfig time_part_config = 8;</code>
     */
    public Builder setTimePartConfig(
        com.google.privacy.dlp.v2.TimePartConfig.Builder builderForValue) {
      if (timePartConfigBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        timePartConfigBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time extraction
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TimePartConfig time_part_config = 8;</code>
     */
    public Builder mergeTimePartConfig(com.google.privacy.dlp.v2.TimePartConfig value) {
      if (timePartConfigBuilder_ == null) {
        if (transformationCase_ == 8
            && transformation_ != com.google.privacy.dlp.v2.TimePartConfig.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.TimePartConfig.newBuilder(
                      (com.google.privacy.dlp.v2.TimePartConfig) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 8) {
          timePartConfigBuilder_.mergeFrom(value);
        } else {
          timePartConfigBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time extraction
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TimePartConfig time_part_config = 8;</code>
     */
    public Builder clearTimePartConfig() {
      if (timePartConfigBuilder_ == null) {
        if (transformationCase_ == 8) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 8) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        timePartConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time extraction
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TimePartConfig time_part_config = 8;</code>
     */
    public com.google.privacy.dlp.v2.TimePartConfig.Builder getTimePartConfigBuilder() {
      return getTimePartConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time extraction
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TimePartConfig time_part_config = 8;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.TimePartConfigOrBuilder getTimePartConfigOrBuilder() {
      if ((transformationCase_ == 8) && (timePartConfigBuilder_ != null)) {
        return timePartConfigBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 8) {
          return (com.google.privacy.dlp.v2.TimePartConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.TimePartConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Time extraction
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TimePartConfig time_part_config = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.TimePartConfig,
            com.google.privacy.dlp.v2.TimePartConfig.Builder,
            com.google.privacy.dlp.v2.TimePartConfigOrBuilder>
        getTimePartConfigFieldBuilder() {
      if (timePartConfigBuilder_ == null) {
        if (!(transformationCase_ == 8)) {
          transformation_ = com.google.privacy.dlp.v2.TimePartConfig.getDefaultInstance();
        }
        timePartConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.TimePartConfig,
                com.google.privacy.dlp.v2.TimePartConfig.Builder,
                com.google.privacy.dlp.v2.TimePartConfigOrBuilder>(
                (com.google.privacy.dlp.v2.TimePartConfig) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 8;
      onChanged();
      return timePartConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CryptoHashConfig,
            com.google.privacy.dlp.v2.CryptoHashConfig.Builder,
            com.google.privacy.dlp.v2.CryptoHashConfigOrBuilder>
        cryptoHashConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoHashConfig crypto_hash_config = 9;</code>
     *
     * @return Whether the cryptoHashConfig field is set.
     */
    @java.lang.Override
    public boolean hasCryptoHashConfig() {
      return transformationCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoHashConfig crypto_hash_config = 9;</code>
     *
     * @return The cryptoHashConfig.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CryptoHashConfig getCryptoHashConfig() {
      if (cryptoHashConfigBuilder_ == null) {
        if (transformationCase_ == 9) {
          return (com.google.privacy.dlp.v2.CryptoHashConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.CryptoHashConfig.getDefaultInstance();
      } else {
        if (transformationCase_ == 9) {
          return cryptoHashConfigBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.CryptoHashConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoHashConfig crypto_hash_config = 9;</code>
     */
    public Builder setCryptoHashConfig(com.google.privacy.dlp.v2.CryptoHashConfig value) {
      if (cryptoHashConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        cryptoHashConfigBuilder_.setMessage(value);
      }
      transformationCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoHashConfig crypto_hash_config = 9;</code>
     */
    public Builder setCryptoHashConfig(
        com.google.privacy.dlp.v2.CryptoHashConfig.Builder builderForValue) {
      if (cryptoHashConfigBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        cryptoHashConfigBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoHashConfig crypto_hash_config = 9;</code>
     */
    public Builder mergeCryptoHashConfig(com.google.privacy.dlp.v2.CryptoHashConfig value) {
      if (cryptoHashConfigBuilder_ == null) {
        if (transformationCase_ == 9
            && transformation_ != com.google.privacy.dlp.v2.CryptoHashConfig.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.CryptoHashConfig.newBuilder(
                      (com.google.privacy.dlp.v2.CryptoHashConfig) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 9) {
          cryptoHashConfigBuilder_.mergeFrom(value);
        } else {
          cryptoHashConfigBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoHashConfig crypto_hash_config = 9;</code>
     */
    public Builder clearCryptoHashConfig() {
      if (cryptoHashConfigBuilder_ == null) {
        if (transformationCase_ == 9) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 9) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        cryptoHashConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoHashConfig crypto_hash_config = 9;</code>
     */
    public com.google.privacy.dlp.v2.CryptoHashConfig.Builder getCryptoHashConfigBuilder() {
      return getCryptoHashConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoHashConfig crypto_hash_config = 9;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CryptoHashConfigOrBuilder getCryptoHashConfigOrBuilder() {
      if ((transformationCase_ == 9) && (cryptoHashConfigBuilder_ != null)) {
        return cryptoHashConfigBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 9) {
          return (com.google.privacy.dlp.v2.CryptoHashConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.CryptoHashConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoHashConfig crypto_hash_config = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CryptoHashConfig,
            com.google.privacy.dlp.v2.CryptoHashConfig.Builder,
            com.google.privacy.dlp.v2.CryptoHashConfigOrBuilder>
        getCryptoHashConfigFieldBuilder() {
      if (cryptoHashConfigBuilder_ == null) {
        if (!(transformationCase_ == 9)) {
          transformation_ = com.google.privacy.dlp.v2.CryptoHashConfig.getDefaultInstance();
        }
        cryptoHashConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CryptoHashConfig,
                com.google.privacy.dlp.v2.CryptoHashConfig.Builder,
                com.google.privacy.dlp.v2.CryptoHashConfigOrBuilder>(
                (com.google.privacy.dlp.v2.CryptoHashConfig) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 9;
      onChanged();
      return cryptoHashConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DateShiftConfig,
            com.google.privacy.dlp.v2.DateShiftConfig.Builder,
            com.google.privacy.dlp.v2.DateShiftConfigOrBuilder>
        dateShiftConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Date Shift
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateShiftConfig date_shift_config = 11;</code>
     *
     * @return Whether the dateShiftConfig field is set.
     */
    @java.lang.Override
    public boolean hasDateShiftConfig() {
      return transformationCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Date Shift
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateShiftConfig date_shift_config = 11;</code>
     *
     * @return The dateShiftConfig.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DateShiftConfig getDateShiftConfig() {
      if (dateShiftConfigBuilder_ == null) {
        if (transformationCase_ == 11) {
          return (com.google.privacy.dlp.v2.DateShiftConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.DateShiftConfig.getDefaultInstance();
      } else {
        if (transformationCase_ == 11) {
          return dateShiftConfigBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.DateShiftConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Date Shift
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateShiftConfig date_shift_config = 11;</code>
     */
    public Builder setDateShiftConfig(com.google.privacy.dlp.v2.DateShiftConfig value) {
      if (dateShiftConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        dateShiftConfigBuilder_.setMessage(value);
      }
      transformationCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Date Shift
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateShiftConfig date_shift_config = 11;</code>
     */
    public Builder setDateShiftConfig(
        com.google.privacy.dlp.v2.DateShiftConfig.Builder builderForValue) {
      if (dateShiftConfigBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        dateShiftConfigBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Date Shift
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateShiftConfig date_shift_config = 11;</code>
     */
    public Builder mergeDateShiftConfig(com.google.privacy.dlp.v2.DateShiftConfig value) {
      if (dateShiftConfigBuilder_ == null) {
        if (transformationCase_ == 11
            && transformation_ != com.google.privacy.dlp.v2.DateShiftConfig.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.DateShiftConfig.newBuilder(
                      (com.google.privacy.dlp.v2.DateShiftConfig) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 11) {
          dateShiftConfigBuilder_.mergeFrom(value);
        } else {
          dateShiftConfigBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Date Shift
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateShiftConfig date_shift_config = 11;</code>
     */
    public Builder clearDateShiftConfig() {
      if (dateShiftConfigBuilder_ == null) {
        if (transformationCase_ == 11) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 11) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        dateShiftConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Date Shift
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateShiftConfig date_shift_config = 11;</code>
     */
    public com.google.privacy.dlp.v2.DateShiftConfig.Builder getDateShiftConfigBuilder() {
      return getDateShiftConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Date Shift
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateShiftConfig date_shift_config = 11;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DateShiftConfigOrBuilder getDateShiftConfigOrBuilder() {
      if ((transformationCase_ == 11) && (dateShiftConfigBuilder_ != null)) {
        return dateShiftConfigBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 11) {
          return (com.google.privacy.dlp.v2.DateShiftConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.DateShiftConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Date Shift
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DateShiftConfig date_shift_config = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DateShiftConfig,
            com.google.privacy.dlp.v2.DateShiftConfig.Builder,
            com.google.privacy.dlp.v2.DateShiftConfigOrBuilder>
        getDateShiftConfigFieldBuilder() {
      if (dateShiftConfigBuilder_ == null) {
        if (!(transformationCase_ == 11)) {
          transformation_ = com.google.privacy.dlp.v2.DateShiftConfig.getDefaultInstance();
        }
        dateShiftConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DateShiftConfig,
                com.google.privacy.dlp.v2.DateShiftConfig.Builder,
                com.google.privacy.dlp.v2.DateShiftConfigOrBuilder>(
                (com.google.privacy.dlp.v2.DateShiftConfig) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 11;
      onChanged();
      return dateShiftConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CryptoDeterministicConfig,
            com.google.privacy.dlp.v2.CryptoDeterministicConfig.Builder,
            com.google.privacy.dlp.v2.CryptoDeterministicConfigOrBuilder>
        cryptoDeterministicConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Deterministic Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoDeterministicConfig crypto_deterministic_config = 12;
     * </code>
     *
     * @return Whether the cryptoDeterministicConfig field is set.
     */
    @java.lang.Override
    public boolean hasCryptoDeterministicConfig() {
      return transformationCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Deterministic Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoDeterministicConfig crypto_deterministic_config = 12;
     * </code>
     *
     * @return The cryptoDeterministicConfig.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CryptoDeterministicConfig getCryptoDeterministicConfig() {
      if (cryptoDeterministicConfigBuilder_ == null) {
        if (transformationCase_ == 12) {
          return (com.google.privacy.dlp.v2.CryptoDeterministicConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.CryptoDeterministicConfig.getDefaultInstance();
      } else {
        if (transformationCase_ == 12) {
          return cryptoDeterministicConfigBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.CryptoDeterministicConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Deterministic Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoDeterministicConfig crypto_deterministic_config = 12;
     * </code>
     */
    public Builder setCryptoDeterministicConfig(
        com.google.privacy.dlp.v2.CryptoDeterministicConfig value) {
      if (cryptoDeterministicConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        cryptoDeterministicConfigBuilder_.setMessage(value);
      }
      transformationCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deterministic Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoDeterministicConfig crypto_deterministic_config = 12;
     * </code>
     */
    public Builder setCryptoDeterministicConfig(
        com.google.privacy.dlp.v2.CryptoDeterministicConfig.Builder builderForValue) {
      if (cryptoDeterministicConfigBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        cryptoDeterministicConfigBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deterministic Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoDeterministicConfig crypto_deterministic_config = 12;
     * </code>
     */
    public Builder mergeCryptoDeterministicConfig(
        com.google.privacy.dlp.v2.CryptoDeterministicConfig value) {
      if (cryptoDeterministicConfigBuilder_ == null) {
        if (transformationCase_ == 12
            && transformation_
                != com.google.privacy.dlp.v2.CryptoDeterministicConfig.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.CryptoDeterministicConfig.newBuilder(
                      (com.google.privacy.dlp.v2.CryptoDeterministicConfig) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 12) {
          cryptoDeterministicConfigBuilder_.mergeFrom(value);
        } else {
          cryptoDeterministicConfigBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deterministic Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoDeterministicConfig crypto_deterministic_config = 12;
     * </code>
     */
    public Builder clearCryptoDeterministicConfig() {
      if (cryptoDeterministicConfigBuilder_ == null) {
        if (transformationCase_ == 12) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 12) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        cryptoDeterministicConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deterministic Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoDeterministicConfig crypto_deterministic_config = 12;
     * </code>
     */
    public com.google.privacy.dlp.v2.CryptoDeterministicConfig.Builder
        getCryptoDeterministicConfigBuilder() {
      return getCryptoDeterministicConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Deterministic Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoDeterministicConfig crypto_deterministic_config = 12;
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CryptoDeterministicConfigOrBuilder
        getCryptoDeterministicConfigOrBuilder() {
      if ((transformationCase_ == 12) && (cryptoDeterministicConfigBuilder_ != null)) {
        return cryptoDeterministicConfigBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 12) {
          return (com.google.privacy.dlp.v2.CryptoDeterministicConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.CryptoDeterministicConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Deterministic Crypto
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoDeterministicConfig crypto_deterministic_config = 12;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CryptoDeterministicConfig,
            com.google.privacy.dlp.v2.CryptoDeterministicConfig.Builder,
            com.google.privacy.dlp.v2.CryptoDeterministicConfigOrBuilder>
        getCryptoDeterministicConfigFieldBuilder() {
      if (cryptoDeterministicConfigBuilder_ == null) {
        if (!(transformationCase_ == 12)) {
          transformation_ =
              com.google.privacy.dlp.v2.CryptoDeterministicConfig.getDefaultInstance();
        }
        cryptoDeterministicConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CryptoDeterministicConfig,
                com.google.privacy.dlp.v2.CryptoDeterministicConfig.Builder,
                com.google.privacy.dlp.v2.CryptoDeterministicConfigOrBuilder>(
                (com.google.privacy.dlp.v2.CryptoDeterministicConfig) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 12;
      onChanged();
      return cryptoDeterministicConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ReplaceDictionaryConfig,
            com.google.privacy.dlp.v2.ReplaceDictionaryConfig.Builder,
            com.google.privacy.dlp.v2.ReplaceDictionaryConfigOrBuilder>
        replaceDictionaryConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Replace with a value randomly drawn (with replacement) from a dictionary.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceDictionaryConfig replace_dictionary_config = 13;</code>
     *
     * @return Whether the replaceDictionaryConfig field is set.
     */
    @java.lang.Override
    public boolean hasReplaceDictionaryConfig() {
      return transformationCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Replace with a value randomly drawn (with replacement) from a dictionary.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceDictionaryConfig replace_dictionary_config = 13;</code>
     *
     * @return The replaceDictionaryConfig.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ReplaceDictionaryConfig getReplaceDictionaryConfig() {
      if (replaceDictionaryConfigBuilder_ == null) {
        if (transformationCase_ == 13) {
          return (com.google.privacy.dlp.v2.ReplaceDictionaryConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.ReplaceDictionaryConfig.getDefaultInstance();
      } else {
        if (transformationCase_ == 13) {
          return replaceDictionaryConfigBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.ReplaceDictionaryConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Replace with a value randomly drawn (with replacement) from a dictionary.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceDictionaryConfig replace_dictionary_config = 13;</code>
     */
    public Builder setReplaceDictionaryConfig(
        com.google.privacy.dlp.v2.ReplaceDictionaryConfig value) {
      if (replaceDictionaryConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        replaceDictionaryConfigBuilder_.setMessage(value);
      }
      transformationCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replace with a value randomly drawn (with replacement) from a dictionary.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceDictionaryConfig replace_dictionary_config = 13;</code>
     */
    public Builder setReplaceDictionaryConfig(
        com.google.privacy.dlp.v2.ReplaceDictionaryConfig.Builder builderForValue) {
      if (replaceDictionaryConfigBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        replaceDictionaryConfigBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replace with a value randomly drawn (with replacement) from a dictionary.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceDictionaryConfig replace_dictionary_config = 13;</code>
     */
    public Builder mergeReplaceDictionaryConfig(
        com.google.privacy.dlp.v2.ReplaceDictionaryConfig value) {
      if (replaceDictionaryConfigBuilder_ == null) {
        if (transformationCase_ == 13
            && transformation_
                != com.google.privacy.dlp.v2.ReplaceDictionaryConfig.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.ReplaceDictionaryConfig.newBuilder(
                      (com.google.privacy.dlp.v2.ReplaceDictionaryConfig) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 13) {
          replaceDictionaryConfigBuilder_.mergeFrom(value);
        } else {
          replaceDictionaryConfigBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replace with a value randomly drawn (with replacement) from a dictionary.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceDictionaryConfig replace_dictionary_config = 13;</code>
     */
    public Builder clearReplaceDictionaryConfig() {
      if (replaceDictionaryConfigBuilder_ == null) {
        if (transformationCase_ == 13) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 13) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        replaceDictionaryConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replace with a value randomly drawn (with replacement) from a dictionary.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceDictionaryConfig replace_dictionary_config = 13;</code>
     */
    public com.google.privacy.dlp.v2.ReplaceDictionaryConfig.Builder
        getReplaceDictionaryConfigBuilder() {
      return getReplaceDictionaryConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Replace with a value randomly drawn (with replacement) from a dictionary.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceDictionaryConfig replace_dictionary_config = 13;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ReplaceDictionaryConfigOrBuilder
        getReplaceDictionaryConfigOrBuilder() {
      if ((transformationCase_ == 13) && (replaceDictionaryConfigBuilder_ != null)) {
        return replaceDictionaryConfigBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 13) {
          return (com.google.privacy.dlp.v2.ReplaceDictionaryConfig) transformation_;
        }
        return com.google.privacy.dlp.v2.ReplaceDictionaryConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Replace with a value randomly drawn (with replacement) from a dictionary.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ReplaceDictionaryConfig replace_dictionary_config = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ReplaceDictionaryConfig,
            com.google.privacy.dlp.v2.ReplaceDictionaryConfig.Builder,
            com.google.privacy.dlp.v2.ReplaceDictionaryConfigOrBuilder>
        getReplaceDictionaryConfigFieldBuilder() {
      if (replaceDictionaryConfigBuilder_ == null) {
        if (!(transformationCase_ == 13)) {
          transformation_ = com.google.privacy.dlp.v2.ReplaceDictionaryConfig.getDefaultInstance();
        }
        replaceDictionaryConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.ReplaceDictionaryConfig,
                com.google.privacy.dlp.v2.ReplaceDictionaryConfig.Builder,
                com.google.privacy.dlp.v2.ReplaceDictionaryConfigOrBuilder>(
                (com.google.privacy.dlp.v2.ReplaceDictionaryConfig) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 13;
      onChanged();
      return replaceDictionaryConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.PrimitiveTransformation)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.PrimitiveTransformation)
  private static final com.google.privacy.dlp.v2.PrimitiveTransformation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.PrimitiveTransformation();
  }

  public static com.google.privacy.dlp.v2.PrimitiveTransformation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PrimitiveTransformation> PARSER =
      new com.google.protobuf.AbstractParser<PrimitiveTransformation>() {
        @java.lang.Override
        public PrimitiveTransformation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PrimitiveTransformation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PrimitiveTransformation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.PrimitiveTransformation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
