/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * A column with a semantic tag attached.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.QuasiId}
 */
public final class QuasiId extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.QuasiId)
    QuasiIdOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QuasiId.newBuilder() to construct.
  private QuasiId(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QuasiId() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QuasiId();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_QuasiId_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_QuasiId_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.QuasiId.class,
            com.google.privacy.dlp.v2.QuasiId.Builder.class);
  }

  private int bitField0_;
  private int tagCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object tag_;

  public enum TagCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INFO_TYPE(2),
    CUSTOM_TAG(3),
    INFERRED(4),
    TAG_NOT_SET(0);
    private final int value;

    private TagCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TagCase valueOf(int value) {
      return forNumber(value);
    }

    public static TagCase forNumber(int value) {
      switch (value) {
        case 2:
          return INFO_TYPE;
        case 3:
          return CUSTOM_TAG;
        case 4:
          return INFERRED;
        case 0:
          return TAG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TagCase getTagCase() {
    return TagCase.forNumber(tagCase_);
  }

  public static final int FIELD_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.FieldId field_;
  /**
   *
   *
   * <pre>
   * Required. Identifies the column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the field field is set.
   */
  @java.lang.Override
  public boolean hasField() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Identifies the column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The field.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldId getField() {
    return field_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : field_;
  }
  /**
   *
   *
   * <pre>
   * Required. Identifies the column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldIdOrBuilder getFieldOrBuilder() {
    return field_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : field_;
  }

  public static final int INFO_TYPE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A column can be tagged with a InfoType to use the relevant public
   * dataset as a statistical model of population, if available. We
   * currently support US ZIP codes, region codes, ages and genders.
   * To programmatically obtain the list of supported InfoTypes, use
   * ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
   *
   * @return Whether the infoType field is set.
   */
  @java.lang.Override
  public boolean hasInfoType() {
    return tagCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A column can be tagged with a InfoType to use the relevant public
   * dataset as a statistical model of population, if available. We
   * currently support US ZIP codes, region codes, ages and genders.
   * To programmatically obtain the list of supported InfoTypes, use
   * ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
   *
   * @return The infoType.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoType getInfoType() {
    if (tagCase_ == 2) {
      return (com.google.privacy.dlp.v2.InfoType) tag_;
    }
    return com.google.privacy.dlp.v2.InfoType.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A column can be tagged with a InfoType to use the relevant public
   * dataset as a statistical model of population, if available. We
   * currently support US ZIP codes, region codes, ages and genders.
   * To programmatically obtain the list of supported InfoTypes, use
   * ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder() {
    if (tagCase_ == 2) {
      return (com.google.privacy.dlp.v2.InfoType) tag_;
    }
    return com.google.privacy.dlp.v2.InfoType.getDefaultInstance();
  }

  public static final int CUSTOM_TAG_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * A column can be tagged with a custom tag. In this case, the user must
   * indicate an auxiliary table that contains statistical information on
   * the possible values of this column (below).
   * </pre>
   *
   * <code>string custom_tag = 3;</code>
   *
   * @return Whether the customTag field is set.
   */
  public boolean hasCustomTag() {
    return tagCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * A column can be tagged with a custom tag. In this case, the user must
   * indicate an auxiliary table that contains statistical information on
   * the possible values of this column (below).
   * </pre>
   *
   * <code>string custom_tag = 3;</code>
   *
   * @return The customTag.
   */
  public java.lang.String getCustomTag() {
    java.lang.Object ref = "";
    if (tagCase_ == 3) {
      ref = tag_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (tagCase_ == 3) {
        tag_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A column can be tagged with a custom tag. In this case, the user must
   * indicate an auxiliary table that contains statistical information on
   * the possible values of this column (below).
   * </pre>
   *
   * <code>string custom_tag = 3;</code>
   *
   * @return The bytes for customTag.
   */
  public com.google.protobuf.ByteString getCustomTagBytes() {
    java.lang.Object ref = "";
    if (tagCase_ == 3) {
      ref = tag_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (tagCase_ == 3) {
        tag_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INFERRED_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * If no semantic tag is indicated, we infer the statistical model from
   * the distribution of values in the input data
   * </pre>
   *
   * <code>.google.protobuf.Empty inferred = 4;</code>
   *
   * @return Whether the inferred field is set.
   */
  @java.lang.Override
  public boolean hasInferred() {
    return tagCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * If no semantic tag is indicated, we infer the statistical model from
   * the distribution of values in the input data
   * </pre>
   *
   * <code>.google.protobuf.Empty inferred = 4;</code>
   *
   * @return The inferred.
   */
  @java.lang.Override
  public com.google.protobuf.Empty getInferred() {
    if (tagCase_ == 4) {
      return (com.google.protobuf.Empty) tag_;
    }
    return com.google.protobuf.Empty.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * If no semantic tag is indicated, we infer the statistical model from
   * the distribution of values in the input data
   * </pre>
   *
   * <code>.google.protobuf.Empty inferred = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.EmptyOrBuilder getInferredOrBuilder() {
    if (tagCase_ == 4) {
      return (com.google.protobuf.Empty) tag_;
    }
    return com.google.protobuf.Empty.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getField());
    }
    if (tagCase_ == 2) {
      output.writeMessage(2, (com.google.privacy.dlp.v2.InfoType) tag_);
    }
    if (tagCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tag_);
    }
    if (tagCase_ == 4) {
      output.writeMessage(4, (com.google.protobuf.Empty) tag_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getField());
    }
    if (tagCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.privacy.dlp.v2.InfoType) tag_);
    }
    if (tagCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, tag_);
    }
    if (tagCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.protobuf.Empty) tag_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.QuasiId)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.QuasiId other = (com.google.privacy.dlp.v2.QuasiId) obj;

    if (hasField() != other.hasField()) return false;
    if (hasField()) {
      if (!getField().equals(other.getField())) return false;
    }
    if (!getTagCase().equals(other.getTagCase())) return false;
    switch (tagCase_) {
      case 2:
        if (!getInfoType().equals(other.getInfoType())) return false;
        break;
      case 3:
        if (!getCustomTag().equals(other.getCustomTag())) return false;
        break;
      case 4:
        if (!getInferred().equals(other.getInferred())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasField()) {
      hash = (37 * hash) + FIELD_FIELD_NUMBER;
      hash = (53 * hash) + getField().hashCode();
    }
    switch (tagCase_) {
      case 2:
        hash = (37 * hash) + INFO_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getInfoType().hashCode();
        break;
      case 3:
        hash = (37 * hash) + CUSTOM_TAG_FIELD_NUMBER;
        hash = (53 * hash) + getCustomTag().hashCode();
        break;
      case 4:
        hash = (37 * hash) + INFERRED_FIELD_NUMBER;
        hash = (53 * hash) + getInferred().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.QuasiId parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.QuasiId parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.QuasiId parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.QuasiId parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.QuasiId parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.QuasiId parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.QuasiId parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.QuasiId parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.QuasiId parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.QuasiId parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.QuasiId parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.QuasiId parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.QuasiId prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A column with a semantic tag attached.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.QuasiId}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.QuasiId)
      com.google.privacy.dlp.v2.QuasiIdOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_QuasiId_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_QuasiId_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.QuasiId.class,
              com.google.privacy.dlp.v2.QuasiId.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.QuasiId.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFieldFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      field_ = null;
      if (fieldBuilder_ != null) {
        fieldBuilder_.dispose();
        fieldBuilder_ = null;
      }
      if (infoTypeBuilder_ != null) {
        infoTypeBuilder_.clear();
      }
      if (inferredBuilder_ != null) {
        inferredBuilder_.clear();
      }
      tagCase_ = 0;
      tag_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_QuasiId_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.QuasiId getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.QuasiId.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.QuasiId build() {
      com.google.privacy.dlp.v2.QuasiId result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.QuasiId buildPartial() {
      com.google.privacy.dlp.v2.QuasiId result = new com.google.privacy.dlp.v2.QuasiId(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.QuasiId result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.field_ = fieldBuilder_ == null ? field_ : fieldBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.QuasiId result) {
      result.tagCase_ = tagCase_;
      result.tag_ = this.tag_;
      if (tagCase_ == 2 && infoTypeBuilder_ != null) {
        result.tag_ = infoTypeBuilder_.build();
      }
      if (tagCase_ == 4 && inferredBuilder_ != null) {
        result.tag_ = inferredBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.QuasiId) {
        return mergeFrom((com.google.privacy.dlp.v2.QuasiId) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.QuasiId other) {
      if (other == com.google.privacy.dlp.v2.QuasiId.getDefaultInstance()) return this;
      if (other.hasField()) {
        mergeField(other.getField());
      }
      switch (other.getTagCase()) {
        case INFO_TYPE:
          {
            mergeInfoType(other.getInfoType());
            break;
          }
        case CUSTOM_TAG:
          {
            tagCase_ = 3;
            tag_ = other.tag_;
            onChanged();
            break;
          }
        case INFERRED:
          {
            mergeInferred(other.getInferred());
            break;
          }
        case TAG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getFieldFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInfoTypeFieldBuilder().getBuilder(), extensionRegistry);
                tagCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                tagCase_ = 3;
                tag_ = s;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getInferredFieldBuilder().getBuilder(), extensionRegistry);
                tagCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int tagCase_ = 0;
    private java.lang.Object tag_;

    public TagCase getTagCase() {
      return TagCase.forNumber(tagCase_);
    }

    public Builder clearTag() {
      tagCase_ = 0;
      tag_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.FieldId field_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        fieldBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Identifies the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the field field is set.
     */
    public boolean hasField() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Identifies the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The field.
     */
    public com.google.privacy.dlp.v2.FieldId getField() {
      if (fieldBuilder_ == null) {
        return field_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : field_;
      } else {
        return fieldBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Identifies the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setField(com.google.privacy.dlp.v2.FieldId value) {
      if (fieldBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        field_ = value;
      } else {
        fieldBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Identifies the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setField(com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (fieldBuilder_ == null) {
        field_ = builderForValue.build();
      } else {
        fieldBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Identifies the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeField(com.google.privacy.dlp.v2.FieldId value) {
      if (fieldBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && field_ != null
            && field_ != com.google.privacy.dlp.v2.FieldId.getDefaultInstance()) {
          getFieldBuilder().mergeFrom(value);
        } else {
          field_ = value;
        }
      } else {
        fieldBuilder_.mergeFrom(value);
      }
      if (field_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Identifies the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearField() {
      bitField0_ = (bitField0_ & ~0x00000001);
      field_ = null;
      if (fieldBuilder_ != null) {
        fieldBuilder_.dispose();
        fieldBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Identifies the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder getFieldBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getFieldFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Identifies the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.FieldIdOrBuilder getFieldOrBuilder() {
      if (fieldBuilder_ != null) {
        return fieldBuilder_.getMessageOrBuilder();
      } else {
        return field_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : field_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Identifies the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        getFieldFieldBuilder() {
      if (fieldBuilder_ == null) {
        fieldBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.FieldId,
                com.google.privacy.dlp.v2.FieldId.Builder,
                com.google.privacy.dlp.v2.FieldIdOrBuilder>(
                getField(), getParentForChildren(), isClean());
        field_ = null;
      }
      return fieldBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoType,
            com.google.privacy.dlp.v2.InfoType.Builder,
            com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        infoTypeBuilder_;
    /**
     *
     *
     * <pre>
     * A column can be tagged with a InfoType to use the relevant public
     * dataset as a statistical model of population, if available. We
     * currently support US ZIP codes, region codes, ages and genders.
     * To programmatically obtain the list of supported InfoTypes, use
     * ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     *
     * @return Whether the infoType field is set.
     */
    @java.lang.Override
    public boolean hasInfoType() {
      return tagCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A column can be tagged with a InfoType to use the relevant public
     * dataset as a statistical model of population, if available. We
     * currently support US ZIP codes, region codes, ages and genders.
     * To programmatically obtain the list of supported InfoTypes, use
     * ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     *
     * @return The infoType.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoType getInfoType() {
      if (infoTypeBuilder_ == null) {
        if (tagCase_ == 2) {
          return (com.google.privacy.dlp.v2.InfoType) tag_;
        }
        return com.google.privacy.dlp.v2.InfoType.getDefaultInstance();
      } else {
        if (tagCase_ == 2) {
          return infoTypeBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.InfoType.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A column can be tagged with a InfoType to use the relevant public
     * dataset as a statistical model of population, if available. We
     * currently support US ZIP codes, region codes, ages and genders.
     * To programmatically obtain the list of supported InfoTypes, use
     * ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     */
    public Builder setInfoType(com.google.privacy.dlp.v2.InfoType value) {
      if (infoTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tag_ = value;
        onChanged();
      } else {
        infoTypeBuilder_.setMessage(value);
      }
      tagCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A column can be tagged with a InfoType to use the relevant public
     * dataset as a statistical model of population, if available. We
     * currently support US ZIP codes, region codes, ages and genders.
     * To programmatically obtain the list of supported InfoTypes, use
     * ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     */
    public Builder setInfoType(com.google.privacy.dlp.v2.InfoType.Builder builderForValue) {
      if (infoTypeBuilder_ == null) {
        tag_ = builderForValue.build();
        onChanged();
      } else {
        infoTypeBuilder_.setMessage(builderForValue.build());
      }
      tagCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A column can be tagged with a InfoType to use the relevant public
     * dataset as a statistical model of population, if available. We
     * currently support US ZIP codes, region codes, ages and genders.
     * To programmatically obtain the list of supported InfoTypes, use
     * ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     */
    public Builder mergeInfoType(com.google.privacy.dlp.v2.InfoType value) {
      if (infoTypeBuilder_ == null) {
        if (tagCase_ == 2 && tag_ != com.google.privacy.dlp.v2.InfoType.getDefaultInstance()) {
          tag_ =
              com.google.privacy.dlp.v2.InfoType.newBuilder(
                      (com.google.privacy.dlp.v2.InfoType) tag_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          tag_ = value;
        }
        onChanged();
      } else {
        if (tagCase_ == 2) {
          infoTypeBuilder_.mergeFrom(value);
        } else {
          infoTypeBuilder_.setMessage(value);
        }
      }
      tagCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A column can be tagged with a InfoType to use the relevant public
     * dataset as a statistical model of population, if available. We
     * currently support US ZIP codes, region codes, ages and genders.
     * To programmatically obtain the list of supported InfoTypes, use
     * ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     */
    public Builder clearInfoType() {
      if (infoTypeBuilder_ == null) {
        if (tagCase_ == 2) {
          tagCase_ = 0;
          tag_ = null;
          onChanged();
        }
      } else {
        if (tagCase_ == 2) {
          tagCase_ = 0;
          tag_ = null;
        }
        infoTypeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A column can be tagged with a InfoType to use the relevant public
     * dataset as a statistical model of population, if available. We
     * currently support US ZIP codes, region codes, ages and genders.
     * To programmatically obtain the list of supported InfoTypes, use
     * ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     */
    public com.google.privacy.dlp.v2.InfoType.Builder getInfoTypeBuilder() {
      return getInfoTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A column can be tagged with a InfoType to use the relevant public
     * dataset as a statistical model of population, if available. We
     * currently support US ZIP codes, region codes, ages and genders.
     * To programmatically obtain the list of supported InfoTypes, use
     * ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder() {
      if ((tagCase_ == 2) && (infoTypeBuilder_ != null)) {
        return infoTypeBuilder_.getMessageOrBuilder();
      } else {
        if (tagCase_ == 2) {
          return (com.google.privacy.dlp.v2.InfoType) tag_;
        }
        return com.google.privacy.dlp.v2.InfoType.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A column can be tagged with a InfoType to use the relevant public
     * dataset as a statistical model of population, if available. We
     * currently support US ZIP codes, region codes, ages and genders.
     * To programmatically obtain the list of supported InfoTypes, use
     * ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoType,
            com.google.privacy.dlp.v2.InfoType.Builder,
            com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        getInfoTypeFieldBuilder() {
      if (infoTypeBuilder_ == null) {
        if (!(tagCase_ == 2)) {
          tag_ = com.google.privacy.dlp.v2.InfoType.getDefaultInstance();
        }
        infoTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InfoType,
                com.google.privacy.dlp.v2.InfoType.Builder,
                com.google.privacy.dlp.v2.InfoTypeOrBuilder>(
                (com.google.privacy.dlp.v2.InfoType) tag_, getParentForChildren(), isClean());
        tag_ = null;
      }
      tagCase_ = 2;
      onChanged();
      return infoTypeBuilder_;
    }

    /**
     *
     *
     * <pre>
     * A column can be tagged with a custom tag. In this case, the user must
     * indicate an auxiliary table that contains statistical information on
     * the possible values of this column (below).
     * </pre>
     *
     * <code>string custom_tag = 3;</code>
     *
     * @return Whether the customTag field is set.
     */
    @java.lang.Override
    public boolean hasCustomTag() {
      return tagCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * A column can be tagged with a custom tag. In this case, the user must
     * indicate an auxiliary table that contains statistical information on
     * the possible values of this column (below).
     * </pre>
     *
     * <code>string custom_tag = 3;</code>
     *
     * @return The customTag.
     */
    @java.lang.Override
    public java.lang.String getCustomTag() {
      java.lang.Object ref = "";
      if (tagCase_ == 3) {
        ref = tag_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (tagCase_ == 3) {
          tag_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A column can be tagged with a custom tag. In this case, the user must
     * indicate an auxiliary table that contains statistical information on
     * the possible values of this column (below).
     * </pre>
     *
     * <code>string custom_tag = 3;</code>
     *
     * @return The bytes for customTag.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCustomTagBytes() {
      java.lang.Object ref = "";
      if (tagCase_ == 3) {
        ref = tag_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (tagCase_ == 3) {
          tag_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A column can be tagged with a custom tag. In this case, the user must
     * indicate an auxiliary table that contains statistical information on
     * the possible values of this column (below).
     * </pre>
     *
     * <code>string custom_tag = 3;</code>
     *
     * @param value The customTag to set.
     * @return This builder for chaining.
     */
    public Builder setCustomTag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tagCase_ = 3;
      tag_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A column can be tagged with a custom tag. In this case, the user must
     * indicate an auxiliary table that contains statistical information on
     * the possible values of this column (below).
     * </pre>
     *
     * <code>string custom_tag = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomTag() {
      if (tagCase_ == 3) {
        tagCase_ = 0;
        tag_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A column can be tagged with a custom tag. In this case, the user must
     * indicate an auxiliary table that contains statistical information on
     * the possible values of this column (below).
     * </pre>
     *
     * <code>string custom_tag = 3;</code>
     *
     * @param value The bytes for customTag to set.
     * @return This builder for chaining.
     */
    public Builder setCustomTagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tagCase_ = 3;
      tag_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Empty,
            com.google.protobuf.Empty.Builder,
            com.google.protobuf.EmptyOrBuilder>
        inferredBuilder_;
    /**
     *
     *
     * <pre>
     * If no semantic tag is indicated, we infer the statistical model from
     * the distribution of values in the input data
     * </pre>
     *
     * <code>.google.protobuf.Empty inferred = 4;</code>
     *
     * @return Whether the inferred field is set.
     */
    @java.lang.Override
    public boolean hasInferred() {
      return tagCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * If no semantic tag is indicated, we infer the statistical model from
     * the distribution of values in the input data
     * </pre>
     *
     * <code>.google.protobuf.Empty inferred = 4;</code>
     *
     * @return The inferred.
     */
    @java.lang.Override
    public com.google.protobuf.Empty getInferred() {
      if (inferredBuilder_ == null) {
        if (tagCase_ == 4) {
          return (com.google.protobuf.Empty) tag_;
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      } else {
        if (tagCase_ == 4) {
          return inferredBuilder_.getMessage();
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If no semantic tag is indicated, we infer the statistical model from
     * the distribution of values in the input data
     * </pre>
     *
     * <code>.google.protobuf.Empty inferred = 4;</code>
     */
    public Builder setInferred(com.google.protobuf.Empty value) {
      if (inferredBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tag_ = value;
        onChanged();
      } else {
        inferredBuilder_.setMessage(value);
      }
      tagCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If no semantic tag is indicated, we infer the statistical model from
     * the distribution of values in the input data
     * </pre>
     *
     * <code>.google.protobuf.Empty inferred = 4;</code>
     */
    public Builder setInferred(com.google.protobuf.Empty.Builder builderForValue) {
      if (inferredBuilder_ == null) {
        tag_ = builderForValue.build();
        onChanged();
      } else {
        inferredBuilder_.setMessage(builderForValue.build());
      }
      tagCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If no semantic tag is indicated, we infer the statistical model from
     * the distribution of values in the input data
     * </pre>
     *
     * <code>.google.protobuf.Empty inferred = 4;</code>
     */
    public Builder mergeInferred(com.google.protobuf.Empty value) {
      if (inferredBuilder_ == null) {
        if (tagCase_ == 4 && tag_ != com.google.protobuf.Empty.getDefaultInstance()) {
          tag_ =
              com.google.protobuf.Empty.newBuilder((com.google.protobuf.Empty) tag_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          tag_ = value;
        }
        onChanged();
      } else {
        if (tagCase_ == 4) {
          inferredBuilder_.mergeFrom(value);
        } else {
          inferredBuilder_.setMessage(value);
        }
      }
      tagCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If no semantic tag is indicated, we infer the statistical model from
     * the distribution of values in the input data
     * </pre>
     *
     * <code>.google.protobuf.Empty inferred = 4;</code>
     */
    public Builder clearInferred() {
      if (inferredBuilder_ == null) {
        if (tagCase_ == 4) {
          tagCase_ = 0;
          tag_ = null;
          onChanged();
        }
      } else {
        if (tagCase_ == 4) {
          tagCase_ = 0;
          tag_ = null;
        }
        inferredBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If no semantic tag is indicated, we infer the statistical model from
     * the distribution of values in the input data
     * </pre>
     *
     * <code>.google.protobuf.Empty inferred = 4;</code>
     */
    public com.google.protobuf.Empty.Builder getInferredBuilder() {
      return getInferredFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If no semantic tag is indicated, we infer the statistical model from
     * the distribution of values in the input data
     * </pre>
     *
     * <code>.google.protobuf.Empty inferred = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.EmptyOrBuilder getInferredOrBuilder() {
      if ((tagCase_ == 4) && (inferredBuilder_ != null)) {
        return inferredBuilder_.getMessageOrBuilder();
      } else {
        if (tagCase_ == 4) {
          return (com.google.protobuf.Empty) tag_;
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If no semantic tag is indicated, we infer the statistical model from
     * the distribution of values in the input data
     * </pre>
     *
     * <code>.google.protobuf.Empty inferred = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Empty,
            com.google.protobuf.Empty.Builder,
            com.google.protobuf.EmptyOrBuilder>
        getInferredFieldBuilder() {
      if (inferredBuilder_ == null) {
        if (!(tagCase_ == 4)) {
          tag_ = com.google.protobuf.Empty.getDefaultInstance();
        }
        inferredBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Empty,
                com.google.protobuf.Empty.Builder,
                com.google.protobuf.EmptyOrBuilder>(
                (com.google.protobuf.Empty) tag_, getParentForChildren(), isClean());
        tag_ = null;
      }
      tagCase_ = 4;
      onChanged();
      return inferredBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.QuasiId)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.QuasiId)
  private static final com.google.privacy.dlp.v2.QuasiId DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.QuasiId();
  }

  public static com.google.privacy.dlp.v2.QuasiId getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QuasiId> PARSER =
      new com.google.protobuf.AbstractParser<QuasiId>() {
        @java.lang.Override
        public QuasiId parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QuasiId> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QuasiId> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.QuasiId getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
