/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * A condition for determining whether a transformation should be applied to
 * a field.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.RecordCondition}
 */
public final class RecordCondition extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.RecordCondition)
    RecordConditionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RecordCondition.newBuilder() to construct.
  private RecordCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RecordCondition() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RecordCondition();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_RecordCondition_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_RecordCondition_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.RecordCondition.class,
            com.google.privacy.dlp.v2.RecordCondition.Builder.class);
  }

  public interface ConditionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.RecordCondition.Condition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Field within the record this condition is evaluated against.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the field field is set.
     */
    boolean hasField();
    /**
     *
     *
     * <pre>
     * Required. Field within the record this condition is evaluated against.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The field.
     */
    com.google.privacy.dlp.v2.FieldId getField();
    /**
     *
     *
     * <pre>
     * Required. Field within the record this condition is evaluated against.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.privacy.dlp.v2.FieldIdOrBuilder getFieldOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Operator used to compare the field or infoType to the value.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.RelationalOperator operator = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for operator.
     */
    int getOperatorValue();
    /**
     *
     *
     * <pre>
     * Required. Operator used to compare the field or infoType to the value.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.RelationalOperator operator = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The operator.
     */
    com.google.privacy.dlp.v2.RelationalOperator getOperator();

    /**
     *
     *
     * <pre>
     * Value to compare against. [Mandatory, except for `EXISTS` tests.]
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value value = 4;</code>
     *
     * @return Whether the value field is set.
     */
    boolean hasValue();
    /**
     *
     *
     * <pre>
     * Value to compare against. [Mandatory, except for `EXISTS` tests.]
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value value = 4;</code>
     *
     * @return The value.
     */
    com.google.privacy.dlp.v2.Value getValue();
    /**
     *
     *
     * <pre>
     * Value to compare against. [Mandatory, except for `EXISTS` tests.]
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value value = 4;</code>
     */
    com.google.privacy.dlp.v2.ValueOrBuilder getValueOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The field type of `value` and `field` do not need to match to be
   * considered equal, but not all comparisons are possible.
   * EQUAL_TO and NOT_EQUAL_TO attempt to compare even with incompatible types,
   * but all other comparisons are invalid with incompatible types.
   * A `value` of type:
   *
   * - `string` can be compared against all other types
   * - `boolean` can only be compared against other booleans
   * - `integer` can be compared against doubles or a string if the string value
   * can be parsed as an integer.
   * - `double` can be compared against integers or a string if the string can
   * be parsed as a double.
   * - `Timestamp` can be compared against strings in RFC 3339 date string
   * format.
   * - `TimeOfDay` can be compared against timestamps and strings in the format
   * of 'HH:mm:ss'.
   *
   * If we fail to compare do to type mismatch, a warning will be given and
   * the condition will evaluate to false.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.RecordCondition.Condition}
   */
  public static final class Condition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.RecordCondition.Condition)
      ConditionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Condition.newBuilder() to construct.
    private Condition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Condition() {
      operator_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Condition();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RecordCondition_Condition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RecordCondition_Condition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.RecordCondition.Condition.class,
              com.google.privacy.dlp.v2.RecordCondition.Condition.Builder.class);
    }

    private int bitField0_;
    public static final int FIELD_FIELD_NUMBER = 1;
    private com.google.privacy.dlp.v2.FieldId field_;
    /**
     *
     *
     * <pre>
     * Required. Field within the record this condition is evaluated against.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the field field is set.
     */
    @java.lang.Override
    public boolean hasField() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Field within the record this condition is evaluated against.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The field.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.FieldId getField() {
      return field_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : field_;
    }
    /**
     *
     *
     * <pre>
     * Required. Field within the record this condition is evaluated against.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.FieldIdOrBuilder getFieldOrBuilder() {
      return field_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : field_;
    }

    public static final int OPERATOR_FIELD_NUMBER = 3;
    private int operator_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Operator used to compare the field or infoType to the value.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.RelationalOperator operator = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for operator.
     */
    @java.lang.Override
    public int getOperatorValue() {
      return operator_;
    }
    /**
     *
     *
     * <pre>
     * Required. Operator used to compare the field or infoType to the value.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.RelationalOperator operator = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The operator.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.RelationalOperator getOperator() {
      com.google.privacy.dlp.v2.RelationalOperator result =
          com.google.privacy.dlp.v2.RelationalOperator.forNumber(operator_);
      return result == null ? com.google.privacy.dlp.v2.RelationalOperator.UNRECOGNIZED : result;
    }

    public static final int VALUE_FIELD_NUMBER = 4;
    private com.google.privacy.dlp.v2.Value value_;
    /**
     *
     *
     * <pre>
     * Value to compare against. [Mandatory, except for `EXISTS` tests.]
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value value = 4;</code>
     *
     * @return Whether the value field is set.
     */
    @java.lang.Override
    public boolean hasValue() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Value to compare against. [Mandatory, except for `EXISTS` tests.]
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value value = 4;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Value getValue() {
      return value_ == null ? com.google.privacy.dlp.v2.Value.getDefaultInstance() : value_;
    }
    /**
     *
     *
     * <pre>
     * Value to compare against. [Mandatory, except for `EXISTS` tests.]
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value value = 4;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ValueOrBuilder getValueOrBuilder() {
      return value_ == null ? com.google.privacy.dlp.v2.Value.getDefaultInstance() : value_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getField());
      }
      if (operator_
          != com.google.privacy.dlp.v2.RelationalOperator.RELATIONAL_OPERATOR_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, operator_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(4, getValue());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getField());
      }
      if (operator_
          != com.google.privacy.dlp.v2.RelationalOperator.RELATIONAL_OPERATOR_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, operator_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getValue());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.RecordCondition.Condition)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.RecordCondition.Condition other =
          (com.google.privacy.dlp.v2.RecordCondition.Condition) obj;

      if (hasField() != other.hasField()) return false;
      if (hasField()) {
        if (!getField().equals(other.getField())) return false;
      }
      if (operator_ != other.operator_) return false;
      if (hasValue() != other.hasValue()) return false;
      if (hasValue()) {
        if (!getValue().equals(other.getValue())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasField()) {
        hash = (37 * hash) + FIELD_FIELD_NUMBER;
        hash = (53 * hash) + getField().hashCode();
      }
      hash = (37 * hash) + OPERATOR_FIELD_NUMBER;
      hash = (53 * hash) + operator_;
      if (hasValue()) {
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getValue().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Condition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Condition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Condition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Condition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Condition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Condition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Condition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Condition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Condition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Condition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Condition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Condition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.RecordCondition.Condition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The field type of `value` and `field` do not need to match to be
     * considered equal, but not all comparisons are possible.
     * EQUAL_TO and NOT_EQUAL_TO attempt to compare even with incompatible types,
     * but all other comparisons are invalid with incompatible types.
     * A `value` of type:
     *
     * - `string` can be compared against all other types
     * - `boolean` can only be compared against other booleans
     * - `integer` can be compared against doubles or a string if the string value
     * can be parsed as an integer.
     * - `double` can be compared against integers or a string if the string can
     * be parsed as a double.
     * - `Timestamp` can be compared against strings in RFC 3339 date string
     * format.
     * - `TimeOfDay` can be compared against timestamps and strings in the format
     * of 'HH:mm:ss'.
     *
     * If we fail to compare do to type mismatch, a warning will be given and
     * the condition will evaluate to false.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.RecordCondition.Condition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.RecordCondition.Condition)
        com.google.privacy.dlp.v2.RecordCondition.ConditionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_RecordCondition_Condition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_RecordCondition_Condition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.RecordCondition.Condition.class,
                com.google.privacy.dlp.v2.RecordCondition.Condition.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.RecordCondition.Condition.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getFieldFieldBuilder();
          getValueFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        field_ = null;
        if (fieldBuilder_ != null) {
          fieldBuilder_.dispose();
          fieldBuilder_ = null;
        }
        operator_ = 0;
        value_ = null;
        if (valueBuilder_ != null) {
          valueBuilder_.dispose();
          valueBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_RecordCondition_Condition_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.RecordCondition.Condition getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.RecordCondition.Condition.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.RecordCondition.Condition build() {
        com.google.privacy.dlp.v2.RecordCondition.Condition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.RecordCondition.Condition buildPartial() {
        com.google.privacy.dlp.v2.RecordCondition.Condition result =
            new com.google.privacy.dlp.v2.RecordCondition.Condition(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.privacy.dlp.v2.RecordCondition.Condition result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.field_ = fieldBuilder_ == null ? field_ : fieldBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.operator_ = operator_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.value_ = valueBuilder_ == null ? value_ : valueBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.RecordCondition.Condition) {
          return mergeFrom((com.google.privacy.dlp.v2.RecordCondition.Condition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.RecordCondition.Condition other) {
        if (other == com.google.privacy.dlp.v2.RecordCondition.Condition.getDefaultInstance())
          return this;
        if (other.hasField()) {
          mergeField(other.getField());
        }
        if (other.operator_ != 0) {
          setOperatorValue(other.getOperatorValue());
        }
        if (other.hasValue()) {
          mergeValue(other.getValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getFieldFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 24:
                {
                  operator_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 24
              case 34:
                {
                  input.readMessage(getValueFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.privacy.dlp.v2.FieldId field_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.FieldId,
              com.google.privacy.dlp.v2.FieldId.Builder,
              com.google.privacy.dlp.v2.FieldIdOrBuilder>
          fieldBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Field within the record this condition is evaluated against.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the field field is set.
       */
      public boolean hasField() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Field within the record this condition is evaluated against.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The field.
       */
      public com.google.privacy.dlp.v2.FieldId getField() {
        if (fieldBuilder_ == null) {
          return field_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : field_;
        } else {
          return fieldBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Field within the record this condition is evaluated against.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setField(com.google.privacy.dlp.v2.FieldId value) {
        if (fieldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          field_ = value;
        } else {
          fieldBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Field within the record this condition is evaluated against.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setField(com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
        if (fieldBuilder_ == null) {
          field_ = builderForValue.build();
        } else {
          fieldBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Field within the record this condition is evaluated against.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeField(com.google.privacy.dlp.v2.FieldId value) {
        if (fieldBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && field_ != null
              && field_ != com.google.privacy.dlp.v2.FieldId.getDefaultInstance()) {
            getFieldBuilder().mergeFrom(value);
          } else {
            field_ = value;
          }
        } else {
          fieldBuilder_.mergeFrom(value);
        }
        if (field_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Field within the record this condition is evaluated against.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearField() {
        bitField0_ = (bitField0_ & ~0x00000001);
        field_ = null;
        if (fieldBuilder_ != null) {
          fieldBuilder_.dispose();
          fieldBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Field within the record this condition is evaluated against.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.privacy.dlp.v2.FieldId.Builder getFieldBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getFieldFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Field within the record this condition is evaluated against.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.privacy.dlp.v2.FieldIdOrBuilder getFieldOrBuilder() {
        if (fieldBuilder_ != null) {
          return fieldBuilder_.getMessageOrBuilder();
        } else {
          return field_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : field_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Field within the record this condition is evaluated against.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.FieldId,
              com.google.privacy.dlp.v2.FieldId.Builder,
              com.google.privacy.dlp.v2.FieldIdOrBuilder>
          getFieldFieldBuilder() {
        if (fieldBuilder_ == null) {
          fieldBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.FieldId,
                  com.google.privacy.dlp.v2.FieldId.Builder,
                  com.google.privacy.dlp.v2.FieldIdOrBuilder>(
                  getField(), getParentForChildren(), isClean());
          field_ = null;
        }
        return fieldBuilder_;
      }

      private int operator_ = 0;
      /**
       *
       *
       * <pre>
       * Required. Operator used to compare the field or infoType to the value.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.RelationalOperator operator = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for operator.
       */
      @java.lang.Override
      public int getOperatorValue() {
        return operator_;
      }
      /**
       *
       *
       * <pre>
       * Required. Operator used to compare the field or infoType to the value.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.RelationalOperator operator = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for operator to set.
       * @return This builder for chaining.
       */
      public Builder setOperatorValue(int value) {
        operator_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Operator used to compare the field or infoType to the value.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.RelationalOperator operator = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The operator.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.RelationalOperator getOperator() {
        com.google.privacy.dlp.v2.RelationalOperator result =
            com.google.privacy.dlp.v2.RelationalOperator.forNumber(operator_);
        return result == null ? com.google.privacy.dlp.v2.RelationalOperator.UNRECOGNIZED : result;
      }
      /**
       *
       *
       * <pre>
       * Required. Operator used to compare the field or infoType to the value.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.RelationalOperator operator = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The operator to set.
       * @return This builder for chaining.
       */
      public Builder setOperator(com.google.privacy.dlp.v2.RelationalOperator value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        operator_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Operator used to compare the field or infoType to the value.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.RelationalOperator operator = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOperator() {
        bitField0_ = (bitField0_ & ~0x00000002);
        operator_ = 0;
        onChanged();
        return this;
      }

      private com.google.privacy.dlp.v2.Value value_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.Value,
              com.google.privacy.dlp.v2.Value.Builder,
              com.google.privacy.dlp.v2.ValueOrBuilder>
          valueBuilder_;
      /**
       *
       *
       * <pre>
       * Value to compare against. [Mandatory, except for `EXISTS` tests.]
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value value = 4;</code>
       *
       * @return Whether the value field is set.
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Value to compare against. [Mandatory, except for `EXISTS` tests.]
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value value = 4;</code>
       *
       * @return The value.
       */
      public com.google.privacy.dlp.v2.Value getValue() {
        if (valueBuilder_ == null) {
          return value_ == null ? com.google.privacy.dlp.v2.Value.getDefaultInstance() : value_;
        } else {
          return valueBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Value to compare against. [Mandatory, except for `EXISTS` tests.]
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value value = 4;</code>
       */
      public Builder setValue(com.google.privacy.dlp.v2.Value value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
        } else {
          valueBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Value to compare against. [Mandatory, except for `EXISTS` tests.]
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value value = 4;</code>
       */
      public Builder setValue(com.google.privacy.dlp.v2.Value.Builder builderForValue) {
        if (valueBuilder_ == null) {
          value_ = builderForValue.build();
        } else {
          valueBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Value to compare against. [Mandatory, except for `EXISTS` tests.]
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value value = 4;</code>
       */
      public Builder mergeValue(com.google.privacy.dlp.v2.Value value) {
        if (valueBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && value_ != null
              && value_ != com.google.privacy.dlp.v2.Value.getDefaultInstance()) {
            getValueBuilder().mergeFrom(value);
          } else {
            value_ = value;
          }
        } else {
          valueBuilder_.mergeFrom(value);
        }
        if (value_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Value to compare against. [Mandatory, except for `EXISTS` tests.]
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value value = 4;</code>
       */
      public Builder clearValue() {
        bitField0_ = (bitField0_ & ~0x00000004);
        value_ = null;
        if (valueBuilder_ != null) {
          valueBuilder_.dispose();
          valueBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Value to compare against. [Mandatory, except for `EXISTS` tests.]
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value value = 4;</code>
       */
      public com.google.privacy.dlp.v2.Value.Builder getValueBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getValueFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Value to compare against. [Mandatory, except for `EXISTS` tests.]
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value value = 4;</code>
       */
      public com.google.privacy.dlp.v2.ValueOrBuilder getValueOrBuilder() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilder();
        } else {
          return value_ == null ? com.google.privacy.dlp.v2.Value.getDefaultInstance() : value_;
        }
      }
      /**
       *
       *
       * <pre>
       * Value to compare against. [Mandatory, except for `EXISTS` tests.]
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value value = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.Value,
              com.google.privacy.dlp.v2.Value.Builder,
              com.google.privacy.dlp.v2.ValueOrBuilder>
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.Value,
                  com.google.privacy.dlp.v2.Value.Builder,
                  com.google.privacy.dlp.v2.ValueOrBuilder>(
                  getValue(), getParentForChildren(), isClean());
          value_ = null;
        }
        return valueBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.RecordCondition.Condition)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.RecordCondition.Condition)
    private static final com.google.privacy.dlp.v2.RecordCondition.Condition DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.RecordCondition.Condition();
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Condition getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Condition> PARSER =
        new com.google.protobuf.AbstractParser<Condition>() {
          @java.lang.Override
          public Condition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Condition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Condition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordCondition.Condition getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConditionsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.RecordCondition.Conditions)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A collection of conditions.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
     */
    java.util.List<com.google.privacy.dlp.v2.RecordCondition.Condition> getConditionsList();
    /**
     *
     *
     * <pre>
     * A collection of conditions.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
     */
    com.google.privacy.dlp.v2.RecordCondition.Condition getConditions(int index);
    /**
     *
     *
     * <pre>
     * A collection of conditions.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
     */
    int getConditionsCount();
    /**
     *
     *
     * <pre>
     * A collection of conditions.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
     */
    java.util.List<? extends com.google.privacy.dlp.v2.RecordCondition.ConditionOrBuilder>
        getConditionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A collection of conditions.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
     */
    com.google.privacy.dlp.v2.RecordCondition.ConditionOrBuilder getConditionsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A collection of conditions.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.RecordCondition.Conditions}
   */
  public static final class Conditions extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.RecordCondition.Conditions)
      ConditionsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Conditions.newBuilder() to construct.
    private Conditions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Conditions() {
      conditions_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Conditions();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RecordCondition_Conditions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RecordCondition_Conditions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.RecordCondition.Conditions.class,
              com.google.privacy.dlp.v2.RecordCondition.Conditions.Builder.class);
    }

    public static final int CONDITIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.privacy.dlp.v2.RecordCondition.Condition> conditions_;
    /**
     *
     *
     * <pre>
     * A collection of conditions.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.privacy.dlp.v2.RecordCondition.Condition> getConditionsList() {
      return conditions_;
    }
    /**
     *
     *
     * <pre>
     * A collection of conditions.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.privacy.dlp.v2.RecordCondition.ConditionOrBuilder>
        getConditionsOrBuilderList() {
      return conditions_;
    }
    /**
     *
     *
     * <pre>
     * A collection of conditions.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
     */
    @java.lang.Override
    public int getConditionsCount() {
      return conditions_.size();
    }
    /**
     *
     *
     * <pre>
     * A collection of conditions.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordCondition.Condition getConditions(int index) {
      return conditions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A collection of conditions.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordCondition.ConditionOrBuilder getConditionsOrBuilder(
        int index) {
      return conditions_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < conditions_.size(); i++) {
        output.writeMessage(1, conditions_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < conditions_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, conditions_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.RecordCondition.Conditions)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.RecordCondition.Conditions other =
          (com.google.privacy.dlp.v2.RecordCondition.Conditions) obj;

      if (!getConditionsList().equals(other.getConditionsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getConditionsCount() > 0) {
        hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
        hash = (53 * hash) + getConditionsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Conditions parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Conditions parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Conditions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Conditions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Conditions parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Conditions parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Conditions parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Conditions parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Conditions parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Conditions parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Conditions parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Conditions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.RecordCondition.Conditions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A collection of conditions.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.RecordCondition.Conditions}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.RecordCondition.Conditions)
        com.google.privacy.dlp.v2.RecordCondition.ConditionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_RecordCondition_Conditions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_RecordCondition_Conditions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.RecordCondition.Conditions.class,
                com.google.privacy.dlp.v2.RecordCondition.Conditions.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.RecordCondition.Conditions.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (conditionsBuilder_ == null) {
          conditions_ = java.util.Collections.emptyList();
        } else {
          conditions_ = null;
          conditionsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_RecordCondition_Conditions_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.RecordCondition.Conditions getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.RecordCondition.Conditions.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.RecordCondition.Conditions build() {
        com.google.privacy.dlp.v2.RecordCondition.Conditions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.RecordCondition.Conditions buildPartial() {
        com.google.privacy.dlp.v2.RecordCondition.Conditions result =
            new com.google.privacy.dlp.v2.RecordCondition.Conditions(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.privacy.dlp.v2.RecordCondition.Conditions result) {
        if (conditionsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            conditions_ = java.util.Collections.unmodifiableList(conditions_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.conditions_ = conditions_;
        } else {
          result.conditions_ = conditionsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.privacy.dlp.v2.RecordCondition.Conditions result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.RecordCondition.Conditions) {
          return mergeFrom((com.google.privacy.dlp.v2.RecordCondition.Conditions) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.RecordCondition.Conditions other) {
        if (other == com.google.privacy.dlp.v2.RecordCondition.Conditions.getDefaultInstance())
          return this;
        if (conditionsBuilder_ == null) {
          if (!other.conditions_.isEmpty()) {
            if (conditions_.isEmpty()) {
              conditions_ = other.conditions_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureConditionsIsMutable();
              conditions_.addAll(other.conditions_);
            }
            onChanged();
          }
        } else {
          if (!other.conditions_.isEmpty()) {
            if (conditionsBuilder_.isEmpty()) {
              conditionsBuilder_.dispose();
              conditionsBuilder_ = null;
              conditions_ = other.conditions_;
              bitField0_ = (bitField0_ & ~0x00000001);
              conditionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getConditionsFieldBuilder()
                      : null;
            } else {
              conditionsBuilder_.addAllMessages(other.conditions_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.privacy.dlp.v2.RecordCondition.Condition m =
                      input.readMessage(
                          com.google.privacy.dlp.v2.RecordCondition.Condition.parser(),
                          extensionRegistry);
                  if (conditionsBuilder_ == null) {
                    ensureConditionsIsMutable();
                    conditions_.add(m);
                  } else {
                    conditionsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.privacy.dlp.v2.RecordCondition.Condition> conditions_ =
          java.util.Collections.emptyList();

      private void ensureConditionsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          conditions_ =
              new java.util.ArrayList<com.google.privacy.dlp.v2.RecordCondition.Condition>(
                  conditions_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.privacy.dlp.v2.RecordCondition.Condition,
              com.google.privacy.dlp.v2.RecordCondition.Condition.Builder,
              com.google.privacy.dlp.v2.RecordCondition.ConditionOrBuilder>
          conditionsBuilder_;

      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public java.util.List<com.google.privacy.dlp.v2.RecordCondition.Condition>
          getConditionsList() {
        if (conditionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(conditions_);
        } else {
          return conditionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public int getConditionsCount() {
        if (conditionsBuilder_ == null) {
          return conditions_.size();
        } else {
          return conditionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public com.google.privacy.dlp.v2.RecordCondition.Condition getConditions(int index) {
        if (conditionsBuilder_ == null) {
          return conditions_.get(index);
        } else {
          return conditionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public Builder setConditions(
          int index, com.google.privacy.dlp.v2.RecordCondition.Condition value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionsIsMutable();
          conditions_.set(index, value);
          onChanged();
        } else {
          conditionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public Builder setConditions(
          int index, com.google.privacy.dlp.v2.RecordCondition.Condition.Builder builderForValue) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.set(index, builderForValue.build());
          onChanged();
        } else {
          conditionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public Builder addConditions(com.google.privacy.dlp.v2.RecordCondition.Condition value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionsIsMutable();
          conditions_.add(value);
          onChanged();
        } else {
          conditionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public Builder addConditions(
          int index, com.google.privacy.dlp.v2.RecordCondition.Condition value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionsIsMutable();
          conditions_.add(index, value);
          onChanged();
        } else {
          conditionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public Builder addConditions(
          com.google.privacy.dlp.v2.RecordCondition.Condition.Builder builderForValue) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.add(builderForValue.build());
          onChanged();
        } else {
          conditionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public Builder addConditions(
          int index, com.google.privacy.dlp.v2.RecordCondition.Condition.Builder builderForValue) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.add(index, builderForValue.build());
          onChanged();
        } else {
          conditionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public Builder addAllConditions(
          java.lang.Iterable<? extends com.google.privacy.dlp.v2.RecordCondition.Condition>
              values) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
          onChanged();
        } else {
          conditionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public Builder clearConditions() {
        if (conditionsBuilder_ == null) {
          conditions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          conditionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public Builder removeConditions(int index) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.remove(index);
          onChanged();
        } else {
          conditionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public com.google.privacy.dlp.v2.RecordCondition.Condition.Builder getConditionsBuilder(
          int index) {
        return getConditionsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public com.google.privacy.dlp.v2.RecordCondition.ConditionOrBuilder getConditionsOrBuilder(
          int index) {
        if (conditionsBuilder_ == null) {
          return conditions_.get(index);
        } else {
          return conditionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public java.util.List<? extends com.google.privacy.dlp.v2.RecordCondition.ConditionOrBuilder>
          getConditionsOrBuilderList() {
        if (conditionsBuilder_ != null) {
          return conditionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(conditions_);
        }
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public com.google.privacy.dlp.v2.RecordCondition.Condition.Builder addConditionsBuilder() {
        return getConditionsFieldBuilder()
            .addBuilder(com.google.privacy.dlp.v2.RecordCondition.Condition.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public com.google.privacy.dlp.v2.RecordCondition.Condition.Builder addConditionsBuilder(
          int index) {
        return getConditionsFieldBuilder()
            .addBuilder(
                index, com.google.privacy.dlp.v2.RecordCondition.Condition.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A collection of conditions.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.RecordCondition.Condition conditions = 1;</code>
       */
      public java.util.List<com.google.privacy.dlp.v2.RecordCondition.Condition.Builder>
          getConditionsBuilderList() {
        return getConditionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.privacy.dlp.v2.RecordCondition.Condition,
              com.google.privacy.dlp.v2.RecordCondition.Condition.Builder,
              com.google.privacy.dlp.v2.RecordCondition.ConditionOrBuilder>
          getConditionsFieldBuilder() {
        if (conditionsBuilder_ == null) {
          conditionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.privacy.dlp.v2.RecordCondition.Condition,
                  com.google.privacy.dlp.v2.RecordCondition.Condition.Builder,
                  com.google.privacy.dlp.v2.RecordCondition.ConditionOrBuilder>(
                  conditions_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          conditions_ = null;
        }
        return conditionsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.RecordCondition.Conditions)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.RecordCondition.Conditions)
    private static final com.google.privacy.dlp.v2.RecordCondition.Conditions DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.RecordCondition.Conditions();
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Conditions getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Conditions> PARSER =
        new com.google.protobuf.AbstractParser<Conditions>() {
          @java.lang.Override
          public Conditions parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Conditions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Conditions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordCondition.Conditions getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ExpressionsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.RecordCondition.Expressions)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The operator to apply to the result of conditions. Default and currently
     * only supported value is `AND`.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator logical_operator = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for logicalOperator.
     */
    int getLogicalOperatorValue();
    /**
     *
     *
     * <pre>
     * The operator to apply to the result of conditions. Default and currently
     * only supported value is `AND`.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator logical_operator = 1;
     * </code>
     *
     * @return The logicalOperator.
     */
    com.google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator getLogicalOperator();

    /**
     *
     *
     * <pre>
     * Conditions to apply to the expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition.Conditions conditions = 3;</code>
     *
     * @return Whether the conditions field is set.
     */
    boolean hasConditions();
    /**
     *
     *
     * <pre>
     * Conditions to apply to the expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition.Conditions conditions = 3;</code>
     *
     * @return The conditions.
     */
    com.google.privacy.dlp.v2.RecordCondition.Conditions getConditions();
    /**
     *
     *
     * <pre>
     * Conditions to apply to the expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition.Conditions conditions = 3;</code>
     */
    com.google.privacy.dlp.v2.RecordCondition.ConditionsOrBuilder getConditionsOrBuilder();

    com.google.privacy.dlp.v2.RecordCondition.Expressions.TypeCase getTypeCase();
  }
  /**
   *
   *
   * <pre>
   * An expression, consisting of an operator and conditions.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.RecordCondition.Expressions}
   */
  public static final class Expressions extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.RecordCondition.Expressions)
      ExpressionsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Expressions.newBuilder() to construct.
    private Expressions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Expressions() {
      logicalOperator_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Expressions();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RecordCondition_Expressions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RecordCondition_Expressions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.RecordCondition.Expressions.class,
              com.google.privacy.dlp.v2.RecordCondition.Expressions.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Logical operators for conditional checks.
     * </pre>
     *
     * Protobuf enum {@code google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator}
     */
    public enum LogicalOperator implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unused
       * </pre>
       *
       * <code>LOGICAL_OPERATOR_UNSPECIFIED = 0;</code>
       */
      LOGICAL_OPERATOR_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Conditional AND
       * </pre>
       *
       * <code>AND = 1;</code>
       */
      AND(1),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unused
       * </pre>
       *
       * <code>LOGICAL_OPERATOR_UNSPECIFIED = 0;</code>
       */
      public static final int LOGICAL_OPERATOR_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Conditional AND
       * </pre>
       *
       * <code>AND = 1;</code>
       */
      public static final int AND_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static LogicalOperator valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static LogicalOperator forNumber(int value) {
        switch (value) {
          case 0:
            return LOGICAL_OPERATOR_UNSPECIFIED;
          case 1:
            return AND;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<LogicalOperator>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<LogicalOperator>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<LogicalOperator>() {
                public LogicalOperator findValueByNumber(int number) {
                  return LogicalOperator.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.privacy.dlp.v2.RecordCondition.Expressions.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final LogicalOperator[] VALUES = values();

      public static LogicalOperator valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private LogicalOperator(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator)
    }

    private int typeCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object type_;

    public enum TypeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      CONDITIONS(3),
      TYPE_NOT_SET(0);
      private final int value;

      private TypeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TypeCase valueOf(int value) {
        return forNumber(value);
      }

      public static TypeCase forNumber(int value) {
        switch (value) {
          case 3:
            return CONDITIONS;
          case 0:
            return TYPE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public TypeCase getTypeCase() {
      return TypeCase.forNumber(typeCase_);
    }

    public static final int LOGICAL_OPERATOR_FIELD_NUMBER = 1;
    private int logicalOperator_ = 0;
    /**
     *
     *
     * <pre>
     * The operator to apply to the result of conditions. Default and currently
     * only supported value is `AND`.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator logical_operator = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for logicalOperator.
     */
    @java.lang.Override
    public int getLogicalOperatorValue() {
      return logicalOperator_;
    }
    /**
     *
     *
     * <pre>
     * The operator to apply to the result of conditions. Default and currently
     * only supported value is `AND`.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator logical_operator = 1;
     * </code>
     *
     * @return The logicalOperator.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator
        getLogicalOperator() {
      com.google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator result =
          com.google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator.forNumber(
              logicalOperator_);
      return result == null
          ? com.google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator.UNRECOGNIZED
          : result;
    }

    public static final int CONDITIONS_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Conditions to apply to the expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition.Conditions conditions = 3;</code>
     *
     * @return Whether the conditions field is set.
     */
    @java.lang.Override
    public boolean hasConditions() {
      return typeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Conditions to apply to the expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition.Conditions conditions = 3;</code>
     *
     * @return The conditions.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordCondition.Conditions getConditions() {
      if (typeCase_ == 3) {
        return (com.google.privacy.dlp.v2.RecordCondition.Conditions) type_;
      }
      return com.google.privacy.dlp.v2.RecordCondition.Conditions.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Conditions to apply to the expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition.Conditions conditions = 3;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordCondition.ConditionsOrBuilder getConditionsOrBuilder() {
      if (typeCase_ == 3) {
        return (com.google.privacy.dlp.v2.RecordCondition.Conditions) type_;
      }
      return com.google.privacy.dlp.v2.RecordCondition.Conditions.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (logicalOperator_
          != com.google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator
              .LOGICAL_OPERATOR_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, logicalOperator_);
      }
      if (typeCase_ == 3) {
        output.writeMessage(3, (com.google.privacy.dlp.v2.RecordCondition.Conditions) type_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (logicalOperator_
          != com.google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator
              .LOGICAL_OPERATOR_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, logicalOperator_);
      }
      if (typeCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.privacy.dlp.v2.RecordCondition.Conditions) type_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.RecordCondition.Expressions)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.RecordCondition.Expressions other =
          (com.google.privacy.dlp.v2.RecordCondition.Expressions) obj;

      if (logicalOperator_ != other.logicalOperator_) return false;
      if (!getTypeCase().equals(other.getTypeCase())) return false;
      switch (typeCase_) {
        case 3:
          if (!getConditions().equals(other.getConditions())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOGICAL_OPERATOR_FIELD_NUMBER;
      hash = (53 * hash) + logicalOperator_;
      switch (typeCase_) {
        case 3:
          hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
          hash = (53 * hash) + getConditions().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Expressions parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Expressions parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Expressions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Expressions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Expressions parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Expressions parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Expressions parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Expressions parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Expressions parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Expressions parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Expressions parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Expressions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.RecordCondition.Expressions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An expression, consisting of an operator and conditions.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.RecordCondition.Expressions}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.RecordCondition.Expressions)
        com.google.privacy.dlp.v2.RecordCondition.ExpressionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_RecordCondition_Expressions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_RecordCondition_Expressions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.RecordCondition.Expressions.class,
                com.google.privacy.dlp.v2.RecordCondition.Expressions.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.RecordCondition.Expressions.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        logicalOperator_ = 0;
        if (conditionsBuilder_ != null) {
          conditionsBuilder_.clear();
        }
        typeCase_ = 0;
        type_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_RecordCondition_Expressions_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.RecordCondition.Expressions getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.RecordCondition.Expressions.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.RecordCondition.Expressions build() {
        com.google.privacy.dlp.v2.RecordCondition.Expressions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.RecordCondition.Expressions buildPartial() {
        com.google.privacy.dlp.v2.RecordCondition.Expressions result =
            new com.google.privacy.dlp.v2.RecordCondition.Expressions(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.privacy.dlp.v2.RecordCondition.Expressions result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.logicalOperator_ = logicalOperator_;
        }
      }

      private void buildPartialOneofs(
          com.google.privacy.dlp.v2.RecordCondition.Expressions result) {
        result.typeCase_ = typeCase_;
        result.type_ = this.type_;
        if (typeCase_ == 3 && conditionsBuilder_ != null) {
          result.type_ = conditionsBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.RecordCondition.Expressions) {
          return mergeFrom((com.google.privacy.dlp.v2.RecordCondition.Expressions) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.RecordCondition.Expressions other) {
        if (other == com.google.privacy.dlp.v2.RecordCondition.Expressions.getDefaultInstance())
          return this;
        if (other.logicalOperator_ != 0) {
          setLogicalOperatorValue(other.getLogicalOperatorValue());
        }
        switch (other.getTypeCase()) {
          case CONDITIONS:
            {
              mergeConditions(other.getConditions());
              break;
            }
          case TYPE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  logicalOperator_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 26:
                {
                  input.readMessage(getConditionsFieldBuilder().getBuilder(), extensionRegistry);
                  typeCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int typeCase_ = 0;
      private java.lang.Object type_;

      public TypeCase getTypeCase() {
        return TypeCase.forNumber(typeCase_);
      }

      public Builder clearType() {
        typeCase_ = 0;
        type_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private int logicalOperator_ = 0;
      /**
       *
       *
       * <pre>
       * The operator to apply to the result of conditions. Default and currently
       * only supported value is `AND`.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator logical_operator = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for logicalOperator.
       */
      @java.lang.Override
      public int getLogicalOperatorValue() {
        return logicalOperator_;
      }
      /**
       *
       *
       * <pre>
       * The operator to apply to the result of conditions. Default and currently
       * only supported value is `AND`.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator logical_operator = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for logicalOperator to set.
       * @return This builder for chaining.
       */
      public Builder setLogicalOperatorValue(int value) {
        logicalOperator_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The operator to apply to the result of conditions. Default and currently
       * only supported value is `AND`.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator logical_operator = 1;
       * </code>
       *
       * @return The logicalOperator.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator
          getLogicalOperator() {
        com.google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator result =
            com.google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator.forNumber(
                logicalOperator_);
        return result == null
            ? com.google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The operator to apply to the result of conditions. Default and currently
       * only supported value is `AND`.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator logical_operator = 1;
       * </code>
       *
       * @param value The logicalOperator to set.
       * @return This builder for chaining.
       */
      public Builder setLogicalOperator(
          com.google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        logicalOperator_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The operator to apply to the result of conditions. Default and currently
       * only supported value is `AND`.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator logical_operator = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLogicalOperator() {
        bitField0_ = (bitField0_ & ~0x00000001);
        logicalOperator_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.RecordCondition.Conditions,
              com.google.privacy.dlp.v2.RecordCondition.Conditions.Builder,
              com.google.privacy.dlp.v2.RecordCondition.ConditionsOrBuilder>
          conditionsBuilder_;
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.RecordCondition.Conditions conditions = 3;</code>
       *
       * @return Whether the conditions field is set.
       */
      @java.lang.Override
      public boolean hasConditions() {
        return typeCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.RecordCondition.Conditions conditions = 3;</code>
       *
       * @return The conditions.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.RecordCondition.Conditions getConditions() {
        if (conditionsBuilder_ == null) {
          if (typeCase_ == 3) {
            return (com.google.privacy.dlp.v2.RecordCondition.Conditions) type_;
          }
          return com.google.privacy.dlp.v2.RecordCondition.Conditions.getDefaultInstance();
        } else {
          if (typeCase_ == 3) {
            return conditionsBuilder_.getMessage();
          }
          return com.google.privacy.dlp.v2.RecordCondition.Conditions.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.RecordCondition.Conditions conditions = 3;</code>
       */
      public Builder setConditions(com.google.privacy.dlp.v2.RecordCondition.Conditions value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          type_ = value;
          onChanged();
        } else {
          conditionsBuilder_.setMessage(value);
        }
        typeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.RecordCondition.Conditions conditions = 3;</code>
       */
      public Builder setConditions(
          com.google.privacy.dlp.v2.RecordCondition.Conditions.Builder builderForValue) {
        if (conditionsBuilder_ == null) {
          type_ = builderForValue.build();
          onChanged();
        } else {
          conditionsBuilder_.setMessage(builderForValue.build());
        }
        typeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.RecordCondition.Conditions conditions = 3;</code>
       */
      public Builder mergeConditions(com.google.privacy.dlp.v2.RecordCondition.Conditions value) {
        if (conditionsBuilder_ == null) {
          if (typeCase_ == 3
              && type_
                  != com.google.privacy.dlp.v2.RecordCondition.Conditions.getDefaultInstance()) {
            type_ =
                com.google.privacy.dlp.v2.RecordCondition.Conditions.newBuilder(
                        (com.google.privacy.dlp.v2.RecordCondition.Conditions) type_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            type_ = value;
          }
          onChanged();
        } else {
          if (typeCase_ == 3) {
            conditionsBuilder_.mergeFrom(value);
          } else {
            conditionsBuilder_.setMessage(value);
          }
        }
        typeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.RecordCondition.Conditions conditions = 3;</code>
       */
      public Builder clearConditions() {
        if (conditionsBuilder_ == null) {
          if (typeCase_ == 3) {
            typeCase_ = 0;
            type_ = null;
            onChanged();
          }
        } else {
          if (typeCase_ == 3) {
            typeCase_ = 0;
            type_ = null;
          }
          conditionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.RecordCondition.Conditions conditions = 3;</code>
       */
      public com.google.privacy.dlp.v2.RecordCondition.Conditions.Builder getConditionsBuilder() {
        return getConditionsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.RecordCondition.Conditions conditions = 3;</code>
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.RecordCondition.ConditionsOrBuilder
          getConditionsOrBuilder() {
        if ((typeCase_ == 3) && (conditionsBuilder_ != null)) {
          return conditionsBuilder_.getMessageOrBuilder();
        } else {
          if (typeCase_ == 3) {
            return (com.google.privacy.dlp.v2.RecordCondition.Conditions) type_;
          }
          return com.google.privacy.dlp.v2.RecordCondition.Conditions.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.RecordCondition.Conditions conditions = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.RecordCondition.Conditions,
              com.google.privacy.dlp.v2.RecordCondition.Conditions.Builder,
              com.google.privacy.dlp.v2.RecordCondition.ConditionsOrBuilder>
          getConditionsFieldBuilder() {
        if (conditionsBuilder_ == null) {
          if (!(typeCase_ == 3)) {
            type_ = com.google.privacy.dlp.v2.RecordCondition.Conditions.getDefaultInstance();
          }
          conditionsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.RecordCondition.Conditions,
                  com.google.privacy.dlp.v2.RecordCondition.Conditions.Builder,
                  com.google.privacy.dlp.v2.RecordCondition.ConditionsOrBuilder>(
                  (com.google.privacy.dlp.v2.RecordCondition.Conditions) type_,
                  getParentForChildren(),
                  isClean());
          type_ = null;
        }
        typeCase_ = 3;
        onChanged();
        return conditionsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.RecordCondition.Expressions)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.RecordCondition.Expressions)
    private static final com.google.privacy.dlp.v2.RecordCondition.Expressions DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.RecordCondition.Expressions();
    }

    public static com.google.privacy.dlp.v2.RecordCondition.Expressions getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Expressions> PARSER =
        new com.google.protobuf.AbstractParser<Expressions>() {
          @java.lang.Override
          public Expressions parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Expressions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Expressions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordCondition.Expressions getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int EXPRESSIONS_FIELD_NUMBER = 3;
  private com.google.privacy.dlp.v2.RecordCondition.Expressions expressions_;
  /**
   *
   *
   * <pre>
   * An expression.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordCondition.Expressions expressions = 3;</code>
   *
   * @return Whether the expressions field is set.
   */
  @java.lang.Override
  public boolean hasExpressions() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * An expression.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordCondition.Expressions expressions = 3;</code>
   *
   * @return The expressions.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RecordCondition.Expressions getExpressions() {
    return expressions_ == null
        ? com.google.privacy.dlp.v2.RecordCondition.Expressions.getDefaultInstance()
        : expressions_;
  }
  /**
   *
   *
   * <pre>
   * An expression.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordCondition.Expressions expressions = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RecordCondition.ExpressionsOrBuilder getExpressionsOrBuilder() {
    return expressions_ == null
        ? com.google.privacy.dlp.v2.RecordCondition.Expressions.getDefaultInstance()
        : expressions_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getExpressions());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getExpressions());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.RecordCondition)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.RecordCondition other =
        (com.google.privacy.dlp.v2.RecordCondition) obj;

    if (hasExpressions() != other.hasExpressions()) return false;
    if (hasExpressions()) {
      if (!getExpressions().equals(other.getExpressions())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasExpressions()) {
      hash = (37 * hash) + EXPRESSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExpressions().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.RecordCondition parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.RecordCondition parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.RecordCondition parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.RecordCondition parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.RecordCondition parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.RecordCondition parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.RecordCondition parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.RecordCondition parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.RecordCondition parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.RecordCondition parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.RecordCondition parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.RecordCondition parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.RecordCondition prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A condition for determining whether a transformation should be applied to
   * a field.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.RecordCondition}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.RecordCondition)
      com.google.privacy.dlp.v2.RecordConditionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RecordCondition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RecordCondition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.RecordCondition.class,
              com.google.privacy.dlp.v2.RecordCondition.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.RecordCondition.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getExpressionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      expressions_ = null;
      if (expressionsBuilder_ != null) {
        expressionsBuilder_.dispose();
        expressionsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RecordCondition_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordCondition getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.RecordCondition.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordCondition build() {
      com.google.privacy.dlp.v2.RecordCondition result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordCondition buildPartial() {
      com.google.privacy.dlp.v2.RecordCondition result =
          new com.google.privacy.dlp.v2.RecordCondition(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.RecordCondition result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.expressions_ =
            expressionsBuilder_ == null ? expressions_ : expressionsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.RecordCondition) {
        return mergeFrom((com.google.privacy.dlp.v2.RecordCondition) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.RecordCondition other) {
      if (other == com.google.privacy.dlp.v2.RecordCondition.getDefaultInstance()) return this;
      if (other.hasExpressions()) {
        mergeExpressions(other.getExpressions());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26:
              {
                input.readMessage(getExpressionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.RecordCondition.Expressions expressions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.RecordCondition.Expressions,
            com.google.privacy.dlp.v2.RecordCondition.Expressions.Builder,
            com.google.privacy.dlp.v2.RecordCondition.ExpressionsOrBuilder>
        expressionsBuilder_;
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition.Expressions expressions = 3;</code>
     *
     * @return Whether the expressions field is set.
     */
    public boolean hasExpressions() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition.Expressions expressions = 3;</code>
     *
     * @return The expressions.
     */
    public com.google.privacy.dlp.v2.RecordCondition.Expressions getExpressions() {
      if (expressionsBuilder_ == null) {
        return expressions_ == null
            ? com.google.privacy.dlp.v2.RecordCondition.Expressions.getDefaultInstance()
            : expressions_;
      } else {
        return expressionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition.Expressions expressions = 3;</code>
     */
    public Builder setExpressions(com.google.privacy.dlp.v2.RecordCondition.Expressions value) {
      if (expressionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expressions_ = value;
      } else {
        expressionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition.Expressions expressions = 3;</code>
     */
    public Builder setExpressions(
        com.google.privacy.dlp.v2.RecordCondition.Expressions.Builder builderForValue) {
      if (expressionsBuilder_ == null) {
        expressions_ = builderForValue.build();
      } else {
        expressionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition.Expressions expressions = 3;</code>
     */
    public Builder mergeExpressions(com.google.privacy.dlp.v2.RecordCondition.Expressions value) {
      if (expressionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && expressions_ != null
            && expressions_
                != com.google.privacy.dlp.v2.RecordCondition.Expressions.getDefaultInstance()) {
          getExpressionsBuilder().mergeFrom(value);
        } else {
          expressions_ = value;
        }
      } else {
        expressionsBuilder_.mergeFrom(value);
      }
      if (expressions_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition.Expressions expressions = 3;</code>
     */
    public Builder clearExpressions() {
      bitField0_ = (bitField0_ & ~0x00000001);
      expressions_ = null;
      if (expressionsBuilder_ != null) {
        expressionsBuilder_.dispose();
        expressionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition.Expressions expressions = 3;</code>
     */
    public com.google.privacy.dlp.v2.RecordCondition.Expressions.Builder getExpressionsBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getExpressionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition.Expressions expressions = 3;</code>
     */
    public com.google.privacy.dlp.v2.RecordCondition.ExpressionsOrBuilder
        getExpressionsOrBuilder() {
      if (expressionsBuilder_ != null) {
        return expressionsBuilder_.getMessageOrBuilder();
      } else {
        return expressions_ == null
            ? com.google.privacy.dlp.v2.RecordCondition.Expressions.getDefaultInstance()
            : expressions_;
      }
    }
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordCondition.Expressions expressions = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.RecordCondition.Expressions,
            com.google.privacy.dlp.v2.RecordCondition.Expressions.Builder,
            com.google.privacy.dlp.v2.RecordCondition.ExpressionsOrBuilder>
        getExpressionsFieldBuilder() {
      if (expressionsBuilder_ == null) {
        expressionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.RecordCondition.Expressions,
                com.google.privacy.dlp.v2.RecordCondition.Expressions.Builder,
                com.google.privacy.dlp.v2.RecordCondition.ExpressionsOrBuilder>(
                getExpressions(), getParentForChildren(), isClean());
        expressions_ = null;
      }
      return expressionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.RecordCondition)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.RecordCondition)
  private static final com.google.privacy.dlp.v2.RecordCondition DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.RecordCondition();
  }

  public static com.google.privacy.dlp.v2.RecordCondition getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RecordCondition> PARSER =
      new com.google.protobuf.AbstractParser<RecordCondition>() {
        @java.lang.Override
        public RecordCondition parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RecordCondition> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RecordCondition> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.RecordCondition getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
