/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * An auxiliary table containing statistical information on the relative
 * frequency of different quasi-identifiers values. It has one or several
 * quasi-identifiers columns, and one column that indicates the relative
 * frequency of each quasi-identifier tuple.
 * If a tuple is present in the data but not in the auxiliary table, the
 * corresponding relative frequency is assumed to be zero (and thus, the
 * tuple is highly reidentifiable).
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.StatisticalTable}
 */
public final class StatisticalTable extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.StatisticalTable)
    StatisticalTableOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StatisticalTable.newBuilder() to construct.
  private StatisticalTable(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StatisticalTable() {
    quasiIds_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StatisticalTable();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_StatisticalTable_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_StatisticalTable_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.StatisticalTable.class,
            com.google.privacy.dlp.v2.StatisticalTable.Builder.class);
  }

  public interface QuasiIdentifierFieldOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Identifies the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1;</code>
     *
     * @return Whether the field field is set.
     */
    boolean hasField();
    /**
     *
     *
     * <pre>
     * Identifies the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1;</code>
     *
     * @return The field.
     */
    com.google.privacy.dlp.v2.FieldId getField();
    /**
     *
     *
     * <pre>
     * Identifies the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1;</code>
     */
    com.google.privacy.dlp.v2.FieldIdOrBuilder getFieldOrBuilder();

    /**
     *
     *
     * <pre>
     * A column can be tagged with a custom tag. In this case, the user must
     * indicate an auxiliary table that contains statistical information on
     * the possible values of this column (below).
     * </pre>
     *
     * <code>string custom_tag = 2;</code>
     *
     * @return The customTag.
     */
    java.lang.String getCustomTag();
    /**
     *
     *
     * <pre>
     * A column can be tagged with a custom tag. In this case, the user must
     * indicate an auxiliary table that contains statistical information on
     * the possible values of this column (below).
     * </pre>
     *
     * <code>string custom_tag = 2;</code>
     *
     * @return The bytes for customTag.
     */
    com.google.protobuf.ByteString getCustomTagBytes();
  }
  /**
   *
   *
   * <pre>
   * A quasi-identifier column has a custom_tag, used to know which column
   * in the data corresponds to which column in the statistical model.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField}
   */
  public static final class QuasiIdentifierField extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField)
      QuasiIdentifierFieldOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QuasiIdentifierField.newBuilder() to construct.
    private QuasiIdentifierField(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QuasiIdentifierField() {
      customTag_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QuasiIdentifierField();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_StatisticalTable_QuasiIdentifierField_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_StatisticalTable_QuasiIdentifierField_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.class,
              com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.Builder.class);
    }

    private int bitField0_;
    public static final int FIELD_FIELD_NUMBER = 1;
    private com.google.privacy.dlp.v2.FieldId field_;
    /**
     *
     *
     * <pre>
     * Identifies the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1;</code>
     *
     * @return Whether the field field is set.
     */
    @java.lang.Override
    public boolean hasField() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Identifies the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1;</code>
     *
     * @return The field.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.FieldId getField() {
      return field_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : field_;
    }
    /**
     *
     *
     * <pre>
     * Identifies the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.FieldIdOrBuilder getFieldOrBuilder() {
      return field_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : field_;
    }

    public static final int CUSTOM_TAG_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object customTag_ = "";
    /**
     *
     *
     * <pre>
     * A column can be tagged with a custom tag. In this case, the user must
     * indicate an auxiliary table that contains statistical information on
     * the possible values of this column (below).
     * </pre>
     *
     * <code>string custom_tag = 2;</code>
     *
     * @return The customTag.
     */
    @java.lang.Override
    public java.lang.String getCustomTag() {
      java.lang.Object ref = customTag_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customTag_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A column can be tagged with a custom tag. In this case, the user must
     * indicate an auxiliary table that contains statistical information on
     * the possible values of this column (below).
     * </pre>
     *
     * <code>string custom_tag = 2;</code>
     *
     * @return The bytes for customTag.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCustomTagBytes() {
      java.lang.Object ref = customTag_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        customTag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getField());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customTag_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, customTag_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getField());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customTag_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, customTag_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField other =
          (com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField) obj;

      if (hasField() != other.hasField()) return false;
      if (hasField()) {
        if (!getField().equals(other.getField())) return false;
      }
      if (!getCustomTag().equals(other.getCustomTag())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasField()) {
        hash = (37 * hash) + FIELD_FIELD_NUMBER;
        hash = (53 * hash) + getField().hashCode();
      }
      hash = (37 * hash) + CUSTOM_TAG_FIELD_NUMBER;
      hash = (53 * hash) + getCustomTag().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A quasi-identifier column has a custom_tag, used to know which column
     * in the data corresponds to which column in the statistical model.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField)
        com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierFieldOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_StatisticalTable_QuasiIdentifierField_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_StatisticalTable_QuasiIdentifierField_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.class,
                com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.Builder.class);
      }

      // Construct using
      // com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getFieldFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        field_ = null;
        if (fieldBuilder_ != null) {
          fieldBuilder_.dispose();
          fieldBuilder_ = null;
        }
        customTag_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_StatisticalTable_QuasiIdentifierField_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField
          getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField build() {
        com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField buildPartial() {
        com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField result =
            new com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.field_ = fieldBuilder_ == null ? field_ : fieldBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.customTag_ = customTag_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField) {
          return mergeFrom((com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField other) {
        if (other
            == com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.getDefaultInstance())
          return this;
        if (other.hasField()) {
          mergeField(other.getField());
        }
        if (!other.getCustomTag().isEmpty()) {
          customTag_ = other.customTag_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getFieldFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  customTag_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.privacy.dlp.v2.FieldId field_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.FieldId,
              com.google.privacy.dlp.v2.FieldId.Builder,
              com.google.privacy.dlp.v2.FieldIdOrBuilder>
          fieldBuilder_;
      /**
       *
       *
       * <pre>
       * Identifies the column.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1;</code>
       *
       * @return Whether the field field is set.
       */
      public boolean hasField() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Identifies the column.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1;</code>
       *
       * @return The field.
       */
      public com.google.privacy.dlp.v2.FieldId getField() {
        if (fieldBuilder_ == null) {
          return field_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : field_;
        } else {
          return fieldBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Identifies the column.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1;</code>
       */
      public Builder setField(com.google.privacy.dlp.v2.FieldId value) {
        if (fieldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          field_ = value;
        } else {
          fieldBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Identifies the column.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1;</code>
       */
      public Builder setField(com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
        if (fieldBuilder_ == null) {
          field_ = builderForValue.build();
        } else {
          fieldBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Identifies the column.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1;</code>
       */
      public Builder mergeField(com.google.privacy.dlp.v2.FieldId value) {
        if (fieldBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && field_ != null
              && field_ != com.google.privacy.dlp.v2.FieldId.getDefaultInstance()) {
            getFieldBuilder().mergeFrom(value);
          } else {
            field_ = value;
          }
        } else {
          fieldBuilder_.mergeFrom(value);
        }
        if (field_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Identifies the column.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1;</code>
       */
      public Builder clearField() {
        bitField0_ = (bitField0_ & ~0x00000001);
        field_ = null;
        if (fieldBuilder_ != null) {
          fieldBuilder_.dispose();
          fieldBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Identifies the column.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1;</code>
       */
      public com.google.privacy.dlp.v2.FieldId.Builder getFieldBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getFieldFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Identifies the column.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1;</code>
       */
      public com.google.privacy.dlp.v2.FieldIdOrBuilder getFieldOrBuilder() {
        if (fieldBuilder_ != null) {
          return fieldBuilder_.getMessageOrBuilder();
        } else {
          return field_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : field_;
        }
      }
      /**
       *
       *
       * <pre>
       * Identifies the column.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId field = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.FieldId,
              com.google.privacy.dlp.v2.FieldId.Builder,
              com.google.privacy.dlp.v2.FieldIdOrBuilder>
          getFieldFieldBuilder() {
        if (fieldBuilder_ == null) {
          fieldBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.FieldId,
                  com.google.privacy.dlp.v2.FieldId.Builder,
                  com.google.privacy.dlp.v2.FieldIdOrBuilder>(
                  getField(), getParentForChildren(), isClean());
          field_ = null;
        }
        return fieldBuilder_;
      }

      private java.lang.Object customTag_ = "";
      /**
       *
       *
       * <pre>
       * A column can be tagged with a custom tag. In this case, the user must
       * indicate an auxiliary table that contains statistical information on
       * the possible values of this column (below).
       * </pre>
       *
       * <code>string custom_tag = 2;</code>
       *
       * @return The customTag.
       */
      public java.lang.String getCustomTag() {
        java.lang.Object ref = customTag_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          customTag_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A column can be tagged with a custom tag. In this case, the user must
       * indicate an auxiliary table that contains statistical information on
       * the possible values of this column (below).
       * </pre>
       *
       * <code>string custom_tag = 2;</code>
       *
       * @return The bytes for customTag.
       */
      public com.google.protobuf.ByteString getCustomTagBytes() {
        java.lang.Object ref = customTag_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          customTag_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A column can be tagged with a custom tag. In this case, the user must
       * indicate an auxiliary table that contains statistical information on
       * the possible values of this column (below).
       * </pre>
       *
       * <code>string custom_tag = 2;</code>
       *
       * @param value The customTag to set.
       * @return This builder for chaining.
       */
      public Builder setCustomTag(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        customTag_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A column can be tagged with a custom tag. In this case, the user must
       * indicate an auxiliary table that contains statistical information on
       * the possible values of this column (below).
       * </pre>
       *
       * <code>string custom_tag = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCustomTag() {
        customTag_ = getDefaultInstance().getCustomTag();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A column can be tagged with a custom tag. In this case, the user must
       * indicate an auxiliary table that contains statistical information on
       * the possible values of this column (below).
       * </pre>
       *
       * <code>string custom_tag = 2;</code>
       *
       * @param value The bytes for customTag to set.
       * @return This builder for chaining.
       */
      public Builder setCustomTagBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        customTag_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField)
    private static final com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField();
    }

    public static com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QuasiIdentifierField> PARSER =
        new com.google.protobuf.AbstractParser<QuasiIdentifierField>() {
          @java.lang.Override
          public QuasiIdentifierField parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QuasiIdentifierField> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QuasiIdentifierField> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int TABLE_FIELD_NUMBER = 3;
  private com.google.privacy.dlp.v2.BigQueryTable table_;
  /**
   *
   *
   * <pre>
   * Required. Auxiliary table location.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTable table = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the table field is set.
   */
  @java.lang.Override
  public boolean hasTable() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Auxiliary table location.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTable table = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The table.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryTable getTable() {
    return table_ == null ? com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance() : table_;
  }
  /**
   *
   *
   * <pre>
   * Required. Auxiliary table location.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTable table = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryTableOrBuilder getTableOrBuilder() {
    return table_ == null ? com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance() : table_;
  }

  public static final int QUASI_IDS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField> quasiIds_;
  /**
   *
   *
   * <pre>
   * Required. Quasi-identifier columns.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField>
      getQuasiIdsList() {
    return quasiIds_;
  }
  /**
   *
   *
   * <pre>
   * Required. Quasi-identifier columns.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierFieldOrBuilder>
      getQuasiIdsOrBuilderList() {
    return quasiIds_;
  }
  /**
   *
   *
   * <pre>
   * Required. Quasi-identifier columns.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getQuasiIdsCount() {
    return quasiIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Quasi-identifier columns.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField getQuasiIds(int index) {
    return quasiIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Quasi-identifier columns.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierFieldOrBuilder
      getQuasiIdsOrBuilder(int index) {
    return quasiIds_.get(index);
  }

  public static final int RELATIVE_FREQUENCY_FIELD_NUMBER = 2;
  private com.google.privacy.dlp.v2.FieldId relativeFrequency_;
  /**
   *
   *
   * <pre>
   * Required. The relative frequency column must contain a floating-point
   * number between 0 and 1 (inclusive). Null values are assumed to be zero.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.FieldId relative_frequency = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the relativeFrequency field is set.
   */
  @java.lang.Override
  public boolean hasRelativeFrequency() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The relative frequency column must contain a floating-point
   * number between 0 and 1 (inclusive). Null values are assumed to be zero.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.FieldId relative_frequency = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The relativeFrequency.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldId getRelativeFrequency() {
    return relativeFrequency_ == null
        ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance()
        : relativeFrequency_;
  }
  /**
   *
   *
   * <pre>
   * Required. The relative frequency column must contain a floating-point
   * number between 0 and 1 (inclusive). Null values are assumed to be zero.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.FieldId relative_frequency = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldIdOrBuilder getRelativeFrequencyOrBuilder() {
    return relativeFrequency_ == null
        ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance()
        : relativeFrequency_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < quasiIds_.size(); i++) {
      output.writeMessage(1, quasiIds_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getRelativeFrequency());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getTable());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < quasiIds_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, quasiIds_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRelativeFrequency());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTable());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.StatisticalTable)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.StatisticalTable other =
        (com.google.privacy.dlp.v2.StatisticalTable) obj;

    if (hasTable() != other.hasTable()) return false;
    if (hasTable()) {
      if (!getTable().equals(other.getTable())) return false;
    }
    if (!getQuasiIdsList().equals(other.getQuasiIdsList())) return false;
    if (hasRelativeFrequency() != other.hasRelativeFrequency()) return false;
    if (hasRelativeFrequency()) {
      if (!getRelativeFrequency().equals(other.getRelativeFrequency())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTable()) {
      hash = (37 * hash) + TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getTable().hashCode();
    }
    if (getQuasiIdsCount() > 0) {
      hash = (37 * hash) + QUASI_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getQuasiIdsList().hashCode();
    }
    if (hasRelativeFrequency()) {
      hash = (37 * hash) + RELATIVE_FREQUENCY_FIELD_NUMBER;
      hash = (53 * hash) + getRelativeFrequency().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.StatisticalTable parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.StatisticalTable parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StatisticalTable parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.StatisticalTable parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StatisticalTable parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.StatisticalTable parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StatisticalTable parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.StatisticalTable parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StatisticalTable parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.StatisticalTable parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StatisticalTable parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.StatisticalTable parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.StatisticalTable prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An auxiliary table containing statistical information on the relative
   * frequency of different quasi-identifiers values. It has one or several
   * quasi-identifiers columns, and one column that indicates the relative
   * frequency of each quasi-identifier tuple.
   * If a tuple is present in the data but not in the auxiliary table, the
   * corresponding relative frequency is assumed to be zero (and thus, the
   * tuple is highly reidentifiable).
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.StatisticalTable}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.StatisticalTable)
      com.google.privacy.dlp.v2.StatisticalTableOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_StatisticalTable_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_StatisticalTable_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.StatisticalTable.class,
              com.google.privacy.dlp.v2.StatisticalTable.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.StatisticalTable.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTableFieldBuilder();
        getQuasiIdsFieldBuilder();
        getRelativeFrequencyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      table_ = null;
      if (tableBuilder_ != null) {
        tableBuilder_.dispose();
        tableBuilder_ = null;
      }
      if (quasiIdsBuilder_ == null) {
        quasiIds_ = java.util.Collections.emptyList();
      } else {
        quasiIds_ = null;
        quasiIdsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      relativeFrequency_ = null;
      if (relativeFrequencyBuilder_ != null) {
        relativeFrequencyBuilder_.dispose();
        relativeFrequencyBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_StatisticalTable_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StatisticalTable getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.StatisticalTable.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StatisticalTable build() {
      com.google.privacy.dlp.v2.StatisticalTable result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StatisticalTable buildPartial() {
      com.google.privacy.dlp.v2.StatisticalTable result =
          new com.google.privacy.dlp.v2.StatisticalTable(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.privacy.dlp.v2.StatisticalTable result) {
      if (quasiIdsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          quasiIds_ = java.util.Collections.unmodifiableList(quasiIds_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.quasiIds_ = quasiIds_;
      } else {
        result.quasiIds_ = quasiIdsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.privacy.dlp.v2.StatisticalTable result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.table_ = tableBuilder_ == null ? table_ : tableBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.relativeFrequency_ =
            relativeFrequencyBuilder_ == null
                ? relativeFrequency_
                : relativeFrequencyBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.StatisticalTable) {
        return mergeFrom((com.google.privacy.dlp.v2.StatisticalTable) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.StatisticalTable other) {
      if (other == com.google.privacy.dlp.v2.StatisticalTable.getDefaultInstance()) return this;
      if (other.hasTable()) {
        mergeTable(other.getTable());
      }
      if (quasiIdsBuilder_ == null) {
        if (!other.quasiIds_.isEmpty()) {
          if (quasiIds_.isEmpty()) {
            quasiIds_ = other.quasiIds_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureQuasiIdsIsMutable();
            quasiIds_.addAll(other.quasiIds_);
          }
          onChanged();
        }
      } else {
        if (!other.quasiIds_.isEmpty()) {
          if (quasiIdsBuilder_.isEmpty()) {
            quasiIdsBuilder_.dispose();
            quasiIdsBuilder_ = null;
            quasiIds_ = other.quasiIds_;
            bitField0_ = (bitField0_ & ~0x00000002);
            quasiIdsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getQuasiIdsFieldBuilder()
                    : null;
          } else {
            quasiIdsBuilder_.addAllMessages(other.quasiIds_);
          }
        }
      }
      if (other.hasRelativeFrequency()) {
        mergeRelativeFrequency(other.getRelativeFrequency());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.parser(),
                        extensionRegistry);
                if (quasiIdsBuilder_ == null) {
                  ensureQuasiIdsIsMutable();
                  quasiIds_.add(m);
                } else {
                  quasiIdsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getRelativeFrequencyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getTableFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.BigQueryTable table_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BigQueryTable,
            com.google.privacy.dlp.v2.BigQueryTable.Builder,
            com.google.privacy.dlp.v2.BigQueryTableOrBuilder>
        tableBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Auxiliary table location.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.BigQueryTable table = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the table field is set.
     */
    public boolean hasTable() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Auxiliary table location.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.BigQueryTable table = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The table.
     */
    public com.google.privacy.dlp.v2.BigQueryTable getTable() {
      if (tableBuilder_ == null) {
        return table_ == null
            ? com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance()
            : table_;
      } else {
        return tableBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Auxiliary table location.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.BigQueryTable table = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTable(com.google.privacy.dlp.v2.BigQueryTable value) {
      if (tableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        table_ = value;
      } else {
        tableBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Auxiliary table location.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.BigQueryTable table = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTable(com.google.privacy.dlp.v2.BigQueryTable.Builder builderForValue) {
      if (tableBuilder_ == null) {
        table_ = builderForValue.build();
      } else {
        tableBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Auxiliary table location.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.BigQueryTable table = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeTable(com.google.privacy.dlp.v2.BigQueryTable value) {
      if (tableBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && table_ != null
            && table_ != com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance()) {
          getTableBuilder().mergeFrom(value);
        } else {
          table_ = value;
        }
      } else {
        tableBuilder_.mergeFrom(value);
      }
      if (table_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Auxiliary table location.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.BigQueryTable table = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearTable() {
      bitField0_ = (bitField0_ & ~0x00000001);
      table_ = null;
      if (tableBuilder_ != null) {
        tableBuilder_.dispose();
        tableBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Auxiliary table location.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.BigQueryTable table = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.BigQueryTable.Builder getTableBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getTableFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Auxiliary table location.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.BigQueryTable table = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.BigQueryTableOrBuilder getTableOrBuilder() {
      if (tableBuilder_ != null) {
        return tableBuilder_.getMessageOrBuilder();
      } else {
        return table_ == null
            ? com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance()
            : table_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Auxiliary table location.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.BigQueryTable table = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BigQueryTable,
            com.google.privacy.dlp.v2.BigQueryTable.Builder,
            com.google.privacy.dlp.v2.BigQueryTableOrBuilder>
        getTableFieldBuilder() {
      if (tableBuilder_ == null) {
        tableBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.BigQueryTable,
                com.google.privacy.dlp.v2.BigQueryTable.Builder,
                com.google.privacy.dlp.v2.BigQueryTableOrBuilder>(
                getTable(), getParentForChildren(), isClean());
        table_ = null;
      }
      return tableBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField>
        quasiIds_ = java.util.Collections.emptyList();

    private void ensureQuasiIdsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        quasiIds_ =
            new java.util.ArrayList<
                com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField>(quasiIds_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField,
            com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.Builder,
            com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierFieldOrBuilder>
        quasiIdsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField>
        getQuasiIdsList() {
      if (quasiIdsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(quasiIds_);
      } else {
        return quasiIdsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getQuasiIdsCount() {
      if (quasiIdsBuilder_ == null) {
        return quasiIds_.size();
      } else {
        return quasiIdsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField getQuasiIds(int index) {
      if (quasiIdsBuilder_ == null) {
        return quasiIds_.get(index);
      } else {
        return quasiIdsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQuasiIds(
        int index, com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField value) {
      if (quasiIdsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuasiIdsIsMutable();
        quasiIds_.set(index, value);
        onChanged();
      } else {
        quasiIdsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQuasiIds(
        int index,
        com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.Builder builderForValue) {
      if (quasiIdsBuilder_ == null) {
        ensureQuasiIdsIsMutable();
        quasiIds_.set(index, builderForValue.build());
        onChanged();
      } else {
        quasiIdsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addQuasiIds(
        com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField value) {
      if (quasiIdsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuasiIdsIsMutable();
        quasiIds_.add(value);
        onChanged();
      } else {
        quasiIdsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addQuasiIds(
        int index, com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField value) {
      if (quasiIdsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuasiIdsIsMutable();
        quasiIds_.add(index, value);
        onChanged();
      } else {
        quasiIdsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addQuasiIds(
        com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.Builder builderForValue) {
      if (quasiIdsBuilder_ == null) {
        ensureQuasiIdsIsMutable();
        quasiIds_.add(builderForValue.build());
        onChanged();
      } else {
        quasiIdsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addQuasiIds(
        int index,
        com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.Builder builderForValue) {
      if (quasiIdsBuilder_ == null) {
        ensureQuasiIdsIsMutable();
        quasiIds_.add(index, builderForValue.build());
        onChanged();
      } else {
        quasiIdsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllQuasiIds(
        java.lang.Iterable<
                ? extends com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField>
            values) {
      if (quasiIdsBuilder_ == null) {
        ensureQuasiIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, quasiIds_);
        onChanged();
      } else {
        quasiIdsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearQuasiIds() {
      if (quasiIdsBuilder_ == null) {
        quasiIds_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        quasiIdsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeQuasiIds(int index) {
      if (quasiIdsBuilder_ == null) {
        ensureQuasiIdsIsMutable();
        quasiIds_.remove(index);
        onChanged();
      } else {
        quasiIdsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.Builder
        getQuasiIdsBuilder(int index) {
      return getQuasiIdsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierFieldOrBuilder
        getQuasiIdsOrBuilder(int index) {
      if (quasiIdsBuilder_ == null) {
        return quasiIds_.get(index);
      } else {
        return quasiIdsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierFieldOrBuilder>
        getQuasiIdsOrBuilderList() {
      if (quasiIdsBuilder_ != null) {
        return quasiIdsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(quasiIds_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.Builder
        addQuasiIdsBuilder() {
      return getQuasiIdsFieldBuilder()
          .addBuilder(
              com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.Builder
        addQuasiIdsBuilder(int index) {
      return getQuasiIdsFieldBuilder()
          .addBuilder(
              index,
              com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Quasi-identifier columns.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField quasi_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.Builder>
        getQuasiIdsBuilderList() {
      return getQuasiIdsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField,
            com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.Builder,
            com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierFieldOrBuilder>
        getQuasiIdsFieldBuilder() {
      if (quasiIdsBuilder_ == null) {
        quasiIdsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField,
                com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.Builder,
                com.google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierFieldOrBuilder>(
                quasiIds_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        quasiIds_ = null;
      }
      return quasiIdsBuilder_;
    }

    private com.google.privacy.dlp.v2.FieldId relativeFrequency_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        relativeFrequencyBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The relative frequency column must contain a floating-point
     * number between 0 and 1 (inclusive). Null values are assumed to be zero.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.FieldId relative_frequency = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the relativeFrequency field is set.
     */
    public boolean hasRelativeFrequency() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The relative frequency column must contain a floating-point
     * number between 0 and 1 (inclusive). Null values are assumed to be zero.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.FieldId relative_frequency = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The relativeFrequency.
     */
    public com.google.privacy.dlp.v2.FieldId getRelativeFrequency() {
      if (relativeFrequencyBuilder_ == null) {
        return relativeFrequency_ == null
            ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance()
            : relativeFrequency_;
      } else {
        return relativeFrequencyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The relative frequency column must contain a floating-point
     * number between 0 and 1 (inclusive). Null values are assumed to be zero.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.FieldId relative_frequency = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRelativeFrequency(com.google.privacy.dlp.v2.FieldId value) {
      if (relativeFrequencyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        relativeFrequency_ = value;
      } else {
        relativeFrequencyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The relative frequency column must contain a floating-point
     * number between 0 and 1 (inclusive). Null values are assumed to be zero.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.FieldId relative_frequency = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRelativeFrequency(com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (relativeFrequencyBuilder_ == null) {
        relativeFrequency_ = builderForValue.build();
      } else {
        relativeFrequencyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The relative frequency column must contain a floating-point
     * number between 0 and 1 (inclusive). Null values are assumed to be zero.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.FieldId relative_frequency = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeRelativeFrequency(com.google.privacy.dlp.v2.FieldId value) {
      if (relativeFrequencyBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && relativeFrequency_ != null
            && relativeFrequency_ != com.google.privacy.dlp.v2.FieldId.getDefaultInstance()) {
          getRelativeFrequencyBuilder().mergeFrom(value);
        } else {
          relativeFrequency_ = value;
        }
      } else {
        relativeFrequencyBuilder_.mergeFrom(value);
      }
      if (relativeFrequency_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The relative frequency column must contain a floating-point
     * number between 0 and 1 (inclusive). Null values are assumed to be zero.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.FieldId relative_frequency = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearRelativeFrequency() {
      bitField0_ = (bitField0_ & ~0x00000004);
      relativeFrequency_ = null;
      if (relativeFrequencyBuilder_ != null) {
        relativeFrequencyBuilder_.dispose();
        relativeFrequencyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The relative frequency column must contain a floating-point
     * number between 0 and 1 (inclusive). Null values are assumed to be zero.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.FieldId relative_frequency = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder getRelativeFrequencyBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRelativeFrequencyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The relative frequency column must contain a floating-point
     * number between 0 and 1 (inclusive). Null values are assumed to be zero.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.FieldId relative_frequency = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.FieldIdOrBuilder getRelativeFrequencyOrBuilder() {
      if (relativeFrequencyBuilder_ != null) {
        return relativeFrequencyBuilder_.getMessageOrBuilder();
      } else {
        return relativeFrequency_ == null
            ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance()
            : relativeFrequency_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The relative frequency column must contain a floating-point
     * number between 0 and 1 (inclusive). Null values are assumed to be zero.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.FieldId relative_frequency = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        getRelativeFrequencyFieldBuilder() {
      if (relativeFrequencyBuilder_ == null) {
        relativeFrequencyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.FieldId,
                com.google.privacy.dlp.v2.FieldId.Builder,
                com.google.privacy.dlp.v2.FieldIdOrBuilder>(
                getRelativeFrequency(), getParentForChildren(), isClean());
        relativeFrequency_ = null;
      }
      return relativeFrequencyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.StatisticalTable)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.StatisticalTable)
  private static final com.google.privacy.dlp.v2.StatisticalTable DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.StatisticalTable();
  }

  public static com.google.privacy.dlp.v2.StatisticalTable getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StatisticalTable> PARSER =
      new com.google.protobuf.AbstractParser<StatisticalTable>() {
        @java.lang.Override
        public StatisticalTable parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StatisticalTable> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StatisticalTable> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.StatisticalTable getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
