/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * StoredInfoType resource message that contains information about the current
 * version and any pending updates.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.StoredInfoType}
 */
public final class StoredInfoType extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.StoredInfoType)
    StoredInfoTypeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StoredInfoType.newBuilder() to construct.
  private StoredInfoType(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StoredInfoType() {
    name_ = "";
    pendingVersions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StoredInfoType();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_StoredInfoType_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_StoredInfoType_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.StoredInfoType.class,
            com.google.privacy.dlp.v2.StoredInfoType.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Resource name.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource name.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CURRENT_VERSION_FIELD_NUMBER = 2;
  private com.google.privacy.dlp.v2.StoredInfoTypeVersion currentVersion_;
  /**
   *
   *
   * <pre>
   * Current version of the stored info type.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredInfoTypeVersion current_version = 2;</code>
   *
   * @return Whether the currentVersion field is set.
   */
  @java.lang.Override
  public boolean hasCurrentVersion() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Current version of the stored info type.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredInfoTypeVersion current_version = 2;</code>
   *
   * @return The currentVersion.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StoredInfoTypeVersion getCurrentVersion() {
    return currentVersion_ == null
        ? com.google.privacy.dlp.v2.StoredInfoTypeVersion.getDefaultInstance()
        : currentVersion_;
  }
  /**
   *
   *
   * <pre>
   * Current version of the stored info type.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredInfoTypeVersion current_version = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StoredInfoTypeVersionOrBuilder getCurrentVersionOrBuilder() {
    return currentVersion_ == null
        ? com.google.privacy.dlp.v2.StoredInfoTypeVersion.getDefaultInstance()
        : currentVersion_;
  }

  public static final int PENDING_VERSIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.StoredInfoTypeVersion> pendingVersions_;
  /**
   *
   *
   * <pre>
   * Pending versions of the stored info type. Empty if no versions are
   * pending.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.StoredInfoTypeVersion> getPendingVersionsList() {
    return pendingVersions_;
  }
  /**
   *
   *
   * <pre>
   * Pending versions of the stored info type. Empty if no versions are
   * pending.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.StoredInfoTypeVersionOrBuilder>
      getPendingVersionsOrBuilderList() {
    return pendingVersions_;
  }
  /**
   *
   *
   * <pre>
   * Pending versions of the stored info type. Empty if no versions are
   * pending.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
   */
  @java.lang.Override
  public int getPendingVersionsCount() {
    return pendingVersions_.size();
  }
  /**
   *
   *
   * <pre>
   * Pending versions of the stored info type. Empty if no versions are
   * pending.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StoredInfoTypeVersion getPendingVersions(int index) {
    return pendingVersions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Pending versions of the stored info type. Empty if no versions are
   * pending.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StoredInfoTypeVersionOrBuilder getPendingVersionsOrBuilder(
      int index) {
    return pendingVersions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCurrentVersion());
    }
    for (int i = 0; i < pendingVersions_.size(); i++) {
      output.writeMessage(3, pendingVersions_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCurrentVersion());
    }
    for (int i = 0; i < pendingVersions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, pendingVersions_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.StoredInfoType)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.StoredInfoType other = (com.google.privacy.dlp.v2.StoredInfoType) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCurrentVersion() != other.hasCurrentVersion()) return false;
    if (hasCurrentVersion()) {
      if (!getCurrentVersion().equals(other.getCurrentVersion())) return false;
    }
    if (!getPendingVersionsList().equals(other.getPendingVersionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCurrentVersion()) {
      hash = (37 * hash) + CURRENT_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getCurrentVersion().hashCode();
    }
    if (getPendingVersionsCount() > 0) {
      hash = (37 * hash) + PENDING_VERSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getPendingVersionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.StoredInfoType parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.StoredInfoType parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StoredInfoType parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.StoredInfoType parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StoredInfoType parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.StoredInfoType parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StoredInfoType parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.StoredInfoType parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StoredInfoType parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.StoredInfoType parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StoredInfoType parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.StoredInfoType parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.StoredInfoType prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * StoredInfoType resource message that contains information about the current
   * version and any pending updates.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.StoredInfoType}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.StoredInfoType)
      com.google.privacy.dlp.v2.StoredInfoTypeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_StoredInfoType_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_StoredInfoType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.StoredInfoType.class,
              com.google.privacy.dlp.v2.StoredInfoType.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.StoredInfoType.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCurrentVersionFieldBuilder();
        getPendingVersionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      currentVersion_ = null;
      if (currentVersionBuilder_ != null) {
        currentVersionBuilder_.dispose();
        currentVersionBuilder_ = null;
      }
      if (pendingVersionsBuilder_ == null) {
        pendingVersions_ = java.util.Collections.emptyList();
      } else {
        pendingVersions_ = null;
        pendingVersionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_StoredInfoType_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StoredInfoType getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.StoredInfoType.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StoredInfoType build() {
      com.google.privacy.dlp.v2.StoredInfoType result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StoredInfoType buildPartial() {
      com.google.privacy.dlp.v2.StoredInfoType result =
          new com.google.privacy.dlp.v2.StoredInfoType(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.privacy.dlp.v2.StoredInfoType result) {
      if (pendingVersionsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          pendingVersions_ = java.util.Collections.unmodifiableList(pendingVersions_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.pendingVersions_ = pendingVersions_;
      } else {
        result.pendingVersions_ = pendingVersionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.privacy.dlp.v2.StoredInfoType result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.currentVersion_ =
            currentVersionBuilder_ == null ? currentVersion_ : currentVersionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.StoredInfoType) {
        return mergeFrom((com.google.privacy.dlp.v2.StoredInfoType) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.StoredInfoType other) {
      if (other == com.google.privacy.dlp.v2.StoredInfoType.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCurrentVersion()) {
        mergeCurrentVersion(other.getCurrentVersion());
      }
      if (pendingVersionsBuilder_ == null) {
        if (!other.pendingVersions_.isEmpty()) {
          if (pendingVersions_.isEmpty()) {
            pendingVersions_ = other.pendingVersions_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensurePendingVersionsIsMutable();
            pendingVersions_.addAll(other.pendingVersions_);
          }
          onChanged();
        }
      } else {
        if (!other.pendingVersions_.isEmpty()) {
          if (pendingVersionsBuilder_.isEmpty()) {
            pendingVersionsBuilder_.dispose();
            pendingVersionsBuilder_ = null;
            pendingVersions_ = other.pendingVersions_;
            bitField0_ = (bitField0_ & ~0x00000004);
            pendingVersionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPendingVersionsFieldBuilder()
                    : null;
          } else {
            pendingVersionsBuilder_.addAllMessages(other.pendingVersions_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCurrentVersionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.privacy.dlp.v2.StoredInfoTypeVersion m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.StoredInfoTypeVersion.parser(),
                        extensionRegistry);
                if (pendingVersionsBuilder_ == null) {
                  ensurePendingVersionsIsMutable();
                  pendingVersions_.add(m);
                } else {
                  pendingVersionsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Resource name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.StoredInfoTypeVersion currentVersion_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.StoredInfoTypeVersion,
            com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder,
            com.google.privacy.dlp.v2.StoredInfoTypeVersionOrBuilder>
        currentVersionBuilder_;
    /**
     *
     *
     * <pre>
     * Current version of the stored info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeVersion current_version = 2;</code>
     *
     * @return Whether the currentVersion field is set.
     */
    public boolean hasCurrentVersion() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Current version of the stored info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeVersion current_version = 2;</code>
     *
     * @return The currentVersion.
     */
    public com.google.privacy.dlp.v2.StoredInfoTypeVersion getCurrentVersion() {
      if (currentVersionBuilder_ == null) {
        return currentVersion_ == null
            ? com.google.privacy.dlp.v2.StoredInfoTypeVersion.getDefaultInstance()
            : currentVersion_;
      } else {
        return currentVersionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Current version of the stored info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeVersion current_version = 2;</code>
     */
    public Builder setCurrentVersion(com.google.privacy.dlp.v2.StoredInfoTypeVersion value) {
      if (currentVersionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        currentVersion_ = value;
      } else {
        currentVersionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Current version of the stored info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeVersion current_version = 2;</code>
     */
    public Builder setCurrentVersion(
        com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder builderForValue) {
      if (currentVersionBuilder_ == null) {
        currentVersion_ = builderForValue.build();
      } else {
        currentVersionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Current version of the stored info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeVersion current_version = 2;</code>
     */
    public Builder mergeCurrentVersion(com.google.privacy.dlp.v2.StoredInfoTypeVersion value) {
      if (currentVersionBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && currentVersion_ != null
            && currentVersion_
                != com.google.privacy.dlp.v2.StoredInfoTypeVersion.getDefaultInstance()) {
          getCurrentVersionBuilder().mergeFrom(value);
        } else {
          currentVersion_ = value;
        }
      } else {
        currentVersionBuilder_.mergeFrom(value);
      }
      if (currentVersion_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Current version of the stored info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeVersion current_version = 2;</code>
     */
    public Builder clearCurrentVersion() {
      bitField0_ = (bitField0_ & ~0x00000002);
      currentVersion_ = null;
      if (currentVersionBuilder_ != null) {
        currentVersionBuilder_.dispose();
        currentVersionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Current version of the stored info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeVersion current_version = 2;</code>
     */
    public com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder getCurrentVersionBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCurrentVersionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Current version of the stored info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeVersion current_version = 2;</code>
     */
    public com.google.privacy.dlp.v2.StoredInfoTypeVersionOrBuilder getCurrentVersionOrBuilder() {
      if (currentVersionBuilder_ != null) {
        return currentVersionBuilder_.getMessageOrBuilder();
      } else {
        return currentVersion_ == null
            ? com.google.privacy.dlp.v2.StoredInfoTypeVersion.getDefaultInstance()
            : currentVersion_;
      }
    }
    /**
     *
     *
     * <pre>
     * Current version of the stored info type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeVersion current_version = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.StoredInfoTypeVersion,
            com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder,
            com.google.privacy.dlp.v2.StoredInfoTypeVersionOrBuilder>
        getCurrentVersionFieldBuilder() {
      if (currentVersionBuilder_ == null) {
        currentVersionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.StoredInfoTypeVersion,
                com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder,
                com.google.privacy.dlp.v2.StoredInfoTypeVersionOrBuilder>(
                getCurrentVersion(), getParentForChildren(), isClean());
        currentVersion_ = null;
      }
      return currentVersionBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.StoredInfoTypeVersion> pendingVersions_ =
        java.util.Collections.emptyList();

    private void ensurePendingVersionsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        pendingVersions_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.StoredInfoTypeVersion>(
                pendingVersions_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.StoredInfoTypeVersion,
            com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder,
            com.google.privacy.dlp.v2.StoredInfoTypeVersionOrBuilder>
        pendingVersionsBuilder_;

    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.StoredInfoTypeVersion>
        getPendingVersionsList() {
      if (pendingVersionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pendingVersions_);
      } else {
        return pendingVersionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public int getPendingVersionsCount() {
      if (pendingVersionsBuilder_ == null) {
        return pendingVersions_.size();
      } else {
        return pendingVersionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public com.google.privacy.dlp.v2.StoredInfoTypeVersion getPendingVersions(int index) {
      if (pendingVersionsBuilder_ == null) {
        return pendingVersions_.get(index);
      } else {
        return pendingVersionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public Builder setPendingVersions(
        int index, com.google.privacy.dlp.v2.StoredInfoTypeVersion value) {
      if (pendingVersionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePendingVersionsIsMutable();
        pendingVersions_.set(index, value);
        onChanged();
      } else {
        pendingVersionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public Builder setPendingVersions(
        int index, com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder builderForValue) {
      if (pendingVersionsBuilder_ == null) {
        ensurePendingVersionsIsMutable();
        pendingVersions_.set(index, builderForValue.build());
        onChanged();
      } else {
        pendingVersionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public Builder addPendingVersions(com.google.privacy.dlp.v2.StoredInfoTypeVersion value) {
      if (pendingVersionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePendingVersionsIsMutable();
        pendingVersions_.add(value);
        onChanged();
      } else {
        pendingVersionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public Builder addPendingVersions(
        int index, com.google.privacy.dlp.v2.StoredInfoTypeVersion value) {
      if (pendingVersionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePendingVersionsIsMutable();
        pendingVersions_.add(index, value);
        onChanged();
      } else {
        pendingVersionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public Builder addPendingVersions(
        com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder builderForValue) {
      if (pendingVersionsBuilder_ == null) {
        ensurePendingVersionsIsMutable();
        pendingVersions_.add(builderForValue.build());
        onChanged();
      } else {
        pendingVersionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public Builder addPendingVersions(
        int index, com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder builderForValue) {
      if (pendingVersionsBuilder_ == null) {
        ensurePendingVersionsIsMutable();
        pendingVersions_.add(index, builderForValue.build());
        onChanged();
      } else {
        pendingVersionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public Builder addAllPendingVersions(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.StoredInfoTypeVersion> values) {
      if (pendingVersionsBuilder_ == null) {
        ensurePendingVersionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pendingVersions_);
        onChanged();
      } else {
        pendingVersionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public Builder clearPendingVersions() {
      if (pendingVersionsBuilder_ == null) {
        pendingVersions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        pendingVersionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public Builder removePendingVersions(int index) {
      if (pendingVersionsBuilder_ == null) {
        ensurePendingVersionsIsMutable();
        pendingVersions_.remove(index);
        onChanged();
      } else {
        pendingVersionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder getPendingVersionsBuilder(
        int index) {
      return getPendingVersionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public com.google.privacy.dlp.v2.StoredInfoTypeVersionOrBuilder getPendingVersionsOrBuilder(
        int index) {
      if (pendingVersionsBuilder_ == null) {
        return pendingVersions_.get(index);
      } else {
        return pendingVersionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.StoredInfoTypeVersionOrBuilder>
        getPendingVersionsOrBuilderList() {
      if (pendingVersionsBuilder_ != null) {
        return pendingVersionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pendingVersions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder addPendingVersionsBuilder() {
      return getPendingVersionsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.StoredInfoTypeVersion.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder addPendingVersionsBuilder(
        int index) {
      return getPendingVersionsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.StoredInfoTypeVersion.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Pending versions of the stored info type. Empty if no versions are
     * pending.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.StoredInfoTypeVersion pending_versions = 3;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder>
        getPendingVersionsBuilderList() {
      return getPendingVersionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.StoredInfoTypeVersion,
            com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder,
            com.google.privacy.dlp.v2.StoredInfoTypeVersionOrBuilder>
        getPendingVersionsFieldBuilder() {
      if (pendingVersionsBuilder_ == null) {
        pendingVersionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.StoredInfoTypeVersion,
                com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder,
                com.google.privacy.dlp.v2.StoredInfoTypeVersionOrBuilder>(
                pendingVersions_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        pendingVersions_ = null;
      }
      return pendingVersionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.StoredInfoType)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.StoredInfoType)
  private static final com.google.privacy.dlp.v2.StoredInfoType DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.StoredInfoType();
  }

  public static com.google.privacy.dlp.v2.StoredInfoType getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StoredInfoType> PARSER =
      new com.google.protobuf.AbstractParser<StoredInfoType>() {
        @java.lang.Override
        public StoredInfoType parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StoredInfoType> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StoredInfoType> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.StoredInfoType getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
