/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Configuration for stored infoTypes. All fields and subfield are provided
 * by the user. For more information, see
 * https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.StoredInfoTypeConfig}
 */
public final class StoredInfoTypeConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.StoredInfoTypeConfig)
    StoredInfoTypeConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StoredInfoTypeConfig.newBuilder() to construct.
  private StoredInfoTypeConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StoredInfoTypeConfig() {
    displayName_ = "";
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StoredInfoTypeConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_StoredInfoTypeConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_StoredInfoTypeConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.StoredInfoTypeConfig.class,
            com.google.privacy.dlp.v2.StoredInfoTypeConfig.Builder.class);
  }

  private int typeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object type_;

  public enum TypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    LARGE_CUSTOM_DICTIONARY(3),
    DICTIONARY(4),
    REGEX(5),
    TYPE_NOT_SET(0);
    private final int value;

    private TypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TypeCase forNumber(int value) {
      switch (value) {
        case 3:
          return LARGE_CUSTOM_DICTIONARY;
        case 4:
          return DICTIONARY;
        case 5:
          return REGEX;
        case 0:
          return TYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TypeCase getTypeCase() {
    return TypeCase.forNumber(typeCase_);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Display name of the StoredInfoType (max 256 characters).
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Display name of the StoredInfoType (max 256 characters).
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Description of the StoredInfoType (max 256 characters).
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Description of the StoredInfoType (max 256 characters).
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LARGE_CUSTOM_DICTIONARY_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * StoredInfoType where findings are defined by a dictionary of phrases.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.LargeCustomDictionaryConfig large_custom_dictionary = 3;</code>
   *
   * @return Whether the largeCustomDictionary field is set.
   */
  @java.lang.Override
  public boolean hasLargeCustomDictionary() {
    return typeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * StoredInfoType where findings are defined by a dictionary of phrases.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.LargeCustomDictionaryConfig large_custom_dictionary = 3;</code>
   *
   * @return The largeCustomDictionary.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.LargeCustomDictionaryConfig getLargeCustomDictionary() {
    if (typeCase_ == 3) {
      return (com.google.privacy.dlp.v2.LargeCustomDictionaryConfig) type_;
    }
    return com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * StoredInfoType where findings are defined by a dictionary of phrases.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.LargeCustomDictionaryConfig large_custom_dictionary = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.LargeCustomDictionaryConfigOrBuilder
      getLargeCustomDictionaryOrBuilder() {
    if (typeCase_ == 3) {
      return (com.google.privacy.dlp.v2.LargeCustomDictionaryConfig) type_;
    }
    return com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.getDefaultInstance();
  }

  public static final int DICTIONARY_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Store dictionary-based CustomInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 4;</code>
   *
   * @return Whether the dictionary field is set.
   */
  @java.lang.Override
  public boolean hasDictionary() {
    return typeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Store dictionary-based CustomInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 4;</code>
   *
   * @return The dictionary.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.Dictionary getDictionary() {
    if (typeCase_ == 4) {
      return (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_;
    }
    return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Store dictionary-based CustomInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder getDictionaryOrBuilder() {
    if (typeCase_ == 4) {
      return (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_;
    }
    return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
  }

  public static final int REGEX_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Store regular expression-based StoredInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 5;</code>
   *
   * @return Whether the regex field is set.
   */
  @java.lang.Override
  public boolean hasRegex() {
    return typeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Store regular expression-based StoredInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 5;</code>
   *
   * @return The regex.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.Regex getRegex() {
    if (typeCase_ == 5) {
      return (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_;
    }
    return com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Store regular expression-based StoredInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 5;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder getRegexOrBuilder() {
    if (typeCase_ == 5) {
      return (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_;
    }
    return com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (typeCase_ == 3) {
      output.writeMessage(3, (com.google.privacy.dlp.v2.LargeCustomDictionaryConfig) type_);
    }
    if (typeCase_ == 4) {
      output.writeMessage(4, (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_);
    }
    if (typeCase_ == 5) {
      output.writeMessage(5, (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (typeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.privacy.dlp.v2.LargeCustomDictionaryConfig) type_);
    }
    if (typeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_);
    }
    if (typeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.StoredInfoTypeConfig)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.StoredInfoTypeConfig other =
        (com.google.privacy.dlp.v2.StoredInfoTypeConfig) obj;

    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getTypeCase().equals(other.getTypeCase())) return false;
    switch (typeCase_) {
      case 3:
        if (!getLargeCustomDictionary().equals(other.getLargeCustomDictionary())) return false;
        break;
      case 4:
        if (!getDictionary().equals(other.getDictionary())) return false;
        break;
      case 5:
        if (!getRegex().equals(other.getRegex())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    switch (typeCase_) {
      case 3:
        hash = (37 * hash) + LARGE_CUSTOM_DICTIONARY_FIELD_NUMBER;
        hash = (53 * hash) + getLargeCustomDictionary().hashCode();
        break;
      case 4:
        hash = (37 * hash) + DICTIONARY_FIELD_NUMBER;
        hash = (53 * hash) + getDictionary().hashCode();
        break;
      case 5:
        hash = (37 * hash) + REGEX_FIELD_NUMBER;
        hash = (53 * hash) + getRegex().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.StoredInfoTypeConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for stored infoTypes. All fields and subfield are provided
   * by the user. For more information, see
   * https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.StoredInfoTypeConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.StoredInfoTypeConfig)
      com.google.privacy.dlp.v2.StoredInfoTypeConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_StoredInfoTypeConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_StoredInfoTypeConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.StoredInfoTypeConfig.class,
              com.google.privacy.dlp.v2.StoredInfoTypeConfig.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.StoredInfoTypeConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      displayName_ = "";
      description_ = "";
      if (largeCustomDictionaryBuilder_ != null) {
        largeCustomDictionaryBuilder_.clear();
      }
      if (dictionaryBuilder_ != null) {
        dictionaryBuilder_.clear();
      }
      if (regexBuilder_ != null) {
        regexBuilder_.clear();
      }
      typeCase_ = 0;
      type_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_StoredInfoTypeConfig_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StoredInfoTypeConfig getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.StoredInfoTypeConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StoredInfoTypeConfig build() {
      com.google.privacy.dlp.v2.StoredInfoTypeConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StoredInfoTypeConfig buildPartial() {
      com.google.privacy.dlp.v2.StoredInfoTypeConfig result =
          new com.google.privacy.dlp.v2.StoredInfoTypeConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.StoredInfoTypeConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.StoredInfoTypeConfig result) {
      result.typeCase_ = typeCase_;
      result.type_ = this.type_;
      if (typeCase_ == 3 && largeCustomDictionaryBuilder_ != null) {
        result.type_ = largeCustomDictionaryBuilder_.build();
      }
      if (typeCase_ == 4 && dictionaryBuilder_ != null) {
        result.type_ = dictionaryBuilder_.build();
      }
      if (typeCase_ == 5 && regexBuilder_ != null) {
        result.type_ = regexBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.StoredInfoTypeConfig) {
        return mergeFrom((com.google.privacy.dlp.v2.StoredInfoTypeConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.StoredInfoTypeConfig other) {
      if (other == com.google.privacy.dlp.v2.StoredInfoTypeConfig.getDefaultInstance()) return this;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      switch (other.getTypeCase()) {
        case LARGE_CUSTOM_DICTIONARY:
          {
            mergeLargeCustomDictionary(other.getLargeCustomDictionary());
            break;
          }
        case DICTIONARY:
          {
            mergeDictionary(other.getDictionary());
            break;
          }
        case REGEX:
          {
            mergeRegex(other.getRegex());
            break;
          }
        case TYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getLargeCustomDictionaryFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDictionaryFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getRegexFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int typeCase_ = 0;
    private java.lang.Object type_;

    public TypeCase getTypeCase() {
      return TypeCase.forNumber(typeCase_);
    }

    public Builder clearType() {
      typeCase_ = 0;
      type_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Display name of the StoredInfoType (max 256 characters).
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name of the StoredInfoType (max 256 characters).
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name of the StoredInfoType (max 256 characters).
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display name of the StoredInfoType (max 256 characters).
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display name of the StoredInfoType (max 256 characters).
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Description of the StoredInfoType (max 256 characters).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the StoredInfoType (max 256 characters).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the StoredInfoType (max 256 characters).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the StoredInfoType (max 256 characters).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the StoredInfoType (max 256 characters).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.LargeCustomDictionaryConfig,
            com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.Builder,
            com.google.privacy.dlp.v2.LargeCustomDictionaryConfigOrBuilder>
        largeCustomDictionaryBuilder_;
    /**
     *
     *
     * <pre>
     * StoredInfoType where findings are defined by a dictionary of phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.LargeCustomDictionaryConfig large_custom_dictionary = 3;</code>
     *
     * @return Whether the largeCustomDictionary field is set.
     */
    @java.lang.Override
    public boolean hasLargeCustomDictionary() {
      return typeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * StoredInfoType where findings are defined by a dictionary of phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.LargeCustomDictionaryConfig large_custom_dictionary = 3;</code>
     *
     * @return The largeCustomDictionary.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.LargeCustomDictionaryConfig getLargeCustomDictionary() {
      if (largeCustomDictionaryBuilder_ == null) {
        if (typeCase_ == 3) {
          return (com.google.privacy.dlp.v2.LargeCustomDictionaryConfig) type_;
        }
        return com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.getDefaultInstance();
      } else {
        if (typeCase_ == 3) {
          return largeCustomDictionaryBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * StoredInfoType where findings are defined by a dictionary of phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.LargeCustomDictionaryConfig large_custom_dictionary = 3;</code>
     */
    public Builder setLargeCustomDictionary(
        com.google.privacy.dlp.v2.LargeCustomDictionaryConfig value) {
      if (largeCustomDictionaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        largeCustomDictionaryBuilder_.setMessage(value);
      }
      typeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * StoredInfoType where findings are defined by a dictionary of phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.LargeCustomDictionaryConfig large_custom_dictionary = 3;</code>
     */
    public Builder setLargeCustomDictionary(
        com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.Builder builderForValue) {
      if (largeCustomDictionaryBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        largeCustomDictionaryBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * StoredInfoType where findings are defined by a dictionary of phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.LargeCustomDictionaryConfig large_custom_dictionary = 3;</code>
     */
    public Builder mergeLargeCustomDictionary(
        com.google.privacy.dlp.v2.LargeCustomDictionaryConfig value) {
      if (largeCustomDictionaryBuilder_ == null) {
        if (typeCase_ == 3
            && type_
                != com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.getDefaultInstance()) {
          type_ =
              com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.newBuilder(
                      (com.google.privacy.dlp.v2.LargeCustomDictionaryConfig) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 3) {
          largeCustomDictionaryBuilder_.mergeFrom(value);
        } else {
          largeCustomDictionaryBuilder_.setMessage(value);
        }
      }
      typeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * StoredInfoType where findings are defined by a dictionary of phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.LargeCustomDictionaryConfig large_custom_dictionary = 3;</code>
     */
    public Builder clearLargeCustomDictionary() {
      if (largeCustomDictionaryBuilder_ == null) {
        if (typeCase_ == 3) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 3) {
          typeCase_ = 0;
          type_ = null;
        }
        largeCustomDictionaryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * StoredInfoType where findings are defined by a dictionary of phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.LargeCustomDictionaryConfig large_custom_dictionary = 3;</code>
     */
    public com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.Builder
        getLargeCustomDictionaryBuilder() {
      return getLargeCustomDictionaryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * StoredInfoType where findings are defined by a dictionary of phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.LargeCustomDictionaryConfig large_custom_dictionary = 3;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.LargeCustomDictionaryConfigOrBuilder
        getLargeCustomDictionaryOrBuilder() {
      if ((typeCase_ == 3) && (largeCustomDictionaryBuilder_ != null)) {
        return largeCustomDictionaryBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 3) {
          return (com.google.privacy.dlp.v2.LargeCustomDictionaryConfig) type_;
        }
        return com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * StoredInfoType where findings are defined by a dictionary of phrases.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.LargeCustomDictionaryConfig large_custom_dictionary = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.LargeCustomDictionaryConfig,
            com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.Builder,
            com.google.privacy.dlp.v2.LargeCustomDictionaryConfigOrBuilder>
        getLargeCustomDictionaryFieldBuilder() {
      if (largeCustomDictionaryBuilder_ == null) {
        if (!(typeCase_ == 3)) {
          type_ = com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.getDefaultInstance();
        }
        largeCustomDictionaryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.LargeCustomDictionaryConfig,
                com.google.privacy.dlp.v2.LargeCustomDictionaryConfig.Builder,
                com.google.privacy.dlp.v2.LargeCustomDictionaryConfigOrBuilder>(
                (com.google.privacy.dlp.v2.LargeCustomDictionaryConfig) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 3;
      onChanged();
      return largeCustomDictionaryBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType.Dictionary,
            com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder,
            com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder>
        dictionaryBuilder_;
    /**
     *
     *
     * <pre>
     * Store dictionary-based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 4;</code>
     *
     * @return Whether the dictionary field is set.
     */
    @java.lang.Override
    public boolean hasDictionary() {
      return typeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Store dictionary-based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 4;</code>
     *
     * @return The dictionary.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.Dictionary getDictionary() {
      if (dictionaryBuilder_ == null) {
        if (typeCase_ == 4) {
          return (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_;
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
      } else {
        if (typeCase_ == 4) {
          return dictionaryBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Store dictionary-based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 4;</code>
     */
    public Builder setDictionary(com.google.privacy.dlp.v2.CustomInfoType.Dictionary value) {
      if (dictionaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        dictionaryBuilder_.setMessage(value);
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Store dictionary-based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 4;</code>
     */
    public Builder setDictionary(
        com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder builderForValue) {
      if (dictionaryBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        dictionaryBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Store dictionary-based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 4;</code>
     */
    public Builder mergeDictionary(com.google.privacy.dlp.v2.CustomInfoType.Dictionary value) {
      if (dictionaryBuilder_ == null) {
        if (typeCase_ == 4
            && type_ != com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance()) {
          type_ =
              com.google.privacy.dlp.v2.CustomInfoType.Dictionary.newBuilder(
                      (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 4) {
          dictionaryBuilder_.mergeFrom(value);
        } else {
          dictionaryBuilder_.setMessage(value);
        }
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Store dictionary-based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 4;</code>
     */
    public Builder clearDictionary() {
      if (dictionaryBuilder_ == null) {
        if (typeCase_ == 4) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 4) {
          typeCase_ = 0;
          type_ = null;
        }
        dictionaryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Store dictionary-based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 4;</code>
     */
    public com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder getDictionaryBuilder() {
      return getDictionaryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Store dictionary-based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 4;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder getDictionaryOrBuilder() {
      if ((typeCase_ == 4) && (dictionaryBuilder_ != null)) {
        return dictionaryBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 4) {
          return (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_;
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Store dictionary-based CustomInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType.Dictionary,
            com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder,
            com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder>
        getDictionaryFieldBuilder() {
      if (dictionaryBuilder_ == null) {
        if (!(typeCase_ == 4)) {
          type_ = com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
        }
        dictionaryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CustomInfoType.Dictionary,
                com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder,
                com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder>(
                (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 4;
      onChanged();
      return dictionaryBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType.Regex,
            com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder,
            com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder>
        regexBuilder_;
    /**
     *
     *
     * <pre>
     * Store regular expression-based StoredInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 5;</code>
     *
     * @return Whether the regex field is set.
     */
    @java.lang.Override
    public boolean hasRegex() {
      return typeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Store regular expression-based StoredInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 5;</code>
     *
     * @return The regex.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.Regex getRegex() {
      if (regexBuilder_ == null) {
        if (typeCase_ == 5) {
          return (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_;
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
      } else {
        if (typeCase_ == 5) {
          return regexBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Store regular expression-based StoredInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 5;</code>
     */
    public Builder setRegex(com.google.privacy.dlp.v2.CustomInfoType.Regex value) {
      if (regexBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        regexBuilder_.setMessage(value);
      }
      typeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Store regular expression-based StoredInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 5;</code>
     */
    public Builder setRegex(
        com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder builderForValue) {
      if (regexBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        regexBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Store regular expression-based StoredInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 5;</code>
     */
    public Builder mergeRegex(com.google.privacy.dlp.v2.CustomInfoType.Regex value) {
      if (regexBuilder_ == null) {
        if (typeCase_ == 5
            && type_ != com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance()) {
          type_ =
              com.google.privacy.dlp.v2.CustomInfoType.Regex.newBuilder(
                      (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 5) {
          regexBuilder_.mergeFrom(value);
        } else {
          regexBuilder_.setMessage(value);
        }
      }
      typeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Store regular expression-based StoredInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 5;</code>
     */
    public Builder clearRegex() {
      if (regexBuilder_ == null) {
        if (typeCase_ == 5) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 5) {
          typeCase_ = 0;
          type_ = null;
        }
        regexBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Store regular expression-based StoredInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 5;</code>
     */
    public com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder getRegexBuilder() {
      return getRegexFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Store regular expression-based StoredInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 5;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder getRegexOrBuilder() {
      if ((typeCase_ == 5) && (regexBuilder_ != null)) {
        return regexBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 5) {
          return (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_;
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Store regular expression-based StoredInfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType.Regex,
            com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder,
            com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder>
        getRegexFieldBuilder() {
      if (regexBuilder_ == null) {
        if (!(typeCase_ == 5)) {
          type_ = com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
        }
        regexBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CustomInfoType.Regex,
                com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder,
                com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder>(
                (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 5;
      onChanged();
      return regexBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.StoredInfoTypeConfig)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.StoredInfoTypeConfig)
  private static final com.google.privacy.dlp.v2.StoredInfoTypeConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.StoredInfoTypeConfig();
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StoredInfoTypeConfig> PARSER =
      new com.google.protobuf.AbstractParser<StoredInfoTypeConfig>() {
        @java.lang.Override
        public StoredInfoTypeConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StoredInfoTypeConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StoredInfoTypeConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.StoredInfoTypeConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
