/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Structured content to inspect. Up to 50,000 `Value`s per request allowed. See
 * https://cloud.google.com/sensitive-data-protection/docs/inspecting-structured-text#inspecting_a_table
 * to learn more.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.Table}
 */
public final class Table extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.Table)
    TableOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Table.newBuilder() to construct.
  private Table(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Table() {
    headers_ = java.util.Collections.emptyList();
    rows_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Table();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_Table_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_Table_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.Table.class, com.google.privacy.dlp.v2.Table.Builder.class);
  }

  public interface RowOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.Table.Row)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Individual cells.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
     */
    java.util.List<com.google.privacy.dlp.v2.Value> getValuesList();
    /**
     *
     *
     * <pre>
     * Individual cells.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
     */
    com.google.privacy.dlp.v2.Value getValues(int index);
    /**
     *
     *
     * <pre>
     * Individual cells.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
     */
    int getValuesCount();
    /**
     *
     *
     * <pre>
     * Individual cells.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
     */
    java.util.List<? extends com.google.privacy.dlp.v2.ValueOrBuilder> getValuesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Individual cells.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
     */
    com.google.privacy.dlp.v2.ValueOrBuilder getValuesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Values of the row.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.Table.Row}
   */
  public static final class Row extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.Table.Row)
      RowOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Row.newBuilder() to construct.
    private Row(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Row() {
      values_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Row();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Table_Row_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Table_Row_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.Table.Row.class,
              com.google.privacy.dlp.v2.Table.Row.Builder.class);
    }

    public static final int VALUES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.privacy.dlp.v2.Value> values_;
    /**
     *
     *
     * <pre>
     * Individual cells.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.privacy.dlp.v2.Value> getValuesList() {
      return values_;
    }
    /**
     *
     *
     * <pre>
     * Individual cells.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.privacy.dlp.v2.ValueOrBuilder>
        getValuesOrBuilderList() {
      return values_;
    }
    /**
     *
     *
     * <pre>
     * Individual cells.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
     */
    @java.lang.Override
    public int getValuesCount() {
      return values_.size();
    }
    /**
     *
     *
     * <pre>
     * Individual cells.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Value getValues(int index) {
      return values_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Individual cells.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ValueOrBuilder getValuesOrBuilder(int index) {
      return values_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < values_.size(); i++) {
        output.writeMessage(1, values_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < values_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, values_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.Table.Row)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.Table.Row other = (com.google.privacy.dlp.v2.Table.Row) obj;

      if (!getValuesList().equals(other.getValuesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getValuesCount() > 0) {
        hash = (37 * hash) + VALUES_FIELD_NUMBER;
        hash = (53 * hash) + getValuesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.Table.Row parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Table.Row parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Table.Row parseFrom(com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Table.Row parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Table.Row parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Table.Row parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Table.Row parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Table.Row parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Table.Row parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Table.Row parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Table.Row parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Table.Row parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.privacy.dlp.v2.Table.Row prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Values of the row.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.Table.Row}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.Table.Row)
        com.google.privacy.dlp.v2.Table.RowOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Table_Row_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Table_Row_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.Table.Row.class,
                com.google.privacy.dlp.v2.Table.Row.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.Table.Row.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (valuesBuilder_ == null) {
          values_ = java.util.Collections.emptyList();
        } else {
          values_ = null;
          valuesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Table_Row_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Table.Row getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.Table.Row.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Table.Row build() {
        com.google.privacy.dlp.v2.Table.Row result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Table.Row buildPartial() {
        com.google.privacy.dlp.v2.Table.Row result = new com.google.privacy.dlp.v2.Table.Row(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.google.privacy.dlp.v2.Table.Row result) {
        if (valuesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            values_ = java.util.Collections.unmodifiableList(values_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.values_ = values_;
        } else {
          result.values_ = valuesBuilder_.build();
        }
      }

      private void buildPartial0(com.google.privacy.dlp.v2.Table.Row result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.Table.Row) {
          return mergeFrom((com.google.privacy.dlp.v2.Table.Row) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.Table.Row other) {
        if (other == com.google.privacy.dlp.v2.Table.Row.getDefaultInstance()) return this;
        if (valuesBuilder_ == null) {
          if (!other.values_.isEmpty()) {
            if (values_.isEmpty()) {
              values_ = other.values_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureValuesIsMutable();
              values_.addAll(other.values_);
            }
            onChanged();
          }
        } else {
          if (!other.values_.isEmpty()) {
            if (valuesBuilder_.isEmpty()) {
              valuesBuilder_.dispose();
              valuesBuilder_ = null;
              values_ = other.values_;
              bitField0_ = (bitField0_ & ~0x00000001);
              valuesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getValuesFieldBuilder()
                      : null;
            } else {
              valuesBuilder_.addAllMessages(other.values_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.privacy.dlp.v2.Value m =
                      input.readMessage(
                          com.google.privacy.dlp.v2.Value.parser(), extensionRegistry);
                  if (valuesBuilder_ == null) {
                    ensureValuesIsMutable();
                    values_.add(m);
                  } else {
                    valuesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.privacy.dlp.v2.Value> values_ =
          java.util.Collections.emptyList();

      private void ensureValuesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          values_ = new java.util.ArrayList<com.google.privacy.dlp.v2.Value>(values_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.privacy.dlp.v2.Value,
              com.google.privacy.dlp.v2.Value.Builder,
              com.google.privacy.dlp.v2.ValueOrBuilder>
          valuesBuilder_;

      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public java.util.List<com.google.privacy.dlp.v2.Value> getValuesList() {
        if (valuesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(values_);
        } else {
          return valuesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public int getValuesCount() {
        if (valuesBuilder_ == null) {
          return values_.size();
        } else {
          return valuesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public com.google.privacy.dlp.v2.Value getValues(int index) {
        if (valuesBuilder_ == null) {
          return values_.get(index);
        } else {
          return valuesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public Builder setValues(int index, com.google.privacy.dlp.v2.Value value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.set(index, value);
          onChanged();
        } else {
          valuesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public Builder setValues(int index, com.google.privacy.dlp.v2.Value.Builder builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.set(index, builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public Builder addValues(com.google.privacy.dlp.v2.Value value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.add(value);
          onChanged();
        } else {
          valuesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public Builder addValues(int index, com.google.privacy.dlp.v2.Value value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.add(index, value);
          onChanged();
        } else {
          valuesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public Builder addValues(com.google.privacy.dlp.v2.Value.Builder builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.add(builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public Builder addValues(int index, com.google.privacy.dlp.v2.Value.Builder builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.add(index, builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public Builder addAllValues(
          java.lang.Iterable<? extends com.google.privacy.dlp.v2.Value> values) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
          onChanged();
        } else {
          valuesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public Builder clearValues() {
        if (valuesBuilder_ == null) {
          values_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          valuesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public Builder removeValues(int index) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.remove(index);
          onChanged();
        } else {
          valuesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public com.google.privacy.dlp.v2.Value.Builder getValuesBuilder(int index) {
        return getValuesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public com.google.privacy.dlp.v2.ValueOrBuilder getValuesOrBuilder(int index) {
        if (valuesBuilder_ == null) {
          return values_.get(index);
        } else {
          return valuesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public java.util.List<? extends com.google.privacy.dlp.v2.ValueOrBuilder>
          getValuesOrBuilderList() {
        if (valuesBuilder_ != null) {
          return valuesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(values_);
        }
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public com.google.privacy.dlp.v2.Value.Builder addValuesBuilder() {
        return getValuesFieldBuilder()
            .addBuilder(com.google.privacy.dlp.v2.Value.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public com.google.privacy.dlp.v2.Value.Builder addValuesBuilder(int index) {
        return getValuesFieldBuilder()
            .addBuilder(index, com.google.privacy.dlp.v2.Value.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Individual cells.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.Value values = 1;</code>
       */
      public java.util.List<com.google.privacy.dlp.v2.Value.Builder> getValuesBuilderList() {
        return getValuesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.privacy.dlp.v2.Value,
              com.google.privacy.dlp.v2.Value.Builder,
              com.google.privacy.dlp.v2.ValueOrBuilder>
          getValuesFieldBuilder() {
        if (valuesBuilder_ == null) {
          valuesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.privacy.dlp.v2.Value,
                  com.google.privacy.dlp.v2.Value.Builder,
                  com.google.privacy.dlp.v2.ValueOrBuilder>(
                  values_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          values_ = null;
        }
        return valuesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.Table.Row)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.Table.Row)
    private static final com.google.privacy.dlp.v2.Table.Row DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.Table.Row();
    }

    public static com.google.privacy.dlp.v2.Table.Row getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Row> PARSER =
        new com.google.protobuf.AbstractParser<Row>() {
          @java.lang.Override
          public Row parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Row> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Row> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Table.Row getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int HEADERS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.FieldId> headers_;
  /**
   *
   *
   * <pre>
   * Headers of the table.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.FieldId> getHeadersList() {
    return headers_;
  }
  /**
   *
   *
   * <pre>
   * Headers of the table.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.FieldIdOrBuilder>
      getHeadersOrBuilderList() {
    return headers_;
  }
  /**
   *
   *
   * <pre>
   * Headers of the table.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
   */
  @java.lang.Override
  public int getHeadersCount() {
    return headers_.size();
  }
  /**
   *
   *
   * <pre>
   * Headers of the table.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldId getHeaders(int index) {
    return headers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Headers of the table.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldIdOrBuilder getHeadersOrBuilder(int index) {
    return headers_.get(index);
  }

  public static final int ROWS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.Table.Row> rows_;
  /**
   *
   *
   * <pre>
   * Rows of the table.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.Table.Row> getRowsList() {
    return rows_;
  }
  /**
   *
   *
   * <pre>
   * Rows of the table.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.Table.RowOrBuilder>
      getRowsOrBuilderList() {
    return rows_;
  }
  /**
   *
   *
   * <pre>
   * Rows of the table.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
   */
  @java.lang.Override
  public int getRowsCount() {
    return rows_.size();
  }
  /**
   *
   *
   * <pre>
   * Rows of the table.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Table.Row getRows(int index) {
    return rows_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Rows of the table.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Table.RowOrBuilder getRowsOrBuilder(int index) {
    return rows_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < headers_.size(); i++) {
      output.writeMessage(1, headers_.get(i));
    }
    for (int i = 0; i < rows_.size(); i++) {
      output.writeMessage(2, rows_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < headers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, headers_.get(i));
    }
    for (int i = 0; i < rows_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, rows_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.Table)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.Table other = (com.google.privacy.dlp.v2.Table) obj;

    if (!getHeadersList().equals(other.getHeadersList())) return false;
    if (!getRowsList().equals(other.getRowsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getHeadersCount() > 0) {
      hash = (37 * hash) + HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getHeadersList().hashCode();
    }
    if (getRowsCount() > 0) {
      hash = (37 * hash) + ROWS_FIELD_NUMBER;
      hash = (53 * hash) + getRowsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.Table parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Table parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Table parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Table parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Table parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Table parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Table parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Table parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Table parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Table parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Table parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Table parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.Table prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Structured content to inspect. Up to 50,000 `Value`s per request allowed. See
   * https://cloud.google.com/sensitive-data-protection/docs/inspecting-structured-text#inspecting_a_table
   * to learn more.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.Table}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.Table)
      com.google.privacy.dlp.v2.TableOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Table_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Table_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.Table.class, com.google.privacy.dlp.v2.Table.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.Table.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (headersBuilder_ == null) {
        headers_ = java.util.Collections.emptyList();
      } else {
        headers_ = null;
        headersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (rowsBuilder_ == null) {
        rows_ = java.util.Collections.emptyList();
      } else {
        rows_ = null;
        rowsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Table_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Table getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.Table.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Table build() {
      com.google.privacy.dlp.v2.Table result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Table buildPartial() {
      com.google.privacy.dlp.v2.Table result = new com.google.privacy.dlp.v2.Table(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.privacy.dlp.v2.Table result) {
      if (headersBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          headers_ = java.util.Collections.unmodifiableList(headers_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.headers_ = headers_;
      } else {
        result.headers_ = headersBuilder_.build();
      }
      if (rowsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          rows_ = java.util.Collections.unmodifiableList(rows_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.rows_ = rows_;
      } else {
        result.rows_ = rowsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.privacy.dlp.v2.Table result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.Table) {
        return mergeFrom((com.google.privacy.dlp.v2.Table) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.Table other) {
      if (other == com.google.privacy.dlp.v2.Table.getDefaultInstance()) return this;
      if (headersBuilder_ == null) {
        if (!other.headers_.isEmpty()) {
          if (headers_.isEmpty()) {
            headers_ = other.headers_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureHeadersIsMutable();
            headers_.addAll(other.headers_);
          }
          onChanged();
        }
      } else {
        if (!other.headers_.isEmpty()) {
          if (headersBuilder_.isEmpty()) {
            headersBuilder_.dispose();
            headersBuilder_ = null;
            headers_ = other.headers_;
            bitField0_ = (bitField0_ & ~0x00000001);
            headersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getHeadersFieldBuilder()
                    : null;
          } else {
            headersBuilder_.addAllMessages(other.headers_);
          }
        }
      }
      if (rowsBuilder_ == null) {
        if (!other.rows_.isEmpty()) {
          if (rows_.isEmpty()) {
            rows_ = other.rows_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureRowsIsMutable();
            rows_.addAll(other.rows_);
          }
          onChanged();
        }
      } else {
        if (!other.rows_.isEmpty()) {
          if (rowsBuilder_.isEmpty()) {
            rowsBuilder_.dispose();
            rowsBuilder_ = null;
            rows_ = other.rows_;
            bitField0_ = (bitField0_ & ~0x00000002);
            rowsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRowsFieldBuilder()
                    : null;
          } else {
            rowsBuilder_.addAllMessages(other.rows_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.privacy.dlp.v2.FieldId m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.FieldId.parser(), extensionRegistry);
                if (headersBuilder_ == null) {
                  ensureHeadersIsMutable();
                  headers_.add(m);
                } else {
                  headersBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.privacy.dlp.v2.Table.Row m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.Table.Row.parser(), extensionRegistry);
                if (rowsBuilder_ == null) {
                  ensureRowsIsMutable();
                  rows_.add(m);
                } else {
                  rowsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.privacy.dlp.v2.FieldId> headers_ =
        java.util.Collections.emptyList();

    private void ensureHeadersIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        headers_ = new java.util.ArrayList<com.google.privacy.dlp.v2.FieldId>(headers_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        headersBuilder_;

    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.FieldId> getHeadersList() {
      if (headersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(headers_);
      } else {
        return headersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public int getHeadersCount() {
      if (headersBuilder_ == null) {
        return headers_.size();
      } else {
        return headersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public com.google.privacy.dlp.v2.FieldId getHeaders(int index) {
      if (headersBuilder_ == null) {
        return headers_.get(index);
      } else {
        return headersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public Builder setHeaders(int index, com.google.privacy.dlp.v2.FieldId value) {
      if (headersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHeadersIsMutable();
        headers_.set(index, value);
        onChanged();
      } else {
        headersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public Builder setHeaders(
        int index, com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (headersBuilder_ == null) {
        ensureHeadersIsMutable();
        headers_.set(index, builderForValue.build());
        onChanged();
      } else {
        headersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public Builder addHeaders(com.google.privacy.dlp.v2.FieldId value) {
      if (headersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHeadersIsMutable();
        headers_.add(value);
        onChanged();
      } else {
        headersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public Builder addHeaders(int index, com.google.privacy.dlp.v2.FieldId value) {
      if (headersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHeadersIsMutable();
        headers_.add(index, value);
        onChanged();
      } else {
        headersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public Builder addHeaders(com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (headersBuilder_ == null) {
        ensureHeadersIsMutable();
        headers_.add(builderForValue.build());
        onChanged();
      } else {
        headersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public Builder addHeaders(
        int index, com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (headersBuilder_ == null) {
        ensureHeadersIsMutable();
        headers_.add(index, builderForValue.build());
        onChanged();
      } else {
        headersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public Builder addAllHeaders(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.FieldId> values) {
      if (headersBuilder_ == null) {
        ensureHeadersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, headers_);
        onChanged();
      } else {
        headersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public Builder clearHeaders() {
      if (headersBuilder_ == null) {
        headers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        headersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public Builder removeHeaders(int index) {
      if (headersBuilder_ == null) {
        ensureHeadersIsMutable();
        headers_.remove(index);
        onChanged();
      } else {
        headersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder getHeadersBuilder(int index) {
      return getHeadersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public com.google.privacy.dlp.v2.FieldIdOrBuilder getHeadersOrBuilder(int index) {
      if (headersBuilder_ == null) {
        return headers_.get(index);
      } else {
        return headersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.FieldIdOrBuilder>
        getHeadersOrBuilderList() {
      if (headersBuilder_ != null) {
        return headersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(headers_);
      }
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder addHeadersBuilder() {
      return getHeadersFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.FieldId.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder addHeadersBuilder(int index) {
      return getHeadersFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.FieldId.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Headers of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId headers = 1;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.FieldId.Builder> getHeadersBuilderList() {
      return getHeadersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        getHeadersFieldBuilder() {
      if (headersBuilder_ == null) {
        headersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.FieldId,
                com.google.privacy.dlp.v2.FieldId.Builder,
                com.google.privacy.dlp.v2.FieldIdOrBuilder>(
                headers_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        headers_ = null;
      }
      return headersBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.Table.Row> rows_ =
        java.util.Collections.emptyList();

    private void ensureRowsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        rows_ = new java.util.ArrayList<com.google.privacy.dlp.v2.Table.Row>(rows_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.Table.Row,
            com.google.privacy.dlp.v2.Table.Row.Builder,
            com.google.privacy.dlp.v2.Table.RowOrBuilder>
        rowsBuilder_;

    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.Table.Row> getRowsList() {
      if (rowsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rows_);
      } else {
        return rowsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public int getRowsCount() {
      if (rowsBuilder_ == null) {
        return rows_.size();
      } else {
        return rowsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public com.google.privacy.dlp.v2.Table.Row getRows(int index) {
      if (rowsBuilder_ == null) {
        return rows_.get(index);
      } else {
        return rowsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public Builder setRows(int index, com.google.privacy.dlp.v2.Table.Row value) {
      if (rowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowsIsMutable();
        rows_.set(index, value);
        onChanged();
      } else {
        rowsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public Builder setRows(int index, com.google.privacy.dlp.v2.Table.Row.Builder builderForValue) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        rows_.set(index, builderForValue.build());
        onChanged();
      } else {
        rowsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public Builder addRows(com.google.privacy.dlp.v2.Table.Row value) {
      if (rowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowsIsMutable();
        rows_.add(value);
        onChanged();
      } else {
        rowsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public Builder addRows(int index, com.google.privacy.dlp.v2.Table.Row value) {
      if (rowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowsIsMutable();
        rows_.add(index, value);
        onChanged();
      } else {
        rowsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public Builder addRows(com.google.privacy.dlp.v2.Table.Row.Builder builderForValue) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        rows_.add(builderForValue.build());
        onChanged();
      } else {
        rowsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public Builder addRows(int index, com.google.privacy.dlp.v2.Table.Row.Builder builderForValue) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        rows_.add(index, builderForValue.build());
        onChanged();
      } else {
        rowsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public Builder addAllRows(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.Table.Row> values) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rows_);
        onChanged();
      } else {
        rowsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public Builder clearRows() {
      if (rowsBuilder_ == null) {
        rows_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        rowsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public Builder removeRows(int index) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        rows_.remove(index);
        onChanged();
      } else {
        rowsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public com.google.privacy.dlp.v2.Table.Row.Builder getRowsBuilder(int index) {
      return getRowsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public com.google.privacy.dlp.v2.Table.RowOrBuilder getRowsOrBuilder(int index) {
      if (rowsBuilder_ == null) {
        return rows_.get(index);
      } else {
        return rowsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.Table.RowOrBuilder>
        getRowsOrBuilderList() {
      if (rowsBuilder_ != null) {
        return rowsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rows_);
      }
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public com.google.privacy.dlp.v2.Table.Row.Builder addRowsBuilder() {
      return getRowsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.Table.Row.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public com.google.privacy.dlp.v2.Table.Row.Builder addRowsBuilder(int index) {
      return getRowsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.Table.Row.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Rows of the table.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Table.Row rows = 2;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.Table.Row.Builder> getRowsBuilderList() {
      return getRowsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.Table.Row,
            com.google.privacy.dlp.v2.Table.Row.Builder,
            com.google.privacy.dlp.v2.Table.RowOrBuilder>
        getRowsFieldBuilder() {
      if (rowsBuilder_ == null) {
        rowsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.Table.Row,
                com.google.privacy.dlp.v2.Table.Row.Builder,
                com.google.privacy.dlp.v2.Table.RowOrBuilder>(
                rows_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        rows_ = null;
      }
      return rowsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.Table)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.Table)
  private static final com.google.privacy.dlp.v2.Table DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.Table();
  }

  public static com.google.privacy.dlp.v2.Table getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Table> PARSER =
      new com.google.protobuf.AbstractParser<Table>() {
        @java.lang.Override
        public Table parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Table> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Table> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.Table getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
