/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * The profile for a scanned table.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.TableDataProfile}
 */
public final class TableDataProfile extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.TableDataProfile)
    TableDataProfileOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TableDataProfile.newBuilder() to construct.
  private TableDataProfile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TableDataProfile() {
    name_ = "";
    projectDataProfile_ = "";
    datasetProjectId_ = "";
    datasetLocation_ = "";
    datasetId_ = "";
    tableId_ = "";
    fullResource_ = "";
    state_ = 0;
    predictedInfoTypes_ = java.util.Collections.emptyList();
    otherInfoTypes_ = java.util.Collections.emptyList();
    encryptionStatus_ = 0;
    resourceVisibility_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TableDataProfile();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_TableDataProfile_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 17:
        return internalGetResourceLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_TableDataProfile_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.TableDataProfile.class,
            com.google.privacy.dlp.v2.TableDataProfile.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states of a profile. New items may be added.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.TableDataProfile.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The profile is currently running. Once a profile has finished it will
     * transition to DONE.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    RUNNING(1),
    /**
     *
     *
     * <pre>
     * The profile is no longer generating.
     * If profile_status.status.code is 0, the profile succeeded, otherwise, it
     * failed.
     * </pre>
     *
     * <code>DONE = 2;</code>
     */
    DONE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The profile is currently running. Once a profile has finished it will
     * transition to DONE.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    public static final int RUNNING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The profile is no longer generating.
     * If profile_status.status.code is 0, the profile succeeded, otherwise, it
     * failed.
     * </pre>
     *
     * <code>DONE = 2;</code>
     */
    public static final int DONE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return RUNNING;
        case 2:
          return DONE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.TableDataProfile.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.TableDataProfile.State)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of the profile.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the profile.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_SOURCE_TYPE_FIELD_NUMBER = 36;
  private com.google.privacy.dlp.v2.DataSourceType dataSourceType_;
  /**
   *
   *
   * <pre>
   * The resource type that was profiled.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataSourceType data_source_type = 36;</code>
   *
   * @return Whether the dataSourceType field is set.
   */
  @java.lang.Override
  public boolean hasDataSourceType() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The resource type that was profiled.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataSourceType data_source_type = 36;</code>
   *
   * @return The dataSourceType.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataSourceType getDataSourceType() {
    return dataSourceType_ == null
        ? com.google.privacy.dlp.v2.DataSourceType.getDefaultInstance()
        : dataSourceType_;
  }
  /**
   *
   *
   * <pre>
   * The resource type that was profiled.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataSourceType data_source_type = 36;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataSourceTypeOrBuilder getDataSourceTypeOrBuilder() {
    return dataSourceType_ == null
        ? com.google.privacy.dlp.v2.DataSourceType.getDefaultInstance()
        : dataSourceType_;
  }

  public static final int PROJECT_DATA_PROFILE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectDataProfile_ = "";
  /**
   *
   *
   * <pre>
   * The resource name to the project data profile for this table.
   * </pre>
   *
   * <code>string project_data_profile = 2;</code>
   *
   * @return The projectDataProfile.
   */
  @java.lang.Override
  public java.lang.String getProjectDataProfile() {
    java.lang.Object ref = projectDataProfile_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectDataProfile_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name to the project data profile for this table.
   * </pre>
   *
   * <code>string project_data_profile = 2;</code>
   *
   * @return The bytes for projectDataProfile.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectDataProfileBytes() {
    java.lang.Object ref = projectDataProfile_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectDataProfile_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATASET_PROJECT_ID_FIELD_NUMBER = 24;

  @SuppressWarnings("serial")
  private volatile java.lang.Object datasetProjectId_ = "";
  /**
   *
   *
   * <pre>
   * The Google Cloud project ID that owns the resource.
   * </pre>
   *
   * <code>string dataset_project_id = 24;</code>
   *
   * @return The datasetProjectId.
   */
  @java.lang.Override
  public java.lang.String getDatasetProjectId() {
    java.lang.Object ref = datasetProjectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      datasetProjectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud project ID that owns the resource.
   * </pre>
   *
   * <code>string dataset_project_id = 24;</code>
   *
   * @return The bytes for datasetProjectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatasetProjectIdBytes() {
    java.lang.Object ref = datasetProjectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      datasetProjectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATASET_LOCATION_FIELD_NUMBER = 29;

  @SuppressWarnings("serial")
  private volatile java.lang.Object datasetLocation_ = "";
  /**
   *
   *
   * <pre>
   * If supported, the location where the dataset's data is stored.
   * See https://cloud.google.com/bigquery/docs/locations for supported
   * locations.
   * </pre>
   *
   * <code>string dataset_location = 29;</code>
   *
   * @return The datasetLocation.
   */
  @java.lang.Override
  public java.lang.String getDatasetLocation() {
    java.lang.Object ref = datasetLocation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      datasetLocation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If supported, the location where the dataset's data is stored.
   * See https://cloud.google.com/bigquery/docs/locations for supported
   * locations.
   * </pre>
   *
   * <code>string dataset_location = 29;</code>
   *
   * @return The bytes for datasetLocation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatasetLocationBytes() {
    java.lang.Object ref = datasetLocation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      datasetLocation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATASET_ID_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private volatile java.lang.Object datasetId_ = "";
  /**
   *
   *
   * <pre>
   * If the resource is BigQuery, the  dataset ID.
   * </pre>
   *
   * <code>string dataset_id = 25;</code>
   *
   * @return The datasetId.
   */
  @java.lang.Override
  public java.lang.String getDatasetId() {
    java.lang.Object ref = datasetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      datasetId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If the resource is BigQuery, the  dataset ID.
   * </pre>
   *
   * <code>string dataset_id = 25;</code>
   *
   * @return The bytes for datasetId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatasetIdBytes() {
    java.lang.Object ref = datasetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      datasetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TABLE_ID_FIELD_NUMBER = 26;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tableId_ = "";
  /**
   *
   *
   * <pre>
   * If the resource is BigQuery, the BigQuery table ID.
   * </pre>
   *
   * <code>string table_id = 26;</code>
   *
   * @return The tableId.
   */
  @java.lang.Override
  public java.lang.String getTableId() {
    java.lang.Object ref = tableId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tableId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If the resource is BigQuery, the BigQuery table ID.
   * </pre>
   *
   * <code>string table_id = 26;</code>
   *
   * @return The bytes for tableId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableIdBytes() {
    java.lang.Object ref = tableId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tableId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FULL_RESOURCE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fullResource_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the resource profiled.
   * https://cloud.google.com/apis/design/resource_names#full_resource_name
   * </pre>
   *
   * <code>string full_resource = 3;</code>
   *
   * @return The fullResource.
   */
  @java.lang.Override
  public java.lang.String getFullResource() {
    java.lang.Object ref = fullResource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fullResource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the resource profiled.
   * https://cloud.google.com/apis/design/resource_names#full_resource_name
   * </pre>
   *
   * <code>string full_resource = 3;</code>
   *
   * @return The bytes for fullResource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFullResourceBytes() {
    java.lang.Object ref = fullResource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fullResource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROFILE_STATUS_FIELD_NUMBER = 21;
  private com.google.privacy.dlp.v2.ProfileStatus profileStatus_;
  /**
   *
   *
   * <pre>
   * Success or error status from the most recent profile generation attempt.
   * May be empty if the profile is still being generated.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 21;</code>
   *
   * @return Whether the profileStatus field is set.
   */
  @java.lang.Override
  public boolean hasProfileStatus() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Success or error status from the most recent profile generation attempt.
   * May be empty if the profile is still being generated.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 21;</code>
   *
   * @return The profileStatus.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ProfileStatus getProfileStatus() {
    return profileStatus_ == null
        ? com.google.privacy.dlp.v2.ProfileStatus.getDefaultInstance()
        : profileStatus_;
  }
  /**
   *
   *
   * <pre>
   * Success or error status from the most recent profile generation attempt.
   * May be empty if the profile is still being generated.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 21;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ProfileStatusOrBuilder getProfileStatusOrBuilder() {
    return profileStatus_ == null
        ? com.google.privacy.dlp.v2.ProfileStatus.getDefaultInstance()
        : profileStatus_;
  }

  public static final int STATE_FIELD_NUMBER = 22;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * State of a profile.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TableDataProfile.State state = 22;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * State of a profile.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TableDataProfile.State state = 22;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TableDataProfile.State getState() {
    com.google.privacy.dlp.v2.TableDataProfile.State result =
        com.google.privacy.dlp.v2.TableDataProfile.State.forNumber(state_);
    return result == null ? com.google.privacy.dlp.v2.TableDataProfile.State.UNRECOGNIZED : result;
  }

  public static final int SENSITIVITY_SCORE_FIELD_NUMBER = 5;
  private com.google.privacy.dlp.v2.SensitivityScore sensitivityScore_;
  /**
   *
   *
   * <pre>
   * The sensitivity score of this table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 5;</code>
   *
   * @return Whether the sensitivityScore field is set.
   */
  @java.lang.Override
  public boolean hasSensitivityScore() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The sensitivity score of this table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 5;</code>
   *
   * @return The sensitivityScore.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.SensitivityScore getSensitivityScore() {
    return sensitivityScore_ == null
        ? com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()
        : sensitivityScore_;
  }
  /**
   *
   *
   * <pre>
   * The sensitivity score of this table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 5;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.SensitivityScoreOrBuilder getSensitivityScoreOrBuilder() {
    return sensitivityScore_ == null
        ? com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()
        : sensitivityScore_;
  }

  public static final int DATA_RISK_LEVEL_FIELD_NUMBER = 6;
  private com.google.privacy.dlp.v2.DataRiskLevel dataRiskLevel_;
  /**
   *
   *
   * <pre>
   * The data risk level of this table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 6;</code>
   *
   * @return Whether the dataRiskLevel field is set.
   */
  @java.lang.Override
  public boolean hasDataRiskLevel() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The data risk level of this table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 6;</code>
   *
   * @return The dataRiskLevel.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataRiskLevel getDataRiskLevel() {
    return dataRiskLevel_ == null
        ? com.google.privacy.dlp.v2.DataRiskLevel.getDefaultInstance()
        : dataRiskLevel_;
  }
  /**
   *
   *
   * <pre>
   * The data risk level of this table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 6;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataRiskLevelOrBuilder getDataRiskLevelOrBuilder() {
    return dataRiskLevel_ == null
        ? com.google.privacy.dlp.v2.DataRiskLevel.getDefaultInstance()
        : dataRiskLevel_;
  }

  public static final int PREDICTED_INFO_TYPES_FIELD_NUMBER = 27;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.InfoTypeSummary> predictedInfoTypes_;
  /**
   *
   *
   * <pre>
   * The infoTypes predicted from this table's data.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.InfoTypeSummary> getPredictedInfoTypesList() {
    return predictedInfoTypes_;
  }
  /**
   *
   *
   * <pre>
   * The infoTypes predicted from this table's data.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.InfoTypeSummaryOrBuilder>
      getPredictedInfoTypesOrBuilderList() {
    return predictedInfoTypes_;
  }
  /**
   *
   *
   * <pre>
   * The infoTypes predicted from this table's data.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
   */
  @java.lang.Override
  public int getPredictedInfoTypesCount() {
    return predictedInfoTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * The infoTypes predicted from this table's data.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeSummary getPredictedInfoTypes(int index) {
    return predictedInfoTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The infoTypes predicted from this table's data.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeSummaryOrBuilder getPredictedInfoTypesOrBuilder(
      int index) {
    return predictedInfoTypes_.get(index);
  }

  public static final int OTHER_INFO_TYPES_FIELD_NUMBER = 28;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.OtherInfoTypeSummary> otherInfoTypes_;
  /**
   *
   *
   * <pre>
   * Other infoTypes found in this table's data.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.OtherInfoTypeSummary> getOtherInfoTypesList() {
    return otherInfoTypes_;
  }
  /**
   *
   *
   * <pre>
   * Other infoTypes found in this table's data.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.OtherInfoTypeSummaryOrBuilder>
      getOtherInfoTypesOrBuilderList() {
    return otherInfoTypes_;
  }
  /**
   *
   *
   * <pre>
   * Other infoTypes found in this table's data.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
   */
  @java.lang.Override
  public int getOtherInfoTypesCount() {
    return otherInfoTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Other infoTypes found in this table's data.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.OtherInfoTypeSummary getOtherInfoTypes(int index) {
    return otherInfoTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Other infoTypes found in this table's data.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.OtherInfoTypeSummaryOrBuilder getOtherInfoTypesOrBuilder(
      int index) {
    return otherInfoTypes_.get(index);
  }

  public static final int CONFIG_SNAPSHOT_FIELD_NUMBER = 7;
  private com.google.privacy.dlp.v2.DataProfileConfigSnapshot configSnapshot_;
  /**
   *
   *
   * <pre>
   * The snapshot of the configurations used to generate the profile.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfileConfigSnapshot config_snapshot = 7;</code>
   *
   * @return Whether the configSnapshot field is set.
   */
  @java.lang.Override
  public boolean hasConfigSnapshot() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The snapshot of the configurations used to generate the profile.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfileConfigSnapshot config_snapshot = 7;</code>
   *
   * @return The configSnapshot.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfileConfigSnapshot getConfigSnapshot() {
    return configSnapshot_ == null
        ? com.google.privacy.dlp.v2.DataProfileConfigSnapshot.getDefaultInstance()
        : configSnapshot_;
  }
  /**
   *
   *
   * <pre>
   * The snapshot of the configurations used to generate the profile.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfileConfigSnapshot config_snapshot = 7;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfileConfigSnapshotOrBuilder getConfigSnapshotOrBuilder() {
    return configSnapshot_ == null
        ? com.google.privacy.dlp.v2.DataProfileConfigSnapshot.getDefaultInstance()
        : configSnapshot_;
  }

  public static final int LAST_MODIFIED_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp lastModifiedTime_;
  /**
   *
   *
   * <pre>
   * The time when this table was last modified
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_modified_time = 8;</code>
   *
   * @return Whether the lastModifiedTime field is set.
   */
  @java.lang.Override
  public boolean hasLastModifiedTime() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time when this table was last modified
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_modified_time = 8;</code>
   *
   * @return The lastModifiedTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastModifiedTime() {
    return lastModifiedTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastModifiedTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when this table was last modified
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_modified_time = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastModifiedTimeOrBuilder() {
    return lastModifiedTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastModifiedTime_;
  }

  public static final int EXPIRATION_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp expirationTime_;
  /**
   *
   *
   * <pre>
   * Optional. The time when this table expires.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expiration_time = 9;</code>
   *
   * @return Whether the expirationTime field is set.
   */
  @java.lang.Override
  public boolean hasExpirationTime() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The time when this table expires.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expiration_time = 9;</code>
   *
   * @return The expirationTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpirationTime() {
    return expirationTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : expirationTime_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The time when this table expires.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expiration_time = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpirationTimeOrBuilder() {
    return expirationTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : expirationTime_;
  }

  public static final int SCANNED_COLUMN_COUNT_FIELD_NUMBER = 10;
  private long scannedColumnCount_ = 0L;
  /**
   *
   *
   * <pre>
   * The number of columns profiled in the table.
   * </pre>
   *
   * <code>int64 scanned_column_count = 10;</code>
   *
   * @return The scannedColumnCount.
   */
  @java.lang.Override
  public long getScannedColumnCount() {
    return scannedColumnCount_;
  }

  public static final int FAILED_COLUMN_COUNT_FIELD_NUMBER = 11;
  private long failedColumnCount_ = 0L;
  /**
   *
   *
   * <pre>
   * The number of columns skipped in the table because of an error.
   * </pre>
   *
   * <code>int64 failed_column_count = 11;</code>
   *
   * @return The failedColumnCount.
   */
  @java.lang.Override
  public long getFailedColumnCount() {
    return failedColumnCount_;
  }

  public static final int TABLE_SIZE_BYTES_FIELD_NUMBER = 12;
  private long tableSizeBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * The size of the table when the profile was generated.
   * </pre>
   *
   * <code>int64 table_size_bytes = 12;</code>
   *
   * @return The tableSizeBytes.
   */
  @java.lang.Override
  public long getTableSizeBytes() {
    return tableSizeBytes_;
  }

  public static final int ROW_COUNT_FIELD_NUMBER = 13;
  private long rowCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Number of rows in the table when the profile was generated.
   * This will not be populated for BigLake tables.
   * </pre>
   *
   * <code>int64 row_count = 13;</code>
   *
   * @return The rowCount.
   */
  @java.lang.Override
  public long getRowCount() {
    return rowCount_;
  }

  public static final int ENCRYPTION_STATUS_FIELD_NUMBER = 14;
  private int encryptionStatus_ = 0;
  /**
   *
   *
   * <pre>
   * How the table is encrypted.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.EncryptionStatus encryption_status = 14;</code>
   *
   * @return The enum numeric value on the wire for encryptionStatus.
   */
  @java.lang.Override
  public int getEncryptionStatusValue() {
    return encryptionStatus_;
  }
  /**
   *
   *
   * <pre>
   * How the table is encrypted.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.EncryptionStatus encryption_status = 14;</code>
   *
   * @return The encryptionStatus.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.EncryptionStatus getEncryptionStatus() {
    com.google.privacy.dlp.v2.EncryptionStatus result =
        com.google.privacy.dlp.v2.EncryptionStatus.forNumber(encryptionStatus_);
    return result == null ? com.google.privacy.dlp.v2.EncryptionStatus.UNRECOGNIZED : result;
  }

  public static final int RESOURCE_VISIBILITY_FIELD_NUMBER = 15;
  private int resourceVisibility_ = 0;
  /**
   *
   *
   * <pre>
   * How broadly a resource has been shared.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ResourceVisibility resource_visibility = 15;</code>
   *
   * @return The enum numeric value on the wire for resourceVisibility.
   */
  @java.lang.Override
  public int getResourceVisibilityValue() {
    return resourceVisibility_;
  }
  /**
   *
   *
   * <pre>
   * How broadly a resource has been shared.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ResourceVisibility resource_visibility = 15;</code>
   *
   * @return The resourceVisibility.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ResourceVisibility getResourceVisibility() {
    com.google.privacy.dlp.v2.ResourceVisibility result =
        com.google.privacy.dlp.v2.ResourceVisibility.forNumber(resourceVisibility_);
    return result == null ? com.google.privacy.dlp.v2.ResourceVisibility.UNRECOGNIZED : result;
  }

  public static final int PROFILE_LAST_GENERATED_FIELD_NUMBER = 16;
  private com.google.protobuf.Timestamp profileLastGenerated_;
  /**
   *
   *
   * <pre>
   * The last time the profile was generated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp profile_last_generated = 16;</code>
   *
   * @return Whether the profileLastGenerated field is set.
   */
  @java.lang.Override
  public boolean hasProfileLastGenerated() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * The last time the profile was generated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp profile_last_generated = 16;</code>
   *
   * @return The profileLastGenerated.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getProfileLastGenerated() {
    return profileLastGenerated_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : profileLastGenerated_;
  }
  /**
   *
   *
   * <pre>
   * The last time the profile was generated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp profile_last_generated = 16;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getProfileLastGeneratedOrBuilder() {
    return profileLastGenerated_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : profileLastGenerated_;
  }

  public static final int RESOURCE_LABELS_FIELD_NUMBER = 17;

  private static final class ResourceLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.privacy.dlp.v2.DlpProto
                .internal_static_google_privacy_dlp_v2_TableDataProfile_ResourceLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> resourceLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetResourceLabels() {
    if (resourceLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ResourceLabelsDefaultEntryHolder.defaultEntry);
    }
    return resourceLabels_;
  }

  public int getResourceLabelsCount() {
    return internalGetResourceLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels applied to the resource at the time the profile was generated.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 17;</code>
   */
  @java.lang.Override
  public boolean containsResourceLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetResourceLabels().getMap().containsKey(key);
  }
  /** Use {@link #getResourceLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getResourceLabels() {
    return getResourceLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels applied to the resource at the time the profile was generated.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 17;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getResourceLabelsMap() {
    return internalGetResourceLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels applied to the resource at the time the profile was generated.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 17;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getResourceLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetResourceLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels applied to the resource at the time the profile was generated.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 17;</code>
   */
  @java.lang.Override
  public java.lang.String getResourceLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetResourceLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 23;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time at which the table was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 23;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time at which the table was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 23;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the table was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 23;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectDataProfile_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, projectDataProfile_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullResource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, fullResource_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getSensitivityScore());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(6, getDataRiskLevel());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(7, getConfigSnapshot());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(8, getLastModifiedTime());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(9, getExpirationTime());
    }
    if (scannedColumnCount_ != 0L) {
      output.writeInt64(10, scannedColumnCount_);
    }
    if (failedColumnCount_ != 0L) {
      output.writeInt64(11, failedColumnCount_);
    }
    if (tableSizeBytes_ != 0L) {
      output.writeInt64(12, tableSizeBytes_);
    }
    if (rowCount_ != 0L) {
      output.writeInt64(13, rowCount_);
    }
    if (encryptionStatus_
        != com.google.privacy.dlp.v2.EncryptionStatus.ENCRYPTION_STATUS_UNSPECIFIED.getNumber()) {
      output.writeEnum(14, encryptionStatus_);
    }
    if (resourceVisibility_
        != com.google.privacy.dlp.v2.ResourceVisibility.RESOURCE_VISIBILITY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(15, resourceVisibility_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(16, getProfileLastGenerated());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetResourceLabels(), ResourceLabelsDefaultEntryHolder.defaultEntry, 17);
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(21, getProfileStatus());
    }
    if (state_ != com.google.privacy.dlp.v2.TableDataProfile.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(22, state_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(23, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetProjectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 24, datasetProjectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, datasetId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 26, tableId_);
    }
    for (int i = 0; i < predictedInfoTypes_.size(); i++) {
      output.writeMessage(27, predictedInfoTypes_.get(i));
    }
    for (int i = 0; i < otherInfoTypes_.size(); i++) {
      output.writeMessage(28, otherInfoTypes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetLocation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 29, datasetLocation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(36, getDataSourceType());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectDataProfile_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, projectDataProfile_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullResource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, fullResource_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getSensitivityScore());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDataRiskLevel());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getConfigSnapshot());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getLastModifiedTime());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getExpirationTime());
    }
    if (scannedColumnCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(10, scannedColumnCount_);
    }
    if (failedColumnCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(11, failedColumnCount_);
    }
    if (tableSizeBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(12, tableSizeBytes_);
    }
    if (rowCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(13, rowCount_);
    }
    if (encryptionStatus_
        != com.google.privacy.dlp.v2.EncryptionStatus.ENCRYPTION_STATUS_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(14, encryptionStatus_);
    }
    if (resourceVisibility_
        != com.google.privacy.dlp.v2.ResourceVisibility.RESOURCE_VISIBILITY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, resourceVisibility_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(16, getProfileLastGenerated());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetResourceLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> resourceLabels__ =
          ResourceLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, resourceLabels__);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getProfileStatus());
    }
    if (state_ != com.google.privacy.dlp.v2.TableDataProfile.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(22, state_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetProjectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(24, datasetProjectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(25, datasetId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(26, tableId_);
    }
    for (int i = 0; i < predictedInfoTypes_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(27, predictedInfoTypes_.get(i));
    }
    for (int i = 0; i < otherInfoTypes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(28, otherInfoTypes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetLocation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(29, datasetLocation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(36, getDataSourceType());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.TableDataProfile)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.TableDataProfile other =
        (com.google.privacy.dlp.v2.TableDataProfile) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasDataSourceType() != other.hasDataSourceType()) return false;
    if (hasDataSourceType()) {
      if (!getDataSourceType().equals(other.getDataSourceType())) return false;
    }
    if (!getProjectDataProfile().equals(other.getProjectDataProfile())) return false;
    if (!getDatasetProjectId().equals(other.getDatasetProjectId())) return false;
    if (!getDatasetLocation().equals(other.getDatasetLocation())) return false;
    if (!getDatasetId().equals(other.getDatasetId())) return false;
    if (!getTableId().equals(other.getTableId())) return false;
    if (!getFullResource().equals(other.getFullResource())) return false;
    if (hasProfileStatus() != other.hasProfileStatus()) return false;
    if (hasProfileStatus()) {
      if (!getProfileStatus().equals(other.getProfileStatus())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasSensitivityScore() != other.hasSensitivityScore()) return false;
    if (hasSensitivityScore()) {
      if (!getSensitivityScore().equals(other.getSensitivityScore())) return false;
    }
    if (hasDataRiskLevel() != other.hasDataRiskLevel()) return false;
    if (hasDataRiskLevel()) {
      if (!getDataRiskLevel().equals(other.getDataRiskLevel())) return false;
    }
    if (!getPredictedInfoTypesList().equals(other.getPredictedInfoTypesList())) return false;
    if (!getOtherInfoTypesList().equals(other.getOtherInfoTypesList())) return false;
    if (hasConfigSnapshot() != other.hasConfigSnapshot()) return false;
    if (hasConfigSnapshot()) {
      if (!getConfigSnapshot().equals(other.getConfigSnapshot())) return false;
    }
    if (hasLastModifiedTime() != other.hasLastModifiedTime()) return false;
    if (hasLastModifiedTime()) {
      if (!getLastModifiedTime().equals(other.getLastModifiedTime())) return false;
    }
    if (hasExpirationTime() != other.hasExpirationTime()) return false;
    if (hasExpirationTime()) {
      if (!getExpirationTime().equals(other.getExpirationTime())) return false;
    }
    if (getScannedColumnCount() != other.getScannedColumnCount()) return false;
    if (getFailedColumnCount() != other.getFailedColumnCount()) return false;
    if (getTableSizeBytes() != other.getTableSizeBytes()) return false;
    if (getRowCount() != other.getRowCount()) return false;
    if (encryptionStatus_ != other.encryptionStatus_) return false;
    if (resourceVisibility_ != other.resourceVisibility_) return false;
    if (hasProfileLastGenerated() != other.hasProfileLastGenerated()) return false;
    if (hasProfileLastGenerated()) {
      if (!getProfileLastGenerated().equals(other.getProfileLastGenerated())) return false;
    }
    if (!internalGetResourceLabels().equals(other.internalGetResourceLabels())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasDataSourceType()) {
      hash = (37 * hash) + DATA_SOURCE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getDataSourceType().hashCode();
    }
    hash = (37 * hash) + PROJECT_DATA_PROFILE_FIELD_NUMBER;
    hash = (53 * hash) + getProjectDataProfile().hashCode();
    hash = (37 * hash) + DATASET_PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDatasetProjectId().hashCode();
    hash = (37 * hash) + DATASET_LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getDatasetLocation().hashCode();
    hash = (37 * hash) + DATASET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDatasetId().hashCode();
    hash = (37 * hash) + TABLE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTableId().hashCode();
    hash = (37 * hash) + FULL_RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getFullResource().hashCode();
    if (hasProfileStatus()) {
      hash = (37 * hash) + PROFILE_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getProfileStatus().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasSensitivityScore()) {
      hash = (37 * hash) + SENSITIVITY_SCORE_FIELD_NUMBER;
      hash = (53 * hash) + getSensitivityScore().hashCode();
    }
    if (hasDataRiskLevel()) {
      hash = (37 * hash) + DATA_RISK_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getDataRiskLevel().hashCode();
    }
    if (getPredictedInfoTypesCount() > 0) {
      hash = (37 * hash) + PREDICTED_INFO_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getPredictedInfoTypesList().hashCode();
    }
    if (getOtherInfoTypesCount() > 0) {
      hash = (37 * hash) + OTHER_INFO_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getOtherInfoTypesList().hashCode();
    }
    if (hasConfigSnapshot()) {
      hash = (37 * hash) + CONFIG_SNAPSHOT_FIELD_NUMBER;
      hash = (53 * hash) + getConfigSnapshot().hashCode();
    }
    if (hasLastModifiedTime()) {
      hash = (37 * hash) + LAST_MODIFIED_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastModifiedTime().hashCode();
    }
    if (hasExpirationTime()) {
      hash = (37 * hash) + EXPIRATION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpirationTime().hashCode();
    }
    hash = (37 * hash) + SCANNED_COLUMN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getScannedColumnCount());
    hash = (37 * hash) + FAILED_COLUMN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getFailedColumnCount());
    hash = (37 * hash) + TABLE_SIZE_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTableSizeBytes());
    hash = (37 * hash) + ROW_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRowCount());
    hash = (37 * hash) + ENCRYPTION_STATUS_FIELD_NUMBER;
    hash = (53 * hash) + encryptionStatus_;
    hash = (37 * hash) + RESOURCE_VISIBILITY_FIELD_NUMBER;
    hash = (53 * hash) + resourceVisibility_;
    if (hasProfileLastGenerated()) {
      hash = (37 * hash) + PROFILE_LAST_GENERATED_FIELD_NUMBER;
      hash = (53 * hash) + getProfileLastGenerated().hashCode();
    }
    if (!internalGetResourceLabels().getMap().isEmpty()) {
      hash = (37 * hash) + RESOURCE_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetResourceLabels().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.TableDataProfile parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TableDataProfile parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TableDataProfile parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TableDataProfile parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TableDataProfile parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TableDataProfile parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TableDataProfile parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TableDataProfile parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TableDataProfile parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TableDataProfile parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TableDataProfile parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TableDataProfile parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.TableDataProfile prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The profile for a scanned table.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.TableDataProfile}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.TableDataProfile)
      com.google.privacy.dlp.v2.TableDataProfileOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TableDataProfile_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 17:
          return internalGetResourceLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 17:
          return internalGetMutableResourceLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TableDataProfile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.TableDataProfile.class,
              com.google.privacy.dlp.v2.TableDataProfile.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.TableDataProfile.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDataSourceTypeFieldBuilder();
        getProfileStatusFieldBuilder();
        getSensitivityScoreFieldBuilder();
        getDataRiskLevelFieldBuilder();
        getPredictedInfoTypesFieldBuilder();
        getOtherInfoTypesFieldBuilder();
        getConfigSnapshotFieldBuilder();
        getLastModifiedTimeFieldBuilder();
        getExpirationTimeFieldBuilder();
        getProfileLastGeneratedFieldBuilder();
        getCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      dataSourceType_ = null;
      if (dataSourceTypeBuilder_ != null) {
        dataSourceTypeBuilder_.dispose();
        dataSourceTypeBuilder_ = null;
      }
      projectDataProfile_ = "";
      datasetProjectId_ = "";
      datasetLocation_ = "";
      datasetId_ = "";
      tableId_ = "";
      fullResource_ = "";
      profileStatus_ = null;
      if (profileStatusBuilder_ != null) {
        profileStatusBuilder_.dispose();
        profileStatusBuilder_ = null;
      }
      state_ = 0;
      sensitivityScore_ = null;
      if (sensitivityScoreBuilder_ != null) {
        sensitivityScoreBuilder_.dispose();
        sensitivityScoreBuilder_ = null;
      }
      dataRiskLevel_ = null;
      if (dataRiskLevelBuilder_ != null) {
        dataRiskLevelBuilder_.dispose();
        dataRiskLevelBuilder_ = null;
      }
      if (predictedInfoTypesBuilder_ == null) {
        predictedInfoTypes_ = java.util.Collections.emptyList();
      } else {
        predictedInfoTypes_ = null;
        predictedInfoTypesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00001000);
      if (otherInfoTypesBuilder_ == null) {
        otherInfoTypes_ = java.util.Collections.emptyList();
      } else {
        otherInfoTypes_ = null;
        otherInfoTypesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      configSnapshot_ = null;
      if (configSnapshotBuilder_ != null) {
        configSnapshotBuilder_.dispose();
        configSnapshotBuilder_ = null;
      }
      lastModifiedTime_ = null;
      if (lastModifiedTimeBuilder_ != null) {
        lastModifiedTimeBuilder_.dispose();
        lastModifiedTimeBuilder_ = null;
      }
      expirationTime_ = null;
      if (expirationTimeBuilder_ != null) {
        expirationTimeBuilder_.dispose();
        expirationTimeBuilder_ = null;
      }
      scannedColumnCount_ = 0L;
      failedColumnCount_ = 0L;
      tableSizeBytes_ = 0L;
      rowCount_ = 0L;
      encryptionStatus_ = 0;
      resourceVisibility_ = 0;
      profileLastGenerated_ = null;
      if (profileLastGeneratedBuilder_ != null) {
        profileLastGeneratedBuilder_.dispose();
        profileLastGeneratedBuilder_ = null;
      }
      internalGetMutableResourceLabels().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TableDataProfile_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TableDataProfile getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.TableDataProfile.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TableDataProfile build() {
      com.google.privacy.dlp.v2.TableDataProfile result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TableDataProfile buildPartial() {
      com.google.privacy.dlp.v2.TableDataProfile result =
          new com.google.privacy.dlp.v2.TableDataProfile(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.privacy.dlp.v2.TableDataProfile result) {
      if (predictedInfoTypesBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)) {
          predictedInfoTypes_ = java.util.Collections.unmodifiableList(predictedInfoTypes_);
          bitField0_ = (bitField0_ & ~0x00001000);
        }
        result.predictedInfoTypes_ = predictedInfoTypes_;
      } else {
        result.predictedInfoTypes_ = predictedInfoTypesBuilder_.build();
      }
      if (otherInfoTypesBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          otherInfoTypes_ = java.util.Collections.unmodifiableList(otherInfoTypes_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.otherInfoTypes_ = otherInfoTypes_;
      } else {
        result.otherInfoTypes_ = otherInfoTypesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.privacy.dlp.v2.TableDataProfile result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dataSourceType_ =
            dataSourceTypeBuilder_ == null ? dataSourceType_ : dataSourceTypeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.projectDataProfile_ = projectDataProfile_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.datasetProjectId_ = datasetProjectId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.datasetLocation_ = datasetLocation_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.datasetId_ = datasetId_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.tableId_ = tableId_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.fullResource_ = fullResource_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.profileStatus_ =
            profileStatusBuilder_ == null ? profileStatus_ : profileStatusBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.sensitivityScore_ =
            sensitivityScoreBuilder_ == null ? sensitivityScore_ : sensitivityScoreBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.dataRiskLevel_ =
            dataRiskLevelBuilder_ == null ? dataRiskLevel_ : dataRiskLevelBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.configSnapshot_ =
            configSnapshotBuilder_ == null ? configSnapshot_ : configSnapshotBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.lastModifiedTime_ =
            lastModifiedTimeBuilder_ == null ? lastModifiedTime_ : lastModifiedTimeBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.expirationTime_ =
            expirationTimeBuilder_ == null ? expirationTime_ : expirationTimeBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.scannedColumnCount_ = scannedColumnCount_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.failedColumnCount_ = failedColumnCount_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.tableSizeBytes_ = tableSizeBytes_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.rowCount_ = rowCount_;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.encryptionStatus_ = encryptionStatus_;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.resourceVisibility_ = resourceVisibility_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.profileLastGenerated_ =
            profileLastGeneratedBuilder_ == null
                ? profileLastGenerated_
                : profileLastGeneratedBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.resourceLabels_ = internalGetResourceLabels();
        result.resourceLabels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.TableDataProfile) {
        return mergeFrom((com.google.privacy.dlp.v2.TableDataProfile) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.TableDataProfile other) {
      if (other == com.google.privacy.dlp.v2.TableDataProfile.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDataSourceType()) {
        mergeDataSourceType(other.getDataSourceType());
      }
      if (!other.getProjectDataProfile().isEmpty()) {
        projectDataProfile_ = other.projectDataProfile_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDatasetProjectId().isEmpty()) {
        datasetProjectId_ = other.datasetProjectId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDatasetLocation().isEmpty()) {
        datasetLocation_ = other.datasetLocation_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDatasetId().isEmpty()) {
        datasetId_ = other.datasetId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getTableId().isEmpty()) {
        tableId_ = other.tableId_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getFullResource().isEmpty()) {
        fullResource_ = other.fullResource_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasProfileStatus()) {
        mergeProfileStatus(other.getProfileStatus());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasSensitivityScore()) {
        mergeSensitivityScore(other.getSensitivityScore());
      }
      if (other.hasDataRiskLevel()) {
        mergeDataRiskLevel(other.getDataRiskLevel());
      }
      if (predictedInfoTypesBuilder_ == null) {
        if (!other.predictedInfoTypes_.isEmpty()) {
          if (predictedInfoTypes_.isEmpty()) {
            predictedInfoTypes_ = other.predictedInfoTypes_;
            bitField0_ = (bitField0_ & ~0x00001000);
          } else {
            ensurePredictedInfoTypesIsMutable();
            predictedInfoTypes_.addAll(other.predictedInfoTypes_);
          }
          onChanged();
        }
      } else {
        if (!other.predictedInfoTypes_.isEmpty()) {
          if (predictedInfoTypesBuilder_.isEmpty()) {
            predictedInfoTypesBuilder_.dispose();
            predictedInfoTypesBuilder_ = null;
            predictedInfoTypes_ = other.predictedInfoTypes_;
            bitField0_ = (bitField0_ & ~0x00001000);
            predictedInfoTypesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPredictedInfoTypesFieldBuilder()
                    : null;
          } else {
            predictedInfoTypesBuilder_.addAllMessages(other.predictedInfoTypes_);
          }
        }
      }
      if (otherInfoTypesBuilder_ == null) {
        if (!other.otherInfoTypes_.isEmpty()) {
          if (otherInfoTypes_.isEmpty()) {
            otherInfoTypes_ = other.otherInfoTypes_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureOtherInfoTypesIsMutable();
            otherInfoTypes_.addAll(other.otherInfoTypes_);
          }
          onChanged();
        }
      } else {
        if (!other.otherInfoTypes_.isEmpty()) {
          if (otherInfoTypesBuilder_.isEmpty()) {
            otherInfoTypesBuilder_.dispose();
            otherInfoTypesBuilder_ = null;
            otherInfoTypes_ = other.otherInfoTypes_;
            bitField0_ = (bitField0_ & ~0x00002000);
            otherInfoTypesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOtherInfoTypesFieldBuilder()
                    : null;
          } else {
            otherInfoTypesBuilder_.addAllMessages(other.otherInfoTypes_);
          }
        }
      }
      if (other.hasConfigSnapshot()) {
        mergeConfigSnapshot(other.getConfigSnapshot());
      }
      if (other.hasLastModifiedTime()) {
        mergeLastModifiedTime(other.getLastModifiedTime());
      }
      if (other.hasExpirationTime()) {
        mergeExpirationTime(other.getExpirationTime());
      }
      if (other.getScannedColumnCount() != 0L) {
        setScannedColumnCount(other.getScannedColumnCount());
      }
      if (other.getFailedColumnCount() != 0L) {
        setFailedColumnCount(other.getFailedColumnCount());
      }
      if (other.getTableSizeBytes() != 0L) {
        setTableSizeBytes(other.getTableSizeBytes());
      }
      if (other.getRowCount() != 0L) {
        setRowCount(other.getRowCount());
      }
      if (other.encryptionStatus_ != 0) {
        setEncryptionStatusValue(other.getEncryptionStatusValue());
      }
      if (other.resourceVisibility_ != 0) {
        setResourceVisibilityValue(other.getResourceVisibilityValue());
      }
      if (other.hasProfileLastGenerated()) {
        mergeProfileLastGenerated(other.getProfileLastGenerated());
      }
      internalGetMutableResourceLabels().mergeFrom(other.internalGetResourceLabels());
      bitField0_ |= 0x01000000;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                projectDataProfile_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                fullResource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(
                    getSensitivityScoreFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getDataRiskLevelFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getConfigSnapshotFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getLastModifiedTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getExpirationTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 74
            case 80:
              {
                scannedColumnCount_ = input.readInt64();
                bitField0_ |= 0x00020000;
                break;
              } // case 80
            case 88:
              {
                failedColumnCount_ = input.readInt64();
                bitField0_ |= 0x00040000;
                break;
              } // case 88
            case 96:
              {
                tableSizeBytes_ = input.readInt64();
                bitField0_ |= 0x00080000;
                break;
              } // case 96
            case 104:
              {
                rowCount_ = input.readInt64();
                bitField0_ |= 0x00100000;
                break;
              } // case 104
            case 112:
              {
                encryptionStatus_ = input.readEnum();
                bitField0_ |= 0x00200000;
                break;
              } // case 112
            case 120:
              {
                resourceVisibility_ = input.readEnum();
                bitField0_ |= 0x00400000;
                break;
              } // case 120
            case 130:
              {
                input.readMessage(
                    getProfileLastGeneratedFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 130
            case 138:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> resourceLabels__ =
                    input.readMessage(
                        ResourceLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableResourceLabels()
                    .getMutableMap()
                    .put(resourceLabels__.getKey(), resourceLabels__.getValue());
                bitField0_ |= 0x01000000;
                break;
              } // case 138
            case 170:
              {
                input.readMessage(getProfileStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 170
            case 176:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 176
            case 186:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x02000000;
                break;
              } // case 186
            case 194:
              {
                datasetProjectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 194
            case 202:
              {
                datasetId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 202
            case 210:
              {
                tableId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 210
            case 218:
              {
                com.google.privacy.dlp.v2.InfoTypeSummary m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.InfoTypeSummary.parser(), extensionRegistry);
                if (predictedInfoTypesBuilder_ == null) {
                  ensurePredictedInfoTypesIsMutable();
                  predictedInfoTypes_.add(m);
                } else {
                  predictedInfoTypesBuilder_.addMessage(m);
                }
                break;
              } // case 218
            case 226:
              {
                com.google.privacy.dlp.v2.OtherInfoTypeSummary m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.OtherInfoTypeSummary.parser(), extensionRegistry);
                if (otherInfoTypesBuilder_ == null) {
                  ensureOtherInfoTypesIsMutable();
                  otherInfoTypes_.add(m);
                } else {
                  otherInfoTypesBuilder_.addMessage(m);
                }
                break;
              } // case 226
            case 234:
              {
                datasetLocation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 234
            case 290:
              {
                input.readMessage(getDataSourceTypeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 290
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the profile.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the profile.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the profile.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the profile.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the profile.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.DataSourceType dataSourceType_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DataSourceType,
            com.google.privacy.dlp.v2.DataSourceType.Builder,
            com.google.privacy.dlp.v2.DataSourceTypeOrBuilder>
        dataSourceTypeBuilder_;
    /**
     *
     *
     * <pre>
     * The resource type that was profiled.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataSourceType data_source_type = 36;</code>
     *
     * @return Whether the dataSourceType field is set.
     */
    public boolean hasDataSourceType() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The resource type that was profiled.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataSourceType data_source_type = 36;</code>
     *
     * @return The dataSourceType.
     */
    public com.google.privacy.dlp.v2.DataSourceType getDataSourceType() {
      if (dataSourceTypeBuilder_ == null) {
        return dataSourceType_ == null
            ? com.google.privacy.dlp.v2.DataSourceType.getDefaultInstance()
            : dataSourceType_;
      } else {
        return dataSourceTypeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The resource type that was profiled.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataSourceType data_source_type = 36;</code>
     */
    public Builder setDataSourceType(com.google.privacy.dlp.v2.DataSourceType value) {
      if (dataSourceTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataSourceType_ = value;
      } else {
        dataSourceTypeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource type that was profiled.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataSourceType data_source_type = 36;</code>
     */
    public Builder setDataSourceType(
        com.google.privacy.dlp.v2.DataSourceType.Builder builderForValue) {
      if (dataSourceTypeBuilder_ == null) {
        dataSourceType_ = builderForValue.build();
      } else {
        dataSourceTypeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource type that was profiled.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataSourceType data_source_type = 36;</code>
     */
    public Builder mergeDataSourceType(com.google.privacy.dlp.v2.DataSourceType value) {
      if (dataSourceTypeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && dataSourceType_ != null
            && dataSourceType_ != com.google.privacy.dlp.v2.DataSourceType.getDefaultInstance()) {
          getDataSourceTypeBuilder().mergeFrom(value);
        } else {
          dataSourceType_ = value;
        }
      } else {
        dataSourceTypeBuilder_.mergeFrom(value);
      }
      if (dataSourceType_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource type that was profiled.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataSourceType data_source_type = 36;</code>
     */
    public Builder clearDataSourceType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      dataSourceType_ = null;
      if (dataSourceTypeBuilder_ != null) {
        dataSourceTypeBuilder_.dispose();
        dataSourceTypeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource type that was profiled.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataSourceType data_source_type = 36;</code>
     */
    public com.google.privacy.dlp.v2.DataSourceType.Builder getDataSourceTypeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDataSourceTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The resource type that was profiled.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataSourceType data_source_type = 36;</code>
     */
    public com.google.privacy.dlp.v2.DataSourceTypeOrBuilder getDataSourceTypeOrBuilder() {
      if (dataSourceTypeBuilder_ != null) {
        return dataSourceTypeBuilder_.getMessageOrBuilder();
      } else {
        return dataSourceType_ == null
            ? com.google.privacy.dlp.v2.DataSourceType.getDefaultInstance()
            : dataSourceType_;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource type that was profiled.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataSourceType data_source_type = 36;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DataSourceType,
            com.google.privacy.dlp.v2.DataSourceType.Builder,
            com.google.privacy.dlp.v2.DataSourceTypeOrBuilder>
        getDataSourceTypeFieldBuilder() {
      if (dataSourceTypeBuilder_ == null) {
        dataSourceTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DataSourceType,
                com.google.privacy.dlp.v2.DataSourceType.Builder,
                com.google.privacy.dlp.v2.DataSourceTypeOrBuilder>(
                getDataSourceType(), getParentForChildren(), isClean());
        dataSourceType_ = null;
      }
      return dataSourceTypeBuilder_;
    }

    private java.lang.Object projectDataProfile_ = "";
    /**
     *
     *
     * <pre>
     * The resource name to the project data profile for this table.
     * </pre>
     *
     * <code>string project_data_profile = 2;</code>
     *
     * @return The projectDataProfile.
     */
    public java.lang.String getProjectDataProfile() {
      java.lang.Object ref = projectDataProfile_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectDataProfile_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name to the project data profile for this table.
     * </pre>
     *
     * <code>string project_data_profile = 2;</code>
     *
     * @return The bytes for projectDataProfile.
     */
    public com.google.protobuf.ByteString getProjectDataProfileBytes() {
      java.lang.Object ref = projectDataProfile_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectDataProfile_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name to the project data profile for this table.
     * </pre>
     *
     * <code>string project_data_profile = 2;</code>
     *
     * @param value The projectDataProfile to set.
     * @return This builder for chaining.
     */
    public Builder setProjectDataProfile(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectDataProfile_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name to the project data profile for this table.
     * </pre>
     *
     * <code>string project_data_profile = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectDataProfile() {
      projectDataProfile_ = getDefaultInstance().getProjectDataProfile();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name to the project data profile for this table.
     * </pre>
     *
     * <code>string project_data_profile = 2;</code>
     *
     * @param value The bytes for projectDataProfile to set.
     * @return This builder for chaining.
     */
    public Builder setProjectDataProfileBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectDataProfile_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object datasetProjectId_ = "";
    /**
     *
     *
     * <pre>
     * The Google Cloud project ID that owns the resource.
     * </pre>
     *
     * <code>string dataset_project_id = 24;</code>
     *
     * @return The datasetProjectId.
     */
    public java.lang.String getDatasetProjectId() {
      java.lang.Object ref = datasetProjectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetProjectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud project ID that owns the resource.
     * </pre>
     *
     * <code>string dataset_project_id = 24;</code>
     *
     * @return The bytes for datasetProjectId.
     */
    public com.google.protobuf.ByteString getDatasetProjectIdBytes() {
      java.lang.Object ref = datasetProjectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetProjectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud project ID that owns the resource.
     * </pre>
     *
     * <code>string dataset_project_id = 24;</code>
     *
     * @param value The datasetProjectId to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      datasetProjectId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud project ID that owns the resource.
     * </pre>
     *
     * <code>string dataset_project_id = 24;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatasetProjectId() {
      datasetProjectId_ = getDefaultInstance().getDatasetProjectId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud project ID that owns the resource.
     * </pre>
     *
     * <code>string dataset_project_id = 24;</code>
     *
     * @param value The bytes for datasetProjectId to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      datasetProjectId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object datasetLocation_ = "";
    /**
     *
     *
     * <pre>
     * If supported, the location where the dataset's data is stored.
     * See https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string dataset_location = 29;</code>
     *
     * @return The datasetLocation.
     */
    public java.lang.String getDatasetLocation() {
      java.lang.Object ref = datasetLocation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetLocation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If supported, the location where the dataset's data is stored.
     * See https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string dataset_location = 29;</code>
     *
     * @return The bytes for datasetLocation.
     */
    public com.google.protobuf.ByteString getDatasetLocationBytes() {
      java.lang.Object ref = datasetLocation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetLocation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If supported, the location where the dataset's data is stored.
     * See https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string dataset_location = 29;</code>
     *
     * @param value The datasetLocation to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      datasetLocation_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If supported, the location where the dataset's data is stored.
     * See https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string dataset_location = 29;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatasetLocation() {
      datasetLocation_ = getDefaultInstance().getDatasetLocation();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If supported, the location where the dataset's data is stored.
     * See https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string dataset_location = 29;</code>
     *
     * @param value The bytes for datasetLocation to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      datasetLocation_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object datasetId_ = "";
    /**
     *
     *
     * <pre>
     * If the resource is BigQuery, the  dataset ID.
     * </pre>
     *
     * <code>string dataset_id = 25;</code>
     *
     * @return The datasetId.
     */
    public java.lang.String getDatasetId() {
      java.lang.Object ref = datasetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If the resource is BigQuery, the  dataset ID.
     * </pre>
     *
     * <code>string dataset_id = 25;</code>
     *
     * @return The bytes for datasetId.
     */
    public com.google.protobuf.ByteString getDatasetIdBytes() {
      java.lang.Object ref = datasetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If the resource is BigQuery, the  dataset ID.
     * </pre>
     *
     * <code>string dataset_id = 25;</code>
     *
     * @param value The datasetId to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      datasetId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the resource is BigQuery, the  dataset ID.
     * </pre>
     *
     * <code>string dataset_id = 25;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatasetId() {
      datasetId_ = getDefaultInstance().getDatasetId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the resource is BigQuery, the  dataset ID.
     * </pre>
     *
     * <code>string dataset_id = 25;</code>
     *
     * @param value The bytes for datasetId to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      datasetId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object tableId_ = "";
    /**
     *
     *
     * <pre>
     * If the resource is BigQuery, the BigQuery table ID.
     * </pre>
     *
     * <code>string table_id = 26;</code>
     *
     * @return The tableId.
     */
    public java.lang.String getTableId() {
      java.lang.Object ref = tableId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If the resource is BigQuery, the BigQuery table ID.
     * </pre>
     *
     * <code>string table_id = 26;</code>
     *
     * @return The bytes for tableId.
     */
    public com.google.protobuf.ByteString getTableIdBytes() {
      java.lang.Object ref = tableId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If the resource is BigQuery, the BigQuery table ID.
     * </pre>
     *
     * <code>string table_id = 26;</code>
     *
     * @param value The tableId to set.
     * @return This builder for chaining.
     */
    public Builder setTableId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tableId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the resource is BigQuery, the BigQuery table ID.
     * </pre>
     *
     * <code>string table_id = 26;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableId() {
      tableId_ = getDefaultInstance().getTableId();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the resource is BigQuery, the BigQuery table ID.
     * </pre>
     *
     * <code>string table_id = 26;</code>
     *
     * @param value The bytes for tableId to set.
     * @return This builder for chaining.
     */
    public Builder setTableIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tableId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object fullResource_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the resource profiled.
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string full_resource = 3;</code>
     *
     * @return The fullResource.
     */
    public java.lang.String getFullResource() {
      java.lang.Object ref = fullResource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fullResource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the resource profiled.
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string full_resource = 3;</code>
     *
     * @return The bytes for fullResource.
     */
    public com.google.protobuf.ByteString getFullResourceBytes() {
      java.lang.Object ref = fullResource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fullResource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the resource profiled.
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string full_resource = 3;</code>
     *
     * @param value The fullResource to set.
     * @return This builder for chaining.
     */
    public Builder setFullResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fullResource_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the resource profiled.
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string full_resource = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFullResource() {
      fullResource_ = getDefaultInstance().getFullResource();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the resource profiled.
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string full_resource = 3;</code>
     *
     * @param value The bytes for fullResource to set.
     * @return This builder for chaining.
     */
    public Builder setFullResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fullResource_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.ProfileStatus profileStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ProfileStatus,
            com.google.privacy.dlp.v2.ProfileStatus.Builder,
            com.google.privacy.dlp.v2.ProfileStatusOrBuilder>
        profileStatusBuilder_;
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 21;</code>
     *
     * @return Whether the profileStatus field is set.
     */
    public boolean hasProfileStatus() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 21;</code>
     *
     * @return The profileStatus.
     */
    public com.google.privacy.dlp.v2.ProfileStatus getProfileStatus() {
      if (profileStatusBuilder_ == null) {
        return profileStatus_ == null
            ? com.google.privacy.dlp.v2.ProfileStatus.getDefaultInstance()
            : profileStatus_;
      } else {
        return profileStatusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 21;</code>
     */
    public Builder setProfileStatus(com.google.privacy.dlp.v2.ProfileStatus value) {
      if (profileStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        profileStatus_ = value;
      } else {
        profileStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 21;</code>
     */
    public Builder setProfileStatus(
        com.google.privacy.dlp.v2.ProfileStatus.Builder builderForValue) {
      if (profileStatusBuilder_ == null) {
        profileStatus_ = builderForValue.build();
      } else {
        profileStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 21;</code>
     */
    public Builder mergeProfileStatus(com.google.privacy.dlp.v2.ProfileStatus value) {
      if (profileStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && profileStatus_ != null
            && profileStatus_ != com.google.privacy.dlp.v2.ProfileStatus.getDefaultInstance()) {
          getProfileStatusBuilder().mergeFrom(value);
        } else {
          profileStatus_ = value;
        }
      } else {
        profileStatusBuilder_.mergeFrom(value);
      }
      if (profileStatus_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 21;</code>
     */
    public Builder clearProfileStatus() {
      bitField0_ = (bitField0_ & ~0x00000100);
      profileStatus_ = null;
      if (profileStatusBuilder_ != null) {
        profileStatusBuilder_.dispose();
        profileStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 21;</code>
     */
    public com.google.privacy.dlp.v2.ProfileStatus.Builder getProfileStatusBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getProfileStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 21;</code>
     */
    public com.google.privacy.dlp.v2.ProfileStatusOrBuilder getProfileStatusOrBuilder() {
      if (profileStatusBuilder_ != null) {
        return profileStatusBuilder_.getMessageOrBuilder();
      } else {
        return profileStatus_ == null
            ? com.google.privacy.dlp.v2.ProfileStatus.getDefaultInstance()
            : profileStatus_;
      }
    }
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ProfileStatus,
            com.google.privacy.dlp.v2.ProfileStatus.Builder,
            com.google.privacy.dlp.v2.ProfileStatusOrBuilder>
        getProfileStatusFieldBuilder() {
      if (profileStatusBuilder_ == null) {
        profileStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.ProfileStatus,
                com.google.privacy.dlp.v2.ProfileStatus.Builder,
                com.google.privacy.dlp.v2.ProfileStatusOrBuilder>(
                getProfileStatus(), getParentForChildren(), isClean());
        profileStatus_ = null;
      }
      return profileStatusBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * State of a profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableDataProfile.State state = 22;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * State of a profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableDataProfile.State state = 22;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of a profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableDataProfile.State state = 22;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.TableDataProfile.State getState() {
      com.google.privacy.dlp.v2.TableDataProfile.State result =
          com.google.privacy.dlp.v2.TableDataProfile.State.forNumber(state_);
      return result == null
          ? com.google.privacy.dlp.v2.TableDataProfile.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * State of a profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableDataProfile.State state = 22;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.privacy.dlp.v2.TableDataProfile.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of a profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableDataProfile.State state = 22;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000200);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.SensitivityScore sensitivityScore_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.SensitivityScore,
            com.google.privacy.dlp.v2.SensitivityScore.Builder,
            com.google.privacy.dlp.v2.SensitivityScoreOrBuilder>
        sensitivityScoreBuilder_;
    /**
     *
     *
     * <pre>
     * The sensitivity score of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 5;</code>
     *
     * @return Whether the sensitivityScore field is set.
     */
    public boolean hasSensitivityScore() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * The sensitivity score of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 5;</code>
     *
     * @return The sensitivityScore.
     */
    public com.google.privacy.dlp.v2.SensitivityScore getSensitivityScore() {
      if (sensitivityScoreBuilder_ == null) {
        return sensitivityScore_ == null
            ? com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()
            : sensitivityScore_;
      } else {
        return sensitivityScoreBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The sensitivity score of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 5;</code>
     */
    public Builder setSensitivityScore(com.google.privacy.dlp.v2.SensitivityScore value) {
      if (sensitivityScoreBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sensitivityScore_ = value;
      } else {
        sensitivityScoreBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sensitivity score of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 5;</code>
     */
    public Builder setSensitivityScore(
        com.google.privacy.dlp.v2.SensitivityScore.Builder builderForValue) {
      if (sensitivityScoreBuilder_ == null) {
        sensitivityScore_ = builderForValue.build();
      } else {
        sensitivityScoreBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sensitivity score of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 5;</code>
     */
    public Builder mergeSensitivityScore(com.google.privacy.dlp.v2.SensitivityScore value) {
      if (sensitivityScoreBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && sensitivityScore_ != null
            && sensitivityScore_
                != com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()) {
          getSensitivityScoreBuilder().mergeFrom(value);
        } else {
          sensitivityScore_ = value;
        }
      } else {
        sensitivityScoreBuilder_.mergeFrom(value);
      }
      if (sensitivityScore_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sensitivity score of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 5;</code>
     */
    public Builder clearSensitivityScore() {
      bitField0_ = (bitField0_ & ~0x00000400);
      sensitivityScore_ = null;
      if (sensitivityScoreBuilder_ != null) {
        sensitivityScoreBuilder_.dispose();
        sensitivityScoreBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sensitivity score of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 5;</code>
     */
    public com.google.privacy.dlp.v2.SensitivityScore.Builder getSensitivityScoreBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getSensitivityScoreFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The sensitivity score of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 5;</code>
     */
    public com.google.privacy.dlp.v2.SensitivityScoreOrBuilder getSensitivityScoreOrBuilder() {
      if (sensitivityScoreBuilder_ != null) {
        return sensitivityScoreBuilder_.getMessageOrBuilder();
      } else {
        return sensitivityScore_ == null
            ? com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()
            : sensitivityScore_;
      }
    }
    /**
     *
     *
     * <pre>
     * The sensitivity score of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.SensitivityScore,
            com.google.privacy.dlp.v2.SensitivityScore.Builder,
            com.google.privacy.dlp.v2.SensitivityScoreOrBuilder>
        getSensitivityScoreFieldBuilder() {
      if (sensitivityScoreBuilder_ == null) {
        sensitivityScoreBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.SensitivityScore,
                com.google.privacy.dlp.v2.SensitivityScore.Builder,
                com.google.privacy.dlp.v2.SensitivityScoreOrBuilder>(
                getSensitivityScore(), getParentForChildren(), isClean());
        sensitivityScore_ = null;
      }
      return sensitivityScoreBuilder_;
    }

    private com.google.privacy.dlp.v2.DataRiskLevel dataRiskLevel_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DataRiskLevel,
            com.google.privacy.dlp.v2.DataRiskLevel.Builder,
            com.google.privacy.dlp.v2.DataRiskLevelOrBuilder>
        dataRiskLevelBuilder_;
    /**
     *
     *
     * <pre>
     * The data risk level of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 6;</code>
     *
     * @return Whether the dataRiskLevel field is set.
     */
    public boolean hasDataRiskLevel() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * The data risk level of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 6;</code>
     *
     * @return The dataRiskLevel.
     */
    public com.google.privacy.dlp.v2.DataRiskLevel getDataRiskLevel() {
      if (dataRiskLevelBuilder_ == null) {
        return dataRiskLevel_ == null
            ? com.google.privacy.dlp.v2.DataRiskLevel.getDefaultInstance()
            : dataRiskLevel_;
      } else {
        return dataRiskLevelBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The data risk level of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 6;</code>
     */
    public Builder setDataRiskLevel(com.google.privacy.dlp.v2.DataRiskLevel value) {
      if (dataRiskLevelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataRiskLevel_ = value;
      } else {
        dataRiskLevelBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data risk level of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 6;</code>
     */
    public Builder setDataRiskLevel(
        com.google.privacy.dlp.v2.DataRiskLevel.Builder builderForValue) {
      if (dataRiskLevelBuilder_ == null) {
        dataRiskLevel_ = builderForValue.build();
      } else {
        dataRiskLevelBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data risk level of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 6;</code>
     */
    public Builder mergeDataRiskLevel(com.google.privacy.dlp.v2.DataRiskLevel value) {
      if (dataRiskLevelBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && dataRiskLevel_ != null
            && dataRiskLevel_ != com.google.privacy.dlp.v2.DataRiskLevel.getDefaultInstance()) {
          getDataRiskLevelBuilder().mergeFrom(value);
        } else {
          dataRiskLevel_ = value;
        }
      } else {
        dataRiskLevelBuilder_.mergeFrom(value);
      }
      if (dataRiskLevel_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data risk level of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 6;</code>
     */
    public Builder clearDataRiskLevel() {
      bitField0_ = (bitField0_ & ~0x00000800);
      dataRiskLevel_ = null;
      if (dataRiskLevelBuilder_ != null) {
        dataRiskLevelBuilder_.dispose();
        dataRiskLevelBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data risk level of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 6;</code>
     */
    public com.google.privacy.dlp.v2.DataRiskLevel.Builder getDataRiskLevelBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getDataRiskLevelFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The data risk level of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 6;</code>
     */
    public com.google.privacy.dlp.v2.DataRiskLevelOrBuilder getDataRiskLevelOrBuilder() {
      if (dataRiskLevelBuilder_ != null) {
        return dataRiskLevelBuilder_.getMessageOrBuilder();
      } else {
        return dataRiskLevel_ == null
            ? com.google.privacy.dlp.v2.DataRiskLevel.getDefaultInstance()
            : dataRiskLevel_;
      }
    }
    /**
     *
     *
     * <pre>
     * The data risk level of this table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DataRiskLevel,
            com.google.privacy.dlp.v2.DataRiskLevel.Builder,
            com.google.privacy.dlp.v2.DataRiskLevelOrBuilder>
        getDataRiskLevelFieldBuilder() {
      if (dataRiskLevelBuilder_ == null) {
        dataRiskLevelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DataRiskLevel,
                com.google.privacy.dlp.v2.DataRiskLevel.Builder,
                com.google.privacy.dlp.v2.DataRiskLevelOrBuilder>(
                getDataRiskLevel(), getParentForChildren(), isClean());
        dataRiskLevel_ = null;
      }
      return dataRiskLevelBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.InfoTypeSummary> predictedInfoTypes_ =
        java.util.Collections.emptyList();

    private void ensurePredictedInfoTypesIsMutable() {
      if (!((bitField0_ & 0x00001000) != 0)) {
        predictedInfoTypes_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.InfoTypeSummary>(predictedInfoTypes_);
        bitField0_ |= 0x00001000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoTypeSummary,
            com.google.privacy.dlp.v2.InfoTypeSummary.Builder,
            com.google.privacy.dlp.v2.InfoTypeSummaryOrBuilder>
        predictedInfoTypesBuilder_;

    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.InfoTypeSummary> getPredictedInfoTypesList() {
      if (predictedInfoTypesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(predictedInfoTypes_);
      } else {
        return predictedInfoTypesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public int getPredictedInfoTypesCount() {
      if (predictedInfoTypesBuilder_ == null) {
        return predictedInfoTypes_.size();
      } else {
        return predictedInfoTypesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeSummary getPredictedInfoTypes(int index) {
      if (predictedInfoTypesBuilder_ == null) {
        return predictedInfoTypes_.get(index);
      } else {
        return predictedInfoTypesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public Builder setPredictedInfoTypes(
        int index, com.google.privacy.dlp.v2.InfoTypeSummary value) {
      if (predictedInfoTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePredictedInfoTypesIsMutable();
        predictedInfoTypes_.set(index, value);
        onChanged();
      } else {
        predictedInfoTypesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public Builder setPredictedInfoTypes(
        int index, com.google.privacy.dlp.v2.InfoTypeSummary.Builder builderForValue) {
      if (predictedInfoTypesBuilder_ == null) {
        ensurePredictedInfoTypesIsMutable();
        predictedInfoTypes_.set(index, builderForValue.build());
        onChanged();
      } else {
        predictedInfoTypesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public Builder addPredictedInfoTypes(com.google.privacy.dlp.v2.InfoTypeSummary value) {
      if (predictedInfoTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePredictedInfoTypesIsMutable();
        predictedInfoTypes_.add(value);
        onChanged();
      } else {
        predictedInfoTypesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public Builder addPredictedInfoTypes(
        int index, com.google.privacy.dlp.v2.InfoTypeSummary value) {
      if (predictedInfoTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePredictedInfoTypesIsMutable();
        predictedInfoTypes_.add(index, value);
        onChanged();
      } else {
        predictedInfoTypesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public Builder addPredictedInfoTypes(
        com.google.privacy.dlp.v2.InfoTypeSummary.Builder builderForValue) {
      if (predictedInfoTypesBuilder_ == null) {
        ensurePredictedInfoTypesIsMutable();
        predictedInfoTypes_.add(builderForValue.build());
        onChanged();
      } else {
        predictedInfoTypesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public Builder addPredictedInfoTypes(
        int index, com.google.privacy.dlp.v2.InfoTypeSummary.Builder builderForValue) {
      if (predictedInfoTypesBuilder_ == null) {
        ensurePredictedInfoTypesIsMutable();
        predictedInfoTypes_.add(index, builderForValue.build());
        onChanged();
      } else {
        predictedInfoTypesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public Builder addAllPredictedInfoTypes(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.InfoTypeSummary> values) {
      if (predictedInfoTypesBuilder_ == null) {
        ensurePredictedInfoTypesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, predictedInfoTypes_);
        onChanged();
      } else {
        predictedInfoTypesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public Builder clearPredictedInfoTypes() {
      if (predictedInfoTypesBuilder_ == null) {
        predictedInfoTypes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00001000);
        onChanged();
      } else {
        predictedInfoTypesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public Builder removePredictedInfoTypes(int index) {
      if (predictedInfoTypesBuilder_ == null) {
        ensurePredictedInfoTypesIsMutable();
        predictedInfoTypes_.remove(index);
        onChanged();
      } else {
        predictedInfoTypesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeSummary.Builder getPredictedInfoTypesBuilder(
        int index) {
      return getPredictedInfoTypesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeSummaryOrBuilder getPredictedInfoTypesOrBuilder(
        int index) {
      if (predictedInfoTypesBuilder_ == null) {
        return predictedInfoTypes_.get(index);
      } else {
        return predictedInfoTypesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.InfoTypeSummaryOrBuilder>
        getPredictedInfoTypesOrBuilderList() {
      if (predictedInfoTypesBuilder_ != null) {
        return predictedInfoTypesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(predictedInfoTypes_);
      }
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeSummary.Builder addPredictedInfoTypesBuilder() {
      return getPredictedInfoTypesFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.InfoTypeSummary.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeSummary.Builder addPredictedInfoTypesBuilder(
        int index) {
      return getPredictedInfoTypesFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.InfoTypeSummary.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The infoTypes predicted from this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoTypeSummary predicted_info_types = 27;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.InfoTypeSummary.Builder>
        getPredictedInfoTypesBuilderList() {
      return getPredictedInfoTypesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoTypeSummary,
            com.google.privacy.dlp.v2.InfoTypeSummary.Builder,
            com.google.privacy.dlp.v2.InfoTypeSummaryOrBuilder>
        getPredictedInfoTypesFieldBuilder() {
      if (predictedInfoTypesBuilder_ == null) {
        predictedInfoTypesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.InfoTypeSummary,
                com.google.privacy.dlp.v2.InfoTypeSummary.Builder,
                com.google.privacy.dlp.v2.InfoTypeSummaryOrBuilder>(
                predictedInfoTypes_,
                ((bitField0_ & 0x00001000) != 0),
                getParentForChildren(),
                isClean());
        predictedInfoTypes_ = null;
      }
      return predictedInfoTypesBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.OtherInfoTypeSummary> otherInfoTypes_ =
        java.util.Collections.emptyList();

    private void ensureOtherInfoTypesIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        otherInfoTypes_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.OtherInfoTypeSummary>(
                otherInfoTypes_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.OtherInfoTypeSummary,
            com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder,
            com.google.privacy.dlp.v2.OtherInfoTypeSummaryOrBuilder>
        otherInfoTypesBuilder_;

    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.OtherInfoTypeSummary> getOtherInfoTypesList() {
      if (otherInfoTypesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(otherInfoTypes_);
      } else {
        return otherInfoTypesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public int getOtherInfoTypesCount() {
      if (otherInfoTypesBuilder_ == null) {
        return otherInfoTypes_.size();
      } else {
        return otherInfoTypesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public com.google.privacy.dlp.v2.OtherInfoTypeSummary getOtherInfoTypes(int index) {
      if (otherInfoTypesBuilder_ == null) {
        return otherInfoTypes_.get(index);
      } else {
        return otherInfoTypesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public Builder setOtherInfoTypes(
        int index, com.google.privacy.dlp.v2.OtherInfoTypeSummary value) {
      if (otherInfoTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOtherInfoTypesIsMutable();
        otherInfoTypes_.set(index, value);
        onChanged();
      } else {
        otherInfoTypesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public Builder setOtherInfoTypes(
        int index, com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder builderForValue) {
      if (otherInfoTypesBuilder_ == null) {
        ensureOtherInfoTypesIsMutable();
        otherInfoTypes_.set(index, builderForValue.build());
        onChanged();
      } else {
        otherInfoTypesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public Builder addOtherInfoTypes(com.google.privacy.dlp.v2.OtherInfoTypeSummary value) {
      if (otherInfoTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOtherInfoTypesIsMutable();
        otherInfoTypes_.add(value);
        onChanged();
      } else {
        otherInfoTypesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public Builder addOtherInfoTypes(
        int index, com.google.privacy.dlp.v2.OtherInfoTypeSummary value) {
      if (otherInfoTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOtherInfoTypesIsMutable();
        otherInfoTypes_.add(index, value);
        onChanged();
      } else {
        otherInfoTypesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public Builder addOtherInfoTypes(
        com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder builderForValue) {
      if (otherInfoTypesBuilder_ == null) {
        ensureOtherInfoTypesIsMutable();
        otherInfoTypes_.add(builderForValue.build());
        onChanged();
      } else {
        otherInfoTypesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public Builder addOtherInfoTypes(
        int index, com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder builderForValue) {
      if (otherInfoTypesBuilder_ == null) {
        ensureOtherInfoTypesIsMutable();
        otherInfoTypes_.add(index, builderForValue.build());
        onChanged();
      } else {
        otherInfoTypesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public Builder addAllOtherInfoTypes(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.OtherInfoTypeSummary> values) {
      if (otherInfoTypesBuilder_ == null) {
        ensureOtherInfoTypesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, otherInfoTypes_);
        onChanged();
      } else {
        otherInfoTypesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public Builder clearOtherInfoTypes() {
      if (otherInfoTypesBuilder_ == null) {
        otherInfoTypes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        otherInfoTypesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public Builder removeOtherInfoTypes(int index) {
      if (otherInfoTypesBuilder_ == null) {
        ensureOtherInfoTypesIsMutable();
        otherInfoTypes_.remove(index);
        onChanged();
      } else {
        otherInfoTypesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder getOtherInfoTypesBuilder(
        int index) {
      return getOtherInfoTypesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public com.google.privacy.dlp.v2.OtherInfoTypeSummaryOrBuilder getOtherInfoTypesOrBuilder(
        int index) {
      if (otherInfoTypesBuilder_ == null) {
        return otherInfoTypes_.get(index);
      } else {
        return otherInfoTypesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.OtherInfoTypeSummaryOrBuilder>
        getOtherInfoTypesOrBuilderList() {
      if (otherInfoTypesBuilder_ != null) {
        return otherInfoTypesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(otherInfoTypes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder addOtherInfoTypesBuilder() {
      return getOtherInfoTypesFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.OtherInfoTypeSummary.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder addOtherInfoTypesBuilder(
        int index) {
      return getOtherInfoTypesFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.OtherInfoTypeSummary.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Other infoTypes found in this table's data.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_info_types = 28;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder>
        getOtherInfoTypesBuilderList() {
      return getOtherInfoTypesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.OtherInfoTypeSummary,
            com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder,
            com.google.privacy.dlp.v2.OtherInfoTypeSummaryOrBuilder>
        getOtherInfoTypesFieldBuilder() {
      if (otherInfoTypesBuilder_ == null) {
        otherInfoTypesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.OtherInfoTypeSummary,
                com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder,
                com.google.privacy.dlp.v2.OtherInfoTypeSummaryOrBuilder>(
                otherInfoTypes_,
                ((bitField0_ & 0x00002000) != 0),
                getParentForChildren(),
                isClean());
        otherInfoTypes_ = null;
      }
      return otherInfoTypesBuilder_;
    }

    private com.google.privacy.dlp.v2.DataProfileConfigSnapshot configSnapshot_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DataProfileConfigSnapshot,
            com.google.privacy.dlp.v2.DataProfileConfigSnapshot.Builder,
            com.google.privacy.dlp.v2.DataProfileConfigSnapshotOrBuilder>
        configSnapshotBuilder_;
    /**
     *
     *
     * <pre>
     * The snapshot of the configurations used to generate the profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileConfigSnapshot config_snapshot = 7;</code>
     *
     * @return Whether the configSnapshot field is set.
     */
    public boolean hasConfigSnapshot() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The snapshot of the configurations used to generate the profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileConfigSnapshot config_snapshot = 7;</code>
     *
     * @return The configSnapshot.
     */
    public com.google.privacy.dlp.v2.DataProfileConfigSnapshot getConfigSnapshot() {
      if (configSnapshotBuilder_ == null) {
        return configSnapshot_ == null
            ? com.google.privacy.dlp.v2.DataProfileConfigSnapshot.getDefaultInstance()
            : configSnapshot_;
      } else {
        return configSnapshotBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The snapshot of the configurations used to generate the profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileConfigSnapshot config_snapshot = 7;</code>
     */
    public Builder setConfigSnapshot(com.google.privacy.dlp.v2.DataProfileConfigSnapshot value) {
      if (configSnapshotBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        configSnapshot_ = value;
      } else {
        configSnapshotBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The snapshot of the configurations used to generate the profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileConfigSnapshot config_snapshot = 7;</code>
     */
    public Builder setConfigSnapshot(
        com.google.privacy.dlp.v2.DataProfileConfigSnapshot.Builder builderForValue) {
      if (configSnapshotBuilder_ == null) {
        configSnapshot_ = builderForValue.build();
      } else {
        configSnapshotBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The snapshot of the configurations used to generate the profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileConfigSnapshot config_snapshot = 7;</code>
     */
    public Builder mergeConfigSnapshot(com.google.privacy.dlp.v2.DataProfileConfigSnapshot value) {
      if (configSnapshotBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && configSnapshot_ != null
            && configSnapshot_
                != com.google.privacy.dlp.v2.DataProfileConfigSnapshot.getDefaultInstance()) {
          getConfigSnapshotBuilder().mergeFrom(value);
        } else {
          configSnapshot_ = value;
        }
      } else {
        configSnapshotBuilder_.mergeFrom(value);
      }
      if (configSnapshot_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The snapshot of the configurations used to generate the profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileConfigSnapshot config_snapshot = 7;</code>
     */
    public Builder clearConfigSnapshot() {
      bitField0_ = (bitField0_ & ~0x00004000);
      configSnapshot_ = null;
      if (configSnapshotBuilder_ != null) {
        configSnapshotBuilder_.dispose();
        configSnapshotBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The snapshot of the configurations used to generate the profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileConfigSnapshot config_snapshot = 7;</code>
     */
    public com.google.privacy.dlp.v2.DataProfileConfigSnapshot.Builder getConfigSnapshotBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getConfigSnapshotFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The snapshot of the configurations used to generate the profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileConfigSnapshot config_snapshot = 7;</code>
     */
    public com.google.privacy.dlp.v2.DataProfileConfigSnapshotOrBuilder
        getConfigSnapshotOrBuilder() {
      if (configSnapshotBuilder_ != null) {
        return configSnapshotBuilder_.getMessageOrBuilder();
      } else {
        return configSnapshot_ == null
            ? com.google.privacy.dlp.v2.DataProfileConfigSnapshot.getDefaultInstance()
            : configSnapshot_;
      }
    }
    /**
     *
     *
     * <pre>
     * The snapshot of the configurations used to generate the profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileConfigSnapshot config_snapshot = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DataProfileConfigSnapshot,
            com.google.privacy.dlp.v2.DataProfileConfigSnapshot.Builder,
            com.google.privacy.dlp.v2.DataProfileConfigSnapshotOrBuilder>
        getConfigSnapshotFieldBuilder() {
      if (configSnapshotBuilder_ == null) {
        configSnapshotBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DataProfileConfigSnapshot,
                com.google.privacy.dlp.v2.DataProfileConfigSnapshot.Builder,
                com.google.privacy.dlp.v2.DataProfileConfigSnapshotOrBuilder>(
                getConfigSnapshot(), getParentForChildren(), isClean());
        configSnapshot_ = null;
      }
      return configSnapshotBuilder_;
    }

    private com.google.protobuf.Timestamp lastModifiedTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastModifiedTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when this table was last modified
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_time = 8;</code>
     *
     * @return Whether the lastModifiedTime field is set.
     */
    public boolean hasLastModifiedTime() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when this table was last modified
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_time = 8;</code>
     *
     * @return The lastModifiedTime.
     */
    public com.google.protobuf.Timestamp getLastModifiedTime() {
      if (lastModifiedTimeBuilder_ == null) {
        return lastModifiedTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastModifiedTime_;
      } else {
        return lastModifiedTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when this table was last modified
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_time = 8;</code>
     */
    public Builder setLastModifiedTime(com.google.protobuf.Timestamp value) {
      if (lastModifiedTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastModifiedTime_ = value;
      } else {
        lastModifiedTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when this table was last modified
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_time = 8;</code>
     */
    public Builder setLastModifiedTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastModifiedTimeBuilder_ == null) {
        lastModifiedTime_ = builderForValue.build();
      } else {
        lastModifiedTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when this table was last modified
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_time = 8;</code>
     */
    public Builder mergeLastModifiedTime(com.google.protobuf.Timestamp value) {
      if (lastModifiedTimeBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && lastModifiedTime_ != null
            && lastModifiedTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastModifiedTimeBuilder().mergeFrom(value);
        } else {
          lastModifiedTime_ = value;
        }
      } else {
        lastModifiedTimeBuilder_.mergeFrom(value);
      }
      if (lastModifiedTime_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when this table was last modified
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_time = 8;</code>
     */
    public Builder clearLastModifiedTime() {
      bitField0_ = (bitField0_ & ~0x00008000);
      lastModifiedTime_ = null;
      if (lastModifiedTimeBuilder_ != null) {
        lastModifiedTimeBuilder_.dispose();
        lastModifiedTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when this table was last modified
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_time = 8;</code>
     */
    public com.google.protobuf.Timestamp.Builder getLastModifiedTimeBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getLastModifiedTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when this table was last modified
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_time = 8;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastModifiedTimeOrBuilder() {
      if (lastModifiedTimeBuilder_ != null) {
        return lastModifiedTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastModifiedTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastModifiedTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when this table was last modified
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_time = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastModifiedTimeFieldBuilder() {
      if (lastModifiedTimeBuilder_ == null) {
        lastModifiedTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastModifiedTime(), getParentForChildren(), isClean());
        lastModifiedTime_ = null;
      }
      return lastModifiedTimeBuilder_;
    }

    private com.google.protobuf.Timestamp expirationTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expirationTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The time when this table expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expiration_time = 9;</code>
     *
     * @return Whether the expirationTime field is set.
     */
    public boolean hasExpirationTime() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when this table expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expiration_time = 9;</code>
     *
     * @return The expirationTime.
     */
    public com.google.protobuf.Timestamp getExpirationTime() {
      if (expirationTimeBuilder_ == null) {
        return expirationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expirationTime_;
      } else {
        return expirationTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when this table expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expiration_time = 9;</code>
     */
    public Builder setExpirationTime(com.google.protobuf.Timestamp value) {
      if (expirationTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expirationTime_ = value;
      } else {
        expirationTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when this table expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expiration_time = 9;</code>
     */
    public Builder setExpirationTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expirationTimeBuilder_ == null) {
        expirationTime_ = builderForValue.build();
      } else {
        expirationTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when this table expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expiration_time = 9;</code>
     */
    public Builder mergeExpirationTime(com.google.protobuf.Timestamp value) {
      if (expirationTimeBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && expirationTime_ != null
            && expirationTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExpirationTimeBuilder().mergeFrom(value);
        } else {
          expirationTime_ = value;
        }
      } else {
        expirationTimeBuilder_.mergeFrom(value);
      }
      if (expirationTime_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when this table expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expiration_time = 9;</code>
     */
    public Builder clearExpirationTime() {
      bitField0_ = (bitField0_ & ~0x00010000);
      expirationTime_ = null;
      if (expirationTimeBuilder_ != null) {
        expirationTimeBuilder_.dispose();
        expirationTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when this table expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expiration_time = 9;</code>
     */
    public com.google.protobuf.Timestamp.Builder getExpirationTimeBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getExpirationTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when this table expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expiration_time = 9;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpirationTimeOrBuilder() {
      if (expirationTimeBuilder_ != null) {
        return expirationTimeBuilder_.getMessageOrBuilder();
      } else {
        return expirationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expirationTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when this table expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expiration_time = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpirationTimeFieldBuilder() {
      if (expirationTimeBuilder_ == null) {
        expirationTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpirationTime(), getParentForChildren(), isClean());
        expirationTime_ = null;
      }
      return expirationTimeBuilder_;
    }

    private long scannedColumnCount_;
    /**
     *
     *
     * <pre>
     * The number of columns profiled in the table.
     * </pre>
     *
     * <code>int64 scanned_column_count = 10;</code>
     *
     * @return The scannedColumnCount.
     */
    @java.lang.Override
    public long getScannedColumnCount() {
      return scannedColumnCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of columns profiled in the table.
     * </pre>
     *
     * <code>int64 scanned_column_count = 10;</code>
     *
     * @param value The scannedColumnCount to set.
     * @return This builder for chaining.
     */
    public Builder setScannedColumnCount(long value) {

      scannedColumnCount_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of columns profiled in the table.
     * </pre>
     *
     * <code>int64 scanned_column_count = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScannedColumnCount() {
      bitField0_ = (bitField0_ & ~0x00020000);
      scannedColumnCount_ = 0L;
      onChanged();
      return this;
    }

    private long failedColumnCount_;
    /**
     *
     *
     * <pre>
     * The number of columns skipped in the table because of an error.
     * </pre>
     *
     * <code>int64 failed_column_count = 11;</code>
     *
     * @return The failedColumnCount.
     */
    @java.lang.Override
    public long getFailedColumnCount() {
      return failedColumnCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of columns skipped in the table because of an error.
     * </pre>
     *
     * <code>int64 failed_column_count = 11;</code>
     *
     * @param value The failedColumnCount to set.
     * @return This builder for chaining.
     */
    public Builder setFailedColumnCount(long value) {

      failedColumnCount_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of columns skipped in the table because of an error.
     * </pre>
     *
     * <code>int64 failed_column_count = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailedColumnCount() {
      bitField0_ = (bitField0_ & ~0x00040000);
      failedColumnCount_ = 0L;
      onChanged();
      return this;
    }

    private long tableSizeBytes_;
    /**
     *
     *
     * <pre>
     * The size of the table when the profile was generated.
     * </pre>
     *
     * <code>int64 table_size_bytes = 12;</code>
     *
     * @return The tableSizeBytes.
     */
    @java.lang.Override
    public long getTableSizeBytes() {
      return tableSizeBytes_;
    }
    /**
     *
     *
     * <pre>
     * The size of the table when the profile was generated.
     * </pre>
     *
     * <code>int64 table_size_bytes = 12;</code>
     *
     * @param value The tableSizeBytes to set.
     * @return This builder for chaining.
     */
    public Builder setTableSizeBytes(long value) {

      tableSizeBytes_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The size of the table when the profile was generated.
     * </pre>
     *
     * <code>int64 table_size_bytes = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableSizeBytes() {
      bitField0_ = (bitField0_ & ~0x00080000);
      tableSizeBytes_ = 0L;
      onChanged();
      return this;
    }

    private long rowCount_;
    /**
     *
     *
     * <pre>
     * Number of rows in the table when the profile was generated.
     * This will not be populated for BigLake tables.
     * </pre>
     *
     * <code>int64 row_count = 13;</code>
     *
     * @return The rowCount.
     */
    @java.lang.Override
    public long getRowCount() {
      return rowCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of rows in the table when the profile was generated.
     * This will not be populated for BigLake tables.
     * </pre>
     *
     * <code>int64 row_count = 13;</code>
     *
     * @param value The rowCount to set.
     * @return This builder for chaining.
     */
    public Builder setRowCount(long value) {

      rowCount_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of rows in the table when the profile was generated.
     * This will not be populated for BigLake tables.
     * </pre>
     *
     * <code>int64 row_count = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowCount() {
      bitField0_ = (bitField0_ & ~0x00100000);
      rowCount_ = 0L;
      onChanged();
      return this;
    }

    private int encryptionStatus_ = 0;
    /**
     *
     *
     * <pre>
     * How the table is encrypted.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.EncryptionStatus encryption_status = 14;</code>
     *
     * @return The enum numeric value on the wire for encryptionStatus.
     */
    @java.lang.Override
    public int getEncryptionStatusValue() {
      return encryptionStatus_;
    }
    /**
     *
     *
     * <pre>
     * How the table is encrypted.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.EncryptionStatus encryption_status = 14;</code>
     *
     * @param value The enum numeric value on the wire for encryptionStatus to set.
     * @return This builder for chaining.
     */
    public Builder setEncryptionStatusValue(int value) {
      encryptionStatus_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How the table is encrypted.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.EncryptionStatus encryption_status = 14;</code>
     *
     * @return The encryptionStatus.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.EncryptionStatus getEncryptionStatus() {
      com.google.privacy.dlp.v2.EncryptionStatus result =
          com.google.privacy.dlp.v2.EncryptionStatus.forNumber(encryptionStatus_);
      return result == null ? com.google.privacy.dlp.v2.EncryptionStatus.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * How the table is encrypted.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.EncryptionStatus encryption_status = 14;</code>
     *
     * @param value The encryptionStatus to set.
     * @return This builder for chaining.
     */
    public Builder setEncryptionStatus(com.google.privacy.dlp.v2.EncryptionStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00200000;
      encryptionStatus_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How the table is encrypted.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.EncryptionStatus encryption_status = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEncryptionStatus() {
      bitField0_ = (bitField0_ & ~0x00200000);
      encryptionStatus_ = 0;
      onChanged();
      return this;
    }

    private int resourceVisibility_ = 0;
    /**
     *
     *
     * <pre>
     * How broadly a resource has been shared.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ResourceVisibility resource_visibility = 15;</code>
     *
     * @return The enum numeric value on the wire for resourceVisibility.
     */
    @java.lang.Override
    public int getResourceVisibilityValue() {
      return resourceVisibility_;
    }
    /**
     *
     *
     * <pre>
     * How broadly a resource has been shared.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ResourceVisibility resource_visibility = 15;</code>
     *
     * @param value The enum numeric value on the wire for resourceVisibility to set.
     * @return This builder for chaining.
     */
    public Builder setResourceVisibilityValue(int value) {
      resourceVisibility_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How broadly a resource has been shared.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ResourceVisibility resource_visibility = 15;</code>
     *
     * @return The resourceVisibility.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ResourceVisibility getResourceVisibility() {
      com.google.privacy.dlp.v2.ResourceVisibility result =
          com.google.privacy.dlp.v2.ResourceVisibility.forNumber(resourceVisibility_);
      return result == null ? com.google.privacy.dlp.v2.ResourceVisibility.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * How broadly a resource has been shared.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ResourceVisibility resource_visibility = 15;</code>
     *
     * @param value The resourceVisibility to set.
     * @return This builder for chaining.
     */
    public Builder setResourceVisibility(com.google.privacy.dlp.v2.ResourceVisibility value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00400000;
      resourceVisibility_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How broadly a resource has been shared.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ResourceVisibility resource_visibility = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceVisibility() {
      bitField0_ = (bitField0_ & ~0x00400000);
      resourceVisibility_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp profileLastGenerated_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        profileLastGeneratedBuilder_;
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 16;</code>
     *
     * @return Whether the profileLastGenerated field is set.
     */
    public boolean hasProfileLastGenerated() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 16;</code>
     *
     * @return The profileLastGenerated.
     */
    public com.google.protobuf.Timestamp getProfileLastGenerated() {
      if (profileLastGeneratedBuilder_ == null) {
        return profileLastGenerated_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : profileLastGenerated_;
      } else {
        return profileLastGeneratedBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 16;</code>
     */
    public Builder setProfileLastGenerated(com.google.protobuf.Timestamp value) {
      if (profileLastGeneratedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        profileLastGenerated_ = value;
      } else {
        profileLastGeneratedBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 16;</code>
     */
    public Builder setProfileLastGenerated(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (profileLastGeneratedBuilder_ == null) {
        profileLastGenerated_ = builderForValue.build();
      } else {
        profileLastGeneratedBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 16;</code>
     */
    public Builder mergeProfileLastGenerated(com.google.protobuf.Timestamp value) {
      if (profileLastGeneratedBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && profileLastGenerated_ != null
            && profileLastGenerated_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getProfileLastGeneratedBuilder().mergeFrom(value);
        } else {
          profileLastGenerated_ = value;
        }
      } else {
        profileLastGeneratedBuilder_.mergeFrom(value);
      }
      if (profileLastGenerated_ != null) {
        bitField0_ |= 0x00800000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 16;</code>
     */
    public Builder clearProfileLastGenerated() {
      bitField0_ = (bitField0_ & ~0x00800000);
      profileLastGenerated_ = null;
      if (profileLastGeneratedBuilder_ != null) {
        profileLastGeneratedBuilder_.dispose();
        profileLastGeneratedBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 16;</code>
     */
    public com.google.protobuf.Timestamp.Builder getProfileLastGeneratedBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getProfileLastGeneratedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 16;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getProfileLastGeneratedOrBuilder() {
      if (profileLastGeneratedBuilder_ != null) {
        return profileLastGeneratedBuilder_.getMessageOrBuilder();
      } else {
        return profileLastGenerated_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : profileLastGenerated_;
      }
    }
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getProfileLastGeneratedFieldBuilder() {
      if (profileLastGeneratedBuilder_ == null) {
        profileLastGeneratedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getProfileLastGenerated(), getParentForChildren(), isClean());
        profileLastGenerated_ = null;
      }
      return profileLastGeneratedBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> resourceLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetResourceLabels() {
      if (resourceLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ResourceLabelsDefaultEntryHolder.defaultEntry);
      }
      return resourceLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableResourceLabels() {
      if (resourceLabels_ == null) {
        resourceLabels_ =
            com.google.protobuf.MapField.newMapField(ResourceLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!resourceLabels_.isMutable()) {
        resourceLabels_ = resourceLabels_.copy();
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return resourceLabels_;
    }

    public int getResourceLabelsCount() {
      return internalGetResourceLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels applied to the resource at the time the profile was generated.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 17;</code>
     */
    @java.lang.Override
    public boolean containsResourceLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetResourceLabels().getMap().containsKey(key);
    }
    /** Use {@link #getResourceLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getResourceLabels() {
      return getResourceLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels applied to the resource at the time the profile was generated.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 17;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getResourceLabelsMap() {
      return internalGetResourceLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels applied to the resource at the time the profile was generated.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 17;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getResourceLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetResourceLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels applied to the resource at the time the profile was generated.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 17;</code>
     */
    @java.lang.Override
    public java.lang.String getResourceLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetResourceLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearResourceLabels() {
      bitField0_ = (bitField0_ & ~0x01000000);
      internalGetMutableResourceLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels applied to the resource at the time the profile was generated.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 17;</code>
     */
    public Builder removeResourceLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableResourceLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableResourceLabels() {
      bitField0_ |= 0x01000000;
      return internalGetMutableResourceLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels applied to the resource at the time the profile was generated.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 17;</code>
     */
    public Builder putResourceLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableResourceLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x01000000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels applied to the resource at the time the profile was generated.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 17;</code>
     */
    public Builder putAllResourceLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableResourceLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x01000000;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the table was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 23;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x02000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which the table was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 23;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the table was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 23;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the table was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 23;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the table was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 23;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x02000000) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x02000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the table was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 23;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x02000000);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the table was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 23;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x02000000;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the table was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 23;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the table was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.TableDataProfile)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.TableDataProfile)
  private static final com.google.privacy.dlp.v2.TableDataProfile DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.TableDataProfile();
  }

  public static com.google.privacy.dlp.v2.TableDataProfile getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TableDataProfile> PARSER =
      new com.google.protobuf.AbstractParser<TableDataProfile>() {
        @java.lang.Override
        public TableDataProfile parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TableDataProfile> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TableDataProfile> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.TableDataProfile getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
