/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * A flattened description of a `PrimitiveTransformation` or
 * `RecordSuppression`.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.TransformationDescription}
 */
public final class TransformationDescription extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.TransformationDescription)
    TransformationDescriptionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransformationDescription.newBuilder() to construct.
  private TransformationDescription(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransformationDescription() {
    type_ = 0;
    description_ = "";
    condition_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransformationDescription();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_TransformationDescription_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_TransformationDescription_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.TransformationDescription.class,
            com.google.privacy.dlp.v2.TransformationDescription.Builder.class);
  }

  private int bitField0_;
  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * The transformation type.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TransformationType type = 1;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * The transformation type.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TransformationType type = 1;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationType getType() {
    com.google.privacy.dlp.v2.TransformationType result =
        com.google.privacy.dlp.v2.TransformationType.forNumber(type_);
    return result == null ? com.google.privacy.dlp.v2.TransformationType.UNRECOGNIZED : result;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * A description of the transformation. This is empty for a
   * RECORD_SUPPRESSION, or is the output of calling toString() on the
   * `PrimitiveTransformation` protocol buffer message for any other type of
   * transformation.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A description of the transformation. This is empty for a
   * RECORD_SUPPRESSION, or is the output of calling toString() on the
   * `PrimitiveTransformation` protocol buffer message for any other type of
   * transformation.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONDITION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object condition_ = "";
  /**
   *
   *
   * <pre>
   * A human-readable string representation of the `RecordCondition`
   * corresponding to this transformation. Set if a `RecordCondition` was used
   * to determine whether or not to apply this transformation.
   *
   * Examples:
   *     * (age_field &gt; 85)
   *     * (age_field &lt;= 18)
   *     * (zip_field exists)
   *     * (zip_field == 01234) &amp;&amp; (city_field != "Springville")
   *     * (zip_field == 01234) &amp;&amp; (age_field &lt;= 18) &amp;&amp; (city_field exists)
   * </pre>
   *
   * <code>string condition = 3;</code>
   *
   * @return The condition.
   */
  @java.lang.Override
  public java.lang.String getCondition() {
    java.lang.Object ref = condition_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      condition_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A human-readable string representation of the `RecordCondition`
   * corresponding to this transformation. Set if a `RecordCondition` was used
   * to determine whether or not to apply this transformation.
   *
   * Examples:
   *     * (age_field &gt; 85)
   *     * (age_field &lt;= 18)
   *     * (zip_field exists)
   *     * (zip_field == 01234) &amp;&amp; (city_field != "Springville")
   *     * (zip_field == 01234) &amp;&amp; (age_field &lt;= 18) &amp;&amp; (city_field exists)
   * </pre>
   *
   * <code>string condition = 3;</code>
   *
   * @return The bytes for condition.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConditionBytes() {
    java.lang.Object ref = condition_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      condition_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INFO_TYPE_FIELD_NUMBER = 4;
  private com.google.privacy.dlp.v2.InfoType infoType_;
  /**
   *
   *
   * <pre>
   * Set if the transformation was limited to a specific `InfoType`.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 4;</code>
   *
   * @return Whether the infoType field is set.
   */
  @java.lang.Override
  public boolean hasInfoType() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Set if the transformation was limited to a specific `InfoType`.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 4;</code>
   *
   * @return The infoType.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoType getInfoType() {
    return infoType_ == null ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance() : infoType_;
  }
  /**
   *
   *
   * <pre>
   * Set if the transformation was limited to a specific `InfoType`.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder() {
    return infoType_ == null ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance() : infoType_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (type_
        != com.google.privacy.dlp.v2.TransformationType.TRANSFORMATION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, condition_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getInfoType());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_
        != com.google.privacy.dlp.v2.TransformationType.TRANSFORMATION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, condition_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getInfoType());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.TransformationDescription)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.TransformationDescription other =
        (com.google.privacy.dlp.v2.TransformationDescription) obj;

    if (type_ != other.type_) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getCondition().equals(other.getCondition())) return false;
    if (hasInfoType() != other.hasInfoType()) return false;
    if (hasInfoType()) {
      if (!getInfoType().equals(other.getInfoType())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + CONDITION_FIELD_NUMBER;
    hash = (53 * hash) + getCondition().hashCode();
    if (hasInfoType()) {
      hash = (37 * hash) + INFO_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getInfoType().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.TransformationDescription parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TransformationDescription parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationDescription parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TransformationDescription parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationDescription parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TransformationDescription parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationDescription parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TransformationDescription parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationDescription parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TransformationDescription parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationDescription parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TransformationDescription parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.TransformationDescription prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A flattened description of a `PrimitiveTransformation` or
   * `RecordSuppression`.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.TransformationDescription}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.TransformationDescription)
      com.google.privacy.dlp.v2.TransformationDescriptionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationDescription_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationDescription_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.TransformationDescription.class,
              com.google.privacy.dlp.v2.TransformationDescription.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.TransformationDescription.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInfoTypeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = 0;
      description_ = "";
      condition_ = "";
      infoType_ = null;
      if (infoTypeBuilder_ != null) {
        infoTypeBuilder_.dispose();
        infoTypeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationDescription_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationDescription getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.TransformationDescription.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationDescription build() {
      com.google.privacy.dlp.v2.TransformationDescription result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationDescription buildPartial() {
      com.google.privacy.dlp.v2.TransformationDescription result =
          new com.google.privacy.dlp.v2.TransformationDescription(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.TransformationDescription result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.condition_ = condition_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.infoType_ = infoTypeBuilder_ == null ? infoType_ : infoTypeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.TransformationDescription) {
        return mergeFrom((com.google.privacy.dlp.v2.TransformationDescription) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.TransformationDescription other) {
      if (other == com.google.privacy.dlp.v2.TransformationDescription.getDefaultInstance())
        return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getCondition().isEmpty()) {
        condition_ = other.condition_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasInfoType()) {
        mergeInfoType(other.getInfoType());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                condition_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getInfoTypeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The transformation type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationType type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The transformation type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationType type = 1;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transformation type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationType type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationType getType() {
      com.google.privacy.dlp.v2.TransformationType result =
          com.google.privacy.dlp.v2.TransformationType.forNumber(type_);
      return result == null ? com.google.privacy.dlp.v2.TransformationType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The transformation type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationType type = 1;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.privacy.dlp.v2.TransformationType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transformation type.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationType type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A description of the transformation. This is empty for a
     * RECORD_SUPPRESSION, or is the output of calling toString() on the
     * `PrimitiveTransformation` protocol buffer message for any other type of
     * transformation.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of the transformation. This is empty for a
     * RECORD_SUPPRESSION, or is the output of calling toString() on the
     * `PrimitiveTransformation` protocol buffer message for any other type of
     * transformation.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of the transformation. This is empty for a
     * RECORD_SUPPRESSION, or is the output of calling toString() on the
     * `PrimitiveTransformation` protocol buffer message for any other type of
     * transformation.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of the transformation. This is empty for a
     * RECORD_SUPPRESSION, or is the output of calling toString() on the
     * `PrimitiveTransformation` protocol buffer message for any other type of
     * transformation.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of the transformation. This is empty for a
     * RECORD_SUPPRESSION, or is the output of calling toString() on the
     * `PrimitiveTransformation` protocol buffer message for any other type of
     * transformation.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object condition_ = "";
    /**
     *
     *
     * <pre>
     * A human-readable string representation of the `RecordCondition`
     * corresponding to this transformation. Set if a `RecordCondition` was used
     * to determine whether or not to apply this transformation.
     *
     * Examples:
     *     * (age_field &gt; 85)
     *     * (age_field &lt;= 18)
     *     * (zip_field exists)
     *     * (zip_field == 01234) &amp;&amp; (city_field != "Springville")
     *     * (zip_field == 01234) &amp;&amp; (age_field &lt;= 18) &amp;&amp; (city_field exists)
     * </pre>
     *
     * <code>string condition = 3;</code>
     *
     * @return The condition.
     */
    public java.lang.String getCondition() {
      java.lang.Object ref = condition_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        condition_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human-readable string representation of the `RecordCondition`
     * corresponding to this transformation. Set if a `RecordCondition` was used
     * to determine whether or not to apply this transformation.
     *
     * Examples:
     *     * (age_field &gt; 85)
     *     * (age_field &lt;= 18)
     *     * (zip_field exists)
     *     * (zip_field == 01234) &amp;&amp; (city_field != "Springville")
     *     * (zip_field == 01234) &amp;&amp; (age_field &lt;= 18) &amp;&amp; (city_field exists)
     * </pre>
     *
     * <code>string condition = 3;</code>
     *
     * @return The bytes for condition.
     */
    public com.google.protobuf.ByteString getConditionBytes() {
      java.lang.Object ref = condition_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        condition_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human-readable string representation of the `RecordCondition`
     * corresponding to this transformation. Set if a `RecordCondition` was used
     * to determine whether or not to apply this transformation.
     *
     * Examples:
     *     * (age_field &gt; 85)
     *     * (age_field &lt;= 18)
     *     * (zip_field exists)
     *     * (zip_field == 01234) &amp;&amp; (city_field != "Springville")
     *     * (zip_field == 01234) &amp;&amp; (age_field &lt;= 18) &amp;&amp; (city_field exists)
     * </pre>
     *
     * <code>string condition = 3;</code>
     *
     * @param value The condition to set.
     * @return This builder for chaining.
     */
    public Builder setCondition(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      condition_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human-readable string representation of the `RecordCondition`
     * corresponding to this transformation. Set if a `RecordCondition` was used
     * to determine whether or not to apply this transformation.
     *
     * Examples:
     *     * (age_field &gt; 85)
     *     * (age_field &lt;= 18)
     *     * (zip_field exists)
     *     * (zip_field == 01234) &amp;&amp; (city_field != "Springville")
     *     * (zip_field == 01234) &amp;&amp; (age_field &lt;= 18) &amp;&amp; (city_field exists)
     * </pre>
     *
     * <code>string condition = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCondition() {
      condition_ = getDefaultInstance().getCondition();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human-readable string representation of the `RecordCondition`
     * corresponding to this transformation. Set if a `RecordCondition` was used
     * to determine whether or not to apply this transformation.
     *
     * Examples:
     *     * (age_field &gt; 85)
     *     * (age_field &lt;= 18)
     *     * (zip_field exists)
     *     * (zip_field == 01234) &amp;&amp; (city_field != "Springville")
     *     * (zip_field == 01234) &amp;&amp; (age_field &lt;= 18) &amp;&amp; (city_field exists)
     * </pre>
     *
     * <code>string condition = 3;</code>
     *
     * @param value The bytes for condition to set.
     * @return This builder for chaining.
     */
    public Builder setConditionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      condition_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.InfoType infoType_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoType,
            com.google.privacy.dlp.v2.InfoType.Builder,
            com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        infoTypeBuilder_;
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 4;</code>
     *
     * @return Whether the infoType field is set.
     */
    public boolean hasInfoType() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 4;</code>
     *
     * @return The infoType.
     */
    public com.google.privacy.dlp.v2.InfoType getInfoType() {
      if (infoTypeBuilder_ == null) {
        return infoType_ == null
            ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
            : infoType_;
      } else {
        return infoTypeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 4;</code>
     */
    public Builder setInfoType(com.google.privacy.dlp.v2.InfoType value) {
      if (infoTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        infoType_ = value;
      } else {
        infoTypeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 4;</code>
     */
    public Builder setInfoType(com.google.privacy.dlp.v2.InfoType.Builder builderForValue) {
      if (infoTypeBuilder_ == null) {
        infoType_ = builderForValue.build();
      } else {
        infoTypeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 4;</code>
     */
    public Builder mergeInfoType(com.google.privacy.dlp.v2.InfoType value) {
      if (infoTypeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && infoType_ != null
            && infoType_ != com.google.privacy.dlp.v2.InfoType.getDefaultInstance()) {
          getInfoTypeBuilder().mergeFrom(value);
        } else {
          infoType_ = value;
        }
      } else {
        infoTypeBuilder_.mergeFrom(value);
      }
      if (infoType_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 4;</code>
     */
    public Builder clearInfoType() {
      bitField0_ = (bitField0_ & ~0x00000008);
      infoType_ = null;
      if (infoTypeBuilder_ != null) {
        infoTypeBuilder_.dispose();
        infoTypeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 4;</code>
     */
    public com.google.privacy.dlp.v2.InfoType.Builder getInfoTypeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getInfoTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 4;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder() {
      if (infoTypeBuilder_ != null) {
        return infoTypeBuilder_.getMessageOrBuilder();
      } else {
        return infoType_ == null
            ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
            : infoType_;
      }
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific `InfoType`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoType,
            com.google.privacy.dlp.v2.InfoType.Builder,
            com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        getInfoTypeFieldBuilder() {
      if (infoTypeBuilder_ == null) {
        infoTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InfoType,
                com.google.privacy.dlp.v2.InfoType.Builder,
                com.google.privacy.dlp.v2.InfoTypeOrBuilder>(
                getInfoType(), getParentForChildren(), isClean());
        infoType_ = null;
      }
      return infoTypeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.TransformationDescription)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.TransformationDescription)
  private static final com.google.privacy.dlp.v2.TransformationDescription DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.TransformationDescription();
  }

  public static com.google.privacy.dlp.v2.TransformationDescription getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransformationDescription> PARSER =
      new com.google.protobuf.AbstractParser<TransformationDescription>() {
        @java.lang.Override
        public TransformationDescription parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransformationDescription> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransformationDescription> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationDescription getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
