/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Summary of a single transformation.
 * Only one of 'transformation', 'field_transformation', or 'record_suppress'
 * will be set.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.TransformationSummary}
 */
public final class TransformationSummary extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.TransformationSummary)
    TransformationSummaryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransformationSummary.newBuilder() to construct.
  private TransformationSummary(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransformationSummary() {
    fieldTransformations_ = java.util.Collections.emptyList();
    results_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransformationSummary();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_TransformationSummary_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_TransformationSummary_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.TransformationSummary.class,
            com.google.privacy.dlp.v2.TransformationSummary.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible outcomes of transformations.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.TransformationSummary.TransformationResultCode}
   */
  public enum TransformationResultCode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused
     * </pre>
     *
     * <code>TRANSFORMATION_RESULT_CODE_UNSPECIFIED = 0;</code>
     */
    TRANSFORMATION_RESULT_CODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Transformation completed without an error.
     * </pre>
     *
     * <code>SUCCESS = 1;</code>
     */
    SUCCESS(1),
    /**
     *
     *
     * <pre>
     * Transformation had an error.
     * </pre>
     *
     * <code>ERROR = 2;</code>
     */
    ERROR(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused
     * </pre>
     *
     * <code>TRANSFORMATION_RESULT_CODE_UNSPECIFIED = 0;</code>
     */
    public static final int TRANSFORMATION_RESULT_CODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Transformation completed without an error.
     * </pre>
     *
     * <code>SUCCESS = 1;</code>
     */
    public static final int SUCCESS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Transformation had an error.
     * </pre>
     *
     * <code>ERROR = 2;</code>
     */
    public static final int ERROR_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TransformationResultCode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TransformationResultCode forNumber(int value) {
      switch (value) {
        case 0:
          return TRANSFORMATION_RESULT_CODE_UNSPECIFIED;
        case 1:
          return SUCCESS;
        case 2:
          return ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TransformationResultCode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TransformationResultCode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<TransformationResultCode>() {
              public TransformationResultCode findValueByNumber(int number) {
                return TransformationResultCode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.TransformationSummary.getDescriptor().getEnumTypes().get(0);
    }

    private static final TransformationResultCode[] VALUES = values();

    public static TransformationResultCode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TransformationResultCode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.TransformationSummary.TransformationResultCode)
  }

  public interface SummaryResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.TransformationSummary.SummaryResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Number of transformations counted by this result.
     * </pre>
     *
     * <code>int64 count = 1;</code>
     *
     * @return The count.
     */
    long getCount();

    /**
     *
     *
     * <pre>
     * Outcome of the transformation.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode code = 2;</code>
     *
     * @return The enum numeric value on the wire for code.
     */
    int getCodeValue();
    /**
     *
     *
     * <pre>
     * Outcome of the transformation.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode code = 2;</code>
     *
     * @return The code.
     */
    com.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode getCode();

    /**
     *
     *
     * <pre>
     * A place for warnings or errors to show up if a transformation didn't
     * work as expected.
     * </pre>
     *
     * <code>string details = 3;</code>
     *
     * @return The details.
     */
    java.lang.String getDetails();
    /**
     *
     *
     * <pre>
     * A place for warnings or errors to show up if a transformation didn't
     * work as expected.
     * </pre>
     *
     * <code>string details = 3;</code>
     *
     * @return The bytes for details.
     */
    com.google.protobuf.ByteString getDetailsBytes();
  }
  /**
   *
   *
   * <pre>
   * A collection that informs the user the number of times a particular
   * `TransformationResultCode` and error details occurred.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.TransformationSummary.SummaryResult}
   */
  public static final class SummaryResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.TransformationSummary.SummaryResult)
      SummaryResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SummaryResult.newBuilder() to construct.
    private SummaryResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SummaryResult() {
      code_ = 0;
      details_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SummaryResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationSummary_SummaryResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationSummary_SummaryResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.class,
              com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.Builder.class);
    }

    public static final int COUNT_FIELD_NUMBER = 1;
    private long count_ = 0L;
    /**
     *
     *
     * <pre>
     * Number of transformations counted by this result.
     * </pre>
     *
     * <code>int64 count = 1;</code>
     *
     * @return The count.
     */
    @java.lang.Override
    public long getCount() {
      return count_;
    }

    public static final int CODE_FIELD_NUMBER = 2;
    private int code_ = 0;
    /**
     *
     *
     * <pre>
     * Outcome of the transformation.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode code = 2;</code>
     *
     * @return The enum numeric value on the wire for code.
     */
    @java.lang.Override
    public int getCodeValue() {
      return code_;
    }
    /**
     *
     *
     * <pre>
     * Outcome of the transformation.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode code = 2;</code>
     *
     * @return The code.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode getCode() {
      com.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode result =
          com.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode.forNumber(code_);
      return result == null
          ? com.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode.UNRECOGNIZED
          : result;
    }

    public static final int DETAILS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object details_ = "";
    /**
     *
     *
     * <pre>
     * A place for warnings or errors to show up if a transformation didn't
     * work as expected.
     * </pre>
     *
     * <code>string details = 3;</code>
     *
     * @return The details.
     */
    @java.lang.Override
    public java.lang.String getDetails() {
      java.lang.Object ref = details_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        details_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A place for warnings or errors to show up if a transformation didn't
     * work as expected.
     * </pre>
     *
     * <code>string details = 3;</code>
     *
     * @return The bytes for details.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDetailsBytes() {
      java.lang.Object ref = details_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        details_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (count_ != 0L) {
        output.writeInt64(1, count_);
      }
      if (code_
          != com.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode
              .TRANSFORMATION_RESULT_CODE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, code_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(details_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, details_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (count_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, count_);
      }
      if (code_
          != com.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode
              .TRANSFORMATION_RESULT_CODE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, code_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(details_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, details_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.TransformationSummary.SummaryResult)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.TransformationSummary.SummaryResult other =
          (com.google.privacy.dlp.v2.TransformationSummary.SummaryResult) obj;

      if (getCount() != other.getCount()) return false;
      if (code_ != other.code_) return false;
      if (!getDetails().equals(other.getDetails())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCount());
      hash = (37 * hash) + CODE_FIELD_NUMBER;
      hash = (53 * hash) + code_;
      hash = (37 * hash) + DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getDetails().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.TransformationSummary.SummaryResult parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.TransformationSummary.SummaryResult parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.TransformationSummary.SummaryResult parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.TransformationSummary.SummaryResult parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.TransformationSummary.SummaryResult parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.TransformationSummary.SummaryResult parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.TransformationSummary.SummaryResult parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.TransformationSummary.SummaryResult parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.TransformationSummary.SummaryResult parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.TransformationSummary.SummaryResult parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.TransformationSummary.SummaryResult parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.TransformationSummary.SummaryResult parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.TransformationSummary.SummaryResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A collection that informs the user the number of times a particular
     * `TransformationResultCode` and error details occurred.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.TransformationSummary.SummaryResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.TransformationSummary.SummaryResult)
        com.google.privacy.dlp.v2.TransformationSummary.SummaryResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_TransformationSummary_SummaryResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_TransformationSummary_SummaryResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.class,
                com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        count_ = 0L;
        code_ = 0;
        details_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_TransformationSummary_SummaryResult_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.TransformationSummary.SummaryResult
          getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.TransformationSummary.SummaryResult build() {
        com.google.privacy.dlp.v2.TransformationSummary.SummaryResult result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.TransformationSummary.SummaryResult buildPartial() {
        com.google.privacy.dlp.v2.TransformationSummary.SummaryResult result =
            new com.google.privacy.dlp.v2.TransformationSummary.SummaryResult(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.privacy.dlp.v2.TransformationSummary.SummaryResult result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.count_ = count_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.code_ = code_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.details_ = details_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.TransformationSummary.SummaryResult) {
          return mergeFrom((com.google.privacy.dlp.v2.TransformationSummary.SummaryResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.privacy.dlp.v2.TransformationSummary.SummaryResult other) {
        if (other
            == com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.getDefaultInstance())
          return this;
        if (other.getCount() != 0L) {
          setCount(other.getCount());
        }
        if (other.code_ != 0) {
          setCodeValue(other.getCodeValue());
        }
        if (!other.getDetails().isEmpty()) {
          details_ = other.details_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  count_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  code_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  details_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long count_;
      /**
       *
       *
       * <pre>
       * Number of transformations counted by this result.
       * </pre>
       *
       * <code>int64 count = 1;</code>
       *
       * @return The count.
       */
      @java.lang.Override
      public long getCount() {
        return count_;
      }
      /**
       *
       *
       * <pre>
       * Number of transformations counted by this result.
       * </pre>
       *
       * <code>int64 count = 1;</code>
       *
       * @param value The count to set.
       * @return This builder for chaining.
       */
      public Builder setCount(long value) {

        count_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of transformations counted by this result.
       * </pre>
       *
       * <code>int64 count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        count_ = 0L;
        onChanged();
        return this;
      }

      private int code_ = 0;
      /**
       *
       *
       * <pre>
       * Outcome of the transformation.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode code = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for code.
       */
      @java.lang.Override
      public int getCodeValue() {
        return code_;
      }
      /**
       *
       *
       * <pre>
       * Outcome of the transformation.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode code = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for code to set.
       * @return This builder for chaining.
       */
      public Builder setCodeValue(int value) {
        code_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Outcome of the transformation.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode code = 2;
       * </code>
       *
       * @return The code.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode getCode() {
        com.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode result =
            com.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode.forNumber(
                code_);
        return result == null
            ? com.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Outcome of the transformation.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode code = 2;
       * </code>
       *
       * @param value The code to set.
       * @return This builder for chaining.
       */
      public Builder setCode(
          com.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        code_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Outcome of the transformation.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.TransformationSummary.TransformationResultCode code = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCode() {
        bitField0_ = (bitField0_ & ~0x00000002);
        code_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object details_ = "";
      /**
       *
       *
       * <pre>
       * A place for warnings or errors to show up if a transformation didn't
       * work as expected.
       * </pre>
       *
       * <code>string details = 3;</code>
       *
       * @return The details.
       */
      public java.lang.String getDetails() {
        java.lang.Object ref = details_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          details_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A place for warnings or errors to show up if a transformation didn't
       * work as expected.
       * </pre>
       *
       * <code>string details = 3;</code>
       *
       * @return The bytes for details.
       */
      public com.google.protobuf.ByteString getDetailsBytes() {
        java.lang.Object ref = details_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          details_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A place for warnings or errors to show up if a transformation didn't
       * work as expected.
       * </pre>
       *
       * <code>string details = 3;</code>
       *
       * @param value The details to set.
       * @return This builder for chaining.
       */
      public Builder setDetails(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A place for warnings or errors to show up if a transformation didn't
       * work as expected.
       * </pre>
       *
       * <code>string details = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDetails() {
        details_ = getDefaultInstance().getDetails();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A place for warnings or errors to show up if a transformation didn't
       * work as expected.
       * </pre>
       *
       * <code>string details = 3;</code>
       *
       * @param value The bytes for details to set.
       * @return This builder for chaining.
       */
      public Builder setDetailsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        details_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.TransformationSummary.SummaryResult)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.TransformationSummary.SummaryResult)
    private static final com.google.privacy.dlp.v2.TransformationSummary.SummaryResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.TransformationSummary.SummaryResult();
    }

    public static com.google.privacy.dlp.v2.TransformationSummary.SummaryResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SummaryResult> PARSER =
        new com.google.protobuf.AbstractParser<SummaryResult>() {
          @java.lang.Override
          public SummaryResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SummaryResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SummaryResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationSummary.SummaryResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int INFO_TYPE_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.InfoType infoType_;
  /**
   *
   *
   * <pre>
   * Set if the transformation was limited to a specific InfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
   *
   * @return Whether the infoType field is set.
   */
  @java.lang.Override
  public boolean hasInfoType() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Set if the transformation was limited to a specific InfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
   *
   * @return The infoType.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoType getInfoType() {
    return infoType_ == null ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance() : infoType_;
  }
  /**
   *
   *
   * <pre>
   * Set if the transformation was limited to a specific InfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder() {
    return infoType_ == null ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance() : infoType_;
  }

  public static final int FIELD_FIELD_NUMBER = 2;
  private com.google.privacy.dlp.v2.FieldId field_;
  /**
   *
   *
   * <pre>
   * Set if the transformation was limited to a specific FieldId.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.FieldId field = 2;</code>
   *
   * @return Whether the field field is set.
   */
  @java.lang.Override
  public boolean hasField() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Set if the transformation was limited to a specific FieldId.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.FieldId field = 2;</code>
   *
   * @return The field.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldId getField() {
    return field_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : field_;
  }
  /**
   *
   *
   * <pre>
   * Set if the transformation was limited to a specific FieldId.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.FieldId field = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldIdOrBuilder getFieldOrBuilder() {
    return field_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : field_;
  }

  public static final int TRANSFORMATION_FIELD_NUMBER = 3;
  private com.google.privacy.dlp.v2.PrimitiveTransformation transformation_;
  /**
   *
   *
   * <pre>
   * The specific transformation these stats apply to.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.PrimitiveTransformation transformation = 3;</code>
   *
   * @return Whether the transformation field is set.
   */
  @java.lang.Override
  public boolean hasTransformation() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The specific transformation these stats apply to.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.PrimitiveTransformation transformation = 3;</code>
   *
   * @return The transformation.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.PrimitiveTransformation getTransformation() {
    return transformation_ == null
        ? com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance()
        : transformation_;
  }
  /**
   *
   *
   * <pre>
   * The specific transformation these stats apply to.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.PrimitiveTransformation transformation = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder getTransformationOrBuilder() {
    return transformation_ == null
        ? com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance()
        : transformation_;
  }

  public static final int FIELD_TRANSFORMATIONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.FieldTransformation> fieldTransformations_;
  /**
   *
   *
   * <pre>
   * The field transformation that was applied.
   * If multiple field transformations are requested for a single field,
   * this list will contain all of them; otherwise, only one is supplied.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.FieldTransformation>
      getFieldTransformationsList() {
    return fieldTransformations_;
  }
  /**
   *
   *
   * <pre>
   * The field transformation that was applied.
   * If multiple field transformations are requested for a single field,
   * this list will contain all of them; otherwise, only one is supplied.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.FieldTransformationOrBuilder>
      getFieldTransformationsOrBuilderList() {
    return fieldTransformations_;
  }
  /**
   *
   *
   * <pre>
   * The field transformation that was applied.
   * If multiple field transformations are requested for a single field,
   * this list will contain all of them; otherwise, only one is supplied.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
   */
  @java.lang.Override
  public int getFieldTransformationsCount() {
    return fieldTransformations_.size();
  }
  /**
   *
   *
   * <pre>
   * The field transformation that was applied.
   * If multiple field transformations are requested for a single field,
   * this list will contain all of them; otherwise, only one is supplied.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldTransformation getFieldTransformations(int index) {
    return fieldTransformations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The field transformation that was applied.
   * If multiple field transformations are requested for a single field,
   * this list will contain all of them; otherwise, only one is supplied.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldTransformationOrBuilder getFieldTransformationsOrBuilder(
      int index) {
    return fieldTransformations_.get(index);
  }

  public static final int RECORD_SUPPRESS_FIELD_NUMBER = 6;
  private com.google.privacy.dlp.v2.RecordSuppression recordSuppress_;
  /**
   *
   *
   * <pre>
   * The specific suppression option these stats apply to.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordSuppression record_suppress = 6;</code>
   *
   * @return Whether the recordSuppress field is set.
   */
  @java.lang.Override
  public boolean hasRecordSuppress() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The specific suppression option these stats apply to.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordSuppression record_suppress = 6;</code>
   *
   * @return The recordSuppress.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RecordSuppression getRecordSuppress() {
    return recordSuppress_ == null
        ? com.google.privacy.dlp.v2.RecordSuppression.getDefaultInstance()
        : recordSuppress_;
  }
  /**
   *
   *
   * <pre>
   * The specific suppression option these stats apply to.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordSuppression record_suppress = 6;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RecordSuppressionOrBuilder getRecordSuppressOrBuilder() {
    return recordSuppress_ == null
        ? com.google.privacy.dlp.v2.RecordSuppression.getDefaultInstance()
        : recordSuppress_;
  }

  public static final int RESULTS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.TransformationSummary.SummaryResult> results_;
  /**
   *
   *
   * <pre>
   * Collection of all transformations that took place or had an error.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.TransformationSummary.SummaryResult>
      getResultsList() {
    return results_;
  }
  /**
   *
   *
   * <pre>
   * Collection of all transformations that took place or had an error.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.privacy.dlp.v2.TransformationSummary.SummaryResultOrBuilder>
      getResultsOrBuilderList() {
    return results_;
  }
  /**
   *
   *
   * <pre>
   * Collection of all transformations that took place or had an error.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
   */
  @java.lang.Override
  public int getResultsCount() {
    return results_.size();
  }
  /**
   *
   *
   * <pre>
   * Collection of all transformations that took place or had an error.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationSummary.SummaryResult getResults(int index) {
    return results_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Collection of all transformations that took place or had an error.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationSummary.SummaryResultOrBuilder getResultsOrBuilder(
      int index) {
    return results_.get(index);
  }

  public static final int TRANSFORMED_BYTES_FIELD_NUMBER = 7;
  private long transformedBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * Total size in bytes that were transformed in some way.
   * </pre>
   *
   * <code>int64 transformed_bytes = 7;</code>
   *
   * @return The transformedBytes.
   */
  @java.lang.Override
  public long getTransformedBytes() {
    return transformedBytes_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getInfoType());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getField());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getTransformation());
    }
    for (int i = 0; i < results_.size(); i++) {
      output.writeMessage(4, results_.get(i));
    }
    for (int i = 0; i < fieldTransformations_.size(); i++) {
      output.writeMessage(5, fieldTransformations_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(6, getRecordSuppress());
    }
    if (transformedBytes_ != 0L) {
      output.writeInt64(7, transformedBytes_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInfoType());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getField());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTransformation());
    }
    for (int i = 0; i < results_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, results_.get(i));
    }
    for (int i = 0; i < fieldTransformations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, fieldTransformations_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getRecordSuppress());
    }
    if (transformedBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, transformedBytes_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.TransformationSummary)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.TransformationSummary other =
        (com.google.privacy.dlp.v2.TransformationSummary) obj;

    if (hasInfoType() != other.hasInfoType()) return false;
    if (hasInfoType()) {
      if (!getInfoType().equals(other.getInfoType())) return false;
    }
    if (hasField() != other.hasField()) return false;
    if (hasField()) {
      if (!getField().equals(other.getField())) return false;
    }
    if (hasTransformation() != other.hasTransformation()) return false;
    if (hasTransformation()) {
      if (!getTransformation().equals(other.getTransformation())) return false;
    }
    if (!getFieldTransformationsList().equals(other.getFieldTransformationsList())) return false;
    if (hasRecordSuppress() != other.hasRecordSuppress()) return false;
    if (hasRecordSuppress()) {
      if (!getRecordSuppress().equals(other.getRecordSuppress())) return false;
    }
    if (!getResultsList().equals(other.getResultsList())) return false;
    if (getTransformedBytes() != other.getTransformedBytes()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasInfoType()) {
      hash = (37 * hash) + INFO_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getInfoType().hashCode();
    }
    if (hasField()) {
      hash = (37 * hash) + FIELD_FIELD_NUMBER;
      hash = (53 * hash) + getField().hashCode();
    }
    if (hasTransformation()) {
      hash = (37 * hash) + TRANSFORMATION_FIELD_NUMBER;
      hash = (53 * hash) + getTransformation().hashCode();
    }
    if (getFieldTransformationsCount() > 0) {
      hash = (37 * hash) + FIELD_TRANSFORMATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFieldTransformationsList().hashCode();
    }
    if (hasRecordSuppress()) {
      hash = (37 * hash) + RECORD_SUPPRESS_FIELD_NUMBER;
      hash = (53 * hash) + getRecordSuppress().hashCode();
    }
    if (getResultsCount() > 0) {
      hash = (37 * hash) + RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getResultsList().hashCode();
    }
    hash = (37 * hash) + TRANSFORMED_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTransformedBytes());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.TransformationSummary parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TransformationSummary parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationSummary parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TransformationSummary parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationSummary parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TransformationSummary parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationSummary parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TransformationSummary parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationSummary parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TransformationSummary parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationSummary parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TransformationSummary parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.TransformationSummary prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Summary of a single transformation.
   * Only one of 'transformation', 'field_transformation', or 'record_suppress'
   * will be set.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.TransformationSummary}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.TransformationSummary)
      com.google.privacy.dlp.v2.TransformationSummaryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationSummary_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationSummary_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.TransformationSummary.class,
              com.google.privacy.dlp.v2.TransformationSummary.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.TransformationSummary.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInfoTypeFieldBuilder();
        getFieldFieldBuilder();
        getTransformationFieldBuilder();
        getFieldTransformationsFieldBuilder();
        getRecordSuppressFieldBuilder();
        getResultsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      infoType_ = null;
      if (infoTypeBuilder_ != null) {
        infoTypeBuilder_.dispose();
        infoTypeBuilder_ = null;
      }
      field_ = null;
      if (fieldBuilder_ != null) {
        fieldBuilder_.dispose();
        fieldBuilder_ = null;
      }
      transformation_ = null;
      if (transformationBuilder_ != null) {
        transformationBuilder_.dispose();
        transformationBuilder_ = null;
      }
      if (fieldTransformationsBuilder_ == null) {
        fieldTransformations_ = java.util.Collections.emptyList();
      } else {
        fieldTransformations_ = null;
        fieldTransformationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      recordSuppress_ = null;
      if (recordSuppressBuilder_ != null) {
        recordSuppressBuilder_.dispose();
        recordSuppressBuilder_ = null;
      }
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
      } else {
        results_ = null;
        resultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      transformedBytes_ = 0L;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationSummary_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationSummary getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.TransformationSummary.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationSummary build() {
      com.google.privacy.dlp.v2.TransformationSummary result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationSummary buildPartial() {
      com.google.privacy.dlp.v2.TransformationSummary result =
          new com.google.privacy.dlp.v2.TransformationSummary(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.privacy.dlp.v2.TransformationSummary result) {
      if (fieldTransformationsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          fieldTransformations_ = java.util.Collections.unmodifiableList(fieldTransformations_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.fieldTransformations_ = fieldTransformations_;
      } else {
        result.fieldTransformations_ = fieldTransformationsBuilder_.build();
      }
      if (resultsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          results_ = java.util.Collections.unmodifiableList(results_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.results_ = results_;
      } else {
        result.results_ = resultsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.privacy.dlp.v2.TransformationSummary result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.infoType_ = infoTypeBuilder_ == null ? infoType_ : infoTypeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.field_ = fieldBuilder_ == null ? field_ : fieldBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.transformation_ =
            transformationBuilder_ == null ? transformation_ : transformationBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.recordSuppress_ =
            recordSuppressBuilder_ == null ? recordSuppress_ : recordSuppressBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.transformedBytes_ = transformedBytes_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.TransformationSummary) {
        return mergeFrom((com.google.privacy.dlp.v2.TransformationSummary) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.TransformationSummary other) {
      if (other == com.google.privacy.dlp.v2.TransformationSummary.getDefaultInstance())
        return this;
      if (other.hasInfoType()) {
        mergeInfoType(other.getInfoType());
      }
      if (other.hasField()) {
        mergeField(other.getField());
      }
      if (other.hasTransformation()) {
        mergeTransformation(other.getTransformation());
      }
      if (fieldTransformationsBuilder_ == null) {
        if (!other.fieldTransformations_.isEmpty()) {
          if (fieldTransformations_.isEmpty()) {
            fieldTransformations_ = other.fieldTransformations_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureFieldTransformationsIsMutable();
            fieldTransformations_.addAll(other.fieldTransformations_);
          }
          onChanged();
        }
      } else {
        if (!other.fieldTransformations_.isEmpty()) {
          if (fieldTransformationsBuilder_.isEmpty()) {
            fieldTransformationsBuilder_.dispose();
            fieldTransformationsBuilder_ = null;
            fieldTransformations_ = other.fieldTransformations_;
            bitField0_ = (bitField0_ & ~0x00000008);
            fieldTransformationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFieldTransformationsFieldBuilder()
                    : null;
          } else {
            fieldTransformationsBuilder_.addAllMessages(other.fieldTransformations_);
          }
        }
      }
      if (other.hasRecordSuppress()) {
        mergeRecordSuppress(other.getRecordSuppress());
      }
      if (resultsBuilder_ == null) {
        if (!other.results_.isEmpty()) {
          if (results_.isEmpty()) {
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureResultsIsMutable();
            results_.addAll(other.results_);
          }
          onChanged();
        }
      } else {
        if (!other.results_.isEmpty()) {
          if (resultsBuilder_.isEmpty()) {
            resultsBuilder_.dispose();
            resultsBuilder_ = null;
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000020);
            resultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResultsFieldBuilder()
                    : null;
          } else {
            resultsBuilder_.addAllMessages(other.results_);
          }
        }
      }
      if (other.getTransformedBytes() != 0L) {
        setTransformedBytes(other.getTransformedBytes());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getInfoTypeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getFieldFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getTransformationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.privacy.dlp.v2.TransformationSummary.SummaryResult m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.parser(),
                        extensionRegistry);
                if (resultsBuilder_ == null) {
                  ensureResultsIsMutable();
                  results_.add(m);
                } else {
                  resultsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.privacy.dlp.v2.FieldTransformation m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.FieldTransformation.parser(), extensionRegistry);
                if (fieldTransformationsBuilder_ == null) {
                  ensureFieldTransformationsIsMutable();
                  fieldTransformations_.add(m);
                } else {
                  fieldTransformationsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getRecordSuppressFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 56:
              {
                transformedBytes_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.InfoType infoType_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoType,
            com.google.privacy.dlp.v2.InfoType.Builder,
            com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        infoTypeBuilder_;
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific InfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     *
     * @return Whether the infoType field is set.
     */
    public boolean hasInfoType() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific InfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     *
     * @return The infoType.
     */
    public com.google.privacy.dlp.v2.InfoType getInfoType() {
      if (infoTypeBuilder_ == null) {
        return infoType_ == null
            ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
            : infoType_;
      } else {
        return infoTypeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific InfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     */
    public Builder setInfoType(com.google.privacy.dlp.v2.InfoType value) {
      if (infoTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        infoType_ = value;
      } else {
        infoTypeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific InfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     */
    public Builder setInfoType(com.google.privacy.dlp.v2.InfoType.Builder builderForValue) {
      if (infoTypeBuilder_ == null) {
        infoType_ = builderForValue.build();
      } else {
        infoTypeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific InfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     */
    public Builder mergeInfoType(com.google.privacy.dlp.v2.InfoType value) {
      if (infoTypeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && infoType_ != null
            && infoType_ != com.google.privacy.dlp.v2.InfoType.getDefaultInstance()) {
          getInfoTypeBuilder().mergeFrom(value);
        } else {
          infoType_ = value;
        }
      } else {
        infoTypeBuilder_.mergeFrom(value);
      }
      if (infoType_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific InfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     */
    public Builder clearInfoType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      infoType_ = null;
      if (infoTypeBuilder_ != null) {
        infoTypeBuilder_.dispose();
        infoTypeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific InfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     */
    public com.google.privacy.dlp.v2.InfoType.Builder getInfoTypeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getInfoTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific InfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder() {
      if (infoTypeBuilder_ != null) {
        return infoTypeBuilder_.getMessageOrBuilder();
      } else {
        return infoType_ == null
            ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
            : infoType_;
      }
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific InfoType.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoType,
            com.google.privacy.dlp.v2.InfoType.Builder,
            com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        getInfoTypeFieldBuilder() {
      if (infoTypeBuilder_ == null) {
        infoTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InfoType,
                com.google.privacy.dlp.v2.InfoType.Builder,
                com.google.privacy.dlp.v2.InfoTypeOrBuilder>(
                getInfoType(), getParentForChildren(), isClean());
        infoType_ = null;
      }
      return infoTypeBuilder_;
    }

    private com.google.privacy.dlp.v2.FieldId field_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        fieldBuilder_;
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific FieldId.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 2;</code>
     *
     * @return Whether the field field is set.
     */
    public boolean hasField() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific FieldId.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 2;</code>
     *
     * @return The field.
     */
    public com.google.privacy.dlp.v2.FieldId getField() {
      if (fieldBuilder_ == null) {
        return field_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : field_;
      } else {
        return fieldBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific FieldId.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 2;</code>
     */
    public Builder setField(com.google.privacy.dlp.v2.FieldId value) {
      if (fieldBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        field_ = value;
      } else {
        fieldBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific FieldId.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 2;</code>
     */
    public Builder setField(com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (fieldBuilder_ == null) {
        field_ = builderForValue.build();
      } else {
        fieldBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific FieldId.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 2;</code>
     */
    public Builder mergeField(com.google.privacy.dlp.v2.FieldId value) {
      if (fieldBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && field_ != null
            && field_ != com.google.privacy.dlp.v2.FieldId.getDefaultInstance()) {
          getFieldBuilder().mergeFrom(value);
        } else {
          field_ = value;
        }
      } else {
        fieldBuilder_.mergeFrom(value);
      }
      if (field_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific FieldId.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 2;</code>
     */
    public Builder clearField() {
      bitField0_ = (bitField0_ & ~0x00000002);
      field_ = null;
      if (fieldBuilder_ != null) {
        fieldBuilder_.dispose();
        fieldBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific FieldId.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 2;</code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder getFieldBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getFieldFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific FieldId.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 2;</code>
     */
    public com.google.privacy.dlp.v2.FieldIdOrBuilder getFieldOrBuilder() {
      if (fieldBuilder_ != null) {
        return fieldBuilder_.getMessageOrBuilder();
      } else {
        return field_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : field_;
      }
    }
    /**
     *
     *
     * <pre>
     * Set if the transformation was limited to a specific FieldId.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId field = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        getFieldFieldBuilder() {
      if (fieldBuilder_ == null) {
        fieldBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.FieldId,
                com.google.privacy.dlp.v2.FieldId.Builder,
                com.google.privacy.dlp.v2.FieldIdOrBuilder>(
                getField(), getParentForChildren(), isClean());
        field_ = null;
      }
      return fieldBuilder_;
    }

    private com.google.privacy.dlp.v2.PrimitiveTransformation transformation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.PrimitiveTransformation,
            com.google.privacy.dlp.v2.PrimitiveTransformation.Builder,
            com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder>
        transformationBuilder_;
    /**
     *
     *
     * <pre>
     * The specific transformation these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation transformation = 3;</code>
     *
     * @return Whether the transformation field is set.
     */
    public boolean hasTransformation() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The specific transformation these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation transformation = 3;</code>
     *
     * @return The transformation.
     */
    public com.google.privacy.dlp.v2.PrimitiveTransformation getTransformation() {
      if (transformationBuilder_ == null) {
        return transformation_ == null
            ? com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance()
            : transformation_;
      } else {
        return transformationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The specific transformation these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation transformation = 3;</code>
     */
    public Builder setTransformation(com.google.privacy.dlp.v2.PrimitiveTransformation value) {
      if (transformationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
      } else {
        transformationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specific transformation these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation transformation = 3;</code>
     */
    public Builder setTransformation(
        com.google.privacy.dlp.v2.PrimitiveTransformation.Builder builderForValue) {
      if (transformationBuilder_ == null) {
        transformation_ = builderForValue.build();
      } else {
        transformationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specific transformation these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation transformation = 3;</code>
     */
    public Builder mergeTransformation(com.google.privacy.dlp.v2.PrimitiveTransformation value) {
      if (transformationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && transformation_ != null
            && transformation_
                != com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance()) {
          getTransformationBuilder().mergeFrom(value);
        } else {
          transformation_ = value;
        }
      } else {
        transformationBuilder_.mergeFrom(value);
      }
      if (transformation_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specific transformation these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation transformation = 3;</code>
     */
    public Builder clearTransformation() {
      bitField0_ = (bitField0_ & ~0x00000004);
      transformation_ = null;
      if (transformationBuilder_ != null) {
        transformationBuilder_.dispose();
        transformationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specific transformation these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation transformation = 3;</code>
     */
    public com.google.privacy.dlp.v2.PrimitiveTransformation.Builder getTransformationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getTransformationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The specific transformation these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation transformation = 3;</code>
     */
    public com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder getTransformationOrBuilder() {
      if (transformationBuilder_ != null) {
        return transformationBuilder_.getMessageOrBuilder();
      } else {
        return transformation_ == null
            ? com.google.privacy.dlp.v2.PrimitiveTransformation.getDefaultInstance()
            : transformation_;
      }
    }
    /**
     *
     *
     * <pre>
     * The specific transformation these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrimitiveTransformation transformation = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.PrimitiveTransformation,
            com.google.privacy.dlp.v2.PrimitiveTransformation.Builder,
            com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder>
        getTransformationFieldBuilder() {
      if (transformationBuilder_ == null) {
        transformationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.PrimitiveTransformation,
                com.google.privacy.dlp.v2.PrimitiveTransformation.Builder,
                com.google.privacy.dlp.v2.PrimitiveTransformationOrBuilder>(
                getTransformation(), getParentForChildren(), isClean());
        transformation_ = null;
      }
      return transformationBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.FieldTransformation> fieldTransformations_ =
        java.util.Collections.emptyList();

    private void ensureFieldTransformationsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        fieldTransformations_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.FieldTransformation>(
                fieldTransformations_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldTransformation,
            com.google.privacy.dlp.v2.FieldTransformation.Builder,
            com.google.privacy.dlp.v2.FieldTransformationOrBuilder>
        fieldTransformationsBuilder_;

    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.FieldTransformation>
        getFieldTransformationsList() {
      if (fieldTransformationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fieldTransformations_);
      } else {
        return fieldTransformationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public int getFieldTransformationsCount() {
      if (fieldTransformationsBuilder_ == null) {
        return fieldTransformations_.size();
      } else {
        return fieldTransformationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public com.google.privacy.dlp.v2.FieldTransformation getFieldTransformations(int index) {
      if (fieldTransformationsBuilder_ == null) {
        return fieldTransformations_.get(index);
      } else {
        return fieldTransformationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public Builder setFieldTransformations(
        int index, com.google.privacy.dlp.v2.FieldTransformation value) {
      if (fieldTransformationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldTransformationsIsMutable();
        fieldTransformations_.set(index, value);
        onChanged();
      } else {
        fieldTransformationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public Builder setFieldTransformations(
        int index, com.google.privacy.dlp.v2.FieldTransformation.Builder builderForValue) {
      if (fieldTransformationsBuilder_ == null) {
        ensureFieldTransformationsIsMutable();
        fieldTransformations_.set(index, builderForValue.build());
        onChanged();
      } else {
        fieldTransformationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public Builder addFieldTransformations(com.google.privacy.dlp.v2.FieldTransformation value) {
      if (fieldTransformationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldTransformationsIsMutable();
        fieldTransformations_.add(value);
        onChanged();
      } else {
        fieldTransformationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public Builder addFieldTransformations(
        int index, com.google.privacy.dlp.v2.FieldTransformation value) {
      if (fieldTransformationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldTransformationsIsMutable();
        fieldTransformations_.add(index, value);
        onChanged();
      } else {
        fieldTransformationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public Builder addFieldTransformations(
        com.google.privacy.dlp.v2.FieldTransformation.Builder builderForValue) {
      if (fieldTransformationsBuilder_ == null) {
        ensureFieldTransformationsIsMutable();
        fieldTransformations_.add(builderForValue.build());
        onChanged();
      } else {
        fieldTransformationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public Builder addFieldTransformations(
        int index, com.google.privacy.dlp.v2.FieldTransformation.Builder builderForValue) {
      if (fieldTransformationsBuilder_ == null) {
        ensureFieldTransformationsIsMutable();
        fieldTransformations_.add(index, builderForValue.build());
        onChanged();
      } else {
        fieldTransformationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public Builder addAllFieldTransformations(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.FieldTransformation> values) {
      if (fieldTransformationsBuilder_ == null) {
        ensureFieldTransformationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fieldTransformations_);
        onChanged();
      } else {
        fieldTransformationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public Builder clearFieldTransformations() {
      if (fieldTransformationsBuilder_ == null) {
        fieldTransformations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        fieldTransformationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public Builder removeFieldTransformations(int index) {
      if (fieldTransformationsBuilder_ == null) {
        ensureFieldTransformationsIsMutable();
        fieldTransformations_.remove(index);
        onChanged();
      } else {
        fieldTransformationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public com.google.privacy.dlp.v2.FieldTransformation.Builder getFieldTransformationsBuilder(
        int index) {
      return getFieldTransformationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public com.google.privacy.dlp.v2.FieldTransformationOrBuilder getFieldTransformationsOrBuilder(
        int index) {
      if (fieldTransformationsBuilder_ == null) {
        return fieldTransformations_.get(index);
      } else {
        return fieldTransformationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.FieldTransformationOrBuilder>
        getFieldTransformationsOrBuilderList() {
      if (fieldTransformationsBuilder_ != null) {
        return fieldTransformationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fieldTransformations_);
      }
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public com.google.privacy.dlp.v2.FieldTransformation.Builder addFieldTransformationsBuilder() {
      return getFieldTransformationsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.FieldTransformation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public com.google.privacy.dlp.v2.FieldTransformation.Builder addFieldTransformationsBuilder(
        int index) {
      return getFieldTransformationsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.FieldTransformation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The field transformation that was applied.
     * If multiple field transformations are requested for a single field,
     * this list will contain all of them; otherwise, only one is supplied.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldTransformation field_transformations = 5;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.FieldTransformation.Builder>
        getFieldTransformationsBuilderList() {
      return getFieldTransformationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldTransformation,
            com.google.privacy.dlp.v2.FieldTransformation.Builder,
            com.google.privacy.dlp.v2.FieldTransformationOrBuilder>
        getFieldTransformationsFieldBuilder() {
      if (fieldTransformationsBuilder_ == null) {
        fieldTransformationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.FieldTransformation,
                com.google.privacy.dlp.v2.FieldTransformation.Builder,
                com.google.privacy.dlp.v2.FieldTransformationOrBuilder>(
                fieldTransformations_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        fieldTransformations_ = null;
      }
      return fieldTransformationsBuilder_;
    }

    private com.google.privacy.dlp.v2.RecordSuppression recordSuppress_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.RecordSuppression,
            com.google.privacy.dlp.v2.RecordSuppression.Builder,
            com.google.privacy.dlp.v2.RecordSuppressionOrBuilder>
        recordSuppressBuilder_;
    /**
     *
     *
     * <pre>
     * The specific suppression option these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordSuppression record_suppress = 6;</code>
     *
     * @return Whether the recordSuppress field is set.
     */
    public boolean hasRecordSuppress() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The specific suppression option these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordSuppression record_suppress = 6;</code>
     *
     * @return The recordSuppress.
     */
    public com.google.privacy.dlp.v2.RecordSuppression getRecordSuppress() {
      if (recordSuppressBuilder_ == null) {
        return recordSuppress_ == null
            ? com.google.privacy.dlp.v2.RecordSuppression.getDefaultInstance()
            : recordSuppress_;
      } else {
        return recordSuppressBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The specific suppression option these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordSuppression record_suppress = 6;</code>
     */
    public Builder setRecordSuppress(com.google.privacy.dlp.v2.RecordSuppression value) {
      if (recordSuppressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        recordSuppress_ = value;
      } else {
        recordSuppressBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specific suppression option these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordSuppression record_suppress = 6;</code>
     */
    public Builder setRecordSuppress(
        com.google.privacy.dlp.v2.RecordSuppression.Builder builderForValue) {
      if (recordSuppressBuilder_ == null) {
        recordSuppress_ = builderForValue.build();
      } else {
        recordSuppressBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specific suppression option these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordSuppression record_suppress = 6;</code>
     */
    public Builder mergeRecordSuppress(com.google.privacy.dlp.v2.RecordSuppression value) {
      if (recordSuppressBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && recordSuppress_ != null
            && recordSuppress_
                != com.google.privacy.dlp.v2.RecordSuppression.getDefaultInstance()) {
          getRecordSuppressBuilder().mergeFrom(value);
        } else {
          recordSuppress_ = value;
        }
      } else {
        recordSuppressBuilder_.mergeFrom(value);
      }
      if (recordSuppress_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specific suppression option these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordSuppression record_suppress = 6;</code>
     */
    public Builder clearRecordSuppress() {
      bitField0_ = (bitField0_ & ~0x00000010);
      recordSuppress_ = null;
      if (recordSuppressBuilder_ != null) {
        recordSuppressBuilder_.dispose();
        recordSuppressBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specific suppression option these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordSuppression record_suppress = 6;</code>
     */
    public com.google.privacy.dlp.v2.RecordSuppression.Builder getRecordSuppressBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getRecordSuppressFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The specific suppression option these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordSuppression record_suppress = 6;</code>
     */
    public com.google.privacy.dlp.v2.RecordSuppressionOrBuilder getRecordSuppressOrBuilder() {
      if (recordSuppressBuilder_ != null) {
        return recordSuppressBuilder_.getMessageOrBuilder();
      } else {
        return recordSuppress_ == null
            ? com.google.privacy.dlp.v2.RecordSuppression.getDefaultInstance()
            : recordSuppress_;
      }
    }
    /**
     *
     *
     * <pre>
     * The specific suppression option these stats apply to.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordSuppression record_suppress = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.RecordSuppression,
            com.google.privacy.dlp.v2.RecordSuppression.Builder,
            com.google.privacy.dlp.v2.RecordSuppressionOrBuilder>
        getRecordSuppressFieldBuilder() {
      if (recordSuppressBuilder_ == null) {
        recordSuppressBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.RecordSuppression,
                com.google.privacy.dlp.v2.RecordSuppression.Builder,
                com.google.privacy.dlp.v2.RecordSuppressionOrBuilder>(
                getRecordSuppress(), getParentForChildren(), isClean());
        recordSuppress_ = null;
      }
      return recordSuppressBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.TransformationSummary.SummaryResult> results_ =
        java.util.Collections.emptyList();

    private void ensureResultsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        results_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.TransformationSummary.SummaryResult>(
                results_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.TransformationSummary.SummaryResult,
            com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.Builder,
            com.google.privacy.dlp.v2.TransformationSummary.SummaryResultOrBuilder>
        resultsBuilder_;

    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.TransformationSummary.SummaryResult>
        getResultsList() {
      if (resultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(results_);
      } else {
        return resultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public int getResultsCount() {
      if (resultsBuilder_ == null) {
        return results_.size();
      } else {
        return resultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public com.google.privacy.dlp.v2.TransformationSummary.SummaryResult getResults(int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public Builder setResults(
        int index, com.google.privacy.dlp.v2.TransformationSummary.SummaryResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.set(index, value);
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public Builder setResults(
        int index,
        com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.set(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public Builder addResults(com.google.privacy.dlp.v2.TransformationSummary.SummaryResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public Builder addResults(
        int index, com.google.privacy.dlp.v2.TransformationSummary.SummaryResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(index, value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public Builder addResults(
        com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public Builder addResults(
        int index,
        com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public Builder addAllResults(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.TransformationSummary.SummaryResult>
            values) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, results_);
        onChanged();
      } else {
        resultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public Builder clearResults() {
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        resultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public Builder removeResults(int index) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.remove(index);
        onChanged();
      } else {
        resultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.Builder getResultsBuilder(
        int index) {
      return getResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public com.google.privacy.dlp.v2.TransformationSummary.SummaryResultOrBuilder
        getResultsOrBuilder(int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public java.util.List<
            ? extends com.google.privacy.dlp.v2.TransformationSummary.SummaryResultOrBuilder>
        getResultsOrBuilderList() {
      if (resultsBuilder_ != null) {
        return resultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(results_);
      }
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.Builder
        addResultsBuilder() {
      return getResultsFieldBuilder()
          .addBuilder(
              com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.Builder addResultsBuilder(
        int index) {
      return getResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Collection of all transformations that took place or had an error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationSummary.SummaryResult results = 4;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.Builder>
        getResultsBuilderList() {
      return getResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.TransformationSummary.SummaryResult,
            com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.Builder,
            com.google.privacy.dlp.v2.TransformationSummary.SummaryResultOrBuilder>
        getResultsFieldBuilder() {
      if (resultsBuilder_ == null) {
        resultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.TransformationSummary.SummaryResult,
                com.google.privacy.dlp.v2.TransformationSummary.SummaryResult.Builder,
                com.google.privacy.dlp.v2.TransformationSummary.SummaryResultOrBuilder>(
                results_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        results_ = null;
      }
      return resultsBuilder_;
    }

    private long transformedBytes_;
    /**
     *
     *
     * <pre>
     * Total size in bytes that were transformed in some way.
     * </pre>
     *
     * <code>int64 transformed_bytes = 7;</code>
     *
     * @return The transformedBytes.
     */
    @java.lang.Override
    public long getTransformedBytes() {
      return transformedBytes_;
    }
    /**
     *
     *
     * <pre>
     * Total size in bytes that were transformed in some way.
     * </pre>
     *
     * <code>int64 transformed_bytes = 7;</code>
     *
     * @param value The transformedBytes to set.
     * @return This builder for chaining.
     */
    public Builder setTransformedBytes(long value) {

      transformedBytes_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total size in bytes that were transformed in some way.
     * </pre>
     *
     * <code>int64 transformed_bytes = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransformedBytes() {
      bitField0_ = (bitField0_ & ~0x00000040);
      transformedBytes_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.TransformationSummary)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.TransformationSummary)
  private static final com.google.privacy.dlp.v2.TransformationSummary DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.TransformationSummary();
  }

  public static com.google.privacy.dlp.v2.TransformationSummary getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransformationSummary> PARSER =
      new com.google.protobuf.AbstractParser<TransformationSummary>() {
        @java.lang.Override
        public TransformationSummary parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransformationSummary> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransformationSummary> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationSummary getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
