/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Set of primitive values supported by the system.
 * Note that for the purposes of inspection or transformation, the number
 * of bytes considered to comprise a 'Value' is based on its representation
 * as a UTF-8 encoded string. For example, if 'integer_value' is set to
 * 123456789, the number of bytes would be counted as 9, even though an
 * int64 only holds up to 8 bytes of data.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.Value}
 */
public final class Value extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.Value)
    ValueOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Value.newBuilder() to construct.
  private Value(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Value() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Value();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_Value_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_Value_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.Value.class, com.google.privacy.dlp.v2.Value.Builder.class);
  }

  private int typeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object type_;

  public enum TypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INTEGER_VALUE(1),
    FLOAT_VALUE(2),
    STRING_VALUE(3),
    BOOLEAN_VALUE(4),
    TIMESTAMP_VALUE(5),
    TIME_VALUE(6),
    DATE_VALUE(7),
    DAY_OF_WEEK_VALUE(8),
    TYPE_NOT_SET(0);
    private final int value;

    private TypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TypeCase forNumber(int value) {
      switch (value) {
        case 1:
          return INTEGER_VALUE;
        case 2:
          return FLOAT_VALUE;
        case 3:
          return STRING_VALUE;
        case 4:
          return BOOLEAN_VALUE;
        case 5:
          return TIMESTAMP_VALUE;
        case 6:
          return TIME_VALUE;
        case 7:
          return DATE_VALUE;
        case 8:
          return DAY_OF_WEEK_VALUE;
        case 0:
          return TYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TypeCase getTypeCase() {
    return TypeCase.forNumber(typeCase_);
  }

  public static final int INTEGER_VALUE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * integer
   * </pre>
   *
   * <code>int64 integer_value = 1;</code>
   *
   * @return Whether the integerValue field is set.
   */
  @java.lang.Override
  public boolean hasIntegerValue() {
    return typeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * integer
   * </pre>
   *
   * <code>int64 integer_value = 1;</code>
   *
   * @return The integerValue.
   */
  @java.lang.Override
  public long getIntegerValue() {
    if (typeCase_ == 1) {
      return (java.lang.Long) type_;
    }
    return 0L;
  }

  public static final int FLOAT_VALUE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * float
   * </pre>
   *
   * <code>double float_value = 2;</code>
   *
   * @return Whether the floatValue field is set.
   */
  @java.lang.Override
  public boolean hasFloatValue() {
    return typeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * float
   * </pre>
   *
   * <code>double float_value = 2;</code>
   *
   * @return The floatValue.
   */
  @java.lang.Override
  public double getFloatValue() {
    if (typeCase_ == 2) {
      return (java.lang.Double) type_;
    }
    return 0D;
  }

  public static final int STRING_VALUE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * string
   * </pre>
   *
   * <code>string string_value = 3;</code>
   *
   * @return Whether the stringValue field is set.
   */
  public boolean hasStringValue() {
    return typeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * string
   * </pre>
   *
   * <code>string string_value = 3;</code>
   *
   * @return The stringValue.
   */
  public java.lang.String getStringValue() {
    java.lang.Object ref = "";
    if (typeCase_ == 3) {
      ref = type_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (typeCase_ == 3) {
        type_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * string
   * </pre>
   *
   * <code>string string_value = 3;</code>
   *
   * @return The bytes for stringValue.
   */
  public com.google.protobuf.ByteString getStringValueBytes() {
    java.lang.Object ref = "";
    if (typeCase_ == 3) {
      ref = type_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (typeCase_ == 3) {
        type_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BOOLEAN_VALUE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * boolean
   * </pre>
   *
   * <code>bool boolean_value = 4;</code>
   *
   * @return Whether the booleanValue field is set.
   */
  @java.lang.Override
  public boolean hasBooleanValue() {
    return typeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * boolean
   * </pre>
   *
   * <code>bool boolean_value = 4;</code>
   *
   * @return The booleanValue.
   */
  @java.lang.Override
  public boolean getBooleanValue() {
    if (typeCase_ == 4) {
      return (java.lang.Boolean) type_;
    }
    return false;
  }

  public static final int TIMESTAMP_VALUE_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * timestamp
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
   *
   * @return Whether the timestampValue field is set.
   */
  @java.lang.Override
  public boolean hasTimestampValue() {
    return typeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * timestamp
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
   *
   * @return The timestampValue.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getTimestampValue() {
    if (typeCase_ == 5) {
      return (com.google.protobuf.Timestamp) type_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * timestamp
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getTimestampValueOrBuilder() {
    if (typeCase_ == 5) {
      return (com.google.protobuf.Timestamp) type_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int TIME_VALUE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * time of day
   * </pre>
   *
   * <code>.google.type.TimeOfDay time_value = 6;</code>
   *
   * @return Whether the timeValue field is set.
   */
  @java.lang.Override
  public boolean hasTimeValue() {
    return typeCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * time of day
   * </pre>
   *
   * <code>.google.type.TimeOfDay time_value = 6;</code>
   *
   * @return The timeValue.
   */
  @java.lang.Override
  public com.google.type.TimeOfDay getTimeValue() {
    if (typeCase_ == 6) {
      return (com.google.type.TimeOfDay) type_;
    }
    return com.google.type.TimeOfDay.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * time of day
   * </pre>
   *
   * <code>.google.type.TimeOfDay time_value = 6;</code>
   */
  @java.lang.Override
  public com.google.type.TimeOfDayOrBuilder getTimeValueOrBuilder() {
    if (typeCase_ == 6) {
      return (com.google.type.TimeOfDay) type_;
    }
    return com.google.type.TimeOfDay.getDefaultInstance();
  }

  public static final int DATE_VALUE_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * date
   * </pre>
   *
   * <code>.google.type.Date date_value = 7;</code>
   *
   * @return Whether the dateValue field is set.
   */
  @java.lang.Override
  public boolean hasDateValue() {
    return typeCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * date
   * </pre>
   *
   * <code>.google.type.Date date_value = 7;</code>
   *
   * @return The dateValue.
   */
  @java.lang.Override
  public com.google.type.Date getDateValue() {
    if (typeCase_ == 7) {
      return (com.google.type.Date) type_;
    }
    return com.google.type.Date.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * date
   * </pre>
   *
   * <code>.google.type.Date date_value = 7;</code>
   */
  @java.lang.Override
  public com.google.type.DateOrBuilder getDateValueOrBuilder() {
    if (typeCase_ == 7) {
      return (com.google.type.Date) type_;
    }
    return com.google.type.Date.getDefaultInstance();
  }

  public static final int DAY_OF_WEEK_VALUE_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * day of week
   * </pre>
   *
   * <code>.google.type.DayOfWeek day_of_week_value = 8;</code>
   *
   * @return Whether the dayOfWeekValue field is set.
   */
  public boolean hasDayOfWeekValue() {
    return typeCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * day of week
   * </pre>
   *
   * <code>.google.type.DayOfWeek day_of_week_value = 8;</code>
   *
   * @return The enum numeric value on the wire for dayOfWeekValue.
   */
  public int getDayOfWeekValueValue() {
    if (typeCase_ == 8) {
      return (java.lang.Integer) type_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * day of week
   * </pre>
   *
   * <code>.google.type.DayOfWeek day_of_week_value = 8;</code>
   *
   * @return The dayOfWeekValue.
   */
  public com.google.type.DayOfWeek getDayOfWeekValue() {
    if (typeCase_ == 8) {
      com.google.type.DayOfWeek result =
          com.google.type.DayOfWeek.forNumber((java.lang.Integer) type_);
      return result == null ? com.google.type.DayOfWeek.UNRECOGNIZED : result;
    }
    return com.google.type.DayOfWeek.DAY_OF_WEEK_UNSPECIFIED;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (typeCase_ == 1) {
      output.writeInt64(1, (long) ((java.lang.Long) type_));
    }
    if (typeCase_ == 2) {
      output.writeDouble(2, (double) ((java.lang.Double) type_));
    }
    if (typeCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, type_);
    }
    if (typeCase_ == 4) {
      output.writeBool(4, (boolean) ((java.lang.Boolean) type_));
    }
    if (typeCase_ == 5) {
      output.writeMessage(5, (com.google.protobuf.Timestamp) type_);
    }
    if (typeCase_ == 6) {
      output.writeMessage(6, (com.google.type.TimeOfDay) type_);
    }
    if (typeCase_ == 7) {
      output.writeMessage(7, (com.google.type.Date) type_);
    }
    if (typeCase_ == 8) {
      output.writeEnum(8, ((java.lang.Integer) type_));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (typeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              1, (long) ((java.lang.Long) type_));
    }
    if (typeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(
              2, (double) ((java.lang.Double) type_));
    }
    if (typeCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, type_);
    }
    if (typeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              4, (boolean) ((java.lang.Boolean) type_));
    }
    if (typeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.protobuf.Timestamp) type_);
    }
    if (typeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.type.TimeOfDay) type_);
    }
    if (typeCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(7, (com.google.type.Date) type_);
    }
    if (typeCase_ == 8) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, ((java.lang.Integer) type_));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.Value)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.Value other = (com.google.privacy.dlp.v2.Value) obj;

    if (!getTypeCase().equals(other.getTypeCase())) return false;
    switch (typeCase_) {
      case 1:
        if (getIntegerValue() != other.getIntegerValue()) return false;
        break;
      case 2:
        if (java.lang.Double.doubleToLongBits(getFloatValue())
            != java.lang.Double.doubleToLongBits(other.getFloatValue())) return false;
        break;
      case 3:
        if (!getStringValue().equals(other.getStringValue())) return false;
        break;
      case 4:
        if (getBooleanValue() != other.getBooleanValue()) return false;
        break;
      case 5:
        if (!getTimestampValue().equals(other.getTimestampValue())) return false;
        break;
      case 6:
        if (!getTimeValue().equals(other.getTimeValue())) return false;
        break;
      case 7:
        if (!getDateValue().equals(other.getDateValue())) return false;
        break;
      case 8:
        if (getDayOfWeekValueValue() != other.getDayOfWeekValueValue()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (typeCase_) {
      case 1:
        hash = (37 * hash) + INTEGER_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIntegerValue());
        break;
      case 2:
        hash = (37 * hash) + FLOAT_VALUE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getFloatValue()));
        break;
      case 3:
        hash = (37 * hash) + STRING_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getStringValue().hashCode();
        break;
      case 4:
        hash = (37 * hash) + BOOLEAN_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBooleanValue());
        break;
      case 5:
        hash = (37 * hash) + TIMESTAMP_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getTimestampValue().hashCode();
        break;
      case 6:
        hash = (37 * hash) + TIME_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getTimeValue().hashCode();
        break;
      case 7:
        hash = (37 * hash) + DATE_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getDateValue().hashCode();
        break;
      case 8:
        hash = (37 * hash) + DAY_OF_WEEK_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getDayOfWeekValueValue();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.Value parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Value parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Value parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Value parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Value parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Value parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Value parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Value parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Value parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Value parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Value parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Value parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.Value prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Set of primitive values supported by the system.
   * Note that for the purposes of inspection or transformation, the number
   * of bytes considered to comprise a 'Value' is based on its representation
   * as a UTF-8 encoded string. For example, if 'integer_value' is set to
   * 123456789, the number of bytes would be counted as 9, even though an
   * int64 only holds up to 8 bytes of data.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.Value}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.Value)
      com.google.privacy.dlp.v2.ValueOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Value_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Value_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.Value.class, com.google.privacy.dlp.v2.Value.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.Value.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (timestampValueBuilder_ != null) {
        timestampValueBuilder_.clear();
      }
      if (timeValueBuilder_ != null) {
        timeValueBuilder_.clear();
      }
      if (dateValueBuilder_ != null) {
        dateValueBuilder_.clear();
      }
      typeCase_ = 0;
      type_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Value_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Value getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.Value.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Value build() {
      com.google.privacy.dlp.v2.Value result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Value buildPartial() {
      com.google.privacy.dlp.v2.Value result = new com.google.privacy.dlp.v2.Value(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.Value result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.Value result) {
      result.typeCase_ = typeCase_;
      result.type_ = this.type_;
      if (typeCase_ == 5 && timestampValueBuilder_ != null) {
        result.type_ = timestampValueBuilder_.build();
      }
      if (typeCase_ == 6 && timeValueBuilder_ != null) {
        result.type_ = timeValueBuilder_.build();
      }
      if (typeCase_ == 7 && dateValueBuilder_ != null) {
        result.type_ = dateValueBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.Value) {
        return mergeFrom((com.google.privacy.dlp.v2.Value) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.Value other) {
      if (other == com.google.privacy.dlp.v2.Value.getDefaultInstance()) return this;
      switch (other.getTypeCase()) {
        case INTEGER_VALUE:
          {
            setIntegerValue(other.getIntegerValue());
            break;
          }
        case FLOAT_VALUE:
          {
            setFloatValue(other.getFloatValue());
            break;
          }
        case STRING_VALUE:
          {
            typeCase_ = 3;
            type_ = other.type_;
            onChanged();
            break;
          }
        case BOOLEAN_VALUE:
          {
            setBooleanValue(other.getBooleanValue());
            break;
          }
        case TIMESTAMP_VALUE:
          {
            mergeTimestampValue(other.getTimestampValue());
            break;
          }
        case TIME_VALUE:
          {
            mergeTimeValue(other.getTimeValue());
            break;
          }
        case DATE_VALUE:
          {
            mergeDateValue(other.getDateValue());
            break;
          }
        case DAY_OF_WEEK_VALUE:
          {
            setDayOfWeekValueValue(other.getDayOfWeekValueValue());
            break;
          }
        case TYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                type_ = input.readInt64();
                typeCase_ = 1;
                break;
              } // case 8
            case 17:
              {
                type_ = input.readDouble();
                typeCase_ = 2;
                break;
              } // case 17
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                typeCase_ = 3;
                type_ = s;
                break;
              } // case 26
            case 32:
              {
                type_ = input.readBool();
                typeCase_ = 4;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getTimestampValueFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getTimeValueFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getDateValueFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 7;
                break;
              } // case 58
            case 64:
              {
                int rawValue = input.readEnum();
                typeCase_ = 8;
                type_ = rawValue;
                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int typeCase_ = 0;
    private java.lang.Object type_;

    public TypeCase getTypeCase() {
      return TypeCase.forNumber(typeCase_);
    }

    public Builder clearType() {
      typeCase_ = 0;
      type_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * integer
     * </pre>
     *
     * <code>int64 integer_value = 1;</code>
     *
     * @return Whether the integerValue field is set.
     */
    public boolean hasIntegerValue() {
      return typeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * integer
     * </pre>
     *
     * <code>int64 integer_value = 1;</code>
     *
     * @return The integerValue.
     */
    public long getIntegerValue() {
      if (typeCase_ == 1) {
        return (java.lang.Long) type_;
      }
      return 0L;
    }
    /**
     *
     *
     * <pre>
     * integer
     * </pre>
     *
     * <code>int64 integer_value = 1;</code>
     *
     * @param value The integerValue to set.
     * @return This builder for chaining.
     */
    public Builder setIntegerValue(long value) {

      typeCase_ = 1;
      type_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * integer
     * </pre>
     *
     * <code>int64 integer_value = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntegerValue() {
      if (typeCase_ == 1) {
        typeCase_ = 0;
        type_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * float
     * </pre>
     *
     * <code>double float_value = 2;</code>
     *
     * @return Whether the floatValue field is set.
     */
    public boolean hasFloatValue() {
      return typeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * float
     * </pre>
     *
     * <code>double float_value = 2;</code>
     *
     * @return The floatValue.
     */
    public double getFloatValue() {
      if (typeCase_ == 2) {
        return (java.lang.Double) type_;
      }
      return 0D;
    }
    /**
     *
     *
     * <pre>
     * float
     * </pre>
     *
     * <code>double float_value = 2;</code>
     *
     * @param value The floatValue to set.
     * @return This builder for chaining.
     */
    public Builder setFloatValue(double value) {

      typeCase_ = 2;
      type_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * float
     * </pre>
     *
     * <code>double float_value = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFloatValue() {
      if (typeCase_ == 2) {
        typeCase_ = 0;
        type_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * string
     * </pre>
     *
     * <code>string string_value = 3;</code>
     *
     * @return Whether the stringValue field is set.
     */
    @java.lang.Override
    public boolean hasStringValue() {
      return typeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * string
     * </pre>
     *
     * <code>string string_value = 3;</code>
     *
     * @return The stringValue.
     */
    @java.lang.Override
    public java.lang.String getStringValue() {
      java.lang.Object ref = "";
      if (typeCase_ == 3) {
        ref = type_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (typeCase_ == 3) {
          type_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * string
     * </pre>
     *
     * <code>string string_value = 3;</code>
     *
     * @return The bytes for stringValue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStringValueBytes() {
      java.lang.Object ref = "";
      if (typeCase_ == 3) {
        ref = type_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (typeCase_ == 3) {
          type_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * string
     * </pre>
     *
     * <code>string string_value = 3;</code>
     *
     * @param value The stringValue to set.
     * @return This builder for chaining.
     */
    public Builder setStringValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      typeCase_ = 3;
      type_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * string
     * </pre>
     *
     * <code>string string_value = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStringValue() {
      if (typeCase_ == 3) {
        typeCase_ = 0;
        type_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * string
     * </pre>
     *
     * <code>string string_value = 3;</code>
     *
     * @param value The bytes for stringValue to set.
     * @return This builder for chaining.
     */
    public Builder setStringValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      typeCase_ = 3;
      type_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * boolean
     * </pre>
     *
     * <code>bool boolean_value = 4;</code>
     *
     * @return Whether the booleanValue field is set.
     */
    public boolean hasBooleanValue() {
      return typeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * boolean
     * </pre>
     *
     * <code>bool boolean_value = 4;</code>
     *
     * @return The booleanValue.
     */
    public boolean getBooleanValue() {
      if (typeCase_ == 4) {
        return (java.lang.Boolean) type_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * boolean
     * </pre>
     *
     * <code>bool boolean_value = 4;</code>
     *
     * @param value The booleanValue to set.
     * @return This builder for chaining.
     */
    public Builder setBooleanValue(boolean value) {

      typeCase_ = 4;
      type_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * boolean
     * </pre>
     *
     * <code>bool boolean_value = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBooleanValue() {
      if (typeCase_ == 4) {
        typeCase_ = 0;
        type_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        timestampValueBuilder_;
    /**
     *
     *
     * <pre>
     * timestamp
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     *
     * @return Whether the timestampValue field is set.
     */
    @java.lang.Override
    public boolean hasTimestampValue() {
      return typeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * timestamp
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     *
     * @return The timestampValue.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getTimestampValue() {
      if (timestampValueBuilder_ == null) {
        if (typeCase_ == 5) {
          return (com.google.protobuf.Timestamp) type_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (typeCase_ == 5) {
          return timestampValueBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * timestamp
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     */
    public Builder setTimestampValue(com.google.protobuf.Timestamp value) {
      if (timestampValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        timestampValueBuilder_.setMessage(value);
      }
      typeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * timestamp
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     */
    public Builder setTimestampValue(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (timestampValueBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        timestampValueBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * timestamp
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     */
    public Builder mergeTimestampValue(com.google.protobuf.Timestamp value) {
      if (timestampValueBuilder_ == null) {
        if (typeCase_ == 5 && type_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          type_ =
              com.google.protobuf.Timestamp.newBuilder((com.google.protobuf.Timestamp) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 5) {
          timestampValueBuilder_.mergeFrom(value);
        } else {
          timestampValueBuilder_.setMessage(value);
        }
      }
      typeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * timestamp
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     */
    public Builder clearTimestampValue() {
      if (timestampValueBuilder_ == null) {
        if (typeCase_ == 5) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 5) {
          typeCase_ = 0;
          type_ = null;
        }
        timestampValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * timestamp
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getTimestampValueBuilder() {
      return getTimestampValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * timestamp
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getTimestampValueOrBuilder() {
      if ((typeCase_ == 5) && (timestampValueBuilder_ != null)) {
        return timestampValueBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 5) {
          return (com.google.protobuf.Timestamp) type_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * timestamp
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getTimestampValueFieldBuilder() {
      if (timestampValueBuilder_ == null) {
        if (!(typeCase_ == 5)) {
          type_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        timestampValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) type_, getParentForChildren(), isClean());
        type_ = null;
      }
      typeCase_ = 5;
      onChanged();
      return timestampValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.TimeOfDay,
            com.google.type.TimeOfDay.Builder,
            com.google.type.TimeOfDayOrBuilder>
        timeValueBuilder_;
    /**
     *
     *
     * <pre>
     * time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time_value = 6;</code>
     *
     * @return Whether the timeValue field is set.
     */
    @java.lang.Override
    public boolean hasTimeValue() {
      return typeCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time_value = 6;</code>
     *
     * @return The timeValue.
     */
    @java.lang.Override
    public com.google.type.TimeOfDay getTimeValue() {
      if (timeValueBuilder_ == null) {
        if (typeCase_ == 6) {
          return (com.google.type.TimeOfDay) type_;
        }
        return com.google.type.TimeOfDay.getDefaultInstance();
      } else {
        if (typeCase_ == 6) {
          return timeValueBuilder_.getMessage();
        }
        return com.google.type.TimeOfDay.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time_value = 6;</code>
     */
    public Builder setTimeValue(com.google.type.TimeOfDay value) {
      if (timeValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        timeValueBuilder_.setMessage(value);
      }
      typeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time_value = 6;</code>
     */
    public Builder setTimeValue(com.google.type.TimeOfDay.Builder builderForValue) {
      if (timeValueBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        timeValueBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time_value = 6;</code>
     */
    public Builder mergeTimeValue(com.google.type.TimeOfDay value) {
      if (timeValueBuilder_ == null) {
        if (typeCase_ == 6 && type_ != com.google.type.TimeOfDay.getDefaultInstance()) {
          type_ =
              com.google.type.TimeOfDay.newBuilder((com.google.type.TimeOfDay) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 6) {
          timeValueBuilder_.mergeFrom(value);
        } else {
          timeValueBuilder_.setMessage(value);
        }
      }
      typeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time_value = 6;</code>
     */
    public Builder clearTimeValue() {
      if (timeValueBuilder_ == null) {
        if (typeCase_ == 6) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 6) {
          typeCase_ = 0;
          type_ = null;
        }
        timeValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time_value = 6;</code>
     */
    public com.google.type.TimeOfDay.Builder getTimeValueBuilder() {
      return getTimeValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time_value = 6;</code>
     */
    @java.lang.Override
    public com.google.type.TimeOfDayOrBuilder getTimeValueOrBuilder() {
      if ((typeCase_ == 6) && (timeValueBuilder_ != null)) {
        return timeValueBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 6) {
          return (com.google.type.TimeOfDay) type_;
        }
        return com.google.type.TimeOfDay.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * time of day
     * </pre>
     *
     * <code>.google.type.TimeOfDay time_value = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.TimeOfDay,
            com.google.type.TimeOfDay.Builder,
            com.google.type.TimeOfDayOrBuilder>
        getTimeValueFieldBuilder() {
      if (timeValueBuilder_ == null) {
        if (!(typeCase_ == 6)) {
          type_ = com.google.type.TimeOfDay.getDefaultInstance();
        }
        timeValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.TimeOfDay,
                com.google.type.TimeOfDay.Builder,
                com.google.type.TimeOfDayOrBuilder>(
                (com.google.type.TimeOfDay) type_, getParentForChildren(), isClean());
        type_ = null;
      }
      typeCase_ = 6;
      onChanged();
      return timeValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
        dateValueBuilder_;
    /**
     *
     *
     * <pre>
     * date
     * </pre>
     *
     * <code>.google.type.Date date_value = 7;</code>
     *
     * @return Whether the dateValue field is set.
     */
    @java.lang.Override
    public boolean hasDateValue() {
      return typeCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * date
     * </pre>
     *
     * <code>.google.type.Date date_value = 7;</code>
     *
     * @return The dateValue.
     */
    @java.lang.Override
    public com.google.type.Date getDateValue() {
      if (dateValueBuilder_ == null) {
        if (typeCase_ == 7) {
          return (com.google.type.Date) type_;
        }
        return com.google.type.Date.getDefaultInstance();
      } else {
        if (typeCase_ == 7) {
          return dateValueBuilder_.getMessage();
        }
        return com.google.type.Date.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * date
     * </pre>
     *
     * <code>.google.type.Date date_value = 7;</code>
     */
    public Builder setDateValue(com.google.type.Date value) {
      if (dateValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        dateValueBuilder_.setMessage(value);
      }
      typeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * date
     * </pre>
     *
     * <code>.google.type.Date date_value = 7;</code>
     */
    public Builder setDateValue(com.google.type.Date.Builder builderForValue) {
      if (dateValueBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        dateValueBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * date
     * </pre>
     *
     * <code>.google.type.Date date_value = 7;</code>
     */
    public Builder mergeDateValue(com.google.type.Date value) {
      if (dateValueBuilder_ == null) {
        if (typeCase_ == 7 && type_ != com.google.type.Date.getDefaultInstance()) {
          type_ =
              com.google.type.Date.newBuilder((com.google.type.Date) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 7) {
          dateValueBuilder_.mergeFrom(value);
        } else {
          dateValueBuilder_.setMessage(value);
        }
      }
      typeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * date
     * </pre>
     *
     * <code>.google.type.Date date_value = 7;</code>
     */
    public Builder clearDateValue() {
      if (dateValueBuilder_ == null) {
        if (typeCase_ == 7) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 7) {
          typeCase_ = 0;
          type_ = null;
        }
        dateValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * date
     * </pre>
     *
     * <code>.google.type.Date date_value = 7;</code>
     */
    public com.google.type.Date.Builder getDateValueBuilder() {
      return getDateValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * date
     * </pre>
     *
     * <code>.google.type.Date date_value = 7;</code>
     */
    @java.lang.Override
    public com.google.type.DateOrBuilder getDateValueOrBuilder() {
      if ((typeCase_ == 7) && (dateValueBuilder_ != null)) {
        return dateValueBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 7) {
          return (com.google.type.Date) type_;
        }
        return com.google.type.Date.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * date
     * </pre>
     *
     * <code>.google.type.Date date_value = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
        getDateValueFieldBuilder() {
      if (dateValueBuilder_ == null) {
        if (!(typeCase_ == 7)) {
          type_ = com.google.type.Date.getDefaultInstance();
        }
        dateValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>(
                (com.google.type.Date) type_, getParentForChildren(), isClean());
        type_ = null;
      }
      typeCase_ = 7;
      onChanged();
      return dateValueBuilder_;
    }

    /**
     *
     *
     * <pre>
     * day of week
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week_value = 8;</code>
     *
     * @return Whether the dayOfWeekValue field is set.
     */
    @java.lang.Override
    public boolean hasDayOfWeekValue() {
      return typeCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * day of week
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week_value = 8;</code>
     *
     * @return The enum numeric value on the wire for dayOfWeekValue.
     */
    @java.lang.Override
    public int getDayOfWeekValueValue() {
      if (typeCase_ == 8) {
        return ((java.lang.Integer) type_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * day of week
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week_value = 8;</code>
     *
     * @param value The enum numeric value on the wire for dayOfWeekValue to set.
     * @return This builder for chaining.
     */
    public Builder setDayOfWeekValueValue(int value) {
      typeCase_ = 8;
      type_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * day of week
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week_value = 8;</code>
     *
     * @return The dayOfWeekValue.
     */
    @java.lang.Override
    public com.google.type.DayOfWeek getDayOfWeekValue() {
      if (typeCase_ == 8) {
        com.google.type.DayOfWeek result =
            com.google.type.DayOfWeek.forNumber((java.lang.Integer) type_);
        return result == null ? com.google.type.DayOfWeek.UNRECOGNIZED : result;
      }
      return com.google.type.DayOfWeek.DAY_OF_WEEK_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * day of week
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week_value = 8;</code>
     *
     * @param value The dayOfWeekValue to set.
     * @return This builder for chaining.
     */
    public Builder setDayOfWeekValue(com.google.type.DayOfWeek value) {
      if (value == null) {
        throw new NullPointerException();
      }
      typeCase_ = 8;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * day of week
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week_value = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDayOfWeekValue() {
      if (typeCase_ == 8) {
        typeCase_ = 0;
        type_ = null;
        onChanged();
      }
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.Value)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.Value)
  private static final com.google.privacy.dlp.v2.Value DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.Value();
  }

  public static com.google.privacy.dlp.v2.Value getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Value> PARSER =
      new com.google.protobuf.AbstractParser<Value>() {
        @java.lang.Override
        public Value parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Value> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Value> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.Value getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
