/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class InspectTemplateName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_INSPECT_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/inspectTemplates/{inspect_template}");
    private static final PathTemplate PROJECT_INSPECT_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/inspectTemplates/{inspect_template}");
    private static final PathTemplate ORGANIZATION_LOCATION_INSPECT_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/inspectTemplates/{inspect_template}");
    private static final PathTemplate PROJECT_LOCATION_INSPECT_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/inspectTemplates/{inspect_template}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String inspectTemplate;
    private final String project;
    private final String location;

    @Deprecated
    protected InspectTemplateName() {
        this.organization = null;
        this.inspectTemplate = null;
        this.project = null;
        this.location = null;
    }

    private InspectTemplateName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.inspectTemplate = (String)Preconditions.checkNotNull((Object)builder.getInspectTemplate());
        this.project = null;
        this.location = null;
        this.pathTemplate = ORGANIZATION_INSPECT_TEMPLATE;
    }

    private InspectTemplateName(ProjectInspectTemplateBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.inspectTemplate = (String)Preconditions.checkNotNull((Object)builder.getInspectTemplate());
        this.organization = null;
        this.location = null;
        this.pathTemplate = PROJECT_INSPECT_TEMPLATE;
    }

    private InspectTemplateName(OrganizationLocationInspectTemplateBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.inspectTemplate = (String)Preconditions.checkNotNull((Object)builder.getInspectTemplate());
        this.project = null;
        this.pathTemplate = ORGANIZATION_LOCATION_INSPECT_TEMPLATE;
    }

    private InspectTemplateName(ProjectLocationInspectTemplateBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.inspectTemplate = (String)Preconditions.checkNotNull((Object)builder.getInspectTemplate());
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_INSPECT_TEMPLATE;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getInspectTemplate() {
        return this.inspectTemplate;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationInspectTemplateBuilder() {
        return new Builder();
    }

    public static ProjectInspectTemplateBuilder newProjectInspectTemplateBuilder() {
        return new ProjectInspectTemplateBuilder();
    }

    public static OrganizationLocationInspectTemplateBuilder newOrganizationLocationInspectTemplateBuilder() {
        return new OrganizationLocationInspectTemplateBuilder();
    }

    public static ProjectLocationInspectTemplateBuilder newProjectLocationInspectTemplateBuilder() {
        return new ProjectLocationInspectTemplateBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InspectTemplateName of(String organization, String inspectTemplate) {
        return InspectTemplateName.newBuilder().setOrganization(organization).setInspectTemplate(inspectTemplate).build();
    }

    public static InspectTemplateName ofOrganizationInspectTemplateName(String organization, String inspectTemplate) {
        return InspectTemplateName.newBuilder().setOrganization(organization).setInspectTemplate(inspectTemplate).build();
    }

    public static InspectTemplateName ofProjectInspectTemplateName(String project, String inspectTemplate) {
        return InspectTemplateName.newProjectInspectTemplateBuilder().setProject(project).setInspectTemplate(inspectTemplate).build();
    }

    public static InspectTemplateName ofOrganizationLocationInspectTemplateName(String organization, String location, String inspectTemplate) {
        return InspectTemplateName.newOrganizationLocationInspectTemplateBuilder().setOrganization(organization).setLocation(location).setInspectTemplate(inspectTemplate).build();
    }

    public static InspectTemplateName ofProjectLocationInspectTemplateName(String project, String location, String inspectTemplate) {
        return InspectTemplateName.newProjectLocationInspectTemplateBuilder().setProject(project).setLocation(location).setInspectTemplate(inspectTemplate).build();
    }

    public static String format(String organization, String inspectTemplate) {
        return InspectTemplateName.newBuilder().setOrganization(organization).setInspectTemplate(inspectTemplate).build().toString();
    }

    public static String formatOrganizationInspectTemplateName(String organization, String inspectTemplate) {
        return InspectTemplateName.newBuilder().setOrganization(organization).setInspectTemplate(inspectTemplate).build().toString();
    }

    public static String formatProjectInspectTemplateName(String project, String inspectTemplate) {
        return InspectTemplateName.newProjectInspectTemplateBuilder().setProject(project).setInspectTemplate(inspectTemplate).build().toString();
    }

    public static String formatOrganizationLocationInspectTemplateName(String organization, String location, String inspectTemplate) {
        return InspectTemplateName.newOrganizationLocationInspectTemplateBuilder().setOrganization(organization).setLocation(location).setInspectTemplate(inspectTemplate).build().toString();
    }

    public static String formatProjectLocationInspectTemplateName(String project, String location, String inspectTemplate) {
        return InspectTemplateName.newProjectLocationInspectTemplateBuilder().setProject(project).setLocation(location).setInspectTemplate(inspectTemplate).build().toString();
    }

    public static InspectTemplateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_INSPECT_TEMPLATE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_INSPECT_TEMPLATE.match(formattedString);
            return InspectTemplateName.ofOrganizationInspectTemplateName((String)matchMap.get("organization"), (String)matchMap.get("inspect_template"));
        }
        if (PROJECT_INSPECT_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_INSPECT_TEMPLATE.match(formattedString);
            return InspectTemplateName.ofProjectInspectTemplateName((String)matchMap.get("project"), (String)matchMap.get("inspect_template"));
        }
        if (ORGANIZATION_LOCATION_INSPECT_TEMPLATE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_INSPECT_TEMPLATE.match(formattedString);
            return InspectTemplateName.ofOrganizationLocationInspectTemplateName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("inspect_template"));
        }
        if (PROJECT_LOCATION_INSPECT_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_INSPECT_TEMPLATE.match(formattedString);
            return InspectTemplateName.ofProjectLocationInspectTemplateName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("inspect_template"));
        }
        throw new ValidationException("InspectTemplateName.parse: formattedString not in valid format", new Object[0]);
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_INSPECT_TEMPLATE.matches(formattedString) || PROJECT_INSPECT_TEMPLATE.matches(formattedString) || ORGANIZATION_LOCATION_INSPECT_TEMPLATE.matches(formattedString) || PROJECT_LOCATION_INSPECT_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InspectTemplateName inspectTemplateName = this;
            synchronized (inspectTemplateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.inspectTemplate != null) {
                        fieldMapBuilder.put((Object)"inspect_template", (Object)this.inspectTemplate);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            InspectTemplateName that = (InspectTemplateName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.inspectTemplate, that.inspectTemplate) && Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.inspectTemplate);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationInspectTemplateBuilder {
        private String project;
        private String location;
        private String inspectTemplate;

        protected ProjectLocationInspectTemplateBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInspectTemplate() {
            return this.inspectTemplate;
        }

        public ProjectLocationInspectTemplateBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationInspectTemplateBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationInspectTemplateBuilder setInspectTemplate(String inspectTemplate) {
            this.inspectTemplate = inspectTemplate;
            return this;
        }

        public InspectTemplateName build() {
            return new InspectTemplateName(this);
        }
    }

    public static class OrganizationLocationInspectTemplateBuilder {
        private String organization;
        private String location;
        private String inspectTemplate;

        protected OrganizationLocationInspectTemplateBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInspectTemplate() {
            return this.inspectTemplate;
        }

        public OrganizationLocationInspectTemplateBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationInspectTemplateBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationInspectTemplateBuilder setInspectTemplate(String inspectTemplate) {
            this.inspectTemplate = inspectTemplate;
            return this;
        }

        public InspectTemplateName build() {
            return new InspectTemplateName(this);
        }
    }

    public static class ProjectInspectTemplateBuilder {
        private String project;
        private String inspectTemplate;

        protected ProjectInspectTemplateBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getInspectTemplate() {
            return this.inspectTemplate;
        }

        public ProjectInspectTemplateBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectInspectTemplateBuilder setInspectTemplate(String inspectTemplate) {
            this.inspectTemplate = inspectTemplate;
            return this;
        }

        public InspectTemplateName build() {
            return new InspectTemplateName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String inspectTemplate;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getInspectTemplate() {
            return this.inspectTemplate;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setInspectTemplate(String inspectTemplate) {
            this.inspectTemplate = inspectTemplate;
            return this;
        }

        private Builder(InspectTemplateName inspectTemplateName) {
            Preconditions.checkArgument((boolean)Objects.equals(inspectTemplateName.pathTemplate, ORGANIZATION_INSPECT_TEMPLATE), (Object)"toBuilder is only supported when InspectTemplateName has the pattern of organizations/{organization}/inspectTemplates/{inspect_template}");
            this.organization = inspectTemplateName.organization;
            this.inspectTemplate = inspectTemplateName.inspectTemplate;
        }

        public InspectTemplateName build() {
            return new InspectTemplateName(this);
        }
    }
}

