/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ColumnDataProfileName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_COLUMN_DATA_PROFILE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/columnDataProfiles/{column_data_profile}");
    private static final PathTemplate PROJECT_LOCATION_COLUMN_DATA_PROFILE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/columnDataProfiles/{column_data_profile}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String location;
    private final String columnDataProfile;
    private final String project;

    @Deprecated
    protected ColumnDataProfileName() {
        this.organization = null;
        this.location = null;
        this.columnDataProfile = null;
        this.project = null;
    }

    private ColumnDataProfileName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.columnDataProfile = (String)Preconditions.checkNotNull((Object)builder.getColumnDataProfile());
        this.project = null;
        this.pathTemplate = ORGANIZATION_LOCATION_COLUMN_DATA_PROFILE;
    }

    private ColumnDataProfileName(ProjectLocationColumnDataProfileBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.columnDataProfile = (String)Preconditions.checkNotNull((Object)builder.getColumnDataProfile());
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_COLUMN_DATA_PROFILE;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getColumnDataProfile() {
        return this.columnDataProfile;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationLocationColumnDataProfileBuilder() {
        return new Builder();
    }

    public static ProjectLocationColumnDataProfileBuilder newProjectLocationColumnDataProfileBuilder() {
        return new ProjectLocationColumnDataProfileBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ColumnDataProfileName of(String organization, String location, String columnDataProfile) {
        return ColumnDataProfileName.newBuilder().setOrganization(organization).setLocation(location).setColumnDataProfile(columnDataProfile).build();
    }

    public static ColumnDataProfileName ofOrganizationLocationColumnDataProfileName(String organization, String location, String columnDataProfile) {
        return ColumnDataProfileName.newBuilder().setOrganization(organization).setLocation(location).setColumnDataProfile(columnDataProfile).build();
    }

    public static ColumnDataProfileName ofProjectLocationColumnDataProfileName(String project, String location, String columnDataProfile) {
        return ColumnDataProfileName.newProjectLocationColumnDataProfileBuilder().setProject(project).setLocation(location).setColumnDataProfile(columnDataProfile).build();
    }

    public static String format(String organization, String location, String columnDataProfile) {
        return ColumnDataProfileName.newBuilder().setOrganization(organization).setLocation(location).setColumnDataProfile(columnDataProfile).build().toString();
    }

    public static String formatOrganizationLocationColumnDataProfileName(String organization, String location, String columnDataProfile) {
        return ColumnDataProfileName.newBuilder().setOrganization(organization).setLocation(location).setColumnDataProfile(columnDataProfile).build().toString();
    }

    public static String formatProjectLocationColumnDataProfileName(String project, String location, String columnDataProfile) {
        return ColumnDataProfileName.newProjectLocationColumnDataProfileBuilder().setProject(project).setLocation(location).setColumnDataProfile(columnDataProfile).build().toString();
    }

    public static ColumnDataProfileName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_LOCATION_COLUMN_DATA_PROFILE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_COLUMN_DATA_PROFILE.match(formattedString);
            return ColumnDataProfileName.ofOrganizationLocationColumnDataProfileName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("column_data_profile"));
        }
        if (PROJECT_LOCATION_COLUMN_DATA_PROFILE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLUMN_DATA_PROFILE.match(formattedString);
            return ColumnDataProfileName.ofProjectLocationColumnDataProfileName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("column_data_profile"));
        }
        throw new ValidationException("ColumnDataProfileName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ColumnDataProfileName> parseList(List<String> formattedStrings) {
        ArrayList<ColumnDataProfileName> list = new ArrayList<ColumnDataProfileName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ColumnDataProfileName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ColumnDataProfileName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ColumnDataProfileName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_COLUMN_DATA_PROFILE.matches(formattedString) || PROJECT_LOCATION_COLUMN_DATA_PROFILE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ColumnDataProfileName columnDataProfileName = this;
            synchronized (columnDataProfileName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.columnDataProfile != null) {
                        fieldMapBuilder.put((Object)"column_data_profile", (Object)this.columnDataProfile);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ColumnDataProfileName that = (ColumnDataProfileName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.columnDataProfile, that.columnDataProfile) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.columnDataProfile);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectLocationColumnDataProfileBuilder {
        private String project;
        private String location;
        private String columnDataProfile;

        protected ProjectLocationColumnDataProfileBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getColumnDataProfile() {
            return this.columnDataProfile;
        }

        public ProjectLocationColumnDataProfileBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationColumnDataProfileBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationColumnDataProfileBuilder setColumnDataProfile(String columnDataProfile) {
            this.columnDataProfile = columnDataProfile;
            return this;
        }

        public ColumnDataProfileName build() {
            return new ColumnDataProfileName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String location;
        private String columnDataProfile;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getColumnDataProfile() {
            return this.columnDataProfile;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setColumnDataProfile(String columnDataProfile) {
            this.columnDataProfile = columnDataProfile;
            return this;
        }

        private Builder(ColumnDataProfileName columnDataProfileName) {
            Preconditions.checkArgument((boolean)Objects.equals(columnDataProfileName.pathTemplate, ORGANIZATION_LOCATION_COLUMN_DATA_PROFILE), (Object)"toBuilder is only supported when ColumnDataProfileName has the pattern of organizations/{organization}/locations/{location}/columnDataProfiles/{column_data_profile}");
            this.organization = columnDataProfileName.organization;
            this.location = columnDataProfileName.location;
            this.columnDataProfile = columnDataProfileName.columnDataProfile;
        }

        public ColumnDataProfileName build() {
            return new ColumnDataProfileName(this);
        }
    }
}

