/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Settings for creating an AlloyDB cluster.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.AlloyDbSettings}
 */
public final class AlloyDbSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.AlloyDbSettings)
    AlloyDbSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AlloyDbSettings.newBuilder() to construct.
  private AlloyDbSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AlloyDbSettings() {
    vpcNetwork_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AlloyDbSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.AlloyDbSettings.class,
            com.google.cloud.clouddms.v1.AlloyDbSettings.Builder.class);
  }

  public interface UserPasswordOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.AlloyDbSettings.UserPassword)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The database username.
     * </pre>
     *
     * <code>string user = 1;</code>
     *
     * @return The user.
     */
    java.lang.String getUser();
    /**
     *
     *
     * <pre>
     * The database username.
     * </pre>
     *
     * <code>string user = 1;</code>
     *
     * @return The bytes for user.
     */
    com.google.protobuf.ByteString getUserBytes();

    /**
     *
     *
     * <pre>
     * The initial password for the user.
     * </pre>
     *
     * <code>string password = 2;</code>
     *
     * @return The password.
     */
    java.lang.String getPassword();
    /**
     *
     *
     * <pre>
     * The initial password for the user.
     * </pre>
     *
     * <code>string password = 2;</code>
     *
     * @return The bytes for password.
     */
    com.google.protobuf.ByteString getPasswordBytes();

    /**
     *
     *
     * <pre>
     * Output only. Indicates if the initial_user.password field has been set.
     * </pre>
     *
     * <code>bool password_set = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The passwordSet.
     */
    boolean getPasswordSet();
  }
  /**
   *
   *
   * <pre>
   * The username/password for a database user. Used for specifying initial
   * users at cluster creation time.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.AlloyDbSettings.UserPassword}
   */
  public static final class UserPassword extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.AlloyDbSettings.UserPassword)
      UserPasswordOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UserPassword.newBuilder() to construct.
    private UserPassword(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UserPassword() {
      user_ = "";
      password_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UserPassword();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_UserPassword_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_UserPassword_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.class,
              com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.Builder.class);
    }

    public static final int USER_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object user_ = "";
    /**
     *
     *
     * <pre>
     * The database username.
     * </pre>
     *
     * <code>string user = 1;</code>
     *
     * @return The user.
     */
    @java.lang.Override
    public java.lang.String getUser() {
      java.lang.Object ref = user_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        user_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The database username.
     * </pre>
     *
     * <code>string user = 1;</code>
     *
     * @return The bytes for user.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUserBytes() {
      java.lang.Object ref = user_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        user_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PASSWORD_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object password_ = "";
    /**
     *
     *
     * <pre>
     * The initial password for the user.
     * </pre>
     *
     * <code>string password = 2;</code>
     *
     * @return The password.
     */
    @java.lang.Override
    public java.lang.String getPassword() {
      java.lang.Object ref = password_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        password_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The initial password for the user.
     * </pre>
     *
     * <code>string password = 2;</code>
     *
     * @return The bytes for password.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPasswordBytes() {
      java.lang.Object ref = password_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        password_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PASSWORD_SET_FIELD_NUMBER = 3;
    private boolean passwordSet_ = false;
    /**
     *
     *
     * <pre>
     * Output only. Indicates if the initial_user.password field has been set.
     * </pre>
     *
     * <code>bool password_set = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The passwordSet.
     */
    @java.lang.Override
    public boolean getPasswordSet() {
      return passwordSet_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(user_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, user_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, password_);
      }
      if (passwordSet_ != false) {
        output.writeBool(3, passwordSet_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(user_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, user_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, password_);
      }
      if (passwordSet_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, passwordSet_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword)) {
        return super.equals(obj);
      }
      com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword other =
          (com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword) obj;

      if (!getUser().equals(other.getUser())) return false;
      if (!getPassword().equals(other.getPassword())) return false;
      if (getPasswordSet() != other.getPasswordSet()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + USER_FIELD_NUMBER;
      hash = (53 * hash) + getUser().hashCode();
      hash = (37 * hash) + PASSWORD_FIELD_NUMBER;
      hash = (53 * hash) + getPassword().hashCode();
      hash = (37 * hash) + PASSWORD_SET_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPasswordSet());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The username/password for a database user. Used for specifying initial
     * users at cluster creation time.
     * </pre>
     *
     * Protobuf type {@code google.cloud.clouddms.v1.AlloyDbSettings.UserPassword}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.AlloyDbSettings.UserPassword)
        com.google.cloud.clouddms.v1.AlloyDbSettings.UserPasswordOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_UserPassword_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_UserPassword_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.class,
                com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.Builder.class);
      }

      // Construct using com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        user_ = "";
        password_ = "";
        passwordSet_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_UserPassword_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword getDefaultInstanceForType() {
        return com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword build() {
        com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword buildPartial() {
        com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword result =
            new com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.user_ = user_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.password_ = password_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.passwordSet_ = passwordSet_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword) {
          return mergeFrom((com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword other) {
        if (other == com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.getDefaultInstance())
          return this;
        if (!other.getUser().isEmpty()) {
          user_ = other.user_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getPassword().isEmpty()) {
          password_ = other.password_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.getPasswordSet() != false) {
          setPasswordSet(other.getPasswordSet());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  user_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  password_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  passwordSet_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object user_ = "";
      /**
       *
       *
       * <pre>
       * The database username.
       * </pre>
       *
       * <code>string user = 1;</code>
       *
       * @return The user.
       */
      public java.lang.String getUser() {
        java.lang.Object ref = user_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          user_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The database username.
       * </pre>
       *
       * <code>string user = 1;</code>
       *
       * @return The bytes for user.
       */
      public com.google.protobuf.ByteString getUserBytes() {
        java.lang.Object ref = user_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          user_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The database username.
       * </pre>
       *
       * <code>string user = 1;</code>
       *
       * @param value The user to set.
       * @return This builder for chaining.
       */
      public Builder setUser(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        user_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The database username.
       * </pre>
       *
       * <code>string user = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUser() {
        user_ = getDefaultInstance().getUser();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The database username.
       * </pre>
       *
       * <code>string user = 1;</code>
       *
       * @param value The bytes for user to set.
       * @return This builder for chaining.
       */
      public Builder setUserBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        user_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object password_ = "";
      /**
       *
       *
       * <pre>
       * The initial password for the user.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @return The password.
       */
      public java.lang.String getPassword() {
        java.lang.Object ref = password_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          password_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The initial password for the user.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @return The bytes for password.
       */
      public com.google.protobuf.ByteString getPasswordBytes() {
        java.lang.Object ref = password_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          password_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The initial password for the user.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @param value The password to set.
       * @return This builder for chaining.
       */
      public Builder setPassword(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        password_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The initial password for the user.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPassword() {
        password_ = getDefaultInstance().getPassword();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The initial password for the user.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @param value The bytes for password to set.
       * @return This builder for chaining.
       */
      public Builder setPasswordBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        password_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private boolean passwordSet_;
      /**
       *
       *
       * <pre>
       * Output only. Indicates if the initial_user.password field has been set.
       * </pre>
       *
       * <code>bool password_set = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The passwordSet.
       */
      @java.lang.Override
      public boolean getPasswordSet() {
        return passwordSet_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Indicates if the initial_user.password field has been set.
       * </pre>
       *
       * <code>bool password_set = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The passwordSet to set.
       * @return This builder for chaining.
       */
      public Builder setPasswordSet(boolean value) {

        passwordSet_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Indicates if the initial_user.password field has been set.
       * </pre>
       *
       * <code>bool password_set = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPasswordSet() {
        bitField0_ = (bitField0_ & ~0x00000004);
        passwordSet_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.AlloyDbSettings.UserPassword)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.AlloyDbSettings.UserPassword)
    private static final com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword();
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UserPassword> PARSER =
        new com.google.protobuf.AbstractParser<UserPassword>() {
          @java.lang.Override
          public UserPassword parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UserPassword> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UserPassword> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PrimaryInstanceSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The ID of the AlloyDB primary instance. The ID must satisfy the
     * regex expression "[a-z0-9-]+".
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * Required. The ID of the AlloyDB primary instance. The ID must satisfy the
     * regex expression "[a-z0-9-]+".
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * Configuration for the machines that host the underlying
     * database engine.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;
     * </code>
     *
     * @return Whether the machineConfig field is set.
     */
    boolean hasMachineConfig();
    /**
     *
     *
     * <pre>
     * Configuration for the machines that host the underlying
     * database engine.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;
     * </code>
     *
     * @return The machineConfig.
     */
    com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
        getMachineConfig();
    /**
     *
     *
     * <pre>
     * Configuration for the machines that host the underlying
     * database engine.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;
     * </code>
     */
    com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfigOrBuilder
        getMachineConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
     * cluster and instances. See the AlloyDB documentation for how these can be
     * used.
     * </pre>
     *
     * <code>map&lt;string, string&gt; database_flags = 6;</code>
     */
    int getDatabaseFlagsCount();
    /**
     *
     *
     * <pre>
     * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
     * cluster and instances. See the AlloyDB documentation for how these can be
     * used.
     * </pre>
     *
     * <code>map&lt;string, string&gt; database_flags = 6;</code>
     */
    boolean containsDatabaseFlags(java.lang.String key);
    /** Use {@link #getDatabaseFlagsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getDatabaseFlags();
    /**
     *
     *
     * <pre>
     * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
     * cluster and instances. See the AlloyDB documentation for how these can be
     * used.
     * </pre>
     *
     * <code>map&lt;string, string&gt; database_flags = 6;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getDatabaseFlagsMap();
    /**
     *
     *
     * <pre>
     * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
     * cluster and instances. See the AlloyDB documentation for how these can be
     * used.
     * </pre>
     *
     * <code>map&lt;string, string&gt; database_flags = 6;</code>
     */
    /* nullable */
    java.lang.String getDatabaseFlagsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
     * cluster and instances. See the AlloyDB documentation for how these can be
     * used.
     * </pre>
     *
     * <code>map&lt;string, string&gt; database_flags = 6;</code>
     */
    java.lang.String getDatabaseFlagsOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Labels for the AlloyDB primary instance created by DMS. An object
     * containing a list of 'key', 'value' pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    int getLabelsCount();
    /**
     *
     *
     * <pre>
     * Labels for the AlloyDB primary instance created by DMS. An object
     * containing a list of 'key', 'value' pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    boolean containsLabels(java.lang.String key);
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getLabels();
    /**
     *
     *
     * <pre>
     * Labels for the AlloyDB primary instance created by DMS. An object
     * containing a list of 'key', 'value' pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
    /**
     *
     *
     * <pre>
     * Labels for the AlloyDB primary instance created by DMS. An object
     * containing a list of 'key', 'value' pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    /* nullable */
    java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * Labels for the AlloyDB primary instance created by DMS. An object
     * containing a list of 'key', 'value' pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    java.lang.String getLabelsOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Output only. The private IP address for the Instance.
     * This is the connection endpoint for an end-user application.
     * </pre>
     *
     * <code>string private_ip = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The privateIp.
     */
    java.lang.String getPrivateIp();
    /**
     *
     *
     * <pre>
     * Output only. The private IP address for the Instance.
     * This is the connection endpoint for an end-user application.
     * </pre>
     *
     * <code>string private_ip = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for privateIp.
     */
    com.google.protobuf.ByteString getPrivateIpBytes();
  }
  /**
   *
   *
   * <pre>
   * Settings for the cluster's primary instance
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings}
   */
  public static final class PrimaryInstanceSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings)
      PrimaryInstanceSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PrimaryInstanceSettings.newBuilder() to construct.
    private PrimaryInstanceSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PrimaryInstanceSettings() {
      id_ = "";
      privateIp_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PrimaryInstanceSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_PrimaryInstanceSettings_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetDatabaseFlags();
        case 7:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_PrimaryInstanceSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.class,
              com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.Builder.class);
    }

    public interface MachineConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The number of CPU's in the VM instance.
       * </pre>
       *
       * <code>int32 cpu_count = 1;</code>
       *
       * @return The cpuCount.
       */
      int getCpuCount();
    }
    /**
     *
     *
     * <pre>
     * MachineConfig describes the configuration of a machine.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig}
     */
    public static final class MachineConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig)
        MachineConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use MachineConfig.newBuilder() to construct.
      private MachineConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MachineConfig() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MachineConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_PrimaryInstanceSettings_MachineConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_PrimaryInstanceSettings_MachineConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
                    .class,
                com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
                    .Builder.class);
      }

      public static final int CPU_COUNT_FIELD_NUMBER = 1;
      private int cpuCount_ = 0;
      /**
       *
       *
       * <pre>
       * The number of CPU's in the VM instance.
       * </pre>
       *
       * <code>int32 cpu_count = 1;</code>
       *
       * @return The cpuCount.
       */
      @java.lang.Override
      public int getCpuCount() {
        return cpuCount_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (cpuCount_ != 0) {
          output.writeInt32(1, cpuCount_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (cpuCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, cpuCount_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig other =
            (com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig)
                obj;

        if (getCpuCount() != other.getCpuCount()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + CPU_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getCpuCount();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
              .MachineConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
              .MachineConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
              .MachineConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
              .MachineConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
              .MachineConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
              .MachineConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
              .MachineConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
              .MachineConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
              .MachineConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
              .MachineConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
              .MachineConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
              .MachineConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * MachineConfig describes the configuration of a machine.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig)
          com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
              .MachineConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
              .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_PrimaryInstanceSettings_MachineConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
              .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_PrimaryInstanceSettings_MachineConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
                      .class,
                  com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          cpuCount_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
              .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_PrimaryInstanceSettings_MachineConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
            getDefaultInstanceForType() {
          return com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
            build() {
          com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
            buildPartial() {
          com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
              result =
                  new com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
                      .MachineConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.cpuCount_ = cpuCount_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig) {
            return mergeFrom(
                (com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
                other) {
          if (other
              == com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
                  .getDefaultInstance()) return this;
          if (other.getCpuCount() != 0) {
            setCpuCount(other.getCpuCount());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    cpuCount_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int cpuCount_;
        /**
         *
         *
         * <pre>
         * The number of CPU's in the VM instance.
         * </pre>
         *
         * <code>int32 cpu_count = 1;</code>
         *
         * @return The cpuCount.
         */
        @java.lang.Override
        public int getCpuCount() {
          return cpuCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of CPU's in the VM instance.
         * </pre>
         *
         * <code>int32 cpu_count = 1;</code>
         *
         * @param value The cpuCount to set.
         * @return This builder for chaining.
         */
        public Builder setCpuCount(int value) {

          cpuCount_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of CPU's in the VM instance.
         * </pre>
         *
         * <code>int32 cpu_count = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCpuCount() {
          bitField0_ = (bitField0_ & ~0x00000001);
          cpuCount_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig)
      private static final com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
              .MachineConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
                .MachineConfig();
      }

      public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
              .MachineConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MachineConfig> PARSER =
          new com.google.protobuf.AbstractParser<MachineConfig>() {
            @java.lang.Override
            public MachineConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<MachineConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MachineConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of the AlloyDB primary instance. The ID must satisfy the
     * regex expression "[a-z0-9-]+".
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the AlloyDB primary instance. The ID must satisfy the
     * regex expression "[a-z0-9-]+".
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MACHINE_CONFIG_FIELD_NUMBER = 2;
    private com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
        machineConfig_;
    /**
     *
     *
     * <pre>
     * Configuration for the machines that host the underlying
     * database engine.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;
     * </code>
     *
     * @return Whether the machineConfig field is set.
     */
    @java.lang.Override
    public boolean hasMachineConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the machines that host the underlying
     * database engine.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;
     * </code>
     *
     * @return The machineConfig.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
        getMachineConfig() {
      return machineConfig_ == null
          ? com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
              .getDefaultInstance()
          : machineConfig_;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the machines that host the underlying
     * database engine.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
            .MachineConfigOrBuilder
        getMachineConfigOrBuilder() {
      return machineConfig_ == null
          ? com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
              .getDefaultInstance()
          : machineConfig_;
    }

    public static final int DATABASE_FLAGS_FIELD_NUMBER = 6;

    private static final class DatabaseFlagsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.cloud.clouddms.v1.ClouddmsResourcesProto
                  .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_PrimaryInstanceSettings_DatabaseFlagsEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.String> databaseFlags_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetDatabaseFlags() {
      if (databaseFlags_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            DatabaseFlagsDefaultEntryHolder.defaultEntry);
      }
      return databaseFlags_;
    }

    public int getDatabaseFlagsCount() {
      return internalGetDatabaseFlags().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
     * cluster and instances. See the AlloyDB documentation for how these can be
     * used.
     * </pre>
     *
     * <code>map&lt;string, string&gt; database_flags = 6;</code>
     */
    @java.lang.Override
    public boolean containsDatabaseFlags(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDatabaseFlags().getMap().containsKey(key);
    }
    /** Use {@link #getDatabaseFlagsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getDatabaseFlags() {
      return getDatabaseFlagsMap();
    }
    /**
     *
     *
     * <pre>
     * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
     * cluster and instances. See the AlloyDB documentation for how these can be
     * used.
     * </pre>
     *
     * <code>map&lt;string, string&gt; database_flags = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getDatabaseFlagsMap() {
      return internalGetDatabaseFlags().getMap();
    }
    /**
     *
     *
     * <pre>
     * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
     * cluster and instances. See the AlloyDB documentation for how these can be
     * used.
     * </pre>
     *
     * <code>map&lt;string, string&gt; database_flags = 6;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getDatabaseFlagsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDatabaseFlags().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
     * cluster and instances. See the AlloyDB documentation for how these can be
     * used.
     * </pre>
     *
     * <code>map&lt;string, string&gt; database_flags = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getDatabaseFlagsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDatabaseFlags().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int LABELS_FIELD_NUMBER = 7;

    private static final class LabelsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.cloud.clouddms.v1.ClouddmsResourcesProto
                  .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_PrimaryInstanceSettings_LabelsEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels for the AlloyDB primary instance created by DMS. An object
     * containing a list of 'key', 'value' pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels for the AlloyDB primary instance created by DMS. An object
     * containing a list of 'key', 'value' pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels for the AlloyDB primary instance created by DMS. An object
     * containing a list of 'key', 'value' pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels for the AlloyDB primary instance created by DMS. An object
     * containing a list of 'key', 'value' pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int PRIVATE_IP_FIELD_NUMBER = 8;

    @SuppressWarnings("serial")
    private volatile java.lang.Object privateIp_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The private IP address for the Instance.
     * This is the connection endpoint for an end-user application.
     * </pre>
     *
     * <code>string private_ip = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The privateIp.
     */
    @java.lang.Override
    public java.lang.String getPrivateIp() {
      java.lang.Object ref = privateIp_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        privateIp_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The private IP address for the Instance.
     * This is the connection endpoint for an end-user application.
     * </pre>
     *
     * <code>string private_ip = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for privateIp.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPrivateIpBytes() {
      java.lang.Object ref = privateIp_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        privateIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getMachineConfig());
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetDatabaseFlags(), DatabaseFlagsDefaultEntryHolder.defaultEntry, 6);
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 7);
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateIp_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, privateIp_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMachineConfig());
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetDatabaseFlags().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> databaseFlags__ =
            DatabaseFlagsDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, databaseFlags__);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetLabels().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
            LabelsDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, labels__);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateIp_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, privateIp_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings other =
          (com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings) obj;

      if (!getId().equals(other.getId())) return false;
      if (hasMachineConfig() != other.hasMachineConfig()) return false;
      if (hasMachineConfig()) {
        if (!getMachineConfig().equals(other.getMachineConfig())) return false;
      }
      if (!internalGetDatabaseFlags().equals(other.internalGetDatabaseFlags())) return false;
      if (!internalGetLabels().equals(other.internalGetLabels())) return false;
      if (!getPrivateIp().equals(other.getPrivateIp())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      if (hasMachineConfig()) {
        hash = (37 * hash) + MACHINE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getMachineConfig().hashCode();
      }
      if (!internalGetDatabaseFlags().getMap().isEmpty()) {
        hash = (37 * hash) + DATABASE_FLAGS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetDatabaseFlags().hashCode();
      }
      if (!internalGetLabels().getMap().isEmpty()) {
        hash = (37 * hash) + LABELS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetLabels().hashCode();
      }
      hash = (37 * hash) + PRIVATE_IP_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateIp().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Settings for the cluster's primary instance
     * </pre>
     *
     * Protobuf type {@code google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings)
        com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_PrimaryInstanceSettings_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 6:
            return internalGetDatabaseFlags();
          case 7:
            return internalGetLabels();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 6:
            return internalGetMutableDatabaseFlags();
          case 7:
            return internalGetMutableLabels();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_PrimaryInstanceSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.class,
                com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.Builder.class);
      }

      // Construct using
      // com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMachineConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        id_ = "";
        machineConfig_ = null;
        if (machineConfigBuilder_ != null) {
          machineConfigBuilder_.dispose();
          machineConfigBuilder_ = null;
        }
        internalGetMutableDatabaseFlags().clear();
        internalGetMutableLabels().clear();
        privateIp_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_PrimaryInstanceSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
          getDefaultInstanceForType() {
        return com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings build() {
        com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings buildPartial() {
        com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings result =
            new com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.id_ = id_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.machineConfig_ =
              machineConfigBuilder_ == null ? machineConfig_ : machineConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.databaseFlags_ = internalGetDatabaseFlags();
          result.databaseFlags_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.labels_ = internalGetLabels();
          result.labels_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.privateIp_ = privateIp_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings) {
          return mergeFrom(
              (com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings other) {
        if (other
            == com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
                .getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasMachineConfig()) {
          mergeMachineConfig(other.getMachineConfig());
        }
        internalGetMutableDatabaseFlags().mergeFrom(other.internalGetDatabaseFlags());
        bitField0_ |= 0x00000004;
        internalGetMutableLabels().mergeFrom(other.internalGetLabels());
        bitField0_ |= 0x00000008;
        if (!other.getPrivateIp().isEmpty()) {
          privateIp_ = other.privateIp_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getMachineConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 50:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String> databaseFlags__ =
                      input.readMessage(
                          DatabaseFlagsDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
                  internalGetMutableDatabaseFlags()
                      .getMutableMap()
                      .put(databaseFlags__.getKey(), databaseFlags__.getValue());
                  bitField0_ |= 0x00000004;
                  break;
                } // case 50
              case 58:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                      input.readMessage(
                          LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
                  internalGetMutableLabels()
                      .getMutableMap()
                      .put(labels__.getKey(), labels__.getValue());
                  bitField0_ |= 0x00000008;
                  break;
                } // case 58
              case 66:
                {
                  privateIp_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 66
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of the AlloyDB primary instance. The ID must satisfy the
       * regex expression "[a-z0-9-]+".
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the AlloyDB primary instance. The ID must satisfy the
       * regex expression "[a-z0-9-]+".
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the AlloyDB primary instance. The ID must satisfy the
       * regex expression "[a-z0-9-]+".
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the AlloyDB primary instance. The ID must satisfy the
       * regex expression "[a-z0-9-]+".
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the AlloyDB primary instance. The ID must satisfy the
       * regex expression "[a-z0-9-]+".
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
          machineConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig,
              com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
                  .Builder,
              com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
                  .MachineConfigOrBuilder>
          machineConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Configuration for the machines that host the underlying
       * database engine.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;
       * </code>
       *
       * @return Whether the machineConfig field is set.
       */
      public boolean hasMachineConfig() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Configuration for the machines that host the underlying
       * database engine.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;
       * </code>
       *
       * @return The machineConfig.
       */
      public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
          getMachineConfig() {
        if (machineConfigBuilder_ == null) {
          return machineConfig_ == null
              ? com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
                  .getDefaultInstance()
              : machineConfig_;
        } else {
          return machineConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Configuration for the machines that host the underlying
       * database engine.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;
       * </code>
       */
      public Builder setMachineConfig(
          com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
              value) {
        if (machineConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          machineConfig_ = value;
        } else {
          machineConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration for the machines that host the underlying
       * database engine.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;
       * </code>
       */
      public Builder setMachineConfig(
          com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig.Builder
              builderForValue) {
        if (machineConfigBuilder_ == null) {
          machineConfig_ = builderForValue.build();
        } else {
          machineConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration for the machines that host the underlying
       * database engine.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;
       * </code>
       */
      public Builder mergeMachineConfig(
          com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
              value) {
        if (machineConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && machineConfig_ != null
              && machineConfig_
                  != com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
                      .MachineConfig.getDefaultInstance()) {
            getMachineConfigBuilder().mergeFrom(value);
          } else {
            machineConfig_ = value;
          }
        } else {
          machineConfigBuilder_.mergeFrom(value);
        }
        if (machineConfig_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration for the machines that host the underlying
       * database engine.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;
       * </code>
       */
      public Builder clearMachineConfig() {
        bitField0_ = (bitField0_ & ~0x00000002);
        machineConfig_ = null;
        if (machineConfigBuilder_ != null) {
          machineConfigBuilder_.dispose();
          machineConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration for the machines that host the underlying
       * database engine.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;
       * </code>
       */
      public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
              .Builder
          getMachineConfigBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getMachineConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Configuration for the machines that host the underlying
       * database engine.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;
       * </code>
       */
      public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
              .MachineConfigOrBuilder
          getMachineConfigOrBuilder() {
        if (machineConfigBuilder_ != null) {
          return machineConfigBuilder_.getMessageOrBuilder();
        } else {
          return machineConfig_ == null
              ? com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
                  .getDefaultInstance()
              : machineConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Configuration for the machines that host the underlying
       * database engine.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig,
              com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
                  .Builder,
              com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
                  .MachineConfigOrBuilder>
          getMachineConfigFieldBuilder() {
        if (machineConfigBuilder_ == null) {
          machineConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
                      .MachineConfig,
                  com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig
                      .Builder,
                  com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
                      .MachineConfigOrBuilder>(
                  getMachineConfig(), getParentForChildren(), isClean());
          machineConfig_ = null;
        }
        return machineConfigBuilder_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> databaseFlags_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetDatabaseFlags() {
        if (databaseFlags_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              DatabaseFlagsDefaultEntryHolder.defaultEntry);
        }
        return databaseFlags_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableDatabaseFlags() {
        if (databaseFlags_ == null) {
          databaseFlags_ =
              com.google.protobuf.MapField.newMapField(
                  DatabaseFlagsDefaultEntryHolder.defaultEntry);
        }
        if (!databaseFlags_.isMutable()) {
          databaseFlags_ = databaseFlags_.copy();
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return databaseFlags_;
      }

      public int getDatabaseFlagsCount() {
        return internalGetDatabaseFlags().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
       * cluster and instances. See the AlloyDB documentation for how these can be
       * used.
       * </pre>
       *
       * <code>map&lt;string, string&gt; database_flags = 6;</code>
       */
      @java.lang.Override
      public boolean containsDatabaseFlags(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetDatabaseFlags().getMap().containsKey(key);
      }
      /** Use {@link #getDatabaseFlagsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getDatabaseFlags() {
        return getDatabaseFlagsMap();
      }
      /**
       *
       *
       * <pre>
       * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
       * cluster and instances. See the AlloyDB documentation for how these can be
       * used.
       * </pre>
       *
       * <code>map&lt;string, string&gt; database_flags = 6;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getDatabaseFlagsMap() {
        return internalGetDatabaseFlags().getMap();
      }
      /**
       *
       *
       * <pre>
       * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
       * cluster and instances. See the AlloyDB documentation for how these can be
       * used.
       * </pre>
       *
       * <code>map&lt;string, string&gt; database_flags = 6;</code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getDatabaseFlagsOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetDatabaseFlags().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
       * cluster and instances. See the AlloyDB documentation for how these can be
       * used.
       * </pre>
       *
       * <code>map&lt;string, string&gt; database_flags = 6;</code>
       */
      @java.lang.Override
      public java.lang.String getDatabaseFlagsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetDatabaseFlags().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearDatabaseFlags() {
        bitField0_ = (bitField0_ & ~0x00000004);
        internalGetMutableDatabaseFlags().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
       * cluster and instances. See the AlloyDB documentation for how these can be
       * used.
       * </pre>
       *
       * <code>map&lt;string, string&gt; database_flags = 6;</code>
       */
      public Builder removeDatabaseFlags(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableDatabaseFlags().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableDatabaseFlags() {
        bitField0_ |= 0x00000004;
        return internalGetMutableDatabaseFlags().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
       * cluster and instances. See the AlloyDB documentation for how these can be
       * used.
       * </pre>
       *
       * <code>map&lt;string, string&gt; database_flags = 6;</code>
       */
      public Builder putDatabaseFlags(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableDatabaseFlags().getMutableMap().put(key, value);
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
       * cluster and instances. See the AlloyDB documentation for how these can be
       * used.
       * </pre>
       *
       * <code>map&lt;string, string&gt; database_flags = 6;</code>
       */
      public Builder putAllDatabaseFlags(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableDatabaseFlags().getMutableMap().putAll(values);
        bitField0_ |= 0x00000004;
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
        if (labels_ == null) {
          return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return labels_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableLabels() {
        if (labels_ == null) {
          labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        if (!labels_.isMutable()) {
          labels_ = labels_.copy();
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return labels_;
      }

      public int getLabelsCount() {
        return internalGetLabels().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Labels for the AlloyDB primary instance created by DMS. An object
       * containing a list of 'key', 'value' pairs.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 7;</code>
       */
      @java.lang.Override
      public boolean containsLabels(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetLabels().getMap().containsKey(key);
      }
      /** Use {@link #getLabelsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getLabels() {
        return getLabelsMap();
      }
      /**
       *
       *
       * <pre>
       * Labels for the AlloyDB primary instance created by DMS. An object
       * containing a list of 'key', 'value' pairs.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 7;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
        return internalGetLabels().getMap();
      }
      /**
       *
       *
       * <pre>
       * Labels for the AlloyDB primary instance created by DMS. An object
       * containing a list of 'key', 'value' pairs.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 7;</code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getLabelsOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Labels for the AlloyDB primary instance created by DMS. An object
       * containing a list of 'key', 'value' pairs.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 7;</code>
       */
      @java.lang.Override
      public java.lang.String getLabelsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearLabels() {
        bitField0_ = (bitField0_ & ~0x00000008);
        internalGetMutableLabels().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Labels for the AlloyDB primary instance created by DMS. An object
       * containing a list of 'key', 'value' pairs.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 7;</code>
       */
      public Builder removeLabels(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableLabels().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
        bitField0_ |= 0x00000008;
        return internalGetMutableLabels().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Labels for the AlloyDB primary instance created by DMS. An object
       * containing a list of 'key', 'value' pairs.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 7;</code>
       */
      public Builder putLabels(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableLabels().getMutableMap().put(key, value);
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Labels for the AlloyDB primary instance created by DMS. An object
       * containing a list of 'key', 'value' pairs.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 7;</code>
       */
      public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableLabels().getMutableMap().putAll(values);
        bitField0_ |= 0x00000008;
        return this;
      }

      private java.lang.Object privateIp_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The private IP address for the Instance.
       * This is the connection endpoint for an end-user application.
       * </pre>
       *
       * <code>string private_ip = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The privateIp.
       */
      public java.lang.String getPrivateIp() {
        java.lang.Object ref = privateIp_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          privateIp_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The private IP address for the Instance.
       * This is the connection endpoint for an end-user application.
       * </pre>
       *
       * <code>string private_ip = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for privateIp.
       */
      public com.google.protobuf.ByteString getPrivateIpBytes() {
        java.lang.Object ref = privateIp_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          privateIp_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The private IP address for the Instance.
       * This is the connection endpoint for an end-user application.
       * </pre>
       *
       * <code>string private_ip = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The privateIp to set.
       * @return This builder for chaining.
       */
      public Builder setPrivateIp(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateIp_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The private IP address for the Instance.
       * This is the connection endpoint for an end-user application.
       * </pre>
       *
       * <code>string private_ip = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrivateIp() {
        privateIp_ = getDefaultInstance().getPrivateIp();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The private IP address for the Instance.
       * This is the connection endpoint for an end-user application.
       * </pre>
       *
       * <code>string private_ip = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for privateIp to set.
       * @return This builder for chaining.
       */
      public Builder setPrivateIpBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        privateIp_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings)
    private static final com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings();
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PrimaryInstanceSettings> PARSER =
        new com.google.protobuf.AbstractParser<PrimaryInstanceSettings>() {
          @java.lang.Override
          public PrimaryInstanceSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PrimaryInstanceSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PrimaryInstanceSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface EncryptionConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The fully-qualified resource name of the KMS key.
     * Each Cloud KMS key is regionalized and has the following format:
     * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
     * </pre>
     *
     * <code>string kms_key_name = 1;</code>
     *
     * @return The kmsKeyName.
     */
    java.lang.String getKmsKeyName();
    /**
     *
     *
     * <pre>
     * The fully-qualified resource name of the KMS key.
     * Each Cloud KMS key is regionalized and has the following format:
     * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
     * </pre>
     *
     * <code>string kms_key_name = 1;</code>
     *
     * @return The bytes for kmsKeyName.
     */
    com.google.protobuf.ByteString getKmsKeyNameBytes();
  }
  /**
   *
   *
   * <pre>
   * EncryptionConfig describes the encryption config of a cluster that is
   * encrypted with a CMEK (customer-managed encryption key).
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig}
   */
  public static final class EncryptionConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig)
      EncryptionConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use EncryptionConfig.newBuilder() to construct.
    private EncryptionConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EncryptionConfig() {
      kmsKeyName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EncryptionConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_EncryptionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_EncryptionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig.class,
              com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig.Builder.class);
    }

    public static final int KMS_KEY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object kmsKeyName_ = "";
    /**
     *
     *
     * <pre>
     * The fully-qualified resource name of the KMS key.
     * Each Cloud KMS key is regionalized and has the following format:
     * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
     * </pre>
     *
     * <code>string kms_key_name = 1;</code>
     *
     * @return The kmsKeyName.
     */
    @java.lang.Override
    public java.lang.String getKmsKeyName() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The fully-qualified resource name of the KMS key.
     * Each Cloud KMS key is regionalized and has the following format:
     * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
     * </pre>
     *
     * <code>string kms_key_name = 1;</code>
     *
     * @return The bytes for kmsKeyName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKmsKeyNameBytes() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, kmsKeyName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, kmsKeyName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig other =
          (com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig) obj;

      if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getKmsKeyName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * EncryptionConfig describes the encryption config of a cluster that is
     * encrypted with a CMEK (customer-managed encryption key).
     * </pre>
     *
     * Protobuf type {@code google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig)
        com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_EncryptionConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_EncryptionConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig.class,
                com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig.Builder.class);
      }

      // Construct using com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        kmsKeyName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_EncryptionConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig
          getDefaultInstanceForType() {
        return com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig build() {
        com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig buildPartial() {
        com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig result =
            new com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.kmsKeyName_ = kmsKeyName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig) {
          return mergeFrom((com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig other) {
        if (other
            == com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig.getDefaultInstance())
          return this;
        if (!other.getKmsKeyName().isEmpty()) {
          kmsKeyName_ = other.kmsKeyName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  kmsKeyName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object kmsKeyName_ = "";
      /**
       *
       *
       * <pre>
       * The fully-qualified resource name of the KMS key.
       * Each Cloud KMS key is regionalized and has the following format:
       * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
       * </pre>
       *
       * <code>string kms_key_name = 1;</code>
       *
       * @return The kmsKeyName.
       */
      public java.lang.String getKmsKeyName() {
        java.lang.Object ref = kmsKeyName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          kmsKeyName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The fully-qualified resource name of the KMS key.
       * Each Cloud KMS key is regionalized and has the following format:
       * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
       * </pre>
       *
       * <code>string kms_key_name = 1;</code>
       *
       * @return The bytes for kmsKeyName.
       */
      public com.google.protobuf.ByteString getKmsKeyNameBytes() {
        java.lang.Object ref = kmsKeyName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          kmsKeyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The fully-qualified resource name of the KMS key.
       * Each Cloud KMS key is regionalized and has the following format:
       * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
       * </pre>
       *
       * <code>string kms_key_name = 1;</code>
       *
       * @param value The kmsKeyName to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKeyName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        kmsKeyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fully-qualified resource name of the KMS key.
       * Each Cloud KMS key is regionalized and has the following format:
       * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
       * </pre>
       *
       * <code>string kms_key_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKmsKeyName() {
        kmsKeyName_ = getDefaultInstance().getKmsKeyName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fully-qualified resource name of the KMS key.
       * Each Cloud KMS key is regionalized and has the following format:
       * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
       * </pre>
       *
       * <code>string kms_key_name = 1;</code>
       *
       * @param value The bytes for kmsKeyName to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        kmsKeyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig)
    private static final com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig();
    }

    public static com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EncryptionConfig> PARSER =
        new com.google.protobuf.AbstractParser<EncryptionConfig>() {
          @java.lang.Override
          public EncryptionConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EncryptionConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EncryptionConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int INITIAL_USER_FIELD_NUMBER = 1;
  private com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initialUser_;
  /**
   *
   *
   * <pre>
   * Required. Input only. Initial user to setup during cluster creation.
   * Required.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initial_user = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return Whether the initialUser field is set.
   */
  @java.lang.Override
  public boolean hasInitialUser() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Input only. Initial user to setup during cluster creation.
   * Required.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initial_user = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The initialUser.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword getInitialUser() {
    return initialUser_ == null
        ? com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.getDefaultInstance()
        : initialUser_;
  }
  /**
   *
   *
   * <pre>
   * Required. Input only. Initial user to setup during cluster creation.
   * Required.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initial_user = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.AlloyDbSettings.UserPasswordOrBuilder
      getInitialUserOrBuilder() {
    return initialUser_ == null
        ? com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.getDefaultInstance()
        : initialUser_;
  }

  public static final int VPC_NETWORK_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object vpcNetwork_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource link for the VPC network in which cluster resources
   * are created and from which they are accessible via Private IP. The network
   * must belong to the same project as the cluster. It is specified in the
   * form: "projects/{project_number}/global/networks/{network_id}". This is
   * required to create a cluster.
   * </pre>
   *
   * <code>string vpc_network = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The vpcNetwork.
   */
  @java.lang.Override
  public java.lang.String getVpcNetwork() {
    java.lang.Object ref = vpcNetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      vpcNetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource link for the VPC network in which cluster resources
   * are created and from which they are accessible via Private IP. The network
   * must belong to the same project as the cluster. It is specified in the
   * form: "projects/{project_number}/global/networks/{network_id}". This is
   * required to create a cluster.
   * </pre>
   *
   * <code>string vpc_network = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for vpcNetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVpcNetworkBytes() {
    java.lang.Object ref = vpcNetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      vpcNetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 3;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.clouddms.v1.ClouddmsResourcesProto
                .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels for the AlloyDB cluster created by DMS. An object containing a list
   * of 'key', 'value' pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels for the AlloyDB cluster created by DMS. An object containing a list
   * of 'key', 'value' pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels for the AlloyDB cluster created by DMS. An object containing a list
   * of 'key', 'value' pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels for the AlloyDB cluster created by DMS. An object containing a list
   * of 'key', 'value' pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int PRIMARY_INSTANCE_SETTINGS_FIELD_NUMBER = 4;
  private com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
      primaryInstanceSettings_;
  /**
   * <code>
   * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings primary_instance_settings = 4;
   * </code>
   *
   * @return Whether the primaryInstanceSettings field is set.
   */
  @java.lang.Override
  public boolean hasPrimaryInstanceSettings() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <code>
   * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings primary_instance_settings = 4;
   * </code>
   *
   * @return The primaryInstanceSettings.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
      getPrimaryInstanceSettings() {
    return primaryInstanceSettings_ == null
        ? com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.getDefaultInstance()
        : primaryInstanceSettings_;
  }
  /**
   * <code>
   * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings primary_instance_settings = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettingsOrBuilder
      getPrimaryInstanceSettingsOrBuilder() {
    return primaryInstanceSettings_ == null
        ? com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.getDefaultInstance()
        : primaryInstanceSettings_;
  }

  public static final int ENCRYPTION_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryptionConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The encryption config can be specified to encrypt the data disks
   * and other persistent data resources of a cluster with a
   * customer-managed encryption key (CMEK). When this field is not
   * specified, the cluster will then use default encryption scheme to
   * protect the user data.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the encryptionConfig field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The encryption config can be specified to encrypt the data disks
   * and other persistent data resources of a cluster with a
   * customer-managed encryption key (CMEK). When this field is not
   * specified, the cluster will then use default encryption scheme to
   * protect the user data.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The encryptionConfig.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig getEncryptionConfig() {
    return encryptionConfig_ == null
        ? com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The encryption config can be specified to encrypt the data disks
   * and other persistent data resources of a cluster with a
   * customer-managed encryption key (CMEK). When this field is not
   * specified, the cluster will then use default encryption scheme to
   * protect the user data.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfigOrBuilder
      getEncryptionConfigOrBuilder() {
    return encryptionConfig_ == null
        ? com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getInitialUser());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vpcNetwork_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, vpcNetwork_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 3);
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getPrimaryInstanceSettings());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getEncryptionConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInitialUser());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vpcNetwork_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, vpcNetwork_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, labels__);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPrimaryInstanceSettings());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEncryptionConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.AlloyDbSettings)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.AlloyDbSettings other =
        (com.google.cloud.clouddms.v1.AlloyDbSettings) obj;

    if (hasInitialUser() != other.hasInitialUser()) return false;
    if (hasInitialUser()) {
      if (!getInitialUser().equals(other.getInitialUser())) return false;
    }
    if (!getVpcNetwork().equals(other.getVpcNetwork())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasPrimaryInstanceSettings() != other.hasPrimaryInstanceSettings()) return false;
    if (hasPrimaryInstanceSettings()) {
      if (!getPrimaryInstanceSettings().equals(other.getPrimaryInstanceSettings())) return false;
    }
    if (hasEncryptionConfig() != other.hasEncryptionConfig()) return false;
    if (hasEncryptionConfig()) {
      if (!getEncryptionConfig().equals(other.getEncryptionConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasInitialUser()) {
      hash = (37 * hash) + INITIAL_USER_FIELD_NUMBER;
      hash = (53 * hash) + getInitialUser().hashCode();
    }
    hash = (37 * hash) + VPC_NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getVpcNetwork().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasPrimaryInstanceSettings()) {
      hash = (37 * hash) + PRIMARY_INSTANCE_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getPrimaryInstanceSettings().hashCode();
    }
    if (hasEncryptionConfig()) {
      hash = (37 * hash) + ENCRYPTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.AlloyDbSettings parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.AlloyDbSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.AlloyDbSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.AlloyDbSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.AlloyDbSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.AlloyDbSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.AlloyDbSettings parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.AlloyDbSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.AlloyDbSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.AlloyDbSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.AlloyDbSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.AlloyDbSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.AlloyDbSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Settings for creating an AlloyDB cluster.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.AlloyDbSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.AlloyDbSettings)
      com.google.cloud.clouddms.v1.AlloyDbSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.AlloyDbSettings.class,
              com.google.cloud.clouddms.v1.AlloyDbSettings.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.AlloyDbSettings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInitialUserFieldBuilder();
        getPrimaryInstanceSettingsFieldBuilder();
        getEncryptionConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      initialUser_ = null;
      if (initialUserBuilder_ != null) {
        initialUserBuilder_.dispose();
        initialUserBuilder_ = null;
      }
      vpcNetwork_ = "";
      internalGetMutableLabels().clear();
      primaryInstanceSettings_ = null;
      if (primaryInstanceSettingsBuilder_ != null) {
        primaryInstanceSettingsBuilder_.dispose();
        primaryInstanceSettingsBuilder_ = null;
      }
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_AlloyDbSettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.AlloyDbSettings getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.AlloyDbSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.AlloyDbSettings build() {
      com.google.cloud.clouddms.v1.AlloyDbSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.AlloyDbSettings buildPartial() {
      com.google.cloud.clouddms.v1.AlloyDbSettings result =
          new com.google.cloud.clouddms.v1.AlloyDbSettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.AlloyDbSettings result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.initialUser_ =
            initialUserBuilder_ == null ? initialUser_ : initialUserBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.vpcNetwork_ = vpcNetwork_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.primaryInstanceSettings_ =
            primaryInstanceSettingsBuilder_ == null
                ? primaryInstanceSettings_
                : primaryInstanceSettingsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.encryptionConfig_ =
            encryptionConfigBuilder_ == null ? encryptionConfig_ : encryptionConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.AlloyDbSettings) {
        return mergeFrom((com.google.cloud.clouddms.v1.AlloyDbSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.AlloyDbSettings other) {
      if (other == com.google.cloud.clouddms.v1.AlloyDbSettings.getDefaultInstance()) return this;
      if (other.hasInitialUser()) {
        mergeInitialUser(other.getInitialUser());
      }
      if (!other.getVpcNetwork().isEmpty()) {
        vpcNetwork_ = other.vpcNetwork_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000004;
      if (other.hasPrimaryInstanceSettings()) {
        mergePrimaryInstanceSettings(other.getPrimaryInstanceSettings());
      }
      if (other.hasEncryptionConfig()) {
        mergeEncryptionConfig(other.getEncryptionConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getInitialUserFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                vpcNetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getPrimaryInstanceSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getEncryptionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initialUser_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword,
            com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.Builder,
            com.google.cloud.clouddms.v1.AlloyDbSettings.UserPasswordOrBuilder>
        initialUserBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Input only. Initial user to setup during cluster creation.
     * Required.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initial_user = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the initialUser field is set.
     */
    public boolean hasInitialUser() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. Initial user to setup during cluster creation.
     * Required.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initial_user = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The initialUser.
     */
    public com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword getInitialUser() {
      if (initialUserBuilder_ == null) {
        return initialUser_ == null
            ? com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.getDefaultInstance()
            : initialUser_;
      } else {
        return initialUserBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. Initial user to setup during cluster creation.
     * Required.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initial_user = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setInitialUser(com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword value) {
      if (initialUserBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        initialUser_ = value;
      } else {
        initialUserBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. Initial user to setup during cluster creation.
     * Required.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initial_user = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setInitialUser(
        com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.Builder builderForValue) {
      if (initialUserBuilder_ == null) {
        initialUser_ = builderForValue.build();
      } else {
        initialUserBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. Initial user to setup during cluster creation.
     * Required.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initial_user = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder mergeInitialUser(
        com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword value) {
      if (initialUserBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && initialUser_ != null
            && initialUser_
                != com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.getDefaultInstance()) {
          getInitialUserBuilder().mergeFrom(value);
        } else {
          initialUser_ = value;
        }
      } else {
        initialUserBuilder_.mergeFrom(value);
      }
      if (initialUser_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. Initial user to setup during cluster creation.
     * Required.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initial_user = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder clearInitialUser() {
      bitField0_ = (bitField0_ & ~0x00000001);
      initialUser_ = null;
      if (initialUserBuilder_ != null) {
        initialUserBuilder_.dispose();
        initialUserBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. Initial user to setup during cluster creation.
     * Required.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initial_user = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.Builder
        getInitialUserBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getInitialUserFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. Initial user to setup during cluster creation.
     * Required.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initial_user = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.clouddms.v1.AlloyDbSettings.UserPasswordOrBuilder
        getInitialUserOrBuilder() {
      if (initialUserBuilder_ != null) {
        return initialUserBuilder_.getMessageOrBuilder();
      } else {
        return initialUser_ == null
            ? com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.getDefaultInstance()
            : initialUser_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. Initial user to setup during cluster creation.
     * Required.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initial_user = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword,
            com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.Builder,
            com.google.cloud.clouddms.v1.AlloyDbSettings.UserPasswordOrBuilder>
        getInitialUserFieldBuilder() {
      if (initialUserBuilder_ == null) {
        initialUserBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword,
                com.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword.Builder,
                com.google.cloud.clouddms.v1.AlloyDbSettings.UserPasswordOrBuilder>(
                getInitialUser(), getParentForChildren(), isClean());
        initialUser_ = null;
      }
      return initialUserBuilder_;
    }

    private java.lang.Object vpcNetwork_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource link for the VPC network in which cluster resources
     * are created and from which they are accessible via Private IP. The network
     * must belong to the same project as the cluster. It is specified in the
     * form: "projects/{project_number}/global/networks/{network_id}". This is
     * required to create a cluster.
     * </pre>
     *
     * <code>string vpc_network = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The vpcNetwork.
     */
    public java.lang.String getVpcNetwork() {
      java.lang.Object ref = vpcNetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vpcNetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource link for the VPC network in which cluster resources
     * are created and from which they are accessible via Private IP. The network
     * must belong to the same project as the cluster. It is specified in the
     * form: "projects/{project_number}/global/networks/{network_id}". This is
     * required to create a cluster.
     * </pre>
     *
     * <code>string vpc_network = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for vpcNetwork.
     */
    public com.google.protobuf.ByteString getVpcNetworkBytes() {
      java.lang.Object ref = vpcNetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vpcNetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource link for the VPC network in which cluster resources
     * are created and from which they are accessible via Private IP. The network
     * must belong to the same project as the cluster. It is specified in the
     * form: "projects/{project_number}/global/networks/{network_id}". This is
     * required to create a cluster.
     * </pre>
     *
     * <code>string vpc_network = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The vpcNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setVpcNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      vpcNetwork_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource link for the VPC network in which cluster resources
     * are created and from which they are accessible via Private IP. The network
     * must belong to the same project as the cluster. It is specified in the
     * form: "projects/{project_number}/global/networks/{network_id}". This is
     * required to create a cluster.
     * </pre>
     *
     * <code>string vpc_network = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVpcNetwork() {
      vpcNetwork_ = getDefaultInstance().getVpcNetwork();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource link for the VPC network in which cluster resources
     * are created and from which they are accessible via Private IP. The network
     * must belong to the same project as the cluster. It is specified in the
     * form: "projects/{project_number}/global/networks/{network_id}". This is
     * required to create a cluster.
     * </pre>
     *
     * <code>string vpc_network = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for vpcNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setVpcNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      vpcNetwork_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels for the AlloyDB cluster created by DMS. An object containing a list
     * of 'key', 'value' pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels for the AlloyDB cluster created by DMS. An object containing a list
     * of 'key', 'value' pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels for the AlloyDB cluster created by DMS. An object containing a list
     * of 'key', 'value' pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels for the AlloyDB cluster created by DMS. An object containing a list
     * of 'key', 'value' pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels for the AlloyDB cluster created by DMS. An object containing a list
     * of 'key', 'value' pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000004;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels for the AlloyDB cluster created by DMS. An object containing a list
     * of 'key', 'value' pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels for the AlloyDB cluster created by DMS. An object containing a list
     * of 'key', 'value' pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    private com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
        primaryInstanceSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings,
            com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.Builder,
            com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettingsOrBuilder>
        primaryInstanceSettingsBuilder_;
    /**
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings primary_instance_settings = 4;
     * </code>
     *
     * @return Whether the primaryInstanceSettings field is set.
     */
    public boolean hasPrimaryInstanceSettings() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings primary_instance_settings = 4;
     * </code>
     *
     * @return The primaryInstanceSettings.
     */
    public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
        getPrimaryInstanceSettings() {
      if (primaryInstanceSettingsBuilder_ == null) {
        return primaryInstanceSettings_ == null
            ? com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
                .getDefaultInstance()
            : primaryInstanceSettings_;
      } else {
        return primaryInstanceSettingsBuilder_.getMessage();
      }
    }
    /**
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings primary_instance_settings = 4;
     * </code>
     */
    public Builder setPrimaryInstanceSettings(
        com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings value) {
      if (primaryInstanceSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        primaryInstanceSettings_ = value;
      } else {
        primaryInstanceSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings primary_instance_settings = 4;
     * </code>
     */
    public Builder setPrimaryInstanceSettings(
        com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.Builder
            builderForValue) {
      if (primaryInstanceSettingsBuilder_ == null) {
        primaryInstanceSettings_ = builderForValue.build();
      } else {
        primaryInstanceSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings primary_instance_settings = 4;
     * </code>
     */
    public Builder mergePrimaryInstanceSettings(
        com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings value) {
      if (primaryInstanceSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && primaryInstanceSettings_ != null
            && primaryInstanceSettings_
                != com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
                    .getDefaultInstance()) {
          getPrimaryInstanceSettingsBuilder().mergeFrom(value);
        } else {
          primaryInstanceSettings_ = value;
        }
      } else {
        primaryInstanceSettingsBuilder_.mergeFrom(value);
      }
      if (primaryInstanceSettings_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings primary_instance_settings = 4;
     * </code>
     */
    public Builder clearPrimaryInstanceSettings() {
      bitField0_ = (bitField0_ & ~0x00000008);
      primaryInstanceSettings_ = null;
      if (primaryInstanceSettingsBuilder_ != null) {
        primaryInstanceSettingsBuilder_.dispose();
        primaryInstanceSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings primary_instance_settings = 4;
     * </code>
     */
    public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.Builder
        getPrimaryInstanceSettingsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getPrimaryInstanceSettingsFieldBuilder().getBuilder();
    }
    /**
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings primary_instance_settings = 4;
     * </code>
     */
    public com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettingsOrBuilder
        getPrimaryInstanceSettingsOrBuilder() {
      if (primaryInstanceSettingsBuilder_ != null) {
        return primaryInstanceSettingsBuilder_.getMessageOrBuilder();
      } else {
        return primaryInstanceSettings_ == null
            ? com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings
                .getDefaultInstance()
            : primaryInstanceSettings_;
      }
    }
    /**
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings primary_instance_settings = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings,
            com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.Builder,
            com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettingsOrBuilder>
        getPrimaryInstanceSettingsFieldBuilder() {
      if (primaryInstanceSettingsBuilder_ == null) {
        primaryInstanceSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings,
                com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.Builder,
                com.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettingsOrBuilder>(
                getPrimaryInstanceSettings(), getParentForChildren(), isClean());
        primaryInstanceSettings_ = null;
      }
      return primaryInstanceSettingsBuilder_;
    }

    private com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryptionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig,
            com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig.Builder,
            com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfigOrBuilder>
        encryptionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the encryptionConfig field is set.
     */
    public boolean hasEncryptionConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The encryptionConfig.
     */
    public com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig getEncryptionConfig() {
      if (encryptionConfigBuilder_ == null) {
        return encryptionConfig_ == null
            ? com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      } else {
        return encryptionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionConfig_ = value;
      } else {
        encryptionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig.Builder builderForValue) {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfig_ = builderForValue.build();
      } else {
        encryptionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEncryptionConfig(
        com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && encryptionConfig_ != null
            && encryptionConfig_
                != com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig
                    .getDefaultInstance()) {
          getEncryptionConfigBuilder().mergeFrom(value);
        } else {
          encryptionConfig_ = value;
        }
      } else {
        encryptionConfigBuilder_.mergeFrom(value);
      }
      if (encryptionConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEncryptionConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig.Builder
        getEncryptionConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getEncryptionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfigOrBuilder
        getEncryptionConfigOrBuilder() {
      if (encryptionConfigBuilder_ != null) {
        return encryptionConfigBuilder_.getMessageOrBuilder();
      } else {
        return encryptionConfig_ == null
            ? com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig,
            com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig.Builder,
            com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfigOrBuilder>
        getEncryptionConfigFieldBuilder() {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig,
                com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig.Builder,
                com.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfigOrBuilder>(
                getEncryptionConfig(), getParentForChildren(), isClean());
        encryptionConfig_ = null;
      }
      return encryptionConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.AlloyDbSettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.AlloyDbSettings)
  private static final com.google.cloud.clouddms.v1.AlloyDbSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.AlloyDbSettings();
  }

  public static com.google.cloud.clouddms.v1.AlloyDbSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AlloyDbSettings> PARSER =
      new com.google.protobuf.AbstractParser<AlloyDbSettings>() {
        @java.lang.Override
        public AlloyDbSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AlloyDbSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AlloyDbSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.AlloyDbSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
