/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Request message for 'ApplyConversionWorkspace' request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest}
 */
public final class ApplyConversionWorkspaceRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest)
    ApplyConversionWorkspaceRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ApplyConversionWorkspaceRequest.newBuilder() to construct.
  private ApplyConversionWorkspaceRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ApplyConversionWorkspaceRequest() {
    name_ = "";
    filter_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ApplyConversionWorkspaceRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsProto
        .internal_static_google_cloud_clouddms_v1_ApplyConversionWorkspaceRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsProto
        .internal_static_google_cloud_clouddms_v1_ApplyConversionWorkspaceRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest.class,
            com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest.Builder.class);
  }

  private int destinationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CONNECTION_PROFILE(100),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 100:
          return CONNECTION_PROFILE;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the conversion workspace resource for which to apply
   * the draft tree. Must be in the form of:
   *  projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the conversion workspace resource for which to apply
   * the draft tree. Must be in the form of:
   *  projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * Filter which entities to apply. Leaving this field empty will apply all of
   * the entities. Supports Google AIP 160 based filtering.
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Filter which entities to apply. Leaving this field empty will apply all of
   * the entities. Supports Google AIP 160 based filtering.
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DRY_RUN_FIELD_NUMBER = 3;
  private boolean dryRun_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Only validates the apply process, but doesn't change the
   * destination database. Only works for PostgreSQL destination connection
   * profile.
   * </pre>
   *
   * <code>bool dry_run = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The dryRun.
   */
  @java.lang.Override
  public boolean getDryRun() {
    return dryRun_;
  }

  public static final int AUTO_COMMIT_FIELD_NUMBER = 4;
  private boolean autoCommit_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Specifies whether the conversion workspace is to be committed
   * automatically after the apply.
   * </pre>
   *
   * <code>bool auto_commit = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The autoCommit.
   */
  @java.lang.Override
  public boolean getAutoCommit() {
    return autoCommit_;
  }

  public static final int CONNECTION_PROFILE_FIELD_NUMBER = 100;
  /**
   *
   *
   * <pre>
   * Optional. Fully qualified (Uri) name of the destination connection
   * profile.
   * </pre>
   *
   * <code>string connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the connectionProfile field is set.
   */
  public boolean hasConnectionProfile() {
    return destinationCase_ == 100;
  }
  /**
   *
   *
   * <pre>
   * Optional. Fully qualified (Uri) name of the destination connection
   * profile.
   * </pre>
   *
   * <code>string connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The connectionProfile.
   */
  public java.lang.String getConnectionProfile() {
    java.lang.Object ref = "";
    if (destinationCase_ == 100) {
      ref = destination_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (destinationCase_ == 100) {
        destination_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Fully qualified (Uri) name of the destination connection
   * profile.
   * </pre>
   *
   * <code>string connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for connectionProfile.
   */
  public com.google.protobuf.ByteString getConnectionProfileBytes() {
    java.lang.Object ref = "";
    if (destinationCase_ == 100) {
      ref = destination_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (destinationCase_ == 100) {
        destination_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
    }
    if (dryRun_ != false) {
      output.writeBool(3, dryRun_);
    }
    if (autoCommit_ != false) {
      output.writeBool(4, autoCommit_);
    }
    if (destinationCase_ == 100) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 100, destination_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
    }
    if (dryRun_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, dryRun_);
    }
    if (autoCommit_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, autoCommit_);
    }
    if (destinationCase_ == 100) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(100, destination_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest other =
        (com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (getDryRun() != other.getDryRun()) return false;
    if (getAutoCommit() != other.getAutoCommit()) return false;
    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 100:
        if (!getConnectionProfile().equals(other.getConnectionProfile())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + DRY_RUN_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDryRun());
    hash = (37 * hash) + AUTO_COMMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutoCommit());
    switch (destinationCase_) {
      case 100:
        hash = (37 * hash) + CONNECTION_PROFILE_FIELD_NUMBER;
        hash = (53 * hash) + getConnectionProfile().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for 'ApplyConversionWorkspace' request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest)
      com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_ApplyConversionWorkspaceRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_ApplyConversionWorkspaceRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest.class,
              com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      filter_ = "";
      dryRun_ = false;
      autoCommit_ = false;
      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_ApplyConversionWorkspaceRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest
        getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest build() {
      com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest buildPartial() {
      com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest result =
          new com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.dryRun_ = dryRun_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.autoCommit_ = autoCommit_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest result) {
      result.destinationCase_ = destinationCase_;
      result.destination_ = this.destination_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest) {
        return mergeFrom((com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest other) {
      if (other
          == com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getDryRun() != false) {
        setDryRun(other.getDryRun());
      }
      if (other.getAutoCommit() != false) {
        setAutoCommit(other.getAutoCommit());
      }
      switch (other.getDestinationCase()) {
        case CONNECTION_PROFILE:
          {
            destinationCase_ = 100;
            destination_ = other.destination_;
            onChanged();
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                dryRun_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                autoCommit_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 802:
              {
                java.lang.String s = input.readStringRequireUtf8();
                destinationCase_ = 100;
                destination_ = s;
                break;
              } // case 802
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the conversion workspace resource for which to apply
     * the draft tree. Must be in the form of:
     *  projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the conversion workspace resource for which to apply
     * the draft tree. Must be in the form of:
     *  projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the conversion workspace resource for which to apply
     * the draft tree. Must be in the form of:
     *  projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the conversion workspace resource for which to apply
     * the draft tree. Must be in the form of:
     *  projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the conversion workspace resource for which to apply
     * the draft tree. Must be in the form of:
     *  projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Filter which entities to apply. Leaving this field empty will apply all of
     * the entities. Supports Google AIP 160 based filtering.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Filter which entities to apply. Leaving this field empty will apply all of
     * the entities. Supports Google AIP 160 based filtering.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Filter which entities to apply. Leaving this field empty will apply all of
     * the entities. Supports Google AIP 160 based filtering.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter which entities to apply. Leaving this field empty will apply all of
     * the entities. Supports Google AIP 160 based filtering.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter which entities to apply. Leaving this field empty will apply all of
     * the entities. Supports Google AIP 160 based filtering.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private boolean dryRun_;
    /**
     *
     *
     * <pre>
     * Optional. Only validates the apply process, but doesn't change the
     * destination database. Only works for PostgreSQL destination connection
     * profile.
     * </pre>
     *
     * <code>bool dry_run = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The dryRun.
     */
    @java.lang.Override
    public boolean getDryRun() {
      return dryRun_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Only validates the apply process, but doesn't change the
     * destination database. Only works for PostgreSQL destination connection
     * profile.
     * </pre>
     *
     * <code>bool dry_run = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The dryRun to set.
     * @return This builder for chaining.
     */
    public Builder setDryRun(boolean value) {

      dryRun_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Only validates the apply process, but doesn't change the
     * destination database. Only works for PostgreSQL destination connection
     * profile.
     * </pre>
     *
     * <code>bool dry_run = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDryRun() {
      bitField0_ = (bitField0_ & ~0x00000004);
      dryRun_ = false;
      onChanged();
      return this;
    }

    private boolean autoCommit_;
    /**
     *
     *
     * <pre>
     * Optional. Specifies whether the conversion workspace is to be committed
     * automatically after the apply.
     * </pre>
     *
     * <code>bool auto_commit = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The autoCommit.
     */
    @java.lang.Override
    public boolean getAutoCommit() {
      return autoCommit_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies whether the conversion workspace is to be committed
     * automatically after the apply.
     * </pre>
     *
     * <code>bool auto_commit = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The autoCommit to set.
     * @return This builder for chaining.
     */
    public Builder setAutoCommit(boolean value) {

      autoCommit_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies whether the conversion workspace is to be committed
     * automatically after the apply.
     * </pre>
     *
     * <code>bool auto_commit = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoCommit() {
      bitField0_ = (bitField0_ & ~0x00000008);
      autoCommit_ = false;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the destination connection
     * profile.
     * </pre>
     *
     * <code>string connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the connectionProfile field is set.
     */
    @java.lang.Override
    public boolean hasConnectionProfile() {
      return destinationCase_ == 100;
    }
    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the destination connection
     * profile.
     * </pre>
     *
     * <code>string connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The connectionProfile.
     */
    @java.lang.Override
    public java.lang.String getConnectionProfile() {
      java.lang.Object ref = "";
      if (destinationCase_ == 100) {
        ref = destination_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (destinationCase_ == 100) {
          destination_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the destination connection
     * profile.
     * </pre>
     *
     * <code>string connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for connectionProfile.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getConnectionProfileBytes() {
      java.lang.Object ref = "";
      if (destinationCase_ == 100) {
        ref = destination_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (destinationCase_ == 100) {
          destination_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the destination connection
     * profile.
     * </pre>
     *
     * <code>string connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The connectionProfile to set.
     * @return This builder for chaining.
     */
    public Builder setConnectionProfile(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationCase_ = 100;
      destination_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the destination connection
     * profile.
     * </pre>
     *
     * <code>string connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConnectionProfile() {
      if (destinationCase_ == 100) {
        destinationCase_ = 0;
        destination_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the destination connection
     * profile.
     * </pre>
     *
     * <code>string connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for connectionProfile to set.
     * @return This builder for chaining.
     */
    public Builder setConnectionProfileBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationCase_ = 100;
      destination_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest)
  private static final com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest();
  }

  public static com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ApplyConversionWorkspaceRequest> PARSER =
      new com.google.protobuf.AbstractParser<ApplyConversionWorkspaceRequest>() {
        @java.lang.Override
        public ApplyConversionWorkspaceRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ApplyConversionWorkspaceRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ApplyConversionWorkspaceRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
