/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Execution log of a background job.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.BackgroundJobLogEntry}
 */
public final class BackgroundJobLogEntry extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.BackgroundJobLogEntry)
    BackgroundJobLogEntryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BackgroundJobLogEntry.newBuilder() to construct.
  private BackgroundJobLogEntry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BackgroundJobLogEntry() {
    id_ = "";
    jobType_ = 0;
    completionState_ = 0;
    completionComment_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BackgroundJobLogEntry();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.class,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Final state after a job completes.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState}
   */
  public enum JobCompletionState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The status is not specified. This state is used when job is not yet
     * finished.
     * </pre>
     *
     * <code>JOB_COMPLETION_STATE_UNSPECIFIED = 0;</code>
     */
    JOB_COMPLETION_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Success.
     * </pre>
     *
     * <code>SUCCEEDED = 1;</code>
     */
    SUCCEEDED(1),
    /**
     *
     *
     * <pre>
     * Error.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    FAILED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The status is not specified. This state is used when job is not yet
     * finished.
     * </pre>
     *
     * <code>JOB_COMPLETION_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int JOB_COMPLETION_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Success.
     * </pre>
     *
     * <code>SUCCEEDED = 1;</code>
     */
    public static final int SUCCEEDED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Error.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    public static final int FAILED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static JobCompletionState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static JobCompletionState forNumber(int value) {
      switch (value) {
        case 0:
          return JOB_COMPLETION_STATE_UNSPECIFIED;
        case 1:
          return SUCCEEDED;
        case 2:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<JobCompletionState>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<JobCompletionState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<JobCompletionState>() {
              public JobCompletionState findValueByNumber(int number) {
                return JobCompletionState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final JobCompletionState[] VALUES = values();

    public static JobCompletionState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private JobCompletionState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState)
  }

  public interface SeedJobDetailsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The connection profile which was used for the seed job.
     * </pre>
     *
     * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The connectionProfile.
     */
    java.lang.String getConnectionProfile();
    /**
     *
     *
     * <pre>
     * Output only. The connection profile which was used for the seed job.
     * </pre>
     *
     * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for connectionProfile.
     */
    com.google.protobuf.ByteString getConnectionProfileBytes();
  }
  /**
   *
   *
   * <pre>
   * Details regarding a Seed background job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails}
   */
  public static final class SeedJobDetails extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails)
      SeedJobDetailsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SeedJobDetails.newBuilder() to construct.
    private SeedJobDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SeedJobDetails() {
      connectionProfile_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SeedJobDetails();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_SeedJobDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_SeedJobDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails.class,
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails.Builder.class);
    }

    public static final int CONNECTION_PROFILE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object connectionProfile_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The connection profile which was used for the seed job.
     * </pre>
     *
     * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The connectionProfile.
     */
    @java.lang.Override
    public java.lang.String getConnectionProfile() {
      java.lang.Object ref = connectionProfile_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        connectionProfile_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The connection profile which was used for the seed job.
     * </pre>
     *
     * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for connectionProfile.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getConnectionProfileBytes() {
      java.lang.Object ref = connectionProfile_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        connectionProfile_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(connectionProfile_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, connectionProfile_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(connectionProfile_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, connectionProfile_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails)) {
        return super.equals(obj);
      }
      com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails other =
          (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails) obj;

      if (!getConnectionProfile().equals(other.getConnectionProfile())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONNECTION_PROFILE_FIELD_NUMBER;
      hash = (53 * hash) + getConnectionProfile().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details regarding a Seed background job.
     * </pre>
     *
     * Protobuf type {@code google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails)
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetailsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
            .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_SeedJobDetails_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
            .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_SeedJobDetails_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails.class,
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails.Builder.class);
      }

      // Construct using
      // com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        connectionProfile_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
            .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_SeedJobDetails_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
          getDefaultInstanceForType() {
        return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails build() {
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails buildPartial() {
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails result =
            new com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.connectionProfile_ = connectionProfile_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails) {
          return mergeFrom(
              (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails other) {
        if (other
            == com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
                .getDefaultInstance()) return this;
        if (!other.getConnectionProfile().isEmpty()) {
          connectionProfile_ = other.connectionProfile_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  connectionProfile_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object connectionProfile_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The connection profile which was used for the seed job.
       * </pre>
       *
       * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The connectionProfile.
       */
      public java.lang.String getConnectionProfile() {
        java.lang.Object ref = connectionProfile_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          connectionProfile_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The connection profile which was used for the seed job.
       * </pre>
       *
       * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for connectionProfile.
       */
      public com.google.protobuf.ByteString getConnectionProfileBytes() {
        java.lang.Object ref = connectionProfile_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          connectionProfile_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The connection profile which was used for the seed job.
       * </pre>
       *
       * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The connectionProfile to set.
       * @return This builder for chaining.
       */
      public Builder setConnectionProfile(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectionProfile_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The connection profile which was used for the seed job.
       * </pre>
       *
       * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConnectionProfile() {
        connectionProfile_ = getDefaultInstance().getConnectionProfile();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The connection profile which was used for the seed job.
       * </pre>
       *
       * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for connectionProfile to set.
       * @return This builder for chaining.
       */
      public Builder setConnectionProfileBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        connectionProfile_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails)
    private static final com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails();
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SeedJobDetails> PARSER =
        new com.google.protobuf.AbstractParser<SeedJobDetails>() {
          @java.lang.Override
          public SeedJobDetails parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SeedJobDetails> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SeedJobDetails> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ImportRulesJobDetailsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. File names used for the import rules job.
     * </pre>
     *
     * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return A list containing the files.
     */
    java.util.List<java.lang.String> getFilesList();
    /**
     *
     *
     * <pre>
     * Output only. File names used for the import rules job.
     * </pre>
     *
     * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count of files.
     */
    int getFilesCount();
    /**
     *
     *
     * <pre>
     * Output only. File names used for the import rules job.
     * </pre>
     *
     * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the element to return.
     * @return The files at the given index.
     */
    java.lang.String getFiles(int index);
    /**
     *
     *
     * <pre>
     * Output only. File names used for the import rules job.
     * </pre>
     *
     * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the files at the given index.
     */
    com.google.protobuf.ByteString getFilesBytes(int index);

    /**
     *
     *
     * <pre>
     * Output only. The requested file format.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ImportRulesFileFormat file_format = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for fileFormat.
     */
    int getFileFormatValue();
    /**
     *
     *
     * <pre>
     * Output only. The requested file format.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ImportRulesFileFormat file_format = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The fileFormat.
     */
    com.google.cloud.clouddms.v1.ImportRulesFileFormat getFileFormat();
  }
  /**
   *
   *
   * <pre>
   * Details regarding an Import Rules background job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails}
   */
  public static final class ImportRulesJobDetails extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails)
      ImportRulesJobDetailsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ImportRulesJobDetails.newBuilder() to construct.
    private ImportRulesJobDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ImportRulesJobDetails() {
      files_ = com.google.protobuf.LazyStringArrayList.emptyList();
      fileFormat_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ImportRulesJobDetails();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_ImportRulesJobDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_ImportRulesJobDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails.class,
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails.Builder
                  .class);
    }

    public static final int FILES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList files_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Output only. File names used for the import rules job.
     * </pre>
     *
     * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return A list containing the files.
     */
    public com.google.protobuf.ProtocolStringList getFilesList() {
      return files_;
    }
    /**
     *
     *
     * <pre>
     * Output only. File names used for the import rules job.
     * </pre>
     *
     * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count of files.
     */
    public int getFilesCount() {
      return files_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. File names used for the import rules job.
     * </pre>
     *
     * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the element to return.
     * @return The files at the given index.
     */
    public java.lang.String getFiles(int index) {
      return files_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. File names used for the import rules job.
     * </pre>
     *
     * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the files at the given index.
     */
    public com.google.protobuf.ByteString getFilesBytes(int index) {
      return files_.getByteString(index);
    }

    public static final int FILE_FORMAT_FIELD_NUMBER = 2;
    private int fileFormat_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The requested file format.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ImportRulesFileFormat file_format = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for fileFormat.
     */
    @java.lang.Override
    public int getFileFormatValue() {
      return fileFormat_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The requested file format.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ImportRulesFileFormat file_format = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The fileFormat.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ImportRulesFileFormat getFileFormat() {
      com.google.cloud.clouddms.v1.ImportRulesFileFormat result =
          com.google.cloud.clouddms.v1.ImportRulesFileFormat.forNumber(fileFormat_);
      return result == null
          ? com.google.cloud.clouddms.v1.ImportRulesFileFormat.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < files_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, files_.getRaw(i));
      }
      if (fileFormat_
          != com.google.cloud.clouddms.v1.ImportRulesFileFormat.IMPORT_RULES_FILE_FORMAT_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, fileFormat_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < files_.size(); i++) {
          dataSize += computeStringSizeNoTag(files_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getFilesList().size();
      }
      if (fileFormat_
          != com.google.cloud.clouddms.v1.ImportRulesFileFormat.IMPORT_RULES_FILE_FORMAT_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, fileFormat_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails)) {
        return super.equals(obj);
      }
      com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails other =
          (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails) obj;

      if (!getFilesList().equals(other.getFilesList())) return false;
      if (fileFormat_ != other.fileFormat_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getFilesCount() > 0) {
        hash = (37 * hash) + FILES_FIELD_NUMBER;
        hash = (53 * hash) + getFilesList().hashCode();
      }
      hash = (37 * hash) + FILE_FORMAT_FIELD_NUMBER;
      hash = (53 * hash) + fileFormat_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details regarding an Import Rules background job.
     * </pre>
     *
     * Protobuf type {@code google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails)
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetailsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
            .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_ImportRulesJobDetails_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
            .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_ImportRulesJobDetails_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails.class,
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        files_ = com.google.protobuf.LazyStringArrayList.emptyList();
        fileFormat_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
            .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_ImportRulesJobDetails_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
          getDefaultInstanceForType() {
        return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails build() {
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
          buildPartial() {
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails result =
            new com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          files_.makeImmutable();
          result.files_ = files_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.fileFormat_ = fileFormat_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails) {
          return mergeFrom(
              (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails other) {
        if (other
            == com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
                .getDefaultInstance()) return this;
        if (!other.files_.isEmpty()) {
          if (files_.isEmpty()) {
            files_ = other.files_;
            bitField0_ |= 0x00000001;
          } else {
            ensureFilesIsMutable();
            files_.addAll(other.files_);
          }
          onChanged();
        }
        if (other.fileFormat_ != 0) {
          setFileFormatValue(other.getFileFormatValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureFilesIsMutable();
                  files_.add(s);
                  break;
                } // case 10
              case 16:
                {
                  fileFormat_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList files_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureFilesIsMutable() {
        if (!files_.isModifiable()) {
          files_ = new com.google.protobuf.LazyStringArrayList(files_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Output only. File names used for the import rules job.
       * </pre>
       *
       * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return A list containing the files.
       */
      public com.google.protobuf.ProtocolStringList getFilesList() {
        files_.makeImmutable();
        return files_;
      }
      /**
       *
       *
       * <pre>
       * Output only. File names used for the import rules job.
       * </pre>
       *
       * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The count of files.
       */
      public int getFilesCount() {
        return files_.size();
      }
      /**
       *
       *
       * <pre>
       * Output only. File names used for the import rules job.
       * </pre>
       *
       * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param index The index of the element to return.
       * @return The files at the given index.
       */
      public java.lang.String getFiles(int index) {
        return files_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. File names used for the import rules job.
       * </pre>
       *
       * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the files at the given index.
       */
      public com.google.protobuf.ByteString getFilesBytes(int index) {
        return files_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. File names used for the import rules job.
       * </pre>
       *
       * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param index The index to set the value at.
       * @param value The files to set.
       * @return This builder for chaining.
       */
      public Builder setFiles(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilesIsMutable();
        files_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. File names used for the import rules job.
       * </pre>
       *
       * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The files to add.
       * @return This builder for chaining.
       */
      public Builder addFiles(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilesIsMutable();
        files_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. File names used for the import rules job.
       * </pre>
       *
       * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param values The files to add.
       * @return This builder for chaining.
       */
      public Builder addAllFiles(java.lang.Iterable<java.lang.String> values) {
        ensureFilesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, files_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. File names used for the import rules job.
       * </pre>
       *
       * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFiles() {
        files_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. File names used for the import rules job.
       * </pre>
       *
       * <code>repeated string files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes of the files to add.
       * @return This builder for chaining.
       */
      public Builder addFilesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureFilesIsMutable();
        files_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int fileFormat_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. The requested file format.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.ImportRulesFileFormat file_format = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for fileFormat.
       */
      @java.lang.Override
      public int getFileFormatValue() {
        return fileFormat_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The requested file format.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.ImportRulesFileFormat file_format = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for fileFormat to set.
       * @return This builder for chaining.
       */
      public Builder setFileFormatValue(int value) {
        fileFormat_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The requested file format.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.ImportRulesFileFormat file_format = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The fileFormat.
       */
      @java.lang.Override
      public com.google.cloud.clouddms.v1.ImportRulesFileFormat getFileFormat() {
        com.google.cloud.clouddms.v1.ImportRulesFileFormat result =
            com.google.cloud.clouddms.v1.ImportRulesFileFormat.forNumber(fileFormat_);
        return result == null
            ? com.google.cloud.clouddms.v1.ImportRulesFileFormat.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. The requested file format.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.ImportRulesFileFormat file_format = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The fileFormat to set.
       * @return This builder for chaining.
       */
      public Builder setFileFormat(com.google.cloud.clouddms.v1.ImportRulesFileFormat value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        fileFormat_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The requested file format.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.ImportRulesFileFormat file_format = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFileFormat() {
        bitField0_ = (bitField0_ & ~0x00000002);
        fileFormat_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails)
    private static final com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails();
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ImportRulesJobDetails> PARSER =
        new com.google.protobuf.AbstractParser<ImportRulesJobDetails>() {
          @java.lang.Override
          public ImportRulesJobDetails parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ImportRulesJobDetails> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ImportRulesJobDetails> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConvertJobDetailsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. AIP-160 based filter used to specify the entities to convert
     * </pre>
     *
     * <code>string filter = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The filter.
     */
    java.lang.String getFilter();
    /**
     *
     *
     * <pre>
     * Output only. AIP-160 based filter used to specify the entities to convert
     * </pre>
     *
     * <code>string filter = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for filter.
     */
    com.google.protobuf.ByteString getFilterBytes();
  }
  /**
   *
   *
   * <pre>
   * Details regarding a Convert background job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails}
   */
  public static final class ConvertJobDetails extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails)
      ConvertJobDetailsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConvertJobDetails.newBuilder() to construct.
    private ConvertJobDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConvertJobDetails() {
      filter_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConvertJobDetails();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_ConvertJobDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_ConvertJobDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails.class,
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails.Builder.class);
    }

    public static final int FILTER_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Output only. AIP-160 based filter used to specify the entities to convert
     * </pre>
     *
     * <code>string filter = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The filter.
     */
    @java.lang.Override
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. AIP-160 based filter used to specify the entities to convert
     * </pre>
     *
     * <code>string filter = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for filter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, filter_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, filter_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails)) {
        return super.equals(obj);
      }
      com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails other =
          (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails) obj;

      if (!getFilter().equals(other.getFilter())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details regarding a Convert background job.
     * </pre>
     *
     * Protobuf type {@code google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails)
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetailsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
            .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_ConvertJobDetails_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
            .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_ConvertJobDetails_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails.class,
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails.Builder.class);
      }

      // Construct using
      // com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        filter_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
            .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_ConvertJobDetails_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
          getDefaultInstanceForType() {
        return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails build() {
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails buildPartial() {
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails result =
            new com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.filter_ = filter_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails) {
          return mergeFrom(
              (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails other) {
        if (other
            == com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
                .getDefaultInstance()) return this;
        if (!other.getFilter().isEmpty()) {
          filter_ = other.filter_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  filter_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * Output only. AIP-160 based filter used to specify the entities to convert
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The filter.
       */
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. AIP-160 based filter used to specify the entities to convert
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for filter.
       */
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. AIP-160 based filter used to specify the entities to convert
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. AIP-160 based filter used to specify the entities to convert
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFilter() {
        filter_ = getDefaultInstance().getFilter();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. AIP-160 based filter used to specify the entities to convert
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        filter_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails)
    private static final com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails();
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConvertJobDetails> PARSER =
        new com.google.protobuf.AbstractParser<ConvertJobDetails>() {
          @java.lang.Override
          public ConvertJobDetails parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConvertJobDetails> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConvertJobDetails> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ApplyJobDetailsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The connection profile which was used for the apply job.
     * </pre>
     *
     * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The connectionProfile.
     */
    java.lang.String getConnectionProfile();
    /**
     *
     *
     * <pre>
     * Output only. The connection profile which was used for the apply job.
     * </pre>
     *
     * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for connectionProfile.
     */
    com.google.protobuf.ByteString getConnectionProfileBytes();

    /**
     *
     *
     * <pre>
     * Output only. AIP-160 based filter used to specify the entities to apply
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The filter.
     */
    java.lang.String getFilter();
    /**
     *
     *
     * <pre>
     * Output only. AIP-160 based filter used to specify the entities to apply
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for filter.
     */
    com.google.protobuf.ByteString getFilterBytes();
  }
  /**
   *
   *
   * <pre>
   * Details regarding an Apply background job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails}
   */
  public static final class ApplyJobDetails extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails)
      ApplyJobDetailsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ApplyJobDetails.newBuilder() to construct.
    private ApplyJobDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ApplyJobDetails() {
      connectionProfile_ = "";
      filter_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ApplyJobDetails();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_ApplyJobDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_ApplyJobDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails.class,
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails.Builder.class);
    }

    public static final int CONNECTION_PROFILE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object connectionProfile_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The connection profile which was used for the apply job.
     * </pre>
     *
     * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The connectionProfile.
     */
    @java.lang.Override
    public java.lang.String getConnectionProfile() {
      java.lang.Object ref = connectionProfile_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        connectionProfile_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The connection profile which was used for the apply job.
     * </pre>
     *
     * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for connectionProfile.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getConnectionProfileBytes() {
      java.lang.Object ref = connectionProfile_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        connectionProfile_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FILTER_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Output only. AIP-160 based filter used to specify the entities to apply
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The filter.
     */
    @java.lang.Override
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. AIP-160 based filter used to specify the entities to apply
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for filter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(connectionProfile_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, connectionProfile_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(connectionProfile_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, connectionProfile_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails)) {
        return super.equals(obj);
      }
      com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails other =
          (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails) obj;

      if (!getConnectionProfile().equals(other.getConnectionProfile())) return false;
      if (!getFilter().equals(other.getFilter())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONNECTION_PROFILE_FIELD_NUMBER;
      hash = (53 * hash) + getConnectionProfile().hashCode();
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details regarding an Apply background job.
     * </pre>
     *
     * Protobuf type {@code google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails)
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetailsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
            .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_ApplyJobDetails_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
            .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_ApplyJobDetails_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails.class,
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails.Builder.class);
      }

      // Construct using
      // com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        connectionProfile_ = "";
        filter_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
            .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_ApplyJobDetails_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
          getDefaultInstanceForType() {
        return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails build() {
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails buildPartial() {
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails result =
            new com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.connectionProfile_ = connectionProfile_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.filter_ = filter_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails) {
          return mergeFrom(
              (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails other) {
        if (other
            == com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
                .getDefaultInstance()) return this;
        if (!other.getConnectionProfile().isEmpty()) {
          connectionProfile_ = other.connectionProfile_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getFilter().isEmpty()) {
          filter_ = other.filter_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  connectionProfile_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  filter_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object connectionProfile_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The connection profile which was used for the apply job.
       * </pre>
       *
       * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The connectionProfile.
       */
      public java.lang.String getConnectionProfile() {
        java.lang.Object ref = connectionProfile_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          connectionProfile_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The connection profile which was used for the apply job.
       * </pre>
       *
       * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for connectionProfile.
       */
      public com.google.protobuf.ByteString getConnectionProfileBytes() {
        java.lang.Object ref = connectionProfile_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          connectionProfile_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The connection profile which was used for the apply job.
       * </pre>
       *
       * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The connectionProfile to set.
       * @return This builder for chaining.
       */
      public Builder setConnectionProfile(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectionProfile_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The connection profile which was used for the apply job.
       * </pre>
       *
       * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConnectionProfile() {
        connectionProfile_ = getDefaultInstance().getConnectionProfile();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The connection profile which was used for the apply job.
       * </pre>
       *
       * <code>string connection_profile = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for connectionProfile to set.
       * @return This builder for chaining.
       */
      public Builder setConnectionProfileBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        connectionProfile_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * Output only. AIP-160 based filter used to specify the entities to apply
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The filter.
       */
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. AIP-160 based filter used to specify the entities to apply
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for filter.
       */
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. AIP-160 based filter used to specify the entities to apply
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. AIP-160 based filter used to specify the entities to apply
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFilter() {
        filter_ = getDefaultInstance().getFilter();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. AIP-160 based filter used to specify the entities to apply
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        filter_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails)
    private static final com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails();
    }

    public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ApplyJobDetails> PARSER =
        new com.google.protobuf.AbstractParser<ApplyJobDetails>() {
          @java.lang.Override
          public ApplyJobDetails parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ApplyJobDetails> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ApplyJobDetails> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int jobDetailsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object jobDetails_;

  public enum JobDetailsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SEED_JOB_DETAILS(100),
    IMPORT_RULES_JOB_DETAILS(101),
    CONVERT_JOB_DETAILS(102),
    APPLY_JOB_DETAILS(103),
    JOBDETAILS_NOT_SET(0);
    private final int value;

    private JobDetailsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static JobDetailsCase valueOf(int value) {
      return forNumber(value);
    }

    public static JobDetailsCase forNumber(int value) {
      switch (value) {
        case 100:
          return SEED_JOB_DETAILS;
        case 101:
          return IMPORT_RULES_JOB_DETAILS;
        case 102:
          return CONVERT_JOB_DETAILS;
        case 103:
          return APPLY_JOB_DETAILS;
        case 0:
          return JOBDETAILS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public JobDetailsCase getJobDetailsCase() {
    return JobDetailsCase.forNumber(jobDetailsCase_);
  }

  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * The background job log entry ID.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The background job log entry ID.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int JOB_TYPE_FIELD_NUMBER = 2;
  private int jobType_ = 0;
  /**
   *
   *
   * <pre>
   * The type of job that was executed.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.BackgroundJobType job_type = 2;</code>
   *
   * @return The enum numeric value on the wire for jobType.
   */
  @java.lang.Override
  public int getJobTypeValue() {
    return jobType_;
  }
  /**
   *
   *
   * <pre>
   * The type of job that was executed.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.BackgroundJobType job_type = 2;</code>
   *
   * @return The jobType.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.BackgroundJobType getJobType() {
    com.google.cloud.clouddms.v1.BackgroundJobType result =
        com.google.cloud.clouddms.v1.BackgroundJobType.forNumber(jobType_);
    return result == null ? com.google.cloud.clouddms.v1.BackgroundJobType.UNRECOGNIZED : result;
  }

  public static final int START_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * The timestamp when the background job was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 3;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The timestamp when the background job was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 3;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * The timestamp when the background job was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int FINISH_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp finishTime_;
  /**
   *
   *
   * <pre>
   * The timestamp when the background job was finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp finish_time = 4;</code>
   *
   * @return Whether the finishTime field is set.
   */
  @java.lang.Override
  public boolean hasFinishTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The timestamp when the background job was finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp finish_time = 4;</code>
   *
   * @return The finishTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getFinishTime() {
    return finishTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : finishTime_;
  }
  /**
   *
   *
   * <pre>
   * The timestamp when the background job was finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp finish_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getFinishTimeOrBuilder() {
    return finishTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : finishTime_;
  }

  public static final int COMPLETION_STATE_FIELD_NUMBER = 5;
  private int completionState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Job completion state, i.e. the final state after the job
   * completed.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState completion_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for completionState.
   */
  @java.lang.Override
  public int getCompletionStateValue() {
    return completionState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Job completion state, i.e. the final state after the job
   * completed.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState completion_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The completionState.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState
      getCompletionState() {
    com.google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState result =
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState.forNumber(
            completionState_);
    return result == null
        ? com.google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState.UNRECOGNIZED
        : result;
  }

  public static final int COMPLETION_COMMENT_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object completionComment_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Job completion comment, such as how many entities were seeded,
   * how many warnings were found during conversion, and similar information.
   * </pre>
   *
   * <code>string completion_comment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The completionComment.
   */
  @java.lang.Override
  public java.lang.String getCompletionComment() {
    java.lang.Object ref = completionComment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      completionComment_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Job completion comment, such as how many entities were seeded,
   * how many warnings were found during conversion, and similar information.
   * </pre>
   *
   * <code>string completion_comment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for completionComment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCompletionCommentBytes() {
    java.lang.Object ref = completionComment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      completionComment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_AUTOCOMMIT_FIELD_NUMBER = 7;
  private boolean requestAutocommit_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Whether the client requested the conversion workspace to be
   * committed after a successful completion of the job.
   * </pre>
   *
   * <code>bool request_autocommit = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The requestAutocommit.
   */
  @java.lang.Override
  public boolean getRequestAutocommit() {
    return requestAutocommit_;
  }

  public static final int SEED_JOB_DETAILS_FIELD_NUMBER = 100;
  /**
   *
   *
   * <pre>
   * Output only. Seed job details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails seed_job_details = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the seedJobDetails field is set.
   */
  @java.lang.Override
  public boolean hasSeedJobDetails() {
    return jobDetailsCase_ == 100;
  }
  /**
   *
   *
   * <pre>
   * Output only. Seed job details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails seed_job_details = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The seedJobDetails.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails getSeedJobDetails() {
    if (jobDetailsCase_ == 100) {
      return (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails) jobDetails_;
    }
    return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Seed job details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails seed_job_details = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetailsOrBuilder
      getSeedJobDetailsOrBuilder() {
    if (jobDetailsCase_ == 100) {
      return (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails) jobDetails_;
    }
    return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails.getDefaultInstance();
  }

  public static final int IMPORT_RULES_JOB_DETAILS_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * Output only. Import rules job details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails import_rules_job_details = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the importRulesJobDetails field is set.
   */
  @java.lang.Override
  public boolean hasImportRulesJobDetails() {
    return jobDetailsCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * Output only. Import rules job details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails import_rules_job_details = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The importRulesJobDetails.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
      getImportRulesJobDetails() {
    if (jobDetailsCase_ == 101) {
      return (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails) jobDetails_;
    }
    return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Import rules job details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails import_rules_job_details = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetailsOrBuilder
      getImportRulesJobDetailsOrBuilder() {
    if (jobDetailsCase_ == 101) {
      return (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails) jobDetails_;
    }
    return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        .getDefaultInstance();
  }

  public static final int CONVERT_JOB_DETAILS_FIELD_NUMBER = 102;
  /**
   *
   *
   * <pre>
   * Output only. Convert job details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails convert_job_details = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the convertJobDetails field is set.
   */
  @java.lang.Override
  public boolean hasConvertJobDetails() {
    return jobDetailsCase_ == 102;
  }
  /**
   *
   *
   * <pre>
   * Output only. Convert job details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails convert_job_details = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The convertJobDetails.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
      getConvertJobDetails() {
    if (jobDetailsCase_ == 102) {
      return (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails) jobDetails_;
    }
    return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Convert job details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails convert_job_details = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetailsOrBuilder
      getConvertJobDetailsOrBuilder() {
    if (jobDetailsCase_ == 102) {
      return (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails) jobDetails_;
    }
    return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
        .getDefaultInstance();
  }

  public static final int APPLY_JOB_DETAILS_FIELD_NUMBER = 103;
  /**
   *
   *
   * <pre>
   * Output only. Apply job details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails apply_job_details = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the applyJobDetails field is set.
   */
  @java.lang.Override
  public boolean hasApplyJobDetails() {
    return jobDetailsCase_ == 103;
  }
  /**
   *
   *
   * <pre>
   * Output only. Apply job details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails apply_job_details = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The applyJobDetails.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails getApplyJobDetails() {
    if (jobDetailsCase_ == 103) {
      return (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails) jobDetails_;
    }
    return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Apply job details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails apply_job_details = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetailsOrBuilder
      getApplyJobDetailsOrBuilder() {
    if (jobDetailsCase_ == 103) {
      return (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails) jobDetails_;
    }
    return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (jobType_
        != com.google.cloud.clouddms.v1.BackgroundJobType.BACKGROUND_JOB_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, jobType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getFinishTime());
    }
    if (completionState_
        != com.google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState
            .JOB_COMPLETION_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, completionState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(completionComment_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, completionComment_);
    }
    if (requestAutocommit_ != false) {
      output.writeBool(7, requestAutocommit_);
    }
    if (jobDetailsCase_ == 100) {
      output.writeMessage(
          100, (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails) jobDetails_);
    }
    if (jobDetailsCase_ == 101) {
      output.writeMessage(
          101,
          (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails) jobDetails_);
    }
    if (jobDetailsCase_ == 102) {
      output.writeMessage(
          102, (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails) jobDetails_);
    }
    if (jobDetailsCase_ == 103) {
      output.writeMessage(
          103, (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails) jobDetails_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (jobType_
        != com.google.cloud.clouddms.v1.BackgroundJobType.BACKGROUND_JOB_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, jobType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getFinishTime());
    }
    if (completionState_
        != com.google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState
            .JOB_COMPLETION_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, completionState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(completionComment_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, completionComment_);
    }
    if (requestAutocommit_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, requestAutocommit_);
    }
    if (jobDetailsCase_ == 100) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              100, (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails) jobDetails_);
    }
    if (jobDetailsCase_ == 101) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              101,
              (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails)
                  jobDetails_);
    }
    if (jobDetailsCase_ == 102) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              102,
              (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails) jobDetails_);
    }
    if (jobDetailsCase_ == 103) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              103,
              (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails) jobDetails_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.BackgroundJobLogEntry)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.BackgroundJobLogEntry other =
        (com.google.cloud.clouddms.v1.BackgroundJobLogEntry) obj;

    if (!getId().equals(other.getId())) return false;
    if (jobType_ != other.jobType_) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasFinishTime() != other.hasFinishTime()) return false;
    if (hasFinishTime()) {
      if (!getFinishTime().equals(other.getFinishTime())) return false;
    }
    if (completionState_ != other.completionState_) return false;
    if (!getCompletionComment().equals(other.getCompletionComment())) return false;
    if (getRequestAutocommit() != other.getRequestAutocommit()) return false;
    if (!getJobDetailsCase().equals(other.getJobDetailsCase())) return false;
    switch (jobDetailsCase_) {
      case 100:
        if (!getSeedJobDetails().equals(other.getSeedJobDetails())) return false;
        break;
      case 101:
        if (!getImportRulesJobDetails().equals(other.getImportRulesJobDetails())) return false;
        break;
      case 102:
        if (!getConvertJobDetails().equals(other.getConvertJobDetails())) return false;
        break;
      case 103:
        if (!getApplyJobDetails().equals(other.getApplyJobDetails())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + JOB_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + jobType_;
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasFinishTime()) {
      hash = (37 * hash) + FINISH_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getFinishTime().hashCode();
    }
    hash = (37 * hash) + COMPLETION_STATE_FIELD_NUMBER;
    hash = (53 * hash) + completionState_;
    hash = (37 * hash) + COMPLETION_COMMENT_FIELD_NUMBER;
    hash = (53 * hash) + getCompletionComment().hashCode();
    hash = (37 * hash) + REQUEST_AUTOCOMMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRequestAutocommit());
    switch (jobDetailsCase_) {
      case 100:
        hash = (37 * hash) + SEED_JOB_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getSeedJobDetails().hashCode();
        break;
      case 101:
        hash = (37 * hash) + IMPORT_RULES_JOB_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getImportRulesJobDetails().hashCode();
        break;
      case 102:
        hash = (37 * hash) + CONVERT_JOB_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getConvertJobDetails().hashCode();
        break;
      case 103:
        hash = (37 * hash) + APPLY_JOB_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getApplyJobDetails().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.BackgroundJobLogEntry prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Execution log of a background job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.BackgroundJobLogEntry}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.BackgroundJobLogEntry)
      com.google.cloud.clouddms.v1.BackgroundJobLogEntryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.class,
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.BackgroundJobLogEntry.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStartTimeFieldBuilder();
        getFinishTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      id_ = "";
      jobType_ = 0;
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      finishTime_ = null;
      if (finishTimeBuilder_ != null) {
        finishTimeBuilder_.dispose();
        finishTimeBuilder_ = null;
      }
      completionState_ = 0;
      completionComment_ = "";
      requestAutocommit_ = false;
      if (seedJobDetailsBuilder_ != null) {
        seedJobDetailsBuilder_.clear();
      }
      if (importRulesJobDetailsBuilder_ != null) {
        importRulesJobDetailsBuilder_.clear();
      }
      if (convertJobDetailsBuilder_ != null) {
        convertJobDetailsBuilder_.clear();
      }
      if (applyJobDetailsBuilder_ != null) {
        applyJobDetailsBuilder_.clear();
      }
      jobDetailsCase_ = 0;
      jobDetails_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_BackgroundJobLogEntry_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry build() {
      com.google.cloud.clouddms.v1.BackgroundJobLogEntry result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry buildPartial() {
      com.google.cloud.clouddms.v1.BackgroundJobLogEntry result =
          new com.google.cloud.clouddms.v1.BackgroundJobLogEntry(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.BackgroundJobLogEntry result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.jobType_ = jobType_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.finishTime_ = finishTimeBuilder_ == null ? finishTime_ : finishTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.completionState_ = completionState_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.completionComment_ = completionComment_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.requestAutocommit_ = requestAutocommit_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.clouddms.v1.BackgroundJobLogEntry result) {
      result.jobDetailsCase_ = jobDetailsCase_;
      result.jobDetails_ = this.jobDetails_;
      if (jobDetailsCase_ == 100 && seedJobDetailsBuilder_ != null) {
        result.jobDetails_ = seedJobDetailsBuilder_.build();
      }
      if (jobDetailsCase_ == 101 && importRulesJobDetailsBuilder_ != null) {
        result.jobDetails_ = importRulesJobDetailsBuilder_.build();
      }
      if (jobDetailsCase_ == 102 && convertJobDetailsBuilder_ != null) {
        result.jobDetails_ = convertJobDetailsBuilder_.build();
      }
      if (jobDetailsCase_ == 103 && applyJobDetailsBuilder_ != null) {
        result.jobDetails_ = applyJobDetailsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.BackgroundJobLogEntry) {
        return mergeFrom((com.google.cloud.clouddms.v1.BackgroundJobLogEntry) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.BackgroundJobLogEntry other) {
      if (other == com.google.cloud.clouddms.v1.BackgroundJobLogEntry.getDefaultInstance())
        return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.jobType_ != 0) {
        setJobTypeValue(other.getJobTypeValue());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasFinishTime()) {
        mergeFinishTime(other.getFinishTime());
      }
      if (other.completionState_ != 0) {
        setCompletionStateValue(other.getCompletionStateValue());
      }
      if (!other.getCompletionComment().isEmpty()) {
        completionComment_ = other.completionComment_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.getRequestAutocommit() != false) {
        setRequestAutocommit(other.getRequestAutocommit());
      }
      switch (other.getJobDetailsCase()) {
        case SEED_JOB_DETAILS:
          {
            mergeSeedJobDetails(other.getSeedJobDetails());
            break;
          }
        case IMPORT_RULES_JOB_DETAILS:
          {
            mergeImportRulesJobDetails(other.getImportRulesJobDetails());
            break;
          }
        case CONVERT_JOB_DETAILS:
          {
            mergeConvertJobDetails(other.getConvertJobDetails());
            break;
          }
        case APPLY_JOB_DETAILS:
          {
            mergeApplyJobDetails(other.getApplyJobDetails());
            break;
          }
        case JOBDETAILS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                jobType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getFinishTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                completionState_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                completionComment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                requestAutocommit_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 802:
              {
                input.readMessage(getSeedJobDetailsFieldBuilder().getBuilder(), extensionRegistry);
                jobDetailsCase_ = 100;
                break;
              } // case 802
            case 810:
              {
                input.readMessage(
                    getImportRulesJobDetailsFieldBuilder().getBuilder(), extensionRegistry);
                jobDetailsCase_ = 101;
                break;
              } // case 810
            case 818:
              {
                input.readMessage(
                    getConvertJobDetailsFieldBuilder().getBuilder(), extensionRegistry);
                jobDetailsCase_ = 102;
                break;
              } // case 818
            case 826:
              {
                input.readMessage(getApplyJobDetailsFieldBuilder().getBuilder(), extensionRegistry);
                jobDetailsCase_ = 103;
                break;
              } // case 826
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int jobDetailsCase_ = 0;
    private java.lang.Object jobDetails_;

    public JobDetailsCase getJobDetailsCase() {
      return JobDetailsCase.forNumber(jobDetailsCase_);
    }

    public Builder clearJobDetails() {
      jobDetailsCase_ = 0;
      jobDetails_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * The background job log entry ID.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The background job log entry ID.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The background job log entry ID.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The background job log entry ID.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The background job log entry ID.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int jobType_ = 0;
    /**
     *
     *
     * <pre>
     * The type of job that was executed.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.BackgroundJobType job_type = 2;</code>
     *
     * @return The enum numeric value on the wire for jobType.
     */
    @java.lang.Override
    public int getJobTypeValue() {
      return jobType_;
    }
    /**
     *
     *
     * <pre>
     * The type of job that was executed.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.BackgroundJobType job_type = 2;</code>
     *
     * @param value The enum numeric value on the wire for jobType to set.
     * @return This builder for chaining.
     */
    public Builder setJobTypeValue(int value) {
      jobType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of job that was executed.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.BackgroundJobType job_type = 2;</code>
     *
     * @return The jobType.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobType getJobType() {
      com.google.cloud.clouddms.v1.BackgroundJobType result =
          com.google.cloud.clouddms.v1.BackgroundJobType.forNumber(jobType_);
      return result == null ? com.google.cloud.clouddms.v1.BackgroundJobType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The type of job that was executed.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.BackgroundJobType job_type = 2;</code>
     *
     * @param value The jobType to set.
     * @return This builder for chaining.
     */
    public Builder setJobType(com.google.cloud.clouddms.v1.BackgroundJobType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      jobType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of job that was executed.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.BackgroundJobType job_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      jobType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp finishTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        finishTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 4;</code>
     *
     * @return Whether the finishTime field is set.
     */
    public boolean hasFinishTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 4;</code>
     *
     * @return The finishTime.
     */
    public com.google.protobuf.Timestamp getFinishTime() {
      if (finishTimeBuilder_ == null) {
        return finishTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : finishTime_;
      } else {
        return finishTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 4;</code>
     */
    public Builder setFinishTime(com.google.protobuf.Timestamp value) {
      if (finishTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        finishTime_ = value;
      } else {
        finishTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 4;</code>
     */
    public Builder setFinishTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (finishTimeBuilder_ == null) {
        finishTime_ = builderForValue.build();
      } else {
        finishTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 4;</code>
     */
    public Builder mergeFinishTime(com.google.protobuf.Timestamp value) {
      if (finishTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && finishTime_ != null
            && finishTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getFinishTimeBuilder().mergeFrom(value);
        } else {
          finishTime_ = value;
        }
      } else {
        finishTimeBuilder_.mergeFrom(value);
      }
      if (finishTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 4;</code>
     */
    public Builder clearFinishTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      finishTime_ = null;
      if (finishTimeBuilder_ != null) {
        finishTimeBuilder_.dispose();
        finishTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getFinishTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getFinishTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getFinishTimeOrBuilder() {
      if (finishTimeBuilder_ != null) {
        return finishTimeBuilder_.getMessageOrBuilder();
      } else {
        return finishTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : finishTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the background job was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getFinishTimeFieldBuilder() {
      if (finishTimeBuilder_ == null) {
        finishTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getFinishTime(), getParentForChildren(), isClean());
        finishTime_ = null;
      }
      return finishTimeBuilder_;
    }

    private int completionState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Job completion state, i.e. the final state after the job
     * completed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState completion_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for completionState.
     */
    @java.lang.Override
    public int getCompletionStateValue() {
      return completionState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Job completion state, i.e. the final state after the job
     * completed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState completion_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for completionState to set.
     * @return This builder for chaining.
     */
    public Builder setCompletionStateValue(int value) {
      completionState_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Job completion state, i.e. the final state after the job
     * completed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState completion_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The completionState.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState
        getCompletionState() {
      com.google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState result =
          com.google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState.forNumber(
              completionState_);
      return result == null
          ? com.google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Job completion state, i.e. the final state after the job
     * completed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState completion_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The completionState to set.
     * @return This builder for chaining.
     */
    public Builder setCompletionState(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      completionState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Job completion state, i.e. the final state after the job
     * completed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState completion_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCompletionState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      completionState_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object completionComment_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Job completion comment, such as how many entities were seeded,
     * how many warnings were found during conversion, and similar information.
     * </pre>
     *
     * <code>string completion_comment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The completionComment.
     */
    public java.lang.String getCompletionComment() {
      java.lang.Object ref = completionComment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        completionComment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Job completion comment, such as how many entities were seeded,
     * how many warnings were found during conversion, and similar information.
     * </pre>
     *
     * <code>string completion_comment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for completionComment.
     */
    public com.google.protobuf.ByteString getCompletionCommentBytes() {
      java.lang.Object ref = completionComment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        completionComment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Job completion comment, such as how many entities were seeded,
     * how many warnings were found during conversion, and similar information.
     * </pre>
     *
     * <code>string completion_comment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The completionComment to set.
     * @return This builder for chaining.
     */
    public Builder setCompletionComment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      completionComment_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Job completion comment, such as how many entities were seeded,
     * how many warnings were found during conversion, and similar information.
     * </pre>
     *
     * <code>string completion_comment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCompletionComment() {
      completionComment_ = getDefaultInstance().getCompletionComment();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Job completion comment, such as how many entities were seeded,
     * how many warnings were found during conversion, and similar information.
     * </pre>
     *
     * <code>string completion_comment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for completionComment to set.
     * @return This builder for chaining.
     */
    public Builder setCompletionCommentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      completionComment_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private boolean requestAutocommit_;
    /**
     *
     *
     * <pre>
     * Output only. Whether the client requested the conversion workspace to be
     * committed after a successful completion of the job.
     * </pre>
     *
     * <code>bool request_autocommit = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The requestAutocommit.
     */
    @java.lang.Override
    public boolean getRequestAutocommit() {
      return requestAutocommit_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether the client requested the conversion workspace to be
     * committed after a successful completion of the job.
     * </pre>
     *
     * <code>bool request_autocommit = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The requestAutocommit to set.
     * @return This builder for chaining.
     */
    public Builder setRequestAutocommit(boolean value) {

      requestAutocommit_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether the client requested the conversion workspace to be
     * committed after a successful completion of the job.
     * </pre>
     *
     * <code>bool request_autocommit = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestAutocommit() {
      bitField0_ = (bitField0_ & ~0x00000040);
      requestAutocommit_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails.Builder,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetailsOrBuilder>
        seedJobDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Seed job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails seed_job_details = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the seedJobDetails field is set.
     */
    @java.lang.Override
    public boolean hasSeedJobDetails() {
      return jobDetailsCase_ == 100;
    }
    /**
     *
     *
     * <pre>
     * Output only. Seed job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails seed_job_details = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The seedJobDetails.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails getSeedJobDetails() {
      if (seedJobDetailsBuilder_ == null) {
        if (jobDetailsCase_ == 100) {
          return (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails) jobDetails_;
        }
        return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
            .getDefaultInstance();
      } else {
        if (jobDetailsCase_ == 100) {
          return seedJobDetailsBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Seed job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails seed_job_details = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSeedJobDetails(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails value) {
      if (seedJobDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobDetails_ = value;
        onChanged();
      } else {
        seedJobDetailsBuilder_.setMessage(value);
      }
      jobDetailsCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Seed job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails seed_job_details = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSeedJobDetails(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails.Builder builderForValue) {
      if (seedJobDetailsBuilder_ == null) {
        jobDetails_ = builderForValue.build();
        onChanged();
      } else {
        seedJobDetailsBuilder_.setMessage(builderForValue.build());
      }
      jobDetailsCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Seed job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails seed_job_details = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSeedJobDetails(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails value) {
      if (seedJobDetailsBuilder_ == null) {
        if (jobDetailsCase_ == 100
            && jobDetails_
                != com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
                    .getDefaultInstance()) {
          jobDetails_ =
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails.newBuilder(
                      (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails)
                          jobDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobDetails_ = value;
        }
        onChanged();
      } else {
        if (jobDetailsCase_ == 100) {
          seedJobDetailsBuilder_.mergeFrom(value);
        } else {
          seedJobDetailsBuilder_.setMessage(value);
        }
      }
      jobDetailsCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Seed job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails seed_job_details = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSeedJobDetails() {
      if (seedJobDetailsBuilder_ == null) {
        if (jobDetailsCase_ == 100) {
          jobDetailsCase_ = 0;
          jobDetails_ = null;
          onChanged();
        }
      } else {
        if (jobDetailsCase_ == 100) {
          jobDetailsCase_ = 0;
          jobDetails_ = null;
        }
        seedJobDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Seed job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails seed_job_details = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails.Builder
        getSeedJobDetailsBuilder() {
      return getSeedJobDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Seed job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails seed_job_details = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetailsOrBuilder
        getSeedJobDetailsOrBuilder() {
      if ((jobDetailsCase_ == 100) && (seedJobDetailsBuilder_ != null)) {
        return seedJobDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (jobDetailsCase_ == 100) {
          return (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails) jobDetails_;
        }
        return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Seed job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails seed_job_details = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails.Builder,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetailsOrBuilder>
        getSeedJobDetailsFieldBuilder() {
      if (seedJobDetailsBuilder_ == null) {
        if (!(jobDetailsCase_ == 100)) {
          jobDetails_ =
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
                  .getDefaultInstance();
        }
        seedJobDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails,
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails.Builder,
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetailsOrBuilder>(
                (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails) jobDetails_,
                getParentForChildren(),
                isClean());
        jobDetails_ = null;
      }
      jobDetailsCase_ = 100;
      onChanged();
      return seedJobDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails.Builder,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetailsOrBuilder>
        importRulesJobDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Import rules job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails import_rules_job_details = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the importRulesJobDetails field is set.
     */
    @java.lang.Override
    public boolean hasImportRulesJobDetails() {
      return jobDetailsCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * Output only. Import rules job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails import_rules_job_details = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The importRulesJobDetails.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
        getImportRulesJobDetails() {
      if (importRulesJobDetailsBuilder_ == null) {
        if (jobDetailsCase_ == 101) {
          return (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails)
              jobDetails_;
        }
        return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
            .getDefaultInstance();
      } else {
        if (jobDetailsCase_ == 101) {
          return importRulesJobDetailsBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Import rules job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails import_rules_job_details = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setImportRulesJobDetails(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails value) {
      if (importRulesJobDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobDetails_ = value;
        onChanged();
      } else {
        importRulesJobDetailsBuilder_.setMessage(value);
      }
      jobDetailsCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Import rules job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails import_rules_job_details = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setImportRulesJobDetails(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails.Builder
            builderForValue) {
      if (importRulesJobDetailsBuilder_ == null) {
        jobDetails_ = builderForValue.build();
        onChanged();
      } else {
        importRulesJobDetailsBuilder_.setMessage(builderForValue.build());
      }
      jobDetailsCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Import rules job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails import_rules_job_details = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeImportRulesJobDetails(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails value) {
      if (importRulesJobDetailsBuilder_ == null) {
        if (jobDetailsCase_ == 101
            && jobDetails_
                != com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
                    .getDefaultInstance()) {
          jobDetails_ =
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails.newBuilder(
                      (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails)
                          jobDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobDetails_ = value;
        }
        onChanged();
      } else {
        if (jobDetailsCase_ == 101) {
          importRulesJobDetailsBuilder_.mergeFrom(value);
        } else {
          importRulesJobDetailsBuilder_.setMessage(value);
        }
      }
      jobDetailsCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Import rules job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails import_rules_job_details = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearImportRulesJobDetails() {
      if (importRulesJobDetailsBuilder_ == null) {
        if (jobDetailsCase_ == 101) {
          jobDetailsCase_ = 0;
          jobDetails_ = null;
          onChanged();
        }
      } else {
        if (jobDetailsCase_ == 101) {
          jobDetailsCase_ = 0;
          jobDetails_ = null;
        }
        importRulesJobDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Import rules job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails import_rules_job_details = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails.Builder
        getImportRulesJobDetailsBuilder() {
      return getImportRulesJobDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Import rules job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails import_rules_job_details = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetailsOrBuilder
        getImportRulesJobDetailsOrBuilder() {
      if ((jobDetailsCase_ == 101) && (importRulesJobDetailsBuilder_ != null)) {
        return importRulesJobDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (jobDetailsCase_ == 101) {
          return (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails)
              jobDetails_;
        }
        return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Import rules job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails import_rules_job_details = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails.Builder,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetailsOrBuilder>
        getImportRulesJobDetailsFieldBuilder() {
      if (importRulesJobDetailsBuilder_ == null) {
        if (!(jobDetailsCase_ == 101)) {
          jobDetails_ =
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
                  .getDefaultInstance();
        }
        importRulesJobDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails,
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails.Builder,
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetailsOrBuilder>(
                (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails)
                    jobDetails_,
                getParentForChildren(),
                isClean());
        jobDetails_ = null;
      }
      jobDetailsCase_ = 101;
      onChanged();
      return importRulesJobDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails.Builder,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetailsOrBuilder>
        convertJobDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Convert job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails convert_job_details = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the convertJobDetails field is set.
     */
    @java.lang.Override
    public boolean hasConvertJobDetails() {
      return jobDetailsCase_ == 102;
    }
    /**
     *
     *
     * <pre>
     * Output only. Convert job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails convert_job_details = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The convertJobDetails.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
        getConvertJobDetails() {
      if (convertJobDetailsBuilder_ == null) {
        if (jobDetailsCase_ == 102) {
          return (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails) jobDetails_;
        }
        return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
            .getDefaultInstance();
      } else {
        if (jobDetailsCase_ == 102) {
          return convertJobDetailsBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Convert job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails convert_job_details = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConvertJobDetails(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails value) {
      if (convertJobDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobDetails_ = value;
        onChanged();
      } else {
        convertJobDetailsBuilder_.setMessage(value);
      }
      jobDetailsCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Convert job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails convert_job_details = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConvertJobDetails(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails.Builder
            builderForValue) {
      if (convertJobDetailsBuilder_ == null) {
        jobDetails_ = builderForValue.build();
        onChanged();
      } else {
        convertJobDetailsBuilder_.setMessage(builderForValue.build());
      }
      jobDetailsCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Convert job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails convert_job_details = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeConvertJobDetails(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails value) {
      if (convertJobDetailsBuilder_ == null) {
        if (jobDetailsCase_ == 102
            && jobDetails_
                != com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
                    .getDefaultInstance()) {
          jobDetails_ =
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails.newBuilder(
                      (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails)
                          jobDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobDetails_ = value;
        }
        onChanged();
      } else {
        if (jobDetailsCase_ == 102) {
          convertJobDetailsBuilder_.mergeFrom(value);
        } else {
          convertJobDetailsBuilder_.setMessage(value);
        }
      }
      jobDetailsCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Convert job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails convert_job_details = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearConvertJobDetails() {
      if (convertJobDetailsBuilder_ == null) {
        if (jobDetailsCase_ == 102) {
          jobDetailsCase_ = 0;
          jobDetails_ = null;
          onChanged();
        }
      } else {
        if (jobDetailsCase_ == 102) {
          jobDetailsCase_ = 0;
          jobDetails_ = null;
        }
        convertJobDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Convert job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails convert_job_details = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails.Builder
        getConvertJobDetailsBuilder() {
      return getConvertJobDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Convert job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails convert_job_details = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetailsOrBuilder
        getConvertJobDetailsOrBuilder() {
      if ((jobDetailsCase_ == 102) && (convertJobDetailsBuilder_ != null)) {
        return convertJobDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (jobDetailsCase_ == 102) {
          return (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails) jobDetails_;
        }
        return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Convert job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails convert_job_details = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails.Builder,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetailsOrBuilder>
        getConvertJobDetailsFieldBuilder() {
      if (convertJobDetailsBuilder_ == null) {
        if (!(jobDetailsCase_ == 102)) {
          jobDetails_ =
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
                  .getDefaultInstance();
        }
        convertJobDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails,
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails.Builder,
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetailsOrBuilder>(
                (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails) jobDetails_,
                getParentForChildren(),
                isClean());
        jobDetails_ = null;
      }
      jobDetailsCase_ = 102;
      onChanged();
      return convertJobDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails.Builder,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetailsOrBuilder>
        applyJobDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Apply job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails apply_job_details = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the applyJobDetails field is set.
     */
    @java.lang.Override
    public boolean hasApplyJobDetails() {
      return jobDetailsCase_ == 103;
    }
    /**
     *
     *
     * <pre>
     * Output only. Apply job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails apply_job_details = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The applyJobDetails.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails getApplyJobDetails() {
      if (applyJobDetailsBuilder_ == null) {
        if (jobDetailsCase_ == 103) {
          return (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails) jobDetails_;
        }
        return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
            .getDefaultInstance();
      } else {
        if (jobDetailsCase_ == 103) {
          return applyJobDetailsBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Apply job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails apply_job_details = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setApplyJobDetails(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails value) {
      if (applyJobDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobDetails_ = value;
        onChanged();
      } else {
        applyJobDetailsBuilder_.setMessage(value);
      }
      jobDetailsCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Apply job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails apply_job_details = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setApplyJobDetails(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails.Builder
            builderForValue) {
      if (applyJobDetailsBuilder_ == null) {
        jobDetails_ = builderForValue.build();
        onChanged();
      } else {
        applyJobDetailsBuilder_.setMessage(builderForValue.build());
      }
      jobDetailsCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Apply job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails apply_job_details = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeApplyJobDetails(
        com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails value) {
      if (applyJobDetailsBuilder_ == null) {
        if (jobDetailsCase_ == 103
            && jobDetails_
                != com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
                    .getDefaultInstance()) {
          jobDetails_ =
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails.newBuilder(
                      (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails)
                          jobDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobDetails_ = value;
        }
        onChanged();
      } else {
        if (jobDetailsCase_ == 103) {
          applyJobDetailsBuilder_.mergeFrom(value);
        } else {
          applyJobDetailsBuilder_.setMessage(value);
        }
      }
      jobDetailsCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Apply job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails apply_job_details = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearApplyJobDetails() {
      if (applyJobDetailsBuilder_ == null) {
        if (jobDetailsCase_ == 103) {
          jobDetailsCase_ = 0;
          jobDetails_ = null;
          onChanged();
        }
      } else {
        if (jobDetailsCase_ == 103) {
          jobDetailsCase_ = 0;
          jobDetails_ = null;
        }
        applyJobDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Apply job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails apply_job_details = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails.Builder
        getApplyJobDetailsBuilder() {
      return getApplyJobDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Apply job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails apply_job_details = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetailsOrBuilder
        getApplyJobDetailsOrBuilder() {
      if ((jobDetailsCase_ == 103) && (applyJobDetailsBuilder_ != null)) {
        return applyJobDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (jobDetailsCase_ == 103) {
          return (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails) jobDetails_;
        }
        return com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Apply job details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails apply_job_details = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails.Builder,
            com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetailsOrBuilder>
        getApplyJobDetailsFieldBuilder() {
      if (applyJobDetailsBuilder_ == null) {
        if (!(jobDetailsCase_ == 103)) {
          jobDetails_ =
              com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
                  .getDefaultInstance();
        }
        applyJobDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails,
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails.Builder,
                com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetailsOrBuilder>(
                (com.google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails) jobDetails_,
                getParentForChildren(),
                isClean());
        jobDetails_ = null;
      }
      jobDetailsCase_ = 103;
      onChanged();
      return applyJobDetailsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.BackgroundJobLogEntry)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.BackgroundJobLogEntry)
  private static final com.google.cloud.clouddms.v1.BackgroundJobLogEntry DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.BackgroundJobLogEntry();
  }

  public static com.google.cloud.clouddms.v1.BackgroundJobLogEntry getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BackgroundJobLogEntry> PARSER =
      new com.google.protobuf.AbstractParser<BackgroundJobLogEntry>() {
        @java.lang.Override
        public BackgroundJobLogEntry parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BackgroundJobLogEntry> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BackgroundJobLogEntry> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.BackgroundJobLogEntry getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
