/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Specifies required connection parameters, and, optionally, the parameters
 * required to create a Cloud SQL destination database instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.CloudSqlConnectionProfile}
 */
public final class CloudSqlConnectionProfile extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.CloudSqlConnectionProfile)
    CloudSqlConnectionProfileOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CloudSqlConnectionProfile.newBuilder() to construct.
  private CloudSqlConnectionProfile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudSqlConnectionProfile() {
    cloudSqlId_ = "";
    privateIp_ = "";
    publicIp_ = "";
    additionalPublicIp_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudSqlConnectionProfile();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_CloudSqlConnectionProfile_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_CloudSqlConnectionProfile_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.class,
            com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.Builder.class);
  }

  private int bitField0_;
  public static final int CLOUD_SQL_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cloudSqlId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The Cloud SQL instance ID that this connection profile is
   * associated with.
   * </pre>
   *
   * <code>string cloud_sql_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The cloudSqlId.
   */
  @java.lang.Override
  public java.lang.String getCloudSqlId() {
    java.lang.Object ref = cloudSqlId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cloudSqlId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The Cloud SQL instance ID that this connection profile is
   * associated with.
   * </pre>
   *
   * <code>string cloud_sql_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for cloudSqlId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCloudSqlIdBytes() {
    java.lang.Object ref = cloudSqlId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cloudSqlId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SETTINGS_FIELD_NUMBER = 2;
  private com.google.cloud.clouddms.v1.CloudSqlSettings settings_;
  /**
   *
   *
   * <pre>
   * Immutable. Metadata used to create the destination Cloud SQL database.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.CloudSqlSettings settings = 2 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the settings field is set.
   */
  @java.lang.Override
  public boolean hasSettings() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Immutable. Metadata used to create the destination Cloud SQL database.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.CloudSqlSettings settings = 2 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The settings.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.CloudSqlSettings getSettings() {
    return settings_ == null
        ? com.google.cloud.clouddms.v1.CloudSqlSettings.getDefaultInstance()
        : settings_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. Metadata used to create the destination Cloud SQL database.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.CloudSqlSettings settings = 2 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.CloudSqlSettingsOrBuilder getSettingsOrBuilder() {
    return settings_ == null
        ? com.google.cloud.clouddms.v1.CloudSqlSettings.getDefaultInstance()
        : settings_;
  }

  public static final int PRIVATE_IP_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object privateIp_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The Cloud SQL database instance's private IP.
   * </pre>
   *
   * <code>string private_ip = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The privateIp.
   */
  @java.lang.Override
  public java.lang.String getPrivateIp() {
    java.lang.Object ref = privateIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      privateIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The Cloud SQL database instance's private IP.
   * </pre>
   *
   * <code>string private_ip = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for privateIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrivateIpBytes() {
    java.lang.Object ref = privateIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      privateIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PUBLIC_IP_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object publicIp_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The Cloud SQL database instance's public IP.
   * </pre>
   *
   * <code>string public_ip = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The publicIp.
   */
  @java.lang.Override
  public java.lang.String getPublicIp() {
    java.lang.Object ref = publicIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      publicIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The Cloud SQL database instance's public IP.
   * </pre>
   *
   * <code>string public_ip = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for publicIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPublicIpBytes() {
    java.lang.Object ref = publicIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      publicIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADDITIONAL_PUBLIC_IP_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object additionalPublicIp_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The Cloud SQL database instance's additional (outgoing) public
   * IP. Used when the Cloud SQL database availability type is REGIONAL (i.e.
   * multiple zones / highly available).
   * </pre>
   *
   * <code>string additional_public_ip = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The additionalPublicIp.
   */
  @java.lang.Override
  public java.lang.String getAdditionalPublicIp() {
    java.lang.Object ref = additionalPublicIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      additionalPublicIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The Cloud SQL database instance's additional (outgoing) public
   * IP. Used when the Cloud SQL database availability type is REGIONAL (i.e.
   * multiple zones / highly available).
   * </pre>
   *
   * <code>string additional_public_ip = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for additionalPublicIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAdditionalPublicIpBytes() {
    java.lang.Object ref = additionalPublicIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      additionalPublicIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cloudSqlId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, cloudSqlId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getSettings());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, privateIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, publicIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(additionalPublicIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, additionalPublicIp_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cloudSqlId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, cloudSqlId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSettings());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, privateIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, publicIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(additionalPublicIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, additionalPublicIp_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.CloudSqlConnectionProfile)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.CloudSqlConnectionProfile other =
        (com.google.cloud.clouddms.v1.CloudSqlConnectionProfile) obj;

    if (!getCloudSqlId().equals(other.getCloudSqlId())) return false;
    if (hasSettings() != other.hasSettings()) return false;
    if (hasSettings()) {
      if (!getSettings().equals(other.getSettings())) return false;
    }
    if (!getPrivateIp().equals(other.getPrivateIp())) return false;
    if (!getPublicIp().equals(other.getPublicIp())) return false;
    if (!getAdditionalPublicIp().equals(other.getAdditionalPublicIp())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CLOUD_SQL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getCloudSqlId().hashCode();
    if (hasSettings()) {
      hash = (37 * hash) + SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getSettings().hashCode();
    }
    hash = (37 * hash) + PRIVATE_IP_FIELD_NUMBER;
    hash = (53 * hash) + getPrivateIp().hashCode();
    hash = (37 * hash) + PUBLIC_IP_FIELD_NUMBER;
    hash = (53 * hash) + getPublicIp().hashCode();
    hash = (37 * hash) + ADDITIONAL_PUBLIC_IP_FIELD_NUMBER;
    hash = (53 * hash) + getAdditionalPublicIp().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.CloudSqlConnectionProfile parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlConnectionProfile parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlConnectionProfile parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlConnectionProfile parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlConnectionProfile parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlConnectionProfile parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlConnectionProfile parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlConnectionProfile parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlConnectionProfile parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlConnectionProfile parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlConnectionProfile parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlConnectionProfile parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.clouddms.v1.CloudSqlConnectionProfile prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies required connection parameters, and, optionally, the parameters
   * required to create a Cloud SQL destination database instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.CloudSqlConnectionProfile}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.CloudSqlConnectionProfile)
      com.google.cloud.clouddms.v1.CloudSqlConnectionProfileOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_CloudSqlConnectionProfile_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_CloudSqlConnectionProfile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.class,
              com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSettingsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      cloudSqlId_ = "";
      settings_ = null;
      if (settingsBuilder_ != null) {
        settingsBuilder_.dispose();
        settingsBuilder_ = null;
      }
      privateIp_ = "";
      publicIp_ = "";
      additionalPublicIp_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_CloudSqlConnectionProfile_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.CloudSqlConnectionProfile getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.CloudSqlConnectionProfile build() {
      com.google.cloud.clouddms.v1.CloudSqlConnectionProfile result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.CloudSqlConnectionProfile buildPartial() {
      com.google.cloud.clouddms.v1.CloudSqlConnectionProfile result =
          new com.google.cloud.clouddms.v1.CloudSqlConnectionProfile(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.CloudSqlConnectionProfile result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.cloudSqlId_ = cloudSqlId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.settings_ = settingsBuilder_ == null ? settings_ : settingsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.privateIp_ = privateIp_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.publicIp_ = publicIp_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.additionalPublicIp_ = additionalPublicIp_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.CloudSqlConnectionProfile) {
        return mergeFrom((com.google.cloud.clouddms.v1.CloudSqlConnectionProfile) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.CloudSqlConnectionProfile other) {
      if (other == com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.getDefaultInstance())
        return this;
      if (!other.getCloudSqlId().isEmpty()) {
        cloudSqlId_ = other.cloudSqlId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSettings()) {
        mergeSettings(other.getSettings());
      }
      if (!other.getPrivateIp().isEmpty()) {
        privateIp_ = other.privateIp_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getPublicIp().isEmpty()) {
        publicIp_ = other.publicIp_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getAdditionalPublicIp().isEmpty()) {
        additionalPublicIp_ = other.additionalPublicIp_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                cloudSqlId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                privateIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                publicIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                additionalPublicIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object cloudSqlId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL instance ID that this connection profile is
     * associated with.
     * </pre>
     *
     * <code>string cloud_sql_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The cloudSqlId.
     */
    public java.lang.String getCloudSqlId() {
      java.lang.Object ref = cloudSqlId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cloudSqlId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL instance ID that this connection profile is
     * associated with.
     * </pre>
     *
     * <code>string cloud_sql_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for cloudSqlId.
     */
    public com.google.protobuf.ByteString getCloudSqlIdBytes() {
      java.lang.Object ref = cloudSqlId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cloudSqlId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL instance ID that this connection profile is
     * associated with.
     * </pre>
     *
     * <code>string cloud_sql_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The cloudSqlId to set.
     * @return This builder for chaining.
     */
    public Builder setCloudSqlId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cloudSqlId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL instance ID that this connection profile is
     * associated with.
     * </pre>
     *
     * <code>string cloud_sql_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCloudSqlId() {
      cloudSqlId_ = getDefaultInstance().getCloudSqlId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL instance ID that this connection profile is
     * associated with.
     * </pre>
     *
     * <code>string cloud_sql_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for cloudSqlId to set.
     * @return This builder for chaining.
     */
    public Builder setCloudSqlIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cloudSqlId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.clouddms.v1.CloudSqlSettings settings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.CloudSqlSettings,
            com.google.cloud.clouddms.v1.CloudSqlSettings.Builder,
            com.google.cloud.clouddms.v1.CloudSqlSettingsOrBuilder>
        settingsBuilder_;
    /**
     *
     *
     * <pre>
     * Immutable. Metadata used to create the destination Cloud SQL database.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings settings = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the settings field is set.
     */
    public boolean hasSettings() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Immutable. Metadata used to create the destination Cloud SQL database.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings settings = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The settings.
     */
    public com.google.cloud.clouddms.v1.CloudSqlSettings getSettings() {
      if (settingsBuilder_ == null) {
        return settings_ == null
            ? com.google.cloud.clouddms.v1.CloudSqlSettings.getDefaultInstance()
            : settings_;
      } else {
        return settingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Metadata used to create the destination Cloud SQL database.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings settings = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setSettings(com.google.cloud.clouddms.v1.CloudSqlSettings value) {
      if (settingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        settings_ = value;
      } else {
        settingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Metadata used to create the destination Cloud SQL database.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings settings = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setSettings(
        com.google.cloud.clouddms.v1.CloudSqlSettings.Builder builderForValue) {
      if (settingsBuilder_ == null) {
        settings_ = builderForValue.build();
      } else {
        settingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Metadata used to create the destination Cloud SQL database.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings settings = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeSettings(com.google.cloud.clouddms.v1.CloudSqlSettings value) {
      if (settingsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && settings_ != null
            && settings_ != com.google.cloud.clouddms.v1.CloudSqlSettings.getDefaultInstance()) {
          getSettingsBuilder().mergeFrom(value);
        } else {
          settings_ = value;
        }
      } else {
        settingsBuilder_.mergeFrom(value);
      }
      if (settings_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Metadata used to create the destination Cloud SQL database.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings settings = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearSettings() {
      bitField0_ = (bitField0_ & ~0x00000002);
      settings_ = null;
      if (settingsBuilder_ != null) {
        settingsBuilder_.dispose();
        settingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Metadata used to create the destination Cloud SQL database.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings settings = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.clouddms.v1.CloudSqlSettings.Builder getSettingsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Immutable. Metadata used to create the destination Cloud SQL database.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings settings = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.clouddms.v1.CloudSqlSettingsOrBuilder getSettingsOrBuilder() {
      if (settingsBuilder_ != null) {
        return settingsBuilder_.getMessageOrBuilder();
      } else {
        return settings_ == null
            ? com.google.cloud.clouddms.v1.CloudSqlSettings.getDefaultInstance()
            : settings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Metadata used to create the destination Cloud SQL database.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings settings = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.CloudSqlSettings,
            com.google.cloud.clouddms.v1.CloudSqlSettings.Builder,
            com.google.cloud.clouddms.v1.CloudSqlSettingsOrBuilder>
        getSettingsFieldBuilder() {
      if (settingsBuilder_ == null) {
        settingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.CloudSqlSettings,
                com.google.cloud.clouddms.v1.CloudSqlSettings.Builder,
                com.google.cloud.clouddms.v1.CloudSqlSettingsOrBuilder>(
                getSettings(), getParentForChildren(), isClean());
        settings_ = null;
      }
      return settingsBuilder_;
    }

    private java.lang.Object privateIp_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL database instance's private IP.
     * </pre>
     *
     * <code>string private_ip = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The privateIp.
     */
    public java.lang.String getPrivateIp() {
      java.lang.Object ref = privateIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        privateIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL database instance's private IP.
     * </pre>
     *
     * <code>string private_ip = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for privateIp.
     */
    public com.google.protobuf.ByteString getPrivateIpBytes() {
      java.lang.Object ref = privateIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        privateIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL database instance's private IP.
     * </pre>
     *
     * <code>string private_ip = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The privateIp to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      privateIp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL database instance's private IP.
     * </pre>
     *
     * <code>string private_ip = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateIp() {
      privateIp_ = getDefaultInstance().getPrivateIp();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL database instance's private IP.
     * </pre>
     *
     * <code>string private_ip = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for privateIp to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      privateIp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object publicIp_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL database instance's public IP.
     * </pre>
     *
     * <code>string public_ip = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The publicIp.
     */
    public java.lang.String getPublicIp() {
      java.lang.Object ref = publicIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        publicIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL database instance's public IP.
     * </pre>
     *
     * <code>string public_ip = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for publicIp.
     */
    public com.google.protobuf.ByteString getPublicIpBytes() {
      java.lang.Object ref = publicIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        publicIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL database instance's public IP.
     * </pre>
     *
     * <code>string public_ip = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The publicIp to set.
     * @return This builder for chaining.
     */
    public Builder setPublicIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      publicIp_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL database instance's public IP.
     * </pre>
     *
     * <code>string public_ip = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPublicIp() {
      publicIp_ = getDefaultInstance().getPublicIp();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL database instance's public IP.
     * </pre>
     *
     * <code>string public_ip = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for publicIp to set.
     * @return This builder for chaining.
     */
    public Builder setPublicIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      publicIp_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object additionalPublicIp_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL database instance's additional (outgoing) public
     * IP. Used when the Cloud SQL database availability type is REGIONAL (i.e.
     * multiple zones / highly available).
     * </pre>
     *
     * <code>string additional_public_ip = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The additionalPublicIp.
     */
    public java.lang.String getAdditionalPublicIp() {
      java.lang.Object ref = additionalPublicIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        additionalPublicIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL database instance's additional (outgoing) public
     * IP. Used when the Cloud SQL database availability type is REGIONAL (i.e.
     * multiple zones / highly available).
     * </pre>
     *
     * <code>string additional_public_ip = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for additionalPublicIp.
     */
    public com.google.protobuf.ByteString getAdditionalPublicIpBytes() {
      java.lang.Object ref = additionalPublicIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        additionalPublicIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL database instance's additional (outgoing) public
     * IP. Used when the Cloud SQL database availability type is REGIONAL (i.e.
     * multiple zones / highly available).
     * </pre>
     *
     * <code>string additional_public_ip = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The additionalPublicIp to set.
     * @return This builder for chaining.
     */
    public Builder setAdditionalPublicIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      additionalPublicIp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL database instance's additional (outgoing) public
     * IP. Used when the Cloud SQL database availability type is REGIONAL (i.e.
     * multiple zones / highly available).
     * </pre>
     *
     * <code>string additional_public_ip = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdditionalPublicIp() {
      additionalPublicIp_ = getDefaultInstance().getAdditionalPublicIp();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud SQL database instance's additional (outgoing) public
     * IP. Used when the Cloud SQL database availability type is REGIONAL (i.e.
     * multiple zones / highly available).
     * </pre>
     *
     * <code>string additional_public_ip = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for additionalPublicIp to set.
     * @return This builder for chaining.
     */
    public Builder setAdditionalPublicIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      additionalPublicIp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.CloudSqlConnectionProfile)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.CloudSqlConnectionProfile)
  private static final com.google.cloud.clouddms.v1.CloudSqlConnectionProfile DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.CloudSqlConnectionProfile();
  }

  public static com.google.cloud.clouddms.v1.CloudSqlConnectionProfile getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudSqlConnectionProfile> PARSER =
      new com.google.protobuf.AbstractParser<CloudSqlConnectionProfile>() {
        @java.lang.Override
        public CloudSqlConnectionProfile parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudSqlConnectionProfile> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudSqlConnectionProfile> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.CloudSqlConnectionProfile getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
