/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Settings for creating a Cloud SQL database instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.CloudSqlSettings}
 */
public final class CloudSqlSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.CloudSqlSettings)
    CloudSqlSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CloudSqlSettings.newBuilder() to construct.
  private CloudSqlSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudSqlSettings() {
    databaseVersion_ = 0;
    tier_ = "";
    activationPolicy_ = 0;
    dataDiskType_ = 0;
    zone_ = "";
    secondaryZone_ = "";
    sourceId_ = "";
    rootPassword_ = "";
    collation_ = "";
    cmekKeyName_ = "";
    availabilityType_ = 0;
    edition_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudSqlSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_CloudSqlSettings_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 2:
        return internalGetUserLabels();
      case 8:
        return internalGetDatabaseFlags();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_CloudSqlSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.CloudSqlSettings.class,
            com.google.cloud.clouddms.v1.CloudSqlSettings.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies when the instance should be activated.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy}
   */
  public enum SqlActivationPolicy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * unspecified policy.
     * </pre>
     *
     * <code>SQL_ACTIVATION_POLICY_UNSPECIFIED = 0;</code>
     */
    SQL_ACTIVATION_POLICY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The instance is always up and running.
     * </pre>
     *
     * <code>ALWAYS = 1;</code>
     */
    ALWAYS(1),
    /**
     *
     *
     * <pre>
     * The instance should never spin up.
     * </pre>
     *
     * <code>NEVER = 2;</code>
     */
    NEVER(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * unspecified policy.
     * </pre>
     *
     * <code>SQL_ACTIVATION_POLICY_UNSPECIFIED = 0;</code>
     */
    public static final int SQL_ACTIVATION_POLICY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The instance is always up and running.
     * </pre>
     *
     * <code>ALWAYS = 1;</code>
     */
    public static final int ALWAYS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The instance should never spin up.
     * </pre>
     *
     * <code>NEVER = 2;</code>
     */
    public static final int NEVER_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SqlActivationPolicy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SqlActivationPolicy forNumber(int value) {
      switch (value) {
        case 0:
          return SQL_ACTIVATION_POLICY_UNSPECIFIED;
        case 1:
          return ALWAYS;
        case 2:
          return NEVER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SqlActivationPolicy>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SqlActivationPolicy>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SqlActivationPolicy>() {
              public SqlActivationPolicy findValueByNumber(int number) {
                return SqlActivationPolicy.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.CloudSqlSettings.getDescriptor().getEnumTypes().get(0);
    }

    private static final SqlActivationPolicy[] VALUES = values();

    public static SqlActivationPolicy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SqlActivationPolicy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy)
  }

  /**
   *
   *
   * <pre>
   * The storage options for Cloud SQL databases.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType}
   */
  public enum SqlDataDiskType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>SQL_DATA_DISK_TYPE_UNSPECIFIED = 0;</code>
     */
    SQL_DATA_DISK_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * SSD disk.
     * </pre>
     *
     * <code>PD_SSD = 1;</code>
     */
    PD_SSD(1),
    /**
     *
     *
     * <pre>
     * HDD disk.
     * </pre>
     *
     * <code>PD_HDD = 2;</code>
     */
    PD_HDD(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>SQL_DATA_DISK_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int SQL_DATA_DISK_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * SSD disk.
     * </pre>
     *
     * <code>PD_SSD = 1;</code>
     */
    public static final int PD_SSD_VALUE = 1;
    /**
     *
     *
     * <pre>
     * HDD disk.
     * </pre>
     *
     * <code>PD_HDD = 2;</code>
     */
    public static final int PD_HDD_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SqlDataDiskType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SqlDataDiskType forNumber(int value) {
      switch (value) {
        case 0:
          return SQL_DATA_DISK_TYPE_UNSPECIFIED;
        case 1:
          return PD_SSD;
        case 2:
          return PD_HDD;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SqlDataDiskType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SqlDataDiskType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SqlDataDiskType>() {
              public SqlDataDiskType findValueByNumber(int number) {
                return SqlDataDiskType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.CloudSqlSettings.getDescriptor().getEnumTypes().get(1);
    }

    private static final SqlDataDiskType[] VALUES = values();

    public static SqlDataDiskType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SqlDataDiskType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType)
  }

  /**
   *
   *
   * <pre>
   * The database engine type and version.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion}
   */
  public enum SqlDatabaseVersion implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified version.
     * </pre>
     *
     * <code>SQL_DATABASE_VERSION_UNSPECIFIED = 0;</code>
     */
    SQL_DATABASE_VERSION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * MySQL 5.6.
     * </pre>
     *
     * <code>MYSQL_5_6 = 1;</code>
     */
    MYSQL_5_6(1),
    /**
     *
     *
     * <pre>
     * MySQL 5.7.
     * </pre>
     *
     * <code>MYSQL_5_7 = 2;</code>
     */
    MYSQL_5_7(2),
    /**
     *
     *
     * <pre>
     * PostgreSQL 9.6.
     * </pre>
     *
     * <code>POSTGRES_9_6 = 3;</code>
     */
    POSTGRES_9_6(3),
    /**
     *
     *
     * <pre>
     * PostgreSQL 11.
     * </pre>
     *
     * <code>POSTGRES_11 = 4;</code>
     */
    POSTGRES_11(4),
    /**
     *
     *
     * <pre>
     * PostgreSQL 10.
     * </pre>
     *
     * <code>POSTGRES_10 = 5;</code>
     */
    POSTGRES_10(5),
    /**
     *
     *
     * <pre>
     * MySQL 8.0.
     * </pre>
     *
     * <code>MYSQL_8_0 = 6;</code>
     */
    MYSQL_8_0(6),
    /**
     *
     *
     * <pre>
     * PostgreSQL 12.
     * </pre>
     *
     * <code>POSTGRES_12 = 7;</code>
     */
    POSTGRES_12(7),
    /**
     *
     *
     * <pre>
     * PostgreSQL 13.
     * </pre>
     *
     * <code>POSTGRES_13 = 8;</code>
     */
    POSTGRES_13(8),
    /**
     *
     *
     * <pre>
     * PostgreSQL 14.
     * </pre>
     *
     * <code>POSTGRES_14 = 17;</code>
     */
    POSTGRES_14(17),
    /**
     *
     *
     * <pre>
     * PostgreSQL 15.
     * </pre>
     *
     * <code>POSTGRES_15 = 18;</code>
     */
    POSTGRES_15(18),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified version.
     * </pre>
     *
     * <code>SQL_DATABASE_VERSION_UNSPECIFIED = 0;</code>
     */
    public static final int SQL_DATABASE_VERSION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * MySQL 5.6.
     * </pre>
     *
     * <code>MYSQL_5_6 = 1;</code>
     */
    public static final int MYSQL_5_6_VALUE = 1;
    /**
     *
     *
     * <pre>
     * MySQL 5.7.
     * </pre>
     *
     * <code>MYSQL_5_7 = 2;</code>
     */
    public static final int MYSQL_5_7_VALUE = 2;
    /**
     *
     *
     * <pre>
     * PostgreSQL 9.6.
     * </pre>
     *
     * <code>POSTGRES_9_6 = 3;</code>
     */
    public static final int POSTGRES_9_6_VALUE = 3;
    /**
     *
     *
     * <pre>
     * PostgreSQL 11.
     * </pre>
     *
     * <code>POSTGRES_11 = 4;</code>
     */
    public static final int POSTGRES_11_VALUE = 4;
    /**
     *
     *
     * <pre>
     * PostgreSQL 10.
     * </pre>
     *
     * <code>POSTGRES_10 = 5;</code>
     */
    public static final int POSTGRES_10_VALUE = 5;
    /**
     *
     *
     * <pre>
     * MySQL 8.0.
     * </pre>
     *
     * <code>MYSQL_8_0 = 6;</code>
     */
    public static final int MYSQL_8_0_VALUE = 6;
    /**
     *
     *
     * <pre>
     * PostgreSQL 12.
     * </pre>
     *
     * <code>POSTGRES_12 = 7;</code>
     */
    public static final int POSTGRES_12_VALUE = 7;
    /**
     *
     *
     * <pre>
     * PostgreSQL 13.
     * </pre>
     *
     * <code>POSTGRES_13 = 8;</code>
     */
    public static final int POSTGRES_13_VALUE = 8;
    /**
     *
     *
     * <pre>
     * PostgreSQL 14.
     * </pre>
     *
     * <code>POSTGRES_14 = 17;</code>
     */
    public static final int POSTGRES_14_VALUE = 17;
    /**
     *
     *
     * <pre>
     * PostgreSQL 15.
     * </pre>
     *
     * <code>POSTGRES_15 = 18;</code>
     */
    public static final int POSTGRES_15_VALUE = 18;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SqlDatabaseVersion valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SqlDatabaseVersion forNumber(int value) {
      switch (value) {
        case 0:
          return SQL_DATABASE_VERSION_UNSPECIFIED;
        case 1:
          return MYSQL_5_6;
        case 2:
          return MYSQL_5_7;
        case 3:
          return POSTGRES_9_6;
        case 4:
          return POSTGRES_11;
        case 5:
          return POSTGRES_10;
        case 6:
          return MYSQL_8_0;
        case 7:
          return POSTGRES_12;
        case 8:
          return POSTGRES_13;
        case 17:
          return POSTGRES_14;
        case 18:
          return POSTGRES_15;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SqlDatabaseVersion>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SqlDatabaseVersion>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SqlDatabaseVersion>() {
              public SqlDatabaseVersion findValueByNumber(int number) {
                return SqlDatabaseVersion.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.CloudSqlSettings.getDescriptor().getEnumTypes().get(2);
    }

    private static final SqlDatabaseVersion[] VALUES = values();

    public static SqlDatabaseVersion valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SqlDatabaseVersion(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion)
  }

  /**
   *
   *
   * <pre>
   * The availability type of the given Cloud SQL instance.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType}
   */
  public enum SqlAvailabilityType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * This is an unknown Availability type.
     * </pre>
     *
     * <code>SQL_AVAILABILITY_TYPE_UNSPECIFIED = 0;</code>
     */
    SQL_AVAILABILITY_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Zonal availablility instance.
     * </pre>
     *
     * <code>ZONAL = 1;</code>
     */
    ZONAL(1),
    /**
     *
     *
     * <pre>
     * Regional availability instance.
     * </pre>
     *
     * <code>REGIONAL = 2;</code>
     */
    REGIONAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * This is an unknown Availability type.
     * </pre>
     *
     * <code>SQL_AVAILABILITY_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int SQL_AVAILABILITY_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Zonal availablility instance.
     * </pre>
     *
     * <code>ZONAL = 1;</code>
     */
    public static final int ZONAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Regional availability instance.
     * </pre>
     *
     * <code>REGIONAL = 2;</code>
     */
    public static final int REGIONAL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SqlAvailabilityType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SqlAvailabilityType forNumber(int value) {
      switch (value) {
        case 0:
          return SQL_AVAILABILITY_TYPE_UNSPECIFIED;
        case 1:
          return ZONAL;
        case 2:
          return REGIONAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SqlAvailabilityType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SqlAvailabilityType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SqlAvailabilityType>() {
              public SqlAvailabilityType findValueByNumber(int number) {
                return SqlAvailabilityType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.CloudSqlSettings.getDescriptor().getEnumTypes().get(3);
    }

    private static final SqlAvailabilityType[] VALUES = values();

    public static SqlAvailabilityType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SqlAvailabilityType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType)
  }

  /**
   *
   *
   * <pre>
   * The edition of the given Cloud SQL instance.
   * Can be ENTERPRISE or ENTERPRISE_PLUS.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.CloudSqlSettings.Edition}
   */
  public enum Edition implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The instance did not specify the edition.
     * </pre>
     *
     * <code>EDITION_UNSPECIFIED = 0;</code>
     */
    EDITION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The instance is an enterprise edition.
     * </pre>
     *
     * <code>ENTERPRISE = 2;</code>
     */
    ENTERPRISE(2),
    /**
     *
     *
     * <pre>
     * The instance is an enterprise plus edition.
     * </pre>
     *
     * <code>ENTERPRISE_PLUS = 3;</code>
     */
    ENTERPRISE_PLUS(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The instance did not specify the edition.
     * </pre>
     *
     * <code>EDITION_UNSPECIFIED = 0;</code>
     */
    public static final int EDITION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The instance is an enterprise edition.
     * </pre>
     *
     * <code>ENTERPRISE = 2;</code>
     */
    public static final int ENTERPRISE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The instance is an enterprise plus edition.
     * </pre>
     *
     * <code>ENTERPRISE_PLUS = 3;</code>
     */
    public static final int ENTERPRISE_PLUS_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Edition valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Edition forNumber(int value) {
      switch (value) {
        case 0:
          return EDITION_UNSPECIFIED;
        case 2:
          return ENTERPRISE;
        case 3:
          return ENTERPRISE_PLUS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Edition> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Edition> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Edition>() {
          public Edition findValueByNumber(int number) {
            return Edition.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.CloudSqlSettings.getDescriptor().getEnumTypes().get(4);
    }

    private static final Edition[] VALUES = values();

    public static Edition valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Edition(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.CloudSqlSettings.Edition)
  }

  private int bitField0_;
  public static final int DATABASE_VERSION_FIELD_NUMBER = 1;
  private int databaseVersion_ = 0;
  /**
   *
   *
   * <pre>
   * The database engine type and version.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion database_version = 1;
   * </code>
   *
   * @return The enum numeric value on the wire for databaseVersion.
   */
  @java.lang.Override
  public int getDatabaseVersionValue() {
    return databaseVersion_;
  }
  /**
   *
   *
   * <pre>
   * The database engine type and version.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion database_version = 1;
   * </code>
   *
   * @return The databaseVersion.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion getDatabaseVersion() {
    com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion result =
        com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion.forNumber(
            databaseVersion_);
    return result == null
        ? com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion.UNRECOGNIZED
        : result;
  }

  public static final int USER_LABELS_FIELD_NUMBER = 2;

  private static final class UserLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.clouddms.v1.ClouddmsResourcesProto
                .internal_static_google_cloud_clouddms_v1_CloudSqlSettings_UserLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetUserLabels() {
    if (userLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(UserLabelsDefaultEntryHolder.defaultEntry);
    }
    return userLabels_;
  }

  public int getUserLabelsCount() {
    return internalGetUserLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for a Cloud SQL instance to use to annotate any related
   * underlying resources such as Compute Engine VMs.
   * An object containing a list of "key": "value" pairs.
   *
   * Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 2;</code>
   */
  @java.lang.Override
  public boolean containsUserLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetUserLabels().getMap().containsKey(key);
  }
  /** Use {@link #getUserLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
    return getUserLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for a Cloud SQL instance to use to annotate any related
   * underlying resources such as Compute Engine VMs.
   * An object containing a list of "key": "value" pairs.
   *
   * Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
    return internalGetUserLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for a Cloud SQL instance to use to annotate any related
   * underlying resources such as Compute Engine VMs.
   * An object containing a list of "key": "value" pairs.
   *
   * Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 2;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getUserLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The resource labels for a Cloud SQL instance to use to annotate any related
   * underlying resources such as Compute Engine VMs.
   * An object containing a list of "key": "value" pairs.
   *
   * Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 2;</code>
   */
  @java.lang.Override
  public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int TIER_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tier_ = "";
  /**
   *
   *
   * <pre>
   * The tier (or machine type) for this instance, for example:
   * `db-n1-standard-1` (MySQL instances) or
   * `db-custom-1-3840` (PostgreSQL instances).
   * For more information, see
   * [Cloud SQL Instance
   * Settings](https://cloud.google.com/sql/docs/mysql/instance-settings).
   * </pre>
   *
   * <code>string tier = 3;</code>
   *
   * @return The tier.
   */
  @java.lang.Override
  public java.lang.String getTier() {
    java.lang.Object ref = tier_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tier_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The tier (or machine type) for this instance, for example:
   * `db-n1-standard-1` (MySQL instances) or
   * `db-custom-1-3840` (PostgreSQL instances).
   * For more information, see
   * [Cloud SQL Instance
   * Settings](https://cloud.google.com/sql/docs/mysql/instance-settings).
   * </pre>
   *
   * <code>string tier = 3;</code>
   *
   * @return The bytes for tier.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTierBytes() {
    java.lang.Object ref = tier_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tier_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STORAGE_AUTO_RESIZE_LIMIT_FIELD_NUMBER = 4;
  private com.google.protobuf.Int64Value storageAutoResizeLimit_;
  /**
   *
   *
   * <pre>
   * The maximum size to which storage capacity can be automatically increased.
   * The default value is 0, which specifies that there is no limit.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value storage_auto_resize_limit = 4;</code>
   *
   * @return Whether the storageAutoResizeLimit field is set.
   */
  @java.lang.Override
  public boolean hasStorageAutoResizeLimit() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The maximum size to which storage capacity can be automatically increased.
   * The default value is 0, which specifies that there is no limit.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value storage_auto_resize_limit = 4;</code>
   *
   * @return The storageAutoResizeLimit.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getStorageAutoResizeLimit() {
    return storageAutoResizeLimit_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : storageAutoResizeLimit_;
  }
  /**
   *
   *
   * <pre>
   * The maximum size to which storage capacity can be automatically increased.
   * The default value is 0, which specifies that there is no limit.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value storage_auto_resize_limit = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getStorageAutoResizeLimitOrBuilder() {
    return storageAutoResizeLimit_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : storageAutoResizeLimit_;
  }

  public static final int ACTIVATION_POLICY_FIELD_NUMBER = 5;
  private int activationPolicy_ = 0;
  /**
   *
   *
   * <pre>
   * The activation policy specifies when the instance is activated; it is
   * applicable only when the instance state is 'RUNNABLE'. Valid values:
   *
   * 'ALWAYS': The instance is on, and remains so even in
   * the absence of connection requests.
   *
   * `NEVER`: The instance is off; it is not activated, even if a
   * connection request arrives.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy activation_policy = 5;
   * </code>
   *
   * @return The enum numeric value on the wire for activationPolicy.
   */
  @java.lang.Override
  public int getActivationPolicyValue() {
    return activationPolicy_;
  }
  /**
   *
   *
   * <pre>
   * The activation policy specifies when the instance is activated; it is
   * applicable only when the instance state is 'RUNNABLE'. Valid values:
   *
   * 'ALWAYS': The instance is on, and remains so even in
   * the absence of connection requests.
   *
   * `NEVER`: The instance is off; it is not activated, even if a
   * connection request arrives.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy activation_policy = 5;
   * </code>
   *
   * @return The activationPolicy.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy getActivationPolicy() {
    com.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy result =
        com.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy.forNumber(
            activationPolicy_);
    return result == null
        ? com.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy.UNRECOGNIZED
        : result;
  }

  public static final int IP_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.clouddms.v1.SqlIpConfig ipConfig_;
  /**
   *
   *
   * <pre>
   * The settings for IP Management. This allows to enable or disable the
   * instance IP and manage which external networks can connect to the instance.
   * The IPv4 address cannot be disabled.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SqlIpConfig ip_config = 6;</code>
   *
   * @return Whether the ipConfig field is set.
   */
  @java.lang.Override
  public boolean hasIpConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The settings for IP Management. This allows to enable or disable the
   * instance IP and manage which external networks can connect to the instance.
   * The IPv4 address cannot be disabled.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SqlIpConfig ip_config = 6;</code>
   *
   * @return The ipConfig.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SqlIpConfig getIpConfig() {
    return ipConfig_ == null
        ? com.google.cloud.clouddms.v1.SqlIpConfig.getDefaultInstance()
        : ipConfig_;
  }
  /**
   *
   *
   * <pre>
   * The settings for IP Management. This allows to enable or disable the
   * instance IP and manage which external networks can connect to the instance.
   * The IPv4 address cannot be disabled.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SqlIpConfig ip_config = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SqlIpConfigOrBuilder getIpConfigOrBuilder() {
    return ipConfig_ == null
        ? com.google.cloud.clouddms.v1.SqlIpConfig.getDefaultInstance()
        : ipConfig_;
  }

  public static final int AUTO_STORAGE_INCREASE_FIELD_NUMBER = 7;
  private com.google.protobuf.BoolValue autoStorageIncrease_;
  /**
   *
   *
   * <pre>
   * [default: ON] If you enable this setting, Cloud SQL checks your available
   * storage every 30 seconds. If the available storage falls below a threshold
   * size, Cloud SQL automatically adds additional storage capacity. If the
   * available storage repeatedly falls below the threshold size, Cloud SQL
   * continues to add storage until it reaches the maximum of 30 TB.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue auto_storage_increase = 7;</code>
   *
   * @return Whether the autoStorageIncrease field is set.
   */
  @java.lang.Override
  public boolean hasAutoStorageIncrease() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * [default: ON] If you enable this setting, Cloud SQL checks your available
   * storage every 30 seconds. If the available storage falls below a threshold
   * size, Cloud SQL automatically adds additional storage capacity. If the
   * available storage repeatedly falls below the threshold size, Cloud SQL
   * continues to add storage until it reaches the maximum of 30 TB.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue auto_storage_increase = 7;</code>
   *
   * @return The autoStorageIncrease.
   */
  @java.lang.Override
  public com.google.protobuf.BoolValue getAutoStorageIncrease() {
    return autoStorageIncrease_ == null
        ? com.google.protobuf.BoolValue.getDefaultInstance()
        : autoStorageIncrease_;
  }
  /**
   *
   *
   * <pre>
   * [default: ON] If you enable this setting, Cloud SQL checks your available
   * storage every 30 seconds. If the available storage falls below a threshold
   * size, Cloud SQL automatically adds additional storage capacity. If the
   * available storage repeatedly falls below the threshold size, Cloud SQL
   * continues to add storage until it reaches the maximum of 30 TB.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue auto_storage_increase = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.BoolValueOrBuilder getAutoStorageIncreaseOrBuilder() {
    return autoStorageIncrease_ == null
        ? com.google.protobuf.BoolValue.getDefaultInstance()
        : autoStorageIncrease_;
  }

  public static final int DATABASE_FLAGS_FIELD_NUMBER = 8;

  private static final class DatabaseFlagsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.clouddms.v1.ClouddmsResourcesProto
                .internal_static_google_cloud_clouddms_v1_CloudSqlSettings_DatabaseFlagsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> databaseFlags_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetDatabaseFlags() {
    if (databaseFlags_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          DatabaseFlagsDefaultEntryHolder.defaultEntry);
    }
    return databaseFlags_;
  }

  public int getDatabaseFlagsCount() {
    return internalGetDatabaseFlags().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The database flags passed to the Cloud SQL instance at startup.
   * An object containing a list of "key": value pairs.
   * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
   * </pre>
   *
   * <code>map&lt;string, string&gt; database_flags = 8;</code>
   */
  @java.lang.Override
  public boolean containsDatabaseFlags(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetDatabaseFlags().getMap().containsKey(key);
  }
  /** Use {@link #getDatabaseFlagsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getDatabaseFlags() {
    return getDatabaseFlagsMap();
  }
  /**
   *
   *
   * <pre>
   * The database flags passed to the Cloud SQL instance at startup.
   * An object containing a list of "key": value pairs.
   * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
   * </pre>
   *
   * <code>map&lt;string, string&gt; database_flags = 8;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getDatabaseFlagsMap() {
    return internalGetDatabaseFlags().getMap();
  }
  /**
   *
   *
   * <pre>
   * The database flags passed to the Cloud SQL instance at startup.
   * An object containing a list of "key": value pairs.
   * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
   * </pre>
   *
   * <code>map&lt;string, string&gt; database_flags = 8;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getDatabaseFlagsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDatabaseFlags().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The database flags passed to the Cloud SQL instance at startup.
   * An object containing a list of "key": value pairs.
   * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
   * </pre>
   *
   * <code>map&lt;string, string&gt; database_flags = 8;</code>
   */
  @java.lang.Override
  public java.lang.String getDatabaseFlagsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDatabaseFlags().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DATA_DISK_TYPE_FIELD_NUMBER = 9;
  private int dataDiskType_ = 0;
  /**
   *
   *
   * <pre>
   * The type of storage: `PD_SSD` (default) or `PD_HDD`.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType data_disk_type = 9;</code>
   *
   * @return The enum numeric value on the wire for dataDiskType.
   */
  @java.lang.Override
  public int getDataDiskTypeValue() {
    return dataDiskType_;
  }
  /**
   *
   *
   * <pre>
   * The type of storage: `PD_SSD` (default) or `PD_HDD`.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType data_disk_type = 9;</code>
   *
   * @return The dataDiskType.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType getDataDiskType() {
    com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType result =
        com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType.forNumber(dataDiskType_);
    return result == null
        ? com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType.UNRECOGNIZED
        : result;
  }

  public static final int DATA_DISK_SIZE_GB_FIELD_NUMBER = 10;
  private com.google.protobuf.Int64Value dataDiskSizeGb_;
  /**
   *
   *
   * <pre>
   * The storage capacity available to the database, in GB.
   * The minimum (and default) size is 10GB.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value data_disk_size_gb = 10;</code>
   *
   * @return Whether the dataDiskSizeGb field is set.
   */
  @java.lang.Override
  public boolean hasDataDiskSizeGb() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The storage capacity available to the database, in GB.
   * The minimum (and default) size is 10GB.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value data_disk_size_gb = 10;</code>
   *
   * @return The dataDiskSizeGb.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getDataDiskSizeGb() {
    return dataDiskSizeGb_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : dataDiskSizeGb_;
  }
  /**
   *
   *
   * <pre>
   * The storage capacity available to the database, in GB.
   * The minimum (and default) size is 10GB.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value data_disk_size_gb = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getDataDiskSizeGbOrBuilder() {
    return dataDiskSizeGb_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : dataDiskSizeGb_;
  }

  public static final int ZONE_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";
  /**
   *
   *
   * <pre>
   * The Google Cloud Platform zone where your Cloud SQL database instance is
   * located.
   * </pre>
   *
   * <code>string zone = 11;</code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Platform zone where your Cloud SQL database instance is
   * located.
   * </pre>
   *
   * <code>string zone = 11;</code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECONDARY_ZONE_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object secondaryZone_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The Google Cloud Platform zone where the failover Cloud SQL
   * database instance is located. Used when the Cloud SQL database availability
   * type is REGIONAL (i.e. multiple zones / highly available).
   * </pre>
   *
   * <code>string secondary_zone = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The secondaryZone.
   */
  @java.lang.Override
  public java.lang.String getSecondaryZone() {
    java.lang.Object ref = secondaryZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      secondaryZone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Google Cloud Platform zone where the failover Cloud SQL
   * database instance is located. Used when the Cloud SQL database availability
   * type is REGIONAL (i.e. multiple zones / highly available).
   * </pre>
   *
   * <code>string secondary_zone = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for secondaryZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSecondaryZoneBytes() {
    java.lang.Object ref = secondaryZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      secondaryZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_ID_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceId_ = "";
  /**
   *
   *
   * <pre>
   * The Database Migration Service source connection profile ID,
   * in the format:
   * `projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID`
   * </pre>
   *
   * <code>string source_id = 12;</code>
   *
   * @return The sourceId.
   */
  @java.lang.Override
  public java.lang.String getSourceId() {
    java.lang.Object ref = sourceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Database Migration Service source connection profile ID,
   * in the format:
   * `projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID`
   * </pre>
   *
   * <code>string source_id = 12;</code>
   *
   * @return The bytes for sourceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceIdBytes() {
    java.lang.Object ref = sourceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROOT_PASSWORD_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rootPassword_ = "";
  /**
   *
   *
   * <pre>
   * Input only. Initial root password.
   * </pre>
   *
   * <code>string root_password = 13 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The rootPassword.
   */
  @java.lang.Override
  public java.lang.String getRootPassword() {
    java.lang.Object ref = rootPassword_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rootPassword_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Input only. Initial root password.
   * </pre>
   *
   * <code>string root_password = 13 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The bytes for rootPassword.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRootPasswordBytes() {
    java.lang.Object ref = rootPassword_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rootPassword_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROOT_PASSWORD_SET_FIELD_NUMBER = 14;
  private boolean rootPasswordSet_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Indicates If this connection profile root password is stored.
   * </pre>
   *
   * <code>bool root_password_set = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The rootPasswordSet.
   */
  @java.lang.Override
  public boolean getRootPasswordSet() {
    return rootPasswordSet_;
  }

  public static final int COLLATION_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object collation_ = "";
  /**
   *
   *
   * <pre>
   * The Cloud SQL default instance level collation.
   * </pre>
   *
   * <code>string collation = 15;</code>
   *
   * @return The collation.
   */
  @java.lang.Override
  public java.lang.String getCollation() {
    java.lang.Object ref = collation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      collation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Cloud SQL default instance level collation.
   * </pre>
   *
   * <code>string collation = 15;</code>
   *
   * @return The bytes for collation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCollationBytes() {
    java.lang.Object ref = collation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      collation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CMEK_KEY_NAME_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cmekKeyName_ = "";
  /**
   *
   *
   * <pre>
   * The KMS key name used for the csql instance.
   * </pre>
   *
   * <code>string cmek_key_name = 16;</code>
   *
   * @return The cmekKeyName.
   */
  @java.lang.Override
  public java.lang.String getCmekKeyName() {
    java.lang.Object ref = cmekKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cmekKeyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The KMS key name used for the csql instance.
   * </pre>
   *
   * <code>string cmek_key_name = 16;</code>
   *
   * @return The bytes for cmekKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCmekKeyNameBytes() {
    java.lang.Object ref = cmekKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cmekKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AVAILABILITY_TYPE_FIELD_NUMBER = 17;
  private int availabilityType_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Availability type. Potential values:
   * *  `ZONAL`: The instance serves data from only one zone. Outages in that
   * zone affect data availability.
   * *  `REGIONAL`: The instance can serve data from more than one zone in a
   * region (it is highly available).
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType availability_type = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for availabilityType.
   */
  @java.lang.Override
  public int getAvailabilityTypeValue() {
    return availabilityType_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Availability type. Potential values:
   * *  `ZONAL`: The instance serves data from only one zone. Outages in that
   * zone affect data availability.
   * *  `REGIONAL`: The instance can serve data from more than one zone in a
   * region (it is highly available).
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType availability_type = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The availabilityType.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType getAvailabilityType() {
    com.google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType result =
        com.google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType.forNumber(
            availabilityType_);
    return result == null
        ? com.google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType.UNRECOGNIZED
        : result;
  }

  public static final int EDITION_FIELD_NUMBER = 19;
  private int edition_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The edition of the given Cloud SQL instance.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.CloudSqlSettings.Edition edition = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for edition.
   */
  @java.lang.Override
  public int getEditionValue() {
    return edition_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The edition of the given Cloud SQL instance.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.CloudSqlSettings.Edition edition = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The edition.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.CloudSqlSettings.Edition getEdition() {
    com.google.cloud.clouddms.v1.CloudSqlSettings.Edition result =
        com.google.cloud.clouddms.v1.CloudSqlSettings.Edition.forNumber(edition_);
    return result == null
        ? com.google.cloud.clouddms.v1.CloudSqlSettings.Edition.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (databaseVersion_
        != com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion
            .SQL_DATABASE_VERSION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, databaseVersion_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetUserLabels(), UserLabelsDefaultEntryHolder.defaultEntry, 2);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tier_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tier_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getStorageAutoResizeLimit());
    }
    if (activationPolicy_
        != com.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy
            .SQL_ACTIVATION_POLICY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, activationPolicy_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getIpConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getAutoStorageIncrease());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetDatabaseFlags(), DatabaseFlagsDefaultEntryHolder.defaultEntry, 8);
    if (dataDiskType_
        != com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType
            .SQL_DATA_DISK_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(9, dataDiskType_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(10, getDataDiskSizeGb());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, zone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, sourceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rootPassword_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, rootPassword_);
    }
    if (rootPasswordSet_ != false) {
      output.writeBool(14, rootPasswordSet_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(collation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, collation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cmekKeyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, cmekKeyName_);
    }
    if (availabilityType_
        != com.google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType
            .SQL_AVAILABILITY_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(17, availabilityType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(secondaryZone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, secondaryZone_);
    }
    if (edition_
        != com.google.cloud.clouddms.v1.CloudSqlSettings.Edition.EDITION_UNSPECIFIED.getNumber()) {
      output.writeEnum(19, edition_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (databaseVersion_
        != com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion
            .SQL_DATABASE_VERSION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, databaseVersion_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetUserLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
          UserLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, userLabels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tier_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, tier_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStorageAutoResizeLimit());
    }
    if (activationPolicy_
        != com.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy
            .SQL_ACTIVATION_POLICY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, activationPolicy_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getIpConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getAutoStorageIncrease());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetDatabaseFlags().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> databaseFlags__ =
          DatabaseFlagsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, databaseFlags__);
    }
    if (dataDiskType_
        != com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType
            .SQL_DATA_DISK_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, dataDiskType_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getDataDiskSizeGb());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, zone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, sourceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rootPassword_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, rootPassword_);
    }
    if (rootPasswordSet_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(14, rootPasswordSet_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(collation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, collation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cmekKeyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, cmekKeyName_);
    }
    if (availabilityType_
        != com.google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType
            .SQL_AVAILABILITY_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(17, availabilityType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(secondaryZone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, secondaryZone_);
    }
    if (edition_
        != com.google.cloud.clouddms.v1.CloudSqlSettings.Edition.EDITION_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(19, edition_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.CloudSqlSettings)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.CloudSqlSettings other =
        (com.google.cloud.clouddms.v1.CloudSqlSettings) obj;

    if (databaseVersion_ != other.databaseVersion_) return false;
    if (!internalGetUserLabels().equals(other.internalGetUserLabels())) return false;
    if (!getTier().equals(other.getTier())) return false;
    if (hasStorageAutoResizeLimit() != other.hasStorageAutoResizeLimit()) return false;
    if (hasStorageAutoResizeLimit()) {
      if (!getStorageAutoResizeLimit().equals(other.getStorageAutoResizeLimit())) return false;
    }
    if (activationPolicy_ != other.activationPolicy_) return false;
    if (hasIpConfig() != other.hasIpConfig()) return false;
    if (hasIpConfig()) {
      if (!getIpConfig().equals(other.getIpConfig())) return false;
    }
    if (hasAutoStorageIncrease() != other.hasAutoStorageIncrease()) return false;
    if (hasAutoStorageIncrease()) {
      if (!getAutoStorageIncrease().equals(other.getAutoStorageIncrease())) return false;
    }
    if (!internalGetDatabaseFlags().equals(other.internalGetDatabaseFlags())) return false;
    if (dataDiskType_ != other.dataDiskType_) return false;
    if (hasDataDiskSizeGb() != other.hasDataDiskSizeGb()) return false;
    if (hasDataDiskSizeGb()) {
      if (!getDataDiskSizeGb().equals(other.getDataDiskSizeGb())) return false;
    }
    if (!getZone().equals(other.getZone())) return false;
    if (!getSecondaryZone().equals(other.getSecondaryZone())) return false;
    if (!getSourceId().equals(other.getSourceId())) return false;
    if (!getRootPassword().equals(other.getRootPassword())) return false;
    if (getRootPasswordSet() != other.getRootPasswordSet()) return false;
    if (!getCollation().equals(other.getCollation())) return false;
    if (!getCmekKeyName().equals(other.getCmekKeyName())) return false;
    if (availabilityType_ != other.availabilityType_) return false;
    if (edition_ != other.edition_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATABASE_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + databaseVersion_;
    if (!internalGetUserLabels().getMap().isEmpty()) {
      hash = (37 * hash) + USER_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetUserLabels().hashCode();
    }
    hash = (37 * hash) + TIER_FIELD_NUMBER;
    hash = (53 * hash) + getTier().hashCode();
    if (hasStorageAutoResizeLimit()) {
      hash = (37 * hash) + STORAGE_AUTO_RESIZE_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getStorageAutoResizeLimit().hashCode();
    }
    hash = (37 * hash) + ACTIVATION_POLICY_FIELD_NUMBER;
    hash = (53 * hash) + activationPolicy_;
    if (hasIpConfig()) {
      hash = (37 * hash) + IP_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getIpConfig().hashCode();
    }
    if (hasAutoStorageIncrease()) {
      hash = (37 * hash) + AUTO_STORAGE_INCREASE_FIELD_NUMBER;
      hash = (53 * hash) + getAutoStorageIncrease().hashCode();
    }
    if (!internalGetDatabaseFlags().getMap().isEmpty()) {
      hash = (37 * hash) + DATABASE_FLAGS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetDatabaseFlags().hashCode();
    }
    hash = (37 * hash) + DATA_DISK_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + dataDiskType_;
    if (hasDataDiskSizeGb()) {
      hash = (37 * hash) + DATA_DISK_SIZE_GB_FIELD_NUMBER;
      hash = (53 * hash) + getDataDiskSizeGb().hashCode();
    }
    hash = (37 * hash) + ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getZone().hashCode();
    hash = (37 * hash) + SECONDARY_ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getSecondaryZone().hashCode();
    hash = (37 * hash) + SOURCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getSourceId().hashCode();
    hash = (37 * hash) + ROOT_PASSWORD_FIELD_NUMBER;
    hash = (53 * hash) + getRootPassword().hashCode();
    hash = (37 * hash) + ROOT_PASSWORD_SET_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRootPasswordSet());
    hash = (37 * hash) + COLLATION_FIELD_NUMBER;
    hash = (53 * hash) + getCollation().hashCode();
    hash = (37 * hash) + CMEK_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getCmekKeyName().hashCode();
    hash = (37 * hash) + AVAILABILITY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + availabilityType_;
    hash = (37 * hash) + EDITION_FIELD_NUMBER;
    hash = (53 * hash) + edition_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.CloudSqlSettings parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlSettings parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.CloudSqlSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.CloudSqlSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Settings for creating a Cloud SQL database instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.CloudSqlSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.CloudSqlSettings)
      com.google.cloud.clouddms.v1.CloudSqlSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_CloudSqlSettings_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetUserLabels();
        case 8:
          return internalGetDatabaseFlags();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetMutableUserLabels();
        case 8:
          return internalGetMutableDatabaseFlags();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_CloudSqlSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.CloudSqlSettings.class,
              com.google.cloud.clouddms.v1.CloudSqlSettings.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.CloudSqlSettings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStorageAutoResizeLimitFieldBuilder();
        getIpConfigFieldBuilder();
        getAutoStorageIncreaseFieldBuilder();
        getDataDiskSizeGbFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      databaseVersion_ = 0;
      internalGetMutableUserLabels().clear();
      tier_ = "";
      storageAutoResizeLimit_ = null;
      if (storageAutoResizeLimitBuilder_ != null) {
        storageAutoResizeLimitBuilder_.dispose();
        storageAutoResizeLimitBuilder_ = null;
      }
      activationPolicy_ = 0;
      ipConfig_ = null;
      if (ipConfigBuilder_ != null) {
        ipConfigBuilder_.dispose();
        ipConfigBuilder_ = null;
      }
      autoStorageIncrease_ = null;
      if (autoStorageIncreaseBuilder_ != null) {
        autoStorageIncreaseBuilder_.dispose();
        autoStorageIncreaseBuilder_ = null;
      }
      internalGetMutableDatabaseFlags().clear();
      dataDiskType_ = 0;
      dataDiskSizeGb_ = null;
      if (dataDiskSizeGbBuilder_ != null) {
        dataDiskSizeGbBuilder_.dispose();
        dataDiskSizeGbBuilder_ = null;
      }
      zone_ = "";
      secondaryZone_ = "";
      sourceId_ = "";
      rootPassword_ = "";
      rootPasswordSet_ = false;
      collation_ = "";
      cmekKeyName_ = "";
      availabilityType_ = 0;
      edition_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_CloudSqlSettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.CloudSqlSettings getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.CloudSqlSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.CloudSqlSettings build() {
      com.google.cloud.clouddms.v1.CloudSqlSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.CloudSqlSettings buildPartial() {
      com.google.cloud.clouddms.v1.CloudSqlSettings result =
          new com.google.cloud.clouddms.v1.CloudSqlSettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.CloudSqlSettings result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.databaseVersion_ = databaseVersion_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.userLabels_ = internalGetUserLabels();
        result.userLabels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.tier_ = tier_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.storageAutoResizeLimit_ =
            storageAutoResizeLimitBuilder_ == null
                ? storageAutoResizeLimit_
                : storageAutoResizeLimitBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.activationPolicy_ = activationPolicy_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.ipConfig_ = ipConfigBuilder_ == null ? ipConfig_ : ipConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.autoStorageIncrease_ =
            autoStorageIncreaseBuilder_ == null
                ? autoStorageIncrease_
                : autoStorageIncreaseBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.databaseFlags_ = internalGetDatabaseFlags();
        result.databaseFlags_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.dataDiskType_ = dataDiskType_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.dataDiskSizeGb_ =
            dataDiskSizeGbBuilder_ == null ? dataDiskSizeGb_ : dataDiskSizeGbBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.zone_ = zone_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.secondaryZone_ = secondaryZone_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.sourceId_ = sourceId_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.rootPassword_ = rootPassword_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.rootPasswordSet_ = rootPasswordSet_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.collation_ = collation_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.cmekKeyName_ = cmekKeyName_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.availabilityType_ = availabilityType_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.edition_ = edition_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.CloudSqlSettings) {
        return mergeFrom((com.google.cloud.clouddms.v1.CloudSqlSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.CloudSqlSettings other) {
      if (other == com.google.cloud.clouddms.v1.CloudSqlSettings.getDefaultInstance()) return this;
      if (other.databaseVersion_ != 0) {
        setDatabaseVersionValue(other.getDatabaseVersionValue());
      }
      internalGetMutableUserLabels().mergeFrom(other.internalGetUserLabels());
      bitField0_ |= 0x00000002;
      if (!other.getTier().isEmpty()) {
        tier_ = other.tier_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasStorageAutoResizeLimit()) {
        mergeStorageAutoResizeLimit(other.getStorageAutoResizeLimit());
      }
      if (other.activationPolicy_ != 0) {
        setActivationPolicyValue(other.getActivationPolicyValue());
      }
      if (other.hasIpConfig()) {
        mergeIpConfig(other.getIpConfig());
      }
      if (other.hasAutoStorageIncrease()) {
        mergeAutoStorageIncrease(other.getAutoStorageIncrease());
      }
      internalGetMutableDatabaseFlags().mergeFrom(other.internalGetDatabaseFlags());
      bitField0_ |= 0x00000080;
      if (other.dataDiskType_ != 0) {
        setDataDiskTypeValue(other.getDataDiskTypeValue());
      }
      if (other.hasDataDiskSizeGb()) {
        mergeDataDiskSizeGb(other.getDataDiskSizeGb());
      }
      if (!other.getZone().isEmpty()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (!other.getSecondaryZone().isEmpty()) {
        secondaryZone_ = other.secondaryZone_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.getSourceId().isEmpty()) {
        sourceId_ = other.sourceId_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (!other.getRootPassword().isEmpty()) {
        rootPassword_ = other.rootPassword_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.getRootPasswordSet() != false) {
        setRootPasswordSet(other.getRootPasswordSet());
      }
      if (!other.getCollation().isEmpty()) {
        collation_ = other.collation_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (!other.getCmekKeyName().isEmpty()) {
        cmekKeyName_ = other.cmekKeyName_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.availabilityType_ != 0) {
        setAvailabilityTypeValue(other.getAvailabilityTypeValue());
      }
      if (other.edition_ != 0) {
        setEditionValue(other.getEditionValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                databaseVersion_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
                    input.readMessage(
                        UserLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableUserLabels()
                    .getMutableMap()
                    .put(userLabels__.getKey(), userLabels__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                tier_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getStorageAutoResizeLimitFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                activationPolicy_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getIpConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getAutoStorageIncreaseFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> databaseFlags__ =
                    input.readMessage(
                        DatabaseFlagsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableDatabaseFlags()
                    .getMutableMap()
                    .put(databaseFlags__.getKey(), databaseFlags__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                dataDiskType_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 82:
              {
                input.readMessage(getDataDiskSizeGbFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                sourceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 98
            case 106:
              {
                rootPassword_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 106
            case 112:
              {
                rootPasswordSet_ = input.readBool();
                bitField0_ |= 0x00004000;
                break;
              } // case 112
            case 122:
              {
                collation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 122
            case 130:
              {
                cmekKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 130
            case 136:
              {
                availabilityType_ = input.readEnum();
                bitField0_ |= 0x00020000;
                break;
              } // case 136
            case 146:
              {
                secondaryZone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 146
            case 152:
              {
                edition_ = input.readEnum();
                bitField0_ |= 0x00040000;
                break;
              } // case 152
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int databaseVersion_ = 0;
    /**
     *
     *
     * <pre>
     * The database engine type and version.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion database_version = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for databaseVersion.
     */
    @java.lang.Override
    public int getDatabaseVersionValue() {
      return databaseVersion_;
    }
    /**
     *
     *
     * <pre>
     * The database engine type and version.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion database_version = 1;
     * </code>
     *
     * @param value The enum numeric value on the wire for databaseVersion to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseVersionValue(int value) {
      databaseVersion_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database engine type and version.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion database_version = 1;
     * </code>
     *
     * @return The databaseVersion.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion getDatabaseVersion() {
      com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion result =
          com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion.forNumber(
              databaseVersion_);
      return result == null
          ? com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The database engine type and version.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion database_version = 1;
     * </code>
     *
     * @param value The databaseVersion to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseVersion(
        com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      databaseVersion_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database engine type and version.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion database_version = 1;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseVersion() {
      bitField0_ = (bitField0_ & ~0x00000001);
      databaseVersion_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetUserLabels() {
      if (userLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            UserLabelsDefaultEntryHolder.defaultEntry);
      }
      return userLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableUserLabels() {
      if (userLabels_ == null) {
        userLabels_ =
            com.google.protobuf.MapField.newMapField(UserLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!userLabels_.isMutable()) {
        userLabels_ = userLabels_.copy();
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return userLabels_;
    }

    public int getUserLabelsCount() {
      return internalGetUserLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for a Cloud SQL instance to use to annotate any related
     * underlying resources such as Compute Engine VMs.
     * An object containing a list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 2;</code>
     */
    @java.lang.Override
    public boolean containsUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetUserLabels().getMap().containsKey(key);
    }
    /** Use {@link #getUserLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
      return getUserLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for a Cloud SQL instance to use to annotate any related
     * underlying resources such as Compute Engine VMs.
     * An object containing a list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
      return internalGetUserLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for a Cloud SQL instance to use to annotate any related
     * underlying resources such as Compute Engine VMs.
     * An object containing a list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 2;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getUserLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for a Cloud SQL instance to use to annotate any related
     * underlying resources such as Compute Engine VMs.
     * An object containing a list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 2;</code>
     */
    @java.lang.Override
    public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearUserLabels() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableUserLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for a Cloud SQL instance to use to annotate any related
     * underlying resources such as Compute Engine VMs.
     * An object containing a list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 2;</code>
     */
    public Builder removeUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableUserLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableUserLabels() {
      bitField0_ |= 0x00000002;
      return internalGetMutableUserLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for a Cloud SQL instance to use to annotate any related
     * underlying resources such as Compute Engine VMs.
     * An object containing a list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 2;</code>
     */
    public Builder putUserLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableUserLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for a Cloud SQL instance to use to annotate any related
     * underlying resources such as Compute Engine VMs.
     * An object containing a list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 2;</code>
     */
    public Builder putAllUserLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableUserLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    private java.lang.Object tier_ = "";
    /**
     *
     *
     * <pre>
     * The tier (or machine type) for this instance, for example:
     * `db-n1-standard-1` (MySQL instances) or
     * `db-custom-1-3840` (PostgreSQL instances).
     * For more information, see
     * [Cloud SQL Instance
     * Settings](https://cloud.google.com/sql/docs/mysql/instance-settings).
     * </pre>
     *
     * <code>string tier = 3;</code>
     *
     * @return The tier.
     */
    public java.lang.String getTier() {
      java.lang.Object ref = tier_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tier_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The tier (or machine type) for this instance, for example:
     * `db-n1-standard-1` (MySQL instances) or
     * `db-custom-1-3840` (PostgreSQL instances).
     * For more information, see
     * [Cloud SQL Instance
     * Settings](https://cloud.google.com/sql/docs/mysql/instance-settings).
     * </pre>
     *
     * <code>string tier = 3;</code>
     *
     * @return The bytes for tier.
     */
    public com.google.protobuf.ByteString getTierBytes() {
      java.lang.Object ref = tier_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tier_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The tier (or machine type) for this instance, for example:
     * `db-n1-standard-1` (MySQL instances) or
     * `db-custom-1-3840` (PostgreSQL instances).
     * For more information, see
     * [Cloud SQL Instance
     * Settings](https://cloud.google.com/sql/docs/mysql/instance-settings).
     * </pre>
     *
     * <code>string tier = 3;</code>
     *
     * @param value The tier to set.
     * @return This builder for chaining.
     */
    public Builder setTier(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tier_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tier (or machine type) for this instance, for example:
     * `db-n1-standard-1` (MySQL instances) or
     * `db-custom-1-3840` (PostgreSQL instances).
     * For more information, see
     * [Cloud SQL Instance
     * Settings](https://cloud.google.com/sql/docs/mysql/instance-settings).
     * </pre>
     *
     * <code>string tier = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTier() {
      tier_ = getDefaultInstance().getTier();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tier (or machine type) for this instance, for example:
     * `db-n1-standard-1` (MySQL instances) or
     * `db-custom-1-3840` (PostgreSQL instances).
     * For more information, see
     * [Cloud SQL Instance
     * Settings](https://cloud.google.com/sql/docs/mysql/instance-settings).
     * </pre>
     *
     * <code>string tier = 3;</code>
     *
     * @param value The bytes for tier to set.
     * @return This builder for chaining.
     */
    public Builder setTierBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tier_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value storageAutoResizeLimit_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        storageAutoResizeLimitBuilder_;
    /**
     *
     *
     * <pre>
     * The maximum size to which storage capacity can be automatically increased.
     * The default value is 0, which specifies that there is no limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value storage_auto_resize_limit = 4;</code>
     *
     * @return Whether the storageAutoResizeLimit field is set.
     */
    public boolean hasStorageAutoResizeLimit() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The maximum size to which storage capacity can be automatically increased.
     * The default value is 0, which specifies that there is no limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value storage_auto_resize_limit = 4;</code>
     *
     * @return The storageAutoResizeLimit.
     */
    public com.google.protobuf.Int64Value getStorageAutoResizeLimit() {
      if (storageAutoResizeLimitBuilder_ == null) {
        return storageAutoResizeLimit_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : storageAutoResizeLimit_;
      } else {
        return storageAutoResizeLimitBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum size to which storage capacity can be automatically increased.
     * The default value is 0, which specifies that there is no limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value storage_auto_resize_limit = 4;</code>
     */
    public Builder setStorageAutoResizeLimit(com.google.protobuf.Int64Value value) {
      if (storageAutoResizeLimitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        storageAutoResizeLimit_ = value;
      } else {
        storageAutoResizeLimitBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum size to which storage capacity can be automatically increased.
     * The default value is 0, which specifies that there is no limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value storage_auto_resize_limit = 4;</code>
     */
    public Builder setStorageAutoResizeLimit(
        com.google.protobuf.Int64Value.Builder builderForValue) {
      if (storageAutoResizeLimitBuilder_ == null) {
        storageAutoResizeLimit_ = builderForValue.build();
      } else {
        storageAutoResizeLimitBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum size to which storage capacity can be automatically increased.
     * The default value is 0, which specifies that there is no limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value storage_auto_resize_limit = 4;</code>
     */
    public Builder mergeStorageAutoResizeLimit(com.google.protobuf.Int64Value value) {
      if (storageAutoResizeLimitBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && storageAutoResizeLimit_ != null
            && storageAutoResizeLimit_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
          getStorageAutoResizeLimitBuilder().mergeFrom(value);
        } else {
          storageAutoResizeLimit_ = value;
        }
      } else {
        storageAutoResizeLimitBuilder_.mergeFrom(value);
      }
      if (storageAutoResizeLimit_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum size to which storage capacity can be automatically increased.
     * The default value is 0, which specifies that there is no limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value storage_auto_resize_limit = 4;</code>
     */
    public Builder clearStorageAutoResizeLimit() {
      bitField0_ = (bitField0_ & ~0x00000008);
      storageAutoResizeLimit_ = null;
      if (storageAutoResizeLimitBuilder_ != null) {
        storageAutoResizeLimitBuilder_.dispose();
        storageAutoResizeLimitBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum size to which storage capacity can be automatically increased.
     * The default value is 0, which specifies that there is no limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value storage_auto_resize_limit = 4;</code>
     */
    public com.google.protobuf.Int64Value.Builder getStorageAutoResizeLimitBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getStorageAutoResizeLimitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The maximum size to which storage capacity can be automatically increased.
     * The default value is 0, which specifies that there is no limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value storage_auto_resize_limit = 4;</code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getStorageAutoResizeLimitOrBuilder() {
      if (storageAutoResizeLimitBuilder_ != null) {
        return storageAutoResizeLimitBuilder_.getMessageOrBuilder();
      } else {
        return storageAutoResizeLimit_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : storageAutoResizeLimit_;
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum size to which storage capacity can be automatically increased.
     * The default value is 0, which specifies that there is no limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value storage_auto_resize_limit = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getStorageAutoResizeLimitFieldBuilder() {
      if (storageAutoResizeLimitBuilder_ == null) {
        storageAutoResizeLimitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getStorageAutoResizeLimit(), getParentForChildren(), isClean());
        storageAutoResizeLimit_ = null;
      }
      return storageAutoResizeLimitBuilder_;
    }

    private int activationPolicy_ = 0;
    /**
     *
     *
     * <pre>
     * The activation policy specifies when the instance is activated; it is
     * applicable only when the instance state is 'RUNNABLE'. Valid values:
     *
     * 'ALWAYS': The instance is on, and remains so even in
     * the absence of connection requests.
     *
     * `NEVER`: The instance is off; it is not activated, even if a
     * connection request arrives.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy activation_policy = 5;
     * </code>
     *
     * @return The enum numeric value on the wire for activationPolicy.
     */
    @java.lang.Override
    public int getActivationPolicyValue() {
      return activationPolicy_;
    }
    /**
     *
     *
     * <pre>
     * The activation policy specifies when the instance is activated; it is
     * applicable only when the instance state is 'RUNNABLE'. Valid values:
     *
     * 'ALWAYS': The instance is on, and remains so even in
     * the absence of connection requests.
     *
     * `NEVER`: The instance is off; it is not activated, even if a
     * connection request arrives.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy activation_policy = 5;
     * </code>
     *
     * @param value The enum numeric value on the wire for activationPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setActivationPolicyValue(int value) {
      activationPolicy_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The activation policy specifies when the instance is activated; it is
     * applicable only when the instance state is 'RUNNABLE'. Valid values:
     *
     * 'ALWAYS': The instance is on, and remains so even in
     * the absence of connection requests.
     *
     * `NEVER`: The instance is off; it is not activated, even if a
     * connection request arrives.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy activation_policy = 5;
     * </code>
     *
     * @return The activationPolicy.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy getActivationPolicy() {
      com.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy result =
          com.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy.forNumber(
              activationPolicy_);
      return result == null
          ? com.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The activation policy specifies when the instance is activated; it is
     * applicable only when the instance state is 'RUNNABLE'. Valid values:
     *
     * 'ALWAYS': The instance is on, and remains so even in
     * the absence of connection requests.
     *
     * `NEVER`: The instance is off; it is not activated, even if a
     * connection request arrives.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy activation_policy = 5;
     * </code>
     *
     * @param value The activationPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setActivationPolicy(
        com.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      activationPolicy_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The activation policy specifies when the instance is activated; it is
     * applicable only when the instance state is 'RUNNABLE'. Valid values:
     *
     * 'ALWAYS': The instance is on, and remains so even in
     * the absence of connection requests.
     *
     * `NEVER`: The instance is off; it is not activated, even if a
     * connection request arrives.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy activation_policy = 5;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearActivationPolicy() {
      bitField0_ = (bitField0_ & ~0x00000010);
      activationPolicy_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.clouddms.v1.SqlIpConfig ipConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SqlIpConfig,
            com.google.cloud.clouddms.v1.SqlIpConfig.Builder,
            com.google.cloud.clouddms.v1.SqlIpConfigOrBuilder>
        ipConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The settings for IP Management. This allows to enable or disable the
     * instance IP and manage which external networks can connect to the instance.
     * The IPv4 address cannot be disabled.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SqlIpConfig ip_config = 6;</code>
     *
     * @return Whether the ipConfig field is set.
     */
    public boolean hasIpConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The settings for IP Management. This allows to enable or disable the
     * instance IP and manage which external networks can connect to the instance.
     * The IPv4 address cannot be disabled.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SqlIpConfig ip_config = 6;</code>
     *
     * @return The ipConfig.
     */
    public com.google.cloud.clouddms.v1.SqlIpConfig getIpConfig() {
      if (ipConfigBuilder_ == null) {
        return ipConfig_ == null
            ? com.google.cloud.clouddms.v1.SqlIpConfig.getDefaultInstance()
            : ipConfig_;
      } else {
        return ipConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The settings for IP Management. This allows to enable or disable the
     * instance IP and manage which external networks can connect to the instance.
     * The IPv4 address cannot be disabled.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SqlIpConfig ip_config = 6;</code>
     */
    public Builder setIpConfig(com.google.cloud.clouddms.v1.SqlIpConfig value) {
      if (ipConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ipConfig_ = value;
      } else {
        ipConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The settings for IP Management. This allows to enable or disable the
     * instance IP and manage which external networks can connect to the instance.
     * The IPv4 address cannot be disabled.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SqlIpConfig ip_config = 6;</code>
     */
    public Builder setIpConfig(com.google.cloud.clouddms.v1.SqlIpConfig.Builder builderForValue) {
      if (ipConfigBuilder_ == null) {
        ipConfig_ = builderForValue.build();
      } else {
        ipConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The settings for IP Management. This allows to enable or disable the
     * instance IP and manage which external networks can connect to the instance.
     * The IPv4 address cannot be disabled.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SqlIpConfig ip_config = 6;</code>
     */
    public Builder mergeIpConfig(com.google.cloud.clouddms.v1.SqlIpConfig value) {
      if (ipConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && ipConfig_ != null
            && ipConfig_ != com.google.cloud.clouddms.v1.SqlIpConfig.getDefaultInstance()) {
          getIpConfigBuilder().mergeFrom(value);
        } else {
          ipConfig_ = value;
        }
      } else {
        ipConfigBuilder_.mergeFrom(value);
      }
      if (ipConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The settings for IP Management. This allows to enable or disable the
     * instance IP and manage which external networks can connect to the instance.
     * The IPv4 address cannot be disabled.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SqlIpConfig ip_config = 6;</code>
     */
    public Builder clearIpConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      ipConfig_ = null;
      if (ipConfigBuilder_ != null) {
        ipConfigBuilder_.dispose();
        ipConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The settings for IP Management. This allows to enable or disable the
     * instance IP and manage which external networks can connect to the instance.
     * The IPv4 address cannot be disabled.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SqlIpConfig ip_config = 6;</code>
     */
    public com.google.cloud.clouddms.v1.SqlIpConfig.Builder getIpConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getIpConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The settings for IP Management. This allows to enable or disable the
     * instance IP and manage which external networks can connect to the instance.
     * The IPv4 address cannot be disabled.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SqlIpConfig ip_config = 6;</code>
     */
    public com.google.cloud.clouddms.v1.SqlIpConfigOrBuilder getIpConfigOrBuilder() {
      if (ipConfigBuilder_ != null) {
        return ipConfigBuilder_.getMessageOrBuilder();
      } else {
        return ipConfig_ == null
            ? com.google.cloud.clouddms.v1.SqlIpConfig.getDefaultInstance()
            : ipConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The settings for IP Management. This allows to enable or disable the
     * instance IP and manage which external networks can connect to the instance.
     * The IPv4 address cannot be disabled.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SqlIpConfig ip_config = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SqlIpConfig,
            com.google.cloud.clouddms.v1.SqlIpConfig.Builder,
            com.google.cloud.clouddms.v1.SqlIpConfigOrBuilder>
        getIpConfigFieldBuilder() {
      if (ipConfigBuilder_ == null) {
        ipConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.SqlIpConfig,
                com.google.cloud.clouddms.v1.SqlIpConfig.Builder,
                com.google.cloud.clouddms.v1.SqlIpConfigOrBuilder>(
                getIpConfig(), getParentForChildren(), isClean());
        ipConfig_ = null;
      }
      return ipConfigBuilder_;
    }

    private com.google.protobuf.BoolValue autoStorageIncrease_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        autoStorageIncreaseBuilder_;
    /**
     *
     *
     * <pre>
     * [default: ON] If you enable this setting, Cloud SQL checks your available
     * storage every 30 seconds. If the available storage falls below a threshold
     * size, Cloud SQL automatically adds additional storage capacity. If the
     * available storage repeatedly falls below the threshold size, Cloud SQL
     * continues to add storage until it reaches the maximum of 30 TB.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue auto_storage_increase = 7;</code>
     *
     * @return Whether the autoStorageIncrease field is set.
     */
    public boolean hasAutoStorageIncrease() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * [default: ON] If you enable this setting, Cloud SQL checks your available
     * storage every 30 seconds. If the available storage falls below a threshold
     * size, Cloud SQL automatically adds additional storage capacity. If the
     * available storage repeatedly falls below the threshold size, Cloud SQL
     * continues to add storage until it reaches the maximum of 30 TB.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue auto_storage_increase = 7;</code>
     *
     * @return The autoStorageIncrease.
     */
    public com.google.protobuf.BoolValue getAutoStorageIncrease() {
      if (autoStorageIncreaseBuilder_ == null) {
        return autoStorageIncrease_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : autoStorageIncrease_;
      } else {
        return autoStorageIncreaseBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [default: ON] If you enable this setting, Cloud SQL checks your available
     * storage every 30 seconds. If the available storage falls below a threshold
     * size, Cloud SQL automatically adds additional storage capacity. If the
     * available storage repeatedly falls below the threshold size, Cloud SQL
     * continues to add storage until it reaches the maximum of 30 TB.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue auto_storage_increase = 7;</code>
     */
    public Builder setAutoStorageIncrease(com.google.protobuf.BoolValue value) {
      if (autoStorageIncreaseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoStorageIncrease_ = value;
      } else {
        autoStorageIncreaseBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [default: ON] If you enable this setting, Cloud SQL checks your available
     * storage every 30 seconds. If the available storage falls below a threshold
     * size, Cloud SQL automatically adds additional storage capacity. If the
     * available storage repeatedly falls below the threshold size, Cloud SQL
     * continues to add storage until it reaches the maximum of 30 TB.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue auto_storage_increase = 7;</code>
     */
    public Builder setAutoStorageIncrease(com.google.protobuf.BoolValue.Builder builderForValue) {
      if (autoStorageIncreaseBuilder_ == null) {
        autoStorageIncrease_ = builderForValue.build();
      } else {
        autoStorageIncreaseBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [default: ON] If you enable this setting, Cloud SQL checks your available
     * storage every 30 seconds. If the available storage falls below a threshold
     * size, Cloud SQL automatically adds additional storage capacity. If the
     * available storage repeatedly falls below the threshold size, Cloud SQL
     * continues to add storage until it reaches the maximum of 30 TB.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue auto_storage_increase = 7;</code>
     */
    public Builder mergeAutoStorageIncrease(com.google.protobuf.BoolValue value) {
      if (autoStorageIncreaseBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && autoStorageIncrease_ != null
            && autoStorageIncrease_ != com.google.protobuf.BoolValue.getDefaultInstance()) {
          getAutoStorageIncreaseBuilder().mergeFrom(value);
        } else {
          autoStorageIncrease_ = value;
        }
      } else {
        autoStorageIncreaseBuilder_.mergeFrom(value);
      }
      if (autoStorageIncrease_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [default: ON] If you enable this setting, Cloud SQL checks your available
     * storage every 30 seconds. If the available storage falls below a threshold
     * size, Cloud SQL automatically adds additional storage capacity. If the
     * available storage repeatedly falls below the threshold size, Cloud SQL
     * continues to add storage until it reaches the maximum of 30 TB.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue auto_storage_increase = 7;</code>
     */
    public Builder clearAutoStorageIncrease() {
      bitField0_ = (bitField0_ & ~0x00000040);
      autoStorageIncrease_ = null;
      if (autoStorageIncreaseBuilder_ != null) {
        autoStorageIncreaseBuilder_.dispose();
        autoStorageIncreaseBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [default: ON] If you enable this setting, Cloud SQL checks your available
     * storage every 30 seconds. If the available storage falls below a threshold
     * size, Cloud SQL automatically adds additional storage capacity. If the
     * available storage repeatedly falls below the threshold size, Cloud SQL
     * continues to add storage until it reaches the maximum of 30 TB.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue auto_storage_increase = 7;</code>
     */
    public com.google.protobuf.BoolValue.Builder getAutoStorageIncreaseBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getAutoStorageIncreaseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [default: ON] If you enable this setting, Cloud SQL checks your available
     * storage every 30 seconds. If the available storage falls below a threshold
     * size, Cloud SQL automatically adds additional storage capacity. If the
     * available storage repeatedly falls below the threshold size, Cloud SQL
     * continues to add storage until it reaches the maximum of 30 TB.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue auto_storage_increase = 7;</code>
     */
    public com.google.protobuf.BoolValueOrBuilder getAutoStorageIncreaseOrBuilder() {
      if (autoStorageIncreaseBuilder_ != null) {
        return autoStorageIncreaseBuilder_.getMessageOrBuilder();
      } else {
        return autoStorageIncrease_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : autoStorageIncrease_;
      }
    }
    /**
     *
     *
     * <pre>
     * [default: ON] If you enable this setting, Cloud SQL checks your available
     * storage every 30 seconds. If the available storage falls below a threshold
     * size, Cloud SQL automatically adds additional storage capacity. If the
     * available storage repeatedly falls below the threshold size, Cloud SQL
     * continues to add storage until it reaches the maximum of 30 TB.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue auto_storage_increase = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        getAutoStorageIncreaseFieldBuilder() {
      if (autoStorageIncreaseBuilder_ == null) {
        autoStorageIncreaseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>(
                getAutoStorageIncrease(), getParentForChildren(), isClean());
        autoStorageIncrease_ = null;
      }
      return autoStorageIncreaseBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> databaseFlags_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetDatabaseFlags() {
      if (databaseFlags_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            DatabaseFlagsDefaultEntryHolder.defaultEntry);
      }
      return databaseFlags_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableDatabaseFlags() {
      if (databaseFlags_ == null) {
        databaseFlags_ =
            com.google.protobuf.MapField.newMapField(DatabaseFlagsDefaultEntryHolder.defaultEntry);
      }
      if (!databaseFlags_.isMutable()) {
        databaseFlags_ = databaseFlags_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return databaseFlags_;
    }

    public int getDatabaseFlagsCount() {
      return internalGetDatabaseFlags().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The database flags passed to the Cloud SQL instance at startup.
     * An object containing a list of "key": value pairs.
     * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     * </pre>
     *
     * <code>map&lt;string, string&gt; database_flags = 8;</code>
     */
    @java.lang.Override
    public boolean containsDatabaseFlags(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDatabaseFlags().getMap().containsKey(key);
    }
    /** Use {@link #getDatabaseFlagsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getDatabaseFlags() {
      return getDatabaseFlagsMap();
    }
    /**
     *
     *
     * <pre>
     * The database flags passed to the Cloud SQL instance at startup.
     * An object containing a list of "key": value pairs.
     * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     * </pre>
     *
     * <code>map&lt;string, string&gt; database_flags = 8;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getDatabaseFlagsMap() {
      return internalGetDatabaseFlags().getMap();
    }
    /**
     *
     *
     * <pre>
     * The database flags passed to the Cloud SQL instance at startup.
     * An object containing a list of "key": value pairs.
     * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     * </pre>
     *
     * <code>map&lt;string, string&gt; database_flags = 8;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getDatabaseFlagsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDatabaseFlags().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The database flags passed to the Cloud SQL instance at startup.
     * An object containing a list of "key": value pairs.
     * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     * </pre>
     *
     * <code>map&lt;string, string&gt; database_flags = 8;</code>
     */
    @java.lang.Override
    public java.lang.String getDatabaseFlagsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDatabaseFlags().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearDatabaseFlags() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableDatabaseFlags().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database flags passed to the Cloud SQL instance at startup.
     * An object containing a list of "key": value pairs.
     * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     * </pre>
     *
     * <code>map&lt;string, string&gt; database_flags = 8;</code>
     */
    public Builder removeDatabaseFlags(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableDatabaseFlags().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableDatabaseFlags() {
      bitField0_ |= 0x00000080;
      return internalGetMutableDatabaseFlags().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The database flags passed to the Cloud SQL instance at startup.
     * An object containing a list of "key": value pairs.
     * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     * </pre>
     *
     * <code>map&lt;string, string&gt; database_flags = 8;</code>
     */
    public Builder putDatabaseFlags(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableDatabaseFlags().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database flags passed to the Cloud SQL instance at startup.
     * An object containing a list of "key": value pairs.
     * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     * </pre>
     *
     * <code>map&lt;string, string&gt; database_flags = 8;</code>
     */
    public Builder putAllDatabaseFlags(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableDatabaseFlags().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    private int dataDiskType_ = 0;
    /**
     *
     *
     * <pre>
     * The type of storage: `PD_SSD` (default) or `PD_HDD`.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType data_disk_type = 9;</code>
     *
     * @return The enum numeric value on the wire for dataDiskType.
     */
    @java.lang.Override
    public int getDataDiskTypeValue() {
      return dataDiskType_;
    }
    /**
     *
     *
     * <pre>
     * The type of storage: `PD_SSD` (default) or `PD_HDD`.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType data_disk_type = 9;</code>
     *
     * @param value The enum numeric value on the wire for dataDiskType to set.
     * @return This builder for chaining.
     */
    public Builder setDataDiskTypeValue(int value) {
      dataDiskType_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of storage: `PD_SSD` (default) or `PD_HDD`.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType data_disk_type = 9;</code>
     *
     * @return The dataDiskType.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType getDataDiskType() {
      com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType result =
          com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType.forNumber(dataDiskType_);
      return result == null
          ? com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of storage: `PD_SSD` (default) or `PD_HDD`.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType data_disk_type = 9;</code>
     *
     * @param value The dataDiskType to set.
     * @return This builder for chaining.
     */
    public Builder setDataDiskType(
        com.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      dataDiskType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of storage: `PD_SSD` (default) or `PD_HDD`.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType data_disk_type = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataDiskType() {
      bitField0_ = (bitField0_ & ~0x00000100);
      dataDiskType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value dataDiskSizeGb_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        dataDiskSizeGbBuilder_;
    /**
     *
     *
     * <pre>
     * The storage capacity available to the database, in GB.
     * The minimum (and default) size is 10GB.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_disk_size_gb = 10;</code>
     *
     * @return Whether the dataDiskSizeGb field is set.
     */
    public boolean hasDataDiskSizeGb() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The storage capacity available to the database, in GB.
     * The minimum (and default) size is 10GB.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_disk_size_gb = 10;</code>
     *
     * @return The dataDiskSizeGb.
     */
    public com.google.protobuf.Int64Value getDataDiskSizeGb() {
      if (dataDiskSizeGbBuilder_ == null) {
        return dataDiskSizeGb_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : dataDiskSizeGb_;
      } else {
        return dataDiskSizeGbBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The storage capacity available to the database, in GB.
     * The minimum (and default) size is 10GB.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_disk_size_gb = 10;</code>
     */
    public Builder setDataDiskSizeGb(com.google.protobuf.Int64Value value) {
      if (dataDiskSizeGbBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataDiskSizeGb_ = value;
      } else {
        dataDiskSizeGbBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The storage capacity available to the database, in GB.
     * The minimum (and default) size is 10GB.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_disk_size_gb = 10;</code>
     */
    public Builder setDataDiskSizeGb(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (dataDiskSizeGbBuilder_ == null) {
        dataDiskSizeGb_ = builderForValue.build();
      } else {
        dataDiskSizeGbBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The storage capacity available to the database, in GB.
     * The minimum (and default) size is 10GB.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_disk_size_gb = 10;</code>
     */
    public Builder mergeDataDiskSizeGb(com.google.protobuf.Int64Value value) {
      if (dataDiskSizeGbBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && dataDiskSizeGb_ != null
            && dataDiskSizeGb_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
          getDataDiskSizeGbBuilder().mergeFrom(value);
        } else {
          dataDiskSizeGb_ = value;
        }
      } else {
        dataDiskSizeGbBuilder_.mergeFrom(value);
      }
      if (dataDiskSizeGb_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The storage capacity available to the database, in GB.
     * The minimum (and default) size is 10GB.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_disk_size_gb = 10;</code>
     */
    public Builder clearDataDiskSizeGb() {
      bitField0_ = (bitField0_ & ~0x00000200);
      dataDiskSizeGb_ = null;
      if (dataDiskSizeGbBuilder_ != null) {
        dataDiskSizeGbBuilder_.dispose();
        dataDiskSizeGbBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The storage capacity available to the database, in GB.
     * The minimum (and default) size is 10GB.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_disk_size_gb = 10;</code>
     */
    public com.google.protobuf.Int64Value.Builder getDataDiskSizeGbBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getDataDiskSizeGbFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The storage capacity available to the database, in GB.
     * The minimum (and default) size is 10GB.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_disk_size_gb = 10;</code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getDataDiskSizeGbOrBuilder() {
      if (dataDiskSizeGbBuilder_ != null) {
        return dataDiskSizeGbBuilder_.getMessageOrBuilder();
      } else {
        return dataDiskSizeGb_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : dataDiskSizeGb_;
      }
    }
    /**
     *
     *
     * <pre>
     * The storage capacity available to the database, in GB.
     * The minimum (and default) size is 10GB.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_disk_size_gb = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getDataDiskSizeGbFieldBuilder() {
      if (dataDiskSizeGbBuilder_ == null) {
        dataDiskSizeGbBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getDataDiskSizeGb(), getParentForChildren(), isClean());
        dataDiskSizeGb_ = null;
      }
      return dataDiskSizeGbBuilder_;
    }

    private java.lang.Object zone_ = "";
    /**
     *
     *
     * <pre>
     * The Google Cloud Platform zone where your Cloud SQL database instance is
     * located.
     * </pre>
     *
     * <code>string zone = 11;</code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Platform zone where your Cloud SQL database instance is
     * located.
     * </pre>
     *
     * <code>string zone = 11;</code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Platform zone where your Cloud SQL database instance is
     * located.
     * </pre>
     *
     * <code>string zone = 11;</code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Platform zone where your Cloud SQL database instance is
     * located.
     * </pre>
     *
     * <code>string zone = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Platform zone where your Cloud SQL database instance is
     * located.
     * </pre>
     *
     * <code>string zone = 11;</code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object secondaryZone_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud Platform zone where the failover Cloud SQL
     * database instance is located. Used when the Cloud SQL database availability
     * type is REGIONAL (i.e. multiple zones / highly available).
     * </pre>
     *
     * <code>string secondary_zone = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The secondaryZone.
     */
    public java.lang.String getSecondaryZone() {
      java.lang.Object ref = secondaryZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        secondaryZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud Platform zone where the failover Cloud SQL
     * database instance is located. Used when the Cloud SQL database availability
     * type is REGIONAL (i.e. multiple zones / highly available).
     * </pre>
     *
     * <code>string secondary_zone = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for secondaryZone.
     */
    public com.google.protobuf.ByteString getSecondaryZoneBytes() {
      java.lang.Object ref = secondaryZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        secondaryZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud Platform zone where the failover Cloud SQL
     * database instance is located. Used when the Cloud SQL database availability
     * type is REGIONAL (i.e. multiple zones / highly available).
     * </pre>
     *
     * <code>string secondary_zone = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The secondaryZone to set.
     * @return This builder for chaining.
     */
    public Builder setSecondaryZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      secondaryZone_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud Platform zone where the failover Cloud SQL
     * database instance is located. Used when the Cloud SQL database availability
     * type is REGIONAL (i.e. multiple zones / highly available).
     * </pre>
     *
     * <code>string secondary_zone = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecondaryZone() {
      secondaryZone_ = getDefaultInstance().getSecondaryZone();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud Platform zone where the failover Cloud SQL
     * database instance is located. Used when the Cloud SQL database availability
     * type is REGIONAL (i.e. multiple zones / highly available).
     * </pre>
     *
     * <code>string secondary_zone = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for secondaryZone to set.
     * @return This builder for chaining.
     */
    public Builder setSecondaryZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      secondaryZone_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object sourceId_ = "";
    /**
     *
     *
     * <pre>
     * The Database Migration Service source connection profile ID,
     * in the format:
     * `projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID`
     * </pre>
     *
     * <code>string source_id = 12;</code>
     *
     * @return The sourceId.
     */
    public java.lang.String getSourceId() {
      java.lang.Object ref = sourceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Database Migration Service source connection profile ID,
     * in the format:
     * `projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID`
     * </pre>
     *
     * <code>string source_id = 12;</code>
     *
     * @return The bytes for sourceId.
     */
    public com.google.protobuf.ByteString getSourceIdBytes() {
      java.lang.Object ref = sourceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Database Migration Service source connection profile ID,
     * in the format:
     * `projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID`
     * </pre>
     *
     * <code>string source_id = 12;</code>
     *
     * @param value The sourceId to set.
     * @return This builder for chaining.
     */
    public Builder setSourceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceId_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Database Migration Service source connection profile ID,
     * in the format:
     * `projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID`
     * </pre>
     *
     * <code>string source_id = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceId() {
      sourceId_ = getDefaultInstance().getSourceId();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Database Migration Service source connection profile ID,
     * in the format:
     * `projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID`
     * </pre>
     *
     * <code>string source_id = 12;</code>
     *
     * @param value The bytes for sourceId to set.
     * @return This builder for chaining.
     */
    public Builder setSourceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceId_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object rootPassword_ = "";
    /**
     *
     *
     * <pre>
     * Input only. Initial root password.
     * </pre>
     *
     * <code>string root_password = 13 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The rootPassword.
     */
    public java.lang.String getRootPassword() {
      java.lang.Object ref = rootPassword_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rootPassword_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. Initial root password.
     * </pre>
     *
     * <code>string root_password = 13 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for rootPassword.
     */
    public com.google.protobuf.ByteString getRootPasswordBytes() {
      java.lang.Object ref = rootPassword_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rootPassword_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. Initial root password.
     * </pre>
     *
     * <code>string root_password = 13 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The rootPassword to set.
     * @return This builder for chaining.
     */
    public Builder setRootPassword(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rootPassword_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Initial root password.
     * </pre>
     *
     * <code>string root_password = 13 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRootPassword() {
      rootPassword_ = getDefaultInstance().getRootPassword();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Initial root password.
     * </pre>
     *
     * <code>string root_password = 13 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The bytes for rootPassword to set.
     * @return This builder for chaining.
     */
    public Builder setRootPasswordBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rootPassword_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private boolean rootPasswordSet_;
    /**
     *
     *
     * <pre>
     * Output only. Indicates If this connection profile root password is stored.
     * </pre>
     *
     * <code>bool root_password_set = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The rootPasswordSet.
     */
    @java.lang.Override
    public boolean getRootPasswordSet() {
      return rootPasswordSet_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates If this connection profile root password is stored.
     * </pre>
     *
     * <code>bool root_password_set = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The rootPasswordSet to set.
     * @return This builder for chaining.
     */
    public Builder setRootPasswordSet(boolean value) {

      rootPasswordSet_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates If this connection profile root password is stored.
     * </pre>
     *
     * <code>bool root_password_set = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRootPasswordSet() {
      bitField0_ = (bitField0_ & ~0x00004000);
      rootPasswordSet_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object collation_ = "";
    /**
     *
     *
     * <pre>
     * The Cloud SQL default instance level collation.
     * </pre>
     *
     * <code>string collation = 15;</code>
     *
     * @return The collation.
     */
    public java.lang.String getCollation() {
      java.lang.Object ref = collation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        collation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud SQL default instance level collation.
     * </pre>
     *
     * <code>string collation = 15;</code>
     *
     * @return The bytes for collation.
     */
    public com.google.protobuf.ByteString getCollationBytes() {
      java.lang.Object ref = collation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        collation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud SQL default instance level collation.
     * </pre>
     *
     * <code>string collation = 15;</code>
     *
     * @param value The collation to set.
     * @return This builder for chaining.
     */
    public Builder setCollation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      collation_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud SQL default instance level collation.
     * </pre>
     *
     * <code>string collation = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCollation() {
      collation_ = getDefaultInstance().getCollation();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud SQL default instance level collation.
     * </pre>
     *
     * <code>string collation = 15;</code>
     *
     * @param value The bytes for collation to set.
     * @return This builder for chaining.
     */
    public Builder setCollationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      collation_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object cmekKeyName_ = "";
    /**
     *
     *
     * <pre>
     * The KMS key name used for the csql instance.
     * </pre>
     *
     * <code>string cmek_key_name = 16;</code>
     *
     * @return The cmekKeyName.
     */
    public java.lang.String getCmekKeyName() {
      java.lang.Object ref = cmekKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cmekKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The KMS key name used for the csql instance.
     * </pre>
     *
     * <code>string cmek_key_name = 16;</code>
     *
     * @return The bytes for cmekKeyName.
     */
    public com.google.protobuf.ByteString getCmekKeyNameBytes() {
      java.lang.Object ref = cmekKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cmekKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The KMS key name used for the csql instance.
     * </pre>
     *
     * <code>string cmek_key_name = 16;</code>
     *
     * @param value The cmekKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setCmekKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cmekKeyName_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The KMS key name used for the csql instance.
     * </pre>
     *
     * <code>string cmek_key_name = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCmekKeyName() {
      cmekKeyName_ = getDefaultInstance().getCmekKeyName();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The KMS key name used for the csql instance.
     * </pre>
     *
     * <code>string cmek_key_name = 16;</code>
     *
     * @param value The bytes for cmekKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setCmekKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cmekKeyName_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private int availabilityType_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Availability type. Potential values:
     * *  `ZONAL`: The instance serves data from only one zone. Outages in that
     * zone affect data availability.
     * *  `REGIONAL`: The instance can serve data from more than one zone in a
     * region (it is highly available).
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType availability_type = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for availabilityType.
     */
    @java.lang.Override
    public int getAvailabilityTypeValue() {
      return availabilityType_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Availability type. Potential values:
     * *  `ZONAL`: The instance serves data from only one zone. Outages in that
     * zone affect data availability.
     * *  `REGIONAL`: The instance can serve data from more than one zone in a
     * region (it is highly available).
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType availability_type = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for availabilityType to set.
     * @return This builder for chaining.
     */
    public Builder setAvailabilityTypeValue(int value) {
      availabilityType_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Availability type. Potential values:
     * *  `ZONAL`: The instance serves data from only one zone. Outages in that
     * zone affect data availability.
     * *  `REGIONAL`: The instance can serve data from more than one zone in a
     * region (it is highly available).
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType availability_type = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The availabilityType.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType getAvailabilityType() {
      com.google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType result =
          com.google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType.forNumber(
              availabilityType_);
      return result == null
          ? com.google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Availability type. Potential values:
     * *  `ZONAL`: The instance serves data from only one zone. Outages in that
     * zone affect data availability.
     * *  `REGIONAL`: The instance can serve data from more than one zone in a
     * region (it is highly available).
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType availability_type = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The availabilityType to set.
     * @return This builder for chaining.
     */
    public Builder setAvailabilityType(
        com.google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00020000;
      availabilityType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Availability type. Potential values:
     * *  `ZONAL`: The instance serves data from only one zone. Outages in that
     * zone affect data availability.
     * *  `REGIONAL`: The instance can serve data from more than one zone in a
     * region (it is highly available).
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings.SqlAvailabilityType availability_type = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvailabilityType() {
      bitField0_ = (bitField0_ & ~0x00020000);
      availabilityType_ = 0;
      onChanged();
      return this;
    }

    private int edition_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The edition of the given Cloud SQL instance.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings.Edition edition = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for edition.
     */
    @java.lang.Override
    public int getEditionValue() {
      return edition_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The edition of the given Cloud SQL instance.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings.Edition edition = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for edition to set.
     * @return This builder for chaining.
     */
    public Builder setEditionValue(int value) {
      edition_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The edition of the given Cloud SQL instance.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings.Edition edition = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The edition.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.CloudSqlSettings.Edition getEdition() {
      com.google.cloud.clouddms.v1.CloudSqlSettings.Edition result =
          com.google.cloud.clouddms.v1.CloudSqlSettings.Edition.forNumber(edition_);
      return result == null
          ? com.google.cloud.clouddms.v1.CloudSqlSettings.Edition.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The edition of the given Cloud SQL instance.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings.Edition edition = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The edition to set.
     * @return This builder for chaining.
     */
    public Builder setEdition(com.google.cloud.clouddms.v1.CloudSqlSettings.Edition value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00040000;
      edition_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The edition of the given Cloud SQL instance.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.CloudSqlSettings.Edition edition = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEdition() {
      bitField0_ = (bitField0_ & ~0x00040000);
      edition_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.CloudSqlSettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.CloudSqlSettings)
  private static final com.google.cloud.clouddms.v1.CloudSqlSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.CloudSqlSettings();
  }

  public static com.google.cloud.clouddms.v1.CloudSqlSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudSqlSettings> PARSER =
      new com.google.protobuf.AbstractParser<CloudSqlSettings>() {
        @java.lang.Override
        public CloudSqlSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudSqlSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudSqlSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.CloudSqlSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
