/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Column is not used as an independent entity, it is retrieved as part of a
 * Table entity.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.ColumnEntity}
 */
public final class ColumnEntity extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.ColumnEntity)
    ColumnEntityOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ColumnEntity.newBuilder() to construct.
  private ColumnEntity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ColumnEntity() {
    name_ = "";
    dataType_ = "";
    charset_ = "";
    collation_ = "";
    setValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
    comment_ = "";
    defaultValue_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ColumnEntity();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_ColumnEntity_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_ColumnEntity_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.ColumnEntity.class,
            com.google.cloud.clouddms.v1.ColumnEntity.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Column name.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Column name.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataType_ = "";
  /**
   *
   *
   * <pre>
   * Column data type.
   * </pre>
   *
   * <code>string data_type = 2;</code>
   *
   * @return The dataType.
   */
  @java.lang.Override
  public java.lang.String getDataType() {
    java.lang.Object ref = dataType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Column data type.
   * </pre>
   *
   * <code>string data_type = 2;</code>
   *
   * @return The bytes for dataType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataTypeBytes() {
    java.lang.Object ref = dataType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHARSET_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object charset_ = "";
  /**
   *
   *
   * <pre>
   * Charset override - instead of table level charset.
   * </pre>
   *
   * <code>string charset = 3;</code>
   *
   * @return The charset.
   */
  @java.lang.Override
  public java.lang.String getCharset() {
    java.lang.Object ref = charset_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      charset_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Charset override - instead of table level charset.
   * </pre>
   *
   * <code>string charset = 3;</code>
   *
   * @return The bytes for charset.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCharsetBytes() {
    java.lang.Object ref = charset_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      charset_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COLLATION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object collation_ = "";
  /**
   *
   *
   * <pre>
   * Collation override - instead of table level collation.
   * </pre>
   *
   * <code>string collation = 4;</code>
   *
   * @return The collation.
   */
  @java.lang.Override
  public java.lang.String getCollation() {
    java.lang.Object ref = collation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      collation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Collation override - instead of table level collation.
   * </pre>
   *
   * <code>string collation = 4;</code>
   *
   * @return The bytes for collation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCollationBytes() {
    java.lang.Object ref = collation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      collation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LENGTH_FIELD_NUMBER = 5;
  private long length_ = 0L;
  /**
   *
   *
   * <pre>
   * Column length - e.g. varchar (50).
   * </pre>
   *
   * <code>int64 length = 5;</code>
   *
   * @return The length.
   */
  @java.lang.Override
  public long getLength() {
    return length_;
  }

  public static final int PRECISION_FIELD_NUMBER = 6;
  private int precision_ = 0;
  /**
   *
   *
   * <pre>
   * Column precision - when relevant.
   * </pre>
   *
   * <code>int32 precision = 6;</code>
   *
   * @return The precision.
   */
  @java.lang.Override
  public int getPrecision() {
    return precision_;
  }

  public static final int SCALE_FIELD_NUMBER = 7;
  private int scale_ = 0;
  /**
   *
   *
   * <pre>
   * Column scale - when relevant.
   * </pre>
   *
   * <code>int32 scale = 7;</code>
   *
   * @return The scale.
   */
  @java.lang.Override
  public int getScale() {
    return scale_;
  }

  public static final int FRACTIONAL_SECONDS_PRECISION_FIELD_NUMBER = 8;
  private int fractionalSecondsPrecision_ = 0;
  /**
   *
   *
   * <pre>
   * Column fractional second precision - used for timestamp based datatypes.
   * </pre>
   *
   * <code>int32 fractional_seconds_precision = 8;</code>
   *
   * @return The fractionalSecondsPrecision.
   */
  @java.lang.Override
  public int getFractionalSecondsPrecision() {
    return fractionalSecondsPrecision_;
  }

  public static final int ARRAY_FIELD_NUMBER = 9;
  private boolean array_ = false;
  /**
   *
   *
   * <pre>
   * Is the column of array type.
   * </pre>
   *
   * <code>bool array = 9;</code>
   *
   * @return The array.
   */
  @java.lang.Override
  public boolean getArray() {
    return array_;
  }

  public static final int ARRAY_LENGTH_FIELD_NUMBER = 10;
  private int arrayLength_ = 0;
  /**
   *
   *
   * <pre>
   * If the column is array, of which length.
   * </pre>
   *
   * <code>int32 array_length = 10;</code>
   *
   * @return The arrayLength.
   */
  @java.lang.Override
  public int getArrayLength() {
    return arrayLength_;
  }

  public static final int NULLABLE_FIELD_NUMBER = 11;
  private boolean nullable_ = false;
  /**
   *
   *
   * <pre>
   * Is the column nullable.
   * </pre>
   *
   * <code>bool nullable = 11;</code>
   *
   * @return The nullable.
   */
  @java.lang.Override
  public boolean getNullable() {
    return nullable_;
  }

  public static final int AUTO_GENERATED_FIELD_NUMBER = 12;
  private boolean autoGenerated_ = false;
  /**
   *
   *
   * <pre>
   * Is the column auto-generated/identity.
   * </pre>
   *
   * <code>bool auto_generated = 12;</code>
   *
   * @return The autoGenerated.
   */
  @java.lang.Override
  public boolean getAutoGenerated() {
    return autoGenerated_;
  }

  public static final int UDT_FIELD_NUMBER = 13;
  private boolean udt_ = false;
  /**
   *
   *
   * <pre>
   * Is the column a UDT.
   * </pre>
   *
   * <code>bool udt = 13;</code>
   *
   * @return The udt.
   */
  @java.lang.Override
  public boolean getUdt() {
    return udt_;
  }

  public static final int CUSTOM_FEATURES_FIELD_NUMBER = 14;
  private com.google.protobuf.Struct customFeatures_;
  /**
   *
   *
   * <pre>
   * Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 14;</code>
   *
   * @return Whether the customFeatures field is set.
   */
  @java.lang.Override
  public boolean hasCustomFeatures() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 14;</code>
   *
   * @return The customFeatures.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getCustomFeatures() {
    return customFeatures_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : customFeatures_;
  }
  /**
   *
   *
   * <pre>
   * Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 14;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getCustomFeaturesOrBuilder() {
    return customFeatures_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : customFeatures_;
  }

  public static final int SET_VALUES_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList setValues_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Specifies the list of values allowed in the column.
   * Only used for set data type.
   * </pre>
   *
   * <code>repeated string set_values = 15;</code>
   *
   * @return A list containing the setValues.
   */
  public com.google.protobuf.ProtocolStringList getSetValuesList() {
    return setValues_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the list of values allowed in the column.
   * Only used for set data type.
   * </pre>
   *
   * <code>repeated string set_values = 15;</code>
   *
   * @return The count of setValues.
   */
  public int getSetValuesCount() {
    return setValues_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies the list of values allowed in the column.
   * Only used for set data type.
   * </pre>
   *
   * <code>repeated string set_values = 15;</code>
   *
   * @param index The index of the element to return.
   * @return The setValues at the given index.
   */
  public java.lang.String getSetValues(int index) {
    return setValues_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Specifies the list of values allowed in the column.
   * Only used for set data type.
   * </pre>
   *
   * <code>repeated string set_values = 15;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the setValues at the given index.
   */
  public com.google.protobuf.ByteString getSetValuesBytes(int index) {
    return setValues_.getByteString(index);
  }

  public static final int COMMENT_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object comment_ = "";
  /**
   *
   *
   * <pre>
   * Comment associated with the column.
   * </pre>
   *
   * <code>string comment = 16;</code>
   *
   * @return The comment.
   */
  @java.lang.Override
  public java.lang.String getComment() {
    java.lang.Object ref = comment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      comment_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Comment associated with the column.
   * </pre>
   *
   * <code>string comment = 16;</code>
   *
   * @return The bytes for comment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCommentBytes() {
    java.lang.Object ref = comment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      comment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORDINAL_POSITION_FIELD_NUMBER = 17;
  private int ordinalPosition_ = 0;
  /**
   *
   *
   * <pre>
   * Column order in the table.
   * </pre>
   *
   * <code>int32 ordinal_position = 17;</code>
   *
   * @return The ordinalPosition.
   */
  @java.lang.Override
  public int getOrdinalPosition() {
    return ordinalPosition_;
  }

  public static final int DEFAULT_VALUE_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultValue_ = "";
  /**
   *
   *
   * <pre>
   * Default value of the column.
   * </pre>
   *
   * <code>string default_value = 18;</code>
   *
   * @return The defaultValue.
   */
  @java.lang.Override
  public java.lang.String getDefaultValue() {
    java.lang.Object ref = defaultValue_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultValue_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Default value of the column.
   * </pre>
   *
   * <code>string default_value = 18;</code>
   *
   * @return The bytes for defaultValue.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultValueBytes() {
    java.lang.Object ref = defaultValue_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultValue_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dataType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(charset_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, charset_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(collation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, collation_);
    }
    if (length_ != 0L) {
      output.writeInt64(5, length_);
    }
    if (precision_ != 0) {
      output.writeInt32(6, precision_);
    }
    if (scale_ != 0) {
      output.writeInt32(7, scale_);
    }
    if (fractionalSecondsPrecision_ != 0) {
      output.writeInt32(8, fractionalSecondsPrecision_);
    }
    if (array_ != false) {
      output.writeBool(9, array_);
    }
    if (arrayLength_ != 0) {
      output.writeInt32(10, arrayLength_);
    }
    if (nullable_ != false) {
      output.writeBool(11, nullable_);
    }
    if (autoGenerated_ != false) {
      output.writeBool(12, autoGenerated_);
    }
    if (udt_ != false) {
      output.writeBool(13, udt_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(14, getCustomFeatures());
    }
    for (int i = 0; i < setValues_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, setValues_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(comment_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, comment_);
    }
    if (ordinalPosition_ != 0) {
      output.writeInt32(17, ordinalPosition_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultValue_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, defaultValue_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dataType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(charset_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, charset_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(collation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, collation_);
    }
    if (length_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, length_);
    }
    if (precision_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, precision_);
    }
    if (scale_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, scale_);
    }
    if (fractionalSecondsPrecision_ != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(8, fractionalSecondsPrecision_);
    }
    if (array_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, array_);
    }
    if (arrayLength_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(10, arrayLength_);
    }
    if (nullable_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, nullable_);
    }
    if (autoGenerated_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, autoGenerated_);
    }
    if (udt_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, udt_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getCustomFeatures());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < setValues_.size(); i++) {
        dataSize += computeStringSizeNoTag(setValues_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSetValuesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(comment_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, comment_);
    }
    if (ordinalPosition_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(17, ordinalPosition_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultValue_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, defaultValue_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.ColumnEntity)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.ColumnEntity other =
        (com.google.cloud.clouddms.v1.ColumnEntity) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDataType().equals(other.getDataType())) return false;
    if (!getCharset().equals(other.getCharset())) return false;
    if (!getCollation().equals(other.getCollation())) return false;
    if (getLength() != other.getLength()) return false;
    if (getPrecision() != other.getPrecision()) return false;
    if (getScale() != other.getScale()) return false;
    if (getFractionalSecondsPrecision() != other.getFractionalSecondsPrecision()) return false;
    if (getArray() != other.getArray()) return false;
    if (getArrayLength() != other.getArrayLength()) return false;
    if (getNullable() != other.getNullable()) return false;
    if (getAutoGenerated() != other.getAutoGenerated()) return false;
    if (getUdt() != other.getUdt()) return false;
    if (hasCustomFeatures() != other.hasCustomFeatures()) return false;
    if (hasCustomFeatures()) {
      if (!getCustomFeatures().equals(other.getCustomFeatures())) return false;
    }
    if (!getSetValuesList().equals(other.getSetValuesList())) return false;
    if (!getComment().equals(other.getComment())) return false;
    if (getOrdinalPosition() != other.getOrdinalPosition()) return false;
    if (!getDefaultValue().equals(other.getDefaultValue())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DATA_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getDataType().hashCode();
    hash = (37 * hash) + CHARSET_FIELD_NUMBER;
    hash = (53 * hash) + getCharset().hashCode();
    hash = (37 * hash) + COLLATION_FIELD_NUMBER;
    hash = (53 * hash) + getCollation().hashCode();
    hash = (37 * hash) + LENGTH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getLength());
    hash = (37 * hash) + PRECISION_FIELD_NUMBER;
    hash = (53 * hash) + getPrecision();
    hash = (37 * hash) + SCALE_FIELD_NUMBER;
    hash = (53 * hash) + getScale();
    hash = (37 * hash) + FRACTIONAL_SECONDS_PRECISION_FIELD_NUMBER;
    hash = (53 * hash) + getFractionalSecondsPrecision();
    hash = (37 * hash) + ARRAY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getArray());
    hash = (37 * hash) + ARRAY_LENGTH_FIELD_NUMBER;
    hash = (53 * hash) + getArrayLength();
    hash = (37 * hash) + NULLABLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getNullable());
    hash = (37 * hash) + AUTO_GENERATED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutoGenerated());
    hash = (37 * hash) + UDT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUdt());
    if (hasCustomFeatures()) {
      hash = (37 * hash) + CUSTOM_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getCustomFeatures().hashCode();
    }
    if (getSetValuesCount() > 0) {
      hash = (37 * hash) + SET_VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getSetValuesList().hashCode();
    }
    hash = (37 * hash) + COMMENT_FIELD_NUMBER;
    hash = (53 * hash) + getComment().hashCode();
    hash = (37 * hash) + ORDINAL_POSITION_FIELD_NUMBER;
    hash = (53 * hash) + getOrdinalPosition();
    hash = (37 * hash) + DEFAULT_VALUE_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultValue().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.ColumnEntity parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ColumnEntity parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ColumnEntity parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ColumnEntity parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ColumnEntity parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ColumnEntity parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ColumnEntity parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ColumnEntity parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ColumnEntity parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ColumnEntity parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ColumnEntity parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ColumnEntity parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.ColumnEntity prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Column is not used as an independent entity, it is retrieved as part of a
   * Table entity.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.ColumnEntity}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.ColumnEntity)
      com.google.cloud.clouddms.v1.ColumnEntityOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_ColumnEntity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_ColumnEntity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.ColumnEntity.class,
              com.google.cloud.clouddms.v1.ColumnEntity.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.ColumnEntity.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCustomFeaturesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      dataType_ = "";
      charset_ = "";
      collation_ = "";
      length_ = 0L;
      precision_ = 0;
      scale_ = 0;
      fractionalSecondsPrecision_ = 0;
      array_ = false;
      arrayLength_ = 0;
      nullable_ = false;
      autoGenerated_ = false;
      udt_ = false;
      customFeatures_ = null;
      if (customFeaturesBuilder_ != null) {
        customFeaturesBuilder_.dispose();
        customFeaturesBuilder_ = null;
      }
      setValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
      comment_ = "";
      ordinalPosition_ = 0;
      defaultValue_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_ColumnEntity_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ColumnEntity getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.ColumnEntity.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ColumnEntity build() {
      com.google.cloud.clouddms.v1.ColumnEntity result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ColumnEntity buildPartial() {
      com.google.cloud.clouddms.v1.ColumnEntity result =
          new com.google.cloud.clouddms.v1.ColumnEntity(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.ColumnEntity result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dataType_ = dataType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.charset_ = charset_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.collation_ = collation_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.length_ = length_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.precision_ = precision_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.scale_ = scale_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.fractionalSecondsPrecision_ = fractionalSecondsPrecision_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.array_ = array_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.arrayLength_ = arrayLength_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.nullable_ = nullable_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.autoGenerated_ = autoGenerated_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.udt_ = udt_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.customFeatures_ =
            customFeaturesBuilder_ == null ? customFeatures_ : customFeaturesBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        setValues_.makeImmutable();
        result.setValues_ = setValues_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.comment_ = comment_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.ordinalPosition_ = ordinalPosition_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.defaultValue_ = defaultValue_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.ColumnEntity) {
        return mergeFrom((com.google.cloud.clouddms.v1.ColumnEntity) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.ColumnEntity other) {
      if (other == com.google.cloud.clouddms.v1.ColumnEntity.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDataType().isEmpty()) {
        dataType_ = other.dataType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getCharset().isEmpty()) {
        charset_ = other.charset_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getCollation().isEmpty()) {
        collation_ = other.collation_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getLength() != 0L) {
        setLength(other.getLength());
      }
      if (other.getPrecision() != 0) {
        setPrecision(other.getPrecision());
      }
      if (other.getScale() != 0) {
        setScale(other.getScale());
      }
      if (other.getFractionalSecondsPrecision() != 0) {
        setFractionalSecondsPrecision(other.getFractionalSecondsPrecision());
      }
      if (other.getArray() != false) {
        setArray(other.getArray());
      }
      if (other.getArrayLength() != 0) {
        setArrayLength(other.getArrayLength());
      }
      if (other.getNullable() != false) {
        setNullable(other.getNullable());
      }
      if (other.getAutoGenerated() != false) {
        setAutoGenerated(other.getAutoGenerated());
      }
      if (other.getUdt() != false) {
        setUdt(other.getUdt());
      }
      if (other.hasCustomFeatures()) {
        mergeCustomFeatures(other.getCustomFeatures());
      }
      if (!other.setValues_.isEmpty()) {
        if (setValues_.isEmpty()) {
          setValues_ = other.setValues_;
          bitField0_ |= 0x00004000;
        } else {
          ensureSetValuesIsMutable();
          setValues_.addAll(other.setValues_);
        }
        onChanged();
      }
      if (!other.getComment().isEmpty()) {
        comment_ = other.comment_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.getOrdinalPosition() != 0) {
        setOrdinalPosition(other.getOrdinalPosition());
      }
      if (!other.getDefaultValue().isEmpty()) {
        defaultValue_ = other.defaultValue_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                dataType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                charset_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                collation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                length_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                precision_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                scale_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                fractionalSecondsPrecision_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 72:
              {
                array_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 80:
              {
                arrayLength_ = input.readInt32();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 88:
              {
                nullable_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            case 96:
              {
                autoGenerated_ = input.readBool();
                bitField0_ |= 0x00000800;
                break;
              } // case 96
            case 104:
              {
                udt_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 104
            case 114:
              {
                input.readMessage(getCustomFeaturesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 122:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSetValuesIsMutable();
                setValues_.add(s);
                break;
              } // case 122
            case 130:
              {
                comment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 130
            case 136:
              {
                ordinalPosition_ = input.readInt32();
                bitField0_ |= 0x00010000;
                break;
              } // case 136
            case 146:
              {
                defaultValue_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 146
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Column name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Column name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Column name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Column name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Column name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object dataType_ = "";
    /**
     *
     *
     * <pre>
     * Column data type.
     * </pre>
     *
     * <code>string data_type = 2;</code>
     *
     * @return The dataType.
     */
    public java.lang.String getDataType() {
      java.lang.Object ref = dataType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Column data type.
     * </pre>
     *
     * <code>string data_type = 2;</code>
     *
     * @return The bytes for dataType.
     */
    public com.google.protobuf.ByteString getDataTypeBytes() {
      java.lang.Object ref = dataType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Column data type.
     * </pre>
     *
     * <code>string data_type = 2;</code>
     *
     * @param value The dataType to set.
     * @return This builder for chaining.
     */
    public Builder setDataType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Column data type.
     * </pre>
     *
     * <code>string data_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataType() {
      dataType_ = getDefaultInstance().getDataType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Column data type.
     * </pre>
     *
     * <code>string data_type = 2;</code>
     *
     * @param value The bytes for dataType to set.
     * @return This builder for chaining.
     */
    public Builder setDataTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object charset_ = "";
    /**
     *
     *
     * <pre>
     * Charset override - instead of table level charset.
     * </pre>
     *
     * <code>string charset = 3;</code>
     *
     * @return The charset.
     */
    public java.lang.String getCharset() {
      java.lang.Object ref = charset_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        charset_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Charset override - instead of table level charset.
     * </pre>
     *
     * <code>string charset = 3;</code>
     *
     * @return The bytes for charset.
     */
    public com.google.protobuf.ByteString getCharsetBytes() {
      java.lang.Object ref = charset_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        charset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Charset override - instead of table level charset.
     * </pre>
     *
     * <code>string charset = 3;</code>
     *
     * @param value The charset to set.
     * @return This builder for chaining.
     */
    public Builder setCharset(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      charset_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Charset override - instead of table level charset.
     * </pre>
     *
     * <code>string charset = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCharset() {
      charset_ = getDefaultInstance().getCharset();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Charset override - instead of table level charset.
     * </pre>
     *
     * <code>string charset = 3;</code>
     *
     * @param value The bytes for charset to set.
     * @return This builder for chaining.
     */
    public Builder setCharsetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      charset_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object collation_ = "";
    /**
     *
     *
     * <pre>
     * Collation override - instead of table level collation.
     * </pre>
     *
     * <code>string collation = 4;</code>
     *
     * @return The collation.
     */
    public java.lang.String getCollation() {
      java.lang.Object ref = collation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        collation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Collation override - instead of table level collation.
     * </pre>
     *
     * <code>string collation = 4;</code>
     *
     * @return The bytes for collation.
     */
    public com.google.protobuf.ByteString getCollationBytes() {
      java.lang.Object ref = collation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        collation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Collation override - instead of table level collation.
     * </pre>
     *
     * <code>string collation = 4;</code>
     *
     * @param value The collation to set.
     * @return This builder for chaining.
     */
    public Builder setCollation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      collation_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collation override - instead of table level collation.
     * </pre>
     *
     * <code>string collation = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCollation() {
      collation_ = getDefaultInstance().getCollation();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collation override - instead of table level collation.
     * </pre>
     *
     * <code>string collation = 4;</code>
     *
     * @param value The bytes for collation to set.
     * @return This builder for chaining.
     */
    public Builder setCollationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      collation_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private long length_;
    /**
     *
     *
     * <pre>
     * Column length - e.g. varchar (50).
     * </pre>
     *
     * <code>int64 length = 5;</code>
     *
     * @return The length.
     */
    @java.lang.Override
    public long getLength() {
      return length_;
    }
    /**
     *
     *
     * <pre>
     * Column length - e.g. varchar (50).
     * </pre>
     *
     * <code>int64 length = 5;</code>
     *
     * @param value The length to set.
     * @return This builder for chaining.
     */
    public Builder setLength(long value) {

      length_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Column length - e.g. varchar (50).
     * </pre>
     *
     * <code>int64 length = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLength() {
      bitField0_ = (bitField0_ & ~0x00000010);
      length_ = 0L;
      onChanged();
      return this;
    }

    private int precision_;
    /**
     *
     *
     * <pre>
     * Column precision - when relevant.
     * </pre>
     *
     * <code>int32 precision = 6;</code>
     *
     * @return The precision.
     */
    @java.lang.Override
    public int getPrecision() {
      return precision_;
    }
    /**
     *
     *
     * <pre>
     * Column precision - when relevant.
     * </pre>
     *
     * <code>int32 precision = 6;</code>
     *
     * @param value The precision to set.
     * @return This builder for chaining.
     */
    public Builder setPrecision(int value) {

      precision_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Column precision - when relevant.
     * </pre>
     *
     * <code>int32 precision = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrecision() {
      bitField0_ = (bitField0_ & ~0x00000020);
      precision_ = 0;
      onChanged();
      return this;
    }

    private int scale_;
    /**
     *
     *
     * <pre>
     * Column scale - when relevant.
     * </pre>
     *
     * <code>int32 scale = 7;</code>
     *
     * @return The scale.
     */
    @java.lang.Override
    public int getScale() {
      return scale_;
    }
    /**
     *
     *
     * <pre>
     * Column scale - when relevant.
     * </pre>
     *
     * <code>int32 scale = 7;</code>
     *
     * @param value The scale to set.
     * @return This builder for chaining.
     */
    public Builder setScale(int value) {

      scale_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Column scale - when relevant.
     * </pre>
     *
     * <code>int32 scale = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScale() {
      bitField0_ = (bitField0_ & ~0x00000040);
      scale_ = 0;
      onChanged();
      return this;
    }

    private int fractionalSecondsPrecision_;
    /**
     *
     *
     * <pre>
     * Column fractional second precision - used for timestamp based datatypes.
     * </pre>
     *
     * <code>int32 fractional_seconds_precision = 8;</code>
     *
     * @return The fractionalSecondsPrecision.
     */
    @java.lang.Override
    public int getFractionalSecondsPrecision() {
      return fractionalSecondsPrecision_;
    }
    /**
     *
     *
     * <pre>
     * Column fractional second precision - used for timestamp based datatypes.
     * </pre>
     *
     * <code>int32 fractional_seconds_precision = 8;</code>
     *
     * @param value The fractionalSecondsPrecision to set.
     * @return This builder for chaining.
     */
    public Builder setFractionalSecondsPrecision(int value) {

      fractionalSecondsPrecision_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Column fractional second precision - used for timestamp based datatypes.
     * </pre>
     *
     * <code>int32 fractional_seconds_precision = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFractionalSecondsPrecision() {
      bitField0_ = (bitField0_ & ~0x00000080);
      fractionalSecondsPrecision_ = 0;
      onChanged();
      return this;
    }

    private boolean array_;
    /**
     *
     *
     * <pre>
     * Is the column of array type.
     * </pre>
     *
     * <code>bool array = 9;</code>
     *
     * @return The array.
     */
    @java.lang.Override
    public boolean getArray() {
      return array_;
    }
    /**
     *
     *
     * <pre>
     * Is the column of array type.
     * </pre>
     *
     * <code>bool array = 9;</code>
     *
     * @param value The array to set.
     * @return This builder for chaining.
     */
    public Builder setArray(boolean value) {

      array_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Is the column of array type.
     * </pre>
     *
     * <code>bool array = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArray() {
      bitField0_ = (bitField0_ & ~0x00000100);
      array_ = false;
      onChanged();
      return this;
    }

    private int arrayLength_;
    /**
     *
     *
     * <pre>
     * If the column is array, of which length.
     * </pre>
     *
     * <code>int32 array_length = 10;</code>
     *
     * @return The arrayLength.
     */
    @java.lang.Override
    public int getArrayLength() {
      return arrayLength_;
    }
    /**
     *
     *
     * <pre>
     * If the column is array, of which length.
     * </pre>
     *
     * <code>int32 array_length = 10;</code>
     *
     * @param value The arrayLength to set.
     * @return This builder for chaining.
     */
    public Builder setArrayLength(int value) {

      arrayLength_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the column is array, of which length.
     * </pre>
     *
     * <code>int32 array_length = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArrayLength() {
      bitField0_ = (bitField0_ & ~0x00000200);
      arrayLength_ = 0;
      onChanged();
      return this;
    }

    private boolean nullable_;
    /**
     *
     *
     * <pre>
     * Is the column nullable.
     * </pre>
     *
     * <code>bool nullable = 11;</code>
     *
     * @return The nullable.
     */
    @java.lang.Override
    public boolean getNullable() {
      return nullable_;
    }
    /**
     *
     *
     * <pre>
     * Is the column nullable.
     * </pre>
     *
     * <code>bool nullable = 11;</code>
     *
     * @param value The nullable to set.
     * @return This builder for chaining.
     */
    public Builder setNullable(boolean value) {

      nullable_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Is the column nullable.
     * </pre>
     *
     * <code>bool nullable = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNullable() {
      bitField0_ = (bitField0_ & ~0x00000400);
      nullable_ = false;
      onChanged();
      return this;
    }

    private boolean autoGenerated_;
    /**
     *
     *
     * <pre>
     * Is the column auto-generated/identity.
     * </pre>
     *
     * <code>bool auto_generated = 12;</code>
     *
     * @return The autoGenerated.
     */
    @java.lang.Override
    public boolean getAutoGenerated() {
      return autoGenerated_;
    }
    /**
     *
     *
     * <pre>
     * Is the column auto-generated/identity.
     * </pre>
     *
     * <code>bool auto_generated = 12;</code>
     *
     * @param value The autoGenerated to set.
     * @return This builder for chaining.
     */
    public Builder setAutoGenerated(boolean value) {

      autoGenerated_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Is the column auto-generated/identity.
     * </pre>
     *
     * <code>bool auto_generated = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoGenerated() {
      bitField0_ = (bitField0_ & ~0x00000800);
      autoGenerated_ = false;
      onChanged();
      return this;
    }

    private boolean udt_;
    /**
     *
     *
     * <pre>
     * Is the column a UDT.
     * </pre>
     *
     * <code>bool udt = 13;</code>
     *
     * @return The udt.
     */
    @java.lang.Override
    public boolean getUdt() {
      return udt_;
    }
    /**
     *
     *
     * <pre>
     * Is the column a UDT.
     * </pre>
     *
     * <code>bool udt = 13;</code>
     *
     * @param value The udt to set.
     * @return This builder for chaining.
     */
    public Builder setUdt(boolean value) {

      udt_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Is the column a UDT.
     * </pre>
     *
     * <code>bool udt = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUdt() {
      bitField0_ = (bitField0_ & ~0x00001000);
      udt_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct customFeatures_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        customFeaturesBuilder_;
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 14;</code>
     *
     * @return Whether the customFeatures field is set.
     */
    public boolean hasCustomFeatures() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 14;</code>
     *
     * @return The customFeatures.
     */
    public com.google.protobuf.Struct getCustomFeatures() {
      if (customFeaturesBuilder_ == null) {
        return customFeatures_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : customFeatures_;
      } else {
        return customFeaturesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 14;</code>
     */
    public Builder setCustomFeatures(com.google.protobuf.Struct value) {
      if (customFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customFeatures_ = value;
      } else {
        customFeaturesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 14;</code>
     */
    public Builder setCustomFeatures(com.google.protobuf.Struct.Builder builderForValue) {
      if (customFeaturesBuilder_ == null) {
        customFeatures_ = builderForValue.build();
      } else {
        customFeaturesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 14;</code>
     */
    public Builder mergeCustomFeatures(com.google.protobuf.Struct value) {
      if (customFeaturesBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && customFeatures_ != null
            && customFeatures_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getCustomFeaturesBuilder().mergeFrom(value);
        } else {
          customFeatures_ = value;
        }
      } else {
        customFeaturesBuilder_.mergeFrom(value);
      }
      if (customFeatures_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 14;</code>
     */
    public Builder clearCustomFeatures() {
      bitField0_ = (bitField0_ & ~0x00002000);
      customFeatures_ = null;
      if (customFeaturesBuilder_ != null) {
        customFeaturesBuilder_.dispose();
        customFeaturesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 14;</code>
     */
    public com.google.protobuf.Struct.Builder getCustomFeaturesBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getCustomFeaturesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 14;</code>
     */
    public com.google.protobuf.StructOrBuilder getCustomFeaturesOrBuilder() {
      if (customFeaturesBuilder_ != null) {
        return customFeaturesBuilder_.getMessageOrBuilder();
      } else {
        return customFeatures_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : customFeatures_;
      }
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getCustomFeaturesFieldBuilder() {
      if (customFeaturesBuilder_ == null) {
        customFeaturesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getCustomFeatures(), getParentForChildren(), isClean());
        customFeatures_ = null;
      }
      return customFeaturesBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList setValues_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSetValuesIsMutable() {
      if (!setValues_.isModifiable()) {
        setValues_ = new com.google.protobuf.LazyStringArrayList(setValues_);
      }
      bitField0_ |= 0x00004000;
    }
    /**
     *
     *
     * <pre>
     * Specifies the list of values allowed in the column.
     * Only used for set data type.
     * </pre>
     *
     * <code>repeated string set_values = 15;</code>
     *
     * @return A list containing the setValues.
     */
    public com.google.protobuf.ProtocolStringList getSetValuesList() {
      setValues_.makeImmutable();
      return setValues_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the list of values allowed in the column.
     * Only used for set data type.
     * </pre>
     *
     * <code>repeated string set_values = 15;</code>
     *
     * @return The count of setValues.
     */
    public int getSetValuesCount() {
      return setValues_.size();
    }
    /**
     *
     *
     * <pre>
     * Specifies the list of values allowed in the column.
     * Only used for set data type.
     * </pre>
     *
     * <code>repeated string set_values = 15;</code>
     *
     * @param index The index of the element to return.
     * @return The setValues at the given index.
     */
    public java.lang.String getSetValues(int index) {
      return setValues_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies the list of values allowed in the column.
     * Only used for set data type.
     * </pre>
     *
     * <code>repeated string set_values = 15;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the setValues at the given index.
     */
    public com.google.protobuf.ByteString getSetValuesBytes(int index) {
      return setValues_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies the list of values allowed in the column.
     * Only used for set data type.
     * </pre>
     *
     * <code>repeated string set_values = 15;</code>
     *
     * @param index The index to set the value at.
     * @param value The setValues to set.
     * @return This builder for chaining.
     */
    public Builder setSetValues(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSetValuesIsMutable();
      setValues_.set(index, value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the list of values allowed in the column.
     * Only used for set data type.
     * </pre>
     *
     * <code>repeated string set_values = 15;</code>
     *
     * @param value The setValues to add.
     * @return This builder for chaining.
     */
    public Builder addSetValues(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSetValuesIsMutable();
      setValues_.add(value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the list of values allowed in the column.
     * Only used for set data type.
     * </pre>
     *
     * <code>repeated string set_values = 15;</code>
     *
     * @param values The setValues to add.
     * @return This builder for chaining.
     */
    public Builder addAllSetValues(java.lang.Iterable<java.lang.String> values) {
      ensureSetValuesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, setValues_);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the list of values allowed in the column.
     * Only used for set data type.
     * </pre>
     *
     * <code>repeated string set_values = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSetValues() {
      setValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00004000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the list of values allowed in the column.
     * Only used for set data type.
     * </pre>
     *
     * <code>repeated string set_values = 15;</code>
     *
     * @param value The bytes of the setValues to add.
     * @return This builder for chaining.
     */
    public Builder addSetValuesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSetValuesIsMutable();
      setValues_.add(value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object comment_ = "";
    /**
     *
     *
     * <pre>
     * Comment associated with the column.
     * </pre>
     *
     * <code>string comment = 16;</code>
     *
     * @return The comment.
     */
    public java.lang.String getComment() {
      java.lang.Object ref = comment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        comment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Comment associated with the column.
     * </pre>
     *
     * <code>string comment = 16;</code>
     *
     * @return The bytes for comment.
     */
    public com.google.protobuf.ByteString getCommentBytes() {
      java.lang.Object ref = comment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        comment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Comment associated with the column.
     * </pre>
     *
     * <code>string comment = 16;</code>
     *
     * @param value The comment to set.
     * @return This builder for chaining.
     */
    public Builder setComment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      comment_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Comment associated with the column.
     * </pre>
     *
     * <code>string comment = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearComment() {
      comment_ = getDefaultInstance().getComment();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Comment associated with the column.
     * </pre>
     *
     * <code>string comment = 16;</code>
     *
     * @param value The bytes for comment to set.
     * @return This builder for chaining.
     */
    public Builder setCommentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      comment_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private int ordinalPosition_;
    /**
     *
     *
     * <pre>
     * Column order in the table.
     * </pre>
     *
     * <code>int32 ordinal_position = 17;</code>
     *
     * @return The ordinalPosition.
     */
    @java.lang.Override
    public int getOrdinalPosition() {
      return ordinalPosition_;
    }
    /**
     *
     *
     * <pre>
     * Column order in the table.
     * </pre>
     *
     * <code>int32 ordinal_position = 17;</code>
     *
     * @param value The ordinalPosition to set.
     * @return This builder for chaining.
     */
    public Builder setOrdinalPosition(int value) {

      ordinalPosition_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Column order in the table.
     * </pre>
     *
     * <code>int32 ordinal_position = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrdinalPosition() {
      bitField0_ = (bitField0_ & ~0x00010000);
      ordinalPosition_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object defaultValue_ = "";
    /**
     *
     *
     * <pre>
     * Default value of the column.
     * </pre>
     *
     * <code>string default_value = 18;</code>
     *
     * @return The defaultValue.
     */
    public java.lang.String getDefaultValue() {
      java.lang.Object ref = defaultValue_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultValue_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Default value of the column.
     * </pre>
     *
     * <code>string default_value = 18;</code>
     *
     * @return The bytes for defaultValue.
     */
    public com.google.protobuf.ByteString getDefaultValueBytes() {
      java.lang.Object ref = defaultValue_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Default value of the column.
     * </pre>
     *
     * <code>string default_value = 18;</code>
     *
     * @param value The defaultValue to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultValue_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default value of the column.
     * </pre>
     *
     * <code>string default_value = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultValue() {
      defaultValue_ = getDefaultInstance().getDefaultValue();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default value of the column.
     * </pre>
     *
     * <code>string default_value = 18;</code>
     *
     * @param value The bytes for defaultValue to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultValue_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.ColumnEntity)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.ColumnEntity)
  private static final com.google.cloud.clouddms.v1.ColumnEntity DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.ColumnEntity();
  }

  public static com.google.cloud.clouddms.v1.ColumnEntity getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ColumnEntity> PARSER =
      new com.google.protobuf.AbstractParser<ColumnEntity>() {
        @java.lang.Override
        public ColumnEntity parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ColumnEntity> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ColumnEntity> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.ColumnEntity getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
