/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Options to configure rule type ConditionalColumnSetValue.
 * The rule is used to transform the data which is being replicated/migrated.
 *
 * The rule filter field can refer to one or more entities.
 *
 * The rule scope can be one of: Column.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.ConditionalColumnSetValue}
 */
public final class ConditionalColumnSetValue extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.ConditionalColumnSetValue)
    ConditionalColumnSetValueOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConditionalColumnSetValue.newBuilder() to construct.
  private ConditionalColumnSetValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConditionalColumnSetValue() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConditionalColumnSetValue();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_ConditionalColumnSetValue_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_ConditionalColumnSetValue_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.ConditionalColumnSetValue.class,
            com.google.cloud.clouddms.v1.ConditionalColumnSetValue.Builder.class);
  }

  private int bitField0_;
  private int sourceFilterCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object sourceFilter_;

  public enum SourceFilterCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SOURCE_TEXT_FILTER(100),
    SOURCE_NUMERIC_FILTER(101),
    SOURCEFILTER_NOT_SET(0);
    private final int value;

    private SourceFilterCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceFilterCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceFilterCase forNumber(int value) {
      switch (value) {
        case 100:
          return SOURCE_TEXT_FILTER;
        case 101:
          return SOURCE_NUMERIC_FILTER;
        case 0:
          return SOURCEFILTER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceFilterCase getSourceFilterCase() {
    return SourceFilterCase.forNumber(sourceFilterCase_);
  }

  public static final int SOURCE_TEXT_FILTER_FIELD_NUMBER = 100;
  /**
   *
   *
   * <pre>
   * Optional. Optional filter on source column length. Used for text based
   * data types like varchar.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sourceTextFilter field is set.
   */
  @java.lang.Override
  public boolean hasSourceTextFilter() {
    return sourceFilterCase_ == 100;
  }
  /**
   *
   *
   * <pre>
   * Optional. Optional filter on source column length. Used for text based
   * data types like varchar.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sourceTextFilter.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SourceTextFilter getSourceTextFilter() {
    if (sourceFilterCase_ == 100) {
      return (com.google.cloud.clouddms.v1.SourceTextFilter) sourceFilter_;
    }
    return com.google.cloud.clouddms.v1.SourceTextFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Optional filter on source column length. Used for text based
   * data types like varchar.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SourceTextFilterOrBuilder getSourceTextFilterOrBuilder() {
    if (sourceFilterCase_ == 100) {
      return (com.google.cloud.clouddms.v1.SourceTextFilter) sourceFilter_;
    }
    return com.google.cloud.clouddms.v1.SourceTextFilter.getDefaultInstance();
  }

  public static final int SOURCE_NUMERIC_FILTER_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * Optional. Optional filter on source column precision and scale. Used for
   * fixed point numbers such as NUMERIC/NUMBER data types.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sourceNumericFilter field is set.
   */
  @java.lang.Override
  public boolean hasSourceNumericFilter() {
    return sourceFilterCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * Optional. Optional filter on source column precision and scale. Used for
   * fixed point numbers such as NUMERIC/NUMBER data types.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sourceNumericFilter.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SourceNumericFilter getSourceNumericFilter() {
    if (sourceFilterCase_ == 101) {
      return (com.google.cloud.clouddms.v1.SourceNumericFilter) sourceFilter_;
    }
    return com.google.cloud.clouddms.v1.SourceNumericFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Optional filter on source column precision and scale. Used for
   * fixed point numbers such as NUMERIC/NUMBER data types.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SourceNumericFilterOrBuilder
      getSourceNumericFilterOrBuilder() {
    if (sourceFilterCase_ == 101) {
      return (com.google.cloud.clouddms.v1.SourceNumericFilter) sourceFilter_;
    }
    return com.google.cloud.clouddms.v1.SourceNumericFilter.getDefaultInstance();
  }

  public static final int VALUE_TRANSFORMATION_FIELD_NUMBER = 1;
  private com.google.cloud.clouddms.v1.ValueTransformation valueTransformation_;
  /**
   *
   *
   * <pre>
   * Required. Description of data transformation during migration.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ValueTransformation value_transformation = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the valueTransformation field is set.
   */
  @java.lang.Override
  public boolean hasValueTransformation() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Description of data transformation during migration.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ValueTransformation value_transformation = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The valueTransformation.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ValueTransformation getValueTransformation() {
    return valueTransformation_ == null
        ? com.google.cloud.clouddms.v1.ValueTransformation.getDefaultInstance()
        : valueTransformation_;
  }
  /**
   *
   *
   * <pre>
   * Required. Description of data transformation during migration.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ValueTransformation value_transformation = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ValueTransformationOrBuilder
      getValueTransformationOrBuilder() {
    return valueTransformation_ == null
        ? com.google.cloud.clouddms.v1.ValueTransformation.getDefaultInstance()
        : valueTransformation_;
  }

  public static final int CUSTOM_FEATURES_FIELD_NUMBER = 2;
  private com.google.protobuf.Struct customFeatures_;
  /**
   *
   *
   * <pre>
   * Optional. Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the customFeatures field is set.
   */
  @java.lang.Override
  public boolean hasCustomFeatures() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The customFeatures.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getCustomFeatures() {
    return customFeatures_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : customFeatures_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getCustomFeaturesOrBuilder() {
    return customFeatures_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : customFeatures_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getValueTransformation());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getCustomFeatures());
    }
    if (sourceFilterCase_ == 100) {
      output.writeMessage(100, (com.google.cloud.clouddms.v1.SourceTextFilter) sourceFilter_);
    }
    if (sourceFilterCase_ == 101) {
      output.writeMessage(101, (com.google.cloud.clouddms.v1.SourceNumericFilter) sourceFilter_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getValueTransformation());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCustomFeatures());
    }
    if (sourceFilterCase_ == 100) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              100, (com.google.cloud.clouddms.v1.SourceTextFilter) sourceFilter_);
    }
    if (sourceFilterCase_ == 101) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              101, (com.google.cloud.clouddms.v1.SourceNumericFilter) sourceFilter_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.ConditionalColumnSetValue)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.ConditionalColumnSetValue other =
        (com.google.cloud.clouddms.v1.ConditionalColumnSetValue) obj;

    if (hasValueTransformation() != other.hasValueTransformation()) return false;
    if (hasValueTransformation()) {
      if (!getValueTransformation().equals(other.getValueTransformation())) return false;
    }
    if (hasCustomFeatures() != other.hasCustomFeatures()) return false;
    if (hasCustomFeatures()) {
      if (!getCustomFeatures().equals(other.getCustomFeatures())) return false;
    }
    if (!getSourceFilterCase().equals(other.getSourceFilterCase())) return false;
    switch (sourceFilterCase_) {
      case 100:
        if (!getSourceTextFilter().equals(other.getSourceTextFilter())) return false;
        break;
      case 101:
        if (!getSourceNumericFilter().equals(other.getSourceNumericFilter())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasValueTransformation()) {
      hash = (37 * hash) + VALUE_TRANSFORMATION_FIELD_NUMBER;
      hash = (53 * hash) + getValueTransformation().hashCode();
    }
    if (hasCustomFeatures()) {
      hash = (37 * hash) + CUSTOM_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getCustomFeatures().hashCode();
    }
    switch (sourceFilterCase_) {
      case 100:
        hash = (37 * hash) + SOURCE_TEXT_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getSourceTextFilter().hashCode();
        break;
      case 101:
        hash = (37 * hash) + SOURCE_NUMERIC_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getSourceNumericFilter().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.ConditionalColumnSetValue parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ConditionalColumnSetValue parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConditionalColumnSetValue parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ConditionalColumnSetValue parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConditionalColumnSetValue parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ConditionalColumnSetValue parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConditionalColumnSetValue parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ConditionalColumnSetValue parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConditionalColumnSetValue parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ConditionalColumnSetValue parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConditionalColumnSetValue parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ConditionalColumnSetValue parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.clouddms.v1.ConditionalColumnSetValue prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Options to configure rule type ConditionalColumnSetValue.
   * The rule is used to transform the data which is being replicated/migrated.
   *
   * The rule filter field can refer to one or more entities.
   *
   * The rule scope can be one of: Column.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.ConditionalColumnSetValue}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.ConditionalColumnSetValue)
      com.google.cloud.clouddms.v1.ConditionalColumnSetValueOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_ConditionalColumnSetValue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_ConditionalColumnSetValue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.ConditionalColumnSetValue.class,
              com.google.cloud.clouddms.v1.ConditionalColumnSetValue.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.ConditionalColumnSetValue.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getValueTransformationFieldBuilder();
        getCustomFeaturesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (sourceTextFilterBuilder_ != null) {
        sourceTextFilterBuilder_.clear();
      }
      if (sourceNumericFilterBuilder_ != null) {
        sourceNumericFilterBuilder_.clear();
      }
      valueTransformation_ = null;
      if (valueTransformationBuilder_ != null) {
        valueTransformationBuilder_.dispose();
        valueTransformationBuilder_ = null;
      }
      customFeatures_ = null;
      if (customFeaturesBuilder_ != null) {
        customFeaturesBuilder_.dispose();
        customFeaturesBuilder_ = null;
      }
      sourceFilterCase_ = 0;
      sourceFilter_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_ConditionalColumnSetValue_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConditionalColumnSetValue getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.ConditionalColumnSetValue.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConditionalColumnSetValue build() {
      com.google.cloud.clouddms.v1.ConditionalColumnSetValue result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConditionalColumnSetValue buildPartial() {
      com.google.cloud.clouddms.v1.ConditionalColumnSetValue result =
          new com.google.cloud.clouddms.v1.ConditionalColumnSetValue(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.ConditionalColumnSetValue result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.valueTransformation_ =
            valueTransformationBuilder_ == null
                ? valueTransformation_
                : valueTransformationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.customFeatures_ =
            customFeaturesBuilder_ == null ? customFeatures_ : customFeaturesBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.clouddms.v1.ConditionalColumnSetValue result) {
      result.sourceFilterCase_ = sourceFilterCase_;
      result.sourceFilter_ = this.sourceFilter_;
      if (sourceFilterCase_ == 100 && sourceTextFilterBuilder_ != null) {
        result.sourceFilter_ = sourceTextFilterBuilder_.build();
      }
      if (sourceFilterCase_ == 101 && sourceNumericFilterBuilder_ != null) {
        result.sourceFilter_ = sourceNumericFilterBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.ConditionalColumnSetValue) {
        return mergeFrom((com.google.cloud.clouddms.v1.ConditionalColumnSetValue) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.ConditionalColumnSetValue other) {
      if (other == com.google.cloud.clouddms.v1.ConditionalColumnSetValue.getDefaultInstance())
        return this;
      if (other.hasValueTransformation()) {
        mergeValueTransformation(other.getValueTransformation());
      }
      if (other.hasCustomFeatures()) {
        mergeCustomFeatures(other.getCustomFeatures());
      }
      switch (other.getSourceFilterCase()) {
        case SOURCE_TEXT_FILTER:
          {
            mergeSourceTextFilter(other.getSourceTextFilter());
            break;
          }
        case SOURCE_NUMERIC_FILTER:
          {
            mergeSourceNumericFilter(other.getSourceNumericFilter());
            break;
          }
        case SOURCEFILTER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getValueTransformationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCustomFeaturesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 802:
              {
                input.readMessage(
                    getSourceTextFilterFieldBuilder().getBuilder(), extensionRegistry);
                sourceFilterCase_ = 100;
                break;
              } // case 802
            case 810:
              {
                input.readMessage(
                    getSourceNumericFilterFieldBuilder().getBuilder(), extensionRegistry);
                sourceFilterCase_ = 101;
                break;
              } // case 810
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceFilterCase_ = 0;
    private java.lang.Object sourceFilter_;

    public SourceFilterCase getSourceFilterCase() {
      return SourceFilterCase.forNumber(sourceFilterCase_);
    }

    public Builder clearSourceFilter() {
      sourceFilterCase_ = 0;
      sourceFilter_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SourceTextFilter,
            com.google.cloud.clouddms.v1.SourceTextFilter.Builder,
            com.google.cloud.clouddms.v1.SourceTextFilterOrBuilder>
        sourceTextFilterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column length. Used for text based
     * data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sourceTextFilter field is set.
     */
    @java.lang.Override
    public boolean hasSourceTextFilter() {
      return sourceFilterCase_ == 100;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column length. Used for text based
     * data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sourceTextFilter.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SourceTextFilter getSourceTextFilter() {
      if (sourceTextFilterBuilder_ == null) {
        if (sourceFilterCase_ == 100) {
          return (com.google.cloud.clouddms.v1.SourceTextFilter) sourceFilter_;
        }
        return com.google.cloud.clouddms.v1.SourceTextFilter.getDefaultInstance();
      } else {
        if (sourceFilterCase_ == 100) {
          return sourceTextFilterBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.SourceTextFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column length. Used for text based
     * data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSourceTextFilter(com.google.cloud.clouddms.v1.SourceTextFilter value) {
      if (sourceTextFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceFilter_ = value;
        onChanged();
      } else {
        sourceTextFilterBuilder_.setMessage(value);
      }
      sourceFilterCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column length. Used for text based
     * data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSourceTextFilter(
        com.google.cloud.clouddms.v1.SourceTextFilter.Builder builderForValue) {
      if (sourceTextFilterBuilder_ == null) {
        sourceFilter_ = builderForValue.build();
        onChanged();
      } else {
        sourceTextFilterBuilder_.setMessage(builderForValue.build());
      }
      sourceFilterCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column length. Used for text based
     * data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSourceTextFilter(com.google.cloud.clouddms.v1.SourceTextFilter value) {
      if (sourceTextFilterBuilder_ == null) {
        if (sourceFilterCase_ == 100
            && sourceFilter_
                != com.google.cloud.clouddms.v1.SourceTextFilter.getDefaultInstance()) {
          sourceFilter_ =
              com.google.cloud.clouddms.v1.SourceTextFilter.newBuilder(
                      (com.google.cloud.clouddms.v1.SourceTextFilter) sourceFilter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceFilter_ = value;
        }
        onChanged();
      } else {
        if (sourceFilterCase_ == 100) {
          sourceTextFilterBuilder_.mergeFrom(value);
        } else {
          sourceTextFilterBuilder_.setMessage(value);
        }
      }
      sourceFilterCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column length. Used for text based
     * data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSourceTextFilter() {
      if (sourceTextFilterBuilder_ == null) {
        if (sourceFilterCase_ == 100) {
          sourceFilterCase_ = 0;
          sourceFilter_ = null;
          onChanged();
        }
      } else {
        if (sourceFilterCase_ == 100) {
          sourceFilterCase_ = 0;
          sourceFilter_ = null;
        }
        sourceTextFilterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column length. Used for text based
     * data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.SourceTextFilter.Builder getSourceTextFilterBuilder() {
      return getSourceTextFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column length. Used for text based
     * data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SourceTextFilterOrBuilder getSourceTextFilterOrBuilder() {
      if ((sourceFilterCase_ == 100) && (sourceTextFilterBuilder_ != null)) {
        return sourceTextFilterBuilder_.getMessageOrBuilder();
      } else {
        if (sourceFilterCase_ == 100) {
          return (com.google.cloud.clouddms.v1.SourceTextFilter) sourceFilter_;
        }
        return com.google.cloud.clouddms.v1.SourceTextFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column length. Used for text based
     * data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SourceTextFilter,
            com.google.cloud.clouddms.v1.SourceTextFilter.Builder,
            com.google.cloud.clouddms.v1.SourceTextFilterOrBuilder>
        getSourceTextFilterFieldBuilder() {
      if (sourceTextFilterBuilder_ == null) {
        if (!(sourceFilterCase_ == 100)) {
          sourceFilter_ = com.google.cloud.clouddms.v1.SourceTextFilter.getDefaultInstance();
        }
        sourceTextFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.SourceTextFilter,
                com.google.cloud.clouddms.v1.SourceTextFilter.Builder,
                com.google.cloud.clouddms.v1.SourceTextFilterOrBuilder>(
                (com.google.cloud.clouddms.v1.SourceTextFilter) sourceFilter_,
                getParentForChildren(),
                isClean());
        sourceFilter_ = null;
      }
      sourceFilterCase_ = 100;
      onChanged();
      return sourceTextFilterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SourceNumericFilter,
            com.google.cloud.clouddms.v1.SourceNumericFilter.Builder,
            com.google.cloud.clouddms.v1.SourceNumericFilterOrBuilder>
        sourceNumericFilterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column precision and scale. Used for
     * fixed point numbers such as NUMERIC/NUMBER data types.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sourceNumericFilter field is set.
     */
    @java.lang.Override
    public boolean hasSourceNumericFilter() {
      return sourceFilterCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column precision and scale. Used for
     * fixed point numbers such as NUMERIC/NUMBER data types.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sourceNumericFilter.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SourceNumericFilter getSourceNumericFilter() {
      if (sourceNumericFilterBuilder_ == null) {
        if (sourceFilterCase_ == 101) {
          return (com.google.cloud.clouddms.v1.SourceNumericFilter) sourceFilter_;
        }
        return com.google.cloud.clouddms.v1.SourceNumericFilter.getDefaultInstance();
      } else {
        if (sourceFilterCase_ == 101) {
          return sourceNumericFilterBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.SourceNumericFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column precision and scale. Used for
     * fixed point numbers such as NUMERIC/NUMBER data types.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSourceNumericFilter(com.google.cloud.clouddms.v1.SourceNumericFilter value) {
      if (sourceNumericFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceFilter_ = value;
        onChanged();
      } else {
        sourceNumericFilterBuilder_.setMessage(value);
      }
      sourceFilterCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column precision and scale. Used for
     * fixed point numbers such as NUMERIC/NUMBER data types.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSourceNumericFilter(
        com.google.cloud.clouddms.v1.SourceNumericFilter.Builder builderForValue) {
      if (sourceNumericFilterBuilder_ == null) {
        sourceFilter_ = builderForValue.build();
        onChanged();
      } else {
        sourceNumericFilterBuilder_.setMessage(builderForValue.build());
      }
      sourceFilterCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column precision and scale. Used for
     * fixed point numbers such as NUMERIC/NUMBER data types.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSourceNumericFilter(
        com.google.cloud.clouddms.v1.SourceNumericFilter value) {
      if (sourceNumericFilterBuilder_ == null) {
        if (sourceFilterCase_ == 101
            && sourceFilter_
                != com.google.cloud.clouddms.v1.SourceNumericFilter.getDefaultInstance()) {
          sourceFilter_ =
              com.google.cloud.clouddms.v1.SourceNumericFilter.newBuilder(
                      (com.google.cloud.clouddms.v1.SourceNumericFilter) sourceFilter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceFilter_ = value;
        }
        onChanged();
      } else {
        if (sourceFilterCase_ == 101) {
          sourceNumericFilterBuilder_.mergeFrom(value);
        } else {
          sourceNumericFilterBuilder_.setMessage(value);
        }
      }
      sourceFilterCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column precision and scale. Used for
     * fixed point numbers such as NUMERIC/NUMBER data types.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSourceNumericFilter() {
      if (sourceNumericFilterBuilder_ == null) {
        if (sourceFilterCase_ == 101) {
          sourceFilterCase_ = 0;
          sourceFilter_ = null;
          onChanged();
        }
      } else {
        if (sourceFilterCase_ == 101) {
          sourceFilterCase_ = 0;
          sourceFilter_ = null;
        }
        sourceNumericFilterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column precision and scale. Used for
     * fixed point numbers such as NUMERIC/NUMBER data types.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.SourceNumericFilter.Builder
        getSourceNumericFilterBuilder() {
      return getSourceNumericFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column precision and scale. Used for
     * fixed point numbers such as NUMERIC/NUMBER data types.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SourceNumericFilterOrBuilder
        getSourceNumericFilterOrBuilder() {
      if ((sourceFilterCase_ == 101) && (sourceNumericFilterBuilder_ != null)) {
        return sourceNumericFilterBuilder_.getMessageOrBuilder();
      } else {
        if (sourceFilterCase_ == 101) {
          return (com.google.cloud.clouddms.v1.SourceNumericFilter) sourceFilter_;
        }
        return com.google.cloud.clouddms.v1.SourceNumericFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional filter on source column precision and scale. Used for
     * fixed point numbers such as NUMERIC/NUMBER data types.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SourceNumericFilter,
            com.google.cloud.clouddms.v1.SourceNumericFilter.Builder,
            com.google.cloud.clouddms.v1.SourceNumericFilterOrBuilder>
        getSourceNumericFilterFieldBuilder() {
      if (sourceNumericFilterBuilder_ == null) {
        if (!(sourceFilterCase_ == 101)) {
          sourceFilter_ = com.google.cloud.clouddms.v1.SourceNumericFilter.getDefaultInstance();
        }
        sourceNumericFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.SourceNumericFilter,
                com.google.cloud.clouddms.v1.SourceNumericFilter.Builder,
                com.google.cloud.clouddms.v1.SourceNumericFilterOrBuilder>(
                (com.google.cloud.clouddms.v1.SourceNumericFilter) sourceFilter_,
                getParentForChildren(),
                isClean());
        sourceFilter_ = null;
      }
      sourceFilterCase_ = 101;
      onChanged();
      return sourceNumericFilterBuilder_;
    }

    private com.google.cloud.clouddms.v1.ValueTransformation valueTransformation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ValueTransformation,
            com.google.cloud.clouddms.v1.ValueTransformation.Builder,
            com.google.cloud.clouddms.v1.ValueTransformationOrBuilder>
        valueTransformationBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Description of data transformation during migration.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueTransformation value_transformation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the valueTransformation field is set.
     */
    public boolean hasValueTransformation() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Description of data transformation during migration.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueTransformation value_transformation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The valueTransformation.
     */
    public com.google.cloud.clouddms.v1.ValueTransformation getValueTransformation() {
      if (valueTransformationBuilder_ == null) {
        return valueTransformation_ == null
            ? com.google.cloud.clouddms.v1.ValueTransformation.getDefaultInstance()
            : valueTransformation_;
      } else {
        return valueTransformationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Description of data transformation during migration.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueTransformation value_transformation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setValueTransformation(com.google.cloud.clouddms.v1.ValueTransformation value) {
      if (valueTransformationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueTransformation_ = value;
      } else {
        valueTransformationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Description of data transformation during migration.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueTransformation value_transformation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setValueTransformation(
        com.google.cloud.clouddms.v1.ValueTransformation.Builder builderForValue) {
      if (valueTransformationBuilder_ == null) {
        valueTransformation_ = builderForValue.build();
      } else {
        valueTransformationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Description of data transformation during migration.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueTransformation value_transformation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeValueTransformation(
        com.google.cloud.clouddms.v1.ValueTransformation value) {
      if (valueTransformationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && valueTransformation_ != null
            && valueTransformation_
                != com.google.cloud.clouddms.v1.ValueTransformation.getDefaultInstance()) {
          getValueTransformationBuilder().mergeFrom(value);
        } else {
          valueTransformation_ = value;
        }
      } else {
        valueTransformationBuilder_.mergeFrom(value);
      }
      if (valueTransformation_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Description of data transformation during migration.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueTransformation value_transformation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearValueTransformation() {
      bitField0_ = (bitField0_ & ~0x00000004);
      valueTransformation_ = null;
      if (valueTransformationBuilder_ != null) {
        valueTransformationBuilder_.dispose();
        valueTransformationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Description of data transformation during migration.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueTransformation value_transformation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.ValueTransformation.Builder
        getValueTransformationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getValueTransformationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Description of data transformation during migration.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueTransformation value_transformation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.ValueTransformationOrBuilder
        getValueTransformationOrBuilder() {
      if (valueTransformationBuilder_ != null) {
        return valueTransformationBuilder_.getMessageOrBuilder();
      } else {
        return valueTransformation_ == null
            ? com.google.cloud.clouddms.v1.ValueTransformation.getDefaultInstance()
            : valueTransformation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Description of data transformation during migration.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueTransformation value_transformation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ValueTransformation,
            com.google.cloud.clouddms.v1.ValueTransformation.Builder,
            com.google.cloud.clouddms.v1.ValueTransformationOrBuilder>
        getValueTransformationFieldBuilder() {
      if (valueTransformationBuilder_ == null) {
        valueTransformationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.ValueTransformation,
                com.google.cloud.clouddms.v1.ValueTransformation.Builder,
                com.google.cloud.clouddms.v1.ValueTransformationOrBuilder>(
                getValueTransformation(), getParentForChildren(), isClean());
        valueTransformation_ = null;
      }
      return valueTransformationBuilder_;
    }

    private com.google.protobuf.Struct customFeatures_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        customFeaturesBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the customFeatures field is set.
     */
    public boolean hasCustomFeatures() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The customFeatures.
     */
    public com.google.protobuf.Struct getCustomFeatures() {
      if (customFeaturesBuilder_ == null) {
        return customFeatures_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : customFeatures_;
      } else {
        return customFeaturesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCustomFeatures(com.google.protobuf.Struct value) {
      if (customFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customFeatures_ = value;
      } else {
        customFeaturesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCustomFeatures(com.google.protobuf.Struct.Builder builderForValue) {
      if (customFeaturesBuilder_ == null) {
        customFeatures_ = builderForValue.build();
      } else {
        customFeaturesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCustomFeatures(com.google.protobuf.Struct value) {
      if (customFeaturesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && customFeatures_ != null
            && customFeatures_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getCustomFeaturesBuilder().mergeFrom(value);
        } else {
          customFeatures_ = value;
        }
      } else {
        customFeaturesBuilder_.mergeFrom(value);
      }
      if (customFeatures_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCustomFeatures() {
      bitField0_ = (bitField0_ & ~0x00000008);
      customFeatures_ = null;
      if (customFeaturesBuilder_ != null) {
        customFeaturesBuilder_.dispose();
        customFeaturesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct.Builder getCustomFeaturesBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCustomFeaturesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.StructOrBuilder getCustomFeaturesOrBuilder() {
      if (customFeaturesBuilder_ != null) {
        return customFeaturesBuilder_.getMessageOrBuilder();
      } else {
        return customFeatures_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : customFeatures_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getCustomFeaturesFieldBuilder() {
      if (customFeaturesBuilder_ == null) {
        customFeaturesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getCustomFeatures(), getParentForChildren(), isClean());
        customFeatures_ = null;
      }
      return customFeaturesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.ConditionalColumnSetValue)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.ConditionalColumnSetValue)
  private static final com.google.cloud.clouddms.v1.ConditionalColumnSetValue DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.ConditionalColumnSetValue();
  }

  public static com.google.cloud.clouddms.v1.ConditionalColumnSetValue getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConditionalColumnSetValue> PARSER =
      new com.google.protobuf.AbstractParser<ConditionalColumnSetValue>() {
        @java.lang.Override
        public ConditionalColumnSetValue parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ConditionalColumnSetValue> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConditionalColumnSetValue> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.ConditionalColumnSetValue getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
