/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * A connection profile definition.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.ConnectionProfile}
 */
public final class ConnectionProfile extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.ConnectionProfile)
    ConnectionProfileOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConnectionProfile.newBuilder() to construct.
  private ConnectionProfile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConnectionProfile() {
    name_ = "";
    state_ = 0;
    displayName_ = "";
    provider_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConnectionProfile();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_ConnectionProfile_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_ConnectionProfile_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.ConnectionProfile.class,
            com.google.cloud.clouddms.v1.ConnectionProfile.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The current connection profile state (e.g. DRAFT, READY, or FAILED).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.ConnectionProfile.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The state of the connection profile is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The connection profile is in draft mode and fully editable.
     * </pre>
     *
     * <code>DRAFT = 1;</code>
     */
    DRAFT(1),
    /**
     *
     *
     * <pre>
     * The connection profile is being created.
     * </pre>
     *
     * <code>CREATING = 2;</code>
     */
    CREATING(2),
    /**
     *
     *
     * <pre>
     * The connection profile is ready.
     * </pre>
     *
     * <code>READY = 3;</code>
     */
    READY(3),
    /**
     *
     *
     * <pre>
     * The connection profile is being updated.
     * </pre>
     *
     * <code>UPDATING = 4;</code>
     */
    UPDATING(4),
    /**
     *
     *
     * <pre>
     * The connection profile is being deleted.
     * </pre>
     *
     * <code>DELETING = 5;</code>
     */
    DELETING(5),
    /**
     *
     *
     * <pre>
     * The connection profile has been deleted.
     * </pre>
     *
     * <code>DELETED = 6;</code>
     */
    DELETED(6),
    /**
     *
     *
     * <pre>
     * The last action on the connection profile failed.
     * </pre>
     *
     * <code>FAILED = 7;</code>
     */
    FAILED(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The state of the connection profile is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The connection profile is in draft mode and fully editable.
     * </pre>
     *
     * <code>DRAFT = 1;</code>
     */
    public static final int DRAFT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The connection profile is being created.
     * </pre>
     *
     * <code>CREATING = 2;</code>
     */
    public static final int CREATING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The connection profile is ready.
     * </pre>
     *
     * <code>READY = 3;</code>
     */
    public static final int READY_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The connection profile is being updated.
     * </pre>
     *
     * <code>UPDATING = 4;</code>
     */
    public static final int UPDATING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The connection profile is being deleted.
     * </pre>
     *
     * <code>DELETING = 5;</code>
     */
    public static final int DELETING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The connection profile has been deleted.
     * </pre>
     *
     * <code>DELETED = 6;</code>
     */
    public static final int DELETED_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The last action on the connection profile failed.
     * </pre>
     *
     * <code>FAILED = 7;</code>
     */
    public static final int FAILED_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return DRAFT;
        case 2:
          return CREATING;
        case 3:
          return READY;
        case 4:
          return UPDATING;
        case 5:
          return DELETING;
        case 6:
          return DELETED;
        case 7:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConnectionProfile.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.ConnectionProfile.State)
  }

  private int bitField0_;
  private int connectionProfileCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object connectionProfile_;

  public enum ConnectionProfileCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MYSQL(100),
    POSTGRESQL(101),
    ORACLE(104),
    CLOUDSQL(102),
    ALLOYDB(105),
    CONNECTIONPROFILE_NOT_SET(0);
    private final int value;

    private ConnectionProfileCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConnectionProfileCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConnectionProfileCase forNumber(int value) {
      switch (value) {
        case 100:
          return MYSQL;
        case 101:
          return POSTGRESQL;
        case 104:
          return ORACLE;
        case 102:
          return CLOUDSQL;
        case 105:
          return ALLOYDB;
        case 0:
          return CONNECTIONPROFILE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConnectionProfileCase getConnectionProfileCase() {
    return ConnectionProfileCase.forNumber(connectionProfileCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of this connection profile resource in the form of
   * projects/{project}/locations/{location}/connectionProfiles/{connectionProfile}.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of this connection profile resource in the form of
   * projects/{project}/locations/{location}/connectionProfiles/{connectionProfile}.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was created.
   * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
   * Example: "2014-10-02T15:01:23.045123456Z".
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was created.
   * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
   * Example: "2014-10-02T15:01:23.045123456Z".
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was created.
   * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
   * Example: "2014-10-02T15:01:23.045123456Z".
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was last updated.
   * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
   * Example: "2014-10-02T15:01:23.045123456Z".
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was last updated.
   * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
   * Example: "2014-10-02T15:01:23.045123456Z".
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was last updated.
   * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
   * Example: "2014-10-02T15:01:23.045123456Z".
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.clouddms.v1.ClouddmsResourcesProto
                .internal_static_google_cloud_clouddms_v1_ConnectionProfile_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for connection profile to use to annotate any related
   * underlying resources such as Compute Engine VMs. An object containing a
   * list of "key": "value" pairs.
   *
   * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for connection profile to use to annotate any related
   * underlying resources such as Compute Engine VMs. An object containing a
   * list of "key": "value" pairs.
   *
   * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for connection profile to use to annotate any related
   * underlying resources such as Compute Engine VMs. An object containing a
   * list of "key": "value" pairs.
   *
   * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The resource labels for connection profile to use to annotate any related
   * underlying resources such as Compute Engine VMs. An object containing a
   * list of "key": "value" pairs.
   *
   * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * The current connection profile state (e.g. DRAFT, READY, or FAILED).
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ConnectionProfile.State state = 5;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * The current connection profile state (e.g. DRAFT, READY, or FAILED).
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ConnectionProfile.State state = 5;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ConnectionProfile.State getState() {
    com.google.cloud.clouddms.v1.ConnectionProfile.State result =
        com.google.cloud.clouddms.v1.ConnectionProfile.State.forNumber(state_);
    return result == null
        ? com.google.cloud.clouddms.v1.ConnectionProfile.State.UNRECOGNIZED
        : result;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The connection profile display name.
   * </pre>
   *
   * <code>string display_name = 6;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The connection profile display name.
   * </pre>
   *
   * <code>string display_name = 6;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MYSQL_FIELD_NUMBER = 100;
  /**
   *
   *
   * <pre>
   * A MySQL database connection profile.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.MySqlConnectionProfile mysql = 100;</code>
   *
   * @return Whether the mysql field is set.
   */
  @java.lang.Override
  public boolean hasMysql() {
    return connectionProfileCase_ == 100;
  }
  /**
   *
   *
   * <pre>
   * A MySQL database connection profile.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.MySqlConnectionProfile mysql = 100;</code>
   *
   * @return The mysql.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MySqlConnectionProfile getMysql() {
    if (connectionProfileCase_ == 100) {
      return (com.google.cloud.clouddms.v1.MySqlConnectionProfile) connectionProfile_;
    }
    return com.google.cloud.clouddms.v1.MySqlConnectionProfile.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A MySQL database connection profile.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.MySqlConnectionProfile mysql = 100;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MySqlConnectionProfileOrBuilder getMysqlOrBuilder() {
    if (connectionProfileCase_ == 100) {
      return (com.google.cloud.clouddms.v1.MySqlConnectionProfile) connectionProfile_;
    }
    return com.google.cloud.clouddms.v1.MySqlConnectionProfile.getDefaultInstance();
  }

  public static final int POSTGRESQL_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * A PostgreSQL database connection profile.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.PostgreSqlConnectionProfile postgresql = 101;</code>
   *
   * @return Whether the postgresql field is set.
   */
  @java.lang.Override
  public boolean hasPostgresql() {
    return connectionProfileCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * A PostgreSQL database connection profile.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.PostgreSqlConnectionProfile postgresql = 101;</code>
   *
   * @return The postgresql.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile getPostgresql() {
    if (connectionProfileCase_ == 101) {
      return (com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile) connectionProfile_;
    }
    return com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A PostgreSQL database connection profile.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.PostgreSqlConnectionProfile postgresql = 101;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.PostgreSqlConnectionProfileOrBuilder
      getPostgresqlOrBuilder() {
    if (connectionProfileCase_ == 101) {
      return (com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile) connectionProfile_;
    }
    return com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile.getDefaultInstance();
  }

  public static final int ORACLE_FIELD_NUMBER = 104;
  /**
   *
   *
   * <pre>
   * An Oracle database connection profile.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.OracleConnectionProfile oracle = 104;</code>
   *
   * @return Whether the oracle field is set.
   */
  @java.lang.Override
  public boolean hasOracle() {
    return connectionProfileCase_ == 104;
  }
  /**
   *
   *
   * <pre>
   * An Oracle database connection profile.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.OracleConnectionProfile oracle = 104;</code>
   *
   * @return The oracle.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.OracleConnectionProfile getOracle() {
    if (connectionProfileCase_ == 104) {
      return (com.google.cloud.clouddms.v1.OracleConnectionProfile) connectionProfile_;
    }
    return com.google.cloud.clouddms.v1.OracleConnectionProfile.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An Oracle database connection profile.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.OracleConnectionProfile oracle = 104;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.OracleConnectionProfileOrBuilder getOracleOrBuilder() {
    if (connectionProfileCase_ == 104) {
      return (com.google.cloud.clouddms.v1.OracleConnectionProfile) connectionProfile_;
    }
    return com.google.cloud.clouddms.v1.OracleConnectionProfile.getDefaultInstance();
  }

  public static final int CLOUDSQL_FIELD_NUMBER = 102;
  /**
   *
   *
   * <pre>
   * A CloudSQL database connection profile.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.CloudSqlConnectionProfile cloudsql = 102;</code>
   *
   * @return Whether the cloudsql field is set.
   */
  @java.lang.Override
  public boolean hasCloudsql() {
    return connectionProfileCase_ == 102;
  }
  /**
   *
   *
   * <pre>
   * A CloudSQL database connection profile.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.CloudSqlConnectionProfile cloudsql = 102;</code>
   *
   * @return The cloudsql.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.CloudSqlConnectionProfile getCloudsql() {
    if (connectionProfileCase_ == 102) {
      return (com.google.cloud.clouddms.v1.CloudSqlConnectionProfile) connectionProfile_;
    }
    return com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A CloudSQL database connection profile.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.CloudSqlConnectionProfile cloudsql = 102;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.CloudSqlConnectionProfileOrBuilder getCloudsqlOrBuilder() {
    if (connectionProfileCase_ == 102) {
      return (com.google.cloud.clouddms.v1.CloudSqlConnectionProfile) connectionProfile_;
    }
    return com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.getDefaultInstance();
  }

  public static final int ALLOYDB_FIELD_NUMBER = 105;
  /**
   *
   *
   * <pre>
   * An AlloyDB cluster connection profile.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.AlloyDbConnectionProfile alloydb = 105;</code>
   *
   * @return Whether the alloydb field is set.
   */
  @java.lang.Override
  public boolean hasAlloydb() {
    return connectionProfileCase_ == 105;
  }
  /**
   *
   *
   * <pre>
   * An AlloyDB cluster connection profile.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.AlloyDbConnectionProfile alloydb = 105;</code>
   *
   * @return The alloydb.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.AlloyDbConnectionProfile getAlloydb() {
    if (connectionProfileCase_ == 105) {
      return (com.google.cloud.clouddms.v1.AlloyDbConnectionProfile) connectionProfile_;
    }
    return com.google.cloud.clouddms.v1.AlloyDbConnectionProfile.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An AlloyDB cluster connection profile.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.AlloyDbConnectionProfile alloydb = 105;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.AlloyDbConnectionProfileOrBuilder getAlloydbOrBuilder() {
    if (connectionProfileCase_ == 105) {
      return (com.google.cloud.clouddms.v1.AlloyDbConnectionProfile) connectionProfile_;
    }
    return com.google.cloud.clouddms.v1.AlloyDbConnectionProfile.getDefaultInstance();
  }

  public static final int ERROR_FIELD_NUMBER = 7;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Output only. The error details in case of state FAILED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The error details in case of state FAILED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The error details in case of state FAILED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  public static final int PROVIDER_FIELD_NUMBER = 8;
  private int provider_ = 0;
  /**
   *
   *
   * <pre>
   * The database provider.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseProvider provider = 8;</code>
   *
   * @return The enum numeric value on the wire for provider.
   */
  @java.lang.Override
  public int getProviderValue() {
    return provider_;
  }
  /**
   *
   *
   * <pre>
   * The database provider.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseProvider provider = 8;</code>
   *
   * @return The provider.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseProvider getProvider() {
    com.google.cloud.clouddms.v1.DatabaseProvider result =
        com.google.cloud.clouddms.v1.DatabaseProvider.forNumber(provider_);
    return result == null ? com.google.cloud.clouddms.v1.DatabaseProvider.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (state_
        != com.google.cloud.clouddms.v1.ConnectionProfile.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, displayName_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getError());
    }
    if (provider_
        != com.google.cloud.clouddms.v1.DatabaseProvider.DATABASE_PROVIDER_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, provider_);
    }
    if (connectionProfileCase_ == 100) {
      output.writeMessage(
          100, (com.google.cloud.clouddms.v1.MySqlConnectionProfile) connectionProfile_);
    }
    if (connectionProfileCase_ == 101) {
      output.writeMessage(
          101, (com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile) connectionProfile_);
    }
    if (connectionProfileCase_ == 102) {
      output.writeMessage(
          102, (com.google.cloud.clouddms.v1.CloudSqlConnectionProfile) connectionProfile_);
    }
    if (connectionProfileCase_ == 104) {
      output.writeMessage(
          104, (com.google.cloud.clouddms.v1.OracleConnectionProfile) connectionProfile_);
    }
    if (connectionProfileCase_ == 105) {
      output.writeMessage(
          105, (com.google.cloud.clouddms.v1.AlloyDbConnectionProfile) connectionProfile_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (state_
        != com.google.cloud.clouddms.v1.ConnectionProfile.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, displayName_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getError());
    }
    if (provider_
        != com.google.cloud.clouddms.v1.DatabaseProvider.DATABASE_PROVIDER_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, provider_);
    }
    if (connectionProfileCase_ == 100) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              100, (com.google.cloud.clouddms.v1.MySqlConnectionProfile) connectionProfile_);
    }
    if (connectionProfileCase_ == 101) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              101, (com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile) connectionProfile_);
    }
    if (connectionProfileCase_ == 102) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              102, (com.google.cloud.clouddms.v1.CloudSqlConnectionProfile) connectionProfile_);
    }
    if (connectionProfileCase_ == 104) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              104, (com.google.cloud.clouddms.v1.OracleConnectionProfile) connectionProfile_);
    }
    if (connectionProfileCase_ == 105) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              105, (com.google.cloud.clouddms.v1.AlloyDbConnectionProfile) connectionProfile_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.ConnectionProfile)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.ConnectionProfile other =
        (com.google.cloud.clouddms.v1.ConnectionProfile) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (state_ != other.state_) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (provider_ != other.provider_) return false;
    if (!getConnectionProfileCase().equals(other.getConnectionProfileCase())) return false;
    switch (connectionProfileCase_) {
      case 100:
        if (!getMysql().equals(other.getMysql())) return false;
        break;
      case 101:
        if (!getPostgresql().equals(other.getPostgresql())) return false;
        break;
      case 104:
        if (!getOracle().equals(other.getOracle())) return false;
        break;
      case 102:
        if (!getCloudsql().equals(other.getCloudsql())) return false;
        break;
      case 105:
        if (!getAlloydb().equals(other.getAlloydb())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    hash = (37 * hash) + PROVIDER_FIELD_NUMBER;
    hash = (53 * hash) + provider_;
    switch (connectionProfileCase_) {
      case 100:
        hash = (37 * hash) + MYSQL_FIELD_NUMBER;
        hash = (53 * hash) + getMysql().hashCode();
        break;
      case 101:
        hash = (37 * hash) + POSTGRESQL_FIELD_NUMBER;
        hash = (53 * hash) + getPostgresql().hashCode();
        break;
      case 104:
        hash = (37 * hash) + ORACLE_FIELD_NUMBER;
        hash = (53 * hash) + getOracle().hashCode();
        break;
      case 102:
        hash = (37 * hash) + CLOUDSQL_FIELD_NUMBER;
        hash = (53 * hash) + getCloudsql().hashCode();
        break;
      case 105:
        hash = (37 * hash) + ALLOYDB_FIELD_NUMBER;
        hash = (53 * hash) + getAlloydb().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.ConnectionProfile parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ConnectionProfile parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConnectionProfile parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ConnectionProfile parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConnectionProfile parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ConnectionProfile parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConnectionProfile parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ConnectionProfile parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConnectionProfile parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ConnectionProfile parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConnectionProfile parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ConnectionProfile parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.ConnectionProfile prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A connection profile definition.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.ConnectionProfile}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.ConnectionProfile)
      com.google.cloud.clouddms.v1.ConnectionProfileOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_ConnectionProfile_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_ConnectionProfile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.ConnectionProfile.class,
              com.google.cloud.clouddms.v1.ConnectionProfile.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.ConnectionProfile.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getErrorFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      state_ = 0;
      displayName_ = "";
      if (mysqlBuilder_ != null) {
        mysqlBuilder_.clear();
      }
      if (postgresqlBuilder_ != null) {
        postgresqlBuilder_.clear();
      }
      if (oracleBuilder_ != null) {
        oracleBuilder_.clear();
      }
      if (cloudsqlBuilder_ != null) {
        cloudsqlBuilder_.clear();
      }
      if (alloydbBuilder_ != null) {
        alloydbBuilder_.clear();
      }
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      provider_ = 0;
      connectionProfileCase_ = 0;
      connectionProfile_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_ConnectionProfile_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConnectionProfile getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.ConnectionProfile.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConnectionProfile build() {
      com.google.cloud.clouddms.v1.ConnectionProfile result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConnectionProfile buildPartial() {
      com.google.cloud.clouddms.v1.ConnectionProfile result =
          new com.google.cloud.clouddms.v1.ConnectionProfile(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.ConnectionProfile result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.provider_ = provider_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.clouddms.v1.ConnectionProfile result) {
      result.connectionProfileCase_ = connectionProfileCase_;
      result.connectionProfile_ = this.connectionProfile_;
      if (connectionProfileCase_ == 100 && mysqlBuilder_ != null) {
        result.connectionProfile_ = mysqlBuilder_.build();
      }
      if (connectionProfileCase_ == 101 && postgresqlBuilder_ != null) {
        result.connectionProfile_ = postgresqlBuilder_.build();
      }
      if (connectionProfileCase_ == 104 && oracleBuilder_ != null) {
        result.connectionProfile_ = oracleBuilder_.build();
      }
      if (connectionProfileCase_ == 102 && cloudsqlBuilder_ != null) {
        result.connectionProfile_ = cloudsqlBuilder_.build();
      }
      if (connectionProfileCase_ == 105 && alloydbBuilder_ != null) {
        result.connectionProfile_ = alloydbBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.ConnectionProfile) {
        return mergeFrom((com.google.cloud.clouddms.v1.ConnectionProfile) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.ConnectionProfile other) {
      if (other == com.google.cloud.clouddms.v1.ConnectionProfile.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (other.provider_ != 0) {
        setProviderValue(other.getProviderValue());
      }
      switch (other.getConnectionProfileCase()) {
        case MYSQL:
          {
            mergeMysql(other.getMysql());
            break;
          }
        case POSTGRESQL:
          {
            mergePostgresql(other.getPostgresql());
            break;
          }
        case ORACLE:
          {
            mergeOracle(other.getOracle());
            break;
          }
        case CLOUDSQL:
          {
            mergeCloudsql(other.getCloudsql());
            break;
          }
        case ALLOYDB:
          {
            mergeAlloydb(other.getAlloydb());
            break;
          }
        case CONNECTIONPROFILE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 58
            case 64:
              {
                provider_ = input.readEnum();
                bitField0_ |= 0x00001000;
                break;
              } // case 64
            case 802:
              {
                input.readMessage(getMysqlFieldBuilder().getBuilder(), extensionRegistry);
                connectionProfileCase_ = 100;
                break;
              } // case 802
            case 810:
              {
                input.readMessage(getPostgresqlFieldBuilder().getBuilder(), extensionRegistry);
                connectionProfileCase_ = 101;
                break;
              } // case 810
            case 818:
              {
                input.readMessage(getCloudsqlFieldBuilder().getBuilder(), extensionRegistry);
                connectionProfileCase_ = 102;
                break;
              } // case 818
            case 834:
              {
                input.readMessage(getOracleFieldBuilder().getBuilder(), extensionRegistry);
                connectionProfileCase_ = 104;
                break;
              } // case 834
            case 842:
              {
                input.readMessage(getAlloydbFieldBuilder().getBuilder(), extensionRegistry);
                connectionProfileCase_ = 105;
                break;
              } // case 842
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int connectionProfileCase_ = 0;
    private java.lang.Object connectionProfile_;

    public ConnectionProfileCase getConnectionProfileCase() {
      return ConnectionProfileCase.forNumber(connectionProfileCase_);
    }

    public Builder clearConnectionProfile() {
      connectionProfileCase_ = 0;
      connectionProfile_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of this connection profile resource in the form of
     * projects/{project}/locations/{location}/connectionProfiles/{connectionProfile}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of this connection profile resource in the form of
     * projects/{project}/locations/{location}/connectionProfiles/{connectionProfile}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of this connection profile resource in the form of
     * projects/{project}/locations/{location}/connectionProfiles/{connectionProfile}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of this connection profile resource in the form of
     * projects/{project}/locations/{location}/connectionProfiles/{connectionProfile}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of this connection profile resource in the form of
     * projects/{project}/locations/{location}/connectionProfiles/{connectionProfile}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for connection profile to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for connection profile to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for connection profile to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for connection profile to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for connection profile to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for connection profile to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for connection profile to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The current connection profile state (e.g. DRAFT, READY, or FAILED).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ConnectionProfile.State state = 5;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The current connection profile state (e.g. DRAFT, READY, or FAILED).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ConnectionProfile.State state = 5;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current connection profile state (e.g. DRAFT, READY, or FAILED).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ConnectionProfile.State state = 5;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConnectionProfile.State getState() {
      com.google.cloud.clouddms.v1.ConnectionProfile.State result =
          com.google.cloud.clouddms.v1.ConnectionProfile.State.forNumber(state_);
      return result == null
          ? com.google.cloud.clouddms.v1.ConnectionProfile.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The current connection profile state (e.g. DRAFT, READY, or FAILED).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ConnectionProfile.State state = 5;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.clouddms.v1.ConnectionProfile.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current connection profile state (e.g. DRAFT, READY, or FAILED).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ConnectionProfile.State state = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The connection profile display name.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The connection profile display name.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The connection profile display name.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The connection profile display name.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The connection profile display name.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.MySqlConnectionProfile,
            com.google.cloud.clouddms.v1.MySqlConnectionProfile.Builder,
            com.google.cloud.clouddms.v1.MySqlConnectionProfileOrBuilder>
        mysqlBuilder_;
    /**
     *
     *
     * <pre>
     * A MySQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MySqlConnectionProfile mysql = 100;</code>
     *
     * @return Whether the mysql field is set.
     */
    @java.lang.Override
    public boolean hasMysql() {
      return connectionProfileCase_ == 100;
    }
    /**
     *
     *
     * <pre>
     * A MySQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MySqlConnectionProfile mysql = 100;</code>
     *
     * @return The mysql.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.MySqlConnectionProfile getMysql() {
      if (mysqlBuilder_ == null) {
        if (connectionProfileCase_ == 100) {
          return (com.google.cloud.clouddms.v1.MySqlConnectionProfile) connectionProfile_;
        }
        return com.google.cloud.clouddms.v1.MySqlConnectionProfile.getDefaultInstance();
      } else {
        if (connectionProfileCase_ == 100) {
          return mysqlBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.MySqlConnectionProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A MySQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MySqlConnectionProfile mysql = 100;</code>
     */
    public Builder setMysql(com.google.cloud.clouddms.v1.MySqlConnectionProfile value) {
      if (mysqlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectionProfile_ = value;
        onChanged();
      } else {
        mysqlBuilder_.setMessage(value);
      }
      connectionProfileCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A MySQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MySqlConnectionProfile mysql = 100;</code>
     */
    public Builder setMysql(
        com.google.cloud.clouddms.v1.MySqlConnectionProfile.Builder builderForValue) {
      if (mysqlBuilder_ == null) {
        connectionProfile_ = builderForValue.build();
        onChanged();
      } else {
        mysqlBuilder_.setMessage(builderForValue.build());
      }
      connectionProfileCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A MySQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MySqlConnectionProfile mysql = 100;</code>
     */
    public Builder mergeMysql(com.google.cloud.clouddms.v1.MySqlConnectionProfile value) {
      if (mysqlBuilder_ == null) {
        if (connectionProfileCase_ == 100
            && connectionProfile_
                != com.google.cloud.clouddms.v1.MySqlConnectionProfile.getDefaultInstance()) {
          connectionProfile_ =
              com.google.cloud.clouddms.v1.MySqlConnectionProfile.newBuilder(
                      (com.google.cloud.clouddms.v1.MySqlConnectionProfile) connectionProfile_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectionProfile_ = value;
        }
        onChanged();
      } else {
        if (connectionProfileCase_ == 100) {
          mysqlBuilder_.mergeFrom(value);
        } else {
          mysqlBuilder_.setMessage(value);
        }
      }
      connectionProfileCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A MySQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MySqlConnectionProfile mysql = 100;</code>
     */
    public Builder clearMysql() {
      if (mysqlBuilder_ == null) {
        if (connectionProfileCase_ == 100) {
          connectionProfileCase_ = 0;
          connectionProfile_ = null;
          onChanged();
        }
      } else {
        if (connectionProfileCase_ == 100) {
          connectionProfileCase_ = 0;
          connectionProfile_ = null;
        }
        mysqlBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A MySQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MySqlConnectionProfile mysql = 100;</code>
     */
    public com.google.cloud.clouddms.v1.MySqlConnectionProfile.Builder getMysqlBuilder() {
      return getMysqlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A MySQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MySqlConnectionProfile mysql = 100;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.MySqlConnectionProfileOrBuilder getMysqlOrBuilder() {
      if ((connectionProfileCase_ == 100) && (mysqlBuilder_ != null)) {
        return mysqlBuilder_.getMessageOrBuilder();
      } else {
        if (connectionProfileCase_ == 100) {
          return (com.google.cloud.clouddms.v1.MySqlConnectionProfile) connectionProfile_;
        }
        return com.google.cloud.clouddms.v1.MySqlConnectionProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A MySQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MySqlConnectionProfile mysql = 100;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.MySqlConnectionProfile,
            com.google.cloud.clouddms.v1.MySqlConnectionProfile.Builder,
            com.google.cloud.clouddms.v1.MySqlConnectionProfileOrBuilder>
        getMysqlFieldBuilder() {
      if (mysqlBuilder_ == null) {
        if (!(connectionProfileCase_ == 100)) {
          connectionProfile_ =
              com.google.cloud.clouddms.v1.MySqlConnectionProfile.getDefaultInstance();
        }
        mysqlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.MySqlConnectionProfile,
                com.google.cloud.clouddms.v1.MySqlConnectionProfile.Builder,
                com.google.cloud.clouddms.v1.MySqlConnectionProfileOrBuilder>(
                (com.google.cloud.clouddms.v1.MySqlConnectionProfile) connectionProfile_,
                getParentForChildren(),
                isClean());
        connectionProfile_ = null;
      }
      connectionProfileCase_ = 100;
      onChanged();
      return mysqlBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile,
            com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile.Builder,
            com.google.cloud.clouddms.v1.PostgreSqlConnectionProfileOrBuilder>
        postgresqlBuilder_;
    /**
     *
     *
     * <pre>
     * A PostgreSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PostgreSqlConnectionProfile postgresql = 101;</code>
     *
     * @return Whether the postgresql field is set.
     */
    @java.lang.Override
    public boolean hasPostgresql() {
      return connectionProfileCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * A PostgreSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PostgreSqlConnectionProfile postgresql = 101;</code>
     *
     * @return The postgresql.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile getPostgresql() {
      if (postgresqlBuilder_ == null) {
        if (connectionProfileCase_ == 101) {
          return (com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile) connectionProfile_;
        }
        return com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile.getDefaultInstance();
      } else {
        if (connectionProfileCase_ == 101) {
          return postgresqlBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A PostgreSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PostgreSqlConnectionProfile postgresql = 101;</code>
     */
    public Builder setPostgresql(com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile value) {
      if (postgresqlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectionProfile_ = value;
        onChanged();
      } else {
        postgresqlBuilder_.setMessage(value);
      }
      connectionProfileCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A PostgreSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PostgreSqlConnectionProfile postgresql = 101;</code>
     */
    public Builder setPostgresql(
        com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile.Builder builderForValue) {
      if (postgresqlBuilder_ == null) {
        connectionProfile_ = builderForValue.build();
        onChanged();
      } else {
        postgresqlBuilder_.setMessage(builderForValue.build());
      }
      connectionProfileCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A PostgreSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PostgreSqlConnectionProfile postgresql = 101;</code>
     */
    public Builder mergePostgresql(com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile value) {
      if (postgresqlBuilder_ == null) {
        if (connectionProfileCase_ == 101
            && connectionProfile_
                != com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile.getDefaultInstance()) {
          connectionProfile_ =
              com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile.newBuilder(
                      (com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile) connectionProfile_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectionProfile_ = value;
        }
        onChanged();
      } else {
        if (connectionProfileCase_ == 101) {
          postgresqlBuilder_.mergeFrom(value);
        } else {
          postgresqlBuilder_.setMessage(value);
        }
      }
      connectionProfileCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A PostgreSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PostgreSqlConnectionProfile postgresql = 101;</code>
     */
    public Builder clearPostgresql() {
      if (postgresqlBuilder_ == null) {
        if (connectionProfileCase_ == 101) {
          connectionProfileCase_ = 0;
          connectionProfile_ = null;
          onChanged();
        }
      } else {
        if (connectionProfileCase_ == 101) {
          connectionProfileCase_ = 0;
          connectionProfile_ = null;
        }
        postgresqlBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A PostgreSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PostgreSqlConnectionProfile postgresql = 101;</code>
     */
    public com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile.Builder getPostgresqlBuilder() {
      return getPostgresqlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A PostgreSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PostgreSqlConnectionProfile postgresql = 101;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.PostgreSqlConnectionProfileOrBuilder
        getPostgresqlOrBuilder() {
      if ((connectionProfileCase_ == 101) && (postgresqlBuilder_ != null)) {
        return postgresqlBuilder_.getMessageOrBuilder();
      } else {
        if (connectionProfileCase_ == 101) {
          return (com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile) connectionProfile_;
        }
        return com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A PostgreSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PostgreSqlConnectionProfile postgresql = 101;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile,
            com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile.Builder,
            com.google.cloud.clouddms.v1.PostgreSqlConnectionProfileOrBuilder>
        getPostgresqlFieldBuilder() {
      if (postgresqlBuilder_ == null) {
        if (!(connectionProfileCase_ == 101)) {
          connectionProfile_ =
              com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile.getDefaultInstance();
        }
        postgresqlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile,
                com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile.Builder,
                com.google.cloud.clouddms.v1.PostgreSqlConnectionProfileOrBuilder>(
                (com.google.cloud.clouddms.v1.PostgreSqlConnectionProfile) connectionProfile_,
                getParentForChildren(),
                isClean());
        connectionProfile_ = null;
      }
      connectionProfileCase_ = 101;
      onChanged();
      return postgresqlBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.OracleConnectionProfile,
            com.google.cloud.clouddms.v1.OracleConnectionProfile.Builder,
            com.google.cloud.clouddms.v1.OracleConnectionProfileOrBuilder>
        oracleBuilder_;
    /**
     *
     *
     * <pre>
     * An Oracle database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.OracleConnectionProfile oracle = 104;</code>
     *
     * @return Whether the oracle field is set.
     */
    @java.lang.Override
    public boolean hasOracle() {
      return connectionProfileCase_ == 104;
    }
    /**
     *
     *
     * <pre>
     * An Oracle database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.OracleConnectionProfile oracle = 104;</code>
     *
     * @return The oracle.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.OracleConnectionProfile getOracle() {
      if (oracleBuilder_ == null) {
        if (connectionProfileCase_ == 104) {
          return (com.google.cloud.clouddms.v1.OracleConnectionProfile) connectionProfile_;
        }
        return com.google.cloud.clouddms.v1.OracleConnectionProfile.getDefaultInstance();
      } else {
        if (connectionProfileCase_ == 104) {
          return oracleBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.OracleConnectionProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An Oracle database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.OracleConnectionProfile oracle = 104;</code>
     */
    public Builder setOracle(com.google.cloud.clouddms.v1.OracleConnectionProfile value) {
      if (oracleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectionProfile_ = value;
        onChanged();
      } else {
        oracleBuilder_.setMessage(value);
      }
      connectionProfileCase_ = 104;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An Oracle database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.OracleConnectionProfile oracle = 104;</code>
     */
    public Builder setOracle(
        com.google.cloud.clouddms.v1.OracleConnectionProfile.Builder builderForValue) {
      if (oracleBuilder_ == null) {
        connectionProfile_ = builderForValue.build();
        onChanged();
      } else {
        oracleBuilder_.setMessage(builderForValue.build());
      }
      connectionProfileCase_ = 104;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An Oracle database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.OracleConnectionProfile oracle = 104;</code>
     */
    public Builder mergeOracle(com.google.cloud.clouddms.v1.OracleConnectionProfile value) {
      if (oracleBuilder_ == null) {
        if (connectionProfileCase_ == 104
            && connectionProfile_
                != com.google.cloud.clouddms.v1.OracleConnectionProfile.getDefaultInstance()) {
          connectionProfile_ =
              com.google.cloud.clouddms.v1.OracleConnectionProfile.newBuilder(
                      (com.google.cloud.clouddms.v1.OracleConnectionProfile) connectionProfile_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectionProfile_ = value;
        }
        onChanged();
      } else {
        if (connectionProfileCase_ == 104) {
          oracleBuilder_.mergeFrom(value);
        } else {
          oracleBuilder_.setMessage(value);
        }
      }
      connectionProfileCase_ = 104;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An Oracle database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.OracleConnectionProfile oracle = 104;</code>
     */
    public Builder clearOracle() {
      if (oracleBuilder_ == null) {
        if (connectionProfileCase_ == 104) {
          connectionProfileCase_ = 0;
          connectionProfile_ = null;
          onChanged();
        }
      } else {
        if (connectionProfileCase_ == 104) {
          connectionProfileCase_ = 0;
          connectionProfile_ = null;
        }
        oracleBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An Oracle database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.OracleConnectionProfile oracle = 104;</code>
     */
    public com.google.cloud.clouddms.v1.OracleConnectionProfile.Builder getOracleBuilder() {
      return getOracleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An Oracle database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.OracleConnectionProfile oracle = 104;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.OracleConnectionProfileOrBuilder getOracleOrBuilder() {
      if ((connectionProfileCase_ == 104) && (oracleBuilder_ != null)) {
        return oracleBuilder_.getMessageOrBuilder();
      } else {
        if (connectionProfileCase_ == 104) {
          return (com.google.cloud.clouddms.v1.OracleConnectionProfile) connectionProfile_;
        }
        return com.google.cloud.clouddms.v1.OracleConnectionProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An Oracle database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.OracleConnectionProfile oracle = 104;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.OracleConnectionProfile,
            com.google.cloud.clouddms.v1.OracleConnectionProfile.Builder,
            com.google.cloud.clouddms.v1.OracleConnectionProfileOrBuilder>
        getOracleFieldBuilder() {
      if (oracleBuilder_ == null) {
        if (!(connectionProfileCase_ == 104)) {
          connectionProfile_ =
              com.google.cloud.clouddms.v1.OracleConnectionProfile.getDefaultInstance();
        }
        oracleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.OracleConnectionProfile,
                com.google.cloud.clouddms.v1.OracleConnectionProfile.Builder,
                com.google.cloud.clouddms.v1.OracleConnectionProfileOrBuilder>(
                (com.google.cloud.clouddms.v1.OracleConnectionProfile) connectionProfile_,
                getParentForChildren(),
                isClean());
        connectionProfile_ = null;
      }
      connectionProfileCase_ = 104;
      onChanged();
      return oracleBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.CloudSqlConnectionProfile,
            com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.Builder,
            com.google.cloud.clouddms.v1.CloudSqlConnectionProfileOrBuilder>
        cloudsqlBuilder_;
    /**
     *
     *
     * <pre>
     * A CloudSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlConnectionProfile cloudsql = 102;</code>
     *
     * @return Whether the cloudsql field is set.
     */
    @java.lang.Override
    public boolean hasCloudsql() {
      return connectionProfileCase_ == 102;
    }
    /**
     *
     *
     * <pre>
     * A CloudSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlConnectionProfile cloudsql = 102;</code>
     *
     * @return The cloudsql.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.CloudSqlConnectionProfile getCloudsql() {
      if (cloudsqlBuilder_ == null) {
        if (connectionProfileCase_ == 102) {
          return (com.google.cloud.clouddms.v1.CloudSqlConnectionProfile) connectionProfile_;
        }
        return com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.getDefaultInstance();
      } else {
        if (connectionProfileCase_ == 102) {
          return cloudsqlBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A CloudSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlConnectionProfile cloudsql = 102;</code>
     */
    public Builder setCloudsql(com.google.cloud.clouddms.v1.CloudSqlConnectionProfile value) {
      if (cloudsqlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectionProfile_ = value;
        onChanged();
      } else {
        cloudsqlBuilder_.setMessage(value);
      }
      connectionProfileCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A CloudSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlConnectionProfile cloudsql = 102;</code>
     */
    public Builder setCloudsql(
        com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.Builder builderForValue) {
      if (cloudsqlBuilder_ == null) {
        connectionProfile_ = builderForValue.build();
        onChanged();
      } else {
        cloudsqlBuilder_.setMessage(builderForValue.build());
      }
      connectionProfileCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A CloudSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlConnectionProfile cloudsql = 102;</code>
     */
    public Builder mergeCloudsql(com.google.cloud.clouddms.v1.CloudSqlConnectionProfile value) {
      if (cloudsqlBuilder_ == null) {
        if (connectionProfileCase_ == 102
            && connectionProfile_
                != com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.getDefaultInstance()) {
          connectionProfile_ =
              com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.newBuilder(
                      (com.google.cloud.clouddms.v1.CloudSqlConnectionProfile) connectionProfile_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectionProfile_ = value;
        }
        onChanged();
      } else {
        if (connectionProfileCase_ == 102) {
          cloudsqlBuilder_.mergeFrom(value);
        } else {
          cloudsqlBuilder_.setMessage(value);
        }
      }
      connectionProfileCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A CloudSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlConnectionProfile cloudsql = 102;</code>
     */
    public Builder clearCloudsql() {
      if (cloudsqlBuilder_ == null) {
        if (connectionProfileCase_ == 102) {
          connectionProfileCase_ = 0;
          connectionProfile_ = null;
          onChanged();
        }
      } else {
        if (connectionProfileCase_ == 102) {
          connectionProfileCase_ = 0;
          connectionProfile_ = null;
        }
        cloudsqlBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A CloudSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlConnectionProfile cloudsql = 102;</code>
     */
    public com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.Builder getCloudsqlBuilder() {
      return getCloudsqlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A CloudSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlConnectionProfile cloudsql = 102;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.CloudSqlConnectionProfileOrBuilder getCloudsqlOrBuilder() {
      if ((connectionProfileCase_ == 102) && (cloudsqlBuilder_ != null)) {
        return cloudsqlBuilder_.getMessageOrBuilder();
      } else {
        if (connectionProfileCase_ == 102) {
          return (com.google.cloud.clouddms.v1.CloudSqlConnectionProfile) connectionProfile_;
        }
        return com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A CloudSQL database connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.CloudSqlConnectionProfile cloudsql = 102;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.CloudSqlConnectionProfile,
            com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.Builder,
            com.google.cloud.clouddms.v1.CloudSqlConnectionProfileOrBuilder>
        getCloudsqlFieldBuilder() {
      if (cloudsqlBuilder_ == null) {
        if (!(connectionProfileCase_ == 102)) {
          connectionProfile_ =
              com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.getDefaultInstance();
        }
        cloudsqlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.CloudSqlConnectionProfile,
                com.google.cloud.clouddms.v1.CloudSqlConnectionProfile.Builder,
                com.google.cloud.clouddms.v1.CloudSqlConnectionProfileOrBuilder>(
                (com.google.cloud.clouddms.v1.CloudSqlConnectionProfile) connectionProfile_,
                getParentForChildren(),
                isClean());
        connectionProfile_ = null;
      }
      connectionProfileCase_ = 102;
      onChanged();
      return cloudsqlBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.AlloyDbConnectionProfile,
            com.google.cloud.clouddms.v1.AlloyDbConnectionProfile.Builder,
            com.google.cloud.clouddms.v1.AlloyDbConnectionProfileOrBuilder>
        alloydbBuilder_;
    /**
     *
     *
     * <pre>
     * An AlloyDB cluster connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.AlloyDbConnectionProfile alloydb = 105;</code>
     *
     * @return Whether the alloydb field is set.
     */
    @java.lang.Override
    public boolean hasAlloydb() {
      return connectionProfileCase_ == 105;
    }
    /**
     *
     *
     * <pre>
     * An AlloyDB cluster connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.AlloyDbConnectionProfile alloydb = 105;</code>
     *
     * @return The alloydb.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.AlloyDbConnectionProfile getAlloydb() {
      if (alloydbBuilder_ == null) {
        if (connectionProfileCase_ == 105) {
          return (com.google.cloud.clouddms.v1.AlloyDbConnectionProfile) connectionProfile_;
        }
        return com.google.cloud.clouddms.v1.AlloyDbConnectionProfile.getDefaultInstance();
      } else {
        if (connectionProfileCase_ == 105) {
          return alloydbBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.AlloyDbConnectionProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An AlloyDB cluster connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.AlloyDbConnectionProfile alloydb = 105;</code>
     */
    public Builder setAlloydb(com.google.cloud.clouddms.v1.AlloyDbConnectionProfile value) {
      if (alloydbBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectionProfile_ = value;
        onChanged();
      } else {
        alloydbBuilder_.setMessage(value);
      }
      connectionProfileCase_ = 105;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An AlloyDB cluster connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.AlloyDbConnectionProfile alloydb = 105;</code>
     */
    public Builder setAlloydb(
        com.google.cloud.clouddms.v1.AlloyDbConnectionProfile.Builder builderForValue) {
      if (alloydbBuilder_ == null) {
        connectionProfile_ = builderForValue.build();
        onChanged();
      } else {
        alloydbBuilder_.setMessage(builderForValue.build());
      }
      connectionProfileCase_ = 105;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An AlloyDB cluster connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.AlloyDbConnectionProfile alloydb = 105;</code>
     */
    public Builder mergeAlloydb(com.google.cloud.clouddms.v1.AlloyDbConnectionProfile value) {
      if (alloydbBuilder_ == null) {
        if (connectionProfileCase_ == 105
            && connectionProfile_
                != com.google.cloud.clouddms.v1.AlloyDbConnectionProfile.getDefaultInstance()) {
          connectionProfile_ =
              com.google.cloud.clouddms.v1.AlloyDbConnectionProfile.newBuilder(
                      (com.google.cloud.clouddms.v1.AlloyDbConnectionProfile) connectionProfile_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectionProfile_ = value;
        }
        onChanged();
      } else {
        if (connectionProfileCase_ == 105) {
          alloydbBuilder_.mergeFrom(value);
        } else {
          alloydbBuilder_.setMessage(value);
        }
      }
      connectionProfileCase_ = 105;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An AlloyDB cluster connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.AlloyDbConnectionProfile alloydb = 105;</code>
     */
    public Builder clearAlloydb() {
      if (alloydbBuilder_ == null) {
        if (connectionProfileCase_ == 105) {
          connectionProfileCase_ = 0;
          connectionProfile_ = null;
          onChanged();
        }
      } else {
        if (connectionProfileCase_ == 105) {
          connectionProfileCase_ = 0;
          connectionProfile_ = null;
        }
        alloydbBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An AlloyDB cluster connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.AlloyDbConnectionProfile alloydb = 105;</code>
     */
    public com.google.cloud.clouddms.v1.AlloyDbConnectionProfile.Builder getAlloydbBuilder() {
      return getAlloydbFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An AlloyDB cluster connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.AlloyDbConnectionProfile alloydb = 105;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.AlloyDbConnectionProfileOrBuilder getAlloydbOrBuilder() {
      if ((connectionProfileCase_ == 105) && (alloydbBuilder_ != null)) {
        return alloydbBuilder_.getMessageOrBuilder();
      } else {
        if (connectionProfileCase_ == 105) {
          return (com.google.cloud.clouddms.v1.AlloyDbConnectionProfile) connectionProfile_;
        }
        return com.google.cloud.clouddms.v1.AlloyDbConnectionProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An AlloyDB cluster connection profile.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.AlloyDbConnectionProfile alloydb = 105;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.AlloyDbConnectionProfile,
            com.google.cloud.clouddms.v1.AlloyDbConnectionProfile.Builder,
            com.google.cloud.clouddms.v1.AlloyDbConnectionProfileOrBuilder>
        getAlloydbFieldBuilder() {
      if (alloydbBuilder_ == null) {
        if (!(connectionProfileCase_ == 105)) {
          connectionProfile_ =
              com.google.cloud.clouddms.v1.AlloyDbConnectionProfile.getDefaultInstance();
        }
        alloydbBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.AlloyDbConnectionProfile,
                com.google.cloud.clouddms.v1.AlloyDbConnectionProfile.Builder,
                com.google.cloud.clouddms.v1.AlloyDbConnectionProfileOrBuilder>(
                (com.google.cloud.clouddms.v1.AlloyDbConnectionProfile) connectionProfile_,
                getParentForChildren(),
                isClean());
        connectionProfile_ = null;
      }
      connectionProfileCase_ = 105;
      onChanged();
      return alloydbBuilder_;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      if (error_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00000800);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private int provider_ = 0;
    /**
     *
     *
     * <pre>
     * The database provider.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseProvider provider = 8;</code>
     *
     * @return The enum numeric value on the wire for provider.
     */
    @java.lang.Override
    public int getProviderValue() {
      return provider_;
    }
    /**
     *
     *
     * <pre>
     * The database provider.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseProvider provider = 8;</code>
     *
     * @param value The enum numeric value on the wire for provider to set.
     * @return This builder for chaining.
     */
    public Builder setProviderValue(int value) {
      provider_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database provider.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseProvider provider = 8;</code>
     *
     * @return The provider.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.DatabaseProvider getProvider() {
      com.google.cloud.clouddms.v1.DatabaseProvider result =
          com.google.cloud.clouddms.v1.DatabaseProvider.forNumber(provider_);
      return result == null ? com.google.cloud.clouddms.v1.DatabaseProvider.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The database provider.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseProvider provider = 8;</code>
     *
     * @param value The provider to set.
     * @return This builder for chaining.
     */
    public Builder setProvider(com.google.cloud.clouddms.v1.DatabaseProvider value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00001000;
      provider_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database provider.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseProvider provider = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProvider() {
      bitField0_ = (bitField0_ & ~0x00001000);
      provider_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.ConnectionProfile)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.ConnectionProfile)
  private static final com.google.cloud.clouddms.v1.ConnectionProfile DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.ConnectionProfile();
  }

  public static com.google.cloud.clouddms.v1.ConnectionProfile getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConnectionProfile> PARSER =
      new com.google.protobuf.AbstractParser<ConnectionProfile>() {
        @java.lang.Override
        public ConnectionProfile parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ConnectionProfile> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConnectionProfile> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.ConnectionProfile getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
