/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Constraint is not used as an independent entity, it is retrieved
 * as part of another entity such as Table or View.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.ConstraintEntity}
 */
public final class ConstraintEntity extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.ConstraintEntity)
    ConstraintEntityOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConstraintEntity.newBuilder() to construct.
  private ConstraintEntity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConstraintEntity() {
    name_ = "";
    type_ = "";
    tableColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
    referenceColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
    referenceTable_ = "";
    tableName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConstraintEntity();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_ConstraintEntity_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_ConstraintEntity_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.ConstraintEntity.class,
            com.google.cloud.clouddms.v1.ConstraintEntity.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of the table constraint.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the table constraint.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * Type of constraint, for example unique, primary key, foreign key (currently
   * only primary key is supported).
   * </pre>
   *
   * <code>string type = 2;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Type of constraint, for example unique, primary key, foreign key (currently
   * only primary key is supported).
   * </pre>
   *
   * <code>string type = 2;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TABLE_COLUMNS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList tableColumns_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Table columns used as part of the Constraint, for example primary key
   * constraint should list the columns which constitutes the key.
   * </pre>
   *
   * <code>repeated string table_columns = 3;</code>
   *
   * @return A list containing the tableColumns.
   */
  public com.google.protobuf.ProtocolStringList getTableColumnsList() {
    return tableColumns_;
  }
  /**
   *
   *
   * <pre>
   * Table columns used as part of the Constraint, for example primary key
   * constraint should list the columns which constitutes the key.
   * </pre>
   *
   * <code>repeated string table_columns = 3;</code>
   *
   * @return The count of tableColumns.
   */
  public int getTableColumnsCount() {
    return tableColumns_.size();
  }
  /**
   *
   *
   * <pre>
   * Table columns used as part of the Constraint, for example primary key
   * constraint should list the columns which constitutes the key.
   * </pre>
   *
   * <code>repeated string table_columns = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The tableColumns at the given index.
   */
  public java.lang.String getTableColumns(int index) {
    return tableColumns_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Table columns used as part of the Constraint, for example primary key
   * constraint should list the columns which constitutes the key.
   * </pre>
   *
   * <code>repeated string table_columns = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tableColumns at the given index.
   */
  public com.google.protobuf.ByteString getTableColumnsBytes(int index) {
    return tableColumns_.getByteString(index);
  }

  public static final int CUSTOM_FEATURES_FIELD_NUMBER = 4;
  private com.google.protobuf.Struct customFeatures_;
  /**
   *
   *
   * <pre>
   * Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 4;</code>
   *
   * @return Whether the customFeatures field is set.
   */
  @java.lang.Override
  public boolean hasCustomFeatures() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 4;</code>
   *
   * @return The customFeatures.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getCustomFeatures() {
    return customFeatures_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : customFeatures_;
  }
  /**
   *
   *
   * <pre>
   * Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getCustomFeaturesOrBuilder() {
    return customFeatures_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : customFeatures_;
  }

  public static final int REFERENCE_COLUMNS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList referenceColumns_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Reference columns which may be associated with the constraint. For example,
   * if the constraint is a FOREIGN_KEY, this represents the list of full names
   * of referenced columns by the foreign key.
   * </pre>
   *
   * <code>repeated string reference_columns = 5;</code>
   *
   * @return A list containing the referenceColumns.
   */
  public com.google.protobuf.ProtocolStringList getReferenceColumnsList() {
    return referenceColumns_;
  }
  /**
   *
   *
   * <pre>
   * Reference columns which may be associated with the constraint. For example,
   * if the constraint is a FOREIGN_KEY, this represents the list of full names
   * of referenced columns by the foreign key.
   * </pre>
   *
   * <code>repeated string reference_columns = 5;</code>
   *
   * @return The count of referenceColumns.
   */
  public int getReferenceColumnsCount() {
    return referenceColumns_.size();
  }
  /**
   *
   *
   * <pre>
   * Reference columns which may be associated with the constraint. For example,
   * if the constraint is a FOREIGN_KEY, this represents the list of full names
   * of referenced columns by the foreign key.
   * </pre>
   *
   * <code>repeated string reference_columns = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The referenceColumns at the given index.
   */
  public java.lang.String getReferenceColumns(int index) {
    return referenceColumns_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Reference columns which may be associated with the constraint. For example,
   * if the constraint is a FOREIGN_KEY, this represents the list of full names
   * of referenced columns by the foreign key.
   * </pre>
   *
   * <code>repeated string reference_columns = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the referenceColumns at the given index.
   */
  public com.google.protobuf.ByteString getReferenceColumnsBytes(int index) {
    return referenceColumns_.getByteString(index);
  }

  public static final int REFERENCE_TABLE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object referenceTable_ = "";
  /**
   *
   *
   * <pre>
   * Reference table which may be associated with the constraint. For example,
   * if the constraint is a FOREIGN_KEY, this represents the list of full name
   * of the referenced table by the foreign key.
   * </pre>
   *
   * <code>string reference_table = 6;</code>
   *
   * @return The referenceTable.
   */
  @java.lang.Override
  public java.lang.String getReferenceTable() {
    java.lang.Object ref = referenceTable_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      referenceTable_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Reference table which may be associated with the constraint. For example,
   * if the constraint is a FOREIGN_KEY, this represents the list of full name
   * of the referenced table by the foreign key.
   * </pre>
   *
   * <code>string reference_table = 6;</code>
   *
   * @return The bytes for referenceTable.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReferenceTableBytes() {
    java.lang.Object ref = referenceTable_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      referenceTable_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TABLE_NAME_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tableName_ = "";
  /**
   *
   *
   * <pre>
   * Table which is associated with the constraint. In case the constraint
   * is defined on a table, this field is left empty as this information is
   * stored in parent_name. However, if constraint is defined on a view, this
   * field stores the table name on which the view is defined.
   * </pre>
   *
   * <code>string table_name = 7;</code>
   *
   * @return The tableName.
   */
  @java.lang.Override
  public java.lang.String getTableName() {
    java.lang.Object ref = tableName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tableName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Table which is associated with the constraint. In case the constraint
   * is defined on a table, this field is left empty as this information is
   * stored in parent_name. However, if constraint is defined on a view, this
   * field stores the table name on which the view is defined.
   * </pre>
   *
   * <code>string table_name = 7;</code>
   *
   * @return The bytes for tableName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableNameBytes() {
    java.lang.Object ref = tableName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tableName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, type_);
    }
    for (int i = 0; i < tableColumns_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tableColumns_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getCustomFeatures());
    }
    for (int i = 0; i < referenceColumns_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, referenceColumns_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(referenceTable_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, referenceTable_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, tableName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, type_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tableColumns_.size(); i++) {
        dataSize += computeStringSizeNoTag(tableColumns_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTableColumnsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCustomFeatures());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < referenceColumns_.size(); i++) {
        dataSize += computeStringSizeNoTag(referenceColumns_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getReferenceColumnsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(referenceTable_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, referenceTable_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, tableName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.ConstraintEntity)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.ConstraintEntity other =
        (com.google.cloud.clouddms.v1.ConstraintEntity) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getType().equals(other.getType())) return false;
    if (!getTableColumnsList().equals(other.getTableColumnsList())) return false;
    if (hasCustomFeatures() != other.hasCustomFeatures()) return false;
    if (hasCustomFeatures()) {
      if (!getCustomFeatures().equals(other.getCustomFeatures())) return false;
    }
    if (!getReferenceColumnsList().equals(other.getReferenceColumnsList())) return false;
    if (!getReferenceTable().equals(other.getReferenceTable())) return false;
    if (!getTableName().equals(other.getTableName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    if (getTableColumnsCount() > 0) {
      hash = (37 * hash) + TABLE_COLUMNS_FIELD_NUMBER;
      hash = (53 * hash) + getTableColumnsList().hashCode();
    }
    if (hasCustomFeatures()) {
      hash = (37 * hash) + CUSTOM_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getCustomFeatures().hashCode();
    }
    if (getReferenceColumnsCount() > 0) {
      hash = (37 * hash) + REFERENCE_COLUMNS_FIELD_NUMBER;
      hash = (53 * hash) + getReferenceColumnsList().hashCode();
    }
    hash = (37 * hash) + REFERENCE_TABLE_FIELD_NUMBER;
    hash = (53 * hash) + getReferenceTable().hashCode();
    hash = (37 * hash) + TABLE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getTableName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.ConstraintEntity parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ConstraintEntity parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConstraintEntity parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ConstraintEntity parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConstraintEntity parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ConstraintEntity parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConstraintEntity parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ConstraintEntity parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConstraintEntity parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ConstraintEntity parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConstraintEntity parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ConstraintEntity parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.ConstraintEntity prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Constraint is not used as an independent entity, it is retrieved
   * as part of another entity such as Table or View.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.ConstraintEntity}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.ConstraintEntity)
      com.google.cloud.clouddms.v1.ConstraintEntityOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_ConstraintEntity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_ConstraintEntity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.ConstraintEntity.class,
              com.google.cloud.clouddms.v1.ConstraintEntity.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.ConstraintEntity.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCustomFeaturesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      type_ = "";
      tableColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      customFeatures_ = null;
      if (customFeaturesBuilder_ != null) {
        customFeaturesBuilder_.dispose();
        customFeaturesBuilder_ = null;
      }
      referenceColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      referenceTable_ = "";
      tableName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_ConstraintEntity_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConstraintEntity getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.ConstraintEntity.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConstraintEntity build() {
      com.google.cloud.clouddms.v1.ConstraintEntity result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConstraintEntity buildPartial() {
      com.google.cloud.clouddms.v1.ConstraintEntity result =
          new com.google.cloud.clouddms.v1.ConstraintEntity(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.ConstraintEntity result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        tableColumns_.makeImmutable();
        result.tableColumns_ = tableColumns_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.customFeatures_ =
            customFeaturesBuilder_ == null ? customFeatures_ : customFeaturesBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        referenceColumns_.makeImmutable();
        result.referenceColumns_ = referenceColumns_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.referenceTable_ = referenceTable_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.tableName_ = tableName_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.ConstraintEntity) {
        return mergeFrom((com.google.cloud.clouddms.v1.ConstraintEntity) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.ConstraintEntity other) {
      if (other == com.google.cloud.clouddms.v1.ConstraintEntity.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.tableColumns_.isEmpty()) {
        if (tableColumns_.isEmpty()) {
          tableColumns_ = other.tableColumns_;
          bitField0_ |= 0x00000004;
        } else {
          ensureTableColumnsIsMutable();
          tableColumns_.addAll(other.tableColumns_);
        }
        onChanged();
      }
      if (other.hasCustomFeatures()) {
        mergeCustomFeatures(other.getCustomFeatures());
      }
      if (!other.referenceColumns_.isEmpty()) {
        if (referenceColumns_.isEmpty()) {
          referenceColumns_ = other.referenceColumns_;
          bitField0_ |= 0x00000010;
        } else {
          ensureReferenceColumnsIsMutable();
          referenceColumns_.addAll(other.referenceColumns_);
        }
        onChanged();
      }
      if (!other.getReferenceTable().isEmpty()) {
        referenceTable_ = other.referenceTable_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getTableName().isEmpty()) {
        tableName_ = other.tableName_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTableColumnsIsMutable();
                tableColumns_.add(s);
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCustomFeaturesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureReferenceColumnsIsMutable();
                referenceColumns_.add(s);
                break;
              } // case 42
            case 50:
              {
                referenceTable_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                tableName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the table constraint.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the table constraint.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the table constraint.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the table constraint.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the table constraint.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * Type of constraint, for example unique, primary key, foreign key (currently
     * only primary key is supported).
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of constraint, for example unique, primary key, foreign key (currently
     * only primary key is supported).
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of constraint, for example unique, primary key, foreign key (currently
     * only primary key is supported).
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of constraint, for example unique, primary key, foreign key (currently
     * only primary key is supported).
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of constraint, for example unique, primary key, foreign key (currently
     * only primary key is supported).
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList tableColumns_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTableColumnsIsMutable() {
      if (!tableColumns_.isModifiable()) {
        tableColumns_ = new com.google.protobuf.LazyStringArrayList(tableColumns_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Table columns used as part of the Constraint, for example primary key
     * constraint should list the columns which constitutes the key.
     * </pre>
     *
     * <code>repeated string table_columns = 3;</code>
     *
     * @return A list containing the tableColumns.
     */
    public com.google.protobuf.ProtocolStringList getTableColumnsList() {
      tableColumns_.makeImmutable();
      return tableColumns_;
    }
    /**
     *
     *
     * <pre>
     * Table columns used as part of the Constraint, for example primary key
     * constraint should list the columns which constitutes the key.
     * </pre>
     *
     * <code>repeated string table_columns = 3;</code>
     *
     * @return The count of tableColumns.
     */
    public int getTableColumnsCount() {
      return tableColumns_.size();
    }
    /**
     *
     *
     * <pre>
     * Table columns used as part of the Constraint, for example primary key
     * constraint should list the columns which constitutes the key.
     * </pre>
     *
     * <code>repeated string table_columns = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The tableColumns at the given index.
     */
    public java.lang.String getTableColumns(int index) {
      return tableColumns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Table columns used as part of the Constraint, for example primary key
     * constraint should list the columns which constitutes the key.
     * </pre>
     *
     * <code>repeated string table_columns = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tableColumns at the given index.
     */
    public com.google.protobuf.ByteString getTableColumnsBytes(int index) {
      return tableColumns_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Table columns used as part of the Constraint, for example primary key
     * constraint should list the columns which constitutes the key.
     * </pre>
     *
     * <code>repeated string table_columns = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The tableColumns to set.
     * @return This builder for chaining.
     */
    public Builder setTableColumns(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTableColumnsIsMutable();
      tableColumns_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table columns used as part of the Constraint, for example primary key
     * constraint should list the columns which constitutes the key.
     * </pre>
     *
     * <code>repeated string table_columns = 3;</code>
     *
     * @param value The tableColumns to add.
     * @return This builder for chaining.
     */
    public Builder addTableColumns(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTableColumnsIsMutable();
      tableColumns_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table columns used as part of the Constraint, for example primary key
     * constraint should list the columns which constitutes the key.
     * </pre>
     *
     * <code>repeated string table_columns = 3;</code>
     *
     * @param values The tableColumns to add.
     * @return This builder for chaining.
     */
    public Builder addAllTableColumns(java.lang.Iterable<java.lang.String> values) {
      ensureTableColumnsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tableColumns_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table columns used as part of the Constraint, for example primary key
     * constraint should list the columns which constitutes the key.
     * </pre>
     *
     * <code>repeated string table_columns = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableColumns() {
      tableColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table columns used as part of the Constraint, for example primary key
     * constraint should list the columns which constitutes the key.
     * </pre>
     *
     * <code>repeated string table_columns = 3;</code>
     *
     * @param value The bytes of the tableColumns to add.
     * @return This builder for chaining.
     */
    public Builder addTableColumnsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTableColumnsIsMutable();
      tableColumns_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct customFeatures_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        customFeaturesBuilder_;
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 4;</code>
     *
     * @return Whether the customFeatures field is set.
     */
    public boolean hasCustomFeatures() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 4;</code>
     *
     * @return The customFeatures.
     */
    public com.google.protobuf.Struct getCustomFeatures() {
      if (customFeaturesBuilder_ == null) {
        return customFeatures_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : customFeatures_;
      } else {
        return customFeaturesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 4;</code>
     */
    public Builder setCustomFeatures(com.google.protobuf.Struct value) {
      if (customFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customFeatures_ = value;
      } else {
        customFeaturesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 4;</code>
     */
    public Builder setCustomFeatures(com.google.protobuf.Struct.Builder builderForValue) {
      if (customFeaturesBuilder_ == null) {
        customFeatures_ = builderForValue.build();
      } else {
        customFeaturesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 4;</code>
     */
    public Builder mergeCustomFeatures(com.google.protobuf.Struct value) {
      if (customFeaturesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && customFeatures_ != null
            && customFeatures_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getCustomFeaturesBuilder().mergeFrom(value);
        } else {
          customFeatures_ = value;
        }
      } else {
        customFeaturesBuilder_.mergeFrom(value);
      }
      if (customFeatures_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 4;</code>
     */
    public Builder clearCustomFeatures() {
      bitField0_ = (bitField0_ & ~0x00000008);
      customFeatures_ = null;
      if (customFeaturesBuilder_ != null) {
        customFeaturesBuilder_.dispose();
        customFeaturesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 4;</code>
     */
    public com.google.protobuf.Struct.Builder getCustomFeaturesBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCustomFeaturesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 4;</code>
     */
    public com.google.protobuf.StructOrBuilder getCustomFeaturesOrBuilder() {
      if (customFeaturesBuilder_ != null) {
        return customFeaturesBuilder_.getMessageOrBuilder();
      } else {
        return customFeatures_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : customFeatures_;
      }
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getCustomFeaturesFieldBuilder() {
      if (customFeaturesBuilder_ == null) {
        customFeaturesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getCustomFeatures(), getParentForChildren(), isClean());
        customFeatures_ = null;
      }
      return customFeaturesBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList referenceColumns_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureReferenceColumnsIsMutable() {
      if (!referenceColumns_.isModifiable()) {
        referenceColumns_ = new com.google.protobuf.LazyStringArrayList(referenceColumns_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Reference columns which may be associated with the constraint. For example,
     * if the constraint is a FOREIGN_KEY, this represents the list of full names
     * of referenced columns by the foreign key.
     * </pre>
     *
     * <code>repeated string reference_columns = 5;</code>
     *
     * @return A list containing the referenceColumns.
     */
    public com.google.protobuf.ProtocolStringList getReferenceColumnsList() {
      referenceColumns_.makeImmutable();
      return referenceColumns_;
    }
    /**
     *
     *
     * <pre>
     * Reference columns which may be associated with the constraint. For example,
     * if the constraint is a FOREIGN_KEY, this represents the list of full names
     * of referenced columns by the foreign key.
     * </pre>
     *
     * <code>repeated string reference_columns = 5;</code>
     *
     * @return The count of referenceColumns.
     */
    public int getReferenceColumnsCount() {
      return referenceColumns_.size();
    }
    /**
     *
     *
     * <pre>
     * Reference columns which may be associated with the constraint. For example,
     * if the constraint is a FOREIGN_KEY, this represents the list of full names
     * of referenced columns by the foreign key.
     * </pre>
     *
     * <code>repeated string reference_columns = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The referenceColumns at the given index.
     */
    public java.lang.String getReferenceColumns(int index) {
      return referenceColumns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Reference columns which may be associated with the constraint. For example,
     * if the constraint is a FOREIGN_KEY, this represents the list of full names
     * of referenced columns by the foreign key.
     * </pre>
     *
     * <code>repeated string reference_columns = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the referenceColumns at the given index.
     */
    public com.google.protobuf.ByteString getReferenceColumnsBytes(int index) {
      return referenceColumns_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Reference columns which may be associated with the constraint. For example,
     * if the constraint is a FOREIGN_KEY, this represents the list of full names
     * of referenced columns by the foreign key.
     * </pre>
     *
     * <code>repeated string reference_columns = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The referenceColumns to set.
     * @return This builder for chaining.
     */
    public Builder setReferenceColumns(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReferenceColumnsIsMutable();
      referenceColumns_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reference columns which may be associated with the constraint. For example,
     * if the constraint is a FOREIGN_KEY, this represents the list of full names
     * of referenced columns by the foreign key.
     * </pre>
     *
     * <code>repeated string reference_columns = 5;</code>
     *
     * @param value The referenceColumns to add.
     * @return This builder for chaining.
     */
    public Builder addReferenceColumns(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReferenceColumnsIsMutable();
      referenceColumns_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reference columns which may be associated with the constraint. For example,
     * if the constraint is a FOREIGN_KEY, this represents the list of full names
     * of referenced columns by the foreign key.
     * </pre>
     *
     * <code>repeated string reference_columns = 5;</code>
     *
     * @param values The referenceColumns to add.
     * @return This builder for chaining.
     */
    public Builder addAllReferenceColumns(java.lang.Iterable<java.lang.String> values) {
      ensureReferenceColumnsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, referenceColumns_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reference columns which may be associated with the constraint. For example,
     * if the constraint is a FOREIGN_KEY, this represents the list of full names
     * of referenced columns by the foreign key.
     * </pre>
     *
     * <code>repeated string reference_columns = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReferenceColumns() {
      referenceColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reference columns which may be associated with the constraint. For example,
     * if the constraint is a FOREIGN_KEY, this represents the list of full names
     * of referenced columns by the foreign key.
     * </pre>
     *
     * <code>repeated string reference_columns = 5;</code>
     *
     * @param value The bytes of the referenceColumns to add.
     * @return This builder for chaining.
     */
    public Builder addReferenceColumnsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReferenceColumnsIsMutable();
      referenceColumns_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object referenceTable_ = "";
    /**
     *
     *
     * <pre>
     * Reference table which may be associated with the constraint. For example,
     * if the constraint is a FOREIGN_KEY, this represents the list of full name
     * of the referenced table by the foreign key.
     * </pre>
     *
     * <code>string reference_table = 6;</code>
     *
     * @return The referenceTable.
     */
    public java.lang.String getReferenceTable() {
      java.lang.Object ref = referenceTable_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        referenceTable_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Reference table which may be associated with the constraint. For example,
     * if the constraint is a FOREIGN_KEY, this represents the list of full name
     * of the referenced table by the foreign key.
     * </pre>
     *
     * <code>string reference_table = 6;</code>
     *
     * @return The bytes for referenceTable.
     */
    public com.google.protobuf.ByteString getReferenceTableBytes() {
      java.lang.Object ref = referenceTable_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        referenceTable_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Reference table which may be associated with the constraint. For example,
     * if the constraint is a FOREIGN_KEY, this represents the list of full name
     * of the referenced table by the foreign key.
     * </pre>
     *
     * <code>string reference_table = 6;</code>
     *
     * @param value The referenceTable to set.
     * @return This builder for chaining.
     */
    public Builder setReferenceTable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      referenceTable_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reference table which may be associated with the constraint. For example,
     * if the constraint is a FOREIGN_KEY, this represents the list of full name
     * of the referenced table by the foreign key.
     * </pre>
     *
     * <code>string reference_table = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReferenceTable() {
      referenceTable_ = getDefaultInstance().getReferenceTable();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reference table which may be associated with the constraint. For example,
     * if the constraint is a FOREIGN_KEY, this represents the list of full name
     * of the referenced table by the foreign key.
     * </pre>
     *
     * <code>string reference_table = 6;</code>
     *
     * @param value The bytes for referenceTable to set.
     * @return This builder for chaining.
     */
    public Builder setReferenceTableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      referenceTable_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object tableName_ = "";
    /**
     *
     *
     * <pre>
     * Table which is associated with the constraint. In case the constraint
     * is defined on a table, this field is left empty as this information is
     * stored in parent_name. However, if constraint is defined on a view, this
     * field stores the table name on which the view is defined.
     * </pre>
     *
     * <code>string table_name = 7;</code>
     *
     * @return The tableName.
     */
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Table which is associated with the constraint. In case the constraint
     * is defined on a table, this field is left empty as this information is
     * stored in parent_name. However, if constraint is defined on a view, this
     * field stores the table name on which the view is defined.
     * </pre>
     *
     * <code>string table_name = 7;</code>
     *
     * @return The bytes for tableName.
     */
    public com.google.protobuf.ByteString getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Table which is associated with the constraint. In case the constraint
     * is defined on a table, this field is left empty as this information is
     * stored in parent_name. However, if constraint is defined on a view, this
     * field stores the table name on which the view is defined.
     * </pre>
     *
     * <code>string table_name = 7;</code>
     *
     * @param value The tableName to set.
     * @return This builder for chaining.
     */
    public Builder setTableName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tableName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table which is associated with the constraint. In case the constraint
     * is defined on a table, this field is left empty as this information is
     * stored in parent_name. However, if constraint is defined on a view, this
     * field stores the table name on which the view is defined.
     * </pre>
     *
     * <code>string table_name = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableName() {
      tableName_ = getDefaultInstance().getTableName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table which is associated with the constraint. In case the constraint
     * is defined on a table, this field is left empty as this information is
     * stored in parent_name. However, if constraint is defined on a view, this
     * field stores the table name on which the view is defined.
     * </pre>
     *
     * <code>string table_name = 7;</code>
     *
     * @param value The bytes for tableName to set.
     * @return This builder for chaining.
     */
    public Builder setTableNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tableName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.ConstraintEntity)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.ConstraintEntity)
  private static final com.google.cloud.clouddms.v1.ConstraintEntity DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.ConstraintEntity();
  }

  public static com.google.cloud.clouddms.v1.ConstraintEntity getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConstraintEntity> PARSER =
      new com.google.protobuf.AbstractParser<ConstraintEntity>() {
        @java.lang.Override
        public ConstraintEntity parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ConstraintEntity> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConstraintEntity> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.ConstraintEntity getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
