/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

public interface ConstraintEntityOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.ConstraintEntity)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The name of the table constraint.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * The name of the table constraint.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Type of constraint, for example unique, primary key, foreign key (currently
   * only primary key is supported).
   * </pre>
   *
   * <code>string type = 2;</code>
   *
   * @return The type.
   */
  java.lang.String getType();
  /**
   *
   *
   * <pre>
   * Type of constraint, for example unique, primary key, foreign key (currently
   * only primary key is supported).
   * </pre>
   *
   * <code>string type = 2;</code>
   *
   * @return The bytes for type.
   */
  com.google.protobuf.ByteString getTypeBytes();

  /**
   *
   *
   * <pre>
   * Table columns used as part of the Constraint, for example primary key
   * constraint should list the columns which constitutes the key.
   * </pre>
   *
   * <code>repeated string table_columns = 3;</code>
   *
   * @return A list containing the tableColumns.
   */
  java.util.List<java.lang.String> getTableColumnsList();
  /**
   *
   *
   * <pre>
   * Table columns used as part of the Constraint, for example primary key
   * constraint should list the columns which constitutes the key.
   * </pre>
   *
   * <code>repeated string table_columns = 3;</code>
   *
   * @return The count of tableColumns.
   */
  int getTableColumnsCount();
  /**
   *
   *
   * <pre>
   * Table columns used as part of the Constraint, for example primary key
   * constraint should list the columns which constitutes the key.
   * </pre>
   *
   * <code>repeated string table_columns = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The tableColumns at the given index.
   */
  java.lang.String getTableColumns(int index);
  /**
   *
   *
   * <pre>
   * Table columns used as part of the Constraint, for example primary key
   * constraint should list the columns which constitutes the key.
   * </pre>
   *
   * <code>repeated string table_columns = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tableColumns at the given index.
   */
  com.google.protobuf.ByteString getTableColumnsBytes(int index);

  /**
   *
   *
   * <pre>
   * Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 4;</code>
   *
   * @return Whether the customFeatures field is set.
   */
  boolean hasCustomFeatures();
  /**
   *
   *
   * <pre>
   * Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 4;</code>
   *
   * @return The customFeatures.
   */
  com.google.protobuf.Struct getCustomFeatures();
  /**
   *
   *
   * <pre>
   * Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 4;</code>
   */
  com.google.protobuf.StructOrBuilder getCustomFeaturesOrBuilder();

  /**
   *
   *
   * <pre>
   * Reference columns which may be associated with the constraint. For example,
   * if the constraint is a FOREIGN_KEY, this represents the list of full names
   * of referenced columns by the foreign key.
   * </pre>
   *
   * <code>repeated string reference_columns = 5;</code>
   *
   * @return A list containing the referenceColumns.
   */
  java.util.List<java.lang.String> getReferenceColumnsList();
  /**
   *
   *
   * <pre>
   * Reference columns which may be associated with the constraint. For example,
   * if the constraint is a FOREIGN_KEY, this represents the list of full names
   * of referenced columns by the foreign key.
   * </pre>
   *
   * <code>repeated string reference_columns = 5;</code>
   *
   * @return The count of referenceColumns.
   */
  int getReferenceColumnsCount();
  /**
   *
   *
   * <pre>
   * Reference columns which may be associated with the constraint. For example,
   * if the constraint is a FOREIGN_KEY, this represents the list of full names
   * of referenced columns by the foreign key.
   * </pre>
   *
   * <code>repeated string reference_columns = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The referenceColumns at the given index.
   */
  java.lang.String getReferenceColumns(int index);
  /**
   *
   *
   * <pre>
   * Reference columns which may be associated with the constraint. For example,
   * if the constraint is a FOREIGN_KEY, this represents the list of full names
   * of referenced columns by the foreign key.
   * </pre>
   *
   * <code>repeated string reference_columns = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the referenceColumns at the given index.
   */
  com.google.protobuf.ByteString getReferenceColumnsBytes(int index);

  /**
   *
   *
   * <pre>
   * Reference table which may be associated with the constraint. For example,
   * if the constraint is a FOREIGN_KEY, this represents the list of full name
   * of the referenced table by the foreign key.
   * </pre>
   *
   * <code>string reference_table = 6;</code>
   *
   * @return The referenceTable.
   */
  java.lang.String getReferenceTable();
  /**
   *
   *
   * <pre>
   * Reference table which may be associated with the constraint. For example,
   * if the constraint is a FOREIGN_KEY, this represents the list of full name
   * of the referenced table by the foreign key.
   * </pre>
   *
   * <code>string reference_table = 6;</code>
   *
   * @return The bytes for referenceTable.
   */
  com.google.protobuf.ByteString getReferenceTableBytes();

  /**
   *
   *
   * <pre>
   * Table which is associated with the constraint. In case the constraint
   * is defined on a table, this field is left empty as this information is
   * stored in parent_name. However, if constraint is defined on a view, this
   * field stores the table name on which the view is defined.
   * </pre>
   *
   * <code>string table_name = 7;</code>
   *
   * @return The tableName.
   */
  java.lang.String getTableName();
  /**
   *
   *
   * <pre>
   * Table which is associated with the constraint. In case the constraint
   * is defined on a table, this field is left empty as this information is
   * stored in parent_name. However, if constraint is defined on a view, this
   * field stores the table name on which the view is defined.
   * </pre>
   *
   * <code>string table_name = 7;</code>
   *
   * @return The bytes for tableName.
   */
  com.google.protobuf.ByteString getTableNameBytes();
}
