/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * The main conversion workspace resource entity.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.ConversionWorkspace}
 */
public final class ConversionWorkspace extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.ConversionWorkspace)
    ConversionWorkspaceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConversionWorkspace.newBuilder() to construct.
  private ConversionWorkspace(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConversionWorkspace() {
    name_ = "";
    latestCommitId_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConversionWorkspace();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_ConversionWorkspace_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetGlobalSettings();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_ConversionWorkspace_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.ConversionWorkspace.class,
            com.google.cloud.clouddms.v1.ConversionWorkspace.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Full name of the workspace resource, in the form of:
   * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Full name of the workspace resource, in the form of:
   * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_FIELD_NUMBER = 2;
  private com.google.cloud.clouddms.v1.DatabaseEngineInfo source_;
  /**
   *
   *
   * <pre>
   * Required. The source engine details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.DatabaseEngineInfo source = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the source field is set.
   */
  @java.lang.Override
  public boolean hasSource() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The source engine details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.DatabaseEngineInfo source = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The source.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseEngineInfo getSource() {
    return source_ == null
        ? com.google.cloud.clouddms.v1.DatabaseEngineInfo.getDefaultInstance()
        : source_;
  }
  /**
   *
   *
   * <pre>
   * Required. The source engine details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.DatabaseEngineInfo source = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseEngineInfoOrBuilder getSourceOrBuilder() {
    return source_ == null
        ? com.google.cloud.clouddms.v1.DatabaseEngineInfo.getDefaultInstance()
        : source_;
  }

  public static final int DESTINATION_FIELD_NUMBER = 3;
  private com.google.cloud.clouddms.v1.DatabaseEngineInfo destination_;
  /**
   *
   *
   * <pre>
   * Required. The destination engine details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.DatabaseEngineInfo destination = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the destination field is set.
   */
  @java.lang.Override
  public boolean hasDestination() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The destination engine details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.DatabaseEngineInfo destination = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The destination.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseEngineInfo getDestination() {
    return destination_ == null
        ? com.google.cloud.clouddms.v1.DatabaseEngineInfo.getDefaultInstance()
        : destination_;
  }
  /**
   *
   *
   * <pre>
   * Required. The destination engine details.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.DatabaseEngineInfo destination = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseEngineInfoOrBuilder getDestinationOrBuilder() {
    return destination_ == null
        ? com.google.cloud.clouddms.v1.DatabaseEngineInfo.getDefaultInstance()
        : destination_;
  }

  public static final int GLOBAL_SETTINGS_FIELD_NUMBER = 4;

  private static final class GlobalSettingsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
                .internal_static_google_cloud_clouddms_v1_ConversionWorkspace_GlobalSettingsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> globalSettings_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetGlobalSettings() {
    if (globalSettings_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          GlobalSettingsDefaultEntryHolder.defaultEntry);
    }
    return globalSettings_;
  }

  public int getGlobalSettingsCount() {
    return internalGetGlobalSettings().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A generic list of settings for the workspace.
   * The settings are database pair dependant and can indicate default behavior
   * for the mapping rules engine or turn on or off specific features.
   * Such examples can be: convert_foreign_key_to_interleave=true,
   * skip_triggers=false, ignore_non_table_synonyms=true
   * </pre>
   *
   * <code>map&lt;string, string&gt; global_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsGlobalSettings(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetGlobalSettings().getMap().containsKey(key);
  }
  /** Use {@link #getGlobalSettingsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getGlobalSettings() {
    return getGlobalSettingsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. A generic list of settings for the workspace.
   * The settings are database pair dependant and can indicate default behavior
   * for the mapping rules engine or turn on or off specific features.
   * Such examples can be: convert_foreign_key_to_interleave=true,
   * skip_triggers=false, ignore_non_table_synonyms=true
   * </pre>
   *
   * <code>map&lt;string, string&gt; global_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getGlobalSettingsMap() {
    return internalGetGlobalSettings().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. A generic list of settings for the workspace.
   * The settings are database pair dependant and can indicate default behavior
   * for the mapping rules engine or turn on or off specific features.
   * Such examples can be: convert_foreign_key_to_interleave=true,
   * skip_triggers=false, ignore_non_table_synonyms=true
   * </pre>
   *
   * <code>map&lt;string, string&gt; global_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getGlobalSettingsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetGlobalSettings().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. A generic list of settings for the workspace.
   * The settings are database pair dependant and can indicate default behavior
   * for the mapping rules engine or turn on or off specific features.
   * Such examples can be: convert_foreign_key_to_interleave=true,
   * skip_triggers=false, ignore_non_table_synonyms=true
   * </pre>
   *
   * <code>map&lt;string, string&gt; global_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getGlobalSettingsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetGlobalSettings().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int HAS_UNCOMMITTED_CHANGES_FIELD_NUMBER = 5;
  private boolean hasUncommittedChanges_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Whether the workspace has uncommitted changes (changes which
   * were made after the workspace was committed).
   * </pre>
   *
   * <code>bool has_uncommitted_changes = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The hasUncommittedChanges.
   */
  @java.lang.Override
  public boolean getHasUncommittedChanges() {
    return hasUncommittedChanges_;
  }

  public static final int LATEST_COMMIT_ID_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object latestCommitId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The latest commit ID.
   * </pre>
   *
   * <code>string latest_commit_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The latestCommitId.
   */
  @java.lang.Override
  public java.lang.String getLatestCommitId() {
    java.lang.Object ref = latestCommitId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      latestCommitId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The latest commit ID.
   * </pre>
   *
   * <code>string latest_commit_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for latestCommitId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLatestCommitIdBytes() {
    java.lang.Object ref = latestCommitId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      latestCommitId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LATEST_COMMIT_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp latestCommitTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the workspace was committed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp latest_commit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the latestCommitTime field is set.
   */
  @java.lang.Override
  public boolean hasLatestCommitTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the workspace was committed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp latest_commit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The latestCommitTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLatestCommitTime() {
    return latestCommitTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : latestCommitTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the workspace was committed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp latest_commit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLatestCommitTimeOrBuilder() {
    return latestCommitTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : latestCommitTime_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the workspace resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the workspace resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the workspace resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the workspace resource was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the workspace resource was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the workspace resource was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The display name for the workspace.
   * </pre>
   *
   * <code>string display_name = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The display name for the workspace.
   * </pre>
   *
   * <code>string display_name = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getSource());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getDestination());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetGlobalSettings(), GlobalSettingsDefaultEntryHolder.defaultEntry, 4);
    if (hasUncommittedChanges_ != false) {
      output.writeBool(5, hasUncommittedChanges_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latestCommitId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, latestCommitId_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getLatestCommitTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(9, getCreateTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(10, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSource());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDestination());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetGlobalSettings().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> globalSettings__ =
          GlobalSettingsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, globalSettings__);
    }
    if (hasUncommittedChanges_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, hasUncommittedChanges_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latestCommitId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, latestCommitId_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getLatestCommitTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getCreateTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.ConversionWorkspace)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.ConversionWorkspace other =
        (com.google.cloud.clouddms.v1.ConversionWorkspace) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasSource() != other.hasSource()) return false;
    if (hasSource()) {
      if (!getSource().equals(other.getSource())) return false;
    }
    if (hasDestination() != other.hasDestination()) return false;
    if (hasDestination()) {
      if (!getDestination().equals(other.getDestination())) return false;
    }
    if (!internalGetGlobalSettings().equals(other.internalGetGlobalSettings())) return false;
    if (getHasUncommittedChanges() != other.getHasUncommittedChanges()) return false;
    if (!getLatestCommitId().equals(other.getLatestCommitId())) return false;
    if (hasLatestCommitTime() != other.hasLatestCommitTime()) return false;
    if (hasLatestCommitTime()) {
      if (!getLatestCommitTime().equals(other.getLatestCommitTime())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasSource()) {
      hash = (37 * hash) + SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getSource().hashCode();
    }
    if (hasDestination()) {
      hash = (37 * hash) + DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getDestination().hashCode();
    }
    if (!internalGetGlobalSettings().getMap().isEmpty()) {
      hash = (37 * hash) + GLOBAL_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetGlobalSettings().hashCode();
    }
    hash = (37 * hash) + HAS_UNCOMMITTED_CHANGES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHasUncommittedChanges());
    hash = (37 * hash) + LATEST_COMMIT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getLatestCommitId().hashCode();
    if (hasLatestCommitTime()) {
      hash = (37 * hash) + LATEST_COMMIT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLatestCommitTime().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.ConversionWorkspace parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ConversionWorkspace parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConversionWorkspace parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ConversionWorkspace parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConversionWorkspace parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ConversionWorkspace parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConversionWorkspace parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ConversionWorkspace parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConversionWorkspace parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ConversionWorkspace parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ConversionWorkspace parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ConversionWorkspace parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.ConversionWorkspace prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The main conversion workspace resource entity.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.ConversionWorkspace}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.ConversionWorkspace)
      com.google.cloud.clouddms.v1.ConversionWorkspaceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_ConversionWorkspace_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetGlobalSettings();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableGlobalSettings();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_ConversionWorkspace_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.ConversionWorkspace.class,
              com.google.cloud.clouddms.v1.ConversionWorkspace.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.ConversionWorkspace.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSourceFieldBuilder();
        getDestinationFieldBuilder();
        getLatestCommitTimeFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      source_ = null;
      if (sourceBuilder_ != null) {
        sourceBuilder_.dispose();
        sourceBuilder_ = null;
      }
      destination_ = null;
      if (destinationBuilder_ != null) {
        destinationBuilder_.dispose();
        destinationBuilder_ = null;
      }
      internalGetMutableGlobalSettings().clear();
      hasUncommittedChanges_ = false;
      latestCommitId_ = "";
      latestCommitTime_ = null;
      if (latestCommitTimeBuilder_ != null) {
        latestCommitTimeBuilder_.dispose();
        latestCommitTimeBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      displayName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_ConversionWorkspace_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConversionWorkspace getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspace.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConversionWorkspace build() {
      com.google.cloud.clouddms.v1.ConversionWorkspace result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConversionWorkspace buildPartial() {
      com.google.cloud.clouddms.v1.ConversionWorkspace result =
          new com.google.cloud.clouddms.v1.ConversionWorkspace(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.ConversionWorkspace result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.source_ = sourceBuilder_ == null ? source_ : sourceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.destination_ =
            destinationBuilder_ == null ? destination_ : destinationBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.globalSettings_ = internalGetGlobalSettings();
        result.globalSettings_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.hasUncommittedChanges_ = hasUncommittedChanges_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.latestCommitId_ = latestCommitId_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.latestCommitTime_ =
            latestCommitTimeBuilder_ == null ? latestCommitTime_ : latestCommitTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.displayName_ = displayName_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.ConversionWorkspace) {
        return mergeFrom((com.google.cloud.clouddms.v1.ConversionWorkspace) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.ConversionWorkspace other) {
      if (other == com.google.cloud.clouddms.v1.ConversionWorkspace.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSource()) {
        mergeSource(other.getSource());
      }
      if (other.hasDestination()) {
        mergeDestination(other.getDestination());
      }
      internalGetMutableGlobalSettings().mergeFrom(other.internalGetGlobalSettings());
      bitField0_ |= 0x00000008;
      if (other.getHasUncommittedChanges() != false) {
        setHasUncommittedChanges(other.getHasUncommittedChanges());
      }
      if (!other.getLatestCommitId().isEmpty()) {
        latestCommitId_ = other.latestCommitId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasLatestCommitTime()) {
        mergeLatestCommitTime(other.getLatestCommitTime());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getSourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getDestinationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> globalSettings__ =
                    input.readMessage(
                        GlobalSettingsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableGlobalSettings()
                    .getMutableMap()
                    .put(globalSettings__.getKey(), globalSettings__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                hasUncommittedChanges_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                latestCommitId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getLatestCommitTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 74:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 90:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Full name of the workspace resource, in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Full name of the workspace resource, in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Full name of the workspace resource, in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Full name of the workspace resource, in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Full name of the workspace resource, in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.clouddms.v1.DatabaseEngineInfo source_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.DatabaseEngineInfo,
            com.google.cloud.clouddms.v1.DatabaseEngineInfo.Builder,
            com.google.cloud.clouddms.v1.DatabaseEngineInfoOrBuilder>
        sourceBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The source engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the source field is set.
     */
    public boolean hasSource() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The source engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The source.
     */
    public com.google.cloud.clouddms.v1.DatabaseEngineInfo getSource() {
      if (sourceBuilder_ == null) {
        return source_ == null
            ? com.google.cloud.clouddms.v1.DatabaseEngineInfo.getDefaultInstance()
            : source_;
      } else {
        return sourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The source engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSource(com.google.cloud.clouddms.v1.DatabaseEngineInfo value) {
      if (sourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
      } else {
        sourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The source engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSource(
        com.google.cloud.clouddms.v1.DatabaseEngineInfo.Builder builderForValue) {
      if (sourceBuilder_ == null) {
        source_ = builderForValue.build();
      } else {
        sourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The source engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeSource(com.google.cloud.clouddms.v1.DatabaseEngineInfo value) {
      if (sourceBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && source_ != null
            && source_ != com.google.cloud.clouddms.v1.DatabaseEngineInfo.getDefaultInstance()) {
          getSourceBuilder().mergeFrom(value);
        } else {
          source_ = value;
        }
      } else {
        sourceBuilder_.mergeFrom(value);
      }
      if (source_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The source engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearSource() {
      bitField0_ = (bitField0_ & ~0x00000002);
      source_ = null;
      if (sourceBuilder_ != null) {
        sourceBuilder_.dispose();
        sourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The source engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.DatabaseEngineInfo.Builder getSourceBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The source engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.DatabaseEngineInfoOrBuilder getSourceOrBuilder() {
      if (sourceBuilder_ != null) {
        return sourceBuilder_.getMessageOrBuilder();
      } else {
        return source_ == null
            ? com.google.cloud.clouddms.v1.DatabaseEngineInfo.getDefaultInstance()
            : source_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The source engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.DatabaseEngineInfo,
            com.google.cloud.clouddms.v1.DatabaseEngineInfo.Builder,
            com.google.cloud.clouddms.v1.DatabaseEngineInfoOrBuilder>
        getSourceFieldBuilder() {
      if (sourceBuilder_ == null) {
        sourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.DatabaseEngineInfo,
                com.google.cloud.clouddms.v1.DatabaseEngineInfo.Builder,
                com.google.cloud.clouddms.v1.DatabaseEngineInfoOrBuilder>(
                getSource(), getParentForChildren(), isClean());
        source_ = null;
      }
      return sourceBuilder_;
    }

    private com.google.cloud.clouddms.v1.DatabaseEngineInfo destination_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.DatabaseEngineInfo,
            com.google.cloud.clouddms.v1.DatabaseEngineInfo.Builder,
            com.google.cloud.clouddms.v1.DatabaseEngineInfoOrBuilder>
        destinationBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The destination engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo destination = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the destination field is set.
     */
    public boolean hasDestination() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The destination engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo destination = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The destination.
     */
    public com.google.cloud.clouddms.v1.DatabaseEngineInfo getDestination() {
      if (destinationBuilder_ == null) {
        return destination_ == null
            ? com.google.cloud.clouddms.v1.DatabaseEngineInfo.getDefaultInstance()
            : destination_;
      } else {
        return destinationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The destination engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo destination = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDestination(com.google.cloud.clouddms.v1.DatabaseEngineInfo value) {
      if (destinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
      } else {
        destinationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The destination engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo destination = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDestination(
        com.google.cloud.clouddms.v1.DatabaseEngineInfo.Builder builderForValue) {
      if (destinationBuilder_ == null) {
        destination_ = builderForValue.build();
      } else {
        destinationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The destination engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo destination = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDestination(com.google.cloud.clouddms.v1.DatabaseEngineInfo value) {
      if (destinationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && destination_ != null
            && destination_
                != com.google.cloud.clouddms.v1.DatabaseEngineInfo.getDefaultInstance()) {
          getDestinationBuilder().mergeFrom(value);
        } else {
          destination_ = value;
        }
      } else {
        destinationBuilder_.mergeFrom(value);
      }
      if (destination_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The destination engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo destination = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDestination() {
      bitField0_ = (bitField0_ & ~0x00000004);
      destination_ = null;
      if (destinationBuilder_ != null) {
        destinationBuilder_.dispose();
        destinationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The destination engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo destination = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.DatabaseEngineInfo.Builder getDestinationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The destination engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo destination = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.DatabaseEngineInfoOrBuilder getDestinationOrBuilder() {
      if (destinationBuilder_ != null) {
        return destinationBuilder_.getMessageOrBuilder();
      } else {
        return destination_ == null
            ? com.google.cloud.clouddms.v1.DatabaseEngineInfo.getDefaultInstance()
            : destination_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The destination engine details.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEngineInfo destination = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.DatabaseEngineInfo,
            com.google.cloud.clouddms.v1.DatabaseEngineInfo.Builder,
            com.google.cloud.clouddms.v1.DatabaseEngineInfoOrBuilder>
        getDestinationFieldBuilder() {
      if (destinationBuilder_ == null) {
        destinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.DatabaseEngineInfo,
                com.google.cloud.clouddms.v1.DatabaseEngineInfo.Builder,
                com.google.cloud.clouddms.v1.DatabaseEngineInfoOrBuilder>(
                getDestination(), getParentForChildren(), isClean());
        destination_ = null;
      }
      return destinationBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> globalSettings_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetGlobalSettings() {
      if (globalSettings_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            GlobalSettingsDefaultEntryHolder.defaultEntry);
      }
      return globalSettings_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableGlobalSettings() {
      if (globalSettings_ == null) {
        globalSettings_ =
            com.google.protobuf.MapField.newMapField(GlobalSettingsDefaultEntryHolder.defaultEntry);
      }
      if (!globalSettings_.isMutable()) {
        globalSettings_ = globalSettings_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return globalSettings_;
    }

    public int getGlobalSettingsCount() {
      return internalGetGlobalSettings().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A generic list of settings for the workspace.
     * The settings are database pair dependant and can indicate default behavior
     * for the mapping rules engine or turn on or off specific features.
     * Such examples can be: convert_foreign_key_to_interleave=true,
     * skip_triggers=false, ignore_non_table_synonyms=true
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; global_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsGlobalSettings(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetGlobalSettings().getMap().containsKey(key);
    }
    /** Use {@link #getGlobalSettingsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getGlobalSettings() {
      return getGlobalSettingsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A generic list of settings for the workspace.
     * The settings are database pair dependant and can indicate default behavior
     * for the mapping rules engine or turn on or off specific features.
     * Such examples can be: convert_foreign_key_to_interleave=true,
     * skip_triggers=false, ignore_non_table_synonyms=true
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; global_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getGlobalSettingsMap() {
      return internalGetGlobalSettings().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A generic list of settings for the workspace.
     * The settings are database pair dependant and can indicate default behavior
     * for the mapping rules engine or turn on or off specific features.
     * Such examples can be: convert_foreign_key_to_interleave=true,
     * skip_triggers=false, ignore_non_table_synonyms=true
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; global_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getGlobalSettingsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetGlobalSettings().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. A generic list of settings for the workspace.
     * The settings are database pair dependant and can indicate default behavior
     * for the mapping rules engine or turn on or off specific features.
     * Such examples can be: convert_foreign_key_to_interleave=true,
     * skip_triggers=false, ignore_non_table_synonyms=true
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; global_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getGlobalSettingsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetGlobalSettings().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearGlobalSettings() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableGlobalSettings().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A generic list of settings for the workspace.
     * The settings are database pair dependant and can indicate default behavior
     * for the mapping rules engine or turn on or off specific features.
     * Such examples can be: convert_foreign_key_to_interleave=true,
     * skip_triggers=false, ignore_non_table_synonyms=true
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; global_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeGlobalSettings(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableGlobalSettings().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableGlobalSettings() {
      bitField0_ |= 0x00000008;
      return internalGetMutableGlobalSettings().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A generic list of settings for the workspace.
     * The settings are database pair dependant and can indicate default behavior
     * for the mapping rules engine or turn on or off specific features.
     * Such examples can be: convert_foreign_key_to_interleave=true,
     * skip_triggers=false, ignore_non_table_synonyms=true
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; global_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putGlobalSettings(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableGlobalSettings().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A generic list of settings for the workspace.
     * The settings are database pair dependant and can indicate default behavior
     * for the mapping rules engine or turn on or off specific features.
     * Such examples can be: convert_foreign_key_to_interleave=true,
     * skip_triggers=false, ignore_non_table_synonyms=true
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; global_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllGlobalSettings(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableGlobalSettings().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private boolean hasUncommittedChanges_;
    /**
     *
     *
     * <pre>
     * Output only. Whether the workspace has uncommitted changes (changes which
     * were made after the workspace was committed).
     * </pre>
     *
     * <code>bool has_uncommitted_changes = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The hasUncommittedChanges.
     */
    @java.lang.Override
    public boolean getHasUncommittedChanges() {
      return hasUncommittedChanges_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether the workspace has uncommitted changes (changes which
     * were made after the workspace was committed).
     * </pre>
     *
     * <code>bool has_uncommitted_changes = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The hasUncommittedChanges to set.
     * @return This builder for chaining.
     */
    public Builder setHasUncommittedChanges(boolean value) {

      hasUncommittedChanges_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether the workspace has uncommitted changes (changes which
     * were made after the workspace was committed).
     * </pre>
     *
     * <code>bool has_uncommitted_changes = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHasUncommittedChanges() {
      bitField0_ = (bitField0_ & ~0x00000010);
      hasUncommittedChanges_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object latestCommitId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The latest commit ID.
     * </pre>
     *
     * <code>string latest_commit_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The latestCommitId.
     */
    public java.lang.String getLatestCommitId() {
      java.lang.Object ref = latestCommitId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        latestCommitId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The latest commit ID.
     * </pre>
     *
     * <code>string latest_commit_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for latestCommitId.
     */
    public com.google.protobuf.ByteString getLatestCommitIdBytes() {
      java.lang.Object ref = latestCommitId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        latestCommitId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The latest commit ID.
     * </pre>
     *
     * <code>string latest_commit_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The latestCommitId to set.
     * @return This builder for chaining.
     */
    public Builder setLatestCommitId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      latestCommitId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The latest commit ID.
     * </pre>
     *
     * <code>string latest_commit_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLatestCommitId() {
      latestCommitId_ = getDefaultInstance().getLatestCommitId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The latest commit ID.
     * </pre>
     *
     * <code>string latest_commit_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for latestCommitId to set.
     * @return This builder for chaining.
     */
    public Builder setLatestCommitIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      latestCommitId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp latestCommitTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        latestCommitTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace was committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_commit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the latestCommitTime field is set.
     */
    public boolean hasLatestCommitTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace was committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_commit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The latestCommitTime.
     */
    public com.google.protobuf.Timestamp getLatestCommitTime() {
      if (latestCommitTimeBuilder_ == null) {
        return latestCommitTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : latestCommitTime_;
      } else {
        return latestCommitTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace was committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_commit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLatestCommitTime(com.google.protobuf.Timestamp value) {
      if (latestCommitTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        latestCommitTime_ = value;
      } else {
        latestCommitTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace was committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_commit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLatestCommitTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (latestCommitTimeBuilder_ == null) {
        latestCommitTime_ = builderForValue.build();
      } else {
        latestCommitTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace was committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_commit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLatestCommitTime(com.google.protobuf.Timestamp value) {
      if (latestCommitTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && latestCommitTime_ != null
            && latestCommitTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLatestCommitTimeBuilder().mergeFrom(value);
        } else {
          latestCommitTime_ = value;
        }
      } else {
        latestCommitTimeBuilder_.mergeFrom(value);
      }
      if (latestCommitTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace was committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_commit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLatestCommitTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      latestCommitTime_ = null;
      if (latestCommitTimeBuilder_ != null) {
        latestCommitTimeBuilder_.dispose();
        latestCommitTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace was committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_commit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLatestCommitTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getLatestCommitTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace was committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_commit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLatestCommitTimeOrBuilder() {
      if (latestCommitTimeBuilder_ != null) {
        return latestCommitTimeBuilder_.getMessageOrBuilder();
      } else {
        return latestCommitTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : latestCommitTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace was committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_commit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLatestCommitTimeFieldBuilder() {
      if (latestCommitTimeBuilder_ == null) {
        latestCommitTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLatestCommitTime(), getParentForChildren(), isClean());
        latestCommitTime_ = null;
      }
      return latestCommitTimeBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the workspace resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The display name for the workspace.
     * </pre>
     *
     * <code>string display_name = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The display name for the workspace.
     * </pre>
     *
     * <code>string display_name = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The display name for the workspace.
     * </pre>
     *
     * <code>string display_name = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The display name for the workspace.
     * </pre>
     *
     * <code>string display_name = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The display name for the workspace.
     * </pre>
     *
     * <code>string display_name = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.ConversionWorkspace)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.ConversionWorkspace)
  private static final com.google.cloud.clouddms.v1.ConversionWorkspace DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.ConversionWorkspace();
  }

  public static com.google.cloud.clouddms.v1.ConversionWorkspace getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConversionWorkspace> PARSER =
      new com.google.protobuf.AbstractParser<ConversionWorkspace>() {
        @java.lang.Override
        public ConversionWorkspace parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ConversionWorkspace> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConversionWorkspace> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.ConversionWorkspace getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
