/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Request message to create a new Database Migration Service migration job
 * in the specified project and region.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.CreateMigrationJobRequest}
 */
public final class CreateMigrationJobRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.CreateMigrationJobRequest)
    CreateMigrationJobRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateMigrationJobRequest.newBuilder() to construct.
  private CreateMigrationJobRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateMigrationJobRequest() {
    parent_ = "";
    migrationJobId_ = "";
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateMigrationJobRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsProto
        .internal_static_google_cloud_clouddms_v1_CreateMigrationJobRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsProto
        .internal_static_google_cloud_clouddms_v1_CreateMigrationJobRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.CreateMigrationJobRequest.class,
            com.google.cloud.clouddms.v1.CreateMigrationJobRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent which owns this collection of migration jobs.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent which owns this collection of migration jobs.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MIGRATION_JOB_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object migrationJobId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The ID of the instance to create.
   * </pre>
   *
   * <code>string migration_job_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The migrationJobId.
   */
  @java.lang.Override
  public java.lang.String getMigrationJobId() {
    java.lang.Object ref = migrationJobId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      migrationJobId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The ID of the instance to create.
   * </pre>
   *
   * <code>string migration_job_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for migrationJobId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMigrationJobIdBytes() {
    java.lang.Object ref = migrationJobId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      migrationJobId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MIGRATION_JOB_FIELD_NUMBER = 3;
  private com.google.cloud.clouddms.v1.MigrationJob migrationJob_;
  /**
   *
   *
   * <pre>
   * Required. Represents a [migration
   * job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
   * object.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MigrationJob migration_job = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the migrationJob field is set.
   */
  @java.lang.Override
  public boolean hasMigrationJob() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Represents a [migration
   * job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
   * object.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MigrationJob migration_job = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The migrationJob.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MigrationJob getMigrationJob() {
    return migrationJob_ == null
        ? com.google.cloud.clouddms.v1.MigrationJob.getDefaultInstance()
        : migrationJob_;
  }
  /**
   *
   *
   * <pre>
   * Required. Represents a [migration
   * job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
   * object.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MigrationJob migration_job = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MigrationJobOrBuilder getMigrationJobOrBuilder() {
    return migrationJob_ == null
        ? com.google.cloud.clouddms.v1.MigrationJob.getDefaultInstance()
        : migrationJob_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A unique ID used to identify the request. If the server receives
   * two requests with the same ID, then the second request is ignored.
   *
   * It is recommended to always set this value to a UUID.
   *
   * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
   * (_), and hyphens (-). The maximum length is 40 characters.
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A unique ID used to identify the request. If the server receives
   * two requests with the same ID, then the second request is ignored.
   *
   * It is recommended to always set this value to a UUID.
   *
   * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
   * (_), and hyphens (-). The maximum length is 40 characters.
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(migrationJobId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, migrationJobId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getMigrationJob());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, requestId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(migrationJobId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, migrationJobId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMigrationJob());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, requestId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.CreateMigrationJobRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.CreateMigrationJobRequest other =
        (com.google.cloud.clouddms.v1.CreateMigrationJobRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getMigrationJobId().equals(other.getMigrationJobId())) return false;
    if (hasMigrationJob() != other.hasMigrationJob()) return false;
    if (hasMigrationJob()) {
      if (!getMigrationJob().equals(other.getMigrationJob())) return false;
    }
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + MIGRATION_JOB_ID_FIELD_NUMBER;
    hash = (53 * hash) + getMigrationJobId().hashCode();
    if (hasMigrationJob()) {
      hash = (37 * hash) + MIGRATION_JOB_FIELD_NUMBER;
      hash = (53 * hash) + getMigrationJob().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.CreateMigrationJobRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.CreateMigrationJobRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.CreateMigrationJobRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.CreateMigrationJobRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.CreateMigrationJobRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.CreateMigrationJobRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.CreateMigrationJobRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.CreateMigrationJobRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.CreateMigrationJobRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.CreateMigrationJobRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.CreateMigrationJobRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.CreateMigrationJobRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.clouddms.v1.CreateMigrationJobRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message to create a new Database Migration Service migration job
   * in the specified project and region.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.CreateMigrationJobRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.CreateMigrationJobRequest)
      com.google.cloud.clouddms.v1.CreateMigrationJobRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_CreateMigrationJobRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_CreateMigrationJobRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.CreateMigrationJobRequest.class,
              com.google.cloud.clouddms.v1.CreateMigrationJobRequest.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.CreateMigrationJobRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMigrationJobFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      migrationJobId_ = "";
      migrationJob_ = null;
      if (migrationJobBuilder_ != null) {
        migrationJobBuilder_.dispose();
        migrationJobBuilder_ = null;
      }
      requestId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_CreateMigrationJobRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.CreateMigrationJobRequest getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.CreateMigrationJobRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.CreateMigrationJobRequest build() {
      com.google.cloud.clouddms.v1.CreateMigrationJobRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.CreateMigrationJobRequest buildPartial() {
      com.google.cloud.clouddms.v1.CreateMigrationJobRequest result =
          new com.google.cloud.clouddms.v1.CreateMigrationJobRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.CreateMigrationJobRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.migrationJobId_ = migrationJobId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.migrationJob_ =
            migrationJobBuilder_ == null ? migrationJob_ : migrationJobBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requestId_ = requestId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.CreateMigrationJobRequest) {
        return mergeFrom((com.google.cloud.clouddms.v1.CreateMigrationJobRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.CreateMigrationJobRequest other) {
      if (other == com.google.cloud.clouddms.v1.CreateMigrationJobRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getMigrationJobId().isEmpty()) {
        migrationJobId_ = other.migrationJobId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasMigrationJob()) {
        mergeMigrationJob(other.getMigrationJob());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                migrationJobId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getMigrationJobFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent which owns this collection of migration jobs.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent which owns this collection of migration jobs.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent which owns this collection of migration jobs.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent which owns this collection of migration jobs.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent which owns this collection of migration jobs.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object migrationJobId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of the instance to create.
     * </pre>
     *
     * <code>string migration_job_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The migrationJobId.
     */
    public java.lang.String getMigrationJobId() {
      java.lang.Object ref = migrationJobId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        migrationJobId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the instance to create.
     * </pre>
     *
     * <code>string migration_job_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for migrationJobId.
     */
    public com.google.protobuf.ByteString getMigrationJobIdBytes() {
      java.lang.Object ref = migrationJobId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        migrationJobId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the instance to create.
     * </pre>
     *
     * <code>string migration_job_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The migrationJobId to set.
     * @return This builder for chaining.
     */
    public Builder setMigrationJobId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      migrationJobId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the instance to create.
     * </pre>
     *
     * <code>string migration_job_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMigrationJobId() {
      migrationJobId_ = getDefaultInstance().getMigrationJobId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the instance to create.
     * </pre>
     *
     * <code>string migration_job_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for migrationJobId to set.
     * @return This builder for chaining.
     */
    public Builder setMigrationJobIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      migrationJobId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.clouddms.v1.MigrationJob migrationJob_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.MigrationJob,
            com.google.cloud.clouddms.v1.MigrationJob.Builder,
            com.google.cloud.clouddms.v1.MigrationJobOrBuilder>
        migrationJobBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Represents a [migration
     * job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
     * object.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob migration_job = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the migrationJob field is set.
     */
    public boolean hasMigrationJob() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Represents a [migration
     * job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
     * object.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob migration_job = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The migrationJob.
     */
    public com.google.cloud.clouddms.v1.MigrationJob getMigrationJob() {
      if (migrationJobBuilder_ == null) {
        return migrationJob_ == null
            ? com.google.cloud.clouddms.v1.MigrationJob.getDefaultInstance()
            : migrationJob_;
      } else {
        return migrationJobBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Represents a [migration
     * job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
     * object.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob migration_job = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMigrationJob(com.google.cloud.clouddms.v1.MigrationJob value) {
      if (migrationJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        migrationJob_ = value;
      } else {
        migrationJobBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Represents a [migration
     * job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
     * object.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob migration_job = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMigrationJob(
        com.google.cloud.clouddms.v1.MigrationJob.Builder builderForValue) {
      if (migrationJobBuilder_ == null) {
        migrationJob_ = builderForValue.build();
      } else {
        migrationJobBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Represents a [migration
     * job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
     * object.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob migration_job = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeMigrationJob(com.google.cloud.clouddms.v1.MigrationJob value) {
      if (migrationJobBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && migrationJob_ != null
            && migrationJob_ != com.google.cloud.clouddms.v1.MigrationJob.getDefaultInstance()) {
          getMigrationJobBuilder().mergeFrom(value);
        } else {
          migrationJob_ = value;
        }
      } else {
        migrationJobBuilder_.mergeFrom(value);
      }
      if (migrationJob_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Represents a [migration
     * job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
     * object.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob migration_job = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearMigrationJob() {
      bitField0_ = (bitField0_ & ~0x00000004);
      migrationJob_ = null;
      if (migrationJobBuilder_ != null) {
        migrationJobBuilder_.dispose();
        migrationJobBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Represents a [migration
     * job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
     * object.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob migration_job = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.MigrationJob.Builder getMigrationJobBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getMigrationJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Represents a [migration
     * job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
     * object.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob migration_job = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.MigrationJobOrBuilder getMigrationJobOrBuilder() {
      if (migrationJobBuilder_ != null) {
        return migrationJobBuilder_.getMessageOrBuilder();
      } else {
        return migrationJob_ == null
            ? com.google.cloud.clouddms.v1.MigrationJob.getDefaultInstance()
            : migrationJob_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Represents a [migration
     * job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
     * object.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob migration_job = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.MigrationJob,
            com.google.cloud.clouddms.v1.MigrationJob.Builder,
            com.google.cloud.clouddms.v1.MigrationJobOrBuilder>
        getMigrationJobFieldBuilder() {
      if (migrationJobBuilder_ == null) {
        migrationJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.MigrationJob,
                com.google.cloud.clouddms.v1.MigrationJob.Builder,
                com.google.cloud.clouddms.v1.MigrationJobOrBuilder>(
                getMigrationJob(), getParentForChildren(), isClean());
        migrationJob_ = null;
      }
      return migrationJobBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server receives
     * two requests with the same ID, then the second request is ignored.
     *
     * It is recommended to always set this value to a UUID.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server receives
     * two requests with the same ID, then the second request is ignored.
     *
     * It is recommended to always set this value to a UUID.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server receives
     * two requests with the same ID, then the second request is ignored.
     *
     * It is recommended to always set this value to a UUID.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server receives
     * two requests with the same ID, then the second request is ignored.
     *
     * It is recommended to always set this value to a UUID.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server receives
     * two requests with the same ID, then the second request is ignored.
     *
     * It is recommended to always set this value to a UUID.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.CreateMigrationJobRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.CreateMigrationJobRequest)
  private static final com.google.cloud.clouddms.v1.CreateMigrationJobRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.CreateMigrationJobRequest();
  }

  public static com.google.cloud.clouddms.v1.CreateMigrationJobRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateMigrationJobRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateMigrationJobRequest>() {
        @java.lang.Override
        public CreateMigrationJobRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateMigrationJobRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateMigrationJobRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.CreateMigrationJobRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
