/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * The base entity type for all the database related entities.
 * The message contains the entity name, the name of its parent, the entity
 * type, and the specific details per entity type.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.DatabaseEntity}
 */
public final class DatabaseEntity extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.DatabaseEntity)
    DatabaseEntityOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DatabaseEntity.newBuilder() to construct.
  private DatabaseEntity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DatabaseEntity() {
    shortName_ = "";
    parentEntity_ = "";
    tree_ = 0;
    entityType_ = 0;
    mappings_ = java.util.Collections.emptyList();
    entityDdl_ = java.util.Collections.emptyList();
    issues_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DatabaseEntity();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_DatabaseEntity_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_DatabaseEntity_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.DatabaseEntity.class,
            com.google.cloud.clouddms.v1.DatabaseEntity.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of database entities tree.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.DatabaseEntity.TreeType}
   */
  public enum TreeType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Tree type unspecified.
     * </pre>
     *
     * <code>TREE_TYPE_UNSPECIFIED = 0;</code>
     */
    TREE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Tree of entities loaded from a source database.
     * </pre>
     *
     * <code>SOURCE = 1;</code>
     */
    SOURCE(1),
    /**
     *
     *
     * <pre>
     * Tree of entities converted from the source tree using the mapping rules.
     * </pre>
     *
     * <code>DRAFT = 2;</code>
     */
    DRAFT(2),
    /**
     *
     *
     * <pre>
     * Tree of entities observed on the destination database.
     * </pre>
     *
     * <code>DESTINATION = 3;</code>
     */
    DESTINATION(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Tree type unspecified.
     * </pre>
     *
     * <code>TREE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TREE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Tree of entities loaded from a source database.
     * </pre>
     *
     * <code>SOURCE = 1;</code>
     */
    public static final int SOURCE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Tree of entities converted from the source tree using the mapping rules.
     * </pre>
     *
     * <code>DRAFT = 2;</code>
     */
    public static final int DRAFT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Tree of entities observed on the destination database.
     * </pre>
     *
     * <code>DESTINATION = 3;</code>
     */
    public static final int DESTINATION_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TreeType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TreeType forNumber(int value) {
      switch (value) {
        case 0:
          return TREE_TYPE_UNSPECIFIED;
        case 1:
          return SOURCE;
        case 2:
          return DRAFT;
        case 3:
          return DESTINATION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TreeType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TreeType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TreeType>() {
          public TreeType findValueByNumber(int number) {
            return TreeType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.DatabaseEntity.getDescriptor().getEnumTypes().get(0);
    }

    private static final TreeType[] VALUES = values();

    public static TreeType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TreeType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.DatabaseEntity.TreeType)
  }

  private int entityBodyCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object entityBody_;

  public enum EntityBodyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DATABASE(101),
    SCHEMA(102),
    TABLE(103),
    VIEW(104),
    SEQUENCE(105),
    STORED_PROCEDURE(106),
    DATABASE_FUNCTION(107),
    SYNONYM(108),
    DATABASE_PACKAGE(109),
    UDT(110),
    MATERIALIZED_VIEW(111),
    ENTITYBODY_NOT_SET(0);
    private final int value;

    private EntityBodyCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EntityBodyCase valueOf(int value) {
      return forNumber(value);
    }

    public static EntityBodyCase forNumber(int value) {
      switch (value) {
        case 101:
          return DATABASE;
        case 102:
          return SCHEMA;
        case 103:
          return TABLE;
        case 104:
          return VIEW;
        case 105:
          return SEQUENCE;
        case 106:
          return STORED_PROCEDURE;
        case 107:
          return DATABASE_FUNCTION;
        case 108:
          return SYNONYM;
        case 109:
          return DATABASE_PACKAGE;
        case 110:
          return UDT;
        case 111:
          return MATERIALIZED_VIEW;
        case 0:
          return ENTITYBODY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EntityBodyCase getEntityBodyCase() {
    return EntityBodyCase.forNumber(entityBodyCase_);
  }

  public static final int SHORT_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object shortName_ = "";
  /**
   *
   *
   * <pre>
   * The short name (e.g. table name) of the entity.
   * </pre>
   *
   * <code>string short_name = 1;</code>
   *
   * @return The shortName.
   */
  @java.lang.Override
  public java.lang.String getShortName() {
    java.lang.Object ref = shortName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      shortName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The short name (e.g. table name) of the entity.
   * </pre>
   *
   * <code>string short_name = 1;</code>
   *
   * @return The bytes for shortName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getShortNameBytes() {
    java.lang.Object ref = shortName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      shortName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_ENTITY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parentEntity_ = "";
  /**
   *
   *
   * <pre>
   * The full name of the parent entity (e.g. schema name).
   * </pre>
   *
   * <code>string parent_entity = 2;</code>
   *
   * @return The parentEntity.
   */
  @java.lang.Override
  public java.lang.String getParentEntity() {
    java.lang.Object ref = parentEntity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parentEntity_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full name of the parent entity (e.g. schema name).
   * </pre>
   *
   * <code>string parent_entity = 2;</code>
   *
   * @return The bytes for parentEntity.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentEntityBytes() {
    java.lang.Object ref = parentEntity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parentEntity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TREE_FIELD_NUMBER = 3;
  private int tree_ = 0;
  /**
   *
   *
   * <pre>
   * The type of tree the entity belongs to.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseEntity.TreeType tree = 3;</code>
   *
   * @return The enum numeric value on the wire for tree.
   */
  @java.lang.Override
  public int getTreeValue() {
    return tree_;
  }
  /**
   *
   *
   * <pre>
   * The type of tree the entity belongs to.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseEntity.TreeType tree = 3;</code>
   *
   * @return The tree.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseEntity.TreeType getTree() {
    com.google.cloud.clouddms.v1.DatabaseEntity.TreeType result =
        com.google.cloud.clouddms.v1.DatabaseEntity.TreeType.forNumber(tree_);
    return result == null
        ? com.google.cloud.clouddms.v1.DatabaseEntity.TreeType.UNRECOGNIZED
        : result;
  }

  public static final int ENTITY_TYPE_FIELD_NUMBER = 4;
  private int entityType_ = 0;
  /**
   *
   *
   * <pre>
   * The type of the database entity (table, view, index, ...).
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
   *
   * @return The enum numeric value on the wire for entityType.
   */
  @java.lang.Override
  public int getEntityTypeValue() {
    return entityType_;
  }
  /**
   *
   *
   * <pre>
   * The type of the database entity (table, view, index, ...).
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
   *
   * @return The entityType.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseEntityType getEntityType() {
    com.google.cloud.clouddms.v1.DatabaseEntityType result =
        com.google.cloud.clouddms.v1.DatabaseEntityType.forNumber(entityType_);
    return result == null ? com.google.cloud.clouddms.v1.DatabaseEntityType.UNRECOGNIZED : result;
  }

  public static final int MAPPINGS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.clouddms.v1.EntityMapping> mappings_;
  /**
   *
   *
   * <pre>
   * Details about entity mappings.
   * For source tree entities, this holds the draft entities which were
   * generated by the mapping rules.
   * For draft tree entities, this holds the source entities which were
   * converted to form the draft entity.
   * Destination entities will have no mapping details.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.clouddms.v1.EntityMapping> getMappingsList() {
    return mappings_;
  }
  /**
   *
   *
   * <pre>
   * Details about entity mappings.
   * For source tree entities, this holds the draft entities which were
   * generated by the mapping rules.
   * For draft tree entities, this holds the source entities which were
   * converted to form the draft entity.
   * Destination entities will have no mapping details.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.clouddms.v1.EntityMappingOrBuilder>
      getMappingsOrBuilderList() {
    return mappings_;
  }
  /**
   *
   *
   * <pre>
   * Details about entity mappings.
   * For source tree entities, this holds the draft entities which were
   * generated by the mapping rules.
   * For draft tree entities, this holds the source entities which were
   * converted to form the draft entity.
   * Destination entities will have no mapping details.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
   */
  @java.lang.Override
  public int getMappingsCount() {
    return mappings_.size();
  }
  /**
   *
   *
   * <pre>
   * Details about entity mappings.
   * For source tree entities, this holds the draft entities which were
   * generated by the mapping rules.
   * For draft tree entities, this holds the source entities which were
   * converted to form the draft entity.
   * Destination entities will have no mapping details.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityMapping getMappings(int index) {
    return mappings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Details about entity mappings.
   * For source tree entities, this holds the draft entities which were
   * generated by the mapping rules.
   * For draft tree entities, this holds the source entities which were
   * converted to form the draft entity.
   * Destination entities will have no mapping details.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityMappingOrBuilder getMappingsOrBuilder(int index) {
    return mappings_.get(index);
  }

  public static final int ENTITY_DDL_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.clouddms.v1.EntityDdl> entityDdl_;
  /**
   *
   *
   * <pre>
   * Details about the entity DDL script. Multiple DDL scripts are provided for
   * child entities such as a table entity will have one DDL for the table with
   * additional DDLs for each index, constraint and such.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.clouddms.v1.EntityDdl> getEntityDdlList() {
    return entityDdl_;
  }
  /**
   *
   *
   * <pre>
   * Details about the entity DDL script. Multiple DDL scripts are provided for
   * child entities such as a table entity will have one DDL for the table with
   * additional DDLs for each index, constraint and such.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.clouddms.v1.EntityDdlOrBuilder>
      getEntityDdlOrBuilderList() {
    return entityDdl_;
  }
  /**
   *
   *
   * <pre>
   * Details about the entity DDL script. Multiple DDL scripts are provided for
   * child entities such as a table entity will have one DDL for the table with
   * additional DDLs for each index, constraint and such.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
   */
  @java.lang.Override
  public int getEntityDdlCount() {
    return entityDdl_.size();
  }
  /**
   *
   *
   * <pre>
   * Details about the entity DDL script. Multiple DDL scripts are provided for
   * child entities such as a table entity will have one DDL for the table with
   * additional DDLs for each index, constraint and such.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityDdl getEntityDdl(int index) {
    return entityDdl_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Details about the entity DDL script. Multiple DDL scripts are provided for
   * child entities such as a table entity will have one DDL for the table with
   * additional DDLs for each index, constraint and such.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityDdlOrBuilder getEntityDdlOrBuilder(int index) {
    return entityDdl_.get(index);
  }

  public static final int ISSUES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.clouddms.v1.EntityIssue> issues_;
  /**
   *
   *
   * <pre>
   * Details about the various issues found for the entity.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.clouddms.v1.EntityIssue> getIssuesList() {
    return issues_;
  }
  /**
   *
   *
   * <pre>
   * Details about the various issues found for the entity.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.clouddms.v1.EntityIssueOrBuilder>
      getIssuesOrBuilderList() {
    return issues_;
  }
  /**
   *
   *
   * <pre>
   * Details about the various issues found for the entity.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
   */
  @java.lang.Override
  public int getIssuesCount() {
    return issues_.size();
  }
  /**
   *
   *
   * <pre>
   * Details about the various issues found for the entity.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityIssue getIssues(int index) {
    return issues_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Details about the various issues found for the entity.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityIssueOrBuilder getIssuesOrBuilder(int index) {
    return issues_.get(index);
  }

  public static final int DATABASE_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * Database.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
   *
   * @return Whether the database field is set.
   */
  @java.lang.Override
  public boolean hasDatabase() {
    return entityBodyCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * Database.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
   *
   * @return The database.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseInstanceEntity getDatabase() {
    if (entityBodyCase_ == 101) {
      return (com.google.cloud.clouddms.v1.DatabaseInstanceEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.DatabaseInstanceEntity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Database.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseInstanceEntityOrBuilder getDatabaseOrBuilder() {
    if (entityBodyCase_ == 101) {
      return (com.google.cloud.clouddms.v1.DatabaseInstanceEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.DatabaseInstanceEntity.getDefaultInstance();
  }

  public static final int SCHEMA_FIELD_NUMBER = 102;
  /**
   *
   *
   * <pre>
   * Schema.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
   *
   * @return Whether the schema field is set.
   */
  @java.lang.Override
  public boolean hasSchema() {
    return entityBodyCase_ == 102;
  }
  /**
   *
   *
   * <pre>
   * Schema.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
   *
   * @return The schema.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SchemaEntity getSchema() {
    if (entityBodyCase_ == 102) {
      return (com.google.cloud.clouddms.v1.SchemaEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.SchemaEntity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Schema.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SchemaEntityOrBuilder getSchemaOrBuilder() {
    if (entityBodyCase_ == 102) {
      return (com.google.cloud.clouddms.v1.SchemaEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.SchemaEntity.getDefaultInstance();
  }

  public static final int TABLE_FIELD_NUMBER = 103;
  /**
   *
   *
   * <pre>
   * Table.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
   *
   * @return Whether the table field is set.
   */
  @java.lang.Override
  public boolean hasTable() {
    return entityBodyCase_ == 103;
  }
  /**
   *
   *
   * <pre>
   * Table.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
   *
   * @return The table.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.TableEntity getTable() {
    if (entityBodyCase_ == 103) {
      return (com.google.cloud.clouddms.v1.TableEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.TableEntity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Table.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.TableEntityOrBuilder getTableOrBuilder() {
    if (entityBodyCase_ == 103) {
      return (com.google.cloud.clouddms.v1.TableEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.TableEntity.getDefaultInstance();
  }

  public static final int VIEW_FIELD_NUMBER = 104;
  /**
   *
   *
   * <pre>
   * View.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
   *
   * @return Whether the view field is set.
   */
  @java.lang.Override
  public boolean hasView() {
    return entityBodyCase_ == 104;
  }
  /**
   *
   *
   * <pre>
   * View.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
   *
   * @return The view.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ViewEntity getView() {
    if (entityBodyCase_ == 104) {
      return (com.google.cloud.clouddms.v1.ViewEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.ViewEntity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * View.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ViewEntityOrBuilder getViewOrBuilder() {
    if (entityBodyCase_ == 104) {
      return (com.google.cloud.clouddms.v1.ViewEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.ViewEntity.getDefaultInstance();
  }

  public static final int SEQUENCE_FIELD_NUMBER = 105;
  /**
   *
   *
   * <pre>
   * Sequence.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
   *
   * @return Whether the sequence field is set.
   */
  @java.lang.Override
  public boolean hasSequence() {
    return entityBodyCase_ == 105;
  }
  /**
   *
   *
   * <pre>
   * Sequence.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
   *
   * @return The sequence.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SequenceEntity getSequence() {
    if (entityBodyCase_ == 105) {
      return (com.google.cloud.clouddms.v1.SequenceEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.SequenceEntity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Sequence.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SequenceEntityOrBuilder getSequenceOrBuilder() {
    if (entityBodyCase_ == 105) {
      return (com.google.cloud.clouddms.v1.SequenceEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.SequenceEntity.getDefaultInstance();
  }

  public static final int STORED_PROCEDURE_FIELD_NUMBER = 106;
  /**
   *
   *
   * <pre>
   * Stored procedure.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
   *
   * @return Whether the storedProcedure field is set.
   */
  @java.lang.Override
  public boolean hasStoredProcedure() {
    return entityBodyCase_ == 106;
  }
  /**
   *
   *
   * <pre>
   * Stored procedure.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
   *
   * @return The storedProcedure.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.StoredProcedureEntity getStoredProcedure() {
    if (entityBodyCase_ == 106) {
      return (com.google.cloud.clouddms.v1.StoredProcedureEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.StoredProcedureEntity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Stored procedure.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.StoredProcedureEntityOrBuilder getStoredProcedureOrBuilder() {
    if (entityBodyCase_ == 106) {
      return (com.google.cloud.clouddms.v1.StoredProcedureEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.StoredProcedureEntity.getDefaultInstance();
  }

  public static final int DATABASE_FUNCTION_FIELD_NUMBER = 107;
  /**
   *
   *
   * <pre>
   * Function.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
   *
   * @return Whether the databaseFunction field is set.
   */
  @java.lang.Override
  public boolean hasDatabaseFunction() {
    return entityBodyCase_ == 107;
  }
  /**
   *
   *
   * <pre>
   * Function.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
   *
   * @return The databaseFunction.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.FunctionEntity getDatabaseFunction() {
    if (entityBodyCase_ == 107) {
      return (com.google.cloud.clouddms.v1.FunctionEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.FunctionEntity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Function.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.FunctionEntityOrBuilder getDatabaseFunctionOrBuilder() {
    if (entityBodyCase_ == 107) {
      return (com.google.cloud.clouddms.v1.FunctionEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.FunctionEntity.getDefaultInstance();
  }

  public static final int SYNONYM_FIELD_NUMBER = 108;
  /**
   *
   *
   * <pre>
   * Synonym.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
   *
   * @return Whether the synonym field is set.
   */
  @java.lang.Override
  public boolean hasSynonym() {
    return entityBodyCase_ == 108;
  }
  /**
   *
   *
   * <pre>
   * Synonym.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
   *
   * @return The synonym.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SynonymEntity getSynonym() {
    if (entityBodyCase_ == 108) {
      return (com.google.cloud.clouddms.v1.SynonymEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.SynonymEntity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Synonym.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SynonymEntityOrBuilder getSynonymOrBuilder() {
    if (entityBodyCase_ == 108) {
      return (com.google.cloud.clouddms.v1.SynonymEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.SynonymEntity.getDefaultInstance();
  }

  public static final int DATABASE_PACKAGE_FIELD_NUMBER = 109;
  /**
   *
   *
   * <pre>
   * Package.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
   *
   * @return Whether the databasePackage field is set.
   */
  @java.lang.Override
  public boolean hasDatabasePackage() {
    return entityBodyCase_ == 109;
  }
  /**
   *
   *
   * <pre>
   * Package.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
   *
   * @return The databasePackage.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.PackageEntity getDatabasePackage() {
    if (entityBodyCase_ == 109) {
      return (com.google.cloud.clouddms.v1.PackageEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.PackageEntity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Package.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.PackageEntityOrBuilder getDatabasePackageOrBuilder() {
    if (entityBodyCase_ == 109) {
      return (com.google.cloud.clouddms.v1.PackageEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.PackageEntity.getDefaultInstance();
  }

  public static final int UDT_FIELD_NUMBER = 110;
  /**
   *
   *
   * <pre>
   * UDT.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
   *
   * @return Whether the udt field is set.
   */
  @java.lang.Override
  public boolean hasUdt() {
    return entityBodyCase_ == 110;
  }
  /**
   *
   *
   * <pre>
   * UDT.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
   *
   * @return The udt.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.UDTEntity getUdt() {
    if (entityBodyCase_ == 110) {
      return (com.google.cloud.clouddms.v1.UDTEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.UDTEntity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * UDT.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.UDTEntityOrBuilder getUdtOrBuilder() {
    if (entityBodyCase_ == 110) {
      return (com.google.cloud.clouddms.v1.UDTEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.UDTEntity.getDefaultInstance();
  }

  public static final int MATERIALIZED_VIEW_FIELD_NUMBER = 111;
  /**
   *
   *
   * <pre>
   * Materialized view.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
   *
   * @return Whether the materializedView field is set.
   */
  @java.lang.Override
  public boolean hasMaterializedView() {
    return entityBodyCase_ == 111;
  }
  /**
   *
   *
   * <pre>
   * Materialized view.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
   *
   * @return The materializedView.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MaterializedViewEntity getMaterializedView() {
    if (entityBodyCase_ == 111) {
      return (com.google.cloud.clouddms.v1.MaterializedViewEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.MaterializedViewEntity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Materialized view.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MaterializedViewEntityOrBuilder
      getMaterializedViewOrBuilder() {
    if (entityBodyCase_ == 111) {
      return (com.google.cloud.clouddms.v1.MaterializedViewEntity) entityBody_;
    }
    return com.google.cloud.clouddms.v1.MaterializedViewEntity.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(shortName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, shortName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentEntity_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, parentEntity_);
    }
    if (tree_
        != com.google.cloud.clouddms.v1.DatabaseEntity.TreeType.TREE_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, tree_);
    }
    if (entityType_
        != com.google.cloud.clouddms.v1.DatabaseEntityType.DATABASE_ENTITY_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, entityType_);
    }
    for (int i = 0; i < mappings_.size(); i++) {
      output.writeMessage(5, mappings_.get(i));
    }
    for (int i = 0; i < entityDdl_.size(); i++) {
      output.writeMessage(6, entityDdl_.get(i));
    }
    for (int i = 0; i < issues_.size(); i++) {
      output.writeMessage(7, issues_.get(i));
    }
    if (entityBodyCase_ == 101) {
      output.writeMessage(101, (com.google.cloud.clouddms.v1.DatabaseInstanceEntity) entityBody_);
    }
    if (entityBodyCase_ == 102) {
      output.writeMessage(102, (com.google.cloud.clouddms.v1.SchemaEntity) entityBody_);
    }
    if (entityBodyCase_ == 103) {
      output.writeMessage(103, (com.google.cloud.clouddms.v1.TableEntity) entityBody_);
    }
    if (entityBodyCase_ == 104) {
      output.writeMessage(104, (com.google.cloud.clouddms.v1.ViewEntity) entityBody_);
    }
    if (entityBodyCase_ == 105) {
      output.writeMessage(105, (com.google.cloud.clouddms.v1.SequenceEntity) entityBody_);
    }
    if (entityBodyCase_ == 106) {
      output.writeMessage(106, (com.google.cloud.clouddms.v1.StoredProcedureEntity) entityBody_);
    }
    if (entityBodyCase_ == 107) {
      output.writeMessage(107, (com.google.cloud.clouddms.v1.FunctionEntity) entityBody_);
    }
    if (entityBodyCase_ == 108) {
      output.writeMessage(108, (com.google.cloud.clouddms.v1.SynonymEntity) entityBody_);
    }
    if (entityBodyCase_ == 109) {
      output.writeMessage(109, (com.google.cloud.clouddms.v1.PackageEntity) entityBody_);
    }
    if (entityBodyCase_ == 110) {
      output.writeMessage(110, (com.google.cloud.clouddms.v1.UDTEntity) entityBody_);
    }
    if (entityBodyCase_ == 111) {
      output.writeMessage(111, (com.google.cloud.clouddms.v1.MaterializedViewEntity) entityBody_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(shortName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, shortName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentEntity_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, parentEntity_);
    }
    if (tree_
        != com.google.cloud.clouddms.v1.DatabaseEntity.TreeType.TREE_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, tree_);
    }
    if (entityType_
        != com.google.cloud.clouddms.v1.DatabaseEntityType.DATABASE_ENTITY_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, entityType_);
    }
    for (int i = 0; i < mappings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, mappings_.get(i));
    }
    for (int i = 0; i < entityDdl_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, entityDdl_.get(i));
    }
    for (int i = 0; i < issues_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, issues_.get(i));
    }
    if (entityBodyCase_ == 101) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              101, (com.google.cloud.clouddms.v1.DatabaseInstanceEntity) entityBody_);
    }
    if (entityBodyCase_ == 102) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              102, (com.google.cloud.clouddms.v1.SchemaEntity) entityBody_);
    }
    if (entityBodyCase_ == 103) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              103, (com.google.cloud.clouddms.v1.TableEntity) entityBody_);
    }
    if (entityBodyCase_ == 104) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              104, (com.google.cloud.clouddms.v1.ViewEntity) entityBody_);
    }
    if (entityBodyCase_ == 105) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              105, (com.google.cloud.clouddms.v1.SequenceEntity) entityBody_);
    }
    if (entityBodyCase_ == 106) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              106, (com.google.cloud.clouddms.v1.StoredProcedureEntity) entityBody_);
    }
    if (entityBodyCase_ == 107) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              107, (com.google.cloud.clouddms.v1.FunctionEntity) entityBody_);
    }
    if (entityBodyCase_ == 108) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              108, (com.google.cloud.clouddms.v1.SynonymEntity) entityBody_);
    }
    if (entityBodyCase_ == 109) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              109, (com.google.cloud.clouddms.v1.PackageEntity) entityBody_);
    }
    if (entityBodyCase_ == 110) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              110, (com.google.cloud.clouddms.v1.UDTEntity) entityBody_);
    }
    if (entityBodyCase_ == 111) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              111, (com.google.cloud.clouddms.v1.MaterializedViewEntity) entityBody_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.DatabaseEntity)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.DatabaseEntity other =
        (com.google.cloud.clouddms.v1.DatabaseEntity) obj;

    if (!getShortName().equals(other.getShortName())) return false;
    if (!getParentEntity().equals(other.getParentEntity())) return false;
    if (tree_ != other.tree_) return false;
    if (entityType_ != other.entityType_) return false;
    if (!getMappingsList().equals(other.getMappingsList())) return false;
    if (!getEntityDdlList().equals(other.getEntityDdlList())) return false;
    if (!getIssuesList().equals(other.getIssuesList())) return false;
    if (!getEntityBodyCase().equals(other.getEntityBodyCase())) return false;
    switch (entityBodyCase_) {
      case 101:
        if (!getDatabase().equals(other.getDatabase())) return false;
        break;
      case 102:
        if (!getSchema().equals(other.getSchema())) return false;
        break;
      case 103:
        if (!getTable().equals(other.getTable())) return false;
        break;
      case 104:
        if (!getView().equals(other.getView())) return false;
        break;
      case 105:
        if (!getSequence().equals(other.getSequence())) return false;
        break;
      case 106:
        if (!getStoredProcedure().equals(other.getStoredProcedure())) return false;
        break;
      case 107:
        if (!getDatabaseFunction().equals(other.getDatabaseFunction())) return false;
        break;
      case 108:
        if (!getSynonym().equals(other.getSynonym())) return false;
        break;
      case 109:
        if (!getDatabasePackage().equals(other.getDatabasePackage())) return false;
        break;
      case 110:
        if (!getUdt().equals(other.getUdt())) return false;
        break;
      case 111:
        if (!getMaterializedView().equals(other.getMaterializedView())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SHORT_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getShortName().hashCode();
    hash = (37 * hash) + PARENT_ENTITY_FIELD_NUMBER;
    hash = (53 * hash) + getParentEntity().hashCode();
    hash = (37 * hash) + TREE_FIELD_NUMBER;
    hash = (53 * hash) + tree_;
    hash = (37 * hash) + ENTITY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + entityType_;
    if (getMappingsCount() > 0) {
      hash = (37 * hash) + MAPPINGS_FIELD_NUMBER;
      hash = (53 * hash) + getMappingsList().hashCode();
    }
    if (getEntityDdlCount() > 0) {
      hash = (37 * hash) + ENTITY_DDL_FIELD_NUMBER;
      hash = (53 * hash) + getEntityDdlList().hashCode();
    }
    if (getIssuesCount() > 0) {
      hash = (37 * hash) + ISSUES_FIELD_NUMBER;
      hash = (53 * hash) + getIssuesList().hashCode();
    }
    switch (entityBodyCase_) {
      case 101:
        hash = (37 * hash) + DATABASE_FIELD_NUMBER;
        hash = (53 * hash) + getDatabase().hashCode();
        break;
      case 102:
        hash = (37 * hash) + SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getSchema().hashCode();
        break;
      case 103:
        hash = (37 * hash) + TABLE_FIELD_NUMBER;
        hash = (53 * hash) + getTable().hashCode();
        break;
      case 104:
        hash = (37 * hash) + VIEW_FIELD_NUMBER;
        hash = (53 * hash) + getView().hashCode();
        break;
      case 105:
        hash = (37 * hash) + SEQUENCE_FIELD_NUMBER;
        hash = (53 * hash) + getSequence().hashCode();
        break;
      case 106:
        hash = (37 * hash) + STORED_PROCEDURE_FIELD_NUMBER;
        hash = (53 * hash) + getStoredProcedure().hashCode();
        break;
      case 107:
        hash = (37 * hash) + DATABASE_FUNCTION_FIELD_NUMBER;
        hash = (53 * hash) + getDatabaseFunction().hashCode();
        break;
      case 108:
        hash = (37 * hash) + SYNONYM_FIELD_NUMBER;
        hash = (53 * hash) + getSynonym().hashCode();
        break;
      case 109:
        hash = (37 * hash) + DATABASE_PACKAGE_FIELD_NUMBER;
        hash = (53 * hash) + getDatabasePackage().hashCode();
        break;
      case 110:
        hash = (37 * hash) + UDT_FIELD_NUMBER;
        hash = (53 * hash) + getUdt().hashCode();
        break;
      case 111:
        hash = (37 * hash) + MATERIALIZED_VIEW_FIELD_NUMBER;
        hash = (53 * hash) + getMaterializedView().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.DatabaseEntity parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.DatabaseEntity parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.DatabaseEntity parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.DatabaseEntity parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.DatabaseEntity parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.DatabaseEntity parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.DatabaseEntity parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.DatabaseEntity parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.DatabaseEntity parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.DatabaseEntity parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.DatabaseEntity parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.DatabaseEntity parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.DatabaseEntity prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The base entity type for all the database related entities.
   * The message contains the entity name, the name of its parent, the entity
   * type, and the specific details per entity type.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.DatabaseEntity}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.DatabaseEntity)
      com.google.cloud.clouddms.v1.DatabaseEntityOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_DatabaseEntity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_DatabaseEntity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.DatabaseEntity.class,
              com.google.cloud.clouddms.v1.DatabaseEntity.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.DatabaseEntity.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      shortName_ = "";
      parentEntity_ = "";
      tree_ = 0;
      entityType_ = 0;
      if (mappingsBuilder_ == null) {
        mappings_ = java.util.Collections.emptyList();
      } else {
        mappings_ = null;
        mappingsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (entityDdlBuilder_ == null) {
        entityDdl_ = java.util.Collections.emptyList();
      } else {
        entityDdl_ = null;
        entityDdlBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      if (issuesBuilder_ == null) {
        issues_ = java.util.Collections.emptyList();
      } else {
        issues_ = null;
        issuesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      if (databaseBuilder_ != null) {
        databaseBuilder_.clear();
      }
      if (schemaBuilder_ != null) {
        schemaBuilder_.clear();
      }
      if (tableBuilder_ != null) {
        tableBuilder_.clear();
      }
      if (viewBuilder_ != null) {
        viewBuilder_.clear();
      }
      if (sequenceBuilder_ != null) {
        sequenceBuilder_.clear();
      }
      if (storedProcedureBuilder_ != null) {
        storedProcedureBuilder_.clear();
      }
      if (databaseFunctionBuilder_ != null) {
        databaseFunctionBuilder_.clear();
      }
      if (synonymBuilder_ != null) {
        synonymBuilder_.clear();
      }
      if (databasePackageBuilder_ != null) {
        databasePackageBuilder_.clear();
      }
      if (udtBuilder_ != null) {
        udtBuilder_.clear();
      }
      if (materializedViewBuilder_ != null) {
        materializedViewBuilder_.clear();
      }
      entityBodyCase_ = 0;
      entityBody_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_DatabaseEntity_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.DatabaseEntity getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.DatabaseEntity.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.DatabaseEntity build() {
      com.google.cloud.clouddms.v1.DatabaseEntity result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.DatabaseEntity buildPartial() {
      com.google.cloud.clouddms.v1.DatabaseEntity result =
          new com.google.cloud.clouddms.v1.DatabaseEntity(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.clouddms.v1.DatabaseEntity result) {
      if (mappingsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          mappings_ = java.util.Collections.unmodifiableList(mappings_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.mappings_ = mappings_;
      } else {
        result.mappings_ = mappingsBuilder_.build();
      }
      if (entityDdlBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          entityDdl_ = java.util.Collections.unmodifiableList(entityDdl_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.entityDdl_ = entityDdl_;
      } else {
        result.entityDdl_ = entityDdlBuilder_.build();
      }
      if (issuesBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          issues_ = java.util.Collections.unmodifiableList(issues_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.issues_ = issues_;
      } else {
        result.issues_ = issuesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.DatabaseEntity result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.shortName_ = shortName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.parentEntity_ = parentEntity_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.tree_ = tree_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.entityType_ = entityType_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.clouddms.v1.DatabaseEntity result) {
      result.entityBodyCase_ = entityBodyCase_;
      result.entityBody_ = this.entityBody_;
      if (entityBodyCase_ == 101 && databaseBuilder_ != null) {
        result.entityBody_ = databaseBuilder_.build();
      }
      if (entityBodyCase_ == 102 && schemaBuilder_ != null) {
        result.entityBody_ = schemaBuilder_.build();
      }
      if (entityBodyCase_ == 103 && tableBuilder_ != null) {
        result.entityBody_ = tableBuilder_.build();
      }
      if (entityBodyCase_ == 104 && viewBuilder_ != null) {
        result.entityBody_ = viewBuilder_.build();
      }
      if (entityBodyCase_ == 105 && sequenceBuilder_ != null) {
        result.entityBody_ = sequenceBuilder_.build();
      }
      if (entityBodyCase_ == 106 && storedProcedureBuilder_ != null) {
        result.entityBody_ = storedProcedureBuilder_.build();
      }
      if (entityBodyCase_ == 107 && databaseFunctionBuilder_ != null) {
        result.entityBody_ = databaseFunctionBuilder_.build();
      }
      if (entityBodyCase_ == 108 && synonymBuilder_ != null) {
        result.entityBody_ = synonymBuilder_.build();
      }
      if (entityBodyCase_ == 109 && databasePackageBuilder_ != null) {
        result.entityBody_ = databasePackageBuilder_.build();
      }
      if (entityBodyCase_ == 110 && udtBuilder_ != null) {
        result.entityBody_ = udtBuilder_.build();
      }
      if (entityBodyCase_ == 111 && materializedViewBuilder_ != null) {
        result.entityBody_ = materializedViewBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.DatabaseEntity) {
        return mergeFrom((com.google.cloud.clouddms.v1.DatabaseEntity) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.DatabaseEntity other) {
      if (other == com.google.cloud.clouddms.v1.DatabaseEntity.getDefaultInstance()) return this;
      if (!other.getShortName().isEmpty()) {
        shortName_ = other.shortName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getParentEntity().isEmpty()) {
        parentEntity_ = other.parentEntity_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.tree_ != 0) {
        setTreeValue(other.getTreeValue());
      }
      if (other.entityType_ != 0) {
        setEntityTypeValue(other.getEntityTypeValue());
      }
      if (mappingsBuilder_ == null) {
        if (!other.mappings_.isEmpty()) {
          if (mappings_.isEmpty()) {
            mappings_ = other.mappings_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureMappingsIsMutable();
            mappings_.addAll(other.mappings_);
          }
          onChanged();
        }
      } else {
        if (!other.mappings_.isEmpty()) {
          if (mappingsBuilder_.isEmpty()) {
            mappingsBuilder_.dispose();
            mappingsBuilder_ = null;
            mappings_ = other.mappings_;
            bitField0_ = (bitField0_ & ~0x00000010);
            mappingsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMappingsFieldBuilder()
                    : null;
          } else {
            mappingsBuilder_.addAllMessages(other.mappings_);
          }
        }
      }
      if (entityDdlBuilder_ == null) {
        if (!other.entityDdl_.isEmpty()) {
          if (entityDdl_.isEmpty()) {
            entityDdl_ = other.entityDdl_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureEntityDdlIsMutable();
            entityDdl_.addAll(other.entityDdl_);
          }
          onChanged();
        }
      } else {
        if (!other.entityDdl_.isEmpty()) {
          if (entityDdlBuilder_.isEmpty()) {
            entityDdlBuilder_.dispose();
            entityDdlBuilder_ = null;
            entityDdl_ = other.entityDdl_;
            bitField0_ = (bitField0_ & ~0x00000020);
            entityDdlBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEntityDdlFieldBuilder()
                    : null;
          } else {
            entityDdlBuilder_.addAllMessages(other.entityDdl_);
          }
        }
      }
      if (issuesBuilder_ == null) {
        if (!other.issues_.isEmpty()) {
          if (issues_.isEmpty()) {
            issues_ = other.issues_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureIssuesIsMutable();
            issues_.addAll(other.issues_);
          }
          onChanged();
        }
      } else {
        if (!other.issues_.isEmpty()) {
          if (issuesBuilder_.isEmpty()) {
            issuesBuilder_.dispose();
            issuesBuilder_ = null;
            issues_ = other.issues_;
            bitField0_ = (bitField0_ & ~0x00000040);
            issuesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getIssuesFieldBuilder()
                    : null;
          } else {
            issuesBuilder_.addAllMessages(other.issues_);
          }
        }
      }
      switch (other.getEntityBodyCase()) {
        case DATABASE:
          {
            mergeDatabase(other.getDatabase());
            break;
          }
        case SCHEMA:
          {
            mergeSchema(other.getSchema());
            break;
          }
        case TABLE:
          {
            mergeTable(other.getTable());
            break;
          }
        case VIEW:
          {
            mergeView(other.getView());
            break;
          }
        case SEQUENCE:
          {
            mergeSequence(other.getSequence());
            break;
          }
        case STORED_PROCEDURE:
          {
            mergeStoredProcedure(other.getStoredProcedure());
            break;
          }
        case DATABASE_FUNCTION:
          {
            mergeDatabaseFunction(other.getDatabaseFunction());
            break;
          }
        case SYNONYM:
          {
            mergeSynonym(other.getSynonym());
            break;
          }
        case DATABASE_PACKAGE:
          {
            mergeDatabasePackage(other.getDatabasePackage());
            break;
          }
        case UDT:
          {
            mergeUdt(other.getUdt());
            break;
          }
        case MATERIALIZED_VIEW:
          {
            mergeMaterializedView(other.getMaterializedView());
            break;
          }
        case ENTITYBODY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                shortName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                parentEntity_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                tree_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                entityType_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                com.google.cloud.clouddms.v1.EntityMapping m =
                    input.readMessage(
                        com.google.cloud.clouddms.v1.EntityMapping.parser(), extensionRegistry);
                if (mappingsBuilder_ == null) {
                  ensureMappingsIsMutable();
                  mappings_.add(m);
                } else {
                  mappingsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.clouddms.v1.EntityDdl m =
                    input.readMessage(
                        com.google.cloud.clouddms.v1.EntityDdl.parser(), extensionRegistry);
                if (entityDdlBuilder_ == null) {
                  ensureEntityDdlIsMutable();
                  entityDdl_.add(m);
                } else {
                  entityDdlBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.clouddms.v1.EntityIssue m =
                    input.readMessage(
                        com.google.cloud.clouddms.v1.EntityIssue.parser(), extensionRegistry);
                if (issuesBuilder_ == null) {
                  ensureIssuesIsMutable();
                  issues_.add(m);
                } else {
                  issuesBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 810:
              {
                input.readMessage(getDatabaseFieldBuilder().getBuilder(), extensionRegistry);
                entityBodyCase_ = 101;
                break;
              } // case 810
            case 818:
              {
                input.readMessage(getSchemaFieldBuilder().getBuilder(), extensionRegistry);
                entityBodyCase_ = 102;
                break;
              } // case 818
            case 826:
              {
                input.readMessage(getTableFieldBuilder().getBuilder(), extensionRegistry);
                entityBodyCase_ = 103;
                break;
              } // case 826
            case 834:
              {
                input.readMessage(getViewFieldBuilder().getBuilder(), extensionRegistry);
                entityBodyCase_ = 104;
                break;
              } // case 834
            case 842:
              {
                input.readMessage(getSequenceFieldBuilder().getBuilder(), extensionRegistry);
                entityBodyCase_ = 105;
                break;
              } // case 842
            case 850:
              {
                input.readMessage(getStoredProcedureFieldBuilder().getBuilder(), extensionRegistry);
                entityBodyCase_ = 106;
                break;
              } // case 850
            case 858:
              {
                input.readMessage(
                    getDatabaseFunctionFieldBuilder().getBuilder(), extensionRegistry);
                entityBodyCase_ = 107;
                break;
              } // case 858
            case 866:
              {
                input.readMessage(getSynonymFieldBuilder().getBuilder(), extensionRegistry);
                entityBodyCase_ = 108;
                break;
              } // case 866
            case 874:
              {
                input.readMessage(getDatabasePackageFieldBuilder().getBuilder(), extensionRegistry);
                entityBodyCase_ = 109;
                break;
              } // case 874
            case 882:
              {
                input.readMessage(getUdtFieldBuilder().getBuilder(), extensionRegistry);
                entityBodyCase_ = 110;
                break;
              } // case 882
            case 890:
              {
                input.readMessage(
                    getMaterializedViewFieldBuilder().getBuilder(), extensionRegistry);
                entityBodyCase_ = 111;
                break;
              } // case 890
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int entityBodyCase_ = 0;
    private java.lang.Object entityBody_;

    public EntityBodyCase getEntityBodyCase() {
      return EntityBodyCase.forNumber(entityBodyCase_);
    }

    public Builder clearEntityBody() {
      entityBodyCase_ = 0;
      entityBody_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object shortName_ = "";
    /**
     *
     *
     * <pre>
     * The short name (e.g. table name) of the entity.
     * </pre>
     *
     * <code>string short_name = 1;</code>
     *
     * @return The shortName.
     */
    public java.lang.String getShortName() {
      java.lang.Object ref = shortName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        shortName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The short name (e.g. table name) of the entity.
     * </pre>
     *
     * <code>string short_name = 1;</code>
     *
     * @return The bytes for shortName.
     */
    public com.google.protobuf.ByteString getShortNameBytes() {
      java.lang.Object ref = shortName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        shortName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The short name (e.g. table name) of the entity.
     * </pre>
     *
     * <code>string short_name = 1;</code>
     *
     * @param value The shortName to set.
     * @return This builder for chaining.
     */
    public Builder setShortName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      shortName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The short name (e.g. table name) of the entity.
     * </pre>
     *
     * <code>string short_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearShortName() {
      shortName_ = getDefaultInstance().getShortName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The short name (e.g. table name) of the entity.
     * </pre>
     *
     * <code>string short_name = 1;</code>
     *
     * @param value The bytes for shortName to set.
     * @return This builder for chaining.
     */
    public Builder setShortNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      shortName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object parentEntity_ = "";
    /**
     *
     *
     * <pre>
     * The full name of the parent entity (e.g. schema name).
     * </pre>
     *
     * <code>string parent_entity = 2;</code>
     *
     * @return The parentEntity.
     */
    public java.lang.String getParentEntity() {
      java.lang.Object ref = parentEntity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parentEntity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the parent entity (e.g. schema name).
     * </pre>
     *
     * <code>string parent_entity = 2;</code>
     *
     * @return The bytes for parentEntity.
     */
    public com.google.protobuf.ByteString getParentEntityBytes() {
      java.lang.Object ref = parentEntity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parentEntity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the parent entity (e.g. schema name).
     * </pre>
     *
     * <code>string parent_entity = 2;</code>
     *
     * @param value The parentEntity to set.
     * @return This builder for chaining.
     */
    public Builder setParentEntity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parentEntity_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the parent entity (e.g. schema name).
     * </pre>
     *
     * <code>string parent_entity = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentEntity() {
      parentEntity_ = getDefaultInstance().getParentEntity();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the parent entity (e.g. schema name).
     * </pre>
     *
     * <code>string parent_entity = 2;</code>
     *
     * @param value The bytes for parentEntity to set.
     * @return This builder for chaining.
     */
    public Builder setParentEntityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parentEntity_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int tree_ = 0;
    /**
     *
     *
     * <pre>
     * The type of tree the entity belongs to.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntity.TreeType tree = 3;</code>
     *
     * @return The enum numeric value on the wire for tree.
     */
    @java.lang.Override
    public int getTreeValue() {
      return tree_;
    }
    /**
     *
     *
     * <pre>
     * The type of tree the entity belongs to.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntity.TreeType tree = 3;</code>
     *
     * @param value The enum numeric value on the wire for tree to set.
     * @return This builder for chaining.
     */
    public Builder setTreeValue(int value) {
      tree_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of tree the entity belongs to.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntity.TreeType tree = 3;</code>
     *
     * @return The tree.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.DatabaseEntity.TreeType getTree() {
      com.google.cloud.clouddms.v1.DatabaseEntity.TreeType result =
          com.google.cloud.clouddms.v1.DatabaseEntity.TreeType.forNumber(tree_);
      return result == null
          ? com.google.cloud.clouddms.v1.DatabaseEntity.TreeType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of tree the entity belongs to.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntity.TreeType tree = 3;</code>
     *
     * @param value The tree to set.
     * @return This builder for chaining.
     */
    public Builder setTree(com.google.cloud.clouddms.v1.DatabaseEntity.TreeType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      tree_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of tree the entity belongs to.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntity.TreeType tree = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTree() {
      bitField0_ = (bitField0_ & ~0x00000004);
      tree_ = 0;
      onChanged();
      return this;
    }

    private int entityType_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the database entity (table, view, index, ...).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
     *
     * @return The enum numeric value on the wire for entityType.
     */
    @java.lang.Override
    public int getEntityTypeValue() {
      return entityType_;
    }
    /**
     *
     *
     * <pre>
     * The type of the database entity (table, view, index, ...).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
     *
     * @param value The enum numeric value on the wire for entityType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityTypeValue(int value) {
      entityType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the database entity (table, view, index, ...).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
     *
     * @return The entityType.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.DatabaseEntityType getEntityType() {
      com.google.cloud.clouddms.v1.DatabaseEntityType result =
          com.google.cloud.clouddms.v1.DatabaseEntityType.forNumber(entityType_);
      return result == null ? com.google.cloud.clouddms.v1.DatabaseEntityType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The type of the database entity (table, view, index, ...).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
     *
     * @param value The entityType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityType(com.google.cloud.clouddms.v1.DatabaseEntityType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      entityType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the database entity (table, view, index, ...).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityType() {
      bitField0_ = (bitField0_ & ~0x00000008);
      entityType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.clouddms.v1.EntityMapping> mappings_ =
        java.util.Collections.emptyList();

    private void ensureMappingsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        mappings_ = new java.util.ArrayList<com.google.cloud.clouddms.v1.EntityMapping>(mappings_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.clouddms.v1.EntityMapping,
            com.google.cloud.clouddms.v1.EntityMapping.Builder,
            com.google.cloud.clouddms.v1.EntityMappingOrBuilder>
        mappingsBuilder_;

    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public java.util.List<com.google.cloud.clouddms.v1.EntityMapping> getMappingsList() {
      if (mappingsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(mappings_);
      } else {
        return mappingsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public int getMappingsCount() {
      if (mappingsBuilder_ == null) {
        return mappings_.size();
      } else {
        return mappingsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public com.google.cloud.clouddms.v1.EntityMapping getMappings(int index) {
      if (mappingsBuilder_ == null) {
        return mappings_.get(index);
      } else {
        return mappingsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public Builder setMappings(int index, com.google.cloud.clouddms.v1.EntityMapping value) {
      if (mappingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMappingsIsMutable();
        mappings_.set(index, value);
        onChanged();
      } else {
        mappingsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public Builder setMappings(
        int index, com.google.cloud.clouddms.v1.EntityMapping.Builder builderForValue) {
      if (mappingsBuilder_ == null) {
        ensureMappingsIsMutable();
        mappings_.set(index, builderForValue.build());
        onChanged();
      } else {
        mappingsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public Builder addMappings(com.google.cloud.clouddms.v1.EntityMapping value) {
      if (mappingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMappingsIsMutable();
        mappings_.add(value);
        onChanged();
      } else {
        mappingsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public Builder addMappings(int index, com.google.cloud.clouddms.v1.EntityMapping value) {
      if (mappingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMappingsIsMutable();
        mappings_.add(index, value);
        onChanged();
      } else {
        mappingsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public Builder addMappings(com.google.cloud.clouddms.v1.EntityMapping.Builder builderForValue) {
      if (mappingsBuilder_ == null) {
        ensureMappingsIsMutable();
        mappings_.add(builderForValue.build());
        onChanged();
      } else {
        mappingsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public Builder addMappings(
        int index, com.google.cloud.clouddms.v1.EntityMapping.Builder builderForValue) {
      if (mappingsBuilder_ == null) {
        ensureMappingsIsMutable();
        mappings_.add(index, builderForValue.build());
        onChanged();
      } else {
        mappingsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public Builder addAllMappings(
        java.lang.Iterable<? extends com.google.cloud.clouddms.v1.EntityMapping> values) {
      if (mappingsBuilder_ == null) {
        ensureMappingsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mappings_);
        onChanged();
      } else {
        mappingsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public Builder clearMappings() {
      if (mappingsBuilder_ == null) {
        mappings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        mappingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public Builder removeMappings(int index) {
      if (mappingsBuilder_ == null) {
        ensureMappingsIsMutable();
        mappings_.remove(index);
        onChanged();
      } else {
        mappingsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public com.google.cloud.clouddms.v1.EntityMapping.Builder getMappingsBuilder(int index) {
      return getMappingsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public com.google.cloud.clouddms.v1.EntityMappingOrBuilder getMappingsOrBuilder(int index) {
      if (mappingsBuilder_ == null) {
        return mappings_.get(index);
      } else {
        return mappingsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.clouddms.v1.EntityMappingOrBuilder>
        getMappingsOrBuilderList() {
      if (mappingsBuilder_ != null) {
        return mappingsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(mappings_);
      }
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public com.google.cloud.clouddms.v1.EntityMapping.Builder addMappingsBuilder() {
      return getMappingsFieldBuilder()
          .addBuilder(com.google.cloud.clouddms.v1.EntityMapping.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public com.google.cloud.clouddms.v1.EntityMapping.Builder addMappingsBuilder(int index) {
      return getMappingsFieldBuilder()
          .addBuilder(index, com.google.cloud.clouddms.v1.EntityMapping.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    public java.util.List<com.google.cloud.clouddms.v1.EntityMapping.Builder>
        getMappingsBuilderList() {
      return getMappingsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.clouddms.v1.EntityMapping,
            com.google.cloud.clouddms.v1.EntityMapping.Builder,
            com.google.cloud.clouddms.v1.EntityMappingOrBuilder>
        getMappingsFieldBuilder() {
      if (mappingsBuilder_ == null) {
        mappingsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.clouddms.v1.EntityMapping,
                com.google.cloud.clouddms.v1.EntityMapping.Builder,
                com.google.cloud.clouddms.v1.EntityMappingOrBuilder>(
                mappings_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        mappings_ = null;
      }
      return mappingsBuilder_;
    }

    private java.util.List<com.google.cloud.clouddms.v1.EntityDdl> entityDdl_ =
        java.util.Collections.emptyList();

    private void ensureEntityDdlIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        entityDdl_ = new java.util.ArrayList<com.google.cloud.clouddms.v1.EntityDdl>(entityDdl_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.clouddms.v1.EntityDdl,
            com.google.cloud.clouddms.v1.EntityDdl.Builder,
            com.google.cloud.clouddms.v1.EntityDdlOrBuilder>
        entityDdlBuilder_;

    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public java.util.List<com.google.cloud.clouddms.v1.EntityDdl> getEntityDdlList() {
      if (entityDdlBuilder_ == null) {
        return java.util.Collections.unmodifiableList(entityDdl_);
      } else {
        return entityDdlBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public int getEntityDdlCount() {
      if (entityDdlBuilder_ == null) {
        return entityDdl_.size();
      } else {
        return entityDdlBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public com.google.cloud.clouddms.v1.EntityDdl getEntityDdl(int index) {
      if (entityDdlBuilder_ == null) {
        return entityDdl_.get(index);
      } else {
        return entityDdlBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public Builder setEntityDdl(int index, com.google.cloud.clouddms.v1.EntityDdl value) {
      if (entityDdlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntityDdlIsMutable();
        entityDdl_.set(index, value);
        onChanged();
      } else {
        entityDdlBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public Builder setEntityDdl(
        int index, com.google.cloud.clouddms.v1.EntityDdl.Builder builderForValue) {
      if (entityDdlBuilder_ == null) {
        ensureEntityDdlIsMutable();
        entityDdl_.set(index, builderForValue.build());
        onChanged();
      } else {
        entityDdlBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public Builder addEntityDdl(com.google.cloud.clouddms.v1.EntityDdl value) {
      if (entityDdlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntityDdlIsMutable();
        entityDdl_.add(value);
        onChanged();
      } else {
        entityDdlBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public Builder addEntityDdl(int index, com.google.cloud.clouddms.v1.EntityDdl value) {
      if (entityDdlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntityDdlIsMutable();
        entityDdl_.add(index, value);
        onChanged();
      } else {
        entityDdlBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public Builder addEntityDdl(com.google.cloud.clouddms.v1.EntityDdl.Builder builderForValue) {
      if (entityDdlBuilder_ == null) {
        ensureEntityDdlIsMutable();
        entityDdl_.add(builderForValue.build());
        onChanged();
      } else {
        entityDdlBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public Builder addEntityDdl(
        int index, com.google.cloud.clouddms.v1.EntityDdl.Builder builderForValue) {
      if (entityDdlBuilder_ == null) {
        ensureEntityDdlIsMutable();
        entityDdl_.add(index, builderForValue.build());
        onChanged();
      } else {
        entityDdlBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public Builder addAllEntityDdl(
        java.lang.Iterable<? extends com.google.cloud.clouddms.v1.EntityDdl> values) {
      if (entityDdlBuilder_ == null) {
        ensureEntityDdlIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, entityDdl_);
        onChanged();
      } else {
        entityDdlBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public Builder clearEntityDdl() {
      if (entityDdlBuilder_ == null) {
        entityDdl_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        entityDdlBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public Builder removeEntityDdl(int index) {
      if (entityDdlBuilder_ == null) {
        ensureEntityDdlIsMutable();
        entityDdl_.remove(index);
        onChanged();
      } else {
        entityDdlBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public com.google.cloud.clouddms.v1.EntityDdl.Builder getEntityDdlBuilder(int index) {
      return getEntityDdlFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public com.google.cloud.clouddms.v1.EntityDdlOrBuilder getEntityDdlOrBuilder(int index) {
      if (entityDdlBuilder_ == null) {
        return entityDdl_.get(index);
      } else {
        return entityDdlBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public java.util.List<? extends com.google.cloud.clouddms.v1.EntityDdlOrBuilder>
        getEntityDdlOrBuilderList() {
      if (entityDdlBuilder_ != null) {
        return entityDdlBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(entityDdl_);
      }
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public com.google.cloud.clouddms.v1.EntityDdl.Builder addEntityDdlBuilder() {
      return getEntityDdlFieldBuilder()
          .addBuilder(com.google.cloud.clouddms.v1.EntityDdl.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public com.google.cloud.clouddms.v1.EntityDdl.Builder addEntityDdlBuilder(int index) {
      return getEntityDdlFieldBuilder()
          .addBuilder(index, com.google.cloud.clouddms.v1.EntityDdl.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    public java.util.List<com.google.cloud.clouddms.v1.EntityDdl.Builder>
        getEntityDdlBuilderList() {
      return getEntityDdlFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.clouddms.v1.EntityDdl,
            com.google.cloud.clouddms.v1.EntityDdl.Builder,
            com.google.cloud.clouddms.v1.EntityDdlOrBuilder>
        getEntityDdlFieldBuilder() {
      if (entityDdlBuilder_ == null) {
        entityDdlBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.clouddms.v1.EntityDdl,
                com.google.cloud.clouddms.v1.EntityDdl.Builder,
                com.google.cloud.clouddms.v1.EntityDdlOrBuilder>(
                entityDdl_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        entityDdl_ = null;
      }
      return entityDdlBuilder_;
    }

    private java.util.List<com.google.cloud.clouddms.v1.EntityIssue> issues_ =
        java.util.Collections.emptyList();

    private void ensureIssuesIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        issues_ = new java.util.ArrayList<com.google.cloud.clouddms.v1.EntityIssue>(issues_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.clouddms.v1.EntityIssue,
            com.google.cloud.clouddms.v1.EntityIssue.Builder,
            com.google.cloud.clouddms.v1.EntityIssueOrBuilder>
        issuesBuilder_;

    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public java.util.List<com.google.cloud.clouddms.v1.EntityIssue> getIssuesList() {
      if (issuesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(issues_);
      } else {
        return issuesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public int getIssuesCount() {
      if (issuesBuilder_ == null) {
        return issues_.size();
      } else {
        return issuesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public com.google.cloud.clouddms.v1.EntityIssue getIssues(int index) {
      if (issuesBuilder_ == null) {
        return issues_.get(index);
      } else {
        return issuesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public Builder setIssues(int index, com.google.cloud.clouddms.v1.EntityIssue value) {
      if (issuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIssuesIsMutable();
        issues_.set(index, value);
        onChanged();
      } else {
        issuesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public Builder setIssues(
        int index, com.google.cloud.clouddms.v1.EntityIssue.Builder builderForValue) {
      if (issuesBuilder_ == null) {
        ensureIssuesIsMutable();
        issues_.set(index, builderForValue.build());
        onChanged();
      } else {
        issuesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public Builder addIssues(com.google.cloud.clouddms.v1.EntityIssue value) {
      if (issuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIssuesIsMutable();
        issues_.add(value);
        onChanged();
      } else {
        issuesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public Builder addIssues(int index, com.google.cloud.clouddms.v1.EntityIssue value) {
      if (issuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIssuesIsMutable();
        issues_.add(index, value);
        onChanged();
      } else {
        issuesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public Builder addIssues(com.google.cloud.clouddms.v1.EntityIssue.Builder builderForValue) {
      if (issuesBuilder_ == null) {
        ensureIssuesIsMutable();
        issues_.add(builderForValue.build());
        onChanged();
      } else {
        issuesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public Builder addIssues(
        int index, com.google.cloud.clouddms.v1.EntityIssue.Builder builderForValue) {
      if (issuesBuilder_ == null) {
        ensureIssuesIsMutable();
        issues_.add(index, builderForValue.build());
        onChanged();
      } else {
        issuesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public Builder addAllIssues(
        java.lang.Iterable<? extends com.google.cloud.clouddms.v1.EntityIssue> values) {
      if (issuesBuilder_ == null) {
        ensureIssuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, issues_);
        onChanged();
      } else {
        issuesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public Builder clearIssues() {
      if (issuesBuilder_ == null) {
        issues_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        issuesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public Builder removeIssues(int index) {
      if (issuesBuilder_ == null) {
        ensureIssuesIsMutable();
        issues_.remove(index);
        onChanged();
      } else {
        issuesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public com.google.cloud.clouddms.v1.EntityIssue.Builder getIssuesBuilder(int index) {
      return getIssuesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public com.google.cloud.clouddms.v1.EntityIssueOrBuilder getIssuesOrBuilder(int index) {
      if (issuesBuilder_ == null) {
        return issues_.get(index);
      } else {
        return issuesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public java.util.List<? extends com.google.cloud.clouddms.v1.EntityIssueOrBuilder>
        getIssuesOrBuilderList() {
      if (issuesBuilder_ != null) {
        return issuesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(issues_);
      }
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public com.google.cloud.clouddms.v1.EntityIssue.Builder addIssuesBuilder() {
      return getIssuesFieldBuilder()
          .addBuilder(com.google.cloud.clouddms.v1.EntityIssue.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public com.google.cloud.clouddms.v1.EntityIssue.Builder addIssuesBuilder(int index) {
      return getIssuesFieldBuilder()
          .addBuilder(index, com.google.cloud.clouddms.v1.EntityIssue.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Details about the various issues found for the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    public java.util.List<com.google.cloud.clouddms.v1.EntityIssue.Builder> getIssuesBuilderList() {
      return getIssuesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.clouddms.v1.EntityIssue,
            com.google.cloud.clouddms.v1.EntityIssue.Builder,
            com.google.cloud.clouddms.v1.EntityIssueOrBuilder>
        getIssuesFieldBuilder() {
      if (issuesBuilder_ == null) {
        issuesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.clouddms.v1.EntityIssue,
                com.google.cloud.clouddms.v1.EntityIssue.Builder,
                com.google.cloud.clouddms.v1.EntityIssueOrBuilder>(
                issues_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        issues_ = null;
      }
      return issuesBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.DatabaseInstanceEntity,
            com.google.cloud.clouddms.v1.DatabaseInstanceEntity.Builder,
            com.google.cloud.clouddms.v1.DatabaseInstanceEntityOrBuilder>
        databaseBuilder_;
    /**
     *
     *
     * <pre>
     * Database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
     *
     * @return Whether the database field is set.
     */
    @java.lang.Override
    public boolean hasDatabase() {
      return entityBodyCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * Database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
     *
     * @return The database.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.DatabaseInstanceEntity getDatabase() {
      if (databaseBuilder_ == null) {
        if (entityBodyCase_ == 101) {
          return (com.google.cloud.clouddms.v1.DatabaseInstanceEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.DatabaseInstanceEntity.getDefaultInstance();
      } else {
        if (entityBodyCase_ == 101) {
          return databaseBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.DatabaseInstanceEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
     */
    public Builder setDatabase(com.google.cloud.clouddms.v1.DatabaseInstanceEntity value) {
      if (databaseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityBody_ = value;
        onChanged();
      } else {
        databaseBuilder_.setMessage(value);
      }
      entityBodyCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
     */
    public Builder setDatabase(
        com.google.cloud.clouddms.v1.DatabaseInstanceEntity.Builder builderForValue) {
      if (databaseBuilder_ == null) {
        entityBody_ = builderForValue.build();
        onChanged();
      } else {
        databaseBuilder_.setMessage(builderForValue.build());
      }
      entityBodyCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
     */
    public Builder mergeDatabase(com.google.cloud.clouddms.v1.DatabaseInstanceEntity value) {
      if (databaseBuilder_ == null) {
        if (entityBodyCase_ == 101
            && entityBody_
                != com.google.cloud.clouddms.v1.DatabaseInstanceEntity.getDefaultInstance()) {
          entityBody_ =
              com.google.cloud.clouddms.v1.DatabaseInstanceEntity.newBuilder(
                      (com.google.cloud.clouddms.v1.DatabaseInstanceEntity) entityBody_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          entityBody_ = value;
        }
        onChanged();
      } else {
        if (entityBodyCase_ == 101) {
          databaseBuilder_.mergeFrom(value);
        } else {
          databaseBuilder_.setMessage(value);
        }
      }
      entityBodyCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
     */
    public Builder clearDatabase() {
      if (databaseBuilder_ == null) {
        if (entityBodyCase_ == 101) {
          entityBodyCase_ = 0;
          entityBody_ = null;
          onChanged();
        }
      } else {
        if (entityBodyCase_ == 101) {
          entityBodyCase_ = 0;
          entityBody_ = null;
        }
        databaseBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
     */
    public com.google.cloud.clouddms.v1.DatabaseInstanceEntity.Builder getDatabaseBuilder() {
      return getDatabaseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.DatabaseInstanceEntityOrBuilder getDatabaseOrBuilder() {
      if ((entityBodyCase_ == 101) && (databaseBuilder_ != null)) {
        return databaseBuilder_.getMessageOrBuilder();
      } else {
        if (entityBodyCase_ == 101) {
          return (com.google.cloud.clouddms.v1.DatabaseInstanceEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.DatabaseInstanceEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.DatabaseInstanceEntity,
            com.google.cloud.clouddms.v1.DatabaseInstanceEntity.Builder,
            com.google.cloud.clouddms.v1.DatabaseInstanceEntityOrBuilder>
        getDatabaseFieldBuilder() {
      if (databaseBuilder_ == null) {
        if (!(entityBodyCase_ == 101)) {
          entityBody_ = com.google.cloud.clouddms.v1.DatabaseInstanceEntity.getDefaultInstance();
        }
        databaseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.DatabaseInstanceEntity,
                com.google.cloud.clouddms.v1.DatabaseInstanceEntity.Builder,
                com.google.cloud.clouddms.v1.DatabaseInstanceEntityOrBuilder>(
                (com.google.cloud.clouddms.v1.DatabaseInstanceEntity) entityBody_,
                getParentForChildren(),
                isClean());
        entityBody_ = null;
      }
      entityBodyCase_ = 101;
      onChanged();
      return databaseBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SchemaEntity,
            com.google.cloud.clouddms.v1.SchemaEntity.Builder,
            com.google.cloud.clouddms.v1.SchemaEntityOrBuilder>
        schemaBuilder_;
    /**
     *
     *
     * <pre>
     * Schema.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
     *
     * @return Whether the schema field is set.
     */
    @java.lang.Override
    public boolean hasSchema() {
      return entityBodyCase_ == 102;
    }
    /**
     *
     *
     * <pre>
     * Schema.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
     *
     * @return The schema.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SchemaEntity getSchema() {
      if (schemaBuilder_ == null) {
        if (entityBodyCase_ == 102) {
          return (com.google.cloud.clouddms.v1.SchemaEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.SchemaEntity.getDefaultInstance();
      } else {
        if (entityBodyCase_ == 102) {
          return schemaBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.SchemaEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Schema.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
     */
    public Builder setSchema(com.google.cloud.clouddms.v1.SchemaEntity value) {
      if (schemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityBody_ = value;
        onChanged();
      } else {
        schemaBuilder_.setMessage(value);
      }
      entityBodyCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Schema.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
     */
    public Builder setSchema(com.google.cloud.clouddms.v1.SchemaEntity.Builder builderForValue) {
      if (schemaBuilder_ == null) {
        entityBody_ = builderForValue.build();
        onChanged();
      } else {
        schemaBuilder_.setMessage(builderForValue.build());
      }
      entityBodyCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Schema.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
     */
    public Builder mergeSchema(com.google.cloud.clouddms.v1.SchemaEntity value) {
      if (schemaBuilder_ == null) {
        if (entityBodyCase_ == 102
            && entityBody_ != com.google.cloud.clouddms.v1.SchemaEntity.getDefaultInstance()) {
          entityBody_ =
              com.google.cloud.clouddms.v1.SchemaEntity.newBuilder(
                      (com.google.cloud.clouddms.v1.SchemaEntity) entityBody_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          entityBody_ = value;
        }
        onChanged();
      } else {
        if (entityBodyCase_ == 102) {
          schemaBuilder_.mergeFrom(value);
        } else {
          schemaBuilder_.setMessage(value);
        }
      }
      entityBodyCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Schema.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
     */
    public Builder clearSchema() {
      if (schemaBuilder_ == null) {
        if (entityBodyCase_ == 102) {
          entityBodyCase_ = 0;
          entityBody_ = null;
          onChanged();
        }
      } else {
        if (entityBodyCase_ == 102) {
          entityBodyCase_ = 0;
          entityBody_ = null;
        }
        schemaBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Schema.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
     */
    public com.google.cloud.clouddms.v1.SchemaEntity.Builder getSchemaBuilder() {
      return getSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Schema.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SchemaEntityOrBuilder getSchemaOrBuilder() {
      if ((entityBodyCase_ == 102) && (schemaBuilder_ != null)) {
        return schemaBuilder_.getMessageOrBuilder();
      } else {
        if (entityBodyCase_ == 102) {
          return (com.google.cloud.clouddms.v1.SchemaEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.SchemaEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Schema.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SchemaEntity,
            com.google.cloud.clouddms.v1.SchemaEntity.Builder,
            com.google.cloud.clouddms.v1.SchemaEntityOrBuilder>
        getSchemaFieldBuilder() {
      if (schemaBuilder_ == null) {
        if (!(entityBodyCase_ == 102)) {
          entityBody_ = com.google.cloud.clouddms.v1.SchemaEntity.getDefaultInstance();
        }
        schemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.SchemaEntity,
                com.google.cloud.clouddms.v1.SchemaEntity.Builder,
                com.google.cloud.clouddms.v1.SchemaEntityOrBuilder>(
                (com.google.cloud.clouddms.v1.SchemaEntity) entityBody_,
                getParentForChildren(),
                isClean());
        entityBody_ = null;
      }
      entityBodyCase_ = 102;
      onChanged();
      return schemaBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.TableEntity,
            com.google.cloud.clouddms.v1.TableEntity.Builder,
            com.google.cloud.clouddms.v1.TableEntityOrBuilder>
        tableBuilder_;
    /**
     *
     *
     * <pre>
     * Table.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
     *
     * @return Whether the table field is set.
     */
    @java.lang.Override
    public boolean hasTable() {
      return entityBodyCase_ == 103;
    }
    /**
     *
     *
     * <pre>
     * Table.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
     *
     * @return The table.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.TableEntity getTable() {
      if (tableBuilder_ == null) {
        if (entityBodyCase_ == 103) {
          return (com.google.cloud.clouddms.v1.TableEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.TableEntity.getDefaultInstance();
      } else {
        if (entityBodyCase_ == 103) {
          return tableBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.TableEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Table.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
     */
    public Builder setTable(com.google.cloud.clouddms.v1.TableEntity value) {
      if (tableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityBody_ = value;
        onChanged();
      } else {
        tableBuilder_.setMessage(value);
      }
      entityBodyCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
     */
    public Builder setTable(com.google.cloud.clouddms.v1.TableEntity.Builder builderForValue) {
      if (tableBuilder_ == null) {
        entityBody_ = builderForValue.build();
        onChanged();
      } else {
        tableBuilder_.setMessage(builderForValue.build());
      }
      entityBodyCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
     */
    public Builder mergeTable(com.google.cloud.clouddms.v1.TableEntity value) {
      if (tableBuilder_ == null) {
        if (entityBodyCase_ == 103
            && entityBody_ != com.google.cloud.clouddms.v1.TableEntity.getDefaultInstance()) {
          entityBody_ =
              com.google.cloud.clouddms.v1.TableEntity.newBuilder(
                      (com.google.cloud.clouddms.v1.TableEntity) entityBody_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          entityBody_ = value;
        }
        onChanged();
      } else {
        if (entityBodyCase_ == 103) {
          tableBuilder_.mergeFrom(value);
        } else {
          tableBuilder_.setMessage(value);
        }
      }
      entityBodyCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
     */
    public Builder clearTable() {
      if (tableBuilder_ == null) {
        if (entityBodyCase_ == 103) {
          entityBodyCase_ = 0;
          entityBody_ = null;
          onChanged();
        }
      } else {
        if (entityBodyCase_ == 103) {
          entityBodyCase_ = 0;
          entityBody_ = null;
        }
        tableBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
     */
    public com.google.cloud.clouddms.v1.TableEntity.Builder getTableBuilder() {
      return getTableFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Table.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.TableEntityOrBuilder getTableOrBuilder() {
      if ((entityBodyCase_ == 103) && (tableBuilder_ != null)) {
        return tableBuilder_.getMessageOrBuilder();
      } else {
        if (entityBodyCase_ == 103) {
          return (com.google.cloud.clouddms.v1.TableEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.TableEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Table.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.TableEntity,
            com.google.cloud.clouddms.v1.TableEntity.Builder,
            com.google.cloud.clouddms.v1.TableEntityOrBuilder>
        getTableFieldBuilder() {
      if (tableBuilder_ == null) {
        if (!(entityBodyCase_ == 103)) {
          entityBody_ = com.google.cloud.clouddms.v1.TableEntity.getDefaultInstance();
        }
        tableBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.TableEntity,
                com.google.cloud.clouddms.v1.TableEntity.Builder,
                com.google.cloud.clouddms.v1.TableEntityOrBuilder>(
                (com.google.cloud.clouddms.v1.TableEntity) entityBody_,
                getParentForChildren(),
                isClean());
        entityBody_ = null;
      }
      entityBodyCase_ = 103;
      onChanged();
      return tableBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ViewEntity,
            com.google.cloud.clouddms.v1.ViewEntity.Builder,
            com.google.cloud.clouddms.v1.ViewEntityOrBuilder>
        viewBuilder_;
    /**
     *
     *
     * <pre>
     * View.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
     *
     * @return Whether the view field is set.
     */
    @java.lang.Override
    public boolean hasView() {
      return entityBodyCase_ == 104;
    }
    /**
     *
     *
     * <pre>
     * View.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
     *
     * @return The view.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ViewEntity getView() {
      if (viewBuilder_ == null) {
        if (entityBodyCase_ == 104) {
          return (com.google.cloud.clouddms.v1.ViewEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.ViewEntity.getDefaultInstance();
      } else {
        if (entityBodyCase_ == 104) {
          return viewBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.ViewEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * View.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
     */
    public Builder setView(com.google.cloud.clouddms.v1.ViewEntity value) {
      if (viewBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityBody_ = value;
        onChanged();
      } else {
        viewBuilder_.setMessage(value);
      }
      entityBodyCase_ = 104;
      return this;
    }
    /**
     *
     *
     * <pre>
     * View.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
     */
    public Builder setView(com.google.cloud.clouddms.v1.ViewEntity.Builder builderForValue) {
      if (viewBuilder_ == null) {
        entityBody_ = builderForValue.build();
        onChanged();
      } else {
        viewBuilder_.setMessage(builderForValue.build());
      }
      entityBodyCase_ = 104;
      return this;
    }
    /**
     *
     *
     * <pre>
     * View.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
     */
    public Builder mergeView(com.google.cloud.clouddms.v1.ViewEntity value) {
      if (viewBuilder_ == null) {
        if (entityBodyCase_ == 104
            && entityBody_ != com.google.cloud.clouddms.v1.ViewEntity.getDefaultInstance()) {
          entityBody_ =
              com.google.cloud.clouddms.v1.ViewEntity.newBuilder(
                      (com.google.cloud.clouddms.v1.ViewEntity) entityBody_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          entityBody_ = value;
        }
        onChanged();
      } else {
        if (entityBodyCase_ == 104) {
          viewBuilder_.mergeFrom(value);
        } else {
          viewBuilder_.setMessage(value);
        }
      }
      entityBodyCase_ = 104;
      return this;
    }
    /**
     *
     *
     * <pre>
     * View.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
     */
    public Builder clearView() {
      if (viewBuilder_ == null) {
        if (entityBodyCase_ == 104) {
          entityBodyCase_ = 0;
          entityBody_ = null;
          onChanged();
        }
      } else {
        if (entityBodyCase_ == 104) {
          entityBodyCase_ = 0;
          entityBody_ = null;
        }
        viewBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * View.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
     */
    public com.google.cloud.clouddms.v1.ViewEntity.Builder getViewBuilder() {
      return getViewFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * View.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ViewEntityOrBuilder getViewOrBuilder() {
      if ((entityBodyCase_ == 104) && (viewBuilder_ != null)) {
        return viewBuilder_.getMessageOrBuilder();
      } else {
        if (entityBodyCase_ == 104) {
          return (com.google.cloud.clouddms.v1.ViewEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.ViewEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * View.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ViewEntity,
            com.google.cloud.clouddms.v1.ViewEntity.Builder,
            com.google.cloud.clouddms.v1.ViewEntityOrBuilder>
        getViewFieldBuilder() {
      if (viewBuilder_ == null) {
        if (!(entityBodyCase_ == 104)) {
          entityBody_ = com.google.cloud.clouddms.v1.ViewEntity.getDefaultInstance();
        }
        viewBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.ViewEntity,
                com.google.cloud.clouddms.v1.ViewEntity.Builder,
                com.google.cloud.clouddms.v1.ViewEntityOrBuilder>(
                (com.google.cloud.clouddms.v1.ViewEntity) entityBody_,
                getParentForChildren(),
                isClean());
        entityBody_ = null;
      }
      entityBodyCase_ = 104;
      onChanged();
      return viewBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SequenceEntity,
            com.google.cloud.clouddms.v1.SequenceEntity.Builder,
            com.google.cloud.clouddms.v1.SequenceEntityOrBuilder>
        sequenceBuilder_;
    /**
     *
     *
     * <pre>
     * Sequence.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
     *
     * @return Whether the sequence field is set.
     */
    @java.lang.Override
    public boolean hasSequence() {
      return entityBodyCase_ == 105;
    }
    /**
     *
     *
     * <pre>
     * Sequence.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
     *
     * @return The sequence.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SequenceEntity getSequence() {
      if (sequenceBuilder_ == null) {
        if (entityBodyCase_ == 105) {
          return (com.google.cloud.clouddms.v1.SequenceEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.SequenceEntity.getDefaultInstance();
      } else {
        if (entityBodyCase_ == 105) {
          return sequenceBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.SequenceEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Sequence.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
     */
    public Builder setSequence(com.google.cloud.clouddms.v1.SequenceEntity value) {
      if (sequenceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityBody_ = value;
        onChanged();
      } else {
        sequenceBuilder_.setMessage(value);
      }
      entityBodyCase_ = 105;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequence.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
     */
    public Builder setSequence(
        com.google.cloud.clouddms.v1.SequenceEntity.Builder builderForValue) {
      if (sequenceBuilder_ == null) {
        entityBody_ = builderForValue.build();
        onChanged();
      } else {
        sequenceBuilder_.setMessage(builderForValue.build());
      }
      entityBodyCase_ = 105;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequence.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
     */
    public Builder mergeSequence(com.google.cloud.clouddms.v1.SequenceEntity value) {
      if (sequenceBuilder_ == null) {
        if (entityBodyCase_ == 105
            && entityBody_ != com.google.cloud.clouddms.v1.SequenceEntity.getDefaultInstance()) {
          entityBody_ =
              com.google.cloud.clouddms.v1.SequenceEntity.newBuilder(
                      (com.google.cloud.clouddms.v1.SequenceEntity) entityBody_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          entityBody_ = value;
        }
        onChanged();
      } else {
        if (entityBodyCase_ == 105) {
          sequenceBuilder_.mergeFrom(value);
        } else {
          sequenceBuilder_.setMessage(value);
        }
      }
      entityBodyCase_ = 105;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequence.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
     */
    public Builder clearSequence() {
      if (sequenceBuilder_ == null) {
        if (entityBodyCase_ == 105) {
          entityBodyCase_ = 0;
          entityBody_ = null;
          onChanged();
        }
      } else {
        if (entityBodyCase_ == 105) {
          entityBodyCase_ = 0;
          entityBody_ = null;
        }
        sequenceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequence.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
     */
    public com.google.cloud.clouddms.v1.SequenceEntity.Builder getSequenceBuilder() {
      return getSequenceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Sequence.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SequenceEntityOrBuilder getSequenceOrBuilder() {
      if ((entityBodyCase_ == 105) && (sequenceBuilder_ != null)) {
        return sequenceBuilder_.getMessageOrBuilder();
      } else {
        if (entityBodyCase_ == 105) {
          return (com.google.cloud.clouddms.v1.SequenceEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.SequenceEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Sequence.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SequenceEntity,
            com.google.cloud.clouddms.v1.SequenceEntity.Builder,
            com.google.cloud.clouddms.v1.SequenceEntityOrBuilder>
        getSequenceFieldBuilder() {
      if (sequenceBuilder_ == null) {
        if (!(entityBodyCase_ == 105)) {
          entityBody_ = com.google.cloud.clouddms.v1.SequenceEntity.getDefaultInstance();
        }
        sequenceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.SequenceEntity,
                com.google.cloud.clouddms.v1.SequenceEntity.Builder,
                com.google.cloud.clouddms.v1.SequenceEntityOrBuilder>(
                (com.google.cloud.clouddms.v1.SequenceEntity) entityBody_,
                getParentForChildren(),
                isClean());
        entityBody_ = null;
      }
      entityBodyCase_ = 105;
      onChanged();
      return sequenceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.StoredProcedureEntity,
            com.google.cloud.clouddms.v1.StoredProcedureEntity.Builder,
            com.google.cloud.clouddms.v1.StoredProcedureEntityOrBuilder>
        storedProcedureBuilder_;
    /**
     *
     *
     * <pre>
     * Stored procedure.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
     *
     * @return Whether the storedProcedure field is set.
     */
    @java.lang.Override
    public boolean hasStoredProcedure() {
      return entityBodyCase_ == 106;
    }
    /**
     *
     *
     * <pre>
     * Stored procedure.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
     *
     * @return The storedProcedure.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.StoredProcedureEntity getStoredProcedure() {
      if (storedProcedureBuilder_ == null) {
        if (entityBodyCase_ == 106) {
          return (com.google.cloud.clouddms.v1.StoredProcedureEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.StoredProcedureEntity.getDefaultInstance();
      } else {
        if (entityBodyCase_ == 106) {
          return storedProcedureBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.StoredProcedureEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Stored procedure.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
     */
    public Builder setStoredProcedure(com.google.cloud.clouddms.v1.StoredProcedureEntity value) {
      if (storedProcedureBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityBody_ = value;
        onChanged();
      } else {
        storedProcedureBuilder_.setMessage(value);
      }
      entityBodyCase_ = 106;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stored procedure.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
     */
    public Builder setStoredProcedure(
        com.google.cloud.clouddms.v1.StoredProcedureEntity.Builder builderForValue) {
      if (storedProcedureBuilder_ == null) {
        entityBody_ = builderForValue.build();
        onChanged();
      } else {
        storedProcedureBuilder_.setMessage(builderForValue.build());
      }
      entityBodyCase_ = 106;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stored procedure.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
     */
    public Builder mergeStoredProcedure(com.google.cloud.clouddms.v1.StoredProcedureEntity value) {
      if (storedProcedureBuilder_ == null) {
        if (entityBodyCase_ == 106
            && entityBody_
                != com.google.cloud.clouddms.v1.StoredProcedureEntity.getDefaultInstance()) {
          entityBody_ =
              com.google.cloud.clouddms.v1.StoredProcedureEntity.newBuilder(
                      (com.google.cloud.clouddms.v1.StoredProcedureEntity) entityBody_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          entityBody_ = value;
        }
        onChanged();
      } else {
        if (entityBodyCase_ == 106) {
          storedProcedureBuilder_.mergeFrom(value);
        } else {
          storedProcedureBuilder_.setMessage(value);
        }
      }
      entityBodyCase_ = 106;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stored procedure.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
     */
    public Builder clearStoredProcedure() {
      if (storedProcedureBuilder_ == null) {
        if (entityBodyCase_ == 106) {
          entityBodyCase_ = 0;
          entityBody_ = null;
          onChanged();
        }
      } else {
        if (entityBodyCase_ == 106) {
          entityBodyCase_ = 0;
          entityBody_ = null;
        }
        storedProcedureBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stored procedure.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
     */
    public com.google.cloud.clouddms.v1.StoredProcedureEntity.Builder getStoredProcedureBuilder() {
      return getStoredProcedureFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Stored procedure.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.StoredProcedureEntityOrBuilder
        getStoredProcedureOrBuilder() {
      if ((entityBodyCase_ == 106) && (storedProcedureBuilder_ != null)) {
        return storedProcedureBuilder_.getMessageOrBuilder();
      } else {
        if (entityBodyCase_ == 106) {
          return (com.google.cloud.clouddms.v1.StoredProcedureEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.StoredProcedureEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Stored procedure.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.StoredProcedureEntity,
            com.google.cloud.clouddms.v1.StoredProcedureEntity.Builder,
            com.google.cloud.clouddms.v1.StoredProcedureEntityOrBuilder>
        getStoredProcedureFieldBuilder() {
      if (storedProcedureBuilder_ == null) {
        if (!(entityBodyCase_ == 106)) {
          entityBody_ = com.google.cloud.clouddms.v1.StoredProcedureEntity.getDefaultInstance();
        }
        storedProcedureBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.StoredProcedureEntity,
                com.google.cloud.clouddms.v1.StoredProcedureEntity.Builder,
                com.google.cloud.clouddms.v1.StoredProcedureEntityOrBuilder>(
                (com.google.cloud.clouddms.v1.StoredProcedureEntity) entityBody_,
                getParentForChildren(),
                isClean());
        entityBody_ = null;
      }
      entityBodyCase_ = 106;
      onChanged();
      return storedProcedureBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.FunctionEntity,
            com.google.cloud.clouddms.v1.FunctionEntity.Builder,
            com.google.cloud.clouddms.v1.FunctionEntityOrBuilder>
        databaseFunctionBuilder_;
    /**
     *
     *
     * <pre>
     * Function.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
     *
     * @return Whether the databaseFunction field is set.
     */
    @java.lang.Override
    public boolean hasDatabaseFunction() {
      return entityBodyCase_ == 107;
    }
    /**
     *
     *
     * <pre>
     * Function.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
     *
     * @return The databaseFunction.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.FunctionEntity getDatabaseFunction() {
      if (databaseFunctionBuilder_ == null) {
        if (entityBodyCase_ == 107) {
          return (com.google.cloud.clouddms.v1.FunctionEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.FunctionEntity.getDefaultInstance();
      } else {
        if (entityBodyCase_ == 107) {
          return databaseFunctionBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.FunctionEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Function.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
     */
    public Builder setDatabaseFunction(com.google.cloud.clouddms.v1.FunctionEntity value) {
      if (databaseFunctionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityBody_ = value;
        onChanged();
      } else {
        databaseFunctionBuilder_.setMessage(value);
      }
      entityBodyCase_ = 107;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Function.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
     */
    public Builder setDatabaseFunction(
        com.google.cloud.clouddms.v1.FunctionEntity.Builder builderForValue) {
      if (databaseFunctionBuilder_ == null) {
        entityBody_ = builderForValue.build();
        onChanged();
      } else {
        databaseFunctionBuilder_.setMessage(builderForValue.build());
      }
      entityBodyCase_ = 107;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Function.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
     */
    public Builder mergeDatabaseFunction(com.google.cloud.clouddms.v1.FunctionEntity value) {
      if (databaseFunctionBuilder_ == null) {
        if (entityBodyCase_ == 107
            && entityBody_ != com.google.cloud.clouddms.v1.FunctionEntity.getDefaultInstance()) {
          entityBody_ =
              com.google.cloud.clouddms.v1.FunctionEntity.newBuilder(
                      (com.google.cloud.clouddms.v1.FunctionEntity) entityBody_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          entityBody_ = value;
        }
        onChanged();
      } else {
        if (entityBodyCase_ == 107) {
          databaseFunctionBuilder_.mergeFrom(value);
        } else {
          databaseFunctionBuilder_.setMessage(value);
        }
      }
      entityBodyCase_ = 107;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Function.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
     */
    public Builder clearDatabaseFunction() {
      if (databaseFunctionBuilder_ == null) {
        if (entityBodyCase_ == 107) {
          entityBodyCase_ = 0;
          entityBody_ = null;
          onChanged();
        }
      } else {
        if (entityBodyCase_ == 107) {
          entityBodyCase_ = 0;
          entityBody_ = null;
        }
        databaseFunctionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Function.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
     */
    public com.google.cloud.clouddms.v1.FunctionEntity.Builder getDatabaseFunctionBuilder() {
      return getDatabaseFunctionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Function.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.FunctionEntityOrBuilder getDatabaseFunctionOrBuilder() {
      if ((entityBodyCase_ == 107) && (databaseFunctionBuilder_ != null)) {
        return databaseFunctionBuilder_.getMessageOrBuilder();
      } else {
        if (entityBodyCase_ == 107) {
          return (com.google.cloud.clouddms.v1.FunctionEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.FunctionEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Function.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.FunctionEntity,
            com.google.cloud.clouddms.v1.FunctionEntity.Builder,
            com.google.cloud.clouddms.v1.FunctionEntityOrBuilder>
        getDatabaseFunctionFieldBuilder() {
      if (databaseFunctionBuilder_ == null) {
        if (!(entityBodyCase_ == 107)) {
          entityBody_ = com.google.cloud.clouddms.v1.FunctionEntity.getDefaultInstance();
        }
        databaseFunctionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.FunctionEntity,
                com.google.cloud.clouddms.v1.FunctionEntity.Builder,
                com.google.cloud.clouddms.v1.FunctionEntityOrBuilder>(
                (com.google.cloud.clouddms.v1.FunctionEntity) entityBody_,
                getParentForChildren(),
                isClean());
        entityBody_ = null;
      }
      entityBodyCase_ = 107;
      onChanged();
      return databaseFunctionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SynonymEntity,
            com.google.cloud.clouddms.v1.SynonymEntity.Builder,
            com.google.cloud.clouddms.v1.SynonymEntityOrBuilder>
        synonymBuilder_;
    /**
     *
     *
     * <pre>
     * Synonym.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
     *
     * @return Whether the synonym field is set.
     */
    @java.lang.Override
    public boolean hasSynonym() {
      return entityBodyCase_ == 108;
    }
    /**
     *
     *
     * <pre>
     * Synonym.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
     *
     * @return The synonym.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SynonymEntity getSynonym() {
      if (synonymBuilder_ == null) {
        if (entityBodyCase_ == 108) {
          return (com.google.cloud.clouddms.v1.SynonymEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.SynonymEntity.getDefaultInstance();
      } else {
        if (entityBodyCase_ == 108) {
          return synonymBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.SynonymEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Synonym.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
     */
    public Builder setSynonym(com.google.cloud.clouddms.v1.SynonymEntity value) {
      if (synonymBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityBody_ = value;
        onChanged();
      } else {
        synonymBuilder_.setMessage(value);
      }
      entityBodyCase_ = 108;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Synonym.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
     */
    public Builder setSynonym(com.google.cloud.clouddms.v1.SynonymEntity.Builder builderForValue) {
      if (synonymBuilder_ == null) {
        entityBody_ = builderForValue.build();
        onChanged();
      } else {
        synonymBuilder_.setMessage(builderForValue.build());
      }
      entityBodyCase_ = 108;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Synonym.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
     */
    public Builder mergeSynonym(com.google.cloud.clouddms.v1.SynonymEntity value) {
      if (synonymBuilder_ == null) {
        if (entityBodyCase_ == 108
            && entityBody_ != com.google.cloud.clouddms.v1.SynonymEntity.getDefaultInstance()) {
          entityBody_ =
              com.google.cloud.clouddms.v1.SynonymEntity.newBuilder(
                      (com.google.cloud.clouddms.v1.SynonymEntity) entityBody_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          entityBody_ = value;
        }
        onChanged();
      } else {
        if (entityBodyCase_ == 108) {
          synonymBuilder_.mergeFrom(value);
        } else {
          synonymBuilder_.setMessage(value);
        }
      }
      entityBodyCase_ = 108;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Synonym.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
     */
    public Builder clearSynonym() {
      if (synonymBuilder_ == null) {
        if (entityBodyCase_ == 108) {
          entityBodyCase_ = 0;
          entityBody_ = null;
          onChanged();
        }
      } else {
        if (entityBodyCase_ == 108) {
          entityBodyCase_ = 0;
          entityBody_ = null;
        }
        synonymBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Synonym.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
     */
    public com.google.cloud.clouddms.v1.SynonymEntity.Builder getSynonymBuilder() {
      return getSynonymFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Synonym.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SynonymEntityOrBuilder getSynonymOrBuilder() {
      if ((entityBodyCase_ == 108) && (synonymBuilder_ != null)) {
        return synonymBuilder_.getMessageOrBuilder();
      } else {
        if (entityBodyCase_ == 108) {
          return (com.google.cloud.clouddms.v1.SynonymEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.SynonymEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Synonym.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SynonymEntity,
            com.google.cloud.clouddms.v1.SynonymEntity.Builder,
            com.google.cloud.clouddms.v1.SynonymEntityOrBuilder>
        getSynonymFieldBuilder() {
      if (synonymBuilder_ == null) {
        if (!(entityBodyCase_ == 108)) {
          entityBody_ = com.google.cloud.clouddms.v1.SynonymEntity.getDefaultInstance();
        }
        synonymBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.SynonymEntity,
                com.google.cloud.clouddms.v1.SynonymEntity.Builder,
                com.google.cloud.clouddms.v1.SynonymEntityOrBuilder>(
                (com.google.cloud.clouddms.v1.SynonymEntity) entityBody_,
                getParentForChildren(),
                isClean());
        entityBody_ = null;
      }
      entityBodyCase_ = 108;
      onChanged();
      return synonymBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.PackageEntity,
            com.google.cloud.clouddms.v1.PackageEntity.Builder,
            com.google.cloud.clouddms.v1.PackageEntityOrBuilder>
        databasePackageBuilder_;
    /**
     *
     *
     * <pre>
     * Package.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
     *
     * @return Whether the databasePackage field is set.
     */
    @java.lang.Override
    public boolean hasDatabasePackage() {
      return entityBodyCase_ == 109;
    }
    /**
     *
     *
     * <pre>
     * Package.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
     *
     * @return The databasePackage.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.PackageEntity getDatabasePackage() {
      if (databasePackageBuilder_ == null) {
        if (entityBodyCase_ == 109) {
          return (com.google.cloud.clouddms.v1.PackageEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.PackageEntity.getDefaultInstance();
      } else {
        if (entityBodyCase_ == 109) {
          return databasePackageBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.PackageEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Package.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
     */
    public Builder setDatabasePackage(com.google.cloud.clouddms.v1.PackageEntity value) {
      if (databasePackageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityBody_ = value;
        onChanged();
      } else {
        databasePackageBuilder_.setMessage(value);
      }
      entityBodyCase_ = 109;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Package.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
     */
    public Builder setDatabasePackage(
        com.google.cloud.clouddms.v1.PackageEntity.Builder builderForValue) {
      if (databasePackageBuilder_ == null) {
        entityBody_ = builderForValue.build();
        onChanged();
      } else {
        databasePackageBuilder_.setMessage(builderForValue.build());
      }
      entityBodyCase_ = 109;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Package.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
     */
    public Builder mergeDatabasePackage(com.google.cloud.clouddms.v1.PackageEntity value) {
      if (databasePackageBuilder_ == null) {
        if (entityBodyCase_ == 109
            && entityBody_ != com.google.cloud.clouddms.v1.PackageEntity.getDefaultInstance()) {
          entityBody_ =
              com.google.cloud.clouddms.v1.PackageEntity.newBuilder(
                      (com.google.cloud.clouddms.v1.PackageEntity) entityBody_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          entityBody_ = value;
        }
        onChanged();
      } else {
        if (entityBodyCase_ == 109) {
          databasePackageBuilder_.mergeFrom(value);
        } else {
          databasePackageBuilder_.setMessage(value);
        }
      }
      entityBodyCase_ = 109;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Package.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
     */
    public Builder clearDatabasePackage() {
      if (databasePackageBuilder_ == null) {
        if (entityBodyCase_ == 109) {
          entityBodyCase_ = 0;
          entityBody_ = null;
          onChanged();
        }
      } else {
        if (entityBodyCase_ == 109) {
          entityBodyCase_ = 0;
          entityBody_ = null;
        }
        databasePackageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Package.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
     */
    public com.google.cloud.clouddms.v1.PackageEntity.Builder getDatabasePackageBuilder() {
      return getDatabasePackageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Package.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.PackageEntityOrBuilder getDatabasePackageOrBuilder() {
      if ((entityBodyCase_ == 109) && (databasePackageBuilder_ != null)) {
        return databasePackageBuilder_.getMessageOrBuilder();
      } else {
        if (entityBodyCase_ == 109) {
          return (com.google.cloud.clouddms.v1.PackageEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.PackageEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Package.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.PackageEntity,
            com.google.cloud.clouddms.v1.PackageEntity.Builder,
            com.google.cloud.clouddms.v1.PackageEntityOrBuilder>
        getDatabasePackageFieldBuilder() {
      if (databasePackageBuilder_ == null) {
        if (!(entityBodyCase_ == 109)) {
          entityBody_ = com.google.cloud.clouddms.v1.PackageEntity.getDefaultInstance();
        }
        databasePackageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.PackageEntity,
                com.google.cloud.clouddms.v1.PackageEntity.Builder,
                com.google.cloud.clouddms.v1.PackageEntityOrBuilder>(
                (com.google.cloud.clouddms.v1.PackageEntity) entityBody_,
                getParentForChildren(),
                isClean());
        entityBody_ = null;
      }
      entityBodyCase_ = 109;
      onChanged();
      return databasePackageBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.UDTEntity,
            com.google.cloud.clouddms.v1.UDTEntity.Builder,
            com.google.cloud.clouddms.v1.UDTEntityOrBuilder>
        udtBuilder_;
    /**
     *
     *
     * <pre>
     * UDT.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
     *
     * @return Whether the udt field is set.
     */
    @java.lang.Override
    public boolean hasUdt() {
      return entityBodyCase_ == 110;
    }
    /**
     *
     *
     * <pre>
     * UDT.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
     *
     * @return The udt.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.UDTEntity getUdt() {
      if (udtBuilder_ == null) {
        if (entityBodyCase_ == 110) {
          return (com.google.cloud.clouddms.v1.UDTEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.UDTEntity.getDefaultInstance();
      } else {
        if (entityBodyCase_ == 110) {
          return udtBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.UDTEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * UDT.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
     */
    public Builder setUdt(com.google.cloud.clouddms.v1.UDTEntity value) {
      if (udtBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityBody_ = value;
        onChanged();
      } else {
        udtBuilder_.setMessage(value);
      }
      entityBodyCase_ = 110;
      return this;
    }
    /**
     *
     *
     * <pre>
     * UDT.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
     */
    public Builder setUdt(com.google.cloud.clouddms.v1.UDTEntity.Builder builderForValue) {
      if (udtBuilder_ == null) {
        entityBody_ = builderForValue.build();
        onChanged();
      } else {
        udtBuilder_.setMessage(builderForValue.build());
      }
      entityBodyCase_ = 110;
      return this;
    }
    /**
     *
     *
     * <pre>
     * UDT.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
     */
    public Builder mergeUdt(com.google.cloud.clouddms.v1.UDTEntity value) {
      if (udtBuilder_ == null) {
        if (entityBodyCase_ == 110
            && entityBody_ != com.google.cloud.clouddms.v1.UDTEntity.getDefaultInstance()) {
          entityBody_ =
              com.google.cloud.clouddms.v1.UDTEntity.newBuilder(
                      (com.google.cloud.clouddms.v1.UDTEntity) entityBody_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          entityBody_ = value;
        }
        onChanged();
      } else {
        if (entityBodyCase_ == 110) {
          udtBuilder_.mergeFrom(value);
        } else {
          udtBuilder_.setMessage(value);
        }
      }
      entityBodyCase_ = 110;
      return this;
    }
    /**
     *
     *
     * <pre>
     * UDT.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
     */
    public Builder clearUdt() {
      if (udtBuilder_ == null) {
        if (entityBodyCase_ == 110) {
          entityBodyCase_ = 0;
          entityBody_ = null;
          onChanged();
        }
      } else {
        if (entityBodyCase_ == 110) {
          entityBodyCase_ = 0;
          entityBody_ = null;
        }
        udtBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * UDT.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
     */
    public com.google.cloud.clouddms.v1.UDTEntity.Builder getUdtBuilder() {
      return getUdtFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * UDT.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.UDTEntityOrBuilder getUdtOrBuilder() {
      if ((entityBodyCase_ == 110) && (udtBuilder_ != null)) {
        return udtBuilder_.getMessageOrBuilder();
      } else {
        if (entityBodyCase_ == 110) {
          return (com.google.cloud.clouddms.v1.UDTEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.UDTEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * UDT.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.UDTEntity,
            com.google.cloud.clouddms.v1.UDTEntity.Builder,
            com.google.cloud.clouddms.v1.UDTEntityOrBuilder>
        getUdtFieldBuilder() {
      if (udtBuilder_ == null) {
        if (!(entityBodyCase_ == 110)) {
          entityBody_ = com.google.cloud.clouddms.v1.UDTEntity.getDefaultInstance();
        }
        udtBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.UDTEntity,
                com.google.cloud.clouddms.v1.UDTEntity.Builder,
                com.google.cloud.clouddms.v1.UDTEntityOrBuilder>(
                (com.google.cloud.clouddms.v1.UDTEntity) entityBody_,
                getParentForChildren(),
                isClean());
        entityBody_ = null;
      }
      entityBodyCase_ = 110;
      onChanged();
      return udtBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.MaterializedViewEntity,
            com.google.cloud.clouddms.v1.MaterializedViewEntity.Builder,
            com.google.cloud.clouddms.v1.MaterializedViewEntityOrBuilder>
        materializedViewBuilder_;
    /**
     *
     *
     * <pre>
     * Materialized view.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
     *
     * @return Whether the materializedView field is set.
     */
    @java.lang.Override
    public boolean hasMaterializedView() {
      return entityBodyCase_ == 111;
    }
    /**
     *
     *
     * <pre>
     * Materialized view.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
     *
     * @return The materializedView.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.MaterializedViewEntity getMaterializedView() {
      if (materializedViewBuilder_ == null) {
        if (entityBodyCase_ == 111) {
          return (com.google.cloud.clouddms.v1.MaterializedViewEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.MaterializedViewEntity.getDefaultInstance();
      } else {
        if (entityBodyCase_ == 111) {
          return materializedViewBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.MaterializedViewEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Materialized view.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
     */
    public Builder setMaterializedView(com.google.cloud.clouddms.v1.MaterializedViewEntity value) {
      if (materializedViewBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityBody_ = value;
        onChanged();
      } else {
        materializedViewBuilder_.setMessage(value);
      }
      entityBodyCase_ = 111;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Materialized view.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
     */
    public Builder setMaterializedView(
        com.google.cloud.clouddms.v1.MaterializedViewEntity.Builder builderForValue) {
      if (materializedViewBuilder_ == null) {
        entityBody_ = builderForValue.build();
        onChanged();
      } else {
        materializedViewBuilder_.setMessage(builderForValue.build());
      }
      entityBodyCase_ = 111;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Materialized view.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
     */
    public Builder mergeMaterializedView(
        com.google.cloud.clouddms.v1.MaterializedViewEntity value) {
      if (materializedViewBuilder_ == null) {
        if (entityBodyCase_ == 111
            && entityBody_
                != com.google.cloud.clouddms.v1.MaterializedViewEntity.getDefaultInstance()) {
          entityBody_ =
              com.google.cloud.clouddms.v1.MaterializedViewEntity.newBuilder(
                      (com.google.cloud.clouddms.v1.MaterializedViewEntity) entityBody_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          entityBody_ = value;
        }
        onChanged();
      } else {
        if (entityBodyCase_ == 111) {
          materializedViewBuilder_.mergeFrom(value);
        } else {
          materializedViewBuilder_.setMessage(value);
        }
      }
      entityBodyCase_ = 111;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Materialized view.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
     */
    public Builder clearMaterializedView() {
      if (materializedViewBuilder_ == null) {
        if (entityBodyCase_ == 111) {
          entityBodyCase_ = 0;
          entityBody_ = null;
          onChanged();
        }
      } else {
        if (entityBodyCase_ == 111) {
          entityBodyCase_ = 0;
          entityBody_ = null;
        }
        materializedViewBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Materialized view.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
     */
    public com.google.cloud.clouddms.v1.MaterializedViewEntity.Builder
        getMaterializedViewBuilder() {
      return getMaterializedViewFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Materialized view.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.MaterializedViewEntityOrBuilder
        getMaterializedViewOrBuilder() {
      if ((entityBodyCase_ == 111) && (materializedViewBuilder_ != null)) {
        return materializedViewBuilder_.getMessageOrBuilder();
      } else {
        if (entityBodyCase_ == 111) {
          return (com.google.cloud.clouddms.v1.MaterializedViewEntity) entityBody_;
        }
        return com.google.cloud.clouddms.v1.MaterializedViewEntity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Materialized view.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.MaterializedViewEntity,
            com.google.cloud.clouddms.v1.MaterializedViewEntity.Builder,
            com.google.cloud.clouddms.v1.MaterializedViewEntityOrBuilder>
        getMaterializedViewFieldBuilder() {
      if (materializedViewBuilder_ == null) {
        if (!(entityBodyCase_ == 111)) {
          entityBody_ = com.google.cloud.clouddms.v1.MaterializedViewEntity.getDefaultInstance();
        }
        materializedViewBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.MaterializedViewEntity,
                com.google.cloud.clouddms.v1.MaterializedViewEntity.Builder,
                com.google.cloud.clouddms.v1.MaterializedViewEntityOrBuilder>(
                (com.google.cloud.clouddms.v1.MaterializedViewEntity) entityBody_,
                getParentForChildren(),
                isClean());
        entityBody_ = null;
      }
      entityBodyCase_ = 111;
      onChanged();
      return materializedViewBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.DatabaseEntity)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.DatabaseEntity)
  private static final com.google.cloud.clouddms.v1.DatabaseEntity DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.DatabaseEntity();
  }

  public static com.google.cloud.clouddms.v1.DatabaseEntity getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DatabaseEntity> PARSER =
      new com.google.protobuf.AbstractParser<DatabaseEntity>() {
        @java.lang.Override
        public DatabaseEntity parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DatabaseEntity> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DatabaseEntity> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseEntity getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
