/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

public interface DatabaseEntityOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.DatabaseEntity)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The short name (e.g. table name) of the entity.
   * </pre>
   *
   * <code>string short_name = 1;</code>
   *
   * @return The shortName.
   */
  java.lang.String getShortName();
  /**
   *
   *
   * <pre>
   * The short name (e.g. table name) of the entity.
   * </pre>
   *
   * <code>string short_name = 1;</code>
   *
   * @return The bytes for shortName.
   */
  com.google.protobuf.ByteString getShortNameBytes();

  /**
   *
   *
   * <pre>
   * The full name of the parent entity (e.g. schema name).
   * </pre>
   *
   * <code>string parent_entity = 2;</code>
   *
   * @return The parentEntity.
   */
  java.lang.String getParentEntity();
  /**
   *
   *
   * <pre>
   * The full name of the parent entity (e.g. schema name).
   * </pre>
   *
   * <code>string parent_entity = 2;</code>
   *
   * @return The bytes for parentEntity.
   */
  com.google.protobuf.ByteString getParentEntityBytes();

  /**
   *
   *
   * <pre>
   * The type of tree the entity belongs to.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseEntity.TreeType tree = 3;</code>
   *
   * @return The enum numeric value on the wire for tree.
   */
  int getTreeValue();
  /**
   *
   *
   * <pre>
   * The type of tree the entity belongs to.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseEntity.TreeType tree = 3;</code>
   *
   * @return The tree.
   */
  com.google.cloud.clouddms.v1.DatabaseEntity.TreeType getTree();

  /**
   *
   *
   * <pre>
   * The type of the database entity (table, view, index, ...).
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
   *
   * @return The enum numeric value on the wire for entityType.
   */
  int getEntityTypeValue();
  /**
   *
   *
   * <pre>
   * The type of the database entity (table, view, index, ...).
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
   *
   * @return The entityType.
   */
  com.google.cloud.clouddms.v1.DatabaseEntityType getEntityType();

  /**
   *
   *
   * <pre>
   * Details about entity mappings.
   * For source tree entities, this holds the draft entities which were
   * generated by the mapping rules.
   * For draft tree entities, this holds the source entities which were
   * converted to form the draft entity.
   * Destination entities will have no mapping details.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
   */
  java.util.List<com.google.cloud.clouddms.v1.EntityMapping> getMappingsList();
  /**
   *
   *
   * <pre>
   * Details about entity mappings.
   * For source tree entities, this holds the draft entities which were
   * generated by the mapping rules.
   * For draft tree entities, this holds the source entities which were
   * converted to form the draft entity.
   * Destination entities will have no mapping details.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
   */
  com.google.cloud.clouddms.v1.EntityMapping getMappings(int index);
  /**
   *
   *
   * <pre>
   * Details about entity mappings.
   * For source tree entities, this holds the draft entities which were
   * generated by the mapping rules.
   * For draft tree entities, this holds the source entities which were
   * converted to form the draft entity.
   * Destination entities will have no mapping details.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
   */
  int getMappingsCount();
  /**
   *
   *
   * <pre>
   * Details about entity mappings.
   * For source tree entities, this holds the draft entities which were
   * generated by the mapping rules.
   * For draft tree entities, this holds the source entities which were
   * converted to form the draft entity.
   * Destination entities will have no mapping details.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
   */
  java.util.List<? extends com.google.cloud.clouddms.v1.EntityMappingOrBuilder>
      getMappingsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Details about entity mappings.
   * For source tree entities, this holds the draft entities which were
   * generated by the mapping rules.
   * For draft tree entities, this holds the source entities which were
   * converted to form the draft entity.
   * Destination entities will have no mapping details.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
   */
  com.google.cloud.clouddms.v1.EntityMappingOrBuilder getMappingsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Details about the entity DDL script. Multiple DDL scripts are provided for
   * child entities such as a table entity will have one DDL for the table with
   * additional DDLs for each index, constraint and such.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
   */
  java.util.List<com.google.cloud.clouddms.v1.EntityDdl> getEntityDdlList();
  /**
   *
   *
   * <pre>
   * Details about the entity DDL script. Multiple DDL scripts are provided for
   * child entities such as a table entity will have one DDL for the table with
   * additional DDLs for each index, constraint and such.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
   */
  com.google.cloud.clouddms.v1.EntityDdl getEntityDdl(int index);
  /**
   *
   *
   * <pre>
   * Details about the entity DDL script. Multiple DDL scripts are provided for
   * child entities such as a table entity will have one DDL for the table with
   * additional DDLs for each index, constraint and such.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
   */
  int getEntityDdlCount();
  /**
   *
   *
   * <pre>
   * Details about the entity DDL script. Multiple DDL scripts are provided for
   * child entities such as a table entity will have one DDL for the table with
   * additional DDLs for each index, constraint and such.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
   */
  java.util.List<? extends com.google.cloud.clouddms.v1.EntityDdlOrBuilder>
      getEntityDdlOrBuilderList();
  /**
   *
   *
   * <pre>
   * Details about the entity DDL script. Multiple DDL scripts are provided for
   * child entities such as a table entity will have one DDL for the table with
   * additional DDLs for each index, constraint and such.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
   */
  com.google.cloud.clouddms.v1.EntityDdlOrBuilder getEntityDdlOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Details about the various issues found for the entity.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
   */
  java.util.List<com.google.cloud.clouddms.v1.EntityIssue> getIssuesList();
  /**
   *
   *
   * <pre>
   * Details about the various issues found for the entity.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
   */
  com.google.cloud.clouddms.v1.EntityIssue getIssues(int index);
  /**
   *
   *
   * <pre>
   * Details about the various issues found for the entity.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
   */
  int getIssuesCount();
  /**
   *
   *
   * <pre>
   * Details about the various issues found for the entity.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
   */
  java.util.List<? extends com.google.cloud.clouddms.v1.EntityIssueOrBuilder>
      getIssuesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Details about the various issues found for the entity.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
   */
  com.google.cloud.clouddms.v1.EntityIssueOrBuilder getIssuesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Database.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
   *
   * @return Whether the database field is set.
   */
  boolean hasDatabase();
  /**
   *
   *
   * <pre>
   * Database.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
   *
   * @return The database.
   */
  com.google.cloud.clouddms.v1.DatabaseInstanceEntity getDatabase();
  /**
   *
   *
   * <pre>
   * Database.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
   */
  com.google.cloud.clouddms.v1.DatabaseInstanceEntityOrBuilder getDatabaseOrBuilder();

  /**
   *
   *
   * <pre>
   * Schema.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
   *
   * @return Whether the schema field is set.
   */
  boolean hasSchema();
  /**
   *
   *
   * <pre>
   * Schema.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
   *
   * @return The schema.
   */
  com.google.cloud.clouddms.v1.SchemaEntity getSchema();
  /**
   *
   *
   * <pre>
   * Schema.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
   */
  com.google.cloud.clouddms.v1.SchemaEntityOrBuilder getSchemaOrBuilder();

  /**
   *
   *
   * <pre>
   * Table.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
   *
   * @return Whether the table field is set.
   */
  boolean hasTable();
  /**
   *
   *
   * <pre>
   * Table.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
   *
   * @return The table.
   */
  com.google.cloud.clouddms.v1.TableEntity getTable();
  /**
   *
   *
   * <pre>
   * Table.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
   */
  com.google.cloud.clouddms.v1.TableEntityOrBuilder getTableOrBuilder();

  /**
   *
   *
   * <pre>
   * View.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
   *
   * @return Whether the view field is set.
   */
  boolean hasView();
  /**
   *
   *
   * <pre>
   * View.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
   *
   * @return The view.
   */
  com.google.cloud.clouddms.v1.ViewEntity getView();
  /**
   *
   *
   * <pre>
   * View.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
   */
  com.google.cloud.clouddms.v1.ViewEntityOrBuilder getViewOrBuilder();

  /**
   *
   *
   * <pre>
   * Sequence.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
   *
   * @return Whether the sequence field is set.
   */
  boolean hasSequence();
  /**
   *
   *
   * <pre>
   * Sequence.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
   *
   * @return The sequence.
   */
  com.google.cloud.clouddms.v1.SequenceEntity getSequence();
  /**
   *
   *
   * <pre>
   * Sequence.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
   */
  com.google.cloud.clouddms.v1.SequenceEntityOrBuilder getSequenceOrBuilder();

  /**
   *
   *
   * <pre>
   * Stored procedure.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
   *
   * @return Whether the storedProcedure field is set.
   */
  boolean hasStoredProcedure();
  /**
   *
   *
   * <pre>
   * Stored procedure.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
   *
   * @return The storedProcedure.
   */
  com.google.cloud.clouddms.v1.StoredProcedureEntity getStoredProcedure();
  /**
   *
   *
   * <pre>
   * Stored procedure.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
   */
  com.google.cloud.clouddms.v1.StoredProcedureEntityOrBuilder getStoredProcedureOrBuilder();

  /**
   *
   *
   * <pre>
   * Function.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
   *
   * @return Whether the databaseFunction field is set.
   */
  boolean hasDatabaseFunction();
  /**
   *
   *
   * <pre>
   * Function.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
   *
   * @return The databaseFunction.
   */
  com.google.cloud.clouddms.v1.FunctionEntity getDatabaseFunction();
  /**
   *
   *
   * <pre>
   * Function.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
   */
  com.google.cloud.clouddms.v1.FunctionEntityOrBuilder getDatabaseFunctionOrBuilder();

  /**
   *
   *
   * <pre>
   * Synonym.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
   *
   * @return Whether the synonym field is set.
   */
  boolean hasSynonym();
  /**
   *
   *
   * <pre>
   * Synonym.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
   *
   * @return The synonym.
   */
  com.google.cloud.clouddms.v1.SynonymEntity getSynonym();
  /**
   *
   *
   * <pre>
   * Synonym.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
   */
  com.google.cloud.clouddms.v1.SynonymEntityOrBuilder getSynonymOrBuilder();

  /**
   *
   *
   * <pre>
   * Package.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
   *
   * @return Whether the databasePackage field is set.
   */
  boolean hasDatabasePackage();
  /**
   *
   *
   * <pre>
   * Package.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
   *
   * @return The databasePackage.
   */
  com.google.cloud.clouddms.v1.PackageEntity getDatabasePackage();
  /**
   *
   *
   * <pre>
   * Package.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
   */
  com.google.cloud.clouddms.v1.PackageEntityOrBuilder getDatabasePackageOrBuilder();

  /**
   *
   *
   * <pre>
   * UDT.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
   *
   * @return Whether the udt field is set.
   */
  boolean hasUdt();
  /**
   *
   *
   * <pre>
   * UDT.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
   *
   * @return The udt.
   */
  com.google.cloud.clouddms.v1.UDTEntity getUdt();
  /**
   *
   *
   * <pre>
   * UDT.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
   */
  com.google.cloud.clouddms.v1.UDTEntityOrBuilder getUdtOrBuilder();

  /**
   *
   *
   * <pre>
   * Materialized view.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
   *
   * @return Whether the materializedView field is set.
   */
  boolean hasMaterializedView();
  /**
   *
   *
   * <pre>
   * Materialized view.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
   *
   * @return The materializedView.
   */
  com.google.cloud.clouddms.v1.MaterializedViewEntity getMaterializedView();
  /**
   *
   *
   * <pre>
   * Materialized view.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
   */
  com.google.cloud.clouddms.v1.MaterializedViewEntityOrBuilder getMaterializedViewOrBuilder();

  com.google.cloud.clouddms.v1.DatabaseEntity.EntityBodyCase getEntityBodyCase();
}
